/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opensearch.action.OriginalIndices;
import org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.opensearch.action.search.AbstractSearchAsyncAction;
import org.opensearch.action.search.ArraySearchPhaseResults;
import org.opensearch.action.search.CanMatchPreFilterSearchPhase;
import org.opensearch.action.search.QueryPhaseResultConsumer;
import org.opensearch.action.search.SearchActionListener;
import org.opensearch.action.search.SearchContextId;
import org.opensearch.action.search.SearchContextIdForNode;
import org.opensearch.action.search.SearchDfsQueryThenFetchAsyncAction;
import org.opensearch.action.search.SearchPhase;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchPhaseController;
import org.opensearch.action.search.SearchPhaseResults;
import org.opensearch.action.search.SearchQueryCategorizer;
import org.opensearch.action.search.SearchQueryThenFetchAsyncAction;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestContext;
import org.opensearch.action.search.SearchRequestOperationsCompositeListenerFactory;
import org.opensearch.action.search.SearchRequestOperationsListener;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchResponseMerger;
import org.opensearch.action.search.SearchShardIterator;
import org.opensearch.action.search.SearchTask;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.action.search.SearchType;
import org.opensearch.action.search.WrappingSearchAsyncActionPhase;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.TimeoutTaskCancellationUtility;
import org.opensearch.client.Client;
import org.opensearch.client.OriginSettingClient;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.GroupShardsIterator;
import org.opensearch.cluster.routing.OperationRouting;
import org.opensearch.cluster.routing.ShardIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AtomicArray;
import org.opensearch.common.util.concurrent.CountDown;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.SearchService;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.internal.AliasFilter;
import org.opensearch.search.internal.InternalSearchResponse;
import org.opensearch.search.pipeline.PipelinedRequest;
import org.opensearch.search.pipeline.SearchPipelineService;
import org.opensearch.search.profile.ProfileShardResult;
import org.opensearch.search.profile.SearchProfileShardResults;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.tasks.CancellableTask;
import org.opensearch.tasks.Task;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanBuilder;
import org.opensearch.telemetry.tracing.SpanScope;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.telemetry.tracing.listener.TraceableActionListener;
import org.opensearch.telemetry.tracing.listener.TraceableSearchRequestOperationsListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.RemoteClusterService;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportService;

public class TransportSearchAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    public static final Setting<Long> SHARD_COUNT_LIMIT_SETTING = Setting.longSetting("action.search.shard_count.limit", Long.MAX_VALUE, 1L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SEARCH_QUERY_METRICS_ENABLED_SETTING = Setting.boolSetting("search.query.metrics.enabled", false, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final String SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING_KEY = "search.cancel_after_time_interval";
    public static final Setting<TimeValue> SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING = Setting.timeSetting("search.cancel_after_time_interval", SearchService.NO_TIMEOUT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String SEARCH_PHASE_TOOK_ENABLED_KEY = "search.phase_took_enabled";
    public static final Setting<Boolean> SEARCH_PHASE_TOOK_ENABLED = Setting.boolSetting("search.phase_took_enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final NodeClient client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final RemoteClusterService remoteClusterService;
    private final SearchPhaseController searchPhaseController;
    private final SearchService searchService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final CircuitBreaker circuitBreaker;
    private final SearchPipelineService searchPipelineService;
    private final SearchRequestOperationsCompositeListenerFactory searchRequestOperationsCompositeListenerFactory;
    private final Tracer tracer;
    private volatile boolean searchQueryMetricsEnabled;
    private final MetricsRegistry metricsRegistry;
    private SearchQueryCategorizer searchQueryCategorizer;

    @Inject
    public TransportSearchAction(NodeClient client, ThreadPool threadPool, CircuitBreakerService circuitBreakerService, TransportService transportService, SearchService searchService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedWriteableRegistry namedWriteableRegistry, SearchPipelineService searchPipelineService, MetricsRegistry metricsRegistry, SearchRequestOperationsCompositeListenerFactory searchRequestOperationsCompositeListenerFactory, Tracer tracer) {
        super("indices:data/read/search", transportService, actionFilters, SearchRequest::new);
        this.client = client;
        this.threadPool = threadPool;
        this.circuitBreaker = circuitBreakerService.getBreaker("request");
        this.searchPhaseController = searchPhaseController;
        this.searchTransportService = searchTransportService;
        this.remoteClusterService = searchTransportService.getRemoteClusterService();
        SearchTransportService.registerRequestHandler(transportService, searchService);
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.searchPipelineService = searchPipelineService;
        this.metricsRegistry = metricsRegistry;
        this.searchQueryMetricsEnabled = clusterService.getClusterSettings().get(SEARCH_QUERY_METRICS_ENABLED_SETTING);
        this.searchRequestOperationsCompositeListenerFactory = searchRequestOperationsCompositeListenerFactory;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SEARCH_QUERY_METRICS_ENABLED_SETTING, this::setSearchQueryMetricsEnabled);
        this.tracer = tracer;
    }

    private void setSearchQueryMetricsEnabled(boolean searchQueryMetricsEnabled) {
        this.searchQueryMetricsEnabled = searchQueryMetricsEnabled;
        if (this.searchQueryMetricsEnabled && this.searchQueryCategorizer == null) {
            this.searchQueryCategorizer = new SearchQueryCategorizer(this.metricsRegistry);
        }
    }

    private Map<String, AliasFilter> buildPerIndexAliasFilter(SearchRequest request, ClusterState clusterState, Index[] concreteIndices, Map<String, AliasFilter> remoteAliasMap) {
        HashMap<String, AliasFilter> aliasFilterMap = new HashMap<String, AliasFilter>();
        Set<String> indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(clusterState, request.indices());
        for (Index index : concreteIndices) {
            clusterState.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, index.getName());
            AliasFilter aliasFilter = this.searchService.buildAliasFilter(clusterState, index.getName(), indicesAndAliases);
            assert (aliasFilter != null);
            aliasFilterMap.put(index.getUUID(), aliasFilter);
        }
        aliasFilterMap.putAll(remoteAliasMap);
        return aliasFilterMap;
    }

    private Map<String, Float> resolveIndexBoosts(SearchRequest searchRequest, ClusterState clusterState) {
        if (searchRequest.source() == null) {
            return Collections.emptyMap();
        }
        SearchSourceBuilder source = searchRequest.source();
        if (source.indexBoosts() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Float> concreteIndexBoosts = new HashMap<String, Float>();
        for (SearchSourceBuilder.IndexBoost ib : source.indexBoosts()) {
            Index[] concreteIndices;
            for (Index concreteIndex : concreteIndices = this.indexNameExpressionResolver.concreteIndices(clusterState, searchRequest.indicesOptions(), ib.getIndex())) {
                concreteIndexBoosts.putIfAbsent(concreteIndex.getUUID(), Float.valueOf(ib.getBoost()));
            }
        }
        return Collections.unmodifiableMap(concreteIndexBoosts);
    }

    @Override
    protected void doExecute(Task task, SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        if (task instanceof CancellableTask) {
            listener = TimeoutTaskCancellationUtility.wrapWithCancellationListener(this.client, (CancellableTask)task, this.clusterService.getClusterSettings(), listener);
        }
        this.executeRequest(task, searchRequest, this::searchAsyncAction, listener);
    }

    public void executeRequest(Task task, SearchRequest searchRequest, final String actionName, final boolean includeSearchContext, final SinglePhaseSearchAction phaseSearchAction, ActionListener<SearchResponse> listener) {
        this.executeRequest(task, searchRequest, new SearchAsyncActionProvider(){

            @Override
            public AbstractSearchAsyncAction<? extends SearchPhaseResult> asyncSearchAction(final SearchTask task, SearchRequest searchRequest, Executor executor, GroupShardsIterator<SearchShardIterator> shardsIts, SearchTimeProvider timeProvider, BiFunction<String, String, Transport.Connection> connectionLookup, ClusterState clusterState, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, ActionListener<SearchResponse> listener, boolean preFilter, ThreadPool threadPool, SearchResponse.Clusters clusters, SearchRequestContext searchRequestContext) {
                return new AbstractSearchAsyncAction<SearchPhaseResult>(actionName, TransportSearchAction.this.logger, TransportSearchAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, indexRoutings, executor, searchRequest, listener, shardsIts, timeProvider, clusterState, task, new ArraySearchPhaseResults(shardsIts.size()), searchRequest.getMaxConcurrentShardRequests(), clusters, searchRequestContext, TransportSearchAction.this.tracer){

                    @Override
                    protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<SearchPhaseResult> listener) {
                        Transport.Connection connection = this.getConnection(shard.getClusterAlias(), shard.getNodeId());
                        phaseSearchAction.executeOnShardTarget(task, shard, connection, listener);
                    }

                    @Override
                    protected SearchPhase getNextPhase(final SearchPhaseResults<SearchPhaseResult> results, SearchPhaseContext context) {
                        return new SearchPhase(this.getName()){

                            public void run() {
                                AtomicArray<SearchPhaseResult> atomicArray = results.getAtomicArray();
                                this.sendSearchResponse(InternalSearchResponse.empty(), atomicArray);
                            }
                        };
                    }

                    @Override
                    boolean buildPointInTimeFromSearchResults() {
                        return includeSearchContext;
                    }
                };
            }
        }, listener);
    }

    private void executeRequest(Task task, SearchRequest originalSearchRequest, SearchAsyncActionProvider searchAsyncActionProvider, ActionListener<SearchResponse> originalListener) {
        long relativeStartNanos = System.nanoTime();
        SearchTimeProvider timeProvider = new SearchTimeProvider(originalSearchRequest.getOrCreateAbsoluteStartMillis(), relativeStartNanos, System::nanoTime);
        if (originalSearchRequest.isPhaseTook() == null) {
            originalSearchRequest.setPhaseTook(this.clusterService.getClusterSettings().get(SEARCH_PHASE_TOOK_ENABLED));
        }
        Span requestSpan = this.tracer.startSpan(SpanBuilder.from(task, this.actionName));
        SpanScope spanScope = this.tracer.withSpanInScope(requestSpan);
        try {
            ActionListener<SearchResponse> listener;
            PipelinedRequest searchRequest;
            ActionListener<SearchResponse> updatedListener = TraceableActionListener.create(originalListener, requestSpan, this.tracer);
            SearchRequestOperationsListener.CompositeListener requestOperationsListeners = this.searchRequestOperationsCompositeListenerFactory.buildCompositeListener(originalSearchRequest, this.logger, TraceableSearchRequestOperationsListener.create(this.tracer, requestSpan));
            SearchRequestContext searchRequestContext = new SearchRequestContext(requestOperationsListeners, originalSearchRequest);
            searchRequestContext.getSearchRequestOperationsListener().onRequestStart(searchRequestContext);
            try {
                searchRequest = this.searchPipelineService.resolvePipeline(originalSearchRequest, this.indexNameExpressionResolver);
                listener = searchRequest.transformResponseListener(updatedListener);
            }
            catch (Exception e) {
                updatedListener.onFailure(e);
                if (spanScope != null) {
                    spanScope.close();
                }
                return;
            }
            ActionListener requestTransformListener = ActionListener.wrap(sr -> {
                if (this.searchQueryMetricsEnabled) {
                    try {
                        this.searchQueryCategorizer.categorize(sr.source());
                    }
                    catch (Exception e) {
                        this.logger.error("Error while trying to categorize the query.", (Throwable)e);
                    }
                }
                ActionListener<SearchSourceBuilder> rewriteListener = this.buildRewriteListener((SearchRequest)sr, task, timeProvider, searchAsyncActionProvider, listener, searchRequestContext);
                if (sr.source() == null) {
                    rewriteListener.onResponse((Object)sr.source());
                } else {
                    Rewriteable.rewriteAndFetch(sr.source(), this.searchService.getRewriteContext(timeProvider::getAbsoluteStartMillis), rewriteListener);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            searchRequest.transformRequest((ActionListener<SearchRequest>)requestTransformListener);
        }
        finally {
            if (spanScope != null) {
                try {
                    spanScope.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private ActionListener<SearchSourceBuilder> buildRewriteListener(SearchRequest searchRequest, Task task, SearchTimeProvider timeProvider, SearchAsyncActionProvider searchAsyncActionProvider, ActionListener<SearchResponse> listener, SearchRequestContext searchRequestContext) {
        return ActionListener.wrap(source -> {
            Map<String, OriginalIndices> remoteClusterIndices;
            SearchContextId searchContext;
            if (source != searchRequest.source()) {
                searchRequest.source((SearchSourceBuilder)source);
            }
            ClusterState clusterState = this.clusterService.state();
            if (searchRequest.pointInTimeBuilder() != null) {
                searchContext = SearchContextId.decode(this.namedWriteableRegistry, searchRequest.pointInTimeBuilder().getId());
                remoteClusterIndices = TransportSearchAction.getIndicesFromSearchContexts(searchContext, searchRequest.indicesOptions());
            } else {
                searchContext = null;
                remoteClusterIndices = this.remoteClusterService.groupIndices(searchRequest.indicesOptions(), searchRequest.indices(), idx -> this.indexNameExpressionResolver.hasIndexAbstraction((String)idx, clusterState));
            }
            OriginalIndices localIndices = remoteClusterIndices.remove("");
            if (remoteClusterIndices.isEmpty()) {
                this.executeLocalSearch(task, timeProvider, searchRequest, localIndices, clusterState, listener, searchContext, searchAsyncActionProvider, searchRequestContext);
            } else if (TransportSearchAction.shouldMinimizeRoundtrips(searchRequest)) {
                TransportSearchAction.ccsRemoteReduce(searchRequest, localIndices, remoteClusterIndices, timeProvider, this.searchService.aggReduceContextBuilder(searchRequest.source()), this.remoteClusterService, this.threadPool, listener, (r, l) -> this.executeLocalSearch(task, timeProvider, (SearchRequest)r, localIndices, clusterState, (ActionListener<SearchResponse>)l, searchContext, searchAsyncActionProvider, searchRequestContext), searchRequestContext);
            } else {
                AtomicInteger skippedClusters = new AtomicInteger(0);
                TransportSearchAction.collectSearchShards(searchRequest.indicesOptions(), searchRequest.preference(), searchRequest.routing(), skippedClusters, remoteClusterIndices, this.remoteClusterService, this.threadPool, (ActionListener<Map<String, ClusterSearchShardsResponse>>)ActionListener.wrap(searchShardsResponses -> {
                    List<SearchShardIterator> remoteShardIterators;
                    Map<String, AliasFilter> remoteAliasFilters;
                    BiFunction<String, String, DiscoveryNode> clusterNodeLookup = TransportSearchAction.getRemoteClusterNodeLookup(searchShardsResponses);
                    if (searchContext != null) {
                        remoteAliasFilters = searchContext.aliasFilter();
                        remoteShardIterators = TransportSearchAction.getRemoteShardsIteratorFromPointInTime(searchShardsResponses, searchContext, searchRequest.pointInTimeBuilder().getKeepAlive(), remoteClusterIndices);
                    } else {
                        remoteAliasFilters = TransportSearchAction.getRemoteAliasFilters(searchShardsResponses);
                        remoteShardIterators = TransportSearchAction.getRemoteShardsIterator(searchShardsResponses, remoteClusterIndices, remoteAliasFilters);
                    }
                    int localClusters = localIndices == null ? 0 : 1;
                    int totalClusters = remoteClusterIndices.size() + localClusters;
                    int successfulClusters = searchShardsResponses.size() + localClusters;
                    this.executeSearch((SearchTask)task, timeProvider, searchRequest, localIndices, remoteShardIterators, clusterNodeLookup, clusterState, remoteAliasFilters, listener, new SearchResponse.Clusters(totalClusters, successfulClusters, skippedClusters.get()), searchContext, searchAsyncActionProvider, searchRequestContext);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    static boolean shouldMinimizeRoundtrips(SearchRequest searchRequest) {
        if (!searchRequest.isCcsMinimizeRoundtrips()) {
            return false;
        }
        if (searchRequest.scroll() != null) {
            return false;
        }
        if (searchRequest.pointInTimeBuilder() != null) {
            return false;
        }
        if (searchRequest.searchType() == SearchType.DFS_QUERY_THEN_FETCH) {
            return false;
        }
        SearchSourceBuilder source = searchRequest.source();
        return source == null || source.collapse() == null || source.collapse().getInnerHits() == null || source.collapse().getInnerHits().isEmpty();
    }

    static void ccsRemoteReduce(SearchRequest searchRequest, OriginalIndices localIndices, Map<String, OriginalIndices> remoteIndices, final SearchTimeProvider timeProvider, InternalAggregation.ReduceContextBuilder aggReduceContextBuilder, RemoteClusterService remoteClusterService, ThreadPool threadPool, final ActionListener<SearchResponse> listener, BiConsumer<SearchRequest, ActionListener<SearchResponse>> localSearchConsumer, final SearchRequestContext searchRequestContext) {
        if (localIndices == null && remoteIndices.size() == 1) {
            Map.Entry<String, OriginalIndices> entry = remoteIndices.entrySet().iterator().next();
            final String clusterAlias = entry.getKey();
            final boolean skipUnavailable = remoteClusterService.isSkipUnavailable(clusterAlias);
            OriginalIndices indices = entry.getValue();
            SearchRequest ccsSearchRequest = SearchRequest.subSearchRequest(searchRequest, indices.indices(), clusterAlias, timeProvider.getAbsoluteStartMillis(), true);
            Client remoteClusterClient = remoteClusterService.getRemoteClusterClient(threadPool, clusterAlias);
            remoteClusterClient.search(ccsSearchRequest, new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    Map<String, ProfileShardResult> profileResults = searchResponse.getProfileResults();
                    SearchProfileShardResults profile = profileResults == null || profileResults.isEmpty() ? null : new SearchProfileShardResults(profileResults);
                    InternalSearchResponse internalSearchResponse = new InternalSearchResponse(searchResponse.getHits(), (InternalAggregations)searchResponse.getAggregations(), searchResponse.getSuggest(), profile, searchResponse.isTimedOut(), searchResponse.isTerminatedEarly(), searchResponse.getNumReducePhases());
                    listener.onResponse((Object)new SearchResponse(internalSearchResponse, searchResponse.getScrollId(), searchResponse.getTotalShards(), searchResponse.getSuccessfulShards(), searchResponse.getSkippedShards(), timeProvider.buildTookInMillis(), searchRequestContext.getPhaseTook(), searchResponse.getShardFailures(), new SearchResponse.Clusters(1, 1, 0), searchResponse.pointInTimeId()));
                }

                public void onFailure(Exception e) {
                    if (skipUnavailable) {
                        listener.onResponse((Object)SearchResponse.empty(timeProvider::buildTookInMillis, new SearchResponse.Clusters(1, 0, 1)));
                    } else {
                        listener.onFailure((Exception)((Object)TransportSearchAction.wrapRemoteClusterFailure(clusterAlias, e)));
                    }
                }
            });
        } else {
            SearchResponseMerger searchResponseMerger = TransportSearchAction.createSearchResponseMerger(searchRequest.source(), timeProvider, aggReduceContextBuilder);
            AtomicInteger skippedClusters = new AtomicInteger(0);
            AtomicReference<Exception> exceptions = new AtomicReference<Exception>();
            int totalClusters = remoteIndices.size() + (localIndices == null ? 0 : 1);
            CountDown countDown = new CountDown(totalClusters);
            for (Map.Entry<String, OriginalIndices> entry : remoteIndices.entrySet()) {
                String clusterAlias = entry.getKey();
                boolean skipUnavailable = remoteClusterService.isSkipUnavailable(clusterAlias);
                OriginalIndices indices = entry.getValue();
                SearchRequest ccsSearchRequest = SearchRequest.subSearchRequest(searchRequest, indices.indices(), clusterAlias, timeProvider.getAbsoluteStartMillis(), false);
                ActionListener<SearchResponse> ccsListener = TransportSearchAction.createCCSListener(clusterAlias, skipUnavailable, countDown, skippedClusters, exceptions, searchResponseMerger, totalClusters, listener, searchRequestContext);
                Client remoteClusterClient = remoteClusterService.getRemoteClusterClient(threadPool, clusterAlias);
                remoteClusterClient.search(ccsSearchRequest, ccsListener);
            }
            if (localIndices != null) {
                ActionListener<SearchResponse> ccsListener = TransportSearchAction.createCCSListener("", false, countDown, skippedClusters, exceptions, searchResponseMerger, totalClusters, listener, searchRequestContext);
                SearchRequest ccsLocalSearchRequest = SearchRequest.subSearchRequest(searchRequest, localIndices.indices(), "", timeProvider.getAbsoluteStartMillis(), false);
                localSearchConsumer.accept(ccsLocalSearchRequest, ccsListener);
            }
        }
    }

    static SearchResponseMerger createSearchResponseMerger(SearchSourceBuilder source, SearchTimeProvider timeProvider, InternalAggregation.ReduceContextBuilder aggReduceContextBuilder) {
        int trackTotalHitsUpTo;
        int size;
        int from;
        if (source == null) {
            from = 0;
            size = 10;
            trackTotalHitsUpTo = 10000;
        } else {
            from = source.from() == -1 ? 0 : source.from();
            size = source.size() == -1 ? 10 : source.size();
            trackTotalHitsUpTo = source.trackTotalHitsUpTo() == null ? 10000 : source.trackTotalHitsUpTo();
            source.from(0);
            source.size(from + size);
        }
        return new SearchResponseMerger(from, size, trackTotalHitsUpTo, timeProvider, aggReduceContextBuilder);
    }

    static void collectSearchShards(IndicesOptions indicesOptions, String preference, String routing, AtomicInteger skippedClusters, Map<String, OriginalIndices> remoteIndicesByCluster, RemoteClusterService remoteClusterService, ThreadPool threadPool, ActionListener<Map<String, ClusterSearchShardsResponse>> listener) {
        CountDown responsesCountDown = new CountDown(remoteIndicesByCluster.size());
        final ConcurrentHashMap searchShardsResponses = new ConcurrentHashMap();
        AtomicReference exceptions = new AtomicReference();
        for (Map.Entry<String, OriginalIndices> entry : remoteIndicesByCluster.entrySet()) {
            final String clusterAlias = entry.getKey();
            boolean skipUnavailable = remoteClusterService.isSkipUnavailable(clusterAlias);
            Client clusterClient = remoteClusterService.getRemoteClusterClient(threadPool, clusterAlias);
            String[] indices = entry.getValue().indices();
            ClusterSearchShardsRequest searchShardsRequest = ((ClusterSearchShardsRequest)new ClusterSearchShardsRequest(indices).indicesOptions(indicesOptions).local(true)).preference(preference).routing(routing);
            clusterClient.admin().cluster().searchShards(searchShardsRequest, (ActionListener<ClusterSearchShardsResponse>)new CCSActionListener<ClusterSearchShardsResponse, Map<String, ClusterSearchShardsResponse>>(clusterAlias, skipUnavailable, responsesCountDown, skippedClusters, exceptions, listener){

                @Override
                void innerOnResponse(ClusterSearchShardsResponse clusterSearchShardsResponse) {
                    searchShardsResponses.put(clusterAlias, clusterSearchShardsResponse);
                }

                @Override
                Map<String, ClusterSearchShardsResponse> createFinalResponse() {
                    return searchShardsResponses;
                }
            });
        }
    }

    private static ActionListener<SearchResponse> createCCSListener(String clusterAlias, boolean skipUnavailable, CountDown countDown, final AtomicInteger skippedClusters, AtomicReference<Exception> exceptions, final SearchResponseMerger searchResponseMerger, final int totalClusters, ActionListener<SearchResponse> originalListener, final SearchRequestContext searchRequestContext) {
        return new CCSActionListener<SearchResponse, SearchResponse>(clusterAlias, skipUnavailable, countDown, skippedClusters, exceptions, originalListener){

            @Override
            void innerOnResponse(SearchResponse searchResponse) {
                searchResponseMerger.add(searchResponse);
            }

            @Override
            SearchResponse createFinalResponse() {
                SearchResponse.Clusters clusters = new SearchResponse.Clusters(totalClusters, searchResponseMerger.numResponses(), skippedClusters.get());
                return searchResponseMerger.getMergedResponse(clusters, searchRequestContext);
            }
        };
    }

    private void executeLocalSearch(Task task, SearchTimeProvider timeProvider, SearchRequest searchRequest, OriginalIndices localIndices, ClusterState clusterState, ActionListener<SearchResponse> listener, SearchContextId searchContext, SearchAsyncActionProvider searchAsyncActionProvider, SearchRequestContext searchRequestContext) {
        this.executeSearch((SearchTask)task, timeProvider, searchRequest, localIndices, Collections.emptyList(), (clusterName, nodeId) -> null, clusterState, Collections.emptyMap(), listener, SearchResponse.Clusters.EMPTY, searchContext, searchAsyncActionProvider, searchRequestContext);
    }

    static BiFunction<String, String, DiscoveryNode> getRemoteClusterNodeLookup(Map<String, ClusterSearchShardsResponse> searchShardsResp) {
        HashMap<String, Map> clusterToNode = new HashMap<String, Map>();
        for (Map.Entry<String, ClusterSearchShardsResponse> entry : searchShardsResp.entrySet()) {
            String clusterAlias2 = entry.getKey();
            for (DiscoveryNode remoteNode : entry.getValue().getNodes()) {
                clusterToNode.computeIfAbsent(clusterAlias2, k -> new HashMap()).put(remoteNode.getId(), remoteNode);
            }
        }
        return (clusterAlias, nodeId) -> {
            Map clusterNodes = (Map)clusterToNode.get(clusterAlias);
            if (clusterNodes == null) {
                throw new IllegalArgumentException("unknown remote cluster: " + clusterAlias);
            }
            return (DiscoveryNode)clusterNodes.get(nodeId);
        };
    }

    static Map<String, AliasFilter> getRemoteAliasFilters(Map<String, ClusterSearchShardsResponse> searchShardsResp) {
        HashMap<String, AliasFilter> aliasFilterMap = new HashMap<String, AliasFilter>();
        for (Map.Entry<String, ClusterSearchShardsResponse> entry : searchShardsResp.entrySet()) {
            ClusterSearchShardsResponse searchShardsResponse = entry.getValue();
            Map<String, AliasFilter> indicesAndFilters = searchShardsResponse.getIndicesAndFilters();
            for (ClusterSearchShardsGroup clusterSearchShardsGroup : searchShardsResponse.getGroups()) {
                AliasFilter aliasFilter;
                ShardId shardId = clusterSearchShardsGroup.getShardId();
                if (indicesAndFilters == null) {
                    aliasFilter = AliasFilter.EMPTY;
                } else {
                    aliasFilter = indicesAndFilters.get(shardId.getIndexName());
                    assert (aliasFilter != null) : "alias filter must not be null for index: " + shardId.getIndex();
                }
                aliasFilterMap.put(shardId.getIndex().getUUID(), aliasFilter);
            }
        }
        return aliasFilterMap;
    }

    static List<SearchShardIterator> getRemoteShardsIterator(Map<String, ClusterSearchShardsResponse> searchShardsResponses, Map<String, OriginalIndices> remoteIndicesByCluster, Map<String, AliasFilter> aliasFilterMap) {
        ArrayList<SearchShardIterator> remoteShardIterators = new ArrayList<SearchShardIterator>();
        for (Map.Entry<String, ClusterSearchShardsResponse> entry : searchShardsResponses.entrySet()) {
            for (ClusterSearchShardsGroup clusterSearchShardsGroup : entry.getValue().getGroups()) {
                String[] stringArray;
                ShardId shardId = clusterSearchShardsGroup.getShardId();
                AliasFilter aliasFilter = aliasFilterMap.get(shardId.getIndex().getUUID());
                String[] aliases = aliasFilter.getAliases();
                String clusterAlias = entry.getKey();
                if (aliases.length == 0) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = shardId.getIndexName();
                } else {
                    stringArray = aliases;
                }
                String[] finalIndices = stringArray;
                OriginalIndices originalIndices = remoteIndicesByCluster.get(clusterAlias);
                assert (originalIndices != null) : "original indices are null for clusterAlias: " + clusterAlias;
                SearchShardIterator shardIterator = new SearchShardIterator(clusterAlias, shardId, Arrays.asList(clusterSearchShardsGroup.getShards()), new OriginalIndices(finalIndices, originalIndices.indicesOptions()));
                remoteShardIterators.add(shardIterator);
            }
        }
        return remoteShardIterators;
    }

    static List<SearchShardIterator> getRemoteShardsIteratorFromPointInTime(Map<String, ClusterSearchShardsResponse> searchShardsResponses, SearchContextId searchContextId, TimeValue searchContextKeepAlive, Map<String, OriginalIndices> remoteClusterIndices) {
        ArrayList<SearchShardIterator> remoteShardIterators = new ArrayList<SearchShardIterator>();
        for (Map.Entry<String, ClusterSearchShardsResponse> entry : searchShardsResponses.entrySet()) {
            for (ClusterSearchShardsGroup group : entry.getValue().getGroups()) {
                ShardId shardId = group.getShardId();
                String clusterAlias = entry.getKey();
                SearchContextIdForNode perNode = searchContextId.shards().get(shardId);
                assert (clusterAlias.equals(perNode.getClusterAlias())) : clusterAlias + " != " + perNode.getClusterAlias();
                List<String> targetNodes = Collections.singletonList(perNode.getNode());
                SearchShardIterator shardIterator = new SearchShardIterator(clusterAlias, shardId, targetNodes, remoteClusterIndices.get(clusterAlias), perNode.getSearchContextId(), searchContextKeepAlive);
                remoteShardIterators.add(shardIterator);
            }
        }
        return remoteShardIterators;
    }

    private Index[] resolveLocalIndices(OriginalIndices localIndices, ClusterState clusterState, SearchTimeProvider timeProvider) {
        if (localIndices == null) {
            return Index.EMPTY_ARRAY;
        }
        return this.indexNameExpressionResolver.concreteIndices(clusterState, localIndices, timeProvider.getAbsoluteStartMillis());
    }

    private void executeSearch(SearchTask task, SearchTimeProvider timeProvider, SearchRequest searchRequest, OriginalIndices localIndices, List<SearchShardIterator> remoteShardIterators, BiFunction<String, String, DiscoveryNode> remoteConnections, ClusterState clusterState, Map<String, AliasFilter> remoteAliasMap, ActionListener<SearchResponse> listener, SearchResponse.Clusters clusters, @Nullable SearchContextId searchContext, SearchAsyncActionProvider searchAsyncActionProvider, SearchRequestContext searchRequestContext) {
        List<SearchShardIterator> localShardIterators;
        String[] concreteLocalIndices;
        Map<String, Set<String>> indexRoutings;
        Map<String, AliasFilter> aliasFilter;
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        if (searchContext != null) {
            assert (searchRequest.pointInTimeBuilder() != null);
            aliasFilter = searchContext.aliasFilter();
            indexRoutings = Collections.emptyMap();
            concreteLocalIndices = localIndices == null ? new String[]{} : localIndices.indices();
            localShardIterators = TransportSearchAction.getLocalLocalShardsIteratorFromPointInTime(clusterState, localIndices, searchRequest.getLocalClusterAlias(), searchContext, searchRequest.pointInTimeBuilder().getKeepAlive());
        } else {
            Index[] indices = this.resolveLocalIndices(localIndices, clusterState, timeProvider);
            Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, searchRequest.routing(), searchRequest.indices());
            routingMap = routingMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(routingMap);
            concreteLocalIndices = new String[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                concreteLocalIndices[i] = indices[i].getName();
            }
            Map<String, Long> nodeSearchCounts = this.searchTransportService.getPendingSearchRequests();
            GroupShardsIterator<ShardIterator> localShardRoutings = this.clusterService.operationRouting().searchShards(clusterState, concreteLocalIndices, routingMap, searchRequest.preference(), this.searchService.getResponseCollectorService(), nodeSearchCounts);
            localShardIterators = StreamSupport.stream(localShardRoutings.spliterator(), false).map(it -> new SearchShardIterator(searchRequest.getLocalClusterAlias(), it.shardId(), it.getShardRoutings(), localIndices)).collect(Collectors.toList());
            aliasFilter = this.buildPerIndexAliasFilter(searchRequest, clusterState, indices, remoteAliasMap);
            indexRoutings = routingMap;
        }
        GroupShardsIterator<SearchShardIterator> shardIterators = TransportSearchAction.mergeShardsIterators(localShardIterators, remoteShardIterators);
        TransportSearchAction.failIfOverShardCountLimit(this.clusterService, shardIterators.size());
        Map<String, Float> concreteIndexBoosts = this.resolveIndexBoosts(searchRequest, clusterState);
        if (shardIterators.size() == 1) {
            searchRequest.searchType(SearchType.QUERY_THEN_FETCH);
        }
        if (searchRequest.allowPartialSearchResults() == null) {
            searchRequest.allowPartialSearchResults(this.searchService.defaultAllowPartialSearchResults());
        }
        if (searchRequest.isSuggestOnly()) {
            searchRequest.requestCache(false);
            switch (searchRequest.searchType()) {
                case DFS_QUERY_THEN_FETCH: {
                    searchRequest.searchType(SearchType.QUERY_THEN_FETCH);
                }
            }
        }
        DiscoveryNodes nodes = clusterState.nodes();
        BiFunction<String, String, Transport.Connection> connectionLookup = TransportSearchAction.buildConnectionLookup(searchRequest.getLocalClusterAlias(), nodes::get, remoteConnections, this.searchTransportService::getConnection);
        Executor asyncSearchExecutor = this.asyncSearchExecutor(concreteLocalIndices, clusterState);
        boolean preFilterSearchShards = TransportSearchAction.shouldPreFilterSearchShards(clusterState, searchRequest, concreteLocalIndices, localShardIterators.size() + remoteShardIterators.size());
        searchAsyncActionProvider.asyncSearchAction(task, searchRequest, asyncSearchExecutor, shardIterators, timeProvider, connectionLookup, clusterState, Collections.unmodifiableMap(aliasFilter), concreteIndexBoosts, indexRoutings, listener, preFilterSearchShards, this.threadPool, clusters, searchRequestContext).start();
    }

    Executor asyncSearchExecutor(String[] indices, ClusterState clusterState) {
        boolean onlySystemIndices = Arrays.stream(indices).allMatch(index -> {
            IndexMetadata indexMetadata = clusterState.metadata().index((String)index);
            return indexMetadata != null && indexMetadata.isSystem();
        });
        return onlySystemIndices ? this.threadPool.executor("system_read") : this.threadPool.executor("search");
    }

    static BiFunction<String, String, Transport.Connection> buildConnectionLookup(String requestClusterAlias, Function<String, DiscoveryNode> localNodes, BiFunction<String, String, DiscoveryNode> remoteNodes, BiFunction<String, DiscoveryNode, Transport.Connection> nodeToConnection) {
        return (clusterAlias, nodeId) -> {
            boolean remoteCluster;
            DiscoveryNode discoveryNode;
            if (clusterAlias == null || requestClusterAlias != null) {
                assert (requestClusterAlias == null || requestClusterAlias.equals(clusterAlias));
                discoveryNode = (DiscoveryNode)localNodes.apply((String)nodeId);
                remoteCluster = false;
            } else {
                discoveryNode = (DiscoveryNode)remoteNodes.apply((String)clusterAlias, (String)nodeId);
                remoteCluster = true;
            }
            if (discoveryNode == null) {
                throw new IllegalStateException("no node found for id: " + nodeId);
            }
            return (Transport.Connection)nodeToConnection.apply(remoteCluster ? clusterAlias : null, discoveryNode);
        };
    }

    static boolean shouldPreFilterSearchShards(ClusterState clusterState, SearchRequest searchRequest, String[] indices, int numShards) {
        SearchSourceBuilder source = searchRequest.source();
        Integer preFilterShardSize = searchRequest.getPreFilterShardSize();
        if (preFilterShardSize == null && (TransportSearchAction.hasReadOnlyIndices(indices, clusterState) || FieldSortBuilder.hasPrimaryFieldSort(source))) {
            preFilterShardSize = 1;
        } else if (preFilterShardSize == null) {
            preFilterShardSize = 128;
        }
        return searchRequest.searchType() == SearchType.QUERY_THEN_FETCH && (SearchService.canRewriteToMatchNone(source) || FieldSortBuilder.hasPrimaryFieldSort(source)) && preFilterShardSize < numShards;
    }

    private static boolean hasReadOnlyIndices(String[] indices, ClusterState clusterState) {
        for (String index : indices) {
            ClusterBlockException writeBlock = clusterState.blocks().indexBlockedException(ClusterBlockLevel.WRITE, index);
            if (writeBlock == null) continue;
            return true;
        }
        return false;
    }

    static GroupShardsIterator<SearchShardIterator> mergeShardsIterators(List<SearchShardIterator> localShardIterators, List<SearchShardIterator> remoteShardIterators) {
        ArrayList<SearchShardIterator> shards = new ArrayList<SearchShardIterator>(remoteShardIterators);
        shards.addAll(localShardIterators);
        return GroupShardsIterator.sortAndCreate(shards);
    }

    private AbstractSearchAsyncAction<? extends SearchPhaseResult> searchAsyncAction(SearchTask task, SearchRequest searchRequest, Executor executor, GroupShardsIterator<SearchShardIterator> shardIterators, SearchTimeProvider timeProvider, BiFunction<String, String, Transport.Connection> connectionLookup, ClusterState clusterState, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, ActionListener<SearchResponse> listener, boolean preFilter, ThreadPool threadPool, SearchResponse.Clusters clusters, SearchRequestContext searchRequestContext) {
        AbstractSearchAsyncAction searchAsyncAction;
        if (preFilter) {
            return new CanMatchPreFilterSearchPhase(this.logger, this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, indexRoutings, executor, searchRequest, listener, shardIterators, timeProvider, clusterState, task, iter -> new WrappingSearchAsyncActionPhase(this.searchAsyncAction(task, searchRequest, executor, (GroupShardsIterator<SearchShardIterator>)iter, timeProvider, connectionLookup, clusterState, aliasFilter, concreteIndexBoosts, indexRoutings, listener, false, threadPool, clusters, searchRequestContext)), clusters, searchRequestContext, this.tracer);
        }
        QueryPhaseResultConsumer queryResultConsumer = this.searchPhaseController.newSearchPhaseResults(executor, this.circuitBreaker, task.getProgressListener(), searchRequest, shardIterators.size(), exc -> this.cancelTask(task, (Exception)exc));
        switch (searchRequest.searchType()) {
            case DFS_QUERY_THEN_FETCH: {
                searchAsyncAction = new SearchDfsQueryThenFetchAsyncAction(this.logger, this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, indexRoutings, this.searchPhaseController, executor, queryResultConsumer, searchRequest, listener, shardIterators, timeProvider, clusterState, task, clusters, searchRequestContext, this.tracer);
                break;
            }
            case QUERY_THEN_FETCH: {
                searchAsyncAction = new SearchQueryThenFetchAsyncAction(this.logger, this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, indexRoutings, this.searchPhaseController, executor, queryResultConsumer, searchRequest, listener, shardIterators, timeProvider, clusterState, task, clusters, searchRequestContext, this.tracer);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown search type: [" + searchRequest.searchType() + "]");
            }
        }
        return searchAsyncAction;
    }

    private void cancelTask(SearchTask task, Exception exc) {
        String errorMsg = exc.getMessage() != null ? exc.getMessage() : "";
        CancelTasksRequest req = ((CancelTasksRequest)new CancelTasksRequest().setTaskId(new TaskId(this.client.getLocalNodeId(), task.getId()))).setReason("Fatal failure during search: " + errorMsg);
        new OriginSettingClient(this.client, "tasks").admin().cluster().cancelTasks(req, (ActionListener<CancelTasksResponse>)ActionListener.wrap(() -> {}));
    }

    private static void failIfOverShardCountLimit(ClusterService clusterService, int shardCount) {
        long shardCountLimit = clusterService.getClusterSettings().get(SHARD_COUNT_LIMIT_SETTING);
        if ((long)shardCount > shardCountLimit) {
            throw new IllegalArgumentException("Trying to query " + shardCount + " shards, which is over the limit of " + shardCountLimit + ". This limit exists because querying many shards at the same time can make the job of the coordinating node very CPU and/or memory intensive. It is usually a better idea to have a smaller number of larger shards. Update [" + SHARD_COUNT_LIMIT_SETTING.getKey() + "] to a greater value if you really want to query that many shards at the same time.");
        }
    }

    private static RemoteTransportException wrapRemoteClusterFailure(String clusterAlias, Exception e) {
        return new RemoteTransportException("error while communicating with remote cluster [" + clusterAlias + "]", e);
    }

    static Map<String, OriginalIndices> getIndicesFromSearchContexts(SearchContextId searchContext, IndicesOptions indicesOptions) {
        HashMap<String, Set> indices = new HashMap<String, Set>();
        for (Map.Entry<ShardId, SearchContextIdForNode> entry : searchContext.shards().entrySet()) {
            String clusterAlias = entry.getValue().getClusterAlias() == null ? "" : entry.getValue().getClusterAlias();
            indices.computeIfAbsent(clusterAlias, k -> new HashSet()).add(entry.getKey().getIndexName());
        }
        return indices.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new OriginalIndices(((Set)e.getValue()).toArray(new String[0]), indicesOptions)));
    }

    static List<SearchShardIterator> getLocalLocalShardsIteratorFromPointInTime(ClusterState clusterState, OriginalIndices originalIndices, String localClusterAlias, SearchContextId searchContext, TimeValue keepAlive) {
        ArrayList<SearchShardIterator> iterators = new ArrayList<SearchShardIterator>(searchContext.shards().size());
        for (Map.Entry<ShardId, SearchContextIdForNode> entry : searchContext.shards().entrySet()) {
            SearchContextIdForNode perNode = entry.getValue();
            if (!Strings.isEmpty((CharSequence)perNode.getClusterAlias())) continue;
            ShardId shardId = entry.getKey();
            OperationRouting.getShards(clusterState, shardId);
            List<String> targetNodes = Collections.singletonList(perNode.getNode());
            iterators.add(new SearchShardIterator(localClusterAlias, shardId, targetNodes, originalIndices, perNode.getSearchContextId(), keepAlive));
        }
        return iterators;
    }

    static abstract class CCSActionListener<Response, FinalResponse>
    implements ActionListener<Response> {
        private final String clusterAlias;
        private final boolean skipUnavailable;
        private final CountDown countDown;
        private final AtomicInteger skippedClusters;
        private final AtomicReference<Exception> exceptions;
        private final ActionListener<FinalResponse> originalListener;

        CCSActionListener(String clusterAlias, boolean skipUnavailable, CountDown countDown, AtomicInteger skippedClusters, AtomicReference<Exception> exceptions, ActionListener<FinalResponse> originalListener) {
            this.clusterAlias = clusterAlias;
            this.skipUnavailable = skipUnavailable;
            this.countDown = countDown;
            this.skippedClusters = skippedClusters;
            this.exceptions = exceptions;
            this.originalListener = originalListener;
        }

        public final void onResponse(Response response) {
            this.innerOnResponse(response);
            this.maybeFinish();
        }

        abstract void innerOnResponse(Response var1);

        public final void onFailure(Exception e) {
            if (this.skipUnavailable) {
                this.skippedClusters.incrementAndGet();
            } else {
                Object exception = e;
                if (!"".equals(this.clusterAlias)) {
                    exception = TransportSearchAction.wrapRemoteClusterFailure(this.clusterAlias, e);
                }
                if (!this.exceptions.compareAndSet((Exception)null, (Exception)exception)) {
                    this.exceptions.accumulateAndGet((Exception)exception, (previous, current) -> {
                        current.addSuppressed((Throwable)previous);
                        return current;
                    });
                }
            }
            this.maybeFinish();
        }

        private void maybeFinish() {
            if (this.countDown.countDown()) {
                Exception exception = this.exceptions.get();
                if (exception == null) {
                    FinalResponse response;
                    try {
                        response = this.createFinalResponse();
                    }
                    catch (Exception e) {
                        this.originalListener.onFailure(e);
                        return;
                    }
                    this.originalListener.onResponse(response);
                } else {
                    this.originalListener.onFailure(this.exceptions.get());
                }
            }
        }

        abstract FinalResponse createFinalResponse();
    }

    static interface SearchAsyncActionProvider {
        public AbstractSearchAsyncAction<? extends SearchPhaseResult> asyncSearchAction(SearchTask var1, SearchRequest var2, Executor var3, GroupShardsIterator<SearchShardIterator> var4, SearchTimeProvider var5, BiFunction<String, String, Transport.Connection> var6, ClusterState var7, Map<String, AliasFilter> var8, Map<String, Float> var9, Map<String, Set<String>> var10, ActionListener<SearchResponse> var11, boolean var12, ThreadPool var13, SearchResponse.Clusters var14, SearchRequestContext var15);
    }

    public static interface SinglePhaseSearchAction {
        public void executeOnShardTarget(SearchTask var1, SearchShardTarget var2, Transport.Connection var3, ActionListener<SearchPhaseResult> var4);
    }

    static final class SearchTimeProvider {
        private final long absoluteStartMillis;
        private final long relativeStartNanos;
        private final LongSupplier relativeCurrentNanosProvider;

        SearchTimeProvider(long absoluteStartMillis, long relativeStartNanos, LongSupplier relativeCurrentNanosProvider) {
            this.absoluteStartMillis = absoluteStartMillis;
            this.relativeStartNanos = relativeStartNanos;
            this.relativeCurrentNanosProvider = relativeCurrentNanosProvider;
        }

        long getAbsoluteStartMillis() {
            return this.absoluteStartMillis;
        }

        long buildTookInMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.relativeCurrentNanosProvider.getAsLong() - this.relativeStartNanos);
        }
    }
}

