/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.cache.service;

import java.io.IOException;
import java.util.Objects;
import java.util.SortedMap;
import org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.cache.CacheType;
import org.opensearch.common.cache.stats.ImmutableCacheStatsHolder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class NodeCacheStats
implements ToXContentFragment,
Writeable {
    private final SortedMap<CacheType, ImmutableCacheStatsHolder> statsByCache;
    private final CommonStatsFlags flags;

    public NodeCacheStats(SortedMap<CacheType, ImmutableCacheStatsHolder> statsByCache, CommonStatsFlags flags) {
        this.statsByCache = statsByCache;
        this.flags = flags;
    }

    public NodeCacheStats(StreamInput in) throws IOException {
        this.flags = new CommonStatsFlags(in);
        this.statsByCache = in.readOrderedMap(i -> (CacheType)i.readEnum(CacheType.class), ImmutableCacheStatsHolder::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.flags.writeTo(out);
        out.writeMap(this.statsByCache, StreamOutput::writeEnum, (o, immutableCacheStatsHolder) -> immutableCacheStatsHolder.writeTo(o));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (CacheType type : this.statsByCache.keySet()) {
            if (!this.flags.getIncludeCaches().contains((Object)type)) continue;
            builder.startObject(type.getValue());
            ((ImmutableCacheStatsHolder)this.statsByCache.get((Object)type)).toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != NodeCacheStats.class) {
            return false;
        }
        NodeCacheStats other = (NodeCacheStats)o;
        return this.statsByCache.equals(other.statsByCache) && this.flags.getIncludeCaches().equals(other.flags.getIncludeCaches());
    }

    public int hashCode() {
        return Objects.hash(this.statsByCache, this.flags);
    }
}

