/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.Version;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.gateway.PersistedClusterStateService;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.gateway.remote.IndexMetadataUploadListener;
import org.opensearch.gateway.remote.RemotePersistenceStats;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.opensearch.node.Node;
import org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.opensearch.threadpool.ThreadPool;

public class RemoteClusterStateService
implements Closeable {
    public static final String METADATA_NAME_FORMAT = "%s.dat";
    public static final String METADATA_MANIFEST_NAME_FORMAT = "%s";
    public static final int RETAINED_MANIFESTS = 10;
    public static final String DELIMITER = "__";
    private static final Logger logger = LogManager.getLogger(RemoteClusterStateService.class);
    public static final TimeValue INDEX_METADATA_UPLOAD_TIMEOUT_DEFAULT = TimeValue.timeValueMillis((long)20000L);
    public static final TimeValue GLOBAL_METADATA_UPLOAD_TIMEOUT_DEFAULT = TimeValue.timeValueMillis((long)20000L);
    public static final TimeValue METADATA_MANIFEST_UPLOAD_TIMEOUT_DEFAULT = TimeValue.timeValueMillis((long)20000L);
    public static final Setting<TimeValue> INDEX_METADATA_UPLOAD_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.state.index_metadata.upload_timeout", INDEX_METADATA_UPLOAD_TIMEOUT_DEFAULT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> GLOBAL_METADATA_UPLOAD_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.state.global_metadata.upload_timeout", GLOBAL_METADATA_UPLOAD_TIMEOUT_DEFAULT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> METADATA_MANIFEST_UPLOAD_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.state.metadata_manifest.upload_timeout", METADATA_MANIFEST_UPLOAD_TIMEOUT_DEFAULT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ChecksumBlobStoreFormat<IndexMetadata> INDEX_METADATA_FORMAT = new ChecksumBlobStoreFormat("index-metadata", "%s.dat", IndexMetadata::fromXContent);
    public static final ChecksumBlobStoreFormat<Metadata> GLOBAL_METADATA_FORMAT = new ChecksumBlobStoreFormat("metadata", "%s.dat", Metadata::fromXContent);
    public static final ChecksumBlobStoreFormat<ClusterMetadataManifest> CLUSTER_METADATA_MANIFEST_FORMAT_V0 = new ChecksumBlobStoreFormat("cluster-metadata-manifest", "%s", ClusterMetadataManifest::fromXContentV0);
    public static final ChecksumBlobStoreFormat<ClusterMetadataManifest> CLUSTER_METADATA_MANIFEST_FORMAT = new ChecksumBlobStoreFormat("cluster-metadata-manifest", "%s", ClusterMetadataManifest::fromXContent);
    public static final Setting<Boolean> REMOTE_CLUSTER_STATE_ENABLED_SETTING = Setting.boolSetting("cluster.remote_store.state.enabled", false, Setting.Property.NodeScope, Setting.Property.Final);
    public static final String CLUSTER_STATE_PATH_TOKEN = "cluster-state";
    public static final String INDEX_PATH_TOKEN = "index";
    public static final String GLOBAL_METADATA_PATH_TOKEN = "global-metadata";
    public static final String MANIFEST_PATH_TOKEN = "manifest";
    public static final String MANIFEST_FILE_PREFIX = "manifest";
    public static final String METADATA_FILE_PREFIX = "metadata";
    public static final int SPLITED_MANIFEST_FILE_LENGTH = 6;
    private final String nodeId;
    private final Supplier<RepositoriesService> repositoriesService;
    private final Settings settings;
    private final LongSupplier relativeTimeNanosSupplier;
    private final ThreadPool threadpool;
    private final List<IndexMetadataUploadListener> indexMetadataUploadListeners;
    private BlobStoreRepository blobStoreRepository;
    private BlobStoreTransferService blobStoreTransferService;
    private volatile TimeValue slowWriteLoggingThreshold;
    private volatile TimeValue indexMetadataUploadTimeout;
    private volatile TimeValue globalMetadataUploadTimeout;
    private volatile TimeValue metadataManifestUploadTimeout;
    private final AtomicBoolean deleteStaleMetadataRunning = new AtomicBoolean(false);
    private final RemotePersistenceStats remoteStateStats;
    public static final int INDEX_METADATA_CURRENT_CODEC_VERSION = 1;
    public static final int MANIFEST_CURRENT_CODEC_VERSION = 1;
    public static final int GLOBAL_METADATA_CURRENT_CODEC_VERSION = 1;
    public static final ToXContent.Params FORMAT_PARAMS;

    public RemoteClusterStateService(String nodeId, Supplier<RepositoriesService> repositoriesService, Settings settings, ClusterSettings clusterSettings, LongSupplier relativeTimeNanosSupplier, ThreadPool threadPool, List<IndexMetadataUploadListener> indexMetadataUploadListeners) {
        assert (RemoteStoreNodeAttribute.isRemoteStoreClusterStateEnabled(settings)) : "Remote cluster state is not enabled";
        this.nodeId = nodeId;
        this.repositoriesService = repositoriesService;
        this.settings = settings;
        this.relativeTimeNanosSupplier = relativeTimeNanosSupplier;
        this.threadpool = threadPool;
        this.slowWriteLoggingThreshold = clusterSettings.get(PersistedClusterStateService.SLOW_WRITE_LOGGING_THRESHOLD);
        this.indexMetadataUploadTimeout = clusterSettings.get(INDEX_METADATA_UPLOAD_TIMEOUT_SETTING);
        this.globalMetadataUploadTimeout = clusterSettings.get(GLOBAL_METADATA_UPLOAD_TIMEOUT_SETTING);
        this.metadataManifestUploadTimeout = clusterSettings.get(METADATA_MANIFEST_UPLOAD_TIMEOUT_SETTING);
        clusterSettings.addSettingsUpdateConsumer(PersistedClusterStateService.SLOW_WRITE_LOGGING_THRESHOLD, this::setSlowWriteLoggingThreshold);
        clusterSettings.addSettingsUpdateConsumer(INDEX_METADATA_UPLOAD_TIMEOUT_SETTING, this::setIndexMetadataUploadTimeout);
        clusterSettings.addSettingsUpdateConsumer(GLOBAL_METADATA_UPLOAD_TIMEOUT_SETTING, this::setGlobalMetadataUploadTimeout);
        clusterSettings.addSettingsUpdateConsumer(METADATA_MANIFEST_UPLOAD_TIMEOUT_SETTING, this::setMetadataManifestUploadTimeout);
        this.remoteStateStats = new RemotePersistenceStats();
        this.indexMetadataUploadListeners = indexMetadataUploadListeners;
    }

    private BlobStoreTransferService getBlobStoreTransferService() {
        if (this.blobStoreTransferService == null) {
            this.blobStoreTransferService = new BlobStoreTransferService(this.blobStoreRepository.blobStore(), this.threadpool);
        }
        return this.blobStoreTransferService;
    }

    @Nullable
    public ClusterMetadataManifest writeFullMetadata(ClusterState clusterState, String previousClusterUUID) throws IOException {
        long startTimeNanos = this.relativeTimeNanosSupplier.getAsLong();
        if (!clusterState.nodes().isLocalNodeElectedClusterManager()) {
            logger.error("Local node is not elected cluster manager. Exiting");
            return null;
        }
        String globalMetadataFile = this.writeGlobalMetadata(clusterState);
        ArrayList<IndexMetadata> toUpload = new ArrayList<IndexMetadata>(clusterState.metadata().indices().values());
        List<ClusterMetadataManifest.UploadedIndexMetadata> allUploadedIndexMetadata = this.writeIndexMetadataParallel(clusterState, toUpload, Collections.emptyMap());
        ClusterMetadataManifest manifest = this.uploadManifest(clusterState, allUploadedIndexMetadata, previousClusterUUID, globalMetadataFile, false);
        long durationMillis = TimeValue.nsecToMSec((long)(this.relativeTimeNanosSupplier.getAsLong() - startTimeNanos));
        this.remoteStateStats.stateSucceeded();
        this.remoteStateStats.stateTook(durationMillis);
        if (durationMillis >= this.slowWriteLoggingThreshold.getMillis()) {
            logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; wrote full state with [{}] indices", (Object)durationMillis, (Object)this.slowWriteLoggingThreshold, (Object)allUploadedIndexMetadata.size());
        } else {
            logger.info("writing cluster state took [{}ms]; wrote full state with [{}] indices and global metadata", (Object)durationMillis, (Object)allUploadedIndexMetadata.size());
        }
        return manifest;
    }

    @Nullable
    public ClusterMetadataManifest writeIncrementalMetadata(ClusterState previousClusterState, ClusterState clusterState, ClusterMetadataManifest previousManifest) throws IOException {
        String globalMetadataFile;
        boolean updateGlobalMetadata;
        long startTimeNanos = this.relativeTimeNanosSupplier.getAsLong();
        if (!clusterState.nodes().isLocalNodeElectedClusterManager()) {
            logger.error("Local node is not elected cluster manager. Exiting");
            return null;
        }
        assert (previousClusterState.metadata().coordinationMetadata().term() == clusterState.metadata().coordinationMetadata().term());
        boolean bl = updateGlobalMetadata = !Metadata.isGlobalStateEquals(previousClusterState.metadata(), clusterState.metadata());
        if (updateGlobalMetadata || previousManifest.getGlobalMetadataFileName() == null) {
            globalMetadataFile = this.writeGlobalMetadata(clusterState);
        } else {
            logger.debug("Global metadata has not updated in cluster state, skipping upload of it");
            globalMetadataFile = previousManifest.getGlobalMetadataFileName();
        }
        HashMap<String, IndexMetadata> previousStateIndexMetadataByName = new HashMap<String, IndexMetadata>();
        for (IndexMetadata indexMetadata : previousClusterState.metadata().indices().values()) {
            previousStateIndexMetadataByName.put(indexMetadata.getIndex().getName(), indexMetadata);
        }
        int numIndicesUpdated = 0;
        int numIndicesUnchanged = 0;
        Map allUploadedIndexMetadata = previousManifest.getIndices().stream().collect(Collectors.toMap(ClusterMetadataManifest.UploadedIndexMetadata::getIndexName, Function.identity()));
        ArrayList<IndexMetadata> toUpload = new ArrayList<IndexMetadata>();
        HashMap<String, IndexMetadata> prevIndexMetadataByName = new HashMap<String, IndexMetadata>();
        for (IndexMetadata indexMetadata : clusterState.metadata().indices().values()) {
            Long previousVersion;
            String indexName = indexMetadata.getIndex().getName();
            IndexMetadata prevIndexMetadata = (IndexMetadata)previousStateIndexMetadataByName.get(indexName);
            Long l = previousVersion = prevIndexMetadata != null ? Long.valueOf(prevIndexMetadata.getVersion()) : null;
            if (previousVersion == null || indexMetadata.getVersion() != previousVersion.longValue()) {
                logger.debug("updating metadata for [{}], changing version from [{}] to [{}]", (Object)indexMetadata.getIndex(), (Object)previousVersion, (Object)indexMetadata.getVersion());
                ++numIndicesUpdated;
                toUpload.add(indexMetadata);
                prevIndexMetadataByName.put(indexName, prevIndexMetadata);
            } else {
                ++numIndicesUnchanged;
            }
            previousStateIndexMetadataByName.remove(indexMetadata.getIndex().getName());
        }
        List<ClusterMetadataManifest.UploadedIndexMetadata> uploadedIndexMetadataList = this.writeIndexMetadataParallel(clusterState, toUpload, prevIndexMetadataByName);
        uploadedIndexMetadataList.forEach(uploadedIndexMetadata -> allUploadedIndexMetadata.put(uploadedIndexMetadata.getIndexName(), uploadedIndexMetadata));
        for (String removedIndexName : previousStateIndexMetadataByName.keySet()) {
            allUploadedIndexMetadata.remove(removedIndexName);
        }
        ClusterMetadataManifest clusterMetadataManifest = this.uploadManifest(clusterState, new ArrayList<ClusterMetadataManifest.UploadedIndexMetadata>(allUploadedIndexMetadata.values()), previousManifest.getPreviousClusterUUID(), globalMetadataFile, false);
        this.deleteStaleClusterMetadata(clusterState.getClusterName().value(), clusterState.metadata().clusterUUID(), 10);
        long durationMillis = TimeValue.nsecToMSec((long)(this.relativeTimeNanosSupplier.getAsLong() - startTimeNanos));
        this.remoteStateStats.stateSucceeded();
        this.remoteStateStats.stateTook(durationMillis);
        if (durationMillis >= this.slowWriteLoggingThreshold.getMillis()) {
            logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; wrote  metadata for [{}] indices and skipped [{}] unchanged indices, global metadata updated : [{}]", (Object)durationMillis, (Object)this.slowWriteLoggingThreshold, (Object)numIndicesUpdated, (Object)numIndicesUnchanged, (Object)updateGlobalMetadata);
        } else {
            logger.info("writing cluster state for version [{}] took [{}ms]; wrote metadata for [{}] indices and skipped [{}] unchanged indices, global metadata updated : [{}]", (Object)clusterMetadataManifest.getStateVersion(), (Object)durationMillis, (Object)numIndicesUpdated, (Object)numIndicesUnchanged, (Object)updateGlobalMetadata);
        }
        return clusterMetadataManifest;
    }

    private String writeGlobalMetadata(ClusterState clusterState) throws IOException {
        AtomicReference result = new AtomicReference();
        AtomicReference exceptionReference = new AtomicReference();
        BlobContainer globalMetadataContainer = this.globalMetadataContainer(clusterState.getClusterName().value(), clusterState.metadata().clusterUUID());
        String globalMetadataFilename = RemoteClusterStateService.globalMetadataFileName(clusterState.metadata());
        CountDownLatch latch = new CountDownLatch(1);
        LatchedActionListener<Void> completionListener = new LatchedActionListener<Void>(ActionListener.wrap(resp -> {
            logger.trace(String.format(Locale.ROOT, "GlobalMetadata uploaded successfully.", new Object[0]));
            result.set(globalMetadataContainer.path().buildAsString() + globalMetadataFilename);
        }, ex -> exceptionReference.set(ex)), latch);
        GLOBAL_METADATA_FORMAT.writeAsyncWithUrgentPriority(clusterState.metadata(), globalMetadataContainer, globalMetadataFilename, this.blobStoreRepository.getCompressor(), completionListener, FORMAT_PARAMS);
        try {
            if (!latch.await(this.getGlobalMetadataUploadTimeout().millis(), TimeUnit.MILLISECONDS)) {
                RemoteStateTransferException ex2 = new RemoteStateTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of global metadata to complete", new Object[0]));
                throw ex2;
            }
        }
        catch (InterruptedException ex3) {
            RemoteStateTransferException exception = new RemoteStateTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of global metadata to complete - %s", new Object[0]), ex3);
            Thread.currentThread().interrupt();
            throw exception;
        }
        if (exceptionReference.get() != null) {
            throw new RemoteStateTransferException(((Exception)exceptionReference.get()).getMessage(), (Throwable)exceptionReference.get());
        }
        return (String)result.get();
    }

    private List<ClusterMetadataManifest.UploadedIndexMetadata> writeIndexMetadataParallel(ClusterState clusterState, List<IndexMetadata> toUpload, Map<String, IndexMetadata> prevIndexMetadataByName) throws IOException {
        assert (Objects.nonNull(this.indexMetadataUploadListeners)) : "indexMetadataUploadListeners can not be null";
        int latchCount = toUpload.size() + this.indexMetadataUploadListeners.size();
        List<Exception> exceptionList = Collections.synchronizedList(new ArrayList(latchCount));
        CountDownLatch latch = new CountDownLatch(latchCount);
        ArrayList<ClusterMetadataManifest.UploadedIndexMetadata> result = new ArrayList<ClusterMetadataManifest.UploadedIndexMetadata>(toUpload.size());
        LatchedActionListener<ClusterMetadataManifest.UploadedIndexMetadata> latchedActionListener = new LatchedActionListener<ClusterMetadataManifest.UploadedIndexMetadata>(ActionListener.wrap(uploadedIndexMetadata -> {
            logger.trace(String.format(Locale.ROOT, "IndexMetadata uploaded successfully for %s", uploadedIndexMetadata.getIndexName()));
            result.add((ClusterMetadataManifest.UploadedIndexMetadata)uploadedIndexMetadata);
        }, ex -> {
            assert (ex instanceof RemoteStateTransferException);
            logger.error(() -> new ParameterizedMessage("Exception during transfer of IndexMetadata to Remote {}", (Object)ex.getMessage()), (Throwable)ex);
            exceptionList.add((Exception)ex);
        }), latch);
        for (IndexMetadata indexMetadata : toUpload) {
            this.writeIndexMetadataAsync(clusterState, indexMetadata, latchedActionListener);
        }
        this.invokeIndexMetadataUploadListeners(toUpload, prevIndexMetadataByName, latch, exceptionList);
        try {
            if (!latch.await(this.getIndexMetadataUploadTimeout().millis(), TimeUnit.MILLISECONDS)) {
                RemoteStateTransferException ex2 = new RemoteStateTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of index metadata to complete - %s", toUpload.stream().map(IndexMetadata::getIndex).map(Index::toString).collect(Collectors.joining(""))));
                exceptionList.forEach(ex2::addSuppressed);
                throw ex2;
            }
        }
        catch (InterruptedException ex3) {
            exceptionList.forEach(ex3::addSuppressed);
            RemoteStateTransferException exception = new RemoteStateTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of index metadata to complete - %s", toUpload.stream().map(IndexMetadata::getIndex).map(Index::toString).collect(Collectors.joining(""))), ex3);
            Thread.currentThread().interrupt();
            throw exception;
        }
        if (exceptionList.size() > 0) {
            RemoteStateTransferException exception = new RemoteStateTransferException(String.format(Locale.ROOT, "Exception during transfer of IndexMetadata to Remote %s", toUpload.stream().map(IndexMetadata::getIndex).map(Index::toString).collect(Collectors.joining(""))));
            exceptionList.forEach(exception::addSuppressed);
            throw exception;
        }
        return result;
    }

    private void invokeIndexMetadataUploadListeners(List<IndexMetadata> updatedIndexMetadataList, Map<String, IndexMetadata> prevIndexMetadataByName, CountDownLatch latch, List<Exception> exceptionList) {
        for (IndexMetadataUploadListener listener : this.indexMetadataUploadListeners) {
            String listenerName = listener.getClass().getSimpleName();
            listener.onUpload(updatedIndexMetadataList, prevIndexMetadataByName, this.getIndexMetadataUploadActionListener(updatedIndexMetadataList, prevIndexMetadataByName, latch, exceptionList, listenerName));
        }
    }

    private ActionListener<Void> getIndexMetadataUploadActionListener(List<IndexMetadata> newIndexMetadataList, Map<String, IndexMetadata> prevIndexMetadataByName, CountDownLatch latch, List<Exception> exceptionList, String listenerName) {
        long startTime = System.nanoTime();
        return new LatchedActionListener<Void>(ActionListener.wrap(ignored -> logger.trace((Message)new ParameterizedMessage("listener={} : Invoked successfully with indexMetadataList={} prevIndexMetadataList={} tookTimeNs={}", new Object[]{listenerName, newIndexMetadataList, prevIndexMetadataByName.values(), System.nanoTime() - startTime})), ex -> {
            logger.error((Message)new ParameterizedMessage("listener={} : Exception during invocation with indexMetadataList={} prevIndexMetadataList={} tookTimeNs={}", new Object[]{listenerName, newIndexMetadataList, prevIndexMetadataByName.values(), System.nanoTime() - startTime}), (Throwable)ex);
            exceptionList.add((Exception)ex);
        }), latch);
    }

    private void writeIndexMetadataAsync(ClusterState clusterState, IndexMetadata indexMetadata, LatchedActionListener<ClusterMetadataManifest.UploadedIndexMetadata> latchedActionListener) throws IOException {
        BlobContainer indexMetadataContainer = this.indexMetadataContainer(clusterState.getClusterName().value(), clusterState.metadata().clusterUUID(), indexMetadata.getIndexUUID());
        String indexMetadataFilename = RemoteClusterStateService.indexMetadataFileName(indexMetadata);
        ActionListener completionListener = ActionListener.wrap(resp -> latchedActionListener.onResponse(new ClusterMetadataManifest.UploadedIndexMetadata(indexMetadata.getIndex().getName(), indexMetadata.getIndexUUID(), indexMetadataContainer.path().buildAsString() + indexMetadataFilename)), ex -> latchedActionListener.onFailure(new RemoteStateTransferException(indexMetadata.getIndex().toString(), (Throwable)ex)));
        INDEX_METADATA_FORMAT.writeAsyncWithUrgentPriority(indexMetadata, indexMetadataContainer, indexMetadataFilename, this.blobStoreRepository.getCompressor(), (ActionListener<Void>)completionListener, FORMAT_PARAMS);
    }

    @Nullable
    public ClusterMetadataManifest markLastStateAsCommitted(ClusterState clusterState, ClusterMetadataManifest previousManifest) throws IOException {
        assert (clusterState != null) : "Last accepted cluster state is not set";
        if (!clusterState.nodes().isLocalNodeElectedClusterManager()) {
            logger.error("Local node is not elected cluster manager. Exiting");
            return null;
        }
        assert (previousManifest != null) : "Last cluster metadata manifest is not set";
        ClusterMetadataManifest committedManifest = this.uploadManifest(clusterState, previousManifest.getIndices(), previousManifest.getPreviousClusterUUID(), previousManifest.getGlobalMetadataFileName(), true);
        this.deleteStaleClusterUUIDs(clusterState, committedManifest);
        return committedManifest;
    }

    @Override
    public void close() throws IOException {
        if (this.blobStoreRepository != null) {
            IOUtils.close((Closeable)((Object)this.blobStoreRepository));
        }
    }

    public void start() {
        assert (RemoteStoreNodeAttribute.isRemoteStoreClusterStateEnabled(this.settings)) : "Remote cluster state is not enabled";
        String remoteStoreRepo = this.settings.get(Node.NODE_ATTRIBUTES.getKey() + "remote_store.state.repository");
        assert (remoteStoreRepo != null) : "Remote Cluster State repository is not configured";
        Repository repository = this.repositoriesService.get().repository(remoteStoreRepo);
        assert (repository instanceof BlobStoreRepository) : "Repository should be instance of BlobStoreRepository";
        this.blobStoreRepository = (BlobStoreRepository)repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterMetadataManifest uploadManifest(ClusterState clusterState, List<ClusterMetadataManifest.UploadedIndexMetadata> uploadedIndexMetadata, String previousClusterUUID, String globalClusterMetadataFileName, boolean committed) throws IOException {
        RemoteClusterStateService remoteClusterStateService = this;
        synchronized (remoteClusterStateService) {
            String manifestFileName = RemoteClusterStateService.getManifestFileName(clusterState.term(), clusterState.version(), committed);
            ClusterMetadataManifest manifest = new ClusterMetadataManifest(clusterState.term(), clusterState.getVersion(), clusterState.metadata().clusterUUID(), clusterState.stateUUID(), Version.CURRENT, this.nodeId, committed, 1, globalClusterMetadataFileName, uploadedIndexMetadata, previousClusterUUID, clusterState.metadata().clusterUUIDCommitted());
            this.writeMetadataManifest(clusterState.getClusterName().value(), clusterState.metadata().clusterUUID(), manifest, manifestFileName);
            return manifest;
        }
    }

    private void writeMetadataManifest(String clusterName, String clusterUUID, ClusterMetadataManifest uploadManifest, String fileName) throws IOException {
        AtomicReference result = new AtomicReference();
        AtomicReference exceptionReference = new AtomicReference();
        BlobContainer metadataManifestContainer = this.manifestContainer(clusterName, clusterUUID);
        CountDownLatch latch = new CountDownLatch(1);
        LatchedActionListener<Void> completionListener = new LatchedActionListener<Void>(ActionListener.wrap(resp -> logger.trace(String.format(Locale.ROOT, "Manifest file uploaded successfully.", new Object[0])), ex -> exceptionReference.set(ex)), latch);
        CLUSTER_METADATA_MANIFEST_FORMAT.writeAsyncWithUrgentPriority(uploadManifest, metadataManifestContainer, fileName, this.blobStoreRepository.getCompressor(), completionListener, FORMAT_PARAMS);
        try {
            if (!latch.await(this.getMetadataManifestUploadTimeout().millis(), TimeUnit.MILLISECONDS)) {
                RemoteStateTransferException ex2 = new RemoteStateTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of manifest file to complete", new Object[0]));
                throw ex2;
            }
        }
        catch (InterruptedException ex3) {
            RemoteStateTransferException exception = new RemoteStateTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of manifest file to complete - %s", new Object[0]), ex3);
            Thread.currentThread().interrupt();
            throw exception;
        }
        if (exceptionReference.get() != null) {
            throw new RemoteStateTransferException(((Exception)exceptionReference.get()).getMessage(), (Throwable)exceptionReference.get());
        }
        logger.debug("Metadata manifest file [{}] written during [{}] phase. ", (Object)fileName, (Object)(uploadManifest.isCommitted() ? "commit" : "publish"));
    }

    private BlobContainer indexMetadataContainer(String clusterName, String clusterUUID, String indexUUID) {
        return this.blobStoreRepository.blobStore().blobContainer(this.getCusterMetadataBasePath(clusterName, clusterUUID).add(INDEX_PATH_TOKEN).add(indexUUID));
    }

    private BlobContainer globalMetadataContainer(String clusterName, String clusterUUID) {
        return this.blobStoreRepository.blobStore().blobContainer(this.getCusterMetadataBasePath(clusterName, clusterUUID).add(GLOBAL_METADATA_PATH_TOKEN));
    }

    private BlobContainer manifestContainer(String clusterName, String clusterUUID) {
        return this.blobStoreRepository.blobStore().blobContainer(this.getManifestFolderPath(clusterName, clusterUUID));
    }

    private BlobPath getCusterMetadataBasePath(String clusterName, String clusterUUID) {
        return this.blobStoreRepository.basePath().add(RemoteClusterStateService.encodeString(clusterName)).add(CLUSTER_STATE_PATH_TOKEN).add(clusterUUID);
    }

    private BlobContainer clusterUUIDContainer(String clusterName) {
        return this.blobStoreRepository.blobStore().blobContainer(this.blobStoreRepository.basePath().add(Base64.getUrlEncoder().withoutPadding().encodeToString(clusterName.getBytes(StandardCharsets.UTF_8))).add(CLUSTER_STATE_PATH_TOKEN));
    }

    private void setSlowWriteLoggingThreshold(TimeValue slowWriteLoggingThreshold) {
        this.slowWriteLoggingThreshold = slowWriteLoggingThreshold;
    }

    private void setIndexMetadataUploadTimeout(TimeValue newIndexMetadataUploadTimeout) {
        this.indexMetadataUploadTimeout = newIndexMetadataUploadTimeout;
    }

    private void setGlobalMetadataUploadTimeout(TimeValue newGlobalMetadataUploadTimeout) {
        this.globalMetadataUploadTimeout = newGlobalMetadataUploadTimeout;
    }

    private void setMetadataManifestUploadTimeout(TimeValue newMetadataManifestUploadTimeout) {
        this.metadataManifestUploadTimeout = newMetadataManifestUploadTimeout;
    }

    public TimeValue getIndexMetadataUploadTimeout() {
        return this.indexMetadataUploadTimeout;
    }

    public TimeValue getGlobalMetadataUploadTimeout() {
        return this.globalMetadataUploadTimeout;
    }

    public TimeValue getMetadataManifestUploadTimeout() {
        return this.metadataManifestUploadTimeout;
    }

    static String getManifestFileName(long term, long version, boolean committed) {
        return String.join((CharSequence)DELIMITER, "manifest", RemoteStoreUtils.invertLong(term), RemoteStoreUtils.invertLong(version), committed ? "C" : "P", RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
    }

    static String indexMetadataFileName(IndexMetadata indexMetadata) {
        return String.join((CharSequence)DELIMITER, METADATA_FILE_PREFIX, RemoteStoreUtils.invertLong(indexMetadata.getVersion()), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
    }

    private static String globalMetadataFileName(Metadata metadata) {
        return String.join((CharSequence)DELIMITER, METADATA_FILE_PREFIX, RemoteStoreUtils.invertLong(metadata.version()), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
    }

    private BlobPath getManifestFolderPath(String clusterName, String clusterUUID) {
        return this.getCusterMetadataBasePath(clusterName, clusterUUID).add("manifest");
    }

    private Map<String, IndexMetadata> getIndexMetadataMap(String clusterName, String clusterUUID, ClusterMetadataManifest clusterMetadataManifest) {
        assert (Objects.equals(clusterUUID, clusterMetadataManifest.getClusterUUID())) : "Corrupt ClusterMetadataManifest found. Cluster UUID mismatch.";
        HashMap<String, IndexMetadata> remoteIndexMetadata = new HashMap<String, IndexMetadata>();
        for (ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata : clusterMetadataManifest.getIndices()) {
            IndexMetadata indexMetadata = this.getIndexMetadata(clusterName, clusterUUID, uploadedIndexMetadata);
            remoteIndexMetadata.put(uploadedIndexMetadata.getIndexUUID(), indexMetadata);
        }
        return remoteIndexMetadata;
    }

    private IndexMetadata getIndexMetadata(String clusterName, String clusterUUID, ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata) {
        BlobContainer blobContainer = this.indexMetadataContainer(clusterName, clusterUUID, uploadedIndexMetadata.getIndexUUID());
        try {
            String[] splitPath = uploadedIndexMetadata.getUploadedFilename().split("/");
            return INDEX_METADATA_FORMAT.read(blobContainer, splitPath[splitPath.length - 1], this.blobStoreRepository.getNamedXContentRegistry());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading IndexMetadata - %s", uploadedIndexMetadata.getUploadedFilename()), e);
        }
    }

    public ClusterState getLatestClusterState(String clusterName, String clusterUUID) {
        Optional<ClusterMetadataManifest> clusterMetadataManifest = this.getLatestClusterMetadataManifest(clusterName, clusterUUID);
        if (clusterMetadataManifest.isEmpty()) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Latest cluster metadata manifest is not present for the provided clusterUUID: %s", clusterUUID));
        }
        Metadata globalMetadata = this.getGlobalMetadata(clusterName, clusterUUID, clusterMetadataManifest.get());
        Map<String, IndexMetadata> indices = this.getIndexMetadataMap(clusterName, clusterUUID, clusterMetadataManifest.get());
        HashMap<String, IndexMetadata> indexMetadataMap = new HashMap<String, IndexMetadata>();
        indices.values().forEach(indexMetadata -> indexMetadataMap.put(indexMetadata.getIndex().getName(), (IndexMetadata)indexMetadata));
        return ClusterState.builder(ClusterState.EMPTY_STATE).version(clusterMetadataManifest.get().getStateVersion()).metadata(Metadata.builder(globalMetadata).indices(indexMetadataMap).build()).build();
    }

    private Metadata getGlobalMetadata(String clusterName, String clusterUUID, ClusterMetadataManifest clusterMetadataManifest) {
        String globalMetadataFileName = clusterMetadataManifest.getGlobalMetadataFileName();
        try {
            if (globalMetadataFileName != null) {
                String[] splitPath = globalMetadataFileName.split("/");
                return GLOBAL_METADATA_FORMAT.read(this.globalMetadataContainer(clusterName, clusterUUID), splitPath[splitPath.length - 1], this.blobStoreRepository.getNamedXContentRegistry());
            }
            return Metadata.EMPTY_METADATA;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading Global Metadata - %s", globalMetadataFileName), e);
        }
    }

    public Optional<ClusterMetadataManifest> getLatestClusterMetadataManifest(String clusterName, String clusterUUID) {
        Optional<String> latestManifestFileName = this.getLatestManifestFileName(clusterName, clusterUUID);
        return latestManifestFileName.map(s -> this.fetchRemoteClusterMetadataManifest(clusterName, clusterUUID, (String)s));
    }

    public String getLastKnownUUIDFromRemote(String clusterName) {
        try {
            Set<String> clusterUUIDs = this.getAllClusterUUIDs(clusterName);
            Map<String, ClusterMetadataManifest> latestManifests = this.getLatestManifestForAllClusterUUIDs(clusterName, clusterUUIDs);
            List<String> validChain = this.createClusterChain(latestManifests, clusterName);
            if (validChain.isEmpty()) {
                return "_na_";
            }
            return validChain.get(0);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while fetching previous UUIDs from remote store for cluster name: %s", clusterName), e);
        }
    }

    private Set<String> getAllClusterUUIDs(String clusterName) throws IOException {
        Map<String, BlobContainer> clusterUUIDMetadata = this.clusterUUIDContainer(clusterName).children();
        if (clusterUUIDMetadata == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(clusterUUIDMetadata.keySet());
    }

    private Map<String, ClusterMetadataManifest> getLatestManifestForAllClusterUUIDs(String clusterName, Set<String> clusterUUIDs) {
        HashMap<String, ClusterMetadataManifest> manifestsByClusterUUID = new HashMap<String, ClusterMetadataManifest>();
        for (String clusterUUID : clusterUUIDs) {
            try {
                Optional<ClusterMetadataManifest> manifest = this.getLatestClusterMetadataManifest(clusterName, clusterUUID);
                manifest.ifPresent(clusterMetadataManifest -> manifestsByClusterUUID.put(clusterUUID, (ClusterMetadataManifest)clusterMetadataManifest));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Exception in fetching manifest for clusterUUID: %s", clusterUUID), e);
            }
        }
        return manifestsByClusterUUID;
    }

    private List<String> createClusterChain(Map<String, ClusterMetadataManifest> manifestsByClusterUUID, String clusterName) {
        List validClusterManifests = manifestsByClusterUUID.values().stream().filter(this::isValidClusterUUID).collect(Collectors.toList());
        Map<String, String> clusterUUIDGraph = validClusterManifests.stream().collect(Collectors.toMap(ClusterMetadataManifest::getClusterUUID, ClusterMetadataManifest::getPreviousClusterUUID));
        List<String> topLevelClusterUUIDs = validClusterManifests.stream().map(ClusterMetadataManifest::getClusterUUID).filter(clusterUUID -> !clusterUUIDGraph.containsValue(clusterUUID)).collect(Collectors.toList());
        if (topLevelClusterUUIDs.isEmpty()) {
            assert (validClusterManifests.isEmpty()) : "There are no top level cluster UUIDs even when there are valid cluster UUIDs";
            logger.info("There is no valid previous cluster UUID. All cluster UUIDs evaluated are: {}", manifestsByClusterUUID.keySet());
            return Collections.emptyList();
        }
        if (topLevelClusterUUIDs.size() > 1) {
            logger.info("Top level cluster UUIDs: {}", topLevelClusterUUIDs);
            Map<String, ClusterMetadataManifest> manifestsByClusterUUIDTrimmed = this.trimClusterUUIDs(manifestsByClusterUUID, topLevelClusterUUIDs, clusterName);
            if (manifestsByClusterUUID.size() == manifestsByClusterUUIDTrimmed.size()) {
                throw new IllegalStateException(String.format(Locale.ROOT, "The system has ended into multiple valid cluster states in the remote store. Please check their latest manifest to decide which one you want to keep. Valid Cluster UUIDs: - %s", topLevelClusterUUIDs));
            }
            return this.createClusterChain(manifestsByClusterUUIDTrimmed, clusterName);
        }
        ArrayList<String> validChain = new ArrayList<String>();
        String currentUUID = (String)topLevelClusterUUIDs.get(0);
        while (currentUUID != null && !"_na_".equals(currentUUID)) {
            validChain.add(currentUUID);
            currentUUID = clusterUUIDGraph.get(currentUUID);
        }
        logger.info("Known UUIDs found in remote store : [{}]", validChain);
        return validChain;
    }

    private Map<String, ClusterMetadataManifest> trimClusterUUIDs(Map<String, ClusterMetadataManifest> latestManifestsByClusterUUID, List<String> validClusterUUIDs, String clusterName) {
        HashMap<String, ClusterMetadataManifest> trimmedUUIDs = new HashMap<String, ClusterMetadataManifest>(latestManifestsByClusterUUID);
        for (String clusterUUID : validClusterUUIDs) {
            ClusterMetadataManifest previousManifest;
            ClusterMetadataManifest currentManifest = (ClusterMetadataManifest)trimmedUUIDs.get(clusterUUID);
            if ("_na_".equals(currentManifest.getPreviousClusterUUID()) || !this.isMetadataEqual(currentManifest, previousManifest = (ClusterMetadataManifest)trimmedUUIDs.get(currentManifest.getPreviousClusterUUID()), clusterName) || !this.isGlobalMetadataEqual(currentManifest, previousManifest, clusterName)) continue;
            trimmedUUIDs.remove(clusterUUID);
        }
        return trimmedUUIDs;
    }

    private boolean isMetadataEqual(ClusterMetadataManifest first, ClusterMetadataManifest second, String clusterName) {
        if (first.getIndices().size() != second.getIndices().size()) {
            return false;
        }
        Map secondIndices = second.getIndices().stream().collect(Collectors.toMap(md -> md.getIndexName(), Function.identity()));
        for (ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata : first.getIndices()) {
            IndexMetadata firstIndexMetadata = this.getIndexMetadata(clusterName, first.getClusterUUID(), uploadedIndexMetadata);
            ClusterMetadataManifest.UploadedIndexMetadata secondUploadedIndexMetadata = (ClusterMetadataManifest.UploadedIndexMetadata)secondIndices.get(uploadedIndexMetadata.getIndexName());
            if (secondUploadedIndexMetadata == null) {
                return false;
            }
            IndexMetadata secondIndexMetadata = this.getIndexMetadata(clusterName, second.getClusterUUID(), secondUploadedIndexMetadata);
            if (firstIndexMetadata.equals(secondIndexMetadata)) continue;
            return false;
        }
        return true;
    }

    private boolean isGlobalMetadataEqual(ClusterMetadataManifest first, ClusterMetadataManifest second, String clusterName) {
        Metadata secondGlobalMetadata = this.getGlobalMetadata(clusterName, second.getClusterUUID(), second);
        Metadata firstGlobalMetadata = this.getGlobalMetadata(clusterName, first.getClusterUUID(), first);
        return Metadata.isGlobalResourcesMetadataEquals(firstGlobalMetadata, secondGlobalMetadata);
    }

    private boolean isValidClusterUUID(ClusterMetadataManifest manifest) {
        return manifest.isClusterUUIDCommitted();
    }

    private List<BlobMetadata> getManifestFileNames(String clusterName, String clusterUUID, int limit) throws IllegalStateException {
        try {
            return this.manifestContainer(clusterName, clusterUUID).listBlobsByPrefixInSortedOrder("manifest__", limit, BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while fetching latest manifest file for remote cluster state", e);
        }
    }

    private Optional<String> getLatestManifestFileName(String clusterName, String clusterUUID) throws IllegalStateException {
        List<BlobMetadata> manifestFilesMetadata = this.getManifestFileNames(clusterName, clusterUUID, 1);
        if (manifestFilesMetadata != null && !manifestFilesMetadata.isEmpty()) {
            return Optional.of(manifestFilesMetadata.get(0).name());
        }
        logger.info("No manifest file present in remote store for cluster name: {}, cluster UUID: {}", (Object)clusterName, (Object)clusterUUID);
        return Optional.empty();
    }

    private ClusterMetadataManifest fetchRemoteClusterMetadataManifest(String clusterName, String clusterUUID, String filename) throws IllegalStateException {
        try {
            return this.getClusterMetadataManifestBlobStoreFormat(filename).read(this.manifestContainer(clusterName, clusterUUID), filename, this.blobStoreRepository.getNamedXContentRegistry());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading cluster metadata - %s", filename), e);
        }
    }

    private ChecksumBlobStoreFormat<ClusterMetadataManifest> getClusterMetadataManifestBlobStoreFormat(String fileName) {
        long codecVersion = this.getManifestCodecVersion(fileName);
        if (codecVersion == 1L) {
            return CLUSTER_METADATA_MANIFEST_FORMAT;
        }
        if (codecVersion == 0L) {
            return CLUSTER_METADATA_MANIFEST_FORMAT_V0;
        }
        throw new IllegalArgumentException("Cluster metadata manifest file is corrupted, don't have valid codec version");
    }

    private int getManifestCodecVersion(String fileName) {
        String[] splitName = fileName.split(DELIMITER);
        if (splitName.length == 6) {
            return Integer.parseInt(splitName[splitName.length - 1]);
        }
        if (splitName.length < 6) {
            return 0;
        }
        throw new IllegalArgumentException("Manifest file name is corrupted");
    }

    public static String encodeString(String content) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(content.getBytes(StandardCharsets.UTF_8));
    }

    public void writeMetadataFailed() {
        this.getStats().stateFailed();
    }

    void deleteStaleUUIDsClusterMetadata(String clusterName, List<String> clusterUUIDs) {
        clusterUUIDs.forEach(clusterUUID -> this.getBlobStoreTransferService().deleteAsync("remote_purge", this.getCusterMetadataBasePath(clusterName, (String)clusterUUID), new ActionListener<Void>(){

            public void onResponse(Void unused) {
                logger.info("Deleted all remote cluster metadata for cluster UUID - {}", (Object)clusterUUID);
            }

            public void onFailure(Exception e) {
                logger.error((Message)new ParameterizedMessage("Exception occurred while deleting all remote cluster metadata for cluster UUID {}", (Object)clusterUUID), (Throwable)e);
                RemoteClusterStateService.this.remoteStateStats.cleanUpAttemptFailed();
            }
        }));
    }

    void deleteStaleClusterMetadata(final String clusterName, final String clusterUUID, final int manifestsToRetain) {
        if (!this.deleteStaleMetadataRunning.compareAndSet(false, true)) {
            logger.info("Delete stale cluster metadata task is already in progress.");
            return;
        }
        try {
            this.getBlobStoreTransferService().listAllInSortedOrderAsync("remote_purge", this.getManifestFolderPath(clusterName, clusterUUID), "manifest", Integer.MAX_VALUE, new ActionListener<List<BlobMetadata>>(){

                public void onResponse(List<BlobMetadata> blobMetadata) {
                    if (blobMetadata.size() > manifestsToRetain) {
                        RemoteClusterStateService.this.deleteClusterMetadata(clusterName, clusterUUID, blobMetadata.subList(0, manifestsToRetain - 1), blobMetadata.subList(manifestsToRetain - 1, blobMetadata.size()));
                    }
                    RemoteClusterStateService.this.deleteStaleMetadataRunning.set(false);
                }

                public void onFailure(Exception e) {
                    logger.error((Message)new ParameterizedMessage("Exception occurred while deleting Remote Cluster Metadata for clusterUUIDs {}", (Object)clusterUUID));
                    RemoteClusterStateService.this.deleteStaleMetadataRunning.set(false);
                }
            });
        }
        catch (Exception e) {
            this.deleteStaleMetadataRunning.set(false);
            throw e;
        }
    }

    private void deleteClusterMetadata(String clusterName, String clusterUUID, List<BlobMetadata> activeManifestBlobMetadata, List<BlobMetadata> staleManifestBlobMetadata) {
        try {
            HashSet filesToKeep = new HashSet();
            HashSet staleManifestPaths = new HashSet();
            HashSet staleIndexMetadataPaths = new HashSet();
            HashSet staleGlobalMetadataPaths = new HashSet();
            activeManifestBlobMetadata.forEach(blobMetadata -> {
                ClusterMetadataManifest clusterMetadataManifest = this.fetchRemoteClusterMetadataManifest(clusterName, clusterUUID, blobMetadata.name());
                clusterMetadataManifest.getIndices().forEach(uploadedIndexMetadata -> filesToKeep.add(uploadedIndexMetadata.getUploadedFilename()));
                filesToKeep.add(clusterMetadataManifest.getGlobalMetadataFileName());
            });
            staleManifestBlobMetadata.forEach(blobMetadata -> {
                ClusterMetadataManifest clusterMetadataManifest = this.fetchRemoteClusterMetadataManifest(clusterName, clusterUUID, blobMetadata.name());
                staleManifestPaths.add(new BlobPath().add("manifest").buildAsString() + blobMetadata.name());
                if (!filesToKeep.contains(clusterMetadataManifest.getGlobalMetadataFileName())) {
                    String[] globalMetadataSplitPath = clusterMetadataManifest.getGlobalMetadataFileName().split("/");
                    staleGlobalMetadataPaths.add(new BlobPath().add(GLOBAL_METADATA_PATH_TOKEN).buildAsString() + GLOBAL_METADATA_FORMAT.blobName(globalMetadataSplitPath[globalMetadataSplitPath.length - 1]));
                }
                clusterMetadataManifest.getIndices().forEach(uploadedIndexMetadata -> {
                    if (!filesToKeep.contains(uploadedIndexMetadata.getUploadedFilename())) {
                        staleIndexMetadataPaths.add(new BlobPath().add(INDEX_PATH_TOKEN).add(uploadedIndexMetadata.getIndexUUID()).buildAsString() + INDEX_METADATA_FORMAT.blobName(uploadedIndexMetadata.getUploadedFilename()));
                    }
                });
            });
            if (staleManifestPaths.isEmpty()) {
                logger.debug("No stale Remote Cluster Metadata files found");
                return;
            }
            this.deleteStalePaths(clusterName, clusterUUID, new ArrayList<String>(staleGlobalMetadataPaths));
            this.deleteStalePaths(clusterName, clusterUUID, new ArrayList<String>(staleIndexMetadataPaths));
            this.deleteStalePaths(clusterName, clusterUUID, new ArrayList<String>(staleManifestPaths));
        }
        catch (IllegalStateException e) {
            logger.error("Error while fetching Remote Cluster Metadata manifests", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error while deleting stale Remote Cluster Metadata files", (Throwable)e);
            this.remoteStateStats.cleanUpAttemptFailed();
        }
        catch (Exception e) {
            logger.error("Unexpected error while deleting stale Remote Cluster Metadata files", (Throwable)e);
            this.remoteStateStats.cleanUpAttemptFailed();
        }
    }

    private void deleteStalePaths(String clusterName, String clusterUUID, List<String> stalePaths) throws IOException {
        logger.debug(String.format(Locale.ROOT, "Deleting stale files from remote - %s", stalePaths));
        this.getBlobStoreTransferService().deleteBlobs(this.getCusterMetadataBasePath(clusterName, clusterUUID), stalePaths);
    }

    public void deleteStaleClusterUUIDs(ClusterState clusterState, ClusterMetadataManifest committedManifest) {
        this.threadpool.executor("remote_purge").execute(() -> {
            HashSet<String> allClustersUUIDsInRemote;
            String clusterName = clusterState.getClusterName().value();
            logger.debug("Deleting stale cluster UUIDs data from remote [{}]", (Object)clusterName);
            try {
                allClustersUUIDsInRemote = new HashSet<String>(this.getAllClusterUUIDs(clusterState.getClusterName().value()));
            }
            catch (IOException e) {
                logger.info(String.format(Locale.ROOT, "Error while fetching all cluster UUIDs for [%s]", clusterName));
                return;
            }
            allClustersUUIDsInRemote.remove(committedManifest.getClusterUUID());
            allClustersUUIDsInRemote.remove(committedManifest.getPreviousClusterUUID());
            this.deleteStaleUUIDsClusterMetadata(clusterName, new ArrayList<String>(allClustersUUIDsInRemote));
        });
    }

    public RemotePersistenceStats getStats() {
        return this.remoteStateStats;
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("context_mode", Metadata.CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
    }

    public static class RemoteStateTransferException
    extends RuntimeException {
        public RemoteStateTransferException(String errorDesc) {
            super(errorDesc);
        }

        public RemoteStateTransferException(String errorDesc, Throwable cause) {
            super(errorDesc, cause);
        }
    }
}

