/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.script.Script;

@PublicApi(since="2.14.0")
public class DerivedField
implements Writeable,
ToXContentFragment {
    private final String name;
    private final String type;
    private final Script script;

    public DerivedField(String name, String type, Script script) {
        this.name = name;
        this.type = type;
        this.script = script;
    }

    public DerivedField(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.script = new Script(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        this.script.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field("type", this.type);
        builder.field("script", (ToXContent)this.script);
        builder.endObject();
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Script getScript() {
        return this.script;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.script);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DerivedField other = (DerivedField)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.script, other.script);
    }
}

