/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.IndexableField;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.DerivedField;
import org.opensearch.index.mapper.DerivedFieldSupportedTypes;
import org.opensearch.index.mapper.DerivedFieldType;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.script.Script;

public class DerivedFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "derived";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final String type;
    private final Script script;

    private static DerivedFieldMapper toType(FieldMapper in) {
        return (DerivedFieldMapper)in;
    }

    protected DerivedFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.type = builder.type.getValue();
        this.script = builder.script.getValue();
    }

    @Override
    public DerivedFieldType fieldType() {
        return (DerivedFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new UnsupportedOperationException("should not be invoked");
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        this.getMergeBuilder().toXContent(builder, includeDefaults);
        this.multiFields.toXContent(builder, params);
        this.copyTo.toXContent(builder, params);
    }

    public String getType() {
        return this.type;
    }

    public Script getScript() {
        return this.script;
    }

    public static Map<String, DerivedFieldType> getAllDerivedFieldTypeFromObject(Map<String, Object> derivedFieldObject, MapperService mapperService) {
        HashMap<String, DerivedFieldType> derivedFieldTypes = new HashMap<String, DerivedFieldType>();
        DocumentMapper documentMapper = mapperService.documentMapperParser().parse(CONTENT_TYPE, derivedFieldObject);
        if (documentMapper != null && documentMapper.mappers() != null) {
            for (Mapper mapper : documentMapper.mappers()) {
                if (!(mapper instanceof DerivedFieldMapper)) continue;
                DerivedFieldType derivedFieldType = ((DerivedFieldMapper)mapper).fieldType();
                derivedFieldTypes.put(derivedFieldType.name(), derivedFieldType);
            }
        }
        return derivedFieldTypes;
    }

    public static DerivedFieldType getDerivedFieldType(DerivedField derivedField, MapperService mapperService) {
        Mapper.BuilderContext builderContext = new Mapper.BuilderContext(mapperService.getIndexSettings().getSettings(), new ContentPath(1));
        Builder builder = new Builder(derivedField);
        return builder.build(builderContext).fieldType();
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<String> type = ParametrizedFieldMapper.Parameter.stringParam("type", false, m -> DerivedFieldMapper.toType((FieldMapper)m).type, "");
        private final ParametrizedFieldMapper.Parameter<Script> script = new ParametrizedFieldMapper.Parameter<Script>("script", false, () -> null, (n, c, o) -> o == null ? null : Script.parse(o), m -> DerivedFieldMapper.toType((FieldMapper)m).script).setSerializerCheck((id, ic, value) -> value != null);

        public Builder(String name) {
            super(name);
        }

        public Builder(DerivedField derivedField) {
            super(derivedField.getName());
            this.type.setValue(derivedField.getType());
            this.script.setValue(derivedField.getScript());
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.type, this.script);
        }

        @Override
        public DerivedFieldMapper build(Mapper.BuilderContext context) {
            FieldMapper fieldMapper = DerivedFieldSupportedTypes.getFieldMapperFromType(this.type.getValue(), this.name, context);
            Function<Object, IndexableField> fieldFunction = DerivedFieldSupportedTypes.getIndexableFieldGeneratorType(this.type.getValue(), this.name);
            DerivedFieldType ft = new DerivedFieldType(new DerivedField(this.buildFullName(context), this.type.getValue(), this.script.getValue()), fieldMapper, fieldFunction);
            return new DerivedFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }
}

