/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.KeywordField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.opensearch.Version;
import org.opensearch.common.Booleans;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.network.InetAddresses;
import org.opensearch.index.mapper.BooleanFieldMapper;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.GeoPointFieldMapper;
import org.opensearch.index.mapper.IpFieldMapper;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.NumberFieldMapper;

public enum DerivedFieldSupportedTypes {
    BOOLEAN("boolean", (name, context) -> {
        BooleanFieldMapper.Builder builder = new BooleanFieldMapper.Builder((String)name);
        return builder.build((Mapper.BuilderContext)context);
    }, name -> o -> {
        Boolean value;
        if (o instanceof Boolean) {
            value = (Boolean)o;
        } else {
            String textValue = o.toString();
            value = Booleans.parseBooleanStrict((String)textValue, (boolean)false);
        }
        return new Field(name, (CharSequence)(value != false ? "T" : "F"), (IndexableFieldType)BooleanFieldMapper.Defaults.FIELD_TYPE);
    }, o -> o),
    DATE("date", (name, context) -> {
        DateFieldMapper.Builder builder = new DateFieldMapper.Builder((String)name, DateFieldMapper.Resolution.MILLISECONDS, DateFieldMapper.getDefaultDateTimeFormatter(), false, Version.CURRENT);
        return builder.build((Mapper.BuilderContext)context);
    }, name -> o -> new LongPoint(name, new long[]{(Long)o}), o -> DateFieldMapper.getDefaultDateTimeFormatter().formatMillis((Long)o)),
    GEO_POINT("geo_point", (name, context) -> {
        GeoPointFieldMapper.Builder builder = new GeoPointFieldMapper.Builder((String)name);
        return builder.build((Mapper.BuilderContext)context);
    }, name -> o -> {
        if (!(o instanceof Tuple) || !(((Tuple)o).v1() instanceof Double) && ((Tuple)o).v2() instanceof Double) {
            throw new ClassCastException("geo_point should be in format emit(double lat, double lon) for derived fields");
        }
        return new LatLonPoint(name, ((Double)((Tuple)o).v1()).doubleValue(), ((Double)((Tuple)o).v2()).doubleValue());
    }, o -> new GeoPoint((Double)((Tuple)o).v1(), (Double)((Tuple)o).v2())),
    IP("ip", (name, context) -> {
        IpFieldMapper.Builder builder = new IpFieldMapper.Builder((String)name, false, Version.CURRENT);
        return builder.build((Mapper.BuilderContext)context);
    }, name -> o -> {
        InetAddress address = o instanceof InetAddress ? (InetAddress)o : InetAddresses.forString((String)o.toString());
        return new InetAddressPoint(name, address);
    }, o -> o),
    KEYWORD("keyword", (name, context) -> {
        FieldType dummyFieldType = new FieldType();
        dummyFieldType.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
        KeywordFieldMapper.Builder keywordBuilder = new KeywordFieldMapper.Builder((String)name);
        KeywordFieldMapper.KeywordFieldType keywordFieldType = keywordBuilder.buildFieldType((Mapper.BuilderContext)context, dummyFieldType);
        keywordFieldType.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        return new KeywordFieldMapper((String)name, dummyFieldType, keywordFieldType, keywordBuilder.multiFieldsBuilder.build(keywordBuilder, (Mapper.BuilderContext)context), keywordBuilder.copyTo.build(), keywordBuilder);
    }, name -> o -> new KeywordField(name, (String)o, Field.Store.NO), o -> o),
    LONG("long", (name, context) -> {
        NumberFieldMapper.Builder longBuilder = new NumberFieldMapper.Builder((String)name, NumberFieldMapper.NumberType.LONG, false, false);
        return longBuilder.build((Mapper.BuilderContext)context);
    }, name -> o -> new LongField(name, Long.parseLong(o.toString()), Field.Store.NO), o -> o),
    DOUBLE("double", (name, context) -> {
        NumberFieldMapper.Builder doubleBuilder = new NumberFieldMapper.Builder((String)name, NumberFieldMapper.NumberType.DOUBLE, false, false);
        return doubleBuilder.build((Mapper.BuilderContext)context);
    }, name -> o -> new DoubleField(name, Double.parseDouble(o.toString()), Field.Store.NO), o -> o);

    final String name;
    private final BiFunction<String, Mapper.BuilderContext, FieldMapper> builder;
    private final Function<String, Function<Object, IndexableField>> indexableFieldBuilder;
    private final Function<Object, Object> valueForDisplay;
    private static final Map<String, DerivedFieldSupportedTypes> enumMap;

    private DerivedFieldSupportedTypes(String name, BiFunction<String, Mapper.BuilderContext, FieldMapper> builder, Function<String, Function<Object, IndexableField>> indexableFieldBuilder, Function<Object, Object> valueForDisplay) {
        this.name = name;
        this.builder = builder;
        this.indexableFieldBuilder = indexableFieldBuilder;
        this.valueForDisplay = valueForDisplay;
    }

    public String getName() {
        return this.name;
    }

    private FieldMapper getFieldMapper(String name, Mapper.BuilderContext context) {
        return this.builder.apply(name, context);
    }

    private Function<Object, IndexableField> getIndexableFieldGenerator(String name) {
        return this.indexableFieldBuilder.apply(name);
    }

    private Function<Object, Object> getValueForDisplayGenerator() {
        return this.valueForDisplay;
    }

    public static FieldMapper getFieldMapperFromType(String type, String name, Mapper.BuilderContext context) {
        if (!enumMap.containsKey(type)) {
            throw new IllegalArgumentException("Type [" + type + "] isn't supported in Derived field context.");
        }
        return enumMap.get(type).getFieldMapper(name, context);
    }

    public static Function<Object, IndexableField> getIndexableFieldGeneratorType(String type, String name) {
        if (!enumMap.containsKey(type)) {
            throw new IllegalArgumentException("Type [" + type + "] isn't supported in Derived field context.");
        }
        return enumMap.get(type).getIndexableFieldGenerator(name);
    }

    public static Function<Object, Object> getValueForDisplayGenerator(String type) {
        if (!enumMap.containsKey(type)) {
            throw new IllegalArgumentException("Type [" + type + "] isn't supported in Derived field context.");
        }
        return enumMap.get(type).getValueForDisplayGenerator();
    }

    static {
        enumMap = Arrays.stream(DerivedFieldSupportedTypes.values()).collect(Collectors.toMap(DerivedFieldSupportedTypes::getName, enumValue -> enumValue));
    }
}

