/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.Nullable;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.common.time.DateMathParser;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.geometry.Geometry;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.DerivedField;
import org.opensearch.index.mapper.DerivedFieldSupportedTypes;
import org.opensearch.index.mapper.DerivedFieldValueFetcher;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.GeoShapeQueryable;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.DerivedFieldQuery;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.script.DerivedFieldScript;
import org.opensearch.search.lookup.SearchLookup;

public final class DerivedFieldType
extends MappedFieldType
implements GeoShapeQueryable {
    private final DerivedField derivedField;
    FieldMapper typeFieldMapper;
    final Function<Object, IndexableField> indexableFieldGenerator;

    public DerivedFieldType(DerivedField derivedField, boolean isIndexed, boolean isStored, boolean hasDocValues, Map<String, String> meta, FieldMapper typeFieldMapper, Function<Object, IndexableField> fieldFunction) {
        super(derivedField.getName(), isIndexed, isStored, hasDocValues, typeFieldMapper.fieldType().getTextSearchInfo(), meta);
        this.derivedField = derivedField;
        this.typeFieldMapper = typeFieldMapper;
        this.indexableFieldGenerator = fieldFunction;
    }

    public DerivedFieldType(DerivedField derivedField, FieldMapper typeFieldMapper, Function<Object, IndexableField> fieldFunction) {
        this(derivedField, false, false, false, Collections.emptyMap(), typeFieldMapper, fieldFunction);
    }

    @Override
    public String typeName() {
        return "derived";
    }

    public String getType() {
        return this.derivedField.getType();
    }

    public MappedFieldType getTypeMappedFieldType() {
        return this.typeFieldMapper.mappedFieldType;
    }

    public NamedAnalyzer getIndexAnalyzer() {
        return this.typeFieldMapper.mappedFieldType.indexAnalyzer();
    }

    @Override
    public DerivedFieldValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
        }
        Function<Object, Object> valueForDisplay = DerivedFieldSupportedTypes.getValueForDisplayGenerator(this.getType());
        return new DerivedFieldValueFetcher(this.getDerivedFieldLeafFactory(context, searchLookup == null ? context.lookup() : searchLookup), valueForDisplay, this.indexableFieldGenerator);
    }

    @Override
    public Query termQuery(Object value, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.termQuery(value, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query termQueryCaseInsensitive(Object value, @Nullable QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.termQueryCaseInsensitive(value, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.termsQuery(values, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, relation, timeZone, parser, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, method, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.prefixQuery(value, method, caseInsensitive, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.wildcardQuery(value, method, caseInsensitive, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query normalizedWildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.normalizedWildcardQuery(value, method, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.regexpQuery(value, syntaxFlags, matchFlags, maxDeterminizedStates, method, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, QueryShardContext context) throws IOException {
        Query query = this.typeFieldMapper.mappedFieldType.phraseQuery(stream, slop, enablePositionIncrements, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, QueryShardContext context) throws IOException {
        Query query = this.typeFieldMapper.mappedFieldType.multiPhraseQuery(stream, slop, enablePositionIncrements, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, QueryShardContext context) throws IOException {
        Query query = this.typeFieldMapper.mappedFieldType.phrasePrefixQuery(stream, slop, maxExpansions, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
        throw new IllegalArgumentException("Can only use span prefix queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    @Override
    public Query distanceFeatureQuery(Object origin, String pivot, float boost, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.distanceFeatureQuery(origin, pivot, boost, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        Query query = ((GeoShapeQueryable)((Object)this.typeFieldMapper.mappedFieldType)).geoShapeQuery(shape, fieldName, relation, context);
        DerivedFieldValueFetcher valueFetcher = this.valueFetcher(context, context.lookup(), null);
        return new DerivedFieldQuery(query, valueFetcher, context.lookup(), (Analyzer)this.getIndexAnalyzer());
    }

    @Override
    public Query existsQuery(QueryShardContext context) {
        throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support exist queries");
    }

    @Override
    public boolean isAggregatable() {
        return false;
    }

    private DerivedFieldScript.LeafFactory getDerivedFieldLeafFactory(QueryShardContext context, SearchLookup searchLookup) {
        if (!context.documentMapper("").sourceMapper().enabled()) {
            throw new IllegalArgumentException("DerivedFieldQuery error: unable to fetch fields from _source field: _source is disabled in the mappings for index [" + context.index().getName() + "]");
        }
        DerivedFieldScript.Factory factory = context.compile(this.derivedField.getScript(), DerivedFieldScript.CONTEXT);
        return factory.newFactory(this.derivedField.getScript().getParams(), searchLookup);
    }
}

