/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.script.DerivedFieldScript;
import org.opensearch.search.lookup.SourceLookup;

@PublicApi(since="2.14.0")
public final class DerivedFieldValueFetcher
implements ValueFetcher {
    private DerivedFieldScript derivedFieldScript;
    private final DerivedFieldScript.LeafFactory derivedFieldScriptFactory;
    private final Function<Object, Object> valueForDisplay;
    private final Function<Object, IndexableField> indexableFieldFunction;

    public DerivedFieldValueFetcher(DerivedFieldScript.LeafFactory derivedFieldScriptFactory, Function<Object, Object> valueForDisplay, Function<Object, IndexableField> indexableFieldFunction) {
        this.derivedFieldScriptFactory = derivedFieldScriptFactory;
        this.valueForDisplay = valueForDisplay;
        this.indexableFieldFunction = indexableFieldFunction;
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) {
        List<Object> values = this.fetchValuesInternal(lookup);
        if (values.isEmpty()) {
            return values;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object v : values) {
            result.add(this.valueForDisplay.apply(v));
        }
        return result;
    }

    private List<Object> fetchValuesInternal(SourceLookup lookup) {
        this.derivedFieldScript.setDocument(lookup.docId());
        this.derivedFieldScript.execute();
        return this.derivedFieldScript.getEmittedValues();
    }

    public List<IndexableField> getIndexableField(SourceLookup lookup) {
        List<Object> values = this.fetchValuesInternal(lookup);
        ArrayList<IndexableField> indexableFields = new ArrayList<IndexableField>();
        for (Object v : values) {
            indexableFields.add(this.indexableFieldFunction.apply(v));
        }
        return indexableFields;
    }

    @Override
    public void setNextReader(LeafReaderContext context) {
        try {
            this.derivedFieldScript = this.derivedFieldScriptFactory.newInstance(context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

