/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentContraints;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.Assertions;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.AbstractIndexComponent;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.index.analysis.CharFilterFactory;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.analysis.ReloadableCustomAnalyzer;
import org.opensearch.index.analysis.TokenFilterFactory;
import org.opensearch.index.analysis.TokenizerFactory;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.DocumentMapperForType;
import org.opensearch.index.mapper.DocumentMapperParser;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.indices.InvalidTypeNameException;
import org.opensearch.indices.mapper.MapperRegistry;
import org.opensearch.script.ScriptService;

@PublicApi(since="1.0.0")
public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String SINGLE_MAPPING_NAME = "_doc";
    public static final Setting<Long> INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_fields.limit", 50L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_objects.limit", 10000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Integer.MAX_VALUE, limit -> {
        if (limit > (long)XContentContraints.DEFAULT_MAX_DEPTH) {
            throw new IllegalArgumentException("The provided value " + limit + " of the index setting 'index.mapping.depth.limit' exceeds per-JVM configured limit of " + XContentContraints.DEFAULT_MAX_DEPTH + ". Please change the setting value or increase per-JVM limit using 'opensearch.xcontent.depth.max' system property.");
        }
    }, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING = Setting.longSetting("index.mapping.field_name_length.limit", Integer.MAX_VALUE, 1L, Integer.MAX_VALUE, limit -> {
        if (limit > (long)XContentContraints.DEFAULT_MAX_NAME_LEN) {
            throw new IllegalArgumentException("The provided value " + limit + " of the index setting 'index.mapping.field_name_length.limit' exceeds per-JVM configured limit of " + XContentContraints.DEFAULT_MAX_NAME_LEN + ". Please change the setting value or increase per-JVM limit using 'opensearch.xcontent.name.length.max' system property.");
        }
    }, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final boolean INDEX_MAPPER_DYNAMIC_DEFAULT = true;
    @Deprecated
    public static final Setting<Boolean> INDEX_MAPPER_DYNAMIC_SETTING = Setting.boolSetting("index.mapper.dynamic", true, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated);
    @Deprecated
    public static final Set<String> META_FIELDS_BEFORE_7DOT8 = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_id", "_ignored", "_index", "_routing", "_size", "_timestamp", "_ttl", "_type")));
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(MapperService.class);
    private final IndexAnalyzers indexAnalyzers;
    private volatile DocumentMapper mapper;
    private final DocumentMapperParser documentParser;
    private final Version indexVersionCreated;
    private final MapperAnalyzerWrapper indexAnalyzer;
    private final MapperAnalyzerWrapper searchAnalyzer;
    private final MapperAnalyzerWrapper searchQuoteAnalyzer;
    private volatile Map<String, MappedFieldType> unmappedFieldTypes = Collections.emptyMap();
    final MapperRegistry mapperRegistry;
    private final BooleanSupplier idFieldDataEnabled;

    public MapperService(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<QueryShardContext> queryShardContextSupplier, BooleanSupplier idFieldDataEnabled, ScriptService scriptService) {
        super(indexSettings);
        this.indexVersionCreated = indexSettings.getIndexVersionCreated();
        this.indexAnalyzers = indexAnalyzers;
        this.documentParser = new DocumentMapperParser(indexSettings, this, xContentRegistry, similarityService, mapperRegistry, queryShardContextSupplier, scriptService);
        this.indexAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultIndexAnalyzer(), MappedFieldType::indexAnalyzer);
        this.searchAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultSearchAnalyzer(), p -> p.getTextSearchInfo().getSearchAnalyzer());
        this.searchQuoteAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultSearchQuoteAnalyzer(), p -> p.getTextSearchInfo().getSearchQuoteAnalyzer());
        this.mapperRegistry = mapperRegistry;
        this.idFieldDataEnabled = idFieldDataEnabled;
        if (INDEX_MAPPER_DYNAMIC_SETTING.exists(indexSettings.getSettings()) && indexSettings.getIndexVersionCreated().onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            throw new IllegalArgumentException("Setting " + INDEX_MAPPER_DYNAMIC_SETTING.getKey() + " was removed after version 6.0.0");
        }
    }

    public boolean hasNested() {
        return this.mapper != null && this.mapper.hasNestedObjects();
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public NamedAnalyzer getNamedAnalyzer(String analyzerName) {
        return this.indexAnalyzers.get(analyzerName);
    }

    public DocumentMapperParser documentMapperParser() {
        return this.documentParser;
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, String mappingSource) throws IOException {
        try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mappingSource);){
            Map map = parser.map();
            return map;
        }
    }

    public boolean updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) throws IOException {
        Map<String, DocumentMapper> updatedEntries;
        assert (newIndexMetadata.getIndex().equals((Object)this.index())) : "index mismatch: expected " + this.index() + " but was " + newIndexMetadata.getIndex();
        if (currentIndexMetadata != null && currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
            this.assertMappingVersion(currentIndexMetadata, newIndexMetadata, Collections.emptyMap());
            return false;
        }
        HashSet<String> existingMappers = new HashSet<String>();
        if (this.mapper != null) {
            existingMappers.add(this.mapper.type());
        }
        try {
            updatedEntries = this.internalMerge(newIndexMetadata, MergeReason.MAPPING_RECOVERY);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to apply mappings", (Object)this.index()), (Throwable)e);
            throw e;
        }
        boolean requireRefresh = false;
        this.assertMappingVersion(currentIndexMetadata, newIndexMetadata, updatedEntries);
        for (DocumentMapper documentMapper : updatedEntries.values()) {
            String op;
            String mappingType = documentMapper.type();
            MappingMetadata mappingMetadata = newIndexMetadata.mapping();
            assert (mappingType.equals(mappingMetadata.type()));
            CompressedXContent incomingMappingSource = mappingMetadata.source();
            String string = op = existingMappers.contains(mappingType) ? "updated" : "added";
            if (this.logger.isDebugEnabled() && incomingMappingSource.compressed().length < 512) {
                this.logger.debug("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
            } else {
                this.logger.debug("[{}] {} mapping [{}] (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op, (Object)mappingType);
            }
            if (this.documentMapper().mappingSource().equals(incomingMappingSource)) continue;
            this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", (Object)this.index(), (Object)mappingType, (Object)incomingMappingSource, (Object)this.documentMapper().mappingSource());
            requireRefresh = true;
        }
        return requireRefresh;
    }

    private void assertMappingVersion(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata, Map<String, DocumentMapper> updatedEntries) throws IOException {
        if (Assertions.ENABLED && currentIndexMetadata != null) {
            if (currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
                assert (updatedEntries.isEmpty()) : updatedEntries;
                MappingMetadata mapping = newIndexMetadata.mapping();
                if (mapping != null) {
                    CompressedXContent currentSource = currentIndexMetadata.mapping().source();
                    CompressedXContent newSource = mapping.source();
                    assert (currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + mapping.type() + "] to be the same as new mapping [" + newSource + "]";
                    CompressedXContent mapperSource = new CompressedXContent(Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this.mapper));
                    assert (currentSource.equals(mapperSource)) : "expected current mapping [" + currentSource + "] for type [" + mapping.type() + "] to be the same as new mapping [" + mapperSource + "]";
                }
            } else {
                long currentMappingVersion = currentIndexMetadata.getMappingVersion();
                long newMappingVersion = newIndexMetadata.getMappingVersion();
                assert (currentMappingVersion < newMappingVersion) : "expected current mapping version [" + currentMappingVersion + "] to be less than new mapping version [" + newMappingVersion + "]";
                assert (!updatedEntries.isEmpty());
                for (DocumentMapper documentMapper : updatedEntries.values()) {
                    MappingMetadata currentMapping = currentIndexMetadata.mapping();
                    assert (currentMapping == null || documentMapper.type().equals(currentMapping.type()));
                    if (currentMapping == null) continue;
                    CompressedXContent currentSource = currentMapping.source();
                    CompressedXContent newSource = documentMapper.mappingSource();
                    assert (!currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + documentMapper.type() + "] to be different than new mapping";
                }
            }
        }
    }

    public void merge(Map<String, Map<String, Object>> mappings, MergeReason reason) {
        LinkedHashMap<String, CompressedXContent> mappingSourcesCompressed = new LinkedHashMap<String, CompressedXContent>(mappings.size());
        for (Map.Entry<String, Map<String, Object>> entry : mappings.entrySet()) {
            try {
                mappingSourcesCompressed.put(entry.getKey(), new CompressedXContent(XContentFactory.jsonBuilder().map(entry.getValue()).toString()));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", e, entry.getKey(), e.getMessage());
            }
        }
        this.internalMerge(mappingSourcesCompressed, reason);
    }

    public void merge(String type, Map<String, Object> mappings, MergeReason reason) throws IOException {
        CompressedXContent content = new CompressedXContent(XContentFactory.jsonBuilder().map(mappings).toString());
        this.internalMerge(Collections.singletonMap(type, content), reason);
    }

    public void merge(IndexMetadata indexMetadata, MergeReason reason) {
        this.internalMerge(indexMetadata, reason);
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason) {
        return this.internalMerge(Collections.singletonMap(type, mappingSource), reason).values().iterator().next();
    }

    private synchronized Map<String, DocumentMapper> internalMerge(IndexMetadata indexMetadata, MergeReason reason) {
        assert (reason != MergeReason.MAPPING_UPDATE_PREFLIGHT);
        LinkedHashMap<String, CompressedXContent> map = new LinkedHashMap<String, CompressedXContent>();
        MappingMetadata mappingMetadata = indexMetadata.mapping();
        if (mappingMetadata != null) {
            map.put(mappingMetadata.type(), mappingMetadata.source());
        }
        return this.internalMerge(map, reason);
    }

    private synchronized Map<String, DocumentMapper> internalMerge(Map<String, CompressedXContent> mappings, MergeReason reason) {
        DocumentMapper documentMapper = null;
        for (Map.Entry<String, CompressedXContent> entry : mappings.entrySet()) {
            String type = entry.getKey();
            if (documentMapper != null) {
                throw new IllegalArgumentException("Cannot put multiple mappings: " + mappings.keySet());
            }
            try {
                documentMapper = this.documentParser.parse(type, entry.getValue());
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", e, entry.getKey(), e.getMessage());
            }
        }
        return this.internalMerge(documentMapper, reason);
    }

    static void validateTypeName(String type) {
        if (type.length() == 0) {
            throw new InvalidTypeNameException("mapping type name is empty");
        }
        if (type.length() > 255) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] is too long; limit is length 255 but was [" + type.length() + "]");
        }
        if (type.charAt(0) == '_' && !SINGLE_MAPPING_NAME.equals(type)) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] can't start with '_' unless it is called [_doc]");
        }
        if (type.contains("#")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include '#' in it");
        }
        if (type.contains(",")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include ',' in it");
        }
        if (type.charAt(0) == '.') {
            throw new IllegalArgumentException("mapping type name [" + type + "] must not start with a '.'");
        }
    }

    private synchronized Map<String, DocumentMapper> internalMerge(DocumentMapper mapper, MergeReason reason) {
        LinkedHashMap<String, DocumentMapper> results = new LinkedHashMap(2);
        DocumentMapper newMapper = null;
        if (mapper != null) {
            MapperService.validateTypeName(mapper.type());
            DocumentMapper oldMapper = this.mapper;
            newMapper = oldMapper != null ? oldMapper.merge(mapper.mapping(), reason) : mapper;
            newMapper.root().fixRedundantIncludes();
            newMapper.validate(this.indexSettings, reason != MergeReason.MAPPING_RECOVERY);
            results.put(newMapper.type(), newMapper);
        }
        results = Collections.unmodifiableMap(results);
        if (reason == MergeReason.MAPPING_UPDATE_PREFLIGHT) {
            return results;
        }
        if (newMapper != null) {
            this.mapper = newMapper;
        }
        assert (results.values().stream().allMatch(this::assertSerialization));
        return results;
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        DocumentMapper newMapper = this.parse(mapper.type(), mappingSource);
        if (!newMapper.mappingSource().equals(mappingSource)) {
            throw new IllegalStateException("DocumentMapper serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapper.mappingSource() + "]");
        }
        return true;
    }

    public DocumentMapper parse(String mappingType, CompressedXContent mappingSource) throws MapperParsingException {
        return this.documentParser.parse(mappingType, mappingSource);
    }

    public DocumentMapper documentMapper() {
        return this.mapper;
    }

    public static boolean isMappingSourceTyped(String type, Map<String, Object> mapping) {
        return mapping.size() == 1 && mapping.keySet().iterator().next().equals(type);
    }

    public static boolean isMappingSourceTyped(String type, CompressedXContent mappingSource) {
        Map root = (Map)XContentHelper.convertToMap(mappingSource.compressedReference(), true, MediaTypeRegistry.JSON).v2();
        return MapperService.isMappingSourceTyped(type, root);
    }

    public String resolveDocumentType(String type) {
        if (SINGLE_MAPPING_NAME.equals(type) && this.mapper != null) {
            return this.mapper.type();
        }
        return type;
    }

    public DocumentMapperForType documentMapperWithAutoCreate() {
        DocumentMapper mapper = this.documentMapper();
        if (mapper != null) {
            return new DocumentMapperForType(mapper, null);
        }
        mapper = this.parse(SINGLE_MAPPING_NAME, null);
        return new DocumentMapperForType(mapper, mapper.mapping());
    }

    public MappedFieldType fieldType(String fullName) {
        return this.mapper == null ? null : this.mapper.fieldTypes().get(fullName);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singleton(pattern);
        }
        return this.mapper == null ? Collections.emptySet() : this.mapper.fieldTypes().simpleMatchToFullName(pattern);
    }

    public Set<String> sourcePath(String fullName) {
        return this.mapper == null ? Collections.emptySet() : this.mapper.fieldTypes().sourcePaths(fullName);
    }

    public Iterable<MappedFieldType> fieldTypes() {
        return this.mapper == null ? Collections.emptySet() : this.mapper.fieldTypes();
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.mapper == null ? null : this.mapper.objectMappers().get(name);
    }

    public MappedFieldType unmappedFieldType(String type) {
        MappedFieldType fieldType;
        if (type.equals("string")) {
            deprecationLogger.deprecate("unmapped_type_string", "[unmapped_type:string] should be replaced with [unmapped_type:keyword]", new Object[0]);
            type = "keyword";
        }
        if ((fieldType = this.unmappedFieldTypes.get(type)) == null) {
            Mapper.TypeParser.ParserContext parserContext = this.documentMapperParser().parserContext();
            Mapper.TypeParser typeParser = parserContext.typeParser(type);
            if (typeParser == null) {
                throw new IllegalArgumentException("No mapper found for type [" + type + "]");
            }
            Mapper.Builder<?> builder = typeParser.parse("__anonymous_" + type, Collections.emptyMap(), parserContext);
            Mapper.BuilderContext builderContext = new Mapper.BuilderContext(this.indexSettings.getSettings(), new ContentPath(1));
            fieldType = ((FieldMapper)builder.build(builderContext)).fieldType();
            HashMap<String, MappedFieldType> newUnmappedFieldTypes = new HashMap<String, MappedFieldType>(this.unmappedFieldTypes);
            newUnmappedFieldTypes.put(type, fieldType);
            this.unmappedFieldTypes = Collections.unmodifiableMap(newUnmappedFieldTypes);
        }
        return fieldType;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    public boolean isIdFieldDataEnabled() {
        return this.idFieldDataEnabled.getAsBoolean();
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    public boolean isMetadataField(String field) {
        return this.mapperRegistry.isMetadataField(this.indexVersionCreated, field);
    }

    public synchronized List<String> reloadSearchAnalyzers(AnalysisRegistry registry) throws IOException {
        this.logger.info("reloading search analyzers");
        Map<String, TokenizerFactory> tokenizerFactories = registry.buildTokenizerFactories(this.indexSettings);
        Map<String, CharFilterFactory> charFilterFactories = registry.buildCharFilterFactories(this.indexSettings);
        Map<String, TokenFilterFactory> tokenFilterFactories = registry.buildTokenFilterFactories(this.indexSettings);
        Map<String, Settings> settings = this.indexSettings.getSettings().getGroups("index.analysis.analyzer");
        ArrayList<String> reloadedAnalyzers = new ArrayList<String>();
        for (NamedAnalyzer namedAnalyzer : this.indexAnalyzers.getAnalyzers().values()) {
            if (!(namedAnalyzer.analyzer() instanceof ReloadableCustomAnalyzer)) continue;
            ReloadableCustomAnalyzer analyzer = (ReloadableCustomAnalyzer)namedAnalyzer.analyzer();
            String analyzerName = namedAnalyzer.name();
            Settings analyzerSettings = settings.get(analyzerName);
            analyzer.reload(analyzerName, analyzerSettings, tokenizerFactories, charFilterFactories, tokenFilterFactories);
            reloadedAnalyzers.add(analyzerName);
        }
        return reloadedAnalyzers;
    }

    final class MapperAnalyzerWrapper
    extends DelegatingAnalyzerWrapper {
        private final Analyzer defaultAnalyzer;
        private final Function<MappedFieldType, Analyzer> extractAnalyzer;

        MapperAnalyzerWrapper(Analyzer defaultAnalyzer, Function<MappedFieldType, Analyzer> extractAnalyzer) {
            super(Analyzer.PER_FIELD_REUSE_STRATEGY);
            this.defaultAnalyzer = defaultAnalyzer;
            this.extractAnalyzer = extractAnalyzer;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer;
            MappedFieldType fieldType = MapperService.this.fieldType(fieldName);
            if (fieldType != null && (analyzer = this.extractAnalyzer.apply(fieldType)) != null) {
                return analyzer;
            }
            return this.defaultAnalyzer;
        }
    }

    @PublicApi(since="1.0.0")
    public static enum MergeReason {
        MAPPING_UPDATE_PREFLIGHT,
        MAPPING_UPDATE,
        INDEX_TEMPLATE,
        MAPPING_RECOVERY;

    }
}

