/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.opensearch.index.mapper.DerivedFieldValueFetcher;
import org.opensearch.search.lookup.LeafSearchLookup;
import org.opensearch.search.lookup.SearchLookup;

public final class DerivedFieldQuery
extends Query {
    private final Query query;
    private final DerivedFieldValueFetcher valueFetcher;
    private final SearchLookup searchLookup;
    private final Analyzer indexAnalyzer;

    public DerivedFieldQuery(Query query, DerivedFieldValueFetcher valueFetcher, SearchLookup searchLookup, Analyzer indexAnalyzer) {
        this.query = query;
        this.valueFetcher = valueFetcher;
        this.searchLookup = searchLookup;
        this.indexAnalyzer = indexAnalyzer;
    }

    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor);
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = indexSearcher.rewrite(this.query);
        if (rewritten == this.query) {
            return this;
        }
        return new DerivedFieldQuery(rewritten, this.valueFetcher, this.searchLookup, this.indexAnalyzer);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(final LeafReaderContext context) {
                DocIdSetIterator approximation = DocIdSetIterator.all((int)context.reader().maxDoc());
                DerivedFieldQuery.this.valueFetcher.setNextReader(context);
                final LeafSearchLookup leafSearchLookup = DerivedFieldQuery.this.searchLookup.getLeafSearchLookup(context);
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    public boolean matches() {
                        leafSearchLookup.source().setSegmentAndDocument(context, this.approximation.docID());
                        List<IndexableField> indexableFields = DerivedFieldQuery.this.valueFetcher.getIndexableField(leafSearchLookup.source());
                        MemoryIndex memoryIndex = new MemoryIndex();
                        for (IndexableField indexableField : indexableFields) {
                            memoryIndex.addField(indexableField, DerivedFieldQuery.this.indexAnalyzer);
                        }
                        float score = memoryIndex.search(DerivedFieldQuery.this.query);
                        return score > 0.0f;
                    }

                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        DerivedFieldQuery other = (DerivedFieldQuery)((Object)o);
        return Objects.equals(this.query, other.query) && Objects.equals(this.indexAnalyzer, other.indexAnalyzer);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.query, this.indexAnalyzer);
    }

    public String toString(String f) {
        return "DerivedFieldQuery (Query: [ " + this.query.toString(f) + "])";
    }
}

