/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.util.ArrayList;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.geo.GeoPolygonDecomposer;
import org.opensearch.common.geo.GeoShapeType;
import org.opensearch.common.geo.GeoShapeUtils;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.geometry.Circle;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.GeometryCollection;
import org.opensearch.geometry.GeometryVisitor;
import org.opensearch.geometry.Line;
import org.opensearch.geometry.LinearRing;
import org.opensearch.geometry.MultiLine;
import org.opensearch.geometry.MultiPoint;
import org.opensearch.geometry.MultiPolygon;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.Rectangle;
import org.opensearch.geometry.ShapeType;
import org.opensearch.index.mapper.DerivedFieldType;
import org.opensearch.index.mapper.GeoPointFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;

public class VectorGeoPointShapeQueryProcessor {
    public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        this.validateIsGeoPointFieldType(fieldName, context);
        if (relation != ShapeRelation.INTERSECTS) {
            throw new QueryShardException(context, relation + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    private void validateIsGeoPointFieldType(String fieldName, QueryShardContext context) {
        MappedFieldType fieldType = context.fieldMapper(fieldName);
        if (!(fieldType instanceof GeoPointFieldMapper.GeoPointFieldType || fieldType instanceof DerivedFieldType && ((DerivedFieldType)fieldType).getTypeMappedFieldType() instanceof GeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(context, "Expected geo_point field type for Field [" + fieldName + "] but found " + fieldType.typeName(), new Object[0]);
        }
    }

    protected Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        ShapeVisitor shapeVisitor = new ShapeVisitor(context, fieldName, relation);
        return (Query)queryShape.visit((GeometryVisitor)shapeVisitor);
    }

    private class ShapeVisitor
    implements GeometryVisitor<Query, RuntimeException> {
        QueryShardContext context;
        MappedFieldType fieldType;
        String fieldName;
        ShapeRelation relation;

        ShapeVisitor(QueryShardContext context, String fieldName, ShapeRelation relation) {
            this.context = context;
            this.fieldType = context.fieldMapper(fieldName);
            this.fieldName = fieldName;
            this.relation = relation;
        }

        public Query visit(Circle circle) {
            Query query = LatLonPoint.newDistanceQuery((String)this.fieldName, (double)circle.getLat(), (double)circle.getLon(), (double)circle.getRadiusMeters());
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowDistanceQuery((String)this.fieldName, (double)circle.getLat(), (double)circle.getLon(), (double)circle.getRadiusMeters());
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        public Query visit(GeometryCollection<?> collection) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            this.visit(bqb, collection);
            return bqb.build();
        }

        private void visit(BooleanQuery.Builder bqb, GeometryCollection<?> collection) {
            BooleanClause.Occur occur = BooleanClause.Occur.FILTER;
            for (Geometry shape : collection) {
                bqb.add((Query)shape.visit((GeometryVisitor)this), occur);
            }
        }

        public Query visit(Line line) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + GeoShapeType.LINESTRING + " queries", new Object[0]);
        }

        public Query visit(LinearRing ring) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + ShapeType.LINEARRING + " queries", new Object[0]);
        }

        public Query visit(MultiLine multiLine) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + GeoShapeType.MULTILINESTRING + " queries", new Object[0]);
        }

        public Query visit(MultiPoint multiPoint) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + GeoShapeType.MULTIPOINT + " queries", new Object[0]);
        }

        private Query visit(ArrayList<org.opensearch.geometry.Polygon> collector) {
            Polygon[] lucenePolygons = new Polygon[collector.size()];
            for (int i = 0; i < collector.size(); ++i) {
                lucenePolygons[i] = GeoShapeUtils.toLucenePolygon(collector.get(i));
            }
            Query query = LatLonPoint.newPolygonQuery((String)this.fieldName, (Polygon[])lucenePolygons);
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowPolygonQuery((String)this.fieldName, (Polygon[])lucenePolygons);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        public Query visit(MultiPolygon multiPolygon) {
            ArrayList<org.opensearch.geometry.Polygon> collector = new ArrayList<org.opensearch.geometry.Polygon>();
            GeoPolygonDecomposer.decomposeMultiPolygon(multiPolygon, true, collector);
            return this.visit(collector);
        }

        public Query visit(Point point) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + GeoShapeType.POINT + " queries", new Object[0]);
        }

        public Query visit(org.opensearch.geometry.Polygon polygon) {
            ArrayList<org.opensearch.geometry.Polygon> collector = new ArrayList<org.opensearch.geometry.Polygon>();
            GeoPolygonDecomposer.decomposePolygon(polygon, true, collector);
            return this.visit(collector);
        }

        public Query visit(Rectangle r) {
            Query query = LatLonPoint.newBoxQuery((String)this.fieldName, (double)r.getMinY(), (double)r.getMaxY(), (double)r.getMinX(), (double)r.getMaxX());
            if (this.fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowBoxQuery((String)this.fieldName, (double)r.getMinY(), (double)r.getMaxY(), (double)r.getMinX(), (double)r.getMaxX());
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }
    }
}

