/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.remote;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.indices.replication.common.ReplicationType;

public class RemoteMigrationIndexMetadataUpdater {
    private final DiscoveryNodes discoveryNodes;
    private final RoutingTable routingTable;
    private final Settings clusterSettings;
    private final IndexMetadata indexMetadata;
    private final Logger logger;

    public RemoteMigrationIndexMetadataUpdater(DiscoveryNodes discoveryNodes, RoutingTable routingTable, IndexMetadata indexMetadata, Settings clusterSettings, Logger logger) {
        this.discoveryNodes = discoveryNodes;
        this.routingTable = routingTable;
        this.clusterSettings = clusterSettings;
        this.indexMetadata = indexMetadata;
        this.logger = logger;
    }

    public void maybeAddRemoteIndexSettings(IndexMetadata.Builder indexMetadataBuilder, String index) {
        Settings currentIndexSettings = this.indexMetadata.getSettings();
        if (this.needsRemoteIndexSettingsUpdate(this.routingTable.indicesRouting().get(index), this.discoveryNodes, currentIndexSettings)) {
            this.logger.info("Index {} does not have remote store based index settings but all primary shards and STARTED replica shards have moved to remote enabled nodes. Applying remote store settings to the index", (Object)index);
            Map<String, String> remoteRepoNames = RemoteStoreUtils.getRemoteStoreRepoName(this.discoveryNodes);
            String segmentRepoName = remoteRepoNames.get("remote_store.segment.repository");
            String tlogRepoName = remoteRepoNames.get("remote_store.translog.repository");
            assert (Objects.nonNull(segmentRepoName) && Objects.nonNull(tlogRepoName)) : "Remote repo names cannot be null";
            Settings.Builder indexSettingsBuilder = Settings.builder().put(currentIndexSettings);
            RemoteMigrationIndexMetadataUpdater.updateRemoteStoreSettings(indexSettingsBuilder, segmentRepoName, tlogRepoName);
            indexMetadataBuilder.settings(indexSettingsBuilder);
            indexMetadataBuilder.settingsVersion(1L + this.indexMetadata.getVersion());
        } else {
            this.logger.debug("Index {} does not satisfy criteria for applying remote store settings", (Object)index);
        }
    }

    private boolean needsRemoteIndexSettingsUpdate(IndexRoutingTable indexRoutingTable, DiscoveryNodes discoveryNodes, Settings currentIndexSettings) {
        assert (currentIndexSettings != null) : "IndexMetadata for a shard cannot be null";
        if (!RemoteMigrationIndexMetadataUpdater.indexHasRemoteStoreSettings(currentIndexSettings)) {
            boolean allPrimariesStartedAndOnRemote = indexRoutingTable.shardsMatchingPredicate(ShardRouting::primary).stream().allMatch(shardRouting -> shardRouting.started() && discoveryNodes.get(shardRouting.currentNodeId()).isRemoteStoreNode());
            List<ShardRouting> replicaShards = indexRoutingTable.shardsMatchingPredicate(shardRouting -> !shardRouting.primary());
            boolean noRelocatingReplicas = replicaShards.stream().noneMatch(ShardRouting::relocating);
            boolean allStartedReplicasOnRemote = replicaShards.stream().filter(ShardRouting::started).allMatch(shardRouting -> discoveryNodes.get(shardRouting.currentNodeId()).isRemoteStoreNode());
            return allPrimariesStartedAndOnRemote && noRelocatingReplicas && allStartedReplicasOnRemote;
        }
        return false;
    }

    public void maybeUpdateRemoteStorePathStrategy(IndexMetadata.Builder indexMetadataBuilder, String index) {
        if (!RemoteMigrationIndexMetadataUpdater.indexHasRemotePathMetadata(this.indexMetadata)) {
            this.logger.info("Adding remote store path strategy for index [{}] during migration", (Object)index);
            indexMetadataBuilder.putCustom("remote_store", RemoteStoreUtils.determineRemoteStorePathStrategyDuringMigration(this.clusterSettings, this.discoveryNodes));
        } else {
            this.logger.debug("Index {} already has remote store path strategy", (Object)index);
        }
    }

    public static boolean indexHasAllRemoteStoreRelatedMetadata(IndexMetadata indexMetadata) {
        return RemoteMigrationIndexMetadataUpdater.indexHasRemoteStoreSettings(indexMetadata.getSettings()) && RemoteMigrationIndexMetadataUpdater.indexHasRemotePathMetadata(indexMetadata);
    }

    public static boolean indexHasRemoteStoreSettings(Settings indexSettings) {
        return IndexMetadata.INDEX_REMOTE_STORE_ENABLED_SETTING.exists(indexSettings) && IndexMetadata.INDEX_REMOTE_TRANSLOG_REPOSITORY_SETTING.exists(indexSettings) && IndexMetadata.INDEX_REMOTE_SEGMENT_STORE_REPOSITORY_SETTING.exists(indexSettings) && IndexMetadata.INDEX_REPLICATION_TYPE_SETTING.get(indexSettings) == ReplicationType.SEGMENT;
    }

    public static boolean indexHasRemotePathMetadata(IndexMetadata indexMetadata) {
        Map<String, String> customMetadata = indexMetadata.getCustomData("remote_store");
        return Objects.nonNull(customMetadata) && Objects.nonNull(customMetadata.get("path_type"));
    }

    public static void updateRemoteStoreSettings(Settings.Builder settingsBuilder, String segmentRepository, String translogRepository) {
        settingsBuilder.put("index.remote_store.enabled", true).put("index.replication.type", ReplicationType.SEGMENT).put("index.remote_store.segment.repository", segmentRepository).put("index.remote_store.translog.repository", translogRepository);
    }
}

