/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.remote;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.hash.FNV1a;
import org.opensearch.index.remote.RemoteStorePathStrategy;
import org.opensearch.index.remote.RemoteStoreUtils;

@ExperimentalApi
public class RemoteStoreEnums {

    @PublicApi(since="2.14.0")
    @ExperimentalApi
    public static enum PathHashAlgorithm {
        FNV_1A_BASE64(0){

            @Override
            String hash(RemoteStorePathStrategy.PathInput pathInput) {
                String input = pathInput.indexUUID() + pathInput.shardId() + pathInput.dataCategory().getName() + pathInput.dataType().getName();
                long hash = FNV1a.hash64(input);
                return RemoteStoreUtils.longToUrlBase64(hash);
            }
        }
        ,
        FNV_1A_COMPOSITE_1(1){

            @Override
            String hash(RemoteStorePathStrategy.PathInput pathInput) {
                String input = pathInput.indexUUID() + pathInput.shardId() + pathInput.dataCategory().getName() + pathInput.dataType().getName();
                long hash = FNV1a.hash64(input);
                return RemoteStoreUtils.longToCompositeBase64AndBinaryEncoding(hash, 20);
            }
        };

        private final int code;
        private static final Map<Integer, PathHashAlgorithm> CODE_TO_ENUM;
        public static final String NAME = "path_hash_algorithm";

        private PathHashAlgorithm(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static PathHashAlgorithm fromCode(int code) {
            return CODE_TO_ENUM.get(code);
        }

        abstract String hash(RemoteStorePathStrategy.PathInput var1);

        public static PathHashAlgorithm parseString(String pathHashAlgorithm) {
            try {
                return PathHashAlgorithm.valueOf(pathHashAlgorithm.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new IllegalArgumentException("Could not parse PathHashAlgorithm for [" + pathHashAlgorithm + "]");
            }
        }

        static {
            PathHashAlgorithm[] values = PathHashAlgorithm.values();
            HashMap<Integer, PathHashAlgorithm> codeToStatus = new HashMap<Integer, PathHashAlgorithm>(values.length);
            for (PathHashAlgorithm value : values) {
                int code = value.code;
                if (codeToStatus.containsKey(code)) {
                    throw new IllegalStateException(new ParameterizedMessage("{} has same code as {}", codeToStatus.get(code), (Object)value).getFormattedMessage());
                }
                codeToStatus.put(code, value);
            }
            CODE_TO_ENUM = Collections.unmodifiableMap(codeToStatus);
        }
    }

    @PublicApi(since="2.14.0")
    @ExperimentalApi
    public static abstract class PathType
    extends Enum<PathType> {
        public static final /* enum */ PathType FIXED = new PathType(0){

            @Override
            public BlobPath generatePath(RemoteStorePathStrategy.PathInput pathInput, PathHashAlgorithm hashAlgorithm) {
                assert (Objects.isNull((Object)hashAlgorithm)) : "hashAlgorithm is expected to be null with fixed remote store path type";
                return pathInput.basePath().add(pathInput.indexUUID()).add(pathInput.shardId()).add(pathInput.dataCategory().getName()).add(pathInput.dataType().getName());
            }

            @Override
            boolean requiresHashAlgorithm() {
                return false;
            }
        };
        public static final /* enum */ PathType HASHED_PREFIX = new PathType(1){

            @Override
            public BlobPath generatePath(RemoteStorePathStrategy.PathInput pathInput, PathHashAlgorithm hashAlgorithm) {
                assert (Objects.nonNull((Object)hashAlgorithm)) : "hashAlgorithm is expected to be non-null";
                return BlobPath.cleanPath().add(hashAlgorithm.hash(pathInput)).add(pathInput.basePath()).add(pathInput.indexUUID()).add(pathInput.shardId()).add(pathInput.dataCategory().getName()).add(pathInput.dataType().getName());
            }

            @Override
            boolean requiresHashAlgorithm() {
                return true;
            }
        };
        public static final /* enum */ PathType HASHED_INFIX = new PathType(2){

            @Override
            public BlobPath generatePath(RemoteStorePathStrategy.PathInput pathInput, PathHashAlgorithm hashAlgorithm) {
                assert (Objects.nonNull((Object)hashAlgorithm)) : "hashAlgorithm is expected to be non-null";
                return pathInput.basePath().add(hashAlgorithm.hash(pathInput)).add(pathInput.indexUUID()).add(pathInput.shardId()).add(pathInput.dataCategory().getName()).add(pathInput.dataType().getName());
            }

            @Override
            boolean requiresHashAlgorithm() {
                return true;
            }
        };
        private final int code;
        private static final Map<Integer, PathType> CODE_TO_ENUM;
        public static final String NAME = "path_type";
        private static final /* synthetic */ PathType[] $VALUES;

        public static PathType[] values() {
            return (PathType[])$VALUES.clone();
        }

        public static PathType valueOf(String name) {
            return Enum.valueOf(PathType.class, name);
        }

        private PathType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static PathType fromCode(int code) {
            return CODE_TO_ENUM.get(code);
        }

        public BlobPath path(RemoteStorePathStrategy.PathInput pathInput, PathHashAlgorithm hashAlgorithm) {
            DataCategory dataCategory = pathInput.dataCategory();
            DataType dataType = pathInput.dataType();
            assert (dataCategory.isSupportedDataType(dataType)) : "category:" + dataCategory + " type:" + dataType + " are not supported together";
            return this.generatePath(pathInput, hashAlgorithm);
        }

        protected abstract BlobPath generatePath(RemoteStorePathStrategy.PathInput var1, PathHashAlgorithm var2);

        abstract boolean requiresHashAlgorithm();

        public static PathType parseString(String pathType) {
            try {
                return PathType.valueOf(pathType.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new IllegalArgumentException("Could not parse PathType for [" + pathType + "]");
            }
        }

        static {
            $VALUES = new PathType[]{FIXED, HASHED_PREFIX, HASHED_INFIX};
            PathType[] values = PathType.values();
            HashMap<Integer, PathType> codeToStatus = new HashMap<Integer, PathType>(values.length);
            for (PathType value : values) {
                int code = value.code;
                if (codeToStatus.containsKey(code)) {
                    throw new IllegalStateException(new ParameterizedMessage("{} has same code as {}", codeToStatus.get(code), (Object)value).getFormattedMessage());
                }
                codeToStatus.put(code, value);
            }
            CODE_TO_ENUM = Collections.unmodifiableMap(codeToStatus);
        }
    }

    @PublicApi(since="2.14.0")
    @ExperimentalApi
    public static enum DataType {
        DATA("data"),
        METADATA("metadata"),
        LOCK_FILES("lock_files");

        private final String name;

        private DataType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    @PublicApi(since="2.14.0")
    @ExperimentalApi
    public static enum DataCategory {
        SEGMENTS("segments", Set.of(DataType.values())),
        TRANSLOG("translog", Set.of(DataType.DATA, DataType.METADATA));

        private final String name;
        private final Set<DataType> supportedDataTypes;

        private DataCategory(String name, Set<DataType> supportedDataTypes) {
            this.name = name;
            this.supportedDataTypes = supportedDataTypes;
        }

        public boolean isSupportedDataType(DataType dataType) {
            return this.supportedDataTypes.contains((Object)dataType);
        }

        public String getName() {
            return this.name;
        }
    }
}

