/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.remote;

import java.util.function.Supplier;
import org.opensearch.Version;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.remote.RemoteStoreEnums;
import org.opensearch.index.remote.RemoteStorePathStrategy;
import org.opensearch.indices.RemoteStoreSettings;

@ExperimentalApi
public class RemoteStorePathStrategyResolver {
    private final RemoteStoreSettings remoteStoreSettings;
    private final Supplier<Version> minNodeVersionSupplier;

    public RemoteStorePathStrategyResolver(RemoteStoreSettings remoteStoreSettings, Supplier<Version> minNodeVersionSupplier) {
        this.remoteStoreSettings = remoteStoreSettings;
        this.minNodeVersionSupplier = minNodeVersionSupplier;
    }

    public RemoteStorePathStrategy get() {
        RemoteStoreEnums.PathType pathType = Version.V_2_14_0.compareTo(this.minNodeVersionSupplier.get()) <= 0 ? this.remoteStoreSettings.getPathType() : RemoteStoreEnums.PathType.FIXED;
        RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm = pathType == RemoteStoreEnums.PathType.FIXED ? null : this.remoteStoreSettings.getPathHashAlgorithm();
        return new RemoteStorePathStrategy(pathType, pathHashAlgorithm);
    }
}

