/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nativeprotocol;

import java.io.Closeable;
import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.bytes.ReleasableBytesReference;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.transport.Header;
import org.opensearch.transport.ProtocolInboundMessage;

@PublicApi(since="2.14.0")
public class NativeInboundMessage
implements Releasable,
ProtocolInboundMessage {
    public static String NATIVE_PROTOCOL = "native";
    private final Header header;
    private final ReleasableBytesReference content;
    private final Exception exception;
    private final boolean isPing;
    private Releasable breakerRelease;
    private StreamInput streamInput;

    public NativeInboundMessage(Header header, ReleasableBytesReference content, Releasable breakerRelease) {
        this.header = header;
        this.content = content;
        this.breakerRelease = breakerRelease;
        this.exception = null;
        this.isPing = false;
    }

    public NativeInboundMessage(Header header, Exception exception) {
        this.header = header;
        this.content = null;
        this.breakerRelease = null;
        this.exception = exception;
        this.isPing = false;
    }

    public NativeInboundMessage(Header header, boolean isPing) {
        this.header = header;
        this.content = null;
        this.breakerRelease = null;
        this.exception = null;
        this.isPing = isPing;
    }

    @Override
    public String getProtocol() {
        return NATIVE_PROTOCOL;
    }

    public Header getHeader() {
        return this.header;
    }

    public int getContentLength() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length();
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isPing() {
        return this.isPing;
    }

    public boolean isShortCircuit() {
        return this.exception != null;
    }

    public Releasable takeBreakerReleaseControl() {
        Releasable toReturn = this.breakerRelease;
        this.breakerRelease = null;
        if (toReturn != null) {
            return toReturn;
        }
        return () -> {};
    }

    public StreamInput openOrGetStreamInput() throws IOException {
        assert (!this.isPing && this.content != null);
        if (this.streamInput == null) {
            this.streamInput = this.content.streamInput();
            this.streamInput.setVersion(this.header.getVersion());
        }
        return this.streamInput;
    }

    public void close() {
        IOUtils.closeWhileHandlingException((Closeable)this.streamInput);
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.content, this.breakerRelease});
    }

    public String toString() {
        return "InboundMessage{" + this.header + "}";
    }
}

