/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import java.util.Iterator;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.WriterConstants;
import org.opensearch.painless.ir.LoopNode;
import org.opensearch.painless.lookup.PainlessCast;
import org.opensearch.painless.lookup.PainlessMethod;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;

public class ForEachSubIterableNode
extends LoopNode {
    private Class<?> variableType;
    private String variableName;
    private PainlessCast cast;
    private Class<?> iteratorType;
    private String iteratorName;
    private PainlessMethod method;

    public void setVariableType(Class<?> variableType) {
        this.variableType = variableType;
    }

    public Class<?> getVariableType() {
        return this.variableType;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setCast(PainlessCast cast) {
        this.cast = cast;
    }

    public PainlessCast getCast() {
        return this.cast;
    }

    public void setIteratorType(Class<?> iteratorType) {
        this.iteratorType = iteratorType;
    }

    public Class<?> getIteratorType() {
        return this.iteratorType;
    }

    public void setIteratorName(String iteratorName) {
        this.iteratorName = iteratorName;
    }

    public String getIteratorName() {
        return this.iteratorName;
    }

    public void setMethod(PainlessMethod method) {
        this.method = method;
    }

    public PainlessMethod getMethod() {
        return this.method;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitForEachSubIterableLoop(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getConditionNode().visit(irTreeVisitor, scope);
        this.getBlockNode().visit(irTreeVisitor, scope);
    }

    public ForEachSubIterableNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeStatementOffset(this.getLocation());
        WriteScope.Variable variable = writeScope.defineVariable(this.variableType, this.variableName);
        WriteScope.Variable iterator = writeScope.defineInternalVariable(this.iteratorType, this.iteratorName);
        this.getConditionNode().write(classWriter, methodWriter, writeScope);
        if (this.method == null) {
            Type methodType = Type.getMethodType((Type)Type.getType(Iterator.class), (Type[])new Type[]{Type.getType(Object.class)});
            methodWriter.invokeDefCall("iterator", methodType, 5, new Object[0]);
        } else {
            methodWriter.invokeMethodCall(this.method);
        }
        methodWriter.visitVarInsn(iterator.getAsmType().getOpcode(54), iterator.getSlot());
        Label begin = new Label();
        Label end = new Label();
        methodWriter.mark(begin);
        methodWriter.visitVarInsn(iterator.getAsmType().getOpcode(21), iterator.getSlot());
        methodWriter.invokeInterface(WriterConstants.ITERATOR_TYPE, WriterConstants.ITERATOR_HASNEXT);
        methodWriter.ifZCmp(153, end);
        methodWriter.visitVarInsn(iterator.getAsmType().getOpcode(21), iterator.getSlot());
        methodWriter.invokeInterface(WriterConstants.ITERATOR_TYPE, WriterConstants.ITERATOR_NEXT);
        methodWriter.writeCast(this.cast);
        methodWriter.visitVarInsn(variable.getAsmType().getOpcode(54), variable.getSlot());
        WriteScope.Variable loop = writeScope.getInternalVariable("loop");
        if (loop != null) {
            methodWriter.writeLoopCounter(loop.getSlot(), this.getLocation());
        }
        this.getBlockNode().continueLabel = begin;
        this.getBlockNode().breakLabel = end;
        this.getBlockNode().write(classWriter, methodWriter, writeScope);
        methodWriter.goTo(begin);
        methodWriter.mark(end);
    }
}

