/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.filter.FilteringGeneratorDelegate;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Set;
import org.opensearch.common.util.io.Streams;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContentParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentGenerator;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.filtering.FilterPathBasedFilter;

public class JsonXContentGenerator
implements XContentGenerator {
    protected final JsonGenerator generator;
    private final GeneratorBase base;
    private final FilteringGeneratorDelegate filter;
    private final OutputStream os;
    private boolean writeLineFeedAtEnd;
    private static final SerializedString LF = new SerializedString("\n");
    private static final DefaultPrettyPrinter.Indenter INDENTER = new DefaultIndenter("  ", LF.getValue());
    private boolean prettyPrint = false;

    public JsonXContentGenerator(JsonGenerator jsonGenerator, OutputStream os, Set<String> includes, Set<String> excludes) {
        boolean hasIncludes;
        boolean hasExcludes;
        Objects.requireNonNull(includes, "Including filters must not be null");
        Objects.requireNonNull(excludes, "Excluding filters must not be null");
        this.os = os;
        this.base = jsonGenerator instanceof GeneratorBase ? (GeneratorBase)jsonGenerator : null;
        JsonGenerator generator = jsonGenerator;
        boolean bl = hasExcludes = !excludes.isEmpty();
        if (hasExcludes) {
            generator = new FilteringGeneratorDelegate(generator, (TokenFilter)new FilterPathBasedFilter(excludes, false), true, true);
        }
        boolean bl2 = hasIncludes = !includes.isEmpty();
        if (hasIncludes) {
            generator = new FilteringGeneratorDelegate(generator, (TokenFilter)new FilterPathBasedFilter(includes, true), true, true);
        }
        this.filter = hasExcludes || hasIncludes ? (FilteringGeneratorDelegate)generator : null;
        this.generator = generator;
    }

    public XContentType contentType() {
        return XContentType.JSON;
    }

    public final void usePrettyPrint() {
        this.generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter(INDENTER).withArrayIndenter(INDENTER));
        this.prettyPrint = true;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void usePrintLineFeedAtEnd() {
        this.writeLineFeedAtEnd = true;
    }

    private boolean isFiltered() {
        return this.filter != null;
    }

    private JsonGenerator getLowLevelGenerator() {
        if (this.isFiltered()) {
            JsonGenerator delegate = this.filter.getDelegate();
            if (delegate instanceof JsonGeneratorDelegate) {
                delegate = ((JsonGeneratorDelegate)delegate).getDelegate();
                assert (!(delegate instanceof JsonGeneratorDelegate));
            }
            return delegate;
        }
        return this.generator;
    }

    private boolean inRoot() {
        JsonStreamContext context = this.generator.getOutputContext();
        return context != null && context.inRoot() && context.getCurrentName() == null;
    }

    public void writeStartObject() throws IOException {
        if (this.inRoot()) {
            this.getLowLevelGenerator().writeStartObject();
            return;
        }
        this.generator.writeStartObject();
    }

    public void writeEndObject() throws IOException {
        if (this.inRoot()) {
            this.getLowLevelGenerator().writeEndObject();
            return;
        }
        this.generator.writeEndObject();
    }

    public void writeStartArray() throws IOException {
        this.generator.writeStartArray();
    }

    public void writeEndArray() throws IOException {
        this.generator.writeEndArray();
    }

    public void writeFieldName(String name) throws IOException {
        this.generator.writeFieldName(name);
    }

    public void writeNull() throws IOException {
        this.generator.writeNull();
    }

    public void writeNullField(String name) throws IOException {
        this.generator.writeNullField(name);
    }

    public void writeBooleanField(String name, boolean value) throws IOException {
        this.generator.writeBooleanField(name, value);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.generator.writeBoolean(value);
    }

    public void writeNumberField(String name, double value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    public void writeNumber(double value) throws IOException {
        this.generator.writeNumber(value);
    }

    public void writeNumberField(String name, float value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    public void writeNumber(float value) throws IOException {
        this.generator.writeNumber(value);
    }

    public void writeNumberField(String name, int value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    public void writeNumberField(String name, BigInteger value) throws IOException {
        this.generator.writeFieldName(name);
        this.generator.writeNumber(value);
    }

    public void writeNumberField(String name, BigDecimal value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    public void writeNumber(int value) throws IOException {
        this.generator.writeNumber(value);
    }

    public void writeNumberField(String name, long value) throws IOException {
        this.generator.writeNumberField(name, value);
    }

    public void writeNumber(long value) throws IOException {
        this.generator.writeNumber(value);
    }

    public void writeNumber(short value) throws IOException {
        this.generator.writeNumber(value);
    }

    public void writeNumber(BigInteger value) throws IOException {
        this.generator.writeNumber(value);
    }

    public void writeNumber(BigDecimal value) throws IOException {
        this.generator.writeNumber(value);
    }

    public void writeStringField(String name, String value) throws IOException {
        this.generator.writeStringField(name, value);
    }

    public void writeString(String value) throws IOException {
        this.generator.writeString(value);
    }

    public void writeString(char[] value, int offset, int len) throws IOException {
        this.generator.writeString(value, offset, len);
    }

    public void writeUTF8String(byte[] value, int offset, int length) throws IOException {
        this.generator.writeUTF8String(value, offset, length);
    }

    public void writeBinaryField(String name, byte[] value) throws IOException {
        this.generator.writeBinaryField(name, value);
    }

    public void writeBinary(byte[] value) throws IOException {
        this.generator.writeBinary(value);
    }

    public void writeBinary(byte[] value, int offset, int len) throws IOException {
        this.generator.writeBinary(value, offset, len);
    }

    private void writeStartRaw(String name) throws IOException {
        this.writeFieldName(name);
        this.generator.writeRaw(':');
    }

    public void writeEndRaw() {
        assert (this.base != null) : "JsonGenerator should be of instance GeneratorBase but was: " + this.generator.getClass();
        if (this.base != null) {
            JsonStreamContext context = this.base.getOutputContext();
            assert (context instanceof JsonWriteContext) : "Expected an instance of JsonWriteContext but was: " + context.getClass();
            ((JsonWriteContext)context).writeValue();
        }
    }

    public void writeRawField(String name, InputStream content) throws IOException {
        MediaType contentType;
        if (!content.markSupported()) {
            content = new BufferedInputStream(content);
        }
        if ((contentType = MediaTypeRegistry.xContentType((InputStream)content)) == null) {
            throw new IllegalArgumentException("Can't write raw bytes whose xcontent-type can't be guessed");
        }
        this.writeRawField(name, content, contentType);
    }

    public void writeRawField(String name, InputStream content, MediaType mediaType) throws IOException {
        if (!this.mayWriteRawData(mediaType)) {
            try (XContentParser parser = mediaType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, content);){
                parser.nextToken();
                this.writeFieldName(name);
                this.copyCurrentStructure(parser);
            }
        } else {
            this.writeStartRaw(name);
            this.flush();
            Streams.copy((InputStream)content, (OutputStream)this.os);
            this.writeEndRaw();
        }
    }

    public void writeRawValue(InputStream stream, MediaType mediaType) throws IOException {
        if (!this.mayWriteRawData(mediaType)) {
            this.copyRawValue(stream, mediaType.xContent());
        } else {
            if (this.generator.getOutputContext().getCurrentName() != null) {
                this.generator.writeRaw(':');
            }
            this.flush();
            Streams.copy((InputStream)stream, (OutputStream)this.os, (boolean)false);
            this.writeEndRaw();
        }
    }

    @Deprecated
    private boolean mayWriteRawData(XContentType contentType) {
        return this.supportsRawWrites() && !this.isFiltered() && contentType == this.contentType() && !this.prettyPrint;
    }

    private boolean mayWriteRawData(MediaType contentType) {
        return this.supportsRawWrites() && !this.isFiltered() && contentType == this.contentType() && !this.prettyPrint;
    }

    protected boolean supportsRawWrites() {
        return true;
    }

    protected void copyRawValue(InputStream stream, XContent xContent) throws IOException {
        try (XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, stream);){
            this.copyCurrentStructure(parser);
        }
    }

    public void copyCurrentStructure(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser instanceof JsonXContentParser) {
            this.generator.copyCurrentStructure(((JsonXContentParser)parser).parser);
        } else {
            JsonXContentGenerator.copyCurrentStructure(this, parser);
        }
    }

    private static void copyCurrentStructure(XContentGenerator destination, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.FIELD_NAME) {
            destination.writeFieldName(parser.currentName());
            token = parser.nextToken();
        }
        switch (token) {
            case START_ARRAY: {
                destination.writeStartArray();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    JsonXContentGenerator.copyCurrentStructure(destination, parser);
                }
                destination.writeEndArray();
                break;
            }
            case START_OBJECT: {
                destination.writeStartObject();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    JsonXContentGenerator.copyCurrentStructure(destination, parser);
                }
                destination.writeEndObject();
                break;
            }
            default: {
                destination.copyCurrentEvent(parser);
            }
        }
    }

    public void flush() throws IOException {
        this.generator.flush();
    }

    public void close() throws IOException {
        if (this.generator.isClosed()) {
            return;
        }
        JsonStreamContext context = this.generator.getOutputContext();
        if (context != null && !context.inRoot()) {
            throw new IOException("Unclosed object or array found");
        }
        if (this.writeLineFeedAtEnd) {
            this.flush();
            this.getLowLevelGenerator().writeRaw((SerializableString)LF);
        }
        this.generator.close();
    }

    public boolean isClosed() {
        return this.generator.isClosed();
    }
}

