/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatus;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClientVpnEndpointResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateClientVpnEndpointResponse> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpnEndpointId").getter(CreateClientVpnEndpointResponse.getter(CreateClientVpnEndpointResponse::clientVpnEndpointId)).setter(CreateClientVpnEndpointResponse.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("clientVpnEndpointId").build()}).build();
    private static final SdkField<ClientVpnEndpointStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(CreateClientVpnEndpointResponse.getter(CreateClientVpnEndpointResponse::status)).setter(CreateClientVpnEndpointResponse.setter(Builder::status)).constructor(ClientVpnEndpointStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(CreateClientVpnEndpointResponse.getter(CreateClientVpnEndpointResponse::dnsName)).setter(CreateClientVpnEndpointResponse.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").unmarshallLocationName("dnsName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, STATUS_FIELD, DNS_NAME_FIELD));
    private final String clientVpnEndpointId;
    private final ClientVpnEndpointStatus status;
    private final String dnsName;

    private CreateClientVpnEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.status = builder.status;
        this.dnsName = builder.dnsName;
    }

    public final String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public final ClientVpnEndpointStatus status() {
        return this.status;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClientVpnEndpointResponse)) {
            return false;
        }
        CreateClientVpnEndpointResponse other = (CreateClientVpnEndpointResponse)((Object)obj);
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.dnsName(), other.dnsName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClientVpnEndpointResponse").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("Status", (Object)this.status()).add("DnsName", (Object)this.dnsName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClientVpnEndpointResponse, T> g) {
        return obj -> g.apply((CreateClientVpnEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private ClientVpnEndpointStatus status;
        private String dnsName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClientVpnEndpointResponse model) {
            super(model);
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.status(model.status);
            this.dnsName(model.dnsName);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final ClientVpnEndpointStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ClientVpnEndpointStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ClientVpnEndpointStatus status) {
            this.status = status;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        @Override
        public CreateClientVpnEndpointResponse build() {
            return new CreateClientVpnEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClientVpnEndpointResponse> {
        public Builder clientVpnEndpointId(String var1);

        public Builder status(ClientVpnEndpointStatus var1);

        default public Builder status(Consumer<ClientVpnEndpointStatus.Builder> status) {
            return this.status((ClientVpnEndpointStatus)((ClientVpnEndpointStatus.Builder)ClientVpnEndpointStatus.builder().applyMutation(status)).build());
        }

        public Builder dnsName(String var1);
    }
}

