/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.connector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.transport.connector.MLUpdateConnectorRequest;
import org.opensearch.ml.engine.MLEngine;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class UpdateConnectorTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateConnectorTransportAction.class);
    private Client client;
    private ConnectorAccessControlHelper connectorAccessControlHelper;
    private MLModelManager mlModelManager;
    private MLEngine mlEngine;
    private volatile List<String> trustedConnectorEndpointsRegex;

    @Inject
    public UpdateConnectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ConnectorAccessControlHelper connectorAccessControlHelper, MLModelManager mlModelManager, Settings settings, ClusterService clusterService, MLEngine mlEngine) {
        super("cluster:admin/opensearch/ml/connectors/update", transportService, actionFilters, MLUpdateConnectorRequest::new);
        this.client = client;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlModelManager = mlModelManager;
        this.mlEngine = mlEngine;
        this.trustedConnectorEndpointsRegex = (List)MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX, it -> {
            this.trustedConnectorEndpointsRegex = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> listener) {
        MLUpdateConnectorRequest mlUpdateConnectorAction = MLUpdateConnectorRequest.fromActionRequest((ActionRequest)request);
        String connectorId = mlUpdateConnectorAction.getConnectorId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.connectorAccessControlHelper.getConnector(this.client, connectorId, (ActionListener<Connector>)ActionListener.wrap(connector -> {
                boolean hasPermission = this.connectorAccessControlHelper.validateConnectorAccess(this.client, (Connector)connector);
                if (Boolean.TRUE.equals(hasPermission)) {
                    connector.update(mlUpdateConnectorAction.getUpdateContent(), arg_0 -> ((MLEngine)this.mlEngine).encrypt(arg_0));
                    connector.validateConnectorURL(this.trustedConnectorEndpointsRegex);
                    UpdateRequest updateRequest = new UpdateRequest(".plugins-ml-connector", connectorId);
                    updateRequest.doc(connector.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                    this.updateUndeployedConnector(connectorId, updateRequest, listener, context);
                } else {
                    listener.onFailure((Exception)new IllegalArgumentException("You don't have permission to update the connector, connector id: " + connectorId));
                }
            }, exception -> {
                log.error("Permission denied: Unable to update the connector with ID {}. Details: {}", (Object)connectorId, exception);
                listener.onFailure(exception);
            }));
        }
        catch (Exception e) {
            log.error("Failed to update ML connector for connector id {}. Details {}:", (Object)connectorId, (Object)e);
            listener.onFailure(e);
        }
    }

    private void updateUndeployedConnector(String connectorId, UpdateRequest updateRequest, ActionListener<UpdateResponse> listener, ThreadContext.StoredContext context) {
        SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-model"});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"connector_id", (Object)connectorId));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.idsQuery().addIds(this.mlModelManager.getAllModelIds()));
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(sourceBuilder);
        this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            SearchHit[] searchHits = searchResponse.getHits().getHits();
            if (searchHits.length == 0) {
                this.client.update(updateRequest, this.getUpdateResponseListener(connectorId, listener, context));
            } else {
                log.error(searchHits.length + " models are still using this connector, please undeploy the models first!");
                ArrayList<String> modelIds = new ArrayList<String>();
                for (SearchHit hit : searchHits) {
                    modelIds.add(hit.getId());
                }
                listener.onFailure((Exception)new OpenSearchStatusException(searchHits.length + " models are still using this connector, please undeploy the models first: " + Arrays.toString(modelIds.toArray(new String[0])), RestStatus.BAD_REQUEST, new Object[0]));
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                this.client.update(updateRequest, this.getUpdateResponseListener(connectorId, listener, context));
                return;
            }
            log.error("Failed to update ML connector: " + connectorId, (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private ActionListener<UpdateResponse> getUpdateResponseListener(String connectorId, ActionListener<UpdateResponse> actionListener, ThreadContext.StoredContext context) {
        return ActionListener.runBefore((ActionListener)ActionListener.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() != DocWriteResponse.Result.UPDATED) {
                log.error("Failed to update the connector with ID: {}", (Object)connectorId);
                actionListener.onResponse(updateResponse);
                return;
            }
            log.info("Successfully updated the connector with ID: {}", (Object)connectorId);
            actionListener.onResponse(updateResponse);
        }, exception -> {
            log.error("Failed to update ML connector with ID {}. Details: {}", (Object)connectorId, exception);
            actionListener.onFailure(exception);
        }), () -> ((ThreadContext.StoredContext)context).restore());
    }
}

