/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.register;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.MLTaskType;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorAction;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorRequest;
import org.opensearch.ml.common.transport.forward.MLForwardInput;
import org.opensearch.ml.common.transport.forward.MLForwardRequest;
import org.opensearch.ml.common.transport.forward.MLForwardRequestType;
import org.opensearch.ml.common.transport.forward.MLForwardResponse;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.common.transport.register.MLRegisterModelRequest;
import org.opensearch.ml.common.transport.register.MLRegisterModelResponse;
import org.opensearch.ml.engine.ModelHelper;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelGroupManager;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.ml.task.MLTaskDispatcher;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.utils.MLExceptionUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class TransportRegisterModelAction
extends HandledTransportAction<ActionRequest, MLRegisterModelResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportRegisterModelAction.class);
    TransportService transportService;
    ModelHelper modelHelper;
    MLIndicesHandler mlIndicesHandler;
    MLModelManager mlModelManager;
    MLTaskManager mlTaskManager;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    Settings settings;
    DiscoveryNodeHelper nodeFilter;
    MLTaskDispatcher mlTaskDispatcher;
    MLStats mlStats;
    volatile String trustedUrlRegex;
    private List<String> trustedConnectorEndpointsRegex;
    ModelAccessControlHelper modelAccessControlHelper;
    private volatile boolean isModelUrlAllowed;
    ConnectorAccessControlHelper connectorAccessControlHelper;
    MLModelGroupManager mlModelGroupManager;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportRegisterModelAction(TransportService transportService, ActionFilters actionFilters, ModelHelper modelHelper, MLIndicesHandler mlIndicesHandler, MLModelManager mlModelManager, MLTaskManager mlTaskManager, ClusterService clusterService, Settings settings, ThreadPool threadPool, Client client, DiscoveryNodeHelper nodeFilter, MLTaskDispatcher mlTaskDispatcher, MLStats mlStats, ModelAccessControlHelper modelAccessControlHelper, ConnectorAccessControlHelper connectorAccessControlHelper, MLModelGroupManager mlModelGroupManager, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/register_model", transportService, actionFilters, MLRegisterModelRequest::new);
        this.transportService = transportService;
        this.modelHelper = modelHelper;
        this.mlIndicesHandler = mlIndicesHandler;
        this.mlModelManager = mlModelManager;
        this.mlTaskManager = mlTaskManager;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.nodeFilter = nodeFilter;
        this.mlTaskDispatcher = mlTaskDispatcher;
        this.mlStats = mlStats;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlModelGroupManager = mlModelGroupManager;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.settings = settings;
        this.trustedUrlRegex = (String)MLCommonsSettings.ML_COMMONS_TRUSTED_URL_REGEX.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_TRUSTED_URL_REGEX, it -> {
            this.trustedUrlRegex = it;
        });
        this.isModelUrlAllowed = (Boolean)MLCommonsSettings.ML_COMMONS_ALLOW_MODEL_URL.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ALLOW_MODEL_URL, it -> {
            this.isModelUrlAllowed = it;
        });
        this.trustedConnectorEndpointsRegex = (List)MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX, it -> {
            this.trustedConnectorEndpointsRegex = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLRegisterModelResponse> listener) {
        MLRegisterModelRequest registerModelRequest = MLRegisterModelRequest.fromActionRequest((ActionRequest)request);
        MLRegisterModelInput registerModelInput = registerModelRequest.getRegisterModelInput();
        if (FunctionName.isDLModel((FunctionName)registerModelInput.getFunctionName()) && !this.mlFeatureEnabledSetting.isLocalModelEnabled()) {
            throw new IllegalStateException("Local Model is currently disabled. To enable it, update the setting \"plugins.ml_commons.local_model.enabled\" to true.");
        }
        if (registerModelInput.getUrl() != null && !this.isModelUrlAllowed) {
            throw new IllegalArgumentException("To upload custom model user needs to enable allow_registering_model_via_url settings. Otherwise please use OpenSearch pre-trained models.");
        }
        registerModelInput.setIsHidden(Boolean.valueOf(RestActionUtils.isSuperAdminUser(this.clusterService, this.client)));
        if (StringUtils.isEmpty((CharSequence)registerModelInput.getModelGroupId())) {
            this.mlModelGroupManager.validateUniqueModelGroupName(registerModelInput.getModelName(), (ActionListener<SearchResponse>)ActionListener.wrap(modelGroups -> {
                if (modelGroups != null && modelGroups.getHits().getTotalHits() != null && modelGroups.getHits().getTotalHits().value != 0L) {
                    String modelGroupIdOfTheNameProvided = modelGroups.getHits().getAt(0).getId();
                    registerModelInput.setModelGroupId(modelGroupIdOfTheNameProvided);
                    this.checkUserAccess(registerModelInput, listener, true);
                } else {
                    this.doRegister(registerModelInput, listener);
                }
            }, e -> {
                log.error("Failed to search model group index", (Throwable)e);
                listener.onFailure(e);
            }));
        } else {
            this.checkUserAccess(registerModelInput, listener, false);
        }
    }

    private void checkUserAccess(MLRegisterModelInput registerModelInput, ActionListener<MLRegisterModelResponse> listener, Boolean isModelNameAlreadyExisting) {
        User user = RestActionUtils.getUserContext(this.client);
        this.modelAccessControlHelper.validateModelGroupAccess(user, registerModelInput.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
            if (access.booleanValue()) {
                this.doRegister(registerModelInput, listener);
                return;
            }
            if (isModelNameAlreadyExisting.booleanValue()) {
                if (registerModelInput.getUrl() == null && registerModelInput.getFunctionName() != FunctionName.REMOTE && registerModelInput.getConnectorId() == null) {
                    listener.onFailure((Exception)new IllegalArgumentException("Without a model group ID, the system will use the model name {" + registerModelInput.getModelName() + "} to create a new model group. However, this name is taken by another group with id {" + registerModelInput.getModelGroupId() + "} you can't access. To register this pre-trained model, create a new model group and use its ID in your request."));
                } else {
                    listener.onFailure((Exception)new IllegalArgumentException("The name {" + registerModelInput.getModelName() + "} you provided is unavailable because it is used by another model group with id {" + registerModelInput.getModelGroupId() + "} to which you do not have access. Please provide a different name."));
                }
                return;
            }
            listener.onFailure((Exception)new IllegalArgumentException("You don't have permissions to perform this operation on this model."));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void doRegister(MLRegisterModelInput registerModelInput, ActionListener<MLRegisterModelResponse> listener) {
        FunctionName functionName = registerModelInput.getFunctionName();
        if (FunctionName.REMOTE == functionName) {
            if (Strings.isNotBlank((String)registerModelInput.getConnectorId())) {
                this.connectorAccessControlHelper.validateConnectorAccess(this.client, registerModelInput.getConnectorId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                    if (Boolean.TRUE.equals(r)) {
                        this.createModelGroup(registerModelInput, listener);
                    } else {
                        listener.onFailure((Exception)new IllegalArgumentException("You don't have permission to use the connector provided, connector id: " + registerModelInput.getConnectorId()));
                    }
                }, e -> {
                    log.error("You don't have permission to use the connector provided, connector id: " + registerModelInput.getConnectorId(), (Throwable)e);
                    listener.onFailure(e);
                }));
            } else {
                this.validateInternalConnector(registerModelInput);
                ActionListener dryRunResultListener = ActionListener.wrap(res -> {
                    log.info("Dry run create connector successfully");
                    this.createModelGroup(registerModelInput, listener);
                }, e -> {
                    log.error(e.getMessage(), (Throwable)e);
                    listener.onFailure(e);
                });
                MLCreateConnectorRequest mlCreateConnectorRequest = this.createDryRunConnectorRequest();
                this.client.execute((ActionType)MLCreateConnectorAction.INSTANCE, (ActionRequest)mlCreateConnectorRequest, dryRunResultListener);
            }
        } else {
            this.createModelGroup(registerModelInput, listener);
        }
    }

    private void createModelGroup(MLRegisterModelInput registerModelInput, ActionListener<MLRegisterModelResponse> listener) {
        if (Strings.isEmpty((CharSequence)registerModelInput.getModelGroupId())) {
            MLRegisterModelGroupInput mlRegisterModelGroupInput = this.createRegisterModelGroupRequest(registerModelInput);
            this.mlModelGroupManager.createModelGroup(mlRegisterModelGroupInput, (ActionListener<String>)ActionListener.wrap(modelGroupId -> {
                registerModelInput.setModelGroupId(modelGroupId);
                registerModelInput.setDoesVersionCreateModelGroup(Boolean.valueOf(true));
                this.registerModel(registerModelInput, listener);
            }, e -> {
                MLExceptionUtils.logException("Failed to create Model Group", e, log);
                listener.onFailure(e);
            }));
        } else {
            registerModelInput.setDoesVersionCreateModelGroup(Boolean.valueOf(false));
            this.registerModel(registerModelInput, listener);
        }
    }

    private MLCreateConnectorRequest createDryRunConnectorRequest() {
        MLCreateConnectorInput createConnectorInput = MLCreateConnectorInput.builder().dryRun(true).build();
        return new MLCreateConnectorRequest(createConnectorInput);
    }

    private void validateInternalConnector(MLRegisterModelInput registerModelInput) {
        if (registerModelInput.getConnector() == null) {
            log.error("You must provide connector content when creating a remote model without providing connector id!");
            throw new IllegalArgumentException("You must provide connector content when creating a remote model without connector id!");
        }
        if (registerModelInput.getConnector().getPredictEndpoint(registerModelInput.getConnector().getParameters()) == null) {
            log.error("Connector endpoint is required when creating a remote model without connector id!");
            throw new IllegalArgumentException("Connector endpoint is required when creating a remote model without connector id!");
        }
        registerModelInput.getConnector().validateConnectorURL(this.trustedConnectorEndpointsRegex);
    }

    private void registerModel(MLRegisterModelInput registerModelInput, ActionListener<MLRegisterModelResponse> listener) {
        boolean validUrl;
        Pattern pattern = Pattern.compile(this.trustedUrlRegex);
        String url = registerModelInput.getUrl();
        if (url != null && !(validUrl = pattern.matcher(url).find())) {
            throw new IllegalArgumentException("URL can't match trusted url regex");
        }
        boolean isAsync = registerModelInput.getFunctionName() != FunctionName.REMOTE;
        MLTask mlTask = MLTask.builder().async(isAsync).taskType(MLTaskType.REGISTER_MODEL).functionName(registerModelInput.getFunctionName()).createTime(Instant.now()).lastUpdateTime(Instant.now()).state(MLTaskState.CREATED).workerNodes((List)ImmutableList.of((Object)this.clusterService.localNode().getId())).build();
        if (!isAsync) {
            this.mlTaskManager.createMLTask(mlTask, (ActionListener<IndexResponse>)ActionListener.wrap(response -> {
                String taskId = response.getId();
                mlTask.setTaskId(taskId);
                this.mlModelManager.registerMLRemoteModel(registerModelInput, mlTask, listener);
            }, e -> {
                MLExceptionUtils.logException("Failed to register model", e, log);
                listener.onFailure(e);
            }));
            return;
        }
        this.mlTaskDispatcher.dispatch(registerModelInput.getFunctionName(), (ActionListener<DiscoveryNode>)ActionListener.wrap(node -> {
            String nodeId = node.getId();
            mlTask.setWorkerNodes((List)ImmutableList.of((Object)nodeId));
            this.mlTaskManager.createMLTask(mlTask, (ActionListener<IndexResponse>)ActionListener.wrap(response -> {
                String taskId = response.getId();
                mlTask.setTaskId(taskId);
                listener.onResponse((Object)new MLRegisterModelResponse(taskId, MLTaskState.CREATED.name()));
                ActionListener forwardActionListener = ActionListener.wrap(res -> {
                    log.debug("Register model response: " + res);
                    if (!this.clusterService.localNode().getId().equals(nodeId)) {
                        this.mlTaskManager.remove(taskId);
                    }
                }, ex -> {
                    MLExceptionUtils.logException("Failed to register model", ex, log);
                    this.mlTaskManager.updateMLTask(taskId, (Map<String, Object>)ImmutableMap.of((Object)"error", (Object)MLExceptionUtils.getRootCauseMessage(ex), (Object)"state", (Object)MLTaskState.FAILED), MLTaskManager.TASK_SEMAPHORE_TIMEOUT, true);
                });
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    this.mlTaskManager.add(mlTask, Arrays.asList(nodeId));
                    MLForwardInput forwardInput = MLForwardInput.builder().requestType(MLForwardRequestType.REGISTER_MODEL).registerModelInput(registerModelInput).mlTask(mlTask).build();
                    MLForwardRequest forwardRequest = new MLForwardRequest(forwardInput);
                    this.transportService.sendRequest(node, "cluster:admin/opensearch/mlinternal/forward", (TransportRequest)forwardRequest, (TransportResponseHandler)new ActionListenerResponseHandler(forwardActionListener, MLForwardResponse::new));
                }
                catch (Exception e) {
                    forwardActionListener.onFailure(e);
                }
            }, e -> {
                MLExceptionUtils.logException("Failed to register model", e, log);
                listener.onFailure(e);
            }));
        }, e -> {
            MLExceptionUtils.logException("Failed to register model", e, log);
            listener.onFailure(e);
        }));
    }

    private MLRegisterModelGroupInput createRegisterModelGroupRequest(MLRegisterModelInput registerModelInput) {
        return MLRegisterModelGroupInput.builder().name(registerModelInput.getModelName()).description(registerModelInput.getDescription()).backendRoles(registerModelInput.getBackendRoles()).modelAccessMode(registerModelInput.getAccessMode()).isAddAllBackendRoles(registerModelInput.getAddAllBackendRoles()).build();
    }
}

