/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.annotation.InputDataSet;
import org.opensearch.ml.common.dataset.MLInputDataType;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.output.model.ModelResultFilter;

@InputDataSet(value=MLInputDataType.TEXT_DOCS)
public class TextDocsInputDataSet
extends MLInputDataset {
    private final ModelResultFilter resultFilter;
    private final List<String> docs;
    private static final Version MINIMAL_SUPPORTED_VERSION_FOR_MULTI_MODAL = Version.V_2_11_0;

    public TextDocsInputDataSet(List<String> docs, ModelResultFilter resultFilter) {
        super(MLInputDataType.TEXT_DOCS);
        this.resultFilter = resultFilter;
        Objects.requireNonNull(docs);
        if (docs.size() == 0) {
            throw new IllegalArgumentException("empty docs");
        }
        this.docs = docs;
    }

    public TextDocsInputDataSet(StreamInput streamInput) throws IOException {
        super(MLInputDataType.TEXT_DOCS);
        Version version = streamInput.getVersion();
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_MULTI_MODAL)) {
            this.docs = new ArrayList<String>();
            int size = streamInput.readInt();
            for (int i = 0; i < size; ++i) {
                this.docs.add(streamInput.readOptionalString());
            }
        } else {
            this.docs = streamInput.readStringList();
        }
        this.resultFilter = streamInput.readBoolean() ? new ModelResultFilter(streamInput) : null;
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        Version version = streamOutput.getVersion();
        if (version.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_MULTI_MODAL)) {
            streamOutput.writeInt(this.docs.size());
            for (String doc : this.docs) {
                streamOutput.writeOptionalString(doc);
            }
        } else {
            streamOutput.writeStringCollection(this.docs);
        }
        if (this.resultFilter != null) {
            streamOutput.writeBoolean(true);
            this.resultFilter.writeTo(streamOutput);
        } else {
            streamOutput.writeBoolean(false);
        }
    }

    @Generated
    public static TextDocsInputDataSetBuilder builder() {
        return new TextDocsInputDataSetBuilder();
    }

    @Generated
    public TextDocsInputDataSetBuilder toBuilder() {
        return new TextDocsInputDataSetBuilder().docs(this.docs).resultFilter(this.resultFilter);
    }

    @Generated
    public ModelResultFilter getResultFilter() {
        return this.resultFilter;
    }

    @Generated
    public List<String> getDocs() {
        return this.docs;
    }

    @Generated
    public static class TextDocsInputDataSetBuilder {
        @Generated
        private List<String> docs;
        @Generated
        private ModelResultFilter resultFilter;

        @Generated
        TextDocsInputDataSetBuilder() {
        }

        @Generated
        public TextDocsInputDataSetBuilder docs(List<String> docs) {
            this.docs = docs;
            return this;
        }

        @Generated
        public TextDocsInputDataSetBuilder resultFilter(ModelResultFilter resultFilter) {
            this.resultFilter = resultFilter;
            return this;
        }

        @Generated
        public TextDocsInputDataSet build() {
            return new TextDocsInputDataSet(this.docs, this.resultFilter);
        }

        @Generated
        public String toString() {
            return "TextDocsInputDataSet.TextDocsInputDataSetBuilder(docs=" + this.docs + ", resultFilter=" + this.resultFilter + ")";
        }
    }
}

