/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.model.StopWords;

public class Guardrail
implements ToXContentObject {
    public static final String STOP_WORDS_FIELD = "stop_words";
    public static final String REGEX_FIELD = "regex";
    private List<StopWords> stopWords;
    private String[] regex;

    public Guardrail(List<StopWords> stopWords, String[] regex) {
        this.stopWords = stopWords;
        this.regex = regex;
    }

    public Guardrail(StreamInput input) throws IOException {
        if (input.readBoolean()) {
            this.stopWords = new ArrayList<StopWords>();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                this.stopWords.add(new StopWords(input));
            }
        }
        this.regex = input.readStringArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.stopWords != null && this.stopWords.size() > 0) {
            out.writeBoolean(true);
            out.writeInt(this.stopWords.size());
            for (StopWords e : this.stopWords) {
                e.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeStringArray(this.regex);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.stopWords != null && this.stopWords.size() > 0) {
            builder.field(STOP_WORDS_FIELD, this.stopWords);
        }
        if (this.regex != null) {
            builder.field(REGEX_FIELD, (Object)this.regex);
        }
        builder.endObject();
        return builder;
    }

    public static Guardrail parse(XContentParser parser) throws IOException {
        ArrayList<StopWords> stopWords = null;
        String[] regex = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "stop_words": {
                    stopWords = new ArrayList<StopWords>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        stopWords.add(StopWords.parse(parser));
                    }
                    continue block8;
                }
                case "regex": {
                    regex = parser.list().toArray(new String[0]);
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return Guardrail.builder().stopWords(stopWords).regex(regex).build();
    }

    @Generated
    public static GuardrailBuilder builder() {
        return new GuardrailBuilder();
    }

    @Generated
    public GuardrailBuilder toBuilder() {
        return new GuardrailBuilder().stopWords(this.stopWords).regex(this.regex);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Guardrail)) {
            return false;
        }
        Guardrail other = (Guardrail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<StopWords> this$stopWords = this.getStopWords();
        List<StopWords> other$stopWords = other.getStopWords();
        if (this$stopWords == null ? other$stopWords != null : !((Object)this$stopWords).equals(other$stopWords)) {
            return false;
        }
        return Arrays.deepEquals(this.getRegex(), other.getRegex());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Guardrail;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<StopWords> $stopWords = this.getStopWords();
        result = result * 59 + ($stopWords == null ? 43 : ((Object)$stopWords).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getRegex());
        return result;
    }

    @Generated
    public List<StopWords> getStopWords() {
        return this.stopWords;
    }

    @Generated
    public String[] getRegex() {
        return this.regex;
    }

    @Generated
    public static class GuardrailBuilder {
        @Generated
        private List<StopWords> stopWords;
        @Generated
        private String[] regex;

        @Generated
        GuardrailBuilder() {
        }

        @Generated
        public GuardrailBuilder stopWords(List<StopWords> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        @Generated
        public GuardrailBuilder regex(String[] regex) {
            this.regex = regex;
            return this;
        }

        @Generated
        public Guardrail build() {
            return new Guardrail(this.stopWords, this.regex);
        }

        @Generated
        public String toString() {
            return "Guardrail.GuardrailBuilder(stopWords=" + this.stopWords + ", regex=" + Arrays.deepToString(this.regex) + ")";
        }
    }
}

