/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.memory.ConversationalMemoryHandler;
import org.opensearch.ml.memory.action.conversation.CreateConversationRequest;
import org.opensearch.ml.memory.action.conversation.CreateConversationResponse;
import org.opensearch.ml.memory.index.OpenSearchConversationalMemoryHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class CreateConversationTransportAction
extends HandledTransportAction<CreateConversationRequest, CreateConversationResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(CreateConversationTransportAction.class);
    private ConversationalMemoryHandler cmHandler;
    private Client client;
    private volatile boolean featureIsEnabled;

    @Inject
    public CreateConversationTransportAction(TransportService transportService, ActionFilters actionFilters, OpenSearchConversationalMemoryHandler cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/opensearch/ml/memory/conversation/create", transportService, actionFilters, CreateConversationRequest::new);
        this.cmHandler = cmHandler;
        this.client = client;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    protected void doExecute(Task task, CreateConversationRequest request, ActionListener<CreateConversationResponse> actionListener) {
        if (!this.featureIsEnabled) {
            actionListener.onFailure((Exception)new OpenSearchException("The experimental Conversation Memory feature is not enabled. To enable, please update the setting " + ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.getKey(), new Object[0]));
            return;
        }
        String name = request.getName();
        String applicationType = request.getApplicationType();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListener.runBefore(actionListener, () -> context.restore());
            ActionListener al = ActionListener.wrap(r -> internalListener.onResponse((Object)new CreateConversationResponse((String)r)), e -> {
                log.error("Failed to create new memory with name " + request.getName(), (Throwable)e);
                internalListener.onFailure(e);
            });
            if (name == null) {
                this.cmHandler.createConversation((ActionListener<String>)al);
            } else {
                this.cmHandler.createConversation(name, applicationType, (ActionListener<String>)al);
            }
        }
        catch (Exception e2) {
            log.error("Failed to create new memory with name " + request.getName(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

