/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.conversation.ConversationMeta;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.memory.ConversationalMemoryHandler;
import org.opensearch.ml.memory.action.conversation.GetConversationRequest;
import org.opensearch.ml.memory.action.conversation.GetConversationResponse;
import org.opensearch.ml.memory.index.OpenSearchConversationalMemoryHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetConversationTransportAction
extends HandledTransportAction<GetConversationRequest, GetConversationResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetConversationTransportAction.class);
    private Client client;
    private ConversationalMemoryHandler cmHandler;
    private volatile boolean featureIsEnabled;

    @Inject
    public GetConversationTransportAction(TransportService transportService, ActionFilters actionFilters, OpenSearchConversationalMemoryHandler cmHandler, Client client, ClusterService clusterService) {
        super("cluster:admin/opensearch/ml/memory/conversation/get", transportService, actionFilters, GetConversationRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    public void doExecute(Task task, GetConversationRequest request, ActionListener<GetConversationResponse> actionListener) {
        if (!this.featureIsEnabled) {
            actionListener.onFailure((Exception)new OpenSearchException("The experimental Conversation Memory feature is not enabled. To enable, please update the setting " + ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_ENABLED.getKey(), new Object[0]));
            return;
        }
        String conversationId = request.getConversationId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            ActionListener internalListener = ActionListener.runBefore(actionListener, () -> context.restore());
            ActionListener al = ActionListener.wrap(conversationMeta -> internalListener.onResponse((Object)new GetConversationResponse((ConversationMeta)conversationMeta)), e -> internalListener.onFailure(e));
            this.cmHandler.getConversation(conversationId, (ActionListener<ConversationMeta>)al);
        }
        catch (Exception e2) {
            log.error("Failed to get memory " + conversationId, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

