/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.tools.democonfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.opensearch.security.tools.democonfig.CertificateGenerator;
import org.opensearch.security.tools.democonfig.ExecutionEnvironment;
import org.opensearch.security.tools.democonfig.SecuritySettingsConfigurer;

public class Installer {
    private static Installer instance;
    private static SecuritySettingsConfigurer securitySettingsConfigurer;
    private static CertificateGenerator certificateGenerator;
    boolean assumeyes = false;
    boolean initsecurity = false;
    boolean cluster_mode = false;
    int skip_updates = -1;
    String SCRIPT_DIR;
    String BASE_DIR;
    String OPENSEARCH_CONF_FILE;
    String OPENSEARCH_BIN_DIR;
    String OPENSEARCH_PLUGINS_DIR;
    String OPENSEARCH_LIB_PATH;
    String OPENSEARCH_INSTALL_TYPE;
    String OPENSEARCH_CONF_DIR;
    String OPENSEARCH_VERSION;
    String SECURITY_VERSION;
    ExecutionEnvironment environment = ExecutionEnvironment.DEMO;
    String OS;
    final String FILE_EXTENSION;
    static File RPM_DEB_OPENSEARCH_HOME;
    private final Options options;
    private final HelpFormatter formatter = new HelpFormatter();

    private Installer() {
        this.OS = System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
        this.FILE_EXTENSION = this.OS.toLowerCase().contains("win") ? ".bat" : ".sh";
        this.options = new Options();
    }

    public static Installer getInstance() {
        if (instance == null) {
            instance = new Installer();
            securitySettingsConfigurer = new SecuritySettingsConfigurer(instance);
            certificateGenerator = new CertificateGenerator(instance);
        }
        return instance;
    }

    public void installDemoConfiguration(String[] options) throws IOException {
        this.readOptions(options);
        Installer.printScriptHeaders();
        this.gatherUserInputs();
        this.initializeVariables();
        this.printVariables();
        securitySettingsConfigurer.configureSecuritySettings();
        certificateGenerator.createDemoCertificates();
        this.finishScriptExecution();
    }

    public static void main(String[] options) throws IOException {
        Installer installer = Installer.getInstance();
        installer.buildOptions();
        installer.installDemoConfiguration(options);
    }

    void buildOptions() {
        this.options.addOption("h", "show-help", false, "Shows help for this tool.");
        this.options.addOption("y", "answer-yes-to-all-prompts", false, "Confirm all installation dialogues automatically.");
        this.options.addOption("i", "initialize-security", false, "Initialize Security plugin with default configuration (default is to ask if -y is not given).");
        this.options.addOption("c", "enable-cluster-mode", false, "Enable cluster mode by binding to all network interfaces (default is to ask if -y is not given).");
        this.options.addOption("s", "skip-updates-when-already-configured", false, "Skip updates if config is already applied to opensearch.yml.");
        this.options.addOption("t", "test-execution-environment", false, "Set the execution environment to `test` to skip password validation. Should be used only for testing. (default is set to `demo`)");
    }

    static void printScriptHeaders() {
        System.out.println("### OpenSearch Security Demo Installer");
        System.out.println("### ** Warning: Do not use on production or public reachable systems **");
    }

    void readOptions(String[] args) {
        this.SCRIPT_DIR = args[0];
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(this.options, args);
            if (line.hasOption("h")) {
                this.showHelp();
                return;
            }
            this.assumeyes = line.hasOption("y");
            this.initsecurity = line.hasOption("i");
            this.cluster_mode = line.hasOption("c");
            this.skip_updates = line.hasOption("s") ? 0 : -1;
            this.environment = line.hasOption("t") ? ExecutionEnvironment.TEST : this.environment;
        }
        catch (ParseException exp) {
            System.out.println("ERR: Parsing failed.  Reason: " + exp.getMessage());
            System.exit(-1);
        }
    }

    void showHelp() {
        this.formatter.printHelp("install_demo_configuration" + this.FILE_EXTENSION, this.options, true);
        System.exit(0);
    }

    void gatherUserInputs() {
        if (!this.assumeyes) {
            try (Scanner scanner = new Scanner(System.in, StandardCharsets.UTF_8);){
                if (!this.confirmAction(scanner, "Install demo certificates?")) {
                    System.exit(0);
                }
                if (!this.initsecurity) {
                    this.initsecurity = this.confirmAction(scanner, "Initialize Security Modules?");
                }
                if (!this.cluster_mode) {
                    System.out.println("Cluster mode requires additional setup of:");
                    System.out.println("  - Virtual memory (vm.max_map_count)" + System.lineSeparator());
                    this.cluster_mode = this.confirmAction(scanner, "Enable cluster mode?");
                }
            }
        }
    }

    boolean confirmAction(Scanner scanner, String message) {
        System.out.print(message + " [y/N] ");
        String response = scanner.nextLine();
        return response.equalsIgnoreCase("yes") || response.equalsIgnoreCase("y");
    }

    void initializeVariables() {
        this.setBaseDir();
        this.setOpenSearchVariables();
        this.setSecurityVariables();
    }

    void setBaseDir() {
        File baseDirFile = new File(this.SCRIPT_DIR).getParentFile().getParentFile().getParentFile();
        String string = this.BASE_DIR = baseDirFile != null ? baseDirFile.getAbsolutePath() : null;
        if (this.BASE_DIR == null || !new File(this.BASE_DIR).isDirectory()) {
            System.out.println("DEBUG: basedir does not exist");
            System.exit(-1);
        }
        this.BASE_DIR = this.BASE_DIR + File.separator;
    }

    void setOpenSearchVariables() {
        this.OPENSEARCH_CONF_FILE = this.BASE_DIR + "config" + File.separator + "opensearch.yml";
        this.OPENSEARCH_BIN_DIR = this.BASE_DIR + "bin" + File.separator;
        this.OPENSEARCH_PLUGINS_DIR = this.BASE_DIR + "plugins" + File.separator;
        this.OPENSEARCH_LIB_PATH = this.BASE_DIR + "lib" + File.separator;
        this.OPENSEARCH_INSTALL_TYPE = this.determineInstallType();
        Set<String> errorMessages = this.validatePaths();
        if (!errorMessages.isEmpty()) {
            errorMessages.forEach(System.out::println);
            System.exit(-1);
        }
        this.OPENSEARCH_CONF_DIR = new File(this.OPENSEARCH_CONF_FILE).getParent();
        this.OPENSEARCH_CONF_DIR = new File(this.OPENSEARCH_CONF_DIR).getAbsolutePath() + File.separator;
    }

    private Set<String> validatePaths() {
        HashSet<String> errorMessages = new HashSet<String>();
        if (!new File(this.OPENSEARCH_CONF_FILE).exists()) {
            errorMessages.add("Unable to determine OpenSearch config file. Quit.");
        }
        if (!new File(this.OPENSEARCH_BIN_DIR).exists()) {
            errorMessages.add("Unable to determine OpenSearch bin directory. Quit.");
        }
        if (!new File(this.OPENSEARCH_PLUGINS_DIR).exists()) {
            errorMessages.add("Unable to determine OpenSearch plugins directory. Quit.");
        }
        if (!new File(this.OPENSEARCH_LIB_PATH).exists()) {
            errorMessages.add("Unable to determine OpenSearch lib directory. Quit.");
        }
        return errorMessages;
    }

    String determineInstallType() {
        if (this.OS.toLowerCase().contains("win")) {
            return ".zip";
        }
        if (RPM_DEB_OPENSEARCH_HOME.exists() && RPM_DEB_OPENSEARCH_HOME.equals(new File(this.BASE_DIR))) {
            this.OPENSEARCH_CONF_FILE = RPM_DEB_OPENSEARCH_HOME.getAbsolutePath() + "/config/opensearch.yml";
            if (!new File(this.OPENSEARCH_CONF_FILE).exists()) {
                this.OPENSEARCH_CONF_FILE = "/etc/opensearch/opensearch.yml";
            }
            return "rpm/deb";
        }
        return ".tar.gz";
    }

    void setSecurityVariables() {
        File[] securityFiles;
        File[] opensearchLibFiles;
        if (!new File(this.OPENSEARCH_PLUGINS_DIR + "opensearch-security").exists()) {
            System.out.println("OpenSearch Security plugin not installed. Quit.");
            System.exit(-1);
        }
        if ((opensearchLibFiles = new File(this.OPENSEARCH_LIB_PATH).listFiles(pathname -> pathname.getName().matches("opensearch-core-(.*).jar"))) != null && opensearchLibFiles.length > 0) {
            this.OPENSEARCH_VERSION = opensearchLibFiles[0].getName().replaceAll("opensearch-core-(.*).jar", "$1");
        }
        if ((securityFiles = new File(this.OPENSEARCH_PLUGINS_DIR + "opensearch-security").listFiles(pathname -> pathname.getName().startsWith("opensearch-security-") && pathname.getName().endsWith(".jar"))) != null && securityFiles.length > 0) {
            this.SECURITY_VERSION = securityFiles[0].getName().replaceAll("opensearch-security-(.*).jar", "$1");
        }
    }

    void printVariables() {
        System.out.println("OpenSearch install type: " + this.OPENSEARCH_INSTALL_TYPE + " on " + this.OS);
        System.out.println("OpenSearch config dir: " + this.OPENSEARCH_CONF_DIR);
        System.out.println("OpenSearch config file: " + this.OPENSEARCH_CONF_FILE);
        System.out.println("OpenSearch bin dir: " + this.OPENSEARCH_BIN_DIR);
        System.out.println("OpenSearch plugins dir: " + this.OPENSEARCH_PLUGINS_DIR);
        System.out.println("OpenSearch lib dir: " + this.OPENSEARCH_LIB_PATH);
        System.out.println("Detected OpenSearch Version: " + this.OPENSEARCH_VERSION);
        System.out.println("Detected OpenSearch Security Version: " + this.SECURITY_VERSION);
    }

    void finishScriptExecution() {
        System.out.println("### Success");
        System.out.println("### Execute this script now on all your nodes and then start all nodes");
        try {
            String securityAdminScriptPath = this.OPENSEARCH_PLUGINS_DIR + "opensearch-security" + File.separator + "tools" + File.separator + "securityadmin" + this.FILE_EXTENSION;
            String securityAdminDemoScriptPath = this.OPENSEARCH_CONF_DIR + "securityadmin_demo" + this.FILE_EXTENSION;
            securitySettingsConfigurer.createSecurityAdminDemoScript(securityAdminScriptPath, securityAdminDemoScriptPath);
            if (!this.OS.toLowerCase().contains("win")) {
                Path file = Paths.get(securityAdminDemoScriptPath, new String[0]);
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                perms.add(PosixFilePermission.OWNER_READ);
                perms.add(PosixFilePermission.OWNER_EXECUTE);
                perms.add(PosixFilePermission.GROUP_EXECUTE);
                perms.add(PosixFilePermission.OTHERS_EXECUTE);
                Files.setPosixFilePermissions(file, perms);
            }
            String lastLine = "";
            try (BufferedReader reader = new BufferedReader(new FileReader(securityAdminDemoScriptPath, StandardCharsets.UTF_8));){
                String currentLine;
                while ((currentLine = reader.readLine()) != null) {
                    lastLine = currentLine;
                }
            }
            if (!this.initsecurity) {
                System.out.println("### After the whole cluster is up execute: ");
                System.out.println(lastLine);
                System.out.println("### or run ." + File.separator + "securityadmin_demo" + this.FILE_EXTENSION);
                System.out.println("### After that you can also use the Security Plugin ConfigurationGUI");
            } else {
                System.out.println("### OpenSearch Security will be automatically initialized.");
                System.out.println("### If you like to change the runtime configuration ");
                System.out.println("### change the files in .." + File.separator + ".." + File.separator + ".." + File.separator + "config" + File.separator + "opensearch-security and execute: ");
                System.out.println(lastLine);
                System.out.println("### or run ." + File.separator + "securityadmin_demo" + this.FILE_EXTENSION);
                System.out.println("### To use the Security Plugin ConfigurationGUI");
            }
            System.out.println("### To access your secured cluster open https://<hostname>:<HTTP port> and log in with admin/<your-custom-admin-password>.");
            System.out.println("### (Ignore the SSL certificate warning because we installed self-signed demo certificates)");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    static void resetInstance() {
        instance = null;
    }

    static {
        RPM_DEB_OPENSEARCH_HOME = new File("/usr/share/opensearch");
    }
}

