/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathUtils {
    public static Path getParentDirectoryOfFile(String location) {
        Path file = null;
        try {
            location = location.replaceAll("\\\\", "/");
            String fileScheme = "file:";
            file = location.toLowerCase().startsWith("file:") ? Paths.get(URI.create(location)).toAbsolutePath() : Paths.get(location, new String[0]).toAbsolutePath();
            if (!Files.exists(file, new LinkOption[0])) {
                return PathUtils.getParentDirectoryFromUrl(location);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return file.toAbsolutePath().getParent();
    }

    private static Path getParentDirectoryFromUrl(String location) {
        try {
            URL url = PathUtils.class.getResource(location);
            if (url == null) {
                url = PathUtils.class.getClassLoader().getResource(location);
            }
            if (url == null) {
                url = ClassLoader.getSystemResource(location);
            }
            Path file = Paths.get(URI.create(url.toExternalForm()));
            return file.getParent();
        }
        catch (Exception e) {
            e.getMessage();
            return null;
        }
    }
}

