/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_et extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwichi aeg",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acre standardaeg",
               "",
               "Acre suveaeg",
               "",
               "Acre aeg",
               "",
            };
        final String[] Apia = new String[] {
               "Apia standardaeg",
               "",
               "Apia suveaeg",
               "",
               "Apia aeg",
               "",
            };
        final String[] Cook = new String[] {
               "Cooki saarte standardaeg",
               "",
               "Cooki saarte osaline suveaeg",
               "",
               "Cooki saarte aeg",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuuba standardaeg",
               "CST",
               "Kuuba suveaeg",
               "CDT",
               "Kuuba aeg",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ei standardaeg",
               "",
               "Fid\u017ei suveaeg",
               "",
               "Fid\u017ei aeg",
               "",
            };
        final String[] Gulf = new String[] {
               "P\u00e4rsia lahe standardaeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdi standardaeg",
               "",
               "Hovdi suveaeg",
               "",
               "Hovdi aeg",
               "",
            };
        final String[] Iran = new String[] {
               "Iraani standardaeg",
               "",
               "Iraani suveaeg",
               "",
               "Iraani aeg",
               "",
            };
        final String[] Niue = new String[] {
               "Niue aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omski standardaeg",
               "",
               "Omski suveaeg",
               "",
               "Omski aeg",
               "",
            };
        final String[] Peru = new String[] {
               "Peruu standardaeg",
               "",
               "Peruu suveaeg",
               "",
               "Peruu aeg",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuki aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake\u2019i aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Casey = new String[] {
               "Casey aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "T\u0161iili standardaeg",
               "",
               "T\u0161iili suveaeg",
               "",
               "T\u0161iili aeg",
               "",
            };
        final String[] China = new String[] {
               "Hiina standardaeg",
               "CST",
               "Hiina suveaeg",
               "CDT",
               "Hiina aeg",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kookossaarte aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davise aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Jaapani standardaeg",
               "JST",
               "Jaapani suveaeg",
               "JDT",
               "Jaapani aeg",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korea standardaeg",
               "KST",
               "Korea suveaeg",
               "KST",
               "Korea aeg",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepali aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Belau aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa standardaeg",
               "SST",
               "Samoa suveaeg",
               "SST",
               "Samoa aeg",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga standardaeg",
               "",
               "Tonga suveaeg",
               "",
               "Tonga aeg",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukoni aeg",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska standardaeg",
               "",
               "Alaska suveaeg",
               "",
               "Alaska aeg",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazonase standardaeg",
               "",
               "Amazonase suveaeg",
               "",
               "Amazonase aeg",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anad\u00f5ri standardaeg",
               "",
               "Anad\u00f5ri suveaeg",
               "",
               "Anad\u00f5ri aeg",
               "",
            };
        final String[] Azores = new String[] {
               "Assooride standardaeg",
               "HMT",
               "Assooride suveaeg",
               "HMT",
               "Assooride aeg",
               "HMT",
            };
        final String[] Bhutan = new String[] {
               "Bhutani aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Lihav\u00f5ttesaare standardaeg",
               "",
               "Lihav\u00f5ttesaare suveaeg",
               "",
               "Lihav\u00f5ttesaare aeg",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Iisraeli standardaeg",
               "IST",
               "Iisraeli suveaeg",
               "IDT",
               "Iisraeli aeg",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsoni aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskva standardaeg",
               "MSK",
               "Moskva suveaeg",
               "MSK",
               "Moskva aeg",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Pohnpei aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara standardaeg",
               "",
               "Samara suveaeg",
               "",
               "Samara aeg",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei standardaeg",
               "CST",
               "Taipei suveaeg",
               "CDT",
               "Taipei aeg",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostoki aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallise ja Futuna aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Araabia standardaeg",
               "",
               "Araabia suveaeg",
               "",
               "Araabia aeg",
               "",
            };
        final String[] Armenia = new String[] {
               "Armeenia standardaeg",
               "",
               "Armeenia suveaeg",
               "",
               "Armeenia aeg",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliivia aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chathami standardaeg",
               "",
               "Chathami suveaeg",
               "",
               "Chathami aeg",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Koordineeritud maailmaaeg",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadori aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier\u2019 aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruusia standardaeg",
               "",
               "Gruusia suveaeg",
               "",
               "Gruusia aeg",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutski standardaeg",
               "",
               "Irkutski suveaeg",
               "",
               "Irkutski aeg",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadani standardaeg",
               "",
               "Magadani suveaeg",
               "",
               "Magadani aeg",
               "",
            };
        final String[] Myanmar = new String[] {
               "Birma aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolki saare standardaeg",
               "",
               "Norfolki saare suveaeg",
               "",
               "Norfolki saare aeg",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha standardaeg",
               "",
               "Fernando de Noronha suveaeg",
               "",
               "Fernando de Noronha aeg",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unioni aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Saalomoni Saarte aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguay standardaeg",
               "",
               "Uruguay suveaeg",
               "",
               "Uruguay aeg",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu standardaeg",
               "",
               "Vanuatu suveaeg",
               "",
               "Vanuatu aeg",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutski standardaeg",
               "",
               "Jakutski suveaeg",
               "",
               "Jakutski aeg",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlandi standardaeg",
               "AST",
               "Atlandi suveaeg",
               "ADT",
               "Atlandi aeg",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Brasiilia standardaeg",
               "",
               "Brasiilia suveaeg",
               "",
               "Brasiilia aeg",
               "",
            };
        final String[] Chamorro = new String[] {
               "T\u0161amorro standardaeg",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Colombia standardaeg",
               "",
               "Colombia suveaeg",
               "",
               "Colombia aeg",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandi saarte standardaeg",
               "",
               "Falklandi saarte suveaeg",
               "",
               "Falklandi saarte aeg",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaisia aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldiivi aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatari standardaeg",
               "",
               "Ulaanbaatari suveaeg",
               "",
               "Ulaanbaatari aeg",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistani standardaeg",
               "PKT",
               "Pakistani suveaeg",
               "PKST",
               "Pakistani aeg",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay standardaeg",
               "",
               "Paraguay suveaeg",
               "",
               "Paraguay aeg",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairni aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahhalini standardaeg",
               "",
               "Sahhalini suveaeg",
               "",
               "Sahhalini aeg",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina standardaeg",
               "",
               "Argentina suveaeg",
               "",
               "Argentina aeg",
               "",
            };
        final String[] Christmas = new String[] {
               "J\u00f5ulusaare aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagose aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongi standardaeg",
               "HKT",
               "Hongkongi suveaeg",
               "HKST",
               "Hongkongi aeg",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indohiina aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Kamt\u0161atka standardaeg",
               "",
               "Kamt\u0161atka suveaeg",
               "",
               "Petropavlovsk-Kamt\u0161atski aeg",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "K\u00f5rg\u00f5zstani aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe\u2019i standardaeg",
               "",
               "Lord Howe\u2019i suveaeg",
               "",
               "Lord Howe\u2019i aeg",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markiisaarte aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritiuse standardaeg",
               "",
               "Mauritiuse suveaeg",
               "",
               "Mauritiuse aeg",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapuri standardaeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgogradi standardaeg",
               "MSK",
               "Volgogradi suveaeg",
               "MSK",
               "Volgogradi aeg",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbaid\u017eaani standardaeg",
               "",
               "Aserbaid\u017eaani suveaeg",
               "",
               "Aserbaid\u017eaani aeg",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladeshi standardaeg",
               "",
               "Bangladeshi suveaeg",
               "",
               "Bangladeshi aeg",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Roheneemesaarte standardaeg",
               "",
               "Roheneemesaarte suveaeg",
               "",
               "Roheneemesaarte aeg",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ida-Timori aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sei\u0161elli aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistani aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistani standardaeg",
               "",
               "Usbekistani suveaeg",
               "",
               "Usbekistani aeg",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistani aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarski standardaeg",
               "",
               "Krasnojarski suveaeg",
               "",
               "Krasnojarski aeg",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Uus-Meremaa standardaeg",
               "NZST",
               "Uus-Meremaa suveaeg",
               "NZDT",
               "Uus-Meremaa aeg",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirski standardaeg",
               "",
               "Novosibirski suveaeg",
               "",
               "Novosibirski aeg",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipiini standardaeg",
               "PST",
               "Filipiini suveaeg",
               "PDT",
               "Filipiini aeg",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostoki standardaeg",
               "",
               "Vladivostoki suveaeg",
               "",
               "Vladivostoki aeg",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "India ookeani aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line\u2019i saarte aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlandi standardaeg",
               "NST",
               "Newfoundlandi suveaeg",
               "NDT",
               "Newfoundlandi aeg",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "T\u00fcrkmenistani standardaeg",
               "",
               "T\u00fcrkmenistani suveaeg",
               "",
               "T\u00fcrkmenistani aeg",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Prantsuse Guajaana aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Uus-Kaledoonia standardaeg",
               "",
               "Uus-Kaledoonia suveaeg",
               "",
               "Uus-Kaledoonia aeg",
               "",
            };
        final String[] South_Georgia = new String[] {
               "L\u00f5una-Georgia aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgi standardaeg",
               "",
               "Jekaterinburgi suveaeg",
               "",
               "Jekaterinburgi aeg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Kesk-Aafrika aeg",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] Africa_Eastern = new String[] {
               "Ida-Aafrika aeg",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "L\u00e4\u00e4ne-Aafrika standardaeg",
               "WAT",
               "L\u00e4\u00e4ne-Aafrika suveaeg",
               "WAT",
               "L\u00e4\u00e4ne-Aafrika aeg",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville\u2019i aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Kesk-Euroopa standardaeg",
               "CET",
               "Kesk-Euroopa suveaeg",
               "CEST",
               "Kesk-Euroopa aeg",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ida-Euroopa standardaeg",
               "EET",
               "Ida-Euroopa suveaeg",
               "EEST",
               "Ida-Euroopa aeg",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "L\u00e4\u00e4ne-Euroopa standardaeg",
               "FMT",
               "L\u00e4\u00e4ne-Euroopa suveaeg",
               "FMT",
               "L\u00e4\u00e4ne-Euroopa aeg",
               "FMT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mehhiko Vaikse ookeani standardaeg",
               "MST",
               "Mehhiko Vaikse ookeani suveaeg",
               "MDT",
               "Mehhiko Vaikse ookeani aeg",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "L\u00f5una-Aafrika standardaeg",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Kesk-Ameerika standardaeg",
               "CST",
               "Kesk-Ameerika suveaeg",
               "CDT",
               "Kesk-Ameerika aeg",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Idaranniku standardaeg",
               "EST",
               "Idaranniku suveaeg",
               "EST",
               "Idaranniku aeg",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Vaikse ookeani standardaeg",
               "PST",
               "Vaikse ookeani suveaeg",
               "PDT",
               "Vaikse ookeani aeg",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Prantsuse Antarktiliste ja L\u00f5unaalade aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberti saarte aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleuudi standardaeg",
               "HST",
               "Hawaii-Aleuudi suveaeg",
               "HST",
               "Hawaii-Aleuudi aeg",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "F\u00f6\u00f6niksisaarte aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre\u2019i ja Miqueloni standardaeg",
               "",
               "Saint-Pierre\u2019i ja Miqueloni suveaeg",
               "",
               "Saint-Pierre\u2019i ja Miqueloni aeg",
               "",
            };
        final String[] America_Mountain = new String[] {
               "M\u00e4estikuv\u00f6\u00f6ndi standardaeg",
               "MST",
               "M\u00e4estikuv\u00f6\u00f6ndi suveaeg",
               "MDT",
               "M\u00e4estikuv\u00f6\u00f6ndi aeg",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalli Saarte aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Loode-Mehhiko standardaeg",
               "",
               "Loode-Mehhiko suveaeg",
               "",
               "Loode-Mehhiko aeg",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Paapua Uus-Guinea aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Kesk-Austraalia standardaeg",
               "ACST",
               "Kesk-Austraalia suveaeg",
               "ACDT",
               "Kesk-Austraalia aeg",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ida-Austraalia standardaeg",
               "AEST",
               "Ida-Austraalia suveaeg",
               "AEDT",
               "Ida-Austraalia aeg",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "L\u00e4\u00e4ne-Austraalia standardaeg",
               "",
               "L\u00e4\u00e4ne-Austraalia suveaeg",
               "",
               "L\u00e4\u00e4ne-Austraalia aeg",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ida-Gr\u00f6\u00f6nimaa standardaeg",
               "",
               "Ida-Gr\u00f6\u00f6nimaa suveaeg",
               "",
               "Ida-Gr\u00f6\u00f6nimaa aeg",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "L\u00e4\u00e4ne-Gr\u00f6\u00f6nimaa standardaeg",
               "",
               "L\u00e4\u00e4ne-Gr\u00f6\u00f6nimaa suveaeg",
               "",
               "L\u00e4\u00e4ne-Gr\u00f6\u00f6nimaa aeg",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Kesk-Indoneesia aeg",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ida-Indoneesia aeg",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "L\u00e4\u00e4ne-Indoneesia aeg",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ida-Kasahstani aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "L\u00e4\u00e4ne-Kasahstani aeg",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Austraalia Kesk-L\u00e4\u00e4ne standardaeg",
               "",
               "Austraalia Kesk-L\u00e4\u00e4ne suveaeg",
               "",
               "Austraalia Kesk-L\u00e4\u00e4ne aeg",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichi aeg",
                    "GMT",
                    "Iiri suveaeg",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwichi aeg",
                    "GMT",
                    "Briti suveaeg",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwichi aeg",
                    "GMT",
                    "Briti suveaeg",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Casey },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bakuu" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "T\u0161ita" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "timezone.excity.Asia/Tokyo", "T\u014dky\u014d" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Almaty", "Almat\u00f5" },
            { "timezone.excity.Asia/Anadyr", "Anad\u00f5r" },
            { "timezone.excity.Asia/Aqtobe", "Akt\u00f6be" },
            { "timezone.excity.Asia/Atyrau", "At\u00f5rau" },
            { "timezone.excity.Asia/Kuwait", "Kuveit" },
            { "timezone.excity.Asia/Muscat", "Masqa\u0163" },
            { "timezone.excity.Asia/Riyadh", "Ar-Riy\u0101\u1e11" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "m\u00e4\u00e4ramata linn" },
            { "timezone.excity.Europe/Kiev", "Kiiev" },
            { "timezone.excity.Europe/Riga", "Riia" },
            { "timezone.excity.Europe/Rome", "Rooma" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Tbilisi", "Thbilisi" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Paris", "Pariis" },
            { "timezone.excity.Indian/Cocos", "Kookossaared" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.Asia/Ashgabat", "A\u015fgabat" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Hand\u00f5ga" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sahhalin" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Europe/Athens", "Ateena" },
            { "timezone.excity.Europe/Berlin", "Berliin" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viin" },
            { "timezone.excity.Europe/Warsaw", "Varssavi" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Pacific/Palau", "Belau" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Al\u017eiir" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruusalemm" },
            { "timezone.excity.Asia/Kamchatka", "Kamt\u0161atka" },
            { "timezone.excity.Asia/Qyzylorda", "K\u00f5z\u00f5lorda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Pacific/Easter", "Lihav\u00f5ttesaar" },
            { "timezone.excity.Africa/Khartoum", "Hartum" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.Asia/Choibalsan", "T\u0161ojbalsan" },
            { "timezone.excity.Atlantic/Azores", "Assoorid" },
            { "timezone.excity.Atlantic/Canary", "Kanaari saared" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e4\u00e4ri saared" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Br\u00fcssel" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Chisinau", "Chi\u0219in\u0103u" },
            { "timezone.excity.Europe/Helsinki", "Helsingi" },
            { "timezone.excity.Europe/Istanbul", "\u0130stanbul" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017egorod" },
            { "timezone.excity.Indian/Maldives", "Maldiivid" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Mariehamn", "Maarianhamina" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Indian/Christmas", "J\u00f5ulusaar" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhaagen" },
            { "timezone.excity.Europe/Zaporozhye", "Zaporo\u017eje" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Pacific/Marquesas", "Markiisaared" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekol\u00f5msk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Saint Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Mani saar" },
            { "timezone.excity.America/Mexico_City", "M\u00e9xico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Roheneemesaared" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "L\u00f5una-Georgia" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, P\u00f5hja-Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, P\u00f5hja-Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, P\u00f5hja-Dakota" },
        };
        return data;
    }
}
