/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.transport.config;

import lombok.Generated;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.AbstractModule;
import org.opensearch.common.inject.Provides;
import org.opensearch.common.inject.Singleton;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.legacy.metrics.GaugeMetric;
import org.opensearch.sql.legacy.metrics.Metric;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.spark.asyncquery.AsyncQueryExecutorService;
import org.opensearch.sql.spark.asyncquery.AsyncQueryExecutorServiceImpl;
import org.opensearch.sql.spark.asyncquery.AsyncQueryJobMetadataStorageService;
import org.opensearch.sql.spark.asyncquery.OpensearchAsyncQueryJobMetadataStorageService;
import org.opensearch.sql.spark.client.EMRServerlessClientFactory;
import org.opensearch.sql.spark.client.EMRServerlessClientFactoryImpl;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigSupplier;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigSupplierImpl;
import org.opensearch.sql.spark.dispatcher.SparkQueryDispatcher;
import org.opensearch.sql.spark.execution.session.SessionManager;
import org.opensearch.sql.spark.execution.statestore.StateStore;
import org.opensearch.sql.spark.flint.FlintIndexMetadataServiceImpl;
import org.opensearch.sql.spark.leasemanager.DefaultLeaseManager;
import org.opensearch.sql.spark.response.JobExecutionResponseReader;

public class AsyncExecutorServiceModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    public AsyncQueryExecutorService asyncQueryExecutorService(AsyncQueryJobMetadataStorageService asyncQueryJobMetadataStorageService, SparkQueryDispatcher sparkQueryDispatcher, SparkExecutionEngineConfigSupplier sparkExecutionEngineConfigSupplier) {
        return new AsyncQueryExecutorServiceImpl(asyncQueryJobMetadataStorageService, sparkQueryDispatcher, sparkExecutionEngineConfigSupplier);
    }

    @Provides
    public AsyncQueryJobMetadataStorageService asyncQueryJobMetadataStorageService(StateStore stateStore) {
        return new OpensearchAsyncQueryJobMetadataStorageService(stateStore);
    }

    @Provides
    @Singleton
    public StateStore stateStore(NodeClient client, ClusterService clusterService) {
        StateStore stateStore = new StateStore((Client)client, clusterService);
        this.registerStateStoreMetrics(stateStore);
        return stateStore;
    }

    @Provides
    public SparkQueryDispatcher sparkQueryDispatcher(EMRServerlessClientFactory emrServerlessClientFactory, DataSourceService dataSourceService, JobExecutionResponseReader jobExecutionResponseReader, FlintIndexMetadataServiceImpl flintIndexMetadataReader, NodeClient client, SessionManager sessionManager, DefaultLeaseManager defaultLeaseManager, StateStore stateStore) {
        return new SparkQueryDispatcher(emrServerlessClientFactory, dataSourceService, jobExecutionResponseReader, flintIndexMetadataReader, (Client)client, sessionManager, defaultLeaseManager, stateStore);
    }

    @Provides
    public SessionManager sessionManager(StateStore stateStore, EMRServerlessClientFactory emrServerlessClientFactory, Settings settings) {
        return new SessionManager(stateStore, emrServerlessClientFactory, settings);
    }

    @Provides
    public DefaultLeaseManager defaultLeaseManager(Settings settings, StateStore stateStore) {
        return new DefaultLeaseManager(settings, stateStore);
    }

    @Provides
    public EMRServerlessClientFactory createEMRServerlessClientFactory(SparkExecutionEngineConfigSupplier sparkExecutionEngineConfigSupplier) {
        return new EMRServerlessClientFactoryImpl(sparkExecutionEngineConfigSupplier);
    }

    @Provides
    public SparkExecutionEngineConfigSupplier sparkExecutionEngineConfigSupplier(Settings settings) {
        return new SparkExecutionEngineConfigSupplierImpl(settings);
    }

    @Provides
    @Singleton
    public FlintIndexMetadataServiceImpl flintIndexMetadataReader(NodeClient client) {
        return new FlintIndexMetadataServiceImpl((Client)client);
    }

    @Provides
    public JobExecutionResponseReader jobExecutionResponseReader(NodeClient client) {
        return new JobExecutionResponseReader((Client)client);
    }

    private void registerStateStoreMetrics(StateStore stateStore) {
        GaugeMetric activeSessionMetric = new GaugeMetric("active_async_query_sessions_count", StateStore.activeSessionsCount(stateStore, StateStore.ALL_DATASOURCE));
        GaugeMetric activeStatementMetric = new GaugeMetric("active_async_query_statements_count", StateStore.activeStatementsCount(stateStore, StateStore.ALL_DATASOURCE));
        Metrics.getInstance().registerMetric((Metric)activeSessionMetric);
        Metrics.getInstance().registerMetric((Metric)activeStatementMetric);
    }

    @Generated
    public AsyncExecutorServiceModule() {
    }
}

