# -*- coding: binary -*-
# frozen_string_literal: true

# This file is auto-generated. Instead of editing this file, please
# add MIMEs to data/custom.xml or lib/marcel/mime_type/definitions.rb.

module Marcel
  # @private
  # :nodoc:
  EXTENSIONS = {
    '123' => 'application/vnd.lotus-1-2-3',
    '3dml' => 'text/vnd.in3d.3dml',
    '3fr' => 'image/x-raw-hasselblad',
    '3g2' => 'video/3gpp2',
    '3gp' => 'video/3gpp',
    '4th' => 'text/x-forth',
    '7z' => 'application/x-7z-compressed',
    'a' => 'application/x-archive',
    'aab' => 'application/x-authorware-bin',
    'aac' => 'audio/x-aac',
    'aam' => 'application/x-authorware-map',
    'aart' => 'text/plain',
    'aas' => 'application/x-authorware-seg',
    'abw' => 'application/x-abiword',
    'ac' => 'text/plain',
    'ac3' => 'audio/ac3',
    'acc' => 'application/vnd.americandynamics.acc',
    'ace' => 'application/x-ace-compressed',
    'acfm' => 'application/x-font-adobe-metric',
    'acu' => 'application/vnd.acucobol',
    'acutc' => 'application/vnd.acucorp',
    'ad' => 'text/x-asciidoc',
    'ad.txt' => 'text/x-asciidoc',
    'ada' => 'text/x-ada',
    'adb' => 'text/x-ada',
    'adoc' => 'text/x-asciidoc',
    'adoc.txt' => 'text/x-asciidoc',
    'adp' => 'audio/adpcm',
    'ads' => 'text/x-ada',
    'aep' => 'application/vnd.adobe.aftereffects.project',
    'aet' => 'application/vnd.adobe.aftereffects.template',
    'afm' => 'application/x-font-adobe-metric',
    'afp' => 'application/vnd.ibm.modcap',
    'ai' => 'application/illustrator',
    'aif' => 'audio/x-aiff',
    'aifc' => 'audio/x-aiff',
    'aiff' => 'audio/x-aiff',
    'air' => 'application/vnd.adobe.air-application-installer-package+zip',
    'aj' => 'text/x-aspectj',
    'al' => 'text/x-perl',
    'am' => 'text/plain',
    'amfm' => 'application/x-font-adobe-metric',
    'ami' => 'application/vnd.amiga.ami',
    'amr' => 'audio/amr',
    'anpa' => 'text/vnd.iptc.anpa',
    'apk' => 'application/vnd.android.package-archive',
    'applescript' => 'text/x-applescript',
    'application' => 'application/x-ms-application',
    'apr' => 'application/vnd.lotus-approach',
    'apt' => 'text/plain',
    'ar' => 'application/x-archive',
    'arc' => 'application/x-internet-archive',
    'arj' => 'application/x-arj',
    'arw' => 'image/x-raw-sony',
    'as' => 'text/x-actionscript',
    'asc' => 'application/pgp-signature',
    'asciidoc' => 'text/x-asciidoc',
    'asf' => 'video/x-ms-asf',
    'asice' => 'application/vnd.etsi.asic-e+zip',
    'asics' => 'application/vnd.etsi.asic-s+zip',
    'asm' => 'text/x-assembly',
    'asnd' => 'audio/vnd.adobe.soundbooth',
    'aso' => 'application/vnd.accpac.simply.aso',
    'asp' => 'text/asp',
    'aspx' => 'text/aspdotnet',
    'asx' => 'application/x-ms-asx',
    'atc' => 'application/vnd.acucorp',
    'atom' => 'application/atom+xml',
    'atomcat' => 'application/atomcat+xml',
    'atomsvc' => 'application/atomsvc+xml',
    'atx' => 'application/vnd.antix.game-component',
    'au' => 'audio/basic',
    'avi' => 'video/x-msvideo',
    'avif' => 'image/avif',
    'aw' => 'application/applixware',
    'awk' => 'text/x-awk',
    'axx' => 'application/x-axcrypt',
    'azf' => 'application/vnd.airzip.filesecure.azf',
    'azs' => 'application/vnd.airzip.filesecure.azs',
    'azw' => 'application/vnd.amazon.ebook',
    'bas' => 'text/x-basic',
    'bash' => 'application/x-sh',
    'bat' => 'application/x-bat',
    'bau' => 'application/vnd.openofficeorg.autotext',
    'bay' => 'image/x-raw-casio',
    'bcpio' => 'application/x-bcpio',
    'bdf' => 'application/x-font-bdf',
    'bdm' => 'application/vnd.syncml.dm+wbxml',
    'bh2' => 'application/vnd.fujitsu.oasysprs',
    'bib' => 'application/x-bibtex-text-file',
    'bibtex' => 'application/x-bibtex-text-file',
    'bin' => 'application/octet-stream',
    'bmi' => 'application/vnd.bmi',
    'bmp' => 'image/bmp',
    'book' => 'application/vnd.framemaker',
    'box' => 'application/vnd.previewsystems.box',
    'boz' => 'application/x-bzip2',
    'bpg' => 'image/x-bpg',
    'bpk' => 'application/octet-stream',
    'bpm' => 'application/bizagi-modeler',
    'br' => 'application/x-brotli',
    'brotli' => 'application/x-brotli',
    'bsh' => 'text/plain',
    'btif' => 'image/prs.btif',
    'bz' => 'application/x-bzip',
    'bz2' => 'application/x-bzip2',
    'c' => 'text/x-c++src',
    'c++' => 'text/x-c++src',
    'c4d' => 'application/vnd.clonk.c4group',
    'c4f' => 'application/vnd.clonk.c4group',
    'c4g' => 'application/vnd.clonk.c4group',
    'c4p' => 'application/vnd.clonk.c4group',
    'c4u' => 'application/vnd.clonk.c4group',
    'cab' => 'application/vnd.ms-cab-compressed',
    'caf' => 'audio/x-caf',
    'cap' => 'application/vnd.tcpdump.pcap',
    'car' => 'application/vnd.curl.car',
    'cat' => 'application/vnd.ms-pki.seccat',
    'cbl' => 'text/x-cobol',
    'cbor' => 'application/cbor',
    'cc' => 'text/x-c++src',
    'cct' => 'application/x-director',
    'ccxml' => 'application/ccxml+xml',
    'cdbcmsg' => 'application/vnd.contact.cmsg',
    'cdf' => 'application/x-netcdf',
    'cdkey' => 'application/vnd.mediastation.cdkey',
    'cdr' => 'application/coreldraw',
    'cdx' => 'chemical/x-cdx',
    'cdxml' => 'application/vnd.chemdraw+xml',
    'cdy' => 'application/vnd.cinderella',
    'cer' => 'application/pkix-cert',
    'cfc' => 'text/x-coldfusion',
    'cfg' => 'text/x-config',
    'cfm' => 'text/x-coldfusion',
    'cfml' => 'text/x-coldfusion',
    'cgi' => 'text/x-cgi',
    'cgm' => 'image/cgm',
    'chat' => 'application/x-chat',
    'chm' => 'application/vnd.ms-htmlhelp',
    'chrt' => 'application/vnd.kde.kchart',
    'cif' => 'chemical/x-cif',
    'cii' => 'application/vnd.anser-web-certificate-issue-initiation',
    'cil' => 'application/vnd.ms-artgalry',
    'cl' => 'text/x-common-lisp',
    'cla' => 'application/vnd.claymore',
    'class' => 'application/java-vm',
    'classpath' => 'text/plain',
    'clj' => 'text/x-clojure',
    'clkk' => 'application/vnd.crick.clicker.keyboard',
    'clkp' => 'application/vnd.crick.clicker.palette',
    'clkt' => 'application/vnd.crick.clicker.template',
    'clkw' => 'application/vnd.crick.clicker.wordbank',
    'clkx' => 'application/vnd.crick.clicker',
    'clp' => 'application/x-msclip',
    'cls' => 'text/x-vbasic',
    'cmc' => 'application/vnd.cosmocaller',
    'cmd' => 'application/x-bat',
    'cmdf' => 'chemical/x-cmdf',
    'cml' => 'chemical/x-cml',
    'cmp' => 'application/vnd.yellowriver-custom-menu',
    'cmx' => 'image/x-cmx',
    'cnd' => 'text/plain',
    'cob' => 'text/x-cobol',
    'cod' => 'application/vnd.rim.cod',
    'coffee' => 'text/x-coffeescript',
    'com' => 'application/x-msdownload',
    'conf' => 'text/x-config',
    'config' => 'text/x-config',
    'cpio' => 'application/x-cpio',
    'cpp' => 'text/x-c++src',
    'cpt' => 'application/mac-compactpro',
    'cr2' => 'image/x-raw-canon',
    'crd' => 'application/x-mscardfile',
    'crl' => 'application/pkix-crl',
    'crt' => 'application/x-x509-cert',
    'crw' => 'image/x-raw-canon',
    'crx' => 'application/x-chrome-package',
    'cs' => 'text/x-csharp',
    'csh' => 'application/x-csh',
    'csml' => 'chemical/x-csml',
    'csp' => 'application/vnd.commonspace',
    'css' => 'text/css',
    'cst' => 'application/x-director',
    'csv' => 'text/csv',
    'cu' => 'application/cu-seeme',
    'curl' => 'text/vnd.curl',
    'cwiki' => 'text/plain',
    'cwk' => 'application/x-appleworks',
    'cww' => 'application/prs.cww',
    'cxt' => 'application/x-director',
    'cxx' => 'text/x-c++src',
    'd' => 'text/x-d',
    'daf' => 'application/vnd.mobius.daf',
    'data' => 'text/plain',
    'dataless' => 'application/vnd.fdsn.seed',
    'davmount' => 'application/davmount+xml',
    'dbase' => 'application/x-dbf',
    'dbase3' => 'application/x-dbf',
    'dbf' => 'application/x-dbf',
    'dcl' => 'text/plain',
    'dcr' => 'application/x-director',
    'dcs' => 'image/x-raw-kodak',
    'dcurl' => 'text/vnd.curl.dcurl',
    'dcx' => 'image/vnd.zbrush.dcx',
    'dd2' => 'application/vnd.oma.dd2+xml',
    'ddd' => 'application/vnd.fujixerox.ddd',
    'deb' => 'application/x-debian-package',
    'def' => 'text/plain',
    'deploy' => 'application/octet-stream',
    'der' => 'application/x-x509-cert;format=der',
    'dex' => 'application/x-dex',
    'dfac' => 'application/vnd.dreamfactory',
    'dib' => 'image/bmp',
    'dif' => 'application/dif+xml',
    'diff' => 'text/x-diff',
    'dir' => 'application/x-director',
    'dis' => 'application/vnd.mobius.dis',
    'dist' => 'application/octet-stream',
    'distz' => 'application/octet-stream',
    'dita' => 'application/dita+xml;format=topic',
    'ditamap' => 'application/dita+xml;format=map',
    'ditaval' => 'application/dita+xml;format=val',
    'djv' => 'image/vnd.djvu',
    'djvu' => 'image/vnd.djvu',
    'dll' => 'application/x-msdownload',
    'dmg' => 'application/x-apple-diskimage',
    'dmp' => 'application/vnd.tcpdump.pcap',
    'dms' => 'application/octet-stream',
    'dna' => 'application/vnd.dna',
    'dng' => 'image/x-raw-adobe',
    'do' => 'application/x-stata-do',
    'doc' => 'application/msword',
    'docm' => 'application/vnd.ms-word.document.macroenabled.12',
    'docx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    'dot' => 'application/msword',
    'dotm' => 'application/vnd.ms-word.template.macroenabled.12',
    'dotx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.template',
    'dp' => 'application/vnd.osgi.dp',
    'dpg' => 'application/vnd.dpgraph',
    'dpr' => 'text/x-pascal',
    'dpx' => 'image/x-dpx',
    'drc' => 'video/x-dirac',
    'drf' => 'image/x-raw-kodak',
    'dsc' => 'text/prs.lines.tag',
    'dsp' => 'text/plain',
    'dsw' => 'text/plain',
    'dta' => 'application/x-stata-dta',
    'dtb' => 'application/x-dtbook+xml',
    'dtd' => 'application/xml-dtd',
    'dts' => 'audio/vnd.dts',
    'dtshd' => 'audio/vnd.dts.hd',
    'dump' => 'application/octet-stream',
    'dvi' => 'application/x-dvi',
    'dwf' => 'model/vnd.dwf',
    'dwfx' => 'model/vnd.dwfx+xps',
    'dwg' => 'image/vnd.dwg',
    'dxb' => 'image/vnd.dxb',
    'dxf' => 'image/vnd.dxf',
    'dxp' => 'application/vnd.spotfire.dxp',
    'dxr' => 'application/x-director',
    'e' => 'text/x-eiffel',
    'ear' => 'application/x-tika-java-enterprise-archive',
    'ecelp4800' => 'audio/vnd.nuera.ecelp4800',
    'ecelp7470' => 'audio/vnd.nuera.ecelp7470',
    'ecelp9600' => 'audio/vnd.nuera.ecelp9600',
    'ecma' => 'application/ecmascript',
    'edm' => 'application/vnd.novadigm.edm',
    'edx' => 'application/vnd.novadigm.edx',
    'efif' => 'application/vnd.picsel',
    'egrm' => 'text/plain',
    'ei6' => 'application/vnd.pg.osasli',
    'el' => 'text/x-emacs-lisp',
    'elc' => 'application/octet-stream',
    'emf' => 'image/emf',
    'eml' => 'message/rfc822',
    'emlx' => 'message/x-emlx',
    'emma' => 'application/emma+xml',
    'emz' => 'image/x-emf-compressed',
    'enr' => 'application/x-endnote-refer',
    'ent' => 'text/plain',
    'enw' => 'application/x-endnote-refer',
    'eol' => 'audio/vnd.digital-winds',
    'eot' => 'application/vnd.ms-fontobject',
    'eps' => 'application/postscript',
    'epsf' => 'application/postscript',
    'epsi' => 'application/postscript',
    'epub' => 'application/epub+zip',
    'erf' => 'image/x-raw-epson',
    'erl' => 'text/x-erlang',
    'es3' => 'application/vnd.eszigno3+xml',
    'esf' => 'application/vnd.epson.esf',
    'et3' => 'application/vnd.eszigno3+xml',
    'etx' => 'text/x-setext',
    'exe' => 'application/x-dosexec',
    'exp' => 'text/x-expect',
    'exr' => 'image/aces',
    'ext' => 'application/vnd.novadigm.ext',
    'ez' => 'application/andrew-inset',
    'ez2' => 'application/vnd.ezpix-album',
    'ez3' => 'application/vnd.ezpix-package',
    'f' => 'text/x-fortran',
    'f4v' => 'video/x-f4v',
    'f77' => 'text/x-fortran',
    'f90' => 'text/x-fortran',
    'fb2' => 'application/x-fictionbook+xml',
    'fbs' => 'image/vnd.fastbidsheet',
    'fdf' => 'application/vnd.fdf',
    'fe_launch' => 'application/vnd.denovo.fcselayout-link',
    'fff' => 'image/x-raw-imacon',
    'fg5' => 'application/vnd.fujitsu.oasysgp',
    'fgd' => 'application/x-director',
    'fh' => 'image/x-freehand',
    'fh10' => 'image/x-freehand',
    'fh11' => 'image/x-freehand',
    'fh12' => 'image/x-freehand',
    'fh4' => 'image/x-freehand',
    'fh40' => 'image/x-freehand',
    'fh5' => 'image/x-freehand',
    'fh50' => 'image/x-freehand',
    'fh7' => 'image/x-freehand',
    'fh8' => 'image/x-freehand',
    'fh9' => 'image/x-freehand',
    'fhc' => 'image/x-freehand',
    'fig' => 'application/x-xfig',
    'fit' => 'application/fits',
    'fits' => 'application/fits',
    'flac' => 'audio/x-flac',
    'flc' => 'video/x-flc',
    'fli' => 'video/x-fli',
    'flo' => 'application/vnd.micrografx.flo',
    'flv' => 'video/x-flv',
    'flw' => 'application/vnd.kde.kivio',
    'flx' => 'text/vnd.fmi.flexstor',
    'fly' => 'text/vnd.fly',
    'fm' => 'application/vnd.framemaker',
    'fn' => 'text/plain',
    'fnc' => 'application/vnd.frogans.fnc',
    'fo' => 'application/xslfo+xml',
    'fodp' => 'application/vnd.oasis.opendocument.flat.presentation',
    'fods' => 'application/vnd.oasis.opendocument.flat.spreadsheet',
    'fodt' => 'application/vnd.oasis.opendocument.flat.text',
    'for' => 'text/x-fortran',
    'fp7' => 'application/x-filemaker',
    'fpx' => 'image/vnd.fpx',
    'frame' => 'application/vnd.framemaker',
    'frm' => 'text/x-vbasic',
    'fsc' => 'application/vnd.fsc.weblaunch',
    'fst' => 'image/vnd.fst',
    'ft' => 'text/plain',
    'ft10' => 'image/x-freehand',
    'ft11' => 'image/x-freehand',
    'ft12' => 'image/x-freehand',
    'ft7' => 'image/x-freehand',
    'ft8' => 'image/x-freehand',
    'ft9' => 'image/x-freehand',
    'ftc' => 'application/vnd.fluxtime.clip',
    'fti' => 'application/vnd.anser-web-funds-transfer-initiation',
    'fts' => 'application/fits',
    'fv' => 'text/plain',
    'fvt' => 'video/vnd.fvt',
    'fzs' => 'application/vnd.fuzzysheet',
    'g' => 'text/plain',
    'g3' => 'image/g3fax',
    'gac' => 'application/vnd.groove-account',
    'gdl' => 'model/vnd.gdl',
    'geo' => 'application/vnd.dynageo',
    'gex' => 'application/vnd.geometry-explorer',
    'ggb' => 'application/vnd.geogebra.file',
    'ggt' => 'application/vnd.geogebra.tool',
    'ghf' => 'application/vnd.groove-help',
    'gif' => 'image/gif',
    'gim' => 'application/vnd.groove-identity-message',
    'gmx' => 'application/vnd.gmx',
    'gnucash' => 'application/x-gnucash',
    'gnumeric' => 'application/x-gnumeric',
    'go' => 'text/x-go',
    'gph' => 'application/vnd.flographit',
    'gqf' => 'application/vnd.grafeq',
    'gqs' => 'application/vnd.grafeq',
    'gram' => 'application/srgs',
    'grb' => 'application/x-grib',
    'grb1' => 'application/x-grib',
    'grb2' => 'application/x-grib',
    'gre' => 'application/vnd.geometry-explorer',
    'grm' => 'text/plain',
    'groovy' => 'text/x-groovy',
    'grv' => 'application/vnd.groove-injector',
    'grxml' => 'application/srgs+xml',
    'gsf' => 'application/x-font-ghostscript',
    'gtar' => 'application/x-gtar',
    'gtm' => 'application/vnd.groove-tool-message',
    'gtw' => 'model/vnd.gtw',
    'gv' => 'text/vnd.graphviz',
    'gz' => 'application/gzip',
    'h' => 'text/x-c++hdr',
    'h++' => 'text/x-c++hdr',
    'h261' => 'video/h261',
    'h263' => 'video/h263',
    'h264' => 'video/h264',
    'h5' => 'application/x-hdf',
    'haml' => 'text/x-haml',
    'handlers' => 'text/plain',
    'hbci' => 'application/vnd.hbci',
    'hdf' => 'application/x-hdf',
    'hdr' => 'application/envi.hdr',
    'he5' => 'application/x-hdf',
    'heic' => 'image/heic',
    'heif' => 'image/heif',
    'hfa' => 'application/x-erdas-hfa',
    'hh' => 'text/x-c++hdr',
    'hlp' => 'application/winhlp',
    'hp' => 'text/x-c++hdr',
    'hpgl' => 'application/vnd.hp-hpgl',
    'hpid' => 'application/vnd.hp-hpid',
    'hpp' => 'text/x-c++hdr',
    'hprof' => 'application/vnd.java.hprof ',
    'hprof.txt' => 'application/vnd.java.hprof.text',
    'hps' => 'application/vnd.hp-hps',
    'hqx' => 'application/mac-binhex40',
    'hs' => 'text/x-haskell',
    'htc' => 'text/plain',
    'htke' => 'application/vnd.kenameaapp',
    'htm' => 'text/html',
    'html' => 'text/html',
    'hvd' => 'application/vnd.yamaha.hv-dic',
    'hvp' => 'application/vnd.yamaha.hv-voice',
    'hvs' => 'application/vnd.yamaha.hv-script',
    'hx' => 'text/x-haxe',
    'hxx' => 'text/x-c++hdr',
    'i3' => 'text/x-modula',
    'ibooks' => 'application/x-ibooks+zip',
    'icb' => 'image/x-tga',
    'icc' => 'application/vnd.iccprofile',
    'ice' => 'x-conference/x-cooltalk',
    'icm' => 'application/vnd.iccprofile',
    'icns' => 'image/icns',
    'ico' => 'image/vnd.microsoft.icon',
    'ics' => 'text/calendar',
    'idl' => 'text/x-idl',
    'ief' => 'image/ief',
    'ifb' => 'text/calendar',
    'ifm' => 'application/vnd.shana.informed.formdata',
    'ig' => 'text/x-modula',
    'iges' => 'model/iges',
    'igl' => 'application/vnd.igloader',
    'igs' => 'model/iges',
    'igx' => 'application/vnd.micrografx.igx',
    'ihtml' => 'text/plain',
    'iif' => 'application/vnd.shana.informed.interchange',
    'iiq' => 'image/x-raw-phaseone',
    'imp' => 'application/vnd.accpac.simply.imp',
    'ims' => 'application/vnd.ms-ims',
    'in' => 'text/plain',
    'indd' => 'application/x-adobe-indesign',
    'ini' => 'text/x-ini',
    'inx' => 'application/x-adobe-indesign-interchange',
    'ipa' => 'application/x-itunes-ipa',
    'ipk' => 'application/vnd.shana.informed.package',
    'irm' => 'application/vnd.ibm.rights-management',
    'irp' => 'application/vnd.irepository.package+xml',
    'iso' => 'application/x-iso9660-image',
    'iso19139' => 'text/iso19139+xml',
    'itk' => 'text/x-tcl',
    'itp' => 'application/vnd.shana.informed.formtemplate',
    'ivp' => 'application/vnd.immervision-ivp',
    'ivu' => 'application/vnd.immervision-ivu',
    'j2c' => 'image/x-jp2-codestream',
    'jad' => 'text/vnd.sun.j2me.app-descriptor',
    'jam' => 'application/vnd.jam',
    'jar' => 'application/java-archive',
    'java' => 'text/x-java-source',
    'jb2' => 'image/x-jbig2',
    'jbig2' => 'image/x-jbig2',
    'jfi' => 'image/jpeg',
    'jfif' => 'image/jpeg',
    'jif' => 'image/jpeg',
    'jisp' => 'application/vnd.jisp',
    'jl' => 'text/x-common-lisp',
    'jlt' => 'application/vnd.hp-jlyt',
    'jmx' => 'text/plain',
    'jng' => 'video/x-jng',
    'jnilib' => 'application/x-java-jnilib',
    'jnlp' => 'application/x-java-jnlp-file',
    'joda' => 'application/vnd.joost.joda-archive',
    'jp2' => 'image/jp2',
    'jpe' => 'image/jpeg',
    'jpeg' => 'image/jpeg',
    'jpf' => 'image/jpx',
    'jpg' => 'image/jpeg',
    'jpgm' => 'image/jpm',
    'jpgv' => 'video/jpeg',
    'jpm' => 'image/jpm',
    'js' => 'application/javascript',
    'json' => 'application/json',
    'jsp' => 'text/x-jsp',
    'junit' => 'text/plain',
    'jx' => 'text/plain',
    'k25' => 'image/x-raw-kodak',
    'kar' => 'audio/midi',
    'karbon' => 'application/vnd.kde.karbon',
    'kdc' => 'image/x-raw-kodak',
    'key' => 'application/vnd.apple.keynote',
    'kfo' => 'application/vnd.kde.kformula',
    'kia' => 'application/vnd.kidspiration',
    'kil' => 'application/x-killustrator',
    'kml' => 'application/vnd.google-earth.kml+xml',
    'kmz' => 'application/vnd.google-earth.kmz',
    'kne' => 'application/vnd.kinar',
    'knp' => 'application/vnd.kinar',
    'kon' => 'application/vnd.kde.kontour',
    'kpr' => 'application/vnd.kde.kpresenter',
    'kpt' => 'application/vnd.kde.kpresenter',
    'ksp' => 'application/vnd.kde.kspread',
    'ktr' => 'application/vnd.kahootz',
    'ktz' => 'application/vnd.kahootz',
    'kwd' => 'application/vnd.kde.kword',
    'kwt' => 'application/vnd.kde.kword',
    'l' => 'text/x-lex',
    'latex' => 'application/x-latex',
    'lbd' => 'application/vnd.llamagraphics.life-balance.desktop',
    'lbe' => 'application/vnd.llamagraphics.life-balance.exchange+xml',
    'les' => 'application/vnd.hhe.lesson-player',
    'less' => 'text/x-less',
    'lha' => 'application/octet-stream',
    'lhs' => 'text/x-haskell',
    'link66' => 'application/vnd.route66.link66+xml',
    'lisp' => 'text/x-common-lisp',
    'list' => 'text/plain',
    'list3820' => 'application/vnd.ibm.modcap',
    'listafp' => 'application/vnd.ibm.modcap',
    'log' => 'text/x-log',
    'lostxml' => 'application/lost+xml',
    'lrf' => 'application/octet-stream',
    'lrm' => 'application/vnd.ms-lrm',
    'lsp' => 'text/x-common-lisp',
    'ltf' => 'application/vnd.frogans.ltf',
    'lua' => 'text/x-lua',
    'lvp' => 'audio/vnd.lucent.voice',
    'lwp' => 'application/vnd.lotus-wordpro',
    'lz' => 'application/x-lzip',
    'lz4' => 'application/x-lz4',
    'lzh' => 'application/octet-stream',
    'lzma' => 'application/x-lzma',
    'm' => 'text/x-objcsrc',
    'm13' => 'application/x-msmediaview',
    'm14' => 'application/x-msmediaview',
    'm1v' => 'video/mpeg',
    'm2a' => 'audio/mpeg',
    'm2v' => 'video/mpeg',
    'm3' => 'text/x-modula',
    'm3a' => 'audio/mpeg',
    'm3u' => 'audio/x-mpegurl',
    'm3u8' => 'application/vnd.apple.mpegurl',
    'm4' => 'text/plain',
    'm4a' => 'audio/mp4',
    'm4b' => 'audio/mp4',
    'm4s' => 'video/iso.segment',
    'm4u' => 'video/vnd.mpegurl',
    'm4v' => 'video/x-m4v',
    'ma' => 'application/mathematica',
    'mag' => 'application/vnd.ecowin.chart',
    'maker' => 'application/vnd.framemaker',
    'man' => 'text/troff',
    'manifest' => 'text/plain',
    'markdown' => 'text/x-web-markdown',
    'mat' => 'application/x-matlab-data',
    'mathml' => 'application/mathml+xml',
    'mb' => 'application/mathematica',
    'mbk' => 'application/vnd.mobius.mbk',
    'mbox' => 'application/mbox',
    'mc1' => 'application/vnd.medcalcdata',
    'mcd' => 'application/vnd.mcd',
    'mcurl' => 'text/vnd.curl.mcurl',
    'md' => 'text/x-web-markdown',
    'mdb' => 'application/x-msaccess',
    'mdi' => 'image/vnd.ms-modi',
    'mdo' => 'text/plain',
    'mdtext' => 'text/x-web-markdown',
    'me' => 'text/troff',
    'mef' => 'image/x-raw-mamiya',
    'memgraph' => 'application/x-memgraph',
    'mesh' => 'model/mesh',
    'meta' => 'text/plain',
    'mf' => 'text/plain',
    'mfm' => 'application/vnd.mfmp',
    'mg' => 'text/x-modula',
    'mgz' => 'application/vnd.proteus.magazine',
    'mht' => 'multipart/related',
    'mhtml' => 'multipart/related',
    'mid' => 'audio/midi',
    'midi' => 'audio/midi',
    'mif' => 'application/vnd.mif',
    'mime' => 'message/rfc822',
    'mj2' => 'video/mj2',
    'mjp2' => 'video/mj2',
    'mka' => 'audio/x-matroska',
    'mkd' => 'text/x-web-markdown',
    'mkv' => 'video/x-matroska',
    'ml' => 'text/x-ml',
    'mli' => 'text/x-ocaml',
    'mlp' => 'application/vnd.dolby.mlp',
    'mmap' => 'application/vnd.mindjet.mindmanager',
    'mmas' => 'application/vnd.mindjet.mindmanager',
    'mmat' => 'application/vnd.mindjet.mindmanager',
    'mmd' => 'application/vnd.chipnuts.karaoke-mmd',
    'mmf' => 'application/vnd.smaf',
    'mmmp' => 'application/vnd.mindjet.mindmanager',
    'mmp' => 'application/vnd.mindjet.mindmanager',
    'mmpt' => 'application/vnd.mindjet.mindmanager',
    'mmr' => 'image/vnd.fujixerox.edmics-mmr',
    'mng' => 'video/x-mng',
    'mny' => 'application/x-msmoney',
    'mobi' => 'application/x-mobipocket-ebook',
    'mod' => 'audio/x-mod',
    'mos' => 'image/x-raw-leaf',
    'mov' => 'video/quicktime',
    'movie' => 'video/x-sgi-movie',
    'mp2' => 'audio/mpeg',
    'mp2a' => 'audio/mpeg',
    'mp3' => 'audio/mpeg',
    'mp4' => 'video/mp4',
    'mp4a' => 'audio/mp4',
    'mp4s' => 'application/mp4',
    'mp4v' => 'video/mp4',
    'mpc' => 'application/vnd.mophun.certificate',
    'mpd' => 'application/dash+xml',
    'mpe' => 'video/mpeg',
    'mpeg' => 'video/mpeg',
    'mpg' => 'video/mpeg',
    'mpg4' => 'video/mp4',
    'mpga' => 'audio/mpeg',
    'mpkg' => 'application/vnd.apple.installer+xml',
    'mpm' => 'application/vnd.blueice.multipass',
    'mpn' => 'application/vnd.mophun.application',
    'mpp' => 'application/vnd.ms-project',
    'mpt' => 'application/vnd.ms-project',
    'mpx' => 'application/x-project',
    'mpy' => 'application/vnd.ibm.minipay',
    'mqy' => 'application/vnd.mobius.mqy',
    'mrc' => 'application/marc',
    'mrw' => 'image/x-raw-minolta',
    'ms' => 'text/troff',
    'mscml' => 'application/mediaservercontrol+xml',
    'mseed' => 'application/vnd.fdsn.mseed',
    'mseq' => 'application/vnd.mseq',
    'msf' => 'application/vnd.epson.msf',
    'msg' => 'application/vnd.ms-outlook',
    'msh' => 'model/mesh',
    'msi' => 'application/x-ms-installer',
    'msl' => 'application/vnd.mobius.msl',
    'msp' => 'application/x-ms-installer',
    'mst' => 'application/x-ms-installer',
    'msty' => 'application/vnd.muvee.style',
    'mts' => 'model/vnd.mts',
    'mus' => 'application/vnd.musician',
    'musicxml' => 'application/vnd.recordare.musicxml+xml',
    'mvb' => 'application/x-msmediaview',
    'mwf' => 'application/vnd.mfer',
    'mxf' => 'application/mxf',
    'mxl' => 'application/vnd.recordare.musicxml',
    'mxml' => 'application/xv+xml',
    'mxs' => 'application/vnd.triscape.mxs',
    'mxu' => 'video/vnd.mpegurl',
    'myd' => 'application/x-mysql-misam-data',
    'myi' => 'application/x-mysql-misam-compressed-index',
    'n-gage' => 'application/vnd.nokia.n-gage.symbian.install',
    'n3' => 'text/plain',
    'nar' => 'application/vnd.iptc.g2.newsmessage+xml',
    'nb' => 'application/mathematica',
    'nc' => 'application/x-netcdf',
    'ncx' => 'application/x-dtbncx+xml',
    'nef' => 'image/x-raw-nikon',
    'ngdat' => 'application/vnd.nokia.n-gage.data',
    'nitf' => 'image/nitf',
    'nlu' => 'application/vnd.neurolanguage.nlu',
    'nml' => 'application/vnd.enliven',
    'nnd' => 'application/vnd.noblenet-directory',
    'nns' => 'application/vnd.noblenet-sealer',
    'nnw' => 'application/vnd.noblenet-web',
    'npx' => 'image/vnd.net-fpx',
    'nroff' => 'text/troff',
    'nrw' => 'image/x-raw-nikon',
    'nsf' => 'application/vnd.lotus-notes',
    'ntf' => 'image/nitf',
    'numbers' => 'application/vnd.apple.numbers',
    'oa2' => 'application/vnd.fujitsu.oasys2',
    'oa3' => 'application/vnd.fujitsu.oasys3',
    'oas' => 'application/vnd.fujitsu.oasys',
    'obd' => 'application/x-msbinder',
    'ocaml' => 'text/x-ocaml',
    'oda' => 'application/oda',
    'odb' => 'application/vnd.oasis.opendocument.base',
    'odc' => 'application/vnd.oasis.opendocument.chart',
    'odf' => 'application/vnd.oasis.opendocument.formula',
    'odft' => 'application/vnd.oasis.opendocument.formula-template',
    'odg' => 'application/vnd.oasis.opendocument.graphics',
    'odi' => 'application/vnd.oasis.opendocument.image',
    'odp' => 'application/vnd.oasis.opendocument.presentation',
    'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
    'odt' => 'application/vnd.oasis.opendocument.text',
    'oga' => 'audio/ogg',
    'ogg' => 'audio/vorbis',
    'ogm' => 'video/x-ogm',
    'ogv' => 'video/ogg',
    'ogx' => 'application/ogg',
    'one' => 'application/onenote;format=one',
    'onepkg' => 'application/onenote; format=package',
    'onetmp' => 'application/onenote',
    'onetoc' => 'application/onenote;format=onetoc2',
    'onetoc2' => 'application/onenote;format=onetoc2',
    'opf' => 'application/oebps-package+xml',
    'oprc' => 'application/vnd.palm',
    'opus' => 'audio/opus',
    'orf' => 'image/x-raw-olympus',
    'org' => 'application/vnd.lotus-organizer',
    'osf' => 'application/vnd.yamaha.openscoreformat',
    'osfpvg' => 'application/vnd.yamaha.openscoreformat.osfpvg+xml',
    'ost' => 'application/vnd.ms-outlook-pst',
    'otc' => 'application/vnd.oasis.opendocument.chart-template',
    'otf' => 'application/x-font-otf',
    'otg' => 'application/vnd.oasis.opendocument.graphics-template',
    'oth' => 'application/vnd.oasis.opendocument.text-web',
    'oti' => 'application/vnd.oasis.opendocument.image-template',
    'otm' => 'application/vnd.oasis.opendocument.text-master',
    'otp' => 'application/vnd.oasis.opendocument.presentation-template',
    'ots' => 'application/vnd.oasis.opendocument.spreadsheet-template',
    'ott' => 'application/vnd.oasis.opendocument.text-template',
    'owl' => 'application/rdf+xml',
    'oxps' => 'application/vnd.ms-xpsdocument',
    'oxt' => 'application/vnd.openofficeorg.extension',
    'p' => 'text/x-pascal',
    'p10' => 'application/pkcs10',
    'p12' => 'application/x-pkcs12',
    'p7b' => 'application/x-pkcs7-certificates',
    'p7c' => 'application/pkcs7-mime',
    'p7m' => 'application/pkcs7-mime',
    'p7r' => 'application/x-pkcs7-certreqresp',
    'p7s' => 'application/pkcs7-signature',
    'pack' => 'application/x-java-pack200',
    'pages' => 'application/vnd.apple.pages',
    'parquet' => 'application/x-parquet',
    'pas' => 'text/x-pascal',
    'patch' => 'text/x-diff',
    'pbd' => 'application/vnd.powerbuilder6',
    'pbm' => 'image/x-portable-bitmap',
    'pcap' => 'application/vnd.tcpdump.pcap',
    'pcf' => 'application/x-font-pcf',
    'pcl' => 'application/vnd.hp-pcl',
    'pclxl' => 'application/vnd.hp-pclxl',
    'pct' => 'image/x-pict',
    'pcurl' => 'application/vnd.curl.pcurl',
    'pcx' => 'image/vnd.zbrush.pcx',
    'pdb' => 'chemical/x-pdb',
    'pdf' => 'application/pdf',
    'pef' => 'image/x-raw-pentax',
    'pem' => 'application/x-x509-cert;format=pem',
    'pen' => 'text/plain',
    'perl' => 'text/x-perl',
    'pfa' => 'application/x-font-type1',
    'pfb' => 'application/x-font-type1',
    'pfm' => 'application/x-font-printer-metric',
    'pfr' => 'application/font-tdpfr',
    'pfx' => 'application/x-pkcs12',
    'pgm' => 'image/x-portable-graymap',
    'pgn' => 'application/x-chess-pgn',
    'pgp' => 'application/pgp-encrypted',
    'php' => 'text/x-php',
    'php3' => 'text/x-php',
    'php4' => 'text/x-php',
    'pic' => 'image/x-pict',
    'pict' => 'image/x-pict',
    'pkg' => 'application/octet-stream',
    'pki' => 'application/pkixcmp',
    'pkipath' => 'application/pkix-pkipath',
    'pl' => 'text/x-perl',
    'plb' => 'application/vnd.3gpp.pic-bw-large',
    'plc' => 'application/vnd.mobius.plc',
    'plf' => 'application/vnd.pocketlearn',
    'pls' => 'application/pls+xml',
    'pm' => 'text/x-perl',
    'pml' => 'application/vnd.ctc-posml',
    'png' => 'image/png',
    'pnm' => 'image/x-portable-anymap',
    'pod' => 'text/plain',
    'pom' => 'text/plain',
    'portpkg' => 'application/vnd.macports.portpkg',
    'pot' => 'application/vnd.ms-powerpoint',
    'potm' => 'application/vnd.ms-powerpoint.template.macroenabled.12',
    'potx' => 'application/vnd.openxmlformats-officedocument.presentationml.template',
    'pp' => 'text/x-pascal',
    'ppa' => 'application/vnd.ms-powerpoint',
    'ppam' => 'application/vnd.ms-powerpoint.addin.macroenabled.12',
    'ppd' => 'application/vnd.cups-ppd',
    'ppj' => 'image/vnd.adobe.premiere',
    'ppm' => 'image/x-portable-pixmap',
    'pps' => 'application/vnd.ms-powerpoint',
    'ppsm' => 'application/vnd.ms-powerpoint.slideshow.macroenabled.12',
    'ppsx' => 'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
    'ppt' => 'application/vnd.ms-powerpoint',
    'pptm' => 'application/vnd.ms-powerpoint.presentation.macroenabled.12',
    'pptx' => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
    'ppz' => 'application/vnd.ms-powerpoint',
    'pqa' => 'application/vnd.palm',
    'prc' => 'application/x-mobipocket-ebook',
    'pre' => 'application/vnd.lotus-freelance',
    'prf' => 'application/pics-rules',
    'pro' => 'text/x-prolog',
    'project' => 'text/plain',
    'properties' => 'text/x-java-properties',
    'prt' => 'application/x-prt',
    'ps' => 'application/postscript',
    'psb' => 'application/vnd.3gpp.pic-bw-small',
    'psd' => 'image/vnd.adobe.photoshop',
    'psf' => 'application/x-font-linux-psf',
    'pst' => 'application/vnd.ms-outlook-pst',
    'ptid' => 'application/vnd.pvi.ptid1',
    'ptx' => 'image/x-raw-pentax',
    'pub' => 'application/x-mspublisher',
    'pvb' => 'application/vnd.3gpp.pic-bw-var',
    'pwn' => 'application/vnd.3m.post-it-notes',
    'pxn' => 'image/x-raw-logitech',
    'py' => 'text/x-python',
    'pya' => 'audio/vnd.ms-playready.media.pya',
    'pyv' => 'video/vnd.ms-playready.media.pyv',
    'qam' => 'application/vnd.epson.quickanime',
    'qbo' => 'application/vnd.intu.qbo',
    'qfx' => 'application/vnd.intu.qfx',
    'qps' => 'application/vnd.publishare-delta-tree',
    'qpw' => 'application/x-quattro-pro',
    'qt' => 'video/quicktime',
    'qwd' => 'application/vnd.quark.quarkxpress',
    'qwt' => 'application/vnd.quark.quarkxpress',
    'qxb' => 'application/vnd.quark.quarkxpress',
    'qxd' => 'application/vnd.quark.quarkxpress',
    'qxl' => 'application/vnd.quark.quarkxpress',
    'qxt' => 'application/vnd.quark.quarkxpress',
    'r' => 'text/x-rsrc',
    'r3d' => 'image/x-raw-red',
    'ra' => 'audio/x-pn-realaudio',
    'raf' => 'image/x-raw-fuji',
    'ram' => 'audio/x-pn-realaudio',
    'rar' => 'application/x-rar-compressed',
    'ras' => 'image/x-cmu-raster',
    'raw' => 'image/x-raw-panasonic',
    'rb' => 'text/x-ruby',
    'rcprofile' => 'application/vnd.ipunplugged.rcprofile',
    'rdf' => 'application/rdf+xml',
    'rdz' => 'application/vnd.data-vision.rdz',
    'rep' => 'application/vnd.businessobjects',
    'res' => 'application/x-dtbresource+xml',
    'rest' => 'text/x-rst',
    'restx' => 'text/x-rst',
    'rexx' => 'text/x-rexx',
    'rgb' => 'image/x-rgb',
    'rif' => 'application/reginfo+xml',
    'rl' => 'application/resource-lists+xml',
    'rlc' => 'image/vnd.fujixerox.edmics-rlc',
    'rld' => 'application/resource-lists-diff+xml',
    'rm' => 'application/vnd.rn-realmedia',
    'rmi' => 'audio/midi',
    'rmp' => 'audio/x-pn-realaudio-plugin',
    'rms' => 'application/vnd.jcp.javame.midlet-rms',
    'rnc' => 'application/relax-ng-compact-syntax',
    'rng' => 'text/plain',
    'rnx' => 'text/plain',
    'roff' => 'text/troff',
    'roles' => 'text/plain',
    'rpm' => 'application/x-rpm',
    'rpss' => 'application/vnd.nokia.radio-presets',
    'rpst' => 'application/vnd.nokia.radio-preset',
    'rq' => 'application/sparql-query',
    'rs' => 'application/rls-services+xml',
    'rsd' => 'application/rsd+xml',
    'rss' => 'application/rss+xml',
    'rst' => 'text/x-rst',
    'rtf' => 'application/rtf',
    'rtx' => 'text/richtext',
    'rw2' => 'image/x-raw-panasonic',
    'rwz' => 'image/x-raw-rawzor',
    's' => 'text/x-assembly',
    's7m' => 'application/x-sas-dmdb',
    'sa7' => 'application/x-sas-access',
    'saf' => 'application/vnd.yamaha.smaf-audio',
    'sas' => 'application/x-sas',
    'sas7bacs' => 'application/x-sas-access',
    'sas7baud' => 'application/x-sas-audit',
    'sas7bbak' => 'application/x-sas-backup',
    'sas7bcat' => 'application/x-sas-catalog',
    'sas7bdat' => 'application/x-sas-data',
    'sas7bdmd' => 'application/x-sas-dmdb',
    'sas7bfdb' => 'application/x-sas-fdb',
    'sas7bitm' => 'application/x-sas-itemstor',
    'sas7bmdb' => 'application/x-sas-mddb',
    'sas7bndx' => 'application/x-sas-data-index',
    'sas7bpgm' => 'application/x-sas-program-data',
    'sas7bput' => 'application/x-sas-putility',
    'sas7butl' => 'application/x-sas-utility',
    'sas7bvew' => 'application/x-sas-view',
    'sass' => 'text/x-sass',
    'sbml' => 'application/sbml+xml',
    'sc' => 'application/vnd.ibm.secure-container',
    'sc7' => 'application/x-sas-catalog',
    'scala' => 'text/x-scala',
    'scd' => 'application/x-msschedule',
    'schemas' => 'text/plain',
    'scm' => 'text/x-scheme',
    'scq' => 'application/scvp-cv-request',
    'scs' => 'application/scvp-cv-response',
    'scss' => 'text/x-scss',
    'scurl' => 'text/vnd.curl.scurl',
    'sd2' => 'application/x-sas-data-v6',
    'sd7' => 'application/x-sas-data',
    'sda' => 'application/vnd.stardivision.draw',
    'sdc' => 'application/vnd.stardivision.calc',
    'sdd' => 'application/vnd.stardivision.impress',
    'sdkd' => 'application/vnd.solent.sdkm+xml',
    'sdkm' => 'application/vnd.solent.sdkm+xml',
    'sdp' => 'application/sdp',
    'sdw' => 'application/vnd.stardivision.writer',
    'sed' => 'text/x-sed',
    'see' => 'application/vnd.seemail',
    'seed' => 'application/vnd.fdsn.seed',
    'sema' => 'application/vnd.sema',
    'semd' => 'application/vnd.semd',
    'semf' => 'application/vnd.semf',
    'ser' => 'application/java-serialized-object',
    'setpay' => 'application/set-payment-initiation',
    'setreg' => 'application/set-registration-initiation',
    'sf7' => 'application/x-sas-fdb',
    'sfd-hdstx' => 'application/vnd.hydrostatix.sof-data',
    'sfdu' => 'application/x-sfdu',
    'sfs' => 'application/vnd.spotfire.sfs',
    'sgl' => 'application/vnd.stardivision.writer-global',
    'sgm' => 'text/sgml',
    'sgml' => 'text/sgml',
    'sh' => 'application/x-sh',
    'shar' => 'application/x-shar',
    'shf' => 'application/shf+xml',
    'shp' => 'application/x-shapefile',
    'shw' => 'application/x-corelpresentations',
    'si7' => 'application/x-sas-data-index',
    'sig' => 'application/pgp-signature',
    'silo' => 'model/mesh',
    'sis' => 'application/vnd.symbian.install',
    'sisx' => 'application/vnd.symbian.install',
    'sit' => 'application/x-stuffit',
    'sitx' => 'application/x-stuffitx',
    'skd' => 'application/vnd.koan',
    'skm' => 'application/vnd.koan',
    'skp' => 'application/vnd.koan',
    'skt' => 'application/vnd.koan',
    'sldasm' => 'application/sldworks',
    'slddrw' => 'application/sldworks',
    'sldm' => 'application/vnd.ms-powerpoint.slide.macroenabled.12',
    'sldprt' => 'application/sldworks',
    'sldx' => 'application/vnd.openxmlformats-officedocument.presentationml.slide',
    'slt' => 'application/vnd.epson.salt',
    'sm7' => 'application/x-sas-mddb',
    'smf' => 'application/vnd.stardivision.math',
    'smi' => 'application/smil+xml',
    'smil' => 'application/smil+xml',
    'sml' => 'application/smil+xml',
    'snd' => 'audio/basic',
    'snf' => 'application/x-font-snf',
    'so' => 'application/octet-stream',
    'sp7' => 'application/x-sas-putility',
    'spc' => 'application/x-pkcs7-certificates',
    'spf' => 'application/vnd.yamaha.smaf-phrase',
    'spl' => 'application/x-futuresplash',
    'spot' => 'text/vnd.in3d.spot',
    'spp' => 'application/scvp-vp-response',
    'spq' => 'application/scvp-vp-request',
    'spx' => 'audio/speex',
    'sql' => 'text/x-sql',
    'sr2' => 'image/x-raw-sony',
    'sr7' => 'application/x-sas-itemstor',
    'src' => 'application/x-wais-source',
    'srf' => 'image/x-raw-sony',
    'srl' => 'application/sereal',
    'srx' => 'application/sparql-results+xml',
    'ss7' => 'application/x-sas-program-data',
    'sse' => 'application/vnd.kodak-descriptor',
    'ssf' => 'application/vnd.epson.ssf',
    'ssml' => 'application/ssml+xml',
    'st' => 'text/x-stsrc',
    'st7' => 'application/x-sas-audit',
    'stc' => 'application/vnd.sun.xml.calc.template',
    'std' => 'application/vnd.sun.xml.draw.template',
    'stf' => 'application/vnd.wt.stf',
    'sti' => 'application/vnd.sun.xml.impress.template',
    'stk' => 'application/hyperstudio',
    'stl' => 'application/vnd.ms-pki.stl',
    'str' => 'application/vnd.pg.format',
    'stw' => 'application/vnd.sun.xml.writer.template',
    'stx' => 'application/x-sas-transport',
    'su7' => 'application/x-sas-utility',
    'sus' => 'application/vnd.sus-calendar',
    'susp' => 'application/vnd.sus-calendar',
    'sv4cpio' => 'application/x-sv4cpio',
    'sv4crc' => 'application/x-sv4crc',
    'sv7' => 'application/x-sas-view',
    'svd' => 'application/vnd.svd',
    'svg' => 'image/svg+xml',
    'svgz' => 'image/svg+xml',
    'swa' => 'application/x-director',
    'swf' => 'application/x-shockwave-flash',
    'swi' => 'application/vnd.arastra.swi',
    'sxc' => 'application/vnd.sun.xml.calc',
    'sxd' => 'application/vnd.sun.xml.draw',
    'sxg' => 'application/vnd.sun.xml.writer.global',
    'sxi' => 'application/vnd.sun.xml.impress',
    'sxm' => 'application/vnd.sun.xml.math',
    'sxw' => 'application/vnd.sun.xml.writer',
    'sz' => 'application/x-snappy-framed',
    't' => 'text/troff',
    'tao' => 'application/vnd.tao.intent-module-archive',
    'tar' => 'application/x-tar',
    'tbz' => 'application/x-bzip',
    'tbz2' => 'application/x-bzip2',
    'tcap' => 'application/vnd.3gpp2.tcap',
    'tcl' => 'text/x-tcl',
    'tcsh' => 'application/x-csh',
    'teacher' => 'application/vnd.smart.teacher',
    'tex' => 'application/x-tex',
    'texi' => 'application/x-texinfo',
    'texinfo' => 'application/x-texinfo',
    'text' => 'text/plain',
    'tfm' => 'application/x-tex-tfm',
    'tga' => 'image/x-tga',
    'tgz' => 'application/gzip',
    'thmx' => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
    'tif' => 'image/tiff',
    'tiff' => 'image/tiff',
    'tk' => 'text/x-tcl',
    'tld' => 'text/plain',
    'tmo' => 'application/vnd.tmobile-livetv',
    'toast' => 'application/x-roxio-toast',
    'torrent' => 'application/x-bittorrent',
    'tpl' => 'application/vnd.groove-tool-template',
    'tpt' => 'application/vnd.trid.tpt',
    'tr' => 'text/troff',
    'tra' => 'application/vnd.trueapp',
    'trm' => 'application/x-msterminal',
    'tsd' => 'application/timestamped-data',
    'tsv' => 'text/tab-separated-values',
    'ttc' => 'application/x-font-ttf',
    'ttf' => 'application/x-font-ttf',
    'twd' => 'application/vnd.simtech-mindmapper',
    'twds' => 'application/vnd.simtech-mindmapper',
    'txd' => 'application/vnd.genomatix.tuxedo',
    'txf' => 'application/vnd.mobius.txf',
    'txt' => 'text/plain',
    'types' => 'text/plain',
    'u32' => 'application/x-authorware-bin',
    'uc2' => 'application/x-uc2-compressed',
    'udeb' => 'application/x-debian-package',
    'ufd' => 'application/vnd.ufdl',
    'ufdl' => 'application/vnd.ufdl',
    'umj' => 'application/vnd.umajin',
    'unityweb' => 'application/vnd.unity',
    'uoml' => 'application/vnd.uoml+xml',
    'uri' => 'text/uri-list',
    'uris' => 'text/uri-list',
    'urls' => 'text/uri-list',
    'ustar' => 'application/x-ustar',
    'utz' => 'application/vnd.uiq.theme',
    'uu' => 'text/x-uuencode',
    'v' => 'text/x-verilog',
    'vb' => 'text/x-vbdotnet',
    'vbs' => 'text/x-vbscript',
    'vcd' => 'application/x-cdlink',
    'vcf' => 'text/x-vcard',
    'vcg' => 'application/vnd.groove-vcard',
    'vcs' => 'text/x-vcalendar',
    'vcx' => 'application/vnd.vcx',
    'vda' => 'image/x-tga',
    'vhd' => 'text/x-vhdl',
    'vhdl' => 'text/x-vhdl',
    'vis' => 'application/vnd.visionary',
    'viv' => 'video/vnd.vivo',
    'vm' => 'text/plain',
    'vmdk' => 'application/x-vmdk',
    'vor' => 'application/x-staroffice-template',
    'vox' => 'application/x-authorware-bin',
    'vrml' => 'model/vrml',
    'vsd' => 'application/vnd.visio',
    'vsdm' => 'application/vnd.ms-visio.drawing.macroEnabled.12',
    'vsdx' => 'application/vnd.ms-visio.drawing',
    'vsf' => 'application/vnd.vsf',
    'vsl' => 'text/plain',
    'vss' => 'application/vnd.visio',
    'vssm' => 'application/vnd.ms-visio.stencil.macroEnabled.12',
    'vssx' => 'application/vnd.ms-visio.stencil',
    'vst' => 'application/vnd.visio',
    'vstm' => 'application/vnd.ms-visio.template.macroEnabled.12',
    'vstx' => 'application/vnd.ms-visio.template',
    'vsw' => 'application/vnd.visio',
    'vtt' => 'text/vtt',
    'vtu' => 'model/vnd.vtu',
    'vxml' => 'application/voicexml+xml',
    'w3d' => 'application/x-director',
    'w60' => 'application/vnd.wordperfect',
    'wad' => 'application/x-doom',
    'war' => 'application/x-tika-java-web-archive',
    'warc' => 'application/warc',
    'wasm' => 'application/wasm',
    'wav' => 'audio/vnd.wave',
    'wax' => 'audio/x-ms-wax',
    'wb1' => 'application/x-quattro-pro',
    'wb2' => 'application/x-quattro-pro',
    'wb3' => 'application/x-quattro-pro',
    'wbmp' => 'image/vnd.wap.wbmp',
    'wbs' => 'application/vnd.criticaltools.wbs+xml',
    'wbxml' => 'application/vnd.wap.wbxml',
    'wcm' => 'application/vnd.ms-works',
    'wdb' => 'application/vnd.ms-works',
    'webarchive' => 'application/x-webarchive',
    'webm' => 'video/webm',
    'webp' => 'image/webp',
    'wk1' => 'application/vnd.lotus-1-2-3',
    'wk2' => 'application/vnd.lotus-1-2-3',
    'wk3' => 'application/vnd.lotus-1-2-3',
    'wk4' => 'application/vnd.lotus-1-2-3',
    'wkq' => 'application/x-quattro-pro',
    'wks' => 'application/vnd.ms-works',
    'wl' => 'application/vnd.wolfram.wl',
    'wm' => 'video/x-ms-wm',
    'wma' => 'audio/x-ms-wma',
    'wmd' => 'application/x-ms-wmd',
    'wmf' => 'image/wmf',
    'wml' => 'text/vnd.wap.wml',
    'wmlc' => 'application/vnd.wap.wmlc',
    'wmls' => 'text/vnd.wap.wmlscript',
    'wmlsc' => 'application/vnd.wap.wmlscriptc',
    'wmv' => 'video/x-ms-wmv',
    'wmx' => 'video/x-ms-wmx',
    'wmz' => 'application/x-ms-wmz',
    'woff' => 'font/woff',
    'woff2' => 'font/woff2',
    'wp' => 'application/vnd.wordperfect',
    'wp5' => 'application/vnd.wordperfect',
    'wp6' => 'application/vnd.wordperfect',
    'wp61' => 'application/vnd.wordperfect',
    'wpd' => 'application/vnd.wordperfect',
    'wpl' => 'application/vnd.ms-wpl',
    'wps' => 'application/vnd.ms-works',
    'wpt' => 'application/vnd.wordperfect',
    'wq1' => 'application/x-quattro-pro',
    'wq2' => 'application/x-quattro-pro',
    'wqd' => 'application/vnd.wqd',
    'wri' => 'application/x-mswrite',
    'wrl' => 'model/vrml',
    'wsdd' => 'text/plain',
    'wsdl' => 'application/wsdl+xml',
    'wspolicy' => 'application/wspolicy+xml',
    'wtb' => 'application/vnd.webturbo',
    'wvx' => 'video/x-ms-wvx',
    'x32' => 'application/x-authorware-bin',
    'x3d' => 'application/vnd.hzn-3d-crossword',
    'x3f' => 'image/x-raw-sigma',
    'xap' => 'application/x-silverlight-app',
    'xar' => 'application/vnd.xara',
    'xargs' => 'text/plain',
    'xbap' => 'application/x-ms-xbap',
    'xbd' => 'application/vnd.fujixerox.docuworks.binder',
    'xbm' => 'image/x-xbitmap',
    'xcat' => 'text/plain',
    'xcf' => 'image/x-xcf',
    'xconf' => 'text/x-config',
    'xdm' => 'application/vnd.syncml.dm+xml',
    'xdp' => 'application/vnd.adobe.xdp+xml',
    'xdw' => 'application/vnd.fujixerox.docuworks',
    'xegrm' => 'text/plain',
    'xenc' => 'application/xenc+xml',
    'xer' => 'application/patch-ops-error+xml',
    'xfdf' => 'application/vnd.adobe.xfdf',
    'xfdl' => 'application/vnd.xfdl',
    'xgrm' => 'text/plain',
    'xht' => 'application/xhtml+xml',
    'xhtml' => 'application/xhtml+xml',
    'xhtml2' => 'application/xhtml+xml',
    'xhvml' => 'application/xv+xml',
    'xif' => 'image/vnd.xiff',
    'xla' => 'application/vnd.ms-excel',
    'xlam' => 'application/vnd.ms-excel.addin.macroenabled.12',
    'xlc' => 'application/vnd.ms-excel',
    'xld' => 'application/vnd.ms-excel',
    'xlex' => 'text/plain',
    'xlf' => 'application/x-xliff+xml',
    'xliff' => 'application/x-xliff+xml',
    'xll' => 'application/vnd.ms-excel',
    'xlm' => 'application/vnd.ms-excel',
    'xlog' => 'text/plain',
    'xlr' => 'application/x-tika-msworks-spreadsheet',
    'xls' => 'application/vnd.ms-excel',
    'xlsb' => 'application/vnd.ms-excel.sheet.binary.macroenabled.12',
    'xlsm' => 'application/vnd.ms-excel.sheet.macroenabled.12',
    'xlsx' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    'xlt' => 'application/vnd.ms-excel',
    'xltm' => 'application/vnd.ms-excel.template.macroenabled.12',
    'xltx' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
    'xlw' => 'application/vnd.ms-excel',
    'xlz' => 'application/x-xliff+zip',
    'xmap' => 'text/plain',
    'xmind' => 'application/x-xmind',
    'xml' => 'application/xml',
    'xmp' => 'application/rdf+xml',
    'xo' => 'application/vnd.olpc-sugar',
    'xop' => 'application/xop+xml',
    'xpi' => 'application/x-xpinstall',
    'xpm' => 'image/x-xpixmap',
    'xport' => 'application/x-sas-xport',
    'xpr' => 'application/vnd.is-xpr',
    'xps' => 'application/vnd.ms-xpsdocument',
    'xpt' => 'application/x-sas-xport',
    'xpw' => 'application/vnd.intercon.formnet',
    'xpx' => 'application/vnd.intercon.formnet',
    'xq' => 'application/xquery',
    'xquery' => 'application/xquery',
    'xroles' => 'text/plain',
    'xsamples' => 'text/plain',
    'xsd' => 'application/xml',
    'xsl' => 'application/xml',
    'xslfo' => 'application/xslfo+xml',
    'xslt' => 'application/xslt+xml',
    'xsm' => 'application/vnd.syncml+xml',
    'xsp' => 'text/plain',
    'xspf' => 'application/xspf+xml',
    'xtest' => 'text/plain',
    'xul' => 'application/vnd.mozilla.xul+xml',
    'xvm' => 'application/xv+xml',
    'xvml' => 'application/xv+xml',
    'xwd' => 'image/x-xwindowdump',
    'xweb' => 'text/plain',
    'xwelcome' => 'text/plain',
    'xyz' => 'chemical/x-xyz',
    'xz' => 'application/x-xz',
    'y' => 'text/x-yacc',
    'yaml' => 'text/x-yaml',
    'z' => 'application/x-compress',
    'zaz' => 'application/vnd.zzazz.deck+xml',
    'zip' => 'application/zip',
    'zir' => 'application/vnd.zul',
    'zirz' => 'application/vnd.zul',
    'zmm' => 'application/vnd.handheld-entertainment+xml',
    'zoo' => 'application/x-zoo',
    'zstd' => 'application/zstd',
  }
  # @private
  # :nodoc:
  TYPES = {
    'application/andrew-inset' => [%w(ez), %w(), nil],
    'application/applixware' => [%w(aw), %w(), nil],
    'application/atom+xml' => [%w(atom), %w(), nil],
    'application/atomcat+xml' => [%w(atomcat), %w(), nil],
    'application/atomsvc+xml' => [%w(atomsvc), %w(), nil],
    'application/bizagi-modeler' => [%w(bpm), %w(application/zip), 'BizAgi Process Modeler'],
    'application/cbor' => [%w(cbor), %w(), 'Concise Binary Object Representation container'],
    'application/ccxml+xml' => [%w(ccxml), %w(), nil],
    'application/coreldraw' => [%w(cdr), %w(), 'des: CorelDraw X4 and newer'],
    'application/cu-seeme' => [%w(cu), %w(), nil],
    'application/dash+xml' => [%w(mpd), %w(application/xml), nil],
    'application/davmount+xml' => [%w(davmount), %w(), nil],
    'application/dif+xml' => [%w(dif), %w(application/xml), nil],
    'application/dita+xml;format=map' => [%w(ditamap), %w(application/dita+xml), 'DITA Map'],
    'application/dita+xml;format=topic' => [%w(dita), %w(application/dita+xml), 'DITA Topic'],
    'application/dita+xml;format=val' => [%w(ditaval), %w(application/dita+xml), 'DITA Conditional Processing Profile'],
    'application/ecmascript' => [%w(ecma), %w(), nil],
    'application/emma+xml' => [%w(emma), %w(), nil],
    'application/envi.hdr' => [%w(hdr), %w(), nil],
    'application/epub+zip' => [%w(epub), %w(), 'Electronic Publication'],
    'application/fits' => [%w(fits fit fts), %w(), 'Flexible Image Transport System'],
    'application/font-tdpfr' => [%w(pfr), %w(), nil],
    'application/gzip' => [%w(gz tgz), %w(), 'Gzip Compressed Archive'],
    'application/hyperstudio' => [%w(stk), %w(), nil],
    'application/illustrator' => [%w(ai), %w(application/postscript), 'Adobe Illustrator Artwork'],
    'application/java-archive' => [%w(jar), %w(application/zip), 'Java Archive'],
    'application/java-serialized-object' => [%w(ser), %w(), nil],
    'application/java-vm' => [%w(class), %w(), 'Java Class File'],
    'application/javascript' => [%w(js), %w(text/plain), 'JavaScript Source Code'],
    'application/json' => [%w(json), %w(application/javascript), nil],
    'application/lost+xml' => [%w(lostxml), %w(), nil],
    'application/mac-binhex40' => [%w(hqx), %w(), nil],
    'application/mac-compactpro' => [%w(cpt), %w(), nil],
    'application/marc' => [%w(mrc), %w(), nil],
    'application/mathematica' => [%w(ma nb mb), %w(text/plain), 'Wolfram Mathematica'],
    'application/mathml+xml' => [%w(mathml), %w(), nil],
    'application/mbox' => [%w(mbox), %w(text/x-tika-text-based-message), nil],
    'application/mediaservercontrol+xml' => [%w(mscml), %w(), nil],
    'application/mp4' => [%w(mp4s), %w(application/quicktime), 'MP4 container format'],
    'application/msword' => [%w(doc dot), %w(application/x-tika-msoffice), 'Microsoft Word Document'],
    'application/mxf' => [%w(mxf), %w(), nil],
    'application/octet-stream' => [%w(bin dms lha lrf lzh so dist distz pkg bpk dump elc deploy), %w(), nil],
    'application/oda' => [%w(oda), %w(), nil],
    'application/oebps-package+xml' => [%w(opf), %w(), nil],
    'application/ogg' => [%w(ogx), %w(), nil],
    'application/onenote' => [%w(onetmp), %w(), nil],
    'application/onenote; format=package' => [%w(onepkg), %w(application/vnd.ms-cab-compressed), 'OneNote Package'],
    'application/onenote;format=one' => [%w(one), %w(application/onenote), nil],
    'application/onenote;format=onetoc2' => [%w(onetoc onetoc2), %w(application/onenote), 'OneNote Table of Contents'],
    'application/patch-ops-error+xml' => [%w(xer), %w(), nil],
    'application/pdf' => [%w(pdf), %w(), 'Portable Document Format'],
    'application/pgp-encrypted' => [%w(pgp), %w(), nil],
    'application/pgp-signature' => [%w(asc sig), %w(), nil],
    'application/pics-rules' => [%w(prf), %w(), nil],
    'application/pkcs10' => [%w(p10), %w(), nil],
    'application/pkcs7-mime' => [%w(p7m p7c), %w(), nil],
    'application/pkcs7-signature' => [%w(p7s), %w(), nil],
    'application/pkix-cert' => [%w(cer), %w(), nil],
    'application/pkix-crl' => [%w(crl), %w(), nil],
    'application/pkix-pkipath' => [%w(pkipath), %w(), nil],
    'application/pkixcmp' => [%w(pki), %w(), nil],
    'application/pls+xml' => [%w(pls), %w(), nil],
    'application/postscript' => [%w(ps eps epsf epsi), %w(), 'PostScript'],
    'application/prs.cww' => [%w(cww), %w(), nil],
    'application/rdf+xml' => [%w(rdf owl xmp), %w(application/xml), 'XML syntax for RDF graphs'],
    'application/reginfo+xml' => [%w(rif), %w(), nil],
    'application/relax-ng-compact-syntax' => [%w(rnc), %w(text/plain), nil],
    'application/resource-lists+xml' => [%w(rl), %w(), nil],
    'application/resource-lists-diff+xml' => [%w(rld), %w(), nil],
    'application/rls-services+xml' => [%w(rs), %w(), nil],
    'application/rsd+xml' => [%w(rsd), %w(), nil],
    'application/rss+xml' => [%w(rss), %w(), nil],
    'application/rtf' => [%w(rtf), %w(text/plain), 'Rich Text Format File'],
    'application/sbml+xml' => [%w(sbml), %w(), nil],
    'application/scvp-cv-request' => [%w(scq), %w(), nil],
    'application/scvp-cv-response' => [%w(scs), %w(), nil],
    'application/scvp-vp-request' => [%w(spq), %w(), nil],
    'application/scvp-vp-response' => [%w(spp), %w(), nil],
    'application/sdp' => [%w(sdp), %w(), nil],
    'application/sereal' => [%w(srl), %w(), 'Sereal binary serialization format'],
    'application/set-payment-initiation' => [%w(setpay), %w(), nil],
    'application/set-registration-initiation' => [%w(setreg), %w(), nil],
    'application/shf+xml' => [%w(shf), %w(), nil],
    'application/sldworks' => [%w(sldprt sldasm slddrw), %w(application/x-tika-msoffice), 'SolidWorks CAD program'],
    'application/smil+xml' => [%w(smi smil sml), %w(application/xml), 'SMIL Multimedia'],
    'application/sparql-query' => [%w(rq), %w(), nil],
    'application/sparql-results+xml' => [%w(srx), %w(), nil],
    'application/srgs' => [%w(gram), %w(), nil],
    'application/srgs+xml' => [%w(grxml), %w(), nil],
    'application/ssml+xml' => [%w(ssml), %w(), nil],
    'application/timestamped-data' => [%w(tsd), %w(), nil],
    'application/vnd.3gpp.pic-bw-large' => [%w(plb), %w(), nil],
    'application/vnd.3gpp.pic-bw-small' => [%w(psb), %w(), nil],
    'application/vnd.3gpp.pic-bw-var' => [%w(pvb), %w(), nil],
    'application/vnd.3gpp2.tcap' => [%w(tcap), %w(), nil],
    'application/vnd.3m.post-it-notes' => [%w(pwn), %w(), nil],
    'application/vnd.accpac.simply.aso' => [%w(aso), %w(), nil],
    'application/vnd.accpac.simply.imp' => [%w(imp), %w(), nil],
    'application/vnd.acucobol' => [%w(acu), %w(), nil],
    'application/vnd.acucorp' => [%w(atc acutc), %w(), nil],
    'application/vnd.adobe.aftereffects.project' => [%w(aep), %w(), nil],
    'application/vnd.adobe.aftereffects.template' => [%w(aet), %w(), nil],
    'application/vnd.adobe.air-application-installer-package+zip' => [%w(air), %w(), nil],
    'application/vnd.adobe.xdp+xml' => [%w(xdp), %w(application/xml), nil],
    'application/vnd.adobe.xfdf' => [%w(xfdf), %w(application/xml), nil],
    'application/vnd.airzip.filesecure.azf' => [%w(azf), %w(), nil],
    'application/vnd.airzip.filesecure.azs' => [%w(azs), %w(), nil],
    'application/vnd.amazon.ebook' => [%w(azw), %w(), nil],
    'application/vnd.americandynamics.acc' => [%w(acc), %w(), nil],
    'application/vnd.amiga.ami' => [%w(ami), %w(), nil],
    'application/vnd.android.package-archive' => [%w(apk), %w(application/java-archive), nil],
    'application/vnd.anser-web-certificate-issue-initiation' => [%w(cii), %w(), nil],
    'application/vnd.anser-web-funds-transfer-initiation' => [%w(fti), %w(), nil],
    'application/vnd.antix.game-component' => [%w(atx), %w(), nil],
    'application/vnd.apple.installer+xml' => [%w(mpkg), %w(), nil],
    'application/vnd.apple.keynote' => [%w(key), %w(application/vnd.apple.iwork), nil],
    'application/vnd.apple.mpegurl' => [%w(m3u8), %w(), nil],
    'application/vnd.apple.numbers' => [%w(numbers), %w(application/vnd.apple.iwork), nil],
    'application/vnd.apple.pages' => [%w(pages), %w(application/vnd.apple.iwork), nil],
    'application/vnd.arastra.swi' => [%w(swi), %w(), nil],
    'application/vnd.blueice.multipass' => [%w(mpm), %w(), nil],
    'application/vnd.bmi' => [%w(bmi), %w(), nil],
    'application/vnd.businessobjects' => [%w(rep), %w(), nil],
    'application/vnd.chemdraw+xml' => [%w(cdxml), %w(), nil],
    'application/vnd.chipnuts.karaoke-mmd' => [%w(mmd), %w(), nil],
    'application/vnd.cinderella' => [%w(cdy), %w(), nil],
    'application/vnd.claymore' => [%w(cla), %w(), nil],
    'application/vnd.clonk.c4group' => [%w(c4g c4d c4f c4p c4u), %w(), nil],
    'application/vnd.commonspace' => [%w(csp), %w(), nil],
    'application/vnd.contact.cmsg' => [%w(cdbcmsg), %w(), nil],
    'application/vnd.cosmocaller' => [%w(cmc), %w(), nil],
    'application/vnd.crick.clicker' => [%w(clkx), %w(), nil],
    'application/vnd.crick.clicker.keyboard' => [%w(clkk), %w(), nil],
    'application/vnd.crick.clicker.palette' => [%w(clkp), %w(), nil],
    'application/vnd.crick.clicker.template' => [%w(clkt), %w(), nil],
    'application/vnd.crick.clicker.wordbank' => [%w(clkw), %w(), nil],
    'application/vnd.criticaltools.wbs+xml' => [%w(wbs), %w(), nil],
    'application/vnd.ctc-posml' => [%w(pml), %w(), nil],
    'application/vnd.cups-ppd' => [%w(ppd), %w(), nil],
    'application/vnd.curl.car' => [%w(car), %w(), nil],
    'application/vnd.curl.pcurl' => [%w(pcurl), %w(), nil],
    'application/vnd.data-vision.rdz' => [%w(rdz), %w(), nil],
    'application/vnd.denovo.fcselayout-link' => [%w(fe_launch), %w(), nil],
    'application/vnd.dna' => [%w(dna), %w(), nil],
    'application/vnd.dolby.mlp' => [%w(mlp), %w(), nil],
    'application/vnd.dpgraph' => [%w(dpg), %w(), nil],
    'application/vnd.dreamfactory' => [%w(dfac), %w(), nil],
    'application/vnd.dynageo' => [%w(geo), %w(), nil],
    'application/vnd.ecowin.chart' => [%w(mag), %w(), nil],
    'application/vnd.enliven' => [%w(nml), %w(), nil],
    'application/vnd.epson.esf' => [%w(esf), %w(), nil],
    'application/vnd.epson.msf' => [%w(msf), %w(), nil],
    'application/vnd.epson.quickanime' => [%w(qam), %w(), nil],
    'application/vnd.epson.salt' => [%w(slt), %w(), nil],
    'application/vnd.epson.ssf' => [%w(ssf), %w(), nil],
    'application/vnd.eszigno3+xml' => [%w(es3 et3), %w(), nil],
    'application/vnd.etsi.asic-e+zip' => [%w(asice), %w(application/zip), 'Extended Associated Signature Container'],
    'application/vnd.etsi.asic-s+zip' => [%w(asics), %w(application/zip), 'Simple Associated Signature Container'],
    'application/vnd.ezpix-album' => [%w(ez2), %w(), nil],
    'application/vnd.ezpix-package' => [%w(ez3), %w(), nil],
    'application/vnd.fdf' => [%w(fdf), %w(), 'Forms Data Format'],
    'application/vnd.fdsn.mseed' => [%w(mseed), %w(), nil],
    'application/vnd.fdsn.seed' => [%w(seed dataless), %w(), nil],
    'application/vnd.flographit' => [%w(gph), %w(), nil],
    'application/vnd.fluxtime.clip' => [%w(ftc), %w(), nil],
    'application/vnd.framemaker' => [%w(fm frame maker book), %w(), nil],
    'application/vnd.frogans.fnc' => [%w(fnc), %w(), nil],
    'application/vnd.frogans.ltf' => [%w(ltf), %w(), nil],
    'application/vnd.fsc.weblaunch' => [%w(fsc), %w(), nil],
    'application/vnd.fujitsu.oasys' => [%w(oas), %w(), nil],
    'application/vnd.fujitsu.oasys2' => [%w(oa2), %w(), nil],
    'application/vnd.fujitsu.oasys3' => [%w(oa3), %w(), nil],
    'application/vnd.fujitsu.oasysgp' => [%w(fg5), %w(), nil],
    'application/vnd.fujitsu.oasysprs' => [%w(bh2), %w(), nil],
    'application/vnd.fujixerox.ddd' => [%w(ddd), %w(), nil],
    'application/vnd.fujixerox.docuworks' => [%w(xdw), %w(), nil],
    'application/vnd.fujixerox.docuworks.binder' => [%w(xbd), %w(), nil],
    'application/vnd.fuzzysheet' => [%w(fzs), %w(), nil],
    'application/vnd.genomatix.tuxedo' => [%w(txd), %w(), nil],
    'application/vnd.geogebra.file' => [%w(ggb), %w(), nil],
    'application/vnd.geogebra.tool' => [%w(ggt), %w(), nil],
    'application/vnd.geometry-explorer' => [%w(gex gre), %w(), nil],
    'application/vnd.gmx' => [%w(gmx), %w(), nil],
    'application/vnd.google-earth.kml+xml' => [%w(kml), %w(application/xml), 'Keyhole Markup Language'],
    'application/vnd.google-earth.kmz' => [%w(kmz), %w(application/zip), nil],
    'application/vnd.grafeq' => [%w(gqf gqs), %w(), nil],
    'application/vnd.groove-account' => [%w(gac), %w(), nil],
    'application/vnd.groove-help' => [%w(ghf), %w(), nil],
    'application/vnd.groove-identity-message' => [%w(gim), %w(), nil],
    'application/vnd.groove-injector' => [%w(grv), %w(), nil],
    'application/vnd.groove-tool-message' => [%w(gtm), %w(), nil],
    'application/vnd.groove-tool-template' => [%w(tpl), %w(), nil],
    'application/vnd.groove-vcard' => [%w(vcg), %w(), nil],
    'application/vnd.handheld-entertainment+xml' => [%w(zmm), %w(), nil],
    'application/vnd.hbci' => [%w(hbci), %w(), nil],
    'application/vnd.hhe.lesson-player' => [%w(les), %w(), nil],
    'application/vnd.hp-hpgl' => [%w(hpgl), %w(), nil],
    'application/vnd.hp-hpid' => [%w(hpid), %w(), nil],
    'application/vnd.hp-hps' => [%w(hps), %w(), nil],
    'application/vnd.hp-jlyt' => [%w(jlt), %w(), nil],
    'application/vnd.hp-pcl' => [%w(pcl), %w(), nil],
    'application/vnd.hp-pclxl' => [%w(pclxl), %w(), nil],
    'application/vnd.hydrostatix.sof-data' => [%w(sfd-hdstx), %w(), nil],
    'application/vnd.hzn-3d-crossword' => [%w(x3d), %w(), nil],
    'application/vnd.ibm.minipay' => [%w(mpy), %w(), nil],
    'application/vnd.ibm.modcap' => [%w(afp listafp list3820), %w(), nil],
    'application/vnd.ibm.rights-management' => [%w(irm), %w(), nil],
    'application/vnd.ibm.secure-container' => [%w(sc), %w(), nil],
    'application/vnd.iccprofile' => [%w(icc icm), %w(), nil],
    'application/vnd.igloader' => [%w(igl), %w(), nil],
    'application/vnd.immervision-ivp' => [%w(ivp), %w(), nil],
    'application/vnd.immervision-ivu' => [%w(ivu), %w(), nil],
    'application/vnd.intercon.formnet' => [%w(xpw xpx), %w(), nil],
    'application/vnd.intu.qbo' => [%w(qbo), %w(), nil],
    'application/vnd.intu.qfx' => [%w(qfx), %w(), nil],
    'application/vnd.iptc.g2.newsmessage+xml' => [%w(nar), %w(application/xml), 'XML syntax for IPTC NewsMessages'],
    'application/vnd.ipunplugged.rcprofile' => [%w(rcprofile), %w(), nil],
    'application/vnd.irepository.package+xml' => [%w(irp), %w(), nil],
    'application/vnd.is-xpr' => [%w(xpr), %w(), nil],
    'application/vnd.jam' => [%w(jam), %w(), nil],
    'application/vnd.java.hprof ' => [%w(hprof), %w(), 'Java hprof text file'],
    'application/vnd.java.hprof.text' => [%w(hprof.txt), %w(text/plain), 'Java hprof text file'],
    'application/vnd.jcp.javame.midlet-rms' => [%w(rms), %w(), nil],
    'application/vnd.jisp' => [%w(jisp), %w(), nil],
    'application/vnd.joost.joda-archive' => [%w(joda), %w(), nil],
    'application/vnd.kahootz' => [%w(ktz ktr), %w(), nil],
    'application/vnd.kde.karbon' => [%w(karbon), %w(), nil],
    'application/vnd.kde.kchart' => [%w(chrt), %w(), 'KChart File'],
    'application/vnd.kde.kformula' => [%w(kfo), %w(), nil],
    'application/vnd.kde.kivio' => [%w(flw), %w(), nil],
    'application/vnd.kde.kontour' => [%w(kon), %w(), nil],
    'application/vnd.kde.kpresenter' => [%w(kpr kpt), %w(), 'KPresenter File'],
    'application/vnd.kde.kspread' => [%w(ksp), %w(), 'KSpread File'],
    'application/vnd.kde.kword' => [%w(kwd kwt), %w(), 'KWord File'],
    'application/vnd.kenameaapp' => [%w(htke), %w(), nil],
    'application/vnd.kidspiration' => [%w(kia), %w(), nil],
    'application/vnd.kinar' => [%w(kne knp), %w(), nil],
    'application/vnd.koan' => [%w(skp skd skt skm), %w(), 'SSEYO Koan File'],
    'application/vnd.kodak-descriptor' => [%w(sse), %w(), nil],
    'application/vnd.llamagraphics.life-balance.desktop' => [%w(lbd), %w(), nil],
    'application/vnd.llamagraphics.life-balance.exchange+xml' => [%w(lbe), %w(), nil],
    'application/vnd.lotus-1-2-3' => [%w(wk1 wk2 wk3 wk4 123), %w(), 'Lotus 1-2-3'],
    'application/vnd.lotus-1-2-3;version=2' => [%w(wk1 wk2), %w(application/vnd.lotus-1-2-3), 'Lotus 1-2-3, version 2'],
    'application/vnd.lotus-1-2-3;version=3' => [%w(wk3), %w(application/vnd.lotus-1-2-3), 'Lotus 1-2-3, version 3'],
    'application/vnd.lotus-1-2-3;version=4' => [%w(wk4), %w(application/vnd.lotus-1-2-3), 'Lotus 1-2-3, version 4-5'],
    'application/vnd.lotus-1-2-3;version=97+9.x' => [%w(123), %w(application/vnd.lotus-1-2-3), 'Lotus 1-2-3, version 97/9.x'],
    'application/vnd.lotus-approach' => [%w(apr), %w(), nil],
    'application/vnd.lotus-freelance' => [%w(pre), %w(), nil],
    'application/vnd.lotus-notes' => [%w(nsf), %w(), nil],
    'application/vnd.lotus-organizer' => [%w(org), %w(), nil],
    'application/vnd.lotus-wordpro' => [%w(lwp), %w(), nil],
    'application/vnd.macports.portpkg' => [%w(portpkg), %w(), nil],
    'application/vnd.mcd' => [%w(mcd), %w(), nil],
    'application/vnd.medcalcdata' => [%w(mc1), %w(), nil],
    'application/vnd.mediastation.cdkey' => [%w(cdkey), %w(), nil],
    'application/vnd.mfer' => [%w(mwf), %w(), nil],
    'application/vnd.mfmp' => [%w(mfm), %w(), nil],
    'application/vnd.micrografx.flo' => [%w(flo), %w(), nil],
    'application/vnd.micrografx.igx' => [%w(igx), %w(), nil],
    'application/vnd.mif' => [%w(mif), %w(), 'FrameMaker Interchange Format'],
    'application/vnd.mindjet.mindmanager' => [%w(mmp mmap mmpt mmat mmmp mmas), %w(application/zip), 'MindManager'],
    'application/vnd.mobius.daf' => [%w(daf), %w(), nil],
    'application/vnd.mobius.dis' => [%w(dis), %w(), nil],
    'application/vnd.mobius.mbk' => [%w(mbk), %w(), nil],
    'application/vnd.mobius.mqy' => [%w(mqy), %w(), nil],
    'application/vnd.mobius.msl' => [%w(msl), %w(), nil],
    'application/vnd.mobius.plc' => [%w(plc), %w(), nil],
    'application/vnd.mobius.txf' => [%w(txf), %w(), nil],
    'application/vnd.mophun.application' => [%w(mpn), %w(), nil],
    'application/vnd.mophun.certificate' => [%w(mpc), %w(), nil],
    'application/vnd.mozilla.xul+xml' => [%w(xul), %w(), nil],
    'application/vnd.ms-artgalry' => [%w(cil), %w(), nil],
    'application/vnd.ms-cab-compressed' => [%w(cab), %w(), nil],
    'application/vnd.ms-excel' => [%w(xls xlm xla xlc xlt xlw xll xld), %w(application/x-tika-msoffice), 'Microsoft Excel Spreadsheet'],
    'application/vnd.ms-excel.addin.macroenabled.12' => [%w(xlam), %w(application/x-tika-ooxml), 'Office Open XML Workbook Add-in (macro-enabled)'],
    'application/vnd.ms-excel.sheet.binary.macroenabled.12' => [%w(xlsb), %w(application/x-tika-ooxml), 'Microsoft Excel 2007 Binary Spreadsheet'],
    'application/vnd.ms-excel.sheet.macroenabled.12' => [%w(xlsm), %w(application/x-tika-ooxml), 'Office Open XML Workbook (macro-enabled)'],
    'application/vnd.ms-excel.template.macroenabled.12' => [%w(xltm), %w(application/x-tika-ooxml), 'Office Open XML Workbook Template (macro-enabled)'],
    'application/vnd.ms-fontobject' => [%w(eot), %w(), nil],
    'application/vnd.ms-htmlhelp' => [%w(chm), %w(), nil],
    'application/vnd.ms-ims' => [%w(ims), %w(), nil],
    'application/vnd.ms-lrm' => [%w(lrm), %w(), nil],
    'application/vnd.ms-outlook' => [%w(msg), %w(application/x-tika-msoffice), 'Microsoft Outlook Message'],
    'application/vnd.ms-outlook-pst' => [%w(pst ost), %w(), 'Outlook Personal Folders File Format'],
    'application/vnd.ms-pki.seccat' => [%w(cat), %w(), nil],
    'application/vnd.ms-pki.stl' => [%w(stl), %w(), nil],
    'application/vnd.ms-powerpoint' => [%w(ppt ppz pps pot ppa), %w(application/x-tika-msoffice), 'Microsoft Powerpoint Presentation'],
    'application/vnd.ms-powerpoint.addin.macroenabled.12' => [%w(ppam), %w(application/x-tika-ooxml), 'Office Open XML Presentation Add-in (macro-enabled)'],
    'application/vnd.ms-powerpoint.presentation.macroenabled.12' => [%w(pptm), %w(application/x-tika-ooxml), 'Office Open XML Presentation (macro-enabled)'],
    'application/vnd.ms-powerpoint.slide.macroenabled.12' => [%w(sldm), %w(application/x-tika-ooxml), nil],
    'application/vnd.ms-powerpoint.slideshow.macroenabled.12' => [%w(ppsm), %w(application/x-tika-ooxml), 'Office Open XML Presentation Slideshow (macro-enabled)'],
    'application/vnd.ms-powerpoint.template.macroenabled.12' => [%w(potm), %w(application/x-tika-ooxml), nil],
    'application/vnd.ms-project' => [%w(mpp mpt), %w(application/x-tika-msoffice), nil],
    'application/vnd.ms-visio.drawing' => [%w(vsdx), %w(application/x-tika-visio-ooxml), 'Office Open XML Visio Drawing (macro-free)'],
    'application/vnd.ms-visio.drawing.macroEnabled.12' => [%w(vsdm), %w(application/x-tika-visio-ooxml), 'Office Open XML Visio Drawing (macro-enabled)'],
    'application/vnd.ms-visio.stencil' => [%w(vssx), %w(application/x-tika-visio-ooxml), 'Office Open XML Visio Stencil (macro-free)'],
    'application/vnd.ms-visio.stencil.macroEnabled.12' => [%w(vssm), %w(application/x-tika-visio-ooxml), 'Office Open XML Visio Stencil (macro-enabled)'],
    'application/vnd.ms-visio.template' => [%w(vstx), %w(application/x-tika-visio-ooxml), 'Office Open XML Visio Template (macro-free)'],
    'application/vnd.ms-visio.template.macroEnabled.12' => [%w(vstm), %w(application/x-tika-visio-ooxml), 'Office Open XML Visio Template (macro-enabled)'],
    'application/vnd.ms-word.document.macroenabled.12' => [%w(docm), %w(application/x-tika-ooxml), 'Office Open XML Document (macro-enabled)'],
    'application/vnd.ms-word.template.macroenabled.12' => [%w(dotm), %w(application/x-tika-ooxml), 'Office Open XML Document Template (macro-enabled)'],
    'application/vnd.ms-works' => [%w(wps wks wcm wdb), %w(application/x-tika-msoffice), nil],
    'application/vnd.ms-wpl' => [%w(wpl), %w(), nil],
    'application/vnd.ms-xpsdocument' => [%w(xps oxps), %w(application/x-tika-ooxml), 'Open XML Paper Specification'],
    'application/vnd.mseq' => [%w(mseq), %w(), nil],
    'application/vnd.musician' => [%w(mus), %w(), nil],
    'application/vnd.muvee.style' => [%w(msty), %w(), nil],
    'application/vnd.neurolanguage.nlu' => [%w(nlu), %w(), nil],
    'application/vnd.noblenet-directory' => [%w(nnd), %w(), nil],
    'application/vnd.noblenet-sealer' => [%w(nns), %w(), nil],
    'application/vnd.noblenet-web' => [%w(nnw), %w(), nil],
    'application/vnd.nokia.n-gage.data' => [%w(ngdat), %w(), nil],
    'application/vnd.nokia.n-gage.symbian.install' => [%w(n-gage), %w(), nil],
    'application/vnd.nokia.radio-preset' => [%w(rpst), %w(), nil],
    'application/vnd.nokia.radio-presets' => [%w(rpss), %w(), nil],
    'application/vnd.novadigm.edm' => [%w(edm), %w(), nil],
    'application/vnd.novadigm.edx' => [%w(edx), %w(), nil],
    'application/vnd.novadigm.ext' => [%w(ext), %w(), nil],
    'application/vnd.oasis.opendocument.base' => [%w(odb), %w(), nil],
    'application/vnd.oasis.opendocument.chart' => [%w(odc), %w(), 'OpenDocument v1.0: Chart document'],
    'application/vnd.oasis.opendocument.chart-template' => [%w(otc), %w(), 'OpenDocument v1.0: Chart document used as template'],
    'application/vnd.oasis.opendocument.flat.presentation' => [%w(fodp), %w(application/vnd.oasis.opendocument.tika.flat.document), 'OpenDocument v1.0: Flat Presentation document'],
    'application/vnd.oasis.opendocument.flat.spreadsheet' => [%w(fods), %w(application/vnd.oasis.opendocument.tika.flat.document), 'OpenDocument v1.0: Flat Spreadsheet document'],
    'application/vnd.oasis.opendocument.flat.text' => [%w(fodt), %w(application/vnd.oasis.opendocument.tika.flat.document), 'OpenDocument v1.0: Flat Text document'],
    'application/vnd.oasis.opendocument.formula' => [%w(odf), %w(application/zip), 'OpenDocument v1.0: Formula document'],
    'application/vnd.oasis.opendocument.formula-template' => [%w(odft), %w(), 'OpenDocument v1.0: Formula document used as template'],
    'application/vnd.oasis.opendocument.graphics' => [%w(odg), %w(), 'OpenDocument v1.0: Graphics document (Drawing)'],
    'application/vnd.oasis.opendocument.graphics-template' => [%w(otg), %w(), 'OpenDocument v1.0: Graphics document used as template'],
    'application/vnd.oasis.opendocument.image' => [%w(odi), %w(), 'OpenDocument v1.0: Image document'],
    'application/vnd.oasis.opendocument.image-template' => [%w(oti), %w(), 'OpenDocument v1.0: Image document used as template'],
    'application/vnd.oasis.opendocument.presentation' => [%w(odp), %w(), 'OpenDocument v1.0: Presentation document'],
    'application/vnd.oasis.opendocument.presentation-template' => [%w(otp), %w(), 'OpenDocument v1.0: Presentation document used as template'],
    'application/vnd.oasis.opendocument.spreadsheet' => [%w(ods), %w(), 'OpenDocument v1.0: Spreadsheet document'],
    'application/vnd.oasis.opendocument.spreadsheet-template' => [%w(ots), %w(), 'OpenDocument v1.0: Spreadsheet document used as template'],
    'application/vnd.oasis.opendocument.text' => [%w(odt), %w(), 'OpenDocument v1.0: Text document'],
    'application/vnd.oasis.opendocument.text-master' => [%w(otm), %w(), 'OpenDocument v1.0: Global Text document'],
    'application/vnd.oasis.opendocument.text-template' => [%w(ott), %w(), 'OpenDocument v1.0: Text document used as template'],
    'application/vnd.oasis.opendocument.text-web' => [%w(oth), %w(), 'OpenDocument v1.0: Text document used as template for HTML documents'],
    'application/vnd.olpc-sugar' => [%w(xo), %w(), nil],
    'application/vnd.oma.dd2+xml' => [%w(dd2), %w(), nil],
    'application/vnd.openofficeorg.autotext' => [%w(bau), %w(application/zip), nil],
    'application/vnd.openofficeorg.extension' => [%w(oxt), %w(), nil],
    'application/vnd.openxmlformats-officedocument.presentationml.presentation' => [%w(pptx thmx), %w(application/x-tika-ooxml), 'Office Open XML Presentation'],
    'application/vnd.openxmlformats-officedocument.presentationml.slide' => [%w(sldx), %w(application/x-tika-ooxml), nil],
    'application/vnd.openxmlformats-officedocument.presentationml.slideshow' => [%w(ppsx), %w(application/x-tika-ooxml), 'Office Open XML Presentation Slideshow'],
    'application/vnd.openxmlformats-officedocument.presentationml.template' => [%w(potx), %w(application/x-tika-ooxml), 'Office Open XML Presentation Template'],
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' => [%w(xlsx), %w(application/x-tika-ooxml), 'Office Open XML Workbook'],
    'application/vnd.openxmlformats-officedocument.spreadsheetml.template' => [%w(xltx), %w(application/x-tika-ooxml), 'Office Open XML Workbook Template'],
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document' => [%w(docx), %w(application/x-tika-ooxml), 'Office Open XML Document'],
    'application/vnd.openxmlformats-officedocument.wordprocessingml.template' => [%w(dotx), %w(application/x-tika-ooxml), 'Office Open XML Document Template'],
    'application/vnd.osgi.dp' => [%w(dp), %w(), nil],
    'application/vnd.palm' => [%w(pqa oprc), %w(), nil],
    'application/vnd.pg.format' => [%w(str), %w(), nil],
    'application/vnd.pg.osasli' => [%w(ei6), %w(), nil],
    'application/vnd.picsel' => [%w(efif), %w(), nil],
    'application/vnd.pocketlearn' => [%w(plf), %w(), nil],
    'application/vnd.powerbuilder6' => [%w(pbd), %w(), nil],
    'application/vnd.previewsystems.box' => [%w(box), %w(), nil],
    'application/vnd.proteus.magazine' => [%w(mgz), %w(), nil],
    'application/vnd.publishare-delta-tree' => [%w(qps), %w(), nil],
    'application/vnd.pvi.ptid1' => [%w(ptid), %w(), nil],
    'application/vnd.quark.quarkxpress' => [%w(qxd qxt qwd qwt qxl qxb), %w(), nil],
    'application/vnd.recordare.musicxml' => [%w(mxl), %w(), nil],
    'application/vnd.recordare.musicxml+xml' => [%w(musicxml), %w(), nil],
    'application/vnd.rim.cod' => [%w(cod), %w(), nil],
    'application/vnd.rn-realmedia' => [%w(rm), %w(), nil],
    'application/vnd.route66.link66+xml' => [%w(link66), %w(), nil],
    'application/vnd.seemail' => [%w(see), %w(), nil],
    'application/vnd.sema' => [%w(sema), %w(), nil],
    'application/vnd.semd' => [%w(semd), %w(), nil],
    'application/vnd.semf' => [%w(semf), %w(), nil],
    'application/vnd.shana.informed.formdata' => [%w(ifm), %w(), nil],
    'application/vnd.shana.informed.formtemplate' => [%w(itp), %w(), nil],
    'application/vnd.shana.informed.interchange' => [%w(iif), %w(), nil],
    'application/vnd.shana.informed.package' => [%w(ipk), %w(), nil],
    'application/vnd.simtech-mindmapper' => [%w(twd twds), %w(), nil],
    'application/vnd.smaf' => [%w(mmf), %w(), nil],
    'application/vnd.smart.teacher' => [%w(teacher), %w(), nil],
    'application/vnd.solent.sdkm+xml' => [%w(sdkm sdkd), %w(), nil],
    'application/vnd.spotfire.dxp' => [%w(dxp), %w(), nil],
    'application/vnd.spotfire.sfs' => [%w(sfs), %w(), nil],
    'application/vnd.stardivision.calc' => [%w(sdc), %w(application/x-tika-staroffice), nil],
    'application/vnd.stardivision.draw' => [%w(sda), %w(application/x-tika-staroffice), nil],
    'application/vnd.stardivision.impress' => [%w(sdd), %w(application/x-tika-staroffice), nil],
    'application/vnd.stardivision.math' => [%w(smf), %w(), nil],
    'application/vnd.stardivision.writer' => [%w(sdw), %w(application/x-tika-staroffice), nil],
    'application/vnd.stardivision.writer-global' => [%w(sgl), %w(), nil],
    'application/vnd.sun.xml.calc' => [%w(sxc), %w(), nil],
    'application/vnd.sun.xml.calc.template' => [%w(stc), %w(), nil],
    'application/vnd.sun.xml.draw' => [%w(sxd), %w(), nil],
    'application/vnd.sun.xml.draw.template' => [%w(std), %w(), nil],
    'application/vnd.sun.xml.impress' => [%w(sxi), %w(), nil],
    'application/vnd.sun.xml.impress.template' => [%w(sti), %w(), nil],
    'application/vnd.sun.xml.math' => [%w(sxm), %w(), nil],
    'application/vnd.sun.xml.writer' => [%w(sxw), %w(), 'OpenOffice v1.0: Writer Document'],
    'application/vnd.sun.xml.writer.global' => [%w(sxg), %w(), nil],
    'application/vnd.sun.xml.writer.template' => [%w(stw), %w(), nil],
    'application/vnd.sus-calendar' => [%w(sus susp), %w(), nil],
    'application/vnd.svd' => [%w(svd), %w(), nil],
    'application/vnd.symbian.install' => [%w(sis sisx), %w(), nil],
    'application/vnd.syncml+xml' => [%w(xsm), %w(), nil],
    'application/vnd.syncml.dm+wbxml' => [%w(bdm), %w(), nil],
    'application/vnd.syncml.dm+xml' => [%w(xdm), %w(), nil],
    'application/vnd.tao.intent-module-archive' => [%w(tao), %w(), nil],
    'application/vnd.tcpdump.pcap' => [%w(pcap cap dmp), %w(), 'TCPDump pcap packet capture'],
    'application/vnd.tmobile-livetv' => [%w(tmo), %w(), nil],
    'application/vnd.trid.tpt' => [%w(tpt), %w(), nil],
    'application/vnd.triscape.mxs' => [%w(mxs), %w(), nil],
    'application/vnd.trueapp' => [%w(tra), %w(), nil],
    'application/vnd.ufdl' => [%w(ufd ufdl), %w(), nil],
    'application/vnd.uiq.theme' => [%w(utz), %w(), nil],
    'application/vnd.umajin' => [%w(umj), %w(), nil],
    'application/vnd.unity' => [%w(unityweb), %w(), nil],
    'application/vnd.uoml+xml' => [%w(uoml), %w(), nil],
    'application/vnd.vcx' => [%w(vcx), %w(), nil],
    'application/vnd.visio' => [%w(vsd vst vss vsw), %w(application/x-tika-msoffice), 'Microsoft Visio Diagram'],
    'application/vnd.visionary' => [%w(vis), %w(), nil],
    'application/vnd.vsf' => [%w(vsf), %w(), nil],
    'application/vnd.wap.wbxml' => [%w(wbxml), %w(), nil],
    'application/vnd.wap.wmlc' => [%w(wmlc), %w(), 'Compiled WML Document'],
    'application/vnd.wap.wmlscriptc' => [%w(wmlsc), %w(), 'Compiled WML Script'],
    'application/vnd.webturbo' => [%w(wtb), %w(), nil],
    'application/vnd.wolfram.wl' => [%w(wl), %w(application/mathematica), 'Wolfram Language'],
    'application/vnd.wordperfect' => [%w(wpd wp wp5 wp6 w60 wp61 wpt), %w(), 'WordPerfect - Corel Word Processing'],
    'application/vnd.wqd' => [%w(wqd), %w(), nil],
    'application/vnd.wt.stf' => [%w(stf), %w(), nil],
    'application/vnd.xara' => [%w(xar), %w(), nil],
    'application/vnd.xfdl' => [%w(xfdl), %w(), nil],
    'application/vnd.yamaha.hv-dic' => [%w(hvd), %w(), nil],
    'application/vnd.yamaha.hv-script' => [%w(hvs), %w(), nil],
    'application/vnd.yamaha.hv-voice' => [%w(hvp), %w(), nil],
    'application/vnd.yamaha.openscoreformat' => [%w(osf), %w(), nil],
    'application/vnd.yamaha.openscoreformat.osfpvg+xml' => [%w(osfpvg), %w(), nil],
    'application/vnd.yamaha.smaf-audio' => [%w(saf), %w(), nil],
    'application/vnd.yamaha.smaf-phrase' => [%w(spf), %w(), nil],
    'application/vnd.yellowriver-custom-menu' => [%w(cmp), %w(), nil],
    'application/vnd.zul' => [%w(zir zirz), %w(), nil],
    'application/vnd.zzazz.deck+xml' => [%w(zaz), %w(), nil],
    'application/voicexml+xml' => [%w(vxml), %w(), nil],
    'application/warc' => [%w(warc), %w(), 'WARC'],
    'application/wasm' => [%w(wasm), %w(), 'Web Assembly'],
    'application/winhlp' => [%w(hlp), %w(), nil],
    'application/wsdl+xml' => [%w(wsdl), %w(), nil],
    'application/wspolicy+xml' => [%w(wspolicy), %w(), nil],
    'application/x-7z-compressed' => [%w(7z), %w(), '7-zip archive'],
    'application/x-abiword' => [%w(abw), %w(), nil],
    'application/x-ace-compressed' => [%w(ace), %w(), nil],
    'application/x-adobe-indesign' => [%w(indd), %w(), 'Adobe InDesign document'],
    'application/x-adobe-indesign-interchange' => [%w(inx), %w(application/xml), 'Adobe InDesign Interchange format'],
    'application/x-apple-diskimage' => [%w(dmg), %w(), nil],
    'application/x-appleworks' => [%w(cwk), %w(), nil],
    'application/x-archive' => [%w(ar a), %w(), nil],
    'application/x-arj' => [%w(arj), %w(), nil],
    'application/x-authorware-bin' => [%w(aab x32 u32 vox), %w(), nil],
    'application/x-authorware-map' => [%w(aam), %w(), nil],
    'application/x-authorware-seg' => [%w(aas), %w(), nil],
    'application/x-axcrypt' => [%w(axx), %w(), 'AxCrypt'],
    'application/x-bat' => [%w(bat cmd), %w(text/plain), 'Windows Batch / Command File'],
    'application/x-bcpio' => [%w(bcpio), %w(), nil],
    'application/x-bibtex-text-file' => [%w(bib bibtex), %w(text/plain), nil],
    'application/x-bittorrent' => [%w(torrent), %w(), nil],
    'application/x-brotli' => [%w(br brotli), %w(), nil],
    'application/x-bzip' => [%w(bz tbz), %w(), nil],
    'application/x-bzip2' => [%w(bz2 tbz2 boz), %w(application/x-bzip), 'Bzip 2 UNIX Compressed File'],
    'application/x-cdlink' => [%w(vcd), %w(), 'Virtual CD-ROM CD Image File'],
    'application/x-chat' => [%w(chat), %w(), nil],
    'application/x-chess-pgn' => [%w(pgn), %w(), nil],
    'application/x-chrome-package' => [%w(crx), %w(), 'Chrome Extension Package'],
    'application/x-compress' => [%w(z), %w(), nil],
    'application/x-corelpresentations' => [%w(shw), %w(application/x-tika-msoffice), nil],
    'application/x-cpio' => [%w(cpio), %w(), 'UNIX CPIO Archive'],
    'application/x-csh' => [%w(csh tcsh), %w(), nil],
    'application/x-dbf' => [%w(dbf dbase dbase3), %w(), nil],
    'application/x-debian-package' => [%w(deb udeb), %w(application/x-archive), nil],
    'application/x-dex' => [%w(dex), %w(), 'Dalvik Executable Format'],
    'application/x-director' => [%w(dir dcr dxr cst cct cxt w3d fgd swa), %w(), 'Shockwave Movie'],
    'application/x-doom' => [%w(wad), %w(), nil],
    'application/x-dosexec' => [%w(exe), %w(application/x-msdownload), 'DOS/Windows executable (EXE)'],
    'application/x-dtbncx+xml' => [%w(ncx), %w(), nil],
    'application/x-dtbook+xml' => [%w(dtb), %w(), nil],
    'application/x-dtbresource+xml' => [%w(res), %w(), nil],
    'application/x-dvi' => [%w(dvi), %w(), 'TeX Device Independent Document'],
    'application/x-elc' => [%w(elc), %w(), 'Emacs Lisp bytecode'],
    'application/x-endnote-refer' => [%w(enw enr), %w(), nil],
    'application/x-erdas-hfa' => [%w(hfa), %w(), nil],
    'application/x-fictionbook+xml' => [%w(fb2), %w(application/xml), 'FictionBook document'],
    'application/x-filemaker' => [%w(fp7), %w(), 'FileMaker Pro 7'],
    'application/x-font-adobe-metric' => [%w(afm acfm amfm), %w(), 'Adobe Font Metric'],
    'application/x-font-bdf' => [%w(bdf), %w(), nil],
    'application/x-font-ghostscript' => [%w(gsf), %w(), nil],
    'application/x-font-linux-psf' => [%w(psf), %w(), nil],
    'application/x-font-otf' => [%w(otf), %w(), 'OpenType Font'],
    'application/x-font-pcf' => [%w(pcf), %w(), nil],
    'application/x-font-printer-metric' => [%w(pfm), %w(), 'Printer Font Metric'],
    'application/x-font-snf' => [%w(snf), %w(), nil],
    'application/x-font-ttf' => [%w(ttf ttc), %w(), 'TrueType Font'],
    'application/x-font-type1' => [%w(pfa pfb), %w(), nil],
    'application/x-futuresplash' => [%w(spl), %w(), 'Macromedia FutureSplash File'],
    'application/x-gnucash' => [%w(gnucash), %w(), nil],
    'application/x-gnumeric' => [%w(gnumeric), %w(), nil],
    'application/x-grib' => [%w(grb grb1 grb2), %w(), 'General Regularly-distributed Information in Binary form'],
    'application/x-gtar' => [%w(gtar), %w(application/x-tar), 'GNU tar Compressed File Archive (GNU Tape Archive)'],
    'application/x-hdf' => [%w(hdf he5 h5), %w(), 'Hierarchical Data Format File'],
    'application/x-ibooks+zip' => [%w(ibooks), %w(application/epub+zip), 'Apple iBooks Author publication format'],
    'application/x-internet-archive' => [%w(arc), %w(), 'ARC'],
    'application/x-iso9660-image' => [%w(iso), %w(), 'ISO 9660 CD-ROM filesystem data'],
    'application/x-itunes-ipa' => [%w(ipa), %w(application/zip), 'Apple iOS IPA AppStore file'],
    'application/x-java-jnilib' => [%w(jnilib), %w(), 'Java Native Library for OSX'],
    'application/x-java-jnlp-file' => [%w(jnlp), %w(), nil],
    'application/x-java-pack200' => [%w(pack), %w(), nil],
    'application/x-killustrator' => [%w(kil), %w(), 'KIllustrator File'],
    'application/x-latex' => [%w(latex), %w(application/x-tex), 'LaTeX Source Document'],
    'application/x-lz4' => [%w(lz4), %w(), 'Second match Legacy Frame'],
    'application/x-lzip' => [%w(lz), %w(), 'Lzip (LZMA) compressed archive'],
    'application/x-lzma' => [%w(lzma), %w(), 'LZMA compressed archive'],
    'application/x-matlab-data' => [%w(mat), %w(), nil],
    'application/x-memgraph' => [%w(memgraph), %w(application/x-bplist), 'Apple Xcode Memgraph'],
    'application/x-mobipocket-ebook' => [%w(prc mobi), %w(), 'Mobipocket Ebook'],
    'application/x-ms-application' => [%w(application), %w(), nil],
    'application/x-ms-asx' => [%w(asx), %w(application/xml), 'Windows Media Metafile'],
    'application/x-ms-installer' => [%w(msi msp mst), %w(application/x-tika-msoffice), 'Microsoft Windows Installer'],
    'application/x-ms-wmd' => [%w(wmd), %w(), nil],
    'application/x-ms-wmz' => [%w(wmz), %w(application/gzip), nil],
    'application/x-ms-xbap' => [%w(xbap), %w(), nil],
    'application/x-msaccess' => [%w(mdb), %w(), nil],
    'application/x-msbinder' => [%w(obd), %w(), nil],
    'application/x-mscardfile' => [%w(crd), %w(), nil],
    'application/x-msclip' => [%w(clp), %w(), nil],
    'application/x-msdownload' => [%w(dll com), %w(), nil],
    'application/x-msmediaview' => [%w(mvb m13 m14), %w(), nil],
    'application/x-msmoney' => [%w(mny), %w(), nil],
    'application/x-mspublisher' => [%w(pub), %w(application/x-tika-msoffice), nil],
    'application/x-msschedule' => [%w(scd), %w(), nil],
    'application/x-msterminal' => [%w(trm), %w(), nil],
    'application/x-mswrite' => [%w(wri), %w(), nil],
    'application/x-mysql-misam-compressed-index' => [%w(myi), %w(application/x-mysql-db), 'MySQL MISAM Compressed Index'],
    'application/x-mysql-misam-data' => [%w(myd), %w(application/x-mysql-db), 'MySQL MISAM Data'],
    'application/x-netcdf' => [%w(nc cdf), %w(), nil],
    'application/x-parquet' => [%w(parquet), %w(), nil],
    'application/x-pkcs12' => [%w(p12 pfx), %w(), nil],
    'application/x-pkcs7-certificates' => [%w(p7b spc), %w(), nil],
    'application/x-pkcs7-certreqresp' => [%w(p7r), %w(), nil],
    'application/x-project' => [%w(mpx), %w(text/plain), nil],
    'application/x-prt' => [%w(prt), %w(), nil],
    'application/x-quattro-pro' => [%w(wq1 wq2 wkq qpw wb1 wb2 wb3), %w(application/x-tika-msoffice), "\n      Quattro Pro - Corel Spreadsheet (part of WordPerfect Office suite)\n    "],
    'application/x-quattro-pro;version=1+5' => [%w(wb1), %w(application/x-quattro-pro), 'Quattro Pro for Windows, version 1, 5'],
    'application/x-quattro-pro;version=1-4' => [%w(wq1 wkq), %w(application/x-quattro-pro), 'Quattro Pro for DOS, version 1-4'],
    'application/x-quattro-pro;version=5' => [%w(wq2 wkq), %w(application/x-quattro-pro), 'Quattro Pro for DOS, version 5'],
    'application/x-quattro-pro;version=6' => [%w(wb2), %w(application/x-quattro-pro), 'Quattro Pro for Windows, version 6'],
    'application/x-rar-compressed' => [%w(rar), %w(), 'RAR archive'],
    'application/x-roxio-toast' => [%w(toast), %w(application/x-iso9660-image), nil],
    'application/x-rpm' => [%w(rpm), %w(), 'RedHat Package Manager'],
    'application/x-sas' => [%w(sas), %w(text/plain), 'SAS Program'],
    'application/x-sas-access' => [%w(sa7 sas7bacs), %w(), 'SAS Access Descriptor'],
    'application/x-sas-audit' => [%w(st7 sas7baud), %w(), 'SAS Audit'],
    'application/x-sas-backup' => [%w(sas7bbak), %w(), 'SAS Backup'],
    'application/x-sas-catalog' => [%w(sc7 sas7bcat), %w(), 'SAS Catalog'],
    'application/x-sas-data' => [%w(sd7 sas7bdat), %w(), 'SAS Data Set'],
    'application/x-sas-data-index' => [%w(si7 sas7bndx), %w(), 'SAS Data Set Index'],
    'application/x-sas-data-v6' => [%w(sd2), %w(), 'SAS v6 Data Set'],
    'application/x-sas-dmdb' => [%w(s7m sas7bdmd), %w(), 'SAS DMDB Data Mining Database File'],
    'application/x-sas-fdb' => [%w(sf7 sas7bfdb), %w(), 'SAS FDB Consolidation Database File'],
    'application/x-sas-itemstor' => [%w(sr7 sas7bitm), %w(), 'SAS Item Store (ItemStor) File'],
    'application/x-sas-mddb' => [%w(sm7 sas7bmdb), %w(), 'SAS MDDB Multi-Dimensional Database File'],
    'application/x-sas-program-data' => [%w(ss7 sas7bpgm), %w(), 'SAS Stored Program (DATA Step)'],
    'application/x-sas-putility' => [%w(sp7 sas7bput), %w(), 'SAS Permanent Utility'],
    'application/x-sas-transport' => [%w(stx), %w(), 'SAS Transport File'],
    'application/x-sas-utility' => [%w(su7 sas7butl), %w(), 'SAS Utility'],
    'application/x-sas-view' => [%w(sv7 sas7bvew), %w(), 'SAS Data Set View'],
    'application/x-sas-xport' => [%w(xpt xport), %w(), 'SAS XPORT Transfer File'],
    'application/x-sfdu' => [%w(sfdu), %w(text/plain), 'Standard Formatted Data Units (SFDUs) data'],
    'application/x-sh' => [%w(sh bash), %w(text/plain), 'UNIX/LINUX Shell Script'],
    'application/x-shapefile' => [%w(shp), %w(), 'ESRI Shapefiles'],
    'application/x-shar' => [%w(shar), %w(), nil],
    'application/x-shockwave-flash' => [%w(swf), %w(), 'Adobe Flash'],
    'application/x-silverlight-app' => [%w(xap), %w(), nil],
    'application/x-snappy-framed' => [%w(sz), %w(), 'Snappy Framed'],
    'application/x-staroffice-template' => [%w(vor), %w(application/x-tika-staroffice), nil],
    'application/x-stata-do' => [%w(do), %w(), 'Stata DTA Script'],
    'application/x-stata-dta' => [%w(dta), %w(), 'Stata DTA Dataset'],
    'application/x-stuffit' => [%w(sit), %w(), nil],
    'application/x-stuffitx' => [%w(sitx), %w(), nil],
    'application/x-sv4cpio' => [%w(sv4cpio), %w(), nil],
    'application/x-sv4crc' => [%w(sv4crc), %w(), nil],
    'application/x-tar' => [%w(tar), %w(), nil],
    'application/x-tex' => [%w(tex), %w(text/plain), 'TeX Source'],
    'application/x-tex-tfm' => [%w(tfm), %w(), nil],
    'application/x-texinfo' => [%w(texinfo texi), %w(), nil],
    'application/x-tika-java-enterprise-archive' => [%w(ear), %w(application/java-archive), nil],
    'application/x-tika-java-web-archive' => [%w(war), %w(application/java-archive), nil],
    'application/x-tika-msworks-spreadsheet' => [%w(xlr), %w(application/vnd.ms-excel), nil],
    'application/x-uc2-compressed' => [%w(uc2), %w(), nil],
    'application/x-ustar' => [%w(ustar), %w(), nil],
    'application/x-vmdk' => [%w(vmdk), %w(), 'Virtual Disk Format'],
    'application/x-wais-source' => [%w(src), %w(), nil],
    'application/x-webarchive' => [%w(webarchive), %w(application/x-bplist), nil],
    'application/x-x509-cert' => [%w(crt), %w(), nil],
    'application/x-x509-cert;format=der' => [%w(der), %w(application/x-x509-cert), nil],
    'application/x-x509-cert;format=pem' => [%w(pem), %w(application/x-x509-cert), nil],
    'application/x-xfig' => [%w(fig), %w(), nil],
    'application/x-xliff+xml' => [%w(xlf xliff), %w(application/xml), 'XLIFF 1.2 document'],
    'application/x-xliff+zip' => [%w(xlz), %w(application/zip), 'XLZ Archive'],
    'application/x-xmind' => [%w(xmind), %w(application/zip), 'XMind Pro'],
    'application/x-xpinstall' => [%w(xpi), %w(), nil],
    'application/x-xz' => [%w(xz), %w(), nil],
    'application/x-zoo' => [%w(zoo), %w(), nil],
    'application/xenc+xml' => [%w(xenc), %w(), nil],
    'application/xhtml+xml' => [%w(xhtml xhtml2 xht), %w(), nil],
    'application/xml' => [%w(xml xsl xsd), %w(text/plain), 'Extensible Markup Language'],
    'application/xml-dtd' => [%w(dtd), %w(text/plain), 'XML Document Type Definition'],
    'application/xop+xml' => [%w(xop), %w(), nil],
    'application/xquery' => [%w(xq xquery), %w(text/plain), 'XQuery source code'],
    'application/xslfo+xml' => [%w(xslfo fo), %w(), 'XSL Format'],
    'application/xslt+xml' => [%w(xslt), %w(), 'XSL Transformations'],
    'application/xspf+xml' => [%w(xspf), %w(), 'XML Shareable Playlist Format'],
    'application/xv+xml' => [%w(mxml xhvml xvml xvm), %w(), nil],
    'application/zip' => [%w(zip), %w(), 'Compressed Archive File'],
    'application/zstd' => [%w(zstd), %w(), 'https://tools.ietf.org/id/draft-kucherawy-dispatch-zstd-01.html'],
    'audio/ac3' => [%w(ac3), %w(), 'Dolby Digital Audio Compression File'],
    'audio/adpcm' => [%w(adp), %w(), nil],
    'audio/amr' => [%w(amr), %w(), nil],
    'audio/basic' => [%w(au snd), %w(), 'uLaw/AU Audio File'],
    'audio/midi' => [%w(mid midi kar rmi), %w(), 'Musical Instrument Digital Interface'],
    'audio/mp4' => [%w(mp4a m4a m4b), %w(application/quicktime), nil],
    'audio/mpeg' => [%w(mpga mp2 mp2a mp3 m2a m3a), %w(), 'MPEG-1 Audio Layer 3'],
    'audio/ogg' => [%w(oga), %w(application/ogg), 'Ogg Vorbis Audio'],
    'audio/opus' => [%w(opus), %w(audio/ogg), 'Ogg Opus Codec Compressed WAV File'],
    'audio/speex' => [%w(spx), %w(audio/ogg), 'Ogg Speex Codec Compressed WAV File'],
    'audio/vnd.adobe.soundbooth' => [%w(asnd), %w(), nil],
    'audio/vnd.digital-winds' => [%w(eol), %w(), nil],
    'audio/vnd.dts' => [%w(dts), %w(), nil],
    'audio/vnd.dts.hd' => [%w(dtshd), %w(), nil],
    'audio/vnd.lucent.voice' => [%w(lvp), %w(), nil],
    'audio/vnd.ms-playready.media.pya' => [%w(pya), %w(), nil],
    'audio/vnd.nuera.ecelp4800' => [%w(ecelp4800), %w(), nil],
    'audio/vnd.nuera.ecelp7470' => [%w(ecelp7470), %w(), nil],
    'audio/vnd.nuera.ecelp9600' => [%w(ecelp9600), %w(), nil],
    'audio/vnd.wave' => [%w(wav), %w(), nil],
    'audio/vorbis' => [%w(ogg), %w(audio/ogg), 'Ogg Vorbis Codec Compressed WAV File'],
    'audio/x-aac' => [%w(aac), %w(), nil],
    'audio/x-aiff' => [%w(aif aiff aifc), %w(), 'Audio Interchange File Format'],
    'audio/x-caf' => [%w(caf), %w(), 'com.apple.coreaudio-format'],
    'audio/x-flac' => [%w(flac), %w(), 'Free Lossless Audio Codec'],
    'audio/x-matroska' => [%w(mka), %w(application/x-matroska), nil],
    'audio/x-mod' => [%w(mod), %w(), nil],
    'audio/x-mpegurl' => [%w(m3u), %w(), 'MP3 Playlist File'],
    'audio/x-ms-wax' => [%w(wax), %w(), nil],
    'audio/x-ms-wma' => [%w(wma), %w(video/x-ms-asf), nil],
    'audio/x-pn-realaudio' => [%w(ram ra), %w(), 'Real Audio'],
    'audio/x-pn-realaudio-plugin' => [%w(rmp), %w(), 'RealMedia Player Plug-in'],
    'chemical/x-cdx' => [%w(cdx), %w(), nil],
    'chemical/x-cif' => [%w(cif), %w(), nil],
    'chemical/x-cmdf' => [%w(cmdf), %w(), nil],
    'chemical/x-cml' => [%w(cml), %w(), nil],
    'chemical/x-csml' => [%w(csml), %w(), nil],
    'chemical/x-pdb' => [%w(pdb), %w(), 'Brookhaven Protein Databank File'],
    'chemical/x-xyz' => [%w(xyz), %w(), nil],
    'font/woff' => [%w(woff), %w(), nil],
    'font/woff2' => [%w(woff2), %w(), nil],
    'image/aces' => [%w(exr), %w(), 'ACES Image Container File'],
    'image/avif' => [%w(avif), %w(), 'AV1 Image File'],
    'image/bmp' => [%w(bmp dib), %w(), 'Windows bitmap'],
    'image/cgm' => [%w(cgm), %w(), 'Computer Graphics Metafile'],
    'image/emf' => [%w(emf), %w(), 'Enhanced Metafile'],
    'image/g3fax' => [%w(g3), %w(), nil],
    'image/gif' => [%w(gif), %w(), 'Graphics Interchange Format'],
    'image/heic' => [%w(heic), %w(), nil],
    'image/heif' => [%w(heif), %w(), nil],
    'image/icns' => [%w(icns), %w(), 'Apple Icon Image Format'],
    'image/ief' => [%w(ief), %w(), nil],
    'image/jp2' => [%w(jp2), %w(image/x-jp2-container), 'JPEG 2000 Part 1 (JP2)'],
    'image/jpeg' => [%w(jpg jpeg jpe jif jfif jfi), %w(), 'Joint Photographic Experts Group'],
    'image/jpm' => [%w(jpm jpgm), %w(image/x-jp2-container), 'JPEG 2000 Part 6 (JPM)'],
    'image/jpx' => [%w(jpf), %w(image/x-jp2-container), 'JPEG 2000 Part 2 (JPX)'],
    'image/nitf' => [%w(ntf nitf), %w(), nil],
    'image/png' => [%w(png), %w(), 'Portable Network Graphics'],
    'image/prs.btif' => [%w(btif), %w(), nil],
    'image/svg+xml' => [%w(svg svgz), %w(application/xml), 'Scalable Vector Graphics'],
    'image/tiff' => [%w(tiff tif), %w(), 'Tagged Image File Format'],
    'image/vnd.adobe.photoshop' => [%w(psd), %w(), 'Photoshop Image'],
    'image/vnd.adobe.premiere' => [%w(ppj), %w(application/xml), nil],
    'image/vnd.djvu' => [%w(djvu djv), %w(), nil],
    'image/vnd.dwg' => [%w(dwg), %w(), 'AutoCad Drawing'],
    'image/vnd.dxb' => [%w(dxb), %w(), 'AutoCAD DXF simplified Binary'],
    'image/vnd.dxf' => [%w(dxf), %w(), 'AutoCAD DXF'],
    'image/vnd.fastbidsheet' => [%w(fbs), %w(), nil],
    'image/vnd.fpx' => [%w(fpx), %w(), nil],
    'image/vnd.fst' => [%w(fst), %w(), nil],
    'image/vnd.fujixerox.edmics-mmr' => [%w(mmr), %w(), nil],
    'image/vnd.fujixerox.edmics-rlc' => [%w(rlc), %w(), nil],
    'image/vnd.microsoft.icon' => [%w(ico), %w(), nil],
    'image/vnd.ms-modi' => [%w(mdi), %w(), 'Microsoft Document Imaging'],
    'image/vnd.net-fpx' => [%w(npx), %w(), nil],
    'image/vnd.wap.wbmp' => [%w(wbmp), %w(), 'Wireless Bitmap File Format'],
    'image/vnd.xiff' => [%w(xif), %w(), nil],
    'image/vnd.zbrush.dcx' => [%w(dcx), %w(), 'ZSoft Multi-Page Paintbrush'],
    'image/vnd.zbrush.pcx' => [%w(pcx), %w(), 'ZSoft Paintbrush PiCture eXchange'],
    'image/webp' => [%w(webp), %w(), nil],
    'image/wmf' => [%w(wmf), %w(), 'Windows Metafile'],
    'image/x-bpg' => [%w(bpg), %w(), 'Better Portable Graphics'],
    'image/x-cmu-raster' => [%w(ras), %w(), nil],
    'image/x-cmx' => [%w(cmx), %w(), nil],
    'image/x-dpx' => [%w(dpx), %w(), 'Digital Picture Exchange from SMPTE'],
    'image/x-emf-compressed' => [%w(emz), %w(application/gzip), 'Compressed Enhanced Metafile'],
    'image/x-freehand' => [%w(fh fhc fh4 fh40 fh5 fh50 fh7 fh8 fh9 fh10 fh11 fh12 ft7 ft8 ft9 ft10 ft11 ft12), %w(), 'FreeHand image'],
    'image/x-jbig2' => [%w(jb2 jbig2), %w(), "\n      A lossless image compression standard from the\n      Joint Bi-level Image Experts Group.\n    "],
    'image/x-jp2-codestream' => [%w(j2c), %w(), 'JPEG 2000 Codestream'],
    'image/x-pict' => [%w(pic pct pict), %w(), 'Apple Macintosh QuickDraw/PICT Format'],
    'image/x-portable-anymap' => [%w(pnm), %w(), 'Portable Any Map'],
    'image/x-portable-bitmap' => [%w(pbm), %w(image/x-portable-anymap), 'Portable Bit Map'],
    'image/x-portable-graymap' => [%w(pgm), %w(image/x-portable-anymap), 'Portable Graymap Graphic'],
    'image/x-portable-pixmap' => [%w(ppm), %w(image/x-portable-anymap), 'UNIX Portable Bitmap Graphic'],
    'image/x-raw-adobe' => [%w(dng), %w(), 'Adobe Digital Negative'],
    'image/x-raw-canon' => [%w(crw cr2), %w(), 'Canon raw image'],
    'image/x-raw-casio' => [%w(bay), %w(), 'Casio raw image'],
    'image/x-raw-epson' => [%w(erf), %w(), 'Epson raw image'],
    'image/x-raw-fuji' => [%w(raf), %w(), 'Fuji raw image'],
    'image/x-raw-hasselblad' => [%w(3fr), %w(), 'Hasselblad raw image'],
    'image/x-raw-imacon' => [%w(fff), %w(), 'Imacon raw image'],
    'image/x-raw-kodak' => [%w(k25 kdc dcs drf), %w(), 'Kodak raw image'],
    'image/x-raw-leaf' => [%w(mos), %w(), 'Leaf raw image'],
    'image/x-raw-logitech' => [%w(pxn), %w(), 'Logitech raw image'],
    'image/x-raw-mamiya' => [%w(mef), %w(), 'Mamiya raw image'],
    'image/x-raw-minolta' => [%w(mrw), %w(), 'Minolta raw image'],
    'image/x-raw-nikon' => [%w(nef nrw), %w(), 'Nikon raw image'],
    'image/x-raw-olympus' => [%w(orf), %w(), 'Olympus raw image'],
    'image/x-raw-panasonic' => [%w(raw rw2), %w(), 'Panasonic raw image'],
    'image/x-raw-pentax' => [%w(ptx pef), %w(), 'Pentax raw image'],
    'image/x-raw-phaseone' => [%w(iiq), %w(), 'Phase One raw image'],
    'image/x-raw-rawzor' => [%w(rwz), %w(), 'Rawzor raw image'],
    'image/x-raw-red' => [%w(r3d), %w(), 'Red raw image'],
    'image/x-raw-sigma' => [%w(x3f), %w(), 'Sigma raw image'],
    'image/x-raw-sony' => [%w(arw srf sr2), %w(), 'Sony raw image'],
    'image/x-rgb' => [%w(rgb), %w(), 'Silicon Graphics RGB Bitmap'],
    'image/x-tga' => [%w(tga icb vda), %w(), 'Targa image data'],
    'image/x-xbitmap' => [%w(xbm), %w(text/x-c), nil],
    'image/x-xcf' => [%w(xcf), %w(), 'GIMP Image File'],
    'image/x-xpixmap' => [%w(xpm), %w(), nil],
    'image/x-xwindowdump' => [%w(xwd), %w(), 'X Windows Dump'],
    'message/rfc822' => [%w(eml mime), %w(text/x-tika-text-based-message), nil],
    'message/x-emlx' => [%w(emlx), %w(text/x-tika-text-based-message), nil],
    'model/iges' => [%w(igs iges), %w(), 'Initial Graphics Exchange Specification Format'],
    'model/mesh' => [%w(msh mesh silo), %w(), nil],
    'model/vnd.dwf' => [%w(dwf), %w(), 'AutoCAD Design Web Format'],
    'model/vnd.dwfx+xps' => [%w(dwfx), %w(application/x-tika-ooxml), 'AutoCAD Design Web Format'],
    'model/vnd.gdl' => [%w(gdl), %w(), nil],
    'model/vnd.gtw' => [%w(gtw), %w(), nil],
    'model/vnd.mts' => [%w(mts), %w(), nil],
    'model/vnd.vtu' => [%w(vtu), %w(), nil],
    'model/vrml' => [%w(wrl vrml), %w(), nil],
    'multipart/related' => [%w(mht mhtml), %w(message/rfc822), 'MIME Encapsulation of Aggregate HTML Documents'],
    'text/asp' => [%w(asp), %w(text/plain), 'Active Server Page'],
    'text/aspdotnet' => [%w(aspx), %w(text/plain), 'ASP .NET'],
    'text/calendar' => [%w(ics ifb), %w(text/plain), nil],
    'text/css' => [%w(css), %w(text/plain), 'Cascading Style Sheet'],
    'text/csv' => [%w(csv), %w(text/plain), nil],
    'text/html' => [%w(html htm), %w(), 'HyperText Markup Language'],
    'text/iso19139+xml' => [%w(iso19139), %w(application/xml), nil],
    'text/plain' => [%w(txt text def list in aart ac am apt bsh classpath cnd cwiki data dcl dsp dsw egrm ent ft fn fv grm g handlers htc ihtml jmx junit jx manifest m4 mf mf meta mdo n3 pen pod pom project rng rnx roles schemas tld types vm vsl wsdd xargs xcat xegrm xgrm xlex xlog xmap xroles xsamples xsp xtest xweb xwelcome), %w(), nil],
    'text/prs.lines.tag' => [%w(dsc), %w(), nil],
    'text/richtext' => [%w(rtx), %w(), nil],
    'text/sgml' => [%w(sgml sgm), %w(), nil],
    'text/tab-separated-values' => [%w(tsv), %w(), nil],
    'text/troff' => [%w(t tr roff nroff man me ms), %w(), 'Roff/nroff/troff/groff Unformatted Manual Page (UNIX)'],
    'text/uri-list' => [%w(uri uris urls), %w(), nil],
    'text/vnd.curl' => [%w(curl), %w(), nil],
    'text/vnd.curl.dcurl' => [%w(dcurl), %w(), nil],
    'text/vnd.curl.mcurl' => [%w(mcurl), %w(), nil],
    'text/vnd.curl.scurl' => [%w(scurl), %w(), nil],
    'text/vnd.fly' => [%w(fly), %w(), nil],
    'text/vnd.fmi.flexstor' => [%w(flx), %w(), nil],
    'text/vnd.graphviz' => [%w(gv), %w(text/plain), 'Graphviz Graph Visualization Software'],
    'text/vnd.in3d.3dml' => [%w(3dml), %w(), nil],
    'text/vnd.in3d.spot' => [%w(spot), %w(), nil],
    'text/vnd.iptc.anpa' => [%w(anpa), %w(), 'American Newspaper Publishers Association Wire Feeds'],
    'text/vnd.sun.j2me.app-descriptor' => [%w(jad), %w(), nil],
    'text/vnd.wap.wml' => [%w(wml), %w(), nil],
    'text/vnd.wap.wmlscript' => [%w(wmls), %w(), 'WML Script'],
    'text/vtt' => [%w(vtt), %w(text/plain), 'Web Video Text Tracks Format'],
    'text/x-actionscript' => [%w(as), %w(text/plain), 'ActionScript source code'],
    'text/x-ada' => [%w(ada adb ads), %w(text/plain), 'Ada source code'],
    'text/x-applescript' => [%w(applescript), %w(text/plain), 'AppleScript source code'],
    'text/x-asciidoc' => [%w(asciidoc adoc ad ad.txt adoc.txt), %w(text/plain), 'Asciidoc source code'],
    'text/x-aspectj' => [%w(aj), %w(text/plain), 'AspectJ source code'],
    'text/x-assembly' => [%w(s s asm), %w(text/plain), 'Assembler source code'],
    'text/x-awk' => [%w(awk), %w(text/plain), 'AWK script'],
    'text/x-basic' => [%w(bas bas bas), %w(text/plain), 'Basic source code'],
    'text/x-c++hdr' => [%w(hpp hxx hh h h++ hp hpp), %w(text/plain), 'C++ source code header'],
    'text/x-c++src' => [%w(cpp cxx cc c c++ cpp), %w(text/plain), 'C++ source code'],
    'text/x-cgi' => [%w(cgi), %w(text/plain), 'CGI script'],
    'text/x-chdr' => [%w(h), %w(text/plain), 'C source code header'],
    'text/x-clojure' => [%w(clj), %w(text/plain), 'Clojure source code'],
    'text/x-cobol' => [%w(cbl cbl cbl cob cob cob), %w(text/plain), 'COBOL source code'],
    'text/x-coffeescript' => [%w(coffee), %w(text/plain), 'CoffeeScript source code'],
    'text/x-coldfusion' => [%w(cfm cfml cfc), %w(text/plain), 'ColdFusion source code'],
    'text/x-common-lisp' => [%w(cl jl lisp lsp), %w(text/plain), 'Common Lisp source code'],
    'text/x-config' => [%w(config conf cfg xconf), %w(text/plain), nil],
    'text/x-csharp' => [%w(cs), %w(text/plain), 'C# source code'],
    'text/x-csrc' => [%w(c), %w(text/plain), 'C source code'],
    'text/x-d' => [%w(d), %w(text/plain), 'D source code'],
    'text/x-diff' => [%w(diff patch), %w(text/plain), nil],
    'text/x-eiffel' => [%w(e), %w(text/plain), 'Eiffel source code'],
    'text/x-emacs-lisp' => [%w(el), %w(text/plain), 'Emacs Lisp source code'],
    'text/x-erlang' => [%w(erl), %w(text/plain), 'Erlang source code'],
    'text/x-expect' => [%w(exp), %w(text/plain), 'Expect Script'],
    'text/x-forth' => [%w(4th), %w(text/plain), 'Forth source code'],
    'text/x-fortran' => [%w(f f for f77 f90), %w(text/plain), 'Fortran source code'],
    'text/x-go' => [%w(go), %w(text/plain), 'Go source code'],
    'text/x-groovy' => [%w(groovy), %w(text/plain), 'Groovy source code'],
    'text/x-haml' => [%w(haml), %w(text/plain), 'HAML source code'],
    'text/x-haskell' => [%w(hs lhs), %w(text/plain), 'Haskell source code'],
    'text/x-haxe' => [%w(hx), %w(text/plain), 'Haxe source code'],
    'text/x-idl' => [%w(idl), %w(text/plain), 'Inteface Definition Language'],
    'text/x-ini' => [%w(ini), %w(text/plain), 'Configuration file'],
    'text/x-java-properties' => [%w(properties), %w(text/plain), 'Java Properties'],
    'text/x-java-source' => [%w(java), %w(text/plain), 'Java source code'],
    'text/x-jsp' => [%w(jsp), %w(text/plain), 'Java Server Page'],
    'text/x-less' => [%w(less), %w(text/plain), 'LESS source code'],
    'text/x-lex' => [%w(l), %w(text/plain), 'Lex/Flex source code'],
    'text/x-log' => [%w(log), %w(text/plain), 'application log'],
    'text/x-lua' => [%w(lua), %w(text/plain), 'Lua source code'],
    'text/x-ml' => [%w(ml), %w(text/plain), 'ML source code'],
    'text/x-modula' => [%w(m3 i3 mg ig), %w(text/plain), 'Modula source code'],
    'text/x-objcsrc' => [%w(m), %w(text/plain), 'Objective-C source code'],
    'text/x-ocaml' => [%w(ocaml mli), %w(text/plain), 'Ocaml source code'],
    'text/x-pascal' => [%w(p pp pas pas dpr), %w(text/plain), 'Pascal source code'],
    'text/x-perl' => [%w(pl pm al perl), %w(text/plain), 'Perl script'],
    'text/x-php' => [%w(php php3 php4), %w(text/plain), 'PHP script'],
    'text/x-prolog' => [%w(pro), %w(text/plain), 'Prolog source code'],
    'text/x-python' => [%w(py), %w(text/plain), 'Python script'],
    'text/x-rexx' => [%w(rexx), %w(text/plain), 'Rexx source code'],
    'text/x-rsrc' => [%w(r), %w(text/plain), 'R source code'],
    'text/x-rst' => [%w(rest rst restx), %w(text/plain), 'reStructuredText source code'],
    'text/x-ruby' => [%w(rb), %w(text/plain), 'Ruby source code'],
    'text/x-sass' => [%w(sass), %w(text/plain), nil],
    'text/x-scala' => [%w(scala), %w(text/plain), 'Scala source code'],
    'text/x-scheme' => [%w(scm), %w(text/plain), 'Scheme source code'],
    'text/x-scss' => [%w(scss), %w(text/plain), nil],
    'text/x-sed' => [%w(sed), %w(text/plain), 'Sed code'],
    'text/x-setext' => [%w(etx), %w(text/plain), nil],
    'text/x-sql' => [%w(sql), %w(text/plain), 'SQL code'],
    'text/x-stsrc' => [%w(st), %w(text/plain), 'Smalltalk source code'],
    'text/x-tcl' => [%w(itk tcl tk), %w(text/plain), 'Tcl script'],
    'text/x-uuencode' => [%w(uu), %w(), nil],
    'text/x-vbasic' => [%w(cls cls cls frm frm frm), %w(text/x-basic), 'Visual basic source code'],
    'text/x-vbdotnet' => [%w(vb), %w(text/x-vbasic), 'VB.NET source code'],
    'text/x-vbscript' => [%w(vbs), %w(text/x-vbasic), 'VBScript source code'],
    'text/x-vcalendar' => [%w(vcs), %w(text/plain), nil],
    'text/x-vcard' => [%w(vcf), %w(text/plain), nil],
    'text/x-verilog' => [%w(v), %w(text/plain), 'Verilog source code'],
    'text/x-vhdl' => [%w(vhd vhdl), %w(text/plain), 'VHDL source code'],
    'text/x-web-markdown' => [%w(md mdtext mkd markdown), %w(text/plain), 'Markdown source code'],
    'text/x-yacc' => [%w(y), %w(text/plain), 'Yacc/Bison source code'],
    'text/x-yaml' => [%w(yaml), %w(text/plain), 'YAML source code'],
    'video/3gpp' => [%w(3gp), %w(), nil],
    'video/3gpp2' => [%w(3g2), %w(), nil],
    'video/h261' => [%w(h261), %w(), nil],
    'video/h263' => [%w(h263), %w(), nil],
    'video/h264' => [%w(h264), %w(), nil],
    'video/iso.segment' => [%w(m4s), %w(video/quicktime), nil],
    'video/jpeg' => [%w(jpgv), %w(), nil],
    'video/mj2' => [%w(mj2 mjp2), %w(image/x-jp2-container), 'JPEG 2000 Part 3 (Motion JPEG, MJ2)'],
    'video/mp4' => [%w(mp4 mp4v mpg4), %w(video/quicktime), nil],
    'video/mpeg' => [%w(mpeg mpg mpe m1v m2v), %w(), 'MPEG Movie Clip'],
    'video/ogg' => [%w(ogv), %w(application/ogg), 'Ogg Vorbis Video'],
    'video/quicktime' => [%w(qt mov), %w(application/quicktime), 'QuickTime Video'],
    'video/vnd.fvt' => [%w(fvt), %w(), nil],
    'video/vnd.mpegurl' => [%w(mxu m4u), %w(), nil],
    'video/vnd.ms-playready.media.pyv' => [%w(pyv), %w(), nil],
    'video/vnd.vivo' => [%w(viv), %w(), nil],
    'video/webm' => [%w(webm), %w(application/x-matroska), nil],
    'video/x-dirac' => [%w(drc), %w(video/ogg), 'Ogg Packaged Dirac Video'],
    'video/x-f4v' => [%w(f4v), %w(), nil],
    'video/x-flc' => [%w(flc), %w(), nil],
    'video/x-fli' => [%w(fli), %w(), nil],
    'video/x-flv' => [%w(flv), %w(), nil],
    'video/x-jng' => [%w(jng), %w(), nil],
    'video/x-m4v' => [%w(m4v), %w(video/mp4), nil],
    'video/x-matroska' => [%w(mkv), %w(application/x-matroska), nil],
    'video/x-mng' => [%w(mng), %w(), nil],
    'video/x-ms-asf' => [%w(asf), %w(), nil],
    'video/x-ms-wm' => [%w(wm), %w(), nil],
    'video/x-ms-wmv' => [%w(wmv), %w(video/x-ms-asf), nil],
    'video/x-ms-wmx' => [%w(wmx), %w(), nil],
    'video/x-ms-wvx' => [%w(wvx), %w(), nil],
    'video/x-msvideo' => [%w(avi), %w(), 'Audio Video Interleave File'],
    'video/x-ogm' => [%w(ogm), %w(video/ogg), 'Ogg Packaged OGM Video'],
    'video/x-sgi-movie' => [%w(movie), %w(), nil],
    'x-conference/x-cooltalk' => [%w(ice), %w(), 'Cooltalk Audio'],
  }
  # @private
  # :nodoc:
  MAGIC = [
    ['image/jpeg', [[0, "\377\330\377"]]],
    ['image/png', [[0, "\211PNG\r\n\032\n"]]],
    ['image/gif', [[0, 'GIF87a'], [0, 'GIF89a']]],
    ['image/tiff', [[0, "MM\000*"], [0, "II*\000"], [0, "MM\000+"]]],
    ['image/bmp', [[0, 'BM', [[26, "\001\000", [[28, "\000\000"], [28, "\001\000"], [28, "\004\000"], [28, "\b\000"], [28, "\020\000"], [28, "\030\000"], [28, " \000"]]]]]]],
    ['image/vnd.adobe.photoshop', [[0, "8BPS\000\001"], [0, "8BPS\000\002"]]],
    ['image/webp', [[0, 'RIFF', [[8, 'WEBP']]]]],
    ['image/svg+xml', [[0..4096, '<svg']]],
    ['video/x-msvideo', [[0, 'RIFF', [[8, 'AVI ']]], [8, 'AVI ']]],
    ['video/x-ms-wmv', [[0..8192, 'Windows Media Video'], [0..8192, 'VC-1 Advanced Profile'], [0..8192, 'wmv2']]],
    ['video/mp4', [[4, 'ftypmp41'], [4, 'ftypmp42']]],
    ['audio/mp4', [[4, 'ftypM4A '], [4, 'ftypM4B '], [4, 'ftypF4A '], [4, 'ftypF4B ']]],
    ['video/quicktime', [[4, "moov\000"], [4, "mdat\000"], [4, "free\000"], [4, "skip\000"], [4, "pnot\000"], [4, 'ftyp'], [0, "\000\000\000\bwide"]]],
    ['video/mpeg', [[0, "\000\000\001\263"], [0, "\000\000\001\272"]]],
    ['video/webm', [[0, "\032E\337\243", [[4..4096, "B\202", [[4..4096, 'webm', [[4..4096, 'V_VP8'], [4..4096, 'V_VP9']]]]]]]]],
    ['video/x-matroska', [[0, "\032E\337\243\223B\202\210matroska"]]],
    ['video/x-flv', [[0, 'FLV']]],
    ['audio/mpeg', [[0, "\377\362"], [0, "\377\363"], [0, "\377\364"], [0, "\377\365"], [0, "\377\366"], [0, "\377\367"], [0, "\377\372"], [0, "\377\373"], [0, "\377\374"], [0, "\377\375"], [0, "\377\377"], [0, 'ID3']]],
    ['application/pdf', [[0, '%PDF-'], [0, "\357\273\277%PDF-"]]],
    ['application/msword', [[0..8, "\320\317\021\340\241\261\032\341", [[546, 'jbjb'], [546, 'bjbj']]]]],
    ['application/vnd.openxmlformats-officedocument.wordprocessingml.document', [[0, "PK\003\004", [[30..65536, '[Content_Types].xml', [[0..4096, 'word/']]], [30, '_rels/.rels', [[0..4096, 'word/']]]]]]],
    ['application/vnd.ms-powerpoint', [[0..8, "\320\317\021\340\241\261\032\341", [[1152..4096, "P\000o\000w\000e\000r\000P\000o\000i\000n\000t\000 D\000o\000c\000u\000m\000e\000n\000t"]]]]],
    ['application/vnd.openxmlformats-officedocument.presentationml.presentation', [[0, "PK\003\004", [[30..65536, '[Content_Types].xml', [[0..4096, 'ppt/']]], [30, '_rels/.rels', [[0..4096, 'ppt/']]]]]]],
    ['application/vnd.ms-excel', [[2080, 'Microsoft Excel 5.0 Worksheet'], [2080, 'Foglio di lavoro Microsoft Exce'], [2114, 'Biff5'], [2121, 'Biff5'], [0..8, "\320\317\021\340\241\261\032\341", [[1152..4096, "W\000o\000r\000k\000b\000o\000o\000k"]]]]],
    ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', [[0, "PK\003\004", [[30..65536, '[Content_Types].xml', [[0..4096, 'xl/']]], [30, '_rels/.rels', [[0..4096, 'xl/']]]]]]],
    ['application/x-dbf', [[0, "(?s)^[\\\\002\\\\003\\\\060\\\\061\\\\062\\\\103\\\\143\\\\203\\\\213\\\\313\\\\365\\\\345\\\\373].[\\\\001-\\\\014][\\\\001-\\\\037].{4}(?:.[^\\\\000]|[\\\\101-\\\\377].)(?:[^\\\\000\\\\001].|.[^\\\\000]).{31}(?<=[\\\\000][^\\\\000]{0,10})[A-Z@+]"]]],
    ['image/x-tga', [[1, "\001\001\000\000", [[8, ".*[\\\\124\\\\122\\\\125\\\\105\\\\126\\\\111\\\\123\\\\111\\\\117\\\\116\\\\055\\\\130\\\\106\\\\111\\\\114\\\\105\\\\056\\\\000]"]]], [1, "\000\002\000\000", [[8, ".*[\\\\124\\\\122\\\\125\\\\105\\\\126\\\\111\\\\123\\\\111\\\\117\\\\116\\\\055\\\\130\\\\106\\\\111\\\\114\\\\105\\\\056\\\\000]"]]], [1, "\000\003\000\000", [[8, ".*[\\\\124\\\\122\\\\125\\\\105\\\\126\\\\111\\\\123\\\\111\\\\117\\\\116\\\\055\\\\130\\\\106\\\\111\\\\114\\\\105\\\\056\\\\000]"]]]]],
    ['application/x-endnote-refer', [[0..50, '%A ', [[0..1000, "\n%D ", [[0..1000, "\n%T "]]]]]]],
    ['application/x-ms-owner', [[0, "(?s)^([\\\\005-\\\\017])[\\\\000\\\\040-\\\\176]{10}.{43}\\\\1\\000"]]],
    ['application/mbox', [[0, 'From ', [[32..256, "\nFrom: "], [32..256, "\nDate: "], [32..256, "\nSubject: "], [32..256, "\nDelivered-To: "], [32..256, "\nReceived: by "], [32..256, "\nReceived: via "], [32..256, "\nReceived: from "], [32..256, "\nMime-Version: "], [32..256, "\nX-", [[32..8192, "\nFrom: "], [32..8192, "\nDate: "], [32..8192, "\nSubject: "], [32..8192, "\nDelivered-To: "], [32..8192, "\nReceived: by "], [32..8192, "\nReceived: via "], [32..8192, "\nReceived: from "], [32..8192, "\nMime-Version: "]]]]]]],
    ['application/x-bplist', [[0, "bplist\000\000"], [0, "bplist\000\001"], [0, "bplist@\000"], [0, 'bplist00'], [0, 'bplist01'], [0, 'bplist10'], [0, 'bplist15'], [0, 'bplist16']]],
    ['application/x-ms-nls', [[0, "(?s)^\\\\015.{51}\\\\014\\\\000\\\\015\\\\000\\\\016"], [0, "(?s)^\\\\104\\\\103.\\\\001"]]],
    ['message/x-emlx', [[2..9, "\nRelay-Version:"], [2..9, "\n#! rnews"], [2..9, "\nN#! rnews"], [2..9, "\nForward to"], [2..9, "\nPipe to"], [2..9, "\nReturn-Path:"], [2..9, "\nFrom:"], [2..9, "\nReceived:"], [2..9, "\nMessage-ID:"], [2..9, "\nDate:"]]],
    ['application/cbor', [[0, "\331\331\367"]]],
    ['application/coreldraw', [[0, 'RIFF', [[8, 'CDR'], [8, 'cdr'], [8, 'DES'], [8, 'des']]]]],
    ['application/vnd.etsi.asic-e+zip', [[0, "PK\003\004", [[30, 'mimetypeapplication/vnd.etsi.asic-e+zip']]]]],
    ['application/vnd.etsi.asic-s+zip', [[0, "PK\003\004", [[30, 'mimetypeapplication/vnd.etsi.asic-s+zip']]]]],
    ['application/vnd.ms-excel.sheet.2', [[0, "\t\000\004\000", [[4, "\000\000\020\000"], [4, "\000\000 \000"], [4, "\000\000@\000"]]]]],
    ['application/vnd.ms-excel.sheet.3', [[0, "\t\002\006\000", [[4, "\000\000\020\000"], [4, "\000\000 \000"], [4, "\000\000@\000"]]]]],
    ['application/vnd.ms-excel.sheet.4', [[0, "\t\004\006\000", [[4, "\000\000\020\000"], [4, "\000\000 \000"], [4, "\000\000@\000"]]]]],
    ['application/vnd.ms-excel.workspace.3', [[0, "\t\002\006\000", [[4, "\000\000\000\001"]]]]],
    ['application/vnd.ms-excel.workspace.4', [[0, "\t\004\006\000", [[4, "\000\000\000\001"]]]]],
    ['application/x-axcrypt', [[0, "\300\271\a.O\223\361F\240\025y,\241\331\350!", [[17, "\000\000\000\002"]]]]],
    ['application/x-berkeley-db;format=btree;version=2', [[12, "b1\005\000", [[16, "\006\000\000\000"]]], [12, "\000\0051b", [[16, "\000\000\000\006"]]], [12, "b1\005\000", [[16, "\006\000\000\000"]]]]],
    ['application/x-berkeley-db;format=btree;version=3', [[12, "b1\005\000", [[16, "\b\000\000\000"]]], [12, "\000\0051b", [[16, "\000\000\000\b"]]], [12, "b1\005\000", [[16, "\b\000\000\000"]]]]],
    ['application/x-berkeley-db;format=btree;version=4', [[12, "b1\005\000", [[16, "\t\000\000\000"]]], [12, "\000\0051b", [[16, "\000\000\000\t"]]], [12, "b1\005\000", [[16, "\t\000\000\000"]]]]],
    ['application/x-berkeley-db;format=hash;version=2', [[12, "a\025\006\000", [[16, "\005\000\000\000"]]], [12, "\000\006\025a", [[16, "\000\000\000\005"]]], [12, "a\025\006\000", [[16, "\005\000\000\000"]]]]],
    ['application/x-berkeley-db;format=hash;version=3', [[12, "a\025\006\000", [[16, "\a\000\000\000"]]], [12, "\000\006\025a", [[16, "\000\000\000\a"]]], [12, "a\025\006\000", [[16, "\a\000\000\000"]]]]],
    ['application/x-berkeley-db;format=hash;version=4', [[12, "a\025\006\000", [[16, "\b\000\000\000"]]], [12, "\000\006\025a", [[16, "\000\000\000\b"]]], [12, "a\025\006\000", [[16, "\b\000\000\000"]]]]],
    ['application/x-berkeley-db;format=hash;version=5', [[12, "a\025\006\000", [[16, "\t\000\000\000"]]], [12, "\000\006\025a", [[16, "\000\000\000\t"]]], [12, "a\025\006\000", [[16, "\t\000\000\000"]]]]],
    ['application/x-bplist', [[0, 'bplist']]],
    ['application/x-debian-package', [[0, "!<arch>\ndebian-binary"], [0, "!<arch>\ndebian-split"]]],
    ['application/x-font-type1', [[0, "\200\001", [[4, "\000\000%!PS-AdobeFont"]]], [0, '%!PS-AdobeFont-1.0']]],
    ['application/x-internet-archive', [[0, 'filedesc://']]],
    ['application/x-lz4', [[0, "\004\"M\030"], [0, "\002!L\030"]]],
    ['application/x-mobipocket-ebook', [[0..60, 'BOOKMOBI']]],
    ['application/x-msaccess', [[0, "\000\001\000\000Stan"]]],
    ['application/x-msdownload;format=pe-arm7', [[128, "pe\000\000", [[132, "\304\001"]]], [240, "pe\000\000", [[244, "\304\001"]]]]],
    ['application/x-msdownload;format=pe-armLE', [[128, "pe\000\000", [[132, "\300\001"]]], [240, "pe\000\000", [[244, "\300\001"]]]]],
    ['application/x-msdownload;format=pe-itanium', [[128, "PE\000\000", [[132, "\000\002"]]], [240, "PE\000\000", [[244, "\000\002"]]]]],
    ['application/x-msdownload;format=pe32', [[128, "PE\000\000", [[132, "L\001"]]], [240, "PE\000\000", [[244, "L\001"]]]]],
    ['application/x-msdownload;format=pe64', [[128, "PE\000\000", [[132, "d\206"]]], [240, "PE\000\000", [[244, "d\206"]]]]],
    ['application/x-msmoney', [[0, "\000\001\000\000MSISAM Database"]]],
    ['application/x-rar-compressed;version=4', [[0, "Rar!\032\a\000"]]],
    ['application/x-rar-compressed;version=5', [[0, "Rar!\032\a\001\000"]]],
    ['application/x-shapefile', [[0, "\000\000'\n"]]],
    ['application/x-stata-dta;version=10', [[0, '<stata_dta><header><release>114</release>']]],
    ['application/x-stata-dta;version=12', [[0, '<stata_dta><header><release>115</release>']]],
    ['application/x-stata-dta;version=13', [[0, '<stata_dta><header><release>117</release>']]],
    ['application/x-stata-dta;version=14', [[0, '<stata_dta><header><release>118</release>']]],
    ['application/x-stata-dta;version=8', [[0, '<stata_dta><header><release>113</release>']]],
    ['application/x-tika-msworks-spreadsheet', [[0..8, "\320\317\021\340\241\261\032\341", [[1152..4096, "W\000k\000s\000S\000S\000W\000o\000r\000k\000B\000o\000o\000k"]]]]],
    ['audio/opus', [[0, 'OggS', [[29, 'pusHead']]]]],
    ['audio/speex', [[0, 'OggS', [[29, 'peex   ']]]]],
    ['audio/vorbis', [[0, 'OggS', [[29, 'vorbis']]]]],
    ['audio/x-caf', [[0, "caff\000\000"], [0, "caff\000\001"], [0, "caff\000\002"], [0, "caff@\000"], [0, "caff\200\000"]]],
    ['audio/x-oggflac', [[0, 'OggS', [[29, 'LAC']]]]],
    ['audio/x-oggpcm', [[0, 'OggS', [[29, 'CM     ']]]]],
    ['image/avif', [[4, 'ftypavif']]],
    ['image/heic', [[4, 'ftypheic'], [4, 'ftypheix']]],
    ['image/heic-sequence', [[4, 'ftyphevc'], [4, 'ftyphevx']]],
    ['image/heif', [[4, 'ftypmif1']]],
    ['image/heif-sequence', [[4, 'ftypmsf1']]],
    ['message/news', [[0, 'Path:'], [0, 'Xref:']]],
    ['model/vnd.dwf;version=2', [[0, '(DWF V00.22)']]],
    ['model/vnd.dwf;version=5', [[0, '(DWF V00.55)']]],
    ['model/vnd.dwf;version=6', [[0, '(DWF V06.', [[11, ')PK']]]]],
    ['multipart/related', [[0, 'From: <Saved by Windows Internet Explorer 8>'], [0, "From: \"Saved by Internet Explorer 11\""], [0, 'MIME-Version: 1.0', [[16..512, "\nContent-Type: multipart/related"]]]]],
    ['video/3gpp', [[4, 'ftyp3ge6'], [4, 'ftyp3ge7'], [4, 'ftyp3gg6'], [4, 'ftyp3gp1'], [4, 'ftyp3gp2'], [4, 'ftyp3gp3'], [4, 'ftyp3gp4'], [4, 'ftyp3gp5'], [4, 'ftyp3gp6'], [4, 'ftyp3gs7']]],
    ['video/3gpp2', [[4, 'ftyp3g2a'], [4, 'ftyp3g2b'], [4, 'ftyp3g2c']]],
    ['video/daala', [[0, 'OggS', [[29, 'daala']]]]],
    ['video/theora', [[0, 'OggS', [[29, 'theora']]]]],
    ['video/x-dirac', [[0, 'OggS', [[29, 'BCD']]]]],
    ['video/x-m4v', [[4, 'ftypM4V '], [4, 'ftypM4VH'], [4, 'ftypM4VP']]],
    ['video/x-oggrgb', [[0, 'OggS', [[29, 'RGB']]]]],
    ['video/x-ogguvs', [[0, 'OggS', [[29, 'VS ']]]]],
    ['video/x-oggyuv', [[0, 'OggS', [[29, 'YUV']]]]],
    ['video/x-ogm', [[0, 'OggS', [[29, 'ideo']]]]],
    ['application/x-msdownload;format=pe', [[0, 'MZ', [[128, "PE\000\000"], [176, "PE\000\000"], [208, "PE\000\000"], [240, "PE\000\000"]]]]],
    ['application/applefile', [[0, "\000\005\026\000"]]],
    ['application/dash+xml', [[0, '<MPD']]],
    ['application/dicom', [[128, 'DICM']]],
    ['application/epub+zip', [[0, "PK\003\004", [[30, 'mimetypeapplication/epub+zip']]]]],
    ['application/fits', [[0, 'SIMPLE  =                    T'], [0, 'SIMPLE  =                T']]],
    ['application/javascript', [[0, '/* jQuery '], [0, '/*! jQuery '], [0, '/*!', [[4..8, '* jQuery ']]], [0, '(function(e,undefined){'], [0, '!function(window,undefined){'], [0, '/*  Prototype JavaScript '], [0, 'var Prototype={'], [0, 'function $w(t){'], [0, '/** @license React'], [0, '/**', [[4..8, '* React ']]]]],
    ['application/mac-binhex40', [[11, 'must be converted with BinHex']]],
    ['application/mathematica', [[0, '(**'], [0, '(* ']]],
    ['application/msword', [[2080, 'Microsoft Word 6.0 Document'], [2080, 'Documento Microsoft Word 6'], [2112, 'MSWordDoc'], [0, "1\276\000\000"], [0, 'PO^Q`'], [0, "\3767\000#"], [0, "\333\245-\000\000\000"], [0, "\224\246."], [0..8, "\320\317\021\340\241\261\032\341", [[1152..4096, "W\000o\000r\000d\000D\000o\000c\000u\000m\000e\000n\000t"]]]]],
    ['application/msword2', [[0, "\233\245"], [0, "\333\245"]]],
    ['application/msword5', [[0, "\3767"]]],
    ['application/octet-stream', [[10, '# This is a shell archive'], [0, "\037\036"], [0, "\037\037"], [0, "\377\037"], [0, "\377\037"], [0, "\005\313"]]],
    ['application/ogg', [[0, 'OggS']]],
    ['application/onenote;format=one', [[0, "\344R\\{", [[4, "\214\330", [[6, "\247M", [[8, '0xAEB15378D02996D3']]]]]]]]],
    ['application/onenote;format=onetoc2', [[0, "\241/\377C", [[4, "\331\357", [[6, 'vL', [[8, '0x9EE210EA5722765F']]]]]]]]],
    ['application/pkcs7-signature', [[0, '-----BEGIN PKCS7'], [0, '0x3080', [[0, "\006\t*\206H\206\367\r\001\a", [[11, "\240"]]]]], [0, '0x3081', [[0, "\006\t*\206H\206\367\r\001\a", [[11, "\240"]]]]], [0, '0x3082', [[0, "\006\t*\206H\206\367\r\001\a", [[11, "\240"]]]]], [0, '0x3083', [[0, "\006\t*\206H\206\367\r\001\a", [[11, "\240"]]]]], [0, '0x3084', [[0, "\006\t*\206H\206\367\r\001\a", [[11, "\240"]]]]]]],
    ['application/postscript', [[0, '%!'], [0, "\004%!"], [0, "\305\320\323\306"], [0, '%!PS-Adobe-3.0 EPSF-3.0']]],
    ['application/rtf', [[0, "{\\rtf"]]],
    ['application/sereal;version=1', [[0, '=srl']]],
    ['application/sereal;version=2', [[0, '=srl']]],
    ['application/sereal;version=3', [[0, "=\363rl"]]],
    ['application/timestamped-data', [[0, "0\200\006\v*\206H\206\367"]]],
    ['application/vnd.apple.mpegurl', [[0, '#EXTM3U']]],
    ['application/vnd.digilite.prolights', [[0, "\177\fD+"]]],
    ['application/vnd.fdf', [[0, '%FDF-']]],
    ['application/vnd.java.hprof ', [[0, "JAVA PROFILE \\\\d\\\\.\\\\d\\\\.\\\\d\\\\u0000"]]],
    ['application/vnd.java.hprof.text', [[0, "JAVA PROFILE \\\\d\\\\.\\\\d\\\\.\\\\d,"]]],
    ['application/vnd.lotus-1-2-3;version=1', [[0, "\000\000\002\000\004\004"]]],
    ['application/vnd.lotus-1-2-3;version=2', [[0, "\000\000\002\000\006\004\006\000\b\000"]]],
    ['application/vnd.lotus-1-2-3;version=3', [[0, "\000\000\032\000\000\020\004\000"]]],
    ['application/vnd.lotus-1-2-3;version=4', [[0, "\000\000\032\000\002\020\004\000"]]],
    ['application/vnd.lotus-1-2-3;version=97+9.x', [[0, "\000\000\032\000\003\020\004\000"]]],
    ['application/vnd.lotus-wordpro', [[0, "WordPro\000"], [0, "WordPro\r\373"]]],
    ['application/vnd.mif', [[0, '<MakerFile'], [0, '<MIFFile'], [0, '<MakerDictionary'], [0, '<MakerScreenFont'], [0, '<MML'], [0, '<Book'], [0, '<Maker']]],
    ['application/vnd.ms-cab-compressed', [[0, "MSCF\000\000\000\000"]]],
    ['application/vnd.ms-cab-compressed', [[0, 'MSCF']]],
    ['application/vnd.ms-htmlhelp', [[0, 'ITSF']]],
    ['application/vnd.ms-outlook-pst', [[0, '!BDN', [[8, 'SM']]]]],
    ['application/vnd.ms-tnef', [[0, "x\237>\""]]],
    ['application/vnd.ms-works', [[0..8, "\320\317\021\340\241\261\032\341", [[1152..4096, "M\000a\000t\000O\000S\000T"]]]]],
    ['application/vnd.oasis.opendocument.chart', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.chart']]]]],
    ['application/vnd.oasis.opendocument.chart-template', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.chart-template']]]]],
    ['application/vnd.oasis.opendocument.formula', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.formula']]]]],
    ['application/vnd.oasis.opendocument.formula-template', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.formula-template']]]]],
    ['application/vnd.oasis.opendocument.graphics', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.graphics']]]]],
    ['application/vnd.oasis.opendocument.graphics-template', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.graphics-template']]]]],
    ['application/vnd.oasis.opendocument.image', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.image']]]]],
    ['application/vnd.oasis.opendocument.image-template', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.image-template']]]]],
    ['application/vnd.oasis.opendocument.presentation', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.presentation']]]]],
    ['application/vnd.oasis.opendocument.presentation-template', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.presentation-template']]]]],
    ['application/vnd.oasis.opendocument.spreadsheet', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.spreadsheet']]]]],
    ['application/vnd.oasis.opendocument.spreadsheet-template', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.spreadsheet-template']]]]],
    ['application/vnd.oasis.opendocument.text', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.text']]]]],
    ['application/vnd.oasis.opendocument.text-master', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.text-master']]]]],
    ['application/vnd.oasis.opendocument.text-template', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.text-template']]]]],
    ['application/vnd.oasis.opendocument.text-web', [[0, 'PK', [[30, 'mimetypeapplication/vnd.oasis.opendocument.text-web']]]]],
    ['application/vnd.rn-realmedia', [[0, '.RMF']]],
    ['application/vnd.stardivision.calc', [[0..8, "\320\317\021\340\241\261\032\341", [[2048..2207, 'StarCalc']]]]],
    ['application/vnd.stardivision.draw', [[0..8, "\320\317\021\340\241\261\032\341", [[2048..2207, 'StarDraw']]]]],
    ['application/vnd.stardivision.impress', [[0..8, "\320\317\021\340\241\261\032\341", [[2048..2207, 'StarImpress']]]]],
    ['application/vnd.stardivision.writer', [[0..8, "\320\317\021\340\241\261\032\341", [[2048..2207, 'StarWriter']]]]],
    ['application/vnd.sun.xml.writer', [[0, 'PK', [[30, 'mimetypeapplication/vnd.sun.xml.writer']]]]],
    ['application/vnd.symbian.install', [[8, "\031\004\000\020"]]],
    ['application/vnd.tcpdump.pcap', [[0, "\241\262\303\324"], [0, "\324\303\262\241"]]],
    ['application/vnd.wolfram.wl', [[0, '#!/usr/bin/env wolframscript']]],
    ['application/vnd.wordperfect', [[0, 'application/vnd.wordperfect;']]],
    ['application/vnd.wordperfect;version=4.2', [[0, "\313\n\001", [[5, "\313"]]]]],
    ['application/vnd.wordperfect;version=5.0', [[0, "\377WPC", [[10, "\000\000"]]]]],
    ['application/vnd.wordperfect;version=5.1', [[0, "\377WPC", [[10, "\000\001"]]]]],
    ['application/vnd.wordperfect;version=6.x', [[0, "\377WPC", [[10, "\002\001"]]]]],
    ['application/vnd.xara', [[0, 'xar!']]],
    ['application/warc', [[0, 'WARC/']]],
    ['application/wasm', [[0, "\000asm"], [0, "msa\000"]]],
    ['application/x-7z-compressed', [[0..1, '7z', [[2..5, "\274\257'\034"]]]]],
    ['application/x-adobe-indesign', [[0, "\006\006\355\365\330\035F\345\2751\357\347\376t\267\035"]]],
    ['application/x-adobe-indesign-interchange', [[0..100, '<?aid']]],
    ['application/x-archive', [[0, '=<ar>'], [0, "!<arch>\n"]]],
    ['application/x-arj', [[0, "`\352"]]],
    ['application/x-bat', [[0, '@echo off'], [0, 'rem ']]],
    ['application/x-berkeley-db;format=btree', [[0, "b1\005\000"], [0, "\000\0051b"], [0, "b1\005\000"], [12, "b1\005\000"], [12, "\000\0051b"], [12, "b1\005\000"]]],
    ['application/x-berkeley-db;format=hash', [[0, "a\025\006\000"], [0, "\000\006\025a"], [0, "a\025\006\000"], [12, "a\025\006\000"], [12, "\000\006\025a"], [12, "a\025\006\000"]]],
    ['application/x-berkeley-db;format=log', [[12, "\210\t\004\000"], [12, "\210\t\004\000"], [12, "\000\004\t\210"]]],
    ['application/x-berkeley-db;format=queue', [[12, "S\"\004\000"], [12, "\000\004\"S"], [12, "S\"\004\000"]]],
    ['application/x-bibtex-text-file', [[0, '% BibTeX `'], [73, '%%%  '], [0, '% BibTeX standard bibliography '], [73, '%%%  @BibTeX-style-file{'], [0, '@article{'], [0, '@book{'], [0, '@inbook{'], [0, '@incollection{'], [0, '@inproceedings{'], [0, '@manual{'], [0, '@misc{'], [0, '@preamble{'], [0, '@phdthesis{'], [0, '@string{'], [0, '@techreport{'], [0, '@unpublished{']]],
    ['application/x-bittorrent', [[0, 'd8:announce']]],
    ['application/x-chrome-package', [[0, 'Cr24']]],
    ['application/x-compress', [[0, "\037\235"]]],
    ['application/x-coredump', [[0, "\177ELF", [[16, "\004\000"], [16, "\000\004"]]]]],
    ['application/x-cpio', [[0, "\307q"], [0, "q\307"], [0, '070707'], [0, '070701'], [0, '070702']]],
    ['application/x-dex', [[0, "dex\n", [[7, "\000"]]]]],
    ['application/x-dvi', [[0, "\367\002"], [0, "\367\002"], [14, "\e TeX output "]]],
    ['application/x-elc', [[0, "\n("], [0, ";ELC\023\000\000\000"]]],
    ['application/x-elf', [[0, "\177ELF"]]],
    ['application/x-erdas-hfa', [[0, 'EHFA_HEADER_TAG']]],
    ['application/x-executable', [[0, "\177ELF", [[16, "\002\000"], [16, "\000\002"]]]]],
    ['application/x-filemaker', [[14, "\300HBAM7", [[525, "HBAM2101OCT99\301\002H\aPro 7.0\300\300"]]]]],
    ['application/x-foxmail', [[0, "\020\020\020\020\020\020\020\021\021\021\021\021\021S"]]],
    ['application/x-gnumeric', [[39, '=<gmr:Workbook']]],
    ['application/x-grib', [[0, 'GRIB']]],
    ['application/x-gtar', [[257, "ustar  \000"]]],
    ['application/x-hdf', [[0, "\016\003\023\001"], [0, "\211HDF\r\n\032"]]],
    ['application/x-hwp', [[0, 'HWP Document File V']]],
    ['application/x-ibooks+zip', [[0, "PK\003\004", [[30, 'mimetypeapplication/x-ibooks+zip']]]]],
    ['application/x-isatab', [[1, 'Source Name']]],
    ['application/x-isatab-assay', [[1, 'Sample Name']]],
    ['application/x-isatab-investigation', [[0, 'ONTOLOGY SOURCE REFERENCE']]],
    ['application/x-iso9660-image', [[32769, 'CD001'], [34817, 'CD001'], [36865, 'CD001']]],
    ['application/x-java-jnilib', [[0, "\312\376\272\276", [[4096, "\376\355\372\316"], [4096, "\376\355\372\317"], [4096, "\316\372\355\376"], [4096, "\317\372\355\376"]]]]],
    ['application/x-kdelnk', [[0, '[KDE Desktop Entry]'], [0, '# KDE Config File']]],
    ['application/x-latex', [[0, '% -*-latex-*-']]],
    ['application/x-lha', [[2, '-lzs-'], [2, '-lh -'], [2, '-lhd-'], [2, '-lh2-'], [2, '-lh3-'], [2, '-lh4-'], [2, '-lh5-'], [2, '-lh6-'], [2, '-lh7-']]],
    ['application/x-lharc', [[2, '-lh0-'], [2, '-lh1-'], [2, '-lz4-'], [2, '-lz5-']]],
    ['application/x-lzip', [[0, 'LZIP']]],
    ['application/x-matlab-data', [[0, 'MATLAB']]],
    ['application/x-msdownload', [[0, 'MZ']]],
    ['application/x-mswrite', [[0, "1\276\000\000"], [0, "2\276\000\000"]]],
    ['application/x-netcdf', [[0, "CDF\001"], [0, "CDF\002"], [0, "CDF\001"]]],
    ['application/x-object', [[0, "\177ELF", [[16, "\001\000"], [16, "\000\001"]]]]],
    ['application/x-ole-storage', [[0..8, "\320\317\021\340\241\261\032\341"]]],
    ['application/x-parquet', [[0, 'PAR1']]],
    ['application/x-project', [[0, 'MPX,Microsoft Project for Windows,']]],
    ['application/x-prt', [[8, '0M3C']]],
    ['application/x-quattro-pro;version=1+5', [[0, "\000\000\002\000\001\020"]]],
    ['application/x-quattro-pro;version=1-4', [[0, "\000\000\002\000 Q"]]],
    ['application/x-quattro-pro;version=5', [[0, "\000\000\002\000!Q"]]],
    ['application/x-quattro-pro;version=6', [[0, "\000\000\002\000\002\020"]]],
    ['application/x-rar-compressed', [[0, 'Rar!'], [0, "Rar!\032"]]],
    ['application/x-rpm', [[0, "\355\253\356\333"]]],
    ['application/x-sc', [[38, 'Spreadsheet']]],
    ['application/x-sh', [[0, '#!/'], [0, '#! /'], [0, "#!\t/"], [0, "eval \"exec"]]],
    ['application/x-sharedlib', [[0, "\177ELF", [[16, "\003\000"], [16, "\000\003"]]]]],
    ['application/x-shockwave-flash', [[0, 'FWS'], [0, 'CWS']]],
    ['application/x-snappy-framed', [[0, 'sNaPpY']]],
    ['application/x-sqlite3', [[0, "SQLite format 3\000"]]],
    ['application/x-stata-dta', [[0, '<stata_dta><header><release>']]],
    ['application/x-stuffit', [[0, 'StuffIt']]],
    ['application/x-tex', [[0, "\\input"], [0, "\\section"], [0, "\\setlength"], [0, "\\documentstyle"], [0, "\\chapter"], [0, "\\documentclass"], [0, "\\relax"], [0, "\\contentsline"]]],
    ['application/x-texinfo', [[0, "\\input texinfo"]]],
    ['application/x-tika-ooxml', [[0, "PK\003\004", [[30, '[Content_Types].xml'], [30, '_rels/.rels']]]]],
    ['application/x-uc2-compressed', [[0, "UC2\032"]]],
    ['application/x-vhd', [[0, 'conectix']]],
    ['application/x-x509-cert;format=der', []],
    ['application/x-x509-cert;format=pem', [[0, '-----BEGIN CERTIFICATE-----']]],
    ['application/x-x509-dsa-parameters', [[0, '-----BEGIN DSA PARAMETERS-----']]],
    ['application/x-x509-ec-parameters', [[0, '-----BEGIN EC PARAMETERS-----']]],
    ['application/x-x509-key;format=pem', [[0, '-----BEGIN PRIVATE KEY-----'], [0, '-----BEGIN PUBLIC KEY-----'], [0, '-----BEGIN KEY-----'], [0, '-----BEGIN RSA KEY-----'], [0, '-----BEGIN RSA PRIVATE KEY-----'], [0, '-----BEGIN DSA KEY-----'], [0, '-----BEGIN DSA PRIVATE KEY-----']]],
    ['application/x-xz', [[0, "\3757zXZ\000"]]],
    ['application/x-zoo', [[20, "\334\247\304\375"]]],
    ['application/xml', [[0, '<?xml'], [0, '<?XML'], [0, "\357\273\277<?xml"], [0, "\377\376<\000?\000x\000m\000l\000"], [0, "\376\377\000<\000?\000x\000m\000l"]]],
    ['application/zip', [[0, "PK\003\004"], [0, "PK\005\006"], [0, "PK\a\b"]]],
    ['application/zstd', [[0, "(\265/\375"]]],
    ['audio/ac3', [[0, "\vw"]]],
    ['audio/amr-wb', [[0, "#!AMR-WB\n"]]],
    ['audio/eac3', [[0, "\vw"]]],
    ['audio/prs.sid', [[0, 'PSID']]],
    ['audio/webm', [[0, "\032E\337\243", [[4..4096, "B\202", [[4..4096, 'webm', [[4..4096, 'A_VORBIS'], [4..4096, 'A_OPUS']]]]]]]]],
    ['audio/x-flac', [[0, 'fLaC']]],
    ['audio/x-mod', [[0, 'Extended Module:'], [21, 'BMOD2STM'], [1080, 'M.K.'], [1080, 'M!K!'], [1080, 'FLT4'], [1080, 'FLT8'], [1080, '4CHN'], [1080, '6CHN'], [1080, '8CHN'], [1080, 'CD81'], [1080, 'OKTA'], [1080, '16CN'], [1080, '32CN'], [0, 'IMPM']]],
    ['audio/x-mpegurl', [[0, "#EXTM3U\r\n"]]],
    ['audio/x-ms-wma', [[0..8192, 'Windows Media Audio']]],
    ['audio/x-pn-realaudio', [[0, ".ra\375"]]],
    ['chemical/x-cdx', [[0, 'VjCD0100']]],
    ['font/woff', [[0, 'wOFF']]],
    ['font/woff2', [[0, 'wOF2']]],
    ['image/aces', [[0, "v/1\001\002\000\000\000"], [0, "v/1\001\002\004\000\000"]]],
    ['image/cgm', [[0, 'BEGMF']]],
    ['image/emf', [[0, "\001\000\000\000", [[40, ' EMF']]]]],
    ['image/fits', [[0, 'SIMPLE  =  ']]],
    ['image/heic', [[4, 'ftypheic'], [4, 'ftypheix']]],
    ['image/heic-sequence', [[4, 'ftyphevc'], [4, 'ftyphevx']]],
    ['image/heif', [[4, 'ftypmif1']]],
    ['image/heif-sequence', [[4, 'ftypmsf1']]],
    ['image/icns', [[0, 'icns']]],
    ['image/jp2', [[0, "\000\000\000\fjP  \r\n\207\n", [[20, 'jp2 ']]]]],
    ['image/jpm', [[0, "\000\000\000\fjP  \r\n\207\n", [[20, 'jpm ']]]]],
    ['image/jpx', [[0, "\000\000\000\fjP  \r\n\207\n", [[20, 'jpx ']]]]],
    ['image/nitf', [[0, 'NITF01.10'], [0, 'NITF02.000'], [0, 'NITF02.100']]],
    ['image/vnd.djvu', [[0, 'AT&TFORM']]],
    ['image/vnd.dwg', [[0, 'MC0.0'], [0, 'AC1.2'], [0, 'AC1.40'], [0, 'AC1.50'], [0, 'AC2.10'], [0, 'AC2.21'], [0, 'AC2.22']]],
    ['image/vnd.dxb', [[0, "AutoCAD DXB 1.0\r\n0x1A00"]]],
    ['image/vnd.dxf;format=ascii', [[0..3, "0\\r\\nSECTION\\r\\n", [[12..18, "2\\r\\nHEADER\\r\\n"]]]]],
    ['image/vnd.dxf;format=binary', [[0, "AutoCAD Binary DXF\r\n0x1A00"]]],
    ['image/vnd.microsoft.icon', [[0, "BA(\000\000\000.\000\000\000\000\000\000\000"], [0, "\000\000\001\000"]]],
    ['image/vnd.ms-modi', [[0, "EP*\000"]]],
    ['image/vnd.zbrush.dcx', [[0, "\261h\336:"]]],
    ['image/wmf', [[0, "\327\315\306\232\000\000"], [0, "\001\000\t\000\000\003"]]],
    ['image/x-bpg', [[0, "BPG\373"]]],
    ['image/x-dpx', [[0, 'SDPX'], [0, 'XPDS']]],
    ['image/x-freehand', [[0, 'AGD2'], [0, 'AGD3'], [0, 'AGD4'], [0..24, 'FreeHand10'], [0..24, 'FreeHand11'], [0..24, 'FreeHand12']]],
    ['image/x-jbig2', [[0, "\227JB2\r\n\032\n"]]],
    ['image/x-jp2-container', [[0, "\000\000\000\fjP  \r\n\207\n"]]],
    ['image/x-niff', [[0, 'IIN1']]],
    ['image/x-pict', [[522, "\000\021\002\377\f\000"]]],
    ['image/x-portable-bitmap', [[0, 'P1'], [0, 'P4']]],
    ['image/x-portable-graymap', [[0, 'P2'], [0, 'P5'], [0, "P5\n"]]],
    ['image/x-portable-pixmap', [[0, 'P3'], [0, 'P6'], [0, 'P7'], [0, "P4\n"]]],
    ['image/x-raw-olympus', [[0, 'IIRO']]],
    ['image/x-rgb', [[0, "\001\332\001\001\000\003"]]],
    ['image/x-xbitmap', [[0, '/* XPM']]],
    ['image/x-xcf', [[0, 'gimp xcf ']]],
    ['message/news', [[0, 'Article']]],
    ['message/rfc822', [[0, 'Relay-Version:'], [0, '#! rnews'], [0, 'N#! rnews'], [0, 'Forward to'], [0, 'Pipe to'], [0, 'Return-Path:'], [0, 'Message-ID:'], [0, 'X-Mailer:'], [0, 'X-Notes-Item:', [[0..8192, 'Message-ID:']]], [0, nil, [[0, 'Date:'], [0, 'Delivered-To:'], [0, 'From:'], [0, 'Message-ID:'], [0, 'MIME-Version:'], [0, 'Received:'], [0, 'Relay-Version:'], [0, 'Return-Path:'], [0, 'Sent:'], [0, 'Status:'], [0, 'User-Agent:'], [0, 'X-Mailer:'], [0, 'X-Originating-IP:'], [0..1024, "\nDate:"], [0..1024, "\nDelivered-To:"], [0..1024, "\nFrom:"], [0..1024, "\nMIME-Version:"], [0..1024, "\nReceived:"], [0..1024, "\nRelay-Version:"], [0..1024, "\nReturn-Path:"], [0..1024, "\nSent:"], [0..1024, "\nStatus:"], [0..1024, "\nSubject:"], [0..1024, "\nTo:"], [0..1024, "\nUser-Agent:"], [0..1024, "\nX-Mailer:"], [0..1024, "\nX-Originating-IP:"]]], [0, '(X|DKIM|ARC)-', [[0..8192, "\nDate:"], [0..8192, "\nDelivered-To:"], [0..8192, "\nFrom:"], [0..8192, "\nMessage-ID:"], [0..8192, "\nMIME-Version:"], [0..8192, "\nReceived:"], [0..8192, "\nRelay-Version:"], [0..8192, "\nReturn-Path:"], [0..8192, "\nStatus:"], [0..8192, "\nUser-Agent:"], [0..8192, "\nX-Mailer:"], [0..8192, "\nX-Originating-IP:"]]]]],
    ['model/vnd.dwf', [[0, '(DWF V', [[8, '.', [[11, ')']]]]]]],
    ['multipart/appledouble', [[0, "\000\005\026\a"]]],
    ['text/calendar', [[0, 'BEGIN:VCALENDAR', [[15..30, 'VERSION:2.0']]]]],
    ['text/troff', [[0, ".\\\""], [0, "'\\\""], [0, "'.\\\""], [0, "\\\""], [0, "'''"]]],
    ['text/vnd.graphviz', [[0, "(?s)^\\\\s*(?:strict\\\\s+)?(?:di)?graph\\\\b"], [0, "(?s)^(?:\\\\s*//[^\\\\n]*\\n){1,10}\\\\s*(?:strict\\\\s+)?(?:di)?graph\\\\b"], [0, "(?s)^\\\\s*/\\\\*.{0,1024}?\\\\*/\\\\s*(?:strict\\\\s+)?(?:di)?graph\\\\b"]]],
    ['text/vnd.iptc.anpa', [[0, "\026\026\001"]]],
    ['text/x-awk', [[0, '#!/bin/gawk'], [0, '#! /bin/gawk'], [0, '#!/usr/bin/gawk'], [0, '#! /usr/bin/gawk'], [0, '#!/usr/local/bin/gawk'], [0, '#! /usr/local/bin/gawk'], [0, '#!/bin/awk'], [0, '#! /bin/awk'], [0, '#!/usr/bin/awk'], [0, '#! /usr/bin/awk']]],
    ['text/x-diff', [[0, 'diff '], [0, '*** '], [0, 'Only in '], [0, 'Common subdirectories: '], [0, 'Index:']]],
    ['text/x-jsp', [[0, '<%@'], [0, '<%--']]],
    ['text/x-matlab', [[0, 'function [']]],
    ['text/x-perl', [[0, "eval \"exec /usr/local/bin/perl"], [0, '#!/bin/perl'], [0, '#!/bin/env perl'], [0, '#!/usr/bin/perl'], [0, '#!/usr/local/bin/perl']]],
    ['text/x-php', [[0, '<?php']]],
    ['text/x-python', [[0, '#!/bin/python'], [0, '#! /bin/python'], [0, "eval \"exec /bin/python"], [0, '#!/usr/bin/python'], [0, '#! /usr/bin/python'], [0, "eval \"exec /usr/bin/python"], [0, '#!/usr/local/bin/python'], [0, '#! /usr/local/bin/python'], [0, "eval \"exec /usr/local/bin/python"], [1, '/bin/env python']]],
    ['text/x-vcalendar', [[0, 'BEGIN:VCALENDAR', [[15..30, 'VERSION:1.0']]]]],
    ['text/x-vcard', [[0, 'BEGIN:VCARD']]],
    ['video/mj2', [[0, "\000\000\000\fjP  \r\n\207\n", [[20, 'mjp2']]]]],
    ['video/x-jng', [[0, "\213JNG"]]],
    ['video/x-mng', [[0, "\212MNG"]]],
    ['video/x-ms-asf', [[0, "0&\262u"]]],
    ['video/x-sgi-movie', [[0, "MOVI\000"], [0, "MOVI\001"], [0, "MOVI\002"], [0, "MOVI\376"], [0, "MOVI\377"]]],
    ['application/gzip', [[0, "\037\213"], [0, "\037\213"]]],
    ['application/zlib', [[0, "x\001"], [0, 'x^'], [0, "x\234"], [0, "x\332"]]],
    ['application/java-vm', [[0, "\312\376\272\276"]]],
    ['application/vnd.wordperfect', [[0, "\377WPC"]]],
    ['application/x-bzip', [[0, 'BZh']]],
    ['application/x-bzip2', [[0, 'BZh91']]],
    ['application/x-font-adobe-metric', [[0, 'StartFontMetrics']]],
    ['application/x-font-printer-metric', [[0, "\000\001", [[4, "\000\000Copyr"]]]]],
    ['application/x-font-ttf', [[0, "\000\001\000\000"]]],
    ['application/x-matroska', [[0, "\032E\337\243"]]],
    ['application/x-mysql-misam-compressed-index', [[0, "\376\376\006"], [0, "\376\376\a"]]],
    ['application/x-mysql-misam-index', [[0, "\376\376\003"], [0, "\376\376\005"]]],
    ['application/x-mysql-table-definition', [[0, "\376\001\a"], [0, "\376\001\b"], [0, "\376\001\t"], [0, "\376\001\n"], [0, "\376\001\v"], [0, "\376\001\f"]]],
    ['application/x-sas-data', [[84, 'SAS FILE']]],
    ['application/x-sas-data-v6', [[0, 'SAS     6.'], [0, 'SAS     7.'], [0, 'SAS     8.0'], [0, 'SAS     9.0']]],
    ['application/x-sas-xport', [[0, 'HEADER RECORD*******LIBRARY HEADER RECORD!!!!!!!']]],
    ['application/x-stata-dta', [[0, '<stata_dta>']]],
    ['application/x-tar', [[257, "ustar\000"]]],
    ['application/x-tika-msoffice', [[0..8, "\320\317\021\340\241\261\032\341"]]],
    ['application/x-x509-key;format=der', []],
    ['application/xhtml+xml', [[0..8192, '<html xmlns=']]],
    ['audio/ac3', [[0, "\vw"]]],
    ['audio/amr', [[0, "#!AMR\n"], [0, '#!AMR']]],
    ['image/vnd.zbrush.pcx', [[0, "\n", [[1, "\000"], [1, "\002"], [1, "\003"], [1, "\004"], [1, "\005"]]]]],
    ['message/rfc822', [[0..1000, "\nMessage-ID:"]]],
    ['text/html', [[0..64, '<!DOCTYPE HTML'], [0..64, '<!DOCTYPE html'], [0..64, '<!doctype HTML'], [0..64, '<!doctype html'], [0..64, '<HEAD'], [0..64, '<head'], [0..64, '<TITLE'], [0..64, '<title'], [0..64, '<HTML'], [0, '<BODY'], [0, '<body'], [0, '<DIV'], [0, '<div'], [0, '<TITLE'], [0, '<title'], [0, '<h1'], [0, '<H1'], [0..128, '<html']]],
    ['text/vtt', [[0, "WEBVTT\r"], [0, "WEBVTT\n"], [0, '0xfeff', [[2, "WEBVTT\r"]]], [0, '0xfeff', [[2, "WEBVTT\n"]]], [0, "WEBVTT FILE\r"], [0, "WEBVTT FILE\n"]]],
    ['text/x-matlab', [[0, "function [a-zA-Z][A-Za-z0-9_]{0,62}[\\\\r\\\\n]"]]],
    ['text/x-matlab', [[0, "function [a-zA-Z][A-Za-z0-9_]{0,62}\\\\s*="]]],
    ['application/inf', [[0, '[version]'], [0, '[strings]']]],
    ['application/x-bibtex-text-file', [[0, '%', [[2..128, "\n@article{"], [2..128, "\n@book{"], [2..128, "\n@inbook{"], [2..128, "\n@incollection{"], [2..128, "\n@inproceedings{"], [2..128, "\n@manual{"], [2..128, "\n@misc{"], [2..128, "\n@preamble{"], [2..128, "\n@phdthesis{"], [2..128, "\n@string{"], [2..128, "\n@techreport{"], [2..128, "\n@unpublished{"]]]]],
    ['application/xml', [[0, '<!--']]],
    ['text/vtt', [[0, 'WEBVTT ', [[10..50, "\n\n"]]], [0, 'WEBVTT ', [[10..50, "\r\r"]]], [0, 'WEBVTT ', [[10..50, "\r\n\r\n"]]]]],
    ['text/x-chdr', [[0, '#ifndef ']]],
    ['text/x-csrc', [[0, '#include ']]],
    ['image/x-jp2-codestream', [[0, "\377O\377Q"]]],
    ['text/x-matlab', [[0, '%', [[2..120, "\n%"]]], [0, '%', [[2..120, "\r%"]]], [0, '%%']]],
    ['application/pdf', [[1..512, '%PDF-1.'], [1..512, '%PDF-2.']]],
    ['audio/basic', [[0, '.snd', [[12, "\000\000\000\001"], [12, "\000\000\000\002"], [12, "\000\000\000\003"], [12, "\000\000\000\004"], [12, "\000\000\000\005"], [12, "\000\000\000\006"], [12, "\000\000\000\a"]]], [0, ".snd\000\000\000"]]],
    ['audio/midi', [[0, 'MThd']]],
    ['audio/vnd.wave', [[0, 'RIFF', [[8, 'WAVE']]]]],
    ['audio/x-adpcm', [[0, '.snd', [[12, "\000\000\000\027"]]]]],
    ['audio/x-aiff', [[0, 'FORM', [[8, 'AIFF']]], [0, 'FORM', [[8, 'AIFC']]], [0, 'FORM', [[8, '8SVX']]], [0, "FORM\000"]]],
    ['audio/x-dec-adpcm', [[0, "\000ds.", [[12, "\000\000\000\027"]]]]],
    ['audio/x-dec-basic', [[0, "\000ds.", [[12, "\000\000\000\001"], [12, "\000\000\000\002"], [12, "\000\000\000\003"], [12, "\000\000\000\004"], [12, "\000\000\000\005"], [12, "\000\000\000\006"], [12, "\000\000\000\a"]]]]],
    ['text/html', [[128..8192, '<html']]],
    ['text/plain', [[0, 'This is TeX,'], [0, 'This is METAFONT,'], [0, '/*'], [0, '//'], [0, ';;'], [0, "\376\377"], [0, "\377\376"], [0, "\357\273\277"]]],
    ['text/x-makefile', [[0, '# Makefile.in generated by'], [0, '#!make'], [0, '#!/usr/bin/make'], [0, '#!/usr/local/bin/make'], [0, '#!/usr/bin/env make']]],
  ]
end
