/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search.provider.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinitionFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class FilterHelper {
    private List<SearchFilterDefinition> filters = new ArrayList<SearchFilterDefinition>();
    private boolean active;
    private Stack<List<SearchFilterDefinition>> stack;

    public FilterHelper(List<SearchFilterDefinition> list, SearchScopeOptions searchScopeOptions) {
        if (searchScopeOptions == null) {
            throw new NullPointerException("Options cannot be null.");
        }
        if (list != null) {
            for (SearchFilterDefinition searchFilterDefinition : list) {
                if (searchScopeOptions.isSearchInGenerated()) {
                    if (searchFilterDefinition == SearchInfoDefinitionFactory.SHARABILITY_FILTER) continue;
                    this.filters.add(searchFilterDefinition);
                    continue;
                }
                this.filters.add(searchFilterDefinition);
            }
        }
        for (SearchFilterDefinition searchFilterDefinition : searchScopeOptions.getFilters()) {
            this.filters.add(searchFilterDefinition);
        }
        this.stack = new Stack();
        this.stack.push(this.filters);
        this.active = !this.filters.isEmpty();
    }

    public boolean fileAllowed(File file, SearchListener searchListener) {
        if (this.active) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null) {
                return this.fileAllowed(fileObject, searchListener);
            }
            searchListener.generalError(new RuntimeException("No FileObject for file " + file.getPath()));
            return false;
        }
        return true;
    }

    public boolean fileAllowed(FileObject fileObject, SearchListener searchListener) {
        if (this.active) {
            for (SearchFilterDefinition searchFilterDefinition : this.stack.peek()) {
                if (searchFilterDefinition.searchFile(fileObject)) continue;
                searchListener.fileSkipped(fileObject, searchFilterDefinition, null);
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean directoryAllowed(File file, SearchListener searchListener) {
        if (this.active) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null) {
                return this.directoryAllowed(fileObject, searchListener);
            }
            searchListener.generalError(new RuntimeException("No FileObject for directory " + file.getPath()));
            return false;
        }
        return true;
    }

    public boolean directoryAllowed(FileObject fileObject, SearchListener searchListener) {
        if (this.active) {
            LinkedList linkedList = null;
            boolean bl = true;
            block5: for (SearchFilterDefinition searchFilterDefinition : this.stack.peek()) {
                SearchFilterDefinition.FolderResult folderResult = searchFilterDefinition.traverseFolder(fileObject);
                switch (folderResult) {
                    case TRAVERSE: {
                        continue block5;
                    }
                    case DO_NOT_TRAVERSE: {
                        bl = false;
                        searchListener.fileSkipped(fileObject, searchFilterDefinition, null);
                        break block5;
                    }
                    case TRAVERSE_ALL_SUBFOLDERS: {
                        if (linkedList == null) {
                            linkedList = new LinkedList(this.stack.peek());
                        }
                        linkedList.remove(searchFilterDefinition);
                        continue block5;
                    }
                    default: {
                        assert (false);
                        continue block5;
                    }
                }
            }
            if (bl) {
                if (linkedList != null) {
                    this.stack.push(linkedList);
                } else {
                    this.stack.push(this.stack.peek());
                }
            }
            return bl;
        }
        return true;
    }

    public void popStack() {
        if (this.active) {
            this.stack.pop();
        }
    }
}

