/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import org.graalvm.visualvm.lib.charts.ChartContext;
import org.graalvm.visualvm.lib.charts.ChartItem;
import org.graalvm.visualvm.lib.charts.ChartOverlay;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItem;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing.ColorIcon;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing.LabelRenderer;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing.LegendFont;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineChart;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineXYPainter;

final class TimelineLegendOverlay
extends ChartOverlay {
    private final TimelineChart chart;
    private final LabelRenderer painter;

    TimelineLegendOverlay(TimelineChart chart) {
        this.chart = chart;
        this.painter = new LabelRenderer();
        this.painter.setFont(new LegendFont());
        int size = this.painter.getFont().getSize() - 3;
        ColorIcon.setup(size, size, LegendFont.FOREGROUND_COLOR, LegendFont.BACKGROUND_COLOR);
    }

    private void setupPainter(String text, Color color) {
        this.painter.setText(text);
        this.painter.setIcon(ColorIcon.fromColor(color));
    }

    public void paint(Graphics g) {
        int rowsCount = this.chart.getRowsCount();
        for (int i = 0; i < rowsCount; ++i) {
            TimelineChart.Row row = this.chart.getRow(i);
            ChartContext rowContext = row.getContext();
            SynchronousXYItem[] rowItems = row.getItems();
            int x = 3;
            int y = -1;
            for (SynchronousXYItem rowItem : rowItems) {
                TimelineXYPainter itemPainter = (TimelineXYPainter)this.chart.getPaintersModel().getPainter((ChartItem)rowItem);
                if (!itemPainter.isPainting()) continue;
                this.setupPainter(rowItem.getName(), itemPainter.getDefiningColor());
                Dimension pd = this.painter.getPreferredSize();
                if (y == -1) {
                    y = Utils.checkedInt((double)rowContext.getViewportOffsetY()) + rowContext.getViewportHeight() - pd.height - 1;
                }
                this.paint(g, x, y);
                x += pd.width + 10;
            }
        }
    }

    private void paint(Graphics g, int x, int y) {
        this.painter.setLocation(x, y + 1);
        this.painter.setForeground(LegendFont.BACKGROUND_COLOR);
        this.painter.paint(g);
        this.painter.setLocation(x, y);
        this.painter.setForeground(LegendFont.FOREGROUND_COLOR);
        this.painter.setIcon(ColorIcon.BOTTOM_SHADOW);
        this.painter.paint(g);
    }

    public void invalidate() {
    }

    public void update(Graphics g) {
    }
}

