/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines;

import com.sun.j3d.audioengines.AudioEngine;
import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.Sample;
import java.util.ArrayList;
import javax.media.j3d.AudioDevice3D;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public abstract class AudioEngine3D
extends AudioEngine
implements AudioDevice3D {
    protected ArrayList samples = new ArrayList(64);
    protected View currentView = null;
    protected AuralParameters attribs = new AuralParameters();

    public AudioEngine3D(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
    }

    public void setView(View view) {
        this.currentView = view;
    }

    public View getView() {
        return this.currentView;
    }

    public int prepareSound(int n, MediaContainer mediaContainer) {
        return -1;
    }

    public abstract void clearSound(int var1);

    public void setVworldXfrm(int n, Transform3D transform3D) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            sample.vworldXfrm.set(transform3D);
        }
    }

    public abstract int startSample(int var1);

    public abstract int stopSample(int var1);

    public abstract void updateSample(int var1);

    public abstract void muteSample(int var1);

    public abstract void unmuteSample(int var1);

    public abstract void pauseSample(int var1);

    public abstract void unpauseSample(int var1);

    public void setSampleGain(int n, float f) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            sample.setGain(f);
        }
    }

    public void setLoop(int n, int n2) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            sample.setLoopCount(n2);
        }
    }

    public void setPosition(int n, Point3d point3d) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            sample.setPosition(point3d);
        }
    }

    public void setDistanceGain(int n, double[] dArray, float[] fArray, double[] dArray2, float[] fArray2) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            sample.setDistanceGain(dArray, fArray, dArray2, fArray2);
        }
    }

    public void setDirection(int n, Vector3d vector3d) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            sample.setDirection(vector3d);
        }
    }

    public void setAngularAttenuation(int n, int n2, double[] dArray, float[] fArray, float[] fArray2) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            sample.setAngularAttenuation(n2, dArray, fArray, fArray2);
        }
    }

    public void setRolloff(float f) {
        this.attribs.rolloff = f;
    }

    public void setReflectionCoefficient(float f) {
        this.attribs.reflectionCoefficient = f;
    }

    public void setReverbDelay(float f) {
        this.attribs.reverbDelay = f;
    }

    public void setReverbOrder(int n) {
        this.attribs.reverbOrder = n;
    }

    public void setDistanceFilter(int n, double[] dArray, float[] fArray) {
        this.attribs.setDistanceFilter(n, dArray, fArray);
    }

    public void setFrequencyScaleFactor(float f) {
        this.attribs.frequencyScaleFactor = f;
    }

    public void setVelocityScaleFactor(float f) {
        this.attribs.velocityScaleFactor = f;
    }

    public int getNumberOfChannelsUsed(int n) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            return sample.getNumberOfChannelsUsed();
        }
        return 0;
    }

    public int getNumberOfChannelsUsed(int n, boolean bl) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            return sample.getNumberOfChannelsUsed();
        }
        return 0;
    }

    public long getSampleDuration(int n) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            return sample.getDuration();
        }
        return 0L;
    }

    public long getStartTime(int n) {
        Sample sample = this.getSample(n);
        if (sample != null) {
            return sample.getStartTime();
        }
        return 0L;
    }

    protected ArrayList getSampleList() {
        return this.samples;
    }

    public int getSampleListSize() {
        return this.samples.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(int n) {
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            if (n >= 0 && n < this.samples.size()) {
                Sample sample = (Sample)this.samples.get(n);
                return sample;
            }
            return null;
        }
    }

    public AuralParameters getAuralParameters() {
        return this.attribs;
    }
}

