/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Fixed;
import jogamp.graph.font.typecast.ot.table.Table;

public class PostTable
implements Table {
    private static final String[] macGlyphName = new String[]{".notdef", "null", "CR", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral'", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "increment", "guillemotleft", "guillemotright", "ellipsis", "nbspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "middot", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "overscore", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idot", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
    private int version;
    private int italicAngle;
    private short underlinePosition;
    private short underlineThickness;
    private int isFixedPitch;
    private int minMemType42;
    private int maxMemType42;
    private int minMemType1;
    private int maxMemType1;
    private int numGlyphs;
    private int[] glyphNameIndex;
    private String[] psGlyphName;

    public PostTable(DataInput dataInput) throws IOException {
        this.version = dataInput.readInt();
        this.italicAngle = dataInput.readInt();
        this.underlinePosition = dataInput.readShort();
        this.underlineThickness = dataInput.readShort();
        this.isFixedPitch = dataInput.readInt();
        this.minMemType42 = dataInput.readInt();
        this.maxMemType42 = dataInput.readInt();
        this.minMemType1 = dataInput.readInt();
        this.maxMemType1 = dataInput.readInt();
        if (this.version == 131072) {
            int n;
            this.numGlyphs = dataInput.readUnsignedShort();
            this.glyphNameIndex = new int[this.numGlyphs];
            for (n = 0; n < this.numGlyphs; ++n) {
                this.glyphNameIndex[n] = dataInput.readUnsignedShort();
            }
            n = this.highestGlyphNameIndex();
            if (n > 257) {
                this.psGlyphName = new String[n -= 257];
                for (int i = 0; i < n; ++i) {
                    int n2 = dataInput.readUnsignedByte();
                    byte[] byArray = new byte[n2];
                    dataInput.readFully(byArray);
                    this.psGlyphName[i] = new String(byArray);
                }
            }
        } else if (this.version == 151552 || this.version == 196608) {
            // empty if block
        }
    }

    public int getVersion() {
        return this.version;
    }

    private int highestGlyphNameIndex() {
        int n = 0;
        for (int i = 0; i < this.numGlyphs; ++i) {
            if (n >= this.glyphNameIndex[i]) continue;
            n = this.glyphNameIndex[i];
        }
        return n;
    }

    public String getGlyphName(int n) {
        if (this.version == 131072) {
            return this.glyphNameIndex[n] > 257 ? this.psGlyphName[this.glyphNameIndex[n] - 258] : macGlyphName[this.glyphNameIndex[n]];
        }
        return null;
    }

    private boolean isMacGlyphName(int n) {
        if (this.version == 131072) {
            return this.glyphNameIndex[n] <= 257;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'post' Table - PostScript Metrics\n---------------------------------\n").append("\n        'post' version:        ").append(Fixed.floatValue(this.version)).append("\n        italicAngle:           ").append(Fixed.floatValue(this.italicAngle)).append("\n        underlinePosition:     ").append(this.underlinePosition).append("\n        underlineThickness:    ").append(this.underlineThickness).append("\n        isFixedPitch:          ").append(this.isFixedPitch).append("\n        minMemType42:          ").append(this.minMemType42).append("\n        maxMemType42:          ").append(this.maxMemType42).append("\n        minMemType1:           ").append(this.minMemType1).append("\n        maxMemType1:           ").append(this.maxMemType1);
        if (this.version == 131072) {
            int n;
            stringBuilder.append("\n\n        Format 2.0:  Non-Standard (for PostScript) TrueType Glyph Set.\n");
            stringBuilder.append("        numGlyphs:      ").append(this.numGlyphs).append("\n");
            for (n = 0; n < this.numGlyphs; ++n) {
                stringBuilder.append("        Glyf ").append(n).append(" -> ");
                if (this.isMacGlyphName(n)) {
                    stringBuilder.append("Mac Glyph # ").append(this.glyphNameIndex[n]).append(", '").append(macGlyphName[this.glyphNameIndex[n]]).append("'\n");
                    continue;
                }
                stringBuilder.append("PSGlyf Name # ").append(this.glyphNameIndex[n] - 257).append(", name= '").append(this.psGlyphName[this.glyphNameIndex[n] - 258]).append("'\n");
            }
            stringBuilder.append("\n        Full List of PSGlyf Names\n        ------------------------\n");
            for (n = 0; n < this.psGlyphName.length; ++n) {
                stringBuilder.append("        PSGlyf Name # ").append(n + 1).append(": ").append(this.psGlyphName[n]).append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

