/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolModulationSet;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;
import org.jmol.viewer.Viewer;

public class XtalSymmetry {
    private static final float MAX_INTERCHAIN_BOND_2 = 25.0f;
    private static final float MINIMUM_FRACTIONAL_ATOM_DISTANCE = 1.0E-4f;
    private static final int PARTICLE_CHAIN = 1;
    private static final int PARTICLE_NONE = 0;
    private static final int PARTICLE_SYMOP = 2;
    private static final float SQUARED_CARTESIAN_DISTANCE_CHECK_NOOPS = 1.0E-4f;
    private static final float SQUARED_CARTESIAN_DISTANCE_CHECK_OPS = 0.01f;
    private AtomSetCollectionReader acr;
    private boolean applySymmetryToBonds;
    private AtomSetCollection asc;
    private FileSymmetry baseSymmetry;
    private int bondCount0;
    private SB bondsFound = new SB();
    private boolean centroidPacked;
    private boolean checkAll;
    private boolean checkNearAtoms;
    private boolean crystalReaderLatticeOpsOnly;
    private Map<Integer, Character> disorderMap;
    private int disorderMapMax;
    private boolean doCentroidUnitCell;
    private boolean doNormalize = true;
    private boolean doPackUnitCell;
    private String filterSymop;
    private int firstAtom;
    private int[] latticeCells;
    private int latticeOp;
    private M4 mident;
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3 minXYZ0;
    private P3 maxXYZ0;
    private M3 mTemp;
    private int ndims = 3;
    private int noSymmetryCount;
    private int nVib;
    private float packingRange;
    private final P3 ptOffset = new P3();
    private P3 ptTemp;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private FileSymmetry symmetry;
    private float symmetryRange;
    private Lst<float[]> trajectoryUnitCells;
    private float[] unitCellParams = null;
    private V3[] unitCellTranslations;

    public Tensor addRotatedTensor(Atom a, Tensor t, int iSym, boolean reset, FileSymmetry symmetry) {
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
            this.mTemp = new M3();
        }
        return a.addTensor(((Tensor)this.acr.getInterface("org.jmol.util.Tensor")).setFromEigenVectors(symmetry.rotateAxes(iSym, t.eigenVectors, this.ptTemp, this.mTemp), t.eigenValues, t.isIsotropic ? "iso" : t.type, t.id, t), null, reset);
    }

    /*
     * WARNING - void declaration
     */
    public void applySymmetryBio(Map<String, Object> thisBiomolecule, boolean applySymmetryToBonds, String filter) {
        void var19_32;
        int imt;
        void var19_30;
        String name;
        int fixBMChains;
        int[] lc;
        Lst biomts = (Lst)thisBiomolecule.get("biomts");
        int len = biomts.size();
        if (this.mident == null) {
            this.mident = new M4();
            this.mident.setIdentity();
        }
        this.acr.lstNCS = null;
        this.setLatticeCells();
        int[] nArray = lc = this.latticeCells != null && this.latticeCells[0] != 0 ? new int[3] : null;
        if (lc != null) {
            for (int i = 0; i < 3; ++i) {
                lc[i] = this.latticeCells[i];
            }
        }
        this.latticeCells = null;
        String bmChains = this.acr.getFilterWithCase("BMCHAINS");
        int n = bmChains == null ? -1 : (fixBMChains = bmChains.length() < 2 ? 0 : PT.parseInt(bmChains.substring(1)));
        if (fixBMChains == Integer.MIN_VALUE) {
            fixBMChains = -bmChains.charAt(1);
        }
        int particleMode = filter.indexOf("BYCHAIN") >= 0 ? 1 : (filter.indexOf("BYSYMOP") >= 0 ? 2 : 0);
        this.doNormalize = false;
        Lst biomtchains = (Lst)thisBiomolecule.get("chains");
        this.symmetry = new FileSymmetry();
        this.symmetry.setSpaceGroup(this.doNormalize);
        this.addSpaceGroupOperation("x,y,z", false);
        this.acr.sgName = name = (String)thisBiomolecule.get("name");
        this.setAtomSetSpaceGroupName(this.acr.sgName);
        this.applySymmetryToBonds = applySymmetryToBonds;
        this.bondCount0 = this.asc.bondCount;
        this.firstAtom = this.asc.getLastAtomSetAtomIndex();
        int atomMax = this.asc.ac;
        Hashtable<Integer, BS> ht = new Hashtable<Integer, BS>();
        int nChain = 0;
        Atom[] atoms = this.asc.atoms;
        boolean addBonds = this.bondCount0 > this.asc.bondIndex0 && applySymmetryToBonds;
        switch (particleMode) {
            case 1: {
                Object a;
                int i = atomMax;
                while (--i >= this.firstAtom) {
                    void var19_22;
                    Integer id = atoms[i].chainID;
                    BS bS = (BS)ht.get(id);
                    if (bS == null) {
                        ++nChain;
                        BS bS2 = new BS();
                        ht.put(id, bS2);
                    }
                    var19_22.set(i);
                }
                this.asc.bsAtoms = new BS();
                for (i = 0; i < nChain; ++i) {
                    this.asc.bsAtoms.set(atomMax + i);
                    a = new Atom();
                    ((T3)a).set(0.0f, 0.0f, 0.0f);
                    ((Atom)a).radius = 16.0f;
                    this.asc.addAtom((Atom)a);
                }
                int ichain = 0;
                for (Map.Entry entry : ht.entrySet()) {
                    Atom a2 = atoms[atomMax + ichain++];
                    BS bs = (BS)entry.getValue();
                    int i2 = bs.nextSetBit(0);
                    while (i2 >= 0) {
                        a2.add(atoms[i2]);
                        i2 = bs.nextSetBit(i2 + 1);
                    }
                    a2.scale(1.0f / (float)bs.cardinality());
                    a2.atomName = "Pt" + ichain;
                    a2.chainID = (Integer)entry.getKey();
                }
                this.firstAtom = atomMax;
                atomMax += nChain;
                addBonds = false;
                break;
            }
            case 2: {
                void var19_28;
                this.asc.bsAtoms = new BS();
                this.asc.bsAtoms.set(atomMax);
                atoms[atomMax] = new Atom();
                Object a = atoms[atomMax];
                ((T3)a).set(0.0f, 0.0f, 0.0f);
                int n2 = atomMax;
                while (--var19_28 >= this.firstAtom) {
                    ((T3)a).add(atoms[var19_28]);
                }
                ((T3)a).scale(1.0f / (float)(atomMax - this.firstAtom));
                ((Atom)a).atomName = "Pt";
                ((Atom)a).radius = 16.0f;
                this.asc.addAtom((Atom)a);
                this.firstAtom = atomMax++;
                addBonds = false;
            }
        }
        Map assemblyIdAtoms = (Map)thisBiomolecule.get("asemblyIdAtoms");
        if (filter.indexOf("#<") >= 0) {
            len = Math.min(len, PT.parseInt(filter.substring(filter.indexOf("#<") + 2)) - 1);
            filter = PT.rep(filter, "#<", "_<");
        }
        int maxChain = 0;
        int n3 = this.firstAtom;
        while (var19_30 < atomMax) {
            atoms[var19_30].bsSymmetry = new BS();
            int chainID = atoms[var19_30].chainID;
            if (chainID > maxChain) {
                maxChain = chainID;
            }
            ++var19_30;
        }
        BS bS = this.asc.bsAtoms;
        int[] atomMap = addBonds ? new int[this.asc.ac] : null;
        int n4 = imt = biomtchains == null ? 1 : 0;
        while (imt < len) {
            if (!(filter.indexOf("!#") < 0 ? filter.indexOf("#") >= 0 && filter.indexOf("#" + (imt + 1) + ";") < 0 : filter.indexOf("!#" + (imt + 1) + ";") >= 0)) {
                String chains;
                M4 mat = (M4)biomts.get(imt);
                boolean notIdentity = !mat.equals(this.mident);
                String string = chains = biomtchains == null ? null : (String)biomtchains.get(imt);
                if (chains != null && assemblyIdAtoms != null) {
                    BS bS3 = new BS();
                    for (Map.Entry e : assemblyIdAtoms.entrySet()) {
                        if (chains.indexOf(":" + (String)e.getKey() + ";") < 0) continue;
                        bS3.or((BS)e.getValue());
                    }
                    if (this.asc.bsAtoms != null) {
                        bS3.and(this.asc.bsAtoms);
                    }
                    chains = null;
                }
                int lastID = -1;
                boolean skipping = false;
                for (int iAtom = this.firstAtom; iAtom < atomMax; ++iAtom) {
                    int id;
                    if (var19_32 != null) {
                        skipping = !var19_32.get(iAtom);
                    } else if (chains != null && (id = atoms[iAtom].chainID) != lastID) {
                        lastID = id;
                        boolean bl = skipping = chains.indexOf(":" + this.acr.vwr.getChainIDStr(lastID) + ";") < 0;
                    }
                    if (skipping) continue;
                    try {
                        int atomSite = atoms[iAtom].atomSite;
                        if (addBonds) {
                            atomMap[atomSite] = this.asc.ac;
                        }
                        Atom atom1 = this.asc.newCloneAtom(atoms[iAtom]);
                        atom1.bondingRadius = imt;
                        this.asc.atomSymbolicMap.put("" + atom1.atomSerial, atom1);
                        if (this.asc.bsAtoms != null) {
                            this.asc.bsAtoms.set(atom1.index);
                        }
                        atom1.atomSite = atomSite;
                        if (notIdentity) {
                            mat.rotTrans(atom1);
                        }
                        atom1.bsSymmetry = BSUtil.newAndSetBit(imt);
                        continue;
                    }
                    catch (Exception e) {
                        this.asc.errorMessage = "appendAtomCollection error: " + e;
                    }
                }
                if (notIdentity) {
                    this.symmetry.addBioMoleculeOperation(mat, false);
                }
                if (addBonds) {
                    for (int bondNum = this.asc.bondIndex0; bondNum < this.bondCount0; ++bondNum) {
                        Bond bond = this.asc.bonds[bondNum];
                        int iAtom1 = atomMap[atoms[bond.atomIndex1].atomSite];
                        int iAtom2 = atomMap[atoms[bond.atomIndex2].atomSite];
                        this.asc.addNewBondWithOrder(iAtom1, iAtom2, bond.order);
                    }
                }
            }
            ++imt;
        }
        if (biomtchains != null) {
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
            }
            this.asc.bsAtoms.clearBits(this.firstAtom, atomMax);
            if (particleMode == 0) {
                if (fixBMChains != -1) {
                    boolean assignABC = fixBMChains != 0;
                    BS bsChains = assignABC ? new BS() : null;
                    atoms = this.asc.atoms;
                    int firstNew = 0;
                    if (assignABC) {
                        firstNew = fixBMChains < 0 ? Math.max(-fixBMChains, maxChain + 1) : Math.max(maxChain + fixBMChains, 65);
                        bsChains.setBits(0, firstNew - 1);
                        bsChains.setBits(91, 97);
                        bsChains.setBits(123, 200);
                    }
                    BS[] bsAll = this.asc.structureCount == 1 ? this.asc.structures[0].bsAll : null;
                    Hashtable<String, Integer> chainMap = new Hashtable<String, Integer>();
                    Hashtable<Integer, Integer> knownMap = new Hashtable<Integer, Integer>();
                    Hashtable<Integer, int[]> knownAtomMap = bsAll == null ? null : new Hashtable<Integer, int[]>();
                    int[] lastKnownAtom = null;
                    int n32 = this.asc.ac;
                    for (int i = atomMax; i < n32; ++i) {
                        int ic = atoms[i].chainID;
                        int isym = atoms[i].bsSymmetry.nextSetBit(0);
                        String ch0 = this.acr.vwr.getChainIDStr(ic);
                        String ch = isym == 0 ? ch0 : ch0 + isym;
                        Integer known = (Integer)chainMap.get(ch);
                        if (known == null) {
                            if (assignABC && isym != 0) {
                                int pt;
                                int n5 = pt = firstNew < 200 ? bsChains.nextClearBit(firstNew) : 200;
                                if (pt < 200) {
                                    bsChains.set(pt);
                                    known = this.acr.vwr.getChainID("" + (char)pt, true);
                                    firstNew = pt;
                                }
                            }
                            if (known == null) {
                                known = this.acr.vwr.getChainID(ch, true);
                            }
                            if (ch != ch0) {
                                knownMap.put(known, ic);
                                if (bsAll != null) {
                                    if (lastKnownAtom != null) {
                                        lastKnownAtom[1] = i;
                                    }
                                    lastKnownAtom = new int[]{i, n32};
                                    knownAtomMap.put(known, lastKnownAtom);
                                }
                            }
                            chainMap.put(ch, known);
                        }
                        atoms[i].chainID = known;
                    }
                    if (this.asc.structureCount > 0) {
                        Structure[] strucs = this.asc.structures;
                        int nStruc = this.asc.structureCount;
                        for (Map.Entry e : knownMap.entrySet()) {
                            Integer known = (Integer)e.getKey();
                            int ch1 = known;
                            int ch0 = (Integer)e.getValue();
                            for (int i = 0; i < nStruc; ++i) {
                                Structure s = strucs[i];
                                if (s.bsAll != null) continue;
                                if (s.startChainID == s.endChainID) {
                                    if (s.startChainID != ch0) continue;
                                    Structure s1 = s.clone();
                                    s1.startChainID = s1.endChainID = ch1;
                                    this.asc.addStructure(s1);
                                    continue;
                                }
                                System.err.println("XtalSymmetry not processing biomt chain structure " + this.acr.vwr.getChainIDStr(ch0) + " to " + this.acr.vwr.getChainIDStr(ch1));
                            }
                        }
                    }
                }
                Lst vConnect = (Lst)this.asc.getAtomSetAuxiliaryInfoValue(-1, "PDB_CONECT_bonds");
                if (!addBonds && vConnect != null) {
                    int i = vConnect.size();
                    while (--i >= 0) {
                        int[] bond = (int[])vConnect.get(i);
                        Atom a = this.asc.getAtomFromName("" + bond[0]);
                        Atom b = this.asc.getAtomFromName("" + bond[1]);
                        if (a == null || b == null || a.bondingRadius == b.bondingRadius || var19_32 != null && (!var19_32.get(a.index) || !var19_32.get(b.index)) || !(a.distanceSquared(b) > 25.0f)) continue;
                        vConnect.removeItemAt(i);
                        System.out.println("long interchain bond removed for @" + a.atomSerial + "-@" + b.atomSerial);
                    }
                }
            }
            int n5 = this.asc.ac;
            for (int i = atomMax; i < n5; ++i) {
                this.asc.atoms[i].bondingRadius = Float.NaN;
            }
        }
        this.noSymmetryCount = atomMax - this.firstAtom;
        this.finalizeSymmetry(this.symmetry);
        this.setCurrentModelInfo(len, null, null);
        this.reset();
    }

    public FileSymmetry getBaseSymmetry() {
        return this.baseSymmetry == null ? this.symmetry : this.baseSymmetry;
    }

    public T3 getOverallSpan() {
        return this.maxXYZ0 == null ? V3.new3(this.maxXYZ.x - this.minXYZ.x, this.maxXYZ.y - this.minXYZ.y, this.maxXYZ.z - this.minXYZ.z) : V3.newVsub(this.maxXYZ0, this.minXYZ0);
    }

    public FileSymmetry getSymmetry() {
        return this.symmetry == null ? (this.symmetry = new FileSymmetry()) : this.symmetry;
    }

    public boolean isWithinCell(int ndims, P3 pt, float minX, float maxX, float minY, float maxY, float minZ, float maxZ, float slop) {
        return pt.x > minX - slop && pt.x < maxX + slop && (ndims < 2 || pt.y > minY - slop && pt.y < maxY + slop) && (ndims < 3 || pt.z > minZ - slop && pt.z < maxZ + slop);
    }

    public void scaleFractionalVibs() {
        float[] params = this.acr.unitCellParams;
        P3 ptScale = P3.new3(1.0f / params[0], 1.0f / params[1], 1.0f / params[2]);
        int i0 = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        int i = this.asc.ac;
        while (--i >= i0) {
            V3 v = this.asc.atoms[i].vib;
            if (v == null) continue;
            v.scaleT(ptScale);
        }
    }

    public XtalSymmetry set(AtomSetCollectionReader reader) {
        this.acr = reader;
        this.asc = reader.asc;
        this.getSymmetry();
        return this;
    }

    public void setLatticeParameter(int latt) {
        this.symmetry.setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(latt);
    }

    public int setSpinVectors() {
        if (this.nVib > 0 || this.asc.iSet < 0 || !this.acr.vibsFractional) {
            return this.nVib;
        }
        int i0 = this.asc.getAtomSetAtomIndex(this.asc.iSet);
        FileSymmetry sym = this.getBaseSymmetry();
        int i = this.asc.ac;
        while (--i >= i0) {
            Vibration v = (Vibration)this.asc.atoms[i].vib;
            if (v == null) continue;
            if (v.modDim > 0) {
                ((JmolModulationSet)((Object)v)).setMoment();
            } else {
                v = (Vibration)v.clone();
                sym.toCartesian(v, true);
                this.asc.atoms[i].vib = v;
            }
            ++this.nVib;
        }
        return this.nVib;
    }

    int addSpaceGroupOperation(String xyz, boolean andSetLattice) {
        this.symmetry.setSpaceGroup(this.doNormalize);
        if (andSetLattice && this.symmetry.getSpaceGroupOperationCount() == 1) {
            this.setLatticeCells();
        }
        return this.symmetry.addSpaceGroupOperation(xyz, 0);
    }

    FileSymmetry applySymmetryFromReader(FileSymmetry readerSymmetry) throws Exception {
        this.asc.setCoordinatesAreFractional(this.acr.iHaveFractionalCoordinates);
        this.setAtomSetSpaceGroupName(this.acr.sgName);
        this.symmetryRange = this.acr.symmetryRange;
        this.asc.setInfo("symmetryRange", Float.valueOf(this.symmetryRange));
        if (this.acr.doConvertToFractional || this.acr.fileCoordinatesAreFractional) {
            this.setLatticeCells();
            boolean doApplySymmetry = true;
            if (this.acr.ignoreFileSpaceGroupName || !this.acr.iHaveSymmetryOperators) {
                if (this.acr.unitCellParams[0] == 0.0f && this.acr.unitCellParams[2] == 0.0f) {
                    SimpleUnitCell.fillParams(null, null, null, this.acr.unitCellParams);
                }
                if (!this.acr.merging || readerSymmetry == null) {
                    readerSymmetry = new FileSymmetry();
                }
                doApplySymmetry = readerSymmetry.createSpaceGroup(this.acr.desiredSpaceGroupIndex, this.acr.sgName.indexOf("!") >= 0 ? "P1" : this.acr.sgName, this.acr.unitCellParams, this.acr.modDim);
            } else {
                this.acr.doPreSymmetry();
                readerSymmetry = null;
            }
            this.packingRange = this.acr.getPackingRangeValue(0.0f);
            if (doApplySymmetry) {
                if (readerSymmetry != null) {
                    this.getSymmetry().setSpaceGroupTo(readerSymmetry.getSpaceGroup());
                }
                this.applySymmetryLattice();
                if (readerSymmetry != null && this.filterSymop == null) {
                    this.setAtomSetSpaceGroupName(readerSymmetry.getSpaceGroupName());
                }
            } else {
                this.setUnitCellSafely();
            }
        }
        if (this.acr.iHaveFractionalCoordinates && this.acr.merging && readerSymmetry != null) {
            Atom[] atoms = this.asc.atoms;
            int n = this.asc.ac;
            for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
                readerSymmetry.toCartesian(atoms[i], true);
            }
            this.asc.setCoordinatesAreFractional(false);
            this.acr.addVibrations = false;
        }
        return this.symmetry;
    }

    FileSymmetry setSymmetry(FileSymmetry symmetry) {
        this.symmetry = symmetry;
        return this.symmetry;
    }

    void setTensors() {
        int n = this.asc.ac;
        for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
            Atom a = this.asc.atoms[i];
            if (a.anisoBorU == null) continue;
            a.addTensor(this.symmetry.getTensor(this.acr.vwr, a.anisoBorU), null, false);
            if (Float.isNaN(a.bfactor)) {
                a.bfactor = a.anisoBorU[7] * 100.0f;
            }
            a.anisoBorU = null;
        }
    }

    private void adjustRangeMinMax(T3[] oabc) {
        P3 pa = new P3();
        P3 pb = new P3();
        P3 pc = new P3();
        if (this.acr.forcePacked) {
            pa.setT(oabc[1]);
            pb.setT(oabc[2]);
            pc.setT(oabc[3]);
            pa.scale(this.packingRange);
            pb.scale(this.packingRange);
            pc.scale(this.packingRange);
        }
        oabc[0].scaleAdd2(this.minXYZ.x, oabc[1], oabc[0]);
        oabc[0].scaleAdd2(this.minXYZ.y, oabc[2], oabc[0]);
        oabc[0].scaleAdd2(this.minXYZ.z, oabc[3], oabc[0]);
        oabc[0].sub(pa);
        oabc[0].sub(pb);
        oabc[0].sub(pc);
        P3 pt = P3.newP(oabc[0]);
        this.symmetry.toFractional(pt, true);
        this.setSymmetryMinMax(pt);
        oabc[1].scale(this.maxXYZ.x - this.minXYZ.x);
        oabc[2].scale(this.maxXYZ.y - this.minXYZ.y);
        oabc[3].scale(this.maxXYZ.z - this.minXYZ.z);
        oabc[1].scaleAdd2(2.0f, pa, oabc[1]);
        oabc[2].scaleAdd2(2.0f, pb, oabc[2]);
        oabc[3].scaleAdd2(2.0f, pc, oabc[3]);
        for (int i = 0; i < 3; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                pt.add2(oabc[i], oabc[j]);
                if (i != 0) {
                    pt.add(oabc[0]);
                }
                this.symmetry.toFractional(pt, false);
                this.setSymmetryMinMax(pt);
            }
        }
        this.symmetry.toCartesian(pt, false);
        pt.add(oabc[1]);
        this.symmetry.toFractional(pt, false);
        this.setSymmetryMinMax(pt);
        this.minXYZ = P3i.new3((int)Math.min(0.0, Math.floor(this.rminx + 0.001f)), (int)Math.min(0.0, Math.floor(this.rminy + 0.001f)), (int)Math.min(0.0, Math.floor(this.rminz + 0.001f)));
        this.maxXYZ = P3i.new3((int)Math.max(1.0, Math.ceil(this.rmaxx - 0.001f)), (int)Math.max(1.0, Math.ceil(this.rmaxy - 0.001f)), (int)Math.max(1.0, Math.ceil(this.rmaxz - 0.001f)));
    }

    private void applyAllSymmetry(MSInterface ms, BS bsAtoms) throws Exception {
        int tz;
        int tx;
        FileSymmetry sym;
        boolean checkRange111;
        if (this.asc.ac == 0 || bsAtoms != null && bsAtoms.isEmpty()) {
            return;
        }
        this.noSymmetryCount = this.asc.baseSymmetryAtomCount > 0 ? this.asc.baseSymmetryAtomCount : (bsAtoms == null ? this.asc.getLastAtomSetAtomCount() : this.asc.ac - bsAtoms.nextSetBit(this.asc.getLastAtomSetAtomIndex()));
        int n = this.noSymmetryCount;
        this.asc.setTensors();
        this.applySymmetryToBonds = this.acr.applySymmetryToBonds;
        this.doPackUnitCell = this.acr.doPackUnitCell && !this.applySymmetryToBonds;
        this.bondCount0 = this.asc.bondCount;
        this.ndims = SimpleUnitCell.getDimensionFromParams(this.acr.unitCellParams);
        this.finalizeSymmetry(this.symmetry);
        int operationCount = this.symmetry.getSpaceGroupOperationCount();
        BS excludedOps = this.acr.thisBiomolecule == null ? null : new BS();
        this.checkNearAtoms = this.acr.checkNearAtoms || excludedOps != null;
        SimpleUnitCell.setMinMaxLatticeParameters(this.ndims, this.minXYZ, this.maxXYZ, 0);
        this.latticeOp = this.symmetry.getLatticeOp();
        boolean bl = this.crystalReaderLatticeOpsOnly = this.asc.crystalReaderLatticeOpsOnly && this.latticeOp >= 0;
        if (this.doCentroidUnitCell) {
            this.asc.setInfo("centroidMinMax", new int[]{this.minXYZ.x, this.minXYZ.y, this.minXYZ.z, this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z, this.centroidPacked ? 1 : 0});
        }
        if (this.doCentroidUnitCell || this.acr.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            this.minXYZ0 = P3.new3(this.minXYZ.x, this.minXYZ.y, this.minXYZ.z);
            this.maxXYZ0 = P3.new3(this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z);
            if (ms != null) {
                ms.setMinMax0(this.minXYZ0, this.maxXYZ0);
                this.minXYZ.set((int)this.minXYZ0.x, (int)this.minXYZ0.y, (int)this.minXYZ0.z);
                this.maxXYZ.set((int)this.maxXYZ0.x, (int)this.maxXYZ0.y, (int)this.maxXYZ0.z);
            }
            switch (this.ndims) {
                case 3: {
                    --this.minXYZ.z;
                    ++this.maxXYZ.z;
                }
                case 2: {
                    --this.minXYZ.y;
                    ++this.maxXYZ.y;
                }
                case 1: {
                    --this.minXYZ.x;
                    ++this.maxXYZ.x;
                }
            }
        }
        int nCells = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        int nsym = n * (this.crystalReaderLatticeOpsOnly ? 4 : operationCount);
        int cartesianCount = this.checkNearAtoms || this.acr.thisBiomolecule != null ? nsym * nCells : (this.symmetryRange > 0.0f ? nsym : 1);
        P3[] cartesians = new P3[cartesianCount];
        P3[] atoms = this.asc.atoms;
        for (int i = 0; i < n; ++i) {
            atoms[this.firstAtom + i].bsSymmetry = BS.newN(operationCount * (nCells + 1));
        }
        int pt = 0;
        this.unitCellTranslations = new V3[nCells];
        int iCell = 0;
        int cell555Count = 0;
        float absRange = Math.abs(this.symmetryRange);
        boolean checkCartesianRange = this.symmetryRange != 0.0f;
        boolean checkRangeNoSymmetry = this.symmetryRange < 0.0f;
        boolean bl2 = checkRange111 = this.symmetryRange > 0.0f;
        if (checkCartesianRange) {
            this.rminz = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminx = Float.MAX_VALUE;
            this.rmaxz = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxx = -3.4028235E38f;
        }
        FileSymmetry lastSymmetry = sym = this.symmetry;
        this.checkAll = this.crystalReaderLatticeOpsOnly || this.asc.atomSetCount == 1 && this.checkNearAtoms && this.latticeOp >= 0;
        Lst<M4> lstNCS = this.acr.lstNCS;
        if (lstNCS != null && ((M4)lstNCS.get((int)0)).m33 == 0.0f) {
            int nn;
            int nOp = sym.getSpaceGroupOperationCount();
            int i = nn = lstNCS.size();
            while (--i >= 0) {
                M4 m = (M4)lstNCS.get(i);
                m.m33 = 1.0f;
                sym.toFractionalM(m);
            }
            for (i = 1; i < nOp; ++i) {
                M4 m1 = sym.getSpaceGroupOperation(i);
                for (int j = 0; j < nn; ++j) {
                    M4 m = M4.newM4((M4)lstNCS.get(j));
                    m.mul2(m1, m);
                    if (this.doNormalize && this.noSymmetryCount > 0) {
                        SymmetryOperation.normalizeOperationToCentroid(3, m, atoms, this.firstAtom, this.noSymmetryCount);
                    }
                    lstNCS.addLast(m);
                }
            }
        }
        P3 pttemp = null;
        M4 op = sym.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            pttemp = new P3();
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        int[] atomMap = this.bondCount0 > this.asc.bondIndex0 && this.applySymmetryToBonds ? new int[n] : null;
        int[] unitCells = new int[nCells];
        for (tx = this.minXYZ.x; tx < this.maxXYZ.x; ++tx) {
            for (int ty = this.minXYZ.y; ty < this.maxXYZ.y; ++ty) {
                for (tz = this.minXYZ.z; tz < this.maxXYZ.z; ++tz) {
                    this.unitCellTranslations[iCell] = V3.new3(tx, ty, tz);
                    unitCells[iCell++] = 555 + tx * 100 + ty * 10 + tz;
                    if (tx != 0 || ty != 0 || tz != 0 || cartesians.length == 0) continue;
                    for (pt = 0; pt < n; ++pt) {
                        P3 atom = atoms[this.firstAtom + pt];
                        if (ms != null && (sym = ms.getAtomSymmetry((Atom)atom, this.symmetry)) != lastSymmetry) {
                            if (sym.getSpaceGroupOperationCount() == 0) {
                                lastSymmetry = sym;
                                this.finalizeSymmetry(lastSymmetry);
                            }
                            op = sym.getSpaceGroupOperation(0);
                        }
                        P3 c = P3.newP(atom);
                        op.rotTrans(c);
                        sym.toCartesian(c, false);
                        if (this.doPackUnitCell) {
                            sym.toUnitCellRnd(c, this.ptOffset);
                            pttemp.setT(c);
                            sym.toFractional(pttemp, false);
                            this.acr.fixFloatPt(pttemp, 100000.0f);
                            if (bsAtoms == null) {
                                atom.setT(pttemp);
                            } else if (atom.distance(pttemp) < 1.0E-4f) {
                                bsAtoms.set(((Atom)atom).index);
                            } else {
                                bsAtoms.clear(((Atom)atom).index);
                                continue;
                            }
                        }
                        if (bsAtoms != null) {
                            ((Atom)atom).bsSymmetry.clearAll();
                        }
                        ((Atom)atom).bsSymmetry.set(iCell * operationCount);
                        ((Atom)atom).bsSymmetry.set(0);
                        if (checkCartesianRange) {
                            this.setSymmetryMinMax(c);
                        }
                        if (pt >= cartesianCount) continue;
                        cartesians[pt] = c;
                    }
                    if (checkRangeNoSymmetry) {
                        this.rminx -= absRange;
                        this.rminy -= absRange;
                        this.rminz -= absRange;
                        this.rmaxx += absRange;
                        this.rmaxy += absRange;
                        this.rmaxz += absRange;
                    }
                    cell555Count = pt = this.symmetryAddAtoms(0, 0, 0, 0, pt, iCell * operationCount, cartesians, ms, excludedOps, atomMap);
                }
            }
        }
        if (checkRange111) {
            this.rminx -= absRange;
            this.rminy -= absRange;
            this.rminz -= absRange;
            this.rmaxx += absRange;
            this.rmaxy += absRange;
            this.rmaxz += absRange;
        }
        iCell = 0;
        for (tx = this.minXYZ.x; tx < this.maxXYZ.x; ++tx) {
            for (int ty = this.minXYZ.y; ty < this.maxXYZ.y; ++ty) {
                for (tz = this.minXYZ.z; tz < this.maxXYZ.z; ++tz) {
                    ++iCell;
                    if (tx == 0 && ty == 0 && tz == 0) continue;
                    pt = this.symmetryAddAtoms(tx, ty, tz, cell555Count, pt, iCell * operationCount, cartesians, ms, excludedOps, atomMap);
                }
            }
        }
        if (iCell * n == this.asc.ac - this.firstAtom) {
            this.duplicateAtomProperties(iCell);
        }
        this.setCurrentModelInfo(n, sym, unitCells);
        this.unitCellParams = null;
        this.reset();
    }

    private void applyRangeSymmetry(BS bsAtoms) throws Exception {
        T3[] range = (T3[])this.acr.fillRange;
        bsAtoms = this.updateBSAtoms();
        this.acr.forcePacked = true;
        this.doPackUnitCell = false;
        P3i minXYZ2 = P3i.new3(this.minXYZ.x, this.minXYZ.y, this.minXYZ.z);
        P3i maxXYZ2 = P3i.new3(this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z);
        T3[] oabc = new P3[4];
        for (int i = 0; i < 4; ++i) {
            oabc[i] = P3.newP(range[i]);
        }
        this.setUnitCellSafely();
        this.adjustRangeMinMax(oabc);
        FileSymmetry superSymmetry = new FileSymmetry();
        superSymmetry.getUnitCell((T3[])this.acr.fillRange, false, null);
        this.applyAllSymmetry(this.acr.ms, bsAtoms);
        P3 pt0 = new P3();
        Atom[] atoms = this.asc.atoms;
        int i = this.asc.ac;
        while (--i >= this.firstAtom) {
            pt0.setT(atoms[i]);
            this.symmetry.toCartesian(pt0, false);
            superSymmetry.toFractional(pt0, false);
            if (!(this.acr.noPack ? !this.removePacking(this.ndims, pt0, minXYZ2.x, maxXYZ2.x, minXYZ2.y, maxXYZ2.y, minXYZ2.z, maxXYZ2.z, this.packingRange) : !this.isWithinCell(this.ndims, pt0, minXYZ2.x, maxXYZ2.x, minXYZ2.y, maxXYZ2.y, minXYZ2.z, maxXYZ2.z, this.packingRange))) continue;
            bsAtoms.clear(i);
        }
    }

    private void applySuperSymmetry(String supercell, BS bsAtoms, int iAtomFirst, T3[] oabc, P3 pt0, V3[] vabc, float slop) throws Exception {
        boolean doPack0;
        this.asc.setGlobalBoolean(7);
        this.doPackUnitCell = doPack0 = this.doPackUnitCell;
        this.applyAllSymmetry(this.acr.ms, null);
        this.doPackUnitCell = doPack0;
        Atom[] atoms = this.asc.atoms;
        int atomCount = this.asc.ac;
        for (int i = iAtomFirst; i < atomCount; ++i) {
            this.symmetry.toCartesian(atoms[i], true);
            bsAtoms.set(i);
        }
        this.asc.setCurrentModelInfo("unitcell_conventional", this.symmetry.getV0abc("a,b,c", null));
        V3 va = vabc[0];
        V3 vb = vabc[1];
        V3 vc = vabc[2];
        this.symmetry = new FileSymmetry();
        this.setUnitCell(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, va.x, va.y, va.z, vb.x, vb.y, vb.z, vc.x, vc.y, vc.z, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, slop}, null, null);
        String name = oabc == null || supercell == null ? "P1" : "cell=" + supercell;
        this.setAtomSetSpaceGroupName(name);
        this.symmetry.setSpaceGroupName(name);
        this.symmetry.setSpaceGroup(this.doNormalize);
        this.symmetry.addSpaceGroupOperation("x,y,z", 0);
        if (pt0 != null && pt0.length() == 0.0f) {
            pt0 = null;
        }
        if (pt0 != null) {
            this.symmetry.toFractional(pt0, true);
        }
        for (int i = iAtomFirst; i < atomCount; ++i) {
            this.symmetry.toFractional(atoms[i], true);
            if (pt0 == null) continue;
            atoms[i].sub(pt0);
        }
        this.asc.haveAnisou = false;
        this.asc.setCurrentModelInfo("matUnitCellOrientation", null);
    }

    private void applySymmetryLattice() throws Exception {
        if (!this.asc.coordinatesAreFractional || this.symmetry.getSpaceGroup() == null) {
            return;
        }
        int maxX = this.latticeCells[0];
        int maxY = this.latticeCells[1];
        int maxZ = Math.abs(this.latticeCells[2]);
        int kcode = this.latticeCells[3];
        this.firstAtom = this.asc.getLastAtomSetAtomIndex();
        BS bsAtoms = this.asc.bsAtoms;
        if (bsAtoms != null) {
            this.updateBSAtoms();
            this.firstAtom = bsAtoms.nextSetBit(this.firstAtom);
        }
        this.rminz = Float.MAX_VALUE;
        this.rminy = Float.MAX_VALUE;
        this.rminx = Float.MAX_VALUE;
        this.rmaxz = -3.4028235E38f;
        this.rmaxy = -3.4028235E38f;
        this.rmaxx = -3.4028235E38f;
        if (this.acr.latticeType == null) {
            this.acr.latticeType = "" + this.symmetry.getLatticeType();
        }
        if (this.acr.isPrimitive) {
            this.asc.setCurrentModelInfo("isprimitive", Boolean.TRUE);
            if (!"P".equals(this.acr.latticeType) || this.acr.primitiveToCrystal != null) {
                this.asc.setCurrentModelInfo("unitcell_conventional", this.symmetry.getConventionalUnitCell(this.acr.latticeType, this.acr.primitiveToCrystal));
            }
        }
        this.setUnitCellSafely();
        this.asc.setCurrentModelInfo("f2c", this.symmetry.getUnitCellF2C());
        String s = this.symmetry.getSpaceGroupTitle();
        if (s.indexOf("--") < 0) {
            this.asc.setCurrentModelInfo("f2cTitle", s);
        }
        this.asc.setCurrentModelInfo("f2cParams", this.symmetry.getUnitCellParams());
        if (this.acr.latticeType != null) {
            this.asc.setCurrentModelInfo("latticeType", this.acr.latticeType);
            if (this.acr.fillRange instanceof String) {
                T3[] range = this.setLatticeRange(this.acr.latticeType, (String)this.acr.fillRange);
                if (range == null) {
                    this.acr.appendLoadNote(this.acr.fillRange + " symmetry could not be implemented");
                    this.acr.fillRange = null;
                } else {
                    this.acr.fillRange = range;
                }
            }
        }
        this.baseSymmetry = this.symmetry;
        if (this.acr.fillRange != null) {
            this.setMinMax(this.ndims, kcode, maxX, maxY, maxZ);
            this.applyRangeSymmetry(bsAtoms);
            return;
        }
        T3[] oabc = null;
        float slop = 1.0E-6f;
        this.nVib = 0;
        String supercell = this.acr.strSupercell;
        boolean isSuper = supercell != null && supercell.indexOf(",") >= 0;
        M4 matSuper = null;
        P3 pt0 = null;
        V3[] vabc = new V3[3];
        if (isSuper) {
            matSuper = new M4();
            if (this.mident == null) {
                this.mident = new M4();
            }
            this.setUnitCellSafely();
            oabc = this.symmetry.getV0abc(supercell, matSuper);
            matSuper.transpose33();
            if (oabc != null && !matSuper.equals(this.mident)) {
                this.setMinMax(this.ndims, kcode, maxX, maxY, maxZ);
                pt0 = P3.newP(oabc[0]);
                vabc[0] = V3.newV(oabc[1]);
                vabc[1] = V3.newV(oabc[2]);
                vabc[2] = V3.newV(oabc[3]);
                this.adjustRangeMinMax(oabc);
            }
        }
        int iAtomFirst = this.asc.getLastAtomSetAtomIndex();
        if (bsAtoms != null) {
            iAtomFirst = bsAtoms.nextSetBit(iAtomFirst);
        }
        if (this.rminx == Float.MAX_VALUE) {
            supercell = null;
            oabc = null;
        } else {
            bsAtoms = this.updateBSAtoms();
            slop = this.symmetry.getPrecision();
            this.applySuperSymmetry(supercell, bsAtoms, iAtomFirst, oabc, pt0, vabc, slop);
        }
        this.setMinMax(this.ndims, kcode, maxX, maxY, maxZ);
        if (oabc == null) {
            this.applyAllSymmetry(this.acr.ms, bsAtoms);
            if (!(this.acr.noPack || this.applySymmetryToBonds && this.acr.doPackUnitCell)) {
                return;
            }
            this.setMinMax(this.ndims, kcode, maxX, maxY, maxZ);
        }
        if (this.acr.forcePacked || this.acr.doPackUnitCell || this.acr.noPack) {
            this.trimToUnitCell(iAtomFirst);
        }
        this.updateSupercellAtomSites(matSuper, bsAtoms, slop);
    }

    private void duplicateAtomProperties(int nTimes) {
        Map p = (Map)this.asc.getAtomSetAuxiliaryInfoValue(-1, "atomProperties");
        if (p != null) {
            for (Map.Entry entry : p.entrySet()) {
                int i;
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (val instanceof String) {
                    String data = (String)val;
                    SB s = new SB();
                    i = nTimes;
                    while (--i >= 0) {
                        s.append(data);
                    }
                    p.put(key, s.toString());
                    continue;
                }
                float[] f = (float[])val;
                float[] fnew = new float[f.length * nTimes];
                i = nTimes;
                while (--i >= 0) {
                    System.arraycopy(f, 0, fnew, i * f.length, f.length);
                }
            }
        }
    }

    private void finalizeSymmetry(FileSymmetry symmetry) {
        String name = (String)this.asc.getAtomSetAuxiliaryInfoValue(-1, "spaceGroup");
        symmetry.setFinalOperations(this.ndims, name, this.asc.atoms, this.firstAtom, this.noSymmetryCount, this.doNormalize, this.filterSymop);
        if (this.filterSymop != null || name == null || name.equals("unspecified!")) {
            this.setAtomSetSpaceGroupName(symmetry.getSpaceGroupName());
        }
        if (this.unitCellParams != null || Float.isNaN(this.acr.unitCellParams[0])) {
            return;
        }
        if (symmetry.fixUnitCell(this.acr.unitCellParams)) {
            this.acr.appendLoadNote("Unit cell parameters were adjusted to match space group!");
        }
        this.setUnitCellSafely();
    }

    public boolean removePacking(int ndims, P3 pt, float minX, float maxX, float minY, float maxY, float minZ, float maxZ, float slop) {
        return pt.x > minX - slop && pt.x < maxX - slop && (ndims < 2 || pt.y > minY - slop && pt.y < maxY - slop) && (ndims < 3 || pt.z > minZ - slop && pt.z < maxZ - slop);
    }

    private void reset() {
        this.asc.coordinatesAreFractional = false;
        this.asc.setCurrentModelInfo("hasSymmetry", Boolean.TRUE);
        this.asc.setGlobalBoolean(1);
    }

    private void setAtomSetSpaceGroupName(String spaceGroupName) {
        this.symmetry.setSpaceGroupName(spaceGroupName);
        this.asc.setCurrentModelInfo("spaceGroup", spaceGroupName + "");
    }

    private void setCurrentModelInfo(int n, FileSymmetry sym, int[] unitCells) {
        if (sym == null) {
            this.asc.setCurrentModelInfo("presymmetryAtomCount", this.noSymmetryCount);
            this.asc.setCurrentModelInfo("biosymmetryCount", n);
            this.asc.setCurrentModelInfo("biosymmetry", this.symmetry);
        } else {
            this.asc.setCurrentModelInfo("presymmetryAtomCount", n);
            this.asc.setCurrentModelInfo("latticeDesignation", sym.getLatticeDesignation());
            this.asc.setCurrentModelInfo("ML_unitCellRange", unitCells);
            if (this.acr.isSUPERCELL) {
                this.asc.setCurrentModelInfo("supercell", this.acr.strSupercell);
            }
        }
        this.asc.setCurrentModelInfo("presymmetryAtomIndex", this.firstAtom);
        int operationCount = this.symmetry.getSpaceGroupOperationCount();
        if (operationCount > 0) {
            String[] symmetryList = new String[operationCount];
            for (int i = 0; i < operationCount; ++i) {
                symmetryList[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.asc.setCurrentModelInfo("symmetryOperations", symmetryList);
            this.asc.setCurrentModelInfo("symmetryOps", this.symmetry.getSymmetryOperations());
        }
        this.asc.setCurrentModelInfo("symmetryCount", operationCount);
        this.asc.setCurrentModelInfo("latticeType", this.acr.latticeType == null ? "P" : this.acr.latticeType);
        this.asc.setCurrentModelInfo("intlTableNo", this.symmetry.getIntTableNumber());
        this.asc.setCurrentModelInfo("intlTableIndex", this.symmetry.getSpaceGroupInfoObj("itaIndex", null, false, false));
        this.asc.setCurrentModelInfo("intlTableTransform", this.symmetry.getSpaceGroupInfoObj("itaTransform", null, false, false));
        this.asc.setCurrentModelInfo("intlTableJmolID", this.symmetry.getIntTableNumberFull());
        this.asc.setCurrentModelInfo("spaceGroupIndex", this.symmetry.getSpaceGroupIndex());
        this.asc.setCurrentModelInfo("spaceGroupTitle", this.symmetry.getSpaceGroupTitle());
        if (this.acr.sgName == null || this.acr.sgName.indexOf("?") >= 0 || this.acr.sgName.indexOf("!") >= 0) {
            this.acr.sgName = this.symmetry.getSpaceGroupName();
            this.setAtomSetSpaceGroupName(this.acr.sgName);
        }
    }

    private void setCurrentModelUCInfo(float[] unitCellParams, P3 unitCellOffset, M3 matUnitCellOrientation) {
        if (unitCellParams != null) {
            this.asc.setCurrentModelInfo("unitCellParams", unitCellParams);
        }
        if (unitCellOffset != null) {
            this.asc.setCurrentModelInfo("unitCellOffset", unitCellOffset);
        }
        if (matUnitCellOrientation != null) {
            this.asc.setCurrentModelInfo("matUnitCellOrientation", matUnitCellOrientation);
        }
    }

    private void setLatticeCells() {
        this.latticeCells = this.acr.latticeCells;
        boolean isLatticeRange = this.latticeCells[0] <= 555 && this.latticeCells[1] >= 555 && (this.latticeCells[2] == 0 || this.latticeCells[2] == 1 || this.latticeCells[2] == -1);
        this.doNormalize = this.latticeCells[0] != 0 && (!isLatticeRange || this.latticeCells[2] == 1);
        this.applySymmetryToBonds = this.acr.applySymmetryToBonds;
        this.doPackUnitCell = this.acr.doPackUnitCell && !this.applySymmetryToBonds;
        this.doCentroidUnitCell = this.acr.doCentroidUnitCell;
        this.centroidPacked = this.acr.centroidPacked;
        this.filterSymop = this.acr.filterSymop;
    }

    private T3[] setLatticeRange(String latticetype, String rangeType) {
        T3[] range = null;
        boolean isRhombohedral = "R".equals(latticetype);
        if (rangeType.equals("conventional")) {
            range = this.symmetry.getConventionalUnitCell(latticetype, this.acr.primitiveToCrystal);
        } else if (rangeType.equals("primitive")) {
            range = this.symmetry.getUnitCellVectors();
            this.symmetry.toFromPrimitive(true, latticetype.charAt(0), range, this.acr.primitiveToCrystal);
        } else {
            rangeType = isRhombohedral && rangeType.equals("rhombohedral") ? (this.symmetry.getUnitCellInfoType(7) == 1.0f ? "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c" : null) : (isRhombohedral && rangeType.equals("trigonal") ? (this.symmetry.getUnitCellInfoType(8) == 1.0f ? "a-b,b-c,a+b+c" : null) : (rangeType.indexOf(",") < 0 || rangeType.indexOf("a") < 0 || rangeType.indexOf("b") < 0 || rangeType.indexOf("c") < 0 ? null : null));
        }
        if (rangeType != null && range == null && (range = this.symmetry.getV0abc(rangeType, null)) == null) {
            rangeType = null;
        }
        if (rangeType == null) {
            return null;
        }
        this.acr.addJmolScript("unitcell " + PT.esc(rangeType));
        return range;
    }

    private void setMinMax(int dim, int kcode, int maxX, int maxY, int maxZ) {
        this.minXYZ = new P3i();
        this.maxXYZ = P3i.new3(maxX, maxY, maxZ);
        SimpleUnitCell.setMinMaxLatticeParameters(dim, this.minXYZ, this.maxXYZ, kcode);
    }

    private void setSymmetryMinMax(P3 c) {
        if (this.rminx > c.x) {
            this.rminx = c.x;
        }
        if (this.rminy > c.y) {
            this.rminy = c.y;
        }
        if (this.rminz > c.z) {
            this.rminz = c.z;
        }
        if (this.rmaxx < c.x) {
            this.rmaxx = c.x;
        }
        if (this.rmaxy < c.y) {
            this.rmaxy = c.y;
        }
        if (this.rmaxz < c.z) {
            this.rmaxz = c.z;
        }
    }

    private void setUnitCell(float[] info, M3 matUnitCellOrientation, P3 unitCellOffset) {
        this.unitCellParams = new float[info.length];
        for (int i = 0; i < info.length; ++i) {
            this.unitCellParams[i] = info[i];
        }
        this.asc.haveUnitCell = true;
        if (this.asc.isTrajectory) {
            if (this.trajectoryUnitCells == null) {
                this.trajectoryUnitCells = new Lst();
                this.asc.setInfo("unitCells", this.trajectoryUnitCells);
            }
            this.trajectoryUnitCells.addLast(this.unitCellParams);
        }
        this.asc.setGlobalBoolean(2);
        this.getSymmetry().setUnitCellFromParams(this.unitCellParams, false, this.unitCellParams[26]);
        if (unitCellOffset != null) {
            this.symmetry.setOffsetPt(unitCellOffset);
        }
        if (matUnitCellOrientation != null) {
            this.symmetry.initializeOrientation(matUnitCellOrientation);
        }
        this.setCurrentModelUCInfo(this.unitCellParams, unitCellOffset, matUnitCellOrientation);
    }

    private void setUnitCellSafely() {
        if (this.unitCellParams == null) {
            this.setUnitCell(this.acr.unitCellParams, this.acr.matUnitCellOrientation, this.acr.unitCellOffset);
        }
    }

    private int symmetryAddAtoms(int transX, int transY, int transZ, int baseCount, int pt, int iCellOpPt, P3[] cartesians, MSInterface ms, BS excludedOps, int[] atomMap) throws Exception {
        boolean addBonds;
        boolean isBaseCell = baseCount == 0;
        boolean bl = addBonds = atomMap != null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(transX, transY, transZ);
        }
        float range2 = this.symmetryRange * this.symmetryRange;
        boolean checkRangeNoSymmetry = this.symmetryRange < 0.0f;
        boolean checkRange111 = this.symmetryRange > 0.0f;
        boolean checkSymmetryMinMax = isBaseCell && checkRange111;
        checkRange111 &= !isBaseCell;
        int nOp = this.symmetry.getSpaceGroupOperationCount();
        Lst<M4> lstNCS = this.acr.lstNCS;
        int nNCS = lstNCS == null ? 0 : lstNCS.size();
        int nOperations = nOp + nNCS;
        nNCS /= nOp;
        boolean checkNearAtoms = this.checkNearAtoms && (nOperations > 1 || this.doPackUnitCell);
        boolean checkSymmetryRange = checkRangeNoSymmetry || checkRange111;
        boolean checkDistances = checkNearAtoms || checkSymmetryRange;
        boolean checkOps = excludedOps != null;
        boolean addCartesian = checkNearAtoms || checkSymmetryMinMax;
        BS bsAtoms = this.acr.isMolecular ? null : this.asc.bsAtoms;
        FileSymmetry sym = this.symmetry;
        if (checkRangeNoSymmetry) {
            baseCount = this.noSymmetryCount;
        }
        int atomMax = this.firstAtom + this.noSymmetryCount;
        int bondAtomMin = this.asc.firstAtomToBond < 0 ? atomMax : this.asc.firstAtomToBond;
        P3 pttemp = new P3();
        String code = null;
        float minCartDist2 = checkOps ? 0.01f : 1.0E-4f;
        char subSystemId = '\u0000';
        int j00 = bsAtoms == null ? this.firstAtom : bsAtoms.nextSetBit(this.firstAtom);
        block0: for (int iSym = 0; iSym < nOperations; ++iSym) {
            if (isBaseCell && iSym == 0 || this.crystalReaderLatticeOpsOnly && iSym > 0 && iSym % this.latticeOp != 0 || excludedOps != null && excludedOps.get(iSym)) continue;
            int pt0 = this.firstAtom + (checkNearAtoms ? pt : (checkRange111 ? baseCount : 0));
            int spinOp = iSym >= nOp ? 0 : (this.asc.vibScale == 0 ? sym.getSpinOp(iSym) : this.asc.vibScale);
            int i0 = Math.max(this.firstAtom, bsAtoms == null ? 0 : bsAtoms.nextSetBit(0));
            boolean checkDistance = checkDistances;
            int spt = iSym >= nOp ? (iSym - nOp) / nNCS : iSym;
            int cpt = spt + iCellOpPt;
            for (int i = i0; i < atomMax; ++i) {
                Lst<Object> tensors;
                Atom a = this.asc.atoms[i];
                if (bsAtoms != null && !bsAtoms.get(i)) continue;
                if (ms == null) {
                    sym.newSpaceGroupPoint(a, iSym, iSym >= nOp ? (M4)lstNCS.get(iSym - nOp) : null, transX, transY, transZ, pttemp);
                } else {
                    sym = ms.getAtomSymmetry(a, this.symmetry);
                    sym.newSpaceGroupPoint(a, iSym, null, transX, transY, transZ, pttemp);
                    code = sym.getSpaceGroupOperationCode(iSym);
                    if (code != null) {
                        subSystemId = code.charAt(0);
                        sym = ms.getSymmetryFromCode(code);
                        if (sym.getSpaceGroupOperationCount() == 0) {
                            this.finalizeSymmetry(sym);
                        }
                    }
                }
                this.acr.fixFloatPt(pttemp, 100000.0f);
                P3 c = P3.newP(pttemp);
                sym.toCartesian(c, false);
                if (this.doPackUnitCell) {
                    sym.toUnitCellRnd(c, this.ptOffset);
                    pttemp.setT(c);
                    sym.toFractional(pttemp, false);
                    this.acr.fixFloatPt(pttemp, 100000.0f);
                    if (!this.isWithinCell(this.ndims, pttemp, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z, this.packingRange)) continue;
                }
                if (checkSymmetryMinMax) {
                    this.setSymmetryMinMax(c);
                }
                Atom special = null;
                if (checkDistance) {
                    if (checkSymmetryRange && (c.x < this.rminx || c.y < this.rminy || c.z < this.rminz || c.x > this.rmaxx || c.y > this.rmaxy || c.z > this.rmaxz)) continue;
                    float minDist2 = Float.MAX_VALUE;
                    int j0 = this.checkAll ? this.asc.ac : pt0;
                    String name = a.atomName;
                    char id = code == null ? a.altLoc : subSystemId;
                    for (int j = j00; j < j0; ++j) {
                        P3 pc;
                        if (bsAtoms != null && !bsAtoms.get(j) || (pc = cartesians[j - this.firstAtom]) == null) continue;
                        float d2 = c.distanceSquared(pc);
                        if (checkNearAtoms && d2 < minCartDist2) {
                            if (checkOps) {
                                excludedOps.set(iSym);
                                continue block0;
                            }
                            special = this.asc.atoms[j];
                            if ((special.atomName == null || special.atomName.equals(name)) && special.altLoc == id) break;
                            special = null;
                        }
                        if (!checkRange111 || j >= baseCount || !(d2 < minDist2)) continue;
                        minDist2 = d2;
                    }
                    if (checkRange111 && minDist2 > range2) continue;
                }
                if (checkOps) {
                    checkDistance = false;
                }
                int atomSite = a.atomSite;
                if (special != null) {
                    if (addBonds) {
                        atomMap[atomSite] = special.index;
                    }
                    special.bsSymmetry.set(cpt);
                    special.bsSymmetry.set(spt);
                    continue;
                }
                if (addBonds) {
                    atomMap[atomSite] = this.asc.ac;
                }
                Atom atom1 = a.copyTo(pttemp, this.asc);
                if (this.asc.bsAtoms != null) {
                    this.asc.bsAtoms.set(atom1.index);
                }
                if (spinOp != 0 && atom1.vib != null) {
                    sym.getSpaceGroupOperation(iSym).rotate(atom1.vib);
                    atom1.vib.scale(spinOp);
                }
                if (atom1.isNegDisorder) {
                    Integer key;
                    Character ch;
                    if (this.disorderMap == null) {
                        this.disorderMap = new Hashtable<Integer, Character>();
                    }
                    if ((ch = this.disorderMap.get(key = Integer.valueOf(iSym * 1000 + atom1.altLoc))) == null) {
                        if (this.disorderMapMax == 0 || this.disorderMapMax == 90) {
                            this.disorderMapMax = 64;
                        }
                        ch = new Character((char)(++this.disorderMapMax));
                        this.disorderMap.put(key, ch);
                    }
                    atom1.altLoc = ch.charValue();
                }
                atom1.atomSite = atomSite;
                if (code != null) {
                    atom1.altLoc = subSystemId;
                }
                atom1.bsSymmetry = BSUtil.newAndSetBit(cpt);
                atom1.bsSymmetry.set(spt);
                if (addCartesian) {
                    cartesians[pt++] = c;
                }
                if ((tensors = a.tensors) == null) continue;
                atom1.tensors = null;
                int j = tensors.size();
                while (--j >= 0) {
                    Tensor t = (Tensor)tensors.get(j);
                    if (t == null) continue;
                    if (nOp == 1) {
                        atom1.addTensor(t.copyTensor(), null, false);
                        continue;
                    }
                    this.addRotatedTensor(atom1, t, iSym, false, sym);
                }
            }
            if (!addBonds) continue;
            Bond[] bonds = this.asc.bonds;
            Atom[] atoms = this.asc.atoms;
            for (int bondNum = this.asc.bondIndex0; bondNum < this.bondCount0; ++bondNum) {
                String key;
                Bond bond = bonds[bondNum];
                Atom atom1 = atoms[bond.atomIndex1];
                Atom atom2 = atoms[bond.atomIndex2];
                if (atom1 == null || atom2 == null || atom2.atomSetIndex < atom1.atomSetIndex) continue;
                int ia1 = atomMap[atom1.atomSite];
                int ia2 = atomMap[atom2.atomSite];
                if (ia1 > ia2) {
                    int i = ia1;
                    ia1 = ia2;
                    ia2 = i;
                }
                if (ia1 == ia2 || ia1 < bondAtomMin && ia2 < bondAtomMin || this.bondsFound.indexOf(key = "-" + ia1 + "," + ia2) >= 0) continue;
                this.bondsFound.append(key);
                this.asc.addNewBondWithOrder(ia1, ia2, bond.order);
            }
        }
        return pt;
    }

    private void trimToUnitCell(int iAtomFirst) {
        Atom[] atoms = this.asc.atoms;
        BS bs = this.updateBSAtoms();
        if (this.acr.noPack) {
            int i = bs.nextSetBit(iAtomFirst);
            while (i >= 0) {
                if (!this.removePacking(this.ndims, atoms[i], this.minXYZ.x, this.maxXYZ.x, this.minXYZ.y, this.maxXYZ.y, this.minXYZ.z, this.maxXYZ.z, this.packingRange)) {
                    bs.clear(i);
                }
                i = bs.nextSetBit(i + 1);
            }
        } else {
            int i = bs.nextSetBit(iAtomFirst);
            while (i >= 0) {
                if (!this.isWithinCell(this.ndims, atoms[i], this.minXYZ.x, this.maxXYZ.x, this.minXYZ.y, this.maxXYZ.y, this.minXYZ.z, this.maxXYZ.z, this.packingRange)) {
                    bs.clear(i);
                }
                i = bs.nextSetBit(i + 1);
            }
        }
    }

    private BS updateBSAtoms() {
        BS bs = this.asc.bsAtoms;
        if (bs == null) {
            bs = this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
        }
        if (bs.nextSetBit(this.firstAtom) < 0) {
            bs.setBits(this.firstAtom, this.asc.ac);
        }
        return bs;
    }

    private void updateSupercellAtomSites(M4 matSuper, BS bsAtoms, float slop) {
        int n = bsAtoms.cardinality();
        Atom[] baseAtoms = new Atom[n];
        int nbase = 0;
        float slop2 = slop * slop;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Atom a = this.asc.atoms[i];
            Atom p = new Atom();
            p.setT(a);
            if (matSuper != null) {
                matSuper.rotTrans(p);
                SimpleUnitCell.unitizeDimRnd(3, p, slop);
            }
            p.atomSerial = a.atomSite;
            p.atomSite = a.atomSite;
            this.symmetry.unitize(p);
            boolean found = false;
            for (int ib = 0; ib < nbase; ++ib) {
                Atom b = baseAtoms[ib];
                if (p.atomSerial != b.atomSerial || !(p.distanceSquared(b) < slop2)) continue;
                found = true;
                a.atomSite = b.atomSite;
                break;
            }
            if (!found) {
                a.atomSite = p.atomSite = nbase;
                baseAtoms[nbase++] = p;
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
    }

    public FileSymmetry newFileSymmetry() {
        return new FileSymmetry();
    }

    public static class FileSymmetry
    extends Symmetry {
        public boolean addLatticeVectors(Lst<float[]> lattvecs) {
            return this.spaceGroup.addLatticeVectors(lattvecs);
        }

        public String addSubSystemOp(String code, Matrix rs, Matrix vs, Matrix sigma) {
            this.spaceGroup.isSSG = true;
            String s = SymmetryOperation.getXYZFromRsVs(rs, vs, false);
            int i = this.spaceGroup.addSymmetry(s, -1, true);
            this.spaceGroup.operations[i].setSigma(code, sigma);
            return s;
        }

        public boolean checkDistance(P3 f1, P3 f2, float distance, float dx, int iRange, int jRange, int kRange, P3 ptOffset) {
            return this.unitCell.checkDistance(f1, f2, distance, dx, iRange, jRange, kRange, ptOffset);
        }

        public boolean createSpaceGroup(int desiredSpaceGroupIndex, String name, Object data, int modDim) {
            this.spaceGroup = SpaceGroup.createSpaceGroup(desiredSpaceGroupIndex, name, data, modDim);
            if (this.spaceGroup != null && Logger.debugging) {
                Logger.debug("using generated space group " + this.spaceGroup.dumpInfo());
            }
            return this.spaceGroup != null;
        }

        public String fcoord(T3 p) {
            return SymmetryOperation.fcoord(p, " ");
        }

        public void getMatrixFromString(String xyz, float[] rotTransMatrix) {
            SymmetryOperation.getMatrixFromString(null, xyz, rotTransMatrix, false, true, false);
        }

        public String getSpaceGroupOperationCode(int iOp) {
            return this.spaceGroup.operations[iOp].subsystemCode;
        }

        public Tensor getTensor(Viewer vwr, float[] parBorU) {
            if (parBorU == null) {
                return null;
            }
            if (this.unitCell == null) {
                this.unitCell = UnitCell.fromParams(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f}, true, 1.0E-4f);
            }
            return this.unitCell.getTensor(vwr, parBorU);
        }

        public String getSpaceGroupTitle() {
            String s = this.getSpaceGroupName();
            return s.startsWith("cell=") ? s : (this.spaceGroup != null ? this.spaceGroup.asString() : (this.unitCell != null && this.unitCell.name.length() > 0 ? "cell=" + this.unitCell.name : ""));
        }

        public void setPrecision(float prec) {
            this.unitCell.setPrecision(prec);
        }

        public void toFractionalM(M4 m) {
            if (!this.isBio) {
                this.unitCell.toFractionalM(m);
            }
        }

        public void toUnitCellRnd(T3 pt, T3 offset) {
            this.unitCell.toUnitCellRnd(pt, offset);
        }

        public void twelfthify(P3 pt) {
            this.unitCell.twelfthify(pt);
        }

        T3[] getConventionalUnitCell(String latticeType, M3 primitiveToCrystal) {
            return this.unitCell == null || latticeType == null ? null : this.unitCell.getConventionalUnitCell(latticeType, primitiveToCrystal);
        }

        int getSpaceGroupIndex() {
            return this.spaceGroup.getIndex();
        }

        float[][] getUnitCellF2C() {
            return this.unitCell.getF2C();
        }

        public void addInversion() {
            SymmetryOperation[] ops = this.spaceGroup.operations;
            M4 inv = new M4();
            inv.m22 = -1.0f;
            inv.m11 = -1.0f;
            inv.m00 = -1.0f;
            inv.m33 = 1.0f;
            int n = this.getSpaceGroupOperationCount();
            M4 m = new M4();
            for (int i = 0; i < n; ++i) {
                m.mul2(inv, ops[i]);
                String s = SymmetryOperation.getXYZFromMatrix(m, true, true, false);
                this.addSpaceGroupOperation(s, 0);
            }
        }
    }
}

