/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery.azure.classic;

import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.DeploymentStatus;
import com.microsoft.windowsazure.management.compute.models.HostedServiceGetDetailedResponse;
import com.microsoft.windowsazure.management.compute.models.InstanceEndpoint;
import com.microsoft.windowsazure.management.compute.models.RoleInstance;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cloud.azure.classic.AzureServiceDisableException;
import org.opensearch.cloud.azure.classic.AzureServiceRemoteException;
import org.opensearch.cloud.azure.classic.management.AzureComputeService;
import org.opensearch.common.network.InetAddresses;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.discovery.SeedHostsProvider;
import org.opensearch.transport.TransportService;

public class AzureSeedHostsProvider
implements SeedHostsProvider {
    private static final Logger logger = LogManager.getLogger(AzureSeedHostsProvider.class);
    private final Settings settings;
    private final AzureComputeService azureComputeService;
    private TransportService transportService;
    private NetworkService networkService;
    private final TimeValue refreshInterval;
    private long lastRefresh;
    private List<TransportAddress> dynamicHosts;
    private final HostType hostType;
    private final String publicEndpointName;
    private final String deploymentName;
    private final DeploymentSlot deploymentSlot;

    public AzureSeedHostsProvider(Settings settings, AzureComputeService azureComputeService, TransportService transportService, NetworkService networkService) {
        this.settings = settings;
        this.azureComputeService = azureComputeService;
        this.transportService = transportService;
        this.networkService = networkService;
        this.refreshInterval = (TimeValue)AzureComputeService.Discovery.REFRESH_SETTING.get(settings);
        this.hostType = (HostType)((Object)AzureComputeService.Discovery.HOST_TYPE_SETTING.get(settings));
        this.publicEndpointName = (String)AzureComputeService.Discovery.ENDPOINT_NAME_SETTING.get(settings);
        this.deploymentName = (String)AzureComputeService.Discovery.DEPLOYMENT_NAME_SETTING.get(settings);
        this.deploymentSlot = ((Deployment)((Object)AzureComputeService.Discovery.DEPLOYMENT_SLOT_SETTING.get((Settings)settings))).slot;
    }

    public List<TransportAddress> getSeedAddresses(SeedHostsProvider.HostsResolver hostsResolver) {
        HostedServiceGetDetailedResponse detailed;
        if (this.refreshInterval.millis() != 0L) {
            if (this.dynamicHosts != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                logger.trace("using cache to retrieve node list");
                return this.dynamicHosts;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        logger.debug("start building nodes list using Azure API");
        this.dynamicHosts = new ArrayList<TransportAddress>();
        try {
            detailed = this.azureComputeService.getServiceDetails();
        }
        catch (AzureServiceDisableException e) {
            logger.debug("Azure discovery service has been disabled. Returning empty list of nodes.");
            return this.dynamicHosts;
        }
        catch (AzureServiceRemoteException e) {
            logger.warn("can not get list of azure nodes: [{}]. Returning empty list of nodes.", (Object)e.getMessage());
            logger.trace("AzureServiceRemoteException caught", (Throwable)e);
            return this.dynamicHosts;
        }
        InetAddress ipAddress = null;
        try {
            ipAddress = this.networkService.resolvePublishHostAddresses(((List)NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(this.settings)).toArray(Strings.EMPTY_ARRAY));
            logger.trace("ip of current node: [{}]", (Object)ipAddress);
        }
        catch (IOException e) {
            logger.trace("exception while finding ip", (Throwable)e);
        }
        for (HostedServiceGetDetailedResponse.Deployment deployment : detailed.getDeployments()) {
            if (deployment.getDeploymentSlot() != this.deploymentSlot) {
                logger.debug("current deployment slot [{}] for [{}] is different from [{}]. skipping...", (Object)deployment.getDeploymentSlot(), (Object)deployment.getName(), (Object)this.deploymentSlot);
                continue;
            }
            if (Strings.hasLength((String)this.deploymentName) && !this.deploymentName.equals(deployment.getName())) {
                logger.debug("current deployment name [{}] different from [{}]. skipping...", (Object)deployment.getName(), (Object)this.deploymentName);
                continue;
            }
            if (deployment.getStatus() != DeploymentStatus.Starting && deployment.getStatus() != DeploymentStatus.Deploying && deployment.getStatus() != DeploymentStatus.Running) {
                logger.debug("[{}] status is [{}]. skipping...", (Object)deployment.getName(), (Object)deployment.getStatus());
                continue;
            }
            for (RoleInstance instance : deployment.getRoleInstances()) {
                String networkAddress = this.resolveInstanceAddress(this.hostType, instance);
                if (networkAddress == null) {
                    logger.warn("no network address found. ignoring [{}]...", (Object)instance.getInstanceName());
                    continue;
                }
                try {
                    TransportAddress[] addresses;
                    for (TransportAddress address : addresses = this.transportService.addressesFromString(networkAddress)) {
                        logger.trace("adding {}, transport_address {}", (Object)networkAddress, (Object)address);
                        this.dynamicHosts.add(address);
                    }
                }
                catch (Exception e) {
                    logger.warn("can not convert [{}] to transport address. skipping. [{}]", (Object)networkAddress, (Object)e.getMessage());
                }
            }
        }
        logger.debug("{} addresses added", (Object)this.dynamicHosts.size());
        return this.dynamicHosts;
    }

    protected String resolveInstanceAddress(HostType hostType, RoleInstance instance) {
        if (hostType == HostType.PRIVATE_IP) {
            InetAddress privateIp = instance.getIPAddress();
            if (privateIp != null) {
                return InetAddresses.toUriString((InetAddress)privateIp);
            }
            logger.trace("no private ip provided. ignoring [{}]...", (Object)instance.getInstanceName());
        } else if (hostType == HostType.PUBLIC_IP) {
            for (InstanceEndpoint endpoint : instance.getInstanceEndpoints()) {
                if (this.publicEndpointName.equals(endpoint.getName())) {
                    return NetworkAddress.format((InetSocketAddress)new InetSocketAddress(endpoint.getVirtualIPAddress(), endpoint.getPort()));
                }
                logger.trace("ignoring endpoint [{}] as different than [{}]", (Object)endpoint.getName(), (Object)this.publicEndpointName);
            }
        }
        return null;
    }

    public static enum Deployment {
        PRODUCTION("production", DeploymentSlot.Production),
        STAGING("staging", DeploymentSlot.Staging);

        private String deployment;
        private DeploymentSlot slot;

        private Deployment(String deployment, DeploymentSlot slot) {
            this.deployment = deployment;
            this.slot = slot;
        }

        public static Deployment fromString(String string) {
            for (Deployment deployment : Deployment.values()) {
                if (!deployment.deployment.equalsIgnoreCase(string)) continue;
                return deployment;
            }
            throw new IllegalArgumentException("invalid value for deployment type [" + string + "]");
        }
    }

    public static enum HostType {
        PRIVATE_IP("private_ip"),
        PUBLIC_IP("public_ip");

        private String type;

        private HostType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static HostType fromString(String type) {
            for (HostType hostType : HostType.values()) {
                if (!hostType.type.equalsIgnoreCase(type)) continue;
                return hostType;
            }
            throw new IllegalArgumentException("invalid value for host type [" + type + "]");
        }
    }
}

