/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.chunker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.neuralsearch.processor.chunker.Chunker;
import org.opensearch.neuralsearch.processor.chunker.ChunkerParameterParser;
import org.opensearch.neuralsearch.processor.chunker.ChunkerUtil;

public final class DelimiterChunker
implements Chunker {
    public static final String ALGORITHM_NAME = "delimiter";
    public static final String DELIMITER_FIELD = "delimiter";
    public static final String DEFAULT_DELIMITER = "\n\n";
    private String delimiter;
    private int maxChunkLimit;

    public DelimiterChunker(Map<String, Object> parameters) {
        this.parseParameters(parameters);
    }

    @Override
    public void parseParameters(Map<String, Object> parameters) {
        this.delimiter = ChunkerParameterParser.parseStringParameter(parameters, "delimiter", DEFAULT_DELIMITER);
        this.maxChunkLimit = ChunkerParameterParser.parseIntegerParameter(parameters, "max_chunk_limit", 100);
    }

    @Override
    public List<String> chunk(String content, Map<String, Object> runtimeParameters) {
        int runtimeMaxChunkLimit = ChunkerParameterParser.parseIntegerParameter(runtimeParameters, "max_chunk_limit", this.maxChunkLimit);
        ArrayList<String> chunkResult = new ArrayList<String>();
        int start = 0;
        int nextDelimiterPosition = content.indexOf(this.delimiter);
        while (nextDelimiterPosition != -1) {
            ChunkerUtil.checkRunTimeMaxChunkLimit(chunkResult.size(), runtimeMaxChunkLimit, this.maxChunkLimit);
            int end = nextDelimiterPosition + this.delimiter.length();
            chunkResult.add(content.substring(start, end));
            start = end;
            nextDelimiterPosition = content.indexOf(this.delimiter, start);
        }
        if (start < content.length()) {
            ChunkerUtil.checkRunTimeMaxChunkLimit(chunkResult.size(), runtimeMaxChunkLimit, this.maxChunkLimit);
            chunkResult.add(content.substring(start));
        }
        return chunkResult;
    }
}

