"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSvelteSys = void 0;
const utils_1 = require("./utils");
const fileCollection_1 = require("../../lib/documents/fileCollection");
/**
 * This should only be accessed by TS svelte module resolution.
 */
function createSvelteSys(tsSystem) {
    const fileExistsCache = new fileCollection_1.FileMap();
    const svelteSys = {
        ...tsSystem,
        fileExists(path) {
            path = (0, utils_1.ensureRealSvelteFilePath)(path);
            const exists = fileExistsCache.get(path) ?? tsSystem.fileExists(path);
            fileExistsCache.set(path, exists);
            return exists;
        },
        readFile(path) {
            // No getSnapshot here, because TS will very rarely call this and only for files that are not in the project
            return tsSystem.readFile((0, utils_1.ensureRealSvelteFilePath)(path));
        },
        readDirectory(path, extensions, exclude, include, depth) {
            const extensionsWithSvelte = extensions ? [...extensions, '.svelte'] : undefined;
            return tsSystem.readDirectory(path, extensionsWithSvelte, exclude, include, depth);
        },
        deleteFile(path) {
            fileExistsCache.delete((0, utils_1.ensureRealSvelteFilePath)(path));
            return tsSystem.deleteFile?.(path);
        },
        deleteFromCache(path) {
            fileExistsCache.delete((0, utils_1.ensureRealSvelteFilePath)(path));
        }
    };
    if (tsSystem.realpath) {
        const realpath = tsSystem.realpath;
        svelteSys.realpath = function (path) {
            if ((0, utils_1.isVirtualSvelteFilePath)(path)) {
                return realpath((0, utils_1.toRealSvelteFilePath)(path)) + '.ts';
            }
            return realpath(path);
        };
    }
    return svelteSys;
}
exports.createSvelteSys = createSvelteSys;
//# sourceMappingURL=svelte-sys.js.map