/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.rest.handler.ValidateForecasterActionHandler;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.transport.ValidateForecasterAction;
import org.opensearch.rest.RestRequest;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.rest.handler.Processor;
import org.opensearch.timeseries.transport.BaseValidateConfigTransportAction;
import org.opensearch.timeseries.transport.ValidateConfigRequest;
import org.opensearch.timeseries.transport.ValidateConfigResponse;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;

public class ValidateForecasterTransportAction
extends BaseValidateConfigTransportAction<ForecastIndex, ForecastIndexManagement> {
    public static final Logger logger = LogManager.getLogger(ValidateForecasterTransportAction.class);

    @Inject
    public ValidateForecasterTransportAction(Client client, SecurityClientUtil clientUtil, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Settings settings, ForecastIndexManagement anomalyDetectionIndices, ActionFilters actionFilters, TransportService transportService, SearchFeatureDao searchFeatureDao) {
        super(ValidateForecasterAction.NAME, client, clientUtil, clusterService, xContentRegistry, settings, anomalyDetectionIndices, actionFilters, transportService, searchFeatureDao, ForecastSettings.FORECAST_FILTER_BY_BACKEND_ROLES);
    }

    @Override
    protected Processor<ValidateConfigResponse> createProcessor(Config forecaster, ValidateConfigRequest request, User user) {
        return new ValidateForecasterActionHandler(this.clusterService, this.client, this.clientUtil, (ForecastIndexManagement)this.indexManagement, forecaster, request.getRequestTimeout(), request.getMaxSingleEntityAnomalyDetectors(), request.getMaxMultiEntityAnomalyDetectors(), request.getMaxAnomalyFeatures(), request.getMaxCategoricalFields(), RestRequest.Method.POST, this.xContentRegistry, user, this.searchFeatureDao, request.getValidationType(), this.clock, this.settings);
    }
}

