/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest.handler;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsAction;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Feature;
import org.opensearch.timeseries.model.MergeableList;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;
import org.opensearch.timeseries.rest.handler.ConfigUpdateConfirmer;
import org.opensearch.timeseries.rest.handler.Processor;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.task.TaskManager;
import org.opensearch.timeseries.util.MultiResponsesDelegateActionListener;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;

public abstract class AbstractTimeSeriesActionHandler<T extends ActionResponse, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, TaskManagerType extends TaskManager<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType>>
implements Processor<T> {
    protected final Logger logger = LogManager.getLogger(AbstractTimeSeriesActionHandler.class);
    public static final String NAME_REGEX = "[a-zA-Z0-9._-]+";
    public static final Integer MAX_NAME_SIZE = 64;
    public static final String CATEGORY_NOT_FOUND_ERR_MSG = "Can't find the categorical field %s";
    public static String INVALID_NAME_SIZE = "Name should be shortened. The maximum limit is " + MAX_NAME_SIZE + " characters.";
    public static final Set<String> ALL_VALIDATION_ASPECTS_STRS = Arrays.asList(ValidationAspect.values()).stream().map(aspect -> aspect.getName()).collect(Collectors.toSet());
    protected final Config config;
    protected final IndexManagement<IndexType> timeSeriesIndices;
    protected final boolean isDryRun;
    protected final Client client;
    protected final String id;
    protected final SecurityClientUtil clientUtil;
    protected final User user;
    protected final RestRequest.Method method;
    protected final ConfigUpdateConfirmer<IndexType, IndexManagementType, TaskCacheManagerType, TaskTypeEnum, TaskClass, TaskManagerType> handler;
    protected final ClusterService clusterService;
    protected final NamedXContentRegistry xContentRegistry;
    protected final TimeValue requestTimeout;
    protected final WriteRequest.RefreshPolicy refreshPolicy;
    protected final Long seqNo;
    protected final Long primaryTerm;
    protected final String validationType;
    protected final SearchFeatureDao searchFeatureDao;
    protected final Integer maxFeatures;
    protected final Integer maxCategoricalFields;
    protected final AnalysisType context;
    protected final List<TaskTypeEnum> batchTasks;
    protected final boolean canUpdateEverything;
    protected final Integer maxSingleStreamConfigs;
    protected final Integer maxHCConfigs;
    protected final Clock clock;
    protected final Settings settings;
    protected final ValidationAspect configValidationAspect;

    public AbstractTimeSeriesActionHandler(Config config, IndexManagement<IndexType> timeSeriesIndices, boolean isDryRun, Client client, String id, SecurityClientUtil clientUtil, User user, RestRequest.Method method, ClusterService clusterService, NamedXContentRegistry xContentRegistry, TransportService transportService, TimeValue requestTimeout, WriteRequest.RefreshPolicy refreshPolicy, Long seqNo, Long primaryTerm, String validationType, SearchFeatureDao searchFeatureDao, Integer maxFeatures, Integer maxCategoricalFields, AnalysisType context, TaskManagerType taskManager, List<TaskTypeEnum> batchTasks, boolean canUpdateCategoryField, Integer maxSingleStreamConfigs, Integer maxHCConfigs, Clock clock, Settings settings, ValidationAspect configValidationAspect) {
        this.config = config;
        this.timeSeriesIndices = timeSeriesIndices;
        this.isDryRun = isDryRun;
        this.client = client;
        this.id = id == null ? "" : id;
        this.clientUtil = clientUtil;
        this.user = user;
        this.method = method;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.requestTimeout = requestTimeout;
        this.refreshPolicy = refreshPolicy;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.validationType = validationType;
        this.searchFeatureDao = searchFeatureDao;
        this.maxFeatures = maxFeatures;
        this.maxCategoricalFields = maxCategoricalFields;
        this.context = context;
        this.batchTasks = batchTasks;
        this.canUpdateEverything = canUpdateCategoryField;
        this.maxSingleStreamConfigs = maxSingleStreamConfigs;
        this.maxHCConfigs = maxHCConfigs;
        this.clock = clock;
        this.settings = settings;
        this.handler = new ConfigUpdateConfirmer(taskManager, transportService);
        this.configValidationAspect = configValidationAspect;
    }

    @Override
    public void start(ActionListener<T> listener) {
        String resultIndexOrAlias = this.config.getCustomResultIndexOrAlias();
        if (resultIndexOrAlias == null) {
            this.createOrUpdateConfig(listener);
            return;
        }
        if (this.isDryRun) {
            if (this.timeSeriesIndices.doesIndexExist(resultIndexOrAlias) || this.timeSeriesIndices.doesAliasExist(resultIndexOrAlias)) {
                this.timeSeriesIndices.validateResultIndexAndExecute(resultIndexOrAlias, () -> this.createOrUpdateConfig(listener), false, ActionListener.wrap(r -> this.createOrUpdateConfig(listener), ex -> {
                    this.logger.error(ex);
                    listener.onFailure((Exception)this.createValidationException(ex.getMessage(), ValidationIssueType.RESULT_INDEX));
                }));
                return;
            }
            this.createOrUpdateConfig(listener);
            return;
        }
        this.timeSeriesIndices.initCustomResultIndexAndExecute(resultIndexOrAlias, () -> this.createOrUpdateConfig(listener), listener);
    }

    private void createOrUpdateConfig(ActionListener<T> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            if (!this.timeSeriesIndices.doesConfigIndexExist() && !this.isDryRun) {
                this.logger.info("Config Indices do not exist");
                this.timeSeriesIndices.initConfigIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> this.onCreateMappingsResponse((CreateIndexResponse)response, false, listener), exception -> listener.onFailure(exception)));
            } else {
                this.logger.info("DryRun variable " + this.isDryRun);
                this.validateName(this.isDryRun, listener);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to create or update forecaster " + this.id, (Throwable)e);
            listener.onFailure(e);
        }
    }

    protected void validateName(boolean indexingDryRun, ActionListener<T> listener) {
        if (!this.config.getName().matches(NAME_REGEX)) {
            listener.onFailure((Exception)this.createValidationException(CommonMessages.INVALID_NAME, ValidationIssueType.NAME));
            return;
        }
        if (this.config.getName().length() > MAX_NAME_SIZE) {
            listener.onFailure((Exception)this.createValidationException(INVALID_NAME_SIZE, ValidationIssueType.NAME));
            return;
        }
        this.validateTimeField(indexingDryRun, listener);
    }

    protected void validateTimeField(boolean indexingDryRun, ActionListener<T> listener) {
        String givenTimeField = this.config.getTimeField();
        GetFieldMappingsRequest getMappingsRequest = new GetFieldMappingsRequest();
        getMappingsRequest.indices(this.config.getIndices().toArray(new String[0])).fields(new String[]{givenTimeField});
        getMappingsRequest.indicesOptions(IndicesOptions.strictExpand());
        ActionListener mappingsListener = ActionListener.wrap(getMappingsResponse -> {
            boolean foundField = false;
            Map mappingsByIndex = getMappingsResponse.mappings();
            for (Map mappingsByField : mappingsByIndex.values()) {
                for (Map.Entry field2Metadata : mappingsByField.entrySet()) {
                    Map fieldMap;
                    GetFieldMappingsResponse.FieldMappingMetadata fieldMetadata = (GetFieldMappingsResponse.FieldMappingMetadata)field2Metadata.getValue();
                    if (fieldMetadata == null || (fieldMap = fieldMetadata.sourceAsMap()) == null) continue;
                    for (Object type : fieldMap.values()) {
                        if (!(type instanceof Map)) continue;
                        foundField = true;
                        Map metadataMap = (Map)type;
                        String typeName = (String)metadataMap.get("type");
                        if (typeName.equals("date")) continue;
                        listener.onFailure((Exception)new ValidationException(String.format(Locale.ROOT, CommonMessages.INVALID_TIMESTAMP, givenTimeField), ValidationIssueType.TIMEFIELD_FIELD, this.configValidationAspect));
                        return;
                    }
                }
            }
            if (!foundField) {
                listener.onFailure((Exception)new ValidationException(String.format(Locale.ROOT, CommonMessages.NON_EXISTENT_TIMESTAMP, givenTimeField), ValidationIssueType.TIMEFIELD_FIELD, this.configValidationAspect));
                return;
            }
            this.prepareConfigIndexing(indexingDryRun, listener);
        }, error -> {
            String message = String.format(Locale.ROOT, "Fail to get the index mapping of %s", this.config.getIndices());
            this.logger.error(message, (Throwable)error);
            listener.onFailure((Exception)new IllegalArgumentException(message));
        });
        this.clientUtil.executeWithInjectedSecurity(GetFieldMappingsAction.INSTANCE, getMappingsRequest, this.user, this.client, this.context, mappingsListener);
    }

    protected void prepareConfigIndexing(boolean indexingDryRun, ActionListener<T> listener) {
        if (this.method == RestRequest.Method.PUT) {
            this.handler.confirmJobRunning(this.clusterService, this.client, this.id, listener, () -> this.updateConfig(this.id, indexingDryRun, listener), this.xContentRegistry);
        } else {
            this.createConfig(indexingDryRun, listener);
        }
    }

    protected void updateConfig(String id, boolean indexingDryRun, ActionListener<T> listener) {
        GetRequest request = new GetRequest(".opendistro-anomaly-detectors", id);
        this.client.get(request, ActionListener.wrap(response -> this.onGetConfigResponse((GetResponse)response, indexingDryRun, id, listener), exception -> listener.onFailure(exception)));
    }

    private void onGetConfigResponse(GetResponse response, boolean indexingDryRun, String id, ActionListener<T> listener) {
        if (!response.isExists()) {
            listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_FIND_CONFIG_MSG + id, RestStatus.NOT_FOUND, new Object[0]));
            return;
        }
        try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            Config existingConfig = this.parse(parser, response);
            if (!this.canUpdateEverything) {
                if (!ParseUtils.listEqualsWithoutConsideringOrder(existingConfig.getCategoryFields(), this.config.getCategoryFields())) {
                    listener.onFailure((Exception)new OpenSearchStatusException("Can't change category field", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                if (!Objects.equals(existingConfig.getCustomResultIndexOrAlias(), this.config.getCustomResultIndexOrAlias())) {
                    listener.onFailure((Exception)new OpenSearchStatusException("Can't change custom result index", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
            }
            ActionListener confirmBatchRunningListener = ActionListener.wrap(r -> this.searchConfigInputIndices(id, indexingDryRun, listener), arg_0 -> listener.onFailure(arg_0));
            this.handler.confirmBatchRunning(id, this.batchTasks, (ActionListener<Void>)confirmBatchRunningListener);
        }
        catch (IOException e) {
            String message = "Failed to parse anomaly detector " + id;
            this.logger.error(message, (Throwable)e);
            listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    protected void validateAgainstExistingHCConfig(String detectorId, boolean indexingDryRun, ActionListener<T> listener) {
        if (this.timeSeriesIndices.doesConfigIndexExist()) {
            BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)"category_field"));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query).size(0).timeout(this.requestTimeout);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-anomaly-detectors"}).source(searchSourceBuilder);
            this.client.search(searchRequest, ActionListener.wrap(response -> this.onSearchHCConfigResponse((SearchResponse)response, detectorId, indexingDryRun, listener), exception -> listener.onFailure(exception)));
        } else {
            this.validateCategoricalField(detectorId, indexingDryRun, listener);
        }
    }

    protected void createConfig(boolean indexingDryRun, ActionListener<T> listener) {
        try {
            List<String> categoricalFields = this.config.getCategoryFields();
            if (categoricalFields != null && categoricalFields.size() > 0) {
                this.validateAgainstExistingHCConfig(null, indexingDryRun, listener);
            } else if (this.timeSeriesIndices.doesConfigIndexExist()) {
                MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query).size(0).timeout(this.requestTimeout);
                SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-anomaly-detectors"}).source(searchSourceBuilder);
                this.client.search(searchRequest, ActionListener.wrap(response -> this.onSearchSingleStreamConfigResponse((SearchResponse)response, indexingDryRun, listener), exception -> listener.onFailure(exception)));
            } else {
                this.searchConfigInputIndices(null, indexingDryRun, listener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    protected void onSearchSingleStreamConfigResponse(SearchResponse response, boolean indexingDryRun, ActionListener<T> listener) throws IOException {
        if (response.getHits().getTotalHits().value >= (long)this.getMaxSingleStreamConfigs().intValue()) {
            String errorMsgSingleEntity = this.getExceedMaxSingleStreamConfigsErrorMsg(this.getMaxSingleStreamConfigs());
            this.logger.error(errorMsgSingleEntity);
            if (indexingDryRun) {
                listener.onFailure((Exception)this.createValidationException(errorMsgSingleEntity, ValidationIssueType.GENERAL_SETTINGS));
                return;
            }
            listener.onFailure((Exception)new IllegalArgumentException(errorMsgSingleEntity));
        } else {
            this.searchConfigInputIndices(null, indexingDryRun, listener);
        }
    }

    protected void onSearchHCConfigResponse(SearchResponse response, String detectorId, boolean indexingDryRun, ActionListener<T> listener) throws IOException {
        if (response.getHits().getTotalHits().value >= (long)this.getMaxHCConfigs().intValue()) {
            String errorMsg = this.getExceedMaxHCConfigsErrorMsg(this.getMaxHCConfigs());
            this.logger.error(errorMsg);
            if (indexingDryRun) {
                listener.onFailure((Exception)this.createValidationException(errorMsg, ValidationIssueType.GENERAL_SETTINGS));
                return;
            }
            listener.onFailure((Exception)new IllegalArgumentException(errorMsg));
        } else {
            this.validateCategoricalField(detectorId, indexingDryRun, listener);
        }
    }

    protected void validateCategoricalField(String detectorId, boolean indexingDryRun, ActionListener<T> listener) {
        List<String> categoryField = this.config.getCategoryFields();
        if (categoryField == null) {
            this.searchConfigInputIndices(detectorId, indexingDryRun, listener);
            return;
        }
        int maxCategoryFields = this.maxCategoricalFields;
        if (categoryField.size() > maxCategoryFields) {
            listener.onFailure((Exception)this.createValidationException(CommonMessages.getTooManyCategoricalFieldErr(maxCategoryFields), ValidationIssueType.CATEGORY));
            return;
        }
        String categoryField0 = categoryField.get(0);
        GetFieldMappingsRequest getMappingsRequest = new GetFieldMappingsRequest();
        getMappingsRequest.indices(this.config.getIndices().toArray(new String[0])).fields(categoryField.toArray(new String[0]));
        getMappingsRequest.indicesOptions(IndicesOptions.strictExpand());
        ActionListener mappingsListener = ActionListener.wrap(getMappingsResponse -> {
            boolean foundField = false;
            Map mappingsByIndex = getMappingsResponse.mappings();
            for (Map mappingsByField : mappingsByIndex.values()) {
                for (Map.Entry field2Metadata : mappingsByField.entrySet()) {
                    Map fieldMap;
                    GetFieldMappingsResponse.FieldMappingMetadata fieldMetadata = (GetFieldMappingsResponse.FieldMappingMetadata)field2Metadata.getValue();
                    if (fieldMetadata == null || (fieldMap = fieldMetadata.sourceAsMap()) == null) continue;
                    for (Object type : fieldMap.values()) {
                        if (type == null || !(type instanceof Map)) continue;
                        foundField = true;
                        Map metadataMap = (Map)type;
                        String typeName = (String)metadataMap.get("type");
                        if (typeName.equals("keyword") || typeName.equals("ip")) continue;
                        listener.onFailure((Exception)this.createValidationException("A categorical field must be of type keyword or ip.", ValidationIssueType.CATEGORY));
                        return;
                    }
                }
            }
            if (!foundField) {
                listener.onFailure((Exception)this.createValidationException(String.format(Locale.ROOT, CATEGORY_NOT_FOUND_ERR_MSG, categoryField0), ValidationIssueType.CATEGORY));
                return;
            }
            this.searchConfigInputIndices(detectorId, indexingDryRun, listener);
        }, error -> {
            String message = String.format(Locale.ROOT, "Fail to get the index mapping of %s", this.config.getIndices());
            this.logger.error(message, (Throwable)error);
            listener.onFailure((Exception)new IllegalArgumentException(message));
        });
        this.clientUtil.executeWithInjectedSecurity(GetFieldMappingsAction.INSTANCE, getMappingsRequest, this.user, this.client, this.context, mappingsListener);
    }

    protected void searchConfigInputIndices(String detectorId, boolean indexingDryRun, ActionListener<T> listener) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(0).timeout(this.requestTimeout);
        SearchRequest searchRequest = new SearchRequest(this.config.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(searchResponse -> this.onSearchConfigInputIndicesResponse((SearchResponse)searchResponse, detectorId, indexingDryRun, listener), exception -> listener.onFailure(exception));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, searchResponseListener);
    }

    protected void onSearchConfigInputIndicesResponse(SearchResponse response, String detectorId, boolean indexingDryRun, ActionListener<T> listener) throws IOException {
        if (response.getHits().getTotalHits().value == 0L) {
            String errorMsg = this.getNoDocsInUserIndexErrorMsg(Arrays.toString(this.config.getIndices().toArray(new String[0])));
            this.logger.error(errorMsg);
            if (indexingDryRun) {
                listener.onFailure((Exception)this.createValidationException(errorMsg, ValidationIssueType.INDICES));
                return;
            }
            listener.onFailure((Exception)new IllegalArgumentException(errorMsg));
        } else {
            this.validateConfigFeatures(detectorId, indexingDryRun, listener);
        }
    }

    protected void checkConfigNameExists(String configId, boolean indexingDryRun, ActionListener<T> listener) throws IOException {
        if (this.timeSeriesIndices.doesConfigIndexExist()) {
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"name.keyword", (String)this.config.getName()));
            if (StringUtils.isNotBlank((String)configId)) {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)configId));
            }
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).timeout(this.requestTimeout);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-anomaly-detectors"}).source(searchSourceBuilder);
            this.client.search(searchRequest, ActionListener.wrap(searchResponse -> this.onSearchConfigNameResponse((SearchResponse)searchResponse, this.config.getName(), indexingDryRun, listener), exception -> listener.onFailure(exception)));
        } else {
            this.tryIndexingConfig(indexingDryRun, listener);
        }
    }

    protected void onSearchConfigNameResponse(SearchResponse response, String name, boolean indexingDryRun, ActionListener<T> listener) throws IOException {
        if (response.getHits().getTotalHits().value > 0L) {
            String errorMsg = this.getDuplicateConfigErrorMsg(name);
            this.logger.warn(errorMsg);
            if (indexingDryRun) {
                listener.onFailure((Exception)this.createValidationException(errorMsg, ValidationIssueType.NAME));
            } else {
                listener.onFailure((Exception)new OpenSearchStatusException(errorMsg, RestStatus.CONFLICT, new Object[0]));
            }
        } else {
            this.tryIndexingConfig(indexingDryRun, listener);
        }
    }

    protected void tryIndexingConfig(boolean indexingDryRun, ActionListener<T> listener) throws IOException {
        if (!indexingDryRun) {
            this.indexConfig(this.id, listener);
        } else {
            this.finishConfigValidationOrContinueToModelValidation(listener);
        }
    }

    protected Set<ValidationAspect> getValidationTypes(String validationType) {
        if (StringUtils.isBlank((String)validationType)) {
            return this.getDefaultValidationType();
        }
        HashSet<String> typesInRequest = new HashSet<String>(Arrays.asList(validationType.split(",")));
        return ValidationAspect.getNames((Collection<String>)Sets.intersection(ALL_VALIDATION_ASPECTS_STRS, typesInRequest));
    }

    protected void finishConfigValidationOrContinueToModelValidation(ActionListener<T> listener) {
        this.logger.info("Skipping indexing detector. No blocking issue found so far.");
        if (!this.getValidationTypes(this.validationType).contains(ValidationAspect.MODEL)) {
            listener.onResponse(null);
        } else {
            this.validateModel(listener);
        }
    }

    protected void indexConfig(final String id, final ActionListener<T> listener) throws IOException {
        final Config copiedConfig = this.copyConfig(this.user, this.config);
        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opendistro-anomaly-detectors").setRefreshPolicy(this.refreshPolicy)).source(copiedConfig.toXContent(XContentFactory.jsonBuilder(), (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE)).setIfSeqNo(this.seqNo.longValue()).setIfPrimaryTerm(this.primaryTerm.longValue()).timeout(this.requestTimeout);
        if (StringUtils.isNotBlank((String)id)) {
            indexRequest.id(id);
        }
        this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                String errorMsg = AbstractTimeSeriesActionHandler.this.checkShardsFailure(indexResponse);
                if (errorMsg != null) {
                    listener.onFailure((Exception)new OpenSearchStatusException(errorMsg, indexResponse.status(), new Object[0]));
                    return;
                }
                listener.onResponse(AbstractTimeSeriesActionHandler.this.createIndexConfigResponse(indexResponse, copiedConfig));
            }

            public void onFailure(Exception e) {
                AbstractTimeSeriesActionHandler.this.logger.warn("Failed to update config", (Throwable)e);
                if (e.getMessage() != null && e.getMessage().contains("version conflict")) {
                    listener.onFailure((Exception)new IllegalArgumentException("There was a problem updating the config:[" + id + "]"));
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    protected void onCreateMappingsResponse(CreateIndexResponse response, boolean indexingDryRun, ActionListener<T> listener) {
        if (response.isAcknowledged()) {
            this.logger.info("Created {} with mappings.", (Object)".opendistro-anomaly-detectors");
            this.prepareConfigIndexing(indexingDryRun, listener);
        } else {
            this.logger.warn("Created {} with mappings call not acknowledged.", (Object)".opendistro-anomaly-detectors");
            listener.onFailure((Exception)new OpenSearchStatusException("Created .opendistro-anomaly-detectorswith mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    protected String checkShardsFailure(IndexResponse response) {
        StringBuilder failureReasons = new StringBuilder();
        if (response.getShardInfo().getFailed() > 0) {
            for (ReplicationResponse.ShardInfo.Failure failure : response.getShardInfo().getFailures()) {
                failureReasons.append(failure);
            }
            return failureReasons.toString();
        }
        return null;
    }

    protected void validateConfigFeatures(String id, boolean indexingDryRun, ActionListener<T> listener) throws IOException {
        if (this.config != null && (this.config.getFeatureAttributes() == null || this.config.getFeatureAttributes().isEmpty())) {
            this.checkConfigNameExists(id, indexingDryRun, listener);
            return;
        }
        String error = RestHandlerUtils.checkFeaturesSyntax(this.config, this.maxFeatures);
        if (StringUtils.isNotBlank((String)error)) {
            if (indexingDryRun) {
                listener.onFailure((Exception)this.createValidationException(error, ValidationIssueType.FEATURE_ATTRIBUTES));
                return;
            }
            listener.onFailure((Exception)new OpenSearchStatusException(error, RestStatus.BAD_REQUEST, new Object[0]));
            return;
        }
        ActionListener validateFeatureQueriesListener = ActionListener.wrap(response -> this.checkConfigNameExists(id, indexingDryRun, listener), exception -> listener.onFailure((Exception)this.createValidationException(exception.getMessage(), ValidationIssueType.FEATURE_ATTRIBUTES)));
        MultiResponsesDelegateActionListener multiFeatureQueriesResponseListener = new MultiResponsesDelegateActionListener(validateFeatureQueriesListener, this.config.getFeatureAttributes().size(), this.getFeatureErrorMsg(this.config.getName()), false);
        for (Feature feature : this.config.getFeatureAttributes()) {
            SearchSourceBuilder ssb = new SearchSourceBuilder().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery());
            AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), this.xContentRegistry, feature.getId());
            ssb.aggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
            SearchRequest searchRequest = new SearchRequest().indices(this.config.getIndices().toArray(new String[0])).source(ssb);
            ActionListener searchResponseListener = ActionListener.wrap(response -> {
                Optional<double[]> aggFeatureResult = this.searchFeatureDao.parseResponse((SearchResponse)response, Arrays.asList(feature.getId()));
                if (aggFeatureResult.isPresent()) {
                    multiFeatureQueriesResponseListener.onResponse(new MergeableList<Optional>(new ArrayList<Optional>(Arrays.asList(aggFeatureResult))));
                } else {
                    String errorMessage = "Feature has an invalid query returning empty aggregated data: " + feature.getName();
                    this.logger.error(errorMessage);
                    multiFeatureQueriesResponseListener.onFailure((Exception)new OpenSearchStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0]));
                }
            }, e -> {
                String errorMessage = RestHandlerUtils.isExceptionCausedByInvalidQuery(e) ? "Feature has an invalid query causing a runtime exception: " + feature.getName() : "Feature has an unknown exception caught while executing the feature query: " + feature.getName();
                this.logger.error(errorMessage, (Throwable)e);
                multiFeatureQueriesResponseListener.onFailure((Exception)new OpenSearchStatusException(errorMessage, RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]));
            });
            this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, searchResponseListener);
        }
    }

    protected Integer getMaxSingleStreamConfigs() {
        return this.maxSingleStreamConfigs;
    }

    protected Integer getMaxHCConfigs() {
        return this.maxHCConfigs;
    }

    protected abstract TimeSeriesException createValidationException(String var1, ValidationIssueType var2);

    protected abstract Config parse(XContentParser var1, GetResponse var2) throws IOException;

    protected abstract String getExceedMaxSingleStreamConfigsErrorMsg(int var1);

    protected abstract String getExceedMaxHCConfigsErrorMsg(int var1);

    protected abstract String getNoDocsInUserIndexErrorMsg(String var1);

    protected abstract String getDuplicateConfigErrorMsg(String var1);

    protected abstract String getFeatureErrorMsg(String var1);

    protected abstract Config copyConfig(User var1, Config var2);

    protected abstract T createIndexConfigResponse(IndexResponse var1, Config var2);

    protected abstract Set<ValidationAspect> getDefaultValidationType();

    protected abstract void validateModel(ActionListener<T> var1);
}

