/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.BadParametersException;
import com.password4j.Hash;
import com.password4j.PBKDF2Function;
import com.password4j.PropertyReader;
import com.password4j.Utils;
import com.password4j.types.Hmac;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CompressedPBKDF2Function
extends PBKDF2Function {
    private static final Map<String, CompressedPBKDF2Function> INSTANCES = new ConcurrentHashMap<String, CompressedPBKDF2Function>();
    private static final char DELIMITER = PropertyReader.readChar("hash.pbkdf2.delimiter", '$');

    protected CompressedPBKDF2Function() {
    }

    protected CompressedPBKDF2Function(Hmac fromCode, int iterations, int length) {
        super(fromCode, iterations, length);
    }

    public static CompressedPBKDF2Function getInstance(Hmac algorithm, int iterations, int length) {
        String key = CompressedPBKDF2Function.getUID(algorithm.name(), iterations, length);
        if (INSTANCES.containsKey(key)) {
            return INSTANCES.get(key);
        }
        CompressedPBKDF2Function function = new CompressedPBKDF2Function(algorithm, iterations, length);
        INSTANCES.put(key, function);
        return function;
    }

    public static CompressedPBKDF2Function getInstance(String algorithm, int iterations, int length) {
        try {
            return CompressedPBKDF2Function.getInstance(Hmac.valueOf(algorithm), iterations, length);
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedOperationException("Algorithm `" + algorithm + "` is not recognized.", iae);
        }
    }

    public static CompressedPBKDF2Function getInstanceFromHash(String hashed) {
        String[] parts = CompressedPBKDF2Function.getParts(hashed);
        if (parts.length == 5) {
            int algorithm = Integer.parseInt(parts[1]);
            long configuration = Long.parseLong(parts[2]);
            int iterations = (int)(configuration >> 32);
            int length = (int)configuration;
            return CompressedPBKDF2Function.getInstance(Hmac.fromCode(algorithm), iterations, length);
        }
        throw new BadParametersException("`" + hashed + "` is not a valid hash");
    }

    protected static List<byte[]> getParts(byte[] hashed) {
        return Utils.split(hashed, (byte)DELIMITER);
    }

    protected static String[] getParts(String hashed) {
        String regex = "\\" + DELIMITER;
        return hashed.split(regex);
    }

    @Override
    protected String getHash(byte[] encodedKey, byte[] salt) {
        String params = Long.toString((long)this.getIterations() << 32 | (long)this.getLength() & 0xFFFFFFFFL);
        String salt64 = Utils.encodeBase64(salt);
        String hash64 = super.getHash(encodedKey, salt);
        return "$" + this.algorithm.code() + "$" + params + "$" + salt64 + "$" + hash64;
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed) {
        return this.check(Utils.fromCharSequenceToBytes(plainTextPassword), Utils.fromCharSequenceToBytes(hashed));
    }

    @Override
    public boolean check(byte[] plainTextPassword, byte[] hashed) {
        byte[] salt = this.getSaltFromHash(hashed);
        Hash internalHas = this.hash(plainTextPassword, salt);
        return CompressedPBKDF2Function.slowEquals(internalHas.getResultAsBytes(), hashed);
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed, String salt) {
        byte[] hashAsBytes = Utils.fromCharSequenceToBytes(hashed);
        byte[] realSalt = this.getSaltFromHash(hashAsBytes);
        byte[] plainTextPasswordAsBytes = Utils.fromCharSequenceToBytes(plainTextPassword);
        Hash internalHash = this.hash(plainTextPasswordAsBytes, realSalt);
        return CompressedPBKDF2Function.slowEquals(internalHash.getResult(), hashed);
    }

    @Override
    public boolean check(byte[] plainTextPassword, byte[] hashed, byte[] salt) {
        byte[] realSalt = this.getSaltFromHash(hashed);
        Hash internalHash = this.hash(plainTextPassword, realSalt);
        return CompressedPBKDF2Function.slowEquals(internalHash.getResultAsBytes(), hashed);
    }

    private byte[] getSaltFromHash(byte[] hashed) {
        List<byte[]> parts = CompressedPBKDF2Function.getParts(hashed);
        if (parts.size() == 5) {
            return Utils.decodeBase64(parts.get(3));
        }
        throw new BadParametersException("`" + Utils.fromBytesToString(hashed) + "` is not a valid hash");
    }
}

