/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.CompressedGeometryRetained;
import javax.media.j3d.GeneralizedVertexList;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryDecompressor;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dI18N;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

class GeometryDecompressorRetained
extends GeometryDecompressor {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    private static final boolean statistics = false;
    private static final boolean printInfo = false;
    private int bufferDataType;
    private int dataPresent;
    private int size;
    private Color4f curColor;
    private Vector3f curNormal;
    private GeneralizedVertexList vlist;
    private Point3d lbounds = new Point3d();
    private Point3d ubounds = new Point3d();
    private boolean boundsOnly = false;
    private boolean positionsOnly = false;
    private static final float bytesPerVertexFudge = 5.3f;
    private long startTime;
    private long endTime;
    private static final int TYPE_POINT = 1;
    private static final int TYPE_LINE = 2;
    private static final int TYPE_TRIANGLE = 4;
    private static final int FRONTFACE_CCW = 1;

    GeometryDecompressorRetained() {
    }

    void setDecompressBoundsOnly(boolean bl) {
        this.boundsOnly = bl;
        if (bl) {
            this.positionsOnly = false;
        }
    }

    void setDecompressPositionsOnly(boolean bl) {
        this.positionsOnly = bl;
        if (bl) {
            this.boundsOnly = false;
        }
    }

    GeometryRetained decompress(CompressedGeometryRetained compressedGeometryRetained) {
        GeometryArray geometryArray;
        if (!this.checkVersion(compressedGeometryRetained.majorVersionNumber, compressedGeometryRetained.minorVersionNumber)) {
            return null;
        }
        this.vlist = null;
        this.curColor = null;
        this.curNormal = null;
        this.lbounds.set(1.0, 1.0, 1.0);
        this.ubounds.set(-1.0, -1.0, -1.0);
        this.bufferDataType = compressedGeometryRetained.bufferType;
        this.dataPresent = compressedGeometryRetained.bufferContents;
        this.size = compressedGeometryRetained.size;
        super.decompress(compressedGeometryRetained.offset, this.size, compressedGeometryRetained.compressedGeometry);
        if (this.boundsOnly) {
            return null;
        }
        switch (this.bufferDataType) {
            case 4: {
                geometryArray = this.vlist.toTriangleStripArray();
                break;
            }
            case 2: {
                geometryArray = this.vlist.toLineStripArray();
                break;
            }
            case 1: {
                geometryArray = this.vlist.toPointArray();
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryDecompressorRetained0"));
            }
        }
        geometryArray.retained.setSource(null);
        return (GeometryRetained)geometryArray.retained;
    }

    void getBoundingBox(BoundingBox boundingBox) {
        boundingBox.setLower(this.lbounds);
        boundingBox.setUpper(this.ubounds);
    }

    void outputVertexFormat(boolean bl, boolean bl2, boolean bl3) {
        if (this.boundsOnly) {
            return;
        }
        if (this.vlist != null) {
            throw new IllegalStateException(J3dI18N.getString("GeometryDecompressorRetained1"));
        }
        int n = 1;
        if (!this.positionsOnly) {
            if (bl) {
                n |= 2;
            }
            if (bl2) {
                n |= 4;
            }
            if (bl3) {
                n |= 8;
            }
        }
        this.vlist = new GeneralizedVertexList(n, 1, (int)((float)this.size / 5.3f));
    }

    void outputVertex(Point3f point3f, Vector3f vector3f, Color4f color4f, int n) {
        if ((double)point3f.x < this.lbounds.x) {
            this.lbounds.x = point3f.x;
        }
        if ((double)point3f.y < this.lbounds.y) {
            this.lbounds.y = point3f.y;
        }
        if ((double)point3f.z < this.lbounds.z) {
            this.lbounds.z = point3f.z;
        }
        if ((double)point3f.x > this.ubounds.x) {
            this.ubounds.x = point3f.x;
        }
        if ((double)point3f.y > this.ubounds.y) {
            this.ubounds.y = point3f.y;
        }
        if ((double)point3f.z > this.ubounds.z) {
            this.ubounds.z = point3f.z;
        }
        if (this.boundsOnly) {
            return;
        }
        if (this.curColor != null) {
            color4f = this.curColor;
        }
        if (this.curNormal != null) {
            vector3f = this.curNormal;
        }
        this.vlist.addVertex(point3f, vector3f, color4f, n);
    }

    void outputColor(Color4f color4f) {
        if (this.boundsOnly || this.positionsOnly) {
            return;
        }
        if ((this.vlist.vertexFormat & 4) == 0) {
            if (this.vlist.size() > 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryDecompressorRetained2"));
            }
            this.vlist.setVertexFormat(this.vlist.vertexFormat | 4);
        }
        if (this.curColor == null) {
            this.curColor = new Color4f();
        }
        this.curColor.set((Tuple4f)color4f);
    }

    void outputNormal(Vector3f vector3f) {
        if (this.boundsOnly || this.positionsOnly) {
            return;
        }
        if ((this.vlist.vertexFormat & 2) == 0) {
            if (this.vlist.size() > 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryDecompressorRetained3"));
            }
            this.vlist.setVertexFormat(this.vlist.vertexFormat | 2);
        }
        if (this.curNormal == null) {
            this.curNormal = new Vector3f();
        }
        this.curNormal.set((Tuple3f)vector3f);
    }

    private void beginPrint() {
        System.err.println("\nGeometryDecompressorRetained");
        switch (this.bufferDataType) {
            case 4: {
                System.err.println(" buffer TYPE_TRIANGLE");
                break;
            }
            case 2: {
                System.err.println(" buffer TYPE_LINE");
                break;
            }
            case 1: {
                System.err.println(" buffer TYPE_POINT");
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryDecompressorRetained4"));
            }
        }
        System.err.print(" buffer data present: coords");
        if ((this.dataPresent & 1) != 0) {
            System.err.print(" normals");
        }
        if ((this.dataPresent & 2) != 0) {
            System.err.print(" colors");
        }
        if ((this.dataPresent & 4) != 0) {
            System.err.print(" alpha");
        }
        System.err.println();
        if (this.boundsOnly) {
            System.err.println(" computing bounds only");
        }
        if (this.positionsOnly) {
            System.err.println(" computing positions only");
        }
        this.startTime = J3dClock.currentTimeMillis();
    }

    private void endPrint() {
        this.endTime = J3dClock.currentTimeMillis();
    }

    private void printBench() {
        float f = (float)(this.endTime - this.startTime) / 1000.0f;
        if (this.boundsOnly) {
            System.err.println(" decompression took " + f + " sec.\n");
            return;
        }
        System.err.println(" decompression + strip conversion took " + f + " sec.");
        switch (this.bufferDataType) {
            case 1: {
                System.err.println(" decompressed " + this.vlist.size() + " points at " + (float)this.vlist.size() / f + " points/sec.\n");
                break;
            }
            case 2: {
                System.err.println(" decompressed " + (this.vlist.vertexCount - this.vlist.stripCount) + " lines at " + (float)(this.vlist.vertexCount - this.vlist.stripCount) / f + " lines/sec.\n");
                break;
            }
            case 4: {
                System.err.println(" decompressed " + (this.vlist.vertexCount - 2 * this.vlist.stripCount) + " triangles at " + (float)(this.vlist.vertexCount - 2 * this.vlist.stripCount) / f + " triangles/sec.\n");
            }
        }
    }

    private void printStats() {
        System.err.println(" bounding box:\n  lower " + this.lbounds.toString() + "\n  upper " + this.ubounds.toString());
        if (this.boundsOnly) {
            return;
        }
        System.err.print(" number of vertices in GeometryArray output: " + this.vlist.vertexCount + "\n" + " GeometryArray vertex data present: coords");
        if ((this.vlist.vertexFormat & 2) != 0) {
            System.err.print(" normals");
        }
        if ((this.vlist.vertexFormat & 4) != 0) {
            System.err.print(" colors");
        }
        if ((this.vlist.vertexFormat & 8) != 0) {
            System.err.print(" alpha");
        }
        System.err.println("\n number of strips: " + this.vlist.stripCount);
        if (this.vlist.stripCount > 0) {
            System.err.println(" vertices/strip: " + (float)this.vlist.vertexCount / (float)this.vlist.stripCount);
        }
    }
}

