(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["agGrid"] = factory();
	else
		root["agGrid"] = factory();
})(self, function() {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 7886:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp(target, key, result);
  return result;
};

// community-modules/client-side-row-model/src/main.ts
var main_exports = {};
__export(main_exports, {
  ClientSideRowModelModule: () => ClientSideRowModelModule
});
module.exports = __toCommonJS(main_exports);

// community-modules/client-side-row-model/src/clientSideRowModelModule.ts
var import_core9 = __webpack_require__(3423);

// community-modules/client-side-row-model/src/clientSideRowModel/clientSideRowModel.ts
var import_core2 = __webpack_require__(3423);

// community-modules/client-side-row-model/src/clientSideRowModel/clientSideNodeManager.ts
var import_core = __webpack_require__(3423);
var _ClientSideNodeManager = class _ClientSideNodeManager {
  constructor(rootNode, gridOptionsService, eventService, columnModel, selectionService, beans) {
    this.nextId = 0;
    // has row data actually been set
    this.rowCountReady = false;
    // when user is provide the id's, we also keep a map of ids to row nodes for convenience
    this.allNodesMap = {};
    this.rootNode = rootNode;
    this.gridOptionsService = gridOptionsService;
    this.eventService = eventService;
    this.columnModel = columnModel;
    this.beans = beans;
    this.selectionService = selectionService;
    this.rootNode.group = true;
    this.rootNode.level = -1;
    this.rootNode.id = _ClientSideNodeManager.ROOT_NODE_ID;
    this.rootNode.allLeafChildren = [];
    this.rootNode.childrenAfterGroup = [];
    this.rootNode.childrenAfterSort = [];
    this.rootNode.childrenAfterAggFilter = [];
    this.rootNode.childrenAfterFilter = [];
  }
  getCopyOfNodesMap() {
    return import_core._.cloneObject(this.allNodesMap);
  }
  getRowNode(id) {
    return this.allNodesMap[id];
  }
  setRowData(rowData) {
    if (typeof rowData === "string") {
      console.warn("AG Grid: rowData must be an array, however you passed in a string. If you are loading JSON, make sure you convert the JSON string to JavaScript objects first");
      return;
    }
    this.rowCountReady = true;
    this.dispatchRowDataUpdateStartedEvent(rowData);
    const rootNode = this.rootNode;
    const sibling = this.rootNode.sibling;
    rootNode.childrenAfterFilter = null;
    rootNode.childrenAfterGroup = null;
    rootNode.childrenAfterAggFilter = null;
    rootNode.childrenAfterSort = null;
    rootNode.childrenMapped = null;
    rootNode.updateHasChildren();
    this.nextId = 0;
    this.allNodesMap = {};
    if (rowData) {
      rootNode.allLeafChildren = rowData.map((dataItem) => this.createNode(dataItem, this.rootNode, _ClientSideNodeManager.TOP_LEVEL));
    } else {
      rootNode.allLeafChildren = [];
      rootNode.childrenAfterGroup = [];
    }
    if (sibling) {
      sibling.childrenAfterFilter = rootNode.childrenAfterFilter;
      sibling.childrenAfterGroup = rootNode.childrenAfterGroup;
      sibling.childrenAfterAggFilter = rootNode.childrenAfterAggFilter;
      sibling.childrenAfterSort = rootNode.childrenAfterSort;
      sibling.childrenMapped = rootNode.childrenMapped;
      sibling.allLeafChildren = rootNode.allLeafChildren;
    }
  }
  updateRowData(rowDataTran, rowNodeOrder) {
    this.rowCountReady = true;
    this.dispatchRowDataUpdateStartedEvent(rowDataTran.add);
    const rowNodeTransaction = {
      remove: [],
      update: [],
      add: []
    };
    const nodesToUnselect = [];
    this.executeRemove(rowDataTran, rowNodeTransaction, nodesToUnselect);
    this.executeUpdate(rowDataTran, rowNodeTransaction, nodesToUnselect);
    this.executeAdd(rowDataTran, rowNodeTransaction);
    this.updateSelection(nodesToUnselect, "rowDataChanged");
    if (rowNodeOrder) {
      import_core._.sortRowNodesByOrder(this.rootNode.allLeafChildren, rowNodeOrder);
    }
    return rowNodeTransaction;
  }
  isRowCountReady() {
    return this.rowCountReady;
  }
  dispatchRowDataUpdateStartedEvent(rowData) {
    const event = {
      type: import_core.Events.EVENT_ROW_DATA_UPDATE_STARTED,
      firstRowData: (rowData == null ? void 0 : rowData.length) ? rowData[0] : null
    };
    this.eventService.dispatchEvent(event);
  }
  updateSelection(nodesToUnselect, source) {
    const selectionChanged = nodesToUnselect.length > 0;
    if (selectionChanged) {
      this.selectionService.setNodesSelected({
        newValue: false,
        nodes: nodesToUnselect,
        suppressFinishActions: true,
        source
      });
    }
    this.selectionService.updateGroupsFromChildrenSelections(source);
    if (selectionChanged) {
      const event = {
        type: import_core.Events.EVENT_SELECTION_CHANGED,
        source
      };
      this.eventService.dispatchEvent(event);
    }
  }
  executeAdd(rowDataTran, rowNodeTransaction) {
    var _a;
    const { add, addIndex } = rowDataTran;
    if (import_core._.missingOrEmpty(add)) {
      return;
    }
    const newNodes = add.map((item) => this.createNode(item, this.rootNode, _ClientSideNodeManager.TOP_LEVEL));
    if (typeof addIndex === "number" && addIndex >= 0) {
      const { allLeafChildren } = this.rootNode;
      const len = allLeafChildren.length;
      let normalisedAddIndex = addIndex;
      const isTreeData = this.gridOptionsService.get("treeData");
      if (isTreeData && addIndex > 0 && len > 0) {
        for (let i = 0; i < len; i++) {
          if (((_a = allLeafChildren[i]) == null ? void 0 : _a.rowIndex) == addIndex - 1) {
            normalisedAddIndex = i + 1;
            break;
          }
        }
      }
      const nodesBeforeIndex = allLeafChildren.slice(0, normalisedAddIndex);
      const nodesAfterIndex = allLeafChildren.slice(normalisedAddIndex, allLeafChildren.length);
      this.rootNode.allLeafChildren = [...nodesBeforeIndex, ...newNodes, ...nodesAfterIndex];
    } else {
      this.rootNode.allLeafChildren = [...this.rootNode.allLeafChildren, ...newNodes];
    }
    if (this.rootNode.sibling) {
      this.rootNode.sibling.allLeafChildren = this.rootNode.allLeafChildren;
    }
    rowNodeTransaction.add = newNodes;
  }
  executeRemove(rowDataTran, rowNodeTransaction, nodesToUnselect) {
    const { remove } = rowDataTran;
    if (import_core._.missingOrEmpty(remove)) {
      return;
    }
    const rowIdsRemoved = {};
    remove.forEach((item) => {
      const rowNode = this.lookupRowNode(item);
      if (!rowNode) {
        return;
      }
      if (rowNode.isSelected()) {
        nodesToUnselect.push(rowNode);
      }
      rowNode.clearRowTopAndRowIndex();
      rowIdsRemoved[rowNode.id] = true;
      delete this.allNodesMap[rowNode.id];
      rowNodeTransaction.remove.push(rowNode);
    });
    this.rootNode.allLeafChildren = this.rootNode.allLeafChildren.filter((rowNode) => !rowIdsRemoved[rowNode.id]);
    if (this.rootNode.sibling) {
      this.rootNode.sibling.allLeafChildren = this.rootNode.allLeafChildren;
    }
  }
  executeUpdate(rowDataTran, rowNodeTransaction, nodesToUnselect) {
    const { update } = rowDataTran;
    if (import_core._.missingOrEmpty(update)) {
      return;
    }
    update.forEach((item) => {
      const rowNode = this.lookupRowNode(item);
      if (!rowNode) {
        return;
      }
      rowNode.updateData(item);
      if (!rowNode.selectable && rowNode.isSelected()) {
        nodesToUnselect.push(rowNode);
      }
      this.setMasterForRow(rowNode, item, _ClientSideNodeManager.TOP_LEVEL, false);
      rowNodeTransaction.update.push(rowNode);
    });
  }
  lookupRowNode(data) {
    const getRowIdFunc = this.gridOptionsService.getCallback("getRowId");
    let rowNode;
    if (getRowIdFunc) {
      const id = getRowIdFunc({ data, level: 0 });
      rowNode = this.allNodesMap[id];
      if (!rowNode) {
        console.error(`AG Grid: could not find row id=${id}, data item was not found for this id`);
        return null;
      }
    } else {
      rowNode = this.rootNode.allLeafChildren.find((node) => node.data === data);
      if (!rowNode) {
        console.error(`AG Grid: could not find data item as object was not found`, data);
        console.error(`Consider using getRowId to help the Grid find matching row data`);
        return null;
      }
    }
    return rowNode || null;
  }
  createNode(dataItem, parent, level) {
    const node = new import_core.RowNode(this.beans);
    node.group = false;
    this.setMasterForRow(node, dataItem, level, true);
    const suppressParentsInRowNodes = this.gridOptionsService.get("suppressParentsInRowNodes");
    if (parent && !suppressParentsInRowNodes) {
      node.parent = parent;
    }
    node.level = level;
    node.setDataAndId(dataItem, this.nextId.toString());
    if (this.allNodesMap[node.id]) {
      console.warn(`AG Grid: duplicate node id '${node.id}' detected from getRowId callback, this could cause issues in your grid.`);
    }
    this.allNodesMap[node.id] = node;
    this.nextId++;
    return node;
  }
  setMasterForRow(rowNode, data, level, setExpanded) {
    const isTreeData = this.gridOptionsService.get("treeData");
    if (isTreeData) {
      rowNode.setMaster(false);
      if (setExpanded) {
        rowNode.expanded = false;
      }
    } else {
      const masterDetail = this.gridOptionsService.get("masterDetail");
      if (masterDetail) {
        const isRowMasterFunc = this.gridOptionsService.get("isRowMaster");
        if (isRowMasterFunc) {
          rowNode.setMaster(isRowMasterFunc(data));
        } else {
          rowNode.setMaster(true);
        }
      } else {
        rowNode.setMaster(false);
      }
      if (setExpanded) {
        const rowGroupColumns = this.columnModel.getRowGroupColumns();
        const numRowGroupColumns = rowGroupColumns ? rowGroupColumns.length : 0;
        const masterRowLevel = level + numRowGroupColumns;
        rowNode.expanded = rowNode.master ? this.isExpanded(masterRowLevel) : false;
      }
    }
  }
  isExpanded(level) {
    const expandByDefault = this.gridOptionsService.get("groupDefaultExpanded");
    if (expandByDefault === -1) {
      return true;
    }
    return level < expandByDefault;
  }
};
_ClientSideNodeManager.TOP_LEVEL = 0;
_ClientSideNodeManager.ROOT_NODE_ID = "ROOT_NODE_ID";
var ClientSideNodeManager = _ClientSideNodeManager;

// community-modules/client-side-row-model/src/clientSideRowModel/clientSideRowModel.ts
var ClientSideRowModel = class extends import_core2.BeanStub {
  constructor() {
    super(...arguments);
    this.onRowHeightChanged_debounced = import_core2._.debounce(this.onRowHeightChanged.bind(this), 100);
    this.rowsToDisplay = [];
    /** Has the start method been called */
    this.hasStarted = false;
    /** E.g. data has been set into the node manager already */
    this.shouldSkipSettingDataOnStart = false;
    /**
     * This is to prevent refresh model being called when it's already being called.
     * E.g. the group stage can trigger initial state filter model to be applied. This fires onFilterChanged,
     * which then triggers the listener here that calls refresh model again but at the filter stage
     * (which is about to be run by the original call).
     */
    this.isRefreshingModel = false;
    this.rowCountReady = false;
  }
  init() {
    const refreshEverythingFunc = this.refreshModel.bind(this, { step: import_core2.ClientSideRowModelSteps.EVERYTHING });
    const animate = !this.gridOptionsService.get("suppressAnimationFrame");
    const refreshEverythingAfterColsChangedFunc = this.refreshModel.bind(this, {
      step: import_core2.ClientSideRowModelSteps.EVERYTHING,
      // after cols change, row grouping (the first stage) could of changed
      afterColumnsChanged: true,
      keepRenderedRows: true,
      // we want animations cos sorting or filtering could be applied
      animate
    });
    this.addManagedListener(this.eventService, import_core2.Events.EVENT_NEW_COLUMNS_LOADED, refreshEverythingAfterColsChangedFunc);
    this.addManagedListener(this.eventService, import_core2.Events.EVENT_COLUMN_ROW_GROUP_CHANGED, refreshEverythingFunc);
    this.addManagedListener(this.eventService, import_core2.Events.EVENT_COLUMN_VALUE_CHANGED, this.onValueChanged.bind(this));
    this.addManagedListener(this.eventService, import_core2.Events.EVENT_COLUMN_PIVOT_CHANGED, this.refreshModel.bind(this, { step: import_core2.ClientSideRowModelSteps.PIVOT }));
    this.addManagedListener(this.eventService, import_core2.Events.EVENT_FILTER_CHANGED, this.onFilterChanged.bind(this));
    this.addManagedListener(this.eventService, import_core2.Events.EVENT_SORT_CHANGED, this.onSortChanged.bind(this));
    this.addManagedListener(this.eventService, import_core2.Events.EVENT_COLUMN_PIVOT_MODE_CHANGED, refreshEverythingFunc);
    this.addManagedListener(this.eventService, import_core2.Events.EVENT_GRID_STYLES_CHANGED, this.onGridStylesChanges.bind(this));
    this.addManagedListener(this.eventService, import_core2.Events.EVENT_GRID_READY, () => this.onGridReady());
    this.addPropertyListeners();
    this.rootNode = new import_core2.RowNode(this.beans);
    this.nodeManager = new ClientSideNodeManager(
      this.rootNode,
      this.gridOptionsService,
      this.eventService,
      this.columnModel,
      this.selectionService,
      this.beans
    );
  }
  addPropertyListeners() {
    const resetProps = /* @__PURE__ */ new Set([
      "treeData",
      "masterDetail"
    ]);
    const groupStageRefreshProps = /* @__PURE__ */ new Set([
      "suppressParentsInRowNodes",
      "groupDefaultExpanded",
      "groupAllowUnbalanced",
      "initialGroupOrderComparator",
      "groupHideOpenParents",
      "groupDisplayType"
    ]);
    const filterStageRefreshProps = /* @__PURE__ */ new Set([
      "excludeChildrenWhenTreeDataFiltering"
    ]);
    const pivotStageRefreshProps = /* @__PURE__ */ new Set([
      "removePivotHeaderRowWhenSingleValueColumn",
      "pivotRowTotals",
      "pivotColumnGroupTotals",
      "suppressExpandablePivotGroups"
    ]);
    const aggregateStageRefreshProps = /* @__PURE__ */ new Set([
      "getGroupRowAgg",
      "alwaysAggregateAtRootLevel",
      "groupIncludeTotalFooter",
      "suppressAggFilteredOnly"
    ]);
    const sortStageRefreshProps = /* @__PURE__ */ new Set([
      "postSortRows",
      "groupDisplayType",
      "accentedSort"
    ]);
    const filterAggStageRefreshProps = /* @__PURE__ */ new Set([]);
    const flattenStageRefreshProps = /* @__PURE__ */ new Set([
      "groupRemoveSingleChildren",
      "groupRemoveLowestSingleChildren",
      "groupIncludeFooter"
    ]);
    const allProps = [
      ...resetProps,
      ...groupStageRefreshProps,
      ...filterStageRefreshProps,
      ...pivotStageRefreshProps,
      ...pivotStageRefreshProps,
      ...aggregateStageRefreshProps,
      ...sortStageRefreshProps,
      ...filterAggStageRefreshProps,
      ...flattenStageRefreshProps
    ];
    this.addManagedPropertyListeners(allProps, (params) => {
      var _a;
      const properties = (_a = params.changeSet) == null ? void 0 : _a.properties;
      if (!properties) {
        return;
      }
      ;
      const arePropertiesImpacted = (propSet) => properties.some((prop) => propSet.has(prop));
      if (arePropertiesImpacted(resetProps)) {
        this.setRowData(this.rootNode.allLeafChildren.map((child) => child.data));
        return;
      }
      if (arePropertiesImpacted(groupStageRefreshProps)) {
        this.refreshModel({ step: import_core2.ClientSideRowModelSteps.EVERYTHING });
        return;
      }
      if (arePropertiesImpacted(filterStageRefreshProps)) {
        this.refreshModel({ step: import_core2.ClientSideRowModelSteps.FILTER });
        return;
      }
      if (arePropertiesImpacted(pivotStageRefreshProps)) {
        this.refreshModel({ step: import_core2.ClientSideRowModelSteps.PIVOT });
        return;
      }
      if (arePropertiesImpacted(aggregateStageRefreshProps)) {
        this.refreshModel({ step: import_core2.ClientSideRowModelSteps.AGGREGATE });
        return;
      }
      if (arePropertiesImpacted(sortStageRefreshProps)) {
        this.refreshModel({ step: import_core2.ClientSideRowModelSteps.SORT });
        return;
      }
      if (arePropertiesImpacted(filterAggStageRefreshProps)) {
        this.refreshModel({ step: import_core2.ClientSideRowModelSteps.FILTER_AGGREGATES });
        return;
      }
      if (arePropertiesImpacted(flattenStageRefreshProps)) {
        this.refreshModel({ step: import_core2.ClientSideRowModelSteps.MAP });
      }
    });
    this.addManagedPropertyListener("rowHeight", () => this.resetRowHeights());
  }
  start() {
    this.hasStarted = true;
    if (this.shouldSkipSettingDataOnStart) {
      this.dispatchUpdateEventsAndRefresh();
    } else {
      this.setInitialData();
    }
  }
  setInitialData() {
    const rowData = this.gridOptionsService.get("rowData");
    if (rowData) {
      this.shouldSkipSettingDataOnStart = true;
      this.setRowData(rowData);
    }
  }
  ensureRowHeightsValid(startPixel, endPixel, startLimitIndex, endLimitIndex) {
    let atLeastOneChange;
    let res = false;
    do {
      atLeastOneChange = false;
      const rowAtStartPixel = this.getRowIndexAtPixel(startPixel);
      const rowAtEndPixel = this.getRowIndexAtPixel(endPixel);
      const firstRow = Math.max(rowAtStartPixel, startLimitIndex);
      const lastRow = Math.min(rowAtEndPixel, endLimitIndex);
      for (let rowIndex = firstRow; rowIndex <= lastRow; rowIndex++) {
        const rowNode = this.getRow(rowIndex);
        if (rowNode.rowHeightEstimated) {
          const rowHeight = this.gridOptionsService.getRowHeightForNode(rowNode);
          rowNode.setRowHeight(rowHeight.height);
          atLeastOneChange = true;
          res = true;
        }
      }
      if (atLeastOneChange) {
        this.setRowTopAndRowIndex();
      }
    } while (atLeastOneChange);
    return res;
  }
  setRowTopAndRowIndex() {
    const defaultRowHeight = this.environment.getDefaultRowHeight();
    let nextRowTop = 0;
    const displayedRowsMapped = /* @__PURE__ */ new Set();
    const allowEstimate = this.gridOptionsService.isDomLayout("normal");
    for (let i = 0; i < this.rowsToDisplay.length; i++) {
      const rowNode = this.rowsToDisplay[i];
      if (rowNode.id != null) {
        displayedRowsMapped.add(rowNode.id);
      }
      if (rowNode.rowHeight == null) {
        const rowHeight = this.gridOptionsService.getRowHeightForNode(rowNode, allowEstimate, defaultRowHeight);
        rowNode.setRowHeight(rowHeight.height, rowHeight.estimated);
      }
      rowNode.setRowTop(nextRowTop);
      rowNode.setRowIndex(i);
      nextRowTop += rowNode.rowHeight;
    }
    return displayedRowsMapped;
  }
  clearRowTopAndRowIndex(changedPath, displayedRowsMapped) {
    const changedPathActive = changedPath.isActive();
    const clearIfNotDisplayed = (rowNode) => {
      if (rowNode && rowNode.id != null && !displayedRowsMapped.has(rowNode.id)) {
        rowNode.clearRowTopAndRowIndex();
      }
    };
    const recurse = (rowNode) => {
      clearIfNotDisplayed(rowNode);
      clearIfNotDisplayed(rowNode.detailNode);
      clearIfNotDisplayed(rowNode.sibling);
      if (rowNode.hasChildren()) {
        if (rowNode.childrenAfterGroup) {
          const isRootNode = rowNode.level == -1;
          const skipChildren = changedPathActive && !isRootNode && !rowNode.expanded;
          if (!skipChildren) {
            rowNode.childrenAfterGroup.forEach(recurse);
          }
        }
      }
    };
    recurse(this.rootNode);
  }
  // returns false if row was moved, otherwise true
  ensureRowsAtPixel(rowNodes, pixel, increment = 0) {
    const indexAtPixelNow = this.getRowIndexAtPixel(pixel);
    const rowNodeAtPixelNow = this.getRow(indexAtPixelNow);
    const animate = !this.gridOptionsService.get("suppressAnimationFrame");
    if (rowNodeAtPixelNow === rowNodes[0]) {
      return false;
    }
    rowNodes.forEach((rowNode) => {
      import_core2._.removeFromArray(this.rootNode.allLeafChildren, rowNode);
    });
    rowNodes.forEach((rowNode, idx) => {
      import_core2._.insertIntoArray(this.rootNode.allLeafChildren, rowNode, Math.max(indexAtPixelNow + increment, 0) + idx);
    });
    this.refreshModel({
      step: import_core2.ClientSideRowModelSteps.EVERYTHING,
      keepRenderedRows: true,
      keepEditingRows: true,
      animate
    });
    return true;
  }
  highlightRowAtPixel(rowNode, pixel) {
    const indexAtPixelNow = pixel != null ? this.getRowIndexAtPixel(pixel) : null;
    const rowNodeAtPixelNow = indexAtPixelNow != null ? this.getRow(indexAtPixelNow) : null;
    if (!rowNodeAtPixelNow || !rowNode || rowNodeAtPixelNow === rowNode || pixel == null) {
      if (this.lastHighlightedRow) {
        this.lastHighlightedRow.setHighlighted(null);
        this.lastHighlightedRow = null;
      }
      return;
    }
    const highlight = this.getHighlightPosition(pixel, rowNodeAtPixelNow);
    if (this.lastHighlightedRow && this.lastHighlightedRow !== rowNodeAtPixelNow) {
      this.lastHighlightedRow.setHighlighted(null);
      this.lastHighlightedRow = null;
    }
    rowNodeAtPixelNow.setHighlighted(highlight);
    this.lastHighlightedRow = rowNodeAtPixelNow;
  }
  getHighlightPosition(pixel, rowNode) {
    if (!rowNode) {
      const index = this.getRowIndexAtPixel(pixel);
      rowNode = this.getRow(index || 0);
      if (!rowNode) {
        return import_core2.RowHighlightPosition.Below;
      }
    }
    const { rowTop, rowHeight } = rowNode;
    return pixel - rowTop < rowHeight / 2 ? import_core2.RowHighlightPosition.Above : import_core2.RowHighlightPosition.Below;
  }
  getLastHighlightedRowNode() {
    return this.lastHighlightedRow;
  }
  isLastRowIndexKnown() {
    return true;
  }
  getRowCount() {
    if (this.rowsToDisplay) {
      return this.rowsToDisplay.length;
    }
    return 0;
  }
  getTopLevelRowCount() {
    const showingRootNode = this.rowsToDisplay && this.rowsToDisplay[0] === this.rootNode;
    if (showingRootNode) {
      return 1;
    }
    const filteredChildren = this.rootNode.childrenAfterAggFilter;
    return filteredChildren ? filteredChildren.length : 0;
  }
  getTopLevelRowDisplayedIndex(topLevelIndex) {
    const showingRootNode = this.rowsToDisplay && this.rowsToDisplay[0] === this.rootNode;
    if (showingRootNode) {
      return topLevelIndex;
    }
    let rowNode = this.rootNode.childrenAfterSort[topLevelIndex];
    if (this.gridOptionsService.get("groupHideOpenParents")) {
      while (rowNode.expanded && rowNode.childrenAfterSort && rowNode.childrenAfterSort.length > 0) {
        rowNode = rowNode.childrenAfterSort[0];
      }
    }
    return rowNode.rowIndex;
  }
  getRowBounds(index) {
    if (import_core2._.missing(this.rowsToDisplay)) {
      return null;
    }
    const rowNode = this.rowsToDisplay[index];
    if (rowNode) {
      return {
        rowTop: rowNode.rowTop,
        rowHeight: rowNode.rowHeight
      };
    }
    return null;
  }
  onRowGroupOpened() {
    const animate = this.gridOptionsService.isAnimateRows();
    this.refreshModel({ step: import_core2.ClientSideRowModelSteps.MAP, keepRenderedRows: true, animate });
  }
  onFilterChanged(event) {
    if (event.afterDataChange) {
      return;
    }
    const animate = this.gridOptionsService.isAnimateRows();
    const primaryOrQuickFilterChanged = event.columns.length === 0 || event.columns.some((col) => col.isPrimary());
    const step = primaryOrQuickFilterChanged ? import_core2.ClientSideRowModelSteps.FILTER : import_core2.ClientSideRowModelSteps.FILTER_AGGREGATES;
    this.refreshModel({ step, keepRenderedRows: true, animate });
  }
  onSortChanged() {
    const animate = this.gridOptionsService.isAnimateRows();
    this.refreshModel({ step: import_core2.ClientSideRowModelSteps.SORT, keepRenderedRows: true, animate, keepEditingRows: true });
  }
  getType() {
    return "clientSide";
  }
  onValueChanged() {
    if (this.columnModel.isPivotActive()) {
      this.refreshModel({ step: import_core2.ClientSideRowModelSteps.PIVOT });
    } else {
      this.refreshModel({ step: import_core2.ClientSideRowModelSteps.AGGREGATE });
    }
  }
  createChangePath(rowNodeTransactions) {
    const noTransactions = import_core2._.missingOrEmpty(rowNodeTransactions);
    const changedPath = new import_core2.ChangedPath(false, this.rootNode);
    if (noTransactions || this.gridOptionsService.get("treeData")) {
      changedPath.setInactive();
    }
    return changedPath;
  }
  isSuppressModelUpdateAfterUpdateTransaction(params) {
    if (!this.gridOptionsService.get("suppressModelUpdateAfterUpdateTransaction")) {
      return false;
    }
    if (params.rowNodeTransactions == null) {
      return false;
    }
    const transWithAddsOrDeletes = params.rowNodeTransactions.filter(
      (tx) => tx.add != null && tx.add.length > 0 || tx.remove != null && tx.remove.length > 0
    );
    const transactionsContainUpdatesOnly = transWithAddsOrDeletes == null || transWithAddsOrDeletes.length == 0;
    return transactionsContainUpdatesOnly;
  }
  buildRefreshModelParams(step) {
    let paramsStep = import_core2.ClientSideRowModelSteps.EVERYTHING;
    const stepsMapped = {
      everything: import_core2.ClientSideRowModelSteps.EVERYTHING,
      group: import_core2.ClientSideRowModelSteps.EVERYTHING,
      filter: import_core2.ClientSideRowModelSteps.FILTER,
      map: import_core2.ClientSideRowModelSteps.MAP,
      aggregate: import_core2.ClientSideRowModelSteps.AGGREGATE,
      sort: import_core2.ClientSideRowModelSteps.SORT,
      pivot: import_core2.ClientSideRowModelSteps.PIVOT
    };
    if (import_core2._.exists(step)) {
      paramsStep = stepsMapped[step];
    }
    if (import_core2._.missing(paramsStep)) {
      console.error(`AG Grid: invalid step ${step}, available steps are ${Object.keys(stepsMapped).join(", ")}`);
      return void 0;
    }
    const animate = !this.gridOptionsService.get("suppressAnimationFrame");
    const modelParams = {
      step: paramsStep,
      keepRenderedRows: true,
      keepEditingRows: true,
      animate
    };
    return modelParams;
  }
  refreshModel(paramsOrStep) {
    if (!this.hasStarted || this.isRefreshingModel || this.columnModel.shouldRowModelIgnoreRefresh()) {
      return;
    }
    let params = typeof paramsOrStep === "object" && "step" in paramsOrStep ? paramsOrStep : this.buildRefreshModelParams(paramsOrStep);
    if (!params) {
      return;
    }
    if (this.isSuppressModelUpdateAfterUpdateTransaction(params)) {
      return;
    }
    const changedPath = this.createChangePath(params.rowNodeTransactions);
    this.isRefreshingModel = true;
    switch (params.step) {
      case import_core2.ClientSideRowModelSteps.EVERYTHING:
        this.doRowGrouping(
          params.rowNodeTransactions,
          params.rowNodeOrder,
          changedPath,
          !!params.afterColumnsChanged
        );
      case import_core2.ClientSideRowModelSteps.FILTER:
        this.doFilter(changedPath);
      case import_core2.ClientSideRowModelSteps.PIVOT:
        this.doPivot(changedPath);
      case import_core2.ClientSideRowModelSteps.AGGREGATE:
        this.doAggregate(changedPath);
      case import_core2.ClientSideRowModelSteps.FILTER_AGGREGATES:
        this.doFilterAggregates(changedPath);
      case import_core2.ClientSideRowModelSteps.SORT:
        this.doSort(params.rowNodeTransactions, changedPath);
      case import_core2.ClientSideRowModelSteps.MAP:
        this.doRowsToDisplay();
    }
    const displayedNodesMapped = this.setRowTopAndRowIndex();
    this.clearRowTopAndRowIndex(changedPath, displayedNodesMapped);
    this.isRefreshingModel = false;
    const event = {
      type: import_core2.Events.EVENT_MODEL_UPDATED,
      animate: params.animate,
      keepRenderedRows: params.keepRenderedRows,
      newData: params.newData,
      newPage: false,
      keepUndoRedoStack: params.keepUndoRedoStack
    };
    this.eventService.dispatchEvent(event);
  }
  isEmpty() {
    const rowsMissing = import_core2._.missing(this.rootNode.allLeafChildren) || this.rootNode.allLeafChildren.length === 0;
    return import_core2._.missing(this.rootNode) || rowsMissing || !this.columnModel.isReady();
  }
  isRowsToRender() {
    return import_core2._.exists(this.rowsToDisplay) && this.rowsToDisplay.length > 0;
  }
  getNodesInRangeForSelection(firstInRange, lastInRange) {
    let started = !lastInRange;
    let finished = false;
    const result = [];
    const groupsSelectChildren = this.gridOptionsService.get("groupSelectsChildren");
    this.forEachNodeAfterFilterAndSort((rowNode) => {
      if (finished) {
        return;
      }
      if (started) {
        if (rowNode === lastInRange || rowNode === firstInRange) {
          finished = true;
          if (rowNode.group && groupsSelectChildren) {
            result.push(...rowNode.allLeafChildren);
            return;
          }
        }
      }
      if (!started) {
        if (rowNode !== lastInRange && rowNode !== firstInRange) {
          return;
        }
        started = true;
      }
      const includeThisNode = !rowNode.group || !groupsSelectChildren;
      if (includeThisNode) {
        result.push(rowNode);
        return;
      }
    });
    return result;
  }
  setDatasource(datasource) {
    console.error("AG Grid: should never call setDatasource on clientSideRowController");
  }
  getTopLevelNodes() {
    return this.rootNode ? this.rootNode.childrenAfterGroup : null;
  }
  getRootNode() {
    return this.rootNode;
  }
  getRow(index) {
    return this.rowsToDisplay[index];
  }
  isRowPresent(rowNode) {
    return this.rowsToDisplay.indexOf(rowNode) >= 0;
  }
  getRowIndexAtPixel(pixelToMatch) {
    if (this.isEmpty() || this.rowsToDisplay.length === 0) {
      return -1;
    }
    let bottomPointer = 0;
    let topPointer = this.rowsToDisplay.length - 1;
    if (pixelToMatch <= 0) {
      return 0;
    }
    const lastNode = import_core2._.last(this.rowsToDisplay);
    if (lastNode.rowTop <= pixelToMatch) {
      return this.rowsToDisplay.length - 1;
    }
    let oldBottomPointer = -1;
    let oldTopPointer = -1;
    while (true) {
      const midPointer = Math.floor((bottomPointer + topPointer) / 2);
      const currentRowNode = this.rowsToDisplay[midPointer];
      if (this.isRowInPixel(currentRowNode, pixelToMatch)) {
        return midPointer;
      }
      if (currentRowNode.rowTop < pixelToMatch) {
        bottomPointer = midPointer + 1;
      } else if (currentRowNode.rowTop > pixelToMatch) {
        topPointer = midPointer - 1;
      }
      const caughtInInfiniteLoop = oldBottomPointer === bottomPointer && oldTopPointer === topPointer;
      if (caughtInInfiniteLoop) {
        return midPointer;
      }
      oldBottomPointer = bottomPointer;
      oldTopPointer = topPointer;
    }
  }
  isRowInPixel(rowNode, pixelToMatch) {
    const topPixel = rowNode.rowTop;
    const bottomPixel = rowNode.rowTop + rowNode.rowHeight;
    const pixelInRow = topPixel <= pixelToMatch && bottomPixel > pixelToMatch;
    return pixelInRow;
  }
  forEachLeafNode(callback) {
    if (this.rootNode.allLeafChildren) {
      this.rootNode.allLeafChildren.forEach((rowNode, index) => callback(rowNode, index));
    }
  }
  forEachNode(callback, includeFooterNodes = false) {
    this.recursivelyWalkNodesAndCallback({
      nodes: [...this.rootNode.childrenAfterGroup || []],
      callback,
      recursionType: 0 /* Normal */,
      index: 0,
      includeFooterNodes
    });
  }
  forEachNodeAfterFilter(callback, includeFooterNodes = false) {
    this.recursivelyWalkNodesAndCallback({
      nodes: [...this.rootNode.childrenAfterAggFilter || []],
      callback,
      recursionType: 1 /* AfterFilter */,
      index: 0,
      includeFooterNodes
    });
  }
  forEachNodeAfterFilterAndSort(callback, includeFooterNodes = false) {
    this.recursivelyWalkNodesAndCallback({
      nodes: [...this.rootNode.childrenAfterSort || []],
      callback,
      recursionType: 2 /* AfterFilterAndSort */,
      index: 0,
      includeFooterNodes
    });
  }
  forEachPivotNode(callback, includeFooterNodes = false) {
    this.recursivelyWalkNodesAndCallback({
      nodes: [this.rootNode],
      callback,
      recursionType: 3 /* PivotNodes */,
      index: 0,
      includeFooterNodes
    });
  }
  // iterates through each item in memory, and calls the callback function
  // nodes - the rowNodes to traverse
  // callback - the user provided callback
  // recursion type - need this to know what child nodes to recurse, eg if looking at all nodes, or filtered notes etc
  // index - works similar to the index in forEach in javascript's array function
  recursivelyWalkNodesAndCallback(params) {
    var _a;
    const { nodes, callback, recursionType, includeFooterNodes } = params;
    let { index } = params;
    for (let i = 0; i < nodes.length; i++) {
      const node = nodes[i];
      callback(node, index++);
      if (node.hasChildren() && !node.footer) {
        let nodeChildren = null;
        switch (recursionType) {
          case 0 /* Normal */:
            nodeChildren = node.childrenAfterGroup;
            break;
          case 1 /* AfterFilter */:
            nodeChildren = node.childrenAfterAggFilter;
            break;
          case 2 /* AfterFilterAndSort */:
            nodeChildren = node.childrenAfterSort;
            break;
          case 3 /* PivotNodes */:
            nodeChildren = !node.leafGroup ? node.childrenAfterSort : null;
            break;
        }
        if (nodeChildren) {
          index = this.recursivelyWalkNodesAndCallback({
            nodes: [...nodeChildren],
            callback,
            recursionType,
            index,
            includeFooterNodes
          });
        }
      }
    }
    const parentNode = (_a = nodes[0]) == null ? void 0 : _a.parent;
    if (!includeFooterNodes || !parentNode)
      return index;
    const isRootNode = parentNode === this.rootNode;
    if (isRootNode) {
      const totalFooters = this.gridOptionsService.get("groupIncludeTotalFooter");
      if (!totalFooters)
        return index;
    } else {
      const isGroupIncludeFooter = this.gridOptionsService.getGroupIncludeFooter();
      if (!isGroupIncludeFooter({ node: parentNode }))
        return index;
    }
    parentNode.createFooter();
    callback(parentNode.sibling, index++);
    return index;
  }
  // it's possible to recompute the aggregate without doing the other parts
  // + api.refreshClientSideRowModel('aggregate')
  doAggregate(changedPath) {
    if (this.aggregationStage) {
      this.aggregationStage.execute({ rowNode: this.rootNode, changedPath });
    }
  }
  doFilterAggregates(changedPath) {
    if (this.filterAggregatesStage) {
      this.filterAggregatesStage.execute({ rowNode: this.rootNode, changedPath });
    } else {
      this.rootNode.childrenAfterAggFilter = this.rootNode.childrenAfterFilter;
    }
  }
  // + gridApi.expandAll()
  // + gridApi.collapseAll()
  expandOrCollapseAll(expand) {
    const usingTreeData = this.gridOptionsService.get("treeData");
    const usingPivotMode = this.columnModel.isPivotActive();
    const recursiveExpandOrCollapse = (rowNodes) => {
      if (!rowNodes) {
        return;
      }
      rowNodes.forEach((rowNode) => {
        const actionRow = () => {
          rowNode.expanded = expand;
          recursiveExpandOrCollapse(rowNode.childrenAfterGroup);
        };
        if (usingTreeData) {
          const hasChildren = import_core2._.exists(rowNode.childrenAfterGroup);
          if (hasChildren) {
            actionRow();
          }
          return;
        }
        if (usingPivotMode) {
          const notLeafGroup = !rowNode.leafGroup;
          if (notLeafGroup) {
            actionRow();
          }
          return;
        }
        const isRowGroup = rowNode.group;
        if (isRowGroup) {
          actionRow();
        }
      });
    };
    if (this.rootNode) {
      recursiveExpandOrCollapse(this.rootNode.childrenAfterGroup);
    }
    this.refreshModel({ step: import_core2.ClientSideRowModelSteps.MAP });
    const eventSource = expand ? "expandAll" : "collapseAll";
    const event = {
      type: import_core2.Events.EVENT_EXPAND_COLLAPSE_ALL,
      source: eventSource
    };
    this.eventService.dispatchEvent(event);
  }
  doSort(rowNodeTransactions, changedPath) {
    this.sortStage.execute({
      rowNode: this.rootNode,
      rowNodeTransactions,
      changedPath
    });
  }
  doRowGrouping(rowNodeTransactions, rowNodeOrder, changedPath, afterColumnsChanged) {
    if (this.groupStage) {
      if (rowNodeTransactions) {
        this.groupStage.execute({
          rowNode: this.rootNode,
          rowNodeTransactions,
          rowNodeOrder,
          changedPath
        });
      } else {
        this.groupStage.execute({
          rowNode: this.rootNode,
          changedPath,
          afterColumnsChanged
        });
      }
      if (this.gridOptionsService.get("groupSelectsChildren")) {
        const selectionChanged = this.selectionService.updateGroupsFromChildrenSelections("rowGroupChanged", changedPath);
        if (selectionChanged) {
          const event = {
            type: import_core2.Events.EVENT_SELECTION_CHANGED,
            source: "rowGroupChanged"
          };
          this.eventService.dispatchEvent(event);
        }
      }
    } else {
      this.rootNode.childrenAfterGroup = this.rootNode.allLeafChildren;
      if (this.rootNode.sibling) {
        this.rootNode.sibling.childrenAfterGroup = this.rootNode.childrenAfterGroup;
      }
      this.rootNode.updateHasChildren();
    }
    if (this.nodeManager.isRowCountReady()) {
      this.rowCountReady = true;
      this.eventService.dispatchEventOnce({
        type: import_core2.Events.EVENT_ROW_COUNT_READY
      });
    }
  }
  doFilter(changedPath) {
    this.filterStage.execute({ rowNode: this.rootNode, changedPath });
  }
  doPivot(changedPath) {
    if (this.pivotStage) {
      this.pivotStage.execute({ rowNode: this.rootNode, changedPath });
    }
  }
  getCopyOfNodesMap() {
    return this.nodeManager.getCopyOfNodesMap();
  }
  getRowNode(id) {
    const idIsGroup = typeof id == "string" && id.indexOf(import_core2.RowNode.ID_PREFIX_ROW_GROUP) == 0;
    if (idIsGroup) {
      let res = void 0;
      this.forEachNode((node) => {
        if (node.id === id) {
          res = node;
        }
      });
      return res;
    }
    return this.nodeManager.getRowNode(id);
  }
  // rows: the rows to put into the model
  setRowData(rowData) {
    this.selectionService.reset("rowDataChanged");
    this.nodeManager.setRowData(rowData);
    if (this.hasStarted) {
      this.dispatchUpdateEventsAndRefresh();
    }
  }
  dispatchUpdateEventsAndRefresh() {
    const rowDataUpdatedEvent = {
      type: import_core2.Events.EVENT_ROW_DATA_UPDATED
    };
    this.eventService.dispatchEvent(rowDataUpdatedEvent);
    this.refreshModel({
      step: import_core2.ClientSideRowModelSteps.EVERYTHING,
      newData: true
    });
  }
  batchUpdateRowData(rowDataTransaction, callback) {
    if (this.applyAsyncTransactionsTimeout == null) {
      this.rowDataTransactionBatch = [];
      const waitMillis = this.gridOptionsService.getAsyncTransactionWaitMillis();
      this.applyAsyncTransactionsTimeout = window.setTimeout(() => {
        this.executeBatchUpdateRowData();
      }, waitMillis);
    }
    this.rowDataTransactionBatch.push({ rowDataTransaction, callback });
  }
  flushAsyncTransactions() {
    if (this.applyAsyncTransactionsTimeout != null) {
      clearTimeout(this.applyAsyncTransactionsTimeout);
      this.executeBatchUpdateRowData();
    }
  }
  executeBatchUpdateRowData() {
    this.valueCache.onDataChanged();
    const callbackFuncsBound = [];
    const rowNodeTrans = [];
    let forceRowNodeOrder = false;
    if (this.rowDataTransactionBatch) {
      this.rowDataTransactionBatch.forEach((tranItem) => {
        const rowNodeTran = this.nodeManager.updateRowData(tranItem.rowDataTransaction, void 0);
        rowNodeTrans.push(rowNodeTran);
        if (tranItem.callback) {
          callbackFuncsBound.push(tranItem.callback.bind(null, rowNodeTran));
        }
        if (typeof tranItem.rowDataTransaction.addIndex === "number") {
          forceRowNodeOrder = true;
        }
      });
    }
    this.commonUpdateRowData(rowNodeTrans, void 0, forceRowNodeOrder);
    if (callbackFuncsBound.length > 0) {
      window.setTimeout(() => {
        callbackFuncsBound.forEach((func) => func());
      }, 0);
    }
    if (rowNodeTrans.length > 0) {
      const event = {
        type: import_core2.Events.EVENT_ASYNC_TRANSACTIONS_FLUSHED,
        results: rowNodeTrans
      };
      this.eventService.dispatchEvent(event);
    }
    this.rowDataTransactionBatch = null;
    this.applyAsyncTransactionsTimeout = void 0;
  }
  updateRowData(rowDataTran, rowNodeOrder) {
    this.valueCache.onDataChanged();
    const rowNodeTran = this.nodeManager.updateRowData(rowDataTran, rowNodeOrder);
    const forceRowNodeOrder = typeof rowDataTran.addIndex === "number";
    this.commonUpdateRowData([rowNodeTran], rowNodeOrder, forceRowNodeOrder);
    return rowNodeTran;
  }
  createRowNodeOrder() {
    const suppressSortOrder = this.gridOptionsService.get("suppressMaintainUnsortedOrder");
    if (suppressSortOrder) {
      return;
    }
    const orderMap = {};
    if (this.rootNode && this.rootNode.allLeafChildren) {
      for (let index = 0; index < this.rootNode.allLeafChildren.length; index++) {
        const node = this.rootNode.allLeafChildren[index];
        orderMap[node.id] = index;
      }
    }
    return orderMap;
  }
  // common to updateRowData and batchUpdateRowData
  commonUpdateRowData(rowNodeTrans, rowNodeOrder, forceRowNodeOrder) {
    if (!this.hasStarted) {
      return;
    }
    const animate = !this.gridOptionsService.get("suppressAnimationFrame");
    if (forceRowNodeOrder) {
      rowNodeOrder = this.createRowNodeOrder();
    }
    const event = {
      type: import_core2.Events.EVENT_ROW_DATA_UPDATED
    };
    this.eventService.dispatchEvent(event);
    this.refreshModel({
      step: import_core2.ClientSideRowModelSteps.EVERYTHING,
      rowNodeTransactions: rowNodeTrans,
      rowNodeOrder,
      keepRenderedRows: true,
      keepEditingRows: true,
      animate
    });
  }
  doRowsToDisplay() {
    this.rowsToDisplay = this.flattenStage.execute({ rowNode: this.rootNode });
  }
  onRowHeightChanged() {
    this.refreshModel({ step: import_core2.ClientSideRowModelSteps.MAP, keepRenderedRows: true, keepEditingRows: true, keepUndoRedoStack: true });
  }
  /** This method is debounced. It is used for row auto-height. If we don't debounce,
   * then the Row Models will end up recalculating each row position
   * for each row height change and result in the Row Renderer laying out rows.
   * This is particularly bad if using print layout, and showing eg 1,000 rows,
   * each row will change it's height, causing Row Model to update 1,000 times.
   */
  onRowHeightChangedDebounced() {
    this.onRowHeightChanged_debounced();
  }
  resetRowHeights() {
    const atLeastOne = this.resetRowHeightsForAllRowNodes();
    this.rootNode.setRowHeight(this.rootNode.rowHeight, true);
    if (this.rootNode.sibling) {
      this.rootNode.sibling.setRowHeight(this.rootNode.sibling.rowHeight, true);
    }
    if (atLeastOne) {
      this.onRowHeightChanged();
    }
  }
  resetRowHeightsForAllRowNodes() {
    let atLeastOne = false;
    this.forEachNode((rowNode) => {
      rowNode.setRowHeight(rowNode.rowHeight, true);
      const detailNode = rowNode.detailNode;
      if (detailNode) {
        detailNode.setRowHeight(detailNode.rowHeight, true);
      }
      if (rowNode.sibling) {
        rowNode.sibling.setRowHeight(rowNode.sibling.rowHeight, true);
      }
      atLeastOne = true;
    });
    return atLeastOne;
  }
  onGridStylesChanges() {
    if (this.columnModel.isAutoRowHeightActive()) {
      return;
    }
    this.resetRowHeights();
  }
  onGridReady() {
    if (this.hasStarted) {
      return;
    }
    this.setInitialData();
  }
  isRowDataLoaded() {
    return this.rowCountReady;
  }
};
__decorateClass([
  (0, import_core2.Autowired)("columnModel")
], ClientSideRowModel.prototype, "columnModel", 2);
__decorateClass([
  (0, import_core2.Autowired)("selectionService")
], ClientSideRowModel.prototype, "selectionService", 2);
__decorateClass([
  (0, import_core2.Autowired)("filterManager")
], ClientSideRowModel.prototype, "filterManager", 2);
__decorateClass([
  (0, import_core2.Autowired)("valueCache")
], ClientSideRowModel.prototype, "valueCache", 2);
__decorateClass([
  (0, import_core2.Autowired)("beans")
], ClientSideRowModel.prototype, "beans", 2);
__decorateClass([
  (0, import_core2.Autowired)("filterStage")
], ClientSideRowModel.prototype, "filterStage", 2);
__decorateClass([
  (0, import_core2.Autowired)("sortStage")
], ClientSideRowModel.prototype, "sortStage", 2);
__decorateClass([
  (0, import_core2.Autowired)("flattenStage")
], ClientSideRowModel.prototype, "flattenStage", 2);
__decorateClass([
  (0, import_core2.Optional)("groupStage")
], ClientSideRowModel.prototype, "groupStage", 2);
__decorateClass([
  (0, import_core2.Optional)("aggregationStage")
], ClientSideRowModel.prototype, "aggregationStage", 2);
__decorateClass([
  (0, import_core2.Optional)("pivotStage")
], ClientSideRowModel.prototype, "pivotStage", 2);
__decorateClass([
  (0, import_core2.Optional)("filterAggregatesStage")
], ClientSideRowModel.prototype, "filterAggregatesStage", 2);
__decorateClass([
  import_core2.PostConstruct
], ClientSideRowModel.prototype, "init", 1);
ClientSideRowModel = __decorateClass([
  (0, import_core2.Bean)("rowModel")
], ClientSideRowModel);

// community-modules/client-side-row-model/src/clientSideRowModel/filterStage.ts
var import_core3 = __webpack_require__(3423);
var FilterStage = class extends import_core3.BeanStub {
  execute(params) {
    const { changedPath } = params;
    this.filterService.filter(changedPath);
  }
};
__decorateClass([
  (0, import_core3.Autowired)("filterService")
], FilterStage.prototype, "filterService", 2);
FilterStage = __decorateClass([
  (0, import_core3.Bean)("filterStage")
], FilterStage);

// community-modules/client-side-row-model/src/clientSideRowModel/sortStage.ts
var import_core4 = __webpack_require__(3423);
var SortStage = class extends import_core4.BeanStub {
  execute(params) {
    const sortOptions = this.sortController.getSortOptions();
    const sortActive = import_core4._.exists(sortOptions) && sortOptions.length > 0;
    const deltaSort = sortActive && import_core4._.exists(params.rowNodeTransactions) && this.gridOptionsService.get("deltaSort");
    const sortContainsGroupColumns = sortOptions.some((opt) => {
      const isSortingCoupled = this.gridOptionsService.isColumnsSortingCoupledToGroup();
      if (isSortingCoupled) {
        return opt.column.isPrimary() && opt.column.isRowGroupActive();
      }
      return !!opt.column.getColDef().showRowGroup;
    });
    this.sortService.sort(sortOptions, sortActive, deltaSort, params.rowNodeTransactions, params.changedPath, sortContainsGroupColumns);
  }
};
__decorateClass([
  (0, import_core4.Autowired)("sortService")
], SortStage.prototype, "sortService", 2);
__decorateClass([
  (0, import_core4.Autowired)("sortController")
], SortStage.prototype, "sortController", 2);
SortStage = __decorateClass([
  (0, import_core4.Bean)("sortStage")
], SortStage);

// community-modules/client-side-row-model/src/clientSideRowModel/flattenStage.ts
var import_core5 = __webpack_require__(3423);
var FlattenStage = class extends import_core5.BeanStub {
  execute(params) {
    const rootNode = params.rowNode;
    const result = [];
    const skipLeafNodes = this.columnModel.isPivotMode();
    const showRootNode = skipLeafNodes && rootNode.leafGroup;
    const topList = showRootNode ? [rootNode] : rootNode.childrenAfterSort;
    const details = this.getFlattenDetails();
    this.recursivelyAddToRowsToDisplay(details, topList, result, skipLeafNodes, 0);
    const atLeastOneRowPresent = result.length > 0;
    const includeGroupTotalFooter = !showRootNode && atLeastOneRowPresent && details.groupIncludeTotalFooter;
    if (includeGroupTotalFooter) {
      rootNode.createFooter();
      this.addRowNodeToRowsToDisplay(details, rootNode.sibling, result, 0);
    }
    return result;
  }
  getFlattenDetails() {
    const groupRemoveSingleChildren = this.gridOptionsService.get("groupRemoveSingleChildren");
    const groupRemoveLowestSingleChildren = !groupRemoveSingleChildren && this.gridOptionsService.get("groupRemoveLowestSingleChildren");
    return {
      groupRemoveLowestSingleChildren,
      groupRemoveSingleChildren,
      isGroupMultiAutoColumn: this.gridOptionsService.isGroupMultiAutoColumn(),
      hideOpenParents: this.gridOptionsService.get("groupHideOpenParents"),
      groupIncludeTotalFooter: this.gridOptionsService.get("groupIncludeTotalFooter"),
      getGroupIncludeFooter: this.gridOptionsService.getGroupIncludeFooter()
    };
  }
  recursivelyAddToRowsToDisplay(details, rowsToFlatten, result, skipLeafNodes, uiLevel) {
    if (import_core5._.missingOrEmpty(rowsToFlatten)) {
      return;
    }
    for (let i = 0; i < rowsToFlatten.length; i++) {
      const rowNode = rowsToFlatten[i];
      const isParent = rowNode.hasChildren();
      const isSkippedLeafNode = skipLeafNodes && !isParent;
      const isRemovedSingleChildrenGroup = details.groupRemoveSingleChildren && isParent && rowNode.childrenAfterGroup.length === 1;
      const isRemovedLowestSingleChildrenGroup = details.groupRemoveLowestSingleChildren && isParent && rowNode.leafGroup && rowNode.childrenAfterGroup.length === 1;
      const neverAllowToExpand = skipLeafNodes && rowNode.leafGroup;
      const isHiddenOpenParent = details.hideOpenParents && rowNode.expanded && !rowNode.master && !neverAllowToExpand;
      const thisRowShouldBeRendered = !isSkippedLeafNode && !isHiddenOpenParent && !isRemovedSingleChildrenGroup && !isRemovedLowestSingleChildrenGroup;
      if (thisRowShouldBeRendered) {
        this.addRowNodeToRowsToDisplay(details, rowNode, result, uiLevel);
      }
      if (skipLeafNodes && rowNode.leafGroup) {
        continue;
      }
      if (isParent) {
        const excludedParent = isRemovedSingleChildrenGroup || isRemovedLowestSingleChildrenGroup;
        if (rowNode.expanded || excludedParent) {
          const uiLevelForChildren = excludedParent ? uiLevel : uiLevel + 1;
          this.recursivelyAddToRowsToDisplay(
            details,
            rowNode.childrenAfterSort,
            result,
            skipLeafNodes,
            uiLevelForChildren
          );
          const doesRowShowFooter = details.getGroupIncludeFooter({ node: rowNode });
          if (doesRowShowFooter) {
            rowNode.createFooter();
            this.addRowNodeToRowsToDisplay(details, rowNode.sibling, result, uiLevelForChildren);
          } else {
            rowNode.destroyFooter();
          }
        }
      } else if (rowNode.master && rowNode.expanded) {
        const detailNode = this.createDetailNode(rowNode);
        this.addRowNodeToRowsToDisplay(details, detailNode, result, uiLevel);
      }
    }
  }
  // duplicated method, it's also in floatingRowModel
  addRowNodeToRowsToDisplay(details, rowNode, result, uiLevel) {
    result.push(rowNode);
    rowNode.setUiLevel(details.isGroupMultiAutoColumn ? 0 : uiLevel);
  }
  createDetailNode(masterNode) {
    if (import_core5._.exists(masterNode.detailNode)) {
      return masterNode.detailNode;
    }
    const detailNode = new import_core5.RowNode(this.beans);
    detailNode.detail = true;
    detailNode.selectable = false;
    detailNode.parent = masterNode;
    if (import_core5._.exists(masterNode.id)) {
      detailNode.id = "detail_" + masterNode.id;
    }
    detailNode.data = masterNode.data;
    detailNode.level = masterNode.level + 1;
    masterNode.detailNode = detailNode;
    return detailNode;
  }
};
__decorateClass([
  (0, import_core5.Autowired)("columnModel")
], FlattenStage.prototype, "columnModel", 2);
__decorateClass([
  (0, import_core5.Autowired)("beans")
], FlattenStage.prototype, "beans", 2);
FlattenStage = __decorateClass([
  (0, import_core5.Bean)("flattenStage")
], FlattenStage);

// community-modules/client-side-row-model/src/clientSideRowModel/sortService.ts
var import_core6 = __webpack_require__(3423);
var SortService = class extends import_core6.BeanStub {
  sort(sortOptions, sortActive, useDeltaSort, rowNodeTransactions, changedPath, sortContainsGroupColumns) {
    const groupMaintainOrder = this.gridOptionsService.get("groupMaintainOrder");
    const groupColumnsPresent = this.columnModel.getAllGridColumns().some((c) => c.isRowGroupActive());
    let allDirtyNodes = {};
    if (useDeltaSort && rowNodeTransactions) {
      allDirtyNodes = this.calculateDirtyNodes(rowNodeTransactions);
    }
    const isPivotMode = this.columnModel.isPivotMode();
    const postSortFunc = this.gridOptionsService.getCallback("postSortRows");
    const callback = (rowNode) => {
      var _a;
      this.pullDownGroupDataForHideOpenParents(rowNode.childrenAfterAggFilter, true);
      const skipSortingPivotLeafs = isPivotMode && rowNode.leafGroup;
      let skipSortingGroups = groupMaintainOrder && groupColumnsPresent && !rowNode.leafGroup && !sortContainsGroupColumns;
      if (skipSortingGroups) {
        const nextGroup = (_a = this.columnModel.getRowGroupColumns()) == null ? void 0 : _a[rowNode.level + 1];
        const wasSortExplicitlyRemoved = (nextGroup == null ? void 0 : nextGroup.getSort()) === null;
        const childrenToBeSorted = rowNode.childrenAfterAggFilter.slice(0);
        if (rowNode.childrenAfterSort && !wasSortExplicitlyRemoved) {
          const indexedOrders = {};
          rowNode.childrenAfterSort.forEach((node, idx) => {
            indexedOrders[node.id] = idx;
          });
          childrenToBeSorted.sort((row1, row2) => {
            var _a2, _b;
            return ((_a2 = indexedOrders[row1.id]) != null ? _a2 : 0) - ((_b = indexedOrders[row2.id]) != null ? _b : 0);
          });
        }
        rowNode.childrenAfterSort = childrenToBeSorted;
      } else if (!sortActive || skipSortingPivotLeafs) {
        rowNode.childrenAfterSort = rowNode.childrenAfterAggFilter.slice(0);
      } else if (useDeltaSort) {
        rowNode.childrenAfterSort = this.doDeltaSort(rowNode, allDirtyNodes, changedPath, sortOptions);
      } else {
        rowNode.childrenAfterSort = this.rowNodeSorter.doFullSort(rowNode.childrenAfterAggFilter, sortOptions);
      }
      if (rowNode.sibling) {
        rowNode.sibling.childrenAfterSort = rowNode.childrenAfterSort;
      }
      this.updateChildIndexes(rowNode);
      if (postSortFunc) {
        const params = { nodes: rowNode.childrenAfterSort };
        postSortFunc(params);
      }
    };
    if (changedPath) {
      changedPath.forEachChangedNodeDepthFirst(callback);
    }
    this.updateGroupDataForHideOpenParents(changedPath);
  }
  calculateDirtyNodes(rowNodeTransactions) {
    const dirtyNodes = {};
    const addNodesFunc = (rowNodes) => {
      if (rowNodes) {
        rowNodes.forEach((rowNode) => dirtyNodes[rowNode.id] = true);
      }
    };
    if (rowNodeTransactions) {
      rowNodeTransactions.forEach((tran) => {
        addNodesFunc(tran.add);
        addNodesFunc(tran.update);
        addNodesFunc(tran.remove);
      });
    }
    return dirtyNodes;
  }
  doDeltaSort(rowNode, allTouchedNodes, changedPath, sortOptions) {
    const unsortedRows = rowNode.childrenAfterAggFilter;
    const oldSortedRows = rowNode.childrenAfterSort;
    if (!oldSortedRows) {
      return this.rowNodeSorter.doFullSort(unsortedRows, sortOptions);
    }
    const untouchedRowsMap = {};
    const touchedRows = [];
    unsortedRows.forEach((row) => {
      if (allTouchedNodes[row.id] || !changedPath.canSkip(row)) {
        touchedRows.push(row);
      } else {
        untouchedRowsMap[row.id] = true;
      }
    });
    const sortedUntouchedRows = oldSortedRows.filter((child) => untouchedRowsMap[child.id]);
    const mapNodeToSortedNode = (rowNode2, pos) => ({ currentPos: pos, rowNode: rowNode2 });
    const sortedChangedRows = touchedRows.map(mapNodeToSortedNode).sort((a, b) => this.rowNodeSorter.compareRowNodes(sortOptions, a, b));
    return this.mergeSortedArrays(
      sortOptions,
      sortedChangedRows,
      sortedUntouchedRows.map(mapNodeToSortedNode)
    ).map(({ rowNode: rowNode2 }) => rowNode2);
  }
  // Merge two sorted arrays into each other
  mergeSortedArrays(sortOptions, arr1, arr2) {
    const res = [];
    let i = 0;
    let j = 0;
    while (i < arr1.length && j < arr2.length) {
      const compareResult = this.rowNodeSorter.compareRowNodes(sortOptions, arr1[i], arr2[j]);
      if (compareResult < 0) {
        res.push(arr1[i++]);
      } else {
        res.push(arr2[j++]);
      }
    }
    while (i < arr1.length) {
      res.push(arr1[i++]);
    }
    while (j < arr2.length) {
      res.push(arr2[j++]);
    }
    return res;
  }
  updateChildIndexes(rowNode) {
    if (import_core6._.missing(rowNode.childrenAfterSort)) {
      return;
    }
    const listToSort = rowNode.childrenAfterSort;
    for (let i = 0; i < listToSort.length; i++) {
      const child = listToSort[i];
      const firstChild = i === 0;
      const lastChild = i === rowNode.childrenAfterSort.length - 1;
      child.setFirstChild(firstChild);
      child.setLastChild(lastChild);
      child.setChildIndex(i);
    }
  }
  updateGroupDataForHideOpenParents(changedPath) {
    if (!this.gridOptionsService.get("groupHideOpenParents")) {
      return;
    }
    if (this.gridOptionsService.get("treeData")) {
      import_core6._.warnOnce(`The property hideOpenParents dose not work with Tree Data. This is because Tree Data has values at the group level, it doesn't make sense to hide them.`);
      return false;
    }
    const callback = (rowNode) => {
      this.pullDownGroupDataForHideOpenParents(rowNode.childrenAfterSort, false);
      rowNode.childrenAfterSort.forEach((child) => {
        if (child.hasChildren()) {
          callback(child);
        }
      });
    };
    if (changedPath) {
      changedPath.executeFromRootNode((rowNode) => callback(rowNode));
    }
  }
  pullDownGroupDataForHideOpenParents(rowNodes, clearOperation) {
    if (!this.gridOptionsService.get("groupHideOpenParents") || import_core6._.missing(rowNodes)) {
      return;
    }
    rowNodes.forEach((childRowNode) => {
      const groupDisplayCols = this.columnModel.getGroupDisplayColumns();
      groupDisplayCols.forEach((groupDisplayCol) => {
        const showRowGroup = groupDisplayCol.getColDef().showRowGroup;
        if (typeof showRowGroup !== "string") {
          console.error("AG Grid: groupHideOpenParents only works when specifying specific columns for colDef.showRowGroup");
          return;
        }
        const displayingGroupKey = showRowGroup;
        const rowGroupColumn = this.columnModel.getPrimaryColumn(displayingGroupKey);
        const thisRowNodeMatches = rowGroupColumn === childRowNode.rowGroupColumn;
        if (thisRowNodeMatches) {
          return;
        }
        if (clearOperation) {
          childRowNode.setGroupValue(groupDisplayCol.getId(), void 0);
        } else {
          const parentToStealFrom = childRowNode.getFirstChildOfFirstChild(rowGroupColumn);
          if (parentToStealFrom) {
            childRowNode.setGroupValue(groupDisplayCol.getId(), parentToStealFrom.key);
          }
        }
      });
    });
  }
};
__decorateClass([
  (0, import_core6.Autowired)("columnModel")
], SortService.prototype, "columnModel", 2);
__decorateClass([
  (0, import_core6.Autowired)("rowNodeSorter")
], SortService.prototype, "rowNodeSorter", 2);
SortService = __decorateClass([
  (0, import_core6.Bean)("sortService")
], SortService);

// community-modules/client-side-row-model/src/clientSideRowModel/filterService.ts
var import_core7 = __webpack_require__(3423);
var FilterService = class extends import_core7.BeanStub {
  filter(changedPath) {
    const filterActive = this.filterManager.isChildFilterPresent();
    this.filterNodes(filterActive, changedPath);
  }
  filterNodes(filterActive, changedPath) {
    const filterCallback = (rowNode, includeChildNodes) => {
      if (rowNode.hasChildren()) {
        if (filterActive && !includeChildNodes) {
          rowNode.childrenAfterFilter = rowNode.childrenAfterGroup.filter((childNode) => {
            const passBecauseChildren = childNode.childrenAfterFilter && childNode.childrenAfterFilter.length > 0;
            const passBecauseDataPasses = childNode.data && this.filterManager.doesRowPassFilter({ rowNode: childNode });
            return passBecauseChildren || passBecauseDataPasses;
          });
        } else {
          rowNode.childrenAfterFilter = rowNode.childrenAfterGroup;
        }
      } else {
        rowNode.childrenAfterFilter = rowNode.childrenAfterGroup;
      }
      if (rowNode.sibling) {
        rowNode.sibling.childrenAfterFilter = rowNode.childrenAfterFilter;
      }
    };
    if (this.doingTreeDataFiltering()) {
      const treeDataDepthFirstFilter = (rowNode, alreadyFoundInParent) => {
        if (rowNode.childrenAfterGroup) {
          for (let i = 0; i < rowNode.childrenAfterGroup.length; i++) {
            const childNode = rowNode.childrenAfterGroup[i];
            const foundInParent = alreadyFoundInParent || this.filterManager.doesRowPassFilter({ rowNode: childNode });
            if (childNode.childrenAfterGroup) {
              treeDataDepthFirstFilter(rowNode.childrenAfterGroup[i], foundInParent);
            } else {
              filterCallback(childNode, foundInParent);
            }
          }
        }
        filterCallback(rowNode, alreadyFoundInParent);
      };
      const treeDataFilterCallback = (rowNode) => treeDataDepthFirstFilter(rowNode, false);
      changedPath.executeFromRootNode(treeDataFilterCallback);
    } else {
      const defaultFilterCallback = (rowNode) => filterCallback(rowNode, false);
      changedPath.forEachChangedNodeDepthFirst(defaultFilterCallback, true);
    }
  }
  doingTreeDataFiltering() {
    return this.gridOptionsService.get("treeData") && !this.gridOptionsService.get("excludeChildrenWhenTreeDataFiltering");
  }
};
__decorateClass([
  (0, import_core7.Autowired)("filterManager")
], FilterService.prototype, "filterManager", 2);
FilterService = __decorateClass([
  (0, import_core7.Bean)("filterService")
], FilterService);

// community-modules/client-side-row-model/src/clientSideRowModel/immutableService.ts
var import_core8 = __webpack_require__(3423);
var ImmutableService = class extends import_core8.BeanStub {
  postConstruct() {
    if (this.rowModel.getType() === "clientSide") {
      this.clientSideRowModel = this.rowModel;
      this.addManagedPropertyListener("rowData", () => this.onRowDataUpdated());
    }
  }
  isActive() {
    const getRowIdProvided = this.gridOptionsService.exists("getRowId");
    const resetRowDataOnUpdate = this.gridOptionsService.get("resetRowDataOnUpdate");
    if (resetRowDataOnUpdate) {
      return false;
    }
    return getRowIdProvided;
  }
  setRowData(rowData) {
    const transactionAndMap = this.createTransactionForRowData(rowData);
    if (!transactionAndMap) {
      return;
    }
    const [transaction, orderIdMap] = transactionAndMap;
    this.clientSideRowModel.updateRowData(transaction, orderIdMap);
  }
  // converts the setRowData() command to a transaction
  createTransactionForRowData(rowData) {
    if (import_core8._.missing(this.clientSideRowModel)) {
      console.error("AG Grid: ImmutableService only works with ClientSideRowModel");
      return;
    }
    const getRowIdFunc = this.gridOptionsService.getCallback("getRowId");
    if (getRowIdFunc == null) {
      console.error("AG Grid: ImmutableService requires getRowId() callback to be implemented, your row data needs IDs!");
      return;
    }
    const transaction = {
      remove: [],
      update: [],
      add: []
    };
    const existingNodesMap = this.clientSideRowModel.getCopyOfNodesMap();
    const suppressSortOrder = this.gridOptionsService.get("suppressMaintainUnsortedOrder");
    const orderMap = suppressSortOrder ? void 0 : {};
    if (import_core8._.exists(rowData)) {
      rowData.forEach((data, index) => {
        const id = getRowIdFunc({ data, level: 0 });
        const existingNode = existingNodesMap[id];
        if (orderMap) {
          orderMap[id] = index;
        }
        if (existingNode) {
          const dataHasChanged = existingNode.data !== data;
          if (dataHasChanged) {
            transaction.update.push(data);
          }
          existingNodesMap[id] = void 0;
        } else {
          transaction.add.push(data);
        }
      });
    }
    import_core8._.iterateObject(existingNodesMap, (id, rowNode) => {
      if (rowNode) {
        transaction.remove.push(rowNode.data);
      }
    });
    return [transaction, orderMap];
  }
  onRowDataUpdated() {
    const rowData = this.gridOptionsService.get("rowData");
    if (!rowData) {
      return;
    }
    if (this.isActive()) {
      this.setRowData(rowData);
    } else {
      this.selectionService.reset("rowDataChanged");
      this.clientSideRowModel.setRowData(rowData);
    }
  }
};
__decorateClass([
  (0, import_core8.Autowired)("rowModel")
], ImmutableService.prototype, "rowModel", 2);
__decorateClass([
  (0, import_core8.Autowired)("rowRenderer")
], ImmutableService.prototype, "rowRenderer", 2);
__decorateClass([
  (0, import_core8.Autowired)("selectionService")
], ImmutableService.prototype, "selectionService", 2);
__decorateClass([
  import_core8.PostConstruct
], ImmutableService.prototype, "postConstruct", 1);
ImmutableService = __decorateClass([
  (0, import_core8.Bean)("immutableService")
], ImmutableService);

// community-modules/client-side-row-model/src/version.ts
var VERSION = "31.2.0";

// community-modules/client-side-row-model/src/clientSideRowModelModule.ts
var ClientSideRowModelModule = {
  version: VERSION,
  moduleName: import_core9.ModuleNames.ClientSideRowModelModule,
  rowModel: "clientSide",
  beans: [ClientSideRowModel, FilterStage, SortStage, FlattenStage, SortService, FilterService, ImmutableService]
};


/***/ }),

/***/ 3423:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp(target, key, result);
  return result;
};
var __decorateParam = (index, decorator) => (target, key) => decorator(target, key, index);

// community-modules/core/src/main.ts
var main_exports = {};
__export(main_exports, {
  ALWAYS_SYNC_GLOBAL_EVENTS: () => ALWAYS_SYNC_GLOBAL_EVENTS,
  AbstractHeaderCellCtrl: () => AbstractHeaderCellCtrl,
  AgAbstractField: () => AgAbstractField,
  AgAbstractLabel: () => AgAbstractLabel,
  AgAutocomplete: () => AgAutocomplete,
  AgCheckbox: () => AgCheckbox,
  AgDialog: () => AgDialog,
  AgGroupComponent: () => AgGroupComponent,
  AgInputDateField: () => AgInputDateField,
  AgInputNumberField: () => AgInputNumberField,
  AgInputRange: () => AgInputRange,
  AgInputTextArea: () => AgInputTextArea,
  AgInputTextField: () => AgInputTextField,
  AgMenuItemComponent: () => AgMenuItemComponent,
  AgMenuItemRenderer: () => AgMenuItemRenderer,
  AgMenuList: () => AgMenuList,
  AgMenuPanel: () => AgMenuPanel,
  AgPanel: () => AgPanel,
  AgPickerField: () => AgPickerField,
  AgPromise: () => AgPromise,
  AgPromiseStatus: () => AgPromiseStatus,
  AgRadioButton: () => AgRadioButton,
  AgRichSelect: () => AgRichSelect,
  AgSelect: () => AgSelect,
  AgSlider: () => AgSlider,
  AgStackComponentsRegistry: () => AgStackComponentsRegistry,
  AgToggleButton: () => AgToggleButton,
  AlignedGridsService: () => AlignedGridsService,
  AnimateShowChangeCellRenderer: () => AnimateShowChangeCellRenderer,
  AnimateSlideCellRenderer: () => AnimateSlideCellRenderer,
  AnimationFrameService: () => AnimationFrameService,
  AutoScrollService: () => AutoScrollService,
  AutoWidthCalculator: () => AutoWidthCalculator,
  Autowired: () => Autowired,
  BarColumnLabelPlacement: () => BarColumnLabelPlacement,
  BaseComponentWrapper: () => BaseComponentWrapper,
  Bean: () => Bean,
  BeanStub: () => BeanStub,
  Beans: () => Beans,
  BodyDropPivotTarget: () => BodyDropPivotTarget,
  BodyDropTarget: () => BodyDropTarget,
  CellComp: () => CellComp,
  CellCtrl: () => CellCtrl,
  CellNavigationService: () => CellNavigationService,
  CellPositionUtils: () => CellPositionUtils,
  CellRangeType: () => CellRangeType,
  ChangedPath: () => ChangedPath,
  CheckboxCellEditor: () => CheckboxCellEditor,
  CheckboxCellRenderer: () => CheckboxCellRenderer,
  CheckboxSelectionComponent: () => CheckboxSelectionComponent,
  ClientSideRowModelSteps: () => ClientSideRowModelSteps,
  ColDefUtil: () => ColDefUtil,
  Column: () => Column,
  ColumnApi: () => ColumnApi,
  ColumnFactory: () => ColumnFactory,
  ColumnGroup: () => ColumnGroup,
  ColumnKeyCreator: () => ColumnKeyCreator,
  ColumnModel: () => ColumnModel,
  ColumnUtils: () => ColumnUtils,
  Component: () => Component,
  ComponentUtil: () => ComponentUtil,
  Context: () => Context,
  CssClassApplier: () => CssClassApplier,
  CssClassManager: () => CssClassManager,
  CtrlsService: () => CtrlsService,
  DataTypeService: () => DataTypeService,
  DateCellEditor: () => DateCellEditor,
  DateFilter: () => DateFilter,
  DateStringCellEditor: () => DateStringCellEditor,
  DisplayedGroupCreator: () => DisplayedGroupCreator,
  DragAndDropService: () => DragAndDropService,
  DragService: () => DragService,
  DragSourceType: () => DragSourceType,
  Environment: () => Environment,
  EventService: () => EventService,
  Events: () => Events,
  ExcelFactoryMode: () => ExcelFactoryMode,
  ExpansionService: () => ExpansionService,
  ExpressionService: () => ExpressionService,
  FilterManager: () => FilterManager,
  FloatingFilterMapper: () => FloatingFilterMapper,
  FocusService: () => FocusService,
  GROUP_AUTO_COLUMN_ID: () => GROUP_AUTO_COLUMN_ID,
  Grid: () => Grid,
  GridApi: () => GridApi,
  GridBodyComp: () => GridBodyComp,
  GridBodyCtrl: () => GridBodyCtrl,
  GridComp: () => GridComp,
  GridCoreCreator: () => GridCoreCreator,
  GridCtrl: () => GridCtrl,
  GridHeaderComp: () => GridHeaderComp,
  GridHeaderCtrl: () => GridHeaderCtrl,
  GridOptionsService: () => GridOptionsService,
  GroupCellRenderer: () => GroupCellRenderer,
  GroupCellRendererCtrl: () => GroupCellRendererCtrl,
  GroupInstanceIdCreator: () => GroupInstanceIdCreator,
  HeaderCellCtrl: () => HeaderCellCtrl,
  HeaderFilterCellComp: () => HeaderFilterCellComp,
  HeaderFilterCellCtrl: () => HeaderFilterCellCtrl,
  HeaderGroupCellCtrl: () => HeaderGroupCellCtrl,
  HeaderNavigationDirection: () => HeaderNavigationDirection,
  HeaderNavigationService: () => HeaderNavigationService,
  HeaderPositionUtils: () => HeaderPositionUtils,
  HeaderRowComp: () => HeaderRowComp,
  HeaderRowContainerComp: () => HeaderRowContainerComp,
  HeaderRowContainerCtrl: () => HeaderRowContainerCtrl,
  HeaderRowCtrl: () => HeaderRowCtrl,
  HeaderRowType: () => HeaderRowType,
  HorizontalDirection: () => HorizontalDirection,
  HorizontalResizeService: () => HorizontalResizeService,
  KeyCode: () => KeyCode,
  LargeTextCellEditor: () => LargeTextCellEditor,
  LayoutCssClasses: () => LayoutCssClasses,
  LocaleService: () => LocaleService,
  Logger: () => Logger,
  LoggerFactory: () => LoggerFactory,
  ManagedFocusFeature: () => ManagedFocusFeature,
  MenuService: () => MenuService,
  ModuleNames: () => ModuleNames,
  ModuleRegistry: () => ModuleRegistry,
  MouseEventService: () => MouseEventService,
  MoveColumnFeature: () => MoveColumnFeature,
  NavigationService: () => NavigationService,
  NumberCellEditor: () => NumberCellEditor,
  NumberFilter: () => NumberFilter,
  NumberSequence: () => NumberSequence,
  Optional: () => Optional,
  PaginationProxy: () => PaginationProxy,
  PillDragComp: () => PillDragComp,
  PillDropZonePanel: () => PillDropZonePanel,
  PinnedRowModel: () => PinnedRowModel,
  PopupComponent: () => PopupComponent,
  PopupEditorWrapper: () => PopupEditorWrapper,
  PopupService: () => PopupService,
  PositionableFeature: () => PositionableFeature,
  PostConstruct: () => PostConstruct,
  PreConstruct: () => PreConstruct,
  PreDestroy: () => PreDestroy,
  PropertyKeys: () => PropertyKeys,
  ProvidedColumnGroup: () => ProvidedColumnGroup,
  ProvidedFilter: () => ProvidedFilter,
  Qualifier: () => Qualifier,
  QuerySelector: () => QuerySelector,
  RefSelector: () => RefSelector,
  ResizeObserverService: () => ResizeObserverService,
  RowAnimationCssClasses: () => RowAnimationCssClasses,
  RowContainerComp: () => RowContainerComp,
  RowContainerCtrl: () => RowContainerCtrl,
  RowContainerName: () => RowContainerName,
  RowContainerType: () => RowContainerType,
  RowCtrl: () => RowCtrl,
  RowHighlightPosition: () => RowHighlightPosition,
  RowNode: () => RowNode,
  RowNodeBlock: () => RowNodeBlock,
  RowNodeBlockLoader: () => RowNodeBlockLoader,
  RowNodeSorter: () => RowNodeSorter,
  RowPositionUtils: () => RowPositionUtils,
  RowRenderer: () => RowRenderer,
  ScalarFilter: () => ScalarFilter,
  ScrollVisibleService: () => ScrollVisibleService,
  SelectCellEditor: () => SelectCellEditor,
  SelectableService: () => SelectableService,
  SelectionHandleType: () => SelectionHandleType,
  ServerSideTransactionResultStatus: () => ServerSideTransactionResultStatus,
  SetLeftFeature: () => SetLeftFeature,
  SimpleFilter: () => SimpleFilter,
  SortController: () => SortController,
  SortIndicatorComp: () => SortIndicatorComp,
  StandardMenuFactory: () => StandardMenuFactory,
  StylingService: () => StylingService,
  TabGuardClassNames: () => TabGuardClassNames,
  TabGuardComp: () => TabGuardComp,
  TabGuardCtrl: () => TabGuardCtrl,
  TabbedLayout: () => TabbedLayout,
  TemplateService: () => TemplateService,
  TextCellEditor: () => TextCellEditor,
  TextFilter: () => TextFilter,
  TextFloatingFilter: () => TextFloatingFilter,
  Timer: () => Timer,
  TooltipFeature: () => TooltipFeature,
  TooltipStateManager: () => TooltipStateManager,
  TouchListener: () => TouchListener,
  UserComponentFactory: () => UserComponentFactory,
  UserComponentRegistry: () => UserComponentRegistry,
  ValueCache: () => ValueCache,
  ValueFormatterService: () => ValueFormatterService,
  ValueParserService: () => ValueParserService,
  ValueService: () => ValueService,
  VanillaFrameworkOverrides: () => VanillaFrameworkOverrides,
  VerticalDirection: () => VerticalDirection,
  VirtualList: () => VirtualList,
  VirtualListDragFeature: () => VirtualListDragFeature,
  _: () => _,
  __FORCE_MODULE_DETECTION: () => __FORCE_MODULE_DETECTION,
  createGrid: () => createGrid,
  getRowContainerTypeForName: () => getRowContainerTypeForName
});
module.exports = __toCommonJS(main_exports);

// community-modules/core/src/utils/generic.ts
var generic_exports = {};
__export(generic_exports, {
  attrToBoolean: () => attrToBoolean,
  attrToNumber: () => attrToNumber,
  attrToString: () => attrToString,
  defaultComparator: () => defaultComparator,
  exists: () => exists,
  jsonEquals: () => jsonEquals,
  makeNull: () => makeNull,
  missing: () => missing,
  missingOrEmpty: () => missingOrEmpty,
  toStringOrNull: () => toStringOrNull,
  values: () => values
});
function makeNull(value) {
  if (value == null || value === "") {
    return null;
  }
  return value;
}
function exists(value, allowEmptyString = false) {
  return value != null && (value !== "" || allowEmptyString);
}
function missing(value) {
  return !exists(value);
}
function missingOrEmpty(value) {
  return value == null || value.length === 0;
}
function toStringOrNull(value) {
  return value != null && typeof value.toString === "function" ? value.toString() : null;
}
function attrToNumber(value) {
  if (value === void 0) {
    return;
  }
  if (value === null || value === "") {
    return null;
  }
  if (typeof value === "number") {
    return isNaN(value) ? void 0 : value;
  }
  const valueParsed = parseInt(value, 10);
  return isNaN(valueParsed) ? void 0 : valueParsed;
}
function attrToBoolean(value) {
  if (value === void 0) {
    return;
  }
  if (value === null || value === "") {
    return false;
  }
  if (typeof value === "boolean") {
    return value;
  }
  return /true/i.test(value);
}
function attrToString(value) {
  if (value == null || value === "") {
    return;
  }
  return value;
}
function jsonEquals(val1, val2) {
  const val1Json = val1 ? JSON.stringify(val1) : null;
  const val2Json = val2 ? JSON.stringify(val2) : null;
  return val1Json === val2Json;
}
function defaultComparator(valueA, valueB, accentedCompare = false) {
  const valueAMissing = valueA == null;
  const valueBMissing = valueB == null;
  if (valueA && valueA.toNumber) {
    valueA = valueA.toNumber();
  }
  if (valueB && valueB.toNumber) {
    valueB = valueB.toNumber();
  }
  if (valueAMissing && valueBMissing) {
    return 0;
  }
  if (valueAMissing) {
    return -1;
  }
  if (valueBMissing) {
    return 1;
  }
  function doQuickCompare(a, b) {
    return a > b ? 1 : a < b ? -1 : 0;
  }
  if (typeof valueA !== "string") {
    return doQuickCompare(valueA, valueB);
  }
  if (!accentedCompare) {
    return doQuickCompare(valueA, valueB);
  }
  try {
    return valueA.localeCompare(valueB);
  } catch (e) {
    return doQuickCompare(valueA, valueB);
  }
}
function values(object) {
  if (object instanceof Set || object instanceof Map) {
    const arr = [];
    object.forEach((value) => arr.push(value));
    return arr;
  }
  return Object.values(object);
}

// community-modules/core/src/columns/columnKeyCreator.ts
var ColumnKeyCreator = class {
  constructor() {
    this.existingKeys = {};
  }
  addExistingKeys(keys2) {
    for (let i = 0; i < keys2.length; i++) {
      this.existingKeys[keys2[i]] = true;
    }
  }
  getUniqueKey(colId, colField) {
    colId = toStringOrNull(colId);
    let count = 0;
    while (true) {
      let idToTry;
      if (colId) {
        idToTry = colId;
        if (count !== 0) {
          idToTry += "_" + count;
        }
      } else if (colField) {
        idToTry = colField;
        if (count !== 0) {
          idToTry += "_" + count;
        }
      } else {
        idToTry = count;
      }
      if (!this.existingKeys[idToTry]) {
        this.existingKeys[idToTry] = true;
        return String(idToTry);
      }
      count++;
    }
  }
};

// community-modules/core/src/utils/object.ts
var object_exports = {};
__export(object_exports, {
  cloneObject: () => cloneObject,
  deepCloneDefinition: () => deepCloneDefinition,
  getAllValuesInObject: () => getAllValuesInObject,
  getValueUsingField: () => getValueUsingField,
  isNonNullObject: () => isNonNullObject,
  iterateObject: () => iterateObject,
  mergeDeep: () => mergeDeep,
  removeAllReferences: () => removeAllReferences
});
function iterateObject(object, callback) {
  if (object == null) {
    return;
  }
  if (Array.isArray(object)) {
    for (let i = 0; i < object.length; i++) {
      callback(i.toString(), object[i]);
    }
    return;
  }
  for (const [key, value] of Object.entries(object)) {
    callback(key, value);
  }
}
function cloneObject(object) {
  const copy = {};
  const keys2 = Object.keys(object);
  for (let i = 0; i < keys2.length; i++) {
    const key = keys2[i];
    const value = object[key];
    copy[key] = value;
  }
  return copy;
}
function deepCloneDefinition(object, keysToSkip) {
  if (!object) {
    return;
  }
  const obj = object;
  const res = {};
  Object.keys(obj).forEach((key) => {
    if (keysToSkip && keysToSkip.indexOf(key) >= 0) {
      return;
    }
    const value = obj[key];
    const sourceIsSimpleObject = isNonNullObject(value) && value.constructor === Object;
    if (sourceIsSimpleObject) {
      res[key] = deepCloneDefinition(value);
    } else {
      res[key] = value;
    }
  });
  return res;
}
function getAllValuesInObject(obj) {
  if (!obj) {
    return [];
  }
  const anyObject = Object;
  if (typeof anyObject.values === "function") {
    return anyObject.values(obj);
  }
  const ret = [];
  for (const key in obj) {
    if (obj.hasOwnProperty(key) && obj.propertyIsEnumerable(key)) {
      ret.push(obj[key]);
    }
  }
  return ret;
}
function mergeDeep(dest, source, copyUndefined = true, makeCopyOfSimpleObjects = false) {
  if (!exists(source)) {
    return;
  }
  iterateObject(source, (key, sourceValue) => {
    let destValue = dest[key];
    if (destValue === sourceValue) {
      return;
    }
    if (makeCopyOfSimpleObjects) {
      const objectIsDueToBeCopied = destValue == null && sourceValue != null;
      if (objectIsDueToBeCopied) {
        const sourceIsSimpleObject = typeof sourceValue === "object" && sourceValue.constructor === Object;
        const dontCopy = sourceIsSimpleObject;
        if (dontCopy) {
          destValue = {};
          dest[key] = destValue;
        }
      }
    }
    if (isNonNullObject(sourceValue) && isNonNullObject(destValue) && !Array.isArray(destValue)) {
      mergeDeep(destValue, sourceValue, copyUndefined, makeCopyOfSimpleObjects);
    } else if (copyUndefined || sourceValue !== void 0) {
      dest[key] = sourceValue;
    }
  });
}
function getValueUsingField(data, field, fieldContainsDots) {
  if (!field || !data) {
    return;
  }
  if (!fieldContainsDots) {
    return data[field];
  }
  const fields = field.split(".");
  let currentObject = data;
  for (let i = 0; i < fields.length; i++) {
    if (currentObject == null) {
      return void 0;
    }
    currentObject = currentObject[fields[i]];
  }
  return currentObject;
}
function removeAllReferences(obj, preserveKeys = [], preDestroyLink) {
  Object.keys(obj).forEach((key) => {
    const value = obj[key];
    if (typeof value === "object" && !preserveKeys.includes(key)) {
      obj[key] = void 0;
    }
  });
  const proto = Object.getPrototypeOf(obj);
  const properties = {};
  const msgFunc = (key) => `AG Grid: Grid API function ${key}() cannot be called as the grid has been destroyed.
    It is recommended to remove local references to the grid api. Alternatively, check gridApi.isDestroyed() to avoid calling methods against a destroyed grid.
    To run logic when the grid is about to be destroyed use the gridPreDestroy event. See: ${preDestroyLink}`;
  Object.getOwnPropertyNames(proto).forEach((key) => {
    const value = proto[key];
    if (typeof value === "function" && !preserveKeys.includes(key)) {
      const func = () => {
        console.warn(msgFunc(key));
      };
      properties[key] = { value: func, writable: true };
    }
  });
  Object.defineProperties(obj, properties);
}
function isNonNullObject(value) {
  return typeof value === "object" && value !== null;
}

// community-modules/core/src/utils/function.ts
var function_exports = {};
__export(function_exports, {
  compose: () => compose,
  debounce: () => debounce,
  doOnce: () => doOnce,
  errorOnce: () => errorOnce,
  executeAfter: () => executeAfter,
  executeInAWhile: () => executeInAWhile,
  executeNextVMTurn: () => executeNextVMTurn,
  getFunctionName: () => getFunctionName,
  isFunction: () => isFunction,
  noop: () => noop,
  throttle: () => throttle,
  waitUntil: () => waitUntil,
  warnOnce: () => warnOnce
});
var doOnceFlags = {};
function doOnce(func, key) {
  if (doOnceFlags[key]) {
    return;
  }
  func();
  doOnceFlags[key] = true;
}
function warnOnce(msg) {
  doOnce(() => console.warn("AG Grid: " + msg), msg);
}
function errorOnce(msg) {
  doOnce(() => console.error("AG Grid: " + msg), msg);
}
function getFunctionName(funcConstructor) {
  if (funcConstructor.name) {
    return funcConstructor.name;
  }
  const matches = /function\s+([^\(]+)/.exec(funcConstructor.toString());
  return matches && matches.length === 2 ? matches[1].trim() : null;
}
function isFunction(val) {
  return !!(val && val.constructor && val.call && val.apply);
}
function executeInAWhile(funcs) {
  executeAfter(funcs, 400);
}
var executeNextVMTurnFuncs = [];
var executeNextVMTurnPending = false;
function executeNextVMTurn(func) {
  executeNextVMTurnFuncs.push(func);
  if (executeNextVMTurnPending) {
    return;
  }
  executeNextVMTurnPending = true;
  window.setTimeout(() => {
    const funcsCopy = executeNextVMTurnFuncs.slice();
    executeNextVMTurnFuncs.length = 0;
    executeNextVMTurnPending = false;
    funcsCopy.forEach((func2) => func2());
  }, 0);
}
function executeAfter(funcs, milliseconds = 0) {
  if (funcs.length > 0) {
    window.setTimeout(() => funcs.forEach((func) => func()), milliseconds);
  }
}
function debounce(func, delay) {
  let timeout;
  return function(...args) {
    const context = this;
    window.clearTimeout(timeout);
    timeout = window.setTimeout(function() {
      func.apply(context, args);
    }, delay);
  };
}
function throttle(func, wait) {
  let previousCall = 0;
  return function(...args) {
    const context = this;
    const currentCall = (/* @__PURE__ */ new Date()).getTime();
    if (currentCall - previousCall < wait) {
      return;
    }
    previousCall = currentCall;
    func.apply(context, args);
  };
}
function waitUntil(condition, callback, timeout = 100, timeoutMessage) {
  const timeStamp = (/* @__PURE__ */ new Date()).getTime();
  let interval = null;
  let executed = false;
  const internalCallback = () => {
    const reachedTimeout = (/* @__PURE__ */ new Date()).getTime() - timeStamp > timeout;
    if (condition() || reachedTimeout) {
      callback();
      executed = true;
      if (interval != null) {
        window.clearInterval(interval);
        interval = null;
      }
      if (reachedTimeout && timeoutMessage) {
        console.warn(timeoutMessage);
      }
    }
  };
  internalCallback();
  if (!executed) {
    interval = window.setInterval(internalCallback, 10);
  }
}
function compose(...fns) {
  return (arg) => fns.reduce((composed, f) => f(composed), arg);
}
var noop = () => {
  return;
};

// community-modules/core/src/modules/moduleNames.ts
var ModuleNames = /* @__PURE__ */ ((ModuleNames2) => {
  ModuleNames2["CommunityCoreModule"] = "@ag-grid-community/core";
  ModuleNames2["InfiniteRowModelModule"] = "@ag-grid-community/infinite-row-model";
  ModuleNames2["ClientSideRowModelModule"] = "@ag-grid-community/client-side-row-model";
  ModuleNames2["CsvExportModule"] = "@ag-grid-community/csv-export";
  ModuleNames2["EnterpriseCoreModule"] = "@ag-grid-enterprise/core";
  ModuleNames2["RowGroupingModule"] = "@ag-grid-enterprise/row-grouping";
  ModuleNames2["ColumnsToolPanelModule"] = "@ag-grid-enterprise/column-tool-panel";
  ModuleNames2["FiltersToolPanelModule"] = "@ag-grid-enterprise/filter-tool-panel";
  ModuleNames2["MenuModule"] = "@ag-grid-enterprise/menu";
  ModuleNames2["SetFilterModule"] = "@ag-grid-enterprise/set-filter";
  ModuleNames2["MultiFilterModule"] = "@ag-grid-enterprise/multi-filter";
  ModuleNames2["StatusBarModule"] = "@ag-grid-enterprise/status-bar";
  ModuleNames2["SideBarModule"] = "@ag-grid-enterprise/side-bar";
  ModuleNames2["RangeSelectionModule"] = "@ag-grid-enterprise/range-selection";
  ModuleNames2["MasterDetailModule"] = "@ag-grid-enterprise/master-detail";
  ModuleNames2["RichSelectModule"] = "@ag-grid-enterprise/rich-select";
  ModuleNames2["GridChartsModule"] = "@ag-grid-enterprise/charts";
  ModuleNames2["ViewportRowModelModule"] = "@ag-grid-enterprise/viewport-row-model";
  ModuleNames2["ServerSideRowModelModule"] = "@ag-grid-enterprise/server-side-row-model";
  ModuleNames2["ExcelExportModule"] = "@ag-grid-enterprise/excel-export";
  ModuleNames2["ClipboardModule"] = "@ag-grid-enterprise/clipboard";
  ModuleNames2["SparklinesModule"] = "@ag-grid-enterprise/sparklines";
  ModuleNames2["AdvancedFilterModule"] = "@ag-grid-enterprise/advanced-filter";
  ModuleNames2["AngularModule"] = "@ag-grid-community/angular";
  ModuleNames2["ReactModule"] = "@ag-grid-community/react";
  ModuleNames2["VueModule"] = "@ag-grid-community/vue";
  return ModuleNames2;
})(ModuleNames || {});

// community-modules/core/src/modules/moduleRegistry.ts
var _ModuleRegistry = class _ModuleRegistry {
  /**
   * Globally register the given module for all grids.
   * @param module - module to register
   */
  static register(module2) {
    _ModuleRegistry.__register(module2, true, void 0);
  }
  /**
   * Globally register the given modules for all grids.
   * @param modules - modules to register
   */
  static registerModules(modules) {
    _ModuleRegistry.__registerModules(modules, true, void 0);
  }
  /** AG GRID INTERNAL - Module registration helper. */
  static __register(module2, moduleBased, gridId) {
    _ModuleRegistry.runVersionChecks(module2);
    if (gridId !== void 0) {
      _ModuleRegistry.areGridScopedModules = true;
      if (_ModuleRegistry.gridModulesMap[gridId] === void 0) {
        _ModuleRegistry.gridModulesMap[gridId] = {};
      }
      _ModuleRegistry.gridModulesMap[gridId][module2.moduleName] = module2;
    } else {
      _ModuleRegistry.globalModulesMap[module2.moduleName] = module2;
    }
    _ModuleRegistry.setModuleBased(moduleBased);
  }
  /** AG GRID INTERNAL - Unregister grid scoped module. */
  static __unRegisterGridModules(gridId) {
    delete _ModuleRegistry.gridModulesMap[gridId];
  }
  /** AG GRID INTERNAL - Module registration helper. */
  static __registerModules(modules, moduleBased, gridId) {
    _ModuleRegistry.setModuleBased(moduleBased);
    if (!modules) {
      return;
    }
    modules.forEach((module2) => _ModuleRegistry.__register(module2, moduleBased, gridId));
  }
  static isValidModuleVersion(module2) {
    const [moduleMajor, moduleMinor] = module2.version.split(".") || [];
    const [currentModuleMajor, currentModuleMinor] = _ModuleRegistry.currentModuleVersion.split(".") || [];
    return moduleMajor === currentModuleMajor && moduleMinor === currentModuleMinor;
  }
  static runVersionChecks(module2) {
    if (!_ModuleRegistry.currentModuleVersion) {
      _ModuleRegistry.currentModuleVersion = module2.version;
    }
    if (!module2.version) {
      console.error(`AG Grid: You are using incompatible versions of AG Grid modules. Major and minor versions should always match across modules. '${module2.moduleName}' is incompatible. Please update all modules to the same version.`);
    } else if (!_ModuleRegistry.isValidModuleVersion(module2)) {
      console.error(`AG Grid: You are using incompatible versions of AG Grid modules. Major and minor versions should always match across modules. '${module2.moduleName}' is version ${module2.version} but the other modules are version ${this.currentModuleVersion}. Please update all modules to the same version.`);
    }
    if (module2.validate) {
      const result = module2.validate();
      if (!result.isValid) {
        const errorResult = result;
        console.error(`AG Grid: ${errorResult.message}`);
      }
    }
  }
  static setModuleBased(moduleBased) {
    if (_ModuleRegistry.moduleBased === void 0) {
      _ModuleRegistry.moduleBased = moduleBased;
    } else {
      if (_ModuleRegistry.moduleBased !== moduleBased) {
        doOnce(
          () => {
            console.warn(`AG Grid: You are mixing modules (i.e. @ag-grid-community/core) and packages (ag-grid-community) - you can only use one or the other of these mechanisms.`);
            console.warn("Please see https://www.ag-grid.com/javascript-grid/packages-modules/ for more information.");
          },
          "ModulePackageCheck"
        );
      }
    }
  }
  /**
   * AG GRID INTERNAL - Set if files are being served from a single UMD bundle to provide accurate enterprise upgrade steps.
   */
  static __setIsBundled() {
    _ModuleRegistry.isBundled = true;
  }
  /** AG GRID INTERNAL - Assert a given module has been register, globally or individually with this grid. */
  static __assertRegistered(moduleName, reason, gridId) {
    var _a;
    if (this.__isRegistered(moduleName, gridId)) {
      return true;
    }
    const warningKey = reason + moduleName;
    let warningMessage;
    if (_ModuleRegistry.isBundled) {
      {
        warningMessage = `AG Grid: unable to use ${reason} as 'ag-grid-enterprise' has not been loaded. Check you are using the Enterprise bundle:
        
        <script src="https://cdn.jsdelivr.net/npm/ag-grid-enterprise@AG_GRID_VERSION/dist/ag-grid-enterprise.min.js"><\/script>
        
For more info see: https://ag-grid.com/javascript-data-grid/getting-started/#getting-started-with-ag-grid-enterprise`;
      }
    } else if (_ModuleRegistry.moduleBased || _ModuleRegistry.moduleBased === void 0) {
      let modName = (_a = Object.entries(ModuleNames).find(([k, v]) => v === moduleName)) == null ? void 0 : _a[0];
      warningMessage = `AG Grid: unable to use ${reason} as the ${modName} is not registered${_ModuleRegistry.areGridScopedModules ? ` for gridId: ${gridId}` : ""}. Check if you have registered the module:
           
    import { ModuleRegistry } from '@ag-grid-community/core';
    import { ${modName} } from '${moduleName}';
    
    ModuleRegistry.registerModules([ ${modName} ]);

For more info see: https://www.ag-grid.com/javascript-grid/modules/`;
    } else {
      warningMessage = `AG Grid: unable to use ${reason} as package 'ag-grid-enterprise' has not been imported. Check that you have imported the package:
            
    import 'ag-grid-enterprise';
            
For more info see: https://www.ag-grid.com/javascript-grid/packages/`;
    }
    doOnce(() => {
      console.warn(warningMessage);
    }, warningKey);
    return false;
  }
  /**
   * AG GRID INTERNAL - Warn that a given integrated chart type is not supported under the community distribution.
   */
  static __warnEnterpriseChartDisabled(chartType) {
    const reason = "ag-charts-enterprise";
    const warningKey = reason + ":" + chartType;
    const url = "https://www.ag-grid.com/javascript-data-grid/integrated-charts-installation/";
    const warningMessage = `AG Grid: the '${chartType}' chart type is not supported in AG Charts Community as 'ag-grid-charts-enterprise' or '@ag-grid-enterprise/charts-enterprise' hasn't been loaded. See ${url} for more details.`;
    doOnce(() => {
      console.warn(warningMessage);
    }, warningKey);
  }
  /** AG GRID INTERNAL - Is the given module registered, globally or individually with this grid. */
  static __isRegistered(moduleName, gridId) {
    var _a;
    return !!_ModuleRegistry.globalModulesMap[moduleName] || !!((_a = _ModuleRegistry.gridModulesMap[gridId]) == null ? void 0 : _a[moduleName]);
  }
  /** AG GRID INTERNAL - Get all registered modules globally / individually for this grid. */
  static __getRegisteredModules(gridId) {
    return [...values(_ModuleRegistry.globalModulesMap), ...values(_ModuleRegistry.gridModulesMap[gridId] || {})];
  }
  /** AG GRID INTERNAL - Get the list of modules registered individually for this grid. */
  static __getGridRegisteredModules(gridId) {
    var _a;
    return values((_a = _ModuleRegistry.gridModulesMap[gridId]) != null ? _a : {}) || [];
  }
  /** INTERNAL */
  static __isPackageBased() {
    return !_ModuleRegistry.moduleBased;
  }
};
// having in a map a) removes duplicates and b) allows fast lookup
_ModuleRegistry.globalModulesMap = {};
_ModuleRegistry.gridModulesMap = {};
_ModuleRegistry.areGridScopedModules = false;
var ModuleRegistry = _ModuleRegistry;

// community-modules/core/src/context/context.ts
var Context = class {
  constructor(params, logger) {
    this.beanWrappers = {};
    this.destroyed = false;
    if (!params || !params.beanClasses) {
      return;
    }
    this.contextParams = params;
    this.logger = logger;
    this.logger.log(">> creating ag-Application Context");
    this.createBeans();
    const beanInstances = this.getBeanInstances();
    this.wireBeans(beanInstances);
    this.logger.log(">> ag-Application Context ready - component is alive");
  }
  getBeanInstances() {
    return values(this.beanWrappers).map((beanEntry) => beanEntry.beanInstance);
  }
  createBean(bean, afterPreCreateCallback) {
    if (!bean) {
      throw Error(`Can't wire to bean since it is null`);
    }
    this.wireBeans([bean], afterPreCreateCallback);
    return bean;
  }
  wireBeans(beanInstances, afterPreCreateCallback) {
    this.autoWireBeans(beanInstances);
    this.methodWireBeans(beanInstances);
    this.callLifeCycleMethods(beanInstances, "preConstructMethods");
    if (exists(afterPreCreateCallback)) {
      beanInstances.forEach(afterPreCreateCallback);
    }
    this.callLifeCycleMethods(beanInstances, "postConstructMethods");
  }
  createBeans() {
    this.contextParams.beanClasses.forEach(this.createBeanWrapper.bind(this));
    iterateObject(this.beanWrappers, (key, beanEntry) => {
      let constructorParamsMeta;
      if (beanEntry.bean.__agBeanMetaData && beanEntry.bean.__agBeanMetaData.autowireMethods && beanEntry.bean.__agBeanMetaData.autowireMethods.agConstructor) {
        constructorParamsMeta = beanEntry.bean.__agBeanMetaData.autowireMethods.agConstructor;
      }
      const constructorParams = this.getBeansForParameters(constructorParamsMeta, beanEntry.bean.name);
      const newInstance = new (beanEntry.bean.bind.apply(beanEntry.bean, [null, ...constructorParams]))();
      beanEntry.beanInstance = newInstance;
    });
    const createdBeanNames = Object.keys(this.beanWrappers).join(", ");
    this.logger.log(`created beans: ${createdBeanNames}`);
  }
  // tslint:disable-next-line
  createBeanWrapper(BeanClass) {
    const metaData = BeanClass.__agBeanMetaData;
    if (!metaData) {
      let beanName;
      if (BeanClass.prototype.constructor) {
        beanName = getFunctionName(BeanClass.prototype.constructor);
      } else {
        beanName = "" + BeanClass;
      }
      console.error(`Context item ${beanName} is not a bean`);
      return;
    }
    const beanEntry = {
      bean: BeanClass,
      beanInstance: null,
      beanName: metaData.beanName
    };
    this.beanWrappers[metaData.beanName] = beanEntry;
  }
  autoWireBeans(beanInstances) {
    beanInstances.forEach((beanInstance) => {
      this.forEachMetaDataInHierarchy(beanInstance, (metaData, beanName) => {
        const attributes = metaData.agClassAttributes;
        if (!attributes) {
          return;
        }
        attributes.forEach((attribute) => {
          const otherBean = this.lookupBeanInstance(beanName, attribute.beanName, attribute.optional);
          beanInstance[attribute.attributeName] = otherBean;
        });
      });
    });
  }
  methodWireBeans(beanInstances) {
    beanInstances.forEach((beanInstance) => {
      this.forEachMetaDataInHierarchy(beanInstance, (metaData, beanName) => {
        iterateObject(metaData.autowireMethods, (methodName, wireParams) => {
          if (methodName === "agConstructor") {
            return;
          }
          const initParams = this.getBeansForParameters(wireParams, beanName);
          beanInstance[methodName].apply(beanInstance, initParams);
        });
      });
    });
  }
  forEachMetaDataInHierarchy(beanInstance, callback) {
    let prototype = Object.getPrototypeOf(beanInstance);
    while (prototype != null) {
      const constructor = prototype.constructor;
      if (constructor.hasOwnProperty("__agBeanMetaData")) {
        const metaData = constructor.__agBeanMetaData;
        const beanName = this.getBeanName(constructor);
        callback(metaData, beanName);
      }
      prototype = Object.getPrototypeOf(prototype);
    }
  }
  getBeanName(constructor) {
    if (constructor.__agBeanMetaData && constructor.__agBeanMetaData.beanName) {
      return constructor.__agBeanMetaData.beanName;
    }
    const constructorString = constructor.toString();
    const beanName = constructorString.substring(9, constructorString.indexOf("("));
    return beanName;
  }
  getBeansForParameters(parameters, beanName) {
    const beansList = [];
    if (parameters) {
      iterateObject(parameters, (paramIndex, otherBeanName) => {
        const otherBean = this.lookupBeanInstance(beanName, otherBeanName);
        beansList[Number(paramIndex)] = otherBean;
      });
    }
    return beansList;
  }
  lookupBeanInstance(wiringBean, beanName, optional = false) {
    if (this.destroyed) {
      this.logger.log(`AG Grid: bean reference ${beanName} is used after the grid is destroyed!`);
      return null;
    }
    if (beanName === "context") {
      return this;
    }
    if (this.contextParams.providedBeanInstances && this.contextParams.providedBeanInstances.hasOwnProperty(beanName)) {
      return this.contextParams.providedBeanInstances[beanName];
    }
    const beanEntry = this.beanWrappers[beanName];
    if (beanEntry) {
      return beanEntry.beanInstance;
    }
    if (!optional) {
      console.error(`AG Grid: unable to find bean reference ${beanName} while initialising ${wiringBean}`);
    }
    return null;
  }
  callLifeCycleMethods(beanInstances, lifeCycleMethod) {
    beanInstances.forEach((beanInstance) => this.callLifeCycleMethodsOnBean(beanInstance, lifeCycleMethod));
  }
  callLifeCycleMethodsOnBean(beanInstance, lifeCycleMethod, methodToIgnore) {
    const allMethods = {};
    this.forEachMetaDataInHierarchy(beanInstance, (metaData) => {
      const methods = metaData[lifeCycleMethod];
      if (methods) {
        methods.forEach((methodName) => {
          if (methodName != methodToIgnore) {
            allMethods[methodName] = true;
          }
        });
      }
    });
    const allMethodsList = Object.keys(allMethods);
    allMethodsList.forEach((methodName) => beanInstance[methodName]());
  }
  getBean(name) {
    return this.lookupBeanInstance("getBean", name, true);
  }
  destroy() {
    if (this.destroyed) {
      return;
    }
    this.destroyed = true;
    this.logger.log(">> Shutting down ag-Application Context");
    const beanInstances = this.getBeanInstances();
    this.destroyBeans(beanInstances);
    this.contextParams.providedBeanInstances = null;
    ModuleRegistry.__unRegisterGridModules(this.contextParams.gridId);
    this.logger.log(">> ag-Application Context shut down - component is dead");
  }
  destroyBean(bean) {
    if (!bean) {
      return;
    }
    this.destroyBeans([bean]);
  }
  destroyBeans(beans) {
    if (!beans) {
      return [];
    }
    beans.forEach((bean) => {
      this.callLifeCycleMethodsOnBean(bean, "preDestroyMethods", "destroy");
      const beanAny = bean;
      if (typeof beanAny.destroy === "function") {
        beanAny.destroy();
      }
    });
    return [];
  }
  isDestroyed() {
    return this.destroyed;
  }
  getGridId() {
    return this.contextParams.gridId;
  }
};
function PreConstruct(target, methodName, descriptor) {
  const props = getOrCreateProps(target.constructor);
  if (!props.preConstructMethods) {
    props.preConstructMethods = [];
  }
  props.preConstructMethods.push(methodName);
}
function PostConstruct(target, methodName, descriptor) {
  const props = getOrCreateProps(target.constructor);
  if (!props.postConstructMethods) {
    props.postConstructMethods = [];
  }
  props.postConstructMethods.push(methodName);
}
function PreDestroy(target, methodName, descriptor) {
  const props = getOrCreateProps(target.constructor);
  if (!props.preDestroyMethods) {
    props.preDestroyMethods = [];
  }
  props.preDestroyMethods.push(methodName);
}
function Bean(beanName) {
  return (classConstructor) => {
    const props = getOrCreateProps(classConstructor);
    props.beanName = beanName;
  };
}
function Autowired(name) {
  return (target, propertyKey, descriptor) => {
    autowiredFunc(target, name, false, target, propertyKey, null);
  };
}
function Optional(name) {
  return (target, propertyKey, descriptor) => {
    autowiredFunc(target, name, true, target, propertyKey, null);
  };
}
function autowiredFunc(target, name, optional, classPrototype, methodOrAttributeName, index) {
  if (name === null) {
    console.error("AG Grid: Autowired name should not be null");
    return;
  }
  if (typeof index === "number") {
    console.error("AG Grid: Autowired should be on an attribute");
    return;
  }
  const props = getOrCreateProps(target.constructor);
  if (!props.agClassAttributes) {
    props.agClassAttributes = [];
  }
  props.agClassAttributes.push({
    attributeName: methodOrAttributeName,
    beanName: name,
    optional
  });
}
function Qualifier(name) {
  return (classPrototype, methodOrAttributeName, index) => {
    const constructor = typeof classPrototype == "function" ? classPrototype : classPrototype.constructor;
    let props;
    if (typeof index === "number") {
      let methodName;
      if (methodOrAttributeName) {
        props = getOrCreateProps(constructor);
        methodName = methodOrAttributeName;
      } else {
        props = getOrCreateProps(constructor);
        methodName = "agConstructor";
      }
      if (!props.autowireMethods) {
        props.autowireMethods = {};
      }
      if (!props.autowireMethods[methodName]) {
        props.autowireMethods[methodName] = {};
      }
      props.autowireMethods[methodName][index] = name;
    }
  };
}
function getOrCreateProps(target) {
  if (!target.hasOwnProperty("__agBeanMetaData")) {
    target.__agBeanMetaData = {};
  }
  return target.__agBeanMetaData;
}

// community-modules/core/src/eventService.ts
var EventService = class {
  constructor() {
    this.allSyncListeners = /* @__PURE__ */ new Map();
    this.allAsyncListeners = /* @__PURE__ */ new Map();
    this.globalSyncListeners = /* @__PURE__ */ new Set();
    this.globalAsyncListeners = /* @__PURE__ */ new Set();
    this.asyncFunctionsQueue = [];
    this.scheduled = false;
    // using an object performs better than a Set for the number of different events we have
    this.firedEvents = {};
  }
  // because this class is used both inside the context and outside the context, we do not
  // use autowired attributes, as that would be confusing, as sometimes the attributes
  // would be wired, and sometimes not.
  //
  // the global event servers used by AG Grid is autowired by the context once, and this
  // setBeans method gets called once.
  //
  // the times when this class is used outside of the context (eg RowNode has an instance of this
  // class) then it is not a bean, and this setBeans method is not called.
  setBeans(gridOptionsService, frameworkOverrides, globalEventListener = null, globalSyncEventListener = null) {
    this.frameworkOverrides = frameworkOverrides;
    this.gridOptionsService = gridOptionsService;
    if (globalEventListener) {
      const async = gridOptionsService.useAsyncEvents();
      this.addGlobalListener(globalEventListener, async);
    }
    if (globalSyncEventListener) {
      this.addGlobalListener(globalSyncEventListener, false);
    }
  }
  setFrameworkOverrides(frameworkOverrides) {
    this.frameworkOverrides = frameworkOverrides;
  }
  getListeners(eventType, async, autoCreateListenerCollection) {
    const listenerMap = async ? this.allAsyncListeners : this.allSyncListeners;
    let listeners = listenerMap.get(eventType);
    if (!listeners && autoCreateListenerCollection) {
      listeners = /* @__PURE__ */ new Set();
      listenerMap.set(eventType, listeners);
    }
    return listeners;
  }
  noRegisteredListenersExist() {
    return this.allSyncListeners.size === 0 && this.allAsyncListeners.size === 0 && this.globalSyncListeners.size === 0 && this.globalAsyncListeners.size === 0;
  }
  addEventListener(eventType, listener, async = false) {
    this.getListeners(eventType, async, true).add(listener);
  }
  removeEventListener(eventType, listener, async = false) {
    const listeners = this.getListeners(eventType, async, false);
    if (!listeners) {
      return;
    }
    listeners.delete(listener);
    if (listeners.size === 0) {
      const listenerMap = async ? this.allAsyncListeners : this.allSyncListeners;
      listenerMap.delete(eventType);
    }
  }
  addGlobalListener(listener, async = false) {
    (async ? this.globalAsyncListeners : this.globalSyncListeners).add(listener);
  }
  removeGlobalListener(listener, async = false) {
    (async ? this.globalAsyncListeners : this.globalSyncListeners).delete(listener);
  }
  dispatchEvent(event) {
    let agEvent = event;
    if (this.gridOptionsService) {
      this.gridOptionsService.addGridCommonParams(agEvent);
    }
    this.dispatchToListeners(agEvent, true);
    this.dispatchToListeners(agEvent, false);
    this.firedEvents[agEvent.type] = true;
  }
  dispatchEventOnce(event) {
    if (!this.firedEvents[event.type]) {
      this.dispatchEvent(event);
    }
  }
  dispatchToListeners(event, async) {
    var _a;
    const eventType = event.type;
    if (async && "event" in event) {
      const browserEvent = event.event;
      if (browserEvent instanceof Event) {
        event.eventPath = browserEvent.composedPath();
      }
    }
    const processEventListeners = (listeners2, originalListeners2) => listeners2.forEach((listener) => {
      if (!originalListeners2.has(listener)) {
        return;
      }
      const callback = this.frameworkOverrides ? () => this.frameworkOverrides.wrapIncoming(() => listener(event)) : () => listener(event);
      if (async) {
        this.dispatchAsync(callback);
      } else {
        callback();
      }
    });
    const originalListeners = (_a = this.getListeners(eventType, async, false)) != null ? _a : /* @__PURE__ */ new Set();
    const listeners = new Set(originalListeners);
    if (listeners.size > 0) {
      processEventListeners(listeners, originalListeners);
    }
    const globalListeners = new Set(async ? this.globalAsyncListeners : this.globalSyncListeners);
    globalListeners.forEach((listener) => {
      const callback = this.frameworkOverrides ? () => this.frameworkOverrides.wrapIncoming(() => listener(eventType, event)) : () => listener(eventType, event);
      if (async) {
        this.dispatchAsync(callback);
      } else {
        callback();
      }
    });
  }
  // this gets called inside the grid's thread, for each event that it
  // wants to set async. the grid then batches the events into one setTimeout()
  // because setTimeout() is an expensive operation. ideally we would have
  // each event in it's own setTimeout(), but we batch for performance.
  dispatchAsync(func) {
    this.asyncFunctionsQueue.push(func);
    if (!this.scheduled) {
      this.frameworkOverrides.wrapIncoming(() => {
        window.setTimeout(this.flushAsyncQueue.bind(this), 0);
      });
      this.scheduled = true;
    }
  }
  // this happens in the next VM turn only, and empties the queue of events
  flushAsyncQueue() {
    this.scheduled = false;
    const queueCopy = this.asyncFunctionsQueue.slice();
    this.asyncFunctionsQueue = [];
    queueCopy.forEach((func) => func());
  }
};
__decorateClass([
  __decorateParam(0, Qualifier("gridOptionsService")),
  __decorateParam(1, Qualifier("frameworkOverrides")),
  __decorateParam(2, Qualifier("globalEventListener")),
  __decorateParam(3, Qualifier("globalSyncEventListener"))
], EventService.prototype, "setBeans", 1);
EventService = __decorateClass([
  Bean("eventService")
], EventService);

// community-modules/core/src/misc/frameworkEventListenerService.ts
var FrameworkEventListenerService = class {
  constructor(frameworkOverrides) {
    this.frameworkOverrides = frameworkOverrides;
    // Map from user listener to wrapped listener so we can remove listener provided by user
    this.wrappedListeners = /* @__PURE__ */ new Map();
    this.wrappedGlobalListeners = /* @__PURE__ */ new Map();
  }
  wrap(userListener) {
    let listener = userListener;
    if (this.frameworkOverrides.shouldWrapOutgoing) {
      listener = (event) => {
        this.frameworkOverrides.wrapOutgoing(() => userListener(event));
      };
      this.wrappedListeners.set(userListener, listener);
    }
    return listener;
  }
  wrapGlobal(userListener) {
    let listener = userListener;
    if (this.frameworkOverrides.shouldWrapOutgoing) {
      listener = (eventType, event) => {
        this.frameworkOverrides.wrapOutgoing(() => userListener(eventType, event));
      };
      this.wrappedGlobalListeners.set(userListener, listener);
    }
    return listener;
  }
  unwrap(userListener) {
    var _a;
    return (_a = this.wrappedListeners.get(userListener)) != null ? _a : userListener;
  }
  unwrapGlobal(userListener) {
    var _a;
    return (_a = this.wrappedGlobalListeners.get(userListener)) != null ? _a : userListener;
  }
};

// community-modules/core/src/entities/column.ts
var COL_DEF_DEFAULTS = {
  resizable: true,
  sortable: true
};
var instanceIdSequence = 0;
function getNextColInstanceId() {
  return instanceIdSequence++;
}
var _Column = class _Column {
  constructor(colDef, userProvidedColDef, colId, primary) {
    // used by React (and possibly other frameworks) as key for rendering. also used to
    // identify old vs new columns for destroying cols when no longer used.
    this.instanceId = getNextColInstanceId();
    // The measured height of this column's header when autoHeaderHeight is enabled
    this.autoHeaderHeight = null;
    this.moving = false;
    this.menuVisible = false;
    this.lastLeftPinned = false;
    this.firstRightPinned = false;
    this.filterActive = false;
    this.eventService = new EventService();
    this.tooltipEnabled = false;
    this.rowGroupActive = false;
    this.pivotActive = false;
    this.aggregationActive = false;
    this.colDef = colDef;
    this.userProvidedColDef = userProvidedColDef;
    this.colId = colId;
    this.primary = primary;
    this.setState(colDef);
  }
  getInstanceId() {
    return this.instanceId;
  }
  setState(colDef) {
    if (colDef.sort !== void 0) {
      if (colDef.sort === "asc" || colDef.sort === "desc") {
        this.sort = colDef.sort;
      }
    } else {
      if (colDef.initialSort === "asc" || colDef.initialSort === "desc") {
        this.sort = colDef.initialSort;
      }
    }
    const sortIndex = colDef.sortIndex;
    const initialSortIndex = colDef.initialSortIndex;
    if (sortIndex !== void 0) {
      if (sortIndex !== null) {
        this.sortIndex = sortIndex;
      }
    } else {
      if (initialSortIndex !== null) {
        this.sortIndex = initialSortIndex;
      }
    }
    const hide = colDef.hide;
    const initialHide = colDef.initialHide;
    if (hide !== void 0) {
      this.visible = !hide;
    } else {
      this.visible = !initialHide;
    }
    if (colDef.pinned !== void 0) {
      this.setPinned(colDef.pinned);
    } else {
      this.setPinned(colDef.initialPinned);
    }
    const flex = colDef.flex;
    const initialFlex = colDef.initialFlex;
    if (flex !== void 0) {
      this.flex = flex;
    } else if (initialFlex !== void 0) {
      this.flex = initialFlex;
    }
  }
  // gets called when user provides an alternative colDef, eg
  setColDef(colDef, userProvidedColDef, source) {
    this.colDef = colDef;
    this.userProvidedColDef = userProvidedColDef;
    this.initMinAndMaxWidths();
    this.initDotNotation();
    this.initTooltip();
    this.eventService.dispatchEvent(this.createColumnEvent("colDefChanged", source));
  }
  /**
   * Returns the column definition provided by the application.
   * This may not be correct, as items can be superseded by default column options.
   * However it's useful for comparison, eg to know which application column definition matches that column.
   */
  getUserProvidedColDef() {
    return this.userProvidedColDef;
  }
  setParent(parent) {
    this.parent = parent;
  }
  /** Returns the parent column group, if column grouping is active. */
  getParent() {
    return this.parent;
  }
  setOriginalParent(originalParent) {
    this.originalParent = originalParent;
  }
  /**
   * Used for marryChildren, helps with comparing when duplicate groups have been created to manage split groups.
   * 
   * Parent may contain a duplicate but not identical group when the group is split.
   */
  getOriginalParent() {
    return this.originalParent;
  }
  initialise() {
    this.initMinAndMaxWidths();
    this.resetActualWidth("gridInitializing");
    this.initDotNotation();
    this.initTooltip();
  }
  initDotNotation() {
    const suppressDotNotation = this.gridOptionsService.get("suppressFieldDotNotation");
    this.fieldContainsDots = exists(this.colDef.field) && this.colDef.field.indexOf(".") >= 0 && !suppressDotNotation;
    this.tooltipFieldContainsDots = exists(this.colDef.tooltipField) && this.colDef.tooltipField.indexOf(".") >= 0 && !suppressDotNotation;
  }
  initMinAndMaxWidths() {
    const colDef = this.colDef;
    this.minWidth = this.columnUtils.calculateColMinWidth(colDef);
    this.maxWidth = this.columnUtils.calculateColMaxWidth(colDef);
  }
  initTooltip() {
    this.tooltipEnabled = exists(this.colDef.tooltipField) || exists(this.colDef.tooltipValueGetter) || exists(this.colDef.tooltipComponent);
  }
  resetActualWidth(source) {
    const initialWidth = this.columnUtils.calculateColInitialWidth(this.colDef);
    this.setActualWidth(initialWidth, source, true);
  }
  isEmptyGroup() {
    return false;
  }
  isRowGroupDisplayed(colId) {
    if (missing(this.colDef) || missing(this.colDef.showRowGroup)) {
      return false;
    }
    const showingAllGroups = this.colDef.showRowGroup === true;
    const showingThisGroup = this.colDef.showRowGroup === colId;
    return showingAllGroups || showingThisGroup;
  }
  /** Returns `true` if column is a primary column, `false` if secondary. Secondary columns are used for pivoting. */
  isPrimary() {
    return this.primary;
  }
  /** Returns `true` if column filtering is allowed. */
  isFilterAllowed() {
    const filterDefined = !!this.colDef.filter;
    return filterDefined;
  }
  isFieldContainsDots() {
    return this.fieldContainsDots;
  }
  isTooltipEnabled() {
    return this.tooltipEnabled;
  }
  isTooltipFieldContainsDots() {
    return this.tooltipFieldContainsDots;
  }
  /** Add an event listener to the column. */
  addEventListener(eventType, userListener) {
    var _a, _b;
    if (this.frameworkOverrides.shouldWrapOutgoing && !this.frameworkEventListenerService) {
      this.eventService.setFrameworkOverrides(this.frameworkOverrides);
      this.frameworkEventListenerService = new FrameworkEventListenerService(this.frameworkOverrides);
    }
    const listener = (_b = (_a = this.frameworkEventListenerService) == null ? void 0 : _a.wrap(userListener)) != null ? _b : userListener;
    this.eventService.addEventListener(eventType, listener);
  }
  /** Remove event listener from the column. */
  removeEventListener(eventType, userListener) {
    var _a, _b;
    const listener = (_b = (_a = this.frameworkEventListenerService) == null ? void 0 : _a.unwrap(userListener)) != null ? _b : userListener;
    this.eventService.removeEventListener(eventType, listener);
  }
  createColumnFunctionCallbackParams(rowNode) {
    return this.gridOptionsService.addGridCommonParams({
      node: rowNode,
      data: rowNode.data,
      column: this,
      colDef: this.colDef
    });
  }
  isSuppressNavigable(rowNode) {
    if (typeof this.colDef.suppressNavigable === "boolean") {
      return this.colDef.suppressNavigable;
    }
    if (typeof this.colDef.suppressNavigable === "function") {
      const params = this.createColumnFunctionCallbackParams(rowNode);
      const userFunc = this.colDef.suppressNavigable;
      return userFunc(params);
    }
    return false;
  }
  /**
   * Returns `true` if the cell for this column is editable for the given `rowNode`, otherwise `false`.
   */
  isCellEditable(rowNode) {
    if (rowNode.group && !this.gridOptionsService.get("enableGroupEdit")) {
      return false;
    }
    return this.isColumnFunc(rowNode, this.colDef.editable);
  }
  isSuppressFillHandle() {
    return !!this.colDef.suppressFillHandle;
  }
  isAutoHeight() {
    return !!this.colDef.autoHeight;
  }
  isAutoHeaderHeight() {
    return !!this.colDef.autoHeaderHeight;
  }
  isRowDrag(rowNode) {
    return this.isColumnFunc(rowNode, this.colDef.rowDrag);
  }
  isDndSource(rowNode) {
    return this.isColumnFunc(rowNode, this.colDef.dndSource);
  }
  isCellCheckboxSelection(rowNode) {
    return this.isColumnFunc(rowNode, this.colDef.checkboxSelection);
  }
  isSuppressPaste(rowNode) {
    return this.isColumnFunc(rowNode, this.colDef ? this.colDef.suppressPaste : null);
  }
  isResizable() {
    return !!this.getColDefValue("resizable");
  }
  /** Get value from ColDef or default if it exists. */
  getColDefValue(key) {
    var _a;
    return (_a = this.colDef[key]) != null ? _a : COL_DEF_DEFAULTS[key];
  }
  isColumnFunc(rowNode, value) {
    if (typeof value === "boolean") {
      return value;
    }
    if (typeof value === "function") {
      const params = this.createColumnFunctionCallbackParams(rowNode);
      const editableFunc = value;
      return editableFunc(params);
    }
    return false;
  }
  setMoving(moving, source) {
    this.moving = moving;
    this.eventService.dispatchEvent(this.createColumnEvent("movingChanged", source));
  }
  createColumnEvent(type, source) {
    return this.gridOptionsService.addGridCommonParams({
      type,
      column: this,
      columns: [this],
      source
    });
  }
  isMoving() {
    return this.moving;
  }
  /** If sorting is active, returns the sort direction e.g. `'asc'` or `'desc'`. */
  getSort() {
    return this.sort;
  }
  setSort(sort, source) {
    if (this.sort !== sort) {
      this.sort = sort;
      this.eventService.dispatchEvent(this.createColumnEvent("sortChanged", source));
    }
    this.dispatchStateUpdatedEvent("sort");
  }
  setMenuVisible(visible, source) {
    if (this.menuVisible !== visible) {
      this.menuVisible = visible;
      this.eventService.dispatchEvent(this.createColumnEvent("menuVisibleChanged", source));
    }
  }
  isMenuVisible() {
    return this.menuVisible;
  }
  isSortable() {
    return !!this.getColDefValue("sortable");
  }
  isSortAscending() {
    return this.sort === "asc";
  }
  isSortDescending() {
    return this.sort === "desc";
  }
  isSortNone() {
    return missing(this.sort);
  }
  isSorting() {
    return exists(this.sort);
  }
  getSortIndex() {
    return this.sortIndex;
  }
  setSortIndex(sortOrder) {
    this.sortIndex = sortOrder;
    this.dispatchStateUpdatedEvent("sortIndex");
  }
  setAggFunc(aggFunc) {
    this.aggFunc = aggFunc;
    this.dispatchStateUpdatedEvent("aggFunc");
  }
  /** If aggregation is set for the column, returns the aggregation function. */
  getAggFunc() {
    return this.aggFunc;
  }
  getLeft() {
    return this.left;
  }
  getOldLeft() {
    return this.oldLeft;
  }
  getRight() {
    return this.left + this.actualWidth;
  }
  setLeft(left, source) {
    this.oldLeft = this.left;
    if (this.left !== left) {
      this.left = left;
      this.eventService.dispatchEvent(this.createColumnEvent("leftChanged", source));
    }
  }
  /** Returns `true` if filter is active on the column. */
  isFilterActive() {
    return this.filterActive;
  }
  // additionalEventAttributes is used by provided simple floating filter, so it can add 'floatingFilter=true' to the event
  setFilterActive(active, source, additionalEventAttributes) {
    if (this.filterActive !== active) {
      this.filterActive = active;
      this.eventService.dispatchEvent(this.createColumnEvent("filterActiveChanged", source));
    }
    const filterChangedEvent = this.createColumnEvent("filterChanged", source);
    if (additionalEventAttributes) {
      mergeDeep(filterChangedEvent, additionalEventAttributes);
    }
    this.eventService.dispatchEvent(filterChangedEvent);
  }
  /** Returns `true` when this `Column` is hovered, otherwise `false` */
  isHovered() {
    return this.columnHoverService.isHovered(this);
  }
  setPinned(pinned) {
    if (pinned === true || pinned === "left") {
      this.pinned = "left";
    } else if (pinned === "right") {
      this.pinned = "right";
    } else {
      this.pinned = null;
    }
    this.dispatchStateUpdatedEvent("pinned");
  }
  setFirstRightPinned(firstRightPinned, source) {
    if (this.firstRightPinned !== firstRightPinned) {
      this.firstRightPinned = firstRightPinned;
      this.eventService.dispatchEvent(this.createColumnEvent("firstRightPinnedChanged", source));
    }
  }
  setLastLeftPinned(lastLeftPinned, source) {
    if (this.lastLeftPinned !== lastLeftPinned) {
      this.lastLeftPinned = lastLeftPinned;
      this.eventService.dispatchEvent(this.createColumnEvent("lastLeftPinnedChanged", source));
    }
  }
  isFirstRightPinned() {
    return this.firstRightPinned;
  }
  isLastLeftPinned() {
    return this.lastLeftPinned;
  }
  isPinned() {
    return this.pinned === "left" || this.pinned === "right";
  }
  isPinnedLeft() {
    return this.pinned === "left";
  }
  isPinnedRight() {
    return this.pinned === "right";
  }
  getPinned() {
    return this.pinned;
  }
  setVisible(visible, source) {
    const newValue = visible === true;
    if (this.visible !== newValue) {
      this.visible = newValue;
      this.eventService.dispatchEvent(this.createColumnEvent("visibleChanged", source));
    }
    this.dispatchStateUpdatedEvent("hide");
  }
  isVisible() {
    return this.visible;
  }
  isSpanHeaderHeight() {
    const colDef = this.getColDef();
    return !colDef.suppressSpanHeaderHeight && !colDef.autoHeaderHeight;
  }
  getColumnGroupPaddingInfo() {
    let parent = this.getParent();
    if (!parent || !parent.isPadding()) {
      return { numberOfParents: 0, isSpanningTotal: false };
    }
    const numberOfParents = parent.getPaddingLevel() + 1;
    let isSpanningTotal = true;
    while (parent) {
      if (!parent.isPadding()) {
        isSpanningTotal = false;
        break;
      }
      parent = parent.getParent();
    }
    return { numberOfParents, isSpanningTotal };
  }
  /** Returns the column definition for this column.
   * The column definition will be the result of merging the application provided column definition with any provided defaults
   * (e.g. `defaultColDef` grid option, or column types.
   *
   * Equivalent: `getDefinition` */
  getColDef() {
    return this.colDef;
  }
  getColumnGroupShow() {
    return this.colDef.columnGroupShow;
  }
  /**
   * Returns the unique ID for the column.
   *
   * Equivalent: `getId`, `getUniqueId` */
  getColId() {
    return this.colId;
  }
  /**
   * Returns the unique ID for the column.
   *
   * Equivalent: `getColId`, `getUniqueId` */
  getId() {
    return this.colId;
  }
  /**
   * Returns the unique ID for the column.
   *
   * Equivalent: `getColId`, `getId` */
  getUniqueId() {
    return this.colId;
  }
  getDefinition() {
    return this.colDef;
  }
  /** Returns the current width of the column. If the column is resized, the actual width is the new size. */
  getActualWidth() {
    return this.actualWidth;
  }
  getAutoHeaderHeight() {
    return this.autoHeaderHeight;
  }
  /** Returns true if the header height has changed */
  setAutoHeaderHeight(height) {
    const changed = height !== this.autoHeaderHeight;
    this.autoHeaderHeight = height;
    return changed;
  }
  createBaseColDefParams(rowNode) {
    const params = this.gridOptionsService.addGridCommonParams({
      node: rowNode,
      data: rowNode.data,
      colDef: this.colDef,
      column: this
    });
    return params;
  }
  getColSpan(rowNode) {
    if (missing(this.colDef.colSpan)) {
      return 1;
    }
    const params = this.createBaseColDefParams(rowNode);
    const colSpan = this.colDef.colSpan(params);
    return Math.max(colSpan, 1);
  }
  getRowSpan(rowNode) {
    if (missing(this.colDef.rowSpan)) {
      return 1;
    }
    const params = this.createBaseColDefParams(rowNode);
    const rowSpan = this.colDef.rowSpan(params);
    return Math.max(rowSpan, 1);
  }
  setActualWidth(actualWidth, source, silent = false) {
    if (this.minWidth != null) {
      actualWidth = Math.max(actualWidth, this.minWidth);
    }
    if (this.maxWidth != null) {
      actualWidth = Math.min(actualWidth, this.maxWidth);
    }
    if (this.actualWidth !== actualWidth) {
      this.actualWidth = actualWidth;
      if (this.flex && source !== "flex" && source !== "gridInitializing") {
        this.flex = null;
      }
      if (!silent) {
        this.fireColumnWidthChangedEvent(source);
      }
    }
    this.dispatchStateUpdatedEvent("width");
  }
  fireColumnWidthChangedEvent(source) {
    this.eventService.dispatchEvent(this.createColumnEvent("widthChanged", source));
  }
  isGreaterThanMax(width) {
    if (this.maxWidth != null) {
      return width > this.maxWidth;
    }
    return false;
  }
  getMinWidth() {
    return this.minWidth;
  }
  getMaxWidth() {
    return this.maxWidth;
  }
  getFlex() {
    return this.flex || 0;
  }
  // this method should only be used by the columnModel to
  // change flex when required by the applyColumnState method.
  setFlex(flex) {
    if (this.flex !== flex) {
      this.flex = flex;
    }
    this.dispatchStateUpdatedEvent("flex");
  }
  setMinimum(source) {
    if (exists(this.minWidth)) {
      this.setActualWidth(this.minWidth, source);
    }
  }
  setRowGroupActive(rowGroup, source) {
    if (this.rowGroupActive !== rowGroup) {
      this.rowGroupActive = rowGroup;
      this.eventService.dispatchEvent(this.createColumnEvent("columnRowGroupChanged", source));
    }
    this.dispatchStateUpdatedEvent("rowGroup");
  }
  /** Returns `true` if row group is currently active for this column. */
  isRowGroupActive() {
    return this.rowGroupActive;
  }
  setPivotActive(pivot, source) {
    if (this.pivotActive !== pivot) {
      this.pivotActive = pivot;
      this.eventService.dispatchEvent(this.createColumnEvent("columnPivotChanged", source));
    }
    this.dispatchStateUpdatedEvent("pivot");
  }
  /** Returns `true` if pivot is currently active for this column. */
  isPivotActive() {
    return this.pivotActive;
  }
  isAnyFunctionActive() {
    return this.isPivotActive() || this.isRowGroupActive() || this.isValueActive();
  }
  isAnyFunctionAllowed() {
    return this.isAllowPivot() || this.isAllowRowGroup() || this.isAllowValue();
  }
  setValueActive(value, source) {
    if (this.aggregationActive !== value) {
      this.aggregationActive = value;
      this.eventService.dispatchEvent(this.createColumnEvent("columnValueChanged", source));
    }
  }
  /** Returns `true` if value (aggregation) is currently active for this column. */
  isValueActive() {
    return this.aggregationActive;
  }
  isAllowPivot() {
    return this.colDef.enablePivot === true;
  }
  isAllowValue() {
    return this.colDef.enableValue === true;
  }
  isAllowRowGroup() {
    return this.colDef.enableRowGroup === true;
  }
  /**
   * @deprecated v31.1 Use `getColDef().menuTabs ?? defaultValues` instead.
   */
  getMenuTabs(defaultValues) {
    warnOnce(`As of v31.1, 'getMenuTabs' is deprecated. Use 'getColDef().menuTabs ?? defaultValues' instead.`);
    let menuTabs = this.getColDef().menuTabs;
    if (menuTabs == null) {
      menuTabs = defaultValues;
    }
    return menuTabs;
  }
  dispatchStateUpdatedEvent(key) {
    this.eventService.dispatchEvent({
      type: _Column.EVENT_STATE_UPDATED,
      key
    });
  }
};
// + renderedHeaderCell - for making header cell transparent when moving
_Column.EVENT_MOVING_CHANGED = "movingChanged";
// + renderedCell - changing left position
_Column.EVENT_LEFT_CHANGED = "leftChanged";
// + renderedCell - changing width
_Column.EVENT_WIDTH_CHANGED = "widthChanged";
// + renderedCell - for changing pinned classes
_Column.EVENT_LAST_LEFT_PINNED_CHANGED = "lastLeftPinnedChanged";
_Column.EVENT_FIRST_RIGHT_PINNED_CHANGED = "firstRightPinnedChanged";
// + renderedColumn - for changing visibility icon
_Column.EVENT_VISIBLE_CHANGED = "visibleChanged";
// + every time the filter changes, used in the floating filters
_Column.EVENT_FILTER_CHANGED = "filterChanged";
// + renderedHeaderCell - marks the header with filter icon
_Column.EVENT_FILTER_ACTIVE_CHANGED = "filterActiveChanged";
// + renderedHeaderCell - marks the header with sort icon
_Column.EVENT_SORT_CHANGED = "sortChanged";
// + renderedHeaderCell - marks the header with sort icon
_Column.EVENT_COL_DEF_CHANGED = "colDefChanged";
_Column.EVENT_MENU_VISIBLE_CHANGED = "menuVisibleChanged";
// + toolpanel, for gui updates
_Column.EVENT_ROW_GROUP_CHANGED = "columnRowGroupChanged";
// + toolpanel, for gui updates
_Column.EVENT_PIVOT_CHANGED = "columnPivotChanged";
// + toolpanel, for gui updates
_Column.EVENT_VALUE_CHANGED = "columnValueChanged";
// + dataTypeService - when waiting to infer cell data types
_Column.EVENT_STATE_UPDATED = "columnStateUpdated";
__decorateClass([
  Autowired("gridOptionsService")
], _Column.prototype, "gridOptionsService", 2);
__decorateClass([
  Autowired("columnUtils")
], _Column.prototype, "columnUtils", 2);
__decorateClass([
  Autowired("columnHoverService")
], _Column.prototype, "columnHoverService", 2);
__decorateClass([
  Autowired("frameworkOverrides")
], _Column.prototype, "frameworkOverrides", 2);
__decorateClass([
  PostConstruct
], _Column.prototype, "initialise", 1);
var Column = _Column;

// community-modules/core/src/entities/providedColumnGroup.ts
var _ProvidedColumnGroup = class _ProvidedColumnGroup {
  constructor(colGroupDef, groupId, padding, level) {
    this.localEventService = new EventService();
    this.expandable = false;
    // used by React (and possibly other frameworks) as key for rendering. also used to
    // identify old vs new columns for destroying cols when no longer used.
    this.instanceId = getNextColInstanceId();
    this.expandableListenerRemoveCallback = null;
    this.colGroupDef = colGroupDef;
    this.groupId = groupId;
    this.expanded = !!colGroupDef && !!colGroupDef.openByDefault;
    this.padding = padding;
    this.level = level;
  }
  destroy() {
    if (this.expandableListenerRemoveCallback) {
      this.reset(null, void 0);
    }
  }
  reset(colGroupDef, level) {
    this.colGroupDef = colGroupDef;
    this.level = level;
    this.originalParent = null;
    if (this.expandableListenerRemoveCallback) {
      this.expandableListenerRemoveCallback();
    }
    this.children = void 0;
    this.expandable = void 0;
  }
  getInstanceId() {
    return this.instanceId;
  }
  setOriginalParent(originalParent) {
    this.originalParent = originalParent;
  }
  getOriginalParent() {
    return this.originalParent;
  }
  getLevel() {
    return this.level;
  }
  isVisible() {
    if (this.children) {
      return this.children.some((child) => child.isVisible());
    }
    return false;
  }
  isPadding() {
    return this.padding;
  }
  setExpanded(expanded) {
    this.expanded = expanded === void 0 ? false : expanded;
    const event = {
      type: _ProvidedColumnGroup.EVENT_EXPANDED_CHANGED
    };
    this.localEventService.dispatchEvent(event);
  }
  isExpandable() {
    return this.expandable;
  }
  isExpanded() {
    return this.expanded;
  }
  getGroupId() {
    return this.groupId;
  }
  getId() {
    return this.getGroupId();
  }
  setChildren(children) {
    this.children = children;
  }
  getChildren() {
    return this.children;
  }
  getColGroupDef() {
    return this.colGroupDef;
  }
  getLeafColumns() {
    const result = [];
    this.addLeafColumns(result);
    return result;
  }
  addLeafColumns(leafColumns) {
    if (!this.children) {
      return;
    }
    this.children.forEach((child) => {
      if (child instanceof Column) {
        leafColumns.push(child);
      } else if (child instanceof _ProvidedColumnGroup) {
        child.addLeafColumns(leafColumns);
      }
    });
  }
  getColumnGroupShow() {
    const colGroupDef = this.colGroupDef;
    if (!colGroupDef) {
      return;
    }
    return colGroupDef.columnGroupShow;
  }
  // need to check that this group has at least one col showing when both expanded and contracted.
  // if not, then we don't allow expanding and contracting on this group
  setupExpandable() {
    this.setExpandable();
    if (this.expandableListenerRemoveCallback) {
      this.expandableListenerRemoveCallback();
    }
    const listener = this.onColumnVisibilityChanged.bind(this);
    this.getLeafColumns().forEach((col) => col.addEventListener("visibleChanged", listener));
    this.expandableListenerRemoveCallback = () => {
      this.getLeafColumns().forEach((col) => col.removeEventListener("visibleChanged", listener));
      this.expandableListenerRemoveCallback = null;
    };
  }
  setExpandable() {
    if (this.isPadding()) {
      return;
    }
    let atLeastOneShowingWhenOpen = false;
    let atLeastOneShowingWhenClosed = false;
    let atLeastOneChangeable = false;
    const children = this.findChildrenRemovingPadding();
    for (let i = 0, j = children.length; i < j; i++) {
      const abstractColumn = children[i];
      if (!abstractColumn.isVisible()) {
        continue;
      }
      const headerGroupShow = abstractColumn.getColumnGroupShow();
      if (headerGroupShow === "open") {
        atLeastOneShowingWhenOpen = true;
        atLeastOneChangeable = true;
      } else if (headerGroupShow === "closed") {
        atLeastOneShowingWhenClosed = true;
        atLeastOneChangeable = true;
      } else {
        atLeastOneShowingWhenOpen = true;
        atLeastOneShowingWhenClosed = true;
      }
    }
    const expandable = atLeastOneShowingWhenOpen && atLeastOneShowingWhenClosed && atLeastOneChangeable;
    if (this.expandable !== expandable) {
      this.expandable = expandable;
      const event = {
        type: _ProvidedColumnGroup.EVENT_EXPANDABLE_CHANGED
      };
      this.localEventService.dispatchEvent(event);
    }
  }
  findChildrenRemovingPadding() {
    const res = [];
    const process = (items) => {
      items.forEach((item) => {
        const skipBecausePadding = item instanceof _ProvidedColumnGroup && item.isPadding();
        if (skipBecausePadding) {
          process(item.children);
        } else {
          res.push(item);
        }
      });
    };
    process(this.children);
    return res;
  }
  onColumnVisibilityChanged() {
    this.setExpandable();
  }
  addEventListener(eventType, listener) {
    this.localEventService.addEventListener(eventType, listener);
  }
  removeEventListener(eventType, listener) {
    this.localEventService.removeEventListener(eventType, listener);
  }
};
_ProvidedColumnGroup.EVENT_EXPANDED_CHANGED = "expandedChanged";
_ProvidedColumnGroup.EVENT_EXPANDABLE_CHANGED = "expandableChanged";
__decorateClass([
  PreDestroy
], _ProvidedColumnGroup.prototype, "destroy", 1);
var ProvidedColumnGroup = _ProvidedColumnGroup;

// community-modules/core/src/entities/defaultColumnTypes.ts
var DefaultColumnTypes = {
  numericColumn: {
    headerClass: "ag-right-aligned-header",
    cellClass: "ag-right-aligned-cell"
  },
  rightAligned: {
    headerClass: "ag-right-aligned-header",
    cellClass: "ag-right-aligned-cell"
  }
};

// community-modules/core/src/utils/event.ts
var event_exports = {};
__export(event_exports, {
  addSafePassiveEventListener: () => addSafePassiveEventListener,
  createEventPath: () => createEventPath,
  getCtrlForEventTarget: () => getCtrlForEventTarget,
  getEventPath: () => getEventPath,
  isElementInEventPath: () => isElementInEventPath,
  isEventSupported: () => isEventSupported,
  isStopPropagationForAgGrid: () => isStopPropagationForAgGrid,
  stopPropagationForAgGrid: () => stopPropagationForAgGrid
});

// community-modules/core/src/utils/array.ts
var array_exports = {};
__export(array_exports, {
  areEqual: () => areEqual,
  existsAndNotEmpty: () => existsAndNotEmpty,
  flatten: () => flatten,
  forEachReverse: () => forEachReverse,
  includes: () => includes,
  insertArrayIntoArray: () => insertArrayIntoArray,
  insertIntoArray: () => insertIntoArray,
  last: () => last,
  moveInArray: () => moveInArray,
  pushAll: () => pushAll,
  removeAllFromArray: () => removeAllFromArray,
  removeAllFromUnorderedArray: () => removeAllFromUnorderedArray,
  removeFromArray: () => removeFromArray,
  removeFromUnorderedArray: () => removeFromUnorderedArray,
  removeRepeatsFromArray: () => removeRepeatsFromArray,
  shallowCompare: () => shallowCompare,
  sortNumerically: () => sortNumerically,
  toStrings: () => toStrings
});
function existsAndNotEmpty(value) {
  return value != null && value.length > 0;
}
function last(arr) {
  if (!arr || !arr.length) {
    return;
  }
  return arr[arr.length - 1];
}
function areEqual(a, b, comparator) {
  if (a == null && b == null) {
    return true;
  }
  return a != null && b != null && a.length === b.length && a.every((value, index) => comparator ? comparator(value, b[index]) : b[index] === value);
}
function shallowCompare(arr1, arr2) {
  return areEqual(arr1, arr2);
}
function sortNumerically(array) {
  return array.sort((a, b) => a - b);
}
function removeRepeatsFromArray(array, object) {
  if (!array) {
    return;
  }
  for (let index = array.length - 2; index >= 0; index--) {
    const thisOneMatches = array[index] === object;
    const nextOneMatches = array[index + 1] === object;
    if (thisOneMatches && nextOneMatches) {
      array.splice(index + 1, 1);
    }
  }
}
function removeFromUnorderedArray(array, object) {
  const index = array.indexOf(object);
  if (index >= 0) {
    array[index] = array[array.length - 1];
    array.pop();
  }
}
function removeFromArray(array, object) {
  const index = array.indexOf(object);
  if (index >= 0) {
    array.splice(index, 1);
  }
}
function removeAllFromUnorderedArray(array, toRemove) {
  for (let i = 0; i < toRemove.length; i++) {
    removeFromUnorderedArray(array, toRemove[i]);
  }
}
function removeAllFromArray(array, toRemove) {
  for (let i = 0; i < toRemove.length; i++) {
    removeFromArray(array, toRemove[i]);
  }
}
function insertIntoArray(array, object, toIndex) {
  array.splice(toIndex, 0, object);
}
function insertArrayIntoArray(dest, src, toIndex) {
  if (dest == null || src == null) {
    return;
  }
  for (let i = src.length - 1; i >= 0; i--) {
    const item = src[i];
    insertIntoArray(dest, item, toIndex);
  }
}
function moveInArray(array, objectsToMove, toIndex) {
  removeAllFromArray(array, objectsToMove);
  objectsToMove.slice().reverse().forEach((obj) => insertIntoArray(array, obj, toIndex));
}
function includes(array, value) {
  return array.indexOf(value) > -1;
}
function flatten(arrayOfArrays) {
  return [].concat.apply([], arrayOfArrays);
}
function pushAll(target, source) {
  if (source == null || target == null) {
    return;
  }
  source.forEach((value) => target.push(value));
}
function toStrings(array) {
  return array.map(toStringOrNull);
}
function forEachReverse(list, action) {
  if (list == null) {
    return;
  }
  for (let i = list.length - 1; i >= 0; i--) {
    action(list[i], i);
  }
}

// community-modules/core/src/utils/event.ts
var AG_GRID_STOP_PROPAGATION = "__ag_Grid_Stop_Propagation";
var PASSIVE_EVENTS = ["touchstart", "touchend", "touchmove", "touchcancel", "scroll"];
var supports = {};
function stopPropagationForAgGrid(event) {
  event[AG_GRID_STOP_PROPAGATION] = true;
}
function isStopPropagationForAgGrid(event) {
  return event[AG_GRID_STOP_PROPAGATION] === true;
}
var isEventSupported = /* @__PURE__ */ (() => {
  const tags = {
    select: "input",
    change: "input",
    submit: "form",
    reset: "form",
    error: "img",
    load: "img",
    abort: "img"
  };
  const eventChecker = (eventName) => {
    if (typeof supports[eventName] === "boolean") {
      return supports[eventName];
    }
    const el = document.createElement(tags[eventName] || "div");
    eventName = "on" + eventName;
    return supports[eventName] = eventName in el;
  };
  return eventChecker;
})();
function getCtrlForEventTarget(gridOptionsService, eventTarget, type) {
  let sourceElement = eventTarget;
  while (sourceElement) {
    const renderedComp = gridOptionsService.getDomData(sourceElement, type);
    if (renderedComp) {
      return renderedComp;
    }
    sourceElement = sourceElement.parentElement;
  }
  return null;
}
function isElementInEventPath(element, event) {
  if (!event || !element) {
    return false;
  }
  return getEventPath(event).indexOf(element) >= 0;
}
function createEventPath(event) {
  const res = [];
  let pointer = event.target;
  while (pointer) {
    res.push(pointer);
    pointer = pointer.parentElement;
  }
  return res;
}
function getEventPath(event) {
  const eventNoType = event;
  if (eventNoType.path) {
    return eventNoType.path;
  }
  if (eventNoType.composedPath) {
    return eventNoType.composedPath();
  }
  return createEventPath(eventNoType);
}
function addSafePassiveEventListener(frameworkOverrides, eElement, event, listener) {
  const isPassive = includes(PASSIVE_EVENTS, event);
  const options = isPassive ? { passive: true } : void 0;
  if (frameworkOverrides && frameworkOverrides.addEventListener) {
    frameworkOverrides.addEventListener(eElement, event, listener, options);
  }
}

// community-modules/core/src/context/beanStub.ts
var _BeanStub = class _BeanStub {
  constructor() {
    this.destroyFunctions = [];
    this.destroyed = false;
    // for vue 3 - prevents Vue from trying to make this (and obviously any sub classes) from being reactive
    // prevents vue from creating proxies for created objects and prevents identity related issues
    this.__v_skip = true;
    // this was a test constructor niall built, when active, it prints after 5 seconds all beans/components that are
    // not destroyed. to use, create a new grid, then api.destroy() before 5 seconds. then anything that gets printed
    // points to a bean or component that was not properly disposed of.
    // constructor() {
    //     setTimeout(()=> {
    //         if (this.isAlive()) {
    //             let prototype: any = Object.getPrototypeOf(this);
    //             const constructor: any = prototype.constructor;
    //             const constructorString = constructor.toString();
    //             const beanName = constructorString.substring(9, constructorString.indexOf("("));
    //             console.log('is alive ' + beanName);
    //         }
    //     }, 5000);
    // }
    // Enable multiple grid properties to be updated together by the user but only trigger shared logic once.
    // Closely related to logic in ComponentUtil.ts
    this.lastChangeSetIdLookup = {};
    this.propertyListenerId = 0;
    this.isAlive = () => !this.destroyed;
  }
  // CellComp and GridComp and override this because they get the FrameworkOverrides from the Beans bean
  getFrameworkOverrides() {
    return this.frameworkOverrides;
  }
  getContext() {
    return this.context;
  }
  destroy() {
    this.destroyFunctions.forEach((func) => func());
    this.destroyFunctions.length = 0;
    this.destroyed = true;
    this.dispatchEvent({ type: _BeanStub.EVENT_DESTROYED });
  }
  addEventListener(eventType, listener) {
    if (!this.localEventService) {
      this.localEventService = new EventService();
    }
    this.localEventService.addEventListener(eventType, listener);
  }
  removeEventListener(eventType, listener) {
    if (this.localEventService) {
      this.localEventService.removeEventListener(eventType, listener);
    }
  }
  dispatchEvent(event) {
    if (this.localEventService) {
      this.localEventService.dispatchEvent(event);
    }
  }
  addManagedListener(object, event, listener) {
    if (this.destroyed) {
      return;
    }
    if (object instanceof HTMLElement) {
      addSafePassiveEventListener(this.getFrameworkOverrides(), object, event, listener);
    } else {
      object.addEventListener(event, listener);
    }
    const destroyFunc = () => {
      object.removeEventListener(event, listener);
      this.destroyFunctions = this.destroyFunctions.filter((fn) => fn !== destroyFunc);
      return null;
    };
    this.destroyFunctions.push(destroyFunc);
    return destroyFunc;
  }
  setupGridOptionListener(event, listener) {
    this.gridOptionsService.addEventListener(event, listener);
    const destroyFunc = () => {
      this.gridOptionsService.removeEventListener(event, listener);
      this.destroyFunctions = this.destroyFunctions.filter((fn) => fn !== destroyFunc);
      return null;
    };
    this.destroyFunctions.push(destroyFunc);
    return destroyFunc;
  }
  /**
   * Setup a managed property listener for the given GridOption property.
   * @param event GridOption property to listen to changes for.
   * @param listener Listener to run when property value changes
   */
  addManagedPropertyListener(event, listener) {
    if (this.destroyed) {
      return () => null;
    }
    return this.setupGridOptionListener(event, listener);
  }
  /**
   * Setup managed property listeners for the given set of GridOption properties.
   * The listener will be run if any of the property changes but will only run once if
   * multiple of the properties change within the same framework lifecycle event.
   * Works on the basis that GridOptionsService updates all properties *before* any property change events are fired.
   * @param events Array of GridOption properties to listen for changes too.
   * @param listener Shared listener to run if any of the properties change
   */
  addManagedPropertyListeners(events, listener) {
    if (this.destroyed) {
      return;
    }
    const eventsKey = events.join("-") + this.propertyListenerId++;
    const wrappedListener = (event) => {
      if (event.changeSet) {
        if (event.changeSet && event.changeSet.id === this.lastChangeSetIdLookup[eventsKey]) {
          return;
        }
        this.lastChangeSetIdLookup[eventsKey] = event.changeSet.id;
      }
      const propertiesChangeEvent = {
        type: "gridPropertyChanged",
        changeSet: event.changeSet,
        source: event.source
      };
      listener(propertiesChangeEvent);
    };
    events.forEach((event) => this.setupGridOptionListener(event, wrappedListener));
  }
  addDestroyFunc(func) {
    if (this.isAlive()) {
      this.destroyFunctions.push(func);
    } else {
      func();
    }
  }
  createManagedBean(bean, context) {
    const res = this.createBean(bean, context);
    this.addDestroyFunc(this.destroyBean.bind(this, bean, context));
    return res;
  }
  createBean(bean, context, afterPreCreateCallback) {
    return (context || this.getContext()).createBean(bean, afterPreCreateCallback);
  }
  destroyBean(bean, context) {
    return (context || this.getContext()).destroyBean(bean);
  }
  destroyBeans(beans, context) {
    if (beans) {
      beans.forEach((bean) => this.destroyBean(bean, context));
    }
    return [];
  }
};
_BeanStub.EVENT_DESTROYED = "destroyed";
__decorateClass([
  Autowired("frameworkOverrides")
], _BeanStub.prototype, "frameworkOverrides", 2);
__decorateClass([
  Autowired("context")
], _BeanStub.prototype, "context", 2);
__decorateClass([
  Autowired("eventService")
], _BeanStub.prototype, "eventService", 2);
__decorateClass([
  Autowired("gridOptionsService")
], _BeanStub.prototype, "gridOptionsService", 2);
__decorateClass([
  Autowired("localeService")
], _BeanStub.prototype, "localeService", 2);
__decorateClass([
  Autowired("environment")
], _BeanStub.prototype, "environment", 2);
__decorateClass([
  PreDestroy
], _BeanStub.prototype, "destroy", 1);
var BeanStub = _BeanStub;

// community-modules/core/src/columns/columnFactory.ts
var ColumnFactory = class extends BeanStub {
  setBeans(loggerFactory) {
    this.logger = loggerFactory.create("ColumnFactory");
  }
  createColumnTree(defs, primaryColumns, existingTree, source) {
    const columnKeyCreator = new ColumnKeyCreator();
    const { existingCols, existingGroups, existingColKeys } = this.extractExistingTreeData(existingTree);
    columnKeyCreator.addExistingKeys(existingColKeys);
    const unbalancedTree = this.recursivelyCreateColumns(
      defs,
      0,
      primaryColumns,
      existingCols,
      columnKeyCreator,
      existingGroups,
      source
    );
    const treeDept = this.findMaxDept(unbalancedTree, 0);
    this.logger.log("Number of levels for grouped columns is " + treeDept);
    const columnTree = this.balanceColumnTree(unbalancedTree, 0, treeDept, columnKeyCreator);
    const deptFirstCallback = (child, parent) => {
      if (child instanceof ProvidedColumnGroup) {
        child.setupExpandable();
      }
      child.setOriginalParent(parent);
    };
    this.columnUtils.depthFirstOriginalTreeSearch(null, columnTree, deptFirstCallback);
    return {
      columnTree,
      treeDept
    };
  }
  extractExistingTreeData(existingTree) {
    const existingCols = [];
    const existingGroups = [];
    const existingColKeys = [];
    if (existingTree) {
      this.columnUtils.depthFirstOriginalTreeSearch(null, existingTree, (item) => {
        if (item instanceof ProvidedColumnGroup) {
          const group = item;
          existingGroups.push(group);
        } else {
          const col = item;
          existingColKeys.push(col.getId());
          existingCols.push(col);
        }
      });
    }
    return { existingCols, existingGroups, existingColKeys };
  }
  createForAutoGroups(autoGroupCols, gridBalancedTree) {
    return autoGroupCols.map((col) => this.createAutoGroupTreeItem(gridBalancedTree, col));
  }
  createAutoGroupTreeItem(balancedColumnTree, column) {
    const dept = this.findDepth(balancedColumnTree);
    let nextChild = column;
    for (let i = dept - 1; i >= 0; i--) {
      const autoGroup = new ProvidedColumnGroup(
        null,
        `FAKE_PATH_${column.getId()}}_${i}`,
        true,
        i
      );
      this.createBean(autoGroup);
      autoGroup.setChildren([nextChild]);
      nextChild.setOriginalParent(autoGroup);
      nextChild = autoGroup;
    }
    if (dept === 0) {
      column.setOriginalParent(null);
    }
    return nextChild;
  }
  findDepth(balancedColumnTree) {
    let dept = 0;
    let pointer = balancedColumnTree;
    while (pointer && pointer[0] && pointer[0] instanceof ProvidedColumnGroup) {
      dept++;
      pointer = pointer[0].getChildren();
    }
    return dept;
  }
  balanceColumnTree(unbalancedTree, currentDept, columnDept, columnKeyCreator) {
    const result = [];
    for (let i = 0; i < unbalancedTree.length; i++) {
      const child = unbalancedTree[i];
      if (child instanceof ProvidedColumnGroup) {
        const originalGroup = child;
        const newChildren = this.balanceColumnTree(
          originalGroup.getChildren(),
          currentDept + 1,
          columnDept,
          columnKeyCreator
        );
        originalGroup.setChildren(newChildren);
        result.push(originalGroup);
      } else {
        let firstPaddedGroup;
        let currentPaddedGroup;
        for (let j = columnDept - 1; j >= currentDept; j--) {
          const newColId = columnKeyCreator.getUniqueKey(null, null);
          const colGroupDefMerged = this.createMergedColGroupDef(null);
          const paddedGroup = new ProvidedColumnGroup(colGroupDefMerged, newColId, true, currentDept);
          this.createBean(paddedGroup);
          if (currentPaddedGroup) {
            currentPaddedGroup.setChildren([paddedGroup]);
          }
          currentPaddedGroup = paddedGroup;
          if (!firstPaddedGroup) {
            firstPaddedGroup = currentPaddedGroup;
          }
        }
        if (firstPaddedGroup && currentPaddedGroup) {
          result.push(firstPaddedGroup);
          const hasGroups = unbalancedTree.some((leaf) => leaf instanceof ProvidedColumnGroup);
          if (hasGroups) {
            currentPaddedGroup.setChildren([child]);
            continue;
          } else {
            currentPaddedGroup.setChildren(unbalancedTree);
            break;
          }
        }
        result.push(child);
      }
    }
    return result;
  }
  findMaxDept(treeChildren, dept) {
    let maxDeptThisLevel = dept;
    for (let i = 0; i < treeChildren.length; i++) {
      const abstractColumn = treeChildren[i];
      if (abstractColumn instanceof ProvidedColumnGroup) {
        const originalGroup = abstractColumn;
        const newDept = this.findMaxDept(originalGroup.getChildren(), dept + 1);
        if (maxDeptThisLevel < newDept) {
          maxDeptThisLevel = newDept;
        }
      }
    }
    return maxDeptThisLevel;
  }
  recursivelyCreateColumns(defs, level, primaryColumns, existingColsCopy, columnKeyCreator, existingGroups, source) {
    if (!defs)
      return [];
    const result = new Array(defs.length);
    for (let i = 0; i < result.length; i++) {
      const def = defs[i];
      if (this.isColumnGroup(def)) {
        result[i] = this.createColumnGroup(
          primaryColumns,
          def,
          level,
          existingColsCopy,
          columnKeyCreator,
          existingGroups,
          source
        );
      } else {
        result[i] = this.createColumn(primaryColumns, def, existingColsCopy, columnKeyCreator, source);
      }
    }
    return result;
  }
  createColumnGroup(primaryColumns, colGroupDef, level, existingColumns, columnKeyCreator, existingGroups, source) {
    const colGroupDefMerged = this.createMergedColGroupDef(colGroupDef);
    const groupId = columnKeyCreator.getUniqueKey(colGroupDefMerged.groupId || null, null);
    const providedGroup = new ProvidedColumnGroup(colGroupDefMerged, groupId, false, level);
    this.createBean(providedGroup);
    const existingGroupAndIndex = this.findExistingGroup(colGroupDef, existingGroups);
    if (existingGroupAndIndex) {
      existingGroups.splice(existingGroupAndIndex.idx, 1);
    }
    let existingGroup = existingGroupAndIndex == null ? void 0 : existingGroupAndIndex.group;
    if (existingGroup) {
      providedGroup.setExpanded(existingGroup.isExpanded());
    }
    const children = this.recursivelyCreateColumns(
      colGroupDefMerged.children,
      level + 1,
      primaryColumns,
      existingColumns,
      columnKeyCreator,
      existingGroups,
      source
    );
    providedGroup.setChildren(children);
    return providedGroup;
  }
  createMergedColGroupDef(colGroupDef) {
    const colGroupDefMerged = {};
    Object.assign(colGroupDefMerged, this.gridOptionsService.get("defaultColGroupDef"));
    Object.assign(colGroupDefMerged, colGroupDef);
    return colGroupDefMerged;
  }
  createColumn(primaryColumns, colDef, existingColsCopy, columnKeyCreator, source) {
    const existingColAndIndex = this.findExistingColumn(colDef, existingColsCopy);
    if (existingColAndIndex) {
      existingColsCopy == null ? void 0 : existingColsCopy.splice(existingColAndIndex.idx, 1);
    }
    let column = existingColAndIndex == null ? void 0 : existingColAndIndex.column;
    if (!column) {
      const colId = columnKeyCreator.getUniqueKey(colDef.colId, colDef.field);
      const colDefMerged = this.addColumnDefaultAndTypes(colDef, colId);
      column = new Column(colDefMerged, colDef, colId, primaryColumns);
      this.context.createBean(column);
    } else {
      const colDefMerged = this.addColumnDefaultAndTypes(colDef, column.getColId());
      column.setColDef(colDefMerged, colDef, source);
      this.applyColumnState(column, colDefMerged, source);
    }
    this.dataTypeService.addColumnListeners(column);
    return column;
  }
  applyColumnState(column, colDef, source) {
    const flex = attrToNumber(colDef.flex);
    if (flex !== void 0) {
      column.setFlex(flex);
    }
    const noFlexThisCol = column.getFlex() <= 0;
    if (noFlexThisCol) {
      const width = attrToNumber(colDef.width);
      if (width != null) {
        column.setActualWidth(width, source);
      } else {
        const widthBeforeUpdate = column.getActualWidth();
        column.setActualWidth(widthBeforeUpdate, source);
      }
    }
    if (colDef.sort !== void 0) {
      if (colDef.sort == "asc" || colDef.sort == "desc") {
        column.setSort(colDef.sort, source);
      } else {
        column.setSort(void 0, source);
      }
    }
    const sortIndex = attrToNumber(colDef.sortIndex);
    if (sortIndex !== void 0) {
      column.setSortIndex(sortIndex);
    }
    const hide = attrToBoolean(colDef.hide);
    if (hide !== void 0) {
      column.setVisible(!hide, source);
    }
    if (colDef.pinned !== void 0) {
      column.setPinned(colDef.pinned);
    }
  }
  findExistingColumn(newColDef, existingColsCopy) {
    if (!existingColsCopy)
      return void 0;
    for (let i = 0; i < existingColsCopy.length; i++) {
      const def = existingColsCopy[i].getUserProvidedColDef();
      if (!def)
        continue;
      const newHasId = newColDef.colId != null;
      if (newHasId) {
        if (existingColsCopy[i].getId() === newColDef.colId) {
          return { idx: i, column: existingColsCopy[i] };
        }
        continue;
      }
      const newHasField = newColDef.field != null;
      if (newHasField) {
        if (def.field === newColDef.field) {
          return { idx: i, column: existingColsCopy[i] };
        }
        continue;
      }
      if (def === newColDef) {
        return { idx: i, column: existingColsCopy[i] };
      }
    }
    return void 0;
  }
  findExistingGroup(newGroupDef, existingGroups) {
    const newHasId = newGroupDef.groupId != null;
    if (!newHasId) {
      return void 0;
    }
    for (let i = 0; i < existingGroups.length; i++) {
      const existingGroup = existingGroups[i];
      const existingDef = existingGroup.getColGroupDef();
      if (!existingDef) {
        continue;
      }
      if (existingGroup.getId() === newGroupDef.groupId) {
        return { idx: i, group: existingGroup };
      }
    }
    return void 0;
  }
  addColumnDefaultAndTypes(colDef, colId) {
    const res = {};
    const defaultColDef = this.gridOptionsService.get("defaultColDef");
    mergeDeep(res, defaultColDef, false, true);
    const columnType = this.dataTypeService.updateColDefAndGetColumnType(res, colDef, colId);
    if (columnType) {
      this.assignColumnTypes(columnType, res);
    }
    mergeDeep(res, colDef, false, true);
    const autoGroupColDef = this.gridOptionsService.get("autoGroupColumnDef");
    const isSortingCoupled = this.gridOptionsService.isColumnsSortingCoupledToGroup();
    if (colDef.rowGroup && autoGroupColDef && isSortingCoupled) {
      mergeDeep(res, { sort: autoGroupColDef.sort, initialSort: autoGroupColDef.initialSort }, false, true);
    }
    this.dataTypeService.validateColDef(res);
    return res;
  }
  assignColumnTypes(typeKeys, colDefMerged) {
    if (!typeKeys.length) {
      return;
    }
    const allColumnTypes = Object.assign({}, DefaultColumnTypes);
    const userTypes = this.gridOptionsService.get("columnTypes") || {};
    iterateObject(userTypes, (key, value) => {
      if (key in allColumnTypes) {
        console.warn(`AG Grid: the column type '${key}' is a default column type and cannot be overridden.`);
      } else {
        const colType = value;
        if (colType.type) {
          warnOnce(`Column type definitions 'columnTypes' with a 'type' attribute are not supported because a column type cannot refer to another column type. Only column definitions 'columnDefs' can use the 'type' attribute to refer to a column type.`);
        }
        allColumnTypes[key] = value;
      }
    });
    typeKeys.forEach((t) => {
      const typeColDef = allColumnTypes[t.trim()];
      if (typeColDef) {
        mergeDeep(colDefMerged, typeColDef, false, true);
      } else {
        console.warn("AG Grid: colDef.type '" + t + "' does not correspond to defined gridOptions.columnTypes");
      }
    });
  }
  // if object has children, we assume it's a group
  isColumnGroup(abstractColDef) {
    return abstractColDef.children !== void 0;
  }
};
__decorateClass([
  Autowired("columnUtils")
], ColumnFactory.prototype, "columnUtils", 2);
__decorateClass([
  Autowired("dataTypeService")
], ColumnFactory.prototype, "dataTypeService", 2);
__decorateClass([
  __decorateParam(0, Qualifier("loggerFactory"))
], ColumnFactory.prototype, "setBeans", 1);
ColumnFactory = __decorateClass([
  Bean("columnFactory")
], ColumnFactory);

// community-modules/core/src/entities/columnGroup.ts
var _ColumnGroup = class _ColumnGroup {
  constructor(providedColumnGroup, groupId, partId, pinned) {
    // depends on the open/closed state of the group, only displaying columns are stored here
    this.displayedChildren = [];
    this.localEventService = new EventService();
    this.groupId = groupId;
    this.partId = partId;
    this.providedColumnGroup = providedColumnGroup;
    this.pinned = pinned;
  }
  // this is static, a it is used outside of this class
  static createUniqueId(groupId, instanceId) {
    return groupId + "_" + instanceId;
  }
  // as the user is adding and removing columns, the groups are recalculated.
  // this reset clears out all children, ready for children to be added again
  reset() {
    this.parent = null;
    this.children = null;
    this.displayedChildren = null;
  }
  getParent() {
    return this.parent;
  }
  setParent(parent) {
    this.parent = parent;
  }
  getUniqueId() {
    return _ColumnGroup.createUniqueId(this.groupId, this.partId);
  }
  isEmptyGroup() {
    return this.displayedChildren.length === 0;
  }
  isMoving() {
    const allLeafColumns = this.getProvidedColumnGroup().getLeafColumns();
    if (!allLeafColumns || allLeafColumns.length === 0) {
      return false;
    }
    return allLeafColumns.every((col) => col.isMoving());
  }
  checkLeft() {
    this.displayedChildren.forEach((child) => {
      if (child instanceof _ColumnGroup) {
        child.checkLeft();
      }
    });
    if (this.displayedChildren.length > 0) {
      if (this.gridOptionsService.get("enableRtl")) {
        const lastChild = last(this.displayedChildren);
        const lastChildLeft = lastChild.getLeft();
        this.setLeft(lastChildLeft);
      } else {
        const firstChildLeft = this.displayedChildren[0].getLeft();
        this.setLeft(firstChildLeft);
      }
    } else {
      this.setLeft(null);
    }
  }
  getLeft() {
    return this.left;
  }
  getOldLeft() {
    return this.oldLeft;
  }
  setLeft(left) {
    this.oldLeft = this.left;
    if (this.left !== left) {
      this.left = left;
      this.localEventService.dispatchEvent(this.createAgEvent(_ColumnGroup.EVENT_LEFT_CHANGED));
    }
  }
  getPinned() {
    return this.pinned;
  }
  createAgEvent(type) {
    return { type };
  }
  addEventListener(eventType, listener) {
    this.localEventService.addEventListener(eventType, listener);
  }
  removeEventListener(eventType, listener) {
    this.localEventService.removeEventListener(eventType, listener);
  }
  getGroupId() {
    return this.groupId;
  }
  getPartId() {
    return this.partId;
  }
  isChildInThisGroupDeepSearch(wantedChild) {
    let result = false;
    this.children.forEach((foundChild) => {
      if (wantedChild === foundChild) {
        result = true;
      }
      if (foundChild instanceof _ColumnGroup) {
        if (foundChild.isChildInThisGroupDeepSearch(wantedChild)) {
          result = true;
        }
      }
    });
    return result;
  }
  getActualWidth() {
    let groupActualWidth = 0;
    if (this.displayedChildren) {
      this.displayedChildren.forEach((child) => {
        groupActualWidth += child.getActualWidth();
      });
    }
    return groupActualWidth;
  }
  isResizable() {
    if (!this.displayedChildren) {
      return false;
    }
    let result = false;
    this.displayedChildren.forEach((child) => {
      if (child.isResizable()) {
        result = true;
      }
    });
    return result;
  }
  getMinWidth() {
    let result = 0;
    this.displayedChildren.forEach((groupChild) => {
      result += groupChild.getMinWidth() || 0;
    });
    return result;
  }
  addChild(child) {
    if (!this.children) {
      this.children = [];
    }
    this.children.push(child);
  }
  getDisplayedChildren() {
    return this.displayedChildren;
  }
  getLeafColumns() {
    const result = [];
    this.addLeafColumns(result);
    return result;
  }
  getDisplayedLeafColumns() {
    const result = [];
    this.addDisplayedLeafColumns(result);
    return result;
  }
  getDefinition() {
    return this.providedColumnGroup.getColGroupDef();
  }
  getColGroupDef() {
    return this.providedColumnGroup.getColGroupDef();
  }
  isPadding() {
    return this.providedColumnGroup.isPadding();
  }
  isExpandable() {
    return this.providedColumnGroup.isExpandable();
  }
  isExpanded() {
    return this.providedColumnGroup.isExpanded();
  }
  setExpanded(expanded) {
    this.providedColumnGroup.setExpanded(expanded);
  }
  addDisplayedLeafColumns(leafColumns) {
    this.displayedChildren.forEach((child) => {
      if (child instanceof Column) {
        leafColumns.push(child);
      } else if (child instanceof _ColumnGroup) {
        child.addDisplayedLeafColumns(leafColumns);
      }
    });
  }
  addLeafColumns(leafColumns) {
    this.children.forEach((child) => {
      if (child instanceof Column) {
        leafColumns.push(child);
      } else if (child instanceof _ColumnGroup) {
        child.addLeafColumns(leafColumns);
      }
    });
  }
  getChildren() {
    return this.children;
  }
  getColumnGroupShow() {
    return this.providedColumnGroup.getColumnGroupShow();
  }
  getProvidedColumnGroup() {
    return this.providedColumnGroup;
  }
  getPaddingLevel() {
    const parent = this.getParent();
    if (!this.isPadding() || !parent || !parent.isPadding()) {
      return 0;
    }
    return 1 + parent.getPaddingLevel();
  }
  calculateDisplayedColumns() {
    this.displayedChildren = [];
    let parentWithExpansion = this;
    while (parentWithExpansion != null && parentWithExpansion.isPadding()) {
      parentWithExpansion = parentWithExpansion.getParent();
    }
    const isExpandable = parentWithExpansion ? parentWithExpansion.providedColumnGroup.isExpandable() : false;
    if (!isExpandable) {
      this.displayedChildren = this.children;
      this.localEventService.dispatchEvent(this.createAgEvent(_ColumnGroup.EVENT_DISPLAYED_CHILDREN_CHANGED));
      return;
    }
    this.children.forEach((child) => {
      const emptyGroup = child instanceof _ColumnGroup && (!child.displayedChildren || !child.displayedChildren.length);
      if (emptyGroup) {
        return;
      }
      const headerGroupShow = child.getColumnGroupShow();
      switch (headerGroupShow) {
        case "open":
          if (parentWithExpansion.providedColumnGroup.isExpanded()) {
            this.displayedChildren.push(child);
          }
          break;
        case "closed":
          if (!parentWithExpansion.providedColumnGroup.isExpanded()) {
            this.displayedChildren.push(child);
          }
          break;
        default:
          this.displayedChildren.push(child);
          break;
      }
    });
    this.localEventService.dispatchEvent(this.createAgEvent(_ColumnGroup.EVENT_DISPLAYED_CHILDREN_CHANGED));
  }
};
_ColumnGroup.EVENT_LEFT_CHANGED = "leftChanged";
_ColumnGroup.EVENT_DISPLAYED_CHILDREN_CHANGED = "displayedChildrenChanged";
__decorateClass([
  Autowired("gridOptionsService")
], _ColumnGroup.prototype, "gridOptionsService", 2);
var ColumnGroup = _ColumnGroup;

// community-modules/core/src/eventKeys.ts
var Events = class {
  /*****************************  INTERNAL EVENTS: END ******************************************* */
};
/** Everything has changed with the columns. Either complete new set of columns set, or user called applyColumnState() */
/** @deprecated - grid no longer uses this, and setSate() also fires individual events */
Events.EVENT_COLUMN_EVERYTHING_CHANGED = "columnEverythingChanged";
/** User has set in new columns. */
Events.EVENT_NEW_COLUMNS_LOADED = "newColumnsLoaded";
/** The pivot mode flag was changed */
Events.EVENT_COLUMN_PIVOT_MODE_CHANGED = "columnPivotModeChanged";
/** Exceeded the pivot limit when generating columns */
Events.EVENT_PIVOT_MAX_COLUMNS_EXCEEDED = "pivotMaxColumnsExceeded";
/** A row group column was added, removed or order changed. */
Events.EVENT_COLUMN_ROW_GROUP_CHANGED = "columnRowGroupChanged";
/** expandAll / collapseAll was called from the api. */
Events.EVENT_EXPAND_COLLAPSE_ALL = "expandOrCollapseAll";
/** A pivot column was added, removed or order changed. */
Events.EVENT_COLUMN_PIVOT_CHANGED = "columnPivotChanged";
/** The list of grid columns has changed. */
Events.EVENT_GRID_COLUMNS_CHANGED = "gridColumnsChanged";
/** A value column was added, removed or agg function was changed. */
Events.EVENT_COLUMN_VALUE_CHANGED = "columnValueChanged";
/** A column was moved */
Events.EVENT_COLUMN_MOVED = "columnMoved";
/** One or more columns was shown / hidden */
Events.EVENT_COLUMN_VISIBLE = "columnVisible";
/** One or more columns was pinned / unpinned*/
Events.EVENT_COLUMN_PINNED = "columnPinned";
/** A column group was opened / closed */
Events.EVENT_COLUMN_GROUP_OPENED = "columnGroupOpened";
/** One or more columns was resized. If just one, the column in the event is set. */
Events.EVENT_COLUMN_RESIZED = "columnResized";
/** The list of displayed columns has changed, can result from columns open / close, column move, pivot, group, etc */
Events.EVENT_DISPLAYED_COLUMNS_CHANGED = "displayedColumnsChanged";
/** The grid option related to suppressing movable columns has changed */
Events.EVENT_SUPPRESS_COLUMN_MOVE_CHANGED = "suppressMovableColumns";
/** The grid option related to suppressing column group selection has changed */
Events.EVENT_SUPPRESS_MENU_HIDE_CHANGED = "suppressMenuHide";
/** The grid option related to suppressing movable columns has changed */
Events.EVENT_SUPPRESS_FIELD_DOT_NOTATION = "suppressFieldDotNotation";
/** The list of virtual columns has changed, results from viewport changing */
Events.EVENT_VIRTUAL_COLUMNS_CHANGED = "virtualColumnsChanged";
/** Column header mouse over */
Events.EVENT_COLUMN_HEADER_MOUSE_OVER = "columnHeaderMouseOver";
/** Column header mouse leave */
Events.EVENT_COLUMN_HEADER_MOUSE_LEAVE = "columnHeaderMouseLeave";
/** Column header clicked */
Events.EVENT_COLUMN_HEADER_CLICKED = "columnHeaderClicked";
/** Column header context menu event, such as right-click or context menu key press */
Events.EVENT_COLUMN_HEADER_CONTEXT_MENU = "columnHeaderContextMenu";
/** Async Transactions Executed */
Events.EVENT_ASYNC_TRANSACTIONS_FLUSHED = "asyncTransactionsFlushed";
/** A row group was opened / closed */
Events.EVENT_ROW_GROUP_OPENED = "rowGroupOpened";
/** Client-Side Row Model only. The client has updated data for the grid */
Events.EVENT_ROW_DATA_UPDATED = "rowDataUpdated";
/** The client has set new floating data into the grid */
Events.EVENT_PINNED_ROW_DATA_CHANGED = "pinnedRowDataChanged";
/** Range selection has changed */
Events.EVENT_RANGE_SELECTION_CHANGED = "rangeSelectionChanged";
/** Chart was created */
Events.EVENT_CHART_CREATED = "chartCreated";
/** Chart Range selection has changed */
Events.EVENT_CHART_RANGE_SELECTION_CHANGED = "chartRangeSelectionChanged";
/** Chart Options have changed */
Events.EVENT_CHART_OPTIONS_CHANGED = "chartOptionsChanged";
/** Chart was destroyed */
Events.EVENT_CHART_DESTROYED = "chartDestroyed";
/** For when the tool panel is shown / hidden */
Events.EVENT_TOOL_PANEL_VISIBLE_CHANGED = "toolPanelVisibleChanged";
Events.EVENT_TOOL_PANEL_SIZE_CHANGED = "toolPanelSizeChanged";
Events.EVENT_COLUMN_PANEL_ITEM_DRAG_START = "columnPanelItemDragStart";
Events.EVENT_COLUMN_PANEL_ITEM_DRAG_END = "columnPanelItemDragEnd";
/** Model was updated - grid updates the drawn rows when this happens */
Events.EVENT_MODEL_UPDATED = "modelUpdated";
Events.EVENT_CUT_START = "cutStart";
Events.EVENT_CUT_END = "cutEnd";
Events.EVENT_PASTE_START = "pasteStart";
Events.EVENT_PASTE_END = "pasteEnd";
Events.EVENT_FILL_START = "fillStart";
Events.EVENT_FILL_END = "fillEnd";
Events.EVENT_RANGE_DELETE_START = "rangeDeleteStart";
Events.EVENT_RANGE_DELETE_END = "rangeDeleteEnd";
/** Undo operation has started. */
Events.EVENT_UNDO_STARTED = "undoStarted";
/** Undo operation has ended. */
Events.EVENT_UNDO_ENDED = "undoEnded";
/** Redo operation has started. */
Events.EVENT_REDO_STARTED = "redoStarted";
/** Redo operation has ended. */
Events.EVENT_REDO_ENDED = "redoEnded";
Events.EVENT_KEY_SHORTCUT_CHANGED_CELL_START = "keyShortcutChangedCellStart";
Events.EVENT_KEY_SHORTCUT_CHANGED_CELL_END = "keyShortcutChangedCellEnd";
Events.EVENT_CELL_CLICKED = "cellClicked";
Events.EVENT_CELL_DOUBLE_CLICKED = "cellDoubleClicked";
Events.EVENT_CELL_MOUSE_DOWN = "cellMouseDown";
Events.EVENT_CELL_CONTEXT_MENU = "cellContextMenu";
Events.EVENT_CELL_VALUE_CHANGED = "cellValueChanged";
Events.EVENT_CELL_EDIT_REQUEST = "cellEditRequest";
Events.EVENT_ROW_VALUE_CHANGED = "rowValueChanged";
Events.EVENT_CELL_FOCUSED = "cellFocused";
Events.EVENT_CELL_FOCUS_CLEARED = "cellFocusCleared";
Events.EVENT_FULL_WIDTH_ROW_FOCUSED = "fullWidthRowFocused";
Events.EVENT_ROW_SELECTED = "rowSelected";
Events.EVENT_SELECTION_CHANGED = "selectionChanged";
Events.EVENT_TOOLTIP_SHOW = "tooltipShow";
Events.EVENT_TOOLTIP_HIDE = "tooltipHide";
Events.EVENT_CELL_KEY_DOWN = "cellKeyDown";
Events.EVENT_CELL_MOUSE_OVER = "cellMouseOver";
Events.EVENT_CELL_MOUSE_OUT = "cellMouseOut";
/** 2 events for filtering. The grid LISTENS for filterChanged and afterFilterChanged */
Events.EVENT_FILTER_CHANGED = "filterChanged";
/** Filter was change but not applied. Only useful if apply buttons are used in filters. */
Events.EVENT_FILTER_MODIFIED = "filterModified";
Events.EVENT_FILTER_OPENED = "filterOpened";
Events.EVENT_ADVANCED_FILTER_BUILDER_VISIBLE_CHANGED = "advancedFilterBuilderVisibleChanged";
Events.EVENT_SORT_CHANGED = "sortChanged";
/** A row was removed from the dom, for any reason. Use to clean up resources (if any) used by the row. */
Events.EVENT_VIRTUAL_ROW_REMOVED = "virtualRowRemoved";
Events.EVENT_ROW_CLICKED = "rowClicked";
Events.EVENT_ROW_DOUBLE_CLICKED = "rowDoubleClicked";
/** Gets called once after the grid has finished initialising. */
Events.EVENT_GRID_READY = "gridReady";
/** Called once when the grid is about to get destroyed. */
Events.EVENT_GRID_PRE_DESTROYED = "gridPreDestroyed";
/** Width of height of the main grid div has changed. Grid listens for this and does layout of grid if it's
 * changed, so always filling the space it was given. */
Events.EVENT_GRID_SIZE_CHANGED = "gridSizeChanged";
/** The indexes of the rows rendered has changed, eg user has scrolled to a new vertical position. */
Events.EVENT_VIEWPORT_CHANGED = "viewportChanged";
/* The width of the scrollbar has been calculated */
Events.EVENT_SCROLLBAR_WIDTH_CHANGED = "scrollbarWidthChanged";
/** Rows were rendered for the first time (ie on async data load). */
Events.EVENT_FIRST_DATA_RENDERED = "firstDataRendered";
/** A column drag has started, either resizing a column or moving a column. */
Events.EVENT_DRAG_STARTED = "dragStarted";
/** A column drag has stopped */
Events.EVENT_DRAG_STOPPED = "dragStopped";
Events.EVENT_CHECKBOX_CHANGED = "checkboxChanged";
Events.EVENT_ROW_EDITING_STARTED = "rowEditingStarted";
Events.EVENT_ROW_EDITING_STOPPED = "rowEditingStopped";
Events.EVENT_CELL_EDITING_STARTED = "cellEditingStarted";
Events.EVENT_CELL_EDITING_STOPPED = "cellEditingStopped";
/** Main body of grid has scrolled, either horizontally or vertically */
Events.EVENT_BODY_SCROLL = "bodyScroll";
/** Main body of the grid has stopped scrolling, either horizontally or vertically */
Events.EVENT_BODY_SCROLL_END = "bodyScrollEnd";
Events.EVENT_HEIGHT_SCALE_CHANGED = "heightScaleChanged";
/** The displayed page for pagination has changed. For example the data was filtered or sorted,
 * or the user has moved to a different page. */
Events.EVENT_PAGINATION_CHANGED = "paginationChanged";
/** Only used by React, Angular, Web Components and VueJS AG Grid components
 * (not used if doing plain JavaScript). If the grid receives changes due
 * to bound properties, this event fires after the grid has finished processing the change. */
Events.EVENT_COMPONENT_STATE_CHANGED = "componentStateChanged";
/** Only used by the SSRM, called when the grid has no more rows to refresh */
Events.EVENT_STORE_REFRESHED = "storeRefreshed";
Events.EVENT_STATE_UPDATED = "stateUpdated";
/** The visibility of the column menu has changed. */
Events.EVENT_COLUMN_MENU_VISIBLE_CHANGED = "columnMenuVisibleChanged";
/*****************************  INTERNAL EVENTS: START ******************************************* */
/** Please remember to add to ComponentUtil.EXCLUDED_INTERNAL_EVENTS to not have these events exposed to framework components. */
/** All items from here down are used internally by the grid, not intended for external use. */
// not documented, either experimental, or we just don't want users using an depending on them
Events.EVENT_BODY_HEIGHT_CHANGED = "bodyHeightChanged";
Events.EVENT_COLUMN_CONTAINER_WIDTH_CHANGED = "columnContainerWidthChanged";
Events.EVENT_DISPLAYED_COLUMNS_WIDTH_CHANGED = "displayedColumnsWidthChanged";
Events.EVENT_SCROLL_VISIBILITY_CHANGED = "scrollVisibilityChanged";
Events.EVENT_COLUMN_HOVER_CHANGED = "columnHoverChanged";
Events.EVENT_FLASH_CELLS = "flashCells";
Events.EVENT_PAGINATION_PIXEL_OFFSET_CHANGED = "paginationPixelOffsetChanged";
Events.EVENT_DISPLAYED_ROWS_CHANGED = "displayedRowsChanged";
Events.EVENT_LEFT_PINNED_WIDTH_CHANGED = "leftPinnedWidthChanged";
Events.EVENT_RIGHT_PINNED_WIDTH_CHANGED = "rightPinnedWidthChanged";
Events.EVENT_ROW_CONTAINER_HEIGHT_CHANGED = "rowContainerHeightChanged";
Events.EVENT_HEADER_HEIGHT_CHANGED = "headerHeightChanged";
Events.EVENT_COLUMN_HEADER_HEIGHT_CHANGED = "columnHeaderHeightChanged";
Events.EVENT_ROW_DRAG_ENTER = "rowDragEnter";
Events.EVENT_ROW_DRAG_MOVE = "rowDragMove";
Events.EVENT_ROW_DRAG_LEAVE = "rowDragLeave";
Events.EVENT_ROW_DRAG_END = "rowDragEnd";
// environment
Events.EVENT_GRID_STYLES_CHANGED = "gridStylesChanged";
// these are used for server side group and agg - only used by CS with Viewport Row Model - intention is
// to design these better around server side functions and then release to general public when fully working with
// all the row models.
Events.EVENT_COLUMN_ROW_GROUP_CHANGE_REQUEST = "columnRowGroupChangeRequest";
Events.EVENT_COLUMN_PIVOT_CHANGE_REQUEST = "columnPivotChangeRequest";
Events.EVENT_COLUMN_VALUE_CHANGE_REQUEST = "columnValueChangeRequest";
Events.EVENT_COLUMN_AGG_FUNC_CHANGE_REQUEST = "columnAggFuncChangeRequest";
Events.EVENT_STORE_UPDATED = "storeUpdated";
Events.EVENT_FILTER_DESTROYED = "filterDestroyed";
Events.EVENT_ROW_DATA_UPDATE_STARTED = "rowDataUpdateStarted";
Events.EVENT_ROW_COUNT_READY = "rowCountReady";
// Advanced Filters
Events.EVENT_ADVANCED_FILTER_ENABLED_CHANGED = "advancedFilterEnabledChanged";
Events.EVENT_DATA_TYPES_INFERRED = "dataTypesInferred";
// Widgets
Events.EVENT_FIELD_VALUE_CHANGED = "fieldValueChanged";
Events.EVENT_FIELD_PICKER_VALUE_SELECTED = "fieldPickerValueSelected";
Events.EVENT_SIDE_BAR_UPDATED = "sideBarUpdated";

// community-modules/core/src/events.ts
var ALWAYS_SYNC_GLOBAL_EVENTS = /* @__PURE__ */ new Set([Events.EVENT_GRID_PRE_DESTROYED]);

// community-modules/core/src/columns/groupInstanceIdCreator.ts
var GroupInstanceIdCreator = class {
  constructor() {
    // this map contains keys to numbers, so we remember what the last call was
    this.existingIds = {};
  }
  getInstanceIdForKey(key) {
    const lastResult = this.existingIds[key];
    let result;
    if (typeof lastResult !== "number") {
      result = 0;
    } else {
      result = lastResult + 1;
    }
    this.existingIds[key] = result;
    return result;
  }
};

// community-modules/core/src/columns/autoGroupColService.ts
var GROUP_AUTO_COLUMN_ID = "ag-Grid-AutoColumn";
var AutoGroupColService = class extends BeanStub {
  createAutoGroupColumns(rowGroupColumns) {
    const groupAutoColumns = [];
    const doingTreeData = this.gridOptionsService.get("treeData");
    let doingMultiAutoColumn = this.gridOptionsService.isGroupMultiAutoColumn();
    if (doingTreeData && doingMultiAutoColumn) {
      console.warn('AG Grid: you cannot mix groupDisplayType = "multipleColumns" with treeData, only one column can be used to display groups when doing tree data');
      doingMultiAutoColumn = false;
    }
    if (doingMultiAutoColumn) {
      rowGroupColumns.forEach((rowGroupCol, index) => {
        groupAutoColumns.push(this.createOneAutoGroupColumn(rowGroupCol, index));
      });
    } else {
      groupAutoColumns.push(this.createOneAutoGroupColumn());
    }
    return groupAutoColumns;
  }
  updateAutoGroupColumns(autoGroupColumns, source) {
    autoGroupColumns.forEach((column, index) => this.updateOneAutoGroupColumn(column, index, source));
  }
  // rowGroupCol and index are missing if groupDisplayType != "multipleColumns"
  createOneAutoGroupColumn(rowGroupCol, index) {
    let colId;
    if (rowGroupCol) {
      colId = `${GROUP_AUTO_COLUMN_ID}-${rowGroupCol.getId()}`;
    } else {
      colId = GROUP_AUTO_COLUMN_ID;
    }
    const colDef = this.createAutoGroupColDef(colId, rowGroupCol, index);
    colDef.colId = colId;
    const newCol = new Column(colDef, null, colId, true);
    this.context.createBean(newCol);
    return newCol;
  }
  /**
   * Refreshes an auto group col to load changes from defaultColDef or autoGroupColDef
   */
  updateOneAutoGroupColumn(colToUpdate, index, source) {
    const oldColDef = colToUpdate.getColDef();
    const underlyingColId = typeof oldColDef.showRowGroup == "string" ? oldColDef.showRowGroup : void 0;
    const underlyingColumn = underlyingColId != null ? this.columnModel.getPrimaryColumn(underlyingColId) : void 0;
    const colDef = this.createAutoGroupColDef(colToUpdate.getId(), underlyingColumn != null ? underlyingColumn : void 0, index);
    colToUpdate.setColDef(colDef, null, source);
    this.columnFactory.applyColumnState(colToUpdate, colDef, source);
  }
  createAutoGroupColDef(colId, underlyingColumn, index) {
    let res = this.createBaseColDef(underlyingColumn);
    const autoGroupColumnDef = this.gridOptionsService.get("autoGroupColumnDef");
    mergeDeep(res, autoGroupColumnDef);
    res = this.columnFactory.addColumnDefaultAndTypes(res, colId);
    if (!this.gridOptionsService.get("treeData")) {
      const noFieldOrValueGetter = missing(res.field) && missing(res.valueGetter) && missing(res.filterValueGetter) && res.filter !== "agGroupColumnFilter";
      if (noFieldOrValueGetter) {
        res.filter = false;
      }
    }
    if (index && index > 0) {
      res.headerCheckboxSelection = false;
    }
    const isSortingCoupled = this.gridOptionsService.isColumnsSortingCoupledToGroup();
    const hasOwnData = res.valueGetter || res.field != null;
    if (isSortingCoupled && !hasOwnData) {
      res.sortIndex = void 0;
      res.initialSort = void 0;
    }
    return res;
  }
  createBaseColDef(rowGroupCol) {
    const userDef = this.gridOptionsService.get("autoGroupColumnDef");
    const localeTextFunc = this.localeService.getLocaleTextFunc();
    const res = {
      headerName: localeTextFunc("group", "Group")
    };
    const userHasProvidedGroupCellRenderer = userDef && (userDef.cellRenderer || userDef.cellRendererSelector);
    if (!userHasProvidedGroupCellRenderer) {
      res.cellRenderer = "agGroupCellRenderer";
    }
    if (rowGroupCol) {
      const colDef = rowGroupCol.getColDef();
      Object.assign(res, {
        // cellRendererParams.groupKey: colDefToCopy.field;
        headerName: this.columnModel.getDisplayNameForColumn(rowGroupCol, "header"),
        headerValueGetter: colDef.headerValueGetter
      });
      if (colDef.cellRenderer) {
        Object.assign(res, {
          cellRendererParams: {
            innerRenderer: colDef.cellRenderer,
            innerRendererParams: colDef.cellRendererParams
          }
        });
      }
      res.showRowGroup = rowGroupCol.getColId();
    } else {
      res.showRowGroup = true;
    }
    return res;
  }
};
__decorateClass([
  Autowired("columnModel")
], AutoGroupColService.prototype, "columnModel", 2);
__decorateClass([
  Autowired("columnFactory")
], AutoGroupColService.prototype, "columnFactory", 2);
AutoGroupColService = __decorateClass([
  Bean("autoGroupColService")
], AutoGroupColService);

// community-modules/core/src/utils/string.ts
var string_exports = {};
__export(string_exports, {
  camelCaseToHumanText: () => camelCaseToHumanText,
  camelCaseToHyphenated: () => camelCaseToHyphenated,
  capitalise: () => capitalise,
  escapeString: () => escapeString,
  utf8_encode: () => utf8_encode
});
var reUnescapedHtml = /[&<>"']/g;
var HTML_ESCAPES = {
  "&": "&amp;",
  "<": "&lt;",
  ">": "&gt;",
  '"': "&quot;",
  "'": "&#39;"
};
function utf8_encode(s) {
  const stringFromCharCode = String.fromCharCode;
  function ucs2decode(string) {
    const output = [];
    if (!string) {
      return [];
    }
    const len = string.length;
    let counter = 0;
    let value;
    let extra;
    while (counter < len) {
      value = string.charCodeAt(counter++);
      if (value >= 55296 && value <= 56319 && counter < len) {
        extra = string.charCodeAt(counter++);
        if ((extra & 64512) == 56320) {
          output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
        } else {
          output.push(value);
          counter--;
        }
      } else {
        output.push(value);
      }
    }
    return output;
  }
  function checkScalarValue(point) {
    if (point >= 55296 && point <= 57343) {
      throw Error(
        "Lone surrogate U+" + point.toString(16).toUpperCase() + " is not a scalar value"
      );
    }
  }
  function createByte(point, shift) {
    return stringFromCharCode(point >> shift & 63 | 128);
  }
  function encodeCodePoint(point) {
    if (point >= 0 && point <= 31 && point !== 10) {
      const convertedCode = point.toString(16).toUpperCase();
      const paddedCode = convertedCode.padStart(4, "0");
      return `_x${paddedCode}_`;
    }
    if ((point & 4294967168) == 0) {
      return stringFromCharCode(point);
    }
    let symbol = "";
    if ((point & 4294965248) == 0) {
      symbol = stringFromCharCode(point >> 6 & 31 | 192);
    } else if ((point & 4294901760) == 0) {
      checkScalarValue(point);
      symbol = stringFromCharCode(point >> 12 & 15 | 224);
      symbol += createByte(point, 6);
    } else if ((point & 4292870144) == 0) {
      symbol = stringFromCharCode(point >> 18 & 7 | 240);
      symbol += createByte(point, 12);
      symbol += createByte(point, 6);
    }
    symbol += stringFromCharCode(point & 63 | 128);
    return symbol;
  }
  const codePoints = ucs2decode(s);
  const length = codePoints.length;
  let index = -1;
  let codePoint;
  let byteString = "";
  while (++index < length) {
    codePoint = codePoints[index];
    byteString += encodeCodePoint(codePoint);
  }
  return byteString;
}
function capitalise(str) {
  return str[0].toUpperCase() + str.substring(1).toLowerCase();
}
function escapeString(toEscape, skipEscapingHtmlChars) {
  if (toEscape == null) {
    return null;
  }
  const stringResult = toEscape.toString().toString();
  if (skipEscapingHtmlChars) {
    return stringResult;
  }
  return stringResult.replace(reUnescapedHtml, (chr) => HTML_ESCAPES[chr]);
}
function camelCaseToHumanText(camelCase) {
  if (!camelCase || camelCase == null) {
    return null;
  }
  const rex = /([a-z])([A-Z])/g;
  const rexCaps = /([A-Z]+)([A-Z])([a-z])/g;
  const words = camelCase.replace(rex, "$1 $2").replace(rexCaps, "$1 $2$3").replace(/\./g, " ").split(" ");
  return words.map((word) => word.substring(0, 1).toUpperCase() + (word.length > 1 ? word.substring(1, word.length) : "")).join(" ");
}
function camelCaseToHyphenated(camelCase) {
  return camelCase.replace(/[A-Z]/g, (s) => `-${s.toLocaleLowerCase()}`);
}

// community-modules/core/src/utils/map.ts
var map_exports = {};
__export(map_exports, {
  convertToMap: () => convertToMap,
  keys: () => keys,
  mapById: () => mapById
});
function convertToMap(arr) {
  const map = /* @__PURE__ */ new Map();
  arr.forEach((pair) => map.set(pair[0], pair[1]));
  return map;
}
function mapById(arr, callback) {
  const map = /* @__PURE__ */ new Map();
  arr.forEach((item) => map.set(callback(item), item));
  return map;
}
function keys(map) {
  const arr = [];
  map.forEach((_2, key) => arr.push(key));
  return arr;
}

// community-modules/core/src/columns/columnModel.ts
var ColumnModel = class extends BeanStub {
  constructor() {
    super(...arguments);
    // header row count, based on user provided columns
    this.primaryHeaderRowCount = 0;
    this.secondaryHeaderRowCount = 0;
    // header row count, either above, or based on pivoting if we are pivoting
    this.gridHeaderRowCount = 0;
    // leave level columns of the displayed trees
    this.displayedColumnsLeft = [];
    this.displayedColumnsRight = [];
    this.displayedColumnsCenter = [];
    // all three lists above combined
    this.displayedColumns = [];
    // for fast lookup, to see if a column or group is still displayed
    this.displayedColumnsAndGroupsMap = {};
    // all columns to be rendered
    this.viewportColumns = [];
    // A hash key to keep track of changes in viewport columns
    this.viewportColumnsHash = "";
    // same as viewportColumns, except we always include columns with headerAutoHeight
    this.headerViewportColumns = [];
    // all columns to be rendered in the centre
    this.viewportColumnsCenter = [];
    // same as viewportColumnsCenter, except we always include columns with headerAutoHeight
    this.headerViewportColumnsCenter = [];
    // all columns & groups to be rendered, index by row. used by header rows to get all items
    // to render for that row.
    this.viewportRowLeft = {};
    this.viewportRowRight = {};
    this.viewportRowCenter = {};
    this.autoHeightActiveAtLeastOnce = false;
    this.rowGroupColumns = [];
    this.valueColumns = [];
    this.pivotColumns = [];
    this.ready = false;
    this.changeEventsDispatching = false;
    this.autoGroupsNeedBuilding = false;
    this.forceRecreateAutoGroups = false;
    this.pivotMode = false;
    this.bodyWidth = 0;
    this.leftWidth = 0;
    this.rightWidth = 0;
    this.bodyWidthDirty = true;
    // when we're waiting for cell data types to be inferred, we need to defer column resizing
    this.shouldQueueResizeOperations = false;
    this.resizeOperationQueue = [];
  }
  init() {
    this.suppressColumnVirtualisation = this.gridOptionsService.get("suppressColumnVirtualisation");
    const pivotMode = this.gridOptionsService.get("pivotMode");
    if (this.isPivotSettingAllowed(pivotMode)) {
      this.pivotMode = pivotMode;
    }
    this.addManagedPropertyListeners(["groupDisplayType", "treeData", "treeDataDisplayType", "groupHideOpenParents"], (event) => this.buildAutoGroupColumns(convertSourceType(event.source)));
    this.addManagedPropertyListener("autoGroupColumnDef", (event) => this.onAutoGroupColumnDefChanged(convertSourceType(event.source)));
    this.addManagedPropertyListeners(["defaultColDef", "columnTypes", "suppressFieldDotNotation"], (event) => this.onSharedColDefChanged(convertSourceType(event.source)));
    this.addManagedPropertyListener("pivotMode", (event) => this.setPivotMode(this.gridOptionsService.get("pivotMode"), convertSourceType(event.source)));
    this.addManagedListener(this.eventService, Events.EVENT_FIRST_DATA_RENDERED, () => this.onFirstDataRendered());
  }
  buildAutoGroupColumns(source) {
    if (!this.columnDefs) {
      return;
    }
    this.autoGroupsNeedBuilding = true;
    this.forceRecreateAutoGroups = true;
    this.updateGridColumns();
    this.updateDisplayedColumns(source);
  }
  onAutoGroupColumnDefChanged(source) {
    if (this.groupAutoColumns) {
      this.autoGroupColService.updateAutoGroupColumns(this.groupAutoColumns, source);
    }
  }
  onSharedColDefChanged(source) {
    if (!this.gridColumns) {
      return;
    }
    if (this.groupAutoColumns) {
      this.autoGroupColService.updateAutoGroupColumns(this.groupAutoColumns, source);
    }
    this.createColumnsFromColumnDefs(true, source);
  }
  setColumnDefs(columnDefs, source) {
    const colsPreviouslyExisted = !!this.columnDefs;
    this.columnDefs = columnDefs;
    this.createColumnsFromColumnDefs(colsPreviouslyExisted, source);
  }
  recreateColumnDefs(source) {
    this.onSharedColDefChanged(source);
  }
  destroyOldColumns(oldTree, newTree) {
    const oldObjectsById = {};
    if (!oldTree) {
      return;
    }
    this.columnUtils.depthFirstOriginalTreeSearch(null, oldTree, (child) => {
      oldObjectsById[child.getInstanceId()] = child;
    });
    if (newTree) {
      this.columnUtils.depthFirstOriginalTreeSearch(null, newTree, (child) => {
        oldObjectsById[child.getInstanceId()] = null;
      });
    }
    const colsToDestroy = Object.values(oldObjectsById).filter((item) => item != null);
    this.destroyBeans(colsToDestroy);
  }
  destroyColumns() {
    this.destroyOldColumns(this.primaryColumnTree);
    this.destroyOldColumns(this.secondaryBalancedTree);
    this.destroyOldColumns(this.groupAutoColsBalancedTree);
  }
  createColumnsFromColumnDefs(colsPreviouslyExisted, source) {
    const dispatchEventsFunc = colsPreviouslyExisted ? this.compareColumnStatesAndDispatchEvents(source) : void 0;
    this.valueCache.expire();
    this.autoGroupsNeedBuilding = true;
    const oldPrimaryColumns = this.primaryColumns;
    const oldPrimaryTree = this.primaryColumnTree;
    const balancedTreeResult = this.columnFactory.createColumnTree(this.columnDefs, true, oldPrimaryTree, source);
    this.destroyOldColumns(this.primaryColumnTree, balancedTreeResult.columnTree);
    this.primaryColumnTree = balancedTreeResult.columnTree;
    this.primaryHeaderRowCount = balancedTreeResult.treeDept + 1;
    this.primaryColumns = this.getColumnsFromTree(this.primaryColumnTree);
    this.primaryColumnsMap = {};
    this.primaryColumns.forEach((col) => this.primaryColumnsMap[col.getId()] = col);
    this.extractRowGroupColumns(source, oldPrimaryColumns);
    this.extractPivotColumns(source, oldPrimaryColumns);
    this.extractValueColumns(source, oldPrimaryColumns);
    this.ready = true;
    const gridColsNotProcessed = this.gridColsArePrimary === void 0;
    const processGridCols = this.gridColsArePrimary || gridColsNotProcessed || this.autoGroupsNeedBuilding;
    if (processGridCols) {
      this.updateGridColumns();
      if (colsPreviouslyExisted && this.gridColsArePrimary && !this.gridOptionsService.get("maintainColumnOrder")) {
        this.orderGridColumnsLikePrimary();
      }
      this.updateDisplayedColumns(source);
      this.checkViewportColumns();
    }
    this.dispatchEverythingChanged(source);
    this.changeEventsDispatching = true;
    if (dispatchEventsFunc) {
      dispatchEventsFunc();
    }
    this.changeEventsDispatching = false;
    this.dispatchNewColumnsLoaded(source);
  }
  shouldRowModelIgnoreRefresh() {
    return this.changeEventsDispatching;
  }
  dispatchNewColumnsLoaded(source) {
    const newColumnsLoadedEvent = {
      type: Events.EVENT_NEW_COLUMNS_LOADED,
      source
    };
    this.eventService.dispatchEvent(newColumnsLoadedEvent);
    if (source === "gridInitializing") {
      this.onColumnsReady();
    }
  }
  // this event is legacy, no grid code listens to it. instead the grid listens to New Columns Loaded
  dispatchEverythingChanged(source) {
    const eventEverythingChanged = {
      type: Events.EVENT_COLUMN_EVERYTHING_CHANGED,
      source
    };
    this.eventService.dispatchEvent(eventEverythingChanged);
  }
  orderGridColumnsLikePrimary() {
    const primaryColumns = this.primaryColumns;
    if (!primaryColumns) {
      return;
    }
    const primaryColsOrdered = primaryColumns.filter((col) => this.gridColumns.indexOf(col) >= 0);
    const otherCols = this.gridColumns.filter((col) => primaryColsOrdered.indexOf(col) < 0);
    this.gridColumns = [...otherCols, ...primaryColsOrdered];
    this.gridColumns = this.placeLockedColumns(this.gridColumns);
  }
  getAllDisplayedAutoHeightCols() {
    return this.displayedAutoHeightCols;
  }
  setViewport() {
    if (this.gridOptionsService.get("enableRtl")) {
      this.viewportLeft = this.bodyWidth - this.scrollPosition - this.scrollWidth;
      this.viewportRight = this.bodyWidth - this.scrollPosition;
    } else {
      this.viewportLeft = this.scrollPosition;
      this.viewportRight = this.scrollWidth + this.scrollPosition;
    }
  }
  // used by clipboard service, to know what columns to paste into
  getDisplayedColumnsStartingAt(column) {
    let currentColumn = column;
    const columns = [];
    while (currentColumn != null) {
      columns.push(currentColumn);
      currentColumn = this.getDisplayedColAfter(currentColumn);
    }
    return columns;
  }
  // checks what columns are currently displayed due to column virtualisation. dispatches an event
  // if the list of columns has changed.
  // + setColumnWidth(), setViewportPosition(), setColumnDefs(), sizeColumnsToFit()
  checkViewportColumns(afterScroll = false) {
    if (this.displayedColumnsCenter == null) {
      return;
    }
    const viewportColumnsChanged = this.extractViewport();
    if (!viewportColumnsChanged) {
      return;
    }
    const event = {
      type: Events.EVENT_VIRTUAL_COLUMNS_CHANGED,
      afterScroll
    };
    this.eventService.dispatchEvent(event);
  }
  setViewportPosition(scrollWidth, scrollPosition, afterScroll = false) {
    if (scrollWidth !== this.scrollWidth || scrollPosition !== this.scrollPosition || this.bodyWidthDirty) {
      this.scrollWidth = scrollWidth;
      this.scrollPosition = scrollPosition;
      this.bodyWidthDirty = true;
      this.setViewport();
      if (this.ready) {
        this.checkViewportColumns(afterScroll);
      }
    }
  }
  isPivotMode() {
    return this.pivotMode;
  }
  isPivotSettingAllowed(pivot) {
    if (pivot && this.gridOptionsService.get("treeData")) {
      console.warn("AG Grid: Pivot mode not available in conjunction Tree Data i.e. 'gridOptions.treeData: true'");
      return false;
    }
    return true;
  }
  setPivotMode(pivotMode, source) {
    if (pivotMode === this.pivotMode || !this.isPivotSettingAllowed(this.pivotMode)) {
      return;
    }
    this.pivotMode = pivotMode;
    if (!this.gridColumns) {
      return;
    }
    this.autoGroupsNeedBuilding = true;
    this.updateGridColumns();
    this.updateDisplayedColumns(source);
    const event = {
      type: Events.EVENT_COLUMN_PIVOT_MODE_CHANGED
    };
    this.eventService.dispatchEvent(event);
  }
  getSecondaryPivotColumn(pivotKeys, valueColKey) {
    if (missing(this.secondaryColumns)) {
      return null;
    }
    const valueColumnToFind = this.getPrimaryColumn(valueColKey);
    let foundColumn = null;
    this.secondaryColumns.forEach((column) => {
      const thisPivotKeys = column.getColDef().pivotKeys;
      const pivotValueColumn = column.getColDef().pivotValueColumn;
      const pivotKeyMatches = areEqual(thisPivotKeys, pivotKeys);
      const pivotValueMatches = pivotValueColumn === valueColumnToFind;
      if (pivotKeyMatches && pivotValueMatches) {
        foundColumn = column;
      }
    });
    return foundColumn;
  }
  setBeans(loggerFactory) {
    this.logger = loggerFactory.create("columnModel");
  }
  setFirstRightAndLastLeftPinned(source) {
    let lastLeft;
    let firstRight;
    if (this.gridOptionsService.get("enableRtl")) {
      lastLeft = this.displayedColumnsLeft ? this.displayedColumnsLeft[0] : null;
      firstRight = this.displayedColumnsRight ? last(this.displayedColumnsRight) : null;
    } else {
      lastLeft = this.displayedColumnsLeft ? last(this.displayedColumnsLeft) : null;
      firstRight = this.displayedColumnsRight ? this.displayedColumnsRight[0] : null;
    }
    this.gridColumns.forEach((column) => {
      column.setLastLeftPinned(column === lastLeft, source);
      column.setFirstRightPinned(column === firstRight, source);
    });
  }
  autoSizeColumns(params) {
    if (this.shouldQueueResizeOperations) {
      this.resizeOperationQueue.push(() => this.autoSizeColumns(params));
      return;
    }
    const { columns, skipHeader, skipHeaderGroups, stopAtGroup, source = "api" } = params;
    this.animationFrameService.flushAllFrames();
    const columnsAutosized = [];
    let changesThisTimeAround = -1;
    const shouldSkipHeader = skipHeader != null ? skipHeader : this.gridOptionsService.get("skipHeaderOnAutoSize");
    const shouldSkipHeaderGroups = skipHeaderGroups != null ? skipHeaderGroups : shouldSkipHeader;
    while (changesThisTimeAround !== 0) {
      changesThisTimeAround = 0;
      this.actionOnGridColumns(columns, (column) => {
        if (columnsAutosized.indexOf(column) >= 0) {
          return false;
        }
        const preferredWidth = this.autoWidthCalculator.getPreferredWidthForColumn(column, shouldSkipHeader);
        if (preferredWidth > 0) {
          const newWidth = this.normaliseColumnWidth(column, preferredWidth);
          column.setActualWidth(newWidth, source);
          columnsAutosized.push(column);
          changesThisTimeAround++;
        }
        return true;
      }, source);
    }
    if (!shouldSkipHeaderGroups) {
      this.autoSizeColumnGroupsByColumns(columns, source, stopAtGroup);
    }
    this.dispatchColumnResizedEvent(columnsAutosized, true, "autosizeColumns");
  }
  dispatchColumnResizedEvent(columns, finished, source, flexColumns = null) {
    if (columns && columns.length) {
      const event = {
        type: Events.EVENT_COLUMN_RESIZED,
        columns,
        column: columns.length === 1 ? columns[0] : null,
        flexColumns,
        finished,
        source
      };
      this.eventService.dispatchEvent(event);
    }
  }
  dispatchColumnChangedEvent(type, columns, source) {
    const event = {
      type,
      columns,
      column: columns && columns.length == 1 ? columns[0] : null,
      source
    };
    this.eventService.dispatchEvent(event);
  }
  dispatchColumnMovedEvent(params) {
    const { movedColumns, source, toIndex, finished } = params;
    const event = {
      type: Events.EVENT_COLUMN_MOVED,
      columns: movedColumns,
      column: movedColumns && movedColumns.length === 1 ? movedColumns[0] : null,
      toIndex,
      finished,
      source
    };
    this.eventService.dispatchEvent(event);
  }
  dispatchColumnPinnedEvent(changedColumns, source) {
    if (!changedColumns.length) {
      return;
    }
    const column = changedColumns.length === 1 ? changedColumns[0] : null;
    const pinned = this.getCommonValue(changedColumns, (col) => col.getPinned());
    const event = {
      type: Events.EVENT_COLUMN_PINNED,
      // mistake in typing, 'undefined' should be allowed, as 'null' means 'not pinned'
      pinned: pinned != null ? pinned : null,
      columns: changedColumns,
      column,
      source
    };
    this.eventService.dispatchEvent(event);
  }
  dispatchColumnVisibleEvent(changedColumns, source) {
    if (!changedColumns.length) {
      return;
    }
    const column = changedColumns.length === 1 ? changedColumns[0] : null;
    const visible = this.getCommonValue(changedColumns, (col) => col.isVisible());
    const event = {
      type: Events.EVENT_COLUMN_VISIBLE,
      visible,
      columns: changedColumns,
      column,
      source
    };
    this.eventService.dispatchEvent(event);
  }
  autoSizeColumn(key, source, skipHeader) {
    if (key) {
      this.autoSizeColumns({ columns: [key], skipHeader, skipHeaderGroups: true, source });
    }
  }
  autoSizeColumnGroupsByColumns(keys2, source, stopAtGroup) {
    const columnGroups = /* @__PURE__ */ new Set();
    const columns = this.getGridColumns(keys2);
    columns.forEach((col) => {
      let parent = col.getParent();
      while (parent && parent != stopAtGroup) {
        if (!parent.isPadding()) {
          columnGroups.add(parent);
        }
        parent = parent.getParent();
      }
    });
    let headerGroupCtrl;
    const resizedColumns = [];
    for (const columnGroup of columnGroups) {
      for (const headerContainerCtrl of this.ctrlsService.getHeaderRowContainerCtrls()) {
        headerGroupCtrl = headerContainerCtrl.getHeaderCtrlForColumn(columnGroup);
        if (headerGroupCtrl) {
          break;
        }
      }
      if (headerGroupCtrl) {
        headerGroupCtrl.resizeLeafColumnsToFit(source);
      }
    }
    return resizedColumns;
  }
  autoSizeAllColumns(source, skipHeader) {
    if (this.shouldQueueResizeOperations) {
      this.resizeOperationQueue.push(() => this.autoSizeAllColumns(source, skipHeader));
      return;
    }
    const allDisplayedColumns = this.getAllDisplayedColumns();
    this.autoSizeColumns({ columns: allDisplayedColumns, skipHeader, source });
  }
  // Possible candidate for reuse (alot of recursive traversal duplication)
  getColumnsFromTree(rootColumns) {
    const result = [];
    const recursiveFindColumns = (childColumns) => {
      for (let i = 0; i < childColumns.length; i++) {
        const child = childColumns[i];
        if (child instanceof Column) {
          result.push(child);
        } else if (child instanceof ProvidedColumnGroup) {
          recursiveFindColumns(child.getChildren());
        }
      }
    };
    recursiveFindColumns(rootColumns);
    return result;
  }
  getAllDisplayedTrees() {
    if (this.displayedTreeLeft && this.displayedTreeRight && this.displayedTreeCentre) {
      return this.displayedTreeLeft.concat(this.displayedTreeCentre).concat(this.displayedTreeRight);
    }
    return null;
  }
  // + columnSelectPanel
  getPrimaryColumnTree() {
    return this.primaryColumnTree;
  }
  // + gridPanel -> for resizing the body and setting top margin
  getHeaderRowCount() {
    return this.gridHeaderRowCount;
  }
  // + headerRenderer -> setting pinned body width
  getDisplayedTreeLeft() {
    return this.displayedTreeLeft;
  }
  // + headerRenderer -> setting pinned body width
  getDisplayedTreeRight() {
    return this.displayedTreeRight;
  }
  // + headerRenderer -> setting pinned body width
  getDisplayedTreeCentre() {
    return this.displayedTreeCentre;
  }
  // gridPanel -> ensureColumnVisible
  isColumnDisplayed(column) {
    return this.getAllDisplayedColumns().indexOf(column) >= 0;
  }
  // + csvCreator
  getAllDisplayedColumns() {
    return this.displayedColumns;
  }
  getViewportColumns() {
    return this.viewportColumns;
  }
  getDisplayedLeftColumnsForRow(rowNode) {
    if (!this.colSpanActive) {
      return this.displayedColumnsLeft;
    }
    return this.getDisplayedColumnsForRow(rowNode, this.displayedColumnsLeft);
  }
  getDisplayedRightColumnsForRow(rowNode) {
    if (!this.colSpanActive) {
      return this.displayedColumnsRight;
    }
    return this.getDisplayedColumnsForRow(rowNode, this.displayedColumnsRight);
  }
  isColSpanActive() {
    return this.colSpanActive;
  }
  getDisplayedColumnsForRow(rowNode, displayedColumns, filterCallback, emptySpaceBeforeColumn) {
    const result = [];
    let lastConsideredCol = null;
    for (let i = 0; i < displayedColumns.length; i++) {
      const col = displayedColumns[i];
      const maxAllowedColSpan = displayedColumns.length - i;
      const colSpan = Math.min(col.getColSpan(rowNode), maxAllowedColSpan);
      const columnsToCheckFilter = [col];
      if (colSpan > 1) {
        const colsToRemove = colSpan - 1;
        for (let j = 1; j <= colsToRemove; j++) {
          columnsToCheckFilter.push(displayedColumns[i + j]);
        }
        i += colsToRemove;
      }
      let filterPasses;
      if (filterCallback) {
        filterPasses = false;
        columnsToCheckFilter.forEach((colForFilter) => {
          if (filterCallback(colForFilter)) {
            filterPasses = true;
          }
        });
      } else {
        filterPasses = true;
      }
      if (filterPasses) {
        if (result.length === 0 && lastConsideredCol) {
          const gapBeforeColumn = emptySpaceBeforeColumn ? emptySpaceBeforeColumn(col) : false;
          if (gapBeforeColumn) {
            result.push(lastConsideredCol);
          }
        }
        result.push(col);
      }
      lastConsideredCol = col;
    }
    return result;
  }
  // + rowRenderer
  // if we are not column spanning, this just returns back the virtual centre columns,
  // however if we are column spanning, then different rows can have different virtual
  // columns, so we have to work out the list for each individual row.
  getViewportCenterColumnsForRow(rowNode) {
    if (!this.colSpanActive) {
      return this.viewportColumnsCenter;
    }
    const emptySpaceBeforeColumn = (col) => {
      const left = col.getLeft();
      return exists(left) && left > this.viewportLeft;
    };
    const filterCallback = this.isColumnVirtualisationSuppressed() ? null : this.isColumnInRowViewport.bind(this);
    return this.getDisplayedColumnsForRow(
      rowNode,
      this.displayedColumnsCenter,
      filterCallback,
      emptySpaceBeforeColumn
    );
  }
  isColumnAtEdge(col, edge) {
    const allColumns = this.getAllDisplayedColumns();
    if (!allColumns.length) {
      return false;
    }
    const isFirst = edge === "first";
    let columnToCompare;
    if (col instanceof ColumnGroup) {
      const leafColumns = col.getDisplayedLeafColumns();
      if (!leafColumns.length) {
        return false;
      }
      columnToCompare = isFirst ? leafColumns[0] : last(leafColumns);
    } else {
      columnToCompare = col;
    }
    return (isFirst ? allColumns[0] : last(allColumns)) === columnToCompare;
  }
  getAriaColumnIndex(col) {
    let targetColumn;
    if (col instanceof ColumnGroup) {
      targetColumn = col.getLeafColumns()[0];
    } else {
      targetColumn = col;
    }
    return this.ariaOrderColumns.indexOf(targetColumn) + 1;
  }
  isColumnInHeaderViewport(col) {
    if (col.isAutoHeaderHeight()) {
      return true;
    }
    return this.isColumnInRowViewport(col);
  }
  isColumnInRowViewport(col) {
    if (col.isAutoHeight()) {
      return true;
    }
    const columnLeft = col.getLeft() || 0;
    const columnRight = columnLeft + col.getActualWidth();
    const leftBounds = this.viewportLeft - 200;
    const rightBounds = this.viewportRight + 200;
    const columnToMuchLeft = columnLeft < leftBounds && columnRight < leftBounds;
    const columnToMuchRight = columnLeft > rightBounds && columnRight > rightBounds;
    return !columnToMuchLeft && !columnToMuchRight;
  }
  // used by:
  // + angularGrid -> setting pinned body width
  // note: this should be cached
  getDisplayedColumnsLeftWidth() {
    return this.getWidthOfColsInList(this.displayedColumnsLeft);
  }
  // note: this should be cached
  getDisplayedColumnsRightWidth() {
    return this.getWidthOfColsInList(this.displayedColumnsRight);
  }
  updatePrimaryColumnList(keys2, masterList, actionIsAdd, columnCallback, eventType, source) {
    if (!keys2 || missingOrEmpty(keys2)) {
      return;
    }
    let atLeastOne = false;
    keys2.forEach((key) => {
      if (!key) {
        return;
      }
      const columnToAdd = this.getPrimaryColumn(key);
      if (!columnToAdd) {
        return;
      }
      if (actionIsAdd) {
        if (masterList.indexOf(columnToAdd) >= 0) {
          return;
        }
        masterList.push(columnToAdd);
      } else {
        if (masterList.indexOf(columnToAdd) < 0) {
          return;
        }
        removeFromArray(masterList, columnToAdd);
      }
      columnCallback(columnToAdd);
      atLeastOne = true;
    });
    if (!atLeastOne) {
      return;
    }
    if (this.autoGroupsNeedBuilding) {
      this.updateGridColumns();
    }
    this.updateDisplayedColumns(source);
    const event = {
      type: eventType,
      columns: masterList,
      column: masterList.length === 1 ? masterList[0] : null,
      source
    };
    this.eventService.dispatchEvent(event);
  }
  setRowGroupColumns(colKeys, source) {
    this.autoGroupsNeedBuilding = true;
    this.setPrimaryColumnList(
      colKeys,
      this.rowGroupColumns,
      Events.EVENT_COLUMN_ROW_GROUP_CHANGED,
      true,
      this.setRowGroupActive.bind(this),
      source
    );
  }
  setRowGroupActive(active, column, source) {
    if (active === column.isRowGroupActive()) {
      return;
    }
    column.setRowGroupActive(active, source);
    if (active && !this.gridOptionsService.get("suppressRowGroupHidesColumns")) {
      this.setColumnsVisible([column], false, source);
    }
    if (!active && !this.gridOptionsService.get("suppressMakeColumnVisibleAfterUnGroup")) {
      this.setColumnsVisible([column], true, source);
    }
  }
  addRowGroupColumns(keys2, source) {
    this.autoGroupsNeedBuilding = true;
    this.updatePrimaryColumnList(
      keys2,
      this.rowGroupColumns,
      true,
      this.setRowGroupActive.bind(this, true),
      Events.EVENT_COLUMN_ROW_GROUP_CHANGED,
      source
    );
  }
  removeRowGroupColumns(keys2, source) {
    this.autoGroupsNeedBuilding = true;
    this.updatePrimaryColumnList(
      keys2,
      this.rowGroupColumns,
      false,
      this.setRowGroupActive.bind(this, false),
      Events.EVENT_COLUMN_ROW_GROUP_CHANGED,
      source
    );
  }
  addPivotColumns(keys2, source) {
    this.updatePrimaryColumnList(
      keys2,
      this.pivotColumns,
      true,
      (column) => column.setPivotActive(true, source),
      Events.EVENT_COLUMN_PIVOT_CHANGED,
      source
    );
  }
  setPivotColumns(colKeys, source) {
    this.setPrimaryColumnList(
      colKeys,
      this.pivotColumns,
      Events.EVENT_COLUMN_PIVOT_CHANGED,
      true,
      (added, column) => {
        column.setPivotActive(added, source);
      },
      source
    );
  }
  removePivotColumns(keys2, source) {
    this.updatePrimaryColumnList(
      keys2,
      this.pivotColumns,
      false,
      (column) => column.setPivotActive(false, source),
      Events.EVENT_COLUMN_PIVOT_CHANGED,
      source
    );
  }
  setPrimaryColumnList(colKeys, masterList, eventName, detectOrderChange, columnCallback, source) {
    if (!this.gridColumns) {
      return;
    }
    const changes = /* @__PURE__ */ new Map();
    masterList.forEach((col, idx) => changes.set(col, idx));
    masterList.length = 0;
    if (exists(colKeys)) {
      colKeys.forEach((key) => {
        const column = this.getPrimaryColumn(key);
        if (column) {
          masterList.push(column);
        }
      });
    }
    masterList.forEach((col, idx) => {
      const oldIndex = changes.get(col);
      if (oldIndex === void 0) {
        changes.set(col, 0);
        return;
      }
      if (detectOrderChange && oldIndex !== idx) {
        return;
      }
      changes.delete(col);
    });
    (this.primaryColumns || []).forEach((column) => {
      const added = masterList.indexOf(column) >= 0;
      columnCallback(added, column);
    });
    if (this.autoGroupsNeedBuilding) {
      this.updateGridColumns();
    }
    this.updateDisplayedColumns(source);
    this.dispatchColumnChangedEvent(eventName, [...changes.keys()], source);
  }
  setValueColumns(colKeys, source) {
    this.setPrimaryColumnList(
      colKeys,
      this.valueColumns,
      Events.EVENT_COLUMN_VALUE_CHANGED,
      false,
      this.setValueActive.bind(this),
      source
    );
  }
  setValueActive(active, column, source) {
    if (active === column.isValueActive()) {
      return;
    }
    column.setValueActive(active, source);
    if (active && !column.getAggFunc()) {
      const initialAggFunc = this.aggFuncService.getDefaultAggFunc(column);
      column.setAggFunc(initialAggFunc);
    }
  }
  addValueColumns(keys2, source) {
    this.updatePrimaryColumnList(
      keys2,
      this.valueColumns,
      true,
      this.setValueActive.bind(this, true),
      Events.EVENT_COLUMN_VALUE_CHANGED,
      source
    );
  }
  removeValueColumns(keys2, source) {
    this.updatePrimaryColumnList(
      keys2,
      this.valueColumns,
      false,
      this.setValueActive.bind(this, false),
      Events.EVENT_COLUMN_VALUE_CHANGED,
      source
    );
  }
  // returns the width we can set to this col, taking into consideration min and max widths
  normaliseColumnWidth(column, newWidth) {
    const minWidth = column.getMinWidth();
    if (exists(minWidth) && newWidth < minWidth) {
      newWidth = minWidth;
    }
    const maxWidth = column.getMaxWidth();
    if (exists(maxWidth) && column.isGreaterThanMax(newWidth)) {
      newWidth = maxWidth;
    }
    return newWidth;
  }
  getPrimaryOrGridColumn(key) {
    const column = this.getPrimaryColumn(key);
    return column || this.getGridColumn(key);
  }
  setColumnWidths(columnWidths, shiftKey, finished, source) {
    const sets = [];
    columnWidths.forEach((columnWidth) => {
      const col = this.getPrimaryOrGridColumn(columnWidth.key);
      if (!col) {
        return;
      }
      sets.push({
        width: columnWidth.newWidth,
        ratios: [1],
        columns: [col]
      });
      const defaultIsShift = this.gridOptionsService.get("colResizeDefault") === "shift";
      if (defaultIsShift) {
        shiftKey = !shiftKey;
      }
      if (shiftKey) {
        const otherCol = this.getDisplayedColAfter(col);
        if (!otherCol) {
          return;
        }
        const widthDiff = col.getActualWidth() - columnWidth.newWidth;
        const otherColWidth = otherCol.getActualWidth() + widthDiff;
        sets.push({
          width: otherColWidth,
          ratios: [1],
          columns: [otherCol]
        });
      }
    });
    if (sets.length === 0) {
      return;
    }
    this.resizeColumnSets({
      resizeSets: sets,
      finished,
      source
    });
  }
  checkMinAndMaxWidthsForSet(columnResizeSet) {
    const { columns, width } = columnResizeSet;
    let minWidthAccumulated = 0;
    let maxWidthAccumulated = 0;
    let maxWidthActive = true;
    columns.forEach((col) => {
      const minWidth = col.getMinWidth();
      minWidthAccumulated += minWidth || 0;
      const maxWidth = col.getMaxWidth();
      if (exists(maxWidth) && maxWidth > 0) {
        maxWidthAccumulated += maxWidth;
      } else {
        maxWidthActive = false;
      }
    });
    const minWidthPasses = width >= minWidthAccumulated;
    const maxWidthPasses = !maxWidthActive || width <= maxWidthAccumulated;
    return minWidthPasses && maxWidthPasses;
  }
  // method takes sets of columns and resizes them. either all sets will be resized, or nothing
  // be resized. this is used for example when user tries to resize a group and holds shift key,
  // then both the current group (grows), and the adjacent group (shrinks), will get resized,
  // so that's two sets for this method.
  resizeColumnSets(params) {
    const { resizeSets, finished, source } = params;
    const passMinMaxCheck = !resizeSets || resizeSets.every((columnResizeSet) => this.checkMinAndMaxWidthsForSet(columnResizeSet));
    if (!passMinMaxCheck) {
      if (finished) {
        const columns = resizeSets && resizeSets.length > 0 ? resizeSets[0].columns : null;
        this.dispatchColumnResizedEvent(columns, finished, source);
      }
      return;
    }
    const changedCols = [];
    const allResizedCols = [];
    resizeSets.forEach((set) => {
      const { width, columns, ratios } = set;
      const newWidths = {};
      const finishedCols = {};
      columns.forEach((col) => allResizedCols.push(col));
      let finishedColsGrew = true;
      let loopCount = 0;
      while (finishedColsGrew) {
        loopCount++;
        if (loopCount > 1e3) {
          console.error("AG Grid: infinite loop in resizeColumnSets");
          break;
        }
        finishedColsGrew = false;
        const subsetCols = [];
        let subsetRatioTotal = 0;
        let pixelsToDistribute = width;
        columns.forEach((col, index) => {
          const thisColFinished = finishedCols[col.getId()];
          if (thisColFinished) {
            pixelsToDistribute -= newWidths[col.getId()];
          } else {
            subsetCols.push(col);
            const ratioThisCol = ratios[index];
            subsetRatioTotal += ratioThisCol;
          }
        });
        const ratioScale = 1 / subsetRatioTotal;
        subsetCols.forEach((col, index) => {
          const lastCol = index === subsetCols.length - 1;
          let colNewWidth;
          if (lastCol) {
            colNewWidth = pixelsToDistribute;
          } else {
            colNewWidth = Math.round(ratios[index] * width * ratioScale);
            pixelsToDistribute -= colNewWidth;
          }
          const minWidth = col.getMinWidth();
          const maxWidth = col.getMaxWidth();
          if (exists(minWidth) && colNewWidth < minWidth) {
            colNewWidth = minWidth;
            finishedCols[col.getId()] = true;
            finishedColsGrew = true;
          } else if (exists(maxWidth) && maxWidth > 0 && colNewWidth > maxWidth) {
            colNewWidth = maxWidth;
            finishedCols[col.getId()] = true;
            finishedColsGrew = true;
          }
          newWidths[col.getId()] = colNewWidth;
        });
      }
      columns.forEach((col) => {
        const newWidth = newWidths[col.getId()];
        const actualWidth = col.getActualWidth();
        if (actualWidth !== newWidth) {
          col.setActualWidth(newWidth, source);
          changedCols.push(col);
        }
      });
    });
    const atLeastOneColChanged = changedCols.length > 0;
    let flexedCols = [];
    if (atLeastOneColChanged) {
      flexedCols = this.refreshFlexedColumns({ resizingCols: allResizedCols, skipSetLeft: true });
      this.setLeftValues(source);
      this.updateBodyWidths();
      this.checkViewportColumns();
    }
    const colsForEvent = allResizedCols.concat(flexedCols);
    if (atLeastOneColChanged || finished) {
      this.dispatchColumnResizedEvent(colsForEvent, finished, source, flexedCols);
    }
  }
  setColumnAggFunc(key, aggFunc, source) {
    if (!key) {
      return;
    }
    const column = this.getPrimaryColumn(key);
    if (!column) {
      return;
    }
    column.setAggFunc(aggFunc);
    this.dispatchColumnChangedEvent(Events.EVENT_COLUMN_VALUE_CHANGED, [column], source);
  }
  moveRowGroupColumn(fromIndex, toIndex, source) {
    if (this.isRowGroupEmpty()) {
      return;
    }
    const column = this.rowGroupColumns[fromIndex];
    const impactedColumns = this.rowGroupColumns.slice(fromIndex, toIndex);
    this.rowGroupColumns.splice(fromIndex, 1);
    this.rowGroupColumns.splice(toIndex, 0, column);
    const event = {
      type: Events.EVENT_COLUMN_ROW_GROUP_CHANGED,
      columns: impactedColumns,
      column: impactedColumns.length === 1 ? impactedColumns[0] : null,
      source
    };
    this.eventService.dispatchEvent(event);
  }
  moveColumns(columnsToMoveKeys, toIndex, source, finished = true) {
    if (!this.gridColumns) {
      return;
    }
    this.columnAnimationService.start();
    if (toIndex > this.gridColumns.length - columnsToMoveKeys.length) {
      console.warn("AG Grid: tried to insert columns in invalid location, toIndex = " + toIndex);
      console.warn("AG Grid: remember that you should not count the moving columns when calculating the new index");
      return;
    }
    const movedColumns = this.getGridColumns(columnsToMoveKeys);
    const failedRules = !this.doesMovePassRules(movedColumns, toIndex);
    if (failedRules) {
      return;
    }
    moveInArray(this.gridColumns, movedColumns, toIndex);
    this.updateDisplayedColumns(source);
    this.dispatchColumnMovedEvent({ movedColumns, source, toIndex, finished });
    this.columnAnimationService.finish();
  }
  doesMovePassRules(columnsToMove, toIndex) {
    const proposedColumnOrder = this.getProposedColumnOrder(columnsToMove, toIndex);
    return this.doesOrderPassRules(proposedColumnOrder);
  }
  doesOrderPassRules(gridOrder) {
    if (!this.doesMovePassMarryChildren(gridOrder)) {
      return false;
    }
    if (!this.doesMovePassLockedPositions(gridOrder)) {
      return false;
    }
    return true;
  }
  getProposedColumnOrder(columnsToMove, toIndex) {
    const proposedColumnOrder = this.gridColumns.slice();
    moveInArray(proposedColumnOrder, columnsToMove, toIndex);
    return proposedColumnOrder;
  }
  // returns the provided cols sorted in same order as they appear in grid columns. eg if grid columns
  // contains [a,b,c,d,e] and col passed is [e,a] then the passed cols are sorted into [a,e]
  sortColumnsLikeGridColumns(cols) {
    if (!cols || cols.length <= 1) {
      return;
    }
    const notAllColsInGridColumns = cols.filter((c) => this.gridColumns.indexOf(c) < 0).length > 0;
    if (notAllColsInGridColumns) {
      return;
    }
    cols.sort((a, b) => {
      const indexA = this.gridColumns.indexOf(a);
      const indexB = this.gridColumns.indexOf(b);
      return indexA - indexB;
    });
  }
  doesMovePassLockedPositions(proposedColumnOrder) {
    let lastPlacement = 0;
    let rulePassed = true;
    const lockPositionToPlacement = (position) => {
      if (!position) {
        return 1;
      }
      if (position === true) {
        return 0;
      }
      return position === "left" ? 0 : 2;
    };
    proposedColumnOrder.forEach((col) => {
      const placement = lockPositionToPlacement(col.getColDef().lockPosition);
      if (placement < lastPlacement) {
        rulePassed = false;
      }
      lastPlacement = placement;
    });
    return rulePassed;
  }
  doesMovePassMarryChildren(allColumnsCopy) {
    let rulePassed = true;
    this.columnUtils.depthFirstOriginalTreeSearch(null, this.gridBalancedTree, (child) => {
      if (!(child instanceof ProvidedColumnGroup)) {
        return;
      }
      const columnGroup = child;
      const colGroupDef = columnGroup.getColGroupDef();
      const marryChildren = colGroupDef && colGroupDef.marryChildren;
      if (!marryChildren) {
        return;
      }
      const newIndexes = [];
      columnGroup.getLeafColumns().forEach((col) => {
        const newColIndex = allColumnsCopy.indexOf(col);
        newIndexes.push(newColIndex);
      });
      const maxIndex = Math.max.apply(Math, newIndexes);
      const minIndex = Math.min.apply(Math, newIndexes);
      const spread = maxIndex - minIndex;
      const maxSpread = columnGroup.getLeafColumns().length - 1;
      if (spread > maxSpread) {
        rulePassed = false;
      }
    });
    return rulePassed;
  }
  moveColumnByIndex(fromIndex, toIndex, source) {
    if (!this.gridColumns) {
      return;
    }
    const column = this.gridColumns[fromIndex];
    this.moveColumns([column], toIndex, source);
  }
  getColumnDefs() {
    if (!this.primaryColumns) {
      return;
    }
    const cols = this.primaryColumns.slice();
    if (this.gridColsArePrimary) {
      cols.sort((a, b) => this.gridColumns.indexOf(a) - this.gridColumns.indexOf(b));
    } else if (this.lastPrimaryOrder) {
      cols.sort((a, b) => this.lastPrimaryOrder.indexOf(a) - this.lastPrimaryOrder.indexOf(b));
    }
    return this.columnDefFactory.buildColumnDefs(cols, this.rowGroupColumns, this.pivotColumns);
  }
  // used by:
  // + angularGrid -> for setting body width
  // + rowController -> setting main row widths (when inserting and resizing)
  // need to cache this
  getBodyContainerWidth() {
    return this.bodyWidth;
  }
  getContainerWidth(pinned) {
    switch (pinned) {
      case "left":
        return this.leftWidth;
      case "right":
        return this.rightWidth;
      default:
        return this.bodyWidth;
    }
  }
  // after setColumnWidth or updateGroupsAndDisplayedColumns
  updateBodyWidths() {
    const newBodyWidth = this.getWidthOfColsInList(this.displayedColumnsCenter);
    const newLeftWidth = this.getWidthOfColsInList(this.displayedColumnsLeft);
    const newRightWidth = this.getWidthOfColsInList(this.displayedColumnsRight);
    this.bodyWidthDirty = this.bodyWidth !== newBodyWidth;
    const atLeastOneChanged = this.bodyWidth !== newBodyWidth || this.leftWidth !== newLeftWidth || this.rightWidth !== newRightWidth;
    if (atLeastOneChanged) {
      this.bodyWidth = newBodyWidth;
      this.leftWidth = newLeftWidth;
      this.rightWidth = newRightWidth;
      const evt = {
        type: Events.EVENT_COLUMN_CONTAINER_WIDTH_CHANGED
      };
      this.eventService.dispatchEvent(evt);
      const event = {
        type: Events.EVENT_DISPLAYED_COLUMNS_WIDTH_CHANGED
      };
      this.eventService.dispatchEvent(event);
    }
  }
  // + rowController
  getValueColumns() {
    return this.valueColumns ? this.valueColumns : [];
  }
  // + rowController
  getPivotColumns() {
    return this.pivotColumns ? this.pivotColumns : [];
  }
  // + clientSideRowModel
  isPivotActive() {
    return this.pivotColumns && this.pivotColumns.length > 0 && this.pivotMode;
  }
  // + toolPanel
  getRowGroupColumns() {
    return this.rowGroupColumns ? this.rowGroupColumns : [];
  }
  // + rowController -> while inserting rows
  getDisplayedCenterColumns() {
    return this.displayedColumnsCenter;
  }
  // + rowController -> while inserting rows
  getDisplayedLeftColumns() {
    return this.displayedColumnsLeft;
  }
  getDisplayedRightColumns() {
    return this.displayedColumnsRight;
  }
  getDisplayedColumns(type) {
    switch (type) {
      case "left":
        return this.getDisplayedLeftColumns();
      case "right":
        return this.getDisplayedRightColumns();
      default:
        return this.getDisplayedCenterColumns();
    }
  }
  // used by:
  // + clientSideRowController -> sorting, building quick filter text
  // + headerRenderer -> sorting (clearing icon)
  getAllPrimaryColumns() {
    return this.primaryColumns ? this.primaryColumns : null;
  }
  getSecondaryColumns() {
    return this.secondaryColumns ? this.secondaryColumns : null;
  }
  getAllColumnsForQuickFilter() {
    return this.columnsForQuickFilter;
  }
  // + moveColumnController
  getAllGridColumns() {
    var _a;
    return (_a = this.gridColumns) != null ? _a : [];
  }
  isEmpty() {
    return missingOrEmpty(this.gridColumns);
  }
  isRowGroupEmpty() {
    return missingOrEmpty(this.rowGroupColumns);
  }
  setColumnsVisible(keys2, visible = false, source) {
    this.applyColumnState({
      state: keys2.map(
        (key) => ({
          colId: typeof key === "string" ? key : key.getColId(),
          hide: !visible
        })
      )
    }, source);
  }
  setColumnsPinned(keys2, pinned, source) {
    if (!this.gridColumns) {
      return;
    }
    if (this.gridOptionsService.isDomLayout("print")) {
      console.warn(`AG Grid: Changing the column pinning status is not allowed with domLayout='print'`);
      return;
    }
    this.columnAnimationService.start();
    let actualPinned;
    if (pinned === true || pinned === "left") {
      actualPinned = "left";
    } else if (pinned === "right") {
      actualPinned = "right";
    } else {
      actualPinned = null;
    }
    this.actionOnGridColumns(keys2, (col) => {
      if (col.getPinned() !== actualPinned) {
        col.setPinned(actualPinned);
        return true;
      }
      return false;
    }, source, () => {
      const event = {
        type: Events.EVENT_COLUMN_PINNED,
        pinned: actualPinned,
        column: null,
        columns: null,
        source
      };
      return event;
    });
    this.columnAnimationService.finish();
  }
  // does an action on a set of columns. provides common functionality for looking up the
  // columns based on key, getting a list of effected columns, and then updated the event
  // with either one column (if it was just one col) or a list of columns
  // used by: autoResize, setVisible, setPinned
  actionOnGridColumns(keys2, action, source, createEvent) {
    if (missingOrEmpty(keys2)) {
      return;
    }
    const updatedColumns = [];
    keys2.forEach((key) => {
      if (!key) {
        return;
      }
      const column = this.getGridColumn(key);
      if (!column) {
        return;
      }
      const resultOfAction = action(column);
      if (resultOfAction !== false) {
        updatedColumns.push(column);
      }
    });
    if (!updatedColumns.length) {
      return;
    }
    this.updateDisplayedColumns(source);
    if (exists(createEvent) && createEvent) {
      const event = createEvent();
      event.columns = updatedColumns;
      event.column = updatedColumns.length === 1 ? updatedColumns[0] : null;
      this.eventService.dispatchEvent(event);
    }
  }
  getDisplayedColBefore(col) {
    const allDisplayedColumns = this.getAllDisplayedColumns();
    const oldIndex = allDisplayedColumns.indexOf(col);
    if (oldIndex > 0) {
      return allDisplayedColumns[oldIndex - 1];
    }
    return null;
  }
  // used by:
  // + rowRenderer -> for navigation
  getDisplayedColAfter(col) {
    const allDisplayedColumns = this.getAllDisplayedColumns();
    const oldIndex = allDisplayedColumns.indexOf(col);
    if (oldIndex < allDisplayedColumns.length - 1) {
      return allDisplayedColumns[oldIndex + 1];
    }
    return null;
  }
  getDisplayedGroupAfter(columnGroup) {
    return this.getDisplayedGroupAtDirection(columnGroup, "After");
  }
  getDisplayedGroupBefore(columnGroup) {
    return this.getDisplayedGroupAtDirection(columnGroup, "Before");
  }
  getDisplayedGroupAtDirection(columnGroup, direction) {
    const requiredLevel = columnGroup.getProvidedColumnGroup().getLevel() + columnGroup.getPaddingLevel();
    const colGroupLeafColumns = columnGroup.getDisplayedLeafColumns();
    const col = direction === "After" ? last(colGroupLeafColumns) : colGroupLeafColumns[0];
    const getDisplayColMethod = `getDisplayedCol${direction}`;
    while (true) {
      const column = this[getDisplayColMethod](col);
      if (!column) {
        return null;
      }
      const groupPointer = this.getColumnGroupAtLevel(column, requiredLevel);
      if (groupPointer !== columnGroup) {
        return groupPointer;
      }
    }
  }
  getColumnGroupAtLevel(column, level) {
    let groupPointer = column.getParent();
    let originalGroupLevel;
    let groupPointerLevel;
    while (true) {
      const groupPointerProvidedColumnGroup = groupPointer.getProvidedColumnGroup();
      originalGroupLevel = groupPointerProvidedColumnGroup.getLevel();
      groupPointerLevel = groupPointer.getPaddingLevel();
      if (originalGroupLevel + groupPointerLevel <= level) {
        break;
      }
      groupPointer = groupPointer.getParent();
    }
    return groupPointer;
  }
  isPinningLeft() {
    return this.displayedColumnsLeft.length > 0;
  }
  isPinningRight() {
    return this.displayedColumnsRight.length > 0;
  }
  getPrimaryAndSecondaryAndAutoColumns() {
    return [].concat(...[
      this.primaryColumns || [],
      this.groupAutoColumns || [],
      this.secondaryColumns || []
    ]);
  }
  createStateItemFromColumn(column) {
    const rowGroupIndex = column.isRowGroupActive() ? this.rowGroupColumns.indexOf(column) : null;
    const pivotIndex = column.isPivotActive() ? this.pivotColumns.indexOf(column) : null;
    const aggFunc = column.isValueActive() ? column.getAggFunc() : null;
    const sort = column.getSort() != null ? column.getSort() : null;
    const sortIndex = column.getSortIndex() != null ? column.getSortIndex() : null;
    const flex = column.getFlex() != null && column.getFlex() > 0 ? column.getFlex() : null;
    const res = {
      colId: column.getColId(),
      width: column.getActualWidth(),
      hide: !column.isVisible(),
      pinned: column.getPinned(),
      sort,
      sortIndex,
      aggFunc,
      rowGroup: column.isRowGroupActive(),
      rowGroupIndex,
      pivot: column.isPivotActive(),
      pivotIndex,
      flex
    };
    return res;
  }
  getColumnState() {
    if (missing(this.primaryColumns) || !this.isAlive()) {
      return [];
    }
    const colsForState = this.getPrimaryAndSecondaryAndAutoColumns();
    const res = colsForState.map(this.createStateItemFromColumn.bind(this));
    this.orderColumnStateList(res);
    return res;
  }
  orderColumnStateList(columnStateList) {
    const colIdToGridIndexMap = convertToMap(this.gridColumns.map((col, index) => [col.getColId(), index]));
    columnStateList.sort((itemA, itemB) => {
      const posA = colIdToGridIndexMap.has(itemA.colId) ? colIdToGridIndexMap.get(itemA.colId) : -1;
      const posB = colIdToGridIndexMap.has(itemB.colId) ? colIdToGridIndexMap.get(itemB.colId) : -1;
      return posA - posB;
    });
  }
  resetColumnState(source) {
    if (missingOrEmpty(this.primaryColumns)) {
      return;
    }
    const primaryColumns = this.getColumnsFromTree(this.primaryColumnTree);
    const columnStates = [];
    let letRowGroupIndex = 1e3;
    let letPivotIndex = 1e3;
    let colsToProcess = [];
    if (this.groupAutoColumns) {
      colsToProcess = colsToProcess.concat(this.groupAutoColumns);
    }
    if (primaryColumns) {
      colsToProcess = colsToProcess.concat(primaryColumns);
    }
    colsToProcess.forEach((column) => {
      const stateItem = this.getColumnStateFromColDef(column);
      if (missing(stateItem.rowGroupIndex) && stateItem.rowGroup) {
        stateItem.rowGroupIndex = letRowGroupIndex++;
      }
      if (missing(stateItem.pivotIndex) && stateItem.pivot) {
        stateItem.pivotIndex = letPivotIndex++;
      }
      columnStates.push(stateItem);
    });
    this.applyColumnState({ state: columnStates, applyOrder: true }, source);
  }
  getColumnStateFromColDef(column) {
    const getValueOrNull = (a, b) => a != null ? a : b != null ? b : null;
    const colDef = column.getColDef();
    const sort = getValueOrNull(colDef.sort, colDef.initialSort);
    const sortIndex = getValueOrNull(colDef.sortIndex, colDef.initialSortIndex);
    const hide = getValueOrNull(colDef.hide, colDef.initialHide);
    const pinned = getValueOrNull(colDef.pinned, colDef.initialPinned);
    const width = getValueOrNull(colDef.width, colDef.initialWidth);
    const flex = getValueOrNull(colDef.flex, colDef.initialFlex);
    let rowGroupIndex = getValueOrNull(colDef.rowGroupIndex, colDef.initialRowGroupIndex);
    let rowGroup = getValueOrNull(colDef.rowGroup, colDef.initialRowGroup);
    if (rowGroupIndex == null && (rowGroup == null || rowGroup == false)) {
      rowGroupIndex = null;
      rowGroup = null;
    }
    let pivotIndex = getValueOrNull(colDef.pivotIndex, colDef.initialPivotIndex);
    let pivot = getValueOrNull(colDef.pivot, colDef.initialPivot);
    if (pivotIndex == null && (pivot == null || pivot == false)) {
      pivotIndex = null;
      pivot = null;
    }
    const aggFunc = getValueOrNull(colDef.aggFunc, colDef.initialAggFunc);
    return {
      colId: column.getColId(),
      sort,
      sortIndex,
      hide,
      pinned,
      width,
      flex,
      rowGroup,
      rowGroupIndex,
      pivot,
      pivotIndex,
      aggFunc
    };
  }
  applyColumnState(params, source) {
    if (missingOrEmpty(this.primaryColumns)) {
      return false;
    }
    if (params && params.state && !params.state.forEach) {
      console.warn("AG Grid: applyColumnState() - the state attribute should be an array, however an array was not found. Please provide an array of items (one for each col you want to change) for state.");
      return false;
    }
    const applyStates = (states, existingColumns, getById) => {
      const dispatchEventsFunc = this.compareColumnStatesAndDispatchEvents(source);
      this.autoGroupsNeedBuilding = true;
      const columnsWithNoState = existingColumns.slice();
      const rowGroupIndexes = {};
      const pivotIndexes = {};
      const autoGroupColumnStates = [];
      const unmatchedAndAutoStates2 = [];
      let unmatchedCount2 = 0;
      const previousRowGroupCols = this.rowGroupColumns.slice();
      const previousPivotCols = this.pivotColumns.slice();
      states.forEach((state) => {
        const colId = state.colId || "";
        const isAutoGroupColumn = colId.startsWith(GROUP_AUTO_COLUMN_ID);
        if (isAutoGroupColumn) {
          autoGroupColumnStates.push(state);
          unmatchedAndAutoStates2.push(state);
          return;
        }
        const column = getById(colId);
        if (!column) {
          unmatchedAndAutoStates2.push(state);
          unmatchedCount2 += 1;
        } else {
          this.syncColumnWithStateItem(
            column,
            state,
            params.defaultState,
            rowGroupIndexes,
            pivotIndexes,
            false,
            source
          );
          removeFromArray(columnsWithNoState, column);
        }
      });
      const applyDefaultsFunc = (col) => this.syncColumnWithStateItem(
        col,
        null,
        params.defaultState,
        rowGroupIndexes,
        pivotIndexes,
        false,
        source
      );
      columnsWithNoState.forEach(applyDefaultsFunc);
      const comparator = (indexes, oldList, colA, colB) => {
        const indexA = indexes[colA.getId()];
        const indexB = indexes[colB.getId()];
        const aHasIndex = indexA != null;
        const bHasIndex = indexB != null;
        if (aHasIndex && bHasIndex) {
          return indexA - indexB;
        }
        if (aHasIndex) {
          return -1;
        }
        if (bHasIndex) {
          return 1;
        }
        const oldIndexA = oldList.indexOf(colA);
        const oldIndexB = oldList.indexOf(colB);
        const aHasOldIndex = oldIndexA >= 0;
        const bHasOldIndex = oldIndexB >= 0;
        if (aHasOldIndex && bHasOldIndex) {
          return oldIndexA - oldIndexB;
        }
        if (aHasOldIndex) {
          return -1;
        }
        return 1;
      };
      this.rowGroupColumns.sort(comparator.bind(this, rowGroupIndexes, previousRowGroupCols));
      this.pivotColumns.sort(comparator.bind(this, pivotIndexes, previousPivotCols));
      this.updateGridColumns();
      const autoGroupColsCopy = this.groupAutoColumns ? this.groupAutoColumns.slice() : [];
      autoGroupColumnStates.forEach((stateItem) => {
        const autoCol = this.getAutoColumn(stateItem.colId);
        removeFromArray(autoGroupColsCopy, autoCol);
        this.syncColumnWithStateItem(autoCol, stateItem, params.defaultState, null, null, true, source);
      });
      autoGroupColsCopy.forEach(applyDefaultsFunc);
      this.applyOrderAfterApplyState(params);
      this.updateDisplayedColumns(source);
      this.dispatchEverythingChanged(source);
      dispatchEventsFunc();
      return { unmatchedAndAutoStates: unmatchedAndAutoStates2, unmatchedCount: unmatchedCount2 };
    };
    this.columnAnimationService.start();
    let {
      unmatchedAndAutoStates,
      unmatchedCount
    } = applyStates(params.state || [], this.primaryColumns || [], (id) => this.getPrimaryColumn(id));
    if (unmatchedAndAutoStates.length > 0 || exists(params.defaultState)) {
      unmatchedCount = applyStates(
        unmatchedAndAutoStates,
        this.secondaryColumns || [],
        (id) => this.getSecondaryColumn(id)
      ).unmatchedCount;
    }
    this.columnAnimationService.finish();
    return unmatchedCount === 0;
  }
  applyOrderAfterApplyState(params) {
    if (!params.applyOrder || !params.state) {
      return;
    }
    let newOrder = [];
    const processedColIds = {};
    params.state.forEach((item) => {
      if (!item.colId || processedColIds[item.colId]) {
        return;
      }
      const col = this.gridColumnsMap[item.colId];
      if (col) {
        newOrder.push(col);
        processedColIds[item.colId] = true;
      }
    });
    let autoGroupInsertIndex = 0;
    this.gridColumns.forEach((col) => {
      const colId = col.getColId();
      const alreadyProcessed = processedColIds[colId] != null;
      if (alreadyProcessed) {
        return;
      }
      const isAutoGroupCol = colId.startsWith(GROUP_AUTO_COLUMN_ID);
      if (isAutoGroupCol) {
        insertIntoArray(newOrder, col, autoGroupInsertIndex++);
      } else {
        newOrder.push(col);
      }
    });
    newOrder = this.placeLockedColumns(newOrder);
    if (!this.doesMovePassMarryChildren(newOrder)) {
      console.warn("AG Grid: Applying column order broke a group where columns should be married together. Applying new order has been discarded.");
      return;
    }
    this.gridColumns = newOrder;
  }
  compareColumnStatesAndDispatchEvents(source) {
    const startState = {
      rowGroupColumns: this.rowGroupColumns.slice(),
      pivotColumns: this.pivotColumns.slice(),
      valueColumns: this.valueColumns.slice()
    };
    const columnStateBefore = this.getColumnState();
    const columnStateBeforeMap = {};
    columnStateBefore.forEach((col) => {
      columnStateBeforeMap[col.colId] = col;
    });
    return () => {
      const colsForState = this.getPrimaryAndSecondaryAndAutoColumns();
      const dispatchWhenListsDifferent = (eventType, colsBefore, colsAfter, idMapper) => {
        const beforeList = colsBefore.map(idMapper);
        const afterList = colsAfter.map(idMapper);
        const unchanged = areEqual(beforeList, afterList);
        if (unchanged) {
          return;
        }
        const changes = new Set(colsBefore);
        colsAfter.forEach((id) => {
          if (!changes.delete(id)) {
            changes.add(id);
          }
        });
        const changesArr = [...changes];
        const event = {
          type: eventType,
          columns: changesArr,
          column: changesArr.length === 1 ? changesArr[0] : null,
          source
        };
        this.eventService.dispatchEvent(event);
      };
      const getChangedColumns = (changedPredicate) => {
        const changedColumns2 = [];
        colsForState.forEach((column) => {
          const colStateBefore = columnStateBeforeMap[column.getColId()];
          if (colStateBefore && changedPredicate(colStateBefore, column)) {
            changedColumns2.push(column);
          }
        });
        return changedColumns2;
      };
      const columnIdMapper = (c) => c.getColId();
      dispatchWhenListsDifferent(
        Events.EVENT_COLUMN_ROW_GROUP_CHANGED,
        startState.rowGroupColumns,
        this.rowGroupColumns,
        columnIdMapper
      );
      dispatchWhenListsDifferent(
        Events.EVENT_COLUMN_PIVOT_CHANGED,
        startState.pivotColumns,
        this.pivotColumns,
        columnIdMapper
      );
      const valueChangePredicate = (cs, c) => {
        const oldActive = cs.aggFunc != null;
        const activeChanged = oldActive != c.isValueActive();
        const aggFuncChanged = oldActive && cs.aggFunc != c.getAggFunc();
        return activeChanged || aggFuncChanged;
      };
      const changedValues = getChangedColumns(valueChangePredicate);
      if (changedValues.length > 0) {
        this.dispatchColumnChangedEvent(Events.EVENT_COLUMN_VALUE_CHANGED, changedValues, source);
      }
      const resizeChangePredicate = (cs, c) => cs.width != c.getActualWidth();
      this.dispatchColumnResizedEvent(getChangedColumns(resizeChangePredicate), true, source);
      const pinnedChangePredicate = (cs, c) => cs.pinned != c.getPinned();
      this.dispatchColumnPinnedEvent(getChangedColumns(pinnedChangePredicate), source);
      const visibilityChangePredicate = (cs, c) => cs.hide == c.isVisible();
      this.dispatchColumnVisibleEvent(getChangedColumns(visibilityChangePredicate), source);
      const sortChangePredicate = (cs, c) => cs.sort != c.getSort() || cs.sortIndex != c.getSortIndex();
      const changedColumns = getChangedColumns(sortChangePredicate);
      if (changedColumns.length > 0) {
        this.sortController.dispatchSortChangedEvents(source, changedColumns);
      }
      this.normaliseColumnMovedEventForColumnState(columnStateBefore, source);
    };
  }
  getCommonValue(cols, valueGetter) {
    if (!cols || cols.length == 0) {
      return void 0;
    }
    const firstValue = valueGetter(cols[0]);
    for (let i = 1; i < cols.length; i++) {
      if (firstValue !== valueGetter(cols[i])) {
        return void 0;
      }
    }
    return firstValue;
  }
  normaliseColumnMovedEventForColumnState(colStateBefore, source) {
    const colStateAfter = this.getColumnState();
    const colStateAfterMapped = {};
    colStateAfter.forEach((s) => colStateAfterMapped[s.colId] = s);
    const colsIntersectIds = {};
    colStateBefore.forEach((s) => {
      if (colStateAfterMapped[s.colId]) {
        colsIntersectIds[s.colId] = true;
      }
    });
    const beforeFiltered = colStateBefore.filter((c) => colsIntersectIds[c.colId]);
    const afterFiltered = colStateAfter.filter((c) => colsIntersectIds[c.colId]);
    const movedColumns = [];
    afterFiltered.forEach((csAfter, index) => {
      const csBefore = beforeFiltered && beforeFiltered[index];
      if (csBefore && csBefore.colId !== csAfter.colId) {
        const gridCol = this.getGridColumn(csBefore.colId);
        if (gridCol) {
          movedColumns.push(gridCol);
        }
      }
    });
    if (!movedColumns.length) {
      return;
    }
    this.dispatchColumnMovedEvent({ movedColumns, source, finished: true });
  }
  syncColumnWithStateItem(column, stateItem, defaultState, rowGroupIndexes, pivotIndexes, autoCol, source) {
    if (!column) {
      return;
    }
    const getValue = (key1, key2) => {
      const obj = { value1: void 0, value2: void 0 };
      let calculated = false;
      if (stateItem) {
        if (stateItem[key1] !== void 0) {
          obj.value1 = stateItem[key1];
          calculated = true;
        }
        if (exists(key2) && stateItem[key2] !== void 0) {
          obj.value2 = stateItem[key2];
          calculated = true;
        }
      }
      if (!calculated && defaultState) {
        if (defaultState[key1] !== void 0) {
          obj.value1 = defaultState[key1];
        }
        if (exists(key2) && defaultState[key2] !== void 0) {
          obj.value2 = defaultState[key2];
        }
      }
      return obj;
    };
    const hide = getValue("hide").value1;
    if (hide !== void 0) {
      column.setVisible(!hide, source);
    }
    const pinned = getValue("pinned").value1;
    if (pinned !== void 0) {
      column.setPinned(pinned);
    }
    const minColWidth = this.columnUtils.calculateColMinWidth(column.getColDef());
    const flex = getValue("flex").value1;
    if (flex !== void 0) {
      column.setFlex(flex);
    }
    if (flex == null) {
      const width = getValue("width").value1;
      if (width != null) {
        if (minColWidth != null && width >= minColWidth) {
          column.setActualWidth(width, source);
        }
      }
    }
    const sort = getValue("sort").value1;
    if (sort !== void 0) {
      if (sort === "desc" || sort === "asc") {
        column.setSort(sort, source);
      } else {
        column.setSort(void 0, source);
      }
    }
    const sortIndex = getValue("sortIndex").value1;
    if (sortIndex !== void 0) {
      column.setSortIndex(sortIndex);
    }
    if (autoCol || !column.isPrimary()) {
      return;
    }
    const aggFunc = getValue("aggFunc").value1;
    if (aggFunc !== void 0) {
      if (typeof aggFunc === "string") {
        column.setAggFunc(aggFunc);
        if (!column.isValueActive()) {
          column.setValueActive(true, source);
          this.valueColumns.push(column);
        }
      } else {
        if (exists(aggFunc)) {
          console.warn("AG Grid: stateItem.aggFunc must be a string. if using your own aggregation functions, register the functions first before using them in get/set state. This is because it is intended for the column state to be stored and retrieved as simple JSON.");
        }
        if (column.isValueActive()) {
          column.setValueActive(false, source);
          removeFromArray(this.valueColumns, column);
        }
      }
    }
    const { value1: rowGroup, value2: rowGroupIndex } = getValue("rowGroup", "rowGroupIndex");
    if (rowGroup !== void 0 || rowGroupIndex !== void 0) {
      if (typeof rowGroupIndex === "number" || rowGroup) {
        if (!column.isRowGroupActive()) {
          column.setRowGroupActive(true, source);
          this.rowGroupColumns.push(column);
        }
        if (rowGroupIndexes && typeof rowGroupIndex === "number") {
          rowGroupIndexes[column.getId()] = rowGroupIndex;
        }
      } else {
        if (column.isRowGroupActive()) {
          column.setRowGroupActive(false, source);
          removeFromArray(this.rowGroupColumns, column);
        }
      }
    }
    const { value1: pivot, value2: pivotIndex } = getValue("pivot", "pivotIndex");
    if (pivot !== void 0 || pivotIndex !== void 0) {
      if (typeof pivotIndex === "number" || pivot) {
        if (!column.isPivotActive()) {
          column.setPivotActive(true, source);
          this.pivotColumns.push(column);
        }
        if (pivotIndexes && typeof pivotIndex === "number") {
          pivotIndexes[column.getId()] = pivotIndex;
        }
      } else {
        if (column.isPivotActive()) {
          column.setPivotActive(false, source);
          removeFromArray(this.pivotColumns, column);
        }
      }
    }
  }
  getGridColumns(keys2) {
    return this.getColumns(keys2, this.getGridColumn.bind(this));
  }
  getColumns(keys2, columnLookupCallback) {
    const foundColumns = [];
    if (keys2) {
      keys2.forEach((key) => {
        const column = columnLookupCallback(key);
        if (column) {
          foundColumns.push(column);
        }
      });
    }
    return foundColumns;
  }
  // used by growGroupPanel
  getColumnWithValidation(key) {
    if (key == null) {
      return null;
    }
    const column = this.getGridColumn(key);
    if (!column) {
      console.warn("AG Grid: could not find column " + key);
    }
    return column;
  }
  getPrimaryColumn(key) {
    if (!this.primaryColumns) {
      return null;
    }
    return this.getColumn(key, this.primaryColumns, this.primaryColumnsMap);
  }
  getGridColumn(key) {
    return this.getColumn(key, this.gridColumns, this.gridColumnsMap);
  }
  lookupGridColumn(key) {
    return this.gridColumnsMap[key];
  }
  getSecondaryColumn(key) {
    if (!this.secondaryColumns) {
      return null;
    }
    return this.getColumn(key, this.secondaryColumns, this.secondaryColumnsMap);
  }
  getColumn(key, columnList, columnMap) {
    if (!key || !columnMap) {
      return null;
    }
    if (typeof key == "string" && columnMap[key]) {
      return columnMap[key];
    }
    for (let i = 0; i < columnList.length; i++) {
      if (this.columnsMatch(columnList[i], key)) {
        return columnList[i];
      }
    }
    return this.getAutoColumn(key);
  }
  getSourceColumnsForGroupColumn(groupCol) {
    const sourceColumnId = groupCol.getColDef().showRowGroup;
    if (!sourceColumnId) {
      return null;
    }
    if (sourceColumnId === true) {
      return this.rowGroupColumns.slice(0);
    }
    const column = this.getPrimaryColumn(sourceColumnId);
    return column ? [column] : null;
  }
  getAutoColumn(key) {
    if (!this.groupAutoColumns || !exists(this.groupAutoColumns) || missing(this.groupAutoColumns)) {
      return null;
    }
    return this.groupAutoColumns.find((groupCol) => this.columnsMatch(groupCol, key)) || null;
  }
  columnsMatch(column, key) {
    const columnMatches = column === key;
    const colDefMatches = column.getColDef() === key;
    const idMatches = column.getColId() == key;
    return columnMatches || colDefMatches || idMatches;
  }
  getDisplayNameForColumn(column, location, includeAggFunc = false) {
    if (!column) {
      return null;
    }
    const headerName = this.getHeaderName(column.getColDef(), column, null, null, location);
    if (includeAggFunc) {
      return this.wrapHeaderNameWithAggFunc(column, headerName);
    }
    return headerName;
  }
  getDisplayNameForProvidedColumnGroup(columnGroup, providedColumnGroup, location) {
    const colGroupDef = providedColumnGroup ? providedColumnGroup.getColGroupDef() : null;
    if (colGroupDef) {
      return this.getHeaderName(colGroupDef, null, columnGroup, providedColumnGroup, location);
    }
    return null;
  }
  getDisplayNameForColumnGroup(columnGroup, location) {
    return this.getDisplayNameForProvidedColumnGroup(columnGroup, columnGroup.getProvidedColumnGroup(), location);
  }
  // location is where the column is going to appear, ie who is calling us
  getHeaderName(colDef, column, columnGroup, providedColumnGroup, location) {
    const headerValueGetter = colDef.headerValueGetter;
    if (headerValueGetter) {
      const params = this.gridOptionsService.addGridCommonParams({
        colDef,
        column,
        columnGroup,
        providedColumnGroup,
        location
      });
      if (typeof headerValueGetter === "function") {
        return headerValueGetter(params);
      } else if (typeof headerValueGetter === "string") {
        return this.expressionService.evaluate(headerValueGetter, params);
      }
      console.warn("AG Grid: headerValueGetter must be a function or a string");
      return "";
    } else if (colDef.headerName != null) {
      return colDef.headerName;
    } else if (colDef.field) {
      return camelCaseToHumanText(colDef.field);
    }
    return "";
  }
  wrapHeaderNameWithAggFunc(column, headerName) {
    if (this.gridOptionsService.get("suppressAggFuncInHeader")) {
      return headerName;
    }
    const pivotValueColumn = column.getColDef().pivotValueColumn;
    const pivotActiveOnThisColumn = exists(pivotValueColumn);
    let aggFunc = null;
    let aggFuncFound;
    if (pivotActiveOnThisColumn) {
      const isCollapsedHeaderEnabled = this.gridOptionsService.get("removePivotHeaderRowWhenSingleValueColumn") && this.valueColumns.length === 1;
      const isTotalColumn = column.getColDef().pivotTotalColumnIds !== void 0;
      if (isCollapsedHeaderEnabled && !isTotalColumn) {
        return headerName;
      }
      aggFunc = pivotValueColumn ? pivotValueColumn.getAggFunc() : null;
      aggFuncFound = true;
    } else {
      const measureActive = column.isValueActive();
      const aggregationPresent = this.pivotMode || !this.isRowGroupEmpty();
      if (measureActive && aggregationPresent) {
        aggFunc = column.getAggFunc();
        aggFuncFound = true;
      } else {
        aggFuncFound = false;
      }
    }
    if (aggFuncFound) {
      const aggFuncString = typeof aggFunc === "string" ? aggFunc : "func";
      const localeTextFunc = this.localeService.getLocaleTextFunc();
      const aggFuncStringTranslated = localeTextFunc(aggFuncString, aggFuncString);
      return `${aggFuncStringTranslated}(${headerName})`;
    }
    return headerName;
  }
  // returns the group with matching colId and instanceId. If instanceId is missing,
  // matches only on the colId.
  getColumnGroup(colId, partId) {
    if (!colId) {
      return null;
    }
    if (colId instanceof ColumnGroup) {
      return colId;
    }
    const allColumnGroups = this.getAllDisplayedTrees();
    const checkPartId = typeof partId === "number";
    let result = null;
    this.columnUtils.depthFirstAllColumnTreeSearch(allColumnGroups, (child) => {
      if (child instanceof ColumnGroup) {
        const columnGroup = child;
        let matched;
        if (checkPartId) {
          matched = colId === columnGroup.getGroupId() && partId === columnGroup.getPartId();
        } else {
          matched = colId === columnGroup.getGroupId();
        }
        if (matched) {
          result = columnGroup;
        }
      }
    });
    return result;
  }
  isReady() {
    return this.ready;
  }
  extractValueColumns(source, oldPrimaryColumns) {
    this.valueColumns = this.extractColumns(
      oldPrimaryColumns,
      this.valueColumns,
      (col, flag) => col.setValueActive(flag, source),
      // aggFunc doesn't have index variant, cos order of value cols doesn't matter, so always return null
      () => void 0,
      () => void 0,
      // aggFunc is a string, so return it's existence
      (colDef) => {
        const aggFunc = colDef.aggFunc;
        if (aggFunc === null || aggFunc === "") {
          return null;
        }
        if (aggFunc === void 0) {
          return;
        }
        return !!aggFunc;
      },
      (colDef) => {
        return colDef.initialAggFunc != null && colDef.initialAggFunc != "";
      }
    );
    this.valueColumns.forEach((col) => {
      const colDef = col.getColDef();
      if (colDef.aggFunc != null && colDef.aggFunc != "") {
        col.setAggFunc(colDef.aggFunc);
      } else {
        if (!col.getAggFunc()) {
          col.setAggFunc(colDef.initialAggFunc);
        }
      }
    });
  }
  extractRowGroupColumns(source, oldPrimaryColumns) {
    this.rowGroupColumns = this.extractColumns(
      oldPrimaryColumns,
      this.rowGroupColumns,
      (col, flag) => col.setRowGroupActive(flag, source),
      (colDef) => colDef.rowGroupIndex,
      (colDef) => colDef.initialRowGroupIndex,
      (colDef) => colDef.rowGroup,
      (colDef) => colDef.initialRowGroup
    );
  }
  extractColumns(oldPrimaryColumns = [], previousCols = [], setFlagFunc, getIndexFunc, getInitialIndexFunc, getValueFunc, getInitialValueFunc) {
    const colsWithIndex = [];
    const colsWithValue = [];
    (this.primaryColumns || []).forEach((col) => {
      const colIsNew = oldPrimaryColumns.indexOf(col) < 0;
      const colDef = col.getColDef();
      const value = attrToBoolean(getValueFunc(colDef));
      const initialValue = attrToBoolean(getInitialValueFunc(colDef));
      const index = attrToNumber(getIndexFunc(colDef));
      const initialIndex = attrToNumber(getInitialIndexFunc(colDef));
      let include;
      const valuePresent = value !== void 0;
      const indexPresent = index !== void 0;
      const initialValuePresent = initialValue !== void 0;
      const initialIndexPresent = initialIndex !== void 0;
      if (valuePresent) {
        include = value;
      } else if (indexPresent) {
        if (index === null) {
          include = false;
        } else {
          include = index >= 0;
        }
      } else {
        if (colIsNew) {
          if (initialValuePresent) {
            include = initialValue;
          } else if (initialIndexPresent) {
            include = initialIndex != null && initialIndex >= 0;
          } else {
            include = false;
          }
        } else {
          include = previousCols.indexOf(col) >= 0;
        }
      }
      if (include) {
        const useIndex = colIsNew ? index != null || initialIndex != null : index != null;
        useIndex ? colsWithIndex.push(col) : colsWithValue.push(col);
      }
    });
    const getIndexForCol = (col) => {
      const index = getIndexFunc(col.getColDef());
      const defaultIndex = getInitialIndexFunc(col.getColDef());
      return index != null ? index : defaultIndex;
    };
    colsWithIndex.sort((colA, colB) => {
      const indexA = getIndexForCol(colA);
      const indexB = getIndexForCol(colB);
      if (indexA === indexB) {
        return 0;
      }
      if (indexA < indexB) {
        return -1;
      }
      return 1;
    });
    const res = [].concat(colsWithIndex);
    previousCols.forEach((col) => {
      if (colsWithValue.indexOf(col) >= 0) {
        res.push(col);
      }
    });
    colsWithValue.forEach((col) => {
      if (res.indexOf(col) < 0) {
        res.push(col);
      }
    });
    previousCols.forEach((col) => {
      if (res.indexOf(col) < 0) {
        setFlagFunc(col, false);
      }
    });
    res.forEach((col) => {
      if (previousCols.indexOf(col) < 0) {
        setFlagFunc(col, true);
      }
    });
    return res;
  }
  extractPivotColumns(source, oldPrimaryColumns) {
    this.pivotColumns = this.extractColumns(
      oldPrimaryColumns,
      this.pivotColumns,
      (col, flag) => col.setPivotActive(flag, source),
      (colDef) => colDef.pivotIndex,
      (colDef) => colDef.initialPivotIndex,
      (colDef) => colDef.pivot,
      (colDef) => colDef.initialPivot
    );
  }
  resetColumnGroupState(source) {
    if (!this.primaryColumnTree) {
      return;
    }
    const stateItems = [];
    this.columnUtils.depthFirstOriginalTreeSearch(null, this.primaryColumnTree, (child) => {
      if (child instanceof ProvidedColumnGroup) {
        const colGroupDef = child.getColGroupDef();
        const groupState = {
          groupId: child.getGroupId(),
          open: !colGroupDef ? void 0 : colGroupDef.openByDefault
        };
        stateItems.push(groupState);
      }
    });
    this.setColumnGroupState(stateItems, source);
  }
  getColumnGroupState() {
    const columnGroupState = [];
    this.columnUtils.depthFirstOriginalTreeSearch(null, this.gridBalancedTree, (node) => {
      if (node instanceof ProvidedColumnGroup) {
        columnGroupState.push({
          groupId: node.getGroupId(),
          open: node.isExpanded()
        });
      }
    });
    return columnGroupState;
  }
  setColumnGroupState(stateItems, source) {
    if (!this.gridBalancedTree) {
      return;
    }
    this.columnAnimationService.start();
    const impactedGroups = [];
    stateItems.forEach((stateItem) => {
      const groupKey = stateItem.groupId;
      const newValue = stateItem.open;
      const providedColumnGroup = this.getProvidedColumnGroup(groupKey);
      if (!providedColumnGroup) {
        return;
      }
      if (providedColumnGroup.isExpanded() === newValue) {
        return;
      }
      this.logger.log("columnGroupOpened(" + providedColumnGroup.getGroupId() + "," + newValue + ")");
      providedColumnGroup.setExpanded(newValue);
      impactedGroups.push(providedColumnGroup);
    });
    this.updateGroupsAndDisplayedColumns(source);
    this.setFirstRightAndLastLeftPinned(source);
    if (impactedGroups.length) {
      const event = {
        type: Events.EVENT_COLUMN_GROUP_OPENED,
        columnGroup: ProvidedColumnGroup.length === 1 ? impactedGroups[0] : void 0,
        columnGroups: impactedGroups
      };
      this.eventService.dispatchEvent(event);
    }
    this.columnAnimationService.finish();
  }
  // called by headerRenderer - when a header is opened or closed
  setColumnGroupOpened(key, newValue, source) {
    let keyAsString;
    if (key instanceof ProvidedColumnGroup) {
      keyAsString = key.getId();
    } else {
      keyAsString = key || "";
    }
    this.setColumnGroupState([{ groupId: keyAsString, open: newValue }], source);
  }
  getProvidedColumnGroup(key) {
    if (typeof key !== "string") {
      console.error("AG Grid: group key must be a string");
    }
    let res = null;
    this.columnUtils.depthFirstOriginalTreeSearch(null, this.gridBalancedTree, (node) => {
      if (node instanceof ProvidedColumnGroup) {
        if (node.getId() === key) {
          res = node;
        }
      }
    });
    return res;
  }
  calculateColumnsForDisplay() {
    let columnsForDisplay;
    if (this.pivotMode && missing(this.secondaryColumns)) {
      columnsForDisplay = this.gridColumns.filter((column) => {
        const isAutoGroupCol = this.groupAutoColumns && includes(this.groupAutoColumns, column);
        const isValueCol = this.valueColumns && includes(this.valueColumns, column);
        return isAutoGroupCol || isValueCol;
      });
    } else {
      columnsForDisplay = this.gridColumns.filter((column) => {
        const isAutoGroupCol = this.groupAutoColumns && includes(this.groupAutoColumns, column);
        return isAutoGroupCol || column.isVisible();
      });
    }
    return columnsForDisplay;
  }
  checkColSpanActiveInCols(columns) {
    let result = false;
    columns.forEach((col) => {
      if (exists(col.getColDef().colSpan)) {
        result = true;
      }
    });
    return result;
  }
  calculateColumnsForGroupDisplay() {
    this.groupDisplayColumns = [];
    this.groupDisplayColumnsMap = {};
    const checkFunc = (col) => {
      const colDef = col.getColDef();
      const underlyingColumn = colDef.showRowGroup;
      if (colDef && exists(underlyingColumn)) {
        this.groupDisplayColumns.push(col);
        if (typeof underlyingColumn === "string") {
          this.groupDisplayColumnsMap[underlyingColumn] = col;
        } else if (underlyingColumn === true) {
          this.getRowGroupColumns().forEach((rowGroupCol) => {
            this.groupDisplayColumnsMap[rowGroupCol.getId()] = col;
          });
        }
      }
    };
    this.gridColumns.forEach(checkFunc);
  }
  getGroupDisplayColumns() {
    return this.groupDisplayColumns;
  }
  getGroupDisplayColumnForGroup(rowGroupColumnId) {
    return this.groupDisplayColumnsMap[rowGroupColumnId];
  }
  updateDisplayedColumns(source) {
    const columnsForDisplay = this.calculateColumnsForDisplay();
    this.buildDisplayedTrees(columnsForDisplay);
    this.updateGroupsAndDisplayedColumns(source);
    this.setFirstRightAndLastLeftPinned(source);
  }
  isSecondaryColumnsPresent() {
    return exists(this.secondaryColumns);
  }
  setSecondaryColumns(colDefs, source) {
    if (!this.gridColumns) {
      return;
    }
    const newColsPresent = colDefs;
    if (!newColsPresent && missing(this.secondaryColumns)) {
      return;
    }
    if (newColsPresent) {
      this.processSecondaryColumnDefinitions(colDefs);
      const balancedTreeResult = this.columnFactory.createColumnTree(
        colDefs,
        false,
        this.secondaryBalancedTree || this.previousSecondaryColumns || void 0,
        source
      );
      this.destroyOldColumns(this.secondaryBalancedTree, balancedTreeResult.columnTree);
      this.secondaryBalancedTree = balancedTreeResult.columnTree;
      this.secondaryHeaderRowCount = balancedTreeResult.treeDept + 1;
      this.secondaryColumns = this.getColumnsFromTree(this.secondaryBalancedTree);
      this.secondaryColumnsMap = {};
      this.secondaryColumns.forEach((col) => this.secondaryColumnsMap[col.getId()] = col);
      this.previousSecondaryColumns = null;
    } else {
      this.previousSecondaryColumns = this.secondaryBalancedTree;
      this.secondaryBalancedTree = null;
      this.secondaryHeaderRowCount = -1;
      this.secondaryColumns = null;
      this.secondaryColumnsMap = {};
    }
    this.updateGridColumns();
    this.updateDisplayedColumns(source);
  }
  processSecondaryColumnDefinitions(colDefs) {
    const columnCallback = this.gridOptionsService.get("processPivotResultColDef");
    const groupCallback = this.gridOptionsService.get("processPivotResultColGroupDef");
    if (!columnCallback && !groupCallback) {
      return void 0;
    }
    const searchForColDefs = (colDefs2) => {
      colDefs2.forEach((abstractColDef) => {
        const isGroup = exists(abstractColDef.children);
        if (isGroup) {
          const colGroupDef = abstractColDef;
          if (groupCallback) {
            groupCallback(colGroupDef);
          }
          searchForColDefs(colGroupDef.children);
        } else {
          const colDef = abstractColDef;
          if (columnCallback) {
            columnCallback(colDef);
          }
        }
      });
    };
    if (colDefs) {
      searchForColDefs(colDefs);
    }
  }
  // called from: applyColumnState, setColumnDefs, setSecondaryColumns
  updateGridColumns() {
    const prevGridCols = this.gridBalancedTree;
    if (this.gridColsArePrimary) {
      this.lastPrimaryOrder = this.gridColumns;
    } else {
      this.lastSecondaryOrder = this.gridColumns;
    }
    const areAutoColsChanged = this.createGroupAutoColumnsIfNeeded();
    if (areAutoColsChanged) {
      const groupAutoColsMap = convertToMap(this.groupAutoColumns.map((col) => [col, true]));
      if (this.lastPrimaryOrder) {
        this.lastPrimaryOrder = this.lastPrimaryOrder.filter((col) => !groupAutoColsMap.has(col));
        this.lastPrimaryOrder = [...this.groupAutoColumns, ...this.lastPrimaryOrder];
      }
      if (this.lastSecondaryOrder) {
        this.lastSecondaryOrder = this.lastSecondaryOrder.filter((col) => !groupAutoColsMap.has(col));
        this.lastSecondaryOrder = [...this.groupAutoColumns, ...this.lastSecondaryOrder];
      }
    }
    let sortOrderToRecover;
    if (this.secondaryColumns && this.secondaryBalancedTree) {
      const hasSameColumns = this.secondaryColumns.some((col) => {
        return this.gridColumnsMap[col.getColId()] !== void 0;
      });
      this.gridBalancedTree = this.secondaryBalancedTree.slice();
      this.gridHeaderRowCount = this.secondaryHeaderRowCount;
      this.gridColumns = this.secondaryColumns.slice();
      this.gridColsArePrimary = false;
      if (hasSameColumns) {
        sortOrderToRecover = this.lastSecondaryOrder;
      }
    } else if (this.primaryColumns) {
      this.gridBalancedTree = this.primaryColumnTree.slice();
      this.gridHeaderRowCount = this.primaryHeaderRowCount;
      this.gridColumns = this.primaryColumns.slice();
      this.gridColsArePrimary = true;
      sortOrderToRecover = this.lastPrimaryOrder;
    }
    this.addAutoGroupToGridColumns();
    this.orderGridColsLike(sortOrderToRecover);
    this.gridColumns = this.placeLockedColumns(this.gridColumns);
    this.calculateColumnsForGroupDisplay();
    this.refreshQuickFilterColumns();
    this.clearDisplayedAndViewportColumns();
    this.colSpanActive = this.checkColSpanActiveInCols(this.gridColumns);
    this.gridColumnsMap = {};
    this.gridColumns.forEach((col) => this.gridColumnsMap[col.getId()] = col);
    this.setAutoHeightActive();
    if (!areEqual(prevGridCols, this.gridBalancedTree)) {
      const event = {
        type: Events.EVENT_GRID_COLUMNS_CHANGED
      };
      this.eventService.dispatchEvent(event);
    }
  }
  setAutoHeightActive() {
    this.autoHeightActive = this.gridColumns.filter((col) => col.isAutoHeight()).length > 0;
    if (this.autoHeightActive) {
      this.autoHeightActiveAtLeastOnce = true;
      const supportedRowModel = this.gridOptionsService.isRowModelType("clientSide") || this.gridOptionsService.isRowModelType("serverSide");
      if (!supportedRowModel) {
        warnOnce("autoHeight columns only work with Client Side Row Model and Server Side Row Model.");
      }
    }
  }
  orderGridColsLike(colsOrder) {
    if (missing(colsOrder)) {
      return;
    }
    const lastOrderMapped = convertToMap(colsOrder.map((col, index) => [col, index]));
    let noColsFound = true;
    this.gridColumns.forEach((col) => {
      if (lastOrderMapped.has(col)) {
        noColsFound = false;
      }
    });
    if (noColsFound) {
      return;
    }
    const gridColsMap = convertToMap(this.gridColumns.map((col) => [col, true]));
    const oldColsOrdered = colsOrder.filter((col) => gridColsMap.has(col));
    const oldColsMap = convertToMap(oldColsOrdered.map((col) => [col, true]));
    const newColsOrdered = this.gridColumns.filter((col) => !oldColsMap.has(col));
    const newGridColumns = oldColsOrdered.slice();
    newColsOrdered.forEach((newCol) => {
      let parent = newCol.getOriginalParent();
      if (!parent) {
        newGridColumns.push(newCol);
        return;
      }
      const siblings = [];
      while (!siblings.length && parent) {
        const leafCols = parent.getLeafColumns();
        leafCols.forEach((leafCol) => {
          const presentInNewGriColumns = newGridColumns.indexOf(leafCol) >= 0;
          const noYetInSiblings = siblings.indexOf(leafCol) < 0;
          if (presentInNewGriColumns && noYetInSiblings) {
            siblings.push(leafCol);
          }
        });
        parent = parent.getOriginalParent();
      }
      if (!siblings.length) {
        newGridColumns.push(newCol);
        return;
      }
      const indexes = siblings.map((col) => newGridColumns.indexOf(col));
      const lastIndex = Math.max(...indexes);
      insertIntoArray(newGridColumns, newCol, lastIndex + 1);
    });
    this.gridColumns = newGridColumns;
  }
  isPrimaryColumnGroupsPresent() {
    return this.primaryHeaderRowCount > 1;
  }
  // if we are using autoGroupCols, then they should be included for quick filter. this covers the
  // following scenarios:
  // a) user provides 'field' into autoGroupCol of normal grid, so now because a valid col to filter leafs on
  // b) using tree data and user depends on autoGroupCol for first col, and we also want to filter on this
  //    (tree data is a bit different, as parent rows can be filtered on, unlike row grouping)
  refreshQuickFilterColumns() {
    var _a;
    let columnsForQuickFilter = (_a = this.isPivotMode() ? this.secondaryColumns : this.primaryColumns) != null ? _a : [];
    if (this.groupAutoColumns) {
      columnsForQuickFilter = columnsForQuickFilter.concat(this.groupAutoColumns);
    }
    this.columnsForQuickFilter = this.gridOptionsService.get("includeHiddenColumnsInQuickFilter") ? columnsForQuickFilter : columnsForQuickFilter.filter((col) => col.isVisible() || col.isRowGroupActive());
  }
  placeLockedColumns(cols) {
    const left = [];
    const normal = [];
    const right = [];
    cols.forEach((col) => {
      const position = col.getColDef().lockPosition;
      if (position === "right") {
        right.push(col);
      } else if (position === "left" || position === true) {
        left.push(col);
      } else {
        normal.push(col);
      }
    });
    return [...left, ...normal, ...right];
  }
  addAutoGroupToGridColumns() {
    if (missing(this.groupAutoColumns)) {
      this.destroyOldColumns(this.groupAutoColsBalancedTree);
      this.groupAutoColsBalancedTree = null;
      return;
    }
    this.gridColumns = this.groupAutoColumns ? this.groupAutoColumns.concat(this.gridColumns) : this.gridColumns;
    const newAutoColsTree = this.columnFactory.createForAutoGroups(this.groupAutoColumns, this.gridBalancedTree);
    this.destroyOldColumns(this.groupAutoColsBalancedTree, newAutoColsTree);
    this.groupAutoColsBalancedTree = newAutoColsTree;
    this.gridBalancedTree = newAutoColsTree.concat(this.gridBalancedTree);
  }
  // gets called after we copy down grid columns, to make sure any part of the gui
  // that tries to draw, eg the header, it will get empty lists of columns rather
  // than stale columns. for example, the header will received gridColumnsChanged
  // event, so will try and draw, but it will draw successfully when it acts on the
  // virtualColumnsChanged event
  clearDisplayedAndViewportColumns() {
    this.viewportRowLeft = {};
    this.viewportRowRight = {};
    this.viewportRowCenter = {};
    this.displayedColumnsLeft = [];
    this.displayedColumnsRight = [];
    this.displayedColumnsCenter = [];
    this.displayedColumns = [];
    this.ariaOrderColumns = [];
    this.viewportColumns = [];
    this.headerViewportColumns = [];
    this.viewportColumnsHash = "";
  }
  updateGroupsAndDisplayedColumns(source) {
    this.updateOpenClosedVisibilityInColumnGroups();
    this.deriveDisplayedColumns(source);
    this.refreshFlexedColumns();
    this.extractViewport();
    this.updateBodyWidths();
    const event = {
      type: Events.EVENT_DISPLAYED_COLUMNS_CHANGED
    };
    this.eventService.dispatchEvent(event);
  }
  deriveDisplayedColumns(source) {
    this.derivedDisplayedColumnsFromDisplayedTree(this.displayedTreeLeft, this.displayedColumnsLeft);
    this.derivedDisplayedColumnsFromDisplayedTree(this.displayedTreeCentre, this.displayedColumnsCenter);
    this.derivedDisplayedColumnsFromDisplayedTree(this.displayedTreeRight, this.displayedColumnsRight);
    this.joinColumnsAriaOrder();
    this.joinDisplayedColumns();
    this.setLeftValues(source);
    this.displayedAutoHeightCols = this.displayedColumns.filter((col) => col.isAutoHeight());
  }
  isAutoRowHeightActive() {
    return this.autoHeightActive;
  }
  wasAutoRowHeightEverActive() {
    return this.autoHeightActiveAtLeastOnce;
  }
  joinColumnsAriaOrder() {
    const allColumns = this.getAllGridColumns();
    const pinnedLeft = [];
    const center = [];
    const pinnedRight = [];
    for (const col of allColumns) {
      const pinned = col.getPinned();
      if (!pinned) {
        center.push(col);
      } else if (pinned === true || pinned === "left") {
        pinnedLeft.push(col);
      } else {
        pinnedRight.push(col);
      }
    }
    this.ariaOrderColumns = pinnedLeft.concat(center).concat(pinnedRight);
  }
  joinDisplayedColumns() {
    if (this.gridOptionsService.get("enableRtl")) {
      this.displayedColumns = this.displayedColumnsRight.concat(this.displayedColumnsCenter).concat(this.displayedColumnsLeft);
    } else {
      this.displayedColumns = this.displayedColumnsLeft.concat(this.displayedColumnsCenter).concat(this.displayedColumnsRight);
    }
  }
  // sets the left pixel position of each column
  setLeftValues(source) {
    this.setLeftValuesOfColumns(source);
    this.setLeftValuesOfGroups();
  }
  setLeftValuesOfColumns(source) {
    if (!this.primaryColumns) {
      return;
    }
    const allColumns = this.getPrimaryAndSecondaryAndAutoColumns().slice(0);
    const doingRtl = this.gridOptionsService.get("enableRtl");
    [
      this.displayedColumnsLeft,
      this.displayedColumnsRight,
      this.displayedColumnsCenter
    ].forEach((columns) => {
      if (doingRtl) {
        let left = this.getWidthOfColsInList(columns);
        columns.forEach((column) => {
          left -= column.getActualWidth();
          column.setLeft(left, source);
        });
      } else {
        let left = 0;
        columns.forEach((column) => {
          column.setLeft(left, source);
          left += column.getActualWidth();
        });
      }
      removeAllFromUnorderedArray(allColumns, columns);
    });
    allColumns.forEach((column) => {
      column.setLeft(null, source);
    });
  }
  setLeftValuesOfGroups() {
    [
      this.displayedTreeLeft,
      this.displayedTreeRight,
      this.displayedTreeCentre
    ].forEach((columns) => {
      columns.forEach((column) => {
        if (column instanceof ColumnGroup) {
          const columnGroup = column;
          columnGroup.checkLeft();
        }
      });
    });
  }
  derivedDisplayedColumnsFromDisplayedTree(tree, columns) {
    columns.length = 0;
    this.columnUtils.depthFirstDisplayedColumnTreeSearch(tree, (child) => {
      if (child instanceof Column) {
        columns.push(child);
      }
    });
  }
  isColumnVirtualisationSuppressed() {
    return this.suppressColumnVirtualisation || this.viewportRight === 0;
  }
  extractViewportColumns() {
    if (this.isColumnVirtualisationSuppressed()) {
      this.viewportColumnsCenter = this.displayedColumnsCenter;
      this.headerViewportColumnsCenter = this.displayedColumnsCenter;
    } else {
      this.viewportColumnsCenter = this.displayedColumnsCenter.filter(this.isColumnInRowViewport.bind(this));
      this.headerViewportColumnsCenter = this.displayedColumnsCenter.filter(this.isColumnInHeaderViewport.bind(this));
    }
    this.viewportColumns = this.viewportColumnsCenter.concat(this.displayedColumnsLeft).concat(this.displayedColumnsRight);
    this.headerViewportColumns = this.headerViewportColumnsCenter.concat(this.displayedColumnsLeft).concat(this.displayedColumnsRight);
  }
  getVirtualHeaderGroupRow(type, dept) {
    let result;
    switch (type) {
      case "left":
        result = this.viewportRowLeft[dept];
        break;
      case "right":
        result = this.viewportRowRight[dept];
        break;
      default:
        result = this.viewportRowCenter[dept];
        break;
    }
    if (missing(result)) {
      result = [];
    }
    return result;
  }
  calculateHeaderRows() {
    this.viewportRowLeft = {};
    this.viewportRowRight = {};
    this.viewportRowCenter = {};
    const virtualColIds = {};
    this.headerViewportColumns.forEach((col) => virtualColIds[col.getId()] = true);
    const testGroup = (children, result, dept) => {
      let returnValue = false;
      for (let i = 0; i < children.length; i++) {
        const child = children[i];
        let addThisItem = false;
        if (child instanceof Column) {
          addThisItem = virtualColIds[child.getId()] === true;
        } else {
          const columnGroup = child;
          const displayedChildren = columnGroup.getDisplayedChildren();
          if (displayedChildren) {
            addThisItem = testGroup(displayedChildren, result, dept + 1);
          }
        }
        if (addThisItem) {
          returnValue = true;
          if (!result[dept]) {
            result[dept] = [];
          }
          result[dept].push(child);
        }
      }
      return returnValue;
    };
    testGroup(this.displayedTreeLeft, this.viewportRowLeft, 0);
    testGroup(this.displayedTreeRight, this.viewportRowRight, 0);
    testGroup(this.displayedTreeCentre, this.viewportRowCenter, 0);
  }
  extractViewport() {
    const hashColumn = (c) => `${c.getId()}-${c.getPinned() || "normal"}`;
    this.extractViewportColumns();
    const newHash = this.viewportColumns.map(hashColumn).join("#");
    const changed = this.viewportColumnsHash !== newHash;
    if (changed) {
      this.viewportColumnsHash = newHash;
      this.calculateHeaderRows();
    }
    return changed;
  }
  refreshFlexedColumns(params = {}) {
    var _a;
    const source = params.source ? params.source : "flex";
    if (params.viewportWidth != null) {
      this.flexViewportWidth = params.viewportWidth;
    }
    if (!this.flexViewportWidth) {
      return [];
    }
    let flexAfterDisplayIndex = -1;
    if (params.resizingCols) {
      const allResizingCols = new Set(params.resizingCols);
      let displayedCols = this.displayedColumnsCenter;
      for (let i = displayedCols.length - 1; i >= 0; i--) {
        if (allResizingCols.has(displayedCols[i])) {
          flexAfterDisplayIndex = i;
          break;
        }
      }
    }
    let knownColumnsWidth = 0;
    let flexingColumns = [];
    let minimumFlexedWidth = 0;
    let totalFlex = 0;
    for (let i = 0; i < this.displayedColumnsCenter.length; i++) {
      const isFlex = this.displayedColumnsCenter[i].getFlex() && i > flexAfterDisplayIndex;
      if (isFlex) {
        flexingColumns.push(this.displayedColumnsCenter[i]);
        totalFlex += this.displayedColumnsCenter[i].getFlex();
        minimumFlexedWidth += (_a = this.displayedColumnsCenter[i].getMinWidth()) != null ? _a : 0;
      } else {
        knownColumnsWidth += this.displayedColumnsCenter[i].getActualWidth();
      }
    }
    ;
    if (!flexingColumns.length) {
      return [];
    }
    let changedColumns = [];
    if (knownColumnsWidth + minimumFlexedWidth > this.flexViewportWidth) {
      flexingColumns.forEach((col) => {
        var _a2;
        return col.setActualWidth((_a2 = col.getMinWidth()) != null ? _a2 : 0, source);
      });
      changedColumns = flexingColumns;
      flexingColumns = [];
    }
    const flexingColumnSizes = [];
    let spaceForFlexingColumns;
    outer:
      while (true) {
        spaceForFlexingColumns = this.flexViewportWidth - knownColumnsWidth;
        const spacePerFlex = spaceForFlexingColumns / totalFlex;
        for (let i = 0; i < flexingColumns.length; i++) {
          const col = flexingColumns[i];
          const widthByFlexRule = spacePerFlex * col.getFlex();
          let constrainedWidth = 0;
          const minWidth = col.getMinWidth();
          const maxWidth = col.getMaxWidth();
          if (exists(minWidth) && widthByFlexRule < minWidth) {
            constrainedWidth = minWidth;
          } else if (exists(maxWidth) && widthByFlexRule > maxWidth) {
            constrainedWidth = maxWidth;
          }
          if (constrainedWidth) {
            col.setActualWidth(constrainedWidth, source);
            removeFromUnorderedArray(flexingColumns, col);
            totalFlex -= col.getFlex();
            changedColumns.push(col);
            knownColumnsWidth += col.getActualWidth();
            continue outer;
          }
          flexingColumnSizes[i] = Math.round(widthByFlexRule);
        }
        break;
      }
    let remainingSpace = spaceForFlexingColumns;
    flexingColumns.forEach((col, i) => {
      col.setActualWidth(Math.min(flexingColumnSizes[i], remainingSpace), source);
      changedColumns.push(col);
      remainingSpace -= flexingColumnSizes[i];
    });
    if (!params.skipSetLeft) {
      this.setLeftValues(source);
    }
    if (params.updateBodyWidths) {
      this.updateBodyWidths();
    }
    if (params.fireResizedEvent) {
      this.dispatchColumnResizedEvent(changedColumns, true, source, flexingColumns);
    }
    return flexingColumns;
  }
  // called from api
  sizeColumnsToFit(gridWidth, source = "sizeColumnsToFit", silent, params) {
    var _c, _d, _e, _f, _g;
    if (this.shouldQueueResizeOperations) {
      this.resizeOperationQueue.push(() => this.sizeColumnsToFit(gridWidth, source, silent, params));
      return;
    }
    const limitsMap = {};
    if (params) {
      (_c = params == null ? void 0 : params.columnLimits) == null ? void 0 : _c.forEach((_a) => {
        var _b = _a, { key } = _b, dimensions = __objRest(_b, ["key"]);
        limitsMap[typeof key === "string" ? key : key.getColId()] = dimensions;
      });
    }
    const allDisplayedColumns = this.getAllDisplayedColumns();
    const doColumnsAlreadyFit = gridWidth === this.getWidthOfColsInList(allDisplayedColumns);
    if (gridWidth <= 0 || !allDisplayedColumns.length || doColumnsAlreadyFit) {
      return;
    }
    const colsToSpread = [];
    const colsToNotSpread = [];
    allDisplayedColumns.forEach((column) => {
      if (column.getColDef().suppressSizeToFit === true) {
        colsToNotSpread.push(column);
      } else {
        colsToSpread.push(column);
      }
    });
    const colsToDispatchEventFor = colsToSpread.slice(0);
    let finishedResizing = false;
    const moveToNotSpread = (column) => {
      removeFromArray(colsToSpread, column);
      colsToNotSpread.push(column);
    };
    colsToSpread.forEach((column) => {
      var _a, _b;
      column.resetActualWidth(source);
      const widthOverride = limitsMap == null ? void 0 : limitsMap[column.getId()];
      const minOverride = (_a = widthOverride == null ? void 0 : widthOverride.minWidth) != null ? _a : params == null ? void 0 : params.defaultMinWidth;
      const maxOverride = (_b = widthOverride == null ? void 0 : widthOverride.maxWidth) != null ? _b : params == null ? void 0 : params.defaultMaxWidth;
      const colWidth = column.getActualWidth();
      if (typeof minOverride === "number" && colWidth < minOverride) {
        column.setActualWidth(minOverride, source, true);
      } else if (typeof maxOverride === "number" && colWidth > maxOverride) {
        column.setActualWidth(maxOverride, source, true);
      }
    });
    while (!finishedResizing) {
      finishedResizing = true;
      const availablePixels = gridWidth - this.getWidthOfColsInList(colsToNotSpread);
      if (availablePixels <= 0) {
        colsToSpread.forEach((column) => {
          var _a, _b;
          const widthOverride = (_b = (_a = limitsMap == null ? void 0 : limitsMap[column.getId()]) == null ? void 0 : _a.minWidth) != null ? _b : params == null ? void 0 : params.defaultMinWidth;
          if (typeof widthOverride === "number") {
            column.setActualWidth(widthOverride, source, true);
            return;
          }
          column.setMinimum(source);
        });
      } else {
        const scale = availablePixels / this.getWidthOfColsInList(colsToSpread);
        let pixelsForLastCol = availablePixels;
        for (let i = colsToSpread.length - 1; i >= 0; i--) {
          const column = colsToSpread[i];
          const widthOverride = limitsMap == null ? void 0 : limitsMap[column.getId()];
          const minOverride = (_d = widthOverride == null ? void 0 : widthOverride.minWidth) != null ? _d : params == null ? void 0 : params.defaultMinWidth;
          const maxOverride = (_e = widthOverride == null ? void 0 : widthOverride.maxWidth) != null ? _e : params == null ? void 0 : params.defaultMaxWidth;
          const colMinWidth = (_f = column.getMinWidth()) != null ? _f : 0;
          const colMaxWidth = (_g = column.getMaxWidth()) != null ? _g : Number.MAX_VALUE;
          const minWidth = typeof minOverride === "number" && minOverride > colMinWidth ? minOverride : column.getMinWidth();
          const maxWidth = typeof maxOverride === "number" && maxOverride < colMaxWidth ? maxOverride : column.getMaxWidth();
          let newWidth = Math.round(column.getActualWidth() * scale);
          if (exists(minWidth) && newWidth < minWidth) {
            newWidth = minWidth;
            moveToNotSpread(column);
            finishedResizing = false;
          } else if (exists(maxWidth) && newWidth > maxWidth) {
            newWidth = maxWidth;
            moveToNotSpread(column);
            finishedResizing = false;
          } else if (i === 0) {
            newWidth = pixelsForLastCol;
          }
          column.setActualWidth(newWidth, source, true);
          pixelsForLastCol -= newWidth;
        }
      }
    }
    colsToDispatchEventFor.forEach((col) => {
      col.fireColumnWidthChangedEvent(source);
    });
    this.setLeftValues(source);
    this.updateBodyWidths();
    if (silent) {
      return;
    }
    this.dispatchColumnResizedEvent(colsToDispatchEventFor, true, source);
  }
  buildDisplayedTrees(visibleColumns) {
    const leftVisibleColumns = [];
    const rightVisibleColumns = [];
    const centerVisibleColumns = [];
    visibleColumns.forEach((column) => {
      switch (column.getPinned()) {
        case "left":
          leftVisibleColumns.push(column);
          break;
        case "right":
          rightVisibleColumns.push(column);
          break;
        default:
          centerVisibleColumns.push(column);
          break;
      }
    });
    const groupInstanceIdCreator = new GroupInstanceIdCreator();
    this.displayedTreeLeft = this.displayedGroupCreator.createDisplayedGroups(
      leftVisibleColumns,
      groupInstanceIdCreator,
      "left",
      this.displayedTreeLeft
    );
    this.displayedTreeRight = this.displayedGroupCreator.createDisplayedGroups(
      rightVisibleColumns,
      groupInstanceIdCreator,
      "right",
      this.displayedTreeRight
    );
    this.displayedTreeCentre = this.displayedGroupCreator.createDisplayedGroups(
      centerVisibleColumns,
      groupInstanceIdCreator,
      null,
      this.displayedTreeCentre
    );
    this.updateDisplayedMap();
  }
  updateDisplayedMap() {
    this.displayedColumnsAndGroupsMap = {};
    const func = (child) => {
      this.displayedColumnsAndGroupsMap[child.getUniqueId()] = child;
    };
    this.columnUtils.depthFirstAllColumnTreeSearch(this.displayedTreeCentre, func);
    this.columnUtils.depthFirstAllColumnTreeSearch(this.displayedTreeLeft, func);
    this.columnUtils.depthFirstAllColumnTreeSearch(this.displayedTreeRight, func);
  }
  isDisplayed(item) {
    const fromMap = this.displayedColumnsAndGroupsMap[item.getUniqueId()];
    return fromMap === item;
  }
  updateOpenClosedVisibilityInColumnGroups() {
    const allColumnGroups = this.getAllDisplayedTrees();
    this.columnUtils.depthFirstAllColumnTreeSearch(allColumnGroups, (child) => {
      if (child instanceof ColumnGroup) {
        child.calculateDisplayedColumns();
      }
    });
  }
  getGroupAutoColumns() {
    return this.groupAutoColumns;
  }
  /**
   * Creates new auto group columns if required
   * @returns whether auto cols have changed
   */
  createGroupAutoColumnsIfNeeded() {
    const forceRecreateAutoGroups = this.forceRecreateAutoGroups;
    this.forceRecreateAutoGroups = false;
    if (!this.autoGroupsNeedBuilding) {
      return false;
    }
    this.autoGroupsNeedBuilding = false;
    const groupFullWidthRow = this.gridOptionsService.isGroupUseEntireRow(this.pivotMode);
    const suppressAutoColumn = this.pivotMode ? this.gridOptionsService.get("pivotSuppressAutoColumn") : this.isGroupSuppressAutoColumn();
    const groupingActive = this.rowGroupColumns.length > 0 || this.gridOptionsService.get("treeData");
    const needAutoColumns = groupingActive && !suppressAutoColumn && !groupFullWidthRow;
    if (needAutoColumns) {
      const newAutoGroupCols = this.autoGroupColService.createAutoGroupColumns(this.rowGroupColumns);
      const autoColsDifferent = !this.autoColsEqual(newAutoGroupCols, this.groupAutoColumns);
      if (autoColsDifferent || forceRecreateAutoGroups) {
        this.groupAutoColumns = newAutoGroupCols;
        return true;
      }
    } else {
      this.groupAutoColumns = null;
    }
    return false;
  }
  isGroupSuppressAutoColumn() {
    const groupDisplayType = this.gridOptionsService.get("groupDisplayType");
    const isCustomRowGroups = groupDisplayType === "custom";
    if (isCustomRowGroups) {
      return true;
    }
    const treeDataDisplayType = this.gridOptionsService.get("treeDataDisplayType");
    return treeDataDisplayType === "custom";
  }
  autoColsEqual(colsA, colsB) {
    return areEqual(colsA, colsB, (a, b) => a.getColId() === b.getColId());
  }
  getWidthOfColsInList(columnList) {
    return columnList.reduce((width, col) => width + col.getActualWidth(), 0);
  }
  getFirstDisplayedColumn() {
    const isRtl = this.gridOptionsService.get("enableRtl");
    const queryOrder = [
      "getDisplayedLeftColumns",
      "getDisplayedCenterColumns",
      "getDisplayedRightColumns"
    ];
    if (isRtl) {
      queryOrder.reverse();
    }
    for (let i = 0; i < queryOrder.length; i++) {
      const container = this[queryOrder[i]]();
      if (container.length) {
        return isRtl ? last(container) : container[0];
      }
    }
    return null;
  }
  setColumnHeaderHeight(col, height) {
    const changed = col.setAutoHeaderHeight(height);
    if (changed) {
      const event = {
        type: Events.EVENT_COLUMN_HEADER_HEIGHT_CHANGED,
        column: col,
        columns: [col],
        source: "autosizeColumnHeaderHeight"
      };
      this.eventService.dispatchEvent(event);
    }
  }
  getColumnGroupHeaderRowHeight() {
    if (this.isPivotMode()) {
      return this.getPivotGroupHeaderHeight();
    }
    return this.getGroupHeaderHeight();
  }
  getColumnHeaderRowHeight() {
    const defaultHeight = this.isPivotMode() ? this.getPivotHeaderHeight() : this.getHeaderHeight();
    const displayedHeights = this.getAllDisplayedColumns().filter((col) => col.isAutoHeaderHeight()).map((col) => col.getAutoHeaderHeight() || 0);
    return Math.max(defaultHeight, ...displayedHeights);
  }
  getHeaderHeight() {
    var _a;
    return (_a = this.gridOptionsService.get("headerHeight")) != null ? _a : this.environment.getFromTheme(25, "headerHeight");
  }
  getFloatingFiltersHeight() {
    var _a;
    return (_a = this.gridOptionsService.get("floatingFiltersHeight")) != null ? _a : this.getHeaderHeight();
  }
  getGroupHeaderHeight() {
    var _a;
    return (_a = this.gridOptionsService.get("groupHeaderHeight")) != null ? _a : this.getHeaderHeight();
  }
  getPivotHeaderHeight() {
    var _a;
    return (_a = this.gridOptionsService.get("pivotHeaderHeight")) != null ? _a : this.getHeaderHeight();
  }
  getPivotGroupHeaderHeight() {
    var _a;
    return (_a = this.gridOptionsService.get("pivotGroupHeaderHeight")) != null ? _a : this.getGroupHeaderHeight();
  }
  queueResizeOperations() {
    this.shouldQueueResizeOperations = true;
  }
  processResizeOperations() {
    this.shouldQueueResizeOperations = false;
    this.resizeOperationQueue.forEach((resizeOperation) => resizeOperation());
    this.resizeOperationQueue = [];
  }
  resetColumnDefIntoColumn(column, source) {
    const userColDef = column.getUserProvidedColDef();
    if (!userColDef) {
      return false;
    }
    const newColDef = this.columnFactory.addColumnDefaultAndTypes(userColDef, column.getColId());
    column.setColDef(newColDef, userColDef, source);
    return true;
  }
  isColumnGroupingLocked(column) {
    const groupLockGroupColumns = this.gridOptionsService.get("groupLockGroupColumns");
    if (!column.isRowGroupActive() || groupLockGroupColumns === 0) {
      return false;
    }
    if (groupLockGroupColumns === -1) {
      return true;
    }
    const colIndex = this.rowGroupColumns.findIndex((groupCol) => groupCol.getColId() === column.getColId());
    return groupLockGroupColumns > colIndex;
  }
  generateColumnStateForRowGroupAndPivotIndexes(updatedRowGroupColumnState, updatedPivotColumnState) {
    let existingColumnStateUpdates = {};
    const orderColumns = (updatedColumnState, colList, enableProp, initialEnableProp, indexProp, initialIndexProp) => {
      if (!colList.length || !this.primaryColumns) {
        return [];
      }
      const updatedColIdArray = Object.keys(updatedColumnState);
      const updatedColIds = new Set(updatedColIdArray);
      const newColIds = new Set(updatedColIdArray);
      const allColIds = new Set(colList.map((column) => {
        const colId = column.getColId();
        newColIds.delete(colId);
        return colId;
      }).concat(updatedColIdArray));
      const colIdsInOriginalOrder = [];
      const originalOrderMap = {};
      let orderIndex = 0;
      for (let i = 0; i < this.primaryColumns.length; i++) {
        const colId = this.primaryColumns[i].getColId();
        if (allColIds.has(colId)) {
          colIdsInOriginalOrder.push(colId);
          originalOrderMap[colId] = orderIndex++;
        }
      }
      let index = 1e3;
      let hasAddedNewCols = false;
      let lastIndex = 0;
      const processPrecedingNewCols = (colId) => {
        const originalOrderIndex = originalOrderMap[colId];
        for (let i = lastIndex; i < originalOrderIndex; i++) {
          const newColId = colIdsInOriginalOrder[i];
          if (newColIds.has(newColId)) {
            updatedColumnState[newColId][indexProp] = index++;
            newColIds.delete(newColId);
          }
        }
        lastIndex = originalOrderIndex;
      };
      colList.forEach((column) => {
        const colId = column.getColId();
        if (updatedColIds.has(colId)) {
          processPrecedingNewCols(colId);
          updatedColumnState[colId][indexProp] = index++;
        } else {
          const colDef = column.getColDef();
          const missingIndex = colDef[indexProp] === null || colDef[indexProp] === void 0 && colDef[initialIndexProp] == null;
          if (missingIndex) {
            if (!hasAddedNewCols) {
              const propEnabled = colDef[enableProp] || colDef[enableProp] === void 0 && colDef[initialEnableProp];
              if (propEnabled) {
                processPrecedingNewCols(colId);
              } else {
                newColIds.forEach((newColId) => {
                  updatedColumnState[newColId][indexProp] = index + originalOrderMap[newColId];
                });
                index += colIdsInOriginalOrder.length;
                hasAddedNewCols = true;
              }
            }
            if (!existingColumnStateUpdates[colId]) {
              existingColumnStateUpdates[colId] = { colId };
            }
            existingColumnStateUpdates[colId][indexProp] = index++;
          }
        }
      });
    };
    orderColumns(updatedRowGroupColumnState, this.rowGroupColumns, "rowGroup", "initialRowGroup", "rowGroupIndex", "initialRowGroupIndex");
    orderColumns(updatedPivotColumnState, this.pivotColumns, "pivot", "initialPivot", "pivotIndex", "initialPivotIndex");
    return Object.values(existingColumnStateUpdates);
  }
  onColumnsReady() {
    const autoSizeStrategy = this.gridOptionsService.get("autoSizeStrategy");
    if (!autoSizeStrategy) {
      return;
    }
    const { type } = autoSizeStrategy;
    setTimeout(() => {
      if (type === "fitGridWidth") {
        const { columnLimits: propColumnLimits, defaultMinWidth, defaultMaxWidth } = autoSizeStrategy;
        const columnLimits = propColumnLimits == null ? void 0 : propColumnLimits.map(({ colId: key, minWidth, maxWidth }) => ({
          key,
          minWidth,
          maxWidth
        }));
        this.ctrlsService.getGridBodyCtrl().sizeColumnsToFit({
          defaultMinWidth,
          defaultMaxWidth,
          columnLimits
        });
      } else if (type === "fitProvidedWidth") {
        this.sizeColumnsToFit(autoSizeStrategy.width, "sizeColumnsToFit");
      }
    });
  }
  onFirstDataRendered() {
    const autoSizeStrategy = this.gridOptionsService.get("autoSizeStrategy");
    if ((autoSizeStrategy == null ? void 0 : autoSizeStrategy.type) !== "fitCellContents") {
      return;
    }
    const { colIds: columns, skipHeader } = autoSizeStrategy;
    setTimeout(() => {
      if (columns) {
        this.autoSizeColumns({
          columns,
          skipHeader,
          source: "autosizeColumns"
        });
      } else {
        this.autoSizeAllColumns("autosizeColumns", skipHeader);
      }
    });
  }
};
__decorateClass([
  Autowired("expressionService")
], ColumnModel.prototype, "expressionService", 2);
__decorateClass([
  Autowired("columnFactory")
], ColumnModel.prototype, "columnFactory", 2);
__decorateClass([
  Autowired("displayedGroupCreator")
], ColumnModel.prototype, "displayedGroupCreator", 2);
__decorateClass([
  Autowired("ctrlsService")
], ColumnModel.prototype, "ctrlsService", 2);
__decorateClass([
  Autowired("autoWidthCalculator")
], ColumnModel.prototype, "autoWidthCalculator", 2);
__decorateClass([
  Autowired("columnUtils")
], ColumnModel.prototype, "columnUtils", 2);
__decorateClass([
  Autowired("columnAnimationService")
], ColumnModel.prototype, "columnAnimationService", 2);
__decorateClass([
  Autowired("autoGroupColService")
], ColumnModel.prototype, "autoGroupColService", 2);
__decorateClass([
  Optional("aggFuncService")
], ColumnModel.prototype, "aggFuncService", 2);
__decorateClass([
  Optional("valueCache")
], ColumnModel.prototype, "valueCache", 2);
__decorateClass([
  Optional("animationFrameService")
], ColumnModel.prototype, "animationFrameService", 2);
__decorateClass([
  Autowired("sortController")
], ColumnModel.prototype, "sortController", 2);
__decorateClass([
  Autowired("columnDefFactory")
], ColumnModel.prototype, "columnDefFactory", 2);
__decorateClass([
  PostConstruct
], ColumnModel.prototype, "init", 1);
__decorateClass([
  PreDestroy
], ColumnModel.prototype, "destroyColumns", 1);
__decorateClass([
  __decorateParam(0, Qualifier("loggerFactory"))
], ColumnModel.prototype, "setBeans", 1);
ColumnModel = __decorateClass([
  Bean("columnModel")
], ColumnModel);
function convertSourceType(source) {
  return source === "gridOptionsUpdated" ? "gridOptionsChanged" : source;
}

// community-modules/core/src/columns/columnUtils.ts
var ColumnUtils = class extends BeanStub {
  calculateColMinWidth(colDef) {
    return colDef.minWidth != null ? colDef.minWidth : this.environment.getMinColWidth();
  }
  calculateColMaxWidth(colDef) {
    return colDef.maxWidth != null ? colDef.maxWidth : Number.MAX_SAFE_INTEGER;
  }
  calculateColInitialWidth(colDef) {
    const minColWidth = this.calculateColMinWidth(colDef);
    const maxColWidth = this.calculateColMaxWidth(colDef);
    let width;
    const colDefWidth = attrToNumber(colDef.width);
    const colDefInitialWidth = attrToNumber(colDef.initialWidth);
    if (colDefWidth != null) {
      width = colDefWidth;
    } else if (colDefInitialWidth != null) {
      width = colDefInitialWidth;
    } else {
      width = 200;
    }
    return Math.max(Math.min(width, maxColWidth), minColWidth);
  }
  getOriginalPathForColumn(column, originalBalancedTree) {
    const result = [];
    let found = false;
    const recursePath = (balancedColumnTree, dept) => {
      for (let i = 0; i < balancedColumnTree.length; i++) {
        if (found) {
          return;
        }
        const node = balancedColumnTree[i];
        if (node instanceof ProvidedColumnGroup) {
          const nextNode = node;
          recursePath(nextNode.getChildren(), dept + 1);
          result[dept] = node;
        } else if (node === column) {
          found = true;
        }
      }
    };
    recursePath(originalBalancedTree, 0);
    return found ? result : null;
  }
  depthFirstOriginalTreeSearch(parent, tree, callback) {
    if (!tree) {
      return;
    }
    tree.forEach((child) => {
      if (child instanceof ProvidedColumnGroup) {
        this.depthFirstOriginalTreeSearch(child, child.getChildren(), callback);
      }
      callback(child, parent);
    });
  }
  depthFirstAllColumnTreeSearch(tree, callback) {
    if (!tree) {
      return;
    }
    tree.forEach((child) => {
      if (child instanceof ColumnGroup) {
        this.depthFirstAllColumnTreeSearch(child.getChildren(), callback);
      }
      callback(child);
    });
  }
  depthFirstDisplayedColumnTreeSearch(tree, callback) {
    if (!tree) {
      return;
    }
    tree.forEach((child) => {
      if (child instanceof ColumnGroup) {
        this.depthFirstDisplayedColumnTreeSearch(child.getDisplayedChildren(), callback);
      }
      callback(child);
    });
  }
};
ColumnUtils = __decorateClass([
  Bean("columnUtils")
], ColumnUtils);

// community-modules/core/src/columns/displayedGroupCreator.ts
var DisplayedGroupCreator = class extends BeanStub {
  createDisplayedGroups(sortedVisibleColumns, groupInstanceIdCreator, pinned, oldDisplayedGroups) {
    const oldColumnsMapped = this.mapOldGroupsById(oldDisplayedGroups);
    const topLevelResultCols = [];
    let groupsOrColsAtCurrentLevel = sortedVisibleColumns;
    while (groupsOrColsAtCurrentLevel.length) {
      const currentlyIterating = groupsOrColsAtCurrentLevel;
      groupsOrColsAtCurrentLevel = [];
      let lastGroupedColIdx = 0;
      const createGroupToIndex = (to) => {
        const from = lastGroupedColIdx;
        lastGroupedColIdx = to;
        const previousNode = currentlyIterating[from];
        const previousNodeProvided = previousNode instanceof ColumnGroup ? previousNode.getProvidedColumnGroup() : previousNode;
        const previousNodeParent = previousNodeProvided.getOriginalParent();
        if (previousNodeParent == null) {
          for (let i = from; i < to; i++) {
            topLevelResultCols.push(currentlyIterating[i]);
          }
          return;
        }
        const newGroup = this.createColumnGroup(
          previousNodeParent,
          groupInstanceIdCreator,
          oldColumnsMapped,
          pinned
        );
        for (let i = from; i < to; i++) {
          newGroup.addChild(currentlyIterating[i]);
        }
        groupsOrColsAtCurrentLevel.push(newGroup);
      };
      for (let i = 1; i < currentlyIterating.length; i++) {
        const thisNode = currentlyIterating[i];
        const thisNodeProvided = thisNode instanceof ColumnGroup ? thisNode.getProvidedColumnGroup() : thisNode;
        const thisNodeParent = thisNodeProvided.getOriginalParent();
        const previousNode = currentlyIterating[lastGroupedColIdx];
        const previousNodeProvided = previousNode instanceof ColumnGroup ? previousNode.getProvidedColumnGroup() : previousNode;
        const previousNodeParent = previousNodeProvided.getOriginalParent();
        if (thisNodeParent !== previousNodeParent) {
          createGroupToIndex(i);
        }
      }
      if (lastGroupedColIdx < currentlyIterating.length) {
        createGroupToIndex(currentlyIterating.length);
      }
    }
    this.setupParentsIntoColumns(topLevelResultCols, null);
    return topLevelResultCols;
  }
  createColumnGroup(providedGroup, groupInstanceIdCreator, oldColumnsMapped, pinned) {
    const groupId = providedGroup.getGroupId();
    const instanceId = groupInstanceIdCreator.getInstanceIdForKey(groupId);
    const uniqueId = ColumnGroup.createUniqueId(groupId, instanceId);
    let columnGroup = oldColumnsMapped[uniqueId];
    if (columnGroup && columnGroup.getProvidedColumnGroup() !== providedGroup) {
      columnGroup = null;
    }
    if (exists(columnGroup)) {
      columnGroup.reset();
    } else {
      columnGroup = new ColumnGroup(providedGroup, groupId, instanceId, pinned);
      this.context.createBean(columnGroup);
    }
    return columnGroup;
  }
  // returns back a 2d map of ColumnGroup as follows: groupId -> instanceId -> ColumnGroup
  mapOldGroupsById(displayedGroups) {
    const result = {};
    const recursive = (columnsOrGroups) => {
      columnsOrGroups.forEach((columnOrGroup) => {
        if (columnOrGroup instanceof ColumnGroup) {
          const columnGroup = columnOrGroup;
          result[columnOrGroup.getUniqueId()] = columnGroup;
          recursive(columnGroup.getChildren());
        }
      });
    };
    if (displayedGroups) {
      recursive(displayedGroups);
    }
    return result;
  }
  setupParentsIntoColumns(columnsOrGroups, parent) {
    columnsOrGroups.forEach((columnsOrGroup) => {
      columnsOrGroup.setParent(parent);
      if (columnsOrGroup instanceof ColumnGroup) {
        const columnGroup = columnsOrGroup;
        this.setupParentsIntoColumns(columnGroup.getChildren(), columnGroup);
      }
    });
  }
};
DisplayedGroupCreator = __decorateClass([
  Bean("displayedGroupCreator")
], DisplayedGroupCreator);

// community-modules/core/src/propertyKeys.ts
var INITIAL_GRID_OPTION_KEYS = {
  enableBrowserTooltips: true,
  tooltipTrigger: true,
  tooltipMouseTrack: true,
  tooltipShowMode: true,
  tooltipInteraction: true,
  defaultColGroupDef: true,
  suppressAutoSize: true,
  skipHeaderOnAutoSize: true,
  autoSizeStrategy: true,
  components: true,
  stopEditingWhenCellsLoseFocus: true,
  undoRedoCellEditing: true,
  undoRedoCellEditingLimit: true,
  excelStyles: true,
  cacheQuickFilter: true,
  excludeHiddenColumnsFromQuickFilter: true,
  advancedFilterModel: true,
  customChartThemes: true,
  chartThemeOverrides: true,
  enableChartToolPanelsButton: true,
  suppressChartToolPanelsButton: true,
  chartToolPanelsDef: true,
  loadingCellRendererSelector: true,
  localeText: true,
  keepDetailRows: true,
  keepDetailRowsCount: true,
  detailRowHeight: true,
  detailRowAutoHeight: true,
  tabIndex: true,
  valueCache: true,
  valueCacheNeverExpires: true,
  enableCellExpressions: true,
  suppressParentsInRowNodes: true,
  suppressTouch: true,
  suppressAsyncEvents: true,
  suppressBrowserResizeObserver: true,
  suppressPropertyNamesCheck: true,
  debug: true,
  loadingOverlayComponent: true,
  suppressLoadingOverlay: true,
  noRowsOverlayComponent: true,
  paginationPageSizeSelector: true,
  paginateChildRows: true,
  pivotPanelShow: true,
  pivotSuppressAutoColumn: true,
  suppressExpandablePivotGroups: true,
  aggFuncs: true,
  suppressAggFuncInHeader: true,
  suppressAggAtRootLevel: true,
  removePivotHeaderRowWhenSingleValueColumn: true,
  allowShowChangeAfterFilter: true,
  ensureDomOrder: true,
  enableRtl: true,
  suppressColumnVirtualisation: true,
  suppressMaxRenderedRowRestriction: true,
  suppressRowVirtualisation: true,
  rowDragText: true,
  suppressGroupMaintainValueType: true,
  groupLockGroupColumns: true,
  rowGroupPanelSuppressSort: true,
  suppressGroupRowsSticky: true,
  rowModelType: true,
  cacheOverflowSize: true,
  infiniteInitialRowCount: true,
  serverSideInitialRowCount: true,
  suppressServerSideInfiniteScroll: true,
  maxBlocksInCache: true,
  maxConcurrentDatasourceRequests: true,
  blockLoadDebounceMillis: true,
  serverSideOnlyRefreshFilteredGroups: true,
  serverSidePivotResultFieldSeparator: true,
  viewportRowModelPageSize: true,
  viewportRowModelBufferSize: true,
  debounceVerticalScrollbar: true,
  suppressAnimationFrame: true,
  suppressPreventDefaultOnMouseWheel: true,
  scrollbarWidth: true,
  icons: true,
  suppressRowTransform: true,
  gridId: true,
  functionsPassive: true,
  enableGroupEdit: true,
  initialState: true,
  processUnpinnedColumns: true,
  createChartContainer: true,
  getLocaleText: true,
  getRowId: true,
  reactiveCustomComponents: true,
  columnMenu: true
};
var _PropertyKeys = class _PropertyKeys {
};
_PropertyKeys.STRING_PROPERTIES = [
  "rowSelection",
  "overlayLoadingTemplate",
  "overlayNoRowsTemplate",
  "gridId",
  "quickFilterText",
  "rowModelType",
  "editType",
  "domLayout",
  "clipboardDelimiter",
  "rowGroupPanelShow",
  "multiSortKey",
  "pivotColumnGroupTotals",
  "pivotRowTotals",
  "pivotPanelShow",
  "fillHandleDirection",
  "groupDisplayType",
  "treeDataDisplayType",
  "colResizeDefault",
  "tooltipTrigger",
  "serverSidePivotResultFieldSeparator",
  "columnMenu",
  "tooltipShowMode"
];
_PropertyKeys.OBJECT_PROPERTIES = [
  "components",
  "rowStyle",
  "context",
  "autoGroupColumnDef",
  "localeText",
  "icons",
  "datasource",
  "serverSideDatasource",
  "viewportDatasource",
  "groupRowRendererParams",
  "aggFuncs",
  "fullWidthCellRendererParams",
  "defaultColGroupDef",
  "defaultColDef",
  "defaultCsvExportParams",
  "defaultExcelExportParams",
  "columnTypes",
  "rowClassRules",
  "detailCellRendererParams",
  "loadingCellRendererParams",
  "loadingOverlayComponentParams",
  "noRowsOverlayComponentParams",
  "popupParent",
  "statusBar",
  "sideBar",
  "chartThemeOverrides",
  "customChartThemes",
  "chartToolPanelsDef",
  "dataTypeDefinitions",
  "advancedFilterModel",
  "advancedFilterParent",
  "advancedFilterBuilderParams",
  "initialState",
  "autoSizeStrategy"
];
_PropertyKeys.ARRAY_PROPERTIES = [
  "sortingOrder",
  "alignedGrids",
  "rowData",
  "columnDefs",
  "excelStyles",
  "pinnedTopRowData",
  "pinnedBottomRowData",
  "chartThemes",
  "rowClass",
  "paginationPageSizeSelector"
];
_PropertyKeys.NUMBER_PROPERTIES = [
  "rowHeight",
  "detailRowHeight",
  "rowBuffer",
  "headerHeight",
  "groupHeaderHeight",
  "groupLockGroupColumns",
  "floatingFiltersHeight",
  "pivotHeaderHeight",
  "pivotGroupHeaderHeight",
  "groupDefaultExpanded",
  "pivotDefaultExpanded",
  "viewportRowModelPageSize",
  "viewportRowModelBufferSize",
  "autoSizePadding",
  "maxBlocksInCache",
  "maxConcurrentDatasourceRequests",
  "tooltipShowDelay",
  "tooltipHideDelay",
  "cacheOverflowSize",
  "paginationPageSize",
  "cacheBlockSize",
  "infiniteInitialRowCount",
  "serverSideInitialRowCount",
  "scrollbarWidth",
  "asyncTransactionWaitMillis",
  "blockLoadDebounceMillis",
  "keepDetailRowsCount",
  "undoRedoCellEditingLimit",
  "cellFlashDelay",
  "cellFadeDelay",
  "cellFlashDuration",
  "cellFadeDuration",
  "tabIndex",
  "pivotMaxGeneratedColumns"
];
_PropertyKeys.BOOLEAN_PROPERTIES = [
  "suppressMakeColumnVisibleAfterUnGroup",
  "suppressRowClickSelection",
  "suppressCellFocus",
  "suppressHeaderFocus",
  "suppressHorizontalScroll",
  "groupSelectsChildren",
  "alwaysShowHorizontalScroll",
  "alwaysShowVerticalScroll",
  "debug",
  "enableBrowserTooltips",
  "enableCellExpressions",
  "groupIncludeTotalFooter",
  "groupSuppressBlankHeader",
  "suppressMenuHide",
  "suppressRowDeselection",
  "unSortIcon",
  "suppressMultiSort",
  "alwaysMultiSort",
  "singleClickEdit",
  "suppressLoadingOverlay",
  "suppressNoRowsOverlay",
  "suppressAutoSize",
  "skipHeaderOnAutoSize",
  "suppressParentsInRowNodes",
  "suppressColumnMoveAnimation",
  "suppressMovableColumns",
  "suppressFieldDotNotation",
  "enableRangeSelection",
  "enableRangeHandle",
  "enableFillHandle",
  "suppressClearOnFillReduction",
  "deltaSort",
  "suppressTouch",
  "suppressAsyncEvents",
  "allowContextMenuWithControlKey",
  "suppressContextMenu",
  "enableCellChangeFlash",
  "suppressDragLeaveHidesColumns",
  "suppressRowGroupHidesColumns",
  "suppressMiddleClickScrolls",
  "suppressPreventDefaultOnMouseWheel",
  "suppressCopyRowsToClipboard",
  "copyHeadersToClipboard",
  "copyGroupHeadersToClipboard",
  "pivotMode",
  "suppressAggFuncInHeader",
  "suppressColumnVirtualisation",
  "alwaysAggregateAtRootLevel",
  "suppressAggAtRootLevel",
  "suppressFocusAfterRefresh",
  "functionsPassive",
  "functionsReadOnly",
  "animateRows",
  "groupSelectsFiltered",
  "groupRemoveSingleChildren",
  "groupRemoveLowestSingleChildren",
  "enableRtl",
  "suppressClickEdit",
  "rowDragEntireRow",
  "rowDragManaged",
  "suppressRowDrag",
  "suppressMoveWhenRowDragging",
  "rowDragMultiRow",
  "enableGroupEdit",
  "embedFullWidthRows",
  "suppressPaginationPanel",
  "groupHideOpenParents",
  "groupAllowUnbalanced",
  "pagination",
  "paginationAutoPageSize",
  "suppressScrollOnNewData",
  "suppressScrollWhenPopupsAreOpen",
  "purgeClosedRowNodes",
  "cacheQuickFilter",
  "includeHiddenColumnsInQuickFilter",
  "excludeHiddenColumnsFromQuickFilter",
  "ensureDomOrder",
  "accentedSort",
  "suppressChangeDetection",
  "valueCache",
  "valueCacheNeverExpires",
  "aggregateOnlyChangedColumns",
  "suppressAnimationFrame",
  "suppressExcelExport",
  "suppressCsvExport",
  "includeHiddenColumnsInAdvancedFilter",
  "suppressMultiRangeSelection",
  "enterMovesDown",
  "enterMovesDownAfterEdit",
  "enterNavigatesVerticallyAfterEdit",
  "enterNavigatesVertically",
  "suppressPropertyNamesCheck",
  "rowMultiSelectWithClick",
  "suppressRowHoverHighlight",
  "suppressRowTransform",
  "suppressClipboardPaste",
  "suppressLastEmptyLineOnPaste",
  "enableCharts",
  "enableChartToolPanelsButton",
  "suppressChartToolPanelsButton",
  "suppressMaintainUnsortedOrder",
  "enableCellTextSelection",
  "suppressBrowserResizeObserver",
  "suppressMaxRenderedRowRestriction",
  "excludeChildrenWhenTreeDataFiltering",
  "tooltipMouseTrack",
  "tooltipInteraction",
  "keepDetailRows",
  "paginateChildRows",
  "preventDefaultOnContextMenu",
  "undoRedoCellEditing",
  "allowDragFromColumnsToolPanel",
  "pivotSuppressAutoColumn",
  "suppressExpandablePivotGroups",
  "debounceVerticalScrollbar",
  "detailRowAutoHeight",
  "serverSideFilterAllLevels",
  "serverSideSortAllLevels",
  "serverSideEnableClientSideSort",
  "serverSideOnlyRefreshFilteredGroups",
  "serverSideSortOnServer",
  "serverSideFilterOnServer",
  "suppressAggFilteredOnly",
  "showOpenedGroup",
  "suppressClipboardApi",
  "suppressModelUpdateAfterUpdateTransaction",
  "stopEditingWhenCellsLoseFocus",
  "maintainColumnOrder",
  "groupMaintainOrder",
  "columnHoverHighlight",
  "readOnlyEdit",
  "suppressRowVirtualisation",
  "enableCellEditingOnBackspace",
  "resetRowDataOnUpdate",
  "removePivotHeaderRowWhenSingleValueColumn",
  "suppressCopySingleCellRanges",
  "suppressGroupRowsSticky",
  "suppressCutToClipboard",
  "suppressServerSideInfiniteScroll",
  "rowGroupPanelSuppressSort",
  "allowShowChangeAfterFilter",
  "enableAdvancedFilter",
  "masterDetail",
  "treeData",
  "suppressGroupMaintainValueType",
  "reactiveCustomComponents"
];
/** You do not need to include event callbacks in this list, as they are generated automatically. */
_PropertyKeys.FUNCTIONAL_PROPERTIES = [
  "doesExternalFilterPass",
  "processPivotResultColDef",
  "processPivotResultColGroupDef",
  "getBusinessKeyForNode",
  "isRowSelectable",
  "rowDragText",
  "groupRowRenderer",
  "fullWidthCellRenderer",
  "loadingCellRenderer",
  "loadingOverlayComponent",
  "noRowsOverlayComponent",
  "detailCellRenderer",
  "quickFilterParser",
  "quickFilterMatcher"
];
/** These callbacks extend AgGridCommon interface */
_PropertyKeys.CALLBACK_PROPERTIES = [
  "getLocaleText",
  "isExternalFilterPresent",
  "getRowHeight",
  "getRowClass",
  "getRowStyle",
  "getContextMenuItems",
  "getMainMenuItems",
  "processRowPostCreate",
  "processCellForClipboard",
  "getGroupRowAgg",
  "isFullWidthRow",
  "sendToClipboard",
  "navigateToNextHeader",
  "tabToNextHeader",
  "navigateToNextCell",
  "tabToNextCell",
  "processCellFromClipboard",
  "getDocument",
  "postProcessPopup",
  "getChildCount",
  "getDataPath",
  "isRowMaster",
  "postSortRows",
  "processHeaderForClipboard",
  "processUnpinnedColumns",
  "processGroupHeaderForClipboard",
  "paginationNumberFormatter",
  "processDataFromClipboard",
  "getServerSideGroupKey",
  "isServerSideGroup",
  "createChartContainer",
  "getChartToolbarItems",
  "fillOperation",
  "isApplyServerSideTransaction",
  "getServerSideGroupLevelParams",
  "isServerSideGroupOpenByDefault",
  "isGroupOpenByDefault",
  "initialGroupOrderComparator",
  "groupIncludeFooter",
  "loadingCellRendererSelector",
  "getRowId",
  "groupAggFiltering",
  "chartMenuItems"
];
_PropertyKeys.FUNCTION_PROPERTIES = [
  ..._PropertyKeys.FUNCTIONAL_PROPERTIES,
  ..._PropertyKeys.CALLBACK_PROPERTIES
];
_PropertyKeys.ALL_PROPERTIES = [
  ..._PropertyKeys.ARRAY_PROPERTIES,
  ..._PropertyKeys.OBJECT_PROPERTIES,
  ..._PropertyKeys.STRING_PROPERTIES,
  ..._PropertyKeys.NUMBER_PROPERTIES,
  ..._PropertyKeys.FUNCTION_PROPERTIES,
  ..._PropertyKeys.BOOLEAN_PROPERTIES
];
var PropertyKeys = _PropertyKeys;

// community-modules/core/src/components/componentUtil.ts
var _ComponentUtil = class _ComponentUtil {
  static getCallbackForEvent(eventName) {
    if (!eventName || eventName.length < 2) {
      return eventName;
    }
    return "on" + eventName[0].toUpperCase() + eventName.substring(1);
  }
  static getGridOptionKeys() {
    return this.ALL_PROPERTIES_AND_CALLBACKS;
  }
  /** Combines component props / attributes with the provided gridOptions returning a new combined gridOptions object */
  static combineAttributesAndGridOptions(gridOptions, component) {
    if (typeof gridOptions !== "object") {
      gridOptions = {};
    }
    const mergedOptions = __spreadValues({}, gridOptions);
    const keys2 = _ComponentUtil.getGridOptionKeys();
    keys2.forEach((key) => {
      const value = component[key];
      if (typeof value !== "undefined" && value !== _ComponentUtil.VUE_OMITTED_PROPERTY) {
        mergedOptions[key] = value;
      }
    });
    return mergedOptions;
  }
  static processOnChange(changes, api) {
    if (!changes) {
      return;
    }
    const gridChanges = {};
    let hasChanges = false;
    Object.keys(changes).filter((key) => _ComponentUtil.ALL_PROPERTIES_AND_CALLBACKS_SET.has(key)).forEach((key) => {
      gridChanges[key] = changes[key];
      hasChanges = true;
    });
    if (!hasChanges) {
      return;
    }
    api.__internalUpdateGridOptions(gridChanges);
    const event = {
      type: Events.EVENT_COMPONENT_STATE_CHANGED
    };
    iterateObject(gridChanges, (key, value) => {
      event[key] = value;
    });
    api.dispatchEvent(event);
  }
};
// all events
_ComponentUtil.EVENTS = values(Events);
_ComponentUtil.VUE_OMITTED_PROPERTY = "AG-VUE-OMITTED-PROPERTY";
// events that are internal to AG Grid and should not be exposed to users via documentation or generated framework components
/** Exclude the following internal events from code generation to prevent exposing these events via framework components */
_ComponentUtil.EXCLUDED_INTERNAL_EVENTS = [
  Events.EVENT_SCROLLBAR_WIDTH_CHANGED,
  Events.EVENT_CHECKBOX_CHANGED,
  Events.EVENT_HEIGHT_SCALE_CHANGED,
  Events.EVENT_BODY_HEIGHT_CHANGED,
  Events.EVENT_COLUMN_CONTAINER_WIDTH_CHANGED,
  Events.EVENT_DISPLAYED_COLUMNS_WIDTH_CHANGED,
  Events.EVENT_SCROLL_VISIBILITY_CHANGED,
  Events.EVENT_COLUMN_HOVER_CHANGED,
  Events.EVENT_FLASH_CELLS,
  Events.EVENT_PAGINATION_PIXEL_OFFSET_CHANGED,
  Events.EVENT_DISPLAYED_ROWS_CHANGED,
  Events.EVENT_LEFT_PINNED_WIDTH_CHANGED,
  Events.EVENT_RIGHT_PINNED_WIDTH_CHANGED,
  Events.EVENT_ROW_CONTAINER_HEIGHT_CHANGED,
  Events.EVENT_STORE_UPDATED,
  Events.EVENT_COLUMN_PANEL_ITEM_DRAG_START,
  Events.EVENT_COLUMN_PANEL_ITEM_DRAG_END,
  Events.EVENT_FILL_START,
  Events.EVENT_FILL_END,
  Events.EVENT_KEY_SHORTCUT_CHANGED_CELL_START,
  Events.EVENT_KEY_SHORTCUT_CHANGED_CELL_END,
  Events.EVENT_FULL_WIDTH_ROW_FOCUSED,
  Events.EVENT_HEADER_HEIGHT_CHANGED,
  Events.EVENT_COLUMN_HEADER_HEIGHT_CHANGED,
  Events.EVENT_CELL_FOCUS_CLEARED,
  Events.EVENT_GRID_STYLES_CHANGED,
  Events.EVENT_FILTER_DESTROYED,
  Events.EVENT_ROW_DATA_UPDATE_STARTED,
  Events.EVENT_ADVANCED_FILTER_ENABLED_CHANGED,
  Events.EVENT_DATA_TYPES_INFERRED,
  Events.EVENT_FIELD_VALUE_CHANGED,
  Events.EVENT_FIELD_PICKER_VALUE_SELECTED,
  Events.EVENT_SUPPRESS_COLUMN_MOVE_CHANGED,
  Events.EVENT_SUPPRESS_MENU_HIDE_CHANGED,
  Events.EVENT_SUPPRESS_FIELD_DOT_NOTATION,
  Events.EVENT_ROW_COUNT_READY,
  Events.EVENT_SIDE_BAR_UPDATED
];
// events that are available for use by users of AG Grid and so should be documented
/** EVENTS that should be exposed via code generation for the framework components.  */
_ComponentUtil.PUBLIC_EVENTS = _ComponentUtil.EVENTS.filter((e) => !includes(_ComponentUtil.EXCLUDED_INTERNAL_EVENTS, e));
// onXXX methods, based on the above events
_ComponentUtil.EVENT_CALLBACKS = _ComponentUtil.EVENTS.map((event) => _ComponentUtil.getCallbackForEvent(event));
_ComponentUtil.STRING_PROPERTIES = PropertyKeys.STRING_PROPERTIES;
_ComponentUtil.OBJECT_PROPERTIES = PropertyKeys.OBJECT_PROPERTIES;
_ComponentUtil.ARRAY_PROPERTIES = PropertyKeys.ARRAY_PROPERTIES;
_ComponentUtil.NUMBER_PROPERTIES = PropertyKeys.NUMBER_PROPERTIES;
_ComponentUtil.BOOLEAN_PROPERTIES = PropertyKeys.BOOLEAN_PROPERTIES;
_ComponentUtil.FUNCTION_PROPERTIES = PropertyKeys.FUNCTION_PROPERTIES;
_ComponentUtil.ALL_PROPERTIES = PropertyKeys.ALL_PROPERTIES;
_ComponentUtil.ALL_PROPERTIES_AND_CALLBACKS = [..._ComponentUtil.ALL_PROPERTIES, ..._ComponentUtil.EVENT_CALLBACKS];
_ComponentUtil.ALL_PROPERTIES_AND_CALLBACKS_SET = new Set(_ComponentUtil.ALL_PROPERTIES_AND_CALLBACKS);
var ComponentUtil = _ComponentUtil;

// community-modules/core/src/components/agStackComponentsRegistry.ts
var AgStackComponentsRegistry = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.componentsMappedByName = {};
  }
  setupComponents(components) {
    if (components) {
      components.forEach((componentMeta) => this.addComponent(componentMeta));
    }
  }
  addComponent(componentMeta) {
    const classEscaped = componentMeta.componentName.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase();
    const classUpperCase = classEscaped.toUpperCase();
    this.componentsMappedByName[classUpperCase] = componentMeta.componentClass;
  }
  getComponentClass(htmlTag) {
    return this.componentsMappedByName[htmlTag];
  }
};
AgStackComponentsRegistry = __decorateClass([
  Bean("agStackComponentsRegistry")
], AgStackComponentsRegistry);

// community-modules/core/src/utils/aria.ts
var aria_exports = {};
__export(aria_exports, {
  getAriaCheckboxStateName: () => getAriaCheckboxStateName,
  getAriaLabel: () => getAriaLabel,
  getAriaLevel: () => getAriaLevel,
  getAriaPosInSet: () => getAriaPosInSet,
  getAriaSortState: () => getAriaSortState,
  removeAriaExpanded: () => removeAriaExpanded,
  removeAriaSort: () => removeAriaSort,
  setAriaActiveDescendant: () => setAriaActiveDescendant,
  setAriaAtomic: () => setAriaAtomic,
  setAriaChecked: () => setAriaChecked,
  setAriaColCount: () => setAriaColCount,
  setAriaColIndex: () => setAriaColIndex,
  setAriaColSpan: () => setAriaColSpan,
  setAriaControls: () => setAriaControls,
  setAriaDescribedBy: () => setAriaDescribedBy,
  setAriaDisabled: () => setAriaDisabled,
  setAriaExpanded: () => setAriaExpanded,
  setAriaHidden: () => setAriaHidden,
  setAriaLabel: () => setAriaLabel,
  setAriaLabelledBy: () => setAriaLabelledBy,
  setAriaLevel: () => setAriaLevel,
  setAriaLive: () => setAriaLive,
  setAriaMultiSelectable: () => setAriaMultiSelectable,
  setAriaPosInSet: () => setAriaPosInSet,
  setAriaRelevant: () => setAriaRelevant,
  setAriaRole: () => setAriaRole,
  setAriaRowCount: () => setAriaRowCount,
  setAriaRowIndex: () => setAriaRowIndex,
  setAriaSelected: () => setAriaSelected,
  setAriaSetSize: () => setAriaSetSize,
  setAriaSort: () => setAriaSort
});
function toggleAriaAttribute(element, attribute, value) {
  if (value == null || typeof value === "string" && value == "") {
    removeAriaAttribute(element, attribute);
  } else {
    setAriaAttribute(element, attribute, value);
  }
}
function setAriaAttribute(element, attribute, value) {
  element.setAttribute(ariaAttributeName(attribute), value.toString());
}
function removeAriaAttribute(element, attribute) {
  element.removeAttribute(ariaAttributeName(attribute));
}
function ariaAttributeName(attribute) {
  return `aria-${attribute}`;
}
function setAriaRole(element, role) {
  if (role) {
    element.setAttribute("role", role);
  } else {
    element.removeAttribute("role");
  }
}
function getAriaSortState(sortDirection) {
  let sort;
  if (sortDirection === "asc") {
    sort = "ascending";
  } else if (sortDirection === "desc") {
    sort = "descending";
  } else if (sortDirection === "mixed") {
    sort = "other";
  } else {
    sort = "none";
  }
  return sort;
}
function getAriaLevel(element) {
  return parseInt(element.getAttribute("aria-level"), 10);
}
function getAriaPosInSet(element) {
  return parseInt(element.getAttribute("aria-posinset"), 10);
}
function getAriaLabel(element) {
  return element.getAttribute("aria-label");
}
function setAriaLabel(element, label) {
  toggleAriaAttribute(element, "label", label);
}
function setAriaLabelledBy(element, labelledBy) {
  toggleAriaAttribute(element, "labelledby", labelledBy);
}
function setAriaDescribedBy(element, describedby) {
  toggleAriaAttribute(element, "describedby", describedby);
}
function setAriaLive(element, live) {
  toggleAriaAttribute(element, "live", live);
}
function setAriaAtomic(element, atomic) {
  toggleAriaAttribute(element, "atomic", atomic);
}
function setAriaRelevant(element, relevant) {
  toggleAriaAttribute(element, "relevant", relevant);
}
function setAriaLevel(element, level) {
  toggleAriaAttribute(element, "level", level);
}
function setAriaDisabled(element, disabled) {
  toggleAriaAttribute(element, "disabled", disabled);
}
function setAriaHidden(element, hidden) {
  toggleAriaAttribute(element, "hidden", hidden);
}
function setAriaActiveDescendant(element, descendantId) {
  toggleAriaAttribute(element, "activedescendant", descendantId);
}
function setAriaExpanded(element, expanded) {
  setAriaAttribute(element, "expanded", expanded);
}
function removeAriaExpanded(element) {
  removeAriaAttribute(element, "expanded");
}
function setAriaSetSize(element, setsize) {
  setAriaAttribute(element, "setsize", setsize);
}
function setAriaPosInSet(element, position) {
  setAriaAttribute(element, "posinset", position);
}
function setAriaMultiSelectable(element, multiSelectable) {
  setAriaAttribute(element, "multiselectable", multiSelectable);
}
function setAriaRowCount(element, rowCount) {
  setAriaAttribute(element, "rowcount", rowCount);
}
function setAriaRowIndex(element, rowIndex) {
  setAriaAttribute(element, "rowindex", rowIndex);
}
function setAriaColCount(element, colCount) {
  setAriaAttribute(element, "colcount", colCount);
}
function setAriaColIndex(element, colIndex) {
  setAriaAttribute(element, "colindex", colIndex);
}
function setAriaColSpan(element, colSpan) {
  setAriaAttribute(element, "colspan", colSpan);
}
function setAriaSort(element, sort) {
  setAriaAttribute(element, "sort", sort);
}
function removeAriaSort(element) {
  removeAriaAttribute(element, "sort");
}
function setAriaSelected(element, selected) {
  toggleAriaAttribute(element, "selected", selected);
}
function setAriaChecked(element, checked) {
  setAriaAttribute(element, "checked", checked === void 0 ? "mixed" : checked);
}
function setAriaControls(controllerElement, controlledElement) {
  toggleAriaAttribute(controllerElement, "controls", controlledElement.id);
  setAriaLabelledBy(controlledElement, controllerElement.id);
}
function getAriaCheckboxStateName(translate, state) {
  return state === void 0 ? translate("ariaIndeterminate", "indeterminate") : state === true ? translate("ariaChecked", "checked") : translate("ariaUnchecked", "unchecked");
}

// community-modules/core/src/utils/browser.ts
var browser_exports = {};
__export(browser_exports, {
  browserSupportsPreventScroll: () => browserSupportsPreventScroll,
  getBodyHeight: () => getBodyHeight,
  getBodyWidth: () => getBodyWidth,
  getMaxDivHeight: () => getMaxDivHeight,
  getSafariVersion: () => getSafariVersion,
  getScrollbarWidth: () => getScrollbarWidth,
  getTabIndex: () => getTabIndex,
  isBrowserChrome: () => isBrowserChrome,
  isBrowserFirefox: () => isBrowserFirefox,
  isBrowserSafari: () => isBrowserSafari,
  isIOSUserAgent: () => isIOSUserAgent,
  isInvisibleScrollbar: () => isInvisibleScrollbar,
  isMacOsUserAgent: () => isMacOsUserAgent
});
var isSafari;
var safariVersion;
var isChrome;
var isFirefox;
var isMacOs;
var isIOS;
var invisibleScrollbar;
var browserScrollbarWidth;
function isBrowserSafari() {
  if (isSafari === void 0) {
    isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
  }
  return isSafari;
}
function getSafariVersion() {
  if (safariVersion === void 0) {
    if (isBrowserSafari()) {
      const versionMatch = navigator.userAgent.match(/version\/(\d+)/i);
      if (versionMatch) {
        safariVersion = versionMatch[1] != null ? parseFloat(versionMatch[1]) : 0;
      }
    } else {
      safariVersion = 0;
    }
  }
  return safariVersion;
}
function isBrowserChrome() {
  if (isChrome === void 0) {
    const win = window;
    isChrome = !!win.chrome && (!!win.chrome.webstore || !!win.chrome.runtime) || /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
  }
  return isChrome;
}
function isBrowserFirefox() {
  if (isFirefox === void 0) {
    isFirefox = /(firefox)/i.test(navigator.userAgent);
  }
  return isFirefox;
}
function isMacOsUserAgent() {
  if (isMacOs === void 0) {
    isMacOs = /(Mac|iPhone|iPod|iPad)/i.test(navigator.platform);
  }
  return isMacOs;
}
function isIOSUserAgent() {
  if (isIOS === void 0) {
    isIOS = /iPad|iPhone|iPod/.test(navigator.platform) || // eslint-disable-next-line
    navigator.platform === "MacIntel" && navigator.maxTouchPoints > 1;
  }
  return isIOS;
}
function browserSupportsPreventScroll() {
  return !isBrowserSafari() || getSafariVersion() >= 15;
}
function getTabIndex(el) {
  if (!el) {
    return null;
  }
  const numberTabIndex = el.tabIndex;
  const tabIndex = el.getAttribute("tabIndex");
  if (numberTabIndex === -1 && (tabIndex === null || tabIndex === "" && !isBrowserFirefox())) {
    return null;
  }
  return numberTabIndex.toString();
}
function getMaxDivHeight() {
  if (!document.body) {
    return -1;
  }
  let res = 1e6;
  const testUpTo = navigator.userAgent.toLowerCase().match(/firefox/) ? 6e6 : 1e9;
  const div = document.createElement("div");
  document.body.appendChild(div);
  while (true) {
    const test = res * 2;
    div.style.height = test + "px";
    if (test > testUpTo || div.clientHeight !== test) {
      break;
    } else {
      res = test;
    }
  }
  document.body.removeChild(div);
  return res;
}
function getBodyWidth() {
  var _a, _b, _c;
  return (_c = (_a = document.body) == null ? void 0 : _a.clientWidth) != null ? _c : window.innerHeight || ((_b = document.documentElement) == null ? void 0 : _b.clientWidth) || -1;
}
function getBodyHeight() {
  var _a, _b, _c;
  return (_c = (_a = document.body) == null ? void 0 : _a.clientHeight) != null ? _c : window.innerHeight || ((_b = document.documentElement) == null ? void 0 : _b.clientHeight) || -1;
}
function getScrollbarWidth() {
  if (browserScrollbarWidth == null) {
    initScrollbarWidthAndVisibility();
  }
  return browserScrollbarWidth;
}
function initScrollbarWidthAndVisibility() {
  const body = document.body;
  const div = document.createElement("div");
  div.style.width = div.style.height = "100px";
  div.style.opacity = "0";
  div.style.overflow = "scroll";
  div.style.msOverflowStyle = "scrollbar";
  div.style.position = "absolute";
  body.appendChild(div);
  let width = div.offsetWidth - div.clientWidth;
  if (width === 0 && div.clientWidth === 0) {
    width = null;
  }
  if (div.parentNode) {
    div.parentNode.removeChild(div);
  }
  if (width != null) {
    browserScrollbarWidth = width;
    invisibleScrollbar = width === 0;
  }
}
function isInvisibleScrollbar() {
  if (invisibleScrollbar == null) {
    initScrollbarWidthAndVisibility();
  }
  return invisibleScrollbar;
}

// community-modules/core/src/utils/date.ts
var date_exports = {};
__export(date_exports, {
  dateToFormattedString: () => dateToFormattedString,
  parseDateTimeFromString: () => parseDateTimeFromString,
  serialiseDate: () => serialiseDate
});

// community-modules/core/src/utils/number.ts
var number_exports = {};
__export(number_exports, {
  cleanNumber: () => cleanNumber,
  createArrayOfNumbers: () => createArrayOfNumbers,
  decToHex: () => decToHex,
  formatNumberCommas: () => formatNumberCommas,
  formatNumberTwoDecimalPlacesAndCommas: () => formatNumberTwoDecimalPlacesAndCommas,
  padStartWidthZeros: () => padStartWidthZeros,
  sum: () => sum
});
function padStartWidthZeros(value, totalStringSize) {
  return value.toString().padStart(totalStringSize, "0");
}
function createArrayOfNumbers(first, last2) {
  const result = [];
  for (let i = first; i <= last2; i++) {
    result.push(i);
  }
  return result;
}
function cleanNumber(value) {
  if (typeof value === "string") {
    value = parseInt(value, 10);
  }
  if (typeof value === "number") {
    return Math.floor(value);
  }
  return null;
}
function decToHex(number, bytes) {
  let hex = "";
  for (let i = 0; i < bytes; i++) {
    hex += String.fromCharCode(number & 255);
    number >>>= 8;
  }
  return hex;
}
function formatNumberTwoDecimalPlacesAndCommas(value, thousandSeparator, decimalSeparator) {
  if (typeof value !== "number") {
    return "";
  }
  return formatNumberCommas(Math.round(value * 100) / 100, thousandSeparator, decimalSeparator);
}
function formatNumberCommas(value, thousandSeparator, decimalSeparator) {
  if (typeof value !== "number") {
    return "";
  }
  return value.toString().replace(".", decimalSeparator).replace(/(\d)(?=(\d{3})+(?!\d))/g, `$1${thousandSeparator}`);
}
function sum(values2) {
  return values2 == null ? null : values2.reduce((total, value) => total + value, 0);
}

// community-modules/core/src/utils/date.ts
function serialiseDate(date, includeTime = true, separator = "-") {
  if (!date) {
    return null;
  }
  let serialised = [date.getFullYear(), date.getMonth() + 1, date.getDate()].map((part) => padStartWidthZeros(part, 2)).join(separator);
  if (includeTime) {
    serialised += " " + [date.getHours(), date.getMinutes(), date.getSeconds()].map((part) => padStartWidthZeros(part, 2)).join(":");
  }
  return serialised;
}
var calculateOrdinal = (value) => {
  if (value > 3 && value < 21) {
    return "th";
  }
  const remainder = value % 10;
  switch (remainder) {
    case 1:
      return "st";
    case 2:
      return "nd";
    case 3:
      return "rd";
  }
  return "th";
};
function dateToFormattedString(date, format = "YYYY-MM-DD") {
  const fullYear = padStartWidthZeros(date.getFullYear(), 4);
  const months = [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December"
  ];
  const days = [
    "Sunday",
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday"
  ];
  const replace = {
    YYYY: () => fullYear.slice(fullYear.length - 4, fullYear.length),
    YY: () => fullYear.slice(fullYear.length - 2, fullYear.length),
    Y: () => `${date.getFullYear()}`,
    MMMM: () => months[date.getMonth()],
    MMM: () => months[date.getMonth()].slice(0, 3),
    MM: () => padStartWidthZeros(date.getMonth() + 1, 2),
    Mo: () => `${date.getMonth() + 1}${calculateOrdinal(date.getMonth() + 1)}`,
    M: () => `${date.getMonth() + 1}`,
    Do: () => `${date.getDate()}${calculateOrdinal(date.getDate())}`,
    DD: () => padStartWidthZeros(date.getDate(), 2),
    D: () => `${date.getDate()}`,
    dddd: () => days[date.getDay()],
    ddd: () => days[date.getDay()].slice(0, 3),
    dd: () => days[date.getDay()].slice(0, 2),
    do: () => `${date.getDay()}${calculateOrdinal(date.getDay())}`,
    d: () => `${date.getDay()}`
  };
  const regexp = new RegExp(Object.keys(replace).join("|"), "g");
  return format.replace(regexp, (match) => {
    if (match in replace) {
      return replace[match]();
    }
    return match;
  });
}
function parseDateTimeFromString(value) {
  if (!value) {
    return null;
  }
  const [dateStr, timeStr] = value.split(" ");
  if (!dateStr) {
    return null;
  }
  const fields = dateStr.split("-").map((f) => parseInt(f, 10));
  if (fields.filter((f) => !isNaN(f)).length !== 3) {
    return null;
  }
  const [year, month, day] = fields;
  const date = new Date(year, month - 1, day);
  if (date.getFullYear() !== year || date.getMonth() !== month - 1 || date.getDate() !== day) {
    return null;
  }
  if (!timeStr || timeStr === "00:00:00") {
    return date;
  }
  const [hours, minutes, seconds] = timeStr.split(":").map((part) => parseInt(part, 10));
  if (hours >= 0 && hours < 24) {
    date.setHours(hours);
  }
  if (minutes >= 0 && minutes < 60) {
    date.setMinutes(minutes);
  }
  if (seconds >= 0 && seconds < 60) {
    date.setSeconds(seconds);
  }
  return date;
}

// community-modules/core/src/utils/dom.ts
var dom_exports = {};
__export(dom_exports, {
  FOCUSABLE_EXCLUDE: () => FOCUSABLE_EXCLUDE,
  FOCUSABLE_SELECTOR: () => FOCUSABLE_SELECTOR,
  addOrRemoveAttribute: () => addOrRemoveAttribute,
  addStylesToElement: () => addStylesToElement,
  bindCellRendererToHtmlElement: () => bindCellRendererToHtmlElement,
  clearElement: () => clearElement,
  copyNodeList: () => copyNodeList,
  ensureDomOrder: () => ensureDomOrder,
  formatSize: () => formatSize,
  getAbsoluteHeight: () => getAbsoluteHeight,
  getAbsoluteWidth: () => getAbsoluteWidth,
  getElementRectWithOffset: () => getElementRectWithOffset,
  getElementSize: () => getElementSize,
  getInnerHeight: () => getInnerHeight,
  getInnerWidth: () => getInnerWidth,
  getScrollLeft: () => getScrollLeft,
  insertWithDomOrder: () => insertWithDomOrder,
  isElementChildOfClass: () => isElementChildOfClass,
  isFocusableFormField: () => isFocusableFormField,
  isHorizontalScrollShowing: () => isHorizontalScrollShowing,
  isInDOM: () => isInDOM,
  isNodeOrElement: () => isNodeOrElement,
  isRtlNegativeScroll: () => isRtlNegativeScroll,
  isVerticalScrollShowing: () => isVerticalScrollShowing,
  isVisible: () => isVisible,
  iterateNamedNodeMap: () => iterateNamedNodeMap,
  loadTemplate: () => loadTemplate,
  nodeListForEach: () => nodeListForEach,
  radioCssClass: () => radioCssClass,
  removeFromParent: () => removeFromParent,
  setDisabled: () => setDisabled,
  setDisplayed: () => setDisplayed,
  setDomChildOrder: () => setDomChildOrder,
  setElementHeight: () => setElementHeight,
  setElementWidth: () => setElementWidth,
  setFixedHeight: () => setFixedHeight,
  setFixedWidth: () => setFixedWidth,
  setScrollLeft: () => setScrollLeft,
  setVisible: () => setVisible
});
var rtlNegativeScroll;
function radioCssClass(element, elementClass, otherElementClass) {
  const parent = element.parentElement;
  let sibling = parent && parent.firstChild;
  while (sibling) {
    if (elementClass) {
      sibling.classList.toggle(elementClass, sibling === element);
    }
    if (otherElementClass) {
      sibling.classList.toggle(otherElementClass, sibling !== element);
    }
    sibling = sibling.nextSibling;
  }
}
var FOCUSABLE_SELECTOR = "[tabindex], input, select, button, textarea, [href]";
var FOCUSABLE_EXCLUDE = "[disabled], .ag-disabled:not(.ag-button), .ag-disabled *";
function isFocusableFormField(element) {
  const matches = Element.prototype.matches || Element.prototype.msMatchesSelector;
  const inputSelector = "input, select, button, textarea";
  const isFocusable = matches.call(element, inputSelector);
  const isNotFocusable = matches.call(element, FOCUSABLE_EXCLUDE);
  const isElementVisible = isVisible(element);
  const focusable = isFocusable && !isNotFocusable && isElementVisible;
  return focusable;
}
function setDisplayed(element, displayed, options = {}) {
  const { skipAriaHidden } = options;
  element.classList.toggle("ag-hidden", !displayed);
  if (!skipAriaHidden) {
    setAriaHidden(element, !displayed);
  }
}
function setVisible(element, visible, options = {}) {
  const { skipAriaHidden } = options;
  element.classList.toggle("ag-invisible", !visible);
  if (!skipAriaHidden) {
    setAriaHidden(element, !visible);
  }
}
function setDisabled(element, disabled) {
  const attributeName = "disabled";
  const addOrRemoveDisabledAttribute = disabled ? (e) => e.setAttribute(attributeName, "") : (e) => e.removeAttribute(attributeName);
  addOrRemoveDisabledAttribute(element);
  nodeListForEach(element.querySelectorAll("input"), (input) => addOrRemoveDisabledAttribute(input));
}
function isElementChildOfClass(element, cls, maxNest) {
  let counter = 0;
  while (element) {
    if (element.classList.contains(cls)) {
      return true;
    }
    element = element.parentElement;
    if (typeof maxNest == "number") {
      if (++counter > maxNest) {
        break;
      }
    } else if (element === maxNest) {
      break;
    }
  }
  return false;
}
function getElementSize(el) {
  const {
    height,
    width,
    borderTopWidth,
    borderRightWidth,
    borderBottomWidth,
    borderLeftWidth,
    paddingTop,
    paddingRight,
    paddingBottom,
    paddingLeft,
    marginTop,
    marginRight,
    marginBottom,
    marginLeft,
    boxSizing
  } = window.getComputedStyle(el);
  return {
    height: parseFloat(height || "0"),
    width: parseFloat(width || "0"),
    borderTopWidth: parseFloat(borderTopWidth || "0"),
    borderRightWidth: parseFloat(borderRightWidth || "0"),
    borderBottomWidth: parseFloat(borderBottomWidth || "0"),
    borderLeftWidth: parseFloat(borderLeftWidth || "0"),
    paddingTop: parseFloat(paddingTop || "0"),
    paddingRight: parseFloat(paddingRight || "0"),
    paddingBottom: parseFloat(paddingBottom || "0"),
    paddingLeft: parseFloat(paddingLeft || "0"),
    marginTop: parseFloat(marginTop || "0"),
    marginRight: parseFloat(marginRight || "0"),
    marginBottom: parseFloat(marginBottom || "0"),
    marginLeft: parseFloat(marginLeft || "0"),
    boxSizing
  };
}
function getInnerHeight(el) {
  const size = getElementSize(el);
  if (size.boxSizing === "border-box") {
    return size.height - size.paddingTop - size.paddingBottom;
  }
  return size.height;
}
function getInnerWidth(el) {
  const size = getElementSize(el);
  if (size.boxSizing === "border-box") {
    return size.width - size.paddingLeft - size.paddingRight;
  }
  return size.width;
}
function getAbsoluteHeight(el) {
  const size = getElementSize(el);
  const marginRight = size.marginBottom + size.marginTop;
  return Math.ceil(el.offsetHeight + marginRight);
}
function getAbsoluteWidth(el) {
  const size = getElementSize(el);
  const marginWidth = size.marginLeft + size.marginRight;
  return Math.ceil(el.offsetWidth + marginWidth);
}
function getElementRectWithOffset(el) {
  const offsetElementRect = el.getBoundingClientRect();
  const { borderTopWidth, borderLeftWidth, borderRightWidth, borderBottomWidth } = getElementSize(el);
  return {
    top: offsetElementRect.top + (borderTopWidth || 0),
    left: offsetElementRect.left + (borderLeftWidth || 0),
    right: offsetElementRect.right + (borderRightWidth || 0),
    bottom: offsetElementRect.bottom + (borderBottomWidth || 0)
  };
}
function isRtlNegativeScroll() {
  if (typeof rtlNegativeScroll === "boolean") {
    return rtlNegativeScroll;
  }
  const template = document.createElement("div");
  template.style.direction = "rtl";
  template.style.width = "1px";
  template.style.height = "1px";
  template.style.position = "fixed";
  template.style.top = "0px";
  template.style.overflow = "hidden";
  template.dir = "rtl";
  template.innerHTML = /* html */
  `<div style="width: 2px">
            <span style="display: inline-block; width: 1px"></span>
            <span style="display: inline-block; width: 1px"></span>
        </div>`;
  document.body.appendChild(template);
  template.scrollLeft = 1;
  rtlNegativeScroll = Math.floor(template.scrollLeft) === 0;
  document.body.removeChild(template);
  return rtlNegativeScroll;
}
function getScrollLeft(element, rtl) {
  let scrollLeft = element.scrollLeft;
  if (rtl) {
    scrollLeft = Math.abs(scrollLeft);
    if (isBrowserChrome() && !isRtlNegativeScroll()) {
      scrollLeft = element.scrollWidth - element.clientWidth - scrollLeft;
    }
  }
  return scrollLeft;
}
function setScrollLeft(element, value, rtl) {
  if (rtl) {
    if (isRtlNegativeScroll()) {
      value *= -1;
    } else if (isBrowserSafari() || isBrowserChrome()) {
      value = element.scrollWidth - element.clientWidth - value;
    }
  }
  element.scrollLeft = value;
}
function clearElement(el) {
  while (el && el.firstChild) {
    el.removeChild(el.firstChild);
  }
}
function removeFromParent(node) {
  if (node && node.parentNode) {
    node.parentNode.removeChild(node);
  }
}
function isInDOM(element) {
  return !!element.offsetParent;
}
function isVisible(element) {
  const el = element;
  if (el.checkVisibility) {
    return el.checkVisibility({ checkVisibilityCSS: true });
  }
  const isHidden = !isInDOM(element) || window.getComputedStyle(element).visibility !== "visible";
  return !isHidden;
}
function loadTemplate(template) {
  const tempDiv = document.createElement("div");
  tempDiv.innerHTML = (template || "").trim();
  return tempDiv.firstChild;
}
function ensureDomOrder(eContainer, eChild, eChildBefore) {
  if (eChildBefore && eChildBefore.nextSibling === eChild) {
    return;
  }
  if (eChildBefore) {
    if (eChildBefore.nextSibling) {
      eContainer.insertBefore(eChild, eChildBefore.nextSibling);
    } else {
      eContainer.appendChild(eChild);
    }
  } else {
    if (eContainer.firstChild && eContainer.firstChild !== eChild) {
      eContainer.insertAdjacentElement("afterbegin", eChild);
    }
  }
}
function setDomChildOrder(eContainer, orderedChildren) {
  for (let i = 0; i < orderedChildren.length; i++) {
    const correctCellAtIndex = orderedChildren[i];
    const actualCellAtIndex = eContainer.children[i];
    if (actualCellAtIndex !== correctCellAtIndex) {
      eContainer.insertBefore(correctCellAtIndex, actualCellAtIndex);
    }
  }
}
function insertWithDomOrder(eContainer, eToInsert, eChildBefore) {
  if (eChildBefore) {
    eChildBefore.insertAdjacentElement("afterend", eToInsert);
  } else {
    if (eContainer.firstChild) {
      eContainer.insertAdjacentElement("afterbegin", eToInsert);
    } else {
      eContainer.appendChild(eToInsert);
    }
  }
}
function addStylesToElement(eElement, styles) {
  if (!styles) {
    return;
  }
  for (const [key, value] of Object.entries(styles)) {
    if (!key || !key.length || value == null) {
      continue;
    }
    const parsedKey = camelCaseToHyphenated(key);
    const valueAsString = value.toString();
    const parsedValue = valueAsString.replace(/\s*!important/g, "");
    const priority = parsedValue.length != valueAsString.length ? "important" : void 0;
    eElement.style.setProperty(parsedKey, parsedValue, priority);
  }
}
function isHorizontalScrollShowing(element) {
  return element.clientWidth < element.scrollWidth;
}
function isVerticalScrollShowing(element) {
  return element.clientHeight < element.scrollHeight;
}
function setElementWidth(element, width) {
  if (width === "flex") {
    element.style.removeProperty("width");
    element.style.removeProperty("minWidth");
    element.style.removeProperty("maxWidth");
    element.style.flex = "1 1 auto";
  } else {
    setFixedWidth(element, width);
  }
}
function setFixedWidth(element, width) {
  width = formatSize(width);
  element.style.width = width.toString();
  element.style.maxWidth = width.toString();
  element.style.minWidth = width.toString();
}
function setElementHeight(element, height) {
  if (height === "flex") {
    element.style.removeProperty("height");
    element.style.removeProperty("minHeight");
    element.style.removeProperty("maxHeight");
    element.style.flex = "1 1 auto";
  } else {
    setFixedHeight(element, height);
  }
}
function setFixedHeight(element, height) {
  height = formatSize(height);
  element.style.height = height.toString();
  element.style.maxHeight = height.toString();
  element.style.minHeight = height.toString();
}
function formatSize(size) {
  if (typeof size === "number") {
    return `${size}px`;
  }
  return size;
}
function isNodeOrElement(o) {
  return o instanceof Node || o instanceof HTMLElement;
}
function copyNodeList(nodeList) {
  if (nodeList == null) {
    return [];
  }
  const result = [];
  nodeListForEach(nodeList, (node) => result.push(node));
  return result;
}
function iterateNamedNodeMap(map, callback) {
  if (!map) {
    return;
  }
  for (let i = 0; i < map.length; i++) {
    const attr = map[i];
    callback(attr.name, attr.value);
  }
}
function addOrRemoveAttribute(element, name, value) {
  if (value == null) {
    element.removeAttribute(name);
  } else {
    element.setAttribute(name, value.toString());
  }
}
function nodeListForEach(nodeList, action) {
  if (nodeList == null) {
    return;
  }
  for (let i = 0; i < nodeList.length; i++) {
    action(nodeList[i]);
  }
}
function bindCellRendererToHtmlElement(cellRendererPromise, eTarget) {
  cellRendererPromise.then((cellRenderer) => {
    const gui = cellRenderer.getGui();
    if (gui != null) {
      if (typeof gui === "object") {
        eTarget.appendChild(gui);
      } else {
        eTarget.innerHTML = gui;
      }
    }
  });
}

// community-modules/core/src/utils/fuzzyMatch.ts
var fuzzyMatch_exports = {};
__export(fuzzyMatch_exports, {
  fuzzyCheckStrings: () => fuzzyCheckStrings,
  fuzzySuggestions: () => fuzzySuggestions
});
function fuzzyCheckStrings(inputValues, validValues, allSuggestions) {
  const fuzzyMatches = {};
  const invalidInputs = inputValues.filter(
    (inputValue) => !validValues.some(
      (validValue) => validValue === inputValue
    )
  );
  if (invalidInputs.length > 0) {
    invalidInputs.forEach(
      (invalidInput) => fuzzyMatches[invalidInput] = fuzzySuggestions(invalidInput, allSuggestions).values
    );
  }
  return fuzzyMatches;
}
function fuzzySuggestions(inputValue, allSuggestions, hideIrrelevant, filterByPercentageOfBestMatch) {
  let thisSuggestions = allSuggestions.map((text, idx) => ({
    value: text,
    relevance: stringWeightedDistances(inputValue.toLowerCase(), text.toLocaleLowerCase()),
    idx
  }));
  thisSuggestions.sort((a, b) => b.relevance - a.relevance);
  if (hideIrrelevant) {
    thisSuggestions = thisSuggestions.filter((suggestion) => suggestion.relevance !== 0);
  }
  if (thisSuggestions.length > 0 && filterByPercentageOfBestMatch && filterByPercentageOfBestMatch > 0) {
    const bestMatch = thisSuggestions[0].relevance;
    const limit = bestMatch * filterByPercentageOfBestMatch;
    thisSuggestions = thisSuggestions.filter((suggestion) => limit - suggestion.relevance < 0);
  }
  const values2 = [];
  const indices = [];
  for (const suggestion of thisSuggestions) {
    values2.push(suggestion.value);
    indices.push(suggestion.idx);
  }
  return { values: values2, indices };
}
function stringWeightedDistances(str1, str2) {
  const a = str1.replace(/\s/g, "");
  const b = str2.replace(/\s/g, "");
  let weight = 0;
  let lastIndex = -1;
  for (let i = 0; i < a.length; i++) {
    const idx = b.indexOf(a[i], lastIndex + 1);
    if (idx === -1) {
      continue;
    }
    lastIndex = idx;
    weight += 100 - lastIndex * 100 / 1e4 * 100;
  }
  return weight;
}

// community-modules/core/src/utils/icon.ts
var icon_exports = {};
__export(icon_exports, {
  createIcon: () => createIcon,
  createIconNoSpan: () => createIconNoSpan,
  iconNameClassMap: () => iconNameClassMap
});
var iconNameClassMap = {
  // header column group shown when expanded (click to contract)
  columnGroupOpened: "expanded",
  // header column group shown when contracted (click to expand)
  columnGroupClosed: "contracted",
  // tool panel column group contracted (click to expand)
  columnSelectClosed: "tree-closed",
  // tool panel column group expanded (click to contract)
  columnSelectOpen: "tree-open",
  // column tool panel header expand/collapse all button, shown when some children are expanded and
  //     others are collapsed
  columnSelectIndeterminate: "tree-indeterminate",
  // shown on ghost icon while dragging column to the side of the grid to pin
  columnMovePin: "pin",
  // shown on ghost icon while dragging over part of the page that is not a drop zone
  columnMoveHide: "eye-slash",
  // shown on ghost icon while dragging columns to reorder
  columnMoveMove: "arrows",
  // animating icon shown when dragging a column to the right of the grid causes horizontal scrolling
  columnMoveLeft: "left",
  // animating icon shown when dragging a column to the left of the grid causes horizontal scrolling
  columnMoveRight: "right",
  // shown on ghost icon while dragging over Row Groups drop zone
  columnMoveGroup: "group",
  // shown on ghost icon while dragging over Values drop zone
  columnMoveValue: "aggregation",
  // shown on ghost icon while dragging over pivot drop zone
  columnMovePivot: "pivot",
  // shown on ghost icon while dragging over drop zone that doesn't support it, e.g.
  //     string column over aggregation drop zone
  dropNotAllowed: "not-allowed",
  // shown on row group when contracted (click to expand)
  groupContracted: "tree-closed",
  // shown on row group when expanded (click to contract)
  groupExpanded: "tree-open",
  // set filter tree list group contracted (click to expand)
  setFilterGroupClosed: "tree-closed",
  // set filter tree list group expanded (click to contract)
  setFilterGroupOpen: "tree-open",
  // set filter tree list expand/collapse all button, shown when some children are expanded and
  //     others are collapsed
  setFilterGroupIndeterminate: "tree-indeterminate",
  // context menu chart item
  chart: "chart",
  // chart window title bar
  close: "cross",
  // X (remove) on column 'pill' after adding it to a drop zone list
  cancel: "cancel",
  // indicates the currently active pin state in the "Pin column" sub-menu of the column menu
  check: "tick",
  // "go to first" button in pagination controls
  first: "first",
  // "go to previous" button in pagination controls
  previous: "previous",
  // "go to next" button in pagination controls
  next: "next",
  // "go to last" button in pagination controls
  last: "last",
  // shown on top right of chart when chart is linked to range data (click to unlink)
  linked: "linked",
  // shown on top right of chart when chart is not linked to range data (click to link)
  unlinked: "unlinked",
  // "Choose colour" button on chart settings tab
  colorPicker: "color-picker",
  // rotating spinner shown by the loading cell renderer
  groupLoading: "loading",
  // button to launch enterprise column menu
  menu: "menu",
  menuAlt: "menu-alt",
  // filter tool panel tab
  filter: "filter",
  // column tool panel tab
  columns: "columns",
  // button in chart regular size window title bar (click to maximise)
  maximize: "maximize",
  // button in chart maximised window title bar (click to make regular size)
  minimize: "minimize",
  // "Pin column" item in column header menu
  menuPin: "pin",
  // "Value aggregation" column menu item (shown on numeric columns when grouping is active)"
  menuValue: "aggregation",
  // "Group by {column-name}" item in column header menu
  menuAddRowGroup: "group",
  // "Un-Group by {column-name}" item in column header menu
  menuRemoveRowGroup: "group",
  // context menu copy item
  clipboardCopy: "copy",
  // context menu cut item
  clipboardCut: "cut",
  // context menu paste item
  clipboardPaste: "paste",
  // identifies the pivot drop zone
  pivotPanel: "pivot",
  // "Row groups" drop zone in column tool panel
  rowGroupPanel: "group",
  // columns tool panel Values drop zone
  valuePanel: "aggregation",
  // drag handle used to pick up draggable columns
  columnDrag: "grip",
  // drag handle used to pick up draggable rows
  rowDrag: "grip",
  // context menu export item
  save: "save",
  // csv export
  csvExport: "csv",
  // excel export,
  excelExport: "excel",
  // icon on dropdown editors
  smallDown: "small-down",
  // version of small-right used in RTL mode
  smallLeft: "small-left",
  // separater between column 'pills' when you add multiple columns to the header drop zone
  smallRight: "small-right",
  smallUp: "small-up",
  // show on column header when column is sorted ascending
  sortAscending: "asc",
  // show on column header when column is sorted descending
  sortDescending: "desc",
  // show on column header when column has no sort, only when enabled with gridOptions.unSortIcon=true
  sortUnSort: "none",
  // Builder button in Advanced Filter
  advancedFilterBuilder: "group",
  // drag handle used to pick up Advanced Filter Builder rows
  advancedFilterBuilderDrag: "grip",
  // Advanced Filter Builder row validation error
  advancedFilterBuilderInvalid: "not-allowed",
  // shown on Advanced Filter Builder rows to move them up
  advancedFilterBuilderMoveUp: "up",
  // shown on Advanced Filter Builder rows to move them down
  advancedFilterBuilderMoveDown: "down",
  // shown on Advanced Filter Builder rows to add new rows
  advancedFilterBuilderAdd: "plus",
  // shown on Advanced Filter Builder rows to remove row
  advancedFilterBuilderRemove: "minus",
  // Edit Chart menu item shown in Integrated Charts menu
  chartsMenuEdit: "chart",
  // Advanced Settings menu item shown in Integrated Charts menu
  chartsMenuAdvancedSettings: "settings",
  // shown in Integrated Charts menu add fields
  chartsMenuAdd: "plus"
};
function createIcon(iconName, gridOptionsService, column) {
  const iconContents = createIconNoSpan(iconName, gridOptionsService, column);
  if (iconContents) {
    const { className } = iconContents;
    if (typeof className === "string" && className.indexOf("ag-icon") > -1 || typeof className === "object" && className["ag-icon"]) {
      return iconContents;
    }
  }
  const eResult = document.createElement("span");
  eResult.appendChild(iconContents);
  return eResult;
}
function createIconNoSpan(iconName, gridOptionsService, column, forceCreate) {
  let userProvidedIcon = null;
  const icons = column && column.getColDef().icons;
  if (icons) {
    userProvidedIcon = icons[iconName];
  }
  if (gridOptionsService && !userProvidedIcon) {
    const optionsIcons = gridOptionsService.get("icons");
    if (optionsIcons) {
      userProvidedIcon = optionsIcons[iconName];
    }
  }
  if (userProvidedIcon) {
    let rendererResult;
    if (typeof userProvidedIcon === "function") {
      rendererResult = userProvidedIcon();
    } else if (typeof userProvidedIcon === "string") {
      rendererResult = userProvidedIcon;
    } else {
      throw new Error("icon from grid options needs to be a string or a function");
    }
    if (typeof rendererResult === "string") {
      return loadTemplate(rendererResult);
    }
    if (isNodeOrElement(rendererResult)) {
      return rendererResult;
    }
    console.warn("AG Grid: iconRenderer should return back a string or a dom object");
  } else {
    const span = document.createElement("span");
    let cssClass = iconNameClassMap[iconName];
    if (!cssClass) {
      if (!forceCreate) {
        console.warn(`AG Grid: Did not find icon ${iconName}`);
        cssClass = "";
      } else {
        cssClass = iconName;
      }
    }
    span.setAttribute("class", `ag-icon ag-icon-${cssClass}`);
    span.setAttribute("unselectable", "on");
    setAriaRole(span, "presentation");
    return span;
  }
}

// community-modules/core/src/utils/keyboard.ts
var keyboard_exports = {};
__export(keyboard_exports, {
  isDeleteKey: () => isDeleteKey,
  isEventFromPrintableCharacter: () => isEventFromPrintableCharacter,
  isUserSuppressingHeaderKeyboardEvent: () => isUserSuppressingHeaderKeyboardEvent,
  isUserSuppressingKeyboardEvent: () => isUserSuppressingKeyboardEvent,
  normaliseQwertyAzerty: () => normaliseQwertyAzerty
});

// community-modules/core/src/constants/keyCode.ts
var KeyCode = class {
};
KeyCode.BACKSPACE = "Backspace";
KeyCode.TAB = "Tab";
KeyCode.ENTER = "Enter";
KeyCode.ESCAPE = "Escape";
KeyCode.SPACE = " ";
KeyCode.LEFT = "ArrowLeft";
KeyCode.UP = "ArrowUp";
KeyCode.RIGHT = "ArrowRight";
KeyCode.DOWN = "ArrowDown";
KeyCode.DELETE = "Delete";
KeyCode.F2 = "F2";
KeyCode.PAGE_UP = "PageUp";
KeyCode.PAGE_DOWN = "PageDown";
KeyCode.PAGE_HOME = "Home";
KeyCode.PAGE_END = "End";
// these should be used with `event.code` instead of `event.key`
// as `event.key` changes when non-latin keyboards are used
KeyCode.A = "KeyA";
KeyCode.C = "KeyC";
KeyCode.D = "KeyD";
KeyCode.V = "KeyV";
KeyCode.X = "KeyX";
KeyCode.Y = "KeyY";
KeyCode.Z = "KeyZ";

// community-modules/core/src/utils/keyboard.ts
var A_KEYCODE = 65;
var C_KEYCODE = 67;
var V_KEYCODE = 86;
var D_KEYCODE = 68;
var Z_KEYCODE = 90;
var Y_KEYCODE = 89;
function isEventFromPrintableCharacter(event) {
  if (event.altKey || event.ctrlKey || event.metaKey) {
    return false;
  }
  const printableCharacter = event.key.length === 1;
  return printableCharacter;
}
function isUserSuppressingKeyboardEvent(gridOptionsService, keyboardEvent, rowNode, column, editing) {
  const colDefFunc = column ? column.getColDef().suppressKeyboardEvent : void 0;
  if (!colDefFunc) {
    return false;
  }
  const params = gridOptionsService.addGridCommonParams({
    event: keyboardEvent,
    editing,
    column,
    node: rowNode,
    data: rowNode.data,
    colDef: column.getColDef()
  });
  if (colDefFunc) {
    const colDefFuncResult = colDefFunc(params);
    if (colDefFuncResult) {
      return true;
    }
  }
  return false;
}
function isUserSuppressingHeaderKeyboardEvent(gridOptionsService, keyboardEvent, headerRowIndex, column) {
  const colDef = column.getDefinition();
  const colDefFunc = colDef && colDef.suppressHeaderKeyboardEvent;
  if (!exists(colDefFunc)) {
    return false;
  }
  const params = gridOptionsService.addGridCommonParams({
    colDef,
    column,
    headerRowIndex,
    event: keyboardEvent
  });
  return !!colDefFunc(params);
}
function normaliseQwertyAzerty(keyboardEvent) {
  const { keyCode } = keyboardEvent;
  let code;
  switch (keyCode) {
    case A_KEYCODE:
      code = KeyCode.A;
      break;
    case C_KEYCODE:
      code = KeyCode.C;
      break;
    case V_KEYCODE:
      code = KeyCode.V;
      break;
    case D_KEYCODE:
      code = KeyCode.D;
      break;
    case Z_KEYCODE:
      code = KeyCode.Z;
      break;
    case Y_KEYCODE:
      code = KeyCode.Y;
      break;
    default:
      code = keyboardEvent.code;
  }
  return code;
}
function isDeleteKey(key, alwaysReturnFalseOnBackspace = false) {
  if (key === KeyCode.DELETE) {
    return true;
  }
  if (!alwaysReturnFalseOnBackspace && key === KeyCode.BACKSPACE) {
    return isMacOsUserAgent();
  }
  return false;
}

// community-modules/core/src/utils/mouse.ts
var mouse_exports = {};
__export(mouse_exports, {
  areEventsNear: () => areEventsNear
});
function areEventsNear(e1, e2, pixelCount) {
  if (pixelCount === 0) {
    return false;
  }
  const diffX = Math.abs(e1.clientX - e2.clientX);
  const diffY = Math.abs(e1.clientY - e2.clientY);
  return Math.max(diffX, diffY) <= pixelCount;
}

// community-modules/core/src/utils/rowNode.ts
var rowNode_exports = {};
__export(rowNode_exports, {
  sortRowNodesByOrder: () => sortRowNodesByOrder
});
function sortRowNodesByOrder(rowNodes, rowNodeOrder) {
  if (!rowNodes) {
    return false;
  }
  const comparator = (nodeA, nodeB) => {
    const positionA = rowNodeOrder[nodeA.id];
    const positionB = rowNodeOrder[nodeB.id];
    const aHasIndex = positionA !== void 0;
    const bHasIndex = positionB !== void 0;
    const bothNodesAreUserNodes = aHasIndex && bHasIndex;
    const bothNodesAreFillerNodes = !aHasIndex && !bHasIndex;
    if (bothNodesAreUserNodes) {
      return positionA - positionB;
    }
    if (bothNodesAreFillerNodes) {
      return nodeA.__objectId - nodeB.__objectId;
    }
    if (aHasIndex) {
      return 1;
    }
    return -1;
  };
  let rowNodeA;
  let rowNodeB;
  let atLeastOneOutOfOrder = false;
  for (let i = 0; i < rowNodes.length - 1; i++) {
    rowNodeA = rowNodes[i];
    rowNodeB = rowNodes[i + 1];
    if (comparator(rowNodeA, rowNodeB) > 0) {
      atLeastOneOutOfOrder = true;
      break;
    }
  }
  if (atLeastOneOutOfOrder) {
    rowNodes.sort(comparator);
    return true;
  }
  return false;
}

// community-modules/core/src/utils/set.ts
var set_exports = {};
__export(set_exports, {
  convertToSet: () => convertToSet
});
function convertToSet(list) {
  const set = /* @__PURE__ */ new Set();
  list.forEach((x) => set.add(x));
  return set;
}

// community-modules/core/src/utils/utils.ts
var utils = __spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues({}, aria_exports), array_exports), browser_exports), date_exports), dom_exports), event_exports), function_exports), fuzzyMatch_exports), generic_exports), icon_exports), keyboard_exports), map_exports), mouse_exports), number_exports), object_exports), rowNode_exports), set_exports), string_exports);
var _ = utils;

// community-modules/core/src/utils/numberSequence.ts
var NumberSequence = class {
  constructor(initValue = 0, step = 1) {
    this.nextValue = initValue;
    this.step = step;
  }
  next() {
    const valToReturn = this.nextValue;
    this.nextValue += this.step;
    return valToReturn;
  }
  peek() {
    return this.nextValue;
  }
  skip(count) {
    this.nextValue += count;
  }
};

// community-modules/core/src/utils/promise.ts
var AgPromiseStatus = /* @__PURE__ */ ((AgPromiseStatus2) => {
  AgPromiseStatus2[AgPromiseStatus2["IN_PROGRESS"] = 0] = "IN_PROGRESS";
  AgPromiseStatus2[AgPromiseStatus2["RESOLVED"] = 1] = "RESOLVED";
  return AgPromiseStatus2;
})(AgPromiseStatus || {});
var AgPromise = class _AgPromise {
  constructor(callback) {
    this.status = 0 /* IN_PROGRESS */;
    this.resolution = null;
    this.waiters = [];
    callback((value) => this.onDone(value), (params) => this.onReject(params));
  }
  static all(promises) {
    return new _AgPromise((resolve) => {
      let remainingToResolve = promises.length;
      const combinedValues = new Array(remainingToResolve);
      promises.forEach((promise, index) => {
        promise.then((value) => {
          combinedValues[index] = value;
          remainingToResolve--;
          if (remainingToResolve === 0) {
            resolve(combinedValues);
          }
        });
      });
    });
  }
  static resolve(value = null) {
    return new _AgPromise((resolve) => resolve(value));
  }
  then(func) {
    return new _AgPromise((resolve) => {
      if (this.status === 1 /* RESOLVED */) {
        resolve(func(this.resolution));
      } else {
        this.waiters.push((value) => resolve(func(value)));
      }
    });
  }
  resolveNow(ifNotResolvedValue, ifResolved) {
    return this.status === 1 /* RESOLVED */ ? ifResolved(this.resolution) : ifNotResolvedValue;
  }
  onDone(value) {
    this.status = 1 /* RESOLVED */;
    this.resolution = value;
    this.waiters.forEach((waiter) => waiter(value));
  }
  onReject(params) {
    console.warn("TBI");
  }
};

// community-modules/core/src/utils/timer.ts
var Timer = class {
  constructor() {
    this.timestamp = (/* @__PURE__ */ new Date()).getTime();
  }
  print(msg) {
    const duration = (/* @__PURE__ */ new Date()).getTime() - this.timestamp;
    console.info(`${msg} = ${duration}`);
    this.timestamp = (/* @__PURE__ */ new Date()).getTime();
  }
};

// community-modules/core/src/rendering/cssClassManager.ts
var CssClassManager = class {
  constructor(getGui) {
    // to minimise DOM hits, we only apply CSS classes if they have changed. as adding a CSS class that is already
    // there, or removing one that wasn't present, all takes CPU.
    this.cssClassStates = {};
    this.getGui = getGui;
  }
  addCssClass(className) {
    const list = (className || "").split(" ");
    if (list.length > 1) {
      list.forEach((cls) => this.addCssClass(cls));
      return;
    }
    const updateNeeded = this.cssClassStates[className] !== true;
    if (updateNeeded && className.length) {
      const eGui = this.getGui();
      if (eGui) {
        eGui.classList.add(className);
      }
      this.cssClassStates[className] = true;
    }
  }
  removeCssClass(className) {
    const list = (className || "").split(" ");
    if (list.length > 1) {
      list.forEach((cls) => this.removeCssClass(cls));
      return;
    }
    const updateNeeded = this.cssClassStates[className] !== false;
    if (updateNeeded && className.length) {
      const eGui = this.getGui();
      if (eGui) {
        eGui.classList.remove(className);
      }
      this.cssClassStates[className] = false;
    }
  }
  containsCssClass(className) {
    const eGui = this.getGui();
    if (!eGui) {
      return false;
    }
    return eGui.classList.contains(className);
  }
  addOrRemoveCssClass(className, addOrRemove) {
    if (!className) {
      return;
    }
    if (className.indexOf(" ") >= 0) {
      const list = (className || "").split(" ");
      if (list.length > 1) {
        list.forEach((cls) => this.addOrRemoveCssClass(cls, addOrRemove));
        return;
      }
    }
    const updateNeeded = this.cssClassStates[className] !== addOrRemove;
    if (updateNeeded && className.length) {
      const eGui = this.getGui();
      if (eGui) {
        eGui.classList.toggle(className, addOrRemove);
      }
      this.cssClassStates[className] = addOrRemove;
    }
  }
};

// community-modules/core/src/widgets/tooltipStateManager.ts
var _TooltipStateManager = class _TooltipStateManager extends BeanStub {
  constructor(parentComp, tooltipShowDelayOverride, tooltipHideDelayOverride, shouldDisplayTooltip) {
    super();
    this.parentComp = parentComp;
    this.tooltipShowDelayOverride = tooltipShowDelayOverride;
    this.tooltipHideDelayOverride = tooltipHideDelayOverride;
    this.shouldDisplayTooltip = shouldDisplayTooltip;
    this.SHOW_QUICK_TOOLTIP_DIFF = 1e3;
    this.FADE_OUT_TOOLTIP_TIMEOUT = 1e3;
    this.INTERACTIVE_HIDE_DELAY = 100;
    this.interactionEnabled = false;
    this.isInteractingWithTooltip = false;
    this.state = 0 /* NOTHING */;
    // when showing the tooltip, we need to make sure it's the most recent instance we request, as due to
    // async we could request two tooltips before the first instance returns, in which case we should
    // disregard the second instance.
    this.tooltipInstanceCount = 0;
    this.tooltipMouseTrack = false;
  }
  postConstruct() {
    if (this.gridOptionsService.get("tooltipInteraction")) {
      this.interactionEnabled = true;
    }
    this.tooltipTrigger = this.getTooltipTrigger();
    this.tooltipMouseTrack = this.gridOptionsService.get("tooltipMouseTrack");
    const el = this.parentComp.getGui();
    if (this.tooltipTrigger === 0 /* HOVER */) {
      this.addManagedListener(el, "mouseenter", this.onMouseEnter.bind(this));
      this.addManagedListener(el, "mouseleave", this.onMouseLeave.bind(this));
    }
    if (this.tooltipTrigger === 1 /* FOCUS */) {
      this.addManagedListener(el, "focusin", this.onFocusIn.bind(this));
      this.addManagedListener(el, "focusout", this.onFocusOut.bind(this));
    }
    this.addManagedListener(el, "mousemove", this.onMouseMove.bind(this));
    if (!this.interactionEnabled) {
      this.addManagedListener(el, "mousedown", this.onMouseDown.bind(this));
      this.addManagedListener(el, "keydown", this.onKeyDown.bind(this));
    }
  }
  getGridOptionsTooltipDelay(delayOption) {
    const delay = this.gridOptionsService.get(delayOption);
    if (delay < 0) {
      warnOnce(`${delayOption} should not be lower than 0`);
    }
    return Math.max(200, delay);
  }
  getTooltipDelay(type) {
    var _a, _b;
    if (type === "show") {
      return (_a = this.tooltipShowDelayOverride) != null ? _a : this.getGridOptionsTooltipDelay("tooltipShowDelay");
    }
    return (_b = this.tooltipHideDelayOverride) != null ? _b : this.getGridOptionsTooltipDelay("tooltipHideDelay");
  }
  destroy() {
    this.setToDoNothing();
    super.destroy();
  }
  getTooltipTrigger() {
    const trigger = this.gridOptionsService.get("tooltipTrigger");
    if (!trigger || trigger === "hover") {
      return 0 /* HOVER */;
    }
    return 1 /* FOCUS */;
  }
  onMouseEnter(e) {
    if (this.interactionEnabled && this.interactiveTooltipTimeoutId) {
      this.unlockService();
      this.startHideTimeout();
    }
    if (isIOSUserAgent()) {
      return;
    }
    if (_TooltipStateManager.isLocked) {
      this.showTooltipTimeoutId = window.setTimeout(() => {
        this.prepareToShowTooltip(e);
      }, this.INTERACTIVE_HIDE_DELAY);
    } else {
      this.prepareToShowTooltip(e);
    }
  }
  onMouseMove(e) {
    if (this.lastMouseEvent) {
      this.lastMouseEvent = e;
    }
    if (this.tooltipMouseTrack && this.state === 2 /* SHOWING */ && this.tooltipComp) {
      this.positionTooltip();
    }
  }
  onMouseDown() {
    this.setToDoNothing();
  }
  onMouseLeave() {
    if (this.interactionEnabled) {
      this.lockService();
    } else {
      this.setToDoNothing();
    }
  }
  onFocusIn() {
    this.prepareToShowTooltip();
  }
  onFocusOut(e) {
    var _a;
    const relatedTarget = e.relatedTarget;
    const parentCompGui = this.parentComp.getGui();
    const tooltipGui = (_a = this.tooltipComp) == null ? void 0 : _a.getGui();
    if (this.isInteractingWithTooltip || parentCompGui.contains(relatedTarget) || this.interactionEnabled && (tooltipGui == null ? void 0 : tooltipGui.contains(relatedTarget))) {
      return;
    }
    this.setToDoNothing();
  }
  onKeyDown() {
    this.setToDoNothing();
  }
  prepareToShowTooltip(mouseEvent) {
    if (this.state != 0 /* NOTHING */ || _TooltipStateManager.isLocked) {
      return;
    }
    let delay = 0;
    if (mouseEvent) {
      delay = this.isLastTooltipHiddenRecently() ? 200 : this.getTooltipDelay("show");
    }
    this.lastMouseEvent = mouseEvent || null;
    this.showTooltipTimeoutId = window.setTimeout(this.showTooltip.bind(this), delay);
    this.state = 1 /* WAITING_TO_SHOW */;
  }
  isLastTooltipHiddenRecently() {
    const now = (/* @__PURE__ */ new Date()).getTime();
    const then = _TooltipStateManager.lastTooltipHideTime;
    return now - then < this.SHOW_QUICK_TOOLTIP_DIFF;
  }
  setToDoNothing() {
    if (this.state === 2 /* SHOWING */) {
      this.hideTooltip();
    }
    if (this.onBodyScrollEventCallback) {
      this.onBodyScrollEventCallback();
      this.onBodyScrollEventCallback = void 0;
    }
    if (this.onColumnMovedEventCallback) {
      this.onColumnMovedEventCallback();
      this.onColumnMovedEventCallback = void 0;
    }
    this.clearTimeouts();
    this.state = 0 /* NOTHING */;
    this.lastMouseEvent = null;
  }
  showTooltip() {
    const params = __spreadValues({}, this.parentComp.getTooltipParams());
    if (!exists(params.value) || this.shouldDisplayTooltip && !this.shouldDisplayTooltip()) {
      this.setToDoNothing();
      return;
    }
    this.state = 2 /* SHOWING */;
    this.tooltipInstanceCount++;
    const callback = this.newTooltipComponentCallback.bind(this, this.tooltipInstanceCount);
    const userDetails = this.userComponentFactory.getTooltipCompDetails(params);
    userDetails.newAgStackInstance().then(callback);
  }
  hideTooltip(forceHide) {
    if (!forceHide && this.isInteractingWithTooltip) {
      return;
    }
    if (this.tooltipComp) {
      this.destroyTooltipComp();
      _TooltipStateManager.lastTooltipHideTime = (/* @__PURE__ */ new Date()).getTime();
    }
    const event = {
      type: Events.EVENT_TOOLTIP_HIDE,
      parentGui: this.parentComp.getGui()
    };
    this.eventService.dispatchEvent(event);
    this.state = 0 /* NOTHING */;
  }
  newTooltipComponentCallback(tooltipInstanceCopy, tooltipComp) {
    const compNoLongerNeeded = this.state !== 2 /* SHOWING */ || this.tooltipInstanceCount !== tooltipInstanceCopy;
    if (compNoLongerNeeded) {
      this.getContext().destroyBean(tooltipComp);
      return;
    }
    const eGui = tooltipComp.getGui();
    this.tooltipComp = tooltipComp;
    if (!eGui.classList.contains("ag-tooltip")) {
      eGui.classList.add("ag-tooltip-custom");
    }
    if (this.tooltipTrigger === 0 /* HOVER */) {
      eGui.classList.add("ag-tooltip-animate");
    }
    if (this.interactionEnabled) {
      eGui.classList.add("ag-tooltip-interactive");
    }
    const translate = this.localeService.getLocaleTextFunc();
    const addPopupRes = this.popupService.addPopup({
      eChild: eGui,
      ariaLabel: translate("ariaLabelTooltip", "Tooltip")
    });
    if (addPopupRes) {
      this.tooltipPopupDestroyFunc = addPopupRes.hideFunc;
    }
    this.positionTooltip();
    if (this.tooltipTrigger === 1 /* FOCUS */) {
      this.onBodyScrollEventCallback = this.addManagedListener(this.eventService, Events.EVENT_BODY_SCROLL, this.setToDoNothing.bind(this));
      this.onColumnMovedEventCallback = this.addManagedListener(this.eventService, Events.EVENT_COLUMN_MOVED, this.setToDoNothing.bind(this));
    }
    if (this.interactionEnabled) {
      if (this.tooltipTrigger === 0 /* HOVER */) {
        this.tooltipMouseEnterListener = this.addManagedListener(eGui, "mouseenter", this.onTooltipMouseEnter.bind(this)) || null;
        this.tooltipMouseLeaveListener = this.addManagedListener(eGui, "mouseleave", this.onTooltipMouseLeave.bind(this)) || null;
      } else {
        this.tooltipFocusInListener = this.addManagedListener(eGui, "focusin", this.onTooltipFocusIn.bind(this)) || null;
        this.tooltipFocusOutListener = this.addManagedListener(eGui, "focusout", this.onTooltipFocusOut.bind(this)) || null;
      }
    }
    const event = {
      type: Events.EVENT_TOOLTIP_SHOW,
      tooltipGui: eGui,
      parentGui: this.parentComp.getGui()
    };
    this.eventService.dispatchEvent(event);
    this.startHideTimeout();
  }
  onTooltipMouseEnter() {
    this.isInteractingWithTooltip = true;
    this.unlockService();
  }
  onTooltipMouseLeave() {
    this.isInteractingWithTooltip = false;
    this.lockService();
  }
  onTooltipFocusIn() {
    this.isInteractingWithTooltip = true;
  }
  onTooltipFocusOut(e) {
    var _a;
    const parentGui = this.parentComp.getGui();
    const tooltipGui = (_a = this.tooltipComp) == null ? void 0 : _a.getGui();
    const relatedTarget = e.relatedTarget;
    if (tooltipGui == null ? void 0 : tooltipGui.contains(relatedTarget)) {
      return;
    }
    this.isInteractingWithTooltip = false;
    if (parentGui.contains(relatedTarget)) {
      this.startHideTimeout();
    } else {
      this.hideTooltip();
    }
  }
  positionTooltip() {
    const params = {
      type: "tooltip",
      ePopup: this.tooltipComp.getGui(),
      nudgeY: 18,
      skipObserver: this.tooltipMouseTrack
    };
    if (this.lastMouseEvent) {
      this.popupService.positionPopupUnderMouseEvent(__spreadProps(__spreadValues({}, params), {
        mouseEvent: this.lastMouseEvent
      }));
    } else {
      this.popupService.positionPopupByComponent(__spreadProps(__spreadValues({}, params), {
        eventSource: this.parentComp.getGui(),
        position: "under",
        keepWithinBounds: true,
        nudgeY: 5
      }));
    }
  }
  destroyTooltipComp() {
    this.tooltipComp.getGui().classList.add("ag-tooltip-hiding");
    const tooltipPopupDestroyFunc = this.tooltipPopupDestroyFunc;
    const tooltipComp = this.tooltipComp;
    const delay = this.tooltipTrigger === 0 /* HOVER */ ? this.FADE_OUT_TOOLTIP_TIMEOUT : 0;
    window.setTimeout(() => {
      tooltipPopupDestroyFunc();
      this.getContext().destroyBean(tooltipComp);
    }, delay);
    this.clearTooltipListeners();
    this.tooltipPopupDestroyFunc = void 0;
    this.tooltipComp = void 0;
  }
  clearTooltipListeners() {
    [
      this.tooltipMouseEnterListener,
      this.tooltipMouseLeaveListener,
      this.tooltipFocusInListener,
      this.tooltipFocusOutListener
    ].forEach((listener) => {
      if (listener) {
        listener();
      }
    });
    this.tooltipMouseEnterListener = this.tooltipMouseLeaveListener = this.tooltipFocusInListener = this.tooltipFocusOutListener = null;
  }
  lockService() {
    _TooltipStateManager.isLocked = true;
    this.interactiveTooltipTimeoutId = window.setTimeout(() => {
      this.unlockService();
      this.setToDoNothing();
    }, this.INTERACTIVE_HIDE_DELAY);
  }
  unlockService() {
    _TooltipStateManager.isLocked = false;
    this.clearInteractiveTimeout();
  }
  startHideTimeout() {
    this.clearHideTimeout();
    this.hideTooltipTimeoutId = window.setTimeout(this.hideTooltip.bind(this), this.getTooltipDelay("hide"));
  }
  clearShowTimeout() {
    if (!this.showTooltipTimeoutId) {
      return;
    }
    window.clearTimeout(this.showTooltipTimeoutId);
    this.showTooltipTimeoutId = void 0;
  }
  clearHideTimeout() {
    if (!this.hideTooltipTimeoutId) {
      return;
    }
    window.clearTimeout(this.hideTooltipTimeoutId);
    this.hideTooltipTimeoutId = void 0;
  }
  clearInteractiveTimeout() {
    if (!this.interactiveTooltipTimeoutId) {
      return;
    }
    window.clearTimeout(this.interactiveTooltipTimeoutId);
    this.interactiveTooltipTimeoutId = void 0;
  }
  clearTimeouts() {
    this.clearShowTimeout();
    this.clearHideTimeout();
    this.clearInteractiveTimeout();
  }
};
_TooltipStateManager.isLocked = false;
__decorateClass([
  Autowired("popupService")
], _TooltipStateManager.prototype, "popupService", 2);
__decorateClass([
  Autowired("userComponentFactory")
], _TooltipStateManager.prototype, "userComponentFactory", 2);
__decorateClass([
  PostConstruct
], _TooltipStateManager.prototype, "postConstruct", 1);
var TooltipStateManager = _TooltipStateManager;

// community-modules/core/src/widgets/tooltipFeature.ts
var TooltipFeature = class extends BeanStub {
  constructor(ctrl, beans) {
    super();
    this.ctrl = ctrl;
    if (beans) {
      this.beans = beans;
    }
  }
  postConstruct() {
    this.refreshToolTip();
  }
  setBrowserTooltip(tooltip) {
    const name = "title";
    const eGui = this.ctrl.getGui();
    if (!eGui) {
      return;
    }
    if (tooltip != null && tooltip != "") {
      eGui.setAttribute(name, tooltip);
    } else {
      eGui.removeAttribute(name);
    }
  }
  updateTooltipText() {
    this.tooltip = this.ctrl.getTooltipValue();
  }
  createTooltipFeatureIfNeeded() {
    var _a, _b, _c, _d;
    if (this.tooltipManager != null) {
      return;
    }
    const parent = {
      getTooltipParams: () => this.getTooltipParams(),
      getGui: () => this.ctrl.getGui()
    };
    this.tooltipManager = this.createBean(new TooltipStateManager(
      parent,
      (_b = (_a = this.ctrl).getTooltipShowDelayOverride) == null ? void 0 : _b.call(_a),
      (_d = (_c = this.ctrl).getTooltipHideDelayOverride) == null ? void 0 : _d.call(_c),
      this.ctrl.shouldDisplayTooltip
    ), this.beans.context);
  }
  refreshToolTip() {
    this.browserTooltips = this.beans.gridOptionsService.get("enableBrowserTooltips");
    this.updateTooltipText();
    if (this.browserTooltips) {
      this.setBrowserTooltip(this.tooltip);
      if (this.tooltipManager) {
        this.tooltipManager = this.destroyBean(this.tooltipManager, this.beans.context);
      }
    } else {
      this.setBrowserTooltip(null);
      this.createTooltipFeatureIfNeeded();
    }
  }
  getTooltipParams() {
    const ctrl = this.ctrl;
    const column = ctrl.getColumn ? ctrl.getColumn() : void 0;
    const colDef = ctrl.getColDef ? ctrl.getColDef() : void 0;
    const rowNode = ctrl.getRowNode ? ctrl.getRowNode() : void 0;
    return {
      location: ctrl.getLocation(),
      //'cell',
      colDef,
      column,
      rowIndex: ctrl.getRowIndex ? ctrl.getRowIndex() : void 0,
      node: rowNode,
      data: rowNode ? rowNode.data : void 0,
      value: this.getTooltipText(),
      valueFormatted: ctrl.getValueFormatted ? ctrl.getValueFormatted() : void 0,
      hideTooltipCallback: () => {
        var _a;
        return (_a = this.tooltipManager) == null ? void 0 : _a.hideTooltip(true);
      }
    };
  }
  getTooltipText() {
    return this.tooltip;
  }
  // overriding to make public, as we don't dispose this bean via context
  destroy() {
    if (this.tooltipManager) {
      this.tooltipManager = this.destroyBean(this.tooltipManager, this.beans.context);
    }
    super.destroy();
  }
};
__decorateClass([
  Autowired("beans")
], TooltipFeature.prototype, "beans", 2);
__decorateClass([
  PostConstruct
], TooltipFeature.prototype, "postConstruct", 1);

// community-modules/core/src/widgets/component.ts
var compIdSequence = new NumberSequence();
var _Component = class _Component extends BeanStub {
  constructor(template) {
    super();
    // if false, then CSS class "ag-hidden" is applied, which sets "display: none"
    this.displayed = true;
    // if false, then CSS class "ag-invisible" is applied, which sets "visibility: hidden"
    this.visible = true;
    // unique id for this row component. this is used for getting a reference to the HTML dom.
    // we cannot use the RowNode id as this is not unique (due to animation, old rows can be lying
    // around as we create a new rowComp instance for the same row node).
    this.compId = compIdSequence.next();
    this.cssClassManager = new CssClassManager(() => this.eGui);
    if (template) {
      this.setTemplate(template);
    }
  }
  preConstructOnComponent() {
    this.usingBrowserTooltips = this.gridOptionsService.get("enableBrowserTooltips");
  }
  getCompId() {
    return this.compId;
  }
  getTooltipParams() {
    return {
      value: this.tooltipText,
      location: "UNKNOWN"
    };
  }
  setTooltip(params) {
    const { newTooltipText, showDelayOverride, hideDelayOverride, location, shouldDisplayTooltip } = params || {};
    if (this.tooltipFeature) {
      this.tooltipFeature = this.destroyBean(this.tooltipFeature);
    }
    if (this.tooltipText !== newTooltipText) {
      this.tooltipText = newTooltipText;
    }
    const getTooltipValue = () => this.tooltipText;
    if (newTooltipText != null) {
      this.tooltipFeature = this.createBean(new TooltipFeature({
        getTooltipValue,
        getGui: () => this.getGui(),
        getLocation: () => location != null ? location : "UNKNOWN",
        getTooltipShowDelayOverride: showDelayOverride != null ? () => showDelayOverride : void 0,
        getTooltipHideDelayOverride: hideDelayOverride != null ? () => hideDelayOverride : void 0,
        shouldDisplayTooltip
      }));
    }
  }
  // for registered components only, eg creates AgCheckbox instance from ag-checkbox HTML tag
  createChildComponentsFromTags(parentNode, paramsMap) {
    const childNodeList = copyNodeList(parentNode.childNodes);
    childNodeList.forEach((childNode) => {
      if (!(childNode instanceof HTMLElement)) {
        return;
      }
      const childComp = this.createComponentFromElement(childNode, (childComp2) => {
        const childGui = childComp2.getGui();
        if (childGui) {
          this.copyAttributesFromNode(childNode, childComp2.getGui());
        }
      }, paramsMap);
      if (childComp) {
        if (childComp.addItems && childNode.children.length) {
          this.createChildComponentsFromTags(childNode, paramsMap);
          const items = Array.prototype.slice.call(childNode.children);
          childComp.addItems(items);
        }
        this.swapComponentForNode(childComp, parentNode, childNode);
      } else if (childNode.childNodes) {
        this.createChildComponentsFromTags(childNode, paramsMap);
      }
    });
  }
  createComponentFromElement(element, afterPreCreateCallback, paramsMap) {
    const key = element.nodeName;
    const componentParams = paramsMap ? paramsMap[element.getAttribute("ref")] : void 0;
    const ComponentClass = this.agStackComponentsRegistry.getComponentClass(key);
    if (ComponentClass) {
      _Component.elementGettingCreated = element;
      const newComponent = new ComponentClass(componentParams);
      newComponent.setParentComponent(this);
      this.createBean(newComponent, null, afterPreCreateCallback);
      return newComponent;
    }
    return null;
  }
  copyAttributesFromNode(source, dest) {
    iterateNamedNodeMap(source.attributes, (name, value) => dest.setAttribute(name, value));
  }
  swapComponentForNode(newComponent, parentNode, childNode) {
    const eComponent = newComponent.getGui();
    parentNode.replaceChild(eComponent, childNode);
    parentNode.insertBefore(document.createComment(childNode.nodeName), eComponent);
    this.addDestroyFunc(this.destroyBean.bind(this, newComponent));
    this.swapInComponentForQuerySelectors(newComponent, childNode);
  }
  swapInComponentForQuerySelectors(newComponent, childNode) {
    const thisNoType = this;
    this.iterateOverQuerySelectors((querySelector) => {
      if (thisNoType[querySelector.attributeName] === childNode) {
        thisNoType[querySelector.attributeName] = newComponent;
      }
    });
  }
  iterateOverQuerySelectors(action) {
    let thisPrototype = Object.getPrototypeOf(this);
    while (thisPrototype != null) {
      const metaData = thisPrototype.__agComponentMetaData;
      const currentProtoName = getFunctionName(thisPrototype.constructor);
      if (metaData && metaData[currentProtoName] && metaData[currentProtoName].querySelectors) {
        metaData[currentProtoName].querySelectors.forEach((querySelector) => action(querySelector));
      }
      thisPrototype = Object.getPrototypeOf(thisPrototype);
    }
  }
  activateTabIndex(elements) {
    const tabIndex = this.gridOptionsService.get("tabIndex");
    if (!elements) {
      elements = [];
    }
    if (!elements.length) {
      elements.push(this.getGui());
    }
    elements.forEach((el) => el.setAttribute("tabindex", tabIndex.toString()));
  }
  setTemplate(template, paramsMap) {
    const eGui = loadTemplate(template);
    this.setTemplateFromElement(eGui, paramsMap);
  }
  setTemplateFromElement(element, paramsMap) {
    this.eGui = element;
    this.eGui.__agComponent = this;
    this.wireQuerySelectors();
    if (!!this.getContext()) {
      this.createChildComponentsFromTags(this.getGui(), paramsMap);
    }
  }
  createChildComponentsPreConstruct() {
    if (!!this.getGui()) {
      this.createChildComponentsFromTags(this.getGui());
    }
  }
  wireQuerySelectors() {
    if (!this.eGui) {
      return;
    }
    const thisNoType = this;
    this.iterateOverQuerySelectors((querySelector) => {
      const setResult = (result) => thisNoType[querySelector.attributeName] = result;
      const topLevelRefMatch = querySelector.refSelector && this.getAttribute("ref") === querySelector.refSelector;
      if (topLevelRefMatch) {
        setResult(this.eGui);
      } else {
        const resultOfQuery = this.eGui.querySelector(querySelector.querySelector);
        if (resultOfQuery) {
          setResult(resultOfQuery.__agComponent || resultOfQuery);
        }
      }
    });
  }
  getGui() {
    return this.eGui;
  }
  getFocusableElement() {
    return this.eGui;
  }
  getAriaElement() {
    return this.getFocusableElement();
  }
  setParentComponent(component) {
    this.parentComponent = component;
  }
  getParentComponent() {
    return this.parentComponent;
  }
  // this method is for older code, that wants to provide the gui element,
  // it is not intended for this to be in ag-Stack
  setGui(eGui) {
    this.eGui = eGui;
  }
  queryForHtmlElement(cssSelector) {
    return this.eGui.querySelector(cssSelector);
  }
  queryForHtmlInputElement(cssSelector) {
    return this.eGui.querySelector(cssSelector);
  }
  appendChild(newChild, container) {
    if (newChild == null) {
      return;
    }
    if (!container) {
      container = this.eGui;
    }
    if (isNodeOrElement(newChild)) {
      container.appendChild(newChild);
    } else {
      const childComponent = newChild;
      container.appendChild(childComponent.getGui());
    }
  }
  isDisplayed() {
    return this.displayed;
  }
  setVisible(visible, options = {}) {
    if (visible !== this.visible) {
      this.visible = visible;
      const { skipAriaHidden } = options;
      setVisible(this.eGui, visible, { skipAriaHidden });
    }
  }
  setDisplayed(displayed, options = {}) {
    if (displayed !== this.displayed) {
      this.displayed = displayed;
      const { skipAriaHidden } = options;
      setDisplayed(this.eGui, displayed, { skipAriaHidden });
      const event = {
        type: _Component.EVENT_DISPLAYED_CHANGED,
        visible: this.displayed
      };
      this.dispatchEvent(event);
    }
  }
  destroy() {
    if (this.parentComponent) {
      this.parentComponent = void 0;
    }
    if (this.tooltipFeature) {
      this.tooltipFeature = this.destroyBean(this.tooltipFeature);
    }
    const eGui = this.eGui;
    if (eGui && eGui.__agComponent) {
      eGui.__agComponent = void 0;
    }
    super.destroy();
  }
  addGuiEventListener(event, listener, options) {
    this.eGui.addEventListener(event, listener, options);
    this.addDestroyFunc(() => this.eGui.removeEventListener(event, listener));
  }
  addCssClass(className) {
    this.cssClassManager.addCssClass(className);
  }
  removeCssClass(className) {
    this.cssClassManager.removeCssClass(className);
  }
  containsCssClass(className) {
    return this.cssClassManager.containsCssClass(className);
  }
  addOrRemoveCssClass(className, addOrRemove) {
    this.cssClassManager.addOrRemoveCssClass(className, addOrRemove);
  }
  getAttribute(key) {
    const { eGui } = this;
    return eGui ? eGui.getAttribute(key) : null;
  }
  getRefElement(refName) {
    return this.queryForHtmlElement(`[ref="${refName}"]`);
  }
};
_Component.EVENT_DISPLAYED_CHANGED = "displayedChanged";
__decorateClass([
  Autowired("agStackComponentsRegistry")
], _Component.prototype, "agStackComponentsRegistry", 2);
__decorateClass([
  PreConstruct
], _Component.prototype, "preConstructOnComponent", 1);
__decorateClass([
  PreConstruct
], _Component.prototype, "createChildComponentsPreConstruct", 1);
var Component = _Component;

// community-modules/core/src/widgets/componentAnnotations.ts
function QuerySelector(selector) {
  return querySelectorFunc.bind(this, selector, void 0);
}
function RefSelector(ref) {
  return querySelectorFunc.bind(this, `[ref=${ref}]`, ref);
}
function querySelectorFunc(selector, refSelector, classPrototype, methodOrAttributeName, index) {
  if (selector === null) {
    console.error("AG Grid: QuerySelector selector should not be null");
    return;
  }
  if (typeof index === "number") {
    console.error("AG Grid: QuerySelector should be on an attribute");
    return;
  }
  addToObjectProps(classPrototype, "querySelectors", {
    attributeName: methodOrAttributeName,
    querySelector: selector,
    refSelector
  });
}
function addToObjectProps(target, key, value) {
  const props = getOrCreateProps2(target, getFunctionName(target.constructor));
  if (!props[key]) {
    props[key] = [];
  }
  props[key].push(value);
}
function getOrCreateProps2(target, instanceName) {
  if (!target.__agComponentMetaData) {
    target.__agComponentMetaData = {};
  }
  if (!target.__agComponentMetaData[instanceName]) {
    target.__agComponentMetaData[instanceName] = {};
  }
  return target.__agComponentMetaData[instanceName];
}

// community-modules/core/src/filter/floating/provided/readOnlyFloatingFilter.ts
var ReadOnlyFloatingFilter = class extends Component {
  constructor() {
    super(
      /* html */
      `
            <div class="ag-floating-filter-input" role="presentation">
                <ag-input-text-field ref="eFloatingFilterText"></ag-input-text-field>
            </div>`
    );
  }
  // this is a user component, and IComponent has "public destroy()" as part of the interface.
  // so we need to override destroy() just to make the method public.
  destroy() {
    super.destroy();
  }
  init(params) {
    this.params = params;
    const displayName = this.columnModel.getDisplayNameForColumn(params.column, "header", true);
    const translate = this.localeService.getLocaleTextFunc();
    this.eFloatingFilterText.setDisabled(true).setInputAriaLabel(`${displayName} ${translate("ariaFilterInput", "Filter Input")}`);
  }
  onParentModelChanged(parentModel) {
    if (parentModel == null) {
      this.eFloatingFilterText.setValue("");
      return;
    }
    this.params.parentFilterInstance((filterInstance) => {
      if (filterInstance.getModelAsString) {
        const modelAsString = filterInstance.getModelAsString(parentModel);
        this.eFloatingFilterText.setValue(modelAsString);
      }
    });
  }
  onParamsUpdated(params) {
    this.refresh(params);
  }
  refresh(params) {
    this.init(params);
  }
};
__decorateClass([
  RefSelector("eFloatingFilterText")
], ReadOnlyFloatingFilter.prototype, "eFloatingFilterText", 2);
__decorateClass([
  Autowired("columnModel")
], ReadOnlyFloatingFilter.prototype, "columnModel", 2);

// community-modules/core/src/filter/provided/date/dateCompWrapper.ts
var DateCompWrapper = class {
  constructor(context, userComponentFactory, dateComponentParams, eParent) {
    this.alive = true;
    this.context = context;
    this.eParent = eParent;
    const compDetails = userComponentFactory.getDateCompDetails(dateComponentParams);
    const promise = compDetails.newAgStackInstance();
    promise.then((dateComp) => {
      if (!this.alive) {
        context.destroyBean(dateComp);
        return;
      }
      this.dateComp = dateComp;
      if (!dateComp) {
        return;
      }
      eParent.appendChild(dateComp.getGui());
      if (dateComp.afterGuiAttached) {
        dateComp.afterGuiAttached();
      }
      if (this.tempValue) {
        dateComp.setDate(this.tempValue);
      }
      if (this.disabled != null) {
        this.setDateCompDisabled(this.disabled);
      }
    });
  }
  destroy() {
    this.alive = false;
    this.dateComp = this.context.destroyBean(this.dateComp);
  }
  getDate() {
    return this.dateComp ? this.dateComp.getDate() : this.tempValue;
  }
  setDate(value) {
    if (this.dateComp) {
      this.dateComp.setDate(value);
    } else {
      this.tempValue = value;
    }
  }
  setDisabled(disabled) {
    if (this.dateComp) {
      this.setDateCompDisabled(disabled);
    } else {
      this.disabled = disabled;
    }
  }
  setDisplayed(displayed) {
    setDisplayed(this.eParent, displayed);
  }
  setInputPlaceholder(placeholder) {
    if (this.dateComp && this.dateComp.setInputPlaceholder) {
      this.dateComp.setInputPlaceholder(placeholder);
    }
  }
  setInputAriaLabel(label) {
    if (this.dateComp && this.dateComp.setInputAriaLabel) {
      this.dateComp.setInputAriaLabel(label);
    }
  }
  afterGuiAttached(params) {
    if (this.dateComp && typeof this.dateComp.afterGuiAttached === "function") {
      this.dateComp.afterGuiAttached(params);
    }
  }
  updateParams(params) {
    var _a, _b;
    let hasRefreshed = false;
    if (((_a = this.dateComp) == null ? void 0 : _a.refresh) && typeof this.dateComp.refresh === "function") {
      const result = this.dateComp.refresh(params);
      if (result !== null) {
        hasRefreshed = true;
      }
    }
    if (!hasRefreshed && ((_b = this.dateComp) == null ? void 0 : _b.onParamsUpdated) && typeof this.dateComp.onParamsUpdated === "function") {
      const result = this.dateComp.onParamsUpdated(params);
      if (result !== null) {
        warnOnce(`Custom date component method 'onParamsUpdated' is deprecated. Use 'refresh' instead.`);
      }
    }
  }
  setDateCompDisabled(disabled) {
    if (this.dateComp == null) {
      return;
    }
    if (this.dateComp.setDisabled == null) {
      return;
    }
    this.dateComp.setDisabled(disabled);
  }
};

// community-modules/core/src/filter/provided/optionsFactory.ts
var OptionsFactory = class {
  constructor() {
    this.customFilterOptions = {};
  }
  init(params, defaultOptions) {
    this.filterOptions = params.filterOptions || defaultOptions;
    this.mapCustomOptions();
    this.selectDefaultItem(params);
  }
  getFilterOptions() {
    return this.filterOptions;
  }
  mapCustomOptions() {
    if (!this.filterOptions) {
      return;
    }
    this.filterOptions.forEach((filterOption) => {
      if (typeof filterOption === "string") {
        return;
      }
      const requiredProperties = [["displayKey"], ["displayName"], ["predicate", "test"]];
      const propertyCheck = (keys2) => {
        if (!keys2.some((key) => filterOption[key] != null)) {
          console.warn(`AG Grid: ignoring FilterOptionDef as it doesn't contain one of '${keys2}'`);
          return false;
        }
        return true;
      };
      if (!requiredProperties.every(propertyCheck)) {
        this.filterOptions = this.filterOptions.filter((v) => v === filterOption) || [];
        return;
      }
      this.customFilterOptions[filterOption.displayKey] = filterOption;
    });
  }
  selectDefaultItem(params) {
    if (params.defaultOption) {
      this.defaultOption = params.defaultOption;
    } else if (this.filterOptions.length >= 1) {
      const firstFilterOption = this.filterOptions[0];
      if (typeof firstFilterOption === "string") {
        this.defaultOption = firstFilterOption;
      } else if (firstFilterOption.displayKey) {
        this.defaultOption = firstFilterOption.displayKey;
      } else {
        console.warn(`AG Grid: invalid FilterOptionDef supplied as it doesn't contain a 'displayKey'`);
      }
    } else {
      console.warn("AG Grid: no filter options for filter");
    }
  }
  getDefaultOption() {
    return this.defaultOption;
  }
  getCustomOption(name) {
    return this.customFilterOptions[name];
  }
};

// community-modules/core/src/filter/filterLocaleText.ts
var FILTER_LOCALE_TEXT = {
  applyFilter: "Apply",
  clearFilter: "Clear",
  resetFilter: "Reset",
  cancelFilter: "Cancel",
  textFilter: "Text Filter",
  numberFilter: "Number Filter",
  dateFilter: "Date Filter",
  setFilter: "Set Filter",
  filterOoo: "Filter...",
  empty: "Choose one",
  equals: "Equals",
  notEqual: "Does not equal",
  lessThan: "Less than",
  greaterThan: "Greater than",
  inRange: "Between",
  inRangeStart: "From",
  inRangeEnd: "To",
  lessThanOrEqual: "Less than or equal to",
  greaterThanOrEqual: "Greater than or equal to",
  contains: "Contains",
  notContains: "Does not contain",
  startsWith: "Begins with",
  endsWith: "Ends with",
  blank: "Blank",
  notBlank: "Not blank",
  before: "Before",
  after: "After",
  andCondition: "AND",
  orCondition: "OR",
  dateFormatOoo: "yyyy-mm-dd"
};

// community-modules/core/src/widgets/managedFocusFeature.ts
var _ManagedFocusFeature = class _ManagedFocusFeature extends BeanStub {
  constructor(eFocusableElement, callbacks = {}) {
    super();
    this.eFocusableElement = eFocusableElement;
    this.callbacks = callbacks;
    this.callbacks = __spreadValues({
      shouldStopEventPropagation: () => false,
      onTabKeyDown: (e) => {
        if (e.defaultPrevented) {
          return;
        }
        const nextRoot = this.focusService.findNextFocusableElement(this.eFocusableElement, false, e.shiftKey);
        if (!nextRoot) {
          return;
        }
        nextRoot.focus();
        e.preventDefault();
      }
    }, callbacks);
  }
  postConstruct() {
    this.eFocusableElement.classList.add(_ManagedFocusFeature.FOCUS_MANAGED_CLASS);
    this.addKeyDownListeners(this.eFocusableElement);
    if (this.callbacks.onFocusIn) {
      this.addManagedListener(this.eFocusableElement, "focusin", this.callbacks.onFocusIn);
    }
    if (this.callbacks.onFocusOut) {
      this.addManagedListener(this.eFocusableElement, "focusout", this.callbacks.onFocusOut);
    }
  }
  addKeyDownListeners(eGui) {
    this.addManagedListener(eGui, "keydown", (e) => {
      if (e.defaultPrevented || isStopPropagationForAgGrid(e)) {
        return;
      }
      if (this.callbacks.shouldStopEventPropagation(e)) {
        stopPropagationForAgGrid(e);
        return;
      }
      if (e.key === KeyCode.TAB) {
        this.callbacks.onTabKeyDown(e);
      } else if (this.callbacks.handleKeyDown) {
        this.callbacks.handleKeyDown(e);
      }
    });
  }
};
_ManagedFocusFeature.FOCUS_MANAGED_CLASS = "ag-focus-managed";
__decorateClass([
  Autowired("focusService")
], _ManagedFocusFeature.prototype, "focusService", 2);
__decorateClass([
  PostConstruct
], _ManagedFocusFeature.prototype, "postConstruct", 1);
var ManagedFocusFeature = _ManagedFocusFeature;

// community-modules/core/src/rendering/features/positionableFeature.ts
var RESIZE_CONTAINER_STYLE = "ag-resizer-wrapper";
var RESIZE_TEMPLATE = (
  /* html */
  `<div class="${RESIZE_CONTAINER_STYLE}">
        <div ref="eTopLeftResizer" class="ag-resizer ag-resizer-topLeft"></div>
        <div ref="eTopResizer" class="ag-resizer ag-resizer-top"></div>
        <div ref="eTopRightResizer" class="ag-resizer ag-resizer-topRight"></div>
        <div ref="eRightResizer" class="ag-resizer ag-resizer-right"></div>
        <div ref="eBottomRightResizer" class="ag-resizer ag-resizer-bottomRight"></div>
        <div ref="eBottomResizer" class="ag-resizer ag-resizer-bottom"></div>
        <div ref="eBottomLeftResizer" class="ag-resizer ag-resizer-bottomLeft"></div>
        <div ref="eLeftResizer" class="ag-resizer ag-resizer-left"></div>
    </div>`
);
var PositionableFeature = class extends BeanStub {
  constructor(element, config) {
    super();
    this.element = element;
    this.dragStartPosition = {
      x: 0,
      y: 0
    };
    this.position = {
      x: 0,
      y: 0
    };
    this.lastSize = {
      width: -1,
      height: -1
    };
    this.positioned = false;
    this.resizersAdded = false;
    this.resizeListeners = [];
    this.boundaryEl = null;
    this.isResizing = false;
    this.isMoving = false;
    this.resizable = {};
    this.movable = false;
    this.currentResizer = null;
    this.config = Object.assign({}, { popup: false }, config);
  }
  center() {
    const { clientHeight, clientWidth } = this.offsetParent;
    const x = clientWidth / 2 - this.getWidth() / 2;
    const y = clientHeight / 2 - this.getHeight() / 2;
    this.offsetElement(x, y);
  }
  initialisePosition() {
    if (this.positioned) {
      return;
    }
    const { centered, forcePopupParentAsOffsetParent, minWidth, width, minHeight, height, x, y } = this.config;
    if (!this.offsetParent) {
      this.setOffsetParent();
    }
    let computedMinHeight = 0;
    let computedMinWidth = 0;
    const isElementVisible = isVisible(this.element);
    if (isElementVisible) {
      const boundaryEl = this.findBoundaryElement();
      const offsetParentComputedStyles = window.getComputedStyle(boundaryEl);
      if (offsetParentComputedStyles.minWidth != null) {
        const paddingWidth = boundaryEl.offsetWidth - this.element.offsetWidth;
        computedMinWidth = parseInt(offsetParentComputedStyles.minWidth, 10) - paddingWidth;
      }
      if (offsetParentComputedStyles.minHeight != null) {
        const paddingHeight = boundaryEl.offsetHeight - this.element.offsetHeight;
        computedMinHeight = parseInt(offsetParentComputedStyles.minHeight, 10) - paddingHeight;
      }
    }
    this.minHeight = minHeight || computedMinHeight;
    this.minWidth = minWidth || computedMinWidth;
    if (width) {
      this.setWidth(width);
    }
    if (height) {
      this.setHeight(height);
    }
    if (!width || !height) {
      this.refreshSize();
    }
    if (centered) {
      this.center();
    } else if (x || y) {
      this.offsetElement(x, y);
    } else if (isElementVisible && forcePopupParentAsOffsetParent) {
      let boundaryEl = this.boundaryEl;
      let initialisedDuringPositioning = true;
      if (!boundaryEl) {
        boundaryEl = this.findBoundaryElement();
        initialisedDuringPositioning = false;
      }
      if (boundaryEl) {
        const top = parseFloat(boundaryEl.style.top);
        const left = parseFloat(boundaryEl.style.left);
        if (initialisedDuringPositioning) {
          this.offsetElement(
            isNaN(left) ? 0 : left,
            isNaN(top) ? 0 : top
          );
        } else {
          this.setPosition(left, top);
        }
      }
    }
    this.positioned = !!this.offsetParent;
  }
  isPositioned() {
    return this.positioned;
  }
  getPosition() {
    return this.position;
  }
  setMovable(movable, moveElement) {
    if (!this.config.popup || movable === this.movable) {
      return;
    }
    this.movable = movable;
    const params = this.moveElementDragListener || {
      eElement: moveElement,
      onDragStart: this.onMoveStart.bind(this),
      onDragging: this.onMove.bind(this),
      onDragStop: this.onMoveEnd.bind(this)
    };
    if (movable) {
      this.dragService.addDragSource(params);
      this.moveElementDragListener = params;
    } else {
      this.dragService.removeDragSource(params);
      this.moveElementDragListener = void 0;
    }
  }
  setResizable(resizable) {
    this.clearResizeListeners();
    if (resizable) {
      this.addResizers();
    } else {
      this.removeResizers();
    }
    if (typeof resizable === "boolean") {
      if (resizable === false) {
        return;
      }
      resizable = {
        topLeft: resizable,
        top: resizable,
        topRight: resizable,
        right: resizable,
        bottomRight: resizable,
        bottom: resizable,
        bottomLeft: resizable,
        left: resizable
      };
    }
    Object.keys(resizable).forEach((side) => {
      const resizableStructure = resizable;
      const isSideResizable = !!resizableStructure[side];
      const resizerEl = this.getResizerElement(side);
      const params = {
        dragStartPixels: 0,
        eElement: resizerEl,
        onDragStart: (e) => this.onResizeStart(e, side),
        onDragging: this.onResize.bind(this),
        onDragStop: (e) => this.onResizeEnd(e, side)
      };
      if (isSideResizable || !this.isAlive() && !isSideResizable) {
        if (isSideResizable) {
          this.dragService.addDragSource(params);
          this.resizeListeners.push(params);
          resizerEl.style.pointerEvents = "all";
        } else {
          resizerEl.style.pointerEvents = "none";
        }
        this.resizable[side] = isSideResizable;
      }
    });
  }
  removeSizeFromEl() {
    this.element.style.removeProperty("height");
    this.element.style.removeProperty("width");
    this.element.style.removeProperty("flex");
  }
  restoreLastSize() {
    this.element.style.flex = "0 0 auto";
    const { height, width } = this.lastSize;
    if (width !== -1) {
      this.element.style.width = `${width}px`;
    }
    if (height !== -1) {
      this.element.style.height = `${height}px`;
    }
  }
  getHeight() {
    return this.element.offsetHeight;
  }
  setHeight(height) {
    const { popup } = this.config;
    const eGui = this.element;
    let isPercent = false;
    if (typeof height === "string" && height.indexOf("%") !== -1) {
      setFixedHeight(eGui, height);
      height = getAbsoluteHeight(eGui);
      isPercent = true;
    } else {
      height = Math.max(this.minHeight, height);
      if (this.positioned) {
        const availableHeight = this.getAvailableHeight();
        if (availableHeight && height > availableHeight) {
          height = availableHeight;
        }
      }
    }
    if (this.getHeight() === height) {
      return;
    }
    if (!isPercent) {
      if (popup) {
        setFixedHeight(eGui, height);
      } else {
        eGui.style.height = `${height}px`;
        eGui.style.flex = "0 0 auto";
        this.lastSize.height = typeof height === "number" ? height : parseFloat(height);
      }
    } else {
      eGui.style.maxHeight = "unset";
      eGui.style.minHeight = "unset";
    }
  }
  getAvailableHeight() {
    const { popup, forcePopupParentAsOffsetParent } = this.config;
    if (!this.positioned) {
      this.initialisePosition();
    }
    const { clientHeight } = this.offsetParent;
    if (!clientHeight) {
      return null;
    }
    const elRect = this.element.getBoundingClientRect();
    const offsetParentRect = this.offsetParent.getBoundingClientRect();
    const yPosition = popup ? this.position.y : elRect.top;
    const parentTop = popup ? 0 : offsetParentRect.top;
    let additionalHeight = 0;
    if (forcePopupParentAsOffsetParent) {
      const parentEl = this.element.parentElement;
      if (parentEl) {
        const { bottom } = parentEl.getBoundingClientRect();
        additionalHeight = bottom - elRect.bottom;
      }
    }
    const availableHeight = clientHeight + parentTop - yPosition - additionalHeight;
    return availableHeight;
  }
  getWidth() {
    return this.element.offsetWidth;
  }
  setWidth(width) {
    const eGui = this.element;
    const { popup } = this.config;
    let isPercent = false;
    if (typeof width === "string" && width.indexOf("%") !== -1) {
      setFixedWidth(eGui, width);
      width = getAbsoluteWidth(eGui);
      isPercent = true;
    } else if (this.positioned) {
      width = Math.max(this.minWidth, width);
      const { clientWidth } = this.offsetParent;
      const xPosition = popup ? this.position.x : this.element.getBoundingClientRect().left;
      if (clientWidth && width + xPosition > clientWidth) {
        width = clientWidth - xPosition;
      }
    }
    if (this.getWidth() === width) {
      return;
    }
    if (!isPercent) {
      if (this.config.popup) {
        setFixedWidth(eGui, width);
      } else {
        eGui.style.width = `${width}px`;
        eGui.style.flex = " unset";
        this.lastSize.width = typeof width === "number" ? width : parseFloat(width);
      }
    } else {
      eGui.style.maxWidth = "unset";
      eGui.style.minWidth = "unset";
    }
  }
  offsetElement(x = 0, y = 0) {
    const { forcePopupParentAsOffsetParent } = this.config;
    const ePopup = forcePopupParentAsOffsetParent ? this.boundaryEl : this.element;
    if (!ePopup) {
      return;
    }
    this.popupService.positionPopup({
      ePopup,
      keepWithinBounds: true,
      skipObserver: this.movable || this.isResizable(),
      updatePosition: () => ({ x, y })
    });
    this.setPosition(
      parseFloat(ePopup.style.left),
      parseFloat(ePopup.style.top)
    );
  }
  constrainSizeToAvailableHeight(constrain) {
    if (!this.config.forcePopupParentAsOffsetParent) {
      return;
    }
    const applyMaxHeightToElement = () => {
      const availableHeight = this.getAvailableHeight();
      this.element.style.setProperty("max-height", `${availableHeight}px`);
    };
    if (constrain) {
      this.resizeObserverSubscriber = this.resizeObserverService.observeResize(
        this.popupService.getPopupParent(),
        applyMaxHeightToElement
      );
    } else {
      this.element.style.removeProperty("max-height");
      if (this.resizeObserverSubscriber) {
        this.resizeObserverSubscriber();
        this.resizeObserverSubscriber = void 0;
      }
    }
  }
  setPosition(x, y) {
    this.position.x = x;
    this.position.y = y;
  }
  updateDragStartPosition(x, y) {
    this.dragStartPosition = { x, y };
  }
  calculateMouseMovement(params) {
    const { e, isLeft, isTop, anywhereWithin, topBuffer } = params;
    const xDiff = e.clientX - this.dragStartPosition.x;
    const yDiff = e.clientY - this.dragStartPosition.y;
    const movementX = this.shouldSkipX(e, !!isLeft, !!anywhereWithin, xDiff) ? 0 : xDiff;
    const movementY = this.shouldSkipY(e, !!isTop, topBuffer, yDiff) ? 0 : yDiff;
    return { movementX, movementY };
  }
  shouldSkipX(e, isLeft, anywhereWithin, diff) {
    const elRect = this.element.getBoundingClientRect();
    const parentRect = this.offsetParent.getBoundingClientRect();
    const boundaryElRect = this.boundaryEl.getBoundingClientRect();
    const xPosition = this.config.popup ? this.position.x : elRect.left;
    let skipX = xPosition <= 0 && parentRect.left >= e.clientX || parentRect.right <= e.clientX && parentRect.right <= boundaryElRect.right;
    if (skipX) {
      return true;
    }
    if (isLeft) {
      skipX = // skip if we are moving to the left and the cursor
      // is positioned to the right of the left side anchor
      diff < 0 && e.clientX > xPosition + parentRect.left || // skip if we are moving to the right and the cursor
      // is positioned to the left of the dialog
      diff > 0 && e.clientX < xPosition + parentRect.left;
    } else {
      if (anywhereWithin) {
        skipX = diff < 0 && e.clientX > boundaryElRect.right || diff > 0 && e.clientX < xPosition + parentRect.left;
      } else {
        skipX = // if the movement is bound to the right side of the dialog
        // we skip if we are moving to the left and the cursor
        // is to the right of the dialog
        diff < 0 && e.clientX > boundaryElRect.right || // or skip if we are moving to the right and the cursor
        // is to the left of the right side anchor
        diff > 0 && e.clientX < boundaryElRect.right;
      }
    }
    return skipX;
  }
  shouldSkipY(e, isTop, topBuffer = 0, diff) {
    const elRect = this.element.getBoundingClientRect();
    const parentRect = this.offsetParent.getBoundingClientRect();
    const boundaryElRect = this.boundaryEl.getBoundingClientRect();
    const yPosition = this.config.popup ? this.position.y : elRect.top;
    let skipY = yPosition <= 0 && parentRect.top >= e.clientY || parentRect.bottom <= e.clientY && parentRect.bottom <= boundaryElRect.bottom;
    if (skipY) {
      return true;
    }
    if (isTop) {
      skipY = // skip if we are moving to towards top and the cursor is
      // below the top anchor + topBuffer
      // note: topBuffer is used when moving the dialog using the title bar
      diff < 0 && e.clientY > yPosition + parentRect.top + topBuffer || // skip if we are moving to the bottom and the cursor is
      // above the top anchor
      diff > 0 && e.clientY < yPosition + parentRect.top;
    } else {
      skipY = // skip if we are moving towards the top and the cursor
      // is below the bottom anchor
      diff < 0 && e.clientY > boundaryElRect.bottom || // skip if we are moving towards the bottom and the cursor
      // is above the bottom anchor
      diff > 0 && e.clientY < boundaryElRect.bottom;
    }
    return skipY;
  }
  createResizeMap() {
    const eGui = this.element;
    this.resizerMap = {
      topLeft: { element: eGui.querySelector("[ref=eTopLeftResizer]") },
      top: { element: eGui.querySelector("[ref=eTopResizer]") },
      topRight: { element: eGui.querySelector("[ref=eTopRightResizer]") },
      right: { element: eGui.querySelector("[ref=eRightResizer]") },
      bottomRight: { element: eGui.querySelector("[ref=eBottomRightResizer]") },
      bottom: { element: eGui.querySelector("[ref=eBottomResizer]") },
      bottomLeft: { element: eGui.querySelector("[ref=eBottomLeftResizer]") },
      left: { element: eGui.querySelector("[ref=eLeftResizer]") }
    };
  }
  addResizers() {
    if (this.resizersAdded) {
      return;
    }
    const eGui = this.element;
    if (!eGui) {
      return;
    }
    const parser = new DOMParser();
    const resizers = parser.parseFromString(RESIZE_TEMPLATE, "text/html").body;
    eGui.appendChild(resizers.firstChild);
    this.createResizeMap();
    this.resizersAdded = true;
  }
  removeResizers() {
    this.resizerMap = void 0;
    const resizerEl = this.element.querySelector(`.${RESIZE_CONTAINER_STYLE}`);
    if (resizerEl) {
      this.element.removeChild(resizerEl);
    }
    this.resizersAdded = false;
  }
  getResizerElement(side) {
    return this.resizerMap[side].element;
  }
  onResizeStart(e, side) {
    this.boundaryEl = this.findBoundaryElement();
    if (!this.positioned) {
      this.initialisePosition();
    }
    this.currentResizer = {
      isTop: !!side.match(/top/i),
      isRight: !!side.match(/right/i),
      isBottom: !!side.match(/bottom/i),
      isLeft: !!side.match(/left/i)
    };
    this.element.classList.add("ag-resizing");
    this.resizerMap[side].element.classList.add("ag-active");
    const { popup, forcePopupParentAsOffsetParent } = this.config;
    if (!popup && !forcePopupParentAsOffsetParent) {
      this.applySizeToSiblings(this.currentResizer.isBottom || this.currentResizer.isTop);
    }
    this.isResizing = true;
    this.updateDragStartPosition(e.clientX, e.clientY);
  }
  getSiblings() {
    const element = this.element;
    const parent = element.parentElement;
    if (!parent) {
      return null;
    }
    return Array.prototype.slice.call(parent.children).filter((el) => !el.classList.contains("ag-hidden"));
  }
  getMinSizeOfSiblings() {
    const siblings = this.getSiblings() || [];
    let height = 0;
    let width = 0;
    for (let i = 0; i < siblings.length; i++) {
      const currentEl = siblings[i];
      const isFlex = !!currentEl.style.flex && currentEl.style.flex !== "0 0 auto";
      if (currentEl === this.element) {
        continue;
      }
      let nextHeight = this.minHeight || 0;
      let nextWidth = this.minWidth || 0;
      if (isFlex) {
        const computedStyle = window.getComputedStyle(currentEl);
        if (computedStyle.minHeight) {
          nextHeight = parseInt(computedStyle.minHeight, 10);
        }
        if (computedStyle.minWidth) {
          nextWidth = parseInt(computedStyle.minWidth, 10);
        }
      } else {
        nextHeight = currentEl.offsetHeight;
        nextWidth = currentEl.offsetWidth;
      }
      height += nextHeight;
      width += nextWidth;
    }
    return { height, width };
  }
  applySizeToSiblings(vertical) {
    let containerToFlex = null;
    const siblings = this.getSiblings();
    if (!siblings) {
      return;
    }
    for (let i = 0; i < siblings.length; i++) {
      const el = siblings[i];
      if (el === containerToFlex) {
        continue;
      }
      if (vertical) {
        el.style.height = `${el.offsetHeight}px`;
      } else {
        el.style.width = `${el.offsetWidth}px`;
      }
      el.style.flex = "0 0 auto";
      if (el === this.element) {
        containerToFlex = siblings[i + 1];
      }
    }
    if (containerToFlex) {
      containerToFlex.style.removeProperty("height");
      containerToFlex.style.removeProperty("min-height");
      containerToFlex.style.removeProperty("max-height");
      containerToFlex.style.flex = "1 1 auto";
    }
  }
  isResizable() {
    return Object.values(this.resizable).some((value) => value);
  }
  onResize(e) {
    if (!this.isResizing || !this.currentResizer) {
      return;
    }
    const { popup, forcePopupParentAsOffsetParent } = this.config;
    const { isTop, isRight, isBottom, isLeft } = this.currentResizer;
    const isHorizontal = isRight || isLeft;
    const isVertical = isBottom || isTop;
    const { movementX, movementY } = this.calculateMouseMovement({ e, isLeft, isTop });
    const xPosition = this.position.x;
    const yPosition = this.position.y;
    let offsetLeft = 0;
    let offsetTop = 0;
    if (isHorizontal && movementX) {
      const direction = isLeft ? -1 : 1;
      const oldWidth = this.getWidth();
      const newWidth = oldWidth + movementX * direction;
      let skipWidth = false;
      if (isLeft) {
        offsetLeft = oldWidth - newWidth;
        if (xPosition + offsetLeft <= 0 || newWidth <= this.minWidth) {
          skipWidth = true;
          offsetLeft = 0;
        }
      }
      if (!skipWidth) {
        this.setWidth(newWidth);
      }
    }
    if (isVertical && movementY) {
      const direction = isTop ? -1 : 1;
      const oldHeight = this.getHeight();
      const newHeight = oldHeight + movementY * direction;
      let skipHeight = false;
      if (isTop) {
        offsetTop = oldHeight - newHeight;
        if (yPosition + offsetTop <= 0 || newHeight <= this.minHeight) {
          skipHeight = true;
          offsetTop = 0;
        }
      } else {
        if (!this.config.popup && !this.config.forcePopupParentAsOffsetParent && oldHeight < newHeight && this.getMinSizeOfSiblings().height + newHeight > this.element.parentElement.offsetHeight) {
          skipHeight = true;
        }
      }
      if (!skipHeight) {
        this.setHeight(newHeight);
      }
    }
    this.updateDragStartPosition(e.clientX, e.clientY);
    if ((popup || forcePopupParentAsOffsetParent) && offsetLeft || offsetTop) {
      this.offsetElement(
        xPosition + offsetLeft,
        yPosition + offsetTop
      );
    }
  }
  onResizeEnd(e, side) {
    this.isResizing = false;
    this.currentResizer = null;
    this.boundaryEl = null;
    const params = {
      type: "resize"
    };
    this.element.classList.remove("ag-resizing");
    this.resizerMap[side].element.classList.remove("ag-active");
    this.dispatchEvent(params);
  }
  refreshSize() {
    const eGui = this.element;
    if (this.config.popup) {
      if (!this.config.width) {
        this.setWidth(eGui.offsetWidth);
      }
      if (!this.config.height) {
        this.setHeight(eGui.offsetHeight);
      }
    }
  }
  onMoveStart(e) {
    this.boundaryEl = this.findBoundaryElement();
    if (!this.positioned) {
      this.initialisePosition();
    }
    this.isMoving = true;
    this.element.classList.add("ag-moving");
    this.updateDragStartPosition(e.clientX, e.clientY);
  }
  onMove(e) {
    if (!this.isMoving) {
      return;
    }
    const { x, y } = this.position;
    let topBuffer;
    if (this.config.calculateTopBuffer) {
      topBuffer = this.config.calculateTopBuffer();
    }
    const { movementX, movementY } = this.calculateMouseMovement({
      e,
      isTop: true,
      anywhereWithin: true,
      topBuffer
    });
    this.offsetElement(x + movementX, y + movementY);
    this.updateDragStartPosition(e.clientX, e.clientY);
  }
  onMoveEnd() {
    this.isMoving = false;
    this.boundaryEl = null;
    this.element.classList.remove("ag-moving");
  }
  setOffsetParent() {
    if (this.config.forcePopupParentAsOffsetParent) {
      this.offsetParent = this.popupService.getPopupParent();
    } else {
      this.offsetParent = this.element.offsetParent;
    }
  }
  findBoundaryElement() {
    let el = this.element;
    while (el) {
      if (window.getComputedStyle(el).position !== "static") {
        return el;
      }
      el = el.parentElement;
    }
    return this.element;
  }
  clearResizeListeners() {
    while (this.resizeListeners.length) {
      const params = this.resizeListeners.pop();
      this.dragService.removeDragSource(params);
    }
  }
  destroy() {
    super.destroy();
    if (this.moveElementDragListener) {
      this.dragService.removeDragSource(this.moveElementDragListener);
    }
    this.constrainSizeToAvailableHeight(false);
    this.clearResizeListeners();
    this.removeResizers();
  }
};
__decorateClass([
  Autowired("popupService")
], PositionableFeature.prototype, "popupService", 2);
__decorateClass([
  Autowired("resizeObserverService")
], PositionableFeature.prototype, "resizeObserverService", 2);
__decorateClass([
  Autowired("dragService")
], PositionableFeature.prototype, "dragService", 2);

// community-modules/core/src/filter/provided/providedFilter.ts
var _ProvidedFilter = class _ProvidedFilter extends Component {
  constructor(filterNameKey) {
    super();
    this.filterNameKey = filterNameKey;
    this.applyActive = false;
    this.hidePopup = null;
    this.debouncePending = false;
    // after the user hits 'apply' the model gets copied to here. this is then the model that we use for
    // all filtering. so if user changes UI but doesn't hit apply, then the UI will be out of sync with this model.
    // this is what we want, as the UI should only become the 'active' filter once it's applied. when apply is
    // inactive, this model will be in sync (following the debounce ms). if the UI is not a valid filter
    // (eg the value is missing so nothing to filter on, or for set filter all checkboxes are checked so filter
    // not active) then this appliedModel will be null/undefined.
    this.appliedModel = null;
    this.buttonListeners = [];
  }
  postConstruct() {
    this.resetTemplate();
    this.createManagedBean(new ManagedFocusFeature(
      this.getFocusableElement(),
      {
        handleKeyDown: this.handleKeyDown.bind(this)
      }
    ));
    this.positionableFeature = new PositionableFeature(
      this.getPositionableElement(),
      {
        forcePopupParentAsOffsetParent: true
      }
    );
    this.createBean(this.positionableFeature);
  }
  // override
  handleKeyDown(e) {
  }
  getFilterTitle() {
    return this.translate(this.filterNameKey);
  }
  isFilterActive() {
    return !!this.appliedModel;
  }
  resetTemplate(paramsMap) {
    let eGui = this.getGui();
    if (eGui) {
      eGui.removeEventListener("submit", this.onFormSubmit);
    }
    const templateString = (
      /* html */
      `
            <form class="ag-filter-wrapper">
                <div class="ag-filter-body-wrapper ag-${this.getCssIdentifier()}-body-wrapper" ref="eFilterBody">
                    ${this.createBodyTemplate()}
                </div>
            </form>`
    );
    this.setTemplate(templateString, paramsMap);
    eGui = this.getGui();
    if (eGui) {
      eGui.addEventListener("submit", this.onFormSubmit);
    }
  }
  isReadOnly() {
    return !!this.providedFilterParams.readOnly;
  }
  init(params) {
    this.setParams(params);
    this.resetUiToDefaults(true).then(() => {
      this.updateUiVisibility();
      this.setupOnBtApplyDebounce();
    });
  }
  setParams(params) {
    this.providedFilterParams = params;
    this.applyActive = _ProvidedFilter.isUseApplyButton(params);
    this.resetButtonsPanel();
  }
  updateParams(params) {
    this.providedFilterParams = params;
    this.applyActive = _ProvidedFilter.isUseApplyButton(params);
    this.resetUiToActiveModel(this.getModel(), () => {
      this.updateUiVisibility();
      this.setupOnBtApplyDebounce();
    });
  }
  resetButtonsPanel() {
    const { buttons } = this.providedFilterParams;
    const hasButtons = buttons && buttons.length > 0 && !this.isReadOnly();
    if (!this.eButtonsPanel) {
      if (hasButtons) {
        this.eButtonsPanel = document.createElement("div");
        this.eButtonsPanel.classList.add("ag-filter-apply-panel");
      }
    } else {
      clearElement(this.eButtonsPanel);
      this.buttonListeners.forEach((destroyFunc) => destroyFunc == null ? void 0 : destroyFunc());
      this.buttonListeners = [];
    }
    if (!hasButtons) {
      if (this.eButtonsPanel) {
        removeFromParent(this.eButtonsPanel);
      }
      return;
    }
    const fragment = document.createDocumentFragment();
    const addButton = (type) => {
      let text;
      let clickListener;
      switch (type) {
        case "apply":
          text = this.translate("applyFilter");
          clickListener = (e) => this.onBtApply(false, false, e);
          break;
        case "clear":
          text = this.translate("clearFilter");
          clickListener = () => this.onBtClear();
          break;
        case "reset":
          text = this.translate("resetFilter");
          clickListener = () => this.onBtReset();
          break;
        case "cancel":
          text = this.translate("cancelFilter");
          clickListener = (e) => {
            this.onBtCancel(e);
          };
          break;
        default:
          console.warn("AG Grid: Unknown button type specified");
          return;
      }
      const buttonType = type === "apply" ? "submit" : "button";
      const button = loadTemplate(
        /* html */
        `<button
                    type="${buttonType}"
                    ref="${type}FilterButton"
                    class="ag-button ag-standard-button ag-filter-apply-panel-button"
                >${text}
                </button>`
      );
      this.buttonListeners.push(this.addManagedListener(button, "click", clickListener));
      fragment.append(button);
    };
    convertToSet(buttons).forEach((type) => addButton(type));
    this.eButtonsPanel.append(fragment);
    this.getGui().appendChild(this.eButtonsPanel);
  }
  // subclasses can override this to provide alternative debounce defaults
  getDefaultDebounceMs() {
    return 0;
  }
  setupOnBtApplyDebounce() {
    const debounceMs = _ProvidedFilter.getDebounceMs(this.providedFilterParams, this.getDefaultDebounceMs());
    const debounceFunc = debounce(this.checkApplyDebounce.bind(this), debounceMs);
    this.onBtApplyDebounce = () => {
      this.debouncePending = true;
      debounceFunc();
    };
  }
  checkApplyDebounce() {
    if (this.debouncePending) {
      this.debouncePending = false;
      this.onBtApply();
    }
  }
  getModel() {
    return this.appliedModel ? this.appliedModel : null;
  }
  setModel(model) {
    const promise = model != null ? this.setModelIntoUi(model) : this.resetUiToDefaults();
    return promise.then(() => {
      this.updateUiVisibility();
      this.applyModel("api");
    });
  }
  onBtCancel(e) {
    this.resetUiToActiveModel(this.getModel(), () => {
      this.handleCancelEnd(e);
    });
  }
  handleCancelEnd(e) {
    if (this.providedFilterParams.closeOnApply) {
      this.close(e);
    }
  }
  resetUiToActiveModel(currentModel, afterUiUpdatedFunc) {
    const afterAppliedFunc = () => {
      this.onUiChanged(false, "prevent");
      afterUiUpdatedFunc == null ? void 0 : afterUiUpdatedFunc();
    };
    if (currentModel != null) {
      this.setModelIntoUi(currentModel).then(afterAppliedFunc);
    } else {
      this.resetUiToDefaults().then(afterAppliedFunc);
    }
  }
  onBtClear() {
    this.resetUiToDefaults().then(() => this.onUiChanged());
  }
  onBtReset() {
    this.onBtClear();
    this.onBtApply();
  }
  /**
   * Applies changes made in the UI to the filter, and returns true if the model has changed.
   */
  applyModel(source = "api") {
    const newModel = this.getModelFromUi();
    if (!this.isModelValid(newModel)) {
      return false;
    }
    const previousModel = this.appliedModel;
    this.appliedModel = newModel;
    return !this.areModelsEqual(previousModel, newModel);
  }
  isModelValid(model) {
    return true;
  }
  onFormSubmit(e) {
    e.preventDefault();
  }
  onBtApply(afterFloatingFilter = false, afterDataChange = false, e) {
    if (e) {
      e.preventDefault();
    }
    if (this.applyModel(afterDataChange ? "rowDataUpdated" : "ui")) {
      const source = "columnFilter";
      this.providedFilterParams.filterChangedCallback({ afterFloatingFilter, afterDataChange, source });
    }
    const { closeOnApply } = this.providedFilterParams;
    if (closeOnApply && this.applyActive && !afterFloatingFilter && !afterDataChange) {
      this.close(e);
    }
  }
  onNewRowsLoaded() {
  }
  close(e) {
    if (!this.hidePopup) {
      return;
    }
    const keyboardEvent = e;
    const key = keyboardEvent && keyboardEvent.key;
    let params;
    if (key === "Enter" || key === "Space") {
      params = { keyboardEvent };
    }
    this.hidePopup(params);
    this.hidePopup = null;
  }
  /**
   * By default, if the change came from a floating filter it will be applied immediately, otherwise if there is no
   * apply button it will be applied after a debounce, otherwise it will not be applied at all. This behaviour can
   * be adjusted by using the apply parameter.
   */
  onUiChanged(fromFloatingFilter = false, apply) {
    this.updateUiVisibility();
    this.providedFilterParams.filterModifiedCallback();
    if (this.applyActive && !this.isReadOnly()) {
      const isValid = this.isModelValid(this.getModelFromUi());
      const applyFilterButton = this.getRefElement("applyFilterButton");
      if (applyFilterButton) {
        setDisabled(applyFilterButton, !isValid);
      }
    }
    if (fromFloatingFilter && !apply || apply === "immediately") {
      this.onBtApply(fromFloatingFilter);
    } else if (!this.applyActive && !apply || apply === "debounce") {
      this.onBtApplyDebounce();
    }
  }
  afterGuiAttached(params) {
    if (params) {
      this.hidePopup = params.hidePopup;
    }
    this.refreshFilterResizer(params == null ? void 0 : params.container);
  }
  refreshFilterResizer(containerType) {
    if (!this.positionableFeature || containerType === "toolPanel") {
      return;
    }
    const isResizable = containerType === "floatingFilter" || containerType === "columnFilter";
    const { positionableFeature, gridOptionsService } = this;
    if (isResizable) {
      positionableFeature.restoreLastSize();
      positionableFeature.setResizable(
        gridOptionsService.get("enableRtl") ? { bottom: true, bottomLeft: true, left: true } : { bottom: true, bottomRight: true, right: true }
      );
    } else {
      this.positionableFeature.removeSizeFromEl();
      this.positionableFeature.setResizable(false);
    }
    this.positionableFeature.constrainSizeToAvailableHeight(true);
  }
  afterGuiDetached() {
    this.checkApplyDebounce();
    if (this.positionableFeature) {
      this.positionableFeature.constrainSizeToAvailableHeight(false);
    }
  }
  // static, as used by floating filter also
  static getDebounceMs(params, debounceDefault) {
    if (_ProvidedFilter.isUseApplyButton(params)) {
      if (params.debounceMs != null) {
        console.warn("AG Grid: debounceMs is ignored when apply button is present");
      }
      return 0;
    }
    return params.debounceMs != null ? params.debounceMs : debounceDefault;
  }
  // static, as used by floating filter also
  static isUseApplyButton(params) {
    return !!params.buttons && params.buttons.indexOf("apply") >= 0;
  }
  refresh(newParams) {
    this.providedFilterParams = newParams;
    return true;
  }
  destroy() {
    const eGui = this.getGui();
    if (eGui) {
      eGui.removeEventListener("submit", this.onFormSubmit);
    }
    this.hidePopup = null;
    if (this.positionableFeature) {
      this.positionableFeature = this.destroyBean(this.positionableFeature);
    }
    this.appliedModel = null;
    super.destroy();
  }
  translate(key) {
    const translate = this.localeService.getLocaleTextFunc();
    return translate(key, FILTER_LOCALE_TEXT[key]);
  }
  getCellValue(rowNode) {
    return this.providedFilterParams.getValue(rowNode);
  }
  // override to control positionable feature
  getPositionableElement() {
    return this.eFilterBody;
  }
};
__decorateClass([
  Autowired("rowModel")
], _ProvidedFilter.prototype, "rowModel", 2);
__decorateClass([
  RefSelector("eFilterBody")
], _ProvidedFilter.prototype, "eFilterBody", 2);
__decorateClass([
  PostConstruct
], _ProvidedFilter.prototype, "postConstruct", 1);
var ProvidedFilter = _ProvidedFilter;

// community-modules/core/src/widgets/agAbstractLabel.ts
var AgAbstractLabel = class extends Component {
  constructor(config, template) {
    super(template);
    this.labelSeparator = "";
    this.labelAlignment = "left";
    this.disabled = false;
    this.label = "";
    this.config = config || {};
  }
  postConstruct() {
    this.addCssClass("ag-labeled");
    this.eLabel.classList.add("ag-label");
    const { labelSeparator, label, labelWidth, labelAlignment, disabled } = this.config;
    if (disabled != null) {
      this.setDisabled(disabled);
    }
    if (labelSeparator != null) {
      this.setLabelSeparator(labelSeparator);
    }
    if (label != null) {
      this.setLabel(label);
    }
    if (labelWidth != null) {
      this.setLabelWidth(labelWidth);
    }
    this.setLabelAlignment(labelAlignment || this.labelAlignment);
    this.refreshLabel();
  }
  refreshLabel() {
    clearElement(this.eLabel);
    if (typeof this.label === "string") {
      this.eLabel.innerText = this.label + this.labelSeparator;
    } else if (this.label) {
      this.eLabel.appendChild(this.label);
    }
    if (this.label === "") {
      setDisplayed(this.eLabel, false);
      setAriaRole(this.eLabel, "presentation");
    } else {
      setDisplayed(this.eLabel, true);
      setAriaRole(this.eLabel, null);
    }
  }
  setLabelSeparator(labelSeparator) {
    if (this.labelSeparator === labelSeparator) {
      return this;
    }
    this.labelSeparator = labelSeparator;
    if (this.label != null) {
      this.refreshLabel();
    }
    return this;
  }
  getLabelId() {
    this.eLabel.id = this.eLabel.id || `ag-${this.getCompId()}-label`;
    return this.eLabel.id;
  }
  getLabel() {
    return this.label;
  }
  setLabel(label) {
    if (this.label === label) {
      return this;
    }
    this.label = label;
    this.refreshLabel();
    return this;
  }
  setLabelAlignment(alignment) {
    const eGui = this.getGui();
    const eGuiClassList = eGui.classList;
    eGuiClassList.toggle("ag-label-align-left", alignment === "left");
    eGuiClassList.toggle("ag-label-align-right", alignment === "right");
    eGuiClassList.toggle("ag-label-align-top", alignment === "top");
    return this;
  }
  setLabelEllipsis(hasEllipsis) {
    this.eLabel.classList.toggle("ag-label-ellipsis", hasEllipsis);
    return this;
  }
  setLabelWidth(width) {
    if (this.label == null) {
      return this;
    }
    setElementWidth(this.eLabel, width);
    return this;
  }
  setDisabled(disabled) {
    disabled = !!disabled;
    const element = this.getGui();
    setDisabled(element, disabled);
    element.classList.toggle("ag-disabled", disabled);
    this.disabled = disabled;
    return this;
  }
  isDisabled() {
    return !!this.disabled;
  }
};
__decorateClass([
  PostConstruct
], AgAbstractLabel.prototype, "postConstruct", 1);

// community-modules/core/src/widgets/agAbstractField.ts
var AgAbstractField = class extends AgAbstractLabel {
  constructor(config, template, className) {
    super(config, template);
    this.className = className;
  }
  postConstruct() {
    super.postConstruct();
    const { width, value, onValueChange } = this.config;
    if (width != null) {
      this.setWidth(width);
    }
    if (value != null) {
      this.setValue(value);
    }
    if (onValueChange != null) {
      this.onValueChange(onValueChange);
    }
    if (this.className) {
      this.addCssClass(this.className);
    }
    this.refreshAriaLabelledBy();
  }
  refreshAriaLabelledBy() {
    const ariaEl = this.getAriaElement();
    const labelId = this.getLabelId();
    if (getAriaLabel(ariaEl) !== null) {
      setAriaLabelledBy(ariaEl, "");
    } else {
      setAriaLabelledBy(ariaEl, labelId != null ? labelId : "");
    }
  }
  setAriaLabel(label) {
    setAriaLabel(this.getAriaElement(), label);
    this.refreshAriaLabelledBy();
    return this;
  }
  onValueChange(callbackFn) {
    this.addManagedListener(this, Events.EVENT_FIELD_VALUE_CHANGED, () => callbackFn(this.getValue()));
    return this;
  }
  getWidth() {
    return this.getGui().clientWidth;
  }
  setWidth(width) {
    setFixedWidth(this.getGui(), width);
    return this;
  }
  getPreviousValue() {
    return this.previousValue;
  }
  getValue() {
    return this.value;
  }
  setValue(value, silent) {
    if (this.value === value) {
      return this;
    }
    this.previousValue = this.value;
    this.value = value;
    if (!silent) {
      this.dispatchEvent({ type: Events.EVENT_FIELD_VALUE_CHANGED });
    }
    return this;
  }
};

// community-modules/core/src/widgets/agPickerField.ts
var TEMPLATE = (
  /* html */
  `
    <div class="ag-picker-field" role="presentation">
        <div ref="eLabel"></div>
            <div ref="eWrapper" class="ag-wrapper ag-picker-field-wrapper ag-picker-collapsed">
            <div ref="eDisplayField" class="ag-picker-field-display"></div>
            <div ref="eIcon" class="ag-picker-field-icon" aria-hidden="true"></div>
        </div>
    </div>`
);
var AgPickerField = class extends AgAbstractField {
  constructor(config) {
    super(config, (config == null ? void 0 : config.template) || TEMPLATE, config == null ? void 0 : config.className);
    this.isPickerDisplayed = false;
    this.skipClick = false;
    this.pickerGap = 4;
    this.hideCurrentPicker = null;
    this.ariaRole = config == null ? void 0 : config.ariaRole;
    this.onPickerFocusIn = this.onPickerFocusIn.bind(this);
    this.onPickerFocusOut = this.onPickerFocusOut.bind(this);
    if (!config) {
      return;
    }
    const { pickerGap, maxPickerHeight, variableWidth, minPickerWidth, maxPickerWidth } = config;
    if (pickerGap != null) {
      this.pickerGap = pickerGap;
    }
    this.variableWidth = !!variableWidth;
    if (maxPickerHeight != null) {
      this.setPickerMaxHeight(maxPickerHeight);
    }
    if (minPickerWidth != null) {
      this.setPickerMinWidth(minPickerWidth);
    }
    if (maxPickerWidth != null) {
      this.setPickerMaxWidth(maxPickerWidth);
    }
  }
  postConstruct() {
    super.postConstruct();
    this.setupAria();
    const displayId = `ag-${this.getCompId()}-display`;
    this.eDisplayField.setAttribute("id", displayId);
    const ariaEl = this.getAriaElement();
    this.addManagedListener(ariaEl, "keydown", this.onKeyDown.bind(this));
    this.addManagedListener(this.eLabel, "mousedown", this.onLabelOrWrapperMouseDown.bind(this));
    this.addManagedListener(this.eWrapper, "mousedown", this.onLabelOrWrapperMouseDown.bind(this));
    const { pickerIcon, inputWidth } = this.config;
    if (pickerIcon) {
      const icon = createIconNoSpan(pickerIcon, this.gridOptionsService);
      if (icon) {
        this.eIcon.appendChild(icon);
      }
    }
    if (inputWidth != null) {
      this.setInputWidth(inputWidth);
    }
  }
  setupAria() {
    const ariaEl = this.getAriaElement();
    ariaEl.setAttribute("tabindex", this.gridOptionsService.get("tabIndex").toString());
    setAriaExpanded(ariaEl, false);
    if (this.ariaRole) {
      setAriaRole(ariaEl, this.ariaRole);
    }
  }
  onLabelOrWrapperMouseDown(e) {
    if (e) {
      const focusableEl = this.getFocusableElement();
      if (focusableEl !== this.eWrapper && (e == null ? void 0 : e.target) === focusableEl) {
        return;
      }
      e.preventDefault();
      this.getFocusableElement().focus();
    }
    if (this.skipClick) {
      this.skipClick = false;
      return;
    }
    if (this.isDisabled()) {
      return;
    }
    if (this.isPickerDisplayed) {
      this.hidePicker();
    } else {
      this.showPicker();
    }
  }
  onKeyDown(e) {
    switch (e.key) {
      case KeyCode.UP:
      case KeyCode.DOWN:
      case KeyCode.ENTER:
      case KeyCode.SPACE:
        e.preventDefault();
        this.onLabelOrWrapperMouseDown();
        break;
      case KeyCode.ESCAPE:
        if (this.isPickerDisplayed) {
          e.preventDefault();
          e.stopPropagation();
          if (this.hideCurrentPicker) {
            this.hideCurrentPicker();
          }
        }
        break;
    }
  }
  showPicker() {
    this.isPickerDisplayed = true;
    if (!this.pickerComponent) {
      this.pickerComponent = this.createPickerComponent();
    }
    const pickerGui = this.pickerComponent.getGui();
    pickerGui.addEventListener("focusin", this.onPickerFocusIn);
    pickerGui.addEventListener("focusout", this.onPickerFocusOut);
    this.hideCurrentPicker = this.renderAndPositionPicker();
    this.toggleExpandedStyles(true);
  }
  renderAndPositionPicker() {
    const eDocument = this.gridOptionsService.getDocument();
    const ePicker = this.pickerComponent.getGui();
    if (!this.gridOptionsService.get("suppressScrollWhenPopupsAreOpen")) {
      this.destroyMouseWheelFunc = this.addManagedListener(this.eventService, Events.EVENT_BODY_SCROLL, () => {
        this.hidePicker();
      });
    }
    const translate = this.localeService.getLocaleTextFunc();
    const { pickerAriaLabelKey, pickerAriaLabelValue, modalPicker = true } = this.config;
    const popupParams = {
      modal: modalPicker,
      eChild: ePicker,
      closeOnEsc: true,
      closedCallback: () => {
        const shouldRestoreFocus = eDocument.activeElement === eDocument.body;
        this.beforeHidePicker();
        if (shouldRestoreFocus && this.isAlive()) {
          this.getFocusableElement().focus();
        }
      },
      ariaLabel: translate(pickerAriaLabelKey, pickerAriaLabelValue)
    };
    const addPopupRes = this.popupService.addPopup(popupParams);
    const { maxPickerHeight, minPickerWidth, maxPickerWidth, variableWidth } = this;
    if (variableWidth) {
      if (minPickerWidth) {
        ePicker.style.minWidth = minPickerWidth;
      }
      ePicker.style.width = formatSize(getAbsoluteWidth(this.eWrapper));
      if (maxPickerWidth) {
        ePicker.style.maxWidth = maxPickerWidth;
      }
    } else {
      setElementWidth(ePicker, maxPickerWidth != null ? maxPickerWidth : getAbsoluteWidth(this.eWrapper));
    }
    const maxHeight = maxPickerHeight != null ? maxPickerHeight : `${getInnerHeight(this.popupService.getPopupParent())}px`;
    ePicker.style.setProperty("max-height", maxHeight);
    ePicker.style.position = "absolute";
    this.alignPickerToComponent();
    return addPopupRes.hideFunc;
  }
  alignPickerToComponent() {
    if (!this.pickerComponent) {
      return;
    }
    const { pickerType } = this.config;
    const { pickerGap } = this;
    const alignSide = this.gridOptionsService.get("enableRtl") ? "right" : "left";
    this.popupService.positionPopupByComponent({
      type: pickerType,
      eventSource: this.eWrapper,
      ePopup: this.pickerComponent.getGui(),
      position: "under",
      alignSide,
      keepWithinBounds: true,
      nudgeY: pickerGap
    });
  }
  beforeHidePicker() {
    if (this.destroyMouseWheelFunc) {
      this.destroyMouseWheelFunc();
      this.destroyMouseWheelFunc = void 0;
    }
    this.toggleExpandedStyles(false);
    const pickerGui = this.pickerComponent.getGui();
    pickerGui.removeEventListener("focusin", this.onPickerFocusIn);
    pickerGui.removeEventListener("focusout", this.onPickerFocusOut);
    this.isPickerDisplayed = false;
    this.pickerComponent = void 0;
    this.hideCurrentPicker = null;
  }
  toggleExpandedStyles(expanded) {
    if (!this.isAlive()) {
      return;
    }
    const ariaEl = this.getAriaElement();
    setAriaExpanded(ariaEl, expanded);
    this.eWrapper.classList.toggle("ag-picker-expanded", expanded);
    this.eWrapper.classList.toggle("ag-picker-collapsed", !expanded);
  }
  onPickerFocusIn() {
    this.togglePickerHasFocus(true);
  }
  onPickerFocusOut(e) {
    var _a;
    if (!((_a = this.pickerComponent) == null ? void 0 : _a.getGui().contains(e.relatedTarget))) {
      this.togglePickerHasFocus(false);
    }
  }
  togglePickerHasFocus(focused) {
    if (!this.pickerComponent) {
      return;
    }
    this.eWrapper.classList.toggle("ag-picker-has-focus", focused);
  }
  hidePicker() {
    if (this.hideCurrentPicker) {
      this.hideCurrentPicker();
    }
  }
  setInputWidth(width) {
    setElementWidth(this.eWrapper, width);
    return this;
  }
  getFocusableElement() {
    return this.eWrapper;
  }
  setPickerGap(gap) {
    this.pickerGap = gap;
    return this;
  }
  setPickerMinWidth(width) {
    if (typeof width === "number") {
      width = `${width}px`;
    }
    this.minPickerWidth = width == null ? void 0 : width;
    return this;
  }
  setPickerMaxWidth(width) {
    if (typeof width === "number") {
      width = `${width}px`;
    }
    this.maxPickerWidth = width == null ? void 0 : width;
    return this;
  }
  setPickerMaxHeight(height) {
    if (typeof height === "number") {
      height = `${height}px`;
    }
    this.maxPickerHeight = height == null ? void 0 : height;
    return this;
  }
  destroy() {
    this.hidePicker();
    super.destroy();
  }
};
__decorateClass([
  Autowired("popupService")
], AgPickerField.prototype, "popupService", 2);
__decorateClass([
  RefSelector("eLabel")
], AgPickerField.prototype, "eLabel", 2);
__decorateClass([
  RefSelector("eWrapper")
], AgPickerField.prototype, "eWrapper", 2);
__decorateClass([
  RefSelector("eDisplayField")
], AgPickerField.prototype, "eDisplayField", 2);
__decorateClass([
  RefSelector("eIcon")
], AgPickerField.prototype, "eIcon", 2);

// community-modules/core/src/widgets/agList.ts
var _AgList = class _AgList extends Component {
  constructor(cssIdentifier = "default", unFocusable = false) {
    super(
      /* html */
      `<div class="ag-list ag-${cssIdentifier}-list" role="listbox"></div>`
    );
    this.cssIdentifier = cssIdentifier;
    this.unFocusable = unFocusable;
    this.options = [];
    this.itemEls = [];
  }
  init() {
    const eGui = this.getGui();
    this.addManagedListener(eGui, "mouseleave", () => this.clearHighlighted());
    if (this.unFocusable) {
      return;
    }
    this.addManagedListener(eGui, "keydown", this.handleKeyDown.bind(this));
  }
  handleKeyDown(e) {
    const key = e.key;
    switch (key) {
      case KeyCode.ENTER:
        if (!this.highlightedEl) {
          this.setValue(this.getValue());
        } else {
          const pos = this.itemEls.indexOf(this.highlightedEl);
          this.setValueByIndex(pos);
        }
        break;
      case KeyCode.DOWN:
      case KeyCode.UP:
        const isDown = key === KeyCode.DOWN;
        let itemToHighlight;
        e.preventDefault();
        if (!this.highlightedEl) {
          itemToHighlight = this.itemEls[isDown ? 0 : this.itemEls.length - 1];
        } else {
          const currentIdx = this.itemEls.indexOf(this.highlightedEl);
          let nextPos = currentIdx + (isDown ? 1 : -1);
          nextPos = Math.min(Math.max(nextPos, 0), this.itemEls.length - 1);
          itemToHighlight = this.itemEls[nextPos];
        }
        this.highlightItem(itemToHighlight);
        break;
    }
  }
  addOptions(listOptions) {
    listOptions.forEach((listOption) => this.addOption(listOption));
    return this;
  }
  addOption(listOption) {
    const { value, text } = listOption;
    const valueToRender = text || value;
    this.options.push({ value, text: valueToRender });
    this.renderOption(value, valueToRender);
    this.updateIndices();
    return this;
  }
  clearOptions() {
    this.options = [];
    this.reset(true);
    this.itemEls.forEach((itemEl) => {
      removeFromParent(itemEl);
    });
    this.itemEls = [];
  }
  updateIndices() {
    const options = this.getGui().querySelectorAll(".ag-list-item");
    options.forEach((option, idx) => {
      setAriaPosInSet(option, idx + 1);
      setAriaSetSize(option, options.length);
    });
  }
  renderOption(value, text) {
    const eDocument = this.gridOptionsService.getDocument();
    const itemEl = eDocument.createElement("div");
    setAriaRole(itemEl, "option");
    itemEl.classList.add("ag-list-item", `ag-${this.cssIdentifier}-list-item`);
    const span = eDocument.createElement("span");
    itemEl.appendChild(span);
    span.innerText = text;
    if (!this.unFocusable) {
      itemEl.tabIndex = -1;
    }
    this.itemEls.push(itemEl);
    this.addManagedListener(itemEl, "mousemove", () => this.highlightItem(itemEl));
    this.addManagedListener(itemEl, "mousedown", (e) => {
      e.preventDefault();
      this.setValue(value);
    });
    this.createManagedBean(new TooltipFeature({
      getTooltipValue: () => text,
      getGui: () => itemEl,
      getLocation: () => "UNKNOWN",
      // only show tooltips for items where the text cannot be fully displayed
      shouldDisplayTooltip: () => span.scrollWidth > span.clientWidth
    }));
    this.getGui().appendChild(itemEl);
  }
  setValue(value, silent) {
    if (this.value === value) {
      this.fireItemSelected();
      return this;
    }
    if (value == null) {
      this.reset(silent);
      return this;
    }
    const idx = this.options.findIndex((option) => option.value === value);
    if (idx !== -1) {
      const option = this.options[idx];
      this.value = option.value;
      this.displayValue = option.text;
      this.highlightItem(this.itemEls[idx]);
      if (!silent) {
        this.fireChangeEvent();
      }
    }
    return this;
  }
  setValueByIndex(idx) {
    return this.setValue(this.options[idx].value);
  }
  getValue() {
    return this.value;
  }
  getDisplayValue() {
    return this.displayValue;
  }
  refreshHighlighted() {
    this.clearHighlighted();
    const idx = this.options.findIndex((option) => option.value === this.value);
    if (idx !== -1) {
      this.highlightItem(this.itemEls[idx]);
    }
  }
  reset(silent) {
    this.value = null;
    this.displayValue = null;
    this.clearHighlighted();
    if (!silent) {
      this.fireChangeEvent();
    }
  }
  highlightItem(el) {
    if (!isVisible(el)) {
      return;
    }
    this.clearHighlighted();
    this.highlightedEl = el;
    this.highlightedEl.classList.add(_AgList.ACTIVE_CLASS);
    setAriaSelected(this.highlightedEl, true);
    const eGui = this.getGui();
    const rect = eGui.getBoundingClientRect();
    const currentTop = rect.top + eGui.scrollTop;
    const height = rect.height;
    const { offsetTop, offsetHeight } = el;
    if (offsetTop + offsetHeight > currentTop + height || offsetTop < currentTop) {
      this.highlightedEl.scrollIntoView({ block: "nearest" });
    }
    if (!this.unFocusable) {
      this.highlightedEl.focus();
    }
  }
  clearHighlighted() {
    if (!this.highlightedEl || !isVisible(this.highlightedEl)) {
      return;
    }
    this.highlightedEl.classList.remove(_AgList.ACTIVE_CLASS);
    setAriaSelected(this.highlightedEl, false);
    this.highlightedEl = null;
  }
  fireChangeEvent() {
    this.dispatchEvent({ type: Events.EVENT_FIELD_VALUE_CHANGED });
    this.fireItemSelected();
  }
  fireItemSelected() {
    this.dispatchEvent({ type: _AgList.EVENT_ITEM_SELECTED });
  }
};
_AgList.EVENT_ITEM_SELECTED = "selectedItem";
_AgList.ACTIVE_CLASS = "ag-active-item";
__decorateClass([
  PostConstruct
], _AgList.prototype, "init", 1);
var AgList = _AgList;

// community-modules/core/src/widgets/agSelect.ts
var _AgSelect = class _AgSelect extends AgPickerField {
  constructor(config) {
    super(__spreadValues({
      pickerAriaLabelKey: "ariaLabelSelectField",
      pickerAriaLabelValue: "Select Field",
      pickerType: "ag-list",
      className: "ag-select",
      pickerIcon: "smallDown",
      ariaRole: "combobox"
    }, config));
  }
  postConstruct() {
    super.postConstruct();
    this.createListComponent();
    this.eWrapper.tabIndex = this.gridOptionsService.get("tabIndex");
    const { options, value, placeholder } = this.config;
    if (options != null) {
      this.addOptions(options);
    }
    if (value != null) {
      this.setValue(value, true);
    }
    if (placeholder && value == null) {
      this.eDisplayField.textContent = placeholder;
    }
    this.addManagedListener(this.eWrapper, "focusout", this.onWrapperFocusOut.bind(this));
  }
  onWrapperFocusOut(e) {
    if (!this.eWrapper.contains(e.relatedTarget)) {
      this.hidePicker();
    }
  }
  createListComponent() {
    this.listComponent = this.createBean(new AgList("select", true));
    this.listComponent.setParentComponent(this);
    const eListAriaEl = this.listComponent.getAriaElement();
    const listId = `ag-select-list-${this.listComponent.getCompId()}`;
    eListAriaEl.setAttribute("id", listId);
    setAriaControls(this.getAriaElement(), eListAriaEl);
    this.listComponent.addManagedListener(
      this.listComponent,
      AgList.EVENT_ITEM_SELECTED,
      () => {
        this.hidePicker();
        this.dispatchEvent({ type: _AgSelect.EVENT_ITEM_SELECTED });
      }
    );
    this.listComponent.addManagedListener(
      this.listComponent,
      Events.EVENT_FIELD_VALUE_CHANGED,
      () => {
        if (!this.listComponent) {
          return;
        }
        this.setValue(this.listComponent.getValue(), false, true);
        this.hidePicker();
      }
    );
  }
  createPickerComponent() {
    return this.listComponent;
  }
  onKeyDown(e) {
    var _a;
    const { key } = e;
    if (key === KeyCode.TAB) {
      this.hidePicker();
    } else if (!this.isPickerDisplayed || key !== KeyCode.ENTER && key !== KeyCode.UP && key !== KeyCode.DOWN) {
      super.onKeyDown(e);
    } else {
      (_a = this.listComponent) == null ? void 0 : _a.handleKeyDown(e);
    }
  }
  showPicker() {
    if (!this.listComponent) {
      return;
    }
    super.showPicker();
    this.listComponent.refreshHighlighted();
  }
  addOptions(options) {
    options.forEach((option) => this.addOption(option));
    return this;
  }
  addOption(option) {
    this.listComponent.addOption(option);
    return this;
  }
  clearOptions() {
    var _a;
    (_a = this.listComponent) == null ? void 0 : _a.clearOptions();
    return this;
  }
  setValue(value, silent, fromPicker) {
    if (this.value === value || !this.listComponent) {
      return this;
    }
    if (!fromPicker) {
      this.listComponent.setValue(value, true);
    }
    const newValue = this.listComponent.getValue();
    if (newValue === this.getValue()) {
      return this;
    }
    let displayValue = this.listComponent.getDisplayValue();
    if (displayValue == null && this.config.placeholder) {
      displayValue = this.config.placeholder;
    }
    this.eDisplayField.innerHTML = displayValue;
    this.setTooltip({
      newTooltipText: displayValue != null ? displayValue : null,
      shouldDisplayTooltip: () => this.eDisplayField.scrollWidth > this.eDisplayField.clientWidth
    });
    return super.setValue(value, silent);
  }
  destroy() {
    if (this.listComponent) {
      this.destroyBean(this.listComponent);
      this.listComponent = void 0;
    }
    super.destroy();
  }
};
_AgSelect.EVENT_ITEM_SELECTED = "selectedItem";
var AgSelect = _AgSelect;

// community-modules/core/src/widgets/agAbstractInputField.ts
var AgAbstractInputField = class extends AgAbstractField {
  constructor(config, className, inputType = "text", displayFieldTag = "input") {
    super(
      config,
      /* html */
      `
            <div role="presentation">
                <div ref="eLabel" class="ag-input-field-label"></div>
                <div ref="eWrapper" class="ag-wrapper ag-input-wrapper" role="presentation">
                    <${displayFieldTag} ref="eInput" class="ag-input-field-input"></${displayFieldTag}>
                </div>
            </div>`,
      className
    );
    this.inputType = inputType;
    this.displayFieldTag = displayFieldTag;
  }
  postConstruct() {
    super.postConstruct();
    this.setInputType();
    this.eLabel.classList.add(`${this.className}-label`);
    this.eWrapper.classList.add(`${this.className}-input-wrapper`);
    this.eInput.classList.add(`${this.className}-input`);
    this.addCssClass("ag-input-field");
    this.eInput.id = this.eInput.id || `ag-${this.getCompId()}-input`;
    const { inputName, inputWidth } = this.config;
    if (inputName != null) {
      this.setInputName(inputName);
    }
    if (inputWidth != null) {
      this.setInputWidth(inputWidth);
    }
    this.addInputListeners();
    this.activateTabIndex([this.eInput]);
  }
  addInputListeners() {
    this.addManagedListener(this.eInput, "input", (e) => this.setValue(e.target.value));
  }
  setInputType() {
    if (this.displayFieldTag === "input") {
      this.eInput.setAttribute("type", this.inputType);
    }
  }
  getInputElement() {
    return this.eInput;
  }
  setInputWidth(width) {
    setElementWidth(this.eWrapper, width);
    return this;
  }
  setInputName(name) {
    this.getInputElement().setAttribute("name", name);
    return this;
  }
  getFocusableElement() {
    return this.eInput;
  }
  setMaxLength(length) {
    const eInput = this.eInput;
    eInput.maxLength = length;
    return this;
  }
  setInputPlaceholder(placeholder) {
    addOrRemoveAttribute(this.eInput, "placeholder", placeholder);
    return this;
  }
  setInputAriaLabel(label) {
    setAriaLabel(this.eInput, label);
    this.refreshAriaLabelledBy();
    return this;
  }
  setDisabled(disabled) {
    setDisabled(this.eInput, disabled);
    return super.setDisabled(disabled);
  }
  setAutoComplete(value) {
    if (value === true) {
      addOrRemoveAttribute(this.eInput, "autocomplete", null);
    } else {
      const autoCompleteValue = typeof value === "string" ? value : "off";
      addOrRemoveAttribute(this.eInput, "autocomplete", autoCompleteValue);
    }
    return this;
  }
};
__decorateClass([
  RefSelector("eLabel")
], AgAbstractInputField.prototype, "eLabel", 2);
__decorateClass([
  RefSelector("eWrapper")
], AgAbstractInputField.prototype, "eWrapper", 2);
__decorateClass([
  RefSelector("eInput")
], AgAbstractInputField.prototype, "eInput", 2);

// community-modules/core/src/widgets/agCheckbox.ts
var AgCheckbox = class extends AgAbstractInputField {
  constructor(config, className = "ag-checkbox", inputType = "checkbox") {
    super(config, className, inputType);
    this.labelAlignment = "right";
    this.selected = false;
    this.readOnly = false;
    this.passive = false;
  }
  postConstruct() {
    super.postConstruct();
    const { readOnly, passive } = this.config;
    if (typeof readOnly === "boolean")
      this.setReadOnly(readOnly);
    if (typeof passive === "boolean")
      this.setPassive(passive);
  }
  addInputListeners() {
    this.addManagedListener(this.eInput, "click", this.onCheckboxClick.bind(this));
    this.addManagedListener(this.eLabel, "click", this.toggle.bind(this));
  }
  getNextValue() {
    return this.selected === void 0 ? true : !this.selected;
  }
  setPassive(passive) {
    this.passive = passive;
  }
  isReadOnly() {
    return this.readOnly;
  }
  setReadOnly(readOnly) {
    this.eWrapper.classList.toggle("ag-disabled", readOnly);
    this.eInput.disabled = readOnly;
    this.readOnly = readOnly;
  }
  setDisabled(disabled) {
    this.eWrapper.classList.toggle("ag-disabled", disabled);
    return super.setDisabled(disabled);
  }
  toggle() {
    if (this.eInput.disabled) {
      return;
    }
    const previousValue = this.isSelected();
    const nextValue = this.getNextValue();
    if (this.passive) {
      this.dispatchChange(nextValue, previousValue);
    } else {
      this.setValue(nextValue);
    }
  }
  getValue() {
    return this.isSelected();
  }
  setValue(value, silent) {
    this.refreshSelectedClass(value);
    this.setSelected(value, silent);
    return this;
  }
  setName(name) {
    const input = this.getInputElement();
    input.name = name;
    return this;
  }
  isSelected() {
    return this.selected;
  }
  setSelected(selected, silent) {
    if (this.isSelected() === selected) {
      return;
    }
    this.previousValue = this.isSelected();
    selected = this.selected = typeof selected === "boolean" ? selected : void 0;
    this.eInput.checked = selected;
    this.eInput.indeterminate = selected === void 0;
    if (!silent) {
      this.dispatchChange(this.selected, this.previousValue);
    }
  }
  dispatchChange(selected, previousValue, event) {
    this.dispatchEvent({ type: Events.EVENT_FIELD_VALUE_CHANGED, selected, previousValue, event });
    const input = this.getInputElement();
    const checkboxChangedEvent = {
      type: Events.EVENT_CHECKBOX_CHANGED,
      id: input.id,
      name: input.name,
      selected,
      previousValue
    };
    this.eventService.dispatchEvent(checkboxChangedEvent);
  }
  onCheckboxClick(e) {
    if (this.passive || this.eInput.disabled) {
      return;
    }
    const previousValue = this.isSelected();
    const selected = this.selected = e.target.checked;
    this.refreshSelectedClass(selected);
    this.dispatchChange(selected, previousValue, e);
  }
  refreshSelectedClass(value) {
    this.eWrapper.classList.toggle("ag-checked", value === true);
    this.eWrapper.classList.toggle("ag-indeterminate", value == null);
  }
};

// community-modules/core/src/widgets/agRadioButton.ts
var AgRadioButton = class extends AgCheckbox {
  constructor(config) {
    super(config, "ag-radio-button", "radio");
  }
  isSelected() {
    return this.eInput.checked;
  }
  toggle() {
    if (this.eInput.disabled) {
      return;
    }
    if (!this.isSelected()) {
      this.setValue(true);
    }
  }
  addInputListeners() {
    super.addInputListeners();
    this.addManagedListener(this.eventService, Events.EVENT_CHECKBOX_CHANGED, this.onChange.bind(this));
  }
  /**
   * This ensures that if another radio button in the same named group is selected, we deselect this radio button.
   * By default the browser does this for you, but we are managing classes ourselves in order to ensure input
   * elements are styled correctly in IE11, and the DOM 'changed' event is only fired when a button is selected,
   * not deselected, so we need to use our own event.
   */
  onChange(event) {
    if (event.selected && event.name && this.eInput.name && this.eInput.name === event.name && event.id && this.eInput.id !== event.id) {
      this.setValue(false, true);
    }
  }
};

// community-modules/core/src/filter/provided/simpleFilter.ts
var SimpleFilterModelFormatter = class {
  constructor(localeService, optionsFactory, valueFormatter) {
    this.localeService = localeService;
    this.optionsFactory = optionsFactory;
    this.valueFormatter = valueFormatter;
  }
  // used by:
  // 1) NumberFloatingFilter & TextFloatingFilter: Always, for both when editable and read only.
  // 2) DateFloatingFilter: Only when read only (as we show text rather than a date picker when read only)
  getModelAsString(model) {
    if (!model) {
      return null;
    }
    const isCombined = model.operator != null;
    const translate = this.localeService.getLocaleTextFunc();
    if (isCombined) {
      const combinedModel = model;
      let { conditions } = combinedModel;
      if (!conditions) {
        const { condition1, condition2 } = combinedModel;
        conditions = [condition1, condition2];
      }
      const customOptions = conditions.map((condition) => this.getModelAsString(condition));
      const joinOperatorTranslateKey = combinedModel.operator === "AND" ? "andCondition" : "orCondition";
      return customOptions.join(` ${translate(joinOperatorTranslateKey, FILTER_LOCALE_TEXT[joinOperatorTranslateKey])} `);
    } else if (model.type === SimpleFilter.BLANK || model.type === SimpleFilter.NOT_BLANK) {
      return translate(model.type, model.type);
    } else {
      const condition = model;
      const customOption = this.optionsFactory.getCustomOption(condition.type);
      const { displayKey, displayName, numberOfInputs } = customOption || {};
      if (displayKey && displayName && numberOfInputs === 0) {
        translate(displayKey, displayName);
        return displayName;
      }
      return this.conditionToString(condition, customOption);
    }
  }
  updateParams(params) {
    this.optionsFactory = params.optionsFactory;
  }
  formatValue(value) {
    var _a;
    return this.valueFormatter ? (_a = this.valueFormatter(value != null ? value : null)) != null ? _a : "" : String(value);
  }
};
var _SimpleFilter = class _SimpleFilter extends ProvidedFilter {
  constructor() {
    super(...arguments);
    this.eTypes = [];
    this.eJoinOperatorPanels = [];
    this.eJoinOperatorsAnd = [];
    this.eJoinOperatorsOr = [];
    this.eConditionBodies = [];
    this.listener = () => this.onUiChanged();
    this.lastUiCompletePosition = null;
    this.joinOperatorId = 0;
  }
  getNumberOfInputs(type) {
    const customOpts = this.optionsFactory.getCustomOption(type);
    if (customOpts) {
      const { numberOfInputs } = customOpts;
      return numberOfInputs != null ? numberOfInputs : 1;
    }
    const zeroInputTypes = [
      _SimpleFilter.EMPTY,
      _SimpleFilter.NOT_BLANK,
      _SimpleFilter.BLANK
    ];
    if (type && zeroInputTypes.indexOf(type) >= 0) {
      return 0;
    } else if (type === _SimpleFilter.IN_RANGE) {
      return 2;
    }
    return 1;
  }
  // floating filter calls this when user applies filter from floating filter
  onFloatingFilterChanged(type, value) {
    this.setTypeFromFloatingFilter(type);
    this.setValueFromFloatingFilter(value);
    this.onUiChanged(true);
  }
  setTypeFromFloatingFilter(type) {
    this.eTypes.forEach((eType, position) => {
      if (position === 0) {
        eType.setValue(type, true);
      } else {
        eType.setValue(this.optionsFactory.getDefaultOption(), true);
      }
    });
  }
  getModelFromUi() {
    const conditions = this.getUiCompleteConditions();
    if (conditions.length === 0) {
      return null;
    }
    if (this.maxNumConditions > 1 && conditions.length > 1) {
      return {
        filterType: this.getFilterType(),
        operator: this.getJoinOperator(),
        condition1: conditions[0],
        condition2: conditions[1],
        conditions
      };
    }
    return conditions[0];
  }
  getConditionTypes() {
    return this.eTypes.map((eType) => eType.getValue());
  }
  getConditionType(position) {
    return this.eTypes[position].getValue();
  }
  getJoinOperator() {
    if (this.eJoinOperatorsOr.length === 0) {
      return this.defaultJoinOperator;
    }
    return this.eJoinOperatorsOr[0].getValue() === true ? "OR" : "AND";
  }
  areModelsEqual(a, b) {
    if (!a && !b) {
      return true;
    }
    if (!a && b || a && !b) {
      return false;
    }
    const aIsSimple = !a.operator;
    const bIsSimple = !b.operator;
    const oneSimpleOneCombined = !aIsSimple && bIsSimple || aIsSimple && !bIsSimple;
    if (oneSimpleOneCombined) {
      return false;
    }
    let res;
    if (aIsSimple) {
      const aSimple = a;
      const bSimple = b;
      res = this.areSimpleModelsEqual(aSimple, bSimple);
    } else {
      const aCombined = a;
      const bCombined = b;
      res = aCombined.operator === bCombined.operator && areEqual(aCombined.conditions, bCombined.conditions, (aModel, bModel) => this.areSimpleModelsEqual(aModel, bModel));
    }
    return res;
  }
  shouldRefresh(newParams) {
    var _a, _b, _c;
    const model = this.getModel();
    const conditions = model ? (_a = model.conditions) != null ? _a : [model] : null;
    const newOptionsList = (_c = (_b = newParams.filterOptions) == null ? void 0 : _b.map(
      (option) => typeof option === "string" ? option : option.displayKey
    )) != null ? _c : this.getDefaultFilterOptions();
    const allConditionsExistInNewOptionsList = !conditions || conditions.every((condition) => newOptionsList.find((option) => option === condition.type) !== void 0);
    if (!allConditionsExistInNewOptionsList) {
      return false;
    }
    if (typeof newParams.maxNumConditions === "number" && conditions && conditions.length > newParams.maxNumConditions) {
      return false;
    }
    return true;
  }
  refresh(newParams) {
    if (!this.shouldRefresh(newParams)) {
      return false;
    }
    const parentRefreshed = super.refresh(newParams);
    if (!parentRefreshed) {
      return false;
    }
    this.setParams(newParams);
    this.removeConditionsAndOperators(0);
    this.createOption();
    this.setModel(this.getModel());
    return true;
  }
  setModelIntoUi(model) {
    const isCombined = model.operator;
    if (isCombined) {
      let combinedModel = model;
      if (!combinedModel.conditions) {
        combinedModel.conditions = [
          combinedModel.condition1,
          combinedModel.condition2
        ];
      }
      const numConditions = this.validateAndUpdateConditions(combinedModel.conditions);
      const numPrevConditions = this.getNumConditions();
      if (numConditions < numPrevConditions) {
        this.removeConditionsAndOperators(numConditions);
      } else if (numConditions > numPrevConditions) {
        for (let i = numPrevConditions; i < numConditions; i++) {
          this.createJoinOperatorPanel();
          this.createOption();
        }
      }
      const orChecked = combinedModel.operator === "OR";
      this.eJoinOperatorsAnd.forEach((eJoinOperatorAnd) => eJoinOperatorAnd.setValue(!orChecked, true));
      this.eJoinOperatorsOr.forEach((eJoinOperatorOr) => eJoinOperatorOr.setValue(orChecked, true));
      combinedModel.conditions.forEach((condition, position) => {
        this.eTypes[position].setValue(condition.type, true);
        this.setConditionIntoUi(condition, position);
      });
    } else {
      const simpleModel = model;
      if (this.getNumConditions() > 1) {
        this.removeConditionsAndOperators(1);
      }
      this.eTypes[0].setValue(simpleModel.type, true);
      this.setConditionIntoUi(simpleModel, 0);
    }
    this.lastUiCompletePosition = this.getNumConditions() - 1;
    this.createMissingConditionsAndOperators();
    this.onUiChanged();
    return AgPromise.resolve();
  }
  validateAndUpdateConditions(conditions) {
    let numConditions = conditions.length;
    if (numConditions > this.maxNumConditions) {
      conditions.splice(this.maxNumConditions);
      warnOnce('Filter Model contains more conditions than "filterParams.maxNumConditions". Additional conditions have been ignored.');
      numConditions = this.maxNumConditions;
    }
    return numConditions;
  }
  doesFilterPass(params) {
    var _a;
    const model = this.getModel();
    if (model == null) {
      return true;
    }
    const { operator } = model;
    const models = [];
    if (operator) {
      const combinedModel = model;
      models.push(...(_a = combinedModel.conditions) != null ? _a : []);
    } else {
      models.push(model);
    }
    const combineFunction = operator && operator === "OR" ? "some" : "every";
    return models[combineFunction]((m) => this.individualConditionPasses(params, m));
  }
  setParams(params) {
    super.setParams(params);
    this.setNumConditions(params);
    this.defaultJoinOperator = this.getDefaultJoinOperator(params.defaultJoinOperator);
    this.filterPlaceholder = params.filterPlaceholder;
    this.optionsFactory = new OptionsFactory();
    this.optionsFactory.init(params, this.getDefaultFilterOptions());
    this.createFilterListOptions();
    this.createOption();
    this.createMissingConditionsAndOperators();
    if (this.isReadOnly()) {
      this.eFilterBody.setAttribute("tabindex", "-1");
    }
  }
  setNumConditions(params) {
    var _a, _b;
    if (params.suppressAndOrCondition != null) {
      warnOnce('Since v29.2 "filterParams.suppressAndOrCondition" is deprecated. Use "filterParams.maxNumConditions = 1" instead.');
    }
    if (params.alwaysShowBothConditions != null) {
      warnOnce('Since v29.2 "filterParams.alwaysShowBothConditions" is deprecated. Use "filterParams.numAlwaysVisibleConditions = 2" instead.');
    }
    this.maxNumConditions = (_a = params.maxNumConditions) != null ? _a : params.suppressAndOrCondition ? 1 : 2;
    if (this.maxNumConditions < 1) {
      warnOnce('"filterParams.maxNumConditions" must be greater than or equal to zero.');
      this.maxNumConditions = 1;
    }
    this.numAlwaysVisibleConditions = (_b = params.numAlwaysVisibleConditions) != null ? _b : params.alwaysShowBothConditions ? 2 : 1;
    if (this.numAlwaysVisibleConditions < 1) {
      warnOnce('"filterParams.numAlwaysVisibleConditions" must be greater than or equal to zero.');
      this.numAlwaysVisibleConditions = 1;
    }
    if (this.numAlwaysVisibleConditions > this.maxNumConditions) {
      warnOnce('"filterParams.numAlwaysVisibleConditions" cannot be greater than "filterParams.maxNumConditions".');
      this.numAlwaysVisibleConditions = this.maxNumConditions;
    }
  }
  createOption() {
    const eType = this.createManagedBean(new AgSelect());
    this.eTypes.push(eType);
    eType.addCssClass("ag-filter-select");
    this.eFilterBody.appendChild(eType.getGui());
    const eConditionBody = this.createValueElement();
    this.eConditionBodies.push(eConditionBody);
    this.eFilterBody.appendChild(eConditionBody);
    this.putOptionsIntoDropdown(eType);
    this.resetType(eType);
    const position = this.getNumConditions() - 1;
    this.forEachPositionInput(position, (element) => this.resetInput(element));
    this.addChangedListeners(eType, position);
  }
  createJoinOperatorPanel() {
    const eJoinOperatorPanel = document.createElement("div");
    this.eJoinOperatorPanels.push(eJoinOperatorPanel);
    eJoinOperatorPanel.classList.add("ag-filter-condition");
    const eJoinOperatorAnd = this.createJoinOperator(this.eJoinOperatorsAnd, eJoinOperatorPanel, "and");
    const eJoinOperatorOr = this.createJoinOperator(this.eJoinOperatorsOr, eJoinOperatorPanel, "or");
    this.eFilterBody.appendChild(eJoinOperatorPanel);
    const index = this.eJoinOperatorPanels.length - 1;
    const uniqueGroupId = this.joinOperatorId++;
    this.resetJoinOperatorAnd(eJoinOperatorAnd, index, uniqueGroupId);
    this.resetJoinOperatorOr(eJoinOperatorOr, index, uniqueGroupId);
    if (!this.isReadOnly()) {
      eJoinOperatorAnd.onValueChange(this.listener);
      eJoinOperatorOr.onValueChange(this.listener);
    }
  }
  createJoinOperator(eJoinOperators, eJoinOperatorPanel, andOr) {
    const eJoinOperator = this.createManagedBean(new AgRadioButton());
    eJoinOperators.push(eJoinOperator);
    eJoinOperator.addCssClass("ag-filter-condition-operator");
    eJoinOperator.addCssClass(`ag-filter-condition-operator-${andOr}`);
    eJoinOperatorPanel.appendChild(eJoinOperator.getGui());
    return eJoinOperator;
  }
  getDefaultJoinOperator(defaultJoinOperator) {
    return defaultJoinOperator === "AND" || defaultJoinOperator === "OR" ? defaultJoinOperator : "AND";
  }
  createFilterListOptions() {
    const filterOptions = this.optionsFactory.getFilterOptions();
    this.filterListOptions = filterOptions.map(
      (option) => typeof option === "string" ? this.createBoilerplateListOption(option) : this.createCustomListOption(option)
    );
  }
  putOptionsIntoDropdown(eType) {
    this.filterListOptions.forEach((listOption) => {
      eType.addOption(listOption);
    });
    eType.setDisabled(this.filterListOptions.length <= 1);
  }
  createBoilerplateListOption(option) {
    return { value: option, text: this.translate(option) };
  }
  createCustomListOption(option) {
    const { displayKey } = option;
    const customOption = this.optionsFactory.getCustomOption(option.displayKey);
    return {
      value: displayKey,
      text: customOption ? this.localeService.getLocaleTextFunc()(customOption.displayKey, customOption.displayName) : this.translate(displayKey)
    };
  }
  /**
   * @deprecated As of v29.2 filters can have more than two conditions. Check `colDef.filterParams.maxNumConditions` instead.
   */
  isAllowTwoConditions() {
    return this.maxNumConditions >= 2;
  }
  createBodyTemplate() {
    return "";
  }
  getCssIdentifier() {
    return "simple-filter";
  }
  updateUiVisibility() {
    const joinOperator = this.getJoinOperator();
    this.updateNumConditions();
    this.updateConditionStatusesAndValues(this.lastUiCompletePosition, joinOperator);
  }
  updateNumConditions() {
    var _a;
    let lastUiCompletePosition = -1;
    let areAllConditionsUiComplete = true;
    for (let position = 0; position < this.getNumConditions(); position++) {
      if (this.isConditionUiComplete(position)) {
        lastUiCompletePosition = position;
      } else {
        areAllConditionsUiComplete = false;
      }
    }
    if (this.shouldAddNewConditionAtEnd(areAllConditionsUiComplete)) {
      this.createJoinOperatorPanel();
      this.createOption();
    } else {
      const activePosition = (_a = this.lastUiCompletePosition) != null ? _a : this.getNumConditions() - 2;
      if (lastUiCompletePosition < activePosition) {
        this.removeConditionsAndOperators(activePosition + 1);
        const removeStartPosition = lastUiCompletePosition + 1;
        const numConditionsToRemove = activePosition - removeStartPosition;
        if (numConditionsToRemove > 0) {
          this.removeConditionsAndOperators(removeStartPosition, numConditionsToRemove);
        }
        this.createMissingConditionsAndOperators();
      }
    }
    this.lastUiCompletePosition = lastUiCompletePosition;
  }
  updateConditionStatusesAndValues(lastUiCompletePosition, joinOperator) {
    this.eTypes.forEach((eType, position) => {
      const disabled = this.isConditionDisabled(position, lastUiCompletePosition);
      eType.setDisabled(disabled || this.filterListOptions.length <= 1);
      if (position === 1) {
        setDisabled(this.eJoinOperatorPanels[0], disabled);
        this.eJoinOperatorsAnd[0].setDisabled(disabled);
        this.eJoinOperatorsOr[0].setDisabled(disabled);
      }
    });
    this.eConditionBodies.forEach((element, index) => {
      setDisplayed(element, this.isConditionBodyVisible(index));
    });
    const orChecked = (joinOperator != null ? joinOperator : this.getJoinOperator()) === "OR";
    this.eJoinOperatorsAnd.forEach((eJoinOperatorAnd, index) => {
      eJoinOperatorAnd.setValue(!orChecked, true);
    });
    this.eJoinOperatorsOr.forEach((eJoinOperatorOr, index) => {
      eJoinOperatorOr.setValue(orChecked, true);
    });
    this.forEachInput((element, index, position, numberOfInputs) => {
      this.setElementDisplayed(element, index < numberOfInputs);
      this.setElementDisabled(element, this.isConditionDisabled(position, lastUiCompletePosition));
    });
    this.resetPlaceholder();
  }
  shouldAddNewConditionAtEnd(areAllConditionsUiComplete) {
    return areAllConditionsUiComplete && this.getNumConditions() < this.maxNumConditions && !this.isReadOnly();
  }
  removeConditionsAndOperators(startPosition, deleteCount) {
    if (startPosition >= this.getNumConditions()) {
      return;
    }
    this.removeComponents(this.eTypes, startPosition, deleteCount);
    this.removeElements(this.eConditionBodies, startPosition, deleteCount);
    this.removeValueElements(startPosition, deleteCount);
    const joinOperatorIndex = Math.max(startPosition - 1, 0);
    this.removeElements(this.eJoinOperatorPanels, joinOperatorIndex, deleteCount);
    this.removeComponents(this.eJoinOperatorsAnd, joinOperatorIndex, deleteCount);
    this.removeComponents(this.eJoinOperatorsOr, joinOperatorIndex, deleteCount);
  }
  removeElements(elements, startPosition, deleteCount) {
    const removedElements = this.removeItems(elements, startPosition, deleteCount);
    removedElements.forEach((element) => removeFromParent(element));
  }
  removeComponents(components, startPosition, deleteCount) {
    const removedComponents = this.removeItems(components, startPosition, deleteCount);
    removedComponents.forEach((comp) => {
      removeFromParent(comp.getGui());
      this.destroyBean(comp);
    });
  }
  removeItems(items, startPosition, deleteCount) {
    return deleteCount == null ? items.splice(startPosition) : items.splice(startPosition, deleteCount);
  }
  afterGuiAttached(params) {
    super.afterGuiAttached(params);
    this.resetPlaceholder();
    if (!(params == null ? void 0 : params.suppressFocus)) {
      if (this.isReadOnly()) {
        this.eFilterBody.focus();
      } else {
        const firstInput = this.getInputs(0)[0];
        if (!firstInput) {
          return;
        }
        if (firstInput instanceof AgAbstractInputField) {
          firstInput.getInputElement().focus();
        }
      }
    }
  }
  afterGuiDetached() {
    super.afterGuiDetached();
    const appliedModel = this.getModel();
    this.resetUiToActiveModel(appliedModel);
    let lastUiCompletePosition = -1;
    let updatedLastUiCompletePosition = -1;
    let conditionsRemoved = false;
    const joinOperator = this.getJoinOperator();
    for (let position = this.getNumConditions() - 1; position >= 0; position--) {
      if (this.isConditionUiComplete(position)) {
        if (lastUiCompletePosition === -1) {
          lastUiCompletePosition = position;
          updatedLastUiCompletePosition = position;
        }
      } else {
        const shouldRemovePositionAtEnd = position >= this.numAlwaysVisibleConditions && !this.isConditionUiComplete(position - 1);
        const positionBeforeLastUiCompletePosition = position < lastUiCompletePosition;
        if (shouldRemovePositionAtEnd || positionBeforeLastUiCompletePosition) {
          this.removeConditionsAndOperators(position, 1);
          conditionsRemoved = true;
          if (positionBeforeLastUiCompletePosition) {
            updatedLastUiCompletePosition--;
          }
        }
      }
    }
    let shouldUpdateConditionStatusesAndValues = false;
    if (this.getNumConditions() < this.numAlwaysVisibleConditions) {
      this.createMissingConditionsAndOperators();
      shouldUpdateConditionStatusesAndValues = true;
    }
    if (this.shouldAddNewConditionAtEnd(updatedLastUiCompletePosition === this.getNumConditions() - 1)) {
      this.createJoinOperatorPanel();
      this.createOption();
      shouldUpdateConditionStatusesAndValues = true;
    }
    if (shouldUpdateConditionStatusesAndValues) {
      this.updateConditionStatusesAndValues(updatedLastUiCompletePosition, joinOperator);
    }
    if (conditionsRemoved) {
      this.updateJoinOperatorsDisabled();
    }
    this.lastUiCompletePosition = updatedLastUiCompletePosition;
  }
  getPlaceholderText(defaultPlaceholder, position) {
    let placeholder = this.translate(defaultPlaceholder);
    if (isFunction(this.filterPlaceholder)) {
      const filterPlaceholderFn = this.filterPlaceholder;
      const filterOptionKey = this.eTypes[position].getValue();
      const filterOption = this.translate(filterOptionKey);
      placeholder = filterPlaceholderFn({
        filterOptionKey,
        filterOption,
        placeholder
      });
    } else if (typeof this.filterPlaceholder === "string") {
      placeholder = this.filterPlaceholder;
    }
    return placeholder;
  }
  // allow sub-classes to reset HTML placeholders after UI update.
  resetPlaceholder() {
    const globalTranslate = this.localeService.getLocaleTextFunc();
    this.forEachInput((element, index, position, numberOfInputs) => {
      if (!(element instanceof AgAbstractInputField)) {
        return;
      }
      const placeholder = index === 0 && numberOfInputs > 1 ? "inRangeStart" : index === 0 ? "filterOoo" : "inRangeEnd";
      const ariaLabel = index === 0 && numberOfInputs > 1 ? globalTranslate("ariaFilterFromValue", "Filter from value") : index === 0 ? globalTranslate("ariaFilterValue", "Filter Value") : globalTranslate("ariaFilterToValue", "Filter to Value");
      element.setInputPlaceholder(this.getPlaceholderText(placeholder, position));
      element.setInputAriaLabel(ariaLabel);
    });
  }
  setElementValue(element, value, fromFloatingFilter) {
    if (element instanceof AgAbstractInputField) {
      element.setValue(value != null ? String(value) : null, true);
    }
  }
  setElementDisplayed(element, displayed) {
    if (element instanceof Component) {
      setDisplayed(element.getGui(), displayed);
    }
  }
  setElementDisabled(element, disabled) {
    if (element instanceof Component) {
      setDisabled(element.getGui(), disabled);
    }
  }
  attachElementOnChange(element, listener) {
    if (element instanceof AgAbstractInputField) {
      element.onValueChange(listener);
    }
  }
  forEachInput(cb) {
    this.getConditionTypes().forEach((type, position) => {
      this.forEachPositionTypeInput(position, type, cb);
    });
  }
  forEachPositionInput(position, cb) {
    const type = this.getConditionType(position);
    this.forEachPositionTypeInput(position, type, cb);
  }
  forEachPositionTypeInput(position, type, cb) {
    const numberOfInputs = this.getNumberOfInputs(type);
    const inputs = this.getInputs(position);
    for (let index = 0; index < inputs.length; index++) {
      const input = inputs[index];
      if (input != null) {
        cb(input, index, position, numberOfInputs);
      }
    }
  }
  isConditionDisabled(position, lastUiCompletePosition) {
    if (this.isReadOnly()) {
      return true;
    }
    if (position === 0) {
      return false;
    }
    return position > lastUiCompletePosition + 1;
  }
  isConditionBodyVisible(position) {
    const type = this.getConditionType(position);
    const numberOfInputs = this.getNumberOfInputs(type);
    return numberOfInputs > 0;
  }
  // returns true if the UI represents a working filter, eg all parts are filled out.
  // eg if text filter and textfield blank then returns false.
  isConditionUiComplete(position) {
    if (position >= this.getNumConditions()) {
      return false;
    }
    const type = this.getConditionType(position);
    if (type === _SimpleFilter.EMPTY) {
      return false;
    }
    if (this.getValues(position).some((v) => v == null)) {
      return false;
    }
    return true;
  }
  getNumConditions() {
    return this.eTypes.length;
  }
  getUiCompleteConditions() {
    const conditions = [];
    for (let position = 0; position < this.getNumConditions(); position++) {
      if (this.isConditionUiComplete(position)) {
        conditions.push(this.createCondition(position));
      }
    }
    return conditions;
  }
  createMissingConditionsAndOperators() {
    if (this.isReadOnly()) {
      return;
    }
    for (let i = this.getNumConditions(); i < this.numAlwaysVisibleConditions; i++) {
      this.createJoinOperatorPanel();
      this.createOption();
    }
  }
  resetUiToDefaults(silent) {
    this.removeConditionsAndOperators(this.isReadOnly() ? 1 : this.numAlwaysVisibleConditions);
    this.eTypes.forEach((eType) => this.resetType(eType));
    this.eJoinOperatorsAnd.forEach((eJoinOperatorAnd, index) => this.resetJoinOperatorAnd(eJoinOperatorAnd, index, this.joinOperatorId + index));
    this.eJoinOperatorsOr.forEach((eJoinOperatorOr, index) => this.resetJoinOperatorOr(eJoinOperatorOr, index, this.joinOperatorId + index));
    this.joinOperatorId++;
    this.forEachInput((element) => this.resetInput(element));
    this.resetPlaceholder();
    this.createMissingConditionsAndOperators();
    this.lastUiCompletePosition = null;
    if (!silent) {
      this.onUiChanged();
    }
    return AgPromise.resolve();
  }
  resetType(eType) {
    const translate = this.localeService.getLocaleTextFunc();
    const filteringLabel = translate("ariaFilteringOperator", "Filtering operator");
    eType.setValue(this.optionsFactory.getDefaultOption(), true).setAriaLabel(filteringLabel).setDisabled(this.isReadOnly() || this.filterListOptions.length <= 1);
  }
  resetJoinOperatorAnd(eJoinOperatorAnd, index, uniqueGroupId) {
    this.resetJoinOperator(eJoinOperatorAnd, index, this.isDefaultOperator("AND"), this.translate("andCondition"), uniqueGroupId);
  }
  resetJoinOperatorOr(eJoinOperatorOr, index, uniqueGroupId) {
    this.resetJoinOperator(eJoinOperatorOr, index, this.isDefaultOperator("OR"), this.translate("orCondition"), uniqueGroupId);
  }
  resetJoinOperator(eJoinOperator, index, value, label, uniqueGroupId) {
    this.updateJoinOperatorDisabled(
      eJoinOperator.setValue(value, true).setName(`ag-simple-filter-and-or-${this.getCompId()}-${uniqueGroupId}`).setLabel(label),
      index
    );
  }
  updateJoinOperatorsDisabled() {
    this.eJoinOperatorsAnd.forEach((eJoinOperator, index) => this.updateJoinOperatorDisabled(eJoinOperator, index));
    this.eJoinOperatorsOr.forEach((eJoinOperator, index) => this.updateJoinOperatorDisabled(eJoinOperator, index));
  }
  updateJoinOperatorDisabled(eJoinOperator, index) {
    eJoinOperator.setDisabled(this.isReadOnly() || index > 0);
  }
  resetInput(element) {
    this.setElementValue(element, null);
    this.setElementDisabled(element, this.isReadOnly());
  }
  // puts model values into the UI
  setConditionIntoUi(model, position) {
    const values2 = this.mapValuesFromModel(model);
    this.forEachInput((element, index, elPosition, _2) => {
      if (elPosition !== position) {
        return;
      }
      this.setElementValue(element, values2[index] != null ? values2[index] : null);
    });
  }
  // after floating filter changes, this sets the 'value' section. this is implemented by the base class
  // (as that's where value is controlled), the 'type' part from the floating filter is dealt with in this class.
  setValueFromFloatingFilter(value) {
    this.forEachInput((element, index, position, _2) => {
      this.setElementValue(element, index === 0 && position === 0 ? value : null, true);
    });
  }
  isDefaultOperator(operator) {
    return operator === this.defaultJoinOperator;
  }
  addChangedListeners(eType, position) {
    if (this.isReadOnly()) {
      return;
    }
    eType.onValueChange(this.listener);
    this.forEachPositionInput(position, (element) => {
      this.attachElementOnChange(element, this.listener);
    });
  }
  /** returns true if the row passes the said condition */
  individualConditionPasses(params, filterModel) {
    const cellValue = this.getCellValue(params.node);
    const values2 = this.mapValuesFromModel(filterModel);
    const customFilterOption = this.optionsFactory.getCustomOption(filterModel.type);
    const customFilterResult = this.evaluateCustomFilter(customFilterOption, values2, cellValue);
    if (customFilterResult != null) {
      return customFilterResult;
    }
    if (cellValue == null) {
      return this.evaluateNullValue(filterModel.type);
    }
    return this.evaluateNonNullValue(values2, cellValue, filterModel, params);
  }
  evaluateCustomFilter(customFilterOption, values2, cellValue) {
    if (customFilterOption == null) {
      return;
    }
    const { predicate } = customFilterOption;
    if (predicate != null && !values2.some((v) => v == null)) {
      return predicate(values2, cellValue);
    }
    return;
  }
  isBlank(cellValue) {
    return cellValue == null || typeof cellValue === "string" && cellValue.trim().length === 0;
  }
  hasInvalidInputs() {
    return false;
  }
};
_SimpleFilter.EMPTY = "empty";
_SimpleFilter.BLANK = "blank";
_SimpleFilter.NOT_BLANK = "notBlank";
_SimpleFilter.EQUALS = "equals";
_SimpleFilter.NOT_EQUAL = "notEqual";
_SimpleFilter.LESS_THAN = "lessThan";
_SimpleFilter.LESS_THAN_OR_EQUAL = "lessThanOrEqual";
_SimpleFilter.GREATER_THAN = "greaterThan";
_SimpleFilter.GREATER_THAN_OR_EQUAL = "greaterThanOrEqual";
_SimpleFilter.IN_RANGE = "inRange";
_SimpleFilter.CONTAINS = "contains";
_SimpleFilter.NOT_CONTAINS = "notContains";
_SimpleFilter.STARTS_WITH = "startsWith";
_SimpleFilter.ENDS_WITH = "endsWith";
var SimpleFilter = _SimpleFilter;

// community-modules/core/src/filter/provided/scalarFilter.ts
var ScalarFilter = class _ScalarFilter extends SimpleFilter {
  setParams(params) {
    super.setParams(params);
    this.scalarFilterParams = params;
  }
  evaluateNullValue(filterType) {
    switch (filterType) {
      case _ScalarFilter.EQUALS:
      case _ScalarFilter.NOT_EQUAL:
        if (this.scalarFilterParams.includeBlanksInEquals) {
          return true;
        }
        break;
      case _ScalarFilter.GREATER_THAN:
      case _ScalarFilter.GREATER_THAN_OR_EQUAL:
        if (this.scalarFilterParams.includeBlanksInGreaterThan) {
          return true;
        }
        break;
      case _ScalarFilter.LESS_THAN:
      case _ScalarFilter.LESS_THAN_OR_EQUAL:
        if (this.scalarFilterParams.includeBlanksInLessThan) {
          return true;
        }
        break;
      case _ScalarFilter.IN_RANGE:
        if (this.scalarFilterParams.includeBlanksInRange) {
          return true;
        }
        break;
      case _ScalarFilter.BLANK:
        return true;
      case _ScalarFilter.NOT_BLANK:
        return false;
    }
    return false;
  }
  evaluateNonNullValue(values2, cellValue, filterModel) {
    const comparator = this.comparator();
    const compareResult = values2[0] != null ? comparator(values2[0], cellValue) : 0;
    switch (filterModel.type) {
      case _ScalarFilter.EQUALS:
        return compareResult === 0;
      case _ScalarFilter.NOT_EQUAL:
        return compareResult !== 0;
      case _ScalarFilter.GREATER_THAN:
        return compareResult > 0;
      case _ScalarFilter.GREATER_THAN_OR_EQUAL:
        return compareResult >= 0;
      case _ScalarFilter.LESS_THAN:
        return compareResult < 0;
      case _ScalarFilter.LESS_THAN_OR_EQUAL:
        return compareResult <= 0;
      case _ScalarFilter.IN_RANGE: {
        const compareToResult = comparator(values2[1], cellValue);
        return this.scalarFilterParams.inRangeInclusive ? compareResult >= 0 && compareToResult <= 0 : compareResult > 0 && compareToResult < 0;
      }
      case _ScalarFilter.BLANK:
        return this.isBlank(cellValue);
      case _ScalarFilter.NOT_BLANK:
        return !this.isBlank(cellValue);
      default:
        console.warn('AG Grid: Unexpected type of filter "' + filterModel.type + '", it looks like the filter was configured with incorrect Filter Options');
        return true;
    }
  }
};

// community-modules/core/src/filter/provided/date/dateFilter.ts
var DEFAULT_MIN_YEAR = 1e3;
var DEFAULT_MAX_YEAR = Infinity;
var DateFilterModelFormatter = class extends SimpleFilterModelFormatter {
  constructor(dateFilterParams, localeService, optionsFactory) {
    super(localeService, optionsFactory);
    this.dateFilterParams = dateFilterParams;
  }
  conditionToString(condition, options) {
    const { type } = condition;
    const { numberOfInputs } = options || {};
    const isRange = type == SimpleFilter.IN_RANGE || numberOfInputs === 2;
    const dateFrom = parseDateTimeFromString(condition.dateFrom);
    const dateTo = parseDateTimeFromString(condition.dateTo);
    const format = this.dateFilterParams.inRangeFloatingFilterDateFormat;
    if (isRange) {
      const formattedFrom = dateFrom !== null ? dateToFormattedString(dateFrom, format) : "null";
      const formattedTo = dateTo !== null ? dateToFormattedString(dateTo, format) : "null";
      return `${formattedFrom}-${formattedTo}`;
    }
    if (dateFrom != null) {
      return dateToFormattedString(dateFrom, format);
    }
    return `${type}`;
  }
  updateParams(params) {
    super.updateParams(params);
    this.dateFilterParams = params.dateFilterParams;
  }
};
var _DateFilter = class _DateFilter extends ScalarFilter {
  constructor() {
    super("dateFilter");
    this.eConditionPanelsFrom = [];
    this.eConditionPanelsTo = [];
    this.dateConditionFromComps = [];
    this.dateConditionToComps = [];
    this.minValidYear = DEFAULT_MIN_YEAR;
    this.maxValidYear = DEFAULT_MAX_YEAR;
    this.minValidDate = null;
    this.maxValidDate = null;
  }
  afterGuiAttached(params) {
    super.afterGuiAttached(params);
    this.dateConditionFromComps[0].afterGuiAttached(params);
  }
  mapValuesFromModel(filterModel) {
    const { dateFrom, dateTo, type } = filterModel || {};
    return [
      dateFrom && parseDateTimeFromString(dateFrom) || null,
      dateTo && parseDateTimeFromString(dateTo) || null
    ].slice(0, this.getNumberOfInputs(type));
  }
  comparator() {
    return this.dateFilterParams.comparator ? this.dateFilterParams.comparator : this.defaultComparator.bind(this);
  }
  defaultComparator(filterDate, cellValue) {
    const cellAsDate = cellValue;
    if (cellValue == null || cellAsDate < filterDate) {
      return -1;
    }
    if (cellAsDate > filterDate) {
      return 1;
    }
    return 0;
  }
  setParams(params) {
    this.dateFilterParams = params;
    super.setParams(params);
    const yearParser = (param, fallback) => {
      if (params[param] != null) {
        if (!isNaN(params[param])) {
          return params[param] == null ? fallback : Number(params[param]);
        } else {
          console.warn(`AG Grid: DateFilter ${param} is not a number`);
        }
      }
      return fallback;
    };
    this.minValidYear = yearParser("minValidYear", DEFAULT_MIN_YEAR);
    this.maxValidYear = yearParser("maxValidYear", DEFAULT_MAX_YEAR);
    if (this.minValidYear > this.maxValidYear) {
      console.warn(`AG Grid: DateFilter minValidYear should be <= maxValidYear`);
    }
    if (params.minValidDate) {
      this.minValidDate = params.minValidDate instanceof Date ? params.minValidDate : parseDateTimeFromString(params.minValidDate);
    } else {
      this.minValidDate = null;
    }
    if (params.maxValidDate) {
      this.maxValidDate = params.maxValidDate instanceof Date ? params.maxValidDate : parseDateTimeFromString(params.maxValidDate);
    } else {
      this.maxValidDate = null;
    }
    if (this.minValidDate && this.maxValidDate && this.minValidDate > this.maxValidDate) {
      console.warn(`AG Grid: DateFilter minValidDate should be <= maxValidDate`);
    }
    this.filterModelFormatter = new DateFilterModelFormatter(this.dateFilterParams, this.localeService, this.optionsFactory);
  }
  createDateCompWrapper(element) {
    const dateCompWrapper = new DateCompWrapper(
      this.getContext(),
      this.userComponentFactory,
      {
        onDateChanged: () => this.onUiChanged(),
        filterParams: this.dateFilterParams
      },
      element
    );
    this.addDestroyFunc(() => dateCompWrapper.destroy());
    return dateCompWrapper;
  }
  setElementValue(element, value) {
    element.setDate(value);
  }
  setElementDisplayed(element, displayed) {
    element.setDisplayed(displayed);
  }
  setElementDisabled(element, disabled) {
    element.setDisabled(disabled);
  }
  getDefaultFilterOptions() {
    return _DateFilter.DEFAULT_FILTER_OPTIONS;
  }
  createValueElement() {
    const eCondition = document.createElement("div");
    eCondition.classList.add("ag-filter-body");
    this.createFromToElement(eCondition, this.eConditionPanelsFrom, this.dateConditionFromComps, "from");
    this.createFromToElement(eCondition, this.eConditionPanelsTo, this.dateConditionToComps, "to");
    return eCondition;
  }
  createFromToElement(eCondition, eConditionPanels, dateConditionComps, fromTo) {
    const eConditionPanel = document.createElement("div");
    eConditionPanel.classList.add(`ag-filter-${fromTo}`);
    eConditionPanel.classList.add(`ag-filter-date-${fromTo}`);
    eConditionPanels.push(eConditionPanel);
    eCondition.appendChild(eConditionPanel);
    dateConditionComps.push(this.createDateCompWrapper(eConditionPanel));
  }
  removeValueElements(startPosition, deleteCount) {
    this.removeDateComps(this.dateConditionFromComps, startPosition, deleteCount);
    this.removeDateComps(this.dateConditionToComps, startPosition, deleteCount);
    this.removeItems(this.eConditionPanelsFrom, startPosition, deleteCount);
    this.removeItems(this.eConditionPanelsTo, startPosition, deleteCount);
  }
  removeDateComps(components, startPosition, deleteCount) {
    const removedComponents = this.removeItems(components, startPosition, deleteCount);
    removedComponents.forEach((comp) => comp.destroy());
  }
  isValidDateValue(value) {
    if (value === null) {
      return false;
    }
    if (this.minValidDate) {
      if (value < this.minValidDate) {
        return false;
      }
    } else {
      if (value.getUTCFullYear() < this.minValidYear) {
        return false;
      }
    }
    if (this.maxValidDate) {
      if (value > this.maxValidDate) {
        return false;
      }
    } else {
      if (value.getUTCFullYear() > this.maxValidYear) {
        return false;
      }
    }
    return true;
  }
  isConditionUiComplete(position) {
    if (!super.isConditionUiComplete(position)) {
      return false;
    }
    let valid = true;
    this.forEachInput((element, index, elPosition, numberOfInputs) => {
      if (elPosition !== position || !valid || index >= numberOfInputs) {
        return;
      }
      valid = valid && this.isValidDateValue(element.getDate());
    });
    return valid;
  }
  areSimpleModelsEqual(aSimple, bSimple) {
    return aSimple.dateFrom === bSimple.dateFrom && aSimple.dateTo === bSimple.dateTo && aSimple.type === bSimple.type;
  }
  getFilterType() {
    return "date";
  }
  createCondition(position) {
    const type = this.getConditionType(position);
    const model = {};
    const values2 = this.getValues(position);
    if (values2.length > 0) {
      model.dateFrom = serialiseDate(values2[0]);
    }
    if (values2.length > 1) {
      model.dateTo = serialiseDate(values2[1]);
    }
    return __spreadValues({
      dateFrom: null,
      dateTo: null,
      filterType: this.getFilterType(),
      type
    }, model);
  }
  resetPlaceholder() {
    const globalTranslate = this.localeService.getLocaleTextFunc();
    const placeholder = this.translate("dateFormatOoo");
    const ariaLabel = globalTranslate("ariaFilterValue", "Filter Value");
    this.forEachInput((element) => {
      element.setInputPlaceholder(placeholder);
      element.setInputAriaLabel(ariaLabel);
    });
  }
  getInputs(position) {
    if (position >= this.dateConditionFromComps.length) {
      return [null, null];
    }
    return [this.dateConditionFromComps[position], this.dateConditionToComps[position]];
  }
  getValues(position) {
    const result = [];
    this.forEachPositionInput(position, (element, index, _elPosition, numberOfInputs) => {
      if (index < numberOfInputs) {
        result.push(element.getDate());
      }
    });
    return result;
  }
  translate(key) {
    if (key === ScalarFilter.LESS_THAN) {
      return super.translate("before");
    }
    if (key === ScalarFilter.GREATER_THAN) {
      return super.translate("after");
    }
    return super.translate(key);
  }
  getModelAsString(model) {
    var _a;
    return (_a = this.filterModelFormatter.getModelAsString(model)) != null ? _a : "";
  }
};
_DateFilter.DEFAULT_FILTER_OPTIONS = [
  ScalarFilter.EQUALS,
  ScalarFilter.NOT_EQUAL,
  ScalarFilter.LESS_THAN,
  ScalarFilter.GREATER_THAN,
  ScalarFilter.IN_RANGE,
  ScalarFilter.BLANK,
  ScalarFilter.NOT_BLANK
];
__decorateClass([
  Autowired("userComponentFactory")
], _DateFilter.prototype, "userComponentFactory", 2);
var DateFilter = _DateFilter;

// community-modules/core/src/filter/floating/provided/simpleFloatingFilter.ts
var SimpleFloatingFilter = class extends Component {
  getDefaultDebounceMs() {
    return 0;
  }
  // this is a user component, and IComponent has "public destroy()" as part of the interface.
  // so we need to override destroy() just to make the method public.
  destroy() {
    super.destroy();
  }
  isEventFromFloatingFilter(event) {
    return event && event.afterFloatingFilter;
  }
  isEventFromDataChange(event) {
    return event == null ? void 0 : event.afterDataChange;
  }
  getLastType() {
    return this.lastType;
  }
  isReadOnly() {
    return this.readOnly;
  }
  setLastTypeFromModel(model) {
    if (!model) {
      this.lastType = this.optionsFactory.getDefaultOption();
      return;
    }
    const isCombined = model.operator;
    let condition;
    if (isCombined) {
      const combinedModel = model;
      condition = combinedModel.conditions[0];
    } else {
      condition = model;
    }
    this.lastType = condition.type;
  }
  canWeEditAfterModelFromParentFilter(model) {
    if (!model) {
      return this.isTypeEditable(this.lastType);
    }
    const isCombined = model.operator;
    if (isCombined) {
      return false;
    }
    const simpleModel = model;
    return this.isTypeEditable(simpleModel.type);
  }
  init(params) {
    this.setSimpleParams(params, false);
  }
  setSimpleParams(params, update = true) {
    this.optionsFactory = new OptionsFactory();
    this.optionsFactory.init(params.filterParams, this.getDefaultFilterOptions());
    if (!update) {
      this.lastType = this.optionsFactory.getDefaultOption();
    }
    this.readOnly = !!params.filterParams.readOnly;
    const editable = this.isTypeEditable(this.optionsFactory.getDefaultOption());
    this.setEditable(editable);
  }
  onParamsUpdated(params) {
    this.refresh(params);
  }
  refresh(params) {
    this.setSimpleParams(params);
  }
  doesFilterHaveSingleInput(filterType) {
    const customFilterOption = this.optionsFactory.getCustomOption(filterType);
    const { numberOfInputs } = customFilterOption || {};
    return numberOfInputs == null || numberOfInputs == 1;
  }
  isTypeEditable(type) {
    const uneditableTypes = [
      SimpleFilter.IN_RANGE,
      SimpleFilter.EMPTY,
      SimpleFilter.BLANK,
      SimpleFilter.NOT_BLANK
    ];
    return !!type && !this.isReadOnly() && this.doesFilterHaveSingleInput(type) && uneditableTypes.indexOf(type) < 0;
  }
};

// community-modules/core/src/filter/provided/date/dateFloatingFilter.ts
var DateFloatingFilter = class extends SimpleFloatingFilter {
  constructor() {
    super(
      /* html */
      `
            <div class="ag-floating-filter-input" role="presentation">
                <ag-input-text-field ref="eReadOnlyText"></ag-input-text-field>
                <div ref="eDateWrapper" style="display: flex;"></div>
            </div>`
    );
  }
  getDefaultFilterOptions() {
    return DateFilter.DEFAULT_FILTER_OPTIONS;
  }
  init(params) {
    super.init(params);
    this.params = params;
    this.filterParams = params.filterParams;
    this.createDateComponent();
    this.filterModelFormatter = new DateFilterModelFormatter(this.filterParams, this.localeService, this.optionsFactory);
    const translate = this.localeService.getLocaleTextFunc();
    this.eReadOnlyText.setDisabled(true).setInputAriaLabel(translate("ariaDateFilterInput", "Date Filter Input"));
  }
  onParamsUpdated(params) {
    this.refresh(params);
  }
  refresh(params) {
    super.refresh(params);
    this.params = params;
    this.filterParams = params.filterParams;
    this.updateDateComponent();
    this.filterModelFormatter.updateParams({ optionsFactory: this.optionsFactory, dateFilterParams: this.filterParams });
    this.updateCompOnModelChange(params.currentParentModel());
  }
  updateCompOnModelChange(model) {
    const allowEditing = !this.isReadOnly() && this.canWeEditAfterModelFromParentFilter(model);
    this.setEditable(allowEditing);
    if (allowEditing) {
      if (model) {
        const dateModel = model;
        this.dateComp.setDate(parseDateTimeFromString(dateModel.dateFrom));
      } else {
        this.dateComp.setDate(null);
      }
      this.eReadOnlyText.setValue("");
    } else {
      this.eReadOnlyText.setValue(this.filterModelFormatter.getModelAsString(model));
      this.dateComp.setDate(null);
    }
  }
  setEditable(editable) {
    setDisplayed(this.eDateWrapper, editable);
    setDisplayed(this.eReadOnlyText.getGui(), !editable);
  }
  onParentModelChanged(model, event) {
    if (this.isEventFromFloatingFilter(event) || this.isEventFromDataChange(event)) {
      return;
    }
    super.setLastTypeFromModel(model);
    this.updateCompOnModelChange(model);
  }
  onDateChanged() {
    const filterValueDate = this.dateComp.getDate();
    const filterValueText = serialiseDate(filterValueDate);
    this.params.parentFilterInstance((filterInstance) => {
      if (filterInstance) {
        const date = parseDateTimeFromString(filterValueText);
        filterInstance.onFloatingFilterChanged(this.getLastType() || null, date);
      }
    });
  }
  getDateComponentParams() {
    const debounceMs = ProvidedFilter.getDebounceMs(this.params.filterParams, this.getDefaultDebounceMs());
    return {
      onDateChanged: debounce(this.onDateChanged.bind(this), debounceMs),
      filterParams: this.params.column.getColDef().filterParams
    };
  }
  createDateComponent() {
    this.dateComp = new DateCompWrapper(this.getContext(), this.userComponentFactory, this.getDateComponentParams(), this.eDateWrapper);
    this.addDestroyFunc(() => this.dateComp.destroy());
  }
  updateDateComponent() {
    const params = this.gridOptionsService.addGridCommonParams(this.getDateComponentParams());
    this.dateComp.updateParams(params);
  }
  getFilterModelFormatter() {
    return this.filterModelFormatter;
  }
};
__decorateClass([
  Autowired("userComponentFactory")
], DateFloatingFilter.prototype, "userComponentFactory", 2);
__decorateClass([
  RefSelector("eReadOnlyText")
], DateFloatingFilter.prototype, "eReadOnlyText", 2);
__decorateClass([
  RefSelector("eDateWrapper")
], DateFloatingFilter.prototype, "eDateWrapper", 2);

// community-modules/core/src/filter/provided/date/defaultDateComponent.ts
var DefaultDateComponent = class extends Component {
  constructor() {
    super(
      /* html */
      `
            <div class="ag-filter-filter">
                <ag-input-text-field class="ag-date-filter" ref="eDateInput"></ag-input-text-field>
            </div>`
    );
  }
  // this is a user component, and IComponent has "public destroy()" as part of the interface.
  // so we need to override destroy() just to make the method public.
  destroy() {
    super.destroy();
  }
  init(params) {
    this.params = params;
    this.setParams(params);
    const eDocument = this.gridOptionsService.getDocument();
    const inputElement = this.eDateInput.getInputElement();
    this.addManagedListener(inputElement, "mousedown", () => {
      if (this.eDateInput.isDisabled() || this.usingSafariDatePicker) {
        return;
      }
      inputElement.focus();
    });
    this.addManagedListener(inputElement, "input", (e) => {
      if (e.target !== eDocument.activeElement) {
        return;
      }
      if (this.eDateInput.isDisabled()) {
        return;
      }
      this.params.onDateChanged();
    });
  }
  setParams(params) {
    const inputElement = this.eDateInput.getInputElement();
    const shouldUseBrowserDatePicker = this.shouldUseBrowserDatePicker(params);
    this.usingSafariDatePicker = shouldUseBrowserDatePicker && isBrowserSafari();
    inputElement.type = shouldUseBrowserDatePicker ? "date" : "text";
    const {
      minValidYear,
      maxValidYear,
      minValidDate,
      maxValidDate
    } = params.filterParams || {};
    if (minValidDate && minValidYear) {
      warnOnce("DateFilter should not have both minValidDate and minValidYear parameters set at the same time! minValidYear will be ignored.");
    }
    if (maxValidDate && maxValidYear) {
      warnOnce("DateFilter should not have both maxValidDate and maxValidYear parameters set at the same time! maxValidYear will be ignored.");
    }
    if (minValidDate && maxValidDate) {
      const [parsedMinValidDate, parsedMaxValidDate] = [minValidDate, maxValidDate].map((v) => v instanceof Date ? v : parseDateTimeFromString(v));
      if (parsedMinValidDate && parsedMaxValidDate && parsedMinValidDate.getTime() > parsedMaxValidDate.getTime()) {
        warnOnce("DateFilter parameter minValidDate should always be lower than or equal to parameter maxValidDate.");
      }
    }
    if (minValidDate) {
      if (minValidDate instanceof Date) {
        inputElement.min = dateToFormattedString(minValidDate);
      } else {
        inputElement.min = minValidDate;
      }
    } else {
      if (minValidYear) {
        inputElement.min = `${minValidYear}-01-01`;
      }
    }
    if (maxValidDate) {
      if (maxValidDate instanceof Date) {
        inputElement.max = dateToFormattedString(maxValidDate);
      } else {
        inputElement.max = maxValidDate;
      }
    } else {
      if (maxValidYear) {
        inputElement.max = `${maxValidYear}-12-31`;
      }
    }
  }
  onParamsUpdated(params) {
    this.refresh(params);
  }
  refresh(params) {
    this.params = params;
    this.setParams(params);
  }
  getDate() {
    return parseDateTimeFromString(this.eDateInput.getValue());
  }
  setDate(date) {
    this.eDateInput.setValue(serialiseDate(date, false));
  }
  setInputPlaceholder(placeholder) {
    this.eDateInput.setInputPlaceholder(placeholder);
  }
  setDisabled(disabled) {
    this.eDateInput.setDisabled(disabled);
  }
  afterGuiAttached(params) {
    if (!params || !params.suppressFocus) {
      this.eDateInput.getInputElement().focus();
    }
  }
  shouldUseBrowserDatePicker(params) {
    if (params.filterParams && params.filterParams.browserDatePicker != null) {
      return params.filterParams.browserDatePicker;
    }
    return isBrowserChrome() || isBrowserFirefox() || isBrowserSafari() && getSafariVersion() >= 14.1;
  }
};
__decorateClass([
  RefSelector("eDateInput")
], DefaultDateComponent.prototype, "eDateInput", 2);

// community-modules/core/src/widgets/agInputTextField.ts
var AgInputTextField = class extends AgAbstractInputField {
  constructor(config, className = "ag-text-field", inputType = "text") {
    super(config, className, inputType);
  }
  postConstruct() {
    super.postConstruct();
    if (this.config.allowedCharPattern) {
      this.preventDisallowedCharacters();
    }
  }
  setValue(value, silent) {
    if (this.eInput.value !== value) {
      this.eInput.value = exists(value) ? value : "";
    }
    return super.setValue(value, silent);
  }
  /** Used to set an initial value into the input without necessarily setting `this.value` or triggering events (e.g. to set an invalid value) */
  setStartValue(value) {
    this.setValue(value, true);
  }
  preventDisallowedCharacters() {
    const pattern = new RegExp(`[${this.config.allowedCharPattern}]`);
    const preventCharacters = (event) => {
      if (!isEventFromPrintableCharacter(event)) {
        return;
      }
      if (event.key && !pattern.test(event.key)) {
        event.preventDefault();
      }
    };
    this.addManagedListener(this.eInput, "keydown", preventCharacters);
    this.addManagedListener(this.eInput, "paste", (e) => {
      var _a;
      const text = (_a = e.clipboardData) == null ? void 0 : _a.getData("text");
      if (text && text.split("").some((c) => !pattern.test(c))) {
        e.preventDefault();
      }
    });
  }
};

// community-modules/core/src/widgets/agInputNumberField.ts
var AgInputNumberField = class extends AgInputTextField {
  constructor(config) {
    super(config, "ag-number-field", "number");
  }
  postConstruct() {
    super.postConstruct();
    this.addManagedListener(this.eInput, "blur", () => {
      const floatedValue = parseFloat(this.eInput.value);
      const value = isNaN(floatedValue) ? "" : this.normalizeValue(floatedValue.toString());
      if (this.value !== value) {
        this.setValue(value);
      }
    });
    this.addManagedListener(this.eInput, "wheel", this.onWheel.bind(this));
    this.eInput.step = "any";
    const { precision, min, max, step } = this.config;
    if (typeof precision === "number")
      this.setPrecision(precision);
    if (typeof min === "number")
      this.setMin(min);
    if (typeof max === "number")
      this.setMax(max);
    if (typeof step === "number")
      this.setStep(step);
  }
  onWheel(e) {
    if (document.activeElement === this.eInput) {
      e.preventDefault();
    }
  }
  normalizeValue(value) {
    if (value === "") {
      return "";
    }
    if (this.precision != null) {
      value = this.adjustPrecision(value);
    }
    const val = parseFloat(value);
    if (this.min != null && val < this.min) {
      value = this.min.toString();
    } else if (this.max != null && val > this.max) {
      value = this.max.toString();
    }
    return value;
  }
  adjustPrecision(value, isScientificNotation) {
    if (this.precision == null) {
      return value;
    }
    if (isScientificNotation) {
      const floatString = parseFloat(value).toFixed(this.precision);
      return parseFloat(floatString).toString();
    }
    const parts = String(value).split(".");
    if (parts.length > 1) {
      if (parts[1].length <= this.precision) {
        return value;
      } else if (this.precision > 0) {
        return `${parts[0]}.${parts[1].slice(0, this.precision)}`;
      }
    }
    return parts[0];
  }
  setMin(min) {
    if (this.min === min) {
      return this;
    }
    this.min = min;
    addOrRemoveAttribute(this.eInput, "min", min);
    return this;
  }
  setMax(max) {
    if (this.max === max) {
      return this;
    }
    this.max = max;
    addOrRemoveAttribute(this.eInput, "max", max);
    return this;
  }
  setPrecision(precision) {
    this.precision = precision;
    return this;
  }
  setStep(step) {
    if (this.step === step) {
      return this;
    }
    this.step = step;
    addOrRemoveAttribute(this.eInput, "step", step);
    return this;
  }
  setValue(value, silent) {
    return this.setValueOrInputValue((v) => super.setValue(v, silent), () => this, value);
  }
  setStartValue(value) {
    return this.setValueOrInputValue(
      (v) => super.setValue(v, true),
      (v) => {
        this.eInput.value = v;
      },
      value
    );
  }
  setValueOrInputValue(setValueFunc, setInputValueOnlyFunc, value) {
    if (exists(value)) {
      let setInputValueOnly = this.isScientificNotation(value);
      if (setInputValueOnly && this.eInput.validity.valid) {
        return setValueFunc(value);
      }
      if (!setInputValueOnly) {
        value = this.adjustPrecision(value);
        const normalizedValue = this.normalizeValue(value);
        setInputValueOnly = value != normalizedValue;
      }
      if (setInputValueOnly) {
        return setInputValueOnlyFunc(value);
      }
    }
    return setValueFunc(value);
  }
  getValue() {
    if (!this.eInput.validity.valid) {
      return void 0;
    }
    const inputValue = this.eInput.value;
    if (this.isScientificNotation(inputValue)) {
      return this.adjustPrecision(inputValue, true);
    }
    return super.getValue();
  }
  isScientificNotation(value) {
    return typeof value === "string" && value.includes("e");
  }
};

// community-modules/core/src/filter/provided/number/numberFilter.ts
var NumberFilterModelFormatter = class extends SimpleFilterModelFormatter {
  conditionToString(condition, options) {
    const { numberOfInputs } = options || {};
    const isRange = condition.type == SimpleFilter.IN_RANGE || numberOfInputs === 2;
    if (isRange) {
      return `${this.formatValue(condition.filter)}-${this.formatValue(condition.filterTo)}`;
    }
    if (condition.filter != null) {
      return this.formatValue(condition.filter);
    }
    return `${condition.type}`;
  }
};
function getAllowedCharPattern(filterParams) {
  const { allowedCharPattern } = filterParams != null ? filterParams : {};
  return allowedCharPattern != null ? allowedCharPattern : null;
}
var _NumberFilter = class _NumberFilter extends ScalarFilter {
  constructor() {
    super("numberFilter");
    this.eValuesFrom = [];
    this.eValuesTo = [];
  }
  refresh(params) {
    if (this.numberFilterParams.allowedCharPattern !== params.allowedCharPattern) {
      return false;
    }
    return super.refresh(params);
  }
  mapValuesFromModel(filterModel) {
    const { filter, filterTo, type } = filterModel || {};
    return [
      this.processValue(filter),
      this.processValue(filterTo)
    ].slice(0, this.getNumberOfInputs(type));
  }
  getDefaultDebounceMs() {
    return 500;
  }
  comparator() {
    return (left, right) => {
      if (left === right) {
        return 0;
      }
      return left < right ? 1 : -1;
    };
  }
  setParams(params) {
    this.numberFilterParams = params;
    super.setParams(params);
    this.filterModelFormatter = new NumberFilterModelFormatter(this.localeService, this.optionsFactory, this.numberFilterParams.numberFormatter);
  }
  getDefaultFilterOptions() {
    return _NumberFilter.DEFAULT_FILTER_OPTIONS;
  }
  setElementValue(element, value, fromFloatingFilter) {
    const valueToSet = !fromFloatingFilter && this.numberFilterParams.numberFormatter ? this.numberFilterParams.numberFormatter(value != null ? value : null) : value;
    super.setElementValue(element, valueToSet);
  }
  createValueElement() {
    const allowedCharPattern = getAllowedCharPattern(this.numberFilterParams);
    const eCondition = document.createElement("div");
    eCondition.classList.add("ag-filter-body");
    setAriaRole(eCondition, "presentation");
    this.createFromToElement(eCondition, this.eValuesFrom, "from", allowedCharPattern);
    this.createFromToElement(eCondition, this.eValuesTo, "to", allowedCharPattern);
    return eCondition;
  }
  createFromToElement(eCondition, eValues, fromTo, allowedCharPattern) {
    const eValue = this.createManagedBean(allowedCharPattern ? new AgInputTextField({ allowedCharPattern }) : new AgInputNumberField());
    eValue.addCssClass(`ag-filter-${fromTo}`);
    eValue.addCssClass("ag-filter-filter");
    eValues.push(eValue);
    eCondition.appendChild(eValue.getGui());
  }
  removeValueElements(startPosition, deleteCount) {
    this.removeComponents(this.eValuesFrom, startPosition, deleteCount);
    this.removeComponents(this.eValuesTo, startPosition, deleteCount);
  }
  getValues(position) {
    const result = [];
    this.forEachPositionInput(position, (element, index, _elPosition, numberOfInputs) => {
      if (index < numberOfInputs) {
        result.push(this.processValue(this.stringToFloat(element.getValue())));
      }
    });
    return result;
  }
  areSimpleModelsEqual(aSimple, bSimple) {
    return aSimple.filter === bSimple.filter && aSimple.filterTo === bSimple.filterTo && aSimple.type === bSimple.type;
  }
  getFilterType() {
    return "number";
  }
  processValue(value) {
    if (value == null) {
      return null;
    }
    return isNaN(value) ? null : value;
  }
  stringToFloat(value) {
    if (typeof value === "number") {
      return value;
    }
    let filterText = makeNull(value);
    if (filterText != null && filterText.trim() === "") {
      filterText = null;
    }
    if (this.numberFilterParams.numberParser) {
      return this.numberFilterParams.numberParser(filterText);
    }
    return filterText == null || filterText.trim() === "-" ? null : parseFloat(filterText);
  }
  createCondition(position) {
    const type = this.getConditionType(position);
    const model = {
      filterType: this.getFilterType(),
      type
    };
    const values2 = this.getValues(position);
    if (values2.length > 0) {
      model.filter = values2[0];
    }
    if (values2.length > 1) {
      model.filterTo = values2[1];
    }
    return model;
  }
  getInputs(position) {
    if (position >= this.eValuesFrom.length) {
      return [null, null];
    }
    return [this.eValuesFrom[position], this.eValuesTo[position]];
  }
  getModelAsString(model) {
    var _a;
    return (_a = this.filterModelFormatter.getModelAsString(model)) != null ? _a : "";
  }
  hasInvalidInputs() {
    let invalidInputs = false;
    this.forEachInput((element) => {
      if (!element.getInputElement().validity.valid) {
        invalidInputs = true;
        return;
      }
    });
    return invalidInputs;
  }
};
_NumberFilter.DEFAULT_FILTER_OPTIONS = [
  ScalarFilter.EQUALS,
  ScalarFilter.NOT_EQUAL,
  ScalarFilter.GREATER_THAN,
  ScalarFilter.GREATER_THAN_OR_EQUAL,
  ScalarFilter.LESS_THAN,
  ScalarFilter.LESS_THAN_OR_EQUAL,
  ScalarFilter.IN_RANGE,
  ScalarFilter.BLANK,
  ScalarFilter.NOT_BLANK
];
var NumberFilter = _NumberFilter;

// community-modules/core/src/filter/provided/text/textFilter.ts
var TextFilterModelFormatter = class extends SimpleFilterModelFormatter {
  conditionToString(condition, options) {
    const { numberOfInputs } = options || {};
    const isRange = condition.type == SimpleFilter.IN_RANGE || numberOfInputs === 2;
    if (isRange) {
      return `${condition.filter}-${condition.filterTo}`;
    }
    if (condition.filter != null) {
      return `${condition.filter}`;
    }
    return `${condition.type}`;
  }
};
var _TextFilter = class _TextFilter extends SimpleFilter {
  constructor() {
    super("textFilter");
    this.eValuesFrom = [];
    this.eValuesTo = [];
  }
  static trimInput(value) {
    const trimmedInput = value && value.trim();
    return trimmedInput === "" ? value : trimmedInput;
  }
  getDefaultDebounceMs() {
    return 500;
  }
  setParams(params) {
    this.textFilterParams = params;
    super.setParams(params);
    this.matcher = this.getTextMatcher();
    this.formatter = this.textFilterParams.textFormatter || (this.textFilterParams.caseSensitive ? _TextFilter.DEFAULT_FORMATTER : _TextFilter.DEFAULT_LOWERCASE_FORMATTER);
    this.filterModelFormatter = new TextFilterModelFormatter(this.localeService, this.optionsFactory);
  }
  getTextMatcher() {
    const legacyComparator = this.textFilterParams.textCustomComparator;
    if (legacyComparator) {
      _.warnOnce("textCustomComparator is deprecated, use textMatcher instead.");
      return ({ filterOption, value, filterText }) => legacyComparator(filterOption, value, filterText);
    }
    return this.textFilterParams.textMatcher || _TextFilter.DEFAULT_MATCHER;
  }
  createCondition(position) {
    const type = this.getConditionType(position);
    const model = {
      filterType: this.getFilterType(),
      type
    };
    const values2 = this.getValuesWithSideEffects(position, true);
    if (values2.length > 0) {
      model.filter = values2[0];
    }
    if (values2.length > 1) {
      model.filterTo = values2[1];
    }
    return model;
  }
  getFilterType() {
    return "text";
  }
  areSimpleModelsEqual(aSimple, bSimple) {
    return aSimple.filter === bSimple.filter && aSimple.filterTo === bSimple.filterTo && aSimple.type === bSimple.type;
  }
  getInputs(position) {
    if (position >= this.eValuesFrom.length) {
      return [null, null];
    }
    return [this.eValuesFrom[position], this.eValuesTo[position]];
  }
  getValues(position) {
    return this.getValuesWithSideEffects(position, false);
  }
  getValuesWithSideEffects(position, applySideEffects) {
    const result = [];
    this.forEachPositionInput(position, (element, index, _elPosition, numberOfInputs) => {
      var _a;
      if (index < numberOfInputs) {
        let value = makeNull(element.getValue());
        if (applySideEffects && this.textFilterParams.trimInput) {
          value = (_a = _TextFilter.trimInput(value)) != null ? _a : null;
          element.setValue(value, true);
        }
        result.push(value);
      }
    });
    return result;
  }
  getDefaultFilterOptions() {
    return _TextFilter.DEFAULT_FILTER_OPTIONS;
  }
  createValueElement() {
    const eCondition = document.createElement("div");
    eCondition.classList.add("ag-filter-body");
    setAriaRole(eCondition, "presentation");
    this.createFromToElement(eCondition, this.eValuesFrom, "from");
    this.createFromToElement(eCondition, this.eValuesTo, "to");
    return eCondition;
  }
  createFromToElement(eCondition, eValues, fromTo) {
    const eValue = this.createManagedBean(new AgInputTextField());
    eValue.addCssClass(`ag-filter-${fromTo}`);
    eValue.addCssClass("ag-filter-filter");
    eValues.push(eValue);
    eCondition.appendChild(eValue.getGui());
  }
  removeValueElements(startPosition, deleteCount) {
    this.removeComponents(this.eValuesFrom, startPosition, deleteCount);
    this.removeComponents(this.eValuesTo, startPosition, deleteCount);
  }
  mapValuesFromModel(filterModel) {
    const { filter, filterTo, type } = filterModel || {};
    return [
      filter || null,
      filterTo || null
    ].slice(0, this.getNumberOfInputs(type));
  }
  evaluateNullValue(filterType) {
    const filterTypesAllowNulls = [
      SimpleFilter.NOT_EQUAL,
      SimpleFilter.NOT_CONTAINS,
      SimpleFilter.BLANK
    ];
    return filterType ? filterTypesAllowNulls.indexOf(filterType) >= 0 : false;
  }
  evaluateNonNullValue(values2, cellValue, filterModel, params) {
    const formattedValues = values2.map((v) => this.formatter(v)) || [];
    const cellValueFormatted = this.formatter(cellValue);
    const { api, colDef, column, columnApi, context, textFormatter } = this.textFilterParams;
    if (filterModel.type === SimpleFilter.BLANK) {
      return this.isBlank(cellValue);
    } else if (filterModel.type === SimpleFilter.NOT_BLANK) {
      return !this.isBlank(cellValue);
    }
    const matcherParams = {
      api,
      colDef,
      column,
      columnApi,
      context,
      node: params.node,
      data: params.data,
      filterOption: filterModel.type,
      value: cellValueFormatted,
      textFormatter
    };
    return formattedValues.some((v) => this.matcher(__spreadProps(__spreadValues({}, matcherParams), { filterText: v })));
  }
  getModelAsString(model) {
    var _a;
    return (_a = this.filterModelFormatter.getModelAsString(model)) != null ? _a : "";
  }
};
_TextFilter.DEFAULT_FILTER_OPTIONS = [
  SimpleFilter.CONTAINS,
  SimpleFilter.NOT_CONTAINS,
  SimpleFilter.EQUALS,
  SimpleFilter.NOT_EQUAL,
  SimpleFilter.STARTS_WITH,
  SimpleFilter.ENDS_WITH,
  SimpleFilter.BLANK,
  SimpleFilter.NOT_BLANK
];
_TextFilter.DEFAULT_FORMATTER = (from) => from;
_TextFilter.DEFAULT_LOWERCASE_FORMATTER = (from) => from == null ? null : from.toString().toLowerCase();
_TextFilter.DEFAULT_MATCHER = ({ filterOption, value, filterText }) => {
  if (filterText == null) {
    return false;
  }
  switch (filterOption) {
    case _TextFilter.CONTAINS:
      return value.indexOf(filterText) >= 0;
    case _TextFilter.NOT_CONTAINS:
      return value.indexOf(filterText) < 0;
    case _TextFilter.EQUALS:
      return value === filterText;
    case _TextFilter.NOT_EQUAL:
      return value != filterText;
    case _TextFilter.STARTS_WITH:
      return value.indexOf(filterText) === 0;
    case _TextFilter.ENDS_WITH:
      const index = value.lastIndexOf(filterText);
      return index >= 0 && index === value.length - filterText.length;
    default:
      return false;
  }
};
var TextFilter = _TextFilter;

// community-modules/core/src/filter/floating/provided/textInputFloatingFilter.ts
var FloatingFilterTextInputService = class extends BeanStub {
  constructor(params) {
    super();
    this.params = params;
    this.valueChangedListener = () => {
    };
  }
  setupGui(parentElement) {
    var _a;
    this.eFloatingFilterTextInput = this.createManagedBean(new AgInputTextField((_a = this.params) == null ? void 0 : _a.config));
    const eInput = this.eFloatingFilterTextInput.getGui();
    parentElement.appendChild(eInput);
    this.addManagedListener(eInput, "input", (e) => this.valueChangedListener(e));
    this.addManagedListener(eInput, "keydown", (e) => this.valueChangedListener(e));
  }
  setEditable(editable) {
    this.eFloatingFilterTextInput.setDisabled(!editable);
  }
  setAutoComplete(autoComplete) {
    this.eFloatingFilterTextInput.setAutoComplete(autoComplete);
  }
  getValue() {
    return this.eFloatingFilterTextInput.getValue();
  }
  setValue(value, silent) {
    this.eFloatingFilterTextInput.setValue(value, silent);
  }
  setValueChangedListener(listener) {
    this.valueChangedListener = listener;
  }
  setParams(params) {
    this.setAriaLabel(params.ariaLabel);
    if (params.autoComplete !== void 0) {
      this.setAutoComplete(params.autoComplete);
    }
  }
  setAriaLabel(ariaLabel) {
    this.eFloatingFilterTextInput.setInputAriaLabel(ariaLabel);
  }
};
var TextInputFloatingFilter = class extends SimpleFloatingFilter {
  postConstruct() {
    this.setTemplate(
      /* html */
      `
            <div class="ag-floating-filter-input" role="presentation" ref="eFloatingFilterInputContainer"></div>
        `
    );
  }
  getDefaultDebounceMs() {
    return 500;
  }
  onParentModelChanged(model, event) {
    if (this.isEventFromFloatingFilter(event) || this.isEventFromDataChange(event)) {
      return;
    }
    this.setLastTypeFromModel(model);
    this.setEditable(this.canWeEditAfterModelFromParentFilter(model));
    this.floatingFilterInputService.setValue(this.getFilterModelFormatter().getModelAsString(model));
  }
  init(params) {
    this.setupFloatingFilterInputService(params);
    super.init(params);
    this.setTextInputParams(params);
  }
  setupFloatingFilterInputService(params) {
    this.floatingFilterInputService = this.createFloatingFilterInputService(params);
    this.floatingFilterInputService.setupGui(this.eFloatingFilterInputContainer);
  }
  setTextInputParams(params) {
    var _a;
    this.params = params;
    const autoComplete = (_a = params.browserAutoComplete) != null ? _a : false;
    this.floatingFilterInputService.setParams({
      ariaLabel: this.getAriaLabel(params),
      autoComplete
    });
    this.applyActive = ProvidedFilter.isUseApplyButton(this.params.filterParams);
    if (!this.isReadOnly()) {
      const debounceMs = ProvidedFilter.getDebounceMs(this.params.filterParams, this.getDefaultDebounceMs());
      const toDebounce = debounce(this.syncUpWithParentFilter.bind(this), debounceMs);
      this.floatingFilterInputService.setValueChangedListener(toDebounce);
    }
  }
  onParamsUpdated(params) {
    this.refresh(params);
  }
  refresh(params) {
    super.refresh(params);
    this.setTextInputParams(params);
  }
  recreateFloatingFilterInputService(params) {
    const value = this.floatingFilterInputService.getValue();
    clearElement(this.eFloatingFilterInputContainer);
    this.destroyBean(this.floatingFilterInputService);
    this.setupFloatingFilterInputService(params);
    this.floatingFilterInputService.setValue(value, true);
  }
  getAriaLabel(params) {
    const displayName = this.columnModel.getDisplayNameForColumn(params.column, "header", true);
    const translate = this.localeService.getLocaleTextFunc();
    return `${displayName} ${translate("ariaFilterInput", "Filter Input")}`;
  }
  syncUpWithParentFilter(e) {
    const isEnterKey = e.key === KeyCode.ENTER;
    if (this.applyActive && !isEnterKey) {
      return;
    }
    let value = this.floatingFilterInputService.getValue();
    if (this.params.filterParams.trimInput) {
      value = TextFilter.trimInput(value);
      this.floatingFilterInputService.setValue(value, true);
    }
    this.params.parentFilterInstance((filterInstance) => {
      if (filterInstance) {
        filterInstance.onFloatingFilterChanged(this.getLastType() || null, value || null);
      }
    });
  }
  setEditable(editable) {
    this.floatingFilterInputService.setEditable(editable);
  }
};
__decorateClass([
  Autowired("columnModel")
], TextInputFloatingFilter.prototype, "columnModel", 2);
__decorateClass([
  RefSelector("eFloatingFilterInputContainer")
], TextInputFloatingFilter.prototype, "eFloatingFilterInputContainer", 2);
__decorateClass([
  PostConstruct
], TextInputFloatingFilter.prototype, "postConstruct", 1);

// community-modules/core/src/filter/provided/number/numberFloatingFilter.ts
var FloatingFilterNumberInputService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.valueChangedListener = () => {
    };
    this.numberInputActive = true;
  }
  setupGui(parentElement) {
    this.eFloatingFilterNumberInput = this.createManagedBean(new AgInputNumberField());
    this.eFloatingFilterTextInput = this.createManagedBean(new AgInputTextField());
    this.eFloatingFilterTextInput.setDisabled(true);
    const eNumberInput = this.eFloatingFilterNumberInput.getGui();
    const eTextInput = this.eFloatingFilterTextInput.getGui();
    parentElement.appendChild(eNumberInput);
    parentElement.appendChild(eTextInput);
    this.setupListeners(eNumberInput, (e) => this.valueChangedListener(e));
    this.setupListeners(eTextInput, (e) => this.valueChangedListener(e));
  }
  setEditable(editable) {
    this.numberInputActive = editable;
    this.eFloatingFilterNumberInput.setDisplayed(this.numberInputActive);
    this.eFloatingFilterTextInput.setDisplayed(!this.numberInputActive);
  }
  setAutoComplete(autoComplete) {
    this.eFloatingFilterNumberInput.setAutoComplete(autoComplete);
    this.eFloatingFilterTextInput.setAutoComplete(autoComplete);
  }
  getValue() {
    return this.getActiveInputElement().getValue();
  }
  setValue(value, silent) {
    this.getActiveInputElement().setValue(value, silent);
  }
  getActiveInputElement() {
    return this.numberInputActive ? this.eFloatingFilterNumberInput : this.eFloatingFilterTextInput;
  }
  setValueChangedListener(listener) {
    this.valueChangedListener = listener;
  }
  setupListeners(element, listener) {
    this.addManagedListener(element, "input", listener);
    this.addManagedListener(element, "keydown", listener);
  }
  setParams(params) {
    this.setAriaLabel(params.ariaLabel);
    if (params.autoComplete !== void 0) {
      this.setAutoComplete(params.autoComplete);
    }
  }
  setAriaLabel(ariaLabel) {
    this.eFloatingFilterNumberInput.setInputAriaLabel(ariaLabel);
    this.eFloatingFilterTextInput.setInputAriaLabel(ariaLabel);
  }
};
var NumberFloatingFilter = class extends TextInputFloatingFilter {
  init(params) {
    var _a;
    super.init(params);
    this.filterModelFormatter = new NumberFilterModelFormatter(
      this.localeService,
      this.optionsFactory,
      (_a = params.filterParams) == null ? void 0 : _a.numberFormatter
    );
  }
  onParamsUpdated(params) {
    this.refresh(params);
  }
  refresh(params) {
    const allowedCharPattern = getAllowedCharPattern(params.filterParams);
    if (allowedCharPattern !== this.allowedCharPattern) {
      this.recreateFloatingFilterInputService(params);
    }
    super.refresh(params);
    this.filterModelFormatter.updateParams({ optionsFactory: this.optionsFactory });
  }
  getDefaultFilterOptions() {
    return NumberFilter.DEFAULT_FILTER_OPTIONS;
  }
  getFilterModelFormatter() {
    return this.filterModelFormatter;
  }
  createFloatingFilterInputService(params) {
    this.allowedCharPattern = getAllowedCharPattern(params.filterParams);
    if (this.allowedCharPattern) {
      return this.createManagedBean(new FloatingFilterTextInputService({
        config: { allowedCharPattern: this.allowedCharPattern }
      }));
    }
    return this.createManagedBean(new FloatingFilterNumberInputService());
  }
};

// community-modules/core/src/filter/provided/text/textFloatingFilter.ts
var TextFloatingFilter = class extends TextInputFloatingFilter {
  init(params) {
    super.init(params);
    this.filterModelFormatter = new TextFilterModelFormatter(this.localeService, this.optionsFactory);
  }
  onParamsUpdated(params) {
    this.refresh(params);
  }
  refresh(params) {
    super.refresh(params);
    this.filterModelFormatter.updateParams({ optionsFactory: this.optionsFactory });
  }
  getDefaultFilterOptions() {
    return TextFilter.DEFAULT_FILTER_OPTIONS;
  }
  getFilterModelFormatter() {
    return this.filterModelFormatter;
  }
  createFloatingFilterInputService() {
    return this.createManagedBean(new FloatingFilterTextInputService());
  }
};

// community-modules/core/src/widgets/touchListener.ts
var _TouchListener = class _TouchListener {
  constructor(eElement, preventMouseClick = false) {
    this.destroyFuncs = [];
    this.touching = false;
    this.eventService = new EventService();
    this.eElement = eElement;
    this.preventMouseClick = preventMouseClick;
    const startListener = this.onTouchStart.bind(this);
    const moveListener = this.onTouchMove.bind(this);
    const endListener = this.onTouchEnd.bind(this);
    this.eElement.addEventListener("touchstart", startListener, { passive: true });
    this.eElement.addEventListener("touchmove", moveListener, { passive: true });
    this.eElement.addEventListener("touchend", endListener, { passive: false });
    this.destroyFuncs.push(() => {
      this.eElement.removeEventListener("touchstart", startListener, { passive: true });
      this.eElement.removeEventListener("touchmove", moveListener, { passive: true });
      this.eElement.removeEventListener("touchend", endListener, { passive: false });
    });
  }
  getActiveTouch(touchList) {
    for (let i = 0; i < touchList.length; i++) {
      const matches = touchList[i].identifier === this.touchStart.identifier;
      if (matches) {
        return touchList[i];
      }
    }
    return null;
  }
  addEventListener(eventType, listener) {
    this.eventService.addEventListener(eventType, listener);
  }
  removeEventListener(eventType, listener) {
    this.eventService.removeEventListener(eventType, listener);
  }
  onTouchStart(touchEvent) {
    if (this.touching) {
      return;
    }
    this.touchStart = touchEvent.touches[0];
    this.touching = true;
    this.moved = false;
    const touchStartCopy = this.touchStart;
    window.setTimeout(() => {
      const touchesMatch = this.touchStart === touchStartCopy;
      if (this.touching && touchesMatch && !this.moved) {
        this.moved = true;
        const event = {
          type: _TouchListener.EVENT_LONG_TAP,
          touchStart: this.touchStart,
          touchEvent
        };
        this.eventService.dispatchEvent(event);
      }
    }, 500);
  }
  onTouchMove(touchEvent) {
    if (!this.touching) {
      return;
    }
    const touch = this.getActiveTouch(touchEvent.touches);
    if (!touch) {
      return;
    }
    const eventIsFarAway = !areEventsNear(touch, this.touchStart, 4);
    if (eventIsFarAway) {
      this.moved = true;
    }
  }
  onTouchEnd(touchEvent) {
    if (!this.touching) {
      return;
    }
    if (!this.moved) {
      const event = {
        type: _TouchListener.EVENT_TAP,
        touchStart: this.touchStart
      };
      this.eventService.dispatchEvent(event);
      this.checkForDoubleTap();
    }
    if (this.preventMouseClick && touchEvent.cancelable) {
      touchEvent.preventDefault();
    }
    this.touching = false;
  }
  checkForDoubleTap() {
    const now = (/* @__PURE__ */ new Date()).getTime();
    if (this.lastTapTime && this.lastTapTime > 0) {
      const interval = now - this.lastTapTime;
      if (interval > _TouchListener.DOUBLE_TAP_MILLIS) {
        const event = {
          type: _TouchListener.EVENT_DOUBLE_TAP,
          touchStart: this.touchStart
        };
        this.eventService.dispatchEvent(event);
        this.lastTapTime = null;
      } else {
        this.lastTapTime = now;
      }
    } else {
      this.lastTapTime = now;
    }
  }
  destroy() {
    this.destroyFuncs.forEach((func) => func());
  }
};
_TouchListener.EVENT_TAP = "tap";
_TouchListener.EVENT_DOUBLE_TAP = "doubleTap";
_TouchListener.EVENT_LONG_TAP = "longTap";
_TouchListener.DOUBLE_TAP_MILLIS = 500;
var TouchListener = _TouchListener;

// community-modules/core/src/headerRendering/cells/column/sortIndicatorComp.ts
var _SortIndicatorComp = class _SortIndicatorComp extends Component {
  constructor(skipTemplate) {
    super();
    if (!skipTemplate) {
      this.setTemplate(_SortIndicatorComp.TEMPLATE);
    }
  }
  attachCustomElements(eSortOrder, eSortAsc, eSortDesc, eSortMixed, eSortNone) {
    this.eSortOrder = eSortOrder;
    this.eSortAsc = eSortAsc;
    this.eSortDesc = eSortDesc;
    this.eSortMixed = eSortMixed;
    this.eSortNone = eSortNone;
  }
  setupSort(column, suppressOrder = false) {
    this.column = column;
    this.suppressOrder = suppressOrder;
    this.setupMultiSortIndicator();
    if (!this.column.isSortable()) {
      return;
    }
    this.addInIcon("sortAscending", this.eSortAsc, column);
    this.addInIcon("sortDescending", this.eSortDesc, column);
    this.addInIcon("sortUnSort", this.eSortNone, column);
    this.addManagedPropertyListener("unSortIcon", () => this.updateIcons());
    this.addManagedListener(this.eventService, Events.EVENT_NEW_COLUMNS_LOADED, () => this.updateIcons());
    this.addManagedListener(this.eventService, Events.EVENT_SORT_CHANGED, () => this.onSortChanged());
    this.addManagedListener(this.eventService, Events.EVENT_COLUMN_ROW_GROUP_CHANGED, () => this.onSortChanged());
    this.onSortChanged();
  }
  addInIcon(iconName, eParent, column) {
    if (eParent == null) {
      return;
    }
    const eIcon = createIconNoSpan(iconName, this.gridOptionsService, column);
    if (eIcon) {
      eParent.appendChild(eIcon);
    }
  }
  onSortChanged() {
    this.updateIcons();
    if (!this.suppressOrder) {
      this.updateSortOrder();
    }
  }
  updateIcons() {
    const sortDirection = this.sortController.getDisplaySortForColumn(this.column);
    if (this.eSortAsc) {
      const isAscending = sortDirection === "asc";
      setDisplayed(this.eSortAsc, isAscending, { skipAriaHidden: true });
    }
    if (this.eSortDesc) {
      const isDescending = sortDirection === "desc";
      setDisplayed(this.eSortDesc, isDescending, { skipAriaHidden: true });
    }
    if (this.eSortNone) {
      const alwaysHideNoSort = !this.column.getColDef().unSortIcon && !this.gridOptionsService.get("unSortIcon");
      const isNone = sortDirection === null || sortDirection === void 0;
      setDisplayed(this.eSortNone, !alwaysHideNoSort && isNone, { skipAriaHidden: true });
    }
  }
  setupMultiSortIndicator() {
    this.addInIcon("sortUnSort", this.eSortMixed, this.column);
    const isColumnShowingRowGroup = this.column.getColDef().showRowGroup;
    const areGroupsCoupled = this.gridOptionsService.isColumnsSortingCoupledToGroup();
    if (areGroupsCoupled && isColumnShowingRowGroup) {
      this.addManagedListener(this.eventService, Events.EVENT_SORT_CHANGED, () => this.updateMultiSortIndicator());
      this.addManagedListener(this.eventService, Events.EVENT_COLUMN_ROW_GROUP_CHANGED, () => this.updateMultiSortIndicator());
      this.updateMultiSortIndicator();
    }
  }
  updateMultiSortIndicator() {
    if (this.eSortMixed) {
      const isMixedSort = this.sortController.getDisplaySortForColumn(this.column) === "mixed";
      setDisplayed(this.eSortMixed, isMixedSort, { skipAriaHidden: true });
    }
  }
  // we listen here for global sort events, NOT column sort events, as we want to do this
  // when sorting has been set on all column (if we listened just for our col (where we
  // set the asc / desc icons) then it's possible other cols are yet to get their sorting state.
  updateSortOrder() {
    var _a;
    if (!this.eSortOrder) {
      return;
    }
    const allColumnsWithSorting = this.sortController.getColumnsWithSortingOrdered();
    const indexThisCol = (_a = this.sortController.getDisplaySortIndexForColumn(this.column)) != null ? _a : -1;
    const moreThanOneColSorting = allColumnsWithSorting.some((col) => {
      var _a2;
      return (_a2 = this.sortController.getDisplaySortIndexForColumn(col)) != null ? _a2 : -1 >= 1;
    });
    const showIndex = indexThisCol >= 0 && moreThanOneColSorting;
    setDisplayed(this.eSortOrder, showIndex, { skipAriaHidden: true });
    if (indexThisCol >= 0) {
      this.eSortOrder.textContent = (indexThisCol + 1).toString();
    } else {
      clearElement(this.eSortOrder);
    }
  }
};
_SortIndicatorComp.TEMPLATE = /* html */
`<span class="ag-sort-indicator-container">
            <span ref="eSortOrder" class="ag-sort-indicator-icon ag-sort-order ag-hidden" aria-hidden="true"></span>
            <span ref="eSortAsc" class="ag-sort-indicator-icon ag-sort-ascending-icon ag-hidden" aria-hidden="true"></span>
            <span ref="eSortDesc" class="ag-sort-indicator-icon ag-sort-descending-icon ag-hidden" aria-hidden="true"></span>
            <span ref="eSortMixed" class="ag-sort-indicator-icon ag-sort-mixed-icon ag-hidden" aria-hidden="true"></span>
            <span ref="eSortNone" class="ag-sort-indicator-icon ag-sort-none-icon ag-hidden" aria-hidden="true"></span>
        </span>`;
__decorateClass([
  RefSelector("eSortOrder")
], _SortIndicatorComp.prototype, "eSortOrder", 2);
__decorateClass([
  RefSelector("eSortAsc")
], _SortIndicatorComp.prototype, "eSortAsc", 2);
__decorateClass([
  RefSelector("eSortDesc")
], _SortIndicatorComp.prototype, "eSortDesc", 2);
__decorateClass([
  RefSelector("eSortMixed")
], _SortIndicatorComp.prototype, "eSortMixed", 2);
__decorateClass([
  RefSelector("eSortNone")
], _SortIndicatorComp.prototype, "eSortNone", 2);
__decorateClass([
  Autowired("columnModel")
], _SortIndicatorComp.prototype, "columnModel", 2);
__decorateClass([
  Autowired("sortController")
], _SortIndicatorComp.prototype, "sortController", 2);
var SortIndicatorComp = _SortIndicatorComp;

// community-modules/core/src/headerRendering/cells/column/headerComp.ts
var _HeaderComp = class _HeaderComp extends Component {
  constructor() {
    super(...arguments);
    this.lastMovingChanged = 0;
  }
  // this is a user component, and IComponent has "public destroy()" as part of the interface.
  // so we need to override destroy() just to make the method public.
  destroy() {
    super.destroy();
  }
  refresh(params) {
    this.params = params;
    if (this.workOutTemplate() != this.currentTemplate) {
      return false;
    }
    if (this.workOutShowMenu() != this.currentShowMenu) {
      return false;
    }
    if (this.workOutSort() != this.currentSort) {
      return false;
    }
    if (this.shouldSuppressMenuHide() != this.currentSuppressMenuHide) {
      return false;
    }
    this.setDisplayName(params);
    return true;
  }
  workOutTemplate() {
    var _a;
    let template = (_a = this.params.template) != null ? _a : _HeaderComp.TEMPLATE;
    template = template && template.trim ? template.trim() : template;
    return template;
  }
  init(params) {
    this.params = params;
    this.currentTemplate = this.workOutTemplate();
    this.setTemplate(this.currentTemplate);
    this.setupTap();
    this.setMenu();
    this.setupSort();
    this.setupFilterIcon();
    this.setupFilterButton();
    this.setDisplayName(params);
  }
  setDisplayName(params) {
    if (this.currentDisplayName != params.displayName) {
      this.currentDisplayName = params.displayName;
      const displayNameSanitised = escapeString(this.currentDisplayName, true);
      if (this.eText) {
        this.eText.textContent = displayNameSanitised;
      }
    }
  }
  addInIcon(iconName, eParent, column) {
    if (eParent == null) {
      return;
    }
    const eIcon = createIconNoSpan(iconName, this.gridOptionsService, column);
    if (eIcon) {
      eParent.appendChild(eIcon);
    }
  }
  setupTap() {
    const { gridOptionsService } = this;
    if (gridOptionsService.get("suppressTouch")) {
      return;
    }
    const touchListener = new TouchListener(this.getGui(), true);
    const suppressMenuHide = this.shouldSuppressMenuHide();
    const tapMenuButton = suppressMenuHide && exists(this.eMenu);
    const menuTouchListener = tapMenuButton ? new TouchListener(this.eMenu, true) : touchListener;
    if (this.params.enableMenu) {
      const eventType = tapMenuButton ? "EVENT_TAP" : "EVENT_LONG_TAP";
      const showMenuFn = (event) => this.params.showColumnMenuAfterMouseClick(event.touchStart);
      this.addManagedListener(menuTouchListener, TouchListener[eventType], showMenuFn);
    }
    if (this.params.enableSorting) {
      const tapListener = (event) => {
        var _a, _b;
        const target = event.touchStart.target;
        if (suppressMenuHide && (((_a = this.eMenu) == null ? void 0 : _a.contains(target)) || ((_b = this.eFilterButton) == null ? void 0 : _b.contains(target)))) {
          return;
        }
        this.sortController.progressSort(this.params.column, false, "uiColumnSorted");
      };
      this.addManagedListener(touchListener, TouchListener.EVENT_TAP, tapListener);
    }
    if (this.params.enableFilterButton) {
      const filterButtonTouchListener = new TouchListener(this.eFilterButton, true);
      this.addManagedListener(filterButtonTouchListener, "tap", () => this.params.showFilter(this.eFilterButton));
      this.addDestroyFunc(() => filterButtonTouchListener.destroy());
    }
    this.addDestroyFunc(() => touchListener.destroy());
    if (tapMenuButton) {
      this.addDestroyFunc(() => menuTouchListener.destroy());
    }
  }
  workOutShowMenu() {
    return this.params.enableMenu && this.menuService.isHeaderMenuButtonEnabled();
  }
  shouldSuppressMenuHide() {
    return this.menuService.isHeaderMenuButtonAlwaysShowEnabled();
  }
  setMenu() {
    if (!this.eMenu) {
      return;
    }
    this.currentShowMenu = this.workOutShowMenu();
    if (!this.currentShowMenu) {
      removeFromParent(this.eMenu);
      this.eMenu = void 0;
      return;
    }
    const isLegacyMenu = this.menuService.isLegacyMenuEnabled();
    this.addInIcon(isLegacyMenu ? "menu" : "menuAlt", this.eMenu, this.params.column);
    this.eMenu.classList.toggle("ag-header-menu-icon", !isLegacyMenu);
    this.currentSuppressMenuHide = this.shouldSuppressMenuHide();
    this.addManagedListener(this.eMenu, "click", () => this.params.showColumnMenu(this.eMenu));
    this.eMenu.classList.toggle("ag-header-menu-always-show", this.currentSuppressMenuHide);
  }
  onMenuKeyboardShortcut(isFilterShortcut) {
    var _a, _b, _c, _d;
    const { column } = this.params;
    const isLegacyMenuEnabled = this.menuService.isLegacyMenuEnabled();
    if (isFilterShortcut && !isLegacyMenuEnabled) {
      if (this.menuService.isFilterMenuInHeaderEnabled(column)) {
        this.params.showFilter((_b = (_a = this.eFilterButton) != null ? _a : this.eMenu) != null ? _b : this.getGui());
        return true;
      }
    } else if (this.params.enableMenu) {
      this.params.showColumnMenu((_d = (_c = this.eMenu) != null ? _c : this.eFilterButton) != null ? _d : this.getGui());
      return true;
    }
    return false;
  }
  workOutSort() {
    return this.params.enableSorting;
  }
  setupSort() {
    this.currentSort = this.params.enableSorting;
    if (!this.eSortIndicator) {
      this.eSortIndicator = this.context.createBean(new SortIndicatorComp(true));
      this.eSortIndicator.attachCustomElements(
        this.eSortOrder,
        this.eSortAsc,
        this.eSortDesc,
        this.eSortMixed,
        this.eSortNone
      );
    }
    this.eSortIndicator.setupSort(this.params.column);
    if (!this.currentSort) {
      return;
    }
    this.addManagedListener(this.params.column, Column.EVENT_MOVING_CHANGED, () => {
      this.lastMovingChanged = (/* @__PURE__ */ new Date()).getTime();
    });
    if (this.eLabel) {
      this.addManagedListener(this.eLabel, "click", (event) => {
        const moving = this.params.column.isMoving();
        const nowTime = (/* @__PURE__ */ new Date()).getTime();
        const movedRecently = nowTime - this.lastMovingChanged < 50;
        const columnMoving = moving || movedRecently;
        if (!columnMoving) {
          const sortUsingCtrl = this.gridOptionsService.get("multiSortKey") === "ctrl";
          const multiSort = sortUsingCtrl ? event.ctrlKey || event.metaKey : event.shiftKey;
          this.params.progressSort(multiSort);
        }
      });
    }
    const onSortingChanged = () => {
      this.addOrRemoveCssClass("ag-header-cell-sorted-asc", this.params.column.isSortAscending());
      this.addOrRemoveCssClass("ag-header-cell-sorted-desc", this.params.column.isSortDescending());
      this.addOrRemoveCssClass("ag-header-cell-sorted-none", this.params.column.isSortNone());
      if (this.params.column.getColDef().showRowGroup) {
        const sourceColumns = this.columnModel.getSourceColumnsForGroupColumn(this.params.column);
        const sortDirectionsMatch = sourceColumns == null ? void 0 : sourceColumns.every((sourceCol) => this.params.column.getSort() == sourceCol.getSort());
        const isMultiSorting = !sortDirectionsMatch;
        this.addOrRemoveCssClass("ag-header-cell-sorted-mixed", isMultiSorting);
      }
    };
    this.addManagedListener(this.eventService, Events.EVENT_SORT_CHANGED, onSortingChanged);
    this.addManagedListener(this.eventService, Events.EVENT_COLUMN_ROW_GROUP_CHANGED, onSortingChanged);
  }
  setupFilterIcon() {
    if (!this.eFilter) {
      return;
    }
    this.configureFilter(this.params.enableFilterIcon, this.eFilter, this.onFilterChangedIcon.bind(this));
  }
  setupFilterButton() {
    if (!this.eFilterButton) {
      return;
    }
    const configured = this.configureFilter(
      this.params.enableFilterButton,
      this.eFilterButton,
      this.onFilterChangedButton.bind(this)
    );
    if (configured) {
      this.addManagedListener(this.eFilterButton, "click", () => this.params.showFilter(this.eFilterButton));
    } else {
      this.eFilterButton = void 0;
    }
  }
  configureFilter(enabled, element, filterChangedCallback) {
    if (!enabled) {
      removeFromParent(element);
      return false;
    }
    const { column } = this.params;
    this.addInIcon("filter", element, column);
    this.addManagedListener(column, Column.EVENT_FILTER_CHANGED, filterChangedCallback);
    filterChangedCallback();
    return true;
  }
  onFilterChangedIcon() {
    const filterPresent = this.params.column.isFilterActive();
    setDisplayed(this.eFilter, filterPresent, { skipAriaHidden: true });
  }
  onFilterChangedButton() {
    const filterPresent = this.params.column.isFilterActive();
    this.eFilterButton.classList.toggle("ag-filter-active", filterPresent);
  }
  getAnchorElementForMenu(isFilter) {
    var _a, _b, _c, _d;
    if (isFilter) {
      return (_b = (_a = this.eFilterButton) != null ? _a : this.eMenu) != null ? _b : this.getGui();
    }
    return (_d = (_c = this.eMenu) != null ? _c : this.eFilterButton) != null ? _d : this.getGui();
  }
};
_HeaderComp.TEMPLATE = /* html */
`<div class="ag-cell-label-container" role="presentation">
            <span ref="eMenu" class="ag-header-icon ag-header-cell-menu-button" aria-hidden="true"></span>
            <span ref="eFilterButton" class="ag-header-icon ag-header-cell-filter-button" aria-hidden="true"></span>
            <div ref="eLabel" class="ag-header-cell-label" role="presentation">
                <span ref="eText" class="ag-header-cell-text"></span>
                <span ref="eFilter" class="ag-header-icon ag-header-label-icon ag-filter-icon" aria-hidden="true"></span>
                <ag-sort-indicator ref="eSortIndicator"></ag-sort-indicator>
            </div>
        </div>`;
__decorateClass([
  Autowired("sortController")
], _HeaderComp.prototype, "sortController", 2);
__decorateClass([
  Autowired("menuService")
], _HeaderComp.prototype, "menuService", 2);
__decorateClass([
  Autowired("columnModel")
], _HeaderComp.prototype, "columnModel", 2);
__decorateClass([
  RefSelector("eFilter")
], _HeaderComp.prototype, "eFilter", 2);
__decorateClass([
  RefSelector("eFilterButton")
], _HeaderComp.prototype, "eFilterButton", 2);
__decorateClass([
  RefSelector("eSortIndicator")
], _HeaderComp.prototype, "eSortIndicator", 2);
__decorateClass([
  RefSelector("eMenu")
], _HeaderComp.prototype, "eMenu", 2);
__decorateClass([
  RefSelector("eLabel")
], _HeaderComp.prototype, "eLabel", 2);
__decorateClass([
  RefSelector("eText")
], _HeaderComp.prototype, "eText", 2);
__decorateClass([
  RefSelector("eSortOrder")
], _HeaderComp.prototype, "eSortOrder", 2);
__decorateClass([
  RefSelector("eSortAsc")
], _HeaderComp.prototype, "eSortAsc", 2);
__decorateClass([
  RefSelector("eSortDesc")
], _HeaderComp.prototype, "eSortDesc", 2);
__decorateClass([
  RefSelector("eSortMixed")
], _HeaderComp.prototype, "eSortMixed", 2);
__decorateClass([
  RefSelector("eSortNone")
], _HeaderComp.prototype, "eSortNone", 2);
var HeaderComp = _HeaderComp;

// community-modules/core/src/headerRendering/cells/columnGroup/headerGroupComp.ts
var _HeaderGroupComp = class _HeaderGroupComp extends Component {
  constructor() {
    super(_HeaderGroupComp.TEMPLATE);
  }
  // this is a user component, and IComponent has "public destroy()" as part of the interface.
  // so we need to override destroy() just to make the method public.
  destroy() {
    super.destroy();
  }
  init(params) {
    this.params = params;
    this.checkWarnings();
    this.setupLabel();
    this.addGroupExpandIcon();
    this.setupExpandIcons();
  }
  checkWarnings() {
    const paramsAny = this.params;
    if (paramsAny.template) {
      warnOnce(`A template was provided for Header Group Comp - templates are only supported for Header Comps (not groups)`);
    }
  }
  setupExpandIcons() {
    this.addInIcon("columnGroupOpened", "agOpened");
    this.addInIcon("columnGroupClosed", "agClosed");
    const expandAction = (event) => {
      if (isStopPropagationForAgGrid(event)) {
        return;
      }
      const newExpandedValue = !this.params.columnGroup.isExpanded();
      this.columnModel.setColumnGroupOpened(this.params.columnGroup.getProvidedColumnGroup(), newExpandedValue, "uiColumnExpanded");
    };
    this.addTouchAndClickListeners(this.eCloseIcon, expandAction);
    this.addTouchAndClickListeners(this.eOpenIcon, expandAction);
    const stopPropagationAction = (event) => {
      stopPropagationForAgGrid(event);
    };
    this.addManagedListener(this.eCloseIcon, "dblclick", stopPropagationAction);
    this.addManagedListener(this.eOpenIcon, "dblclick", stopPropagationAction);
    this.addManagedListener(this.getGui(), "dblclick", expandAction);
    this.updateIconVisibility();
    const providedColumnGroup = this.params.columnGroup.getProvidedColumnGroup();
    this.addManagedListener(providedColumnGroup, ProvidedColumnGroup.EVENT_EXPANDED_CHANGED, this.updateIconVisibility.bind(this));
    this.addManagedListener(providedColumnGroup, ProvidedColumnGroup.EVENT_EXPANDABLE_CHANGED, this.updateIconVisibility.bind(this));
  }
  addTouchAndClickListeners(eElement, action) {
    const touchListener = new TouchListener(eElement, true);
    this.addManagedListener(touchListener, TouchListener.EVENT_TAP, action);
    this.addDestroyFunc(() => touchListener.destroy());
    this.addManagedListener(eElement, "click", action);
  }
  updateIconVisibility() {
    const columnGroup = this.params.columnGroup;
    if (columnGroup.isExpandable()) {
      const expanded = this.params.columnGroup.isExpanded();
      setDisplayed(this.eOpenIcon, expanded);
      setDisplayed(this.eCloseIcon, !expanded);
    } else {
      setDisplayed(this.eOpenIcon, false);
      setDisplayed(this.eCloseIcon, false);
    }
  }
  addInIcon(iconName, refName) {
    const eIcon = createIconNoSpan(iconName, this.gridOptionsService, null);
    if (eIcon) {
      this.getRefElement(refName).appendChild(eIcon);
    }
  }
  addGroupExpandIcon() {
    if (!this.params.columnGroup.isExpandable()) {
      setDisplayed(this.eOpenIcon, false);
      setDisplayed(this.eCloseIcon, false);
      return;
    }
  }
  setupLabel() {
    var _a;
    const { displayName, columnGroup } = this.params;
    if (exists(displayName)) {
      const displayNameSanitised = escapeString(displayName, true);
      this.getRefElement("agLabel").textContent = displayNameSanitised;
    }
    this.addOrRemoveCssClass("ag-sticky-label", !((_a = columnGroup.getColGroupDef()) == null ? void 0 : _a.suppressStickyLabel));
  }
};
_HeaderGroupComp.TEMPLATE = /* html */
`<div class="ag-header-group-cell-label" ref="agContainer" role="presentation">
            <span ref="agLabel" class="ag-header-group-text" role="presentation"></span>
            <span ref="agOpened" class="ag-header-icon ag-header-expand-icon ag-header-expand-icon-expanded"></span>
            <span ref="agClosed" class="ag-header-icon ag-header-expand-icon ag-header-expand-icon-collapsed"></span>
        </div>`;
__decorateClass([
  Autowired("columnModel")
], _HeaderGroupComp.prototype, "columnModel", 2);
__decorateClass([
  RefSelector("agOpened")
], _HeaderGroupComp.prototype, "eOpenIcon", 2);
__decorateClass([
  RefSelector("agClosed")
], _HeaderGroupComp.prototype, "eCloseIcon", 2);
var HeaderGroupComp = _HeaderGroupComp;

// community-modules/core/src/widgets/popupComponent.ts
var PopupComponent = class extends Component {
  isPopup() {
    return true;
  }
  setParentComponent(container) {
    container.addCssClass("ag-has-popup");
    super.setParentComponent(container);
  }
  destroy() {
    const parentComp = this.parentComponent;
    const hasParent = parentComp && parentComp.isAlive();
    if (hasParent) {
      parentComp.getGui().classList.remove("ag-has-popup");
    }
    super.destroy();
  }
};

// community-modules/core/src/rendering/cellEditors/largeTextCellEditor.ts
var _LargeTextCellEditor = class _LargeTextCellEditor extends PopupComponent {
  constructor() {
    super(_LargeTextCellEditor.TEMPLATE);
  }
  init(params) {
    this.params = params;
    this.focusAfterAttached = params.cellStartedEdit;
    this.eTextArea.setMaxLength(params.maxLength || 200).setCols(params.cols || 60).setRows(params.rows || 10);
    if (exists(params.value, true)) {
      this.eTextArea.setValue(params.value.toString(), true);
    }
    this.addGuiEventListener("keydown", this.onKeyDown.bind(this));
    this.activateTabIndex();
  }
  onKeyDown(event) {
    const key = event.key;
    if (key === KeyCode.LEFT || key === KeyCode.UP || key === KeyCode.RIGHT || key === KeyCode.DOWN || event.shiftKey && key === KeyCode.ENTER) {
      event.stopPropagation();
    }
  }
  afterGuiAttached() {
    const translate = this.localeService.getLocaleTextFunc();
    this.eTextArea.setInputAriaLabel(translate("ariaInputEditor", "Input Editor"));
    if (this.focusAfterAttached) {
      this.eTextArea.getFocusableElement().focus();
    }
  }
  getValue() {
    const value = this.eTextArea.getValue();
    if (!exists(value) && !exists(this.params.value)) {
      return this.params.value;
    }
    return this.params.parseValue(value);
  }
};
_LargeTextCellEditor.TEMPLATE = /* html */
`<div class="ag-large-text">
            <ag-input-text-area ref="eTextArea" class="ag-large-text-input"></ag-input-text-area>
        </div>`;
__decorateClass([
  RefSelector("eTextArea")
], _LargeTextCellEditor.prototype, "eTextArea", 2);
var LargeTextCellEditor = _LargeTextCellEditor;

// community-modules/core/src/rendering/cellEditors/selectCellEditor.ts
var SelectCellEditor = class extends PopupComponent {
  constructor() {
    super(
      /* html */
      `<div class="ag-cell-edit-wrapper">
                <ag-select class="ag-cell-editor" ref="eSelect"></ag-select>
            </div>`
    );
    this.startedByEnter = false;
  }
  init(params) {
    this.focusAfterAttached = params.cellStartedEdit;
    const { eSelect, valueFormatterService, gridOptionsService } = this;
    const { values: values2, value, eventKey } = params;
    if (missing(values2)) {
      console.warn("AG Grid: no values found for select cellEditor");
      return;
    }
    this.startedByEnter = eventKey != null ? eventKey === KeyCode.ENTER : false;
    let hasValue = false;
    values2.forEach((currentValue) => {
      const option = { value: currentValue };
      const valueFormatted = valueFormatterService.formatValue(params.column, null, currentValue);
      const valueFormattedExits = valueFormatted !== null && valueFormatted !== void 0;
      option.text = valueFormattedExits ? valueFormatted : currentValue;
      eSelect.addOption(option);
      hasValue = hasValue || value === currentValue;
    });
    if (hasValue) {
      eSelect.setValue(params.value, true);
    } else if (params.values.length) {
      eSelect.setValue(params.values[0], true);
    }
    const { valueListGap, valueListMaxWidth, valueListMaxHeight } = params;
    if (valueListGap != null) {
      eSelect.setPickerGap(valueListGap);
    }
    if (valueListMaxHeight != null) {
      eSelect.setPickerMaxHeight(valueListMaxHeight);
    }
    if (valueListMaxWidth != null) {
      eSelect.setPickerMaxWidth(valueListMaxWidth);
    }
    if (gridOptionsService.get("editType") !== "fullRow") {
      this.addManagedListener(this.eSelect, AgSelect.EVENT_ITEM_SELECTED, () => params.stopEditing());
    }
  }
  afterGuiAttached() {
    if (this.focusAfterAttached) {
      this.eSelect.getFocusableElement().focus();
    }
    if (this.startedByEnter) {
      setTimeout(() => {
        if (this.isAlive()) {
          this.eSelect.showPicker();
        }
      });
    }
  }
  focusIn() {
    this.eSelect.getFocusableElement().focus();
  }
  getValue() {
    return this.eSelect.getValue();
  }
  isPopup() {
    return false;
  }
};
__decorateClass([
  Autowired("valueFormatterService")
], SelectCellEditor.prototype, "valueFormatterService", 2);
__decorateClass([
  RefSelector("eSelect")
], SelectCellEditor.prototype, "eSelect", 2);

// community-modules/core/src/rendering/cellEditors/simpleCellEditor.ts
var SimpleCellEditor = class extends PopupComponent {
  constructor(cellEditorInput) {
    super(
      /* html */
      `
            <div class="ag-cell-edit-wrapper">
                ${cellEditorInput.getTemplate()}
            </div>`
    );
    this.cellEditorInput = cellEditorInput;
  }
  init(params) {
    this.params = params;
    const eInput = this.eInput;
    this.cellEditorInput.init(eInput, params);
    let startValue;
    if (params.cellStartedEdit) {
      this.focusAfterAttached = true;
      const eventKey = params.eventKey;
      if (eventKey === KeyCode.BACKSPACE || params.eventKey === KeyCode.DELETE) {
        startValue = "";
      } else if (eventKey && eventKey.length === 1) {
        startValue = eventKey;
      } else {
        startValue = this.cellEditorInput.getStartValue();
        if (eventKey !== KeyCode.F2) {
          this.highlightAllOnFocus = true;
        }
      }
    } else {
      this.focusAfterAttached = false;
      startValue = this.cellEditorInput.getStartValue();
    }
    if (startValue != null) {
      eInput.setStartValue(startValue);
    }
    this.addManagedListener(eInput.getGui(), "keydown", (event) => {
      const { key } = event;
      if (key === KeyCode.PAGE_UP || key === KeyCode.PAGE_DOWN) {
        event.preventDefault();
      }
    });
  }
  afterGuiAttached() {
    var _a, _b;
    const translate = this.localeService.getLocaleTextFunc();
    const eInput = this.eInput;
    eInput.setInputAriaLabel(translate("ariaInputEditor", "Input Editor"));
    if (!this.focusAfterAttached) {
      return;
    }
    if (!isBrowserSafari()) {
      eInput.getFocusableElement().focus();
    }
    const inputEl = eInput.getInputElement();
    if (this.highlightAllOnFocus) {
      inputEl.select();
    } else {
      (_b = (_a = this.cellEditorInput).setCaret) == null ? void 0 : _b.call(_a);
    }
  }
  // gets called when tabbing through cells and in full row edit mode
  focusIn() {
    const eInput = this.eInput;
    const focusEl = eInput.getFocusableElement();
    const inputEl = eInput.getInputElement();
    focusEl.focus();
    inputEl.select();
  }
  getValue() {
    return this.cellEditorInput.getValue();
  }
  isPopup() {
    return false;
  }
};
__decorateClass([
  RefSelector("eInput")
], SimpleCellEditor.prototype, "eInput", 2);

// community-modules/core/src/rendering/cellEditors/textCellEditor.ts
var TextCellEditorInput = class {
  getTemplate() {
    return (
      /* html */
      `<ag-input-text-field class="ag-cell-editor" ref="eInput"></ag-input-text-field>`
    );
  }
  init(eInput, params) {
    this.eInput = eInput;
    this.params = params;
    if (params.maxLength != null) {
      eInput.setMaxLength(params.maxLength);
    }
  }
  getValue() {
    const value = this.eInput.getValue();
    if (!exists(value) && !exists(this.params.value)) {
      return this.params.value;
    }
    return this.params.parseValue(value);
  }
  getStartValue() {
    const formatValue = this.params.useFormatter || this.params.column.getColDef().refData;
    return formatValue ? this.params.formatValue(this.params.value) : this.params.value;
  }
  setCaret() {
    const value = this.eInput.getValue();
    const len = exists(value) && value.length || 0;
    if (len) {
      this.eInput.getInputElement().setSelectionRange(len, len);
    }
  }
};
var TextCellEditor = class extends SimpleCellEditor {
  constructor() {
    super(new TextCellEditorInput());
  }
};

// community-modules/core/src/rendering/cellRenderers/animateShowChangeCellRenderer.ts
var ARROW_UP = "\u2191";
var ARROW_DOWN = "\u2193";
var AnimateShowChangeCellRenderer = class extends Component {
  constructor() {
    super();
    this.refreshCount = 0;
    const template = document.createElement("span");
    const delta = document.createElement("span");
    delta.setAttribute("class", "ag-value-change-delta");
    const value = document.createElement("span");
    value.setAttribute("class", "ag-value-change-value");
    template.appendChild(delta);
    template.appendChild(value);
    this.setTemplateFromElement(template);
  }
  init(params) {
    this.eValue = this.queryForHtmlElement(".ag-value-change-value");
    this.eDelta = this.queryForHtmlElement(".ag-value-change-delta");
    this.refresh(params, true);
  }
  showDelta(params, delta) {
    const absDelta = Math.abs(delta);
    const valueFormatted = params.formatValue(absDelta);
    const valueToUse = exists(valueFormatted) ? valueFormatted : absDelta;
    const deltaUp = delta >= 0;
    if (deltaUp) {
      this.eDelta.textContent = ARROW_UP + valueToUse;
    } else {
      this.eDelta.textContent = ARROW_DOWN + valueToUse;
    }
    this.eDelta.classList.toggle("ag-value-change-delta-up", deltaUp);
    this.eDelta.classList.toggle("ag-value-change-delta-down", !deltaUp);
  }
  setTimerToRemoveDelta() {
    this.refreshCount++;
    const refreshCountCopy = this.refreshCount;
    this.getFrameworkOverrides().wrapIncoming(() => {
      window.setTimeout(() => {
        if (refreshCountCopy === this.refreshCount) {
          this.hideDeltaValue();
        }
      }, 2e3);
    });
  }
  hideDeltaValue() {
    this.eValue.classList.remove("ag-value-change-value-highlight");
    clearElement(this.eDelta);
  }
  refresh(params, isInitialRender = false) {
    const value = params.value;
    if (value === this.lastValue) {
      return false;
    }
    if (exists(params.valueFormatted)) {
      this.eValue.textContent = params.valueFormatted;
    } else if (exists(params.value)) {
      this.eValue.textContent = value;
    } else {
      clearElement(this.eValue);
    }
    if (this.filterManager.isSuppressFlashingCellsBecauseFiltering()) {
      return false;
    }
    if (typeof value === "number" && typeof this.lastValue === "number") {
      const delta = value - this.lastValue;
      this.showDelta(params, delta);
    }
    if (this.lastValue) {
      this.eValue.classList.add("ag-value-change-value-highlight");
    }
    if (!isInitialRender) {
      this.setTimerToRemoveDelta();
    }
    this.lastValue = value;
    return true;
  }
};
__decorateClass([
  Autowired("filterManager")
], AnimateShowChangeCellRenderer.prototype, "filterManager", 2);

// community-modules/core/src/rendering/cellRenderers/animateSlideCellRenderer.ts
var AnimateSlideCellRenderer = class extends Component {
  constructor() {
    super();
    this.refreshCount = 0;
    const template = document.createElement("span");
    const slide = document.createElement("span");
    slide.setAttribute("class", "ag-value-slide-current");
    template.appendChild(slide);
    this.setTemplateFromElement(template);
    this.eCurrent = this.queryForHtmlElement(".ag-value-slide-current");
  }
  init(params) {
    this.refresh(params, true);
  }
  addSlideAnimation() {
    this.refreshCount++;
    const refreshCountCopy = this.refreshCount;
    if (this.ePrevious) {
      this.getGui().removeChild(this.ePrevious);
    }
    const prevElement = document.createElement("span");
    prevElement.setAttribute("class", "ag-value-slide-previous ag-value-slide-out");
    this.ePrevious = prevElement;
    this.ePrevious.textContent = this.eCurrent.textContent;
    this.getGui().insertBefore(this.ePrevious, this.eCurrent);
    this.getFrameworkOverrides().wrapIncoming(() => {
      window.setTimeout(() => {
        if (refreshCountCopy !== this.refreshCount) {
          return;
        }
        this.ePrevious.classList.add("ag-value-slide-out-end");
      }, 50);
      window.setTimeout(() => {
        if (refreshCountCopy !== this.refreshCount) {
          return;
        }
        this.getGui().removeChild(this.ePrevious);
        this.ePrevious = null;
      }, 3e3);
    });
  }
  refresh(params, isInitialRender = false) {
    let value = params.value;
    if (missing(value)) {
      value = "";
    }
    if (value === this.lastValue) {
      return false;
    }
    if (this.filterManager.isSuppressFlashingCellsBecauseFiltering()) {
      return false;
    }
    if (!isInitialRender) {
      this.addSlideAnimation();
    }
    this.lastValue = value;
    if (exists(params.valueFormatted)) {
      this.eCurrent.textContent = params.valueFormatted;
    } else if (exists(params.value)) {
      this.eCurrent.textContent = value;
    } else {
      clearElement(this.eCurrent);
    }
    return true;
  }
};
__decorateClass([
  Autowired("filterManager")
], AnimateSlideCellRenderer.prototype, "filterManager", 2);

// community-modules/core/src/entities/rowNode.ts
var _RowNode = class _RowNode {
  constructor(beans) {
    /** The current row index. If the row is filtered out or in a collapsed group, this value will be `null`. */
    this.rowIndex = null;
    /** The key for the group eg Ireland, UK, USA */
    this.key = null;
    /** Children mapped by the pivot columns. */
    this.childrenMapped = {};
    /**
     * This will be `true` if it has a rowIndex assigned, otherwise `false`.
     */
    this.displayed = false;
    /** The row top position in pixels. */
    this.rowTop = null;
    /** The top pixel for this row last time, makes sense if data set was ordered or filtered,
     * it is used so new rows can animate in from their old position. */
    this.oldRowTop = null;
    /** `true` by default - can be overridden via gridOptions.isRowSelectable(rowNode) */
    this.selectable = true;
    /** Used by sorting service - to give deterministic sort to groups. Previously we
     * just id for this, however id is a string and had slower sorting compared to numbers. */
    this.__objectId = _RowNode.OBJECT_ID_SEQUENCE++;
    /** When one or more Columns are using autoHeight, this keeps track of height of each autoHeight Cell,
     * indexed by the Column ID. */
    this.__autoHeights = {};
    /** `true` when nodes with the same id are being removed and added as part of the same batch transaction */
    this.alreadyRendered = false;
    this.highlighted = null;
    this.hovered = false;
    this.selected = false;
    this.beans = beans;
  }
  /**
   * Replaces the data on the `rowNode`. When this method is called, the grid will refresh the entire rendered row if it is displayed.
   */
  setData(data) {
    this.setDataCommon(data, false);
  }
  // similar to setRowData, however it is expected that the data is the same data item. this
  // is intended to be used with Redux type stores, where the whole data can be changed. we are
  // guaranteed that the data is the same entity (so grid doesn't need to worry about the id of the
  // underlying data changing, hence doesn't need to worry about selection). the grid, upon receiving
  // dataChanged event, will refresh the cells rather than rip them all out (so user can show transitions).
  /**
   * Updates the data on the `rowNode`. When this method is called, the grid will refresh the entire rendered row if it is displayed.
   */
  updateData(data) {
    this.setDataCommon(data, true);
  }
  setDataCommon(data, update) {
    const oldData = this.data;
    this.data = data;
    this.beans.valueCache.onDataChanged();
    this.updateDataOnDetailNode();
    this.checkRowSelectable();
    this.resetQuickFilterAggregateText();
    const event = this.createDataChangedEvent(data, oldData, update);
    this.dispatchLocalEvent(event);
  }
  // when we are doing master / detail, the detail node is lazy created, but then kept around.
  // so if we show / hide the detail, the same detail rowNode is used. so we need to keep the data
  // in sync, otherwise expand/collapse of the detail would still show the old values.
  updateDataOnDetailNode() {
    if (this.detailNode) {
      this.detailNode.data = this.data;
    }
  }
  createDataChangedEvent(newData, oldData, update) {
    return {
      type: _RowNode.EVENT_DATA_CHANGED,
      node: this,
      oldData,
      newData,
      update
    };
  }
  createLocalRowEvent(type) {
    return {
      type,
      node: this
    };
  }
  getRowIndexString() {
    if (this.rowPinned === "top") {
      return "t-" + this.rowIndex;
    }
    if (this.rowPinned === "bottom") {
      return "b-" + this.rowIndex;
    }
    return this.rowIndex.toString();
  }
  createDaemonNode() {
    const oldNode = new _RowNode(this.beans);
    oldNode.id = this.id;
    oldNode.data = this.data;
    oldNode.__daemon = true;
    oldNode.selected = this.selected;
    oldNode.level = this.level;
    return oldNode;
  }
  setDataAndId(data, id) {
    const oldNode = exists(this.id) ? this.createDaemonNode() : null;
    const oldData = this.data;
    this.data = data;
    this.updateDataOnDetailNode();
    this.setId(id);
    this.checkRowSelectable();
    this.beans.selectionService.syncInRowNode(this, oldNode);
    const event = this.createDataChangedEvent(data, oldData, false);
    this.dispatchLocalEvent(event);
  }
  checkRowSelectable() {
    const isRowSelectableFunc = this.beans.gridOptionsService.get("isRowSelectable");
    this.setRowSelectable(isRowSelectableFunc ? isRowSelectableFunc(this) : true);
  }
  setRowSelectable(newVal, suppressSelectionUpdate) {
    if (this.selectable !== newVal) {
      this.selectable = newVal;
      if (this.eventService) {
        this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_SELECTABLE_CHANGED));
      }
      if (suppressSelectionUpdate) {
        return;
      }
      const isGroupSelectsChildren = this.beans.gridOptionsService.get("groupSelectsChildren");
      if (isGroupSelectsChildren) {
        const selected = this.calculateSelectedFromChildren();
        this.setSelectedParams({
          newValue: selected != null ? selected : false,
          source: "selectableChanged"
        });
        return;
      }
      if (this.isSelected() && !this.selectable) {
        this.setSelectedParams({
          newValue: false,
          source: "selectableChanged"
        });
      }
    }
  }
  setId(id) {
    const getRowIdFunc = this.beans.gridOptionsService.getCallback("getRowId");
    if (getRowIdFunc) {
      if (this.data) {
        const parentKeys = this.getGroupKeys(true);
        this.id = getRowIdFunc({
          data: this.data,
          parentKeys: parentKeys.length > 0 ? parentKeys : void 0,
          level: this.level
        });
        if (this.id !== null && typeof this.id === "string" && this.id.startsWith(_RowNode.ID_PREFIX_ROW_GROUP)) {
          console.error(`AG Grid: Row IDs cannot start with ${_RowNode.ID_PREFIX_ROW_GROUP}, this is a reserved prefix for AG Grid's row grouping feature.`);
        }
        if (this.id !== null && typeof this.id !== "string") {
          this.id = "" + this.id;
        }
      } else {
        this.id = void 0;
      }
    } else {
      this.id = id;
    }
  }
  getGroupKeys(excludeSelf = false) {
    const keys2 = [];
    let pointer = this;
    if (excludeSelf) {
      pointer = pointer.parent;
    }
    while (pointer && pointer.level >= 0) {
      keys2.push(pointer.key);
      pointer = pointer.parent;
    }
    keys2.reverse();
    return keys2;
  }
  isPixelInRange(pixel) {
    if (!exists(this.rowTop) || !exists(this.rowHeight)) {
      return false;
    }
    return pixel >= this.rowTop && pixel < this.rowTop + this.rowHeight;
  }
  setFirstChild(firstChild) {
    if (this.firstChild === firstChild) {
      return;
    }
    this.firstChild = firstChild;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_FIRST_CHILD_CHANGED));
    }
  }
  setLastChild(lastChild) {
    if (this.lastChild === lastChild) {
      return;
    }
    this.lastChild = lastChild;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_LAST_CHILD_CHANGED));
    }
  }
  setChildIndex(childIndex) {
    if (this.childIndex === childIndex) {
      return;
    }
    this.childIndex = childIndex;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_CHILD_INDEX_CHANGED));
    }
  }
  setRowTop(rowTop) {
    this.oldRowTop = this.rowTop;
    if (this.rowTop === rowTop) {
      return;
    }
    this.rowTop = rowTop;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_TOP_CHANGED));
    }
    this.setDisplayed(rowTop !== null);
  }
  clearRowTopAndRowIndex() {
    this.oldRowTop = null;
    this.setRowTop(null);
    this.setRowIndex(null);
  }
  setDisplayed(displayed) {
    if (this.displayed === displayed) {
      return;
    }
    this.displayed = displayed;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_DISPLAYED_CHANGED));
    }
  }
  setDragging(dragging) {
    if (this.dragging === dragging) {
      return;
    }
    this.dragging = dragging;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_DRAGGING_CHANGED));
    }
  }
  setHighlighted(highlighted) {
    if (highlighted === this.highlighted) {
      return;
    }
    this.highlighted = highlighted;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_HIGHLIGHT_CHANGED));
    }
  }
  setHovered(hovered) {
    if (this.hovered === hovered) {
      return;
    }
    this.hovered = hovered;
  }
  isHovered() {
    return this.hovered;
  }
  setAllChildrenCount(allChildrenCount) {
    if (this.allChildrenCount === allChildrenCount) {
      return;
    }
    this.allChildrenCount = allChildrenCount;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_ALL_CHILDREN_COUNT_CHANGED));
    }
  }
  setMaster(master) {
    if (this.master === master) {
      return;
    }
    if (this.master && !master) {
      this.expanded = false;
    }
    this.master = master;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_MASTER_CHANGED));
    }
  }
  setGroup(group) {
    if (this.group === group) {
      return;
    }
    if (this.group && !group) {
      this.expanded = false;
    }
    this.group = group;
    this.updateHasChildren();
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_GROUP_CHANGED));
    }
  }
  /**
   * Sets the row height.
   * Call if you want to change the height initially assigned to the row.
   * After calling, you must call `api.onRowHeightChanged()` so the grid knows it needs to work out the placement of the rows. */
  setRowHeight(rowHeight, estimated = false) {
    this.rowHeight = rowHeight;
    this.rowHeightEstimated = estimated;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_HEIGHT_CHANGED));
    }
  }
  setRowAutoHeight(cellHeight, column) {
    if (!this.__autoHeights) {
      this.__autoHeights = {};
    }
    this.__autoHeights[column.getId()] = cellHeight;
    if (cellHeight != null) {
      if (this.checkAutoHeightsDebounced == null) {
        this.checkAutoHeightsDebounced = debounce(this.checkAutoHeights.bind(this), 1);
      }
      this.checkAutoHeightsDebounced();
    }
  }
  checkAutoHeights() {
    let notAllPresent = false;
    let nonePresent = true;
    let newRowHeight = 0;
    const autoHeights = this.__autoHeights;
    if (autoHeights == null) {
      return;
    }
    const displayedAutoHeightCols = this.beans.columnModel.getAllDisplayedAutoHeightCols();
    displayedAutoHeightCols.forEach((col) => {
      let cellHeight = autoHeights[col.getId()];
      if (cellHeight == null) {
        if (this.beans.columnModel.isColSpanActive()) {
          let activeColsForRow = [];
          switch (col.getPinned()) {
            case "left":
              activeColsForRow = this.beans.columnModel.getDisplayedLeftColumnsForRow(this);
              break;
            case "right":
              activeColsForRow = this.beans.columnModel.getDisplayedRightColumnsForRow(this);
              break;
            case null:
              activeColsForRow = this.beans.columnModel.getViewportCenterColumnsForRow(this);
              break;
          }
          if (activeColsForRow.includes(col)) {
            notAllPresent = true;
            return;
          }
          cellHeight = -1;
        } else {
          notAllPresent = true;
          return;
        }
      } else {
        nonePresent = false;
      }
      if (cellHeight > newRowHeight) {
        newRowHeight = cellHeight;
      }
    });
    if (notAllPresent) {
      return;
    }
    if (nonePresent || newRowHeight < 10) {
      newRowHeight = this.beans.gridOptionsService.getRowHeightForNode(this).height;
    }
    if (newRowHeight == this.rowHeight) {
      return;
    }
    this.setRowHeight(newRowHeight);
    const rowModel = this.beans.rowModel;
    if (rowModel.onRowHeightChangedDebounced) {
      rowModel.onRowHeightChangedDebounced();
    }
  }
  setRowIndex(rowIndex) {
    if (this.rowIndex === rowIndex) {
      return;
    }
    this.rowIndex = rowIndex;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_ROW_INDEX_CHANGED));
    }
  }
  setUiLevel(uiLevel) {
    if (this.uiLevel === uiLevel) {
      return;
    }
    this.uiLevel = uiLevel;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_UI_LEVEL_CHANGED));
    }
  }
  /**
   * Set the expanded state of this rowNode. Pass `true` to expand and `false` to collapse.
   */
  setExpanded(expanded, e) {
    if (this.expanded === expanded) {
      return;
    }
    this.expanded = expanded;
    if (this.eventService) {
      this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_EXPANDED_CHANGED));
    }
    const event = Object.assign({}, this.createGlobalRowEvent(Events.EVENT_ROW_GROUP_OPENED), {
      expanded,
      event: e || null
    });
    this.beans.rowNodeEventThrottle.dispatchExpanded(event);
    if (this.sibling) {
      this.beans.rowRenderer.refreshCells({ rowNodes: [this] });
    }
  }
  createGlobalRowEvent(type) {
    return this.beans.gridOptionsService.addGridCommonParams({
      type,
      node: this,
      data: this.data,
      rowIndex: this.rowIndex,
      rowPinned: this.rowPinned
    });
  }
  dispatchLocalEvent(event) {
    if (this.eventService) {
      this.eventService.dispatchEvent(event);
    }
  }
  /**
   * Replaces the value on the `rowNode` for the specified column. When complete,
   * the grid will refresh the rendered cell on the required row only.
   * **Note**: This method only fires `onCellEditRequest` when the Grid is in **Read Only** mode.
   *
   * @param colKey The column where the value should be updated
   * @param newValue The new value
   * @param eventSource The source of the event
   * @returns `true` if the value was changed, otherwise `false`.
   */
  setDataValue(colKey, newValue, eventSource) {
    const getColumnFromKey = () => {
      var _a;
      if (typeof colKey !== "string") {
        return colKey;
      }
      return (_a = this.beans.columnModel.getGridColumn(colKey)) != null ? _a : this.beans.columnModel.getPrimaryColumn(colKey);
    };
    const column = getColumnFromKey();
    const oldValue = this.getValueFromValueService(column);
    if (this.beans.gridOptionsService.get("readOnlyEdit")) {
      this.dispatchEventForSaveValueReadOnly(column, oldValue, newValue, eventSource);
      return false;
    }
    const valueChanged = this.beans.valueService.setValue(this, column, newValue, eventSource);
    this.dispatchCellChangedEvent(column, newValue, oldValue);
    this.checkRowSelectable();
    return valueChanged;
  }
  getValueFromValueService(column) {
    const lockedClosedGroup = this.leafGroup && this.beans.columnModel.isPivotMode();
    const isOpenGroup = this.group && this.expanded && !this.footer && !lockedClosedGroup;
    const getGroupIncludeFooter = this.beans.gridOptionsService.getGroupIncludeFooter();
    const groupFootersEnabled = getGroupIncludeFooter({ node: this });
    const groupAlwaysShowAggData = this.beans.gridOptionsService.get("groupSuppressBlankHeader");
    const ignoreAggData = isOpenGroup && groupFootersEnabled && !groupAlwaysShowAggData;
    const value = this.beans.valueService.getValue(column, this, false, ignoreAggData);
    return value;
  }
  dispatchEventForSaveValueReadOnly(column, oldValue, newValue, eventSource) {
    const event = this.beans.gridOptionsService.addGridCommonParams({
      type: Events.EVENT_CELL_EDIT_REQUEST,
      event: null,
      rowIndex: this.rowIndex,
      rowPinned: this.rowPinned,
      column,
      colDef: column.getColDef(),
      data: this.data,
      node: this,
      oldValue,
      newValue,
      value: newValue,
      source: eventSource
    });
    this.beans.eventService.dispatchEvent(event);
  }
  setGroupValue(colKey, newValue) {
    const column = this.beans.columnModel.getGridColumn(colKey);
    if (missing(this.groupData)) {
      this.groupData = {};
    }
    const columnId = column.getColId();
    const oldValue = this.groupData[columnId];
    if (oldValue === newValue) {
      return;
    }
    this.groupData[columnId] = newValue;
    this.dispatchCellChangedEvent(column, newValue, oldValue);
  }
  // sets the data for an aggregation
  setAggData(newAggData) {
    const oldAggData = this.aggData;
    this.aggData = newAggData;
    if (this.eventService) {
      const eventFunc = (colId) => {
        const value = this.aggData ? this.aggData[colId] : void 0;
        const oldValue = oldAggData ? oldAggData[colId] : void 0;
        if (value === oldValue) {
          return;
        }
        const column = this.beans.columnModel.lookupGridColumn(colId);
        if (!column) {
          return;
        }
        this.dispatchCellChangedEvent(column, value, oldValue);
      };
      for (const key in this.aggData) {
        eventFunc(key);
      }
      for (const key in newAggData) {
        if (key in this.aggData) {
          continue;
        }
        eventFunc(key);
      }
    }
  }
  updateHasChildren() {
    let newValue = this.group && !this.footer || this.childrenAfterGroup && this.childrenAfterGroup.length > 0;
    const isSsrm = this.beans.gridOptionsService.isRowModelType("serverSide");
    if (isSsrm) {
      const isTreeData = this.beans.gridOptionsService.get("treeData");
      const isGroupFunc = this.beans.gridOptionsService.get("isServerSideGroup");
      newValue = !this.stub && !this.footer && (isTreeData ? !!isGroupFunc && isGroupFunc(this.data) : !!this.group);
    }
    if (newValue !== this.__hasChildren) {
      this.__hasChildren = !!newValue;
      if (this.eventService) {
        this.eventService.dispatchEvent(this.createLocalRowEvent(_RowNode.EVENT_HAS_CHILDREN_CHANGED));
      }
    }
  }
  hasChildren() {
    if (this.__hasChildren == null) {
      this.updateHasChildren();
    }
    return this.__hasChildren;
  }
  isEmptyRowGroupNode() {
    return this.group && missingOrEmpty(this.childrenAfterGroup);
  }
  dispatchCellChangedEvent(column, newValue, oldValue) {
    const cellChangedEvent = {
      type: _RowNode.EVENT_CELL_CHANGED,
      node: this,
      column,
      newValue,
      oldValue
    };
    this.dispatchLocalEvent(cellChangedEvent);
  }
  /**
   * The first time `quickFilter` runs, the grid creates a one-off string representation of the row.
   * This string is then used for the quick filter instead of hitting each column separately.
   * When you edit, using grid editing, this string gets cleared down.
   * However if you edit without using grid editing, you will need to clear this string down for the row to be updated with the new values.
   * Otherwise new values will not work with the `quickFilter`. */
  resetQuickFilterAggregateText() {
    this.quickFilterAggregateText = null;
  }
  /** Returns:
  * - `true` if the node can be expanded, i.e it is a group or master row.
  * - `false` if the node cannot be expanded
  */
  isExpandable() {
    if (this.footer) {
      return false;
    }
    if (this.beans.columnModel.isPivotMode()) {
      return this.hasChildren() && !this.leafGroup;
    }
    return this.hasChildren() || !!this.master;
  }
  /** Returns:
   * - `true` if node is selected,
   * - `false` if the node isn't selected
   * - `undefined` if it's partially selected (group where not all children are selected). */
  isSelected() {
    if (this.footer) {
      return this.sibling.isSelected();
    }
    return this.selected;
  }
  /** Perform a depth-first search of this node and its children. */
  depthFirstSearch(callback) {
    if (this.childrenAfterGroup) {
      this.childrenAfterGroup.forEach((child) => child.depthFirstSearch(callback));
    }
    callback(this);
  }
  // + selectionController.calculatedSelectedForAllGroupNodes()
  calculateSelectedFromChildren() {
    var _a;
    let atLeastOneSelected = false;
    let atLeastOneDeSelected = false;
    let atLeastOneMixed = false;
    if (!((_a = this.childrenAfterGroup) == null ? void 0 : _a.length)) {
      return this.selectable ? this.selected : null;
    }
    for (let i = 0; i < this.childrenAfterGroup.length; i++) {
      const child = this.childrenAfterGroup[i];
      let childState = child.isSelected();
      if (!child.selectable) {
        const selectable = child.calculateSelectedFromChildren();
        if (selectable === null) {
          continue;
        }
        childState = selectable;
      }
      switch (childState) {
        case true:
          atLeastOneSelected = true;
          break;
        case false:
          atLeastOneDeSelected = true;
          break;
        default:
          atLeastOneMixed = true;
          break;
      }
    }
    if (atLeastOneMixed || atLeastOneSelected && atLeastOneDeSelected) {
      return void 0;
    }
    if (atLeastOneSelected) {
      return true;
    }
    if (atLeastOneDeSelected) {
      return false;
    }
    if (!this.selectable) {
      return null;
    }
    return this.selected;
  }
  setSelectedInitialValue(selected) {
    this.selected = selected;
  }
  selectThisNode(newValue, e, source = "api") {
    const selectionNotAllowed = !this.selectable && newValue;
    const selectionNotChanged = this.selected === newValue;
    if (selectionNotAllowed || selectionNotChanged) {
      return false;
    }
    this.selected = newValue;
    if (this.eventService) {
      this.dispatchLocalEvent(this.createLocalRowEvent(_RowNode.EVENT_ROW_SELECTED));
      const sibling = this.sibling;
      if (sibling && sibling.footer) {
        sibling.dispatchLocalEvent(sibling.createLocalRowEvent(_RowNode.EVENT_ROW_SELECTED));
      }
    }
    const event = __spreadProps(__spreadValues({}, this.createGlobalRowEvent(Events.EVENT_ROW_SELECTED)), {
      event: e || null,
      source
    });
    this.beans.eventService.dispatchEvent(event);
    return true;
  }
  /**
   * Select (or deselect) the node.
   * @param newValue -`true` for selection, `false` for deselection.
   * @param clearSelection - If selecting, then passing `true` will select the node exclusively (i.e. NOT do multi select). If doing deselection, `clearSelection` has no impact.
   * @param source - Source property that will appear in the `selectionChanged` event.
   */
  setSelected(newValue, clearSelection = false, source = "api") {
    if (typeof source === "boolean") {
      console.warn("AG Grid: since version v30, rowNode.setSelected() property `suppressFinishActions` has been removed, please use `gridApi.setNodesSelected()` for bulk actions, and the event `source` property for ignoring events instead.");
      return;
    }
    this.setSelectedParams({
      newValue,
      clearSelection,
      rangeSelect: false,
      source
    });
  }
  // this is for internal use only. To make calling code more readable, this is the same method as setSelected except it takes names parameters
  setSelectedParams(params) {
    if (this.rowPinned) {
      console.warn("AG Grid: cannot select pinned rows");
      return 0;
    }
    if (this.id === void 0) {
      console.warn("AG Grid: cannot select node until id for node is known");
      return 0;
    }
    return this.beans.selectionService.setNodesSelected(__spreadProps(__spreadValues({}, params), { nodes: [this.footer ? this.sibling : this] }));
  }
  /**
   * Returns:
   * - `true` if node is either pinned to the `top` or `bottom`
   * - `false` if the node isn't pinned
   */
  isRowPinned() {
    return this.rowPinned === "top" || this.rowPinned === "bottom";
  }
  isParentOfNode(potentialParent) {
    let parentNode = this.parent;
    while (parentNode) {
      if (parentNode === potentialParent) {
        return true;
      }
      parentNode = parentNode.parent;
    }
    return false;
  }
  /** Add an event listener. */
  addEventListener(eventType, userListener) {
    var _a, _b;
    if (!this.eventService) {
      this.eventService = new EventService();
    }
    if (this.beans.frameworkOverrides.shouldWrapOutgoing && !this.frameworkEventListenerService) {
      this.eventService.setFrameworkOverrides(this.beans.frameworkOverrides);
      this.frameworkEventListenerService = new FrameworkEventListenerService(this.beans.frameworkOverrides);
    }
    const listener = (_b = (_a = this.frameworkEventListenerService) == null ? void 0 : _a.wrap(userListener)) != null ? _b : userListener;
    this.eventService.addEventListener(eventType, listener);
  }
  /** Remove event listener. */
  removeEventListener(eventType, userListener) {
    var _a, _b;
    if (!this.eventService) {
      return;
    }
    const listener = (_b = (_a = this.frameworkEventListenerService) == null ? void 0 : _a.unwrap(userListener)) != null ? _b : userListener;
    this.eventService.removeEventListener(eventType, listener);
    if (this.eventService.noRegisteredListenersExist()) {
      this.eventService = null;
    }
  }
  onMouseEnter() {
    this.dispatchLocalEvent(this.createLocalRowEvent(_RowNode.EVENT_MOUSE_ENTER));
  }
  onMouseLeave() {
    this.dispatchLocalEvent(this.createLocalRowEvent(_RowNode.EVENT_MOUSE_LEAVE));
  }
  getFirstChildOfFirstChild(rowGroupColumn) {
    let currentRowNode = this;
    let isCandidate = true;
    let foundFirstChildPath = false;
    let nodeToSwapIn = null;
    while (isCandidate && !foundFirstChildPath) {
      const parentRowNode = currentRowNode.parent;
      const firstChild = exists(parentRowNode) && currentRowNode.firstChild;
      if (firstChild) {
        if (parentRowNode.rowGroupColumn === rowGroupColumn) {
          foundFirstChildPath = true;
          nodeToSwapIn = parentRowNode;
        }
      } else {
        isCandidate = false;
      }
      currentRowNode = parentRowNode;
    }
    return foundFirstChildPath ? nodeToSwapIn : null;
  }
  /**
   * Returns:
   * - `true` if the node is a full width cell
   * - `false` if the node is not a full width cell
   */
  isFullWidthCell() {
    if (this.detail) {
      return true;
    }
    const isFullWidthCellFunc = this.beans.gridOptionsService.getCallback("isFullWidthRow");
    return isFullWidthCellFunc ? isFullWidthCellFunc({ rowNode: this }) : false;
  }
  /**
   * Returns the route of the row node. If the Row Node is a group, it returns the route to that Row Node.
   * If the Row Node is not a group, it returns `undefined`.
   */
  getRoute() {
    if (this.key == null) {
      return;
    }
    const res = [];
    let pointer = this;
    while (pointer.key != null) {
      res.push(pointer.key);
      pointer = pointer.parent;
    }
    return res.reverse();
  }
  createFooter() {
    if (this.sibling) {
      return;
    }
    const ignoredProperties = /* @__PURE__ */ new Set([
      "eventService",
      "__objectId",
      "sticky"
    ]);
    const footerNode = new _RowNode(this.beans);
    Object.keys(this).forEach((key) => {
      if (ignoredProperties.has(key)) {
        return;
      }
      footerNode[key] = this[key];
    });
    footerNode.footer = true;
    footerNode.setRowTop(null);
    footerNode.setRowIndex(null);
    footerNode.oldRowTop = null;
    footerNode.id = "rowGroupFooter_" + this.id;
    footerNode.sibling = this;
    this.sibling = footerNode;
  }
  // Only used by SSRM. In CSRM this is never used as footers should always be present for
  // the purpose of exporting collapsed groups. In SSRM it is not possible to export collapsed
  // groups anyway, so can destroy footers.
  destroyFooter() {
    if (!this.sibling) {
      return;
    }
    this.sibling.setRowTop(null);
    this.sibling.setRowIndex(null);
    this.sibling = void 0;
  }
};
_RowNode.ID_PREFIX_ROW_GROUP = "row-group-";
_RowNode.ID_PREFIX_TOP_PINNED = "t-";
_RowNode.ID_PREFIX_BOTTOM_PINNED = "b-";
_RowNode.OBJECT_ID_SEQUENCE = 0;
_RowNode.EVENT_ROW_SELECTED = "rowSelected";
_RowNode.EVENT_DATA_CHANGED = "dataChanged";
_RowNode.EVENT_CELL_CHANGED = "cellChanged";
_RowNode.EVENT_ALL_CHILDREN_COUNT_CHANGED = "allChildrenCountChanged";
_RowNode.EVENT_MASTER_CHANGED = "masterChanged";
_RowNode.EVENT_GROUP_CHANGED = "groupChanged";
_RowNode.EVENT_MOUSE_ENTER = "mouseEnter";
_RowNode.EVENT_MOUSE_LEAVE = "mouseLeave";
_RowNode.EVENT_HEIGHT_CHANGED = "heightChanged";
_RowNode.EVENT_TOP_CHANGED = "topChanged";
_RowNode.EVENT_DISPLAYED_CHANGED = "displayedChanged";
_RowNode.EVENT_FIRST_CHILD_CHANGED = "firstChildChanged";
_RowNode.EVENT_LAST_CHILD_CHANGED = "lastChildChanged";
_RowNode.EVENT_CHILD_INDEX_CHANGED = "childIndexChanged";
_RowNode.EVENT_ROW_INDEX_CHANGED = "rowIndexChanged";
_RowNode.EVENT_EXPANDED_CHANGED = "expandedChanged";
_RowNode.EVENT_HAS_CHILDREN_CHANGED = "hasChildrenChanged";
_RowNode.EVENT_SELECTABLE_CHANGED = "selectableChanged";
_RowNode.EVENT_UI_LEVEL_CHANGED = "uiLevelChanged";
_RowNode.EVENT_HIGHLIGHT_CHANGED = "rowHighlightChanged";
_RowNode.EVENT_DRAGGING_CHANGED = "draggingChanged";
var RowNode = _RowNode;

// community-modules/core/src/rendering/checkboxSelectionComponent.ts
var CheckboxSelectionComponent = class extends Component {
  constructor() {
    super(
      /* html*/
      `
            <div class="ag-selection-checkbox" role="presentation">
                <ag-checkbox role="presentation" ref="eCheckbox"></ag-checkbox>
            </div>`
    );
  }
  postConstruct() {
    this.eCheckbox.setPassive(true);
  }
  getCheckboxId() {
    return this.eCheckbox.getInputElement().id;
  }
  onDataChanged() {
    this.onSelectionChanged();
  }
  onSelectableChanged() {
    this.showOrHideSelect();
  }
  onSelectionChanged() {
    const translate = this.localeService.getLocaleTextFunc();
    const state = this.rowNode.isSelected();
    const stateName = getAriaCheckboxStateName(translate, state);
    const [ariaKey, ariaLabel] = this.rowNode.selectable ? ["ariaRowToggleSelection", "Press Space to toggle row selection"] : ["ariaRowSelectionDisabled", "Row Selection is disabled for this row"];
    const translatedLabel = translate(ariaKey, ariaLabel);
    this.eCheckbox.setValue(state, true);
    this.eCheckbox.setInputAriaLabel(`${translatedLabel} (${stateName})`);
  }
  onClicked(newValue, groupSelectsFiltered, event) {
    return this.rowNode.setSelectedParams({ newValue, rangeSelect: event.shiftKey, groupSelectsFiltered, event, source: "checkboxSelected" });
  }
  init(params) {
    this.rowNode = params.rowNode;
    this.column = params.column;
    this.overrides = params.overrides;
    this.onSelectionChanged();
    this.addManagedListener(this.eCheckbox.getInputElement(), "dblclick", (event) => {
      stopPropagationForAgGrid(event);
    });
    this.addManagedListener(this.eCheckbox.getInputElement(), "click", (event) => {
      stopPropagationForAgGrid(event);
      const groupSelectsFiltered = this.gridOptionsService.get("groupSelectsFiltered");
      const isSelected = this.eCheckbox.getValue();
      if (this.shouldHandleIndeterminateState(isSelected, groupSelectsFiltered)) {
        const result = this.onClicked(true, groupSelectsFiltered, event || {});
        if (result === 0) {
          this.onClicked(false, groupSelectsFiltered, event);
        }
      } else if (isSelected) {
        this.onClicked(false, groupSelectsFiltered, event);
      } else {
        this.onClicked(true, groupSelectsFiltered, event || {});
      }
    });
    this.addManagedListener(this.rowNode, RowNode.EVENT_ROW_SELECTED, this.onSelectionChanged.bind(this));
    this.addManagedListener(this.rowNode, RowNode.EVENT_DATA_CHANGED, this.onDataChanged.bind(this));
    this.addManagedListener(this.rowNode, RowNode.EVENT_SELECTABLE_CHANGED, this.onSelectableChanged.bind(this));
    const isRowSelectableFunc = this.gridOptionsService.get("isRowSelectable");
    const checkboxVisibleIsDynamic = isRowSelectableFunc || typeof this.getIsVisible() === "function";
    if (checkboxVisibleIsDynamic) {
      const showOrHideSelectListener = this.showOrHideSelect.bind(this);
      this.addManagedListener(this.eventService, Events.EVENT_DISPLAYED_COLUMNS_CHANGED, showOrHideSelectListener);
      this.addManagedListener(this.rowNode, RowNode.EVENT_DATA_CHANGED, showOrHideSelectListener);
      this.addManagedListener(this.rowNode, RowNode.EVENT_CELL_CHANGED, showOrHideSelectListener);
      this.showOrHideSelect();
    }
    this.eCheckbox.getInputElement().setAttribute("tabindex", "-1");
  }
  shouldHandleIndeterminateState(isSelected, groupSelectsFiltered) {
    return groupSelectsFiltered && (this.eCheckbox.getPreviousValue() === void 0 || isSelected === void 0) && this.gridOptionsService.isRowModelType("clientSide");
  }
  showOrHideSelect() {
    var _a, _b, _c;
    let selectable = this.rowNode.selectable;
    const isVisible2 = this.getIsVisible();
    if (selectable) {
      if (typeof isVisible2 === "function") {
        const extraParams = (_a = this.overrides) == null ? void 0 : _a.callbackParams;
        if (!this.column) {
          selectable = isVisible2(__spreadProps(__spreadValues({}, extraParams), { node: this.rowNode, data: this.rowNode.data }));
        } else {
          const params = this.column.createColumnFunctionCallbackParams(this.rowNode);
          selectable = isVisible2(__spreadValues(__spreadValues({}, extraParams), params));
        }
      } else {
        selectable = isVisible2 != null ? isVisible2 : false;
      }
    }
    const disableInsteadOfHide = (_b = this.column) == null ? void 0 : _b.getColDef().showDisabledCheckboxes;
    if (disableInsteadOfHide) {
      this.eCheckbox.setDisabled(!selectable);
      this.setVisible(true);
      this.setDisplayed(true);
      return;
    }
    if ((_c = this.overrides) == null ? void 0 : _c.removeHidden) {
      this.setDisplayed(selectable);
      return;
    }
    this.setVisible(selectable);
  }
  getIsVisible() {
    var _a, _b;
    if (this.overrides) {
      return this.overrides.isVisible;
    }
    return (_b = (_a = this.column) == null ? void 0 : _a.getColDef()) == null ? void 0 : _b.checkboxSelection;
  }
};
__decorateClass([
  RefSelector("eCheckbox")
], CheckboxSelectionComponent.prototype, "eCheckbox", 2);
__decorateClass([
  PostConstruct
], CheckboxSelectionComponent.prototype, "postConstruct", 1);

// community-modules/core/src/constants/direction.ts
var VerticalDirection = /* @__PURE__ */ ((VerticalDirection2) => {
  VerticalDirection2[VerticalDirection2["Up"] = 0] = "Up";
  VerticalDirection2[VerticalDirection2["Down"] = 1] = "Down";
  return VerticalDirection2;
})(VerticalDirection || {});
var HorizontalDirection = /* @__PURE__ */ ((HorizontalDirection2) => {
  HorizontalDirection2[HorizontalDirection2["Left"] = 0] = "Left";
  HorizontalDirection2[HorizontalDirection2["Right"] = 1] = "Right";
  return HorizontalDirection2;
})(HorizontalDirection || {});

// community-modules/core/src/dragAndDrop/dragAndDropService.ts
var DragSourceType = /* @__PURE__ */ ((DragSourceType4) => {
  DragSourceType4[DragSourceType4["ToolPanel"] = 0] = "ToolPanel";
  DragSourceType4[DragSourceType4["HeaderCell"] = 1] = "HeaderCell";
  DragSourceType4[DragSourceType4["RowDrag"] = 2] = "RowDrag";
  DragSourceType4[DragSourceType4["ChartPanel"] = 3] = "ChartPanel";
  DragSourceType4[DragSourceType4["AdvancedFilterBuilder"] = 4] = "AdvancedFilterBuilder";
  return DragSourceType4;
})(DragSourceType || {});
var DragAndDropService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.dragSourceAndParamsList = [];
    this.dropTargets = [];
  }
  init() {
    this.ePinnedIcon = createIcon("columnMovePin", this.gridOptionsService, null);
    this.eHideIcon = createIcon("columnMoveHide", this.gridOptionsService, null);
    this.eMoveIcon = createIcon("columnMoveMove", this.gridOptionsService, null);
    this.eLeftIcon = createIcon("columnMoveLeft", this.gridOptionsService, null);
    this.eRightIcon = createIcon("columnMoveRight", this.gridOptionsService, null);
    this.eGroupIcon = createIcon("columnMoveGroup", this.gridOptionsService, null);
    this.eAggregateIcon = createIcon("columnMoveValue", this.gridOptionsService, null);
    this.ePivotIcon = createIcon("columnMovePivot", this.gridOptionsService, null);
    this.eDropNotAllowedIcon = createIcon("dropNotAllowed", this.gridOptionsService, null);
  }
  addDragSource(dragSource, allowTouch = false) {
    const params = {
      eElement: dragSource.eElement,
      dragStartPixels: dragSource.dragStartPixels,
      onDragStart: this.onDragStart.bind(this, dragSource),
      onDragStop: this.onDragStop.bind(this),
      onDragging: this.onDragging.bind(this),
      includeTouch: allowTouch
    };
    this.dragSourceAndParamsList.push({ params, dragSource });
    this.dragService.addDragSource(params);
  }
  removeDragSource(dragSource) {
    const sourceAndParams = this.dragSourceAndParamsList.find((item) => item.dragSource === dragSource);
    if (sourceAndParams) {
      this.dragService.removeDragSource(sourceAndParams.params);
      removeFromArray(this.dragSourceAndParamsList, sourceAndParams);
    }
  }
  clearDragSourceParamsList() {
    this.dragSourceAndParamsList.forEach((sourceAndParams) => this.dragService.removeDragSource(sourceAndParams.params));
    this.dragSourceAndParamsList.length = 0;
    this.dropTargets.length = 0;
  }
  nudge() {
    if (this.dragging) {
      this.onDragging(this.eventLastTime, true);
    }
  }
  onDragStart(dragSource, mouseEvent) {
    this.dragging = true;
    this.dragSource = dragSource;
    this.eventLastTime = mouseEvent;
    this.dragItem = this.dragSource.getDragItem();
    if (this.dragSource.onDragStarted) {
      this.dragSource.onDragStarted();
    }
    this.createGhost();
  }
  onDragStop(mouseEvent) {
    this.eventLastTime = null;
    this.dragging = false;
    if (this.dragSource.onDragStopped) {
      this.dragSource.onDragStopped();
    }
    if (this.lastDropTarget && this.lastDropTarget.onDragStop) {
      const draggingEvent = this.createDropTargetEvent(this.lastDropTarget, mouseEvent, null, null, false);
      this.lastDropTarget.onDragStop(draggingEvent);
    }
    this.lastDropTarget = null;
    this.dragItem = null;
    this.removeGhost();
  }
  onDragging(mouseEvent, fromNudge) {
    var _a, _b, _c, _d;
    const hDirection = this.getHorizontalDirection(mouseEvent);
    const vDirection = this.getVerticalDirection(mouseEvent);
    this.eventLastTime = mouseEvent;
    this.positionGhost(mouseEvent);
    const validDropTargets = this.dropTargets.filter((target) => this.isMouseOnDropTarget(mouseEvent, target));
    const dropTarget = this.findCurrentDropTarget(mouseEvent, validDropTargets);
    if (dropTarget !== this.lastDropTarget) {
      this.leaveLastTargetIfExists(mouseEvent, hDirection, vDirection, fromNudge);
      if (this.lastDropTarget !== null && dropTarget === null) {
        (_b = (_a = this.dragSource).onGridExit) == null ? void 0 : _b.call(_a, this.dragItem);
      }
      if (this.lastDropTarget === null && dropTarget !== null) {
        (_d = (_c = this.dragSource).onGridEnter) == null ? void 0 : _d.call(_c, this.dragItem);
      }
      this.enterDragTargetIfExists(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
      this.lastDropTarget = dropTarget;
    } else if (dropTarget && dropTarget.onDragging) {
      const draggingEvent = this.createDropTargetEvent(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
      dropTarget.onDragging(draggingEvent);
    }
  }
  getAllContainersFromDropTarget(dropTarget) {
    const secondaryContainers = dropTarget.getSecondaryContainers ? dropTarget.getSecondaryContainers() : null;
    const containers = [[dropTarget.getContainer()]];
    return secondaryContainers ? containers.concat(secondaryContainers) : containers;
  }
  allContainersIntersect(mouseEvent, containers) {
    for (const container of containers) {
      const rect = container.getBoundingClientRect();
      if (rect.width === 0 || rect.height === 0) {
        return false;
      }
      const horizontalFit = mouseEvent.clientX >= rect.left && mouseEvent.clientX < rect.right;
      const verticalFit = mouseEvent.clientY >= rect.top && mouseEvent.clientY < rect.bottom;
      if (!horizontalFit || !verticalFit) {
        return false;
      }
    }
    return true;
  }
  // checks if the mouse is on the drop target. it checks eContainer and eSecondaryContainers
  isMouseOnDropTarget(mouseEvent, dropTarget) {
    const allContainersFromDropTarget = this.getAllContainersFromDropTarget(dropTarget);
    let mouseOverTarget = false;
    for (const currentContainers of allContainersFromDropTarget) {
      if (this.allContainersIntersect(mouseEvent, currentContainers)) {
        mouseOverTarget = true;
        break;
      }
    }
    if (dropTarget.targetContainsSource && !dropTarget.getContainer().contains(this.dragSource.eElement)) {
      return false;
    }
    return mouseOverTarget && dropTarget.isInterestedIn(this.dragSource.type, this.dragSource.eElement);
  }
  findCurrentDropTarget(mouseEvent, validDropTargets) {
    const len = validDropTargets.length;
    if (len === 0) {
      return null;
    }
    if (len === 1) {
      return validDropTargets[0];
    }
    const rootNode = this.gridOptionsService.getRootNode();
    const elementStack = rootNode.elementsFromPoint(mouseEvent.clientX, mouseEvent.clientY);
    for (const el of elementStack) {
      for (const dropTarget of validDropTargets) {
        const containers = flatten(this.getAllContainersFromDropTarget(dropTarget));
        if (containers.indexOf(el) !== -1) {
          return dropTarget;
        }
      }
    }
    return null;
  }
  enterDragTargetIfExists(dropTarget, mouseEvent, hDirection, vDirection, fromNudge) {
    if (!dropTarget) {
      return;
    }
    if (dropTarget.onDragEnter) {
      const dragEnterEvent = this.createDropTargetEvent(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
      dropTarget.onDragEnter(dragEnterEvent);
    }
    this.setGhostIcon(dropTarget.getIconName ? dropTarget.getIconName() : null);
  }
  leaveLastTargetIfExists(mouseEvent, hDirection, vDirection, fromNudge) {
    if (!this.lastDropTarget) {
      return;
    }
    if (this.lastDropTarget.onDragLeave) {
      const dragLeaveEvent = this.createDropTargetEvent(this.lastDropTarget, mouseEvent, hDirection, vDirection, fromNudge);
      this.lastDropTarget.onDragLeave(dragLeaveEvent);
    }
    this.setGhostIcon(null);
  }
  addDropTarget(dropTarget) {
    this.dropTargets.push(dropTarget);
  }
  removeDropTarget(dropTarget) {
    this.dropTargets = this.dropTargets.filter((target) => target.getContainer() !== dropTarget.getContainer());
  }
  hasExternalDropZones() {
    return this.dropTargets.some((zones) => zones.external);
  }
  findExternalZone(params) {
    const externalTargets = this.dropTargets.filter((target) => target.external);
    return externalTargets.find((zone) => zone.getContainer() === params.getContainer()) || null;
  }
  getHorizontalDirection(event) {
    const clientX = this.eventLastTime && this.eventLastTime.clientX;
    const eClientX = event.clientX;
    if (clientX === eClientX) {
      return null;
    }
    return clientX > eClientX ? 0 /* Left */ : 1 /* Right */;
  }
  getVerticalDirection(event) {
    const clientY = this.eventLastTime && this.eventLastTime.clientY;
    const eClientY = event.clientY;
    if (clientY === eClientY) {
      return null;
    }
    return clientY > eClientY ? 0 /* Up */ : 1 /* Down */;
  }
  createDropTargetEvent(dropTarget, event, hDirection, vDirection, fromNudge) {
    const dropZoneTarget = dropTarget.getContainer();
    const rect = dropZoneTarget.getBoundingClientRect();
    const { gridApi: api, columnApi, dragItem, dragSource } = this;
    const x = event.clientX - rect.left;
    const y = event.clientY - rect.top;
    return { event, x, y, vDirection, hDirection, dragSource, fromNudge, dragItem, api, columnApi, dropZoneTarget };
  }
  positionGhost(event) {
    const ghost = this.eGhost;
    if (!ghost) {
      return;
    }
    const ghostRect = ghost.getBoundingClientRect();
    const ghostHeight = ghostRect.height;
    const browserWidth = getBodyWidth() - 2;
    const browserHeight = getBodyHeight() - 2;
    const offsetParentSize = getElementRectWithOffset(ghost.offsetParent);
    const { clientY, clientX } = event;
    let top = clientY - offsetParentSize.top - ghostHeight / 2;
    let left = clientX - offsetParentSize.left - 10;
    const eDocument = this.gridOptionsService.getDocument();
    const win = eDocument.defaultView || window;
    const windowScrollY = win.pageYOffset || eDocument.documentElement.scrollTop;
    const windowScrollX = win.pageXOffset || eDocument.documentElement.scrollLeft;
    if (browserWidth > 0 && left + ghost.clientWidth > browserWidth + windowScrollX) {
      left = browserWidth + windowScrollX - ghost.clientWidth;
    }
    if (left < 0) {
      left = 0;
    }
    if (browserHeight > 0 && top + ghost.clientHeight > browserHeight + windowScrollY) {
      top = browserHeight + windowScrollY - ghost.clientHeight;
    }
    if (top < 0) {
      top = 0;
    }
    ghost.style.left = `${left}px`;
    ghost.style.top = `${top}px`;
  }
  removeGhost() {
    if (this.eGhost && this.eGhostParent) {
      this.eGhostParent.removeChild(this.eGhost);
    }
    this.eGhost = null;
  }
  createGhost() {
    this.eGhost = loadTemplate(DragAndDropService.GHOST_TEMPLATE);
    this.mouseEventService.stampTopLevelGridCompWithGridInstance(this.eGhost);
    const { theme } = this.environment.getTheme();
    if (theme) {
      this.eGhost.classList.add(theme);
    }
    this.eGhostIcon = this.eGhost.querySelector(".ag-dnd-ghost-icon");
    this.setGhostIcon(null);
    const eText = this.eGhost.querySelector(".ag-dnd-ghost-label");
    let dragItemName = this.dragSource.dragItemName;
    if (isFunction(dragItemName)) {
      dragItemName = dragItemName();
    }
    eText.innerHTML = escapeString(dragItemName) || "";
    this.eGhost.style.height = "25px";
    this.eGhost.style.top = "20px";
    this.eGhost.style.left = "20px";
    const eDocument = this.gridOptionsService.getDocument();
    let rootNode = null;
    let targetEl = null;
    try {
      rootNode = eDocument.fullscreenElement;
    } catch (e) {
    } finally {
      if (!rootNode) {
        rootNode = this.gridOptionsService.getRootNode();
      }
      const body = rootNode.querySelector("body");
      if (body) {
        targetEl = body;
      } else if (rootNode instanceof ShadowRoot) {
        targetEl = rootNode;
      } else if (rootNode instanceof Document) {
        targetEl = rootNode == null ? void 0 : rootNode.documentElement;
      } else {
        targetEl = rootNode;
      }
    }
    this.eGhostParent = targetEl;
    if (!this.eGhostParent) {
      console.warn("AG Grid: could not find document body, it is needed for dragging columns");
    } else {
      this.eGhostParent.appendChild(this.eGhost);
    }
  }
  setGhostIcon(iconName, shake = false) {
    clearElement(this.eGhostIcon);
    let eIcon = null;
    if (!iconName) {
      iconName = this.dragSource.getDefaultIconName ? this.dragSource.getDefaultIconName() : DragAndDropService.ICON_NOT_ALLOWED;
    }
    switch (iconName) {
      case DragAndDropService.ICON_PINNED:
        eIcon = this.ePinnedIcon;
        break;
      case DragAndDropService.ICON_MOVE:
        eIcon = this.eMoveIcon;
        break;
      case DragAndDropService.ICON_LEFT:
        eIcon = this.eLeftIcon;
        break;
      case DragAndDropService.ICON_RIGHT:
        eIcon = this.eRightIcon;
        break;
      case DragAndDropService.ICON_GROUP:
        eIcon = this.eGroupIcon;
        break;
      case DragAndDropService.ICON_AGGREGATE:
        eIcon = this.eAggregateIcon;
        break;
      case DragAndDropService.ICON_PIVOT:
        eIcon = this.ePivotIcon;
        break;
      case DragAndDropService.ICON_NOT_ALLOWED:
        eIcon = this.eDropNotAllowedIcon;
        break;
      case DragAndDropService.ICON_HIDE:
        eIcon = this.eHideIcon;
        break;
    }
    this.eGhostIcon.classList.toggle("ag-shake-left-to-right", shake);
    if (eIcon === this.eHideIcon && this.gridOptionsService.get("suppressDragLeaveHidesColumns")) {
      return;
    }
    if (eIcon) {
      this.eGhostIcon.appendChild(eIcon);
    }
  }
};
DragAndDropService.ICON_PINNED = "pinned";
DragAndDropService.ICON_MOVE = "move";
DragAndDropService.ICON_LEFT = "left";
DragAndDropService.ICON_RIGHT = "right";
DragAndDropService.ICON_GROUP = "group";
DragAndDropService.ICON_AGGREGATE = "aggregate";
DragAndDropService.ICON_PIVOT = "pivot";
DragAndDropService.ICON_NOT_ALLOWED = "notAllowed";
DragAndDropService.ICON_HIDE = "hide";
DragAndDropService.GHOST_TEMPLATE = /* html */
`<div class="ag-dnd-ghost ag-unselectable">
            <span class="ag-dnd-ghost-icon ag-shake-left-to-right"></span>
            <div class="ag-dnd-ghost-label"></div>
        </div>`;
__decorateClass([
  Autowired("dragService")
], DragAndDropService.prototype, "dragService", 2);
__decorateClass([
  Autowired("mouseEventService")
], DragAndDropService.prototype, "mouseEventService", 2);
__decorateClass([
  Autowired("columnApi")
], DragAndDropService.prototype, "columnApi", 2);
__decorateClass([
  Autowired("gridApi")
], DragAndDropService.prototype, "gridApi", 2);
__decorateClass([
  PostConstruct
], DragAndDropService.prototype, "init", 1);
__decorateClass([
  PreDestroy
], DragAndDropService.prototype, "clearDragSourceParamsList", 1);
DragAndDropService = __decorateClass([
  Bean("dragAndDropService")
], DragAndDropService);

// community-modules/core/src/rendering/row/rowDragComp.ts
var RowDragComp = class extends Component {
  constructor(cellValueFn, rowNode, column, customGui, dragStartPixels, suppressVisibilityChange) {
    super();
    this.cellValueFn = cellValueFn;
    this.rowNode = rowNode;
    this.column = column;
    this.customGui = customGui;
    this.dragStartPixels = dragStartPixels;
    this.suppressVisibilityChange = suppressVisibilityChange;
    this.dragSource = null;
  }
  isCustomGui() {
    return this.customGui != null;
  }
  postConstruct() {
    if (!this.customGui) {
      this.setTemplate(
        /* html */
        `<div class="ag-drag-handle ag-row-drag" aria-hidden="true"></div>`
      );
      this.getGui().appendChild(createIconNoSpan("rowDrag", this.gridOptionsService, null));
      this.addDragSource();
    } else {
      this.setDragElement(this.customGui, this.dragStartPixels);
    }
    this.checkCompatibility();
    if (!this.suppressVisibilityChange) {
      const strategy = this.gridOptionsService.get("rowDragManaged") ? new ManagedVisibilityStrategy(this, this.beans, this.rowNode, this.column) : new NonManagedVisibilityStrategy(this, this.beans, this.rowNode, this.column);
      this.createManagedBean(strategy, this.beans.context);
    }
  }
  setDragElement(dragElement, dragStartPixels) {
    this.setTemplateFromElement(dragElement);
    this.addDragSource(dragStartPixels);
  }
  getSelectedNodes() {
    const isRowDragMultiRow = this.gridOptionsService.get("rowDragMultiRow");
    if (!isRowDragMultiRow) {
      return [this.rowNode];
    }
    const selection = this.beans.selectionService.getSelectedNodes();
    return selection.indexOf(this.rowNode) !== -1 ? selection : [this.rowNode];
  }
  // returns true if all compatibility items work out
  checkCompatibility() {
    const managed = this.gridOptionsService.get("rowDragManaged");
    const treeData = this.gridOptionsService.get("treeData");
    if (treeData && managed) {
      warnOnce("If using row drag with tree data, you cannot have rowDragManaged=true");
    }
  }
  getDragItem() {
    return {
      rowNode: this.rowNode,
      rowNodes: this.getSelectedNodes(),
      columns: this.column ? [this.column] : void 0,
      defaultTextValue: this.cellValueFn()
    };
  }
  getRowDragText(column) {
    if (column) {
      const colDef = column.getColDef();
      if (colDef.rowDragText) {
        return colDef.rowDragText;
      }
    }
    return this.gridOptionsService.get("rowDragText");
  }
  addDragSource(dragStartPixels = 4) {
    if (this.dragSource) {
      this.removeDragSource();
    }
    const translate = this.localeService.getLocaleTextFunc();
    this.dragSource = {
      type: 2 /* RowDrag */,
      eElement: this.getGui(),
      dragItemName: () => {
        var _a;
        const dragItem = this.getDragItem();
        const dragItemCount = ((_a = dragItem.rowNodes) == null ? void 0 : _a.length) || 1;
        const rowDragText = this.getRowDragText(this.column);
        if (rowDragText) {
          return rowDragText(dragItem, dragItemCount);
        }
        return dragItemCount === 1 ? this.cellValueFn() : `${dragItemCount} ${translate("rowDragRows", "rows")}`;
      },
      getDragItem: () => this.getDragItem(),
      dragStartPixels,
      dragSourceDomDataKey: this.gridOptionsService.getDomDataKey()
    };
    this.beans.dragAndDropService.addDragSource(this.dragSource, true);
  }
  removeDragSource() {
    if (this.dragSource) {
      this.beans.dragAndDropService.removeDragSource(this.dragSource);
    }
    this.dragSource = null;
  }
};
__decorateClass([
  Autowired("beans")
], RowDragComp.prototype, "beans", 2);
__decorateClass([
  PostConstruct
], RowDragComp.prototype, "postConstruct", 1);
__decorateClass([
  PreDestroy
], RowDragComp.prototype, "removeDragSource", 1);
var VisibilityStrategy = class extends BeanStub {
  constructor(parent, rowNode, column) {
    super();
    this.parent = parent;
    this.rowNode = rowNode;
    this.column = column;
  }
  setDisplayedOrVisible(neverDisplayed) {
    const displayedOptions = { skipAriaHidden: true };
    if (neverDisplayed) {
      this.parent.setDisplayed(false, displayedOptions);
    } else {
      let shown = true;
      let isShownSometimes = false;
      if (this.column) {
        shown = this.column.isRowDrag(this.rowNode) || this.parent.isCustomGui();
        isShownSometimes = isFunction(this.column.getColDef().rowDrag);
      }
      if (isShownSometimes) {
        this.parent.setDisplayed(true, displayedOptions);
        this.parent.setVisible(shown, displayedOptions);
      } else {
        this.parent.setDisplayed(shown, displayedOptions);
        this.parent.setVisible(true, displayedOptions);
      }
    }
  }
};
var NonManagedVisibilityStrategy = class extends VisibilityStrategy {
  constructor(parent, beans, rowNode, column) {
    super(parent, rowNode, column);
    this.beans = beans;
  }
  postConstruct() {
    this.addManagedPropertyListener("suppressRowDrag", this.onSuppressRowDrag.bind(this));
    this.addManagedListener(this.rowNode, RowNode.EVENT_DATA_CHANGED, this.workOutVisibility.bind(this));
    this.addManagedListener(this.rowNode, RowNode.EVENT_CELL_CHANGED, this.workOutVisibility.bind(this));
    this.addManagedListener(this.rowNode, RowNode.EVENT_CELL_CHANGED, this.workOutVisibility.bind(this));
    this.addManagedListener(this.beans.eventService, Events.EVENT_NEW_COLUMNS_LOADED, this.workOutVisibility.bind(this));
    this.workOutVisibility();
  }
  onSuppressRowDrag() {
    this.workOutVisibility();
  }
  workOutVisibility() {
    const neverDisplayed = this.gridOptionsService.get("suppressRowDrag");
    this.setDisplayedOrVisible(neverDisplayed);
  }
};
__decorateClass([
  PostConstruct
], NonManagedVisibilityStrategy.prototype, "postConstruct", 1);
var ManagedVisibilityStrategy = class extends VisibilityStrategy {
  constructor(parent, beans, rowNode, column) {
    super(parent, rowNode, column);
    this.beans = beans;
  }
  postConstruct() {
    this.addManagedListener(this.beans.eventService, Events.EVENT_SORT_CHANGED, this.workOutVisibility.bind(this));
    this.addManagedListener(this.beans.eventService, Events.EVENT_FILTER_CHANGED, this.workOutVisibility.bind(this));
    this.addManagedListener(this.beans.eventService, Events.EVENT_COLUMN_ROW_GROUP_CHANGED, this.workOutVisibility.bind(this));
    this.addManagedListener(this.beans.eventService, Events.EVENT_NEW_COLUMNS_LOADED, this.workOutVisibility.bind(this));
    this.addManagedListener(this.rowNode, RowNode.EVENT_DATA_CHANGED, this.workOutVisibility.bind(this));
    this.addManagedListener(this.rowNode, RowNode.EVENT_CELL_CHANGED, this.workOutVisibility.bind(this));
    this.addManagedPropertyListener("suppressRowDrag", this.onSuppressRowDrag.bind(this));
    this.workOutVisibility();
  }
  onSuppressRowDrag() {
    this.workOutVisibility();
  }
  workOutVisibility() {
    const gridBodyCon = this.beans.ctrlsService.getGridBodyCtrl();
    const rowDragFeature = gridBodyCon.getRowDragFeature();
    const shouldPreventRowMove = rowDragFeature && rowDragFeature.shouldPreventRowMove();
    const suppressRowDrag = this.gridOptionsService.get("suppressRowDrag");
    const hasExternalDropZones = this.beans.dragAndDropService.hasExternalDropZones();
    const neverDisplayed = shouldPreventRowMove && !hasExternalDropZones || suppressRowDrag;
    this.setDisplayedOrVisible(neverDisplayed);
  }
};
__decorateClass([
  PostConstruct
], ManagedVisibilityStrategy.prototype, "postConstruct", 1);

// community-modules/core/src/rendering/cellRenderers/groupCellRendererCtrl.ts
var GroupCellRendererCtrl = class extends BeanStub {
  init(comp, eGui, eCheckbox, eExpanded, eContracted, compClass, params) {
    var _a, _b, _c, _d;
    this.params = params;
    this.eGui = eGui;
    this.eCheckbox = eCheckbox;
    this.eExpanded = eExpanded;
    this.eContracted = eContracted;
    this.comp = comp;
    this.compClass = compClass;
    const { node, value, colDef } = params;
    const topLevelFooter = this.isTopLevelFooter();
    if (!topLevelFooter) {
      const embeddedRowMismatch = this.isEmbeddedRowMismatch();
      if (embeddedRowMismatch) {
        return;
      }
      if (node.footer && this.gridOptionsService.get("groupHideOpenParents")) {
        const showRowGroup = colDef && colDef.showRowGroup;
        const rowGroupColumnId = node.rowGroupColumn && node.rowGroupColumn.getColId();
        if (showRowGroup !== rowGroupColumnId) {
          return;
        }
      }
    }
    this.setupShowingValueForOpenedParent();
    this.findDisplayedGroupNode();
    if (!topLevelFooter) {
      const showingFooterTotal = params.node.footer && params.node.rowGroupIndex === this.columnModel.getRowGroupColumns().findIndex((c) => {
        var _a2;
        return c.getColId() === ((_a2 = params.colDef) == null ? void 0 : _a2.showRowGroup);
      });
      const isAlwaysShowing = this.gridOptionsService.get("groupDisplayType") != "multipleColumns" || this.gridOptionsService.get("treeData");
      const showOpenGroupValue = isAlwaysShowing || this.gridOptionsService.get("showOpenedGroup") && !params.node.footer && (!params.node.group || params.node.rowGroupIndex != null && params.node.rowGroupIndex > this.columnModel.getRowGroupColumns().findIndex((c) => {
        var _a2;
        return c.getColId() === ((_a2 = params.colDef) == null ? void 0 : _a2.showRowGroup);
      }));
      const leafWithValues = !node.group && (((_a = this.params.colDef) == null ? void 0 : _a.field) || ((_b = this.params.colDef) == null ? void 0 : _b.valueGetter));
      const isExpandable = this.isExpandable();
      const showPivotModeLeafValue = this.columnModel.isPivotMode() && node.leafGroup && ((_c = node.rowGroupColumn) == null ? void 0 : _c.getColId()) === ((_d = params.column) == null ? void 0 : _d.getColDef().showRowGroup);
      const canSkipRenderingCell = !this.showingValueForOpenedParent && !isExpandable && !leafWithValues && !showOpenGroupValue && !showingFooterTotal && !showPivotModeLeafValue;
      if (canSkipRenderingCell) {
        return;
      }
    }
    this.addExpandAndContract();
    this.addFullWidthRowDraggerIfNeeded();
    this.addCheckboxIfNeeded();
    this.addValueElement();
    this.setupIndent();
    this.refreshAriaExpanded();
  }
  getCellAriaRole() {
    var _a, _b;
    const colDefAriaRole = (_a = this.params.colDef) == null ? void 0 : _a.cellAriaRole;
    const columnColDefAriaRole = (_b = this.params.column) == null ? void 0 : _b.getColDef().cellAriaRole;
    return colDefAriaRole || columnColDefAriaRole || "gridcell";
  }
  destroy() {
    super.destroy();
    this.expandListener = null;
  }
  refreshAriaExpanded() {
    const { node, eGridCell } = this.params;
    if (this.expandListener) {
      this.expandListener = this.expandListener();
    }
    if (!this.isExpandable()) {
      removeAriaExpanded(eGridCell);
      return;
    }
    const listener = () => {
      setAriaExpanded(eGridCell, !!node.expanded);
    };
    this.expandListener = this.addManagedListener(node, RowNode.EVENT_EXPANDED_CHANGED, listener) || null;
    listener();
  }
  isTopLevelFooter() {
    if (!this.gridOptionsService.get("groupIncludeTotalFooter")) {
      return false;
    }
    if (this.params.value != null || this.params.node.level != -1) {
      return false;
    }
    const colDef = this.params.colDef;
    const doingFullWidth = colDef == null;
    if (doingFullWidth) {
      return true;
    }
    if (colDef.showRowGroup === true) {
      return true;
    }
    const rowGroupCols = this.columnModel.getRowGroupColumns();
    if (!rowGroupCols || rowGroupCols.length === 0) {
      return true;
    }
    const firstRowGroupCol = rowGroupCols[0];
    return firstRowGroupCol.getId() === colDef.showRowGroup;
  }
  // if we are doing embedded full width rows, we only show the renderer when
  // in the body, or if pinning in the pinned section, or if pinning and RTL,
  // in the right section. otherwise we would have the cell repeated in each section.
  isEmbeddedRowMismatch() {
    if (!this.params.fullWidth || !this.gridOptionsService.get("embedFullWidthRows")) {
      return false;
    }
    const pinnedLeftCell = this.params.pinned === "left";
    const pinnedRightCell = this.params.pinned === "right";
    const bodyCell = !pinnedLeftCell && !pinnedRightCell;
    if (this.gridOptionsService.get("enableRtl")) {
      if (this.columnModel.isPinningLeft()) {
        return !pinnedRightCell;
      }
      return !bodyCell;
    }
    if (this.columnModel.isPinningLeft()) {
      return !pinnedLeftCell;
    }
    return !bodyCell;
  }
  findDisplayedGroupNode() {
    const column = this.params.column;
    const rowNode = this.params.node;
    if (this.showingValueForOpenedParent) {
      let pointer = rowNode.parent;
      while (pointer != null) {
        if (pointer.rowGroupColumn && column.isRowGroupDisplayed(pointer.rowGroupColumn.getId())) {
          this.displayedGroupNode = pointer;
          break;
        }
        pointer = pointer.parent;
      }
    }
    if (missing(this.displayedGroupNode)) {
      this.displayedGroupNode = rowNode;
    }
  }
  setupShowingValueForOpenedParent() {
    const rowNode = this.params.node;
    const column = this.params.column;
    if (!this.gridOptionsService.get("groupHideOpenParents")) {
      this.showingValueForOpenedParent = false;
      return;
    }
    if (!rowNode.groupData) {
      this.showingValueForOpenedParent = false;
      return;
    }
    const showingGroupNode = rowNode.rowGroupColumn != null;
    if (showingGroupNode) {
      const keyOfGroupingColumn = rowNode.rowGroupColumn.getId();
      const configuredToShowThisGroupLevel = column.isRowGroupDisplayed(keyOfGroupingColumn);
      if (configuredToShowThisGroupLevel) {
        this.showingValueForOpenedParent = false;
        return;
      }
    }
    const valPresent = rowNode.groupData[column.getId()] != null;
    this.showingValueForOpenedParent = valPresent;
  }
  addValueElement() {
    if (this.displayedGroupNode.footer) {
      this.addFooterValue();
    } else {
      this.addGroupValue();
      this.addChildCount();
    }
  }
  addGroupValue() {
    var _a;
    const paramsAdjusted = this.adjustParamsWithDetailsFromRelatedColumn();
    const innerCompDetails = this.getInnerCompDetails(paramsAdjusted);
    const { valueFormatted, value } = paramsAdjusted;
    let valueWhenNoRenderer = valueFormatted;
    if (valueWhenNoRenderer == null) {
      const isGroupColForNode = this.displayedGroupNode.rowGroupColumn && ((_a = this.params.column) == null ? void 0 : _a.isRowGroupDisplayed(this.displayedGroupNode.rowGroupColumn.getId()));
      if (this.displayedGroupNode.key === "" && this.displayedGroupNode.group && isGroupColForNode) {
        const localeTextFunc = this.localeService.getLocaleTextFunc();
        valueWhenNoRenderer = localeTextFunc("blanks", "(Blanks)");
      } else {
        valueWhenNoRenderer = value != null ? value : null;
      }
    }
    this.comp.setInnerRenderer(innerCompDetails, valueWhenNoRenderer);
  }
  adjustParamsWithDetailsFromRelatedColumn() {
    const relatedColumn = this.displayedGroupNode.rowGroupColumn;
    const column = this.params.column;
    if (!relatedColumn) {
      return this.params;
    }
    const notFullWidth = column != null;
    if (notFullWidth) {
      const showingThisRowGroup = column.isRowGroupDisplayed(relatedColumn.getId());
      if (!showingThisRowGroup) {
        return this.params;
      }
    }
    const params = this.params;
    const { value, node } = this.params;
    const valueFormatted = this.valueFormatterService.formatValue(relatedColumn, node, value);
    const paramsAdjusted = __spreadProps(__spreadValues({}, params), {
      valueFormatted
    });
    return paramsAdjusted;
  }
  addFooterValue() {
    const footerValueGetter = this.params.footerValueGetter;
    let footerValue = "";
    if (footerValueGetter) {
      const paramsClone = cloneObject(this.params);
      paramsClone.value = this.params.value;
      if (typeof footerValueGetter === "function") {
        footerValue = footerValueGetter(paramsClone);
      } else if (typeof footerValueGetter === "string") {
        footerValue = this.expressionService.evaluate(footerValueGetter, paramsClone);
      } else {
        console.warn("AG Grid: footerValueGetter should be either a function or a string (expression)");
      }
    } else {
      const localeTextFunc = this.localeService.getLocaleTextFunc();
      const footerTotalPrefix = localeTextFunc("footerTotal", "Total");
      footerValue = footerTotalPrefix + " " + (this.params.value != null ? this.params.value : "");
    }
    const innerCompDetails = this.getInnerCompDetails(this.params);
    this.comp.setInnerRenderer(innerCompDetails, footerValue);
  }
  getInnerCompDetails(params) {
    if (params.fullWidth) {
      return this.userComponentFactory.getFullWidthGroupRowInnerCellRenderer(
        this.gridOptionsService.get("groupRowRendererParams"),
        params
      );
    }
    const innerCompDetails = this.userComponentFactory.getInnerRendererDetails(params, params);
    const isGroupRowRenderer = (details) => details && details.componentClass == this.compClass;
    if (innerCompDetails && !isGroupRowRenderer(innerCompDetails)) {
      return innerCompDetails;
    }
    const relatedColumn = this.displayedGroupNode.rowGroupColumn;
    const relatedColDef = relatedColumn ? relatedColumn.getColDef() : void 0;
    if (!relatedColDef) {
      return;
    }
    const relatedCompDetails = this.userComponentFactory.getCellRendererDetails(relatedColDef, params);
    if (relatedCompDetails && !isGroupRowRenderer(relatedCompDetails)) {
      return relatedCompDetails;
    }
    if (isGroupRowRenderer(relatedCompDetails) && relatedColDef.cellRendererParams && relatedColDef.cellRendererParams.innerRenderer) {
      const res = this.userComponentFactory.getInnerRendererDetails(relatedColDef.cellRendererParams, params);
      return res;
    }
  }
  addChildCount() {
    if (this.params.suppressCount) {
      return;
    }
    this.addManagedListener(this.displayedGroupNode, RowNode.EVENT_ALL_CHILDREN_COUNT_CHANGED, this.updateChildCount.bind(this));
    this.updateChildCount();
  }
  updateChildCount() {
    const allChildrenCount = this.displayedGroupNode.allChildrenCount;
    const showingGroupForThisNode = this.isShowRowGroupForThisRow();
    const showCount = showingGroupForThisNode && allChildrenCount != null && allChildrenCount >= 0;
    const countString = showCount ? `(${allChildrenCount})` : ``;
    this.comp.setChildCount(countString);
  }
  isShowRowGroupForThisRow() {
    if (this.gridOptionsService.get("treeData")) {
      return true;
    }
    const rowGroupColumn = this.displayedGroupNode.rowGroupColumn;
    if (!rowGroupColumn) {
      return false;
    }
    const column = this.params.column;
    const thisColumnIsInterested = column == null || column.isRowGroupDisplayed(rowGroupColumn.getId());
    return thisColumnIsInterested;
  }
  addExpandAndContract() {
    var _a;
    const params = this.params;
    const eExpandedIcon = createIconNoSpan("groupExpanded", this.gridOptionsService, null);
    const eContractedIcon = createIconNoSpan("groupContracted", this.gridOptionsService, null);
    if (eExpandedIcon) {
      this.eExpanded.appendChild(eExpandedIcon);
    }
    if (eContractedIcon) {
      this.eContracted.appendChild(eContractedIcon);
    }
    const eGroupCell = params.eGridCell;
    const isDoubleClickEdit = ((_a = this.params.column) == null ? void 0 : _a.isCellEditable(params.node)) && this.gridOptionsService.get("enableGroupEdit");
    if (!isDoubleClickEdit && this.isExpandable() && !params.suppressDoubleClickExpand) {
      this.addManagedListener(eGroupCell, "dblclick", this.onCellDblClicked.bind(this));
    }
    this.addManagedListener(this.eExpanded, "click", this.onExpandClicked.bind(this));
    this.addManagedListener(this.eContracted, "click", this.onExpandClicked.bind(this));
    this.addManagedListener(eGroupCell, "keydown", this.onKeyDown.bind(this));
    this.addManagedListener(params.node, RowNode.EVENT_EXPANDED_CHANGED, this.showExpandAndContractIcons.bind(this));
    this.showExpandAndContractIcons();
    const expandableChangedListener = this.onRowNodeIsExpandableChanged.bind(this);
    this.addManagedListener(this.displayedGroupNode, RowNode.EVENT_ALL_CHILDREN_COUNT_CHANGED, expandableChangedListener);
    this.addManagedListener(this.displayedGroupNode, RowNode.EVENT_MASTER_CHANGED, expandableChangedListener);
    this.addManagedListener(this.displayedGroupNode, RowNode.EVENT_GROUP_CHANGED, expandableChangedListener);
    this.addManagedListener(this.displayedGroupNode, RowNode.EVENT_HAS_CHILDREN_CHANGED, expandableChangedListener);
  }
  onExpandClicked(mouseEvent) {
    if (isStopPropagationForAgGrid(mouseEvent)) {
      return;
    }
    stopPropagationForAgGrid(mouseEvent);
    this.onExpandOrContract(mouseEvent);
  }
  onExpandOrContract(e) {
    const rowNode = this.displayedGroupNode;
    const nextExpandState = !rowNode.expanded;
    if (!nextExpandState && rowNode.sticky) {
      this.scrollToStickyNode(rowNode);
    }
    rowNode.setExpanded(nextExpandState, e);
  }
  scrollToStickyNode(rowNode) {
    const gridBodyCtrl = this.ctrlsService.getGridBodyCtrl();
    const scrollFeature = gridBodyCtrl.getScrollFeature();
    scrollFeature.setVerticalScrollPosition(rowNode.rowTop - rowNode.stickyRowTop);
  }
  isExpandable() {
    if (this.showingValueForOpenedParent) {
      return true;
    }
    const rowNode = this.displayedGroupNode;
    const reducedLeafNode = this.columnModel.isPivotMode() && rowNode.leafGroup;
    const expandableGroup = rowNode.isExpandable() && !rowNode.footer && !reducedLeafNode;
    if (!expandableGroup) {
      return false;
    }
    const column = this.params.column;
    const displayingForOneColumnOnly = column != null && typeof column.getColDef().showRowGroup === "string";
    if (displayingForOneColumnOnly) {
      const showing = this.isShowRowGroupForThisRow();
      return showing;
    }
    return true;
  }
  showExpandAndContractIcons() {
    const { params, displayedGroupNode: displayedGroup, columnModel } = this;
    const { node } = params;
    const isExpandable = this.isExpandable();
    if (isExpandable) {
      const expanded = this.showingValueForOpenedParent ? true : node.expanded;
      this.comp.setExpandedDisplayed(expanded);
      this.comp.setContractedDisplayed(!expanded);
    } else {
      this.comp.setExpandedDisplayed(false);
      this.comp.setContractedDisplayed(false);
    }
    const pivotMode = columnModel.isPivotMode();
    const pivotModeAndLeafGroup = pivotMode && displayedGroup.leafGroup;
    const addExpandableCss = isExpandable && !pivotModeAndLeafGroup;
    const isTotalFooterNode = node.footer && node.level === -1;
    this.comp.addOrRemoveCssClass("ag-cell-expandable", addExpandableCss);
    this.comp.addOrRemoveCssClass("ag-row-group", addExpandableCss);
    if (pivotMode) {
      this.comp.addOrRemoveCssClass("ag-pivot-leaf-group", pivotModeAndLeafGroup);
    } else if (!isTotalFooterNode) {
      this.comp.addOrRemoveCssClass("ag-row-group-leaf-indent", !addExpandableCss);
    }
  }
  onRowNodeIsExpandableChanged() {
    this.showExpandAndContractIcons();
    this.setIndent();
    this.refreshAriaExpanded();
  }
  setupIndent() {
    const node = this.params.node;
    const suppressPadding = this.params.suppressPadding;
    if (!suppressPadding) {
      this.addManagedListener(node, RowNode.EVENT_UI_LEVEL_CHANGED, this.setIndent.bind(this));
      this.setIndent();
    }
  }
  setIndent() {
    if (this.gridOptionsService.get("groupHideOpenParents")) {
      return;
    }
    const params = this.params;
    const rowNode = params.node;
    const fullWithRow = !!params.colDef;
    const treeData = this.gridOptionsService.get("treeData");
    const manyDimensionThisColumn = !fullWithRow || treeData || params.colDef.showRowGroup === true;
    const paddingCount = manyDimensionThisColumn ? rowNode.uiLevel : 0;
    if (this.indentClass) {
      this.comp.addOrRemoveCssClass(this.indentClass, false);
    }
    this.indentClass = "ag-row-group-indent-" + paddingCount;
    this.comp.addOrRemoveCssClass(this.indentClass, true);
  }
  addFullWidthRowDraggerIfNeeded() {
    if (!this.params.fullWidth || !this.params.rowDrag) {
      return;
    }
    const rowDragComp = new RowDragComp(() => this.params.value, this.params.node);
    this.createManagedBean(rowDragComp, this.context);
    this.eGui.insertAdjacentElement("afterbegin", rowDragComp.getGui());
  }
  isUserWantsSelected() {
    const paramsCheckbox = this.params.checkbox;
    return typeof paramsCheckbox === "function" || paramsCheckbox === true;
  }
  addCheckboxIfNeeded() {
    const rowNode = this.displayedGroupNode;
    const checkboxNeeded = this.isUserWantsSelected() && // footers cannot be selected
    !rowNode.footer && // pinned rows cannot be selected
    !rowNode.rowPinned && // details cannot be selected
    !rowNode.detail;
    if (checkboxNeeded) {
      const cbSelectionComponent = new CheckboxSelectionComponent();
      this.getContext().createBean(cbSelectionComponent);
      cbSelectionComponent.init({
        rowNode: this.params.node,
        // when groupHideOpenParents = true and group expanded, we want the checkbox to refer to leaf node state (not group node state)
        column: this.params.column,
        overrides: {
          isVisible: this.params.checkbox,
          callbackParams: this.params,
          removeHidden: true
        }
      });
      this.eCheckbox.appendChild(cbSelectionComponent.getGui());
      this.addDestroyFunc(() => this.getContext().destroyBean(cbSelectionComponent));
    }
    this.comp.setCheckboxVisible(checkboxNeeded);
  }
  onKeyDown(event) {
    const isEnterKey = event.key === KeyCode.ENTER;
    if (!isEnterKey || this.params.suppressEnterExpand) {
      return;
    }
    const cellEditable = this.params.column && this.params.column.isCellEditable(this.params.node);
    if (cellEditable) {
      return;
    }
    this.onExpandOrContract(event);
  }
  onCellDblClicked(mouseEvent) {
    if (isStopPropagationForAgGrid(mouseEvent)) {
      return;
    }
    const targetIsExpandIcon = isElementInEventPath(this.eExpanded, mouseEvent) || isElementInEventPath(this.eContracted, mouseEvent);
    if (!targetIsExpandIcon) {
      this.onExpandOrContract(mouseEvent);
    }
  }
};
__decorateClass([
  Autowired("expressionService")
], GroupCellRendererCtrl.prototype, "expressionService", 2);
__decorateClass([
  Autowired("valueFormatterService")
], GroupCellRendererCtrl.prototype, "valueFormatterService", 2);
__decorateClass([
  Autowired("columnModel")
], GroupCellRendererCtrl.prototype, "columnModel", 2);
__decorateClass([
  Autowired("userComponentFactory")
], GroupCellRendererCtrl.prototype, "userComponentFactory", 2);
__decorateClass([
  Autowired("ctrlsService")
], GroupCellRendererCtrl.prototype, "ctrlsService", 2);

// community-modules/core/src/rendering/cellRenderers/groupCellRenderer.ts
var _GroupCellRenderer = class _GroupCellRenderer extends Component {
  constructor() {
    super(_GroupCellRenderer.TEMPLATE);
  }
  init(params) {
    const compProxy = {
      setInnerRenderer: (compDetails, valueToDisplay) => this.setRenderDetails(compDetails, valueToDisplay),
      setChildCount: (count) => this.eChildCount.textContent = count,
      addOrRemoveCssClass: (cssClass, value) => this.addOrRemoveCssClass(cssClass, value),
      setContractedDisplayed: (expanded) => setDisplayed(this.eContracted, expanded),
      setExpandedDisplayed: (expanded) => setDisplayed(this.eExpanded, expanded),
      setCheckboxVisible: (visible) => this.eCheckbox.classList.toggle("ag-invisible", !visible)
    };
    const ctrl = this.createManagedBean(new GroupCellRendererCtrl());
    const fullWidth = !params.colDef;
    const eGui = this.getGui();
    ctrl.init(compProxy, eGui, this.eCheckbox, this.eExpanded, this.eContracted, this.constructor, params);
    if (fullWidth) {
      setAriaRole(eGui, ctrl.getCellAriaRole());
    }
  }
  setRenderDetails(compDetails, valueToDisplay) {
    if (compDetails) {
      const componentPromise = compDetails.newAgStackInstance();
      if (!componentPromise) {
        return;
      }
      componentPromise.then((comp) => {
        if (!comp) {
          return;
        }
        const destroyComp = () => this.context.destroyBean(comp);
        if (this.isAlive()) {
          this.eValue.appendChild(comp.getGui());
          this.addDestroyFunc(destroyComp);
        } else {
          destroyComp();
        }
      });
    } else {
      this.eValue.innerText = valueToDisplay;
    }
  }
  // this is a user component, and IComponent has "public destroy()" as part of the interface.
  // so we need to have public here instead of private or protected
  destroy() {
    this.getContext().destroyBean(this.innerCellRenderer);
    super.destroy();
  }
  refresh() {
    return false;
  }
};
_GroupCellRenderer.TEMPLATE = /* html */
`<span class="ag-cell-wrapper">
            <span class="ag-group-expanded" ref="eExpanded"></span>
            <span class="ag-group-contracted" ref="eContracted"></span>
            <span class="ag-group-checkbox ag-invisible" ref="eCheckbox"></span>
            <span class="ag-group-value" ref="eValue"></span>
            <span class="ag-group-child-count" ref="eChildCount"></span>
        </span>`;
__decorateClass([
  RefSelector("eExpanded")
], _GroupCellRenderer.prototype, "eExpanded", 2);
__decorateClass([
  RefSelector("eContracted")
], _GroupCellRenderer.prototype, "eContracted", 2);
__decorateClass([
  RefSelector("eCheckbox")
], _GroupCellRenderer.prototype, "eCheckbox", 2);
__decorateClass([
  RefSelector("eValue")
], _GroupCellRenderer.prototype, "eValue", 2);
__decorateClass([
  RefSelector("eChildCount")
], _GroupCellRenderer.prototype, "eChildCount", 2);
var GroupCellRenderer = _GroupCellRenderer;

// community-modules/core/src/rendering/cellRenderers/loadingCellRenderer.ts
var _LoadingCellRenderer = class _LoadingCellRenderer extends Component {
  constructor() {
    super(_LoadingCellRenderer.TEMPLATE);
  }
  init(params) {
    params.node.failedLoad ? this.setupFailed() : this.setupLoading();
  }
  setupFailed() {
    const localeTextFunc = this.localeService.getLocaleTextFunc();
    this.eLoadingText.innerText = localeTextFunc("loadingError", "ERR");
  }
  setupLoading() {
    const eLoadingIcon = createIconNoSpan("groupLoading", this.gridOptionsService, null);
    if (eLoadingIcon) {
      this.eLoadingIcon.appendChild(eLoadingIcon);
    }
    const localeTextFunc = this.localeService.getLocaleTextFunc();
    this.eLoadingText.innerText = localeTextFunc("loadingOoo", "Loading");
  }
  refresh(params) {
    return false;
  }
  // this is a user component, and IComponent has "public destroy()" as part of the interface.
  // so we need to override destroy() just to make the method public.
  destroy() {
    super.destroy();
  }
};
_LoadingCellRenderer.TEMPLATE = `<div class="ag-loading">
            <span class="ag-loading-icon" ref="eLoadingIcon"></span>
            <span class="ag-loading-text" ref="eLoadingText"></span>
        </div>`;
__decorateClass([
  RefSelector("eLoadingIcon")
], _LoadingCellRenderer.prototype, "eLoadingIcon", 2);
__decorateClass([
  RefSelector("eLoadingText")
], _LoadingCellRenderer.prototype, "eLoadingText", 2);
var LoadingCellRenderer = _LoadingCellRenderer;

// community-modules/core/src/rendering/overlays/loadingOverlayComponent.ts
var _LoadingOverlayComponent = class _LoadingOverlayComponent extends Component {
  constructor() {
    super();
  }
  // this is a user component, and IComponent has "public destroy()" as part of the interface.
  // so we need to override destroy() just to make the method public.
  destroy() {
    super.destroy();
  }
  init(params) {
    const customTemplate = this.gridOptionsService.get("overlayLoadingTemplate");
    this.setTemplate(customTemplate != null ? customTemplate : _LoadingOverlayComponent.DEFAULT_LOADING_OVERLAY_TEMPLATE);
    if (!customTemplate) {
      const localeTextFunc = this.localeService.getLocaleTextFunc();
      setTimeout(() => {
        this.getGui().textContent = localeTextFunc("loadingOoo", "Loading...");
      });
    }
  }
};
_LoadingOverlayComponent.DEFAULT_LOADING_OVERLAY_TEMPLATE = /* html */
`<span aria-live="polite" aria-atomic="true" class="ag-overlay-loading-center"></span>`;
var LoadingOverlayComponent = _LoadingOverlayComponent;

// community-modules/core/src/rendering/overlays/noRowsOverlayComponent.ts
var _NoRowsOverlayComponent = class _NoRowsOverlayComponent extends Component {
  constructor() {
    super();
  }
  // this is a user component, and IComponent has "public destroy()" as part of the interface.
  // so we need to override destroy() just to make the method public.
  destroy() {
    super.destroy();
  }
  init(params) {
    const customTemplate = this.gridOptionsService.get("overlayNoRowsTemplate");
    this.setTemplate(customTemplate != null ? customTemplate : _NoRowsOverlayComponent.DEFAULT_NO_ROWS_TEMPLATE);
    if (!customTemplate) {
      const localeTextFunc = this.localeService.getLocaleTextFunc();
      setTimeout(() => {
        this.getGui().textContent = localeTextFunc("noRowsToShow", "No Rows To Show");
      });
    }
  }
};
_NoRowsOverlayComponent.DEFAULT_NO_ROWS_TEMPLATE = /* html */
`<span class="ag-overlay-no-rows-center"></span>`;
var NoRowsOverlayComponent = _NoRowsOverlayComponent;

// community-modules/core/src/rendering/tooltipComponent.ts
var TooltipComponent = class extends PopupComponent {
  constructor() {
    super(
      /* html */
      `<div class="ag-tooltip"></div>`
    );
  }
  // will need to type params
  init(params) {
    const { value } = params;
    this.getGui().textContent = escapeString(value, true);
  }
};

// community-modules/core/src/rendering/cellEditors/numberCellEditor.ts
var NumberCellEditorInput = class {
  getTemplate() {
    return (
      /* html */
      `<ag-input-number-field class="ag-cell-editor" ref="eInput"></ag-input-number-field>`
    );
  }
  init(eInput, params) {
    this.eInput = eInput;
    this.params = params;
    if (params.max != null) {
      eInput.setMax(params.max);
    }
    if (params.min != null) {
      eInput.setMin(params.min);
    }
    if (params.precision != null) {
      eInput.setPrecision(params.precision);
    }
    if (params.step != null) {
      eInput.setStep(params.step);
    }
    const inputEl = eInput.getInputElement();
    if (params.preventStepping) {
      eInput.addManagedListener(inputEl, "keydown", this.preventStepping);
    } else if (params.showStepperButtons) {
      inputEl.classList.add("ag-number-field-input-stepper");
    }
  }
  preventStepping(e) {
    if (e.key === KeyCode.UP || e.key === KeyCode.DOWN) {
      e.preventDefault();
    }
  }
  getValue() {
    const value = this.eInput.getValue();
    if (!exists(value) && !exists(this.params.value)) {
      return this.params.value;
    }
    let parsedValue = this.params.parseValue(value);
    if (parsedValue == null) {
      return parsedValue;
    }
    if (typeof parsedValue === "string") {
      if (parsedValue === "") {
        return null;
      }
      parsedValue = Number(parsedValue);
    }
    return isNaN(parsedValue) ? null : parsedValue;
  }
  getStartValue() {
    return this.params.value;
  }
};
var NumberCellEditor = class extends SimpleCellEditor {
  constructor() {
    super(new NumberCellEditorInput());
  }
};

// community-modules/core/src/rendering/cellEditors/dateCellEditor.ts
var DateCellEditorInput = class {
  getTemplate() {
    return (
      /* html */
      `<ag-input-date-field class="ag-cell-editor" ref="eInput"></ag-input-date-field>`
    );
  }
  init(eInput, params) {
    this.eInput = eInput;
    this.params = params;
    if (params.min != null) {
      eInput.setMin(params.min);
    }
    if (params.max != null) {
      eInput.setMax(params.max);
    }
    if (params.step != null) {
      eInput.setStep(params.step);
    }
  }
  getValue() {
    const value = this.eInput.getDate();
    if (!exists(value) && !exists(this.params.value)) {
      return this.params.value;
    }
    return value != null ? value : null;
  }
  getStartValue() {
    const { value } = this.params;
    if (!(value instanceof Date)) {
      return void 0;
    }
    return serialiseDate(value, false);
  }
};
var DateCellEditor = class extends SimpleCellEditor {
  constructor() {
    super(new DateCellEditorInput());
  }
};

// community-modules/core/src/rendering/cellEditors/dateStringCellEditor.ts
var DateStringCellEditorInput = class {
  constructor(getDataTypeService) {
    this.getDataTypeService = getDataTypeService;
  }
  getTemplate() {
    return (
      /* html */
      `<ag-input-date-field class="ag-cell-editor" ref="eInput"></ag-input-date-field>`
    );
  }
  init(eInput, params) {
    this.eInput = eInput;
    this.params = params;
    if (params.min != null) {
      eInput.setMin(params.min);
    }
    if (params.max != null) {
      eInput.setMax(params.max);
    }
    if (params.step != null) {
      eInput.setStep(params.step);
    }
  }
  getValue() {
    const value = this.formatDate(this.eInput.getDate());
    if (!exists(value) && !exists(this.params.value)) {
      return this.params.value;
    }
    return this.params.parseValue(value != null ? value : "");
  }
  getStartValue() {
    var _a, _b;
    return serialiseDate((_b = this.parseDate((_a = this.params.value) != null ? _a : void 0)) != null ? _b : null, false);
  }
  parseDate(value) {
    return this.getDataTypeService().getDateParserFunction(this.params.column)(value);
  }
  formatDate(value) {
    return this.getDataTypeService().getDateFormatterFunction(this.params.column)(value);
  }
};
var DateStringCellEditor = class extends SimpleCellEditor {
  constructor() {
    super(new DateStringCellEditorInput(() => this.dataTypeService));
  }
};
__decorateClass([
  Autowired("dataTypeService")
], DateStringCellEditor.prototype, "dataTypeService", 2);

// community-modules/core/src/rendering/cellRenderers/checkboxCellRenderer.ts
var _CheckboxCellRenderer = class _CheckboxCellRenderer extends Component {
  constructor() {
    super(_CheckboxCellRenderer.TEMPLATE);
  }
  init(params) {
    this.params = params;
    this.updateCheckbox(params);
    const inputEl = this.eCheckbox.getInputElement();
    inputEl.setAttribute("tabindex", "-1");
    setAriaLive(inputEl, "polite");
    this.addManagedListener(inputEl, "click", (event) => {
      stopPropagationForAgGrid(event);
      if (this.eCheckbox.isDisabled()) {
        return;
      }
      const isSelected = this.eCheckbox.getValue();
      this.onCheckboxChanged(isSelected);
    });
    this.addManagedListener(inputEl, "dblclick", (event) => {
      stopPropagationForAgGrid(event);
    });
    const eDocument = this.gridOptionsService.getDocument();
    this.addManagedListener(this.params.eGridCell, "keydown", (event) => {
      if (event.key === KeyCode.SPACE && !this.eCheckbox.isDisabled()) {
        if (this.params.eGridCell === eDocument.activeElement) {
          this.eCheckbox.toggle();
        }
        const isSelected = this.eCheckbox.getValue();
        this.onCheckboxChanged(isSelected);
        event.preventDefault();
      }
    });
  }
  refresh(params) {
    this.params = params;
    this.updateCheckbox(params);
    return true;
  }
  updateCheckbox(params) {
    var _a, _b, _c;
    let isSelected;
    let displayed = true;
    if (params.node.group && params.column) {
      const colId = params.column.getColId();
      if (colId.startsWith(GROUP_AUTO_COLUMN_ID)) {
        isSelected = params.value == null || params.value === "" ? void 0 : params.value === "true";
      } else if (params.node.aggData && params.node.aggData[colId] !== void 0) {
        isSelected = (_a = params.value) != null ? _a : void 0;
      } else {
        displayed = false;
      }
    } else {
      isSelected = (_b = params.value) != null ? _b : void 0;
    }
    if (!displayed) {
      this.eCheckbox.setDisplayed(false);
      return;
    }
    this.eCheckbox.setValue(isSelected);
    const disabled = params.disabled != null ? params.disabled : !((_c = params.column) == null ? void 0 : _c.isCellEditable(params.node));
    this.eCheckbox.setDisabled(disabled);
    const translate = this.localeService.getLocaleTextFunc();
    const stateName = getAriaCheckboxStateName(translate, isSelected);
    const ariaLabel = disabled ? stateName : `${translate("ariaToggleCellValue", "Press SPACE to toggle cell value")} (${stateName})`;
    this.eCheckbox.setInputAriaLabel(ariaLabel);
  }
  onCheckboxChanged(isSelected) {
    const { column, node, rowIndex, value } = this.params;
    const eventStarted = {
      type: Events.EVENT_CELL_EDITING_STARTED,
      column,
      colDef: column == null ? void 0 : column.getColDef(),
      data: node.data,
      node,
      rowIndex,
      rowPinned: node.rowPinned,
      value
    };
    this.eventService.dispatchEvent(eventStarted);
    const valueChanged = this.params.node.setDataValue(this.params.column, isSelected, "edit");
    const eventStopped = {
      type: Events.EVENT_CELL_EDITING_STOPPED,
      column,
      colDef: column == null ? void 0 : column.getColDef(),
      data: node.data,
      node,
      rowIndex,
      rowPinned: node.rowPinned,
      value,
      oldValue: value,
      newValue: isSelected,
      valueChanged
    };
    this.eventService.dispatchEvent(eventStopped);
  }
};
_CheckboxCellRenderer.TEMPLATE = /* html*/
`
        <div class="ag-cell-wrapper ag-checkbox-cell" role="presentation">
            <ag-checkbox role="presentation" ref="eCheckbox"></ag-checkbox>
        </div>`;
__decorateClass([
  RefSelector("eCheckbox")
], _CheckboxCellRenderer.prototype, "eCheckbox", 2);
var CheckboxCellRenderer = _CheckboxCellRenderer;

// community-modules/core/src/rendering/cellEditors/checkboxCellEditor.ts
var CheckboxCellEditor = class extends PopupComponent {
  constructor() {
    super(
      /* html */
      `
            <div class="ag-cell-wrapper ag-cell-edit-wrapper ag-checkbox-edit">
                <ag-checkbox role="presentation" ref="eCheckbox"></ag-checkbox>
            </div>`
    );
  }
  init(params) {
    var _a;
    this.params = params;
    const isSelected = (_a = params.value) != null ? _a : void 0;
    this.eCheckbox.setValue(isSelected);
    const inputEl = this.eCheckbox.getInputElement();
    inputEl.setAttribute("tabindex", "-1");
    this.setAriaLabel(isSelected);
    this.addManagedListener(
      this.eCheckbox,
      Events.EVENT_FIELD_VALUE_CHANGED,
      (event) => this.setAriaLabel(event.selected)
    );
  }
  getValue() {
    return this.eCheckbox.getValue();
  }
  focusIn() {
    this.eCheckbox.getFocusableElement().focus();
  }
  afterGuiAttached() {
    if (this.params.cellStartedEdit) {
      this.focusIn();
    }
  }
  isPopup() {
    return false;
  }
  setAriaLabel(isSelected) {
    const translate = this.localeService.getLocaleTextFunc();
    const stateName = getAriaCheckboxStateName(translate, isSelected);
    const ariaLabel = translate("ariaToggleCellValue", "Press SPACE to toggle cell value");
    this.eCheckbox.setInputAriaLabel(`${ariaLabel} (${stateName})`);
  }
};
__decorateClass([
  RefSelector("eCheckbox")
], CheckboxCellEditor.prototype, "eCheckbox", 2);

// community-modules/core/src/widgets/agMenuItemRenderer.ts
var AgMenuItemRenderer = class extends Component {
  constructor() {
    super();
    this.setTemplate(
      /* html */
      `<div></div>`
    );
  }
  init(params) {
    var _a;
    this.params = params;
    this.cssClassPrefix = (_a = this.params.cssClassPrefix) != null ? _a : "ag-menu-option";
    this.addIcon();
    this.addName();
    this.addShortcut();
    this.addSubMenu();
  }
  configureDefaults() {
    return true;
  }
  addIcon() {
    if (this.params.isCompact) {
      return;
    }
    const icon = loadTemplate(
      /* html */
      `<span ref="eIcon" class="${this.getClassName("part")} ${this.getClassName("icon")}" role="presentation"></span>`
    );
    if (this.params.checked) {
      icon.appendChild(createIconNoSpan("check", this.gridOptionsService));
    } else if (this.params.icon) {
      if (isNodeOrElement(this.params.icon)) {
        icon.appendChild(this.params.icon);
      } else if (typeof this.params.icon === "string") {
        icon.innerHTML = this.params.icon;
      } else {
        console.warn("AG Grid: menu item icon must be DOM node or string");
      }
    }
    this.getGui().appendChild(icon);
  }
  addName() {
    const name = loadTemplate(
      /* html */
      `<span ref="eName" class="${this.getClassName("part")} ${this.getClassName("text")}">${this.params.name || ""}</span>`
    );
    this.getGui().appendChild(name);
  }
  addShortcut() {
    if (this.params.isCompact) {
      return;
    }
    const shortcut = loadTemplate(
      /* html */
      `<span ref="eShortcut" class="${this.getClassName("part")} ${this.getClassName("shortcut")}">${this.params.shortcut || ""}</span>`
    );
    this.getGui().appendChild(shortcut);
  }
  addSubMenu() {
    const pointer = loadTemplate(
      /* html */
      `<span ref="ePopupPointer" class="${this.getClassName("part")} ${this.getClassName("popup-pointer")}"></span>`
    );
    const eGui = this.getGui();
    if (this.params.subMenu) {
      const iconName = this.gridOptionsService.get("enableRtl") ? "smallLeft" : "smallRight";
      setAriaExpanded(eGui, false);
      pointer.appendChild(createIconNoSpan(iconName, this.gridOptionsService));
    }
    eGui.appendChild(pointer);
  }
  getClassName(suffix) {
    return `${this.cssClassPrefix}-${suffix}`;
  }
  destroy() {
    super.destroy();
  }
};

// community-modules/core/src/components/framework/userComponentRegistry.ts
var UserComponentRegistry = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.agGridDefaults = {
      //date
      agDateInput: DefaultDateComponent,
      //header
      agColumnHeader: HeaderComp,
      agColumnGroupHeader: HeaderGroupComp,
      agSortIndicator: SortIndicatorComp,
      //floating filters
      agTextColumnFloatingFilter: TextFloatingFilter,
      agNumberColumnFloatingFilter: NumberFloatingFilter,
      agDateColumnFloatingFilter: DateFloatingFilter,
      agReadOnlyFloatingFilter: ReadOnlyFloatingFilter,
      // renderers
      agAnimateShowChangeCellRenderer: AnimateShowChangeCellRenderer,
      agAnimateSlideCellRenderer: AnimateSlideCellRenderer,
      agGroupCellRenderer: GroupCellRenderer,
      agGroupRowRenderer: GroupCellRenderer,
      agLoadingCellRenderer: LoadingCellRenderer,
      agCheckboxCellRenderer: CheckboxCellRenderer,
      //editors
      agCellEditor: TextCellEditor,
      agTextCellEditor: TextCellEditor,
      agNumberCellEditor: NumberCellEditor,
      agDateCellEditor: DateCellEditor,
      agDateStringCellEditor: DateStringCellEditor,
      agSelectCellEditor: SelectCellEditor,
      agLargeTextCellEditor: LargeTextCellEditor,
      agCheckboxCellEditor: CheckboxCellEditor,
      //filter
      agTextColumnFilter: TextFilter,
      agNumberColumnFilter: NumberFilter,
      agDateColumnFilter: DateFilter,
      //overlays
      agLoadingOverlay: LoadingOverlayComponent,
      agNoRowsOverlay: NoRowsOverlayComponent,
      // tooltips
      agTooltipComponent: TooltipComponent,
      // menu item
      agMenuItem: AgMenuItemRenderer
    };
    /** Used to provide useful error messages if a user is trying to use an enterprise component without loading the module. */
    this.enterpriseAgDefaultCompsModule = {
      agSetColumnFilter: "@ag-grid-enterprise/set-filter" /* SetFilterModule */,
      agSetColumnFloatingFilter: "@ag-grid-enterprise/set-filter" /* SetFilterModule */,
      agMultiColumnFilter: "@ag-grid-enterprise/multi-filter" /* MultiFilterModule */,
      agMultiColumnFloatingFilter: "@ag-grid-enterprise/multi-filter" /* MultiFilterModule */,
      agGroupColumnFilter: "@ag-grid-enterprise/row-grouping" /* RowGroupingModule */,
      agGroupColumnFloatingFilter: "@ag-grid-enterprise/row-grouping" /* RowGroupingModule */,
      agRichSelect: "@ag-grid-enterprise/rich-select" /* RichSelectModule */,
      agRichSelectCellEditor: "@ag-grid-enterprise/rich-select" /* RichSelectModule */,
      agDetailCellRenderer: "@ag-grid-enterprise/master-detail" /* MasterDetailModule */,
      agSparklineCellRenderer: "@ag-grid-enterprise/sparklines" /* SparklinesModule */
    };
    this.jsComps = {};
  }
  init() {
    if (this.gridOptions.components != null) {
      iterateObject(this.gridOptions.components, (key, component) => this.registerJsComponent(key, component));
    }
  }
  registerDefaultComponent(name, component) {
    if (this.agGridDefaults[name]) {
      console.error(`Trying to overwrite a default component. You should call registerComponent`);
      return;
    }
    this.agGridDefaults[name] = component;
  }
  registerJsComponent(name, component) {
    this.jsComps[name] = component;
  }
  retrieve(propertyName, name) {
    const createResult = (component, componentFromFramework) => ({ componentFromFramework, component });
    const registeredViaFrameworkComp = this.getFrameworkOverrides().frameworkComponent(name, this.gridOptions.components);
    if (registeredViaFrameworkComp != null) {
      return createResult(registeredViaFrameworkComp, true);
    }
    const jsComponent = this.jsComps[name];
    if (jsComponent) {
      const isFwkComp = this.getFrameworkOverrides().isFrameworkComponent(jsComponent);
      return createResult(jsComponent, isFwkComp);
    }
    const defaultComponent = this.agGridDefaults[name];
    if (defaultComponent) {
      return createResult(defaultComponent, false);
    }
    const moduleForComponent = this.enterpriseAgDefaultCompsModule[name];
    if (moduleForComponent) {
      ModuleRegistry.__assertRegistered(moduleForComponent, `AG Grid '${propertyName}' component: ${name}`, this.context.getGridId());
    } else {
      doOnce(() => {
        this.warnAboutMissingComponent(propertyName, name);
      }, "MissingComp" + name);
    }
    return null;
  }
  warnAboutMissingComponent(propertyName, componentName) {
    const validComponents = [
      // Don't include the old names / internals in potential suggestions
      ...Object.keys(this.agGridDefaults).filter((k) => !["agCellEditor", "agGroupRowRenderer", "agSortIndicator"].includes(k)),
      ...Object.keys(this.jsComps)
    ];
    const suggestions = fuzzySuggestions(componentName, validComponents, true, 0.8).values;
    console.warn(`AG Grid: Could not find '${componentName}' component. It was configured as "${propertyName}: '${componentName}'" but it wasn't found in the list of registered components.`);
    if (suggestions.length > 0) {
      console.warn(`         Did you mean: [${suggestions.slice(0, 3)}]?`);
    }
    console.warn(`If using a custom component check it has been registered as described in: ${this.getFrameworkOverrides().getDocLink("components/")}`);
  }
};
__decorateClass([
  Autowired("gridOptions")
], UserComponentRegistry.prototype, "gridOptions", 2);
__decorateClass([
  PostConstruct
], UserComponentRegistry.prototype, "init", 1);
UserComponentRegistry = __decorateClass([
  Bean("userComponentRegistry")
], UserComponentRegistry);

// community-modules/core/src/components/framework/componentTypes.ts
var DateComponent = {
  propertyName: "dateComponent",
  cellRenderer: false
};
var HeaderComponent = {
  propertyName: "headerComponent",
  cellRenderer: false
};
var HeaderGroupComponent = {
  propertyName: "headerGroupComponent",
  cellRenderer: false
};
var CellRendererComponent = {
  propertyName: "cellRenderer",
  cellRenderer: true
};
var CellEditorComponent = {
  propertyName: "cellEditor",
  cellRenderer: false
};
var InnerRendererComponent = {
  propertyName: "innerRenderer",
  cellRenderer: true
};
var LoadingOverlayComponent2 = {
  propertyName: "loadingOverlayComponent",
  cellRenderer: false
};
var NoRowsOverlayComponent2 = {
  propertyName: "noRowsOverlayComponent",
  cellRenderer: false
};
var TooltipComponent2 = {
  propertyName: "tooltipComponent",
  cellRenderer: false
};
var FilterComponent = {
  propertyName: "filter",
  cellRenderer: false
};
var FloatingFilterComponent = {
  propertyName: "floatingFilterComponent",
  cellRenderer: false
};
var ToolPanelComponent = {
  propertyName: "toolPanel",
  cellRenderer: false
};
var StatusPanelComponent = {
  propertyName: "statusPanel",
  cellRenderer: false
};
var FullWidth = {
  propertyName: "fullWidthCellRenderer",
  cellRenderer: true
};
var FullWidthLoading = {
  propertyName: "loadingCellRenderer",
  cellRenderer: true
};
var FullWidthGroup = {
  propertyName: "groupRowRenderer",
  cellRenderer: true
};
var FullWidthDetail = {
  propertyName: "detailCellRenderer",
  cellRenderer: true
};
var MenuItemComponent = {
  propertyName: "menuItem",
  cellRenderer: false
};

// community-modules/core/src/filter/floating/floatingFilterMapper.ts
var FloatingFilterMapper = class {
  static getFloatingFilterType(filterType) {
    return this.filterToFloatingFilterMapping[filterType];
  }
};
FloatingFilterMapper.filterToFloatingFilterMapping = {
  set: "agSetColumnFloatingFilter",
  agSetColumnFilter: "agSetColumnFloatingFilter",
  multi: "agMultiColumnFloatingFilter",
  agMultiColumnFilter: "agMultiColumnFloatingFilter",
  group: "agGroupColumnFloatingFilter",
  agGroupColumnFilter: "agGroupColumnFloatingFilter",
  number: "agNumberColumnFloatingFilter",
  agNumberColumnFilter: "agNumberColumnFloatingFilter",
  date: "agDateColumnFloatingFilter",
  agDateColumnFilter: "agDateColumnFloatingFilter",
  text: "agTextColumnFloatingFilter",
  agTextColumnFilter: "agTextColumnFloatingFilter"
};

// community-modules/core/src/components/framework/userComponentFactory.ts
var UserComponentFactory = class extends BeanStub {
  getHeaderCompDetails(colDef, params) {
    return this.getCompDetails(colDef, HeaderComponent, "agColumnHeader", params);
  }
  getHeaderGroupCompDetails(params) {
    const colGroupDef = params.columnGroup.getColGroupDef();
    return this.getCompDetails(colGroupDef, HeaderGroupComponent, "agColumnGroupHeader", params);
  }
  // this one is unusual, as it can be LoadingCellRenderer, DetailCellRenderer, FullWidthCellRenderer or GroupRowRenderer.
  // so we have to pass the type in.
  getFullWidthCellRendererDetails(params) {
    return this.getCompDetails(this.gridOptions, FullWidth, null, params, true);
  }
  getFullWidthLoadingCellRendererDetails(params) {
    return this.getCompDetails(this.gridOptions, FullWidthLoading, "agLoadingCellRenderer", params, true);
  }
  getFullWidthGroupCellRendererDetails(params) {
    return this.getCompDetails(this.gridOptions, FullWidthGroup, "agGroupRowRenderer", params, true);
  }
  getFullWidthDetailCellRendererDetails(params) {
    return this.getCompDetails(this.gridOptions, FullWidthDetail, "agDetailCellRenderer", params, true);
  }
  // CELL RENDERER
  getInnerRendererDetails(def, params) {
    return this.getCompDetails(def, InnerRendererComponent, null, params);
  }
  getFullWidthGroupRowInnerCellRenderer(def, params) {
    return this.getCompDetails(def, InnerRendererComponent, null, params);
  }
  getCellRendererDetails(def, params) {
    return this.getCompDetails(def, CellRendererComponent, null, params);
  }
  // CELL EDITOR
  getCellEditorDetails(def, params) {
    return this.getCompDetails(def, CellEditorComponent, "agCellEditor", params, true);
  }
  // FILTER
  getFilterDetails(def, params, defaultFilter) {
    return this.getCompDetails(def, FilterComponent, defaultFilter, params, true);
  }
  getDateCompDetails(params) {
    return this.getCompDetails(this.gridOptions, DateComponent, "agDateInput", params, true);
  }
  getLoadingOverlayCompDetails(params) {
    return this.getCompDetails(this.gridOptions, LoadingOverlayComponent2, "agLoadingOverlay", params, true);
  }
  getNoRowsOverlayCompDetails(params) {
    return this.getCompDetails(this.gridOptions, NoRowsOverlayComponent2, "agNoRowsOverlay", params, true);
  }
  getTooltipCompDetails(params) {
    return this.getCompDetails(params.colDef, TooltipComponent2, "agTooltipComponent", params, true);
  }
  getSetFilterCellRendererDetails(def, params) {
    return this.getCompDetails(def, CellRendererComponent, null, params);
  }
  getFloatingFilterCompDetails(def, params, defaultFloatingFilter) {
    return this.getCompDetails(def, FloatingFilterComponent, defaultFloatingFilter, params);
  }
  getToolPanelCompDetails(toolPanelDef, params) {
    return this.getCompDetails(toolPanelDef, ToolPanelComponent, null, params, true);
  }
  getStatusPanelCompDetails(def, params) {
    return this.getCompDetails(def, StatusPanelComponent, null, params, true);
  }
  getMenuItemCompDetails(def, params) {
    return this.getCompDetails(def, MenuItemComponent, "agMenuItem", params, true);
  }
  getCompDetails(defObject, type, defaultName, params, mandatory = false) {
    const { propertyName, cellRenderer } = type;
    let { compName, jsComp, fwComp, paramsFromSelector, popupFromSelector, popupPositionFromSelector } = this.getCompKeys(defObject, type, params);
    const lookupFromRegistry = (key) => {
      const item = this.userComponentRegistry.retrieve(propertyName, key);
      if (item) {
        jsComp = !item.componentFromFramework ? item.component : void 0;
        fwComp = item.componentFromFramework ? item.component : void 0;
      }
    };
    if (compName != null) {
      lookupFromRegistry(compName);
    }
    if (jsComp == null && fwComp == null && defaultName != null) {
      lookupFromRegistry(defaultName);
    }
    if (jsComp && cellRenderer && !this.agComponentUtils.doesImplementIComponent(jsComp)) {
      jsComp = this.agComponentUtils.adaptFunction(propertyName, jsComp);
    }
    if (!jsComp && !fwComp) {
      if (mandatory) {
        console.error(`AG Grid: Could not find component ${compName}, did you forget to configure this component?`);
      }
      return;
    }
    const paramsMerged = this.mergeParamsWithApplicationProvidedParams(defObject, type, params, paramsFromSelector);
    const componentFromFramework = jsComp == null;
    const componentClass = jsComp ? jsComp : fwComp;
    return {
      componentFromFramework,
      componentClass,
      params: paramsMerged,
      type,
      popupFromSelector,
      popupPositionFromSelector,
      newAgStackInstance: () => this.newAgStackInstance(componentClass, componentFromFramework, paramsMerged, type)
    };
  }
  getCompKeys(defObject, type, params) {
    const { propertyName } = type;
    let compName;
    let jsComp;
    let fwComp;
    let paramsFromSelector;
    let popupFromSelector;
    let popupPositionFromSelector;
    if (defObject) {
      const defObjectAny = defObject;
      const selectorFunc = defObjectAny[propertyName + "Selector"];
      const selectorRes = selectorFunc ? selectorFunc(params) : null;
      const assignComp = (providedJsComp) => {
        if (typeof providedJsComp === "string") {
          compName = providedJsComp;
        } else if (providedJsComp != null && providedJsComp !== true) {
          const isFwkComp = this.getFrameworkOverrides().isFrameworkComponent(providedJsComp);
          if (isFwkComp) {
            fwComp = providedJsComp;
          } else {
            jsComp = providedJsComp;
          }
        }
      };
      if (selectorRes) {
        assignComp(selectorRes.component);
        paramsFromSelector = selectorRes.params;
        popupFromSelector = selectorRes.popup;
        popupPositionFromSelector = selectorRes.popupPosition;
      } else {
        assignComp(defObjectAny[propertyName]);
      }
    }
    return { compName, jsComp, fwComp, paramsFromSelector, popupFromSelector, popupPositionFromSelector };
  }
  newAgStackInstance(ComponentClass, componentFromFramework, params, type) {
    const propertyName = type.propertyName;
    const jsComponent = !componentFromFramework;
    let instance;
    if (jsComponent) {
      instance = new ComponentClass();
    } else {
      const thisComponentConfig = this.componentMetadataProvider.retrieve(propertyName);
      instance = this.frameworkComponentWrapper.wrap(
        ComponentClass,
        thisComponentConfig.mandatoryMethodList,
        thisComponentConfig.optionalMethodList,
        type
      );
    }
    const deferredInit = this.initComponent(instance, params);
    if (deferredInit == null) {
      return AgPromise.resolve(instance);
    }
    return deferredInit.then(() => instance);
  }
  // used by Floating Filter
  mergeParamsWithApplicationProvidedParams(defObject, type, paramsFromGrid, paramsFromSelector = null) {
    const params = this.gridOptionsService.getGridCommonParams();
    mergeDeep(params, paramsFromGrid);
    const defObjectAny = defObject;
    const userParams = defObjectAny && defObjectAny[type.propertyName + "Params"];
    if (typeof userParams === "function") {
      const userParamsFromFunc = userParams(paramsFromGrid);
      mergeDeep(params, userParamsFromFunc);
    } else if (typeof userParams === "object") {
      mergeDeep(params, userParams);
    }
    mergeDeep(params, paramsFromSelector);
    return params;
  }
  initComponent(component, params) {
    this.context.createBean(component);
    if (component.init == null) {
      return;
    }
    return component.init(params);
  }
  getDefaultFloatingFilterType(def, getFromDefault) {
    if (def == null) {
      return null;
    }
    let defaultFloatingFilterType = null;
    let { compName, jsComp, fwComp } = this.getCompKeys(def, FilterComponent);
    if (compName) {
      defaultFloatingFilterType = FloatingFilterMapper.getFloatingFilterType(compName);
    } else {
      const usingDefaultFilter = jsComp == null && fwComp == null && def.filter === true;
      if (usingDefaultFilter) {
        defaultFloatingFilterType = getFromDefault();
      }
    }
    return defaultFloatingFilterType;
  }
};
__decorateClass([
  Autowired("gridOptions")
], UserComponentFactory.prototype, "gridOptions", 2);
__decorateClass([
  Autowired("agComponentUtils")
], UserComponentFactory.prototype, "agComponentUtils", 2);
__decorateClass([
  Autowired("componentMetadataProvider")
], UserComponentFactory.prototype, "componentMetadataProvider", 2);
__decorateClass([
  Autowired("userComponentRegistry")
], UserComponentFactory.prototype, "userComponentRegistry", 2);
__decorateClass([
  Optional("frameworkComponentWrapper")
], UserComponentFactory.prototype, "frameworkComponentWrapper", 2);
UserComponentFactory = __decorateClass([
  Bean("userComponentFactory")
], UserComponentFactory);

// community-modules/core/src/components/colDefUtil.ts
var _ColDefUtil = class _ColDefUtil {
};
_ColDefUtil.ColDefPropertyMap = {
  headerName: void 0,
  columnGroupShow: void 0,
  headerClass: void 0,
  toolPanelClass: void 0,
  headerValueGetter: void 0,
  pivotKeys: void 0,
  groupId: void 0,
  colId: void 0,
  sort: void 0,
  initialSort: void 0,
  field: void 0,
  type: void 0,
  cellDataType: void 0,
  tooltipComponent: void 0,
  tooltipField: void 0,
  headerTooltip: void 0,
  cellClass: void 0,
  showRowGroup: void 0,
  filter: void 0,
  initialAggFunc: void 0,
  defaultAggFunc: void 0,
  aggFunc: void 0,
  pinned: void 0,
  initialPinned: void 0,
  chartDataType: void 0,
  cellAriaRole: void 0,
  cellEditorPopupPosition: void 0,
  headerGroupComponent: void 0,
  headerGroupComponentParams: void 0,
  cellStyle: void 0,
  cellRenderer: void 0,
  cellRendererParams: void 0,
  cellEditor: void 0,
  cellEditorParams: void 0,
  filterParams: void 0,
  pivotValueColumn: void 0,
  headerComponent: void 0,
  headerComponentParams: void 0,
  floatingFilterComponent: void 0,
  floatingFilterComponentParams: void 0,
  tooltipComponentParams: void 0,
  refData: void 0,
  columnsMenuParams: void 0,
  columnChooserParams: void 0,
  children: void 0,
  sortingOrder: void 0,
  allowedAggFuncs: void 0,
  menuTabs: void 0,
  pivotTotalColumnIds: void 0,
  cellClassRules: void 0,
  icons: void 0,
  sortIndex: void 0,
  initialSortIndex: void 0,
  flex: void 0,
  initialFlex: void 0,
  width: void 0,
  initialWidth: void 0,
  minWidth: void 0,
  maxWidth: void 0,
  rowGroupIndex: void 0,
  initialRowGroupIndex: void 0,
  pivotIndex: void 0,
  initialPivotIndex: void 0,
  suppressCellFlash: void 0,
  suppressColumnsToolPanel: void 0,
  suppressFiltersToolPanel: void 0,
  openByDefault: void 0,
  marryChildren: void 0,
  suppressStickyLabel: void 0,
  hide: void 0,
  initialHide: void 0,
  rowGroup: void 0,
  initialRowGroup: void 0,
  pivot: void 0,
  initialPivot: void 0,
  checkboxSelection: void 0,
  showDisabledCheckboxes: void 0,
  headerCheckboxSelection: void 0,
  headerCheckboxSelectionFilteredOnly: void 0,
  headerCheckboxSelectionCurrentPageOnly: void 0,
  suppressMenu: void 0,
  suppressHeaderMenuButton: void 0,
  suppressMovable: void 0,
  lockPosition: void 0,
  lockVisible: void 0,
  lockPinned: void 0,
  unSortIcon: void 0,
  suppressSizeToFit: void 0,
  suppressAutoSize: void 0,
  enableRowGroup: void 0,
  enablePivot: void 0,
  enableValue: void 0,
  editable: void 0,
  suppressPaste: void 0,
  suppressNavigable: void 0,
  enableCellChangeFlash: void 0,
  rowDrag: void 0,
  dndSource: void 0,
  autoHeight: void 0,
  wrapText: void 0,
  sortable: void 0,
  resizable: void 0,
  singleClickEdit: void 0,
  floatingFilter: void 0,
  cellEditorPopup: void 0,
  suppressFillHandle: void 0,
  wrapHeaderText: void 0,
  autoHeaderHeight: void 0,
  dndSourceOnRowDrag: void 0,
  valueGetter: void 0,
  valueSetter: void 0,
  filterValueGetter: void 0,
  keyCreator: void 0,
  valueFormatter: void 0,
  valueParser: void 0,
  comparator: void 0,
  equals: void 0,
  pivotComparator: void 0,
  suppressKeyboardEvent: void 0,
  suppressHeaderKeyboardEvent: void 0,
  colSpan: void 0,
  rowSpan: void 0,
  getQuickFilterText: void 0,
  onCellValueChanged: void 0,
  onCellClicked: void 0,
  onCellDoubleClicked: void 0,
  onCellContextMenu: void 0,
  rowDragText: void 0,
  tooltipValueGetter: void 0,
  cellRendererSelector: void 0,
  cellEditorSelector: void 0,
  suppressSpanHeaderHeight: void 0,
  useValueFormatterForExport: void 0,
  useValueParserForImport: void 0,
  mainMenuItems: void 0,
  contextMenuItems: void 0,
  suppressFloatingFilterButton: void 0,
  suppressHeaderFilterButton: void 0,
  suppressHeaderContextMenu: void 0
};
_ColDefUtil.ALL_PROPERTIES = Object.keys(_ColDefUtil.ColDefPropertyMap);
var ColDefUtil = _ColDefUtil;

// community-modules/core/src/interfaces/iExcelCreator.ts
var ExcelFactoryMode = /* @__PURE__ */ ((ExcelFactoryMode2) => {
  ExcelFactoryMode2[ExcelFactoryMode2["SINGLE_SHEET"] = 0] = "SINGLE_SHEET";
  ExcelFactoryMode2[ExcelFactoryMode2["MULTI_SHEET"] = 1] = "MULTI_SHEET";
  return ExcelFactoryMode2;
})(ExcelFactoryMode || {});

// community-modules/core/src/interfaces/iRowNode.ts
var RowHighlightPosition = /* @__PURE__ */ ((RowHighlightPosition2) => {
  RowHighlightPosition2[RowHighlightPosition2["Above"] = 0] = "Above";
  RowHighlightPosition2[RowHighlightPosition2["Below"] = 1] = "Below";
  return RowHighlightPosition2;
})(RowHighlightPosition || {});

// community-modules/core/src/autoScrollService.ts
var AutoScrollService = class {
  constructor(params) {
    this.tickingInterval = null;
    this.onScrollCallback = null;
    this.scrollContainer = params.scrollContainer;
    this.scrollHorizontally = params.scrollAxis.indexOf("x") !== -1;
    this.scrollVertically = params.scrollAxis.indexOf("y") !== -1;
    this.scrollByTick = params.scrollByTick != null ? params.scrollByTick : 20;
    if (params.onScrollCallback) {
      this.onScrollCallback = params.onScrollCallback;
    }
    if (this.scrollVertically) {
      this.getVerticalPosition = params.getVerticalPosition;
      this.setVerticalPosition = params.setVerticalPosition;
    }
    if (this.scrollHorizontally) {
      this.getHorizontalPosition = params.getHorizontalPosition;
      this.setHorizontalPosition = params.setHorizontalPosition;
    }
    this.shouldSkipVerticalScroll = params.shouldSkipVerticalScroll || (() => false);
    this.shouldSkipHorizontalScroll = params.shouldSkipHorizontalScroll || (() => false);
  }
  check(mouseEvent, forceSkipVerticalScroll = false) {
    const skipVerticalScroll = forceSkipVerticalScroll || this.shouldSkipVerticalScroll();
    if (skipVerticalScroll && this.shouldSkipHorizontalScroll()) {
      return;
    }
    const rect = this.scrollContainer.getBoundingClientRect();
    const scrollTick = this.scrollByTick;
    this.tickLeft = mouseEvent.clientX < rect.left + scrollTick;
    this.tickRight = mouseEvent.clientX > rect.right - scrollTick;
    this.tickUp = mouseEvent.clientY < rect.top + scrollTick && !skipVerticalScroll;
    this.tickDown = mouseEvent.clientY > rect.bottom - scrollTick && !skipVerticalScroll;
    if (this.tickLeft || this.tickRight || this.tickUp || this.tickDown) {
      this.ensureTickingStarted();
    } else {
      this.ensureCleared();
    }
  }
  ensureTickingStarted() {
    if (this.tickingInterval === null) {
      this.tickingInterval = window.setInterval(this.doTick.bind(this), 100);
      this.tickCount = 0;
    }
  }
  doTick() {
    this.tickCount++;
    let tickAmount;
    tickAmount = this.tickCount > 20 ? 200 : this.tickCount > 10 ? 80 : 40;
    if (this.scrollVertically) {
      const vScrollPosition = this.getVerticalPosition();
      if (this.tickUp) {
        this.setVerticalPosition(vScrollPosition - tickAmount);
      }
      if (this.tickDown) {
        this.setVerticalPosition(vScrollPosition + tickAmount);
      }
    }
    if (this.scrollHorizontally) {
      const hScrollPosition = this.getHorizontalPosition();
      if (this.tickLeft) {
        this.setHorizontalPosition(hScrollPosition - tickAmount);
      }
      if (this.tickRight) {
        this.setHorizontalPosition(hScrollPosition + tickAmount);
      }
    }
    if (this.onScrollCallback) {
      this.onScrollCallback();
    }
  }
  ensureCleared() {
    if (this.tickingInterval) {
      window.clearInterval(this.tickingInterval);
      this.tickingInterval = null;
    }
  }
};

// community-modules/core/src/gridBodyComp/rowDragFeature.ts
var RowDragFeature = class extends BeanStub {
  constructor(eContainer) {
    super();
    this.isMultiRowDrag = false;
    this.eContainer = eContainer;
  }
  postConstruct() {
    if (this.gridOptionsService.isRowModelType("clientSide")) {
      this.clientSideRowModel = this.rowModel;
    }
    this.ctrlsService.whenReady(() => {
      const gridBodyCon = this.ctrlsService.getGridBodyCtrl();
      this.autoScrollService = new AutoScrollService({
        scrollContainer: gridBodyCon.getBodyViewportElement(),
        scrollAxis: "y",
        getVerticalPosition: () => gridBodyCon.getScrollFeature().getVScrollPosition().top,
        setVerticalPosition: (position) => gridBodyCon.getScrollFeature().setVerticalScrollPosition(position),
        onScrollCallback: () => {
          this.onDragging(this.lastDraggingEvent);
        }
      });
    });
  }
  getContainer() {
    return this.eContainer;
  }
  isInterestedIn(type) {
    return type === 2 /* RowDrag */;
  }
  getIconName() {
    const managedDrag = this.gridOptionsService.get("rowDragManaged");
    if (managedDrag && this.shouldPreventRowMove()) {
      return DragAndDropService.ICON_NOT_ALLOWED;
    }
    return DragAndDropService.ICON_MOVE;
  }
  shouldPreventRowMove() {
    const rowGroupCols = this.columnModel.getRowGroupColumns();
    if (rowGroupCols.length) {
      return true;
    }
    const isFilterPresent = this.filterManager.isAnyFilterPresent();
    if (isFilterPresent) {
      return true;
    }
    const isSortActive = this.sortController.isSortActive();
    if (isSortActive) {
      return true;
    }
    return false;
  }
  getRowNodes(draggingEvent) {
    if (!this.isFromThisGrid(draggingEvent)) {
      return draggingEvent.dragItem.rowNodes || [];
    }
    const isRowDragMultiRow = this.gridOptionsService.get("rowDragMultiRow");
    const selectedNodes = [...this.selectionService.getSelectedNodes()].sort(
      (a, b) => {
        if (a.rowIndex == null || b.rowIndex == null) {
          return 0;
        }
        return this.getRowIndexNumber(a) - this.getRowIndexNumber(b);
      }
    );
    const currentNode = draggingEvent.dragItem.rowNode;
    if (isRowDragMultiRow && selectedNodes.indexOf(currentNode) !== -1) {
      this.isMultiRowDrag = true;
      return selectedNodes;
    }
    this.isMultiRowDrag = false;
    return [currentNode];
  }
  onDragEnter(draggingEvent) {
    draggingEvent.dragItem.rowNodes = this.getRowNodes(draggingEvent);
    this.dispatchGridEvent(Events.EVENT_ROW_DRAG_ENTER, draggingEvent);
    this.getRowNodes(draggingEvent).forEach((rowNode) => {
      rowNode.setDragging(true);
    });
    this.onEnterOrDragging(draggingEvent);
  }
  onDragging(draggingEvent) {
    this.onEnterOrDragging(draggingEvent);
  }
  isFromThisGrid(draggingEvent) {
    const { dragSourceDomDataKey } = draggingEvent.dragSource;
    return dragSourceDomDataKey === this.gridOptionsService.getDomDataKey();
  }
  isDropZoneWithinThisGrid(draggingEvent) {
    const gridBodyCon = this.ctrlsService.getGridBodyCtrl();
    const gridGui = gridBodyCon.getGui();
    const { dropZoneTarget } = draggingEvent;
    return !gridGui.contains(dropZoneTarget);
  }
  onEnterOrDragging(draggingEvent) {
    this.dispatchGridEvent(Events.EVENT_ROW_DRAG_MOVE, draggingEvent);
    this.lastDraggingEvent = draggingEvent;
    const pixel = this.mouseEventService.getNormalisedPosition(draggingEvent).y;
    const managedDrag = this.gridOptionsService.get("rowDragManaged");
    if (managedDrag) {
      this.doManagedDrag(draggingEvent, pixel);
    }
    this.autoScrollService.check(draggingEvent.event);
  }
  doManagedDrag(draggingEvent, pixel) {
    const isFromThisGrid = this.isFromThisGrid(draggingEvent);
    const managedDrag = this.gridOptionsService.get("rowDragManaged");
    const rowNodes = draggingEvent.dragItem.rowNodes;
    if (managedDrag && this.shouldPreventRowMove()) {
      return;
    }
    if (this.gridOptionsService.get("suppressMoveWhenRowDragging") || !isFromThisGrid) {
      if (!this.isDropZoneWithinThisGrid(draggingEvent)) {
        this.clientSideRowModel.highlightRowAtPixel(rowNodes[0], pixel);
      }
    } else {
      this.moveRows(rowNodes, pixel);
    }
  }
  getRowIndexNumber(rowNode) {
    return parseInt(last(rowNode.getRowIndexString().split("-")), 10);
  }
  moveRowAndClearHighlight(draggingEvent) {
    const lastHighlightedRowNode = this.clientSideRowModel.getLastHighlightedRowNode();
    const isBelow = lastHighlightedRowNode && lastHighlightedRowNode.highlighted === 1 /* Below */;
    const pixel = this.mouseEventService.getNormalisedPosition(draggingEvent).y;
    const rowNodes = draggingEvent.dragItem.rowNodes;
    let increment = isBelow ? 1 : 0;
    if (this.isFromThisGrid(draggingEvent)) {
      rowNodes.forEach((rowNode) => {
        if (rowNode.rowTop < pixel) {
          increment -= 1;
        }
      });
      this.moveRows(rowNodes, pixel, increment);
    } else {
      const getRowIdFunc = this.gridOptionsService.getCallback("getRowId");
      let addIndex = this.clientSideRowModel.getRowIndexAtPixel(pixel) + 1;
      if (this.clientSideRowModel.getHighlightPosition(pixel) === 0 /* Above */) {
        addIndex--;
      }
      this.clientSideRowModel.updateRowData({
        add: rowNodes.map((node) => node.data).filter(
          (data) => !this.clientSideRowModel.getRowNode(
            getRowIdFunc ? getRowIdFunc({ data, level: 0 }) : data.id
          )
        ),
        addIndex
      });
    }
    this.clearRowHighlight();
  }
  clearRowHighlight() {
    this.clientSideRowModel.highlightRowAtPixel(null);
  }
  moveRows(rowNodes, pixel, increment = 0) {
    const rowWasMoved = this.clientSideRowModel.ensureRowsAtPixel(rowNodes, pixel, increment);
    if (rowWasMoved) {
      this.focusService.clearFocusedCell();
      if (this.rangeService) {
        this.rangeService.removeAllCellRanges();
      }
    }
  }
  addRowDropZone(params) {
    if (!params.getContainer()) {
      warnOnce("addRowDropZone - A container target needs to be provided");
      return;
    }
    if (this.dragAndDropService.findExternalZone(params)) {
      console.warn("AG Grid: addRowDropZone - target already exists in the list of DropZones. Use `removeRowDropZone` before adding it again.");
      return;
    }
    let processedParams = {
      getContainer: params.getContainer
    };
    if (params.fromGrid) {
      processedParams = params;
    } else {
      if (params.onDragEnter) {
        processedParams.onDragEnter = (e) => {
          params.onDragEnter(this.draggingToRowDragEvent(Events.EVENT_ROW_DRAG_ENTER, e));
        };
      }
      if (params.onDragLeave) {
        processedParams.onDragLeave = (e) => {
          params.onDragLeave(this.draggingToRowDragEvent(Events.EVENT_ROW_DRAG_LEAVE, e));
        };
      }
      if (params.onDragging) {
        processedParams.onDragging = (e) => {
          params.onDragging(this.draggingToRowDragEvent(Events.EVENT_ROW_DRAG_MOVE, e));
        };
      }
      if (params.onDragStop) {
        processedParams.onDragStop = (e) => {
          params.onDragStop(this.draggingToRowDragEvent(Events.EVENT_ROW_DRAG_END, e));
        };
      }
    }
    this.dragAndDropService.addDropTarget(__spreadValues({
      isInterestedIn: (type) => type === 2 /* RowDrag */,
      getIconName: () => DragAndDropService.ICON_MOVE,
      external: true
    }, processedParams));
  }
  getRowDropZone(events) {
    const getContainer = this.getContainer.bind(this);
    const onDragEnter = this.onDragEnter.bind(this);
    const onDragLeave = this.onDragLeave.bind(this);
    const onDragging = this.onDragging.bind(this);
    const onDragStop = this.onDragStop.bind(this);
    if (!events) {
      return {
        getContainer,
        onDragEnter,
        onDragLeave,
        onDragging,
        onDragStop,
        /* @private */
        fromGrid: true
      };
    }
    return {
      getContainer,
      onDragEnter: events.onDragEnter ? (e) => {
        onDragEnter(e);
        events.onDragEnter(this.draggingToRowDragEvent(Events.EVENT_ROW_DRAG_ENTER, e));
      } : onDragEnter,
      onDragLeave: events.onDragLeave ? (e) => {
        onDragLeave(e);
        events.onDragLeave(this.draggingToRowDragEvent(Events.EVENT_ROW_DRAG_LEAVE, e));
      } : onDragLeave,
      onDragging: events.onDragging ? (e) => {
        onDragging(e);
        events.onDragging(this.draggingToRowDragEvent(Events.EVENT_ROW_DRAG_MOVE, e));
      } : onDragging,
      onDragStop: events.onDragStop ? (e) => {
        onDragStop(e);
        events.onDragStop(this.draggingToRowDragEvent(Events.EVENT_ROW_DRAG_END, e));
      } : onDragStop,
      fromGrid: true
      /* @private */
    };
  }
  draggingToRowDragEvent(type, draggingEvent) {
    const yNormalised = this.mouseEventService.getNormalisedPosition(draggingEvent).y;
    const mouseIsPastLastRow = yNormalised > this.paginationProxy.getCurrentPageHeight();
    let overIndex = -1;
    let overNode;
    if (!mouseIsPastLastRow) {
      overIndex = this.rowModel.getRowIndexAtPixel(yNormalised);
      overNode = this.rowModel.getRow(overIndex);
    }
    let vDirectionString;
    switch (draggingEvent.vDirection) {
      case 1 /* Down */:
        vDirectionString = "down";
        break;
      case 0 /* Up */:
        vDirectionString = "up";
        break;
      default:
        vDirectionString = null;
        break;
    }
    const event = this.gridOptionsService.addGridCommonParams({
      type,
      event: draggingEvent.event,
      node: draggingEvent.dragItem.rowNode,
      nodes: draggingEvent.dragItem.rowNodes,
      overIndex,
      overNode,
      y: yNormalised,
      vDirection: vDirectionString
    });
    return event;
  }
  dispatchGridEvent(type, draggingEvent) {
    const event = this.draggingToRowDragEvent(type, draggingEvent);
    this.eventService.dispatchEvent(event);
  }
  onDragLeave(draggingEvent) {
    this.dispatchGridEvent(Events.EVENT_ROW_DRAG_LEAVE, draggingEvent);
    this.stopDragging(draggingEvent);
    if (this.gridOptionsService.get("rowDragManaged")) {
      this.clearRowHighlight();
    }
    if (this.isFromThisGrid(draggingEvent)) {
      this.isMultiRowDrag = false;
    }
  }
  onDragStop(draggingEvent) {
    this.dispatchGridEvent(Events.EVENT_ROW_DRAG_END, draggingEvent);
    this.stopDragging(draggingEvent);
    if (this.gridOptionsService.get("rowDragManaged") && (this.gridOptionsService.get("suppressMoveWhenRowDragging") || !this.isFromThisGrid(draggingEvent)) && !this.isDropZoneWithinThisGrid(draggingEvent)) {
      this.moveRowAndClearHighlight(draggingEvent);
    }
  }
  stopDragging(draggingEvent) {
    this.autoScrollService.ensureCleared();
    this.getRowNodes(draggingEvent).forEach((rowNode) => {
      rowNode.setDragging(false);
    });
  }
};
__decorateClass([
  Autowired("dragAndDropService")
], RowDragFeature.prototype, "dragAndDropService", 2);
__decorateClass([
  Autowired("rowModel")
], RowDragFeature.prototype, "rowModel", 2);
__decorateClass([
  Autowired("paginationProxy")
], RowDragFeature.prototype, "paginationProxy", 2);
__decorateClass([
  Autowired("columnModel")
], RowDragFeature.prototype, "columnModel", 2);
__decorateClass([
  Autowired("focusService")
], RowDragFeature.prototype, "focusService", 2);
__decorateClass([
  Autowired("sortController")
], RowDragFeature.prototype, "sortController", 2);
__decorateClass([
  Autowired("filterManager")
], RowDragFeature.prototype, "filterManager", 2);
__decorateClass([
  Autowired("selectionService")
], RowDragFeature.prototype, "selectionService", 2);
__decorateClass([
  Autowired("mouseEventService")
], RowDragFeature.prototype, "mouseEventService", 2);
__decorateClass([
  Autowired("ctrlsService")
], RowDragFeature.prototype, "ctrlsService", 2);
__decorateClass([
  Optional("rangeService")
], RowDragFeature.prototype, "rangeService", 2);
__decorateClass([
  PostConstruct
], RowDragFeature.prototype, "postConstruct", 1);

// community-modules/core/src/dragAndDrop/dragService.ts
var DragService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.dragEndFunctions = [];
    this.dragSources = [];
  }
  removeAllListeners() {
    this.dragSources.forEach(this.removeListener.bind(this));
    this.dragSources.length = 0;
  }
  removeListener(dragSourceAndListener) {
    const element = dragSourceAndListener.dragSource.eElement;
    const mouseDownListener = dragSourceAndListener.mouseDownListener;
    element.removeEventListener("mousedown", mouseDownListener);
    if (dragSourceAndListener.touchEnabled) {
      const touchStartListener = dragSourceAndListener.touchStartListener;
      element.removeEventListener("touchstart", touchStartListener, { passive: true });
    }
  }
  removeDragSource(params) {
    const dragSourceAndListener = this.dragSources.find((item) => item.dragSource === params);
    if (!dragSourceAndListener) {
      return;
    }
    this.removeListener(dragSourceAndListener);
    removeFromArray(this.dragSources, dragSourceAndListener);
  }
  isDragging() {
    return this.dragging;
  }
  addDragSource(params) {
    const mouseListener = this.onMouseDown.bind(this, params);
    const { eElement, includeTouch, stopPropagationForTouch } = params;
    eElement.addEventListener("mousedown", mouseListener);
    let touchListener = null;
    const suppressTouch = this.gridOptionsService.get("suppressTouch");
    if (includeTouch && !suppressTouch) {
      touchListener = (touchEvent) => {
        if (isFocusableFormField(touchEvent.target)) {
          return;
        }
        if (touchEvent.cancelable) {
          touchEvent.preventDefault();
          if (stopPropagationForTouch) {
            touchEvent.stopPropagation();
          }
        }
        this.onTouchStart(params, touchEvent);
      };
      eElement.addEventListener("touchstart", touchListener, { passive: false });
    }
    this.dragSources.push({
      dragSource: params,
      mouseDownListener: mouseListener,
      touchStartListener: touchListener,
      touchEnabled: !!includeTouch
    });
  }
  getStartTarget() {
    return this.startTarget;
  }
  // gets called whenever mouse down on any drag source
  onTouchStart(params, touchEvent) {
    this.currentDragParams = params;
    this.dragging = false;
    const touch = touchEvent.touches[0];
    this.touchLastTime = touch;
    this.touchStart = touch;
    const touchMoveEvent = (e) => this.onTouchMove(e, params.eElement);
    const touchEndEvent = (e) => this.onTouchUp(e, params.eElement);
    const documentTouchMove = (e) => {
      if (e.cancelable) {
        e.preventDefault();
      }
    };
    const target = touchEvent.target;
    const events = [
      // Prevents the page document from moving while we are dragging items around.
      // preventDefault needs to be called in the touchmove listener and never inside the
      // touchstart, because using touchstart causes the click event to be cancelled on touch devices.
      { target: this.gridOptionsService.getRootNode(), type: "touchmove", listener: documentTouchMove, options: { passive: false } },
      { target, type: "touchmove", listener: touchMoveEvent, options: { passive: true } },
      { target, type: "touchend", listener: touchEndEvent, options: { passive: true } },
      { target, type: "touchcancel", listener: touchEndEvent, options: { passive: true } }
    ];
    this.addTemporaryEvents(events);
    if (params.dragStartPixels === 0) {
      this.onCommonMove(touch, this.touchStart, params.eElement);
    }
  }
  // gets called whenever mouse down on any drag source
  onMouseDown(params, mouseEvent) {
    const e = mouseEvent;
    if (params.skipMouseEvent && params.skipMouseEvent(mouseEvent)) {
      return;
    }
    if (e._alreadyProcessedByDragService) {
      return;
    }
    e._alreadyProcessedByDragService = true;
    if (mouseEvent.button !== 0) {
      return;
    }
    if (this.shouldPreventMouseEvent(mouseEvent)) {
      mouseEvent.preventDefault();
    }
    this.currentDragParams = params;
    this.dragging = false;
    this.mouseStartEvent = mouseEvent;
    this.startTarget = mouseEvent.target;
    const mouseMoveEvent = (event) => this.onMouseMove(event, params.eElement);
    const mouseUpEvent = (event) => this.onMouseUp(event, params.eElement);
    const contextEvent = (event) => event.preventDefault();
    const target = this.gridOptionsService.getRootNode();
    const events = [
      { target, type: "mousemove", listener: mouseMoveEvent },
      { target, type: "mouseup", listener: mouseUpEvent },
      { target, type: "contextmenu", listener: contextEvent }
    ];
    this.addTemporaryEvents(events);
    if (params.dragStartPixels === 0) {
      this.onMouseMove(mouseEvent, params.eElement);
    }
  }
  addTemporaryEvents(events) {
    events.forEach((currentEvent) => {
      const { target, type, listener, options } = currentEvent;
      target.addEventListener(type, listener, options);
    });
    this.dragEndFunctions.push(() => {
      events.forEach((currentEvent) => {
        const { target, type, listener, options } = currentEvent;
        target.removeEventListener(type, listener, options);
      });
    });
  }
  // returns true if the event is close to the original event by X pixels either vertically or horizontally.
  // we only start dragging after X pixels so this allows us to know if we should start dragging yet.
  isEventNearStartEvent(currentEvent, startEvent) {
    const { dragStartPixels } = this.currentDragParams;
    const requiredPixelDiff = exists(dragStartPixels) ? dragStartPixels : 4;
    return areEventsNear(currentEvent, startEvent, requiredPixelDiff);
  }
  getFirstActiveTouch(touchList) {
    for (let i = 0; i < touchList.length; i++) {
      if (touchList[i].identifier === this.touchStart.identifier) {
        return touchList[i];
      }
    }
    return null;
  }
  onCommonMove(currentEvent, startEvent, el) {
    if (!this.dragging) {
      if (!this.dragging && this.isEventNearStartEvent(currentEvent, startEvent)) {
        return;
      }
      this.dragging = true;
      const event = {
        type: Events.EVENT_DRAG_STARTED,
        target: el
      };
      this.eventService.dispatchEvent(event);
      this.currentDragParams.onDragStart(startEvent);
      this.currentDragParams.onDragging(startEvent);
    }
    this.currentDragParams.onDragging(currentEvent);
  }
  onTouchMove(touchEvent, el) {
    const touch = this.getFirstActiveTouch(touchEvent.touches);
    if (!touch) {
      return;
    }
    this.onCommonMove(touch, this.touchStart, el);
  }
  // only gets called after a mouse down - as this is only added after mouseDown
  // and is removed when mouseUp happens
  onMouseMove(mouseEvent, el) {
    var _a;
    if (isBrowserSafari()) {
      const eDocument = this.gridOptionsService.getDocument();
      (_a = eDocument.getSelection()) == null ? void 0 : _a.removeAllRanges();
    }
    if (this.shouldPreventMouseEvent(mouseEvent)) {
      mouseEvent.preventDefault();
    }
    this.onCommonMove(mouseEvent, this.mouseStartEvent, el);
  }
  shouldPreventMouseEvent(mouseEvent) {
    const isEnableCellTextSelect = this.gridOptionsService.get("enableCellTextSelection");
    const isMouseMove = mouseEvent.type === "mousemove";
    return (
      // when `isEnableCellTextSelect` is `true`, we need to preventDefault on mouseMove
      // to avoid the grid text being selected while dragging components.
      isEnableCellTextSelect && isMouseMove && mouseEvent.cancelable && this.mouseEventService.isEventFromThisGrid(mouseEvent) && !this.isOverFormFieldElement(mouseEvent)
    );
  }
  isOverFormFieldElement(mouseEvent) {
    const el = mouseEvent.target;
    const tagName = el == null ? void 0 : el.tagName.toLocaleLowerCase();
    return !!(tagName == null ? void 0 : tagName.match("^a$|textarea|input|select|button"));
  }
  onTouchUp(touchEvent, el) {
    let touch = this.getFirstActiveTouch(touchEvent.changedTouches);
    if (!touch) {
      touch = this.touchLastTime;
    }
    this.onUpCommon(touch, el);
  }
  onMouseUp(mouseEvent, el) {
    this.onUpCommon(mouseEvent, el);
  }
  onUpCommon(eventOrTouch, el) {
    if (this.dragging) {
      this.dragging = false;
      this.currentDragParams.onDragStop(eventOrTouch);
      const event = {
        type: Events.EVENT_DRAG_STOPPED,
        target: el
      };
      this.eventService.dispatchEvent(event);
    }
    this.mouseStartEvent = null;
    this.startTarget = null;
    this.touchStart = null;
    this.touchLastTime = null;
    this.currentDragParams = null;
    this.dragEndFunctions.forEach((func) => func());
    this.dragEndFunctions.length = 0;
  }
};
__decorateClass([
  Autowired("mouseEventService")
], DragService.prototype, "mouseEventService", 2);
__decorateClass([
  PreDestroy
], DragService.prototype, "removeAllListeners", 1);
DragService = __decorateClass([
  Bean("dragService")
], DragService);

// community-modules/core/src/dragAndDrop/virtualListDragFeature.ts
var LIST_ITEM_HOVERED = "ag-list-item-hovered";
var VirtualListDragFeature = class extends BeanStub {
  constructor(comp, virtualList, params) {
    super();
    this.comp = comp;
    this.virtualList = virtualList;
    this.params = params;
    this.currentDragValue = null;
    this.lastHoveredListItem = null;
  }
  postConstruct() {
    this.addManagedListener(this.params.eventSource, this.params.listItemDragStartEvent, this.listItemDragStart.bind(this));
    this.addManagedListener(this.params.eventSource, this.params.listItemDragEndEvent, this.listItemDragEnd.bind(this));
    this.createDropTarget();
    this.createAutoScrollService();
  }
  listItemDragStart(event) {
    this.currentDragValue = this.params.getCurrentDragValue(event);
    this.moveBlocked = this.params.isMoveBlocked(this.currentDragValue);
  }
  listItemDragEnd() {
    window.setTimeout(() => {
      this.currentDragValue = null;
      this.moveBlocked = false;
    }, 10);
  }
  createDropTarget() {
    const dropTarget = {
      isInterestedIn: (type) => type === this.params.dragSourceType,
      getIconName: () => this.moveBlocked ? DragAndDropService.ICON_PINNED : DragAndDropService.ICON_MOVE,
      getContainer: () => this.comp.getGui(),
      onDragging: (e) => this.onDragging(e),
      onDragStop: () => this.onDragStop(),
      onDragLeave: () => this.onDragLeave()
    };
    this.dragAndDropService.addDropTarget(dropTarget);
  }
  createAutoScrollService() {
    const virtualListGui = this.virtualList.getGui();
    this.autoScrollService = new AutoScrollService({
      scrollContainer: virtualListGui,
      scrollAxis: "y",
      getVerticalPosition: () => virtualListGui.scrollTop,
      setVerticalPosition: (position) => virtualListGui.scrollTop = position
    });
  }
  onDragging(e) {
    if (!this.currentDragValue || this.moveBlocked) {
      return;
    }
    const hoveredListItem = this.getListDragItem(e);
    const comp = this.virtualList.getComponentAt(hoveredListItem.rowIndex);
    if (!comp) {
      return;
    }
    const el = comp.getGui().parentElement;
    if (this.lastHoveredListItem && this.lastHoveredListItem.rowIndex === hoveredListItem.rowIndex && this.lastHoveredListItem.position === hoveredListItem.position) {
      return;
    }
    this.autoScrollService.check(e.event);
    this.clearHoveredItems();
    this.lastHoveredListItem = hoveredListItem;
    radioCssClass(el, LIST_ITEM_HOVERED);
    radioCssClass(el, `ag-item-highlight-${hoveredListItem.position}`);
  }
  getListDragItem(e) {
    const virtualListGui = this.virtualList.getGui();
    const paddingTop = parseFloat(window.getComputedStyle(virtualListGui).paddingTop);
    const rowHeight = this.virtualList.getRowHeight();
    const scrollTop = this.virtualList.getScrollTop();
    const rowIndex = Math.max(0, (e.y - paddingTop + scrollTop) / rowHeight);
    const maxLen = this.params.getNumRows(this.comp) - 1;
    const normalizedRowIndex = Math.min(maxLen, rowIndex) | 0;
    return {
      rowIndex: normalizedRowIndex,
      position: Math.round(rowIndex) > rowIndex || rowIndex > maxLen ? "bottom" : "top",
      component: this.virtualList.getComponentAt(normalizedRowIndex)
    };
  }
  onDragStop() {
    if (this.moveBlocked) {
      return;
    }
    this.params.moveItem(this.currentDragValue, this.lastHoveredListItem);
    this.clearHoveredItems();
    this.autoScrollService.ensureCleared();
  }
  onDragLeave() {
    this.clearHoveredItems();
    this.autoScrollService.ensureCleared();
  }
  clearHoveredItems() {
    const virtualListGui = this.virtualList.getGui();
    virtualListGui.querySelectorAll(`.${LIST_ITEM_HOVERED}`).forEach((el) => {
      [
        LIST_ITEM_HOVERED,
        "ag-item-highlight-top",
        "ag-item-highlight-bottom"
      ].forEach((cls) => {
        el.classList.remove(cls);
      });
    });
    this.lastHoveredListItem = null;
  }
};
__decorateClass([
  Autowired("dragAndDropService")
], VirtualListDragFeature.prototype, "dragAndDropService", 2);
__decorateClass([
  PostConstruct
], VirtualListDragFeature.prototype, "postConstruct", 1);

// community-modules/core/src/gridApi.ts
function unwrapUserComp(comp) {
  const compAsAny = comp;
  const isProxy = compAsAny != null && compAsAny.getFrameworkComponentInstance != null;
  return isProxy ? compAsAny.getFrameworkComponentInstance() : comp;
}
var GridApi = class {
  constructor() {
    this.detailGridInfoMap = {};
    this.destroyCalled = false;
  }
  init() {
    switch (this.rowModel.getType()) {
      case "clientSide":
        this.clientSideRowModel = this.rowModel;
        break;
      case "infinite":
        this.infiniteRowModel = this.rowModel;
        break;
      case "serverSide":
        this.serverSideRowModel = this.rowModel;
        break;
    }
    this.ctrlsService.whenReady(() => {
      this.gridBodyCtrl = this.ctrlsService.getGridBodyCtrl();
    });
  }
  /** Used internally by grid. Not intended to be used by the client. Interface may change between releases. */
  __getAlignedGridService() {
    return this.alignedGridsService;
  }
  /** Used internally by grid. Not intended to be used by the client. Interface may change between releases. */
  __getContext() {
    return this.context;
  }
  /** Used internally by grid. Not intended to be used by the client. Interface may change between releases. */
  __getModel() {
    return this.rowModel;
  }
  /** Returns the `gridId` for the current grid as specified via the gridOptions property `gridId` or the auto assigned grid id if none was provided. */
  getGridId() {
    return this.context.getGridId();
  }
  /** Register a detail grid with the master grid when it is created. */
  addDetailGridInfo(id, gridInfo) {
    this.detailGridInfoMap[id] = gridInfo;
  }
  /** Unregister a detail grid from the master grid when it is destroyed. */
  removeDetailGridInfo(id) {
    this.detailGridInfoMap[id] = void 0;
  }
  /** Returns the `DetailGridInfo` corresponding to the supplied `detailGridId`. */
  getDetailGridInfo(id) {
    return this.detailGridInfoMap[id];
  }
  /** Iterates through each `DetailGridInfo` in the grid and calls the supplied callback on each. */
  forEachDetailGridInfo(callback) {
    let index = 0;
    iterateObject(this.detailGridInfoMap, (id, gridInfo) => {
      if (exists(gridInfo)) {
        callback(gridInfo, index);
        index++;
      }
    });
  }
  /** Similar to `exportDataAsCsv`, except returns the result as a string rather than download it. */
  getDataAsCsv(params) {
    if (ModuleRegistry.__assertRegistered("@ag-grid-community/csv-export" /* CsvExportModule */, "api.getDataAsCsv", this.context.getGridId())) {
      return this.csvCreator.getDataAsCsv(params);
    }
  }
  /** Downloads a CSV export of the grid's data. */
  exportDataAsCsv(params) {
    if (ModuleRegistry.__assertRegistered("@ag-grid-community/csv-export" /* CsvExportModule */, "api.exportDataAsCSv", this.context.getGridId())) {
      this.csvCreator.exportDataAsCsv(params);
    }
  }
  assertNotExcelMultiSheet(method, params) {
    if (!ModuleRegistry.__assertRegistered("@ag-grid-enterprise/excel-export" /* ExcelExportModule */, "api." + method, this.context.getGridId())) {
      return false;
    }
    if (this.excelCreator.getFactoryMode() === 1 /* MULTI_SHEET */) {
      console.warn("AG Grid: The Excel Exporter is currently on Multi Sheet mode. End that operation by calling 'api.getMultipleSheetAsExcel()' or 'api.exportMultipleSheetsAsExcel()'");
      return false;
    }
    return true;
  }
  /** Similar to `exportDataAsExcel`, except instead of downloading a file, it will return a [Blob](https://developer.mozilla.org/en-US/docs/Web/API/Blob) to be processed by the user. */
  getDataAsExcel(params) {
    if (this.assertNotExcelMultiSheet("getDataAsExcel", params)) {
      return this.excelCreator.getDataAsExcel(params);
    }
  }
  /** Downloads an Excel export of the grid's data. */
  exportDataAsExcel(params) {
    if (this.assertNotExcelMultiSheet("exportDataAsExcel", params)) {
      this.excelCreator.exportDataAsExcel(params);
    }
  }
  /** This is method to be used to get the grid's data as a sheet, that will later be exported either by `getMultipleSheetsAsExcel()` or `exportMultipleSheetsAsExcel()`. */
  getSheetDataForExcel(params) {
    if (!ModuleRegistry.__assertRegistered("@ag-grid-enterprise/excel-export" /* ExcelExportModule */, "api.getSheetDataForExcel", this.context.getGridId())) {
      return;
    }
    this.excelCreator.setFactoryMode(1 /* MULTI_SHEET */);
    return this.excelCreator.getSheetDataForExcel(params);
  }
  /** Similar to `exportMultipleSheetsAsExcel`, except instead of downloading a file, it will return a [Blob](https://developer.mozilla.org/en-US/docs/Web/API/Blob) to be processed by the user. */
  getMultipleSheetsAsExcel(params) {
    if (ModuleRegistry.__assertRegistered("@ag-grid-enterprise/excel-export" /* ExcelExportModule */, "api.getMultipleSheetsAsExcel", this.context.getGridId())) {
      return this.excelCreator.getMultipleSheetsAsExcel(params);
    }
  }
  /** Downloads an Excel export of multiple sheets in one file. */
  exportMultipleSheetsAsExcel(params) {
    if (ModuleRegistry.__assertRegistered("@ag-grid-enterprise/excel-export" /* ExcelExportModule */, "api.exportMultipleSheetsAsExcel", this.context.getGridId())) {
      this.excelCreator.exportMultipleSheetsAsExcel(params);
    }
  }
  /**
   * Sets an ARIA property in the grid panel (element with `role=\"grid\"`), and removes an ARIA property when the value is null.
   *
   * Example: `api.setGridAriaProperty('label', 'my grid')` will set `aria-label=\"my grid\"`.
   *
   * `api.setGridAriaProperty('label', null)` will remove the `aria-label` attribute from the grid element.
   */
  setGridAriaProperty(property, value) {
    if (!property) {
      return;
    }
    const eGrid = this.ctrlsService.getGridBodyCtrl().getGui();
    const ariaProperty = `aria-${property}`;
    if (value === null) {
      eGrid.removeAttribute(ariaProperty);
    } else {
      eGrid.setAttribute(ariaProperty, value);
    }
  }
  logMissingRowModel(apiMethod, ...requiredRowModels) {
    console.error(`AG Grid: api.${apiMethod} can only be called when gridOptions.rowModelType is ${requiredRowModels.join(" or ")}`);
  }
  logDeprecation(version, apiMethod, replacement, message) {
    warnOnce(`Since ${version} api.${apiMethod} is deprecated. Please use ${replacement} instead. ${message}`);
  }
  /** Gets the number of top pinned rows. */
  getPinnedTopRowCount() {
    return this.pinnedRowModel.getPinnedTopRowCount();
  }
  /** Gets the number of bottom pinned rows. */
  getPinnedBottomRowCount() {
    return this.pinnedRowModel.getPinnedBottomRowCount();
  }
  /** Gets the top pinned row with the specified index. */
  getPinnedTopRow(index) {
    return this.pinnedRowModel.getPinnedTopRow(index);
  }
  /** Gets the bottom pinned row with the specified index. */
  getPinnedBottomRow(index) {
    return this.pinnedRowModel.getPinnedBottomRow(index);
  }
  expireValueCache() {
    this.valueCache.expire();
  }
  /**
   * Returns an object with two properties:
   *  - `top`: The top pixel position of the current scroll in the grid
   *  - `bottom`: The bottom pixel position of the current scroll in the grid
   */
  getVerticalPixelRange() {
    return this.gridBodyCtrl.getScrollFeature().getVScrollPosition();
  }
  /**
   * Returns an object with two properties:
   * - `left`: The left pixel position of the current scroll in the grid
   * - `right`: The right pixel position of the current scroll in the grid
   */
  getHorizontalPixelRange() {
    return this.gridBodyCtrl.getScrollFeature().getHScrollPosition();
  }
  /** Performs change detection on all cells, refreshing cells where required. */
  refreshCells(params = {}) {
    this.frameworkOverrides.wrapIncoming(() => this.rowRenderer.refreshCells(params));
  }
  /** Flash rows, columns or individual cells. */
  flashCells(params = {}) {
    const warning = (prop) => warnOnce(`Since v31.1 api.flashCells parameter '${prop}Delay' is deprecated. Please use '${prop}Duration' instead.`);
    if (exists(params.fadeDelay)) {
      warning("fade");
    }
    if (exists(params.flashDelay)) {
      warning("flash");
    }
    this.frameworkOverrides.wrapIncoming(() => this.rowRenderer.flashCells(params));
  }
  /** Remove row(s) from the DOM and recreate them again from scratch. */
  redrawRows(params = {}) {
    const rowNodes = params ? params.rowNodes : void 0;
    this.frameworkOverrides.wrapIncoming(() => this.rowRenderer.redrawRows(rowNodes));
  }
  /** Redraws the header. Useful if a column name changes, or something else that changes how the column header is displayed. */
  refreshHeader() {
    this.frameworkOverrides.wrapIncoming(() => this.ctrlsService.getHeaderRowContainerCtrls().forEach((c) => c.refresh()));
  }
  /** Returns `true` if any filter is set. This includes quick filter, column filter, external filter or advanced filter. */
  isAnyFilterPresent() {
    return this.filterManager.isAnyFilterPresent();
  }
  /** Returns `true` if any column filter is set, otherwise `false`. */
  isColumnFilterPresent() {
    return this.filterManager.isColumnFilterPresent() || this.filterManager.isAggregateFilterPresent();
  }
  /** Returns `true` if the Quick Filter is set, otherwise `false`. */
  isQuickFilterPresent() {
    return this.filterManager.isQuickFilterPresent();
  }
  /**
   * Returns the row model inside the table.
   * From here you can see the original rows, rows after filter has been applied,
   * rows after aggregation has been applied, and the final set of 'to be displayed' rows.
   *
   * @deprecated As of v31.1, getModel() is deprecated and will not be available in future versions.
   * Please use the appropriate grid API methods instead
   */
  getModel() {
    warnOnce("Since v31.1 getModel() is deprecated. Please use the appropriate grid API methods instead.");
    return this.rowModel;
  }
  /** Expand or collapse a specific row node, optionally expanding/collapsing all of its parent nodes. */
  setRowNodeExpanded(rowNode, expanded, expandParents) {
    this.expansionService.setRowNodeExpanded(rowNode, expanded, expandParents);
  }
  /**
   * Informs the grid that row group expanded state has changed and it needs to rerender the group nodes.
   * Typically called after updating the row node expanded state explicitly, i.e `rowNode.expanded = false`,
   * across multiple groups and you want to update the grid view in a single rerender instead of on every group change.
   */
  onGroupExpandedOrCollapsed() {
    if (missing(this.clientSideRowModel)) {
      this.logMissingRowModel("onGroupExpandedOrCollapsed", "clientSide");
      return;
    }
    this.expansionService.onGroupExpandedOrCollapsed();
  }
  /**
   * Refresh the Client-Side Row Model, executing the grouping, filtering and sorting again.
   * Optionally provide the step you wish the refresh to apply from. Defaults to `everything`.
   */
  refreshClientSideRowModel(step) {
    if (missing(this.clientSideRowModel)) {
      this.logMissingRowModel("refreshClientSideRowModel", "clientSide");
      return;
    }
    this.clientSideRowModel.refreshModel(step);
  }
  /** Returns `true` when there are no more animation frames left to process. */
  isAnimationFrameQueueEmpty() {
    return this.animationFrameService.isQueueEmpty();
  }
  flushAllAnimationFrames() {
    this.animationFrameService.flushAllFrames();
  }
  /**
   * Returns the row node with the given ID.
   * The row node ID is the one you provide from the callback `getRowId(params)`,
   * otherwise the ID is a number (cast as string) auto-generated by the grid when
   * the row data is set.
   */
  getRowNode(id) {
    return this.rowModel.getRowNode(id);
  }
  /**
   * Gets the sizes that various UI elements will be rendered at with the current theme.
   * If you override the row or header height using `gridOptions`, the override value you provided will be returned.
   */
  getSizesForCurrentTheme() {
    return {
      rowHeight: this.gos.getRowHeightAsNumber(),
      headerHeight: this.columnModel.getHeaderHeight()
    };
  }
  /** Expand all groups. */
  expandAll() {
    if (this.clientSideRowModel || this.serverSideRowModel) {
      this.expansionService.expandAll(true);
    } else {
      this.logMissingRowModel("expandAll", "clientSide", "serverSide");
    }
  }
  /** Collapse all groups. */
  collapseAll() {
    if (this.clientSideRowModel || this.serverSideRowModel) {
      this.expansionService.expandAll(false);
    } else {
      this.logMissingRowModel("collapseAll", "clientSide", "serverSide");
    }
  }
  /**
   * Registers a callback to a virtual row.
   * A virtual row is a row that is visually rendered on the screen (rows that are not visible because of the scroll position are not rendered).
   * Unlike normal events, you do not need to unregister rendered row listeners.
   * When the rendered row is removed from the grid, all associated rendered row listeners will also be removed.
   * listen for this event if your `cellRenderer` needs to do cleanup when the row no longer exists.
   */
  addRenderedRowListener(eventName, rowIndex, callback) {
    this.rowRenderer.addRenderedRowListener(eventName, rowIndex, callback);
  }
  /** Get the current Quick Filter text from the grid, or `undefined` if none is set. */
  getQuickFilter() {
    return this.gos.get("quickFilterText");
  }
  /** Get the state of the Advanced Filter. Used for saving Advanced Filter state */
  getAdvancedFilterModel() {
    if (ModuleRegistry.__assertRegistered("@ag-grid-enterprise/advanced-filter" /* AdvancedFilterModule */, "api.getAdvancedFilterModel", this.context.getGridId())) {
      return this.filterManager.getAdvancedFilterModel();
    }
    return null;
  }
  /** Set the state of the Advanced Filter. Used for restoring Advanced Filter state */
  setAdvancedFilterModel(advancedFilterModel) {
    this.filterManager.setAdvancedFilterModel(advancedFilterModel);
  }
  /** Open the Advanced Filter Builder dialog (if enabled). */
  showAdvancedFilterBuilder() {
    if (ModuleRegistry.__assertRegistered("@ag-grid-enterprise/advanced-filter" /* AdvancedFilterModule */, "api.setAdvancedFilterModel", this.context.getGridId())) {
      this.filterManager.showAdvancedFilterBuilder("api");
    }
  }
  /**
   * Set all of the provided nodes selection state to the provided value.
   */
  setNodesSelected(params) {
    const allNodesValid = params.nodes.every((node) => {
      if (node.rowPinned) {
        console.warn("AG Grid: cannot select pinned rows");
        return false;
      }
      if (node.id === void 0) {
        console.warn("AG Grid: cannot select node until id for node is known");
        return false;
      }
      return true;
    });
    if (!allNodesValid) {
      return;
    }
    const { nodes, source, newValue } = params;
    const nodesAsRowNode = nodes;
    this.selectionService.setNodesSelected({ nodes: nodesAsRowNode, source: source != null ? source : "api", newValue });
  }
  /**
   * Select all rows, regardless of filtering and rows that are not visible due to grouping being enabled and their groups not expanded.
   * @param source Source property that will appear in the `selectionChanged` event, defaults to `'apiSelectAll'`
   */
  selectAll(source = "apiSelectAll") {
    this.selectionService.selectAllRowNodes({ source });
  }
  /**
   * Clear all row selections, regardless of filtering.
   * @param source Source property that will appear in the `selectionChanged` event, defaults to `'apiSelectAll'`
   */
  deselectAll(source = "apiSelectAll") {
    this.selectionService.deselectAllRowNodes({ source });
  }
  /**
   * Select all filtered rows.
   * @param source Source property that will appear in the `selectionChanged` event, defaults to `'apiSelectAllFiltered'`
   */
  selectAllFiltered(source = "apiSelectAllFiltered") {
    this.selectionService.selectAllRowNodes({ source, justFiltered: true });
  }
  /**
   * Clear all filtered selections.
   * @param source Source property that will appear in the `selectionChanged` event, defaults to `'apiSelectAllFiltered'`
   */
  deselectAllFiltered(source = "apiSelectAllFiltered") {
    this.selectionService.deselectAllRowNodes({ source, justFiltered: true });
  }
  /**
   * Returns an object containing rules matching the selected rows in the SSRM.
   * 
   * If `groupSelectsChildren=false` the returned object will be flat, and will conform to IServerSideSelectionState.
   * If `groupSelectsChildren=true` the returned object will be hierarchical, and will conform to IServerSideGroupSelectionState.
   */
  getServerSideSelectionState() {
    if (missing(this.serverSideRowModel)) {
      this.logMissingRowModel("getServerSideSelectionState", "serverSide");
      return null;
    }
    return this.selectionService.getSelectionState();
  }
  /**
   * Set the rules matching the selected rows in the SSRM.
   * 
   * If `groupSelectsChildren=false` the param will be flat, and should conform to IServerSideSelectionState.
   * If `groupSelectsChildren=true` the param will be hierarchical, and should conform to IServerSideGroupSelectionState.
   */
  setServerSideSelectionState(state) {
    if (missing(this.serverSideRowModel)) {
      this.logMissingRowModel("setServerSideSelectionState", "serverSide");
      return;
    }
    this.selectionService.setSelectionState(state, "api");
  }
  /**
   * Select all rows on the current page.
   * @param source Source property that will appear in the `selectionChanged` event, defaults to `'apiSelectAllCurrentPage'`
   */
  selectAllOnCurrentPage(source = "apiSelectAllCurrentPage") {
    this.selectionService.selectAllRowNodes({ source, justCurrentPage: true });
  }
  /**
   * Clear all filtered on the current page.
   * @param source Source property that will appear in the `selectionChanged` event, defaults to `'apiSelectAllCurrentPage'`
   */
  deselectAllOnCurrentPage(source = "apiSelectAllCurrentPage") {
    this.selectionService.deselectAllRowNodes({ source, justCurrentPage: true });
  }
  /** Show the 'loading' overlay. */
  showLoadingOverlay() {
    this.overlayService.showLoadingOverlay();
  }
  /** Show the 'no rows' overlay. */
  showNoRowsOverlay() {
    this.overlayService.showNoRowsOverlay();
  }
  /** Hides the overlay if showing. */
  hideOverlay() {
    this.overlayService.hideOverlay();
  }
  /**
   * Returns an unsorted list of selected nodes.
   * Getting the underlying node (rather than the data) is useful when working with tree / aggregated data,
   * as the node can be traversed.
   */
  getSelectedNodes() {
    return this.selectionService.getSelectedNodes();
  }
  /** Returns an unsorted list of selected rows (i.e. row data that you provided). */
  getSelectedRows() {
    return this.selectionService.getSelectedRows();
  }
  /**
   * Returns a list of all selected nodes at 'best cost', a feature to be used with groups / trees.
   * If a group has all its children selected, then the group appears in the result, but not the children.
   * Designed for use with `'children'` as the group selection type, where groups don't actually appear in the selection normally.
   */
  getBestCostNodeSelection() {
    if (missing(this.clientSideRowModel)) {
      this.logMissingRowModel("getBestCostNodeSelection", "clientSide");
      return;
    }
    return this.selectionService.getBestCostNodeSelection();
  }
  /** Retrieve rendered nodes. Due to virtualisation this will contain only the current visible rows and those in the buffer. */
  getRenderedNodes() {
    return this.rowRenderer.getRenderedNodes();
  }
  /**
   *  Ensures the column is visible by scrolling the table if needed.
   *
   * This will have no effect before the firstDataRendered event has fired.
   *
   * @param key - The column to ensure visible
   * @param position - Where the column will be positioned.
   * - `auto` - Scrolls the minimum amount to make sure the column is visible.
   * - `start` - Scrolls the column to the start of the viewport.
   * - `middle` - Scrolls the column to the middle of the viewport.
   * - `end` - Scrolls the column to the end of the viewport.
  */
  ensureColumnVisible(key, position = "auto") {
    this.frameworkOverrides.wrapIncoming(() => this.gridBodyCtrl.getScrollFeature().ensureColumnVisible(key, position), "ensureVisible");
  }
  /**
   * Vertically scrolls the grid until the provided row index is inside the visible viewport.
   * If a position is provided, the grid will attempt to scroll until the row is at the given position within the viewport.
   * This will have no effect before the firstDataRendered event has fired.
   */
  ensureIndexVisible(index, position) {
    this.frameworkOverrides.wrapIncoming(() => this.gridBodyCtrl.getScrollFeature().ensureIndexVisible(index, position), "ensureVisible");
  }
  /**
   * Vertically scrolls the grid until the provided row (or a row matching the provided comparator) is inside the visible viewport.
   * If a position is provided, the grid will attempt to scroll until the row is at the given position within the viewport.
   * This will have no effect before the firstDataRendered event has fired.
   */
  ensureNodeVisible(nodeSelector, position = null) {
    this.frameworkOverrides.wrapIncoming(() => this.gridBodyCtrl.getScrollFeature().ensureNodeVisible(nodeSelector, position), "ensureVisible");
  }
  /**
   * Similar to `forEachNode`, except lists all the leaf nodes.
   * This effectively goes through all the data that you provided to the grid before the grid performed any grouping.
   * If using tree data, goes through all the nodes for the data you provided, including nodes that have children,
   * but excluding groups the grid created where gaps were missing in the hierarchy.
   */
  forEachLeafNode(callback) {
    if (missing(this.clientSideRowModel)) {
      this.logMissingRowModel("forEachLeafNode", "clientSide");
      return;
    }
    this.clientSideRowModel.forEachLeafNode(callback);
  }
  /**
   * Iterates through each node (row) in the grid and calls the callback for each node.
   * This works similar to the `forEach` method on a JavaScript array.
   * This is called for every node, ignoring any filtering or sorting applied within the grid.
   * If using the Infinite Row Model, then this gets called for each page loaded in the page cache.
   */
  forEachNode(callback, includeFooterNodes) {
    this.rowModel.forEachNode(callback, includeFooterNodes);
  }
  /** Similar to `forEachNode`, except skips any filtered out data. */
  forEachNodeAfterFilter(callback) {
    if (missing(this.clientSideRowModel)) {
      this.logMissingRowModel("forEachNodeAfterFilter", "clientSide");
      return;
    }
    this.clientSideRowModel.forEachNodeAfterFilter(callback);
  }
  /** Similar to `forEachNodeAfterFilter`, except the callbacks are called in the order the rows are displayed in the grid. */
  forEachNodeAfterFilterAndSort(callback) {
    if (missing(this.clientSideRowModel)) {
      this.logMissingRowModel("forEachNodeAfterFilterAndSort", "clientSide");
      return;
    }
    this.clientSideRowModel.forEachNodeAfterFilterAndSort(callback);
  }
  /**
   * @deprecated v31.1 To get/set individual filter models, use `getColumnFilterModel` or `setColumnFilterModel` instead.
   * To get hold of the filter instance, use `getColumnFilterInstance` which returns the instance asynchronously.
   */
  getFilterInstance(key, callback) {
    warnOnce(`'getFilterInstance' is deprecated. To get/set individual filter models, use 'getColumnFilterModel' or 'setColumnFilterModel' instead. To get hold of the filter instance, use 'getColumnFilterInstance' which returns the instance asynchronously.`);
    return this.filterManager.getFilterInstance(key, callback);
  }
  /**
   * Returns the filter component instance for a column.
   * For getting/setting models for individual column filters, use `getColumnFilterModel` and `setColumnFilterModel` instead of this.
   * `key` can be a column ID or a `Column` object.
   */
  getColumnFilterInstance(key) {
    return this.filterManager.getColumnFilterInstance(key);
  }
  /** Destroys a filter. Useful to force a particular filter to be created from scratch again. */
  destroyFilter(key) {
    const column = this.columnModel.getPrimaryColumn(key);
    if (column) {
      return this.filterManager.destroyFilter(column, "api");
    }
  }
  /** Gets the status panel instance corresponding to the supplied `id`. */
  getStatusPanel(key) {
    if (!ModuleRegistry.__assertRegistered("@ag-grid-enterprise/status-bar" /* StatusBarModule */, "api.getStatusPanel", this.context.getGridId())) {
      return;
    }
    const comp = this.statusBarService.getStatusPanel(key);
    return unwrapUserComp(comp);
  }
  getColumnDef(key) {
    const column = this.columnModel.getPrimaryColumn(key);
    if (column) {
      return column.getColDef();
    }
    return null;
  }
  /**
   * Returns the current column definitions.
  */
  getColumnDefs() {
    return this.columnModel.getColumnDefs();
  }
  /**
   * Informs the grid that a filter has changed. This is typically called after a filter change through one of the filter APIs.
   * @param source The source of the filter change event. If not specified defaults to `'api'`.
   */
  onFilterChanged(source = "api") {
    this.filterManager.onFilterChanged({ source });
  }
  /**
   * Gets the grid to act as if the sort was changed.
   * Useful if you update some values and want to get the grid to reorder them according to the new values.
   */
  onSortChanged() {
    this.sortController.onSortChanged("api");
  }
  /**
   * Sets the state of all the column filters. Provide it with what you get from `getFilterModel()` to restore filter state.
   * If inferring cell data types, and row data is provided asynchronously and is yet to be set,
   * the filter model will be applied asynchronously after row data is added.
   * To always perform this synchronously, set `cellDataType = false` on the default column definition,
   * or provide cell data types for every column.
   */
  setFilterModel(model) {
    this.frameworkOverrides.wrapIncoming(() => this.filterManager.setFilterModel(model));
  }
  /** Gets the current state of all the column filters. Used for saving filter state. */
  getFilterModel() {
    return this.filterManager.getFilterModel();
  }
  /**
   * Gets the current filter model for the specified column.
   * Will return `null` if no active filter.
   */
  getColumnFilterModel(column) {
    return this.filterManager.getColumnFilterModel(column);
  }
  /**
   * Sets the filter model for the specified column.
   * Setting a `model` of `null` will reset the filter (make inactive).
   * Must wait on the response before calling `api.onFilterChanged()`.
   */
  setColumnFilterModel(column, model) {
    return this.filterManager.setColumnFilterModel(column, model);
  }
  /** Returns the focused cell (or the last focused cell if the grid lost focus). */
  getFocusedCell() {
    return this.focusService.getFocusedCell();
  }
  /** Clears the focused cell. */
  clearFocusedCell() {
    return this.focusService.clearFocusedCell();
  }
  /** Sets the focus to the specified cell. `rowPinned` can be either 'top', 'bottom' or null (for not pinned). */
  setFocusedCell(rowIndex, colKey, rowPinned) {
    this.focusService.setFocusedCell({ rowIndex, column: colKey, rowPinned, forceBrowserFocus: true });
  }
  /** Adds a drop zone outside of the grid where rows can be dropped. */
  addRowDropZone(params) {
    this.gridBodyCtrl.getRowDragFeature().addRowDropZone(params);
  }
  /** Removes an external drop zone added by `addRowDropZone`. */
  removeRowDropZone(params) {
    const activeDropTarget = this.dragAndDropService.findExternalZone(params);
    if (activeDropTarget) {
      this.dragAndDropService.removeDropTarget(activeDropTarget);
    }
  }
  /** Returns the `RowDropZoneParams` to be used by another grid's `addRowDropZone` method. */
  getRowDropZoneParams(events) {
    return this.gridBodyCtrl.getRowDragFeature().getRowDropZone(events);
  }
  assertSideBarLoaded(apiMethod) {
    return ModuleRegistry.__assertRegistered("@ag-grid-enterprise/side-bar" /* SideBarModule */, "api." + apiMethod, this.context.getGridId());
  }
  /** Returns `true` if the side bar is visible. */
  isSideBarVisible() {
    return this.assertSideBarLoaded("isSideBarVisible") && this.sideBarService.getSideBarComp().isDisplayed();
  }
  /** Show/hide the entire side bar, including any visible panel and the tab buttons. */
  setSideBarVisible(show) {
    if (this.assertSideBarLoaded("setSideBarVisible")) {
      this.sideBarService.getSideBarComp().setDisplayed(show);
    }
  }
  /** Sets the side bar position relative to the grid. Possible values are `'left'` or `'right'`. */
  setSideBarPosition(position) {
    if (this.assertSideBarLoaded("setSideBarPosition")) {
      this.sideBarService.getSideBarComp().setSideBarPosition(position);
    }
  }
  /** Opens a particular tool panel. Provide the ID of the tool panel to open. */
  openToolPanel(key) {
    if (this.assertSideBarLoaded("openToolPanel")) {
      this.sideBarService.getSideBarComp().openToolPanel(key, "api");
    }
  }
  /** Closes the currently open tool panel (if any). */
  closeToolPanel() {
    if (this.assertSideBarLoaded("closeToolPanel")) {
      this.sideBarService.getSideBarComp().close("api");
    }
  }
  /** Returns the ID of the currently shown tool panel if any, otherwise `null`. */
  getOpenedToolPanel() {
    if (this.assertSideBarLoaded("getOpenedToolPanel")) {
      return this.sideBarService.getSideBarComp().openedItem();
    }
    return null;
  }
  /** Force refresh all tool panels by calling their `refresh` method. */
  refreshToolPanel() {
    if (this.assertSideBarLoaded("refreshToolPanel")) {
      this.sideBarService.getSideBarComp().refresh();
    }
  }
  /** Returns `true` if the tool panel is showing, otherwise `false`. */
  isToolPanelShowing() {
    return this.assertSideBarLoaded("isToolPanelShowing") && this.sideBarService.getSideBarComp().isToolPanelShowing();
  }
  /** Gets the tool panel instance corresponding to the supplied `id`. */
  getToolPanelInstance(id) {
    if (this.assertSideBarLoaded("getToolPanelInstance")) {
      const comp = this.sideBarService.getSideBarComp().getToolPanelInstance(id);
      return unwrapUserComp(comp);
    }
  }
  /** Returns the current side bar configuration. If a shortcut was used, returns the detailed long form. */
  getSideBar() {
    if (this.assertSideBarLoaded("getSideBar")) {
      return this.sideBarService.getSideBarComp().getDef();
    }
    return void 0;
  }
  /** Tells the grid to recalculate the row heights. */
  resetRowHeights() {
    if (exists(this.clientSideRowModel)) {
      if (this.columnModel.isAutoRowHeightActive()) {
        console.warn("AG Grid: calling gridApi.resetRowHeights() makes no sense when using Auto Row Height.");
        return;
      }
      this.clientSideRowModel.resetRowHeights();
    }
  }
  /**
   * Sets the `rowCount` and `maxRowFound` properties.
   * The second parameter, `maxRowFound`, is optional and if left out, only `rowCount` is set.
   * Set `rowCount` to adjust the height of the vertical scroll.
   * Set `maxRowFound` to enable / disable searching for more rows.
   * Use this method if you add or remove rows into the dataset and need to reset the number of rows or instruct the grid that the entire row count is no longer known.
   */
  setRowCount(rowCount, maxRowFound) {
    if (this.serverSideRowModel) {
      if (this.columnModel.isRowGroupEmpty()) {
        this.serverSideRowModel.setRowCount(rowCount, maxRowFound);
        return;
      }
      console.error("AG Grid: setRowCount cannot be used while using row grouping.");
      return;
    }
    if (this.infiniteRowModel) {
      this.infiniteRowModel.setRowCount(rowCount, maxRowFound);
      return;
    }
    this.logMissingRowModel("setRowCount", "infinite", "serverSide");
  }
  /** Tells the grid a row height has changed. To be used after calling `rowNode.setRowHeight(newHeight)`. */
  onRowHeightChanged() {
    if (this.clientSideRowModel) {
      this.clientSideRowModel.onRowHeightChanged();
    } else if (this.serverSideRowModel) {
      this.serverSideRowModel.onRowHeightChanged();
    }
  }
  /**
   * Gets the value for a column for a particular `rowNode` (row).
   * This is useful if you want the raw value of a cell e.g. if implementing your own CSV export.
   */
  getValue(colKey, rowNode) {
    let column = this.columnModel.getPrimaryColumn(colKey);
    if (missing(column)) {
      column = this.columnModel.getGridColumn(colKey);
    }
    if (missing(column)) {
      return null;
    }
    return this.valueService.getValue(column, rowNode);
  }
  /**
   * Add an event listener for the specified `eventType`.
   * Works similar to `addEventListener` for a browser DOM element.
   * Listeners will be automatically removed when the grid is destroyed.
   */
  addEventListener(eventType, listener) {
    this.apiEventService.addEventListener(eventType, listener);
  }
  /**
   * Add an event listener for all event types coming from the grid.
   * Listeners will be automatically removed when the grid is destroyed.
   */
  addGlobalListener(listener) {
    this.apiEventService.addGlobalListener(listener);
  }
  /** Remove an event listener. */
  removeEventListener(eventType, listener) {
    this.apiEventService.removeEventListener(eventType, listener);
  }
  /** Remove a global event listener. */
  removeGlobalListener(listener) {
    this.apiEventService.removeGlobalListener(listener);
  }
  dispatchEvent(event) {
    this.eventService.dispatchEvent(event);
  }
  /** Will destroy the grid and release resources. If you are using a framework you do not need to call this, as the grid links in with the framework lifecycle. However if you are using Web Components or native JavaScript, you do need to call this, to avoid a memory leak in your application. */
  destroy() {
    const preDestroyLink = `See ${this.frameworkOverrides.getDocLink("grid-lifecycle/#grid-pre-destroyed")}`;
    if (this.destroyCalled) {
      return;
    }
    const event = {
      type: Events.EVENT_GRID_PRE_DESTROYED,
      state: this.getState()
    };
    this.dispatchEvent(event);
    this.destroyCalled = true;
    const gridCtrl = this.ctrlsService.getGridCtrl();
    if (gridCtrl) {
      gridCtrl.destroyGridUi();
    }
    this.context.destroy();
    removeAllReferences(this, ["isDestroyed"], preDestroyLink);
  }
  /** Returns `true` if the grid has been destroyed. */
  isDestroyed() {
    return this.destroyCalled;
  }
  /** Reset the Quick Filter cache text on every rowNode. */
  resetQuickFilter() {
    this.filterManager.resetQuickFilterCache();
  }
  /** Returns the list of selected cell ranges. */
  getCellRanges() {
    if (this.rangeService) {
      return this.rangeService.getCellRanges();
    }
    ModuleRegistry.__assertRegistered("@ag-grid-enterprise/range-selection" /* RangeSelectionModule */, "api.getCellRanges", this.context.getGridId());
    return null;
  }
  /** Adds the provided cell range to the selected ranges. */
  addCellRange(params) {
    if (this.rangeService) {
      this.rangeService.addCellRange(params);
      return;
    }
    ModuleRegistry.__assertRegistered("@ag-grid-enterprise/range-selection" /* RangeSelectionModule */, "api.addCellRange", this.context.getGridId());
  }
  /** Clears the selected ranges. */
  clearRangeSelection() {
    if (this.rangeService) {
      this.rangeService.removeAllCellRanges();
    }
    ModuleRegistry.__assertRegistered("@ag-grid-enterprise/range-selection" /* RangeSelectionModule */, "gridApi.clearRangeSelection", this.context.getGridId());
  }
  /** Reverts the last cell edit. */
  undoCellEditing() {
    this.undoRedoService.undo("api");
  }
  /** Re-applies the most recently undone cell edit. */
  redoCellEditing() {
    this.undoRedoService.redo("api");
  }
  /** Returns current number of available cell edit undo operations. */
  getCurrentUndoSize() {
    return this.undoRedoService.getCurrentUndoStackSize();
  }
  /** Returns current number of available cell edit redo operations. */
  getCurrentRedoSize() {
    return this.undoRedoService.getCurrentRedoStackSize();
  }
  assertChart(methodName, func) {
    if (ModuleRegistry.__assertRegistered("@ag-grid-enterprise/charts" /* GridChartsModule */, "api." + methodName, this.context.getGridId())) {
      return this.frameworkOverrides.wrapIncoming(() => func());
    }
  }
  /** Returns a list of models with information about the charts that are currently rendered from the grid. */
  getChartModels() {
    return this.assertChart("getChartModels", () => this.chartService.getChartModels());
  }
  /** Returns the `ChartRef` using the supplied `chartId`. */
  getChartRef(chartId) {
    return this.assertChart("getChartRef", () => this.chartService.getChartRef(chartId));
  }
  /** Returns a base64-encoded image data URL for the referenced chartId. */
  getChartImageDataURL(params) {
    return this.assertChart("getChartImageDataURL", () => this.chartService.getChartImageDataURL(params));
  }
  /** Starts a browser-based image download for the referenced chartId. */
  downloadChart(params) {
    return this.assertChart("downloadChart", () => this.chartService.downloadChart(params));
  }
  /** Open the Chart Tool Panel. */
  openChartToolPanel(params) {
    return this.assertChart("openChartToolPanel", () => this.chartService.openChartToolPanel(params));
  }
  /** Close the Chart Tool Panel. */
  closeChartToolPanel(params) {
    return this.assertChart("closeChartToolPanel", () => this.chartService.closeChartToolPanel(params.chartId));
  }
  /** Used to programmatically create charts from a range. */
  createRangeChart(params) {
    return this.assertChart("createRangeChart", () => this.chartService.createRangeChart(params));
  }
  /** Used to programmatically create pivot charts from a grid. */
  createPivotChart(params) {
    return this.assertChart("createPivotChart", () => this.chartService.createPivotChart(params));
  }
  /** Used to programmatically create cross filter charts from a range. */
  createCrossFilterChart(params) {
    return this.assertChart("createCrossFilterChart", () => this.chartService.createCrossFilterChart(params));
  }
  /** Used to programmatically update a chart. */
  updateChart(params) {
    return this.assertChart("updateChart", () => this.chartService.updateChart(params));
  }
  /** Restores a chart using the `ChartModel` that was previously obtained from `getChartModels()`. */
  restoreChart(chartModel, chartContainer) {
    return this.assertChart("restoreChart", () => this.chartService.restoreChart(chartModel, chartContainer));
  }
  assertClipboard(methodName, func) {
    if (ModuleRegistry.__assertRegistered("@ag-grid-enterprise/clipboard" /* ClipboardModule */, "api" + methodName, this.context.getGridId())) {
      func();
    }
  }
  /** Copies data to clipboard by following the same rules as pressing Ctrl+C. */
  copyToClipboard(params) {
    this.assertClipboard("copyToClipboard", () => this.clipboardService.copyToClipboard(params));
  }
  /** Cuts data to clipboard by following the same rules as pressing Ctrl+X. */
  cutToClipboard(params) {
    this.assertClipboard("cutToClipboard", () => this.clipboardService.cutToClipboard(params));
  }
  /** Copies the selected rows to the clipboard. */
  copySelectedRowsToClipboard(params) {
    this.assertClipboard("copySelectedRowsToClipboard", () => this.clipboardService.copySelectedRowsToClipboard(params));
  }
  /** Copies the selected ranges to the clipboard. */
  copySelectedRangeToClipboard(params) {
    this.assertClipboard("copySelectedRangeToClipboard", () => this.clipboardService.copySelectedRangeToClipboard(params));
  }
  /** Copies the selected range down, similar to `Ctrl + D` in Excel. */
  copySelectedRangeDown() {
    this.assertClipboard("copySelectedRangeDown", () => this.clipboardService.copyRangeDown());
  }
  /** Pastes the data from the Clipboard into the focused cell of the grid. If no grid cell is focused, calling this method has no effect. */
  pasteFromClipboard() {
    this.assertClipboard("pasteFromClipboard", () => this.clipboardService.pasteFromClipboard());
  }
  /** @deprecated v31.1 Use `IHeaderParams.showColumnMenu` within a header component, or `api.showColumnMenu` elsewhere. */
  showColumnMenuAfterButtonClick(colKey, buttonElement) {
    warnOnce(`'showColumnMenuAfterButtonClick' is deprecated. Use 'IHeaderParams.showColumnMenu' within a header component, or 'api.showColumnMenu' elsewhere.`);
    const column = this.columnModel.getGridColumn(colKey);
    this.menuService.showColumnMenu({
      column,
      buttonElement,
      positionBy: "button"
    });
  }
  /** @deprecated v31.1 Use `IHeaderParams.showColumnMenuAfterMouseClick` within a header component, or `api.showColumnMenu` elsewhere. */
  showColumnMenuAfterMouseClick(colKey, mouseEvent) {
    warnOnce(`'showColumnMenuAfterMouseClick' is deprecated. Use 'IHeaderParams.showColumnMenuAfterMouseClick' within a header component, or 'api.showColumnMenu' elsewhere.`);
    let column = this.columnModel.getGridColumn(colKey);
    if (!column) {
      column = this.columnModel.getPrimaryColumn(colKey);
    }
    if (!column) {
      console.error(`AG Grid: column '${colKey}' not found`);
      return;
    }
    this.menuService.showColumnMenu({
      column,
      mouseEvent,
      positionBy: "mouse"
    });
  }
  /** Show the column chooser. */
  showColumnChooser(params) {
    this.menuService.showColumnChooser({ chooserParams: params });
  }
  /** Show the filter for the provided column. */
  showColumnFilter(colKey) {
    const column = this.columnModel.getGridColumn(colKey);
    if (!column) {
      console.error(`AG Grid: column '${colKey}' not found`);
      return;
    }
    this.menuService.showFilterMenu({
      column,
      containerType: "columnFilter",
      positionBy: "auto"
    });
  }
  /** Show the column menu for the provided column. */
  showColumnMenu(colKey) {
    const column = this.columnModel.getGridColumn(colKey);
    if (!column) {
      console.error(`AG Grid: column '${colKey}' not found`);
      return;
    }
    this.menuService.showColumnMenu({
      column,
      positionBy: "auto"
    });
  }
  /** Hides any visible context menu or column menu. */
  hidePopupMenu() {
    this.menuService.hidePopupMenu();
  }
  /** Hide the column chooser if visible. */
  hideColumnChooser() {
    this.menuService.hideColumnChooser();
  }
  /** Navigates the grid focus to the next cell, as if tabbing. */
  tabToNextCell(event) {
    return this.navigationService.tabToNextCell(false, event);
  }
  /** Navigates the grid focus to the previous cell, as if shift-tabbing. */
  tabToPreviousCell(event) {
    return this.navigationService.tabToNextCell(true, event);
  }
  /** Returns the list of active cell renderer instances. */
  getCellRendererInstances(params = {}) {
    const res = this.rowRenderer.getCellRendererInstances(params);
    const unwrapped = res.map(unwrapUserComp);
    return unwrapped;
  }
  /** Returns the list of active cell editor instances. Optionally provide parameters to restrict to certain columns / row nodes. */
  getCellEditorInstances(params = {}) {
    const res = this.rowRenderer.getCellEditorInstances(params);
    const unwrapped = res.map(unwrapUserComp);
    return unwrapped;
  }
  /** If the grid is editing, returns back details of the editing cell(s). */
  getEditingCells() {
    return this.rowRenderer.getEditingCells();
  }
  /** If a cell is editing, it stops the editing. Pass `true` if you want to cancel the editing (i.e. don't accept changes). */
  stopEditing(cancel = false) {
    this.rowRenderer.stopEditing(cancel);
  }
  /** Start editing the provided cell. If another cell is editing, the editing will be stopped in that other cell. */
  startEditingCell(params) {
    const column = this.columnModel.getGridColumn(params.colKey);
    if (!column) {
      console.warn(`AG Grid: no column found for ${params.colKey}`);
      return;
    }
    const cellPosition = {
      rowIndex: params.rowIndex,
      rowPinned: params.rowPinned || null,
      column
    };
    const notPinned = params.rowPinned == null;
    if (notPinned) {
      this.ensureIndexVisible(params.rowIndex);
    }
    this.ensureColumnVisible(params.colKey);
    const cell = this.navigationService.getCellByPosition(cellPosition);
    if (!cell) {
      return;
    }
    if (!this.focusService.isCellFocused(cellPosition)) {
      this.focusService.setFocusedCell(cellPosition);
    }
    cell.startRowOrCellEdit(params.key);
  }
  /** @deprecated v31.1 addAggFunc(key, func) is  deprecated, please use addAggFuncs({ key: func }) instead. */
  addAggFunc(key, aggFunc) {
    this.logDeprecation("v31.1", "addAggFunc(key, func)", "addAggFuncs({ key: func })");
    if (this.aggFuncService) {
      this.aggFuncService.addAggFuncs({ key: aggFunc });
    }
  }
  /** Add aggregations function with the specified keys. */
  addAggFuncs(aggFuncs) {
    if (this.aggFuncService) {
      this.aggFuncService.addAggFuncs(aggFuncs);
    }
  }
  /** Clears all aggregation functions (including those provided by the grid). */
  clearAggFuncs() {
    if (this.aggFuncService) {
      this.aggFuncService.clear();
    }
  }
  /** Apply transactions to the server side row model. */
  applyServerSideTransaction(transaction) {
    if (!this.serverSideTransactionManager) {
      this.logMissingRowModel("applyServerSideTransaction", "serverSide");
      return;
    }
    return this.serverSideTransactionManager.applyTransaction(transaction);
  }
  /** Batch apply transactions to the server side row model. */
  applyServerSideTransactionAsync(transaction, callback) {
    if (!this.serverSideTransactionManager) {
      this.logMissingRowModel("applyServerSideTransactionAsync", "serverSide");
      return;
    }
    return this.serverSideTransactionManager.applyTransactionAsync(transaction, callback);
  }
  /**
   * Applies row data to a server side store.
   * New rows will overwrite rows at the same index in the same way as if provided by a datasource success callback.
  */
  applyServerSideRowData(params) {
    var _a, _b;
    const startRow = (_a = params.startRow) != null ? _a : 0;
    const route = (_b = params.route) != null ? _b : [];
    if (startRow < 0) {
      console.warn(`AG Grid: invalid value ${params.startRow} for startRow, the value should be >= 0`);
      return;
    }
    if (this.serverSideRowModel) {
      this.serverSideRowModel.applyRowData(params.successParams, startRow, route);
    } else {
      this.logMissingRowModel("setServerSideDatasource", "serverSide");
    }
  }
  /** Gets all failed server side loads to retry. */
  retryServerSideLoads() {
    if (!this.serverSideRowModel) {
      this.logMissingRowModel("retryServerSideLoads", "serverSide");
      return;
    }
    this.serverSideRowModel.retryLoads();
  }
  flushServerSideAsyncTransactions() {
    if (!this.serverSideTransactionManager) {
      this.logMissingRowModel("flushServerSideAsyncTransactions", "serverSide");
      return;
    }
    return this.serverSideTransactionManager.flushAsyncTransactions();
  }
  /** Update row data. Pass a transaction object with lists for `add`, `remove` and `update`. */
  applyTransaction(rowDataTransaction) {
    if (!this.clientSideRowModel) {
      this.logMissingRowModel("applyTransaction", "clientSide");
      return;
    }
    return this.frameworkOverrides.wrapIncoming(() => this.clientSideRowModel.updateRowData(rowDataTransaction));
  }
  /** Same as `applyTransaction` except executes asynchronously for efficiency. */
  applyTransactionAsync(rowDataTransaction, callback) {
    if (!this.clientSideRowModel) {
      this.logMissingRowModel("applyTransactionAsync", "clientSide");
      return;
    }
    this.frameworkOverrides.wrapIncoming(() => this.clientSideRowModel.batchUpdateRowData(rowDataTransaction, callback));
  }
  /** Executes any remaining asynchronous grid transactions, if any are waiting to be executed. */
  flushAsyncTransactions() {
    if (!this.clientSideRowModel) {
      this.logMissingRowModel("flushAsyncTransactions", "clientSide");
      return;
    }
    this.frameworkOverrides.wrapIncoming(() => this.clientSideRowModel.flushAsyncTransactions());
  }
  /**
   * Marks all the currently loaded blocks in the cache for reload.
   * If you have 10 blocks in the cache, all 10 will be marked for reload.
   * The old data will continue to be displayed until the new data is loaded.
   */
  refreshInfiniteCache() {
    if (this.infiniteRowModel) {
      this.infiniteRowModel.refreshCache();
    } else {
      this.logMissingRowModel("refreshInfiniteCache", "infinite");
    }
  }
  /**
   * Purges the cache.
   * The grid is then told to refresh. Only the blocks required to display the current data on screen are fetched (typically no more than 2).
   * The grid will display nothing while the new blocks are loaded.
   * Use this to immediately remove the old data from the user.
   */
  purgeInfiniteCache() {
    if (this.infiniteRowModel) {
      this.infiniteRowModel.purgeCache();
    } else {
      this.logMissingRowModel("purgeInfiniteCache", "infinite");
    }
  }
  /**
   * Refresh a server-side store level.
   * If you pass no parameters, then the top level store is refreshed.
   * To refresh a child level, pass in the string of keys to get to the desired level.
   * Once the store refresh is complete, the storeRefreshed event is fired.
   */
  refreshServerSide(params) {
    if (!this.serverSideRowModel) {
      this.logMissingRowModel("refreshServerSide", "serverSide");
      return;
    }
    this.serverSideRowModel.refreshStore(params);
  }
  /** Returns info on all server side group levels. */
  getServerSideGroupLevelState() {
    if (!this.serverSideRowModel) {
      this.logMissingRowModel("getServerSideGroupLevelState", "serverSide");
      return [];
    }
    return this.serverSideRowModel.getStoreState();
  }
  /** The row count defines how many rows the grid allows scrolling to. */
  getInfiniteRowCount() {
    if (this.infiniteRowModel) {
      return this.infiniteRowModel.getRowCount();
    } else {
      this.logMissingRowModel("getInfiniteRowCount", "infinite");
    }
  }
  /** Returns `true` if grid allows for scrolling past the last row to load more rows, thus providing infinite scroll. */
  isLastRowIndexKnown() {
    if (this.infiniteRowModel) {
      return this.infiniteRowModel.isLastRowIndexKnown();
    } else {
      this.logMissingRowModel("isLastRowIndexKnown", "infinite");
    }
  }
  /**
   * Returns an object representing the state of the cache. This is useful for debugging and understanding how the cache is working.
   */
  getCacheBlockState() {
    return this.rowNodeBlockLoader.getBlockState();
  }
  /** @deprecated v31.1 `getFirstDisplayedRow` is deprecated. Please use `getFirstDisplayedRowIndex` instead. */
  getFirstDisplayedRow() {
    this.logDeprecation("v31.1", "getFirstDisplayedRow", "getFirstDisplayedRowIndex");
    return this.getFirstDisplayedRowIndex();
  }
  /** Get the index of the first displayed row due to scrolling (includes invisible rendered rows in the buffer). */
  getFirstDisplayedRowIndex() {
    return this.rowRenderer.getFirstVirtualRenderedRow();
  }
  /** @deprecated v31.1 `getLastDisplayedRow` is deprecated. Please use `getLastDisplayedRowIndex` instead. */
  getLastDisplayedRow() {
    this.logDeprecation("v31.1", "getLastDisplayedRow", "getLastDisplayedRowIndex");
    return this.getLastDisplayedRowIndex();
  }
  /** Get the index of the last displayed row due to scrolling (includes invisible rendered rows in the buffer). */
  getLastDisplayedRowIndex() {
    return this.rowRenderer.getLastVirtualRenderedRow();
  }
  /** Returns the displayed `RowNode` at the given `index`. */
  getDisplayedRowAtIndex(index) {
    return this.rowModel.getRow(index);
  }
  /** Returns the total number of displayed rows. */
  getDisplayedRowCount() {
    return this.rowModel.getRowCount();
  }
  /**
   * Returns `true` when the last page is known.
   * This will always be `true` if you are using the Client-Side Row Model for pagination.
   * Returns `false` when the last page is not known; this only happens when using Infinite Row Model.
   */
  paginationIsLastPageFound() {
    return this.paginationProxy.isLastPageFound();
  }
  /** Returns how many rows are being shown per page. */
  paginationGetPageSize() {
    return this.paginationProxy.getPageSize();
  }
  /** Returns the 0-based index of the page which is showing. */
  paginationGetCurrentPage() {
    return this.paginationProxy.getCurrentPage();
  }
  /** Returns the total number of pages. Returns `null` if `paginationIsLastPageFound() === false`. */
  paginationGetTotalPages() {
    return this.paginationProxy.getTotalPages();
  }
  /** The total number of rows. Returns `null` if `paginationIsLastPageFound() === false`. */
  paginationGetRowCount() {
    return this.paginationProxy.getMasterRowCount();
  }
  /** Navigates to the next page. */
  paginationGoToNextPage() {
    this.paginationProxy.goToNextPage();
  }
  /** Navigates to the previous page. */
  paginationGoToPreviousPage() {
    this.paginationProxy.goToPreviousPage();
  }
  /** Navigates to the first page. */
  paginationGoToFirstPage() {
    this.paginationProxy.goToFirstPage();
  }
  /** Navigates to the last page. */
  paginationGoToLastPage() {
    this.paginationProxy.goToLastPage();
  }
  /** Goes to the specified page. If the page requested doesn't exist, it will go to the last page. */
  paginationGoToPage(page) {
    this.paginationProxy.goToPage(page);
  }
  // Methods migrated from old ColumnApi
  /**
   * Adjusts the size of columns to fit the available horizontal space.
   *
   * Note: it is not recommended to call this method rapidly e.g. in response
   * to window resize events or as the container size is animated. This can
   * cause the scrollbar to flicker. Use column flex for smoother results.
   * 
   * If inferring cell data types with custom column types
   * and row data is provided asynchronously, the column sizing will happen asynchronously when row data is added.
   * To always perform this synchronously, set `cellDataType = false` on the default column definition.
   **/
  sizeColumnsToFit(paramsOrGridWidth) {
    if (typeof paramsOrGridWidth === "number") {
      this.columnModel.sizeColumnsToFit(paramsOrGridWidth, "api");
    } else {
      this.gridBodyCtrl.sizeColumnsToFit(paramsOrGridWidth);
    }
  }
  /** Call this if you want to open or close a column group. */
  setColumnGroupOpened(group, newValue) {
    this.columnModel.setColumnGroupOpened(group, newValue, "api");
  }
  /** Returns the column group with the given name. */
  getColumnGroup(name, instanceId) {
    return this.columnModel.getColumnGroup(name, instanceId);
  }
  /** Returns the provided column group with the given name. */
  getProvidedColumnGroup(name) {
    return this.columnModel.getProvidedColumnGroup(name);
  }
  /** Returns the display name for a column. Useful if you are doing your own header rendering and want the grid to work out if `headerValueGetter` is used, or if you are doing your own column management GUI, to know what to show as the column name. */
  getDisplayNameForColumn(column, location) {
    return this.columnModel.getDisplayNameForColumn(column, location) || "";
  }
  /** Returns the display name for a column group (when grouping columns). */
  getDisplayNameForColumnGroup(columnGroup, location) {
    return this.columnModel.getDisplayNameForColumnGroup(columnGroup, location) || "";
  }
  /** Returns the column with the given `colKey`, which can either be the `colId` (a string) or the `colDef` (an object). */
  getColumn(key) {
    return this.columnModel.getPrimaryColumn(key);
  }
  /** Returns all the columns, regardless of visible or not. */
  getColumns() {
    return this.columnModel.getAllPrimaryColumns();
  }
  /** Applies the state of the columns from a previous state. Returns `false` if one or more columns could not be found. */
  applyColumnState(params) {
    return this.columnModel.applyColumnState(params, "api");
  }
  /** Gets the state of the columns. Typically used when saving column state. */
  getColumnState() {
    return this.columnModel.getColumnState();
  }
  /** Sets the state back to match the originally provided column definitions. */
  resetColumnState() {
    this.columnModel.resetColumnState("api");
  }
  /** Gets the state of the column groups. Typically used when saving column group state. */
  getColumnGroupState() {
    return this.columnModel.getColumnGroupState();
  }
  /** Sets the state of the column group state from a previous state. */
  setColumnGroupState(stateItems) {
    this.columnModel.setColumnGroupState(stateItems, "api");
  }
  /** Sets the state back to match the originally provided column definitions. */
  resetColumnGroupState() {
    this.columnModel.resetColumnGroupState("api");
  }
  /** Returns `true` if pinning left or right, otherwise `false`. */
  isPinning() {
    return this.columnModel.isPinningLeft() || this.columnModel.isPinningRight();
  }
  /** Returns `true` if pinning left, otherwise `false`. */
  isPinningLeft() {
    return this.columnModel.isPinningLeft();
  }
  /** Returns `true` if pinning right, otherwise `false`. */
  isPinningRight() {
    return this.columnModel.isPinningRight();
  }
  /** Returns the column to the right of the provided column, taking into consideration open / closed column groups and visible columns. This is useful if you need to know what column is beside yours e.g. if implementing your own cell navigation. */
  getDisplayedColAfter(col) {
    return this.columnModel.getDisplayedColAfter(col);
  }
  /** Same as `getVisibleColAfter` except gives column to the left. */
  getDisplayedColBefore(col) {
    return this.columnModel.getDisplayedColBefore(col);
  }
  /** @deprecated v31.1 setColumnVisible(key, visible) deprecated, please use setColumnsVisible([key], visible) instead. */
  setColumnVisible(key, visible) {
    this.logDeprecation("v31.1", "setColumnVisible(key,visible)", "setColumnsVisible([key],visible)");
    this.columnModel.setColumnsVisible([key], visible, "api");
  }
  /** Sets the visibility of columns. Key can be the column ID or `Column` object. */
  setColumnsVisible(keys2, visible) {
    this.columnModel.setColumnsVisible(keys2, visible, "api");
  }
  /** @deprecated v31.1 setColumnPinned(key, pinned) deprecated, please use setColumnsPinned([key], pinned) instead. */
  setColumnPinned(key, pinned) {
    this.logDeprecation("v31.1", "setColumnPinned(key,pinned)", "setColumnsPinned([key],pinned)");
    this.columnModel.setColumnsPinned([key], pinned, "api");
  }
  /** Set a column's pinned / unpinned state. Key can be the column ID, field, `ColDef` object or `Column` object. */
  setColumnsPinned(keys2, pinned) {
    this.columnModel.setColumnsPinned(keys2, pinned, "api");
  }
  /**
   * Returns all the grid columns, same as `getColumns()`, except
   *
   *  a) it has the order of the columns that are presented in the grid
   *
   *  b) it's after the 'pivot' step, so if pivoting, has the value columns for the pivot.
   */
  getAllGridColumns() {
    return this.columnModel.getAllGridColumns();
  }
  /** Same as `getAllDisplayedColumns` but just for the pinned left portion of the grid. */
  getDisplayedLeftColumns() {
    return this.columnModel.getDisplayedLeftColumns();
  }
  /** Same as `getAllDisplayedColumns` but just for the center portion of the grid. */
  getDisplayedCenterColumns() {
    return this.columnModel.getDisplayedCenterColumns();
  }
  /** Same as `getAllDisplayedColumns` but just for the pinned right portion of the grid. */
  getDisplayedRightColumns() {
    return this.columnModel.getDisplayedRightColumns();
  }
  /** Returns all columns currently displayed (e.g. are visible and if in a group, the group is showing the columns) for the pinned left, centre and pinned right portions of the grid. */
  getAllDisplayedColumns() {
    return this.columnModel.getAllDisplayedColumns();
  }
  /** Same as `getAllGridColumns()`, except only returns rendered columns, i.e. columns that are not within the viewport and therefore not rendered, due to column virtualisation, are not displayed. */
  getAllDisplayedVirtualColumns() {
    return this.columnModel.getViewportColumns();
  }
  /** @deprecated v31.1 moveColumn(key, toIndex) deprecated, please use moveColumns([key], toIndex) instead. */
  moveColumn(key, toIndex) {
    this.logDeprecation("v31.1", "moveColumn(key, toIndex)", "moveColumns([key], toIndex)");
    this.columnModel.moveColumns([key], toIndex, "api");
  }
  /** Moves the column at `fromIdex` to `toIndex`. The column is first removed, then added at the `toIndex` location, thus index locations will change to the right of the column after the removal. */
  moveColumnByIndex(fromIndex, toIndex) {
    this.columnModel.moveColumnByIndex(fromIndex, toIndex, "api");
  }
  /** Moves columns to `toIndex`. The columns are first removed, then added at the `toIndex` location, thus index locations will change to the right of the column after the removal. */
  moveColumns(columnsToMoveKeys, toIndex) {
    this.columnModel.moveColumns(columnsToMoveKeys, toIndex, "api");
  }
  /** Move the column to a new position in the row grouping order. */
  moveRowGroupColumn(fromIndex, toIndex) {
    this.columnModel.moveRowGroupColumn(fromIndex, toIndex, "api");
  }
  /** Sets the agg function for a column. `aggFunc` can be one of the built-in aggregations or a custom aggregation by name or direct function. */
  setColumnAggFunc(key, aggFunc) {
    this.columnModel.setColumnAggFunc(key, aggFunc, "api");
  }
  /** @deprecated v31.1 setColumnWidths(key, newWidth) deprecated, please use setColumnWidths( [{key: newWidth}] ) instead. */
  setColumnWidth(key, newWidth, finished = true, source = "api") {
    this.logDeprecation("v31.1", "setColumnWidth(col, width)", "setColumnWidths([{key: col, newWidth: width}])");
    this.columnModel.setColumnWidths([{ key, newWidth }], false, finished, source);
  }
  /** Sets the column widths of the columns provided. The finished flag gets included in the resulting event and not used internally by the grid. The finished flag is intended for dragging, where a dragging action will produce many `columnWidth` events, so the consumer of events knows when it receives the last event in a stream. The finished parameter is optional, and defaults to `true`. */
  setColumnWidths(columnWidths, finished = true, source = "api") {
    this.columnModel.setColumnWidths(columnWidths, false, finished, source);
  }
  /** Get the pivot mode. */
  isPivotMode() {
    return this.columnModel.isPivotMode();
  }
  /** Returns the pivot result column for the given `pivotKeys` and `valueColId`. Useful to then call operations on the pivot column. */
  getPivotResultColumn(pivotKeys, valueColKey) {
    return this.columnModel.getSecondaryPivotColumn(pivotKeys, valueColKey);
  }
  /** Set the value columns to the provided list of columns. */
  setValueColumns(colKeys) {
    this.columnModel.setValueColumns(colKeys, "api");
  }
  /** Get a list of the existing value columns. */
  getValueColumns() {
    return this.columnModel.getValueColumns();
  }
  /** @deprecated v31.1 removeValueColumn(colKey) deprecated, please use removeValueColumns([colKey]) instead. */
  removeValueColumn(colKey) {
    this.logDeprecation("v31.1", "removeValueColumn(colKey)", "removeValueColumns([colKey])");
    this.columnModel.removeValueColumns([colKey], "api");
  }
  /** Remove the given list of columns from the existing set of value columns. */
  removeValueColumns(colKeys) {
    this.columnModel.removeValueColumns(colKeys, "api");
  }
  /** @deprecated v31.1 addValueColumn(colKey) deprecated, please use addValueColumns([colKey]) instead. */
  addValueColumn(colKey) {
    this.logDeprecation("v31.1", "addValueColumn(colKey)", "addValueColumns([colKey])");
    this.columnModel.addValueColumns([colKey], "api");
  }
  /** Add the given list of columns to the existing set of value columns. */
  addValueColumns(colKeys) {
    this.columnModel.addValueColumns(colKeys, "api");
  }
  /** Set the row group columns. */
  setRowGroupColumns(colKeys) {
    this.columnModel.setRowGroupColumns(colKeys, "api");
  }
  /** @deprecated v31.1 removeRowGroupColumn(colKey) deprecated, please use removeRowGroupColumns([colKey]) instead. */
  removeRowGroupColumn(colKey) {
    this.logDeprecation("v31.1", "removeRowGroupColumn(colKey)", "removeRowGroupColumns([colKey])");
    this.columnModel.removeRowGroupColumns([colKey], "api");
  }
  /** Remove columns from the row groups. */
  removeRowGroupColumns(colKeys) {
    this.columnModel.removeRowGroupColumns(colKeys, "api");
  }
  /** @deprecated v31.1 addRowGroupColumn(colKey) deprecated, please use addRowGroupColumns([colKey]) instead. */
  addRowGroupColumn(colKey) {
    this.logDeprecation("v31.1", "addRowGroupColumn(colKey)", "addRowGroupColumns([colKey])");
    this.columnModel.addRowGroupColumns([colKey], "api");
  }
  /** Add columns to the row groups. */
  addRowGroupColumns(colKeys) {
    this.columnModel.addRowGroupColumns(colKeys, "api");
  }
  /** Get row group columns. */
  getRowGroupColumns() {
    return this.columnModel.getRowGroupColumns();
  }
  /** Set the pivot columns. */
  setPivotColumns(colKeys) {
    this.columnModel.setPivotColumns(colKeys, "api");
  }
  /** @deprecated v31.1 removePivotColumn(colKey) deprecated, please use removePivotColumns([colKey]) instead. */
  removePivotColumn(colKey) {
    this.logDeprecation("v31.1", "removePivotColumn(colKey)", "removePivotColumns([colKey])");
    this.columnModel.removePivotColumns([colKey], "api");
  }
  /** Remove pivot columns. */
  removePivotColumns(colKeys) {
    this.columnModel.removePivotColumns(colKeys, "api");
  }
  /** @deprecated v31.1 addPivotColumn(colKey) deprecated, please use addPivotColumns([colKey]) instead. */
  addPivotColumn(colKey) {
    this.logDeprecation("v31.1", "addPivotColumn(colKey)", "addPivotColumns([colKey])");
    this.columnModel.addPivotColumns([colKey], "api");
  }
  /** Add pivot columns. */
  addPivotColumns(colKeys) {
    this.columnModel.addPivotColumns(colKeys, "api");
  }
  /** Get the pivot columns. */
  getPivotColumns() {
    return this.columnModel.getPivotColumns();
  }
  /** Same as `getAllDisplayedColumnGroups` but just for the pinned left portion of the grid. */
  getLeftDisplayedColumnGroups() {
    return this.columnModel.getDisplayedTreeLeft();
  }
  /** Same as `getAllDisplayedColumnGroups` but just for the center portion of the grid. */
  getCenterDisplayedColumnGroups() {
    return this.columnModel.getDisplayedTreeCentre();
  }
  /** Same as `getAllDisplayedColumnGroups` but just for the pinned right portion of the grid. */
  getRightDisplayedColumnGroups() {
    return this.columnModel.getDisplayedTreeRight();
  }
  /** Returns all 'root' column headers. If you are not grouping columns, these return the columns. If you are grouping, these return the top level groups - you can navigate down through each one to get the other lower level headers and finally the columns at the bottom. */
  getAllDisplayedColumnGroups() {
    return this.columnModel.getAllDisplayedTrees();
  }
  /** @deprecated v31.1 autoSizeColumn(key) deprecated, please use autoSizeColumns([colKey]) instead. */
  autoSizeColumn(key, skipHeader) {
    this.logDeprecation("v31.1", "autoSizeColumn(key, skipHeader)", "autoSizeColumns([key], skipHeader)");
    return this.columnModel.autoSizeColumns({ columns: [key], skipHeader, source: "api" });
  }
  /**
   * Auto-sizes columns based on their contents. If inferring cell data types with custom column types
   * and row data is provided asynchronously, the column sizing will happen asynchronously when row data is added.
   * To always perform this synchronously, set `cellDataType = false` on the default column definition.
   */
  autoSizeColumns(keys2, skipHeader) {
    this.columnModel.autoSizeColumns({ columns: keys2, skipHeader, source: "api" });
  }
  /**
   * Calls `autoSizeColumns` on all displayed columns. If inferring cell data types with custom column types
   * and row data is provided asynchronously, the column sizing will happen asynchronously when row data is added.
   * To always perform this synchronously, set `cellDataType = false` on the default column definition.
   */
  autoSizeAllColumns(skipHeader) {
    this.columnModel.autoSizeAllColumns("api", skipHeader);
  }
  /** Set the pivot result columns. */
  setPivotResultColumns(colDefs) {
    this.columnModel.setSecondaryColumns(colDefs, "api");
  }
  /** Returns the grid's pivot result columns. */
  getPivotResultColumns() {
    return this.columnModel.getSecondaryColumns();
  }
  /** Get the current state of the grid. Can be used in conjunction with the `initialState` grid option to save and restore grid state. */
  getState() {
    return this.stateService.getState();
  }
  /**
   * Returns the grid option value for a provided key.
   */
  getGridOption(key) {
    return this.gos.get(key);
  }
  /**
   * Updates a single gridOption to the new value provided. (Cannot be used on `Initial` properties.)
   * If updating multiple options, it is recommended to instead use `api.updateGridOptions()` which batches update logic.
   */
  setGridOption(key, value) {
    this.updateGridOptions({ [key]: value });
  }
  /**
   * Updates the provided subset of gridOptions with the provided values. (Cannot be used on `Initial` properties.)
   */
  updateGridOptions(options) {
    this.gos.updateGridOptions({ options });
  }
  /** Used internally by grid. Not intended to be used by the client. Interface may change between releases. */
  __internalUpdateGridOptions(options) {
    this.gos.updateGridOptions({ options, source: "gridOptionsUpdated" });
  }
  deprecatedUpdateGridOption(key, value) {
    warnOnce(`set${key.charAt(0).toUpperCase()}${key.slice(1, key.length)} is deprecated. Please use 'api.setGridOption('${key}', newValue)' or 'api.updateGridOptions({ ${key}: newValue })' instead.`);
    this.setGridOption(key, value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Set the top pinned rows. Call with no rows / undefined to clear top pinned rows. 
   **/
  setPivotMode(pivotMode) {
    this.deprecatedUpdateGridOption("pivotMode", pivotMode);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Set the top pinned rows. Call with no rows / undefined to clear top pinned rows. 
   **/
  setPinnedTopRowData(rows) {
    this.deprecatedUpdateGridOption("pinnedTopRowData", rows);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Set the bottom pinned rows. Call with no rows / undefined to clear bottom pinned rows.
   * */
  setPinnedBottomRowData(rows) {
    this.deprecatedUpdateGridOption("pinnedBottomRowData", rows);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * DOM element to use as the popup parent for grid popups (context menu, column menu etc).
   * */
  setPopupParent(ePopupParent) {
    this.deprecatedUpdateGridOption("popupParent", ePopupParent);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   */
  setSuppressModelUpdateAfterUpdateTransaction(value) {
    this.deprecatedUpdateGridOption("suppressModelUpdateAfterUpdateTransaction", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Resets the data type definitions. This will update the columns in the grid.
   * */
  setDataTypeDefinitions(dataTypeDefinitions) {
    this.deprecatedUpdateGridOption("dataTypeDefinitions", dataTypeDefinitions);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Set whether the grid paginates the data or not.
   *  - `true` to enable pagination
   *  - `false` to disable pagination
   */
  setPagination(value) {
    this.deprecatedUpdateGridOption("pagination", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the `paginationPageSize`, then re-paginates the grid so the changes are applied immediately.
   * */
  paginationSetPageSize(size) {
    this.deprecatedUpdateGridOption("paginationPageSize", size);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Resets the side bar to the provided configuration. The parameter is the same as the sideBar grid property. The side bar is re-created from scratch with the new config.
   * */
  setSideBar(def) {
    this.deprecatedUpdateGridOption("sideBar", def);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   */
  setSuppressClipboardPaste(value) {
    this.deprecatedUpdateGridOption("suppressClipboardPaste", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   */
  setGroupRemoveSingleChildren(value) {
    this.deprecatedUpdateGridOption("groupRemoveSingleChildren", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   */
  setGroupRemoveLowestSingleChildren(value) {
    this.deprecatedUpdateGridOption("groupRemoveLowestSingleChildren", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   */
  setGroupDisplayType(value) {
    this.deprecatedUpdateGridOption("groupDisplayType", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the `groupIncludeFooter` property
   */
  setGroupIncludeFooter(value) {
    this.deprecatedUpdateGridOption("groupIncludeFooter", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the `groupIncludeTotalFooter` property
   */
  setGroupIncludeTotalFooter(value) {
    this.deprecatedUpdateGridOption("groupIncludeTotalFooter", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   */
  setRowClass(className) {
    this.deprecatedUpdateGridOption("rowClass", className);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the `deltaSort` property
   * */
  setDeltaSort(enable) {
    this.deprecatedUpdateGridOption("deltaSort", enable);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the `suppressRowDrag` property.
   * */
  setSuppressRowDrag(value) {
    this.deprecatedUpdateGridOption("suppressRowDrag", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the `suppressMoveWhenRowDragging` property.
   * */
  setSuppressMoveWhenRowDragging(value) {
    this.deprecatedUpdateGridOption("suppressMoveWhenRowDragging", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the `suppressRowClickSelection` property.
   * */
  setSuppressRowClickSelection(value) {
    this.deprecatedUpdateGridOption("suppressRowClickSelection", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Enable/disable the Advanced Filter
   * */
  setEnableAdvancedFilter(enabled) {
    this.deprecatedUpdateGridOption("enableAdvancedFilter", enabled);
  }
  /** 
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Updates the `includeHiddenColumnsInAdvancedFilter` grid option.
   * By default hidden columns are excluded from the Advanced Filter.
   * Set to `true` to include them.
   */
  setIncludeHiddenColumnsInAdvancedFilter(value) {
    this.deprecatedUpdateGridOption("includeHiddenColumnsInAdvancedFilter", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * DOM element to use as the parent for the Advanced Filter, to allow it to appear outside of the grid.
   * Set to `null` to appear inside the grid.
   */
  setAdvancedFilterParent(advancedFilterParent) {
    this.deprecatedUpdateGridOption("advancedFilterParent", advancedFilterParent);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Updates the Advanced Filter Builder parameters.
   * */
  setAdvancedFilterBuilderParams(params) {
    this.deprecatedUpdateGridOption("advancedFilterBuilderParams", params);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Pass a Quick Filter text into the grid for filtering.
   * */
  setQuickFilter(newFilter) {
    warnOnce(`setQuickFilter is deprecated. Please use 'api.setGridOption('quickFilterText', newValue)' or 'api.updateGridOptions({ quickFilterText: newValue })' instead.`);
    this.gos.updateGridOptions({ options: { quickFilterText: newFilter } });
  }
  /** 
   * @deprecated As of v30, hidden columns are excluded from the Quick Filter by default. To include hidden columns, use `setIncludeHiddenColumnsInQuickFilter` instead.
   */
  setExcludeHiddenColumnsFromQuickFilter(value) {
    this.deprecatedUpdateGridOption("includeHiddenColumnsInQuickFilter", !value);
  }
  /** 
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Updates the `includeHiddenColumnsInQuickFilter` grid option.
   * By default hidden columns are excluded from the Quick Filter.
   * Set to `true` to include them.
   */
  setIncludeHiddenColumnsInQuickFilter(value) {
    this.deprecatedUpdateGridOption("includeHiddenColumnsInQuickFilter", value);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Updates the `quickFilterParser` grid option,
   * which changes how the Quick Filter splits the Quick Filter text into search terms.
   */
  setQuickFilterParser(quickFilterParser) {
    this.deprecatedUpdateGridOption("quickFilterParser", quickFilterParser);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Updates the `quickFilterMatcher` grid option,
   * which changes the matching logic for whether a row passes the Quick Filter.
   */
  setQuickFilterMatcher(quickFilterMatcher) {
    this.deprecatedUpdateGridOption("quickFilterMatcher", quickFilterMatcher);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * If `true`, the horizontal scrollbar will always be present, even if not required. Otherwise, it will only be displayed when necessary.
   * */
  setAlwaysShowHorizontalScroll(show) {
    this.deprecatedUpdateGridOption("alwaysShowHorizontalScroll", show);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * If `true`, the vertical scrollbar will always be present, even if not required. Otherwise it will only be displayed when necessary.
   * */
  setAlwaysShowVerticalScroll(show) {
    this.deprecatedUpdateGridOption("alwaysShowVerticalScroll", show);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   */
  setFunctionsReadOnly(readOnly) {
    this.deprecatedUpdateGridOption("functionsReadOnly", readOnly);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Call to set new column definitions. The grid will redraw all the column headers, and then redraw all of the rows.
   */
  setColumnDefs(colDefs, source = "api") {
    warnOnce(`setColumnDefs is deprecated. Please use 'api.setGridOption('columnDefs', newValue)' or 'api.updateGridOptions({ columnDefs: newValue })' instead.`);
    this.gos.updateGridOptions({
      options: { columnDefs: colDefs },
      source
    });
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Call to set new auto group column definition. The grid will recreate any auto-group columns if present.
   * */
  setAutoGroupColumnDef(colDef, source = "api") {
    warnOnce(`setAutoGroupColumnDef is deprecated. Please use 'api.setGridOption('autoGroupColumnDef', newValue)' or 'api.updateGridOptions({ autoGroupColumnDef: newValue })' instead.`);
    this.gos.updateGridOptions({
      options: { autoGroupColumnDef: colDef },
      source
    });
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Call to set new Default Column Definition.
   * */
  setDefaultColDef(colDef, source = "api") {
    warnOnce(`setDefaultColDef is deprecated. Please use 'api.setGridOption('defaultColDef', newValue)' or 'api.updateGridOptions({ defaultColDef: newValue })' instead.`);
    this.gos.updateGridOptions({
      options: { defaultColDef: colDef },
      source
    });
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Call to set new Column Types.
   * */
  setColumnTypes(columnTypes, source = "api") {
    warnOnce(`setColumnTypes is deprecated. Please use 'api.setGridOption('columnTypes', newValue)' or 'api.updateGridOptions({ columnTypes: newValue })' instead.`);
    this.gos.updateGridOptions({
      options: { columnTypes },
      source
    });
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the `treeData` property.
   * */
  setTreeData(newTreeData) {
    this.deprecatedUpdateGridOption("treeData", newTreeData);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Set new datasource for Server-Side Row Model.
   * */
  setServerSideDatasource(datasource) {
    this.deprecatedUpdateGridOption("serverSideDatasource", datasource);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * 
   * Note this purges all the cached data and reloads all the rows of the grid.
   * */
  setCacheBlockSize(blockSize) {
    this.deprecatedUpdateGridOption("cacheBlockSize", blockSize);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Set new datasource for Infinite Row Model.
   * */
  setDatasource(datasource) {
    this.deprecatedUpdateGridOption("datasource", datasource);
  }
  /** 
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Set new datasource for Viewport Row Model.
   * */
  setViewportDatasource(viewportDatasource) {
    this.deprecatedUpdateGridOption("viewportDatasource", viewportDatasource);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Set the row data.
   * */
  setRowData(rowData) {
    this.deprecatedUpdateGridOption("rowData", rowData);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the `enableCellTextSelection` property.
   * */
  setEnableCellTextSelection(selectable) {
    this.deprecatedUpdateGridOption("enableCellTextSelection", selectable);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the height in pixels for the row containing the column label header.
   * */
  setHeaderHeight(headerHeight) {
    this.deprecatedUpdateGridOption("headerHeight", headerHeight);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Switch between layout options: `normal`, `autoHeight`, `print`.
   * Defaults to `normal` if no domLayout provided.
   */
  setDomLayout(domLayout) {
    this.deprecatedUpdateGridOption("domLayout", domLayout);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the preferred direction for the selection fill handle.
   * */
  setFillHandleDirection(direction) {
    this.deprecatedUpdateGridOption("fillHandleDirection", direction);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the height in pixels for the rows containing header column groups.
   * */
  setGroupHeaderHeight(headerHeight) {
    this.deprecatedUpdateGridOption("groupHeaderHeight", headerHeight);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the height in pixels for the row containing the floating filters.
   * */
  setFloatingFiltersHeight(headerHeight) {
    this.deprecatedUpdateGridOption("floatingFiltersHeight", headerHeight);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the height in pixels for the row containing the columns when in pivot mode.
   * */
  setPivotHeaderHeight(headerHeight) {
    this.deprecatedUpdateGridOption("pivotHeaderHeight", headerHeight);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   * Sets the height in pixels for the row containing header column groups when in pivot mode.
   * */
  setPivotGroupHeaderHeight(headerHeight) {
    this.deprecatedUpdateGridOption("pivotGroupHeaderHeight", headerHeight);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setAnimateRows(animateRows) {
    this.deprecatedUpdateGridOption("animateRows", animateRows);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setIsExternalFilterPresent(isExternalFilterPresentFunc) {
    this.deprecatedUpdateGridOption("isExternalFilterPresent", isExternalFilterPresentFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setDoesExternalFilterPass(doesExternalFilterPassFunc) {
    this.deprecatedUpdateGridOption("doesExternalFilterPass", doesExternalFilterPassFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setNavigateToNextCell(navigateToNextCellFunc) {
    this.deprecatedUpdateGridOption("navigateToNextCell", navigateToNextCellFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setTabToNextCell(tabToNextCellFunc) {
    this.deprecatedUpdateGridOption("tabToNextCell", tabToNextCellFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setTabToNextHeader(tabToNextHeaderFunc) {
    this.deprecatedUpdateGridOption("tabToNextHeader", tabToNextHeaderFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setNavigateToNextHeader(navigateToNextHeaderFunc) {
    this.deprecatedUpdateGridOption("navigateToNextHeader", navigateToNextHeaderFunc);
  }
  setRowGroupPanelShow(rowGroupPanelShow) {
    this.deprecatedUpdateGridOption("rowGroupPanelShow", rowGroupPanelShow);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetGroupRowAgg(getGroupRowAggFunc) {
    this.deprecatedUpdateGridOption("getGroupRowAgg", getGroupRowAggFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetBusinessKeyForNode(getBusinessKeyForNodeFunc) {
    this.deprecatedUpdateGridOption("getBusinessKeyForNode", getBusinessKeyForNodeFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetChildCount(getChildCountFunc) {
    this.deprecatedUpdateGridOption("getChildCount", getChildCountFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setProcessRowPostCreate(processRowPostCreateFunc) {
    this.deprecatedUpdateGridOption("processRowPostCreate", processRowPostCreateFunc);
  }
  /**
   * @deprecated v31 `getRowId` is a static property and cannot be updated.
   *  */
  setGetRowId(getRowIdFunc) {
    warnOnce(`getRowId is a static property and can no longer be updated.`);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetRowClass(rowClassFunc) {
    this.deprecatedUpdateGridOption("getRowClass", rowClassFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setIsFullWidthRow(isFullWidthRowFunc) {
    this.deprecatedUpdateGridOption("isFullWidthRow", isFullWidthRowFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setIsRowSelectable(isRowSelectableFunc) {
    this.deprecatedUpdateGridOption("isRowSelectable", isRowSelectableFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setIsRowMaster(isRowMasterFunc) {
    this.deprecatedUpdateGridOption("isRowMaster", isRowMasterFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setPostSortRows(postSortRowsFunc) {
    this.deprecatedUpdateGridOption("postSortRows", postSortRowsFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetDocument(getDocumentFunc) {
    this.deprecatedUpdateGridOption("getDocument", getDocumentFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetContextMenuItems(getContextMenuItemsFunc) {
    this.deprecatedUpdateGridOption("getContextMenuItems", getContextMenuItemsFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetMainMenuItems(getMainMenuItemsFunc) {
    this.deprecatedUpdateGridOption("getMainMenuItems", getMainMenuItemsFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setProcessCellForClipboard(processCellForClipboardFunc) {
    this.deprecatedUpdateGridOption("processCellForClipboard", processCellForClipboardFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setSendToClipboard(sendToClipboardFunc) {
    this.deprecatedUpdateGridOption("sendToClipboard", sendToClipboardFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setProcessCellFromClipboard(processCellFromClipboardFunc) {
    this.deprecatedUpdateGridOption("processCellFromClipboard", processCellFromClipboardFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setProcessPivotResultColDef(processPivotResultColDefFunc) {
    this.deprecatedUpdateGridOption("processPivotResultColDef", processPivotResultColDefFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setProcessPivotResultColGroupDef(processPivotResultColGroupDefFunc) {
    this.deprecatedUpdateGridOption("processPivotResultColGroupDef", processPivotResultColGroupDefFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setPostProcessPopup(postProcessPopupFunc) {
    this.deprecatedUpdateGridOption("postProcessPopup", postProcessPopupFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setInitialGroupOrderComparator(initialGroupOrderComparatorFunc) {
    this.deprecatedUpdateGridOption("initialGroupOrderComparator", initialGroupOrderComparatorFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetChartToolbarItems(getChartToolbarItemsFunc) {
    this.deprecatedUpdateGridOption("getChartToolbarItems", getChartToolbarItemsFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setPaginationNumberFormatter(paginationNumberFormatterFunc) {
    this.deprecatedUpdateGridOption("paginationNumberFormatter", paginationNumberFormatterFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetServerSideGroupLevelParams(getServerSideGroupLevelParamsFunc) {
    this.deprecatedUpdateGridOption("getServerSideGroupLevelParams", getServerSideGroupLevelParamsFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setIsServerSideGroupOpenByDefault(isServerSideGroupOpenByDefaultFunc) {
    this.deprecatedUpdateGridOption("isServerSideGroupOpenByDefault", isServerSideGroupOpenByDefaultFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setIsApplyServerSideTransaction(isApplyServerSideTransactionFunc) {
    this.deprecatedUpdateGridOption("isApplyServerSideTransaction", isApplyServerSideTransactionFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setIsServerSideGroup(isServerSideGroupFunc) {
    this.deprecatedUpdateGridOption("isServerSideGroup", isServerSideGroupFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetServerSideGroupKey(getServerSideGroupKeyFunc) {
    this.deprecatedUpdateGridOption("getServerSideGroupKey", getServerSideGroupKeyFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetRowStyle(rowStyleFunc) {
    this.deprecatedUpdateGridOption("getRowStyle", rowStyleFunc);
  }
  /**
   * @deprecated v31 Use `api.setGridOption` or `api.updateGridOptions` instead.
   *  */
  setGetRowHeight(rowHeightFunc) {
    this.deprecatedUpdateGridOption("getRowHeight", rowHeightFunc);
  }
};
__decorateClass([
  Optional("csvCreator")
], GridApi.prototype, "csvCreator", 2);
__decorateClass([
  Optional("excelCreator")
], GridApi.prototype, "excelCreator", 2);
__decorateClass([
  Autowired("rowRenderer")
], GridApi.prototype, "rowRenderer", 2);
__decorateClass([
  Autowired("navigationService")
], GridApi.prototype, "navigationService", 2);
__decorateClass([
  Autowired("filterManager")
], GridApi.prototype, "filterManager", 2);
__decorateClass([
  Autowired("columnModel")
], GridApi.prototype, "columnModel", 2);
__decorateClass([
  Autowired("selectionService")
], GridApi.prototype, "selectionService", 2);
__decorateClass([
  Autowired("gridOptionsService")
], GridApi.prototype, "gos", 2);
__decorateClass([
  Autowired("valueService")
], GridApi.prototype, "valueService", 2);
__decorateClass([
  Autowired("alignedGridsService")
], GridApi.prototype, "alignedGridsService", 2);
__decorateClass([
  Autowired("eventService")
], GridApi.prototype, "eventService", 2);
__decorateClass([
  Autowired("pinnedRowModel")
], GridApi.prototype, "pinnedRowModel", 2);
__decorateClass([
  Autowired("context")
], GridApi.prototype, "context", 2);
__decorateClass([
  Autowired("rowModel")
], GridApi.prototype, "rowModel", 2);
__decorateClass([
  Autowired("sortController")
], GridApi.prototype, "sortController", 2);
__decorateClass([
  Autowired("paginationProxy")
], GridApi.prototype, "paginationProxy", 2);
__decorateClass([
  Autowired("focusService")
], GridApi.prototype, "focusService", 2);
__decorateClass([
  Autowired("dragAndDropService")
], GridApi.prototype, "dragAndDropService", 2);
__decorateClass([
  Optional("rangeService")
], GridApi.prototype, "rangeService", 2);
__decorateClass([
  Optional("clipboardService")
], GridApi.prototype, "clipboardService", 2);
__decorateClass([
  Optional("aggFuncService")
], GridApi.prototype, "aggFuncService", 2);
__decorateClass([
  Autowired("menuService")
], GridApi.prototype, "menuService", 2);
__decorateClass([
  Autowired("valueCache")
], GridApi.prototype, "valueCache", 2);
__decorateClass([
  Autowired("animationFrameService")
], GridApi.prototype, "animationFrameService", 2);
__decorateClass([
  Optional("statusBarService")
], GridApi.prototype, "statusBarService", 2);
__decorateClass([
  Optional("chartService")
], GridApi.prototype, "chartService", 2);
__decorateClass([
  Optional("undoRedoService")
], GridApi.prototype, "undoRedoService", 2);
__decorateClass([
  Optional("rowNodeBlockLoader")
], GridApi.prototype, "rowNodeBlockLoader", 2);
__decorateClass([
  Optional("ssrmTransactionManager")
], GridApi.prototype, "serverSideTransactionManager", 2);
__decorateClass([
  Autowired("ctrlsService")
], GridApi.prototype, "ctrlsService", 2);
__decorateClass([
  Autowired("overlayService")
], GridApi.prototype, "overlayService", 2);
__decorateClass([
  Optional("sideBarService")
], GridApi.prototype, "sideBarService", 2);
__decorateClass([
  Autowired("stateService")
], GridApi.prototype, "stateService", 2);
__decorateClass([
  Autowired("expansionService")
], GridApi.prototype, "expansionService", 2);
__decorateClass([
  Autowired("apiEventService")
], GridApi.prototype, "apiEventService", 2);
__decorateClass([
  Autowired("frameworkOverrides")
], GridApi.prototype, "frameworkOverrides", 2);
__decorateClass([
  PostConstruct
], GridApi.prototype, "init", 1);
GridApi = __decorateClass([
  Bean("gridApi")
], GridApi);

// community-modules/core/src/filter/quickFilterService.ts
var QuickFilterService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.quickFilter = null;
    this.quickFilterParts = null;
  }
  postConstruct() {
    this.addManagedListener(this.eventService, Events.EVENT_COLUMN_PIVOT_MODE_CHANGED, () => this.resetQuickFilterCache());
    this.addManagedListener(this.eventService, Events.EVENT_NEW_COLUMNS_LOADED, () => this.resetQuickFilterCache());
    this.addManagedListener(this.eventService, Events.EVENT_COLUMN_ROW_GROUP_CHANGED, () => this.resetQuickFilterCache());
    this.addManagedListener(this.eventService, Events.EVENT_COLUMN_VISIBLE, () => {
      if (!this.gridOptionsService.get("includeHiddenColumnsInQuickFilter")) {
        this.resetQuickFilterCache();
      }
    });
    this.addManagedPropertyListener("quickFilterText", (e) => this.setQuickFilter(e.currentValue));
    this.addManagedPropertyListener("includeHiddenColumnsInQuickFilter", () => this.onIncludeHiddenColumnsInQuickFilterChanged());
    this.quickFilter = this.parseQuickFilter(this.gridOptionsService.get("quickFilterText"));
    this.parser = this.gridOptionsService.get("quickFilterParser");
    this.matcher = this.gridOptionsService.get("quickFilterMatcher");
    this.setQuickFilterParts();
    this.addManagedPropertyListeners(["quickFilterMatcher", "quickFilterParser"], () => this.setQuickFilterParserAndMatcher());
  }
  isQuickFilterPresent() {
    return this.quickFilter !== null;
  }
  doesRowPassQuickFilter(node) {
    const usingCache = this.gridOptionsService.get("cacheQuickFilter");
    if (this.matcher) {
      return this.doesRowPassQuickFilterMatcher(usingCache, node);
    }
    return this.quickFilterParts.every(
      (part) => usingCache ? this.doesRowPassQuickFilterCache(node, part) : this.doesRowPassQuickFilterNoCache(node, part)
    );
  }
  resetQuickFilterCache() {
    this.rowModel.forEachNode((node) => node.quickFilterAggregateText = null);
  }
  setQuickFilterParts() {
    const { quickFilter, parser } = this;
    if (quickFilter) {
      this.quickFilterParts = parser ? parser(quickFilter) : quickFilter.split(" ");
    } else {
      this.quickFilterParts = null;
    }
  }
  parseQuickFilter(newFilter) {
    if (!exists(newFilter)) {
      return null;
    }
    if (!this.gridOptionsService.isRowModelType("clientSide")) {
      console.warn("AG Grid - Quick filtering only works with the Client-Side Row Model");
      return null;
    }
    return newFilter.toUpperCase();
  }
  setQuickFilter(newFilter) {
    if (newFilter != null && typeof newFilter !== "string") {
      console.warn(`AG Grid - Grid option quickFilterText only supports string inputs, received: ${typeof newFilter}`);
      return;
    }
    const parsedFilter = this.parseQuickFilter(newFilter);
    if (this.quickFilter !== parsedFilter) {
      this.quickFilter = parsedFilter;
      this.setQuickFilterParts();
      this.dispatchEvent({ type: QuickFilterService.EVENT_QUICK_FILTER_CHANGED });
    }
  }
  setQuickFilterParserAndMatcher() {
    const parser = this.gridOptionsService.get("quickFilterParser");
    const matcher = this.gridOptionsService.get("quickFilterMatcher");
    const hasChanged = parser !== this.parser || matcher !== this.matcher;
    this.parser = parser;
    this.matcher = matcher;
    if (hasChanged) {
      this.setQuickFilterParts();
      this.dispatchEvent({ type: QuickFilterService.EVENT_QUICK_FILTER_CHANGED });
    }
  }
  onIncludeHiddenColumnsInQuickFilterChanged() {
    this.columnModel.refreshQuickFilterColumns();
    this.resetQuickFilterCache();
    if (this.isQuickFilterPresent()) {
      this.dispatchEvent({ type: QuickFilterService.EVENT_QUICK_FILTER_CHANGED });
    }
  }
  doesRowPassQuickFilterNoCache(node, filterPart) {
    const columns = this.columnModel.getAllColumnsForQuickFilter();
    return columns.some((column) => {
      const part = this.getQuickFilterTextForColumn(column, node);
      return exists(part) && part.indexOf(filterPart) >= 0;
    });
  }
  doesRowPassQuickFilterCache(node, filterPart) {
    this.checkGenerateQuickFilterAggregateText(node);
    return node.quickFilterAggregateText.indexOf(filterPart) >= 0;
  }
  doesRowPassQuickFilterMatcher(usingCache, node) {
    let quickFilterAggregateText;
    if (usingCache) {
      this.checkGenerateQuickFilterAggregateText(node);
      quickFilterAggregateText = node.quickFilterAggregateText;
    } else {
      quickFilterAggregateText = this.getQuickFilterAggregateText(node);
    }
    const { quickFilterParts, matcher } = this;
    return matcher(quickFilterParts, quickFilterAggregateText);
  }
  checkGenerateQuickFilterAggregateText(node) {
    if (!node.quickFilterAggregateText) {
      node.quickFilterAggregateText = this.getQuickFilterAggregateText(node);
    }
  }
  getQuickFilterTextForColumn(column, node) {
    let value = this.valueService.getValue(column, node, true);
    const colDef = column.getColDef();
    if (colDef.getQuickFilterText) {
      const params = this.gridOptionsService.addGridCommonParams({
        value,
        node,
        data: node.data,
        column,
        colDef
      });
      value = colDef.getQuickFilterText(params);
    }
    return exists(value) ? value.toString().toUpperCase() : null;
  }
  getQuickFilterAggregateText(node) {
    const stringParts = [];
    const columns = this.columnModel.getAllColumnsForQuickFilter();
    columns.forEach((column) => {
      const part = this.getQuickFilterTextForColumn(column, node);
      if (exists(part)) {
        stringParts.push(part);
      }
    });
    return stringParts.join(QuickFilterService.QUICK_FILTER_SEPARATOR);
  }
};
QuickFilterService.EVENT_QUICK_FILTER_CHANGED = "quickFilterChanged";
QuickFilterService.QUICK_FILTER_SEPARATOR = "\n";
__decorateClass([
  Autowired("valueService")
], QuickFilterService.prototype, "valueService", 2);
__decorateClass([
  Autowired("columnModel")
], QuickFilterService.prototype, "columnModel", 2);
__decorateClass([
  Autowired("rowModel")
], QuickFilterService.prototype, "rowModel", 2);
__decorateClass([
  PostConstruct
], QuickFilterService.prototype, "postConstruct", 1);
QuickFilterService = __decorateClass([
  Bean("quickFilterService")
], QuickFilterService);

// community-modules/core/src/filter/filterManager.ts
var FilterManager = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.allColumnFilters = /* @__PURE__ */ new Map();
    this.allColumnListeners = /* @__PURE__ */ new Map();
    this.activeAggregateFilters = [];
    this.activeColumnFilters = [];
    // this is true when the grid is processing the filter change. this is used by the cell comps, so that they
    // don't flash when data changes due to filter changes. there is no need to flash when filter changes as the
    // user is in control, so doesn't make sense to show flashing changes. for example, go to main demo where
    // this feature is turned off (hack code to always return false for isSuppressFlashingCellsBecauseFiltering(), put in)
    // 100,000 rows and group by country. then do some filtering. all the cells flash, which is silly.
    this.processingFilterChange = false;
    // when we're waiting for cell data types to be inferred, we need to defer filter model updates
    this.filterModelUpdateQueue = [];
    this.columnFilterModelUpdateQueue = [];
    this.advancedFilterModelUpdateQueue = [];
  }
  init() {
    var _a, _b, _c;
    this.addManagedListener(this.eventService, Events.EVENT_GRID_COLUMNS_CHANGED, () => this.onColumnsChanged());
    this.addManagedListener(this.eventService, Events.EVENT_COLUMN_VALUE_CHANGED, () => this.refreshFiltersForAggregations());
    this.addManagedListener(this.eventService, Events.EVENT_COLUMN_PIVOT_CHANGED, () => this.refreshFiltersForAggregations());
    this.addManagedListener(this.eventService, Events.EVENT_COLUMN_PIVOT_MODE_CHANGED, () => this.refreshFiltersForAggregations());
    this.addManagedListener(this.eventService, Events.EVENT_NEW_COLUMNS_LOADED, () => this.updateAdvancedFilterColumns());
    this.addManagedListener(this.eventService, Events.EVENT_COLUMN_VISIBLE, () => this.updateAdvancedFilterColumns());
    this.addManagedListener(this.eventService, Events.EVENT_ROW_DATA_UPDATED, () => this.onNewRowsLoaded("rowDataUpdated"));
    this.externalFilterPresent = this.isExternalFilterPresentCallback();
    this.addManagedPropertyListeners(["isExternalFilterPresent", "doesExternalFilterPass"], () => {
      this.onFilterChanged({ source: "api" });
    });
    this.updateAggFiltering();
    this.addManagedPropertyListener("groupAggFiltering", () => {
      this.updateAggFiltering();
      this.onFilterChanged();
    });
    this.addManagedPropertyListener("advancedFilterModel", (event) => this.setAdvancedFilterModel(event.currentValue));
    this.addManagedListener(
      this.eventService,
      Events.EVENT_ADVANCED_FILTER_ENABLED_CHANGED,
      ({ enabled }) => this.onAdvancedFilterEnabledChanged(enabled)
    );
    this.addManagedListener(this.eventService, Events.EVENT_DATA_TYPES_INFERRED, () => this.processFilterModelUpdateQueue());
    this.addManagedListener(this.quickFilterService, QuickFilterService.EVENT_QUICK_FILTER_CHANGED, () => this.onFilterChanged({ source: "quickFilter" }));
    this.initialFilterModel = __spreadValues({}, (_c = (_b = (_a = this.gridOptionsService.get("initialState")) == null ? void 0 : _a.filter) == null ? void 0 : _b.filterModel) != null ? _c : {});
  }
  isExternalFilterPresentCallback() {
    const isFilterPresent = this.gridOptionsService.getCallback("isExternalFilterPresent");
    if (typeof isFilterPresent === "function") {
      return isFilterPresent({});
    }
    return false;
  }
  doesExternalFilterPass(node) {
    const doesFilterPass = this.gridOptionsService.get("doesExternalFilterPass");
    if (typeof doesFilterPass === "function") {
      return doesFilterPass(node);
    }
    return false;
  }
  setFilterModel(model, source = "api") {
    if (this.isAdvancedFilterEnabled()) {
      this.warnAdvancedFilters();
      return;
    }
    if (this.dataTypeService.isPendingInference()) {
      this.filterModelUpdateQueue.push({ model, source });
      return;
    }
    const allPromises = [];
    const previousModel = this.getFilterModel();
    if (model) {
      const modelKeys = convertToSet(Object.keys(model));
      this.allColumnFilters.forEach((filterWrapper, colId) => {
        const newModel = model[colId];
        allPromises.push(this.setModelOnFilterWrapper(filterWrapper.filterPromise, newModel));
        modelKeys.delete(colId);
      });
      modelKeys.forEach((colId) => {
        const column = this.columnModel.getPrimaryColumn(colId) || this.columnModel.getGridColumn(colId);
        if (!column) {
          console.warn("AG Grid: setFilterModel() - no column found for colId: " + colId);
          return;
        }
        if (!column.isFilterAllowed()) {
          console.warn("AG Grid: setFilterModel() - unable to fully apply model, filtering disabled for colId: " + colId);
          return;
        }
        const filterWrapper = this.getOrCreateFilterWrapper(column, "NO_UI");
        if (!filterWrapper) {
          console.warn("AG-Grid: setFilterModel() - unable to fully apply model, unable to create filter for colId: " + colId);
          return;
        }
        allPromises.push(this.setModelOnFilterWrapper(filterWrapper.filterPromise, model[colId]));
      });
    } else {
      this.allColumnFilters.forEach((filterWrapper) => {
        allPromises.push(this.setModelOnFilterWrapper(filterWrapper.filterPromise, null));
      });
    }
    AgPromise.all(allPromises).then(() => {
      const currentModel = this.getFilterModel();
      const columns = [];
      this.allColumnFilters.forEach((filterWrapper, colId) => {
        const before = previousModel ? previousModel[colId] : null;
        const after = currentModel ? currentModel[colId] : null;
        if (!_.jsonEquals(before, after)) {
          columns.push(filterWrapper.column);
        }
      });
      if (columns.length > 0) {
        this.onFilterChanged({ columns, source });
      }
    });
  }
  setModelOnFilterWrapper(filterPromise, newModel) {
    return new AgPromise((resolve) => {
      filterPromise.then((filter) => {
        if (typeof filter.setModel !== "function") {
          console.warn("AG Grid: filter missing setModel method, which is needed for setFilterModel");
          resolve();
        }
        (filter.setModel(newModel) || AgPromise.resolve()).then(() => resolve());
      });
    });
  }
  getFilterModel() {
    const result = {};
    this.allColumnFilters.forEach((filterWrapper, key) => {
      const model = this.getModelFromFilterWrapper(filterWrapper);
      if (exists(model)) {
        result[key] = model;
      }
    });
    return result;
  }
  getModelFromFilterWrapper(filterWrapper) {
    var _a;
    const filterPromise = filterWrapper.filterPromise;
    const filter = filterPromise.resolveNow(null, (promiseFilter) => promiseFilter);
    if (filter == null) {
      return (_a = this.initialFilterModel[filterWrapper.column.getColId()]) != null ? _a : null;
    }
    if (typeof filter.getModel !== "function") {
      console.warn("AG Grid: filter API missing getModel method, which is needed for getFilterModel");
      return null;
    }
    return filter.getModel();
  }
  isColumnFilterPresent() {
    return this.activeColumnFilters.length > 0;
  }
  isAggregateFilterPresent() {
    return !!this.activeAggregateFilters.length;
  }
  isExternalFilterPresent() {
    return this.externalFilterPresent;
  }
  isChildFilterPresent() {
    return this.isColumnFilterPresent() || this.isQuickFilterPresent() || this.isExternalFilterPresent() || this.isAdvancedFilterPresent();
  }
  isAdvancedFilterPresent() {
    return this.isAdvancedFilterEnabled() && this.advancedFilterService.isFilterPresent();
  }
  onAdvancedFilterEnabledChanged(enabled) {
    var _a;
    if (enabled) {
      if (this.allColumnFilters.size) {
        this.allColumnFilters.forEach((filterWrapper) => this.disposeFilterWrapper(filterWrapper, "advancedFilterEnabled"));
        this.onFilterChanged({ source: "advancedFilter" });
      }
    } else {
      if ((_a = this.advancedFilterService) == null ? void 0 : _a.isFilterPresent()) {
        this.advancedFilterService.setModel(null);
        this.onFilterChanged({ source: "advancedFilter" });
      }
    }
  }
  isAdvancedFilterEnabled() {
    var _a;
    return !!((_a = this.advancedFilterService) == null ? void 0 : _a.isEnabled());
  }
  isAdvancedFilterHeaderActive() {
    return this.isAdvancedFilterEnabled() && this.advancedFilterService.isHeaderActive();
  }
  doAggregateFiltersPass(node, filterToSkip) {
    return this.doColumnFiltersPass(node, filterToSkip, true);
  }
  // called by:
  // 1) onFilterChanged()
  // 2) onNewRowsLoaded()
  updateActiveFilters() {
    this.activeColumnFilters.length = 0;
    this.activeAggregateFilters.length = 0;
    const isFilterActive = (filter) => {
      if (!filter) {
        return false;
      }
      if (!filter.isFilterActive) {
        console.warn("AG Grid: Filter is missing isFilterActive() method");
        return false;
      }
      return filter.isFilterActive();
    };
    const groupFilterEnabled = !!this.gridOptionsService.getGroupAggFiltering();
    const isAggFilter = (column) => {
      const isSecondary = !column.isPrimary();
      if (isSecondary) {
        return true;
      }
      const isShowingPrimaryColumns = !this.columnModel.isPivotActive();
      const isValueActive = column.isValueActive();
      if (!isValueActive || !isShowingPrimaryColumns) {
        return false;
      }
      if (this.columnModel.isPivotMode()) {
        return true;
      }
      return groupFilterEnabled;
    };
    this.allColumnFilters.forEach((filterWrapper) => {
      if (filterWrapper.filterPromise.resolveNow(false, isFilterActive)) {
        const filterComp = filterWrapper.filterPromise.resolveNow(null, (filter) => filter);
        if (isAggFilter(filterWrapper.column)) {
          this.activeAggregateFilters.push(filterComp);
        } else {
          this.activeColumnFilters.push(filterComp);
        }
      }
    });
  }
  updateFilterFlagInColumns(source, additionalEventAttributes) {
    this.allColumnFilters.forEach((filterWrapper) => {
      const isFilterActive = filterWrapper.filterPromise.resolveNow(false, (filter) => filter.isFilterActive());
      filterWrapper.column.setFilterActive(isFilterActive, source, additionalEventAttributes);
    });
  }
  isAnyFilterPresent() {
    return this.isQuickFilterPresent() || this.isColumnFilterPresent() || this.isAggregateFilterPresent() || this.isExternalFilterPresent() || this.isAdvancedFilterPresent();
  }
  doColumnFiltersPass(node, filterToSkip, targetAggregates) {
    const { data, aggData } = node;
    const targetedFilters = targetAggregates ? this.activeAggregateFilters : this.activeColumnFilters;
    const targetedData = targetAggregates ? aggData : data;
    for (let i = 0; i < targetedFilters.length; i++) {
      const filter = targetedFilters[i];
      if (filter == null || filter === filterToSkip) {
        continue;
      }
      if (typeof filter.doesFilterPass !== "function") {
        throw new Error("Filter is missing method doesFilterPass");
      }
      if (!filter.doesFilterPass({ node, data: targetedData })) {
        return false;
      }
    }
    return true;
  }
  resetQuickFilterCache() {
    this.quickFilterService.resetQuickFilterCache();
  }
  refreshFiltersForAggregations() {
    const isAggFiltering = this.gridOptionsService.getGroupAggFiltering();
    if (isAggFiltering) {
      this.onFilterChanged();
    }
  }
  // sometimes (especially in React) the filter can call onFilterChanged when we are in the middle
  // of a render cycle. this would be bad, so we wait for render cycle to complete when this happens.
  // this happens in react when we change React State in the grid (eg setting RowCtrl's in RowContainer)
  // which results in React State getting applied in the main application, triggering a useEffect() to
  // be kicked off adn then the application calling the grid's API. in AG-6554, the custom filter was
  // getting it's useEffect() triggered in this way.
  callOnFilterChangedOutsideRenderCycle(params) {
    const action = () => this.onFilterChanged(params);
    if (this.rowRenderer.isRefreshInProgress()) {
      setTimeout(action, 0);
    } else {
      action();
    }
  }
  onFilterChanged(params = {}) {
    const { source, filterInstance, additionalEventAttributes, columns } = params;
    this.updateDependantFilters();
    this.updateActiveFilters();
    this.updateFilterFlagInColumns("filterChanged", additionalEventAttributes);
    this.externalFilterPresent = this.isExternalFilterPresentCallback();
    this.allColumnFilters.forEach((filterWrapper) => {
      if (!filterWrapper.filterPromise) {
        return;
      }
      filterWrapper.filterPromise.then((filter) => {
        if (filter && filter !== filterInstance && filter.onAnyFilterChanged) {
          filter.onAnyFilterChanged();
        }
      });
    });
    const filterChangedEvent = {
      source,
      type: Events.EVENT_FILTER_CHANGED,
      columns: columns || []
    };
    if (additionalEventAttributes) {
      mergeDeep(filterChangedEvent, additionalEventAttributes);
    }
    this.processingFilterChange = true;
    this.eventService.dispatchEvent(filterChangedEvent);
    this.processingFilterChange = false;
  }
  isSuppressFlashingCellsBecauseFiltering() {
    var _a;
    const allowShowChangeAfterFilter = (_a = this.gridOptionsService.get("allowShowChangeAfterFilter")) != null ? _a : false;
    return !allowShowChangeAfterFilter && this.processingFilterChange;
  }
  isQuickFilterPresent() {
    return this.quickFilterService.isQuickFilterPresent();
  }
  updateAggFiltering() {
    this.aggFiltering = !!this.gridOptionsService.getGroupAggFiltering();
  }
  isAggregateQuickFilterPresent() {
    return this.isQuickFilterPresent() && (this.aggFiltering || this.columnModel.isPivotMode());
  }
  isNonAggregateQuickFilterPresent() {
    return this.isQuickFilterPresent() && !(this.aggFiltering || this.columnModel.isPivotMode());
  }
  doesRowPassOtherFilters(filterToSkip, node) {
    return this.doesRowPassFilter({ rowNode: node, filterInstanceToSkip: filterToSkip });
  }
  doesRowPassAggregateFilters(params) {
    if (this.isAggregateQuickFilterPresent() && !this.quickFilterService.doesRowPassQuickFilter(params.rowNode)) {
      return false;
    }
    if (this.isAggregateFilterPresent() && !this.doAggregateFiltersPass(params.rowNode, params.filterInstanceToSkip)) {
      return false;
    }
    return true;
  }
  doesRowPassFilter(params) {
    if (this.isNonAggregateQuickFilterPresent() && !this.quickFilterService.doesRowPassQuickFilter(params.rowNode)) {
      return false;
    }
    if (this.isExternalFilterPresent() && !this.doesExternalFilterPass(params.rowNode)) {
      return false;
    }
    if (this.isColumnFilterPresent() && !this.doColumnFiltersPass(params.rowNode, params.filterInstanceToSkip)) {
      return false;
    }
    if (this.isAdvancedFilterPresent() && !this.advancedFilterService.doesFilterPass(params.rowNode)) {
      return false;
    }
    return true;
  }
  onNewRowsLoaded(source) {
    this.allColumnFilters.forEach((filterWrapper) => {
      filterWrapper.filterPromise.then((filter) => {
        if (filter.onNewRowsLoaded) {
          filter.onNewRowsLoaded();
        }
      });
    });
    this.updateFilterFlagInColumns(source, { afterDataChange: true });
    this.updateActiveFilters();
  }
  createValueGetter(column) {
    return ({ node }) => this.valueService.getValue(column, node, true);
  }
  createGetValue(filterColumn) {
    return (rowNode, column) => {
      const columnToUse = column ? this.columnModel.getGridColumn(column) : filterColumn;
      return columnToUse ? this.valueService.getValue(columnToUse, rowNode, true) : void 0;
    };
  }
  getFilterComponent(column, source, createIfDoesNotExist = true) {
    var _a;
    if (createIfDoesNotExist) {
      return ((_a = this.getOrCreateFilterWrapper(column, source)) == null ? void 0 : _a.filterPromise) || null;
    }
    const filterWrapper = this.cachedFilter(column);
    return filterWrapper ? filterWrapper.filterPromise : null;
  }
  isFilterActive(column) {
    const filterWrapper = this.cachedFilter(column);
    return !!filterWrapper && filterWrapper.filterPromise.resolveNow(false, (filter) => filter.isFilterActive());
  }
  getOrCreateFilterWrapper(column, source) {
    if (!column.isFilterAllowed()) {
      return null;
    }
    let filterWrapper = this.cachedFilter(column);
    if (!filterWrapper) {
      filterWrapper = this.createFilterWrapper(column, source);
      this.setColumnFilterWrapper(column, filterWrapper);
    } else if (source !== "NO_UI") {
      this.putIntoGui(filterWrapper, source);
    }
    return filterWrapper;
  }
  cachedFilter(column) {
    return this.allColumnFilters.get(column.getColId());
  }
  getDefaultFilter(column) {
    let defaultFilter;
    if (ModuleRegistry.__isRegistered("@ag-grid-enterprise/set-filter" /* SetFilterModule */, this.context.getGridId())) {
      defaultFilter = "agSetColumnFilter";
    } else {
      const cellDataType = this.dataTypeService.getBaseDataType(column);
      if (cellDataType === "number") {
        defaultFilter = "agNumberColumnFilter";
      } else if (cellDataType === "date" || cellDataType === "dateString") {
        defaultFilter = "agDateColumnFilter";
      } else {
        defaultFilter = "agTextColumnFilter";
      }
    }
    return defaultFilter;
  }
  getDefaultFloatingFilter(column) {
    let defaultFloatingFilterType;
    if (ModuleRegistry.__isRegistered("@ag-grid-enterprise/set-filter" /* SetFilterModule */, this.context.getGridId())) {
      defaultFloatingFilterType = "agSetColumnFloatingFilter";
    } else {
      const cellDataType = this.dataTypeService.getBaseDataType(column);
      if (cellDataType === "number") {
        defaultFloatingFilterType = "agNumberColumnFloatingFilter";
      } else if (cellDataType === "date" || cellDataType === "dateString") {
        defaultFloatingFilterType = "agDateColumnFloatingFilter";
      } else {
        defaultFloatingFilterType = "agTextColumnFloatingFilter";
      }
    }
    return defaultFloatingFilterType;
  }
  createFilterInstance(column) {
    const defaultFilter = this.getDefaultFilter(column);
    const colDef = column.getColDef();
    let filterInstance;
    const params = __spreadProps(__spreadValues({}, this.createFilterParams(column, colDef)), {
      filterModifiedCallback: () => this.filterModifiedCallbackFactory(filterInstance, column)(),
      filterChangedCallback: (additionalEventAttributes) => this.filterChangedCallbackFactory(filterInstance, column)(additionalEventAttributes),
      doesRowPassOtherFilter: (node) => this.doesRowPassOtherFilters(filterInstance, node)
    });
    const compDetails = this.userComponentFactory.getFilterDetails(colDef, params, defaultFilter);
    if (!compDetails) {
      return { filterPromise: null, compDetails: null };
    }
    return {
      filterPromise: () => {
        const filterPromise = compDetails.newAgStackInstance();
        if (filterPromise) {
          filterPromise.then((r) => filterInstance = r);
        }
        return filterPromise;
      },
      compDetails
    };
  }
  createFilterParams(column, colDef) {
    const params = this.gridOptionsService.addGridCommonParams({
      column,
      colDef: cloneObject(colDef),
      rowModel: this.rowModel,
      filterChangedCallback: () => {
      },
      filterModifiedCallback: () => {
      },
      valueGetter: this.createValueGetter(column),
      getValue: this.createGetValue(column),
      doesRowPassOtherFilter: () => true
    });
    return params;
  }
  createFilterWrapper(column, source) {
    var _a;
    const filterWrapper = {
      column,
      filterPromise: null,
      compiledElement: null,
      guiPromise: AgPromise.resolve(null),
      compDetails: null
    };
    const { filterPromise, compDetails } = this.createFilterInstance(column);
    filterWrapper.filterPromise = (_a = filterPromise == null ? void 0 : filterPromise()) != null ? _a : null;
    filterWrapper.compDetails = compDetails;
    if (filterPromise) {
      this.putIntoGui(filterWrapper, source);
    }
    return filterWrapper;
  }
  putIntoGui(filterWrapper, source) {
    const eFilterGui = document.createElement("div");
    eFilterGui.className = "ag-filter";
    filterWrapper.guiPromise = new AgPromise((resolve) => {
      filterWrapper.filterPromise.then((filter) => {
        let guiFromFilter = filter.getGui();
        if (!exists(guiFromFilter)) {
          console.warn(`AG Grid: getGui method from filter returned ${guiFromFilter}, it should be a DOM element or an HTML template string.`);
        }
        if (typeof guiFromFilter === "string") {
          guiFromFilter = loadTemplate(guiFromFilter);
        }
        eFilterGui.appendChild(guiFromFilter);
        resolve(eFilterGui);
        const event = {
          type: Events.EVENT_FILTER_OPENED,
          column: filterWrapper.column,
          source,
          eGui: eFilterGui
        };
        this.eventService.dispatchEvent(event);
      });
    });
  }
  onColumnsChanged() {
    const columns = [];
    this.allColumnFilters.forEach((wrapper, colId) => {
      let currentColumn;
      if (wrapper.column.isPrimary()) {
        currentColumn = this.columnModel.getPrimaryColumn(colId);
      } else {
        currentColumn = this.columnModel.getGridColumn(colId);
      }
      if (currentColumn) {
        return;
      }
      columns.push(wrapper.column);
      this.disposeFilterWrapper(wrapper, "columnChanged");
      this.disposeColumnListener(colId);
    });
    if (columns.length > 0) {
      this.onFilterChanged({ columns, source: "api" });
    } else {
      this.updateDependantFilters();
    }
  }
  updateDependantFilters() {
    const groupColumns = this.columnModel.getGroupAutoColumns();
    groupColumns == null ? void 0 : groupColumns.forEach((groupColumn) => {
      if (groupColumn.getColDef().filter === "agGroupColumnFilter") {
        this.getOrCreateFilterWrapper(groupColumn, "NO_UI");
      }
    });
  }
  // for group filters, can change dynamically whether they are allowed or not
  isFilterAllowed(column) {
    var _a, _b;
    if (this.isAdvancedFilterEnabled()) {
      return false;
    }
    const isFilterAllowed = column.isFilterAllowed();
    if (!isFilterAllowed) {
      return false;
    }
    const filterWrapper = this.allColumnFilters.get(column.getColId());
    return (_b = (_a = filterWrapper == null ? void 0 : filterWrapper.filterPromise) == null ? void 0 : _a.resolveNow(
      true,
      // defer to filter component isFilterAllowed if it exists
      (filter) => typeof (filter == null ? void 0 : filter.isFilterAllowed) === "function" ? filter == null ? void 0 : filter.isFilterAllowed() : true
    )) != null ? _b : true;
  }
  getFloatingFilterCompDetails(column, showParentFilter) {
    const parentFilterInstance = (callback) => {
      const filterComponent = this.getFilterComponent(column, "NO_UI");
      if (filterComponent == null) {
        return;
      }
      filterComponent.then((instance) => {
        callback(unwrapUserComp(instance));
      });
    };
    const colDef = column.getColDef();
    const filterParams = __spreadProps(__spreadValues({}, this.createFilterParams(column, colDef)), {
      filterChangedCallback: () => parentFilterInstance((filterInstance) => this.filterChangedCallbackFactory(filterInstance, column)())
    });
    const finalFilterParams = this.userComponentFactory.mergeParamsWithApplicationProvidedParams(colDef, FilterComponent, filterParams);
    let defaultFloatingFilterType = this.userComponentFactory.getDefaultFloatingFilterType(colDef, () => this.getDefaultFloatingFilter(column));
    if (defaultFloatingFilterType == null) {
      defaultFloatingFilterType = "agReadOnlyFloatingFilter";
    }
    const params = {
      column,
      filterParams: finalFilterParams,
      currentParentModel: () => this.getCurrentFloatingFilterParentModel(column),
      parentFilterInstance,
      showParentFilter,
      suppressFilterButton: false
      // This one might be overridden from the colDef
    };
    return this.userComponentFactory.getFloatingFilterCompDetails(colDef, params, defaultFloatingFilterType);
  }
  getCurrentFloatingFilterParentModel(column) {
    const filterComponent = this.getFilterComponent(column, "NO_UI", false);
    return filterComponent ? filterComponent.resolveNow(null, (filter) => filter && filter.getModel()) : null;
  }
  // destroys the filter, so it no longer takes part
  destroyFilter(column, source = "api") {
    const colId = column.getColId();
    const filterWrapper = this.allColumnFilters.get(colId);
    this.disposeColumnListener(colId);
    delete this.initialFilterModel[colId];
    if (filterWrapper) {
      this.disposeFilterWrapper(filterWrapper, source);
      this.onFilterChanged({
        columns: [column],
        source: "api"
      });
    }
  }
  disposeColumnListener(colId) {
    const columnListener = this.allColumnListeners.get(colId);
    if (columnListener) {
      this.allColumnListeners.delete(colId);
      columnListener();
    }
  }
  disposeFilterWrapper(filterWrapper, source) {
    filterWrapper.filterPromise.then((filter) => {
      this.getContext().destroyBean(filter);
      filterWrapper.column.setFilterActive(false, "filterDestroyed");
      this.allColumnFilters.delete(filterWrapper.column.getColId());
      const event = {
        type: Events.EVENT_FILTER_DESTROYED,
        source,
        column: filterWrapper.column
      };
      this.eventService.dispatchEvent(event);
    });
  }
  filterModifiedCallbackFactory(filter, column) {
    return () => {
      const event = {
        type: Events.EVENT_FILTER_MODIFIED,
        column,
        filterInstance: filter
      };
      this.eventService.dispatchEvent(event);
    };
  }
  filterChangedCallbackFactory(filter, column) {
    return (additionalEventAttributes) => {
      var _a;
      const source = (_a = additionalEventAttributes == null ? void 0 : additionalEventAttributes.source) != null ? _a : "api";
      const params = {
        filter,
        additionalEventAttributes,
        columns: [column],
        source
      };
      this.callOnFilterChangedOutsideRenderCycle(params);
    };
  }
  checkDestroyFilter(colId) {
    const filterWrapper = this.allColumnFilters.get(colId);
    if (!filterWrapper) {
      return;
    }
    const column = filterWrapper.column;
    const { compDetails } = column.isFilterAllowed() ? this.createFilterInstance(column) : { compDetails: null };
    if (this.areFilterCompsDifferent(filterWrapper.compDetails, compDetails)) {
      this.destroyFilter(column, "paramsUpdated");
      return;
    }
    const newFilterParams = column.getColDef().filterParams;
    if (!filterWrapper.filterPromise) {
      this.destroyFilter(column, "paramsUpdated");
      return;
    }
    filterWrapper.filterPromise.then((filter) => {
      const shouldRefreshFilter = (filter == null ? void 0 : filter.refresh) ? filter.refresh(__spreadValues(__spreadProps(__spreadValues({}, this.createFilterParams(column, column.getColDef())), {
        filterModifiedCallback: this.filterModifiedCallbackFactory(filter, column),
        filterChangedCallback: this.filterChangedCallbackFactory(filter, column),
        doesRowPassOtherFilter: (node) => this.doesRowPassOtherFilters(filter, node)
      }), newFilterParams)) : true;
      if (shouldRefreshFilter === false) {
        this.destroyFilter(column, "paramsUpdated");
      }
    });
  }
  setColumnFilterWrapper(column, filterWrapper) {
    const colId = column.getColId();
    this.allColumnFilters.set(colId, filterWrapper);
    this.allColumnListeners.set(
      colId,
      this.addManagedListener(
        column,
        Column.EVENT_COL_DEF_CHANGED,
        () => this.checkDestroyFilter(colId)
      )
    );
  }
  areFilterCompsDifferent(oldCompDetails, newCompDetails) {
    if (!newCompDetails || !oldCompDetails) {
      return true;
    }
    const { componentClass: oldComponentClass } = oldCompDetails;
    const { componentClass: newComponentClass } = newCompDetails;
    const isSameComponentClass = oldComponentClass === newComponentClass || // react hooks returns new wrappers, so check nested render method
    (oldComponentClass == null ? void 0 : oldComponentClass.render) && (newComponentClass == null ? void 0 : newComponentClass.render) && oldComponentClass.render === newComponentClass.render;
    return !isSameComponentClass;
  }
  getAdvancedFilterModel() {
    return this.isAdvancedFilterEnabled() ? this.advancedFilterService.getModel() : null;
  }
  setAdvancedFilterModel(expression) {
    if (!this.isAdvancedFilterEnabled()) {
      return;
    }
    if (this.dataTypeService.isPendingInference()) {
      this.advancedFilterModelUpdateQueue.push(expression);
      return;
    }
    this.advancedFilterService.setModel(expression != null ? expression : null);
    this.onFilterChanged({ source: "advancedFilter" });
  }
  showAdvancedFilterBuilder(source) {
    if (!this.isAdvancedFilterEnabled()) {
      return;
    }
    this.advancedFilterService.getCtrl().toggleFilterBuilder(source, true);
  }
  updateAdvancedFilterColumns() {
    if (!this.isAdvancedFilterEnabled()) {
      return;
    }
    if (this.advancedFilterService.updateValidity()) {
      this.onFilterChanged({ source: "advancedFilter" });
    }
  }
  hasFloatingFilters() {
    if (this.isAdvancedFilterEnabled()) {
      return false;
    }
    const gridColumns = this.columnModel.getAllGridColumns();
    return gridColumns.some((col) => col.getColDef().floatingFilter);
  }
  getFilterInstance(key, callback) {
    if (this.isAdvancedFilterEnabled()) {
      this.warnAdvancedFilters();
      return void 0;
    }
    const res = this.getFilterInstanceImpl(key, (instance) => {
      if (!callback) {
        return;
      }
      const unwrapped2 = unwrapUserComp(instance);
      callback(unwrapped2);
    });
    const unwrapped = unwrapUserComp(res);
    return unwrapped;
  }
  getColumnFilterInstance(key) {
    return new Promise((resolve) => {
      this.getFilterInstance(key, (filter) => {
        resolve(filter);
      });
    });
  }
  getFilterInstanceImpl(key, callback) {
    const column = this.columnModel.getPrimaryColumn(key);
    if (!column) {
      return void 0;
    }
    const filterPromise = this.getFilterComponent(column, "NO_UI");
    const currentValue = filterPromise && filterPromise.resolveNow(null, (filterComp) => filterComp);
    if (currentValue) {
      setTimeout(callback, 0, currentValue);
    } else if (filterPromise) {
      filterPromise.then((comp) => {
        callback(comp);
      });
    }
    return currentValue;
  }
  warnAdvancedFilters() {
    warnOnce("Column Filter API methods have been disabled as Advanced Filters are enabled.");
  }
  setupAdvancedFilterHeaderComp(eCompToInsertBefore) {
    var _a;
    (_a = this.advancedFilterService) == null ? void 0 : _a.getCtrl().setupHeaderComp(eCompToInsertBefore);
  }
  getHeaderRowCount() {
    return this.isAdvancedFilterHeaderActive() ? 1 : 0;
  }
  getHeaderHeight() {
    return this.isAdvancedFilterHeaderActive() ? this.advancedFilterService.getCtrl().getHeaderHeight() : 0;
  }
  processFilterModelUpdateQueue() {
    this.filterModelUpdateQueue.forEach(({ model, source }) => this.setFilterModel(model, source));
    this.filterModelUpdateQueue = [];
    this.columnFilterModelUpdateQueue.forEach(({ key, model, resolve }) => {
      this.setColumnFilterModel(key, model).then(() => resolve());
    });
    this.columnFilterModelUpdateQueue = [];
    this.advancedFilterModelUpdateQueue.forEach((model) => this.setAdvancedFilterModel(model));
    this.advancedFilterModelUpdateQueue = [];
  }
  getColumnFilterModel(key) {
    const filterWrapper = this.getFilterWrapper(key);
    return filterWrapper ? this.getModelFromFilterWrapper(filterWrapper) : null;
  }
  setColumnFilterModel(key, model) {
    if (this.isAdvancedFilterEnabled()) {
      this.warnAdvancedFilters();
      return Promise.resolve();
    }
    if (this.dataTypeService.isPendingInference()) {
      let resolve = () => {
      };
      const promise = new Promise((res) => {
        resolve = res;
      });
      this.columnFilterModelUpdateQueue.push({ key, model, resolve });
      return promise;
    }
    const column = this.columnModel.getPrimaryColumn(key);
    const filterWrapper = column ? this.getOrCreateFilterWrapper(column, "NO_UI") : null;
    const convertPromise = (promise) => {
      return new Promise((resolve) => {
        promise.then((result) => resolve(result));
      });
    };
    return filterWrapper ? convertPromise(this.setModelOnFilterWrapper(filterWrapper.filterPromise, model)) : Promise.resolve();
  }
  getFilterWrapper(key) {
    var _a;
    const column = this.columnModel.getPrimaryColumn(key);
    return column ? (_a = this.cachedFilter(column)) != null ? _a : null : null;
  }
  destroy() {
    super.destroy();
    this.allColumnFilters.forEach((filterWrapper) => this.disposeFilterWrapper(filterWrapper, "gridDestroyed"));
    this.allColumnListeners.clear();
  }
};
__decorateClass([
  Autowired("valueService")
], FilterManager.prototype, "valueService", 2);
__decorateClass([
  Autowired("columnModel")
], FilterManager.prototype, "columnModel", 2);
__decorateClass([
  Autowired("rowModel")
], FilterManager.prototype, "rowModel", 2);
__decorateClass([
  Autowired("userComponentFactory")
], FilterManager.prototype, "userComponentFactory", 2);
__decorateClass([
  Autowired("rowRenderer")
], FilterManager.prototype, "rowRenderer", 2);
__decorateClass([
  Autowired("dataTypeService")
], FilterManager.prototype, "dataTypeService", 2);
__decorateClass([
  Autowired("quickFilterService")
], FilterManager.prototype, "quickFilterService", 2);
__decorateClass([
  Optional("advancedFilterService")
], FilterManager.prototype, "advancedFilterService", 2);
__decorateClass([
  PostConstruct
], FilterManager.prototype, "init", 1);
FilterManager = __decorateClass([
  Bean("filterManager")
], FilterManager);

// community-modules/core/src/headerRendering/cells/abstractCell/abstractHeaderCellComp.ts
var AbstractHeaderCellComp = class extends Component {
  constructor(template, ctrl) {
    super(template);
    this.ctrl = ctrl;
  }
  getCtrl() {
    return this.ctrl;
  }
};

// community-modules/core/src/headerRendering/cells/floatingFilter/headerFilterCellComp.ts
var _HeaderFilterCellComp = class _HeaderFilterCellComp extends AbstractHeaderCellComp {
  constructor(ctrl) {
    super(_HeaderFilterCellComp.TEMPLATE, ctrl);
  }
  postConstruct() {
    const eGui = this.getGui();
    const compProxy = {
      addOrRemoveCssClass: (cssClassName, on) => this.addOrRemoveCssClass(cssClassName, on),
      addOrRemoveBodyCssClass: (cssClassName, on) => this.eFloatingFilterBody.classList.toggle(cssClassName, on),
      setButtonWrapperDisplayed: (displayed) => setDisplayed(this.eButtonWrapper, displayed),
      setCompDetails: (compDetails) => this.setCompDetails(compDetails),
      getFloatingFilterComp: () => this.compPromise,
      setWidth: (width) => eGui.style.width = width,
      setMenuIcon: (eIcon) => this.eButtonShowMainFilter.appendChild(eIcon)
    };
    this.ctrl.setComp(compProxy, eGui, this.eButtonShowMainFilter, this.eFloatingFilterBody);
  }
  setCompDetails(compDetails) {
    if (!compDetails) {
      this.destroyFloatingFilterComp();
      this.compPromise = null;
      return;
    }
    this.compPromise = compDetails.newAgStackInstance();
    this.compPromise.then((comp) => this.afterCompCreated(comp));
  }
  destroyFloatingFilterComp() {
    if (this.floatingFilterComp) {
      this.eFloatingFilterBody.removeChild(this.floatingFilterComp.getGui());
      this.floatingFilterComp = this.destroyBean(this.floatingFilterComp);
    }
  }
  afterCompCreated(comp) {
    if (!comp) {
      return;
    }
    if (!this.isAlive()) {
      this.destroyBean(comp);
      return;
    }
    this.destroyFloatingFilterComp();
    this.floatingFilterComp = comp;
    this.eFloatingFilterBody.appendChild(comp.getGui());
    if (comp.afterGuiAttached) {
      comp.afterGuiAttached();
    }
  }
};
_HeaderFilterCellComp.TEMPLATE = /* html */
`<div class="ag-header-cell ag-floating-filter" role="gridcell">
            <div ref="eFloatingFilterBody" role="presentation"></div>
            <div class="ag-floating-filter-button ag-hidden" ref="eButtonWrapper" role="presentation">
                <button type="button" class="ag-button ag-floating-filter-button-button" ref="eButtonShowMainFilter" tabindex="-1"></button>
            </div>
        </div>`;
__decorateClass([
  RefSelector("eFloatingFilterBody")
], _HeaderFilterCellComp.prototype, "eFloatingFilterBody", 2);
__decorateClass([
  RefSelector("eButtonWrapper")
], _HeaderFilterCellComp.prototype, "eButtonWrapper", 2);
__decorateClass([
  RefSelector("eButtonShowMainFilter")
], _HeaderFilterCellComp.prototype, "eButtonShowMainFilter", 2);
__decorateClass([
  PostConstruct
], _HeaderFilterCellComp.prototype, "postConstruct", 1);
__decorateClass([
  PreDestroy
], _HeaderFilterCellComp.prototype, "destroyFloatingFilterComp", 1);
var HeaderFilterCellComp = _HeaderFilterCellComp;

// community-modules/core/src/styling/layoutFeature.ts
var LayoutCssClasses = /* @__PURE__ */ ((LayoutCssClasses2) => {
  LayoutCssClasses2["AUTO_HEIGHT"] = "ag-layout-auto-height";
  LayoutCssClasses2["NORMAL"] = "ag-layout-normal";
  LayoutCssClasses2["PRINT"] = "ag-layout-print";
  return LayoutCssClasses2;
})(LayoutCssClasses || {});
var LayoutFeature = class extends BeanStub {
  constructor(view) {
    super();
    this.view = view;
  }
  postConstruct() {
    this.addManagedPropertyListener("domLayout", this.updateLayoutClasses.bind(this));
    this.updateLayoutClasses();
  }
  updateLayoutClasses() {
    const domLayout = this.getDomLayout();
    const params = {
      autoHeight: domLayout === "autoHeight",
      normal: domLayout === "normal",
      print: domLayout === "print"
    };
    const cssClass = params.autoHeight ? "ag-layout-auto-height" /* AUTO_HEIGHT */ : params.print ? "ag-layout-print" /* PRINT */ : "ag-layout-normal" /* NORMAL */;
    this.view.updateLayoutClasses(cssClass, params);
  }
  // returns either 'print', 'autoHeight' or 'normal' (normal is the default)
  getDomLayout() {
    var _a;
    const domLayout = (_a = this.gridOptionsService.get("domLayout")) != null ? _a : "normal";
    const validLayouts = ["normal", "print", "autoHeight"];
    if (validLayouts.indexOf(domLayout) === -1) {
      warnOnce(`${domLayout} is not valid for DOM Layout, valid values are 'normal', 'autoHeight', 'print'.`);
      return "normal";
    }
    return domLayout;
  }
};
__decorateClass([
  PostConstruct
], LayoutFeature.prototype, "postConstruct", 1);

// community-modules/core/src/gridBodyComp/gridBodyScrollFeature.ts
var GridBodyScrollFeature = class extends BeanStub {
  constructor(eBodyViewport) {
    super();
    this.lastScrollSource = [null, null];
    this.scrollLeft = -1;
    this.nextScrollTop = -1;
    this.scrollTop = -1;
    // Used to provide approximate values of scrollTop and offsetHeight
    // without forcing the browser to recalculate styles.
    this.lastOffsetHeight = -1;
    this.lastScrollTop = -1;
    this.eBodyViewport = eBodyViewport;
    this.resetLastHScrollDebounced = debounce(() => this.lastScrollSource[1 /* Horizontal */] = null, 500);
    this.resetLastVScrollDebounced = debounce(() => this.lastScrollSource[0 /* Vertical */] = null, 500);
  }
  postConstruct() {
    this.enableRtl = this.gridOptionsService.get("enableRtl");
    this.addManagedListener(this.eventService, Events.EVENT_DISPLAYED_COLUMNS_WIDTH_CHANGED, this.onDisplayedColumnsWidthChanged.bind(this));
    this.ctrlsService.whenReady((p) => {
      this.centerRowContainerCtrl = p.centerRowContainerCtrl;
      this.onDisplayedColumnsWidthChanged();
      this.addScrollListener();
    });
  }
  addScrollListener() {
    const fakeHScroll = this.ctrlsService.getFakeHScrollComp();
    const fakeVScroll = this.ctrlsService.getFakeVScrollComp();
    this.addManagedListener(this.centerRowContainerCtrl.getViewportElement(), "scroll", this.onHScroll.bind(this));
    fakeHScroll.onScrollCallback(this.onFakeHScroll.bind(this));
    const isDebounce = this.gridOptionsService.get("debounceVerticalScrollbar");
    const onVScroll = isDebounce ? debounce(this.onVScroll.bind(this), 100) : this.onVScroll.bind(this);
    const onFakeVScroll = isDebounce ? debounce(this.onFakeVScroll.bind(this), 100) : this.onFakeVScroll.bind(this);
    this.addManagedListener(this.eBodyViewport, "scroll", onVScroll);
    fakeVScroll.onScrollCallback(onFakeVScroll);
  }
  onDisplayedColumnsWidthChanged() {
    if (this.enableRtl) {
      this.horizontallyScrollHeaderCenterAndFloatingCenter();
    }
  }
  horizontallyScrollHeaderCenterAndFloatingCenter(scrollLeft) {
    const notYetInitialised = this.centerRowContainerCtrl == null;
    if (notYetInitialised) {
      return;
    }
    if (scrollLeft === void 0) {
      scrollLeft = this.centerRowContainerCtrl.getCenterViewportScrollLeft();
    }
    const offset = this.enableRtl ? scrollLeft : -scrollLeft;
    const topCenterContainer = this.ctrlsService.getTopCenterRowContainerCtrl();
    const stickyTopCenterContainer = this.ctrlsService.getStickyTopCenterRowContainerCtrl();
    const bottomCenterContainer = this.ctrlsService.getBottomCenterRowContainerCtrl();
    const fakeHScroll = this.ctrlsService.getFakeHScrollComp();
    const centerHeaderContainer = this.ctrlsService.getHeaderRowContainerCtrl();
    centerHeaderContainer.setHorizontalScroll(-offset);
    bottomCenterContainer.setContainerTranslateX(offset);
    topCenterContainer.setContainerTranslateX(offset);
    stickyTopCenterContainer.setContainerTranslateX(offset);
    const centerViewport = this.centerRowContainerCtrl.getViewportElement();
    const isCenterViewportLastHorizontal = this.lastScrollSource[1 /* Horizontal */] === 0 /* Container */;
    scrollLeft = Math.abs(scrollLeft);
    if (isCenterViewportLastHorizontal) {
      fakeHScroll.setScrollPosition(scrollLeft);
    } else {
      setScrollLeft(centerViewport, scrollLeft, this.enableRtl);
    }
  }
  isControllingScroll(source, direction) {
    if (this.lastScrollSource[direction] == null) {
      this.lastScrollSource[direction] = source;
      return true;
    }
    return this.lastScrollSource[direction] === source;
  }
  onFakeHScroll() {
    if (!this.isControllingScroll(1 /* FakeContainer */, 1 /* Horizontal */)) {
      return;
    }
    this.onHScrollCommon(1 /* FakeContainer */);
  }
  onHScroll() {
    if (!this.isControllingScroll(0 /* Container */, 1 /* Horizontal */)) {
      return;
    }
    this.onHScrollCommon(0 /* Container */);
  }
  onHScrollCommon(source) {
    const centerContainerViewport = this.centerRowContainerCtrl.getViewportElement();
    const { scrollLeft } = centerContainerViewport;
    if (this.shouldBlockScrollUpdate(1 /* Horizontal */, scrollLeft, true)) {
      return;
    }
    let newScrollLeft;
    if (source === 0 /* Container */) {
      newScrollLeft = getScrollLeft(centerContainerViewport, this.enableRtl);
    } else {
      newScrollLeft = this.ctrlsService.getFakeHScrollComp().getScrollPosition();
    }
    this.doHorizontalScroll(Math.round(newScrollLeft));
    this.resetLastHScrollDebounced();
  }
  onFakeVScroll() {
    if (!this.isControllingScroll(1 /* FakeContainer */, 0 /* Vertical */)) {
      return;
    }
    this.onVScrollCommon(1 /* FakeContainer */);
  }
  onVScroll() {
    if (!this.isControllingScroll(0 /* Container */, 0 /* Vertical */)) {
      return;
    }
    this.onVScrollCommon(0 /* Container */);
  }
  onVScrollCommon(source) {
    let scrollTop;
    if (source === 0 /* Container */) {
      scrollTop = this.eBodyViewport.scrollTop;
    } else {
      scrollTop = this.ctrlsService.getFakeVScrollComp().getScrollPosition();
    }
    if (this.shouldBlockScrollUpdate(0 /* Vertical */, scrollTop, true)) {
      return;
    }
    this.animationFrameService.setScrollTop(scrollTop);
    this.nextScrollTop = scrollTop;
    if (source === 0 /* Container */) {
      this.ctrlsService.getFakeVScrollComp().setScrollPosition(scrollTop);
    } else {
      this.eBodyViewport.scrollTop = scrollTop;
    }
    if (this.gridOptionsService.get("suppressAnimationFrame")) {
      this.scrollGridIfNeeded();
    } else {
      this.animationFrameService.schedule();
    }
    this.resetLastVScrollDebounced();
  }
  doHorizontalScroll(scrollLeft) {
    const fakeScrollLeft = this.ctrlsService.getFakeHScrollComp().getScrollPosition();
    if (this.scrollLeft === scrollLeft && scrollLeft === fakeScrollLeft) {
      return;
    }
    this.scrollLeft = scrollLeft;
    this.fireScrollEvent(1 /* Horizontal */);
    this.horizontallyScrollHeaderCenterAndFloatingCenter(scrollLeft);
    this.centerRowContainerCtrl.onHorizontalViewportChanged(true);
  }
  fireScrollEvent(direction) {
    const bodyScrollEvent = {
      type: Events.EVENT_BODY_SCROLL,
      direction: direction === 1 /* Horizontal */ ? "horizontal" : "vertical",
      left: this.scrollLeft,
      top: this.scrollTop
    };
    this.eventService.dispatchEvent(bodyScrollEvent);
    window.clearTimeout(this.scrollTimer);
    this.scrollTimer = void 0;
    this.scrollTimer = window.setTimeout(() => {
      const bodyScrollEndEvent = __spreadProps(__spreadValues({}, bodyScrollEvent), {
        type: Events.EVENT_BODY_SCROLL_END
      });
      this.eventService.dispatchEvent(bodyScrollEndEvent);
    }, 100);
  }
  shouldBlockScrollUpdate(direction, scrollTo, touchOnly = false) {
    if (touchOnly && !isIOSUserAgent()) {
      return false;
    }
    if (direction === 0 /* Vertical */) {
      return this.shouldBlockVerticalScroll(scrollTo);
    }
    return this.shouldBlockHorizontalScroll(scrollTo);
  }
  shouldBlockVerticalScroll(scrollTo) {
    const clientHeight = getInnerHeight(this.eBodyViewport);
    const { scrollHeight } = this.eBodyViewport;
    if (scrollTo < 0 || scrollTo + clientHeight > scrollHeight) {
      return true;
    }
    return false;
  }
  shouldBlockHorizontalScroll(scrollTo) {
    const clientWidth = this.centerRowContainerCtrl.getCenterWidth();
    const { scrollWidth } = this.centerRowContainerCtrl.getViewportElement();
    if (this.enableRtl && isRtlNegativeScroll()) {
      if (scrollTo > 0) {
        return true;
      }
    } else if (scrollTo < 0) {
      return true;
    }
    if (Math.abs(scrollTo) + clientWidth > scrollWidth) {
      return true;
    }
    return false;
  }
  redrawRowsAfterScroll() {
    this.fireScrollEvent(0 /* Vertical */);
  }
  // this is to cater for AG-3274, where grid is removed from the dom and then inserted back in again.
  // (which happens with some implementations of tabbing). this can result in horizontal scroll getting
  // reset back to the left, however no scroll event is fired. so we need to get header to also scroll
  // back to the left to be kept in sync.
  // adding and removing the grid from the DOM both resets the scroll position and
  // triggers a resize event, so notify listeners if the scroll position has changed
  checkScrollLeft() {
    if (this.scrollLeft !== this.centerRowContainerCtrl.getCenterViewportScrollLeft()) {
      this.onHScrollCommon(0 /* Container */);
    }
  }
  scrollGridIfNeeded() {
    const frameNeeded = this.scrollTop != this.nextScrollTop;
    if (frameNeeded) {
      this.scrollTop = this.nextScrollTop;
      this.redrawRowsAfterScroll();
    }
    return frameNeeded;
  }
  // called by scrollHorizontally method and alignedGridsService
  setHorizontalScrollPosition(hScrollPosition, fromAlignedGridsService = false) {
    const minScrollLeft = 0;
    const maxScrollLeft = this.centerRowContainerCtrl.getViewportElement().scrollWidth - this.centerRowContainerCtrl.getCenterWidth();
    if (!fromAlignedGridsService && this.shouldBlockScrollUpdate(1 /* Horizontal */, hScrollPosition)) {
      if (this.enableRtl && isRtlNegativeScroll()) {
        hScrollPosition = hScrollPosition > 0 ? 0 : maxScrollLeft;
      } else {
        hScrollPosition = Math.min(Math.max(hScrollPosition, minScrollLeft), maxScrollLeft);
      }
    }
    setScrollLeft(this.centerRowContainerCtrl.getViewportElement(), Math.abs(hScrollPosition), this.enableRtl);
    this.doHorizontalScroll(hScrollPosition);
  }
  setVerticalScrollPosition(vScrollPosition) {
    this.eBodyViewport.scrollTop = vScrollPosition;
  }
  getVScrollPosition() {
    this.lastScrollTop = this.eBodyViewport.scrollTop;
    this.lastOffsetHeight = this.eBodyViewport.offsetHeight;
    const result = {
      top: this.lastScrollTop,
      bottom: this.lastScrollTop + this.lastOffsetHeight
    };
    return result;
  }
  /** Get an approximate scroll position that returns the last real value read.
   * This is useful for avoiding repeated DOM reads that force the browser to recalculate styles.
   * This can have big performance improvements but may not be 100% accurate so only use if this is acceptable.
   */
  getApproximateVScollPosition() {
    if (this.lastScrollTop >= 0 && this.lastOffsetHeight >= 0) {
      return {
        top: this.scrollTop,
        bottom: this.scrollTop + this.lastOffsetHeight
      };
    }
    return this.getVScrollPosition();
  }
  getHScrollPosition() {
    return this.centerRowContainerCtrl.getHScrollPosition();
  }
  isHorizontalScrollShowing() {
    return this.centerRowContainerCtrl.isHorizontalScrollShowing();
  }
  // called by the headerRootComp and moveColumnController
  scrollHorizontally(pixels) {
    const oldScrollPosition = this.centerRowContainerCtrl.getViewportElement().scrollLeft;
    this.setHorizontalScrollPosition(oldScrollPosition + pixels);
    return this.centerRowContainerCtrl.getViewportElement().scrollLeft - oldScrollPosition;
  }
  // gets called by rowRenderer when new data loaded, as it will want to scroll to the top
  scrollToTop() {
    this.eBodyViewport.scrollTop = 0;
  }
  // Valid values for position are bottom, middle and top
  ensureNodeVisible(comparator, position = null) {
    const rowCount = this.rowModel.getRowCount();
    let indexToSelect = -1;
    for (let i = 0; i < rowCount; i++) {
      const node = this.rowModel.getRow(i);
      if (typeof comparator === "function") {
        const predicate = comparator;
        if (node && predicate(node)) {
          indexToSelect = i;
          break;
        }
      } else {
        if (comparator === node || comparator === node.data) {
          indexToSelect = i;
          break;
        }
      }
    }
    if (indexToSelect >= 0) {
      this.ensureIndexVisible(indexToSelect, position);
    }
  }
  // Valid values for position are bottom, middle and top
  // position should be {'top','middle','bottom', or undefined/null}.
  // if undefined/null, then the grid will to the minimal amount of scrolling,
  // eg if grid needs to scroll up, it scrolls until row is on top,
  //    if grid needs to scroll down, it scrolls until row is on bottom,
  //    if row is already in view, grid does not scroll
  ensureIndexVisible(index, position) {
    if (this.gridOptionsService.isDomLayout("print")) {
      return;
    }
    const rowCount = this.paginationProxy.getRowCount();
    if (typeof index !== "number" || index < 0 || index >= rowCount) {
      console.warn("AG Grid: Invalid row index for ensureIndexVisible: " + index);
      return;
    }
    const isPaging = this.gridOptionsService.get("pagination");
    const paginationPanelEnabled = isPaging && !this.gridOptionsService.get("suppressPaginationPanel");
    this.getFrameworkOverrides().wrapIncoming(() => {
      if (!paginationPanelEnabled) {
        this.paginationProxy.goToPageWithIndex(index);
      }
      const gridBodyCtrl = this.ctrlsService.getGridBodyCtrl();
      const stickyTopHeight = gridBodyCtrl.getStickyTopHeight();
      const rowNode = this.paginationProxy.getRow(index);
      let rowGotShiftedDuringOperation;
      do {
        const startingRowTop = rowNode.rowTop;
        const startingRowHeight = rowNode.rowHeight;
        const paginationOffset = this.paginationProxy.getPixelOffset();
        const rowTopPixel = rowNode.rowTop - paginationOffset;
        const rowBottomPixel = rowTopPixel + rowNode.rowHeight;
        const scrollPosition = this.getVScrollPosition();
        const heightOffset = this.heightScaler.getDivStretchOffset();
        const vScrollTop = scrollPosition.top + heightOffset;
        const vScrollBottom = scrollPosition.bottom + heightOffset;
        const viewportHeight = vScrollBottom - vScrollTop;
        const pxTop = this.heightScaler.getScrollPositionForPixel(rowTopPixel);
        const pxBottom = this.heightScaler.getScrollPositionForPixel(rowBottomPixel - viewportHeight);
        const pxMiddle = Math.min((pxTop + pxBottom) / 2, rowTopPixel);
        const rowAboveViewport = vScrollTop + stickyTopHeight > rowTopPixel;
        const rowBelowViewport = vScrollBottom < rowBottomPixel;
        let newScrollPosition = null;
        if (position === "top") {
          newScrollPosition = pxTop;
        } else if (position === "bottom") {
          newScrollPosition = pxBottom;
        } else if (position === "middle") {
          newScrollPosition = pxMiddle;
        } else if (rowAboveViewport) {
          newScrollPosition = pxTop - stickyTopHeight;
        } else if (rowBelowViewport) {
          newScrollPosition = pxBottom;
        }
        if (newScrollPosition !== null) {
          this.setVerticalScrollPosition(newScrollPosition);
          this.rowRenderer.redraw({ afterScroll: true });
        }
        rowGotShiftedDuringOperation = startingRowTop !== rowNode.rowTop || startingRowHeight !== rowNode.rowHeight;
      } while (rowGotShiftedDuringOperation);
      this.animationFrameService.flushAllFrames();
    });
  }
  ensureColumnVisible(key, position = "auto") {
    const column = this.columnModel.getGridColumn(key);
    if (!column) {
      return;
    }
    if (column.isPinned()) {
      return;
    }
    if (!this.columnModel.isColumnDisplayed(column)) {
      return;
    }
    const newHorizontalScroll = this.getPositionedHorizontalScroll(column, position);
    this.getFrameworkOverrides().wrapIncoming(() => {
      if (newHorizontalScroll !== null) {
        this.centerRowContainerCtrl.setCenterViewportScrollLeft(newHorizontalScroll);
      }
      this.centerRowContainerCtrl.onHorizontalViewportChanged();
      this.animationFrameService.flushAllFrames();
    });
  }
  setScrollPosition(top, left) {
    this.getFrameworkOverrides().wrapIncoming(() => {
      this.centerRowContainerCtrl.setCenterViewportScrollLeft(left);
      this.setVerticalScrollPosition(top);
      this.rowRenderer.redraw({ afterScroll: true });
      this.animationFrameService.flushAllFrames();
    });
  }
  getPositionedHorizontalScroll(column, position) {
    const { columnBeforeStart, columnAfterEnd } = this.isColumnOutsideViewport(column);
    const viewportTooSmallForColumn = this.centerRowContainerCtrl.getCenterWidth() < column.getActualWidth();
    const viewportWidth = this.centerRowContainerCtrl.getCenterWidth();
    const isRtl = this.enableRtl;
    let alignColToStart = (isRtl ? columnBeforeStart : columnAfterEnd) || viewportTooSmallForColumn;
    let alignColToEnd = isRtl ? columnAfterEnd : columnBeforeStart;
    if (position !== "auto") {
      alignColToStart = position === "start";
      alignColToEnd = position === "end";
    }
    const isMiddle = position === "middle";
    if (alignColToStart || alignColToEnd || isMiddle) {
      const { colLeft, colMiddle, colRight } = this.getColumnBounds(column);
      if (isMiddle) {
        return colMiddle - viewportWidth / 2;
      }
      if (alignColToStart) {
        return isRtl ? colRight : colLeft;
      }
      return isRtl ? colLeft - viewportWidth : colRight - viewportWidth;
    }
    return null;
  }
  isColumnOutsideViewport(column) {
    const { start: viewportStart, end: viewportEnd } = this.getViewportBounds();
    const { colLeft, colRight } = this.getColumnBounds(column);
    const isRtl = this.enableRtl;
    const columnBeforeStart = isRtl ? viewportStart > colRight : viewportEnd < colRight;
    const columnAfterEnd = isRtl ? viewportEnd < colLeft : viewportStart > colLeft;
    return { columnBeforeStart, columnAfterEnd };
  }
  getColumnBounds(column) {
    const isRtl = this.enableRtl;
    const bodyWidth = this.columnModel.getBodyContainerWidth();
    const colWidth = column.getActualWidth();
    const colLeft = column.getLeft();
    const multiplier = isRtl ? -1 : 1;
    const colLeftPixel = isRtl ? bodyWidth - colLeft : colLeft;
    const colRightPixel = colLeftPixel + colWidth * multiplier;
    const colMidPixel = colLeftPixel + colWidth / 2 * multiplier;
    return { colLeft: colLeftPixel, colMiddle: colMidPixel, colRight: colRightPixel };
  }
  getViewportBounds() {
    const viewportWidth = this.centerRowContainerCtrl.getCenterWidth();
    const scrollPosition = this.centerRowContainerCtrl.getCenterViewportScrollLeft();
    const viewportStartPixel = scrollPosition;
    const viewportEndPixel = viewportWidth + scrollPosition;
    return { start: viewportStartPixel, end: viewportEndPixel, width: viewportWidth };
  }
};
__decorateClass([
  Autowired("ctrlsService")
], GridBodyScrollFeature.prototype, "ctrlsService", 2);
__decorateClass([
  Autowired("animationFrameService")
], GridBodyScrollFeature.prototype, "animationFrameService", 2);
__decorateClass([
  Autowired("paginationProxy")
], GridBodyScrollFeature.prototype, "paginationProxy", 2);
__decorateClass([
  Autowired("rowModel")
], GridBodyScrollFeature.prototype, "rowModel", 2);
__decorateClass([
  Autowired("rowContainerHeightService")
], GridBodyScrollFeature.prototype, "heightScaler", 2);
__decorateClass([
  Autowired("rowRenderer")
], GridBodyScrollFeature.prototype, "rowRenderer", 2);
__decorateClass([
  Autowired("columnModel")
], GridBodyScrollFeature.prototype, "columnModel", 2);
__decorateClass([
  PostConstruct
], GridBodyScrollFeature.prototype, "postConstruct", 1);

// community-modules/core/src/gridBodyComp/gridBodyCtrl.ts
var RowAnimationCssClasses = /* @__PURE__ */ ((RowAnimationCssClasses2) => {
  RowAnimationCssClasses2["ANIMATION_ON"] = "ag-row-animation";
  RowAnimationCssClasses2["ANIMATION_OFF"] = "ag-row-no-animation";
  return RowAnimationCssClasses2;
})(RowAnimationCssClasses || {});
var CSS_CLASS_FORCE_VERTICAL_SCROLL = "ag-force-vertical-scroll";
var CSS_CLASS_CELL_SELECTABLE = "ag-selectable";
var CSS_CLASS_COLUMN_MOVING = "ag-column-moving";
var GridBodyCtrl = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.stickyTopHeight = 0;
  }
  getScrollFeature() {
    return this.bodyScrollFeature;
  }
  getBodyViewportElement() {
    return this.eBodyViewport;
  }
  setComp(comp, eGridBody, eBodyViewport, eTop, eBottom, eStickyTop) {
    this.comp = comp;
    this.eGridBody = eGridBody;
    this.eBodyViewport = eBodyViewport;
    this.eTop = eTop;
    this.eBottom = eBottom;
    this.eStickyTop = eStickyTop;
    this.setCellTextSelection(this.gridOptionsService.get("enableCellTextSelection"));
    this.addManagedPropertyListener("enableCellTextSelection", (props) => this.setCellTextSelection(props.currentValue));
    this.createManagedBean(new LayoutFeature(this.comp));
    this.bodyScrollFeature = this.createManagedBean(new GridBodyScrollFeature(this.eBodyViewport));
    this.addRowDragListener();
    this.setupRowAnimationCssClass();
    this.addEventListeners();
    this.addFocusListeners([eTop, eBodyViewport, eBottom, eStickyTop]);
    this.onGridColumnsChanged();
    this.addBodyViewportListener();
    this.setFloatingHeights();
    this.disableBrowserDragging();
    this.addStopEditingWhenGridLosesFocus();
    this.filterManager.setupAdvancedFilterHeaderComp(eTop);
    this.ctrlsService.registerGridBodyCtrl(this);
  }
  getComp() {
    return this.comp;
  }
  addEventListeners() {
    this.addManagedListener(this.eventService, Events.EVENT_GRID_COLUMNS_CHANGED, this.onGridColumnsChanged.bind(this));
    this.addManagedListener(this.eventService, Events.EVENT_SCROLL_VISIBILITY_CHANGED, this.onScrollVisibilityChanged.bind(this));
    this.addManagedListener(this.eventService, Events.EVENT_PINNED_ROW_DATA_CHANGED, this.onPinnedRowDataChanged.bind(this));
    this.addManagedListener(this.eventService, Events.EVENT_HEADER_HEIGHT_CHANGED, this.onHeaderHeightChanged.bind(this));
  }
  addFocusListeners(elements) {
    elements.forEach((element) => {
      this.addManagedListener(element, "focusin", (e) => {
        const { target } = e;
        const isFocusedElementNested = isElementChildOfClass(target, "ag-root", element);
        element.classList.toggle("ag-has-focus", !isFocusedElementNested);
      });
      this.addManagedListener(element, "focusout", (e) => {
        const { target, relatedTarget } = e;
        const gridContainRelatedTarget = element.contains(relatedTarget);
        const isNestedRelatedTarget = isElementChildOfClass(relatedTarget, "ag-root", element);
        const isNestedTarget = isElementChildOfClass(target, "ag-root", element);
        if (isNestedTarget) {
          return;
        }
        if (!gridContainRelatedTarget || isNestedRelatedTarget) {
          element.classList.remove("ag-has-focus");
        }
      });
    });
  }
  // used by ColumnAnimationService
  setColumnMovingCss(moving) {
    this.comp.setColumnMovingCss(CSS_CLASS_COLUMN_MOVING, moving);
  }
  setCellTextSelection(selectable = false) {
    this.comp.setCellSelectableCss(CSS_CLASS_CELL_SELECTABLE, selectable);
  }
  onScrollVisibilityChanged() {
    const visible = this.scrollVisibleService.isVerticalScrollShowing();
    this.setVerticalScrollPaddingVisible(visible);
    this.setStickyTopWidth(visible);
    const scrollbarWidth = visible ? this.gridOptionsService.getScrollbarWidth() || 0 : 0;
    const pad = isInvisibleScrollbar() ? 16 : 0;
    const width = `calc(100% + ${scrollbarWidth + pad}px)`;
    this.animationFrameService.requestAnimationFrame(() => this.comp.setBodyViewportWidth(width));
  }
  onGridColumnsChanged() {
    const columns = this.columnModel.getAllGridColumns();
    this.comp.setColumnCount(columns.length);
  }
  // if we do not do this, then the user can select a pic in the grid (eg an image in a custom cell renderer)
  // and then that will start the browser native drag n' drop, which messes up with our own drag and drop.
  disableBrowserDragging() {
    this.addManagedListener(this.eGridBody, "dragstart", (event) => {
      if (event.target instanceof HTMLImageElement) {
        event.preventDefault();
        return false;
      }
    });
  }
  addStopEditingWhenGridLosesFocus() {
    if (!this.gridOptionsService.get("stopEditingWhenCellsLoseFocus")) {
      return;
    }
    const focusOutListener = (event) => {
      const elementWithFocus = event.relatedTarget;
      if (getTabIndex(elementWithFocus) === null) {
        this.rowRenderer.stopEditing();
        return;
      }
      let clickInsideGrid = (
        // see if click came from inside the viewports
        viewports.some((viewport) => viewport.contains(elementWithFocus)) && this.mouseEventService.isElementInThisGrid(elementWithFocus)
      );
      if (!clickInsideGrid) {
        const popupService = this.popupService;
        clickInsideGrid = popupService.getActivePopups().some((popup) => popup.contains(elementWithFocus)) || popupService.isElementWithinCustomPopup(elementWithFocus);
      }
      if (!clickInsideGrid) {
        this.rowRenderer.stopEditing();
      }
    };
    const viewports = [this.eBodyViewport, this.eBottom, this.eTop, this.eStickyTop];
    viewports.forEach((viewport) => this.addManagedListener(viewport, "focusout", focusOutListener));
  }
  updateRowCount() {
    const headerCount = this.headerNavigationService.getHeaderRowCount() + this.filterManager.getHeaderRowCount();
    const rowCount = this.rowModel.isLastRowIndexKnown() ? this.rowModel.getRowCount() : -1;
    const total = rowCount === -1 ? -1 : headerCount + rowCount;
    this.comp.setRowCount(total);
  }
  registerBodyViewportResizeListener(listener) {
    this.comp.registerBodyViewportResizeListener(listener);
  }
  setVerticalScrollPaddingVisible(visible) {
    const overflowY = visible ? "scroll" : "hidden";
    this.comp.setPinnedTopBottomOverflowY(overflowY);
  }
  isVerticalScrollShowing() {
    const show = this.gridOptionsService.get("alwaysShowVerticalScroll");
    const cssClass = show ? CSS_CLASS_FORCE_VERTICAL_SCROLL : null;
    const allowVerticalScroll = this.gridOptionsService.isDomLayout("normal");
    this.comp.setAlwaysVerticalScrollClass(cssClass, show);
    return show || allowVerticalScroll && isVerticalScrollShowing(this.eBodyViewport);
  }
  setupRowAnimationCssClass() {
    const listener = () => {
      const animateRows = this.gridOptionsService.isAnimateRows() && !this.rowContainerHeightService.isStretching();
      const animateRowsCssClass = animateRows ? "ag-row-animation" /* ANIMATION_ON */ : "ag-row-no-animation" /* ANIMATION_OFF */;
      this.comp.setRowAnimationCssOnBodyViewport(animateRowsCssClass, animateRows);
    };
    listener();
    this.addManagedListener(this.eventService, Events.EVENT_HEIGHT_SCALE_CHANGED, listener);
    this.addManagedPropertyListener("animateRows", listener);
  }
  getGridBodyElement() {
    return this.eGridBody;
  }
  addBodyViewportListener() {
    const listener = this.onBodyViewportContextMenu.bind(this);
    this.addManagedListener(this.eBodyViewport, "contextmenu", listener);
    this.mockContextMenuForIPad(listener);
    this.addManagedListener(this.eBodyViewport, "wheel", this.onBodyViewportWheel.bind(this));
    this.addManagedListener(this.eStickyTop, "wheel", this.onStickyTopWheel.bind(this));
    this.addFullWidthContainerWheelListener();
  }
  addFullWidthContainerWheelListener() {
    const fullWidthContainer = this.eBodyViewport.querySelector(".ag-full-width-container");
    const eCenterColsViewport = this.eBodyViewport.querySelector(".ag-center-cols-viewport");
    if (fullWidthContainer && eCenterColsViewport) {
      this.addManagedListener(fullWidthContainer, "wheel", (e) => this.onFullWidthContainerWheel(e, eCenterColsViewport));
    }
  }
  onFullWidthContainerWheel(e, eCenterColsViewport) {
    if (!e.deltaX || Math.abs(e.deltaY) > Math.abs(e.deltaX) || !this.mouseEventService.isEventFromThisGrid(e)) {
      return;
    }
    e.preventDefault();
    eCenterColsViewport.scrollBy({ left: e.deltaX });
  }
  onBodyViewportContextMenu(mouseEvent, touch, touchEvent) {
    if (!mouseEvent && !touchEvent) {
      return;
    }
    if (this.gridOptionsService.get("preventDefaultOnContextMenu")) {
      const event = mouseEvent || touchEvent;
      event.preventDefault();
    }
    const { target } = mouseEvent || touch;
    if (target === this.eBodyViewport || target === this.ctrlsService.getCenterRowContainerCtrl().getViewportElement()) {
      this.menuService.showContextMenu({ mouseEvent, touchEvent, value: null, anchorToElement: this.eGridBody });
    }
  }
  mockContextMenuForIPad(listener) {
    if (!isIOSUserAgent()) {
      return;
    }
    const touchListener = new TouchListener(this.eBodyViewport);
    const longTapListener = (event) => {
      listener(void 0, event.touchStart, event.touchEvent);
    };
    this.addManagedListener(touchListener, TouchListener.EVENT_LONG_TAP, longTapListener);
    this.addDestroyFunc(() => touchListener.destroy());
  }
  onBodyViewportWheel(e) {
    if (!this.gridOptionsService.get("suppressScrollWhenPopupsAreOpen")) {
      return;
    }
    if (this.popupService.hasAnchoredPopup()) {
      e.preventDefault();
    }
  }
  onStickyTopWheel(e) {
    e.preventDefault();
    if (e.offsetY) {
      this.scrollVertically(e.deltaY);
    }
  }
  getGui() {
    return this.eGridBody;
  }
  // called by rowDragFeature
  scrollVertically(pixels) {
    const oldScrollPosition = this.eBodyViewport.scrollTop;
    this.bodyScrollFeature.setVerticalScrollPosition(oldScrollPosition + pixels);
    return this.eBodyViewport.scrollTop - oldScrollPosition;
  }
  addRowDragListener() {
    this.rowDragFeature = this.createManagedBean(new RowDragFeature(this.eBodyViewport));
    this.dragAndDropService.addDropTarget(this.rowDragFeature);
  }
  getRowDragFeature() {
    return this.rowDragFeature;
  }
  onPinnedRowDataChanged() {
    this.setFloatingHeights();
  }
  setFloatingHeights() {
    const { pinnedRowModel } = this;
    let floatingTopHeight = pinnedRowModel.getPinnedTopTotalHeight();
    let floatingBottomHeight = pinnedRowModel.getPinnedBottomTotalHeight();
    this.comp.setTopHeight(floatingTopHeight);
    this.comp.setBottomHeight(floatingBottomHeight);
    this.comp.setTopDisplay(floatingTopHeight ? "inherit" : "none");
    this.comp.setBottomDisplay(floatingBottomHeight ? "inherit" : "none");
    this.setStickyTopOffsetTop();
  }
  setStickyTopHeight(height = 0) {
    this.comp.setStickyTopHeight(`${height}px`);
    this.stickyTopHeight = height;
  }
  getStickyTopHeight() {
    return this.stickyTopHeight;
  }
  setStickyTopWidth(vScrollVisible) {
    if (!vScrollVisible) {
      this.comp.setStickyTopWidth("100%");
    } else {
      const scrollbarWidth = this.gridOptionsService.getScrollbarWidth();
      this.comp.setStickyTopWidth(`calc(100% - ${scrollbarWidth}px)`);
    }
  }
  onHeaderHeightChanged() {
    this.setStickyTopOffsetTop();
  }
  setStickyTopOffsetTop() {
    const headerCtrl = this.ctrlsService.getGridHeaderCtrl();
    const headerHeight = headerCtrl.getHeaderHeight() + this.filterManager.getHeaderHeight();
    const pinnedTopHeight = this.pinnedRowModel.getPinnedTopTotalHeight();
    let height = 0;
    if (headerHeight > 0) {
      height += headerHeight + 1;
    }
    if (pinnedTopHeight > 0) {
      height += pinnedTopHeight + 1;
    }
    this.comp.setStickyTopTop(`${height}px`);
  }
  // method will call itself if no available width. this covers if the grid
  // isn't visible, but is just about to be visible.
  sizeColumnsToFit(params, nextTimeout) {
    const removeScrollWidth = this.isVerticalScrollShowing();
    const scrollWidthToRemove = removeScrollWidth ? this.gridOptionsService.getScrollbarWidth() : 0;
    const bodyViewportWidth = getInnerWidth(this.eGridBody);
    const availableWidth = bodyViewportWidth - scrollWidthToRemove;
    if (availableWidth > 0) {
      this.columnModel.sizeColumnsToFit(availableWidth, "sizeColumnsToFit", false, params);
      return;
    }
    if (nextTimeout === void 0) {
      window.setTimeout(() => {
        this.sizeColumnsToFit(params, 100);
      }, 0);
    } else if (nextTimeout === 100) {
      window.setTimeout(() => {
        this.sizeColumnsToFit(params, 500);
      }, 100);
    } else if (nextTimeout === 500) {
      window.setTimeout(() => {
        this.sizeColumnsToFit(params, -1);
      }, 500);
    } else {
      console.warn("AG Grid: tried to call sizeColumnsToFit() but the grid is coming back with zero width, maybe the grid is not visible yet on the screen?");
    }
  }
  // + rangeService
  addScrollEventListener(listener) {
    this.eBodyViewport.addEventListener("scroll", listener, { passive: true });
  }
  // + focusService
  removeScrollEventListener(listener) {
    this.eBodyViewport.removeEventListener("scroll", listener);
  }
};
__decorateClass([
  Autowired("animationFrameService")
], GridBodyCtrl.prototype, "animationFrameService", 2);
__decorateClass([
  Autowired("rowContainerHeightService")
], GridBodyCtrl.prototype, "rowContainerHeightService", 2);
__decorateClass([
  Autowired("ctrlsService")
], GridBodyCtrl.prototype, "ctrlsService", 2);
__decorateClass([
  Autowired("columnModel")
], GridBodyCtrl.prototype, "columnModel", 2);
__decorateClass([
  Autowired("scrollVisibleService")
], GridBodyCtrl.prototype, "scrollVisibleService", 2);
__decorateClass([
  Autowired("menuService")
], GridBodyCtrl.prototype, "menuService", 2);
__decorateClass([
  Autowired("headerNavigationService")
], GridBodyCtrl.prototype, "headerNavigationService", 2);
__decorateClass([
  Autowired("dragAndDropService")
], GridBodyCtrl.prototype, "dragAndDropService", 2);
__decorateClass([
  Autowired("pinnedRowModel")
], GridBodyCtrl.prototype, "pinnedRowModel", 2);
__decorateClass([
  Autowired("rowRenderer")
], GridBodyCtrl.prototype, "rowRenderer", 2);
__decorateClass([
  Autowired("popupService")
], GridBodyCtrl.prototype, "popupService", 2);
__decorateClass([
  Autowired("mouseEventService")
], GridBodyCtrl.prototype, "mouseEventService", 2);
__decorateClass([
  Autowired("rowModel")
], GridBodyCtrl.prototype, "rowModel", 2);
__decorateClass([
  Autowired("filterManager")
], GridBodyCtrl.prototype, "filterManager", 2);

// community-modules/core/src/interfaces/IRangeService.ts
var SelectionHandleType = /* @__PURE__ */ ((SelectionHandleType2) => {
  SelectionHandleType2[SelectionHandleType2["FILL"] = 0] = "FILL";
  SelectionHandleType2[SelectionHandleType2["RANGE"] = 1] = "RANGE";
  return SelectionHandleType2;
})(SelectionHandleType || {});
var CellRangeType = /* @__PURE__ */ ((CellRangeType2) => {
  CellRangeType2[CellRangeType2["VALUE"] = 0] = "VALUE";
  CellRangeType2[CellRangeType2["DIMENSION"] = 1] = "DIMENSION";
  return CellRangeType2;
})(CellRangeType || {});

// community-modules/core/src/rendering/cell/cellRangeFeature.ts
var CSS_CELL_RANGE_SELECTED = "ag-cell-range-selected";
var CSS_CELL_RANGE_CHART = "ag-cell-range-chart";
var CSS_CELL_RANGE_SINGLE_CELL = "ag-cell-range-single-cell";
var CSS_CELL_RANGE_CHART_CATEGORY = "ag-cell-range-chart-category";
var CSS_CELL_RANGE_HANDLE = "ag-cell-range-handle";
var CSS_CELL_RANGE_TOP = "ag-cell-range-top";
var CSS_CELL_RANGE_RIGHT = "ag-cell-range-right";
var CSS_CELL_RANGE_BOTTOM = "ag-cell-range-bottom";
var CSS_CELL_RANGE_LEFT = "ag-cell-range-left";
var CellRangeFeature = class {
  constructor(beans, ctrl) {
    this.beans = beans;
    this.cellCtrl = ctrl;
  }
  setComp(cellComp, eGui) {
    this.cellComp = cellComp;
    this.eGui = eGui;
    this.onRangeSelectionChanged();
  }
  onRangeSelectionChanged() {
    if (!this.cellComp) {
      return;
    }
    this.rangeCount = this.beans.rangeService.getCellRangeCount(this.cellCtrl.getCellPosition());
    this.hasChartRange = this.getHasChartRange();
    this.cellComp.addOrRemoveCssClass(CSS_CELL_RANGE_SELECTED, this.rangeCount !== 0);
    this.cellComp.addOrRemoveCssClass(`${CSS_CELL_RANGE_SELECTED}-1`, this.rangeCount === 1);
    this.cellComp.addOrRemoveCssClass(`${CSS_CELL_RANGE_SELECTED}-2`, this.rangeCount === 2);
    this.cellComp.addOrRemoveCssClass(`${CSS_CELL_RANGE_SELECTED}-3`, this.rangeCount === 3);
    this.cellComp.addOrRemoveCssClass(`${CSS_CELL_RANGE_SELECTED}-4`, this.rangeCount >= 4);
    this.cellComp.addOrRemoveCssClass(CSS_CELL_RANGE_CHART, this.hasChartRange);
    setAriaSelected(this.eGui, this.rangeCount > 0 ? true : void 0);
    this.cellComp.addOrRemoveCssClass(CSS_CELL_RANGE_SINGLE_CELL, this.isSingleCell());
    this.updateRangeBorders();
    this.refreshHandle();
  }
  updateRangeBorders() {
    const rangeBorders = this.getRangeBorders();
    const isSingleCell = this.isSingleCell();
    const isTop = !isSingleCell && rangeBorders.top;
    const isRight = !isSingleCell && rangeBorders.right;
    const isBottom = !isSingleCell && rangeBorders.bottom;
    const isLeft = !isSingleCell && rangeBorders.left;
    this.cellComp.addOrRemoveCssClass(CSS_CELL_RANGE_TOP, isTop);
    this.cellComp.addOrRemoveCssClass(CSS_CELL_RANGE_RIGHT, isRight);
    this.cellComp.addOrRemoveCssClass(CSS_CELL_RANGE_BOTTOM, isBottom);
    this.cellComp.addOrRemoveCssClass(CSS_CELL_RANGE_LEFT, isLeft);
  }
  isSingleCell() {
    const { rangeService } = this.beans;
    return this.rangeCount === 1 && rangeService && !rangeService.isMoreThanOneCell();
  }
  getHasChartRange() {
    const { rangeService } = this.beans;
    if (!this.rangeCount || !rangeService) {
      return false;
    }
    const cellRanges = rangeService.getCellRanges();
    return cellRanges.length > 0 && cellRanges.every((range) => includes([1 /* DIMENSION */, 0 /* VALUE */], range.type));
  }
  updateRangeBordersIfRangeCount() {
    if (this.rangeCount > 0) {
      this.updateRangeBorders();
      this.refreshHandle();
    }
  }
  getRangeBorders() {
    const isRtl = this.beans.gridOptionsService.get("enableRtl");
    let top = false;
    let right = false;
    let bottom = false;
    let left = false;
    const thisCol = this.cellCtrl.getCellPosition().column;
    const { rangeService, columnModel } = this.beans;
    let leftCol;
    let rightCol;
    if (isRtl) {
      leftCol = columnModel.getDisplayedColAfter(thisCol);
      rightCol = columnModel.getDisplayedColBefore(thisCol);
    } else {
      leftCol = columnModel.getDisplayedColBefore(thisCol);
      rightCol = columnModel.getDisplayedColAfter(thisCol);
    }
    const ranges = rangeService.getCellRanges().filter(
      (range) => rangeService.isCellInSpecificRange(this.cellCtrl.getCellPosition(), range)
    );
    if (!leftCol) {
      left = true;
    }
    if (!rightCol) {
      right = true;
    }
    for (let i = 0; i < ranges.length; i++) {
      if (top && right && bottom && left) {
        break;
      }
      const range = ranges[i];
      const startRow = rangeService.getRangeStartRow(range);
      const endRow = rangeService.getRangeEndRow(range);
      if (!top && this.beans.rowPositionUtils.sameRow(startRow, this.cellCtrl.getCellPosition())) {
        top = true;
      }
      if (!bottom && this.beans.rowPositionUtils.sameRow(endRow, this.cellCtrl.getCellPosition())) {
        bottom = true;
      }
      if (!left && leftCol && range.columns.indexOf(leftCol) < 0) {
        left = true;
      }
      if (!right && rightCol && range.columns.indexOf(rightCol) < 0) {
        right = true;
      }
    }
    return { top, right, bottom, left };
  }
  refreshHandle() {
    if (!this.beans.rangeService || this.beans.context.isDestroyed()) {
      return;
    }
    const shouldHaveSelectionHandle = this.shouldHaveSelectionHandle();
    if (this.selectionHandle && !shouldHaveSelectionHandle) {
      this.selectionHandle = this.beans.context.destroyBean(this.selectionHandle);
    }
    if (shouldHaveSelectionHandle) {
      this.addSelectionHandle();
    }
    this.cellComp.addOrRemoveCssClass(CSS_CELL_RANGE_HANDLE, !!this.selectionHandle);
  }
  shouldHaveSelectionHandle() {
    const { gridOptionsService, rangeService } = this.beans;
    const cellRanges = rangeService.getCellRanges();
    const rangesLen = cellRanges.length;
    if (this.rangeCount < 1 || rangesLen < 1) {
      return false;
    }
    const cellRange = last(cellRanges);
    const cellPosition = this.cellCtrl.getCellPosition();
    const isFillHandleAvailable = gridOptionsService.get("enableFillHandle") && !this.cellCtrl.isSuppressFillHandle();
    const isRangeHandleAvailable = gridOptionsService.get("enableRangeHandle");
    let handleIsAvailable = rangesLen === 1 && !this.cellCtrl.isEditing() && (isFillHandleAvailable || isRangeHandleAvailable);
    if (this.hasChartRange) {
      const hasCategoryRange = cellRanges[0].type === 1 /* DIMENSION */;
      const isCategoryCell = hasCategoryRange && rangeService.isCellInSpecificRange(cellPosition, cellRanges[0]);
      this.cellComp.addOrRemoveCssClass(CSS_CELL_RANGE_CHART_CATEGORY, isCategoryCell);
      handleIsAvailable = cellRange.type === 0 /* VALUE */;
    }
    return handleIsAvailable && cellRange.endRow != null && rangeService.isContiguousRange(cellRange) && rangeService.isBottomRightCell(cellRange, cellPosition);
  }
  addSelectionHandle() {
    const { gridOptionsService, rangeService } = this.beans;
    const cellRangeType = last(rangeService.getCellRanges()).type;
    const selectionHandleFill = gridOptionsService.get("enableFillHandle") && missing(cellRangeType);
    const type = selectionHandleFill ? 0 /* FILL */ : 1 /* RANGE */;
    if (this.selectionHandle && this.selectionHandle.getType() !== type) {
      this.selectionHandle = this.beans.context.destroyBean(this.selectionHandle);
    }
    if (!this.selectionHandle) {
      this.selectionHandle = this.beans.selectionHandleFactory.createSelectionHandle(type);
    }
    this.selectionHandle.refresh(this.cellCtrl);
  }
  destroy() {
    this.beans.context.destroyBean(this.selectionHandle);
  }
};

// community-modules/core/src/rendering/cell/cellPositionFeature.ts
var CellPositionFeature = class extends BeanStub {
  constructor(ctrl, beans) {
    super();
    this.cellCtrl = ctrl;
    this.beans = beans;
    this.column = ctrl.getColumn();
    this.rowNode = ctrl.getRowNode();
  }
  setupRowSpan() {
    this.rowSpan = this.column.getRowSpan(this.rowNode);
    this.addManagedListener(this.beans.eventService, Events.EVENT_NEW_COLUMNS_LOADED, () => this.onNewColumnsLoaded());
  }
  setComp(eGui) {
    this.eGui = eGui;
    this.setupColSpan();
    this.setupRowSpan();
    this.onLeftChanged();
    this.onWidthChanged();
    this.applyRowSpan();
  }
  onNewColumnsLoaded() {
    const rowSpan = this.column.getRowSpan(this.rowNode);
    if (this.rowSpan === rowSpan) {
      return;
    }
    this.rowSpan = rowSpan;
    this.applyRowSpan(true);
  }
  onDisplayColumnsChanged() {
    const colsSpanning = this.getColSpanningList();
    if (!areEqual(this.colsSpanning, colsSpanning)) {
      this.colsSpanning = colsSpanning;
      this.onWidthChanged();
      this.onLeftChanged();
    }
  }
  setupColSpan() {
    if (this.column.getColDef().colSpan == null) {
      return;
    }
    this.colsSpanning = this.getColSpanningList();
    this.addManagedListener(this.beans.eventService, Events.EVENT_DISPLAYED_COLUMNS_CHANGED, this.onDisplayColumnsChanged.bind(this));
    this.addManagedListener(this.beans.eventService, Events.EVENT_DISPLAYED_COLUMNS_WIDTH_CHANGED, this.onWidthChanged.bind(this));
  }
  onWidthChanged() {
    if (!this.eGui) {
      return;
    }
    const width = this.getCellWidth();
    this.eGui.style.width = `${width}px`;
  }
  getCellWidth() {
    if (!this.colsSpanning) {
      return this.column.getActualWidth();
    }
    return this.colsSpanning.reduce((width, col) => width + col.getActualWidth(), 0);
  }
  getColSpanningList() {
    const colSpan = this.column.getColSpan(this.rowNode);
    const colsSpanning = [];
    if (colSpan === 1) {
      colsSpanning.push(this.column);
    } else {
      let pointer = this.column;
      const pinned = this.column.getPinned();
      for (let i = 0; pointer && i < colSpan; i++) {
        colsSpanning.push(pointer);
        pointer = this.beans.columnModel.getDisplayedColAfter(pointer);
        if (!pointer || missing(pointer)) {
          break;
        }
        if (pinned !== pointer.getPinned()) {
          break;
        }
      }
    }
    return colsSpanning;
  }
  onLeftChanged() {
    if (!this.eGui) {
      return;
    }
    const left = this.modifyLeftForPrintLayout(this.getCellLeft());
    this.eGui.style.left = left + "px";
  }
  getCellLeft() {
    let mostLeftCol;
    if (this.beans.gridOptionsService.get("enableRtl") && this.colsSpanning) {
      mostLeftCol = last(this.colsSpanning);
    } else {
      mostLeftCol = this.column;
    }
    return mostLeftCol.getLeft();
  }
  modifyLeftForPrintLayout(leftPosition) {
    if (!this.cellCtrl.isPrintLayout() || this.column.getPinned() === "left") {
      return leftPosition;
    }
    const leftWidth = this.beans.columnModel.getDisplayedColumnsLeftWidth();
    if (this.column.getPinned() === "right") {
      const bodyWidth = this.beans.columnModel.getBodyContainerWidth();
      return leftWidth + bodyWidth + (leftPosition || 0);
    }
    return leftWidth + (leftPosition || 0);
  }
  applyRowSpan(force) {
    if (this.rowSpan === 1 && !force) {
      return;
    }
    const singleRowHeight = this.beans.gridOptionsService.getRowHeightAsNumber();
    const totalRowHeight = singleRowHeight * this.rowSpan;
    this.eGui.style.height = `${totalRowHeight}px`;
    this.eGui.style.zIndex = "1";
  }
  // overriding to make public, as we don't dispose this bean via context
  destroy() {
    super.destroy();
  }
};

// community-modules/core/src/rendering/cell/cellCustomStyleFeature.ts
var CellCustomStyleFeature = class extends BeanStub {
  constructor(ctrl, beans) {
    super();
    this.staticClasses = [];
    this.cellCtrl = ctrl;
    this.beans = beans;
    this.column = ctrl.getColumn();
    this.rowNode = ctrl.getRowNode();
  }
  setComp(comp) {
    this.cellComp = comp;
    this.applyUserStyles();
    this.applyCellClassRules();
    this.applyClassesFromColDef();
  }
  applyCellClassRules() {
    const colDef = this.column.getColDef();
    const { cellClassRules } = colDef;
    const cellClassParams = this.beans.gridOptionsService.addGridCommonParams({
      value: this.cellCtrl.getValue(),
      data: this.rowNode.data,
      node: this.rowNode,
      colDef,
      column: this.column,
      rowIndex: this.rowNode.rowIndex
    });
    this.beans.stylingService.processClassRules(
      // if current was previous, skip
      cellClassRules === this.cellClassRules ? void 0 : this.cellClassRules,
      cellClassRules,
      cellClassParams,
      (className) => this.cellComp.addOrRemoveCssClass(className, true),
      (className) => this.cellComp.addOrRemoveCssClass(className, false)
    );
    this.cellClassRules = cellClassRules;
  }
  applyUserStyles() {
    const colDef = this.column.getColDef();
    if (!colDef.cellStyle) {
      return;
    }
    let styles;
    if (typeof colDef.cellStyle === "function") {
      const cellStyleParams = this.beans.gridOptionsService.addGridCommonParams({
        column: this.column,
        value: this.cellCtrl.getValue(),
        colDef,
        data: this.rowNode.data,
        node: this.rowNode,
        rowIndex: this.rowNode.rowIndex
      });
      const cellStyleFunc = colDef.cellStyle;
      styles = cellStyleFunc(cellStyleParams);
    } else {
      styles = colDef.cellStyle;
    }
    if (styles) {
      this.cellComp.setUserStyles(styles);
    }
  }
  applyClassesFromColDef() {
    const colDef = this.column.getColDef();
    const cellClassParams = this.beans.gridOptionsService.addGridCommonParams({
      value: this.cellCtrl.getValue(),
      data: this.rowNode.data,
      node: this.rowNode,
      column: this.column,
      colDef,
      rowIndex: this.rowNode.rowIndex
    });
    if (this.staticClasses.length) {
      this.staticClasses.forEach((className) => this.cellComp.addOrRemoveCssClass(className, false));
    }
    this.staticClasses = this.beans.stylingService.getStaticCellClasses(colDef, cellClassParams);
    if (this.staticClasses.length) {
      this.staticClasses.forEach((className) => this.cellComp.addOrRemoveCssClass(className, true));
    }
  }
  // overriding to make public, as we don't dispose this bean via context
  destroy() {
    super.destroy();
  }
};

// community-modules/core/src/rendering/beans.ts
var Beans = class {
  postConstruct() {
    if (this.gridOptionsService.isRowModelType("clientSide")) {
      this.clientSideRowModel = this.rowModel;
    }
    if (this.gridOptionsService.isRowModelType("serverSide")) {
      this.serverSideRowModel = this.rowModel;
    }
  }
};
__decorateClass([
  Autowired("resizeObserverService")
], Beans.prototype, "resizeObserverService", 2);
__decorateClass([
  Autowired("paginationProxy")
], Beans.prototype, "paginationProxy", 2);
__decorateClass([
  Autowired("context")
], Beans.prototype, "context", 2);
__decorateClass([
  Autowired("columnApi")
], Beans.prototype, "columnApi", 2);
__decorateClass([
  Autowired("gridApi")
], Beans.prototype, "gridApi", 2);
__decorateClass([
  Autowired("gridOptionsService")
], Beans.prototype, "gridOptionsService", 2);
__decorateClass([
  Autowired("expressionService")
], Beans.prototype, "expressionService", 2);
__decorateClass([
  Autowired("environment")
], Beans.prototype, "environment", 2);
__decorateClass([
  Autowired("rowRenderer")
], Beans.prototype, "rowRenderer", 2);
__decorateClass([
  Autowired("templateService")
], Beans.prototype, "templateService", 2);
__decorateClass([
  Autowired("valueService")
], Beans.prototype, "valueService", 2);
__decorateClass([
  Autowired("eventService")
], Beans.prototype, "eventService", 2);
__decorateClass([
  Autowired("columnModel")
], Beans.prototype, "columnModel", 2);
__decorateClass([
  Autowired("headerNavigationService")
], Beans.prototype, "headerNavigationService", 2);
__decorateClass([
  Autowired("navigationService")
], Beans.prototype, "navigationService", 2);
__decorateClass([
  Autowired("columnAnimationService")
], Beans.prototype, "columnAnimationService", 2);
__decorateClass([
  Optional("rangeService")
], Beans.prototype, "rangeService", 2);
__decorateClass([
  Autowired("focusService")
], Beans.prototype, "focusService", 2);
__decorateClass([
  Autowired("popupService")
], Beans.prototype, "popupService", 2);
__decorateClass([
  Autowired("valueFormatterService")
], Beans.prototype, "valueFormatterService", 2);
__decorateClass([
  Autowired("stylingService")
], Beans.prototype, "stylingService", 2);
__decorateClass([
  Autowired("columnHoverService")
], Beans.prototype, "columnHoverService", 2);
__decorateClass([
  Autowired("userComponentFactory")
], Beans.prototype, "userComponentFactory", 2);
__decorateClass([
  Autowired("userComponentRegistry")
], Beans.prototype, "userComponentRegistry", 2);
__decorateClass([
  Autowired("animationFrameService")
], Beans.prototype, "animationFrameService", 2);
__decorateClass([
  Autowired("dragService")
], Beans.prototype, "dragService", 2);
__decorateClass([
  Autowired("dragAndDropService")
], Beans.prototype, "dragAndDropService", 2);
__decorateClass([
  Autowired("sortController")
], Beans.prototype, "sortController", 2);
__decorateClass([
  Autowired("filterManager")
], Beans.prototype, "filterManager", 2);
__decorateClass([
  Autowired("rowContainerHeightService")
], Beans.prototype, "rowContainerHeightService", 2);
__decorateClass([
  Autowired("frameworkOverrides")
], Beans.prototype, "frameworkOverrides", 2);
__decorateClass([
  Autowired("cellPositionUtils")
], Beans.prototype, "cellPositionUtils", 2);
__decorateClass([
  Autowired("rowPositionUtils")
], Beans.prototype, "rowPositionUtils", 2);
__decorateClass([
  Autowired("selectionService")
], Beans.prototype, "selectionService", 2);
__decorateClass([
  Optional("selectionHandleFactory")
], Beans.prototype, "selectionHandleFactory", 2);
__decorateClass([
  Autowired("rowCssClassCalculator")
], Beans.prototype, "rowCssClassCalculator", 2);
__decorateClass([
  Autowired("rowModel")
], Beans.prototype, "rowModel", 2);
__decorateClass([
  Autowired("ctrlsService")
], Beans.prototype, "ctrlsService", 2);
__decorateClass([
  Autowired("ctrlsFactory")
], Beans.prototype, "ctrlsFactory", 2);
__decorateClass([
  Autowired("agStackComponentsRegistry")
], Beans.prototype, "agStackComponentsRegistry", 2);
__decorateClass([
  Autowired("valueCache")
], Beans.prototype, "valueCache", 2);
__decorateClass([
  Autowired("rowNodeEventThrottle")
], Beans.prototype, "rowNodeEventThrottle", 2);
__decorateClass([
  Autowired("localeService")
], Beans.prototype, "localeService", 2);
__decorateClass([
  Autowired("valueParserService")
], Beans.prototype, "valueParserService", 2);
__decorateClass([
  Autowired("syncService")
], Beans.prototype, "syncService", 2);
__decorateClass([
  Autowired("ariaAnnouncementService")
], Beans.prototype, "ariaAnnouncementService", 2);
__decorateClass([
  PostConstruct
], Beans.prototype, "postConstruct", 1);
Beans = __decorateClass([
  Bean("beans")
], Beans);

// community-modules/core/src/rendering/cell/cellMouseListenerFeature.ts
var CellMouseListenerFeature = class extends Beans {
  constructor(ctrl, beans, column) {
    super();
    this.cellCtrl = ctrl;
    this.beans = beans;
    this.column = column;
  }
  onMouseEvent(eventName, mouseEvent) {
    if (isStopPropagationForAgGrid(mouseEvent)) {
      return;
    }
    switch (eventName) {
      case "click":
        this.onCellClicked(mouseEvent);
        break;
      case "mousedown":
      case "touchstart":
        this.onMouseDown(mouseEvent);
        break;
      case "dblclick":
        this.onCellDoubleClicked(mouseEvent);
        break;
      case "mouseout":
        this.onMouseOut(mouseEvent);
        break;
      case "mouseover":
        this.onMouseOver(mouseEvent);
        break;
    }
  }
  onCellClicked(mouseEvent) {
    if (this.isDoubleClickOnIPad()) {
      this.onCellDoubleClicked(mouseEvent);
      mouseEvent.preventDefault();
      return;
    }
    const { eventService, rangeService, gridOptionsService } = this.beans;
    const isMultiKey = mouseEvent.ctrlKey || mouseEvent.metaKey;
    if (rangeService && isMultiKey) {
      if (rangeService.getCellRangeCount(this.cellCtrl.getCellPosition()) > 1) {
        rangeService.intersectLastRange(true);
      }
    }
    const cellClickedEvent = this.cellCtrl.createEvent(mouseEvent, Events.EVENT_CELL_CLICKED);
    eventService.dispatchEvent(cellClickedEvent);
    const colDef = this.column.getColDef();
    if (colDef.onCellClicked) {
      window.setTimeout(() => {
        this.beans.frameworkOverrides.wrapOutgoing(() => {
          colDef.onCellClicked(cellClickedEvent);
        });
      }, 0);
    }
    const editOnSingleClick = (gridOptionsService.get("singleClickEdit") || colDef.singleClickEdit) && !gridOptionsService.get("suppressClickEdit");
    if (editOnSingleClick && !(mouseEvent.shiftKey && (rangeService == null ? void 0 : rangeService.getCellRanges().length) != 0)) {
      this.cellCtrl.startRowOrCellEdit();
    }
  }
  // returns true if on iPad and this is second 'click' event in 200ms
  isDoubleClickOnIPad() {
    if (!isIOSUserAgent() || isEventSupported("dblclick")) {
      return false;
    }
    const nowMillis = (/* @__PURE__ */ new Date()).getTime();
    const res = nowMillis - this.lastIPadMouseClickEvent < 200;
    this.lastIPadMouseClickEvent = nowMillis;
    return res;
  }
  onCellDoubleClicked(mouseEvent) {
    const colDef = this.column.getColDef();
    const cellDoubleClickedEvent = this.cellCtrl.createEvent(mouseEvent, Events.EVENT_CELL_DOUBLE_CLICKED);
    this.beans.eventService.dispatchEvent(cellDoubleClickedEvent);
    if (typeof colDef.onCellDoubleClicked === "function") {
      window.setTimeout(() => {
        this.beans.frameworkOverrides.wrapOutgoing(() => {
          colDef.onCellDoubleClicked(cellDoubleClickedEvent);
        });
      }, 0);
    }
    const editOnDoubleClick = !this.beans.gridOptionsService.get("singleClickEdit") && !this.beans.gridOptionsService.get("suppressClickEdit");
    if (editOnDoubleClick) {
      this.cellCtrl.startRowOrCellEdit(null, mouseEvent);
    }
  }
  onMouseDown(mouseEvent) {
    const { ctrlKey, metaKey, shiftKey } = mouseEvent;
    const target = mouseEvent.target;
    const { cellCtrl, beans } = this;
    const { eventService, rangeService, focusService } = beans;
    if (this.isRightClickInExistingRange(mouseEvent)) {
      return;
    }
    const ranges = rangeService && rangeService.getCellRanges().length != 0;
    if (!shiftKey || !ranges) {
      const forceBrowserFocus = isBrowserSafari() && !cellCtrl.isEditing() && !isFocusableFormField(target);
      cellCtrl.focusCell(forceBrowserFocus);
    }
    if (shiftKey && ranges && !focusService.isCellFocused(cellCtrl.getCellPosition())) {
      mouseEvent.preventDefault();
      const focusedCellPosition = focusService.getFocusedCell();
      if (focusedCellPosition) {
        const { column, rowIndex, rowPinned } = focusedCellPosition;
        const focusedRowCtrl = beans.rowRenderer.getRowByPosition({ rowIndex, rowPinned });
        const focusedCellCtrl = focusedRowCtrl == null ? void 0 : focusedRowCtrl.getCellCtrl(column);
        if (focusedCellCtrl == null ? void 0 : focusedCellCtrl.isEditing()) {
          focusedCellCtrl.stopEditing();
        }
        focusService.setFocusedCell({
          column,
          rowIndex,
          rowPinned,
          forceBrowserFocus: true,
          preventScrollOnBrowserFocus: true
        });
      }
    }
    if (this.containsWidget(target)) {
      return;
    }
    if (rangeService) {
      const thisCell = this.cellCtrl.getCellPosition();
      if (shiftKey) {
        rangeService.extendLatestRangeToCell(thisCell);
      } else {
        const isMultiKey = ctrlKey || metaKey;
        rangeService.setRangeToCell(thisCell, isMultiKey);
      }
    }
    eventService.dispatchEvent(this.cellCtrl.createEvent(mouseEvent, Events.EVENT_CELL_MOUSE_DOWN));
  }
  isRightClickInExistingRange(mouseEvent) {
    const { rangeService } = this.beans;
    if (rangeService) {
      const cellInRange = rangeService.isCellInAnyRange(this.cellCtrl.getCellPosition());
      const isRightClick = mouseEvent.button === 2 || mouseEvent.ctrlKey && this.beans.gridOptionsService.get("allowContextMenuWithControlKey");
      if (cellInRange && isRightClick) {
        return true;
      }
    }
    return false;
  }
  containsWidget(target) {
    return isElementChildOfClass(target, "ag-selection-checkbox", 3);
  }
  onMouseOut(mouseEvent) {
    if (this.mouseStayingInsideCell(mouseEvent)) {
      return;
    }
    const cellMouseOutEvent = this.cellCtrl.createEvent(mouseEvent, Events.EVENT_CELL_MOUSE_OUT);
    this.beans.eventService.dispatchEvent(cellMouseOutEvent);
    this.beans.columnHoverService.clearMouseOver();
  }
  onMouseOver(mouseEvent) {
    if (this.mouseStayingInsideCell(mouseEvent)) {
      return;
    }
    const cellMouseOverEvent = this.cellCtrl.createEvent(mouseEvent, Events.EVENT_CELL_MOUSE_OVER);
    this.beans.eventService.dispatchEvent(cellMouseOverEvent);
    this.beans.columnHoverService.setMouseOver([this.column]);
  }
  mouseStayingInsideCell(e) {
    if (!e.target || !e.relatedTarget) {
      return false;
    }
    const eGui = this.cellCtrl.getGui();
    const cellContainsTarget = eGui.contains(e.target);
    const cellContainsRelatedTarget = eGui.contains(e.relatedTarget);
    return cellContainsTarget && cellContainsRelatedTarget;
  }
  destroy() {
  }
};

// community-modules/core/src/rendering/cell/cellKeyboardListenerFeature.ts
var CellKeyboardListenerFeature = class extends BeanStub {
  constructor(ctrl, beans, column, rowNode, rowCtrl) {
    super();
    this.cellCtrl = ctrl;
    this.beans = beans;
    this.rowNode = rowNode;
    this.rowCtrl = rowCtrl;
  }
  setComp(eGui) {
    this.eGui = eGui;
  }
  onKeyDown(event) {
    const key = event.key;
    switch (key) {
      case KeyCode.ENTER:
        this.onEnterKeyDown(event);
        break;
      case KeyCode.F2:
        this.onF2KeyDown(event);
        break;
      case KeyCode.ESCAPE:
        this.onEscapeKeyDown(event);
        break;
      case KeyCode.TAB:
        this.onTabKeyDown(event);
        break;
      case KeyCode.BACKSPACE:
      case KeyCode.DELETE:
        this.onBackspaceOrDeleteKeyDown(key, event);
        break;
      case KeyCode.DOWN:
      case KeyCode.UP:
      case KeyCode.RIGHT:
      case KeyCode.LEFT:
        this.onNavigationKeyDown(event, key);
        break;
    }
  }
  onNavigationKeyDown(event, key) {
    if (this.cellCtrl.isEditing()) {
      return;
    }
    if (event.shiftKey && this.cellCtrl.isRangeSelectionEnabled()) {
      this.onShiftRangeSelect(event);
    } else {
      this.beans.navigationService.navigateToNextCell(event, key, this.cellCtrl.getCellPosition(), true);
    }
    event.preventDefault();
  }
  onShiftRangeSelect(event) {
    if (!this.beans.rangeService) {
      return;
    }
    const endCell = this.beans.rangeService.extendLatestRangeInDirection(event);
    if (endCell) {
      this.beans.navigationService.ensureCellVisible(endCell);
    }
  }
  onTabKeyDown(event) {
    this.beans.navigationService.onTabKeyDown(this.cellCtrl, event);
  }
  onBackspaceOrDeleteKeyDown(key, event) {
    const { cellCtrl, beans, rowNode } = this;
    const { gridOptionsService, rangeService, eventService } = beans;
    if (cellCtrl.isEditing()) {
      return;
    }
    eventService.dispatchEvent({ type: Events.EVENT_KEY_SHORTCUT_CHANGED_CELL_START });
    if (isDeleteKey(key, gridOptionsService.get("enableCellEditingOnBackspace"))) {
      if (rangeService && gridOptionsService.get("enableRangeSelection")) {
        rangeService.clearCellRangeCellValues({ dispatchWrapperEvents: true, wrapperEventSource: "deleteKey" });
      } else if (cellCtrl.isCellEditable()) {
        rowNode.setDataValue(cellCtrl.getColumn(), null, "cellClear");
      }
    } else {
      cellCtrl.startRowOrCellEdit(key, event);
    }
    eventService.dispatchEvent({ type: Events.EVENT_KEY_SHORTCUT_CHANGED_CELL_END });
  }
  onEnterKeyDown(e) {
    if (this.cellCtrl.isEditing() || this.rowCtrl.isEditing()) {
      this.cellCtrl.stopEditingAndFocus(false, e.shiftKey);
    } else {
      if (this.beans.gridOptionsService.get("enterNavigatesVertically")) {
        const key = e.shiftKey ? KeyCode.UP : KeyCode.DOWN;
        this.beans.navigationService.navigateToNextCell(null, key, this.cellCtrl.getCellPosition(), false);
      } else {
        this.cellCtrl.startRowOrCellEdit(KeyCode.ENTER, e);
        if (this.cellCtrl.isEditing()) {
          e.preventDefault();
        }
      }
    }
  }
  onF2KeyDown(event) {
    if (!this.cellCtrl.isEditing()) {
      this.cellCtrl.startRowOrCellEdit(KeyCode.F2, event);
    }
  }
  onEscapeKeyDown(event) {
    if (this.cellCtrl.isEditing()) {
      this.cellCtrl.stopRowOrCellEdit(true);
      this.cellCtrl.focusCell(true);
    }
  }
  processCharacter(event) {
    const eventTarget = event.target;
    const eventOnChildComponent = eventTarget !== this.eGui;
    if (eventOnChildComponent || this.cellCtrl.isEditing()) {
      return;
    }
    const key = event.key;
    if (key === " ") {
      this.onSpaceKeyDown(event);
    } else {
      this.cellCtrl.startRowOrCellEdit(key, event);
      event.preventDefault();
    }
  }
  onSpaceKeyDown(event) {
    const { gridOptionsService } = this.beans;
    if (!this.cellCtrl.isEditing() && gridOptionsService.isRowSelection()) {
      const currentSelection = this.rowNode.isSelected();
      const newSelection = !currentSelection;
      if (newSelection || !gridOptionsService.get("suppressRowDeselection")) {
        const groupSelectsFiltered = this.beans.gridOptionsService.get("groupSelectsFiltered");
        const updatedCount = this.rowNode.setSelectedParams({
          newValue: newSelection,
          rangeSelect: event.shiftKey,
          groupSelectsFiltered,
          event,
          source: "spaceKey"
        });
        if (currentSelection === void 0 && updatedCount === 0) {
          this.rowNode.setSelectedParams({
            newValue: false,
            rangeSelect: event.shiftKey,
            groupSelectsFiltered,
            event,
            source: "spaceKey"
          });
        }
      }
    }
    event.preventDefault();
  }
  destroy() {
    super.destroy();
  }
};

// community-modules/core/src/rendering/dndSourceComp.ts
var DndSourceComp = class extends Component {
  constructor(rowNode, column, eCell) {
    super(
      /* html */
      `<div class="ag-drag-handle ag-row-drag" draggable="true"></div>`
    );
    this.rowNode = rowNode;
    this.column = column;
    this.eCell = eCell;
  }
  postConstruct() {
    const eGui = this.getGui();
    eGui.appendChild(createIconNoSpan("rowDrag", this.gridOptionsService, null));
    this.addGuiEventListener("mousedown", (e) => {
      e.stopPropagation();
    });
    this.addDragSource();
    this.checkVisibility();
  }
  addDragSource() {
    this.addGuiEventListener("dragstart", this.onDragStart.bind(this));
  }
  onDragStart(dragEvent) {
    const providedOnRowDrag = this.column.getColDef().dndSourceOnRowDrag;
    dragEvent.dataTransfer.setDragImage(this.eCell, 0, 0);
    const defaultOnRowDrag = () => {
      try {
        const jsonData = JSON.stringify(this.rowNode.data);
        dragEvent.dataTransfer.setData("application/json", jsonData);
        dragEvent.dataTransfer.setData("text/plain", jsonData);
      } catch (e) {
      }
    };
    if (providedOnRowDrag) {
      const params = this.gridOptionsService.addGridCommonParams({
        rowNode: this.rowNode,
        dragEvent
      });
      providedOnRowDrag(params);
    } else {
      defaultOnRowDrag();
    }
  }
  checkVisibility() {
    const visible = this.column.isDndSource(this.rowNode);
    this.setDisplayed(visible);
  }
};
__decorateClass([
  PostConstruct
], DndSourceComp.prototype, "postConstruct", 1);

// community-modules/core/src/headerRendering/cells/cssClassApplier.ts
var CSS_FIRST_COLUMN = "ag-column-first";
var CSS_LAST_COLUMN = "ag-column-last";
var CssClassApplier = class {
  static getHeaderClassesFromColDef(abstractColDef, gridOptionsService, column, columnGroup) {
    if (missing(abstractColDef)) {
      return [];
    }
    return this.getColumnClassesFromCollDef(
      abstractColDef.headerClass,
      abstractColDef,
      gridOptionsService,
      column,
      columnGroup
    );
  }
  static getToolPanelClassesFromColDef(abstractColDef, gridOptionsService, column, columnGroup) {
    if (missing(abstractColDef)) {
      return [];
    }
    return this.getColumnClassesFromCollDef(
      abstractColDef.toolPanelClass,
      abstractColDef,
      gridOptionsService,
      column,
      columnGroup
    );
  }
  static refreshFirstAndLastStyles(comp, column, columnModel) {
    comp.addOrRemoveCssClass(CSS_FIRST_COLUMN, columnModel.isColumnAtEdge(column, "first"));
    comp.addOrRemoveCssClass(CSS_LAST_COLUMN, columnModel.isColumnAtEdge(column, "last"));
  }
  static getClassParams(abstractColDef, gridOptionsService, column, columnGroup) {
    return gridOptionsService.addGridCommonParams({
      // bad naming, as colDef here can be a group or a column,
      // however most people won't appreciate the difference,
      // so keeping it as colDef to avoid confusion.
      colDef: abstractColDef,
      column,
      columnGroup
    });
  }
  static getColumnClassesFromCollDef(classesOrFunc, abstractColDef, gridOptionsService, column, columnGroup) {
    if (missing(classesOrFunc)) {
      return [];
    }
    let classToUse;
    if (typeof classesOrFunc === "function") {
      const params = this.getClassParams(abstractColDef, gridOptionsService, column, columnGroup);
      classToUse = classesOrFunc(params);
    } else {
      classToUse = classesOrFunc;
    }
    if (typeof classToUse === "string") {
      return [classToUse];
    }
    if (Array.isArray(classToUse)) {
      return [...classToUse];
    }
    return [];
  }
};

// community-modules/core/src/rendering/cell/cellCtrl.ts
var CSS_CELL = "ag-cell";
var CSS_AUTO_HEIGHT = "ag-cell-auto-height";
var CSS_NORMAL_HEIGHT = "ag-cell-normal-height";
var CSS_CELL_FOCUS = "ag-cell-focus";
var CSS_CELL_FIRST_RIGHT_PINNED = "ag-cell-first-right-pinned";
var CSS_CELL_LAST_LEFT_PINNED = "ag-cell-last-left-pinned";
var CSS_CELL_NOT_INLINE_EDITING = "ag-cell-not-inline-editing";
var CSS_COLUMN_HOVER = "ag-column-hover";
var CSS_CELL_WRAP_TEXT = "ag-cell-wrap-text";
var instanceIdSequence2 = 0;
var _CellCtrl = class _CellCtrl extends BeanStub {
  constructor(column, rowNode, beans, rowCtrl) {
    super();
    this.cellRangeFeature = null;
    this.cellPositionFeature = null;
    this.cellCustomStyleFeature = null;
    this.tooltipFeature = null;
    this.cellMouseListenerFeature = null;
    this.cellKeyboardListenerFeature = null;
    this.suppressRefreshCell = false;
    this.onCellCompAttachedFuncs = [];
    this.column = column;
    this.rowNode = rowNode;
    this.beans = beans;
    this.rowCtrl = rowCtrl;
    this.instanceId = column.getId() + "-" + instanceIdSequence2++;
    this.colIdSanitised = escapeString(this.column.getId());
    if (!beans.gridOptionsService.get("suppressCellFocus")) {
      this.tabIndex = -1;
    }
    this.createCellPosition();
    this.addFeatures();
    this.updateAndFormatValue(false);
  }
  shouldRestoreFocus() {
    return this.beans.focusService.shouldRestoreFocus(this.cellPosition);
  }
  addFeatures() {
    this.cellPositionFeature = new CellPositionFeature(this, this.beans);
    this.addDestroyFunc(() => {
      var _a;
      (_a = this.cellPositionFeature) == null ? void 0 : _a.destroy();
      this.cellPositionFeature = null;
    });
    this.cellCustomStyleFeature = new CellCustomStyleFeature(this, this.beans);
    this.addDestroyFunc(() => {
      var _a;
      (_a = this.cellCustomStyleFeature) == null ? void 0 : _a.destroy();
      this.cellCustomStyleFeature = null;
    });
    this.cellMouseListenerFeature = new CellMouseListenerFeature(this, this.beans, this.column);
    this.addDestroyFunc(() => {
      var _a;
      (_a = this.cellMouseListenerFeature) == null ? void 0 : _a.destroy();
      this.cellMouseListenerFeature = null;
    });
    this.cellKeyboardListenerFeature = new CellKeyboardListenerFeature(this, this.beans, this.column, this.rowNode, this.rowCtrl);
    this.addDestroyFunc(() => {
      var _a;
      (_a = this.cellKeyboardListenerFeature) == null ? void 0 : _a.destroy();
      this.cellKeyboardListenerFeature = null;
    });
    if (this.column.isTooltipEnabled()) {
      this.enableTooltipFeature();
      this.addDestroyFunc(() => {
        this.disableTooltipFeature();
      });
    }
    const rangeSelectionEnabled = this.beans.rangeService && this.beans.gridOptionsService.get("enableRangeSelection");
    if (rangeSelectionEnabled) {
      this.cellRangeFeature = new CellRangeFeature(this.beans, this);
      this.addDestroyFunc(() => {
        var _a;
        (_a = this.cellRangeFeature) == null ? void 0 : _a.destroy();
        this.cellRangeFeature = null;
      });
    }
  }
  enableTooltipFeature(value, shouldDisplayTooltip) {
    const getTooltipValue = () => {
      const colDef = this.column.getColDef();
      const data = this.rowNode.data;
      if (colDef.tooltipField && exists(data)) {
        return getValueUsingField(data, colDef.tooltipField, this.column.isTooltipFieldContainsDots());
      }
      const valueGetter = colDef.tooltipValueGetter;
      if (valueGetter) {
        return valueGetter(this.beans.gridOptionsService.addGridCommonParams({
          location: "cell",
          colDef: this.column.getColDef(),
          column: this.column,
          rowIndex: this.cellPosition.rowIndex,
          node: this.rowNode,
          data: this.rowNode.data,
          value: this.value,
          valueFormatted: this.valueFormatted
        }));
      }
      return null;
    };
    const isTooltipWhenTruncated = this.beans.gridOptionsService.get("tooltipShowMode") === "whenTruncated";
    if (!shouldDisplayTooltip && isTooltipWhenTruncated && !this.isCellRenderer()) {
      shouldDisplayTooltip = () => {
        const eGui = this.getGui();
        const textEl = eGui.children.length === 0 ? eGui : eGui.querySelector(".ag-cell-value");
        if (!textEl) {
          return true;
        }
        return textEl.scrollWidth > textEl.clientWidth;
      };
    }
    const tooltipCtrl = {
      getColumn: () => this.column,
      getColDef: () => this.column.getColDef(),
      getRowIndex: () => this.cellPosition.rowIndex,
      getRowNode: () => this.rowNode,
      getGui: () => this.getGui(),
      getLocation: () => "cell",
      getTooltipValue: value != null ? () => value : getTooltipValue,
      // this makes no sense, why is the cell formatted value passed to the tooltip???
      getValueFormatted: () => this.valueFormatted,
      shouldDisplayTooltip
    };
    this.tooltipFeature = new TooltipFeature(tooltipCtrl, this.beans);
  }
  disableTooltipFeature() {
    if (!this.tooltipFeature) {
      return;
    }
    this.tooltipFeature.destroy();
    this.tooltipFeature = null;
  }
  setComp(comp, eGui, eCellWrapper, printLayout, startEditing) {
    var _a, _b, _c, _d;
    this.cellComp = comp;
    this.eGui = eGui;
    this.printLayout = printLayout;
    this.addDomData();
    this.onCellFocused(this.focusEventToRestore);
    this.applyStaticCssClasses();
    this.setWrapText();
    this.onFirstRightPinnedChanged();
    this.onLastLeftPinnedChanged();
    this.onColumnHover();
    this.setupControlComps();
    this.setupAutoHeight(eCellWrapper);
    this.refreshFirstAndLastStyles();
    this.refreshAriaColIndex();
    (_a = this.cellPositionFeature) == null ? void 0 : _a.setComp(eGui);
    (_b = this.cellCustomStyleFeature) == null ? void 0 : _b.setComp(comp);
    (_c = this.tooltipFeature) == null ? void 0 : _c.refreshToolTip();
    (_d = this.cellKeyboardListenerFeature) == null ? void 0 : _d.setComp(this.eGui);
    if (this.cellRangeFeature) {
      this.cellRangeFeature.setComp(comp, eGui);
    }
    if (startEditing && this.isCellEditable()) {
      this.startEditing();
    } else {
      this.showValue();
    }
    if (this.onCellCompAttachedFuncs.length) {
      this.onCellCompAttachedFuncs.forEach((func) => func());
      this.onCellCompAttachedFuncs = [];
    }
  }
  setupAutoHeight(eCellWrapper) {
    this.isAutoHeight = this.column.isAutoHeight();
    if (!this.isAutoHeight || !eCellWrapper) {
      return;
    }
    const eParentCell = eCellWrapper.parentElement;
    const minRowHeight = this.beans.gridOptionsService.getRowHeightForNode(this.rowNode).height;
    const measureHeight = (timesCalled) => {
      if (this.editing) {
        return;
      }
      if (!this.isAlive()) {
        return;
      }
      const { paddingTop, paddingBottom, borderBottomWidth, borderTopWidth } = getElementSize(eParentCell);
      const extraHeight = paddingTop + paddingBottom + borderBottomWidth + borderTopWidth;
      const wrapperHeight = eCellWrapper.offsetHeight;
      const autoHeight = wrapperHeight + extraHeight;
      if (timesCalled < 5) {
        const doc = this.beans.gridOptionsService.getDocument();
        const notYetInDom = !doc || !doc.contains(eCellWrapper);
        const possiblyNoContentYet = autoHeight == 0;
        if (notYetInDom || possiblyNoContentYet) {
          window.setTimeout(() => measureHeight(timesCalled + 1), 0);
          return;
        }
      }
      const newHeight = Math.max(autoHeight, minRowHeight);
      this.rowNode.setRowAutoHeight(newHeight, this.column);
    };
    const listener = () => measureHeight(0);
    listener();
    const destroyResizeObserver = this.beans.resizeObserverService.observeResize(eCellWrapper, listener);
    this.addDestroyFunc(() => {
      destroyResizeObserver();
      this.rowNode.setRowAutoHeight(void 0, this.column);
    });
  }
  getCellAriaRole() {
    var _a;
    return (_a = this.column.getColDef().cellAriaRole) != null ? _a : "gridcell";
  }
  getInstanceId() {
    return this.instanceId;
  }
  getIncludeSelection() {
    return this.includeSelection;
  }
  getIncludeRowDrag() {
    return this.includeRowDrag;
  }
  getIncludeDndSource() {
    return this.includeDndSource;
  }
  getColumnIdSanitised() {
    return this.colIdSanitised;
  }
  getTabIndex() {
    return this.tabIndex;
  }
  isCellRenderer() {
    const colDef = this.column.getColDef();
    return colDef.cellRenderer != null || colDef.cellRendererSelector != null;
  }
  getValueToDisplay() {
    return this.valueFormatted != null ? this.valueFormatted : this.value;
  }
  showValue(forceNewCellRendererInstance = false) {
    const valueToDisplay = this.getValueToDisplay();
    let compDetails;
    if (this.isCellRenderer()) {
      const params = this.createCellRendererParams();
      compDetails = this.beans.userComponentFactory.getCellRendererDetails(this.column.getColDef(), params);
    }
    this.cellComp.setRenderDetails(compDetails, valueToDisplay, forceNewCellRendererInstance);
    this.refreshHandle();
  }
  setupControlComps() {
    const colDef = this.column.getColDef();
    this.includeSelection = this.isIncludeControl(colDef.checkboxSelection);
    this.includeRowDrag = this.isIncludeControl(colDef.rowDrag);
    this.includeDndSource = this.isIncludeControl(colDef.dndSource);
    this.cellComp.setIncludeSelection(this.includeSelection);
    this.cellComp.setIncludeDndSource(this.includeDndSource);
    this.cellComp.setIncludeRowDrag(this.includeRowDrag);
  }
  isForceWrapper() {
    const forceWrapper = this.beans.gridOptionsService.get("enableCellTextSelection") || this.column.isAutoHeight();
    return forceWrapper;
  }
  isIncludeControl(value) {
    const rowNodePinned = this.rowNode.rowPinned != null;
    const isFunc = typeof value === "function";
    const res = rowNodePinned ? false : isFunc || value === true;
    return res;
  }
  refreshShouldDestroy() {
    const colDef = this.column.getColDef();
    const selectionChanged = this.includeSelection != this.isIncludeControl(colDef.checkboxSelection);
    const rowDragChanged = this.includeRowDrag != this.isIncludeControl(colDef.rowDrag);
    const dndSourceChanged = this.includeDndSource != this.isIncludeControl(colDef.dndSource);
    return selectionChanged || rowDragChanged || dndSourceChanged;
  }
  // either called internally if single cell editing, or called by rowRenderer if row editing
  startEditing(key = null, cellStartedEdit = false, event = null) {
    if (!this.isCellEditable() || this.editing) {
      return;
    }
    if (!this.cellComp) {
      this.onCellCompAttachedFuncs.push(() => {
        this.startEditing(key, cellStartedEdit, event);
      });
      return;
    }
    const editorParams = this.createCellEditorParams(key, cellStartedEdit);
    const colDef = this.column.getColDef();
    const compDetails = this.beans.userComponentFactory.getCellEditorDetails(colDef, editorParams);
    this.editCompDetails = compDetails;
    const popup = (compDetails == null ? void 0 : compDetails.popupFromSelector) != null ? compDetails.popupFromSelector : !!colDef.cellEditorPopup;
    const position = (compDetails == null ? void 0 : compDetails.popupPositionFromSelector) != null ? compDetails.popupPositionFromSelector : colDef.cellEditorPopupPosition;
    this.setEditing(true);
    this.cellComp.setEditDetails(compDetails, popup, position, this.beans.gridOptionsService.get("reactiveCustomComponents"));
    const e = this.createEvent(event, Events.EVENT_CELL_EDITING_STARTED);
    this.beans.eventService.dispatchEvent(e);
  }
  setEditing(editing) {
    if (this.editing === editing) {
      return;
    }
    this.editing = editing;
    this.refreshHandle();
  }
  // pass in 'true' to cancel the editing.
  stopRowOrCellEdit(cancel = false) {
    if (this.beans.gridOptionsService.get("editType") === "fullRow") {
      this.rowCtrl.stopEditing(cancel);
    } else {
      this.stopEditing(cancel);
    }
  }
  onPopupEditorClosed() {
    if (!this.isEditing()) {
      return;
    }
    this.stopEditingAndFocus();
  }
  takeValueFromCellEditor(cancel) {
    const noValueResult = { newValueExists: false };
    if (cancel) {
      return noValueResult;
    }
    const cellEditor = this.cellComp.getCellEditor();
    if (!cellEditor) {
      return noValueResult;
    }
    const userWantsToCancel = cellEditor.isCancelAfterEnd && cellEditor.isCancelAfterEnd();
    if (userWantsToCancel) {
      return noValueResult;
    }
    const newValue = cellEditor.getValue();
    return {
      newValue,
      newValueExists: true
    };
  }
  /**
   * @returns `True` if the value changes, otherwise `False`.
   */
  saveNewValue(oldValue, newValue) {
    if (newValue === oldValue) {
      return false;
    }
    this.suppressRefreshCell = true;
    const valueChanged = this.rowNode.setDataValue(this.column, newValue, "edit");
    this.suppressRefreshCell = false;
    return valueChanged;
  }
  /**
   * Ends the Cell Editing
   * @param cancel `True` if the edit process is being canceled.
   * @returns `True` if the value of the `GridCell` has been updated, otherwise `False`.
   */
  stopEditing(cancel = false) {
    if (!this.editing) {
      return false;
    }
    const { newValue, newValueExists } = this.takeValueFromCellEditor(cancel);
    const oldValue = this.rowNode.getValueFromValueService(this.column);
    let valueChanged = false;
    if (newValueExists) {
      valueChanged = this.saveNewValue(oldValue, newValue);
    }
    this.setEditing(false);
    this.cellComp.setEditDetails();
    this.editCompDetails = void 0;
    this.updateAndFormatValue(false);
    this.refreshCell({ forceRefresh: true, suppressFlash: true });
    this.dispatchEditingStoppedEvent(oldValue, newValue, !cancel && !!valueChanged);
    return valueChanged;
  }
  dispatchEditingStoppedEvent(oldValue, newValue, valueChanged) {
    const editingStoppedEvent = __spreadProps(__spreadValues({}, this.createEvent(null, Events.EVENT_CELL_EDITING_STOPPED)), {
      oldValue,
      newValue,
      valueChanged
    });
    this.beans.eventService.dispatchEvent(editingStoppedEvent);
  }
  createCellEditorParams(key, cellStartedEdit) {
    return this.beans.gridOptionsService.addGridCommonParams({
      value: this.rowNode.getValueFromValueService(this.column),
      eventKey: key,
      column: this.column,
      colDef: this.column.getColDef(),
      rowIndex: this.getCellPosition().rowIndex,
      node: this.rowNode,
      data: this.rowNode.data,
      cellStartedEdit,
      onKeyDown: this.onKeyDown.bind(this),
      stopEditing: this.stopEditingAndFocus.bind(this),
      eGridCell: this.getGui(),
      parseValue: this.parseValue.bind(this),
      formatValue: this.formatValue.bind(this)
    });
  }
  createCellRendererParams() {
    const res = this.beans.gridOptionsService.addGridCommonParams({
      value: this.value,
      valueFormatted: this.valueFormatted,
      getValue: () => this.rowNode.getValueFromValueService(this.column),
      setValue: (value) => this.beans.valueService.setValue(this.rowNode, this.column, value),
      formatValue: this.formatValue.bind(this),
      data: this.rowNode.data,
      node: this.rowNode,
      pinned: this.column.getPinned(),
      colDef: this.column.getColDef(),
      column: this.column,
      rowIndex: this.getCellPosition().rowIndex,
      refreshCell: this.refreshCell.bind(this),
      eGridCell: this.getGui(),
      eParentOfValue: this.cellComp.getParentOfValue(),
      registerRowDragger: (rowDraggerElement, dragStartPixels, value, suppressVisibilityChange) => this.registerRowDragger(rowDraggerElement, dragStartPixels, suppressVisibilityChange),
      setTooltip: (value, shouldDisplayTooltip) => {
        if (this.tooltipFeature) {
          this.disableTooltipFeature();
        }
        this.enableTooltipFeature(value, shouldDisplayTooltip);
        this.refreshToolTip();
      }
    });
    return res;
  }
  parseValue(newValue) {
    return this.beans.valueParserService.parseValue(this.column, this.rowNode, newValue, this.getValue());
  }
  setFocusOutOnEditor() {
    if (!this.editing) {
      return;
    }
    const cellEditor = this.cellComp.getCellEditor();
    if (cellEditor && cellEditor.focusOut) {
      cellEditor.focusOut();
    }
  }
  setFocusInOnEditor() {
    if (!this.editing) {
      return;
    }
    const cellEditor = this.cellComp.getCellEditor();
    if (cellEditor && cellEditor.focusIn) {
      cellEditor.focusIn();
    } else {
      this.focusCell(true);
    }
  }
  onCellChanged(event) {
    const eventImpactsThisCell = event.column === this.column;
    if (eventImpactsThisCell) {
      this.refreshCell({});
    }
  }
  refreshOrDestroyCell(params) {
    var _a;
    if (this.refreshShouldDestroy()) {
      (_a = this.rowCtrl) == null ? void 0 : _a.refreshCell(this);
    } else {
      this.refreshCell(params);
    }
  }
  // + stop editing {forceRefresh: true, suppressFlash: true}
  // + event cellChanged {}
  // + cellRenderer.params.refresh() {} -> method passes 'as is' to the cellRenderer, so params could be anything
  // + rowCtrl: event dataChanged {suppressFlash: !update, newData: !update}
  // + rowCtrl: api refreshCells() {animate: true/false}
  // + rowRenderer: api softRefreshView() {}
  refreshCell(params) {
    var _a, _b, _c;
    if (this.suppressRefreshCell || this.editing) {
      return;
    }
    const colDef = this.column.getColDef();
    const newData = params != null && !!params.newData;
    const suppressFlash = params != null && !!params.suppressFlash || !!colDef.suppressCellFlash;
    const noValueProvided = colDef.field == null && colDef.valueGetter == null && colDef.showRowGroup == null;
    const forceRefresh = params && params.forceRefresh || noValueProvided || newData;
    const isCellCompReady = !!this.cellComp;
    const valuesDifferent = this.updateAndFormatValue(isCellCompReady);
    const dataNeedsUpdating = forceRefresh || valuesDifferent;
    if (!isCellCompReady) {
      return;
    }
    if (dataNeedsUpdating) {
      this.showValue(newData);
      const processingFilterChange = this.beans.filterManager.isSuppressFlashingCellsBecauseFiltering();
      const flashCell = !suppressFlash && !processingFilterChange && (this.beans.gridOptionsService.get("enableCellChangeFlash") || colDef.enableCellChangeFlash);
      if (flashCell) {
        this.flashCell();
      }
      (_a = this.cellCustomStyleFeature) == null ? void 0 : _a.applyUserStyles();
      (_b = this.cellCustomStyleFeature) == null ? void 0 : _b.applyClassesFromColDef();
    }
    this.refreshToolTip();
    (_c = this.cellCustomStyleFeature) == null ? void 0 : _c.applyCellClassRules();
  }
  // cell editors call this, when they want to stop for reasons other
  // than what we pick up on. eg selecting from a dropdown ends editing.
  stopEditingAndFocus(suppressNavigateAfterEdit = false, shiftKey = false) {
    this.stopRowOrCellEdit();
    this.focusCell(true);
    if (!suppressNavigateAfterEdit) {
      this.navigateAfterEdit(shiftKey);
    }
  }
  navigateAfterEdit(shiftKey) {
    const enterNavigatesVerticallyAfterEdit = this.beans.gridOptionsService.get("enterNavigatesVerticallyAfterEdit");
    if (enterNavigatesVerticallyAfterEdit) {
      const key = shiftKey ? KeyCode.UP : KeyCode.DOWN;
      this.beans.navigationService.navigateToNextCell(null, key, this.getCellPosition(), false);
    }
  }
  // user can also call this via API
  flashCell(delays) {
    var _a, _b;
    const flashDuration = (_a = delays == null ? void 0 : delays.flashDuration) != null ? _a : delays == null ? void 0 : delays.flashDelay;
    const fadeDuration = (_b = delays == null ? void 0 : delays.fadeDuration) != null ? _b : delays == null ? void 0 : delays.fadeDelay;
    this.animateCell("data-changed", flashDuration, fadeDuration);
  }
  animateCell(cssName, flashDuration, fadeDuration) {
    if (!this.cellComp) {
      return;
    }
    const fullName = `ag-cell-${cssName}`;
    const animationFullName = `ag-cell-${cssName}-animation`;
    const { gridOptionsService } = this.beans;
    if (!flashDuration) {
      flashDuration = gridOptionsService.get("cellFlashDuration");
    }
    if (!exists(fadeDuration)) {
      fadeDuration = gridOptionsService.get("cellFadeDuration");
    }
    this.cellComp.addOrRemoveCssClass(fullName, true);
    this.cellComp.addOrRemoveCssClass(animationFullName, false);
    this.beans.frameworkOverrides.wrapIncoming(() => {
      window.setTimeout(() => {
        if (!this.isAlive()) {
          return;
        }
        this.cellComp.addOrRemoveCssClass(fullName, false);
        this.cellComp.addOrRemoveCssClass(animationFullName, true);
        this.eGui.style.transition = `background-color ${fadeDuration}ms`;
        window.setTimeout(() => {
          if (!this.isAlive()) {
            return;
          }
          this.cellComp.addOrRemoveCssClass(animationFullName, false);
          this.eGui.style.transition = "";
        }, fadeDuration);
      }, flashDuration);
    });
  }
  onFlashCells(event) {
    if (!this.cellComp) {
      return;
    }
    const cellId = this.beans.cellPositionUtils.createId(this.getCellPosition());
    const shouldFlash = event.cells[cellId];
    if (shouldFlash) {
      this.animateCell("highlight");
    }
  }
  isCellEditable() {
    return this.column.isCellEditable(this.rowNode);
  }
  isSuppressFillHandle() {
    return this.column.isSuppressFillHandle();
  }
  formatValue(value) {
    var _a;
    return (_a = this.callValueFormatter(value)) != null ? _a : value;
  }
  callValueFormatter(value) {
    return this.beans.valueFormatterService.formatValue(this.column, this.rowNode, value);
  }
  updateAndFormatValue(compareValues) {
    const oldValue = this.value;
    const oldValueFormatted = this.valueFormatted;
    this.value = this.rowNode.getValueFromValueService(this.column);
    this.valueFormatted = this.callValueFormatter(this.value);
    if (compareValues) {
      return !this.valuesAreEqual(oldValue, this.value) || this.valueFormatted != oldValueFormatted;
    }
    return true;
  }
  valuesAreEqual(val1, val2) {
    const colDef = this.column.getColDef();
    return colDef.equals ? colDef.equals(val1, val2) : val1 === val2;
  }
  getComp() {
    return this.cellComp;
  }
  getValue() {
    return this.value;
  }
  getValueFormatted() {
    return this.valueFormatted;
  }
  addDomData() {
    const element = this.getGui();
    this.beans.gridOptionsService.setDomData(element, _CellCtrl.DOM_DATA_KEY_CELL_CTRL, this);
    this.addDestroyFunc(() => this.beans.gridOptionsService.setDomData(element, _CellCtrl.DOM_DATA_KEY_CELL_CTRL, null));
  }
  createEvent(domEvent, eventType) {
    const event = this.beans.gridOptionsService.addGridCommonParams({
      type: eventType,
      node: this.rowNode,
      data: this.rowNode.data,
      value: this.value,
      column: this.column,
      colDef: this.column.getColDef(),
      rowPinned: this.rowNode.rowPinned,
      event: domEvent,
      rowIndex: this.rowNode.rowIndex
    });
    return event;
  }
  processCharacter(event) {
    var _a;
    (_a = this.cellKeyboardListenerFeature) == null ? void 0 : _a.processCharacter(event);
  }
  onKeyDown(event) {
    var _a;
    (_a = this.cellKeyboardListenerFeature) == null ? void 0 : _a.onKeyDown(event);
  }
  onMouseEvent(eventName, mouseEvent) {
    var _a;
    (_a = this.cellMouseListenerFeature) == null ? void 0 : _a.onMouseEvent(eventName, mouseEvent);
  }
  getGui() {
    return this.eGui;
  }
  refreshToolTip() {
    var _a;
    (_a = this.tooltipFeature) == null ? void 0 : _a.refreshToolTip();
  }
  getColSpanningList() {
    return this.cellPositionFeature.getColSpanningList();
  }
  onLeftChanged() {
    var _a;
    if (!this.cellComp) {
      return;
    }
    (_a = this.cellPositionFeature) == null ? void 0 : _a.onLeftChanged();
  }
  onDisplayedColumnsChanged() {
    if (!this.eGui) {
      return;
    }
    this.refreshAriaColIndex();
    this.refreshFirstAndLastStyles();
  }
  refreshFirstAndLastStyles() {
    const { cellComp, column, beans } = this;
    CssClassApplier.refreshFirstAndLastStyles(cellComp, column, beans.columnModel);
  }
  refreshAriaColIndex() {
    const colIdx = this.beans.columnModel.getAriaColumnIndex(this.column);
    setAriaColIndex(this.getGui(), colIdx);
  }
  isSuppressNavigable() {
    return this.column.isSuppressNavigable(this.rowNode);
  }
  onWidthChanged() {
    var _a;
    return (_a = this.cellPositionFeature) == null ? void 0 : _a.onWidthChanged();
  }
  getColumn() {
    return this.column;
  }
  getRowNode() {
    return this.rowNode;
  }
  getBeans() {
    return this.beans;
  }
  isPrintLayout() {
    return this.printLayout;
  }
  appendChild(htmlElement) {
    this.eGui.appendChild(htmlElement);
  }
  refreshHandle() {
    if (this.cellRangeFeature) {
      this.cellRangeFeature.refreshHandle();
    }
  }
  getCellPosition() {
    return this.cellPosition;
  }
  isEditing() {
    return this.editing;
  }
  // called by rowRenderer when user navigates via tab key
  startRowOrCellEdit(key, event = null) {
    if (!this.cellComp) {
      this.onCellCompAttachedFuncs.push(() => {
        this.startRowOrCellEdit(key, event);
      });
      return;
    }
    if (this.beans.gridOptionsService.get("editType") === "fullRow") {
      this.rowCtrl.startRowEditing(key, this);
    } else {
      this.startEditing(key, true, event);
    }
  }
  getRowCtrl() {
    return this.rowCtrl;
  }
  getRowPosition() {
    return {
      rowIndex: this.cellPosition.rowIndex,
      rowPinned: this.cellPosition.rowPinned
    };
  }
  updateRangeBordersIfRangeCount() {
    if (!this.cellComp) {
      return;
    }
    if (this.cellRangeFeature) {
      this.cellRangeFeature.updateRangeBordersIfRangeCount();
    }
  }
  onRangeSelectionChanged() {
    if (!this.cellComp) {
      return;
    }
    if (this.cellRangeFeature) {
      this.cellRangeFeature.onRangeSelectionChanged();
    }
  }
  isRangeSelectionEnabled() {
    return this.cellRangeFeature != null;
  }
  focusCell(forceBrowserFocus = false) {
    this.beans.focusService.setFocusedCell({
      rowIndex: this.getCellPosition().rowIndex,
      column: this.column,
      rowPinned: this.rowNode.rowPinned,
      forceBrowserFocus
    });
  }
  onRowIndexChanged() {
    this.createCellPosition();
    this.onCellFocused();
    if (this.cellRangeFeature) {
      this.cellRangeFeature.onRangeSelectionChanged();
    }
  }
  onFirstRightPinnedChanged() {
    if (!this.cellComp) {
      return;
    }
    const firstRightPinned = this.column.isFirstRightPinned();
    this.cellComp.addOrRemoveCssClass(CSS_CELL_FIRST_RIGHT_PINNED, firstRightPinned);
  }
  onLastLeftPinnedChanged() {
    if (!this.cellComp) {
      return;
    }
    const lastLeftPinned = this.column.isLastLeftPinned();
    this.cellComp.addOrRemoveCssClass(CSS_CELL_LAST_LEFT_PINNED, lastLeftPinned);
  }
  onCellFocused(event) {
    if (this.beans.gridOptionsService.get("suppressCellFocus")) {
      return;
    }
    const cellFocused = this.beans.focusService.isCellFocused(this.cellPosition);
    if (!this.cellComp) {
      if (cellFocused && (event == null ? void 0 : event.forceBrowserFocus)) {
        this.focusEventToRestore = event;
      }
      return;
    }
    this.focusEventToRestore = void 0;
    this.cellComp.addOrRemoveCssClass(CSS_CELL_FOCUS, cellFocused);
    if (cellFocused && event && event.forceBrowserFocus) {
      const focusEl = this.cellComp.getFocusableElement();
      focusEl.focus({ preventScroll: !!event.preventScrollOnBrowserFocus });
    }
    const fullRowEdit = this.beans.gridOptionsService.get("editType") === "fullRow";
    if (!cellFocused && !fullRowEdit && this.editing) {
      this.stopRowOrCellEdit();
    }
    if (cellFocused) {
      this.rowCtrl.announceDescription();
    }
  }
  createCellPosition() {
    this.cellPosition = {
      rowIndex: this.rowNode.rowIndex,
      rowPinned: makeNull(this.rowNode.rowPinned),
      column: this.column
    };
  }
  // CSS Classes that only get applied once, they never change
  applyStaticCssClasses() {
    this.cellComp.addOrRemoveCssClass(CSS_CELL, true);
    this.cellComp.addOrRemoveCssClass(CSS_CELL_NOT_INLINE_EDITING, true);
    const autoHeight = this.column.isAutoHeight() == true;
    this.cellComp.addOrRemoveCssClass(CSS_AUTO_HEIGHT, autoHeight);
    this.cellComp.addOrRemoveCssClass(CSS_NORMAL_HEIGHT, !autoHeight);
  }
  onColumnHover() {
    if (!this.cellComp) {
      return;
    }
    if (!this.beans.gridOptionsService.get("columnHoverHighlight")) {
      return;
    }
    const isHovered = this.beans.columnHoverService.isHovered(this.column);
    this.cellComp.addOrRemoveCssClass(CSS_COLUMN_HOVER, isHovered);
  }
  onColDefChanged() {
    var _a;
    if (!this.cellComp) {
      return;
    }
    const isAutoHeight = this.column.isAutoHeight();
    if (isAutoHeight !== this.isAutoHeight) {
      (_a = this.rowCtrl) == null ? void 0 : _a.refreshCell(this);
    }
    const isTooltipEnabled = this.column.isTooltipEnabled();
    if (isTooltipEnabled) {
      this.disableTooltipFeature();
      this.enableTooltipFeature();
    } else {
      this.disableTooltipFeature();
    }
    this.setWrapText();
    if (!this.editing) {
      this.refreshOrDestroyCell({ forceRefresh: true, suppressFlash: true });
    } else {
      const cellEditor = this.getCellEditor();
      if (cellEditor == null ? void 0 : cellEditor.refresh) {
        const { eventKey, cellStartedEdit } = this.editCompDetails.params;
        const editorParams = this.createCellEditorParams(eventKey, cellStartedEdit);
        const colDef = this.column.getColDef();
        const compDetails = this.beans.userComponentFactory.getCellEditorDetails(colDef, editorParams);
        cellEditor.refresh(compDetails.params);
      }
    }
  }
  setWrapText() {
    const value = this.column.getColDef().wrapText == true;
    this.cellComp.addOrRemoveCssClass(CSS_CELL_WRAP_TEXT, value);
  }
  dispatchCellContextMenuEvent(event) {
    const colDef = this.column.getColDef();
    const cellContextMenuEvent = this.createEvent(event, Events.EVENT_CELL_CONTEXT_MENU);
    this.beans.eventService.dispatchEvent(cellContextMenuEvent);
    if (colDef.onCellContextMenu) {
      window.setTimeout(() => {
        this.beans.frameworkOverrides.wrapOutgoing(() => {
          colDef.onCellContextMenu(cellContextMenuEvent);
        });
      }, 0);
    }
  }
  getCellRenderer() {
    return this.cellComp ? this.cellComp.getCellRenderer() : null;
  }
  getCellEditor() {
    return this.cellComp ? this.cellComp.getCellEditor() : null;
  }
  destroy() {
    this.onCellCompAttachedFuncs = [];
    super.destroy();
  }
  createSelectionCheckbox() {
    const cbSelectionComponent = new CheckboxSelectionComponent();
    this.beans.context.createBean(cbSelectionComponent);
    cbSelectionComponent.init({ rowNode: this.rowNode, column: this.column });
    return cbSelectionComponent;
  }
  createDndSource() {
    const dndSourceComp = new DndSourceComp(this.rowNode, this.column, this.eGui);
    this.beans.context.createBean(dndSourceComp);
    return dndSourceComp;
  }
  registerRowDragger(customElement, dragStartPixels, suppressVisibilityChange) {
    if (this.customRowDragComp) {
      this.customRowDragComp.setDragElement(customElement, dragStartPixels);
      return;
    }
    const newComp = this.createRowDragComp(customElement, dragStartPixels, suppressVisibilityChange);
    if (newComp) {
      this.customRowDragComp = newComp;
      this.addDestroyFunc(() => {
        this.beans.context.destroyBean(newComp);
        this.customRowDragComp = null;
      });
    }
  }
  createRowDragComp(customElement, dragStartPixels, suppressVisibilityChange) {
    const pagination = this.beans.gridOptionsService.get("pagination");
    const rowDragManaged = this.beans.gridOptionsService.get("rowDragManaged");
    const clientSideRowModelActive = this.beans.gridOptionsService.isRowModelType("clientSide");
    if (rowDragManaged) {
      if (!clientSideRowModelActive) {
        warnOnce("managed row dragging is only allowed in the Client Side Row Model");
        return;
      }
      if (pagination) {
        warnOnce("managed row dragging is not possible when doing pagination");
        return;
      }
    }
    const rowDragComp = new RowDragComp(() => this.value, this.rowNode, this.column, customElement, dragStartPixels, suppressVisibilityChange);
    this.beans.context.createBean(rowDragComp);
    return rowDragComp;
  }
};
_CellCtrl.DOM_DATA_KEY_CELL_CTRL = "cellCtrl";
var CellCtrl = _CellCtrl;

// community-modules/core/src/rendering/row/rowCtrl.ts
var instanceIdSequence3 = 0;
var _RowCtrl = class _RowCtrl extends BeanStub {
  constructor(rowNode, beans, animateIn, useAnimationFrameForCreate, printLayout) {
    super();
    this.allRowGuis = [];
    this.active = true;
    this.centerCellCtrls = { list: [], map: {} };
    this.leftCellCtrls = { list: [], map: {} };
    this.rightCellCtrls = { list: [], map: {} };
    this.slideInAnimation = {
      left: false,
      center: false,
      right: false,
      fullWidth: false
    };
    this.fadeInAnimation = {
      left: false,
      center: false,
      right: false,
      fullWidth: false
    };
    this.rowDragComps = [];
    this.lastMouseDownOnDragger = false;
    this.emptyStyle = {};
    this.updateColumnListsPending = false;
    this.rowId = null;
    this.businessKeySanitised = null;
    this.beans = beans;
    this.gridOptionsService = beans.gridOptionsService;
    this.rowNode = rowNode;
    this.paginationPage = beans.paginationProxy.getCurrentPage();
    this.useAnimationFrameForCreate = useAnimationFrameForCreate;
    this.printLayout = printLayout;
    this.suppressRowTransform = this.gridOptionsService.get("suppressRowTransform");
    this.instanceId = rowNode.id + "-" + instanceIdSequence3++;
    this.rowId = escapeString(rowNode.id);
    this.initRowBusinessKey();
    this.rowFocused = beans.focusService.isRowFocused(this.rowNode.rowIndex, this.rowNode.rowPinned);
    this.rowLevel = beans.rowCssClassCalculator.calculateRowLevel(this.rowNode);
    this.setRowType();
    this.setAnimateFlags(animateIn);
    this.rowStyles = this.processStylesFromGridOptions();
    if (this.isFullWidth() && !this.gridOptionsService.get("suppressCellFocus")) {
      this.tabIndex = -1;
    }
    this.addListeners();
  }
  initRowBusinessKey() {
    this.businessKeyForNodeFunc = this.gridOptionsService.get("getBusinessKeyForNode");
    this.updateRowBusinessKey();
  }
  updateRowBusinessKey() {
    if (typeof this.businessKeyForNodeFunc !== "function") {
      return;
    }
    const businessKey = this.businessKeyForNodeFunc(this.rowNode);
    this.businessKeySanitised = escapeString(businessKey);
  }
  getRowId() {
    return this.rowId;
  }
  getRowStyles() {
    return this.rowStyles;
  }
  getTabIndex() {
    return this.tabIndex;
  }
  isSticky() {
    return this.rowNode.sticky;
  }
  getBeans() {
    return this.beans;
  }
  getInstanceId() {
    return this.instanceId;
  }
  setComp(rowComp, element, containerType) {
    const gui = { rowComp, element, containerType };
    this.allRowGuis.push(gui);
    if (containerType === "left" /* LEFT */) {
      this.leftGui = gui;
    } else if (containerType === "right" /* RIGHT */) {
      this.rightGui = gui;
    } else if (containerType === "fullWidth" /* FULL_WIDTH */) {
      this.fullWidthGui = gui;
    } else {
      this.centerGui = gui;
    }
    this.initialiseRowComp(gui);
    if (this.rowType !== "FullWidthLoading" && !this.rowNode.rowPinned) {
      this.beans.rowRenderer.dispatchFirstDataRenderedEvent();
    }
  }
  unsetComp(containerType) {
    this.allRowGuis = this.allRowGuis.filter((rowGui) => rowGui.containerType !== containerType);
    switch (containerType) {
      case "left" /* LEFT */:
        this.leftGui = void 0;
        break;
      case "right" /* RIGHT */:
        this.rightGui = void 0;
        break;
      case "fullWidth" /* FULL_WIDTH */:
        this.fullWidthGui = void 0;
        break;
      case "center" /* CENTER */:
        this.centerGui = void 0;
        break;
      default:
    }
  }
  isCacheable() {
    return this.rowType === "FullWidthDetail" /* FullWidthDetail */ && this.gridOptionsService.get("keepDetailRows");
  }
  setCached(cached) {
    const displayValue = cached ? "none" : "";
    this.allRowGuis.forEach((rg) => rg.element.style.display = displayValue);
  }
  initialiseRowComp(gui) {
    const gos = this.gridOptionsService;
    this.listenOnDomOrder(gui);
    if (this.beans.columnModel.wasAutoRowHeightEverActive()) {
      this.rowNode.checkAutoHeights();
    }
    this.onRowHeightChanged(gui);
    this.updateRowIndexes(gui);
    this.setFocusedClasses(gui);
    this.setStylesFromGridOptions(false, gui);
    if (gos.isRowSelection() && this.rowNode.selectable) {
      this.onRowSelected(gui);
    }
    this.updateColumnLists(!this.useAnimationFrameForCreate);
    const comp = gui.rowComp;
    const initialRowClasses = this.getInitialRowClasses(gui.containerType);
    initialRowClasses.forEach((name) => comp.addOrRemoveCssClass(name, true));
    this.executeSlideAndFadeAnimations(gui);
    if (this.rowNode.group) {
      setAriaExpanded(gui.element, this.rowNode.expanded == true);
    }
    this.setRowCompRowId(comp);
    this.setRowCompRowBusinessKey(comp);
    gos.setDomData(gui.element, _RowCtrl.DOM_DATA_KEY_ROW_CTRL, this);
    this.addDestroyFunc(
      () => gos.setDomData(gui.element, _RowCtrl.DOM_DATA_KEY_ROW_CTRL, null)
    );
    if (this.useAnimationFrameForCreate) {
      this.beans.animationFrameService.createTask(
        this.addHoverFunctionality.bind(this, gui.element),
        this.rowNode.rowIndex,
        "createTasksP2"
      );
    } else {
      this.addHoverFunctionality(gui.element);
    }
    if (this.isFullWidth()) {
      this.setupFullWidth(gui);
    }
    if (gos.get("rowDragEntireRow")) {
      this.addRowDraggerToRow(gui);
    }
    if (this.useAnimationFrameForCreate) {
      this.beans.animationFrameService.addDestroyTask(() => {
        if (!this.isAlive()) {
          return;
        }
        gui.rowComp.addOrRemoveCssClass("ag-after-created", true);
      });
    }
    this.executeProcessRowPostCreateFunc();
  }
  setRowCompRowBusinessKey(comp) {
    if (this.businessKeySanitised == null) {
      return;
    }
    comp.setRowBusinessKey(this.businessKeySanitised);
  }
  getBusinessKey() {
    return this.businessKeySanitised;
  }
  setRowCompRowId(comp) {
    this.rowId = escapeString(this.rowNode.id);
    if (this.rowId == null) {
      return;
    }
    comp.setRowId(this.rowId);
  }
  executeSlideAndFadeAnimations(gui) {
    const { containerType } = gui;
    const shouldSlide = this.slideInAnimation[containerType];
    if (shouldSlide) {
      executeNextVMTurn(() => {
        this.onTopChanged();
      });
      this.slideInAnimation[containerType] = false;
    }
    const shouldFade = this.fadeInAnimation[containerType];
    if (shouldFade) {
      executeNextVMTurn(() => {
        gui.rowComp.addOrRemoveCssClass("ag-opacity-zero", false);
      });
      this.fadeInAnimation[containerType] = false;
    }
  }
  addRowDraggerToRow(gui) {
    if (this.gridOptionsService.get("enableRangeSelection")) {
      warnOnce("Setting `rowDragEntireRow: true` in the gridOptions doesn't work with `enableRangeSelection: true`");
      return;
    }
    const translate = this.beans.localeService.getLocaleTextFunc();
    const rowDragComp = new RowDragComp(
      () => `1 ${translate("rowDragRow", "row")}`,
      this.rowNode,
      void 0,
      gui.element,
      void 0,
      true
    );
    const rowDragBean = this.createBean(rowDragComp, this.beans.context);
    this.rowDragComps.push(rowDragBean);
  }
  setupFullWidth(gui) {
    const pinned = this.getPinnedForContainer(gui.containerType);
    if (this.rowType == "FullWidthDetail" /* FullWidthDetail */) {
      if (!ModuleRegistry.__assertRegistered("@ag-grid-enterprise/master-detail" /* MasterDetailModule */, "cell renderer 'agDetailCellRenderer' (for master detail)", this.beans.context.getGridId())) {
        return;
      }
    }
    const compDetails = this.createFullWidthCompDetails(gui.element, pinned);
    gui.rowComp.showFullWidth(compDetails);
  }
  isPrintLayout() {
    return this.printLayout;
  }
  getFullWidthCellRenderers() {
    var _a, _b;
    if (this.gridOptionsService.get("embedFullWidthRows")) {
      return this.allRowGuis.map((gui) => {
        var _a2;
        return (_a2 = gui == null ? void 0 : gui.rowComp) == null ? void 0 : _a2.getFullWidthCellRenderer();
      });
    }
    return [(_b = (_a = this.fullWidthGui) == null ? void 0 : _a.rowComp) == null ? void 0 : _b.getFullWidthCellRenderer()];
  }
  // use by autoWidthCalculator, as it clones the elements
  getCellElement(column) {
    const cellCtrl = this.getCellCtrl(column);
    return cellCtrl ? cellCtrl.getGui() : null;
  }
  executeProcessRowPostCreateFunc() {
    const func = this.gridOptionsService.getCallback("processRowPostCreate");
    if (!func || !this.areAllContainersReady()) {
      return;
    }
    const params = {
      // areAllContainersReady asserts that centerGui is not null
      eRow: this.centerGui.element,
      ePinnedLeftRow: this.leftGui ? this.leftGui.element : void 0,
      ePinnedRightRow: this.rightGui ? this.rightGui.element : void 0,
      node: this.rowNode,
      rowIndex: this.rowNode.rowIndex,
      addRenderedRowListener: this.addEventListener.bind(this)
    };
    func(params);
  }
  areAllContainersReady() {
    const isLeftReady = !!this.leftGui || !this.beans.columnModel.isPinningLeft();
    const isCenterReady = !!this.centerGui;
    const isRightReady = !!this.rightGui || !this.beans.columnModel.isPinningRight();
    return isLeftReady && isCenterReady && isRightReady;
  }
  setRowType() {
    const isStub = this.rowNode.stub;
    const isFullWidthCell = this.rowNode.isFullWidthCell();
    const isDetailCell = this.gridOptionsService.get("masterDetail") && this.rowNode.detail;
    const pivotMode = this.beans.columnModel.isPivotMode();
    const isGroupRow = !!this.rowNode.group && !this.rowNode.footer;
    const isFullWidthGroup = isGroupRow && this.gridOptionsService.isGroupUseEntireRow(pivotMode);
    if (isStub) {
      this.rowType = "FullWidthLoading" /* FullWidthLoading */;
    } else if (isDetailCell) {
      this.rowType = "FullWidthDetail" /* FullWidthDetail */;
    } else if (isFullWidthCell) {
      this.rowType = "FullWidth" /* FullWidth */;
    } else if (isFullWidthGroup) {
      this.rowType = "FullWidthGroup" /* FullWidthGroup */;
    } else {
      this.rowType = "Normal" /* Normal */;
    }
  }
  updat