/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.client;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.ml.client.MachineLearningClient;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.MLTask;
import org.opensearch.ml.common.ToolMetadata;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.InputHelper;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.agent.MLAgentDeleteAction;
import org.opensearch.ml.common.transport.agent.MLAgentDeleteRequest;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentAction;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentRequest;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentResponse;
import org.opensearch.ml.common.transport.connector.MLConnectorDeleteAction;
import org.opensearch.ml.common.transport.connector.MLConnectorDeleteRequest;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorAction;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorRequest;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorResponse;
import org.opensearch.ml.common.transport.deploy.MLDeployModelAction;
import org.opensearch.ml.common.transport.deploy.MLDeployModelRequest;
import org.opensearch.ml.common.transport.deploy.MLDeployModelResponse;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskAction;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskRequest;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskResponse;
import org.opensearch.ml.common.transport.model.MLModelDeleteAction;
import org.opensearch.ml.common.transport.model.MLModelDeleteRequest;
import org.opensearch.ml.common.transport.model.MLModelGetAction;
import org.opensearch.ml.common.transport.model.MLModelGetRequest;
import org.opensearch.ml.common.transport.model.MLModelGetResponse;
import org.opensearch.ml.common.transport.model.MLModelSearchAction;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupAction;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupRequest;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupResponse;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskRequest;
import org.opensearch.ml.common.transport.register.MLRegisterModelAction;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;
import org.opensearch.ml.common.transport.register.MLRegisterModelRequest;
import org.opensearch.ml.common.transport.register.MLRegisterModelResponse;
import org.opensearch.ml.common.transport.task.MLTaskDeleteAction;
import org.opensearch.ml.common.transport.task.MLTaskDeleteRequest;
import org.opensearch.ml.common.transport.task.MLTaskGetAction;
import org.opensearch.ml.common.transport.task.MLTaskGetRequest;
import org.opensearch.ml.common.transport.task.MLTaskGetResponse;
import org.opensearch.ml.common.transport.task.MLTaskSearchAction;
import org.opensearch.ml.common.transport.tools.MLGetToolAction;
import org.opensearch.ml.common.transport.tools.MLListToolsAction;
import org.opensearch.ml.common.transport.tools.MLToolGetRequest;
import org.opensearch.ml.common.transport.tools.MLToolGetResponse;
import org.opensearch.ml.common.transport.tools.MLToolsListRequest;
import org.opensearch.ml.common.transport.tools.MLToolsListResponse;
import org.opensearch.ml.common.transport.training.MLTrainingTaskAction;
import org.opensearch.ml.common.transport.training.MLTrainingTaskRequest;
import org.opensearch.ml.common.transport.trainpredict.MLTrainAndPredictionTaskAction;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsAction;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsRequest;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsResponse;

public class MachineLearningNodeClient
implements MachineLearningClient {
    private final Client client;

    @Override
    public void predict(String modelId, MLInput mlInput, ActionListener<MLOutput> listener) {
        this.validateMLInput(mlInput, true);
        MLPredictionTaskRequest predictionRequest = MLPredictionTaskRequest.builder().mlInput(mlInput).modelId(modelId).dispatchTask(true).build();
        this.client.execute((ActionType)MLPredictionTaskAction.INSTANCE, (ActionRequest)predictionRequest, this.getMlPredictionTaskResponseActionListener(listener));
    }

    @Override
    public void trainAndPredict(MLInput mlInput, ActionListener<MLOutput> listener) {
        this.validateMLInput(mlInput, true);
        MLTrainingTaskRequest request = MLTrainingTaskRequest.builder().mlInput(mlInput).dispatchTask(true).build();
        this.client.execute((ActionType)MLTrainAndPredictionTaskAction.INSTANCE, (ActionRequest)request, this.getMlPredictionTaskResponseActionListener(listener));
    }

    @Override
    public void train(MLInput mlInput, boolean asyncTask, ActionListener<MLOutput> listener) {
        this.validateMLInput(mlInput, true);
        MLTrainingTaskRequest trainingTaskRequest = MLTrainingTaskRequest.builder().mlInput(mlInput).async(asyncTask).dispatchTask(true).build();
        this.client.execute((ActionType)MLTrainingTaskAction.INSTANCE, (ActionRequest)trainingTaskRequest, this.getMlPredictionTaskResponseActionListener(listener));
    }

    @Override
    public void run(MLInput mlInput, Map<String, Object> args, ActionListener<MLOutput> listener) {
        String action = InputHelper.getAction(args);
        if (action == null) {
            throw new IllegalArgumentException("The parameter action is required.");
        }
        FunctionName functionName = InputHelper.getFunctionName(args);
        MLAlgoParams mlAlgoParams = InputHelper.convertArgumentToMLParameter(args, functionName);
        mlInput.setAlgorithm(functionName);
        mlInput.setParameters(mlAlgoParams);
        switch (action) {
            case "train": {
                boolean asyncTask = args.containsKey("async") ? (Boolean)args.get("async") : false;
                this.train(mlInput, asyncTask, listener);
                break;
            }
            case "predict": {
                String modelId = (String)args.get("modelid");
                if (modelId == null) {
                    throw new IllegalArgumentException("The model ID is required for prediction.");
                }
                this.predict(modelId, mlInput, listener);
                break;
            }
            case "trainandpredict": {
                this.trainAndPredict(mlInput, listener);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported action.");
            }
        }
    }

    @Override
    public void getModel(String modelId, ActionListener<MLModel> listener) {
        MLModelGetRequest mlModelGetRequest = MLModelGetRequest.builder().modelId(modelId).build();
        this.client.execute((ActionType)MLModelGetAction.INSTANCE, (ActionRequest)mlModelGetRequest, this.getMlGetModelResponseActionListener(listener));
    }

    private ActionListener<MLModelGetResponse> getMlGetModelResponseActionListener(ActionListener<MLModel> listener) {
        ActionListener internalListener = ActionListener.wrap(predictionResponse -> listener.onResponse((Object)predictionResponse.getMlModel()), arg_0 -> listener.onFailure(arg_0));
        ActionListener<MLModelGetResponse> actionListener = this.wrapActionListener(internalListener, res -> {
            MLModelGetResponse getResponse = MLModelGetResponse.fromActionResponse(res);
            return getResponse;
        });
        return actionListener;
    }

    @Override
    public void deleteModel(String modelId, ActionListener<DeleteResponse> listener) {
        MLModelDeleteRequest mlModelDeleteRequest = MLModelDeleteRequest.builder().modelId(modelId).build();
        this.client.execute((ActionType)MLModelDeleteAction.INSTANCE, (ActionRequest)mlModelDeleteRequest, ActionListener.wrap(deleteResponse -> listener.onResponse(deleteResponse), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void searchModel(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        this.client.execute((ActionType)MLModelSearchAction.INSTANCE, (ActionRequest)searchRequest, ActionListener.wrap(searchResponse -> listener.onResponse(searchResponse), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void registerModelGroup(MLRegisterModelGroupInput mlRegisterModelGroupInput, ActionListener<MLRegisterModelGroupResponse> listener) {
        MLRegisterModelGroupRequest mlRegisterModelGroupRequest = new MLRegisterModelGroupRequest(mlRegisterModelGroupInput);
        this.client.execute((ActionType)MLRegisterModelGroupAction.INSTANCE, (ActionRequest)mlRegisterModelGroupRequest, this.getMlRegisterModelGroupResponseActionListener(listener));
    }

    @Override
    public void execute(FunctionName name, Input input, ActionListener<MLExecuteTaskResponse> listener) {
        MLExecuteTaskRequest mlExecuteTaskRequest = new MLExecuteTaskRequest(name, input);
        this.client.execute((ActionType)MLExecuteTaskAction.INSTANCE, (ActionRequest)mlExecuteTaskRequest, listener);
    }

    @Override
    public void getTask(String taskId, ActionListener<MLTask> listener) {
        MLTaskGetRequest mlTaskGetRequest = MLTaskGetRequest.builder().taskId(taskId).build();
        this.client.execute((ActionType)MLTaskGetAction.INSTANCE, (ActionRequest)mlTaskGetRequest, this.getMLTaskResponseActionListener(listener));
    }

    @Override
    public void deleteTask(String taskId, ActionListener<DeleteResponse> listener) {
        MLTaskDeleteRequest mlTaskDeleteRequest = MLTaskDeleteRequest.builder().taskId(taskId).build();
        this.client.execute((ActionType)MLTaskDeleteAction.INSTANCE, (ActionRequest)mlTaskDeleteRequest, ActionListener.wrap(deleteResponse -> listener.onResponse(deleteResponse), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void searchTask(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        this.client.execute((ActionType)MLTaskSearchAction.INSTANCE, (ActionRequest)searchRequest, ActionListener.wrap(searchResponse -> listener.onResponse(searchResponse), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void register(MLRegisterModelInput mlInput, ActionListener<MLRegisterModelResponse> listener) {
        MLRegisterModelRequest registerRequest = new MLRegisterModelRequest(mlInput);
        this.client.execute((ActionType)MLRegisterModelAction.INSTANCE, (ActionRequest)registerRequest, this.getMLRegisterModelResponseActionListener(listener));
    }

    @Override
    public void deploy(String modelId, ActionListener<MLDeployModelResponse> listener) {
        MLDeployModelRequest deployModelRequest = new MLDeployModelRequest(modelId, false);
        this.client.execute((ActionType)MLDeployModelAction.INSTANCE, (ActionRequest)deployModelRequest, this.getMlDeployModelResponseActionListener(listener));
    }

    @Override
    public void undeploy(String[] modelIds, String[] nodeIds, ActionListener<MLUndeployModelsResponse> listener) {
        MLUndeployModelsRequest undeployModelRequest = new MLUndeployModelsRequest(modelIds, nodeIds);
        this.client.execute((ActionType)MLUndeployModelsAction.INSTANCE, (ActionRequest)undeployModelRequest, this.getMlUndeployModelsResponseActionListener(listener));
    }

    @Override
    public void createConnector(MLCreateConnectorInput mlCreateConnectorInput, ActionListener<MLCreateConnectorResponse> listener) {
        MLCreateConnectorRequest createConnectorRequest = new MLCreateConnectorRequest(mlCreateConnectorInput);
        this.client.execute((ActionType)MLCreateConnectorAction.INSTANCE, (ActionRequest)createConnectorRequest, this.getMlCreateConnectorResponseActionListener(listener));
    }

    @Override
    public void deleteConnector(String connectorId, ActionListener<DeleteResponse> listener) {
        MLConnectorDeleteRequest connectorDeleteRequest = new MLConnectorDeleteRequest(connectorId);
        this.client.execute((ActionType)MLConnectorDeleteAction.INSTANCE, (ActionRequest)connectorDeleteRequest, ActionListener.wrap(deleteResponse -> listener.onResponse(deleteResponse), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void registerAgent(MLAgent mlAgent, ActionListener<MLRegisterAgentResponse> listener) {
        MLRegisterAgentRequest mlRegisterAgentRequest = MLRegisterAgentRequest.builder().mlAgent(mlAgent).build();
        this.client.execute((ActionType)MLRegisterAgentAction.INSTANCE, (ActionRequest)mlRegisterAgentRequest, this.getMLRegisterAgentResponseActionListener(listener));
    }

    @Override
    public void deleteAgent(String agentId, ActionListener<DeleteResponse> listener) {
        MLAgentDeleteRequest agentDeleteRequest = new MLAgentDeleteRequest(agentId);
        this.client.execute((ActionType)MLAgentDeleteAction.INSTANCE, (ActionRequest)agentDeleteRequest, ActionListener.wrap(deleteResponse -> listener.onResponse(deleteResponse), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void listTools(ActionListener<List<ToolMetadata>> listener) {
        MLToolsListRequest mlToolsListRequest = MLToolsListRequest.builder().build();
        this.client.execute((ActionType)MLListToolsAction.INSTANCE, (ActionRequest)mlToolsListRequest, this.getMlListToolsResponseActionListener(listener));
    }

    @Override
    public void getTool(String toolName, ActionListener<ToolMetadata> listener) {
        MLToolGetRequest mlToolGetRequest = MLToolGetRequest.builder().toolName(toolName).build();
        this.client.execute((ActionType)MLGetToolAction.INSTANCE, (ActionRequest)mlToolGetRequest, this.getMlGetToolResponseActionListener(listener));
    }

    private ActionListener<MLToolsListResponse> getMlListToolsResponseActionListener(ActionListener<List<ToolMetadata>> listener) {
        ActionListener internalListener = ActionListener.wrap(mlModelListResponse -> listener.onResponse(mlModelListResponse.getToolMetadataList()), arg_0 -> listener.onFailure(arg_0));
        ActionListener<MLToolsListResponse> actionListener = this.wrapActionListener(internalListener, res -> {
            MLToolsListResponse getResponse = MLToolsListResponse.fromActionResponse(res);
            return getResponse;
        });
        return actionListener;
    }

    private ActionListener<MLToolGetResponse> getMlGetToolResponseActionListener(ActionListener<ToolMetadata> listener) {
        ActionListener internalListener = ActionListener.wrap(mlModelGetResponse -> listener.onResponse((Object)mlModelGetResponse.getToolMetadata()), arg_0 -> listener.onFailure(arg_0));
        ActionListener<MLToolGetResponse> actionListener = this.wrapActionListener(internalListener, res -> {
            MLToolGetResponse getResponse = MLToolGetResponse.fromActionResponse(res);
            return getResponse;
        });
        return actionListener;
    }

    private ActionListener<MLRegisterAgentResponse> getMLRegisterAgentResponseActionListener(ActionListener<MLRegisterAgentResponse> listener) {
        ActionListener<MLRegisterAgentResponse> actionListener = this.wrapActionListener(listener, res -> {
            MLRegisterAgentResponse mlRegisterAgentResponse = MLRegisterAgentResponse.fromActionResponse(res);
            return mlRegisterAgentResponse;
        });
        return actionListener;
    }

    private ActionListener<MLTaskGetResponse> getMLTaskResponseActionListener(ActionListener<MLTask> listener) {
        ActionListener internalListener = ActionListener.wrap(getResponse -> listener.onResponse((Object)getResponse.getMlTask()), arg_0 -> listener.onFailure(arg_0));
        ActionListener<MLTaskGetResponse> actionListener = this.wrapActionListener(internalListener, response -> {
            MLTaskGetResponse getResponse = MLTaskGetResponse.fromActionResponse(response);
            return getResponse;
        });
        return actionListener;
    }

    private ActionListener<MLDeployModelResponse> getMlDeployModelResponseActionListener(ActionListener<MLDeployModelResponse> listener) {
        ActionListener<MLDeployModelResponse> actionListener = this.wrapActionListener(listener, response -> {
            MLDeployModelResponse deployModelResponse = MLDeployModelResponse.fromActionResponse(response);
            return deployModelResponse;
        });
        return actionListener;
    }

    private ActionListener<MLUndeployModelsResponse> getMlUndeployModelsResponseActionListener(ActionListener<MLUndeployModelsResponse> listener) {
        ActionListener<MLUndeployModelsResponse> actionListener = this.wrapActionListener(listener, response -> {
            MLUndeployModelsResponse deployModelResponse = MLUndeployModelsResponse.fromActionResponse(response);
            return deployModelResponse;
        });
        return actionListener;
    }

    private ActionListener<MLCreateConnectorResponse> getMlCreateConnectorResponseActionListener(ActionListener<MLCreateConnectorResponse> listener) {
        ActionListener<MLCreateConnectorResponse> actionListener = this.wrapActionListener(listener, response -> {
            MLCreateConnectorResponse createConnectorResponse = MLCreateConnectorResponse.fromActionResponse(response);
            return createConnectorResponse;
        });
        return actionListener;
    }

    private ActionListener<MLRegisterModelGroupResponse> getMlRegisterModelGroupResponseActionListener(ActionListener<MLRegisterModelGroupResponse> listener) {
        ActionListener<MLRegisterModelGroupResponse> actionListener = this.wrapActionListener(listener, response -> {
            MLRegisterModelGroupResponse registerModelGroupResponse = MLRegisterModelGroupResponse.fromActionResponse(response);
            return registerModelGroupResponse;
        });
        return actionListener;
    }

    private ActionListener<MLTaskResponse> getMlPredictionTaskResponseActionListener(ActionListener<MLOutput> listener) {
        ActionListener internalListener = ActionListener.wrap(predictionResponse -> listener.onResponse((Object)predictionResponse.getOutput()), arg_0 -> listener.onFailure(arg_0));
        ActionListener<MLTaskResponse> actionListener = this.wrapActionListener(internalListener, res -> {
            MLTaskResponse predictionResponse = MLTaskResponse.fromActionResponse(res);
            return predictionResponse;
        });
        return actionListener;
    }

    private ActionListener<MLRegisterModelResponse> getMLRegisterModelResponseActionListener(ActionListener<MLRegisterModelResponse> listener) {
        ActionListener<MLRegisterModelResponse> actionListener = this.wrapActionListener(listener, res -> {
            MLRegisterModelResponse registerModelResponse = MLRegisterModelResponse.fromActionResponse(res);
            return registerModelResponse;
        });
        return actionListener;
    }

    private <T extends ActionResponse> ActionListener<T> wrapActionListener(ActionListener<T> listener, Function<ActionResponse, T> recreate) {
        ActionListener actionListener = ActionListener.wrap(r -> listener.onResponse((Object)((ActionResponse)recreate.apply((ActionResponse)r))), e -> listener.onFailure(e));
        return actionListener;
    }

    private void validateMLInput(MLInput mlInput, boolean requireInput) {
        if (mlInput == null) {
            throw new IllegalArgumentException("ML Input can't be null");
        }
        if (requireInput && mlInput.getInputDataset() == null) {
            throw new IllegalArgumentException("input data set can't be null");
        }
    }

    @Generated
    public MachineLearningNodeClient(Client client) {
        this.client = client;
    }
}

