/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MLDeploySetting
implements ToXContentObject,
Writeable {
    public static final String IS_AUTO_DEPLOY_ENABLED_FIELD = "is_auto_deploy_enabled";
    public static final String MODEL_TTL_MINUTES_FIELD = "model_ttl_minutes";
    private static final long DEFAULT_TTL_MINUTES = -1L;
    public static final Version MINIMAL_SUPPORTED_VERSION_FOR_MODEL_TTL = Version.V_2_14_0;
    private Boolean isAutoDeployEnabled;
    private Long modelTTLInMinutes;

    public MLDeploySetting(Boolean isAutoDeployEnabled, Long modelTTLInMinutes) {
        this.isAutoDeployEnabled = isAutoDeployEnabled;
        this.modelTTLInMinutes = modelTTLInMinutes;
        if (modelTTLInMinutes == null) {
            this.modelTTLInMinutes = -1L;
        }
    }

    public MLDeploySetting(StreamInput in) throws IOException {
        this.isAutoDeployEnabled = in.readOptionalBoolean();
        Version streamInputVersion = in.getVersion();
        if (streamInputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_MODEL_TTL)) {
            this.modelTTLInMinutes = in.readOptionalLong();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalBoolean(this.isAutoDeployEnabled);
        if (streamOutputVersion.onOrAfter(MINIMAL_SUPPORTED_VERSION_FOR_MODEL_TTL)) {
            out.writeOptionalLong(this.modelTTLInMinutes);
        }
    }

    public static MLDeploySetting parse(XContentParser parser) throws IOException {
        Boolean isAutoDeployEnabled = null;
        Long modelTTLMinutes = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "is_auto_deploy_enabled": {
                    isAutoDeployEnabled = parser.booleanValue();
                    continue block8;
                }
                case "model_ttl_minutes": {
                    modelTTLMinutes = parser.longValue();
                }
            }
            parser.skipChildren();
        }
        return new MLDeploySetting(isAutoDeployEnabled, modelTTLMinutes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.isAutoDeployEnabled != null) {
            builder.field(IS_AUTO_DEPLOY_ENABLED_FIELD, this.isAutoDeployEnabled);
        }
        if (this.modelTTLInMinutes != null) {
            builder.field(MODEL_TTL_MINUTES_FIELD, this.modelTTLInMinutes);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public static MLDeploySettingBuilder builder() {
        return new MLDeploySettingBuilder();
    }

    @Generated
    public MLDeploySettingBuilder toBuilder() {
        return new MLDeploySettingBuilder().isAutoDeployEnabled(this.isAutoDeployEnabled).modelTTLInMinutes(this.modelTTLInMinutes);
    }

    @Generated
    public void setIsAutoDeployEnabled(Boolean isAutoDeployEnabled) {
        this.isAutoDeployEnabled = isAutoDeployEnabled;
    }

    @Generated
    public void setModelTTLInMinutes(Long modelTTLInMinutes) {
        this.modelTTLInMinutes = modelTTLInMinutes;
    }

    @Generated
    public Boolean getIsAutoDeployEnabled() {
        return this.isAutoDeployEnabled;
    }

    @Generated
    public Long getModelTTLInMinutes() {
        return this.modelTTLInMinutes;
    }

    @Generated
    public static class MLDeploySettingBuilder {
        @Generated
        private Boolean isAutoDeployEnabled;
        @Generated
        private Long modelTTLInMinutes;

        @Generated
        MLDeploySettingBuilder() {
        }

        @Generated
        public MLDeploySettingBuilder isAutoDeployEnabled(Boolean isAutoDeployEnabled) {
            this.isAutoDeployEnabled = isAutoDeployEnabled;
            return this;
        }

        @Generated
        public MLDeploySettingBuilder modelTTLInMinutes(Long modelTTLInMinutes) {
            this.modelTTLInMinutes = modelTTLInMinutes;
            return this;
        }

        @Generated
        public MLDeploySetting build() {
            return new MLDeploySetting(this.isAutoDeployEnabled, this.modelTTLInMinutes);
        }

        @Generated
        public String toString() {
            return "MLDeploySetting.MLDeploySettingBuilder(isAutoDeployEnabled=" + this.isAutoDeployEnabled + ", modelTTLInMinutes=" + this.modelTTLInMinutes + ")";
        }
    }
}

