/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformLoggingMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class Diagnostics {
    private static final String PACKAGE = "org.apache.tomcat.util";
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    private static final String INDENT1 = "  ";
    private static final String INDENT2 = "\t";
    private static final String INDENT3 = "   ";
    private static final String CRLF = "\r\n";
    private static final String vminfoSystemProperty = "java.vm.info";
    private static final Log log = LogFactory.getLog(Diagnostics.class);
    private static final SimpleDateFormat timeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private static final CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
    private static final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private static final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final PlatformLoggingMXBean loggingMXBean = ManagementFactory.getPlatformMXBean(PlatformLoggingMXBean.class);
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static final List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private static final List<MemoryManagerMXBean> memoryManagerMXBeans = ManagementFactory.getMemoryManagerMXBeans();
    private static final List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();

    public static boolean isThreadContentionMonitoringEnabled() {
        return threadMXBean.isThreadContentionMonitoringEnabled();
    }

    public static void setThreadContentionMonitoringEnabled(boolean bl) {
        threadMXBean.setThreadContentionMonitoringEnabled(bl);
        boolean bl2 = threadMXBean.isThreadContentionMonitoringEnabled();
        if (bl != bl2) {
            log.error((Object)sm.getString("diagnostics.setPropertyFail", "threadContentionMonitoringEnabled", bl, bl2));
        }
    }

    public static boolean isThreadCpuTimeEnabled() {
        return threadMXBean.isThreadCpuTimeEnabled();
    }

    public static void setThreadCpuTimeEnabled(boolean bl) {
        threadMXBean.setThreadCpuTimeEnabled(bl);
        boolean bl2 = threadMXBean.isThreadCpuTimeEnabled();
        if (bl != bl2) {
            log.error((Object)sm.getString("diagnostics.setPropertyFail", "threadCpuTimeEnabled", bl, bl2));
        }
    }

    public static void resetPeakThreadCount() {
        threadMXBean.resetPeakThreadCount();
    }

    public static void setVerboseClassLoading(boolean bl) {
        classLoadingMXBean.setVerbose(bl);
        boolean bl2 = classLoadingMXBean.isVerbose();
        if (bl != bl2) {
            log.error((Object)sm.getString("diagnostics.setPropertyFail", "verboseClassLoading", bl, bl2));
        }
    }

    public static void setLoggerLevel(String string, String string2) {
        loggingMXBean.setLoggerLevel(string, string2);
        String string3 = loggingMXBean.getLoggerLevel(string);
        if (!string3.equals(string2)) {
            String string4 = "loggerLevel[" + string + "]";
            log.error((Object)sm.getString("diagnostics.setPropertyFail", string4, string2, string3));
        }
    }

    public static void setVerboseGarbageCollection(boolean bl) {
        memoryMXBean.setVerbose(bl);
        boolean bl2 = memoryMXBean.isVerbose();
        if (bl != bl2) {
            log.error((Object)sm.getString("diagnostics.setPropertyFail", "verboseGarbageCollection", bl, bl2));
        }
    }

    public static void gc() {
        memoryMXBean.gc();
    }

    public static void resetPeakUsage(String string) {
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            if (!string.equals("all") && !string.equals(memoryPoolMXBean.getName())) continue;
            memoryPoolMXBean.resetPeakUsage();
        }
    }

    public static boolean setUsageThreshold(String string, long l) {
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            if (!string.equals(memoryPoolMXBean.getName())) continue;
            try {
                memoryPoolMXBean.setUsageThreshold(l);
                return true;
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                return false;
            }
        }
        return false;
    }

    public static boolean setCollectionUsageThreshold(String string, long l) {
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            if (!string.equals(memoryPoolMXBean.getName())) continue;
            try {
                memoryPoolMXBean.setCollectionUsageThreshold(l);
                return true;
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                return false;
            }
        }
        return false;
    }

    private static String getThreadDumpHeader(ThreadInfo threadInfo) {
        StringBuilder stringBuilder = new StringBuilder("\"" + threadInfo.getThreadName() + "\"");
        stringBuilder.append(" Id=" + threadInfo.getThreadId());
        stringBuilder.append(" cpu=" + threadMXBean.getThreadCpuTime(threadInfo.getThreadId()) + " ns");
        stringBuilder.append(" usr=" + threadMXBean.getThreadUserTime(threadInfo.getThreadId()) + " ns");
        stringBuilder.append(" blocked " + threadInfo.getBlockedCount() + " for " + threadInfo.getBlockedTime() + " ms");
        stringBuilder.append(" waited " + threadInfo.getWaitedCount() + " for " + threadInfo.getWaitedTime() + " ms");
        if (threadInfo.isSuspended()) {
            stringBuilder.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            stringBuilder.append(" (running in native)");
        }
        stringBuilder.append(CRLF);
        stringBuilder.append("   java.lang.Thread.State: " + (Object)((Object)threadInfo.getThreadState()));
        stringBuilder.append(CRLF);
        return stringBuilder.toString();
    }

    private static String getThreadDump(ThreadInfo threadInfo) {
        MonitorInfo[] monitorInfoArray;
        StringBuilder stringBuilder = new StringBuilder(Diagnostics.getThreadDumpHeader(threadInfo));
        for (LockInfo monitorInfoArray2 : threadInfo.getLockedSynchronizers()) {
            stringBuilder.append("\tlocks " + monitorInfoArray2.toString() + CRLF);
        }
        boolean bl = true;
        StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
        Object[] objectArray = new Object[stackTraceElementArray.length];
        for (MonitorInfo monitorInfo : monitorInfoArray = threadInfo.getLockedMonitors()) {
            objectArray[monitorInfo.getLockedStackDepth()] = monitorInfo;
        }
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            stringBuilder.append("\tat " + stackTraceElement.toString() + CRLF);
            if (bl) {
                if (threadInfo.getLockName() != null) {
                    stringBuilder.append("\t- waiting on (a " + threadInfo.getLockName() + ")");
                    if (threadInfo.getLockOwnerName() != null) {
                        stringBuilder.append(" owned by " + threadInfo.getLockOwnerName() + " Id=" + threadInfo.getLockOwnerId());
                    }
                    stringBuilder.append(CRLF);
                }
                bl = false;
            }
            if (objectArray[i] == null) continue;
            MonitorInfo monitorInfo = (MonitorInfo)objectArray[i];
            stringBuilder.append("\t- locked (a " + monitorInfo.toString() + ") index " + monitorInfo.getLockedStackDepth() + " frame " + monitorInfo.getLockedStackFrame().toString());
            stringBuilder.append(CRLF);
        }
        return stringBuilder.toString();
    }

    private static String getThreadDump(ThreadInfo[] threadInfoArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ThreadInfo threadInfo : threadInfoArray) {
            stringBuilder.append(Diagnostics.getThreadDump(threadInfo));
            stringBuilder.append(CRLF);
        }
        return stringBuilder.toString();
    }

    public static String findDeadlock() {
        ThreadInfo[] threadInfoArray = null;
        long[] lArray = threadMXBean.findDeadlockedThreads();
        if (lArray != null && (threadInfoArray = threadMXBean.getThreadInfo(threadMXBean.findDeadlockedThreads(), true, true)) != null) {
            StringBuilder stringBuilder = new StringBuilder(sm.getString("diagnostics.deadlockFound"));
            stringBuilder.append(CRLF);
            stringBuilder.append(Diagnostics.getThreadDump(threadInfoArray));
            return stringBuilder.toString();
        }
        return "";
    }

    public static String getThreadDump() {
        return Diagnostics.getThreadDump(sm);
    }

    public static String getThreadDump(Enumeration<Locale> enumeration) {
        return Diagnostics.getThreadDump(StringManager.getManager(PACKAGE, enumeration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getThreadDump(StringManager stringManager) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = timeformat;
        synchronized (object) {
            stringBuilder.append(timeformat.format(new Date()));
        }
        stringBuilder.append(CRLF);
        stringBuilder.append(stringManager.getString("diagnostics.threadDumpTitle"));
        stringBuilder.append(' ');
        stringBuilder.append(runtimeMXBean.getVmName());
        stringBuilder.append(" (");
        stringBuilder.append(runtimeMXBean.getVmVersion());
        object = System.getProperty(vminfoSystemProperty);
        if (object != null) {
            stringBuilder.append(" " + (String)object);
        }
        stringBuilder.append("):\r\n");
        stringBuilder.append(CRLF);
        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(true, true);
        stringBuilder.append(Diagnostics.getThreadDump(threadInfoArray));
        stringBuilder.append(Diagnostics.findDeadlock());
        return stringBuilder.toString();
    }

    private static String formatMemoryUsage(String string, MemoryUsage memoryUsage) {
        if (memoryUsage != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(INDENT1 + string + " init: " + memoryUsage.getInit() + CRLF);
            stringBuilder.append(INDENT1 + string + " used: " + memoryUsage.getUsed() + CRLF);
            stringBuilder.append(INDENT1 + string + " committed: " + memoryUsage.getCommitted() + CRLF);
            stringBuilder.append(INDENT1 + string + " max: " + memoryUsage.getMax() + CRLF);
            return stringBuilder.toString();
        }
        return "";
    }

    public static String getVMInfo() {
        return Diagnostics.getVMInfo(sm);
    }

    public static String getVMInfo(Enumeration<Locale> enumeration) {
        return Diagnostics.getVMInfo(StringManager.getManager(PACKAGE, enumeration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVMInfo(StringManager stringManager) {
        Object object5;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        Object object3 = timeformat;
        synchronized (object3) {
            stringBuilder.append(timeformat.format(new Date()));
        }
        stringBuilder.append(CRLF);
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoRuntime"));
        stringBuilder.append(":\r\n");
        stringBuilder.append("  vmName: " + runtimeMXBean.getVmName() + CRLF);
        stringBuilder.append("  vmVersion: " + runtimeMXBean.getVmVersion() + CRLF);
        stringBuilder.append("  vmVendor: " + runtimeMXBean.getVmVendor() + CRLF);
        stringBuilder.append("  specName: " + runtimeMXBean.getSpecName() + CRLF);
        stringBuilder.append("  specVersion: " + runtimeMXBean.getSpecVersion() + CRLF);
        stringBuilder.append("  specVendor: " + runtimeMXBean.getSpecVendor() + CRLF);
        stringBuilder.append("  managementSpecVersion: " + runtimeMXBean.getManagementSpecVersion() + CRLF);
        stringBuilder.append("  name: " + runtimeMXBean.getName() + CRLF);
        stringBuilder.append("  startTime: " + runtimeMXBean.getStartTime() + CRLF);
        stringBuilder.append("  uptime: " + runtimeMXBean.getUptime() + CRLF);
        stringBuilder.append("  isBootClassPathSupported: " + runtimeMXBean.isBootClassPathSupported() + CRLF);
        stringBuilder.append(CRLF);
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoOs"));
        stringBuilder.append(":\r\n");
        stringBuilder.append("  name: " + operatingSystemMXBean.getName() + CRLF);
        stringBuilder.append("  version: " + operatingSystemMXBean.getVersion() + CRLF);
        stringBuilder.append("  architecture: " + operatingSystemMXBean.getArch() + CRLF);
        stringBuilder.append("  availableProcessors: " + operatingSystemMXBean.getAvailableProcessors() + CRLF);
        stringBuilder.append("  systemLoadAverage: " + operatingSystemMXBean.getSystemLoadAverage() + CRLF);
        stringBuilder.append(CRLF);
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoThreadMxBean"));
        stringBuilder.append(":\r\n");
        stringBuilder.append("  isCurrentThreadCpuTimeSupported: " + threadMXBean.isCurrentThreadCpuTimeSupported() + CRLF);
        stringBuilder.append("  isThreadCpuTimeSupported: " + threadMXBean.isThreadCpuTimeSupported() + CRLF);
        stringBuilder.append("  isThreadCpuTimeEnabled: " + threadMXBean.isThreadCpuTimeEnabled() + CRLF);
        stringBuilder.append("  isObjectMonitorUsageSupported: " + threadMXBean.isObjectMonitorUsageSupported() + CRLF);
        stringBuilder.append("  isSynchronizerUsageSupported: " + threadMXBean.isSynchronizerUsageSupported() + CRLF);
        stringBuilder.append("  isThreadContentionMonitoringSupported: " + threadMXBean.isThreadContentionMonitoringSupported() + CRLF);
        stringBuilder.append("  isThreadContentionMonitoringEnabled: " + threadMXBean.isThreadContentionMonitoringEnabled() + CRLF);
        stringBuilder.append(CRLF);
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoThreadCounts"));
        stringBuilder.append(":\r\n");
        stringBuilder.append("  daemon: " + threadMXBean.getDaemonThreadCount() + CRLF);
        stringBuilder.append("  total: " + threadMXBean.getThreadCount() + CRLF);
        stringBuilder.append("  peak: " + threadMXBean.getPeakThreadCount() + CRLF);
        stringBuilder.append("  totalStarted: " + threadMXBean.getTotalStartedThreadCount() + CRLF);
        stringBuilder.append(CRLF);
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoStartup"));
        stringBuilder.append(":\r\n");
        for (String arrayList2 : runtimeMXBean.getInputArguments()) {
            stringBuilder.append(INDENT1 + arrayList2 + CRLF);
        }
        stringBuilder.append(CRLF);
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoPath"));
        stringBuilder.append(":\r\n");
        if (runtimeMXBean.isBootClassPathSupported()) {
            stringBuilder.append("  bootClassPath: " + runtimeMXBean.getBootClassPath() + CRLF);
        }
        stringBuilder.append("  classPath: " + runtimeMXBean.getClassPath() + CRLF);
        stringBuilder.append("  libraryPath: " + runtimeMXBean.getLibraryPath() + CRLF);
        stringBuilder.append(CRLF);
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoClassLoading"));
        stringBuilder.append(":\r\n");
        stringBuilder.append("  loaded: " + classLoadingMXBean.getLoadedClassCount() + CRLF);
        stringBuilder.append("  unloaded: " + classLoadingMXBean.getUnloadedClassCount() + CRLF);
        stringBuilder.append("  totalLoaded: " + classLoadingMXBean.getTotalLoadedClassCount() + CRLF);
        stringBuilder.append("  isVerbose: " + classLoadingMXBean.isVerbose() + CRLF);
        stringBuilder.append(CRLF);
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoClassCompilation"));
        stringBuilder.append(":\r\n");
        stringBuilder.append("  name: " + compilationMXBean.getName() + CRLF);
        stringBuilder.append("  totalCompilationTime: " + compilationMXBean.getTotalCompilationTime() + CRLF);
        stringBuilder.append("  isCompilationTimeMonitoringSupported: " + compilationMXBean.isCompilationTimeMonitoringSupported() + CRLF);
        stringBuilder.append(CRLF);
        for (MemoryManagerMXBean memoryManagerMXBean : memoryManagerMXBeans) {
            stringBuilder.append(stringManager.getString("diagnostics.vmInfoMemoryManagers", memoryManagerMXBean.getName()));
            stringBuilder.append(":\r\n");
            stringBuilder.append("  isValid: " + memoryManagerMXBean.isValid() + CRLF);
            stringBuilder.append("  mbean.getMemoryPoolNames: \r\n");
            object2 = memoryManagerMXBean.getMemoryPoolNames();
            Arrays.sort((Object[])object2);
            for (Object object4 : object2) {
                stringBuilder.append(INDENT2 + (String)object4 + CRLF);
            }
            stringBuilder.append(CRLF);
        }
        for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMXBeans) {
            stringBuilder.append(stringManager.getString("diagnostics.vmInfoGarbageCollectors", garbageCollectorMXBean.getName()));
            stringBuilder.append(":\r\n");
            stringBuilder.append("  isValid: " + garbageCollectorMXBean.isValid() + CRLF);
            stringBuilder.append("  mbean.getMemoryPoolNames: \r\n");
            object2 = garbageCollectorMXBean.getMemoryPoolNames();
            Arrays.sort((Object[])object2);
            for (Object object4 : object2) {
                stringBuilder.append(INDENT2 + (String)object4 + CRLF);
            }
            stringBuilder.append("  getCollectionCount: " + garbageCollectorMXBean.getCollectionCount() + CRLF);
            stringBuilder.append("  getCollectionTime: " + garbageCollectorMXBean.getCollectionTime() + CRLF);
            stringBuilder.append(CRLF);
        }
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoMemory"));
        stringBuilder.append(":\r\n");
        stringBuilder.append("  isVerbose: " + memoryMXBean.isVerbose() + CRLF);
        stringBuilder.append("  getObjectPendingFinalizationCount: " + memoryMXBean.getObjectPendingFinalizationCount() + CRLF);
        stringBuilder.append(Diagnostics.formatMemoryUsage("heap", memoryMXBean.getHeapMemoryUsage()));
        stringBuilder.append(Diagnostics.formatMemoryUsage("non-heap", memoryMXBean.getNonHeapMemoryUsage()));
        stringBuilder.append(CRLF);
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            stringBuilder.append(stringManager.getString("diagnostics.vmInfoMemoryPools", memoryPoolMXBean.getName()));
            stringBuilder.append(":\r\n");
            stringBuilder.append("  isValid: " + memoryPoolMXBean.isValid() + CRLF);
            stringBuilder.append("  getType: " + (Object)((Object)memoryPoolMXBean.getType()) + CRLF);
            stringBuilder.append("  mbean.getMemoryManagerNames: \r\n");
            object2 = memoryPoolMXBean.getMemoryManagerNames();
            Arrays.sort((Object[])object2);
            for (Object object4 : object2) {
                stringBuilder.append(INDENT2 + (String)object4 + CRLF);
            }
            stringBuilder.append("  isUsageThresholdSupported: " + memoryPoolMXBean.isUsageThresholdSupported() + CRLF);
            try {
                stringBuilder.append("  isUsageThresholdExceeded: " + memoryPoolMXBean.isUsageThresholdExceeded() + CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            stringBuilder.append("  isCollectionUsageThresholdSupported: " + memoryPoolMXBean.isCollectionUsageThresholdSupported() + CRLF);
            try {
                stringBuilder.append("  isCollectionUsageThresholdExceeded: " + memoryPoolMXBean.isCollectionUsageThresholdExceeded() + CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                stringBuilder.append("  getUsageThreshold: " + memoryPoolMXBean.getUsageThreshold() + CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                stringBuilder.append("  getUsageThresholdCount: " + memoryPoolMXBean.getUsageThresholdCount() + CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                stringBuilder.append("  getCollectionUsageThreshold: " + memoryPoolMXBean.getCollectionUsageThreshold() + CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                stringBuilder.append("  getCollectionUsageThresholdCount: " + memoryPoolMXBean.getCollectionUsageThresholdCount() + CRLF);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            stringBuilder.append(Diagnostics.formatMemoryUsage("current", memoryPoolMXBean.getUsage()));
            stringBuilder.append(Diagnostics.formatMemoryUsage("collection", memoryPoolMXBean.getCollectionUsage()));
            stringBuilder.append(Diagnostics.formatMemoryUsage("peak", memoryPoolMXBean.getPeakUsage()));
            stringBuilder.append(CRLF);
        }
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoSystem"));
        stringBuilder.append(":\r\n");
        object3 = runtimeMXBean.getSystemProperties();
        ArrayList arrayList = new ArrayList(object3.keySet());
        Collections.sort(arrayList);
        for (Object object5 : arrayList) {
            stringBuilder.append(INDENT1 + (String)object5 + ": " + (String)object3.get(object5) + CRLF);
        }
        stringBuilder.append(CRLF);
        stringBuilder.append(stringManager.getString("diagnostics.vmInfoLogger"));
        stringBuilder.append(":\r\n");
        object2 = loggingMXBean.getLoggerNames();
        Collections.sort(object2);
        object5 = object2.iterator();
        while (object5.hasNext()) {
            String string = (String)object5.next();
            stringBuilder.append(INDENT1 + string + ": level=" + loggingMXBean.getLoggerLevel(string) + ", parent=" + loggingMXBean.getParentLoggerName(string) + CRLF);
        }
        stringBuilder.append(CRLF);
        return stringBuilder.toString();
    }
}

