/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.EncodedSolidusHandling;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

public final class UDecoder {
    private static final StringManager sm = StringManager.getManager(UDecoder.class);
    @Deprecated
    public static final boolean ALLOW_ENCODED_SLASH = Boolean.parseBoolean(System.getProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "false"));
    private static final IOException EXCEPTION_EOF = new DecodeException(sm.getString("uDecoder.eof"));
    private static final IOException EXCEPTION_NOT_HEX_DIGIT = new DecodeException(sm.getString("uDecoder.isHexDigit"));
    private static final IOException EXCEPTION_SLASH = new DecodeException(sm.getString("uDecoder.noSlash"));

    public void convert(ByteChunk byteChunk, boolean bl) throws IOException {
        if (bl) {
            this.convert(byteChunk, true, EncodedSolidusHandling.DECODE);
        } else {
            this.convert(byteChunk, false, EncodedSolidusHandling.REJECT);
        }
    }

    public void convert(ByteChunk byteChunk, EncodedSolidusHandling encodedSolidusHandling) throws IOException {
        this.convert(byteChunk, false, encodedSolidusHandling);
    }

    private void convert(ByteChunk byteChunk, boolean bl, EncodedSolidusHandling encodedSolidusHandling) throws IOException {
        int n = byteChunk.getStart();
        byte[] byArray = byteChunk.getBytes();
        int n2 = byteChunk.getEnd();
        int n3 = ByteChunk.findByte(byArray, n, n2, (byte)37);
        int n4 = -1;
        if (bl) {
            n4 = ByteChunk.findByte(byArray, n, n3 >= 0 ? n3 : n2, (byte)43);
        }
        if (n3 < 0 && n4 < 0) {
            return;
        }
        if (n4 >= 0 && n4 < n3 || n3 < 0) {
            n3 = n4;
        }
        int n5 = n3;
        while (n5 < n2) {
            if (byArray[n5] == 43 && bl) {
                byArray[n3] = 32;
            } else if (byArray[n5] != 37) {
                byArray[n3] = byArray[n5];
            } else {
                if (n5 + 2 >= n2) {
                    throw EXCEPTION_EOF;
                }
                byte by = byArray[n5 + 1];
                byte by2 = byArray[n5 + 2];
                if (!UDecoder.isHexDigit(by) || !UDecoder.isHexDigit(by2)) {
                    throw EXCEPTION_NOT_HEX_DIGIT;
                }
                n5 += 2;
                int n6 = UDecoder.x2c(by, by2);
                if (n6 == 47) {
                    switch (encodedSolidusHandling) {
                        case DECODE: {
                            byArray[n3] = (byte)n6;
                            break;
                        }
                        case REJECT: {
                            throw EXCEPTION_SLASH;
                        }
                        case PASS_THROUGH: {
                            byArray[n3++] = byArray[n5 - 2];
                            byArray[n3++] = byArray[n5 - 1];
                            byArray[n3] = byArray[n5];
                        }
                    }
                } else {
                    byArray[n3] = (byte)n6;
                }
            }
            ++n5;
            ++n3;
        }
        byteChunk.setEnd(n3);
    }

    @Deprecated
    public void convert(CharChunk charChunk, boolean bl) throws IOException {
        int n = charChunk.getOffset();
        char[] cArray = charChunk.getBuffer();
        int n2 = charChunk.getEnd();
        int n3 = CharChunk.indexOf(cArray, n, n2, '%');
        int n4 = -1;
        if (bl) {
            n4 = CharChunk.indexOf(cArray, n, n3 >= 0 ? n3 : n2, '+');
        }
        if (n3 < 0 && n4 < 0) {
            return;
        }
        if (n4 >= 0 && n4 < n3 || n3 < 0) {
            n3 = n4;
        }
        boolean bl2 = !ALLOW_ENCODED_SLASH && !bl;
        int n5 = n3;
        while (n5 < n2) {
            if (cArray[n5] == '+' && bl) {
                cArray[n3] = 32;
            } else if (cArray[n5] != '%') {
                cArray[n3] = cArray[n5];
            } else {
                if (n5 + 2 >= n2) {
                    throw EXCEPTION_EOF;
                }
                char c = cArray[n5 + 1];
                char c2 = cArray[n5 + 2];
                if (!UDecoder.isHexDigit(c) || !UDecoder.isHexDigit(c2)) {
                    throw EXCEPTION_NOT_HEX_DIGIT;
                }
                n5 += 2;
                int n6 = UDecoder.x2c(c, c2);
                if (bl2 && n6 == 47) {
                    throw EXCEPTION_SLASH;
                }
                cArray[n3] = (char)n6;
            }
            ++n5;
            ++n3;
        }
        charChunk.setEnd(n3);
    }

    @Deprecated
    public void convert(MessageBytes messageBytes, boolean bl) throws IOException {
        switch (messageBytes.getType()) {
            case 1: {
                String string = messageBytes.toString();
                if (string == null) {
                    return;
                }
                try {
                    messageBytes.setString(this.convert(string, bl));
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw new DecodeException(runtimeException.getMessage());
                }
            }
            case 3: {
                CharChunk charChunk = messageBytes.getCharChunk();
                this.convert(charChunk, bl);
                break;
            }
            case 2: {
                ByteChunk byteChunk = messageBytes.getByteChunk();
                this.convert(byteChunk, bl);
            }
        }
    }

    @Deprecated
    public String convert(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (!(bl && string.indexOf(43) >= 0 || string.indexOf(37) >= 0)) {
            return string;
        }
        boolean bl2 = !ALLOW_ENCODED_SLASH && !bl;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = string.length();
        stringBuilder.ensureCapacity(string.length());
        while (n < n2) {
            char c;
            int n3;
            for (n3 = n; !(n3 >= n2 || (c = string.charAt(n3)) == '+' && bl || c == '%'); ++n3) {
            }
            if (n3 > n) {
                stringBuilder.append(string.substring(n, n3));
                n = n3;
            }
            if (n >= n2) break;
            c = string.charAt(n);
            if (c == '+') {
                stringBuilder.append(' ');
                ++n;
                continue;
            }
            if (c != '%') continue;
            char c2 = (char)Integer.parseInt(string.substring(n + 1, n + 3), 16);
            if (bl2 && c2 == '/') {
                throw new IllegalArgumentException(sm.getString("uDecoder.noSlash"));
            }
            stringBuilder.append(c2);
            n += 3;
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String URLDecode(String string) {
        return UDecoder.URLDecode(string, StandardCharsets.UTF_8);
    }

    public static String URLDecode(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(37) == -1) {
            return string;
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 2);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, charset);
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        try {
            while (n2 < n) {
                char c;
                if ((c = cArray[n2++]) == '%') {
                    outputStreamWriter.flush();
                    if (n2 + 2 > n) {
                        throw new IllegalArgumentException(sm.getString("uDecoder.urlDecode.missingDigit", string));
                    }
                    char c2 = cArray[n2++];
                    char c3 = cArray[n2++];
                    if (UDecoder.isHexDigit(c2) && UDecoder.isHexDigit(c3)) {
                        byteArrayOutputStream.write(UDecoder.x2c(c2, c3));
                        continue;
                    }
                    throw new IllegalArgumentException(sm.getString("uDecoder.urlDecode.missingDigit", string));
                }
                outputStreamWriter.append(c);
            }
            outputStreamWriter.flush();
            return byteArrayOutputStream.toString(charset.name());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(sm.getString("uDecoder.urlDecode.conversionError", string, charset.name()), iOException);
        }
    }

    private static boolean isHexDigit(int n) {
        return n >= 48 && n <= 57 || n >= 97 && n <= 102 || n >= 65 && n <= 70;
    }

    private static int x2c(byte by, byte by2) {
        int n = by >= 65 ? (by & 0xDF) - 65 + 10 : by - 48;
        n *= 16;
        return n += by2 >= 65 ? (by2 & 0xDF) - 65 + 10 : by2 - 48;
    }

    private static int x2c(char c, char c2) {
        int n = c >= 'A' ? (c & 0xDF) - 65 + 10 : c - 48;
        n *= 16;
        return n += c2 >= 'A' ? (c2 & 0xDF) - 65 + 10 : c2 - 48;
    }

    private static class DecodeException
    extends CharConversionException {
        private static final long serialVersionUID = 1L;

        DecodeException(String string) {
            super(string);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

