/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.statement;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.engine.DocumentMissingException;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.sql.spark.execution.session.SessionId;
import org.opensearch.sql.spark.execution.statement.StatementId;
import org.opensearch.sql.spark.execution.statement.StatementModel;
import org.opensearch.sql.spark.execution.statement.StatementState;
import org.opensearch.sql.spark.execution.statestore.StateStore;
import org.opensearch.sql.spark.rest.model.LangType;

public class Statement {
    private static final Logger LOG = LogManager.getLogger();
    private final SessionId sessionId;
    private final String applicationId;
    private final String jobId;
    private final StatementId statementId;
    private final LangType langType;
    private final String datasourceName;
    private final String query;
    private final String queryId;
    private final StateStore stateStore;
    private StatementModel statementModel;

    public void open() {
        try {
            this.statementModel = StatementModel.submitStatement(this.sessionId, this.applicationId, this.jobId, this.statementId, this.langType, this.datasourceName, this.query, this.queryId);
            this.statementModel = StateStore.createStatement(this.stateStore, this.datasourceName).apply(this.statementModel);
        }
        catch (VersionConflictEngineException e) {
            String errorMsg = "statement already exist. " + this.statementId;
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    public void cancel() {
        StatementState statementState = this.statementModel.getStatementState();
        if (statementState.equals((Object)StatementState.SUCCESS) || statementState.equals((Object)StatementState.FAILED) || statementState.equals((Object)StatementState.CANCELLED)) {
            String errorMsg = String.format("can't cancel statement in %s state. statement: %s.", statementState.getState(), this.statementId);
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        try {
            this.statementModel = StateStore.updateStatementState(this.stateStore, this.statementModel.getDatasourceName()).apply(this.statementModel, StatementState.CANCELLED);
        }
        catch (DocumentMissingException e) {
            String errorMsg = String.format("cancel statement failed. no statement found. statement: %s.", this.statementId);
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        catch (VersionConflictEngineException e) {
            this.statementModel = StateStore.getStatement(this.stateStore, this.statementModel.getDatasourceName()).apply(this.statementModel.getId()).orElse(this.statementModel);
            String errorMsg = String.format("cancel statement failed. current statementState: %s statement: %s.", new Object[]{this.statementModel.getStatementState(), this.statementId});
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    public StatementState getStatementState() {
        return this.statementModel.getStatementState();
    }

    @Generated
    Statement(SessionId sessionId, String applicationId, String jobId, StatementId statementId, LangType langType, String datasourceName, String query, String queryId, StateStore stateStore, StatementModel statementModel) {
        this.sessionId = sessionId;
        this.applicationId = applicationId;
        this.jobId = jobId;
        this.statementId = statementId;
        this.langType = langType;
        this.datasourceName = datasourceName;
        this.query = query;
        this.queryId = queryId;
        this.stateStore = stateStore;
        this.statementModel = statementModel;
    }

    @Generated
    public static StatementBuilder builder() {
        return new StatementBuilder();
    }

    @Generated
    public SessionId getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public StatementId getStatementId() {
        return this.statementId;
    }

    @Generated
    public LangType getLangType() {
        return this.langType;
    }

    @Generated
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public StateStore getStateStore() {
        return this.stateStore;
    }

    @Generated
    public StatementModel getStatementModel() {
        return this.statementModel;
    }

    @Generated
    public void setStatementModel(StatementModel statementModel) {
        this.statementModel = statementModel;
    }

    @Generated
    public static class StatementBuilder {
        @Generated
        private SessionId sessionId;
        @Generated
        private String applicationId;
        @Generated
        private String jobId;
        @Generated
        private StatementId statementId;
        @Generated
        private LangType langType;
        @Generated
        private String datasourceName;
        @Generated
        private String query;
        @Generated
        private String queryId;
        @Generated
        private StateStore stateStore;
        @Generated
        private StatementModel statementModel;

        @Generated
        StatementBuilder() {
        }

        @Generated
        public StatementBuilder sessionId(SessionId sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public StatementBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @Generated
        public StatementBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Generated
        public StatementBuilder statementId(StatementId statementId) {
            this.statementId = statementId;
            return this;
        }

        @Generated
        public StatementBuilder langType(LangType langType) {
            this.langType = langType;
            return this;
        }

        @Generated
        public StatementBuilder datasourceName(String datasourceName) {
            this.datasourceName = datasourceName;
            return this;
        }

        @Generated
        public StatementBuilder query(String query) {
            this.query = query;
            return this;
        }

        @Generated
        public StatementBuilder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @Generated
        public StatementBuilder stateStore(StateStore stateStore) {
            this.stateStore = stateStore;
            return this;
        }

        @Generated
        public StatementBuilder statementModel(StatementModel statementModel) {
            this.statementModel = statementModel;
            return this;
        }

        @Generated
        public Statement build() {
            return new Statement(this.sessionId, this.applicationId, this.jobId, this.statementId, this.langType, this.datasourceName, this.query, this.queryId, this.stateStore, this.statementModel);
        }

        @Generated
        public String toString() {
            return "Statement.StatementBuilder(sessionId=" + this.sessionId + ", applicationId=" + this.applicationId + ", jobId=" + this.jobId + ", statementId=" + this.statementId + ", langType=" + this.langType + ", datasourceName=" + this.datasourceName + ", query=" + this.query + ", queryId=" + this.queryId + ", stateStore=" + this.stateStore + ", statementModel=" + this.statementModel + ")";
        }
    }
}

