/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerObjectImpl;
import com.alibaba.druid.sql.dialect.sqlserver.ast.expr.SQLServerExpr;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;

public class SQLServerObjectReferenceExpr
extends SQLServerObjectImpl
implements SQLServerExpr,
SQLName {
    private String server;
    private String database;
    private String schema;

    public SQLServerObjectReferenceExpr() {
    }

    public SQLServerObjectReferenceExpr(SQLExpr owner) {
        if (owner instanceof SQLIdentifierExpr) {
            this.database = ((SQLIdentifierExpr)owner).getName();
        } else if (owner instanceof SQLPropertyExpr) {
            SQLPropertyExpr propExpr = (SQLPropertyExpr)owner;
            this.server = ((SQLIdentifierExpr)propExpr.getOwner()).getName();
            this.database = propExpr.getName();
        } else {
            throw new IllegalArgumentException(owner.toString());
        }
    }

    @Override
    public String getSimpleName() {
        if (this.schema != null) {
            return this.schema;
        }
        if (this.database != null) {
            return this.database;
        }
        return this.server;
    }

    @Override
    public void accept0(SQLServerASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuffer buf) {
        boolean flag = false;
        if (this.server != null) {
            buf.append(this.server);
            flag = true;
        }
        if (flag) {
            buf.append('.');
        }
        if (this.database != null) {
            buf.append(this.database);
            flag = true;
        }
        if (flag) {
            buf.append('.');
        }
        if (this.schema != null) {
            buf.append(this.schema);
            flag = true;
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

