# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .service_principal_base import ServicePrincipalBase


class ServicePrincipalCreateParameters(ServicePrincipalBase):
    """Request parameters for creating a new service principal.

    All required parameters must be populated in order to send to Azure.

    :param account_enabled: whether or not the service principal account is
     enabled
    :type account_enabled: str
    :param app_role_assignment_required: Specifies whether an
     AppRoleAssignment to a user or group is required before Azure AD will
     issue a user or access token to the application.
    :type app_role_assignment_required: bool
    :param key_credentials: The collection of key credentials associated with
     the service principal.
    :type key_credentials: list[~azure.graphrbac.models.KeyCredential]
    :param password_credentials: The collection of password credentials
     associated with the service principal.
    :type password_credentials:
     list[~azure.graphrbac.models.PasswordCredential]
    :param service_principal_type: the type of the servie principal
    :type service_principal_type: str
    :param tags: Optional list of tags that you can apply to your service
     principals. Not nullable.
    :type tags: list[str]
    :param app_id: Required. The application ID.
    :type app_id: str
    """

    _validation = {
        'app_id': {'required': True},
    }

    _attribute_map = {
        'account_enabled': {'key': 'accountEnabled', 'type': 'str'},
        'app_role_assignment_required': {'key': 'appRoleAssignmentRequired', 'type': 'bool'},
        'key_credentials': {'key': 'keyCredentials', 'type': '[KeyCredential]'},
        'password_credentials': {'key': 'passwordCredentials', 'type': '[PasswordCredential]'},
        'service_principal_type': {'key': 'servicePrincipalType', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'app_id': {'key': 'appId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServicePrincipalCreateParameters, self).__init__(**kwargs)
        self.app_id = kwargs.get('app_id', None)
