# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AbsoluteMonthlySchedule(_serialization.Model):
    """For schedules like: 'recur every month on the 15th' or 'recur every 3 months on the 20th'.

    All required parameters must be populated in order to send to server.

    :ivar interval_months: Specifies the number of months between each set of occurrences.
     Required.
    :vartype interval_months: int
    :ivar day_of_month: The date of the month. Required.
    :vartype day_of_month: int
    """

    _validation = {
        "interval_months": {"required": True, "maximum": 6, "minimum": 1},
        "day_of_month": {"required": True, "maximum": 31, "minimum": 1},
    }

    _attribute_map = {
        "interval_months": {"key": "intervalMonths", "type": "int"},
        "day_of_month": {"key": "dayOfMonth", "type": "int"},
    }

    def __init__(self, *, interval_months: int, day_of_month: int, **kwargs: Any) -> None:
        """
        :keyword interval_months: Specifies the number of months between each set of occurrences.
         Required.
        :paramtype interval_months: int
        :keyword day_of_month: The date of the month. Required.
        :paramtype day_of_month: int
        """
        super().__init__(**kwargs)
        self.interval_months = interval_months
        self.day_of_month = day_of_month


class SubResource(_serialization.Model):
    """Reference to another subresource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AgentPool(SubResource):  # pylint: disable=too-many-instance-attributes
    """Agent Pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
     system pools. The default value is 1.
    :vartype count: int
    :ivar vm_size: VM size availability varies by region. If a node contains insufficient compute
     resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted
     VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions.
    :vartype vm_size: str
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in the master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar os_disk_type: The default is 'Ephemeral' if the VM supports it and has a cache disk
     larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed
     after creation. For more information see `Ephemeral OS
     <https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os>`_. Known values are:
     "Managed" and "Ephemeral".
    :vartype os_disk_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSDiskType
    :ivar kubelet_disk_type: Determines the placement of emptyDir volumes, container runtime data
     root, and Kubelet ephemeral storage. Known values are: "OS" and "Temporary".
    :vartype kubelet_disk_type: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.KubeletDiskType
    :ivar workload_runtime: Determines the type of workload a node can run. Known values are:
     "OCIContainer" and "WasmWasi".
    :vartype workload_runtime: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.WorkloadRuntime
    :ivar vnet_subnet_id: If this is not specified, a VNET and subnet will be generated and used.
     If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just
     nodes. This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
    :vartype vnet_subnet_id: str
    :ivar pod_subnet_id: If omitted, pod IPs are statically assigned on the node subnet (see
     vnetSubnetID for more details). This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
    :vartype pod_subnet_id: str
    :ivar max_pods: The maximum number of pods that can run on a node.
    :vartype max_pods: int
    :ivar os_type: The operating system type. The default is Linux. Known values are: "Linux" and
     "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
    :ivar os_sku: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is
     Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >=
     1.25 if OSType is Windows. Known values are: "Ubuntu", "AzureLinux", "CBLMariner",
     "Windows2019", and "Windows2022".
    :vartype os_sku: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSSKU
    :ivar max_count: The maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: The minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler.
    :vartype enable_auto_scaling: bool
    :ivar scale_down_mode: This also effects the cluster autoscaler behavior. If not specified, it
     defaults to Delete. Known values are: "Delete" and "Deallocate".
    :vartype scale_down_mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.ScaleDownMode
    :ivar type_properties_type: The type of Agent Pool. Known values are: "VirtualMachineScaleSets"
     and "AvailabilitySet".
    :vartype type_properties_type: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolType
    :ivar mode: A cluster must have at least one 'System' Agent Pool at all times. For additional
     information on agent pool restrictions and best practices, see:
     https://docs.microsoft.com/azure/aks/use-system-pools. Known values are: "System" and "User".
    :vartype mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolMode
    :ivar orchestrator_version: Both patch version <major.minor.patch> (e.g. 1.20.13) and
     <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported
     GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once
     it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch
     version is available. As a best practice, you should upgrade all node pools in an AKS cluster
     to the same Kubernetes version. The node pool version must have the same major version as the
     control plane. The node pool minor version must be within two minor versions of the control
     plane version. The node pool version cannot be greater than the control plane version. For more
     information see `upgrading a node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool>`_.
    :vartype orchestrator_version: str
    :ivar current_orchestrator_version: If orchestratorVersion is a fully specified version
     <major.minor.patch>, this field will be exactly equal to it. If orchestratorVersion is
     <major.minor>, this field will contain the full <major.minor.patch> version being used.
    :vartype current_orchestrator_version: str
    :ivar node_image_version: The version of node image.
    :vartype node_image_version: str
    :ivar upgrade_settings: Settings for upgrading the agentpool.
    :vartype upgrade_settings:
     ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state.
    :vartype provisioning_state: str
    :ivar power_state: When an Agent Pool is first created it is initially Running. The Agent Pool
     can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and
     does not accrue billing charges. An Agent Pool can only be stopped if it is Running and
     provisioning state is Succeeded.
    :vartype power_state: ~azure.mgmt.containerservice.v2024_01_01.models.PowerState
    :ivar availability_zones: The list of Availability zones to use for nodes. This can only be
     specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
    :vartype availability_zones: list[str]
    :ivar enable_node_public_ip: Some scenarios may require nodes in a node pool to receive their
     own dedicated public IP addresses. A common scenario is for gaming workloads, where a console
     needs to make a direct connection to a cloud virtual machine to minimize hops. For more
     information see `assigning a public IP per node
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools>`_.
     The default is false.
    :vartype enable_node_public_ip: bool
    :ivar node_public_ip_prefix_id: This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.  # pylint: disable=line-too-long
    :vartype node_public_ip_prefix_id: str
    :ivar scale_set_priority: The Virtual Machine Scale Set priority. If not specified, the default
     is 'Regular'. Known values are: "Spot" and "Regular".
    :vartype scale_set_priority: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetPriority
    :ivar scale_set_eviction_policy: This cannot be specified unless the scaleSetPriority is
     'Spot'. If not specified, the default is 'Delete'. Known values are: "Delete" and "Deallocate".
    :vartype scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetEvictionPolicy
    :ivar spot_max_price: Possible values are any decimal value greater than zero or -1 which
     indicates the willingness to pay any on-demand price. For more details on spot pricing, see
     `spot VMs pricing <https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing>`_.
    :vartype spot_max_price: float
    :ivar tags: The tags to be persisted on the agent pool virtual machine scale set.
    :vartype tags: dict[str, str]
    :ivar node_labels: The node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: The taints added to new nodes during node pool create and scale. For
     example, key=value:NoSchedule.
    :vartype node_taints: list[str]
    :ivar proximity_placement_group_id: The ID for Proximity Placement Group.
    :vartype proximity_placement_group_id: str
    :ivar kubelet_config: The Kubelet configuration on the agent pool nodes.
    :vartype kubelet_config: ~azure.mgmt.containerservice.v2024_01_01.models.KubeletConfig
    :ivar linux_os_config: The OS configuration of Linux agent nodes.
    :vartype linux_os_config: ~azure.mgmt.containerservice.v2024_01_01.models.LinuxOSConfig
    :ivar enable_encryption_at_host: This is only supported on certain VM sizes and in certain
     Azure regions. For more information, see:
     https://docs.microsoft.com/azure/aks/enable-host-encryption.
    :vartype enable_encryption_at_host: bool
    :ivar enable_ultra_ssd: Whether to enable UltraSSD.
    :vartype enable_ultra_ssd: bool
    :ivar enable_fips: See `Add a FIPS-enabled node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview>`_
     for more details.
    :vartype enable_fips: bool
    :ivar gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance profile
     for supported GPU VM SKU. Known values are: "MIG1g", "MIG2g", "MIG3g", "MIG4g", and "MIG7g".
    :vartype gpu_instance_profile: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.GPUInstanceProfile
    :ivar creation_data: CreationData to be used to specify the source Snapshot ID if the node pool
     will be created/upgraded using a snapshot.
    :vartype creation_data: ~azure.mgmt.containerservice.v2024_01_01.models.CreationData
    :ivar capacity_reservation_group_id: AKS will associate the specified agent pool with the
     Capacity Reservation Group.
    :vartype capacity_reservation_group_id: str
    :ivar host_group_id: This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.  # pylint: disable=line-too-long
     For more information see `Azure dedicated hosts
     <https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts>`_.
    :vartype host_group_id: str
    :ivar network_profile: Network-related settings of an agent pool.
    :vartype network_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolNetworkProfile
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "os_disk_size_gb": {"maximum": 2048, "minimum": 0},
        "current_orchestrator_version": {"readonly": True},
        "node_image_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "count": {"key": "properties.count", "type": "int"},
        "vm_size": {"key": "properties.vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "properties.osDiskSizeGB", "type": "int"},
        "os_disk_type": {"key": "properties.osDiskType", "type": "str"},
        "kubelet_disk_type": {"key": "properties.kubeletDiskType", "type": "str"},
        "workload_runtime": {"key": "properties.workloadRuntime", "type": "str"},
        "vnet_subnet_id": {"key": "properties.vnetSubnetID", "type": "str"},
        "pod_subnet_id": {"key": "properties.podSubnetID", "type": "str"},
        "max_pods": {"key": "properties.maxPods", "type": "int"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_sku": {"key": "properties.osSKU", "type": "str"},
        "max_count": {"key": "properties.maxCount", "type": "int"},
        "min_count": {"key": "properties.minCount", "type": "int"},
        "enable_auto_scaling": {"key": "properties.enableAutoScaling", "type": "bool"},
        "scale_down_mode": {"key": "properties.scaleDownMode", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "mode": {"key": "properties.mode", "type": "str"},
        "orchestrator_version": {"key": "properties.orchestratorVersion", "type": "str"},
        "current_orchestrator_version": {"key": "properties.currentOrchestratorVersion", "type": "str"},
        "node_image_version": {"key": "properties.nodeImageVersion", "type": "str"},
        "upgrade_settings": {"key": "properties.upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "power_state": {"key": "properties.powerState", "type": "PowerState"},
        "availability_zones": {"key": "properties.availabilityZones", "type": "[str]"},
        "enable_node_public_ip": {"key": "properties.enableNodePublicIP", "type": "bool"},
        "node_public_ip_prefix_id": {"key": "properties.nodePublicIPPrefixID", "type": "str"},
        "scale_set_priority": {"key": "properties.scaleSetPriority", "type": "str"},
        "scale_set_eviction_policy": {"key": "properties.scaleSetEvictionPolicy", "type": "str"},
        "spot_max_price": {"key": "properties.spotMaxPrice", "type": "float"},
        "tags": {"key": "properties.tags", "type": "{str}"},
        "node_labels": {"key": "properties.nodeLabels", "type": "{str}"},
        "node_taints": {"key": "properties.nodeTaints", "type": "[str]"},
        "proximity_placement_group_id": {"key": "properties.proximityPlacementGroupID", "type": "str"},
        "kubelet_config": {"key": "properties.kubeletConfig", "type": "KubeletConfig"},
        "linux_os_config": {"key": "properties.linuxOSConfig", "type": "LinuxOSConfig"},
        "enable_encryption_at_host": {"key": "properties.enableEncryptionAtHost", "type": "bool"},
        "enable_ultra_ssd": {"key": "properties.enableUltraSSD", "type": "bool"},
        "enable_fips": {"key": "properties.enableFIPS", "type": "bool"},
        "gpu_instance_profile": {"key": "properties.gpuInstanceProfile", "type": "str"},
        "creation_data": {"key": "properties.creationData", "type": "CreationData"},
        "capacity_reservation_group_id": {"key": "properties.capacityReservationGroupID", "type": "str"},
        "host_group_id": {"key": "properties.hostGroupID", "type": "str"},
        "network_profile": {"key": "properties.networkProfile", "type": "AgentPoolNetworkProfile"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        count: Optional[int] = None,
        vm_size: Optional[str] = None,
        os_disk_size_gb: Optional[int] = None,
        os_disk_type: Optional[Union[str, "_models.OSDiskType"]] = None,
        kubelet_disk_type: Optional[Union[str, "_models.KubeletDiskType"]] = None,
        workload_runtime: Optional[Union[str, "_models.WorkloadRuntime"]] = None,
        vnet_subnet_id: Optional[str] = None,
        pod_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Union[str, "_models.OSType"] = "Linux",
        os_sku: Optional[Union[str, "_models.OSSKU"]] = None,
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        scale_down_mode: Optional[Union[str, "_models.ScaleDownMode"]] = None,
        type_properties_type: Optional[Union[str, "_models.AgentPoolType"]] = None,
        mode: Optional[Union[str, "_models.AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        power_state: Optional["_models.PowerState"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        node_public_ip_prefix_id: Optional[str] = None,
        scale_set_priority: Union[str, "_models.ScaleSetPriority"] = "Regular",
        scale_set_eviction_policy: Union[str, "_models.ScaleSetEvictionPolicy"] = "Delete",
        spot_max_price: float = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        proximity_placement_group_id: Optional[str] = None,
        kubelet_config: Optional["_models.KubeletConfig"] = None,
        linux_os_config: Optional["_models.LinuxOSConfig"] = None,
        enable_encryption_at_host: Optional[bool] = None,
        enable_ultra_ssd: Optional[bool] = None,
        enable_fips: Optional[bool] = None,
        gpu_instance_profile: Optional[Union[str, "_models.GPUInstanceProfile"]] = None,
        creation_data: Optional["_models.CreationData"] = None,
        capacity_reservation_group_id: Optional[str] = None,
        host_group_id: Optional[str] = None,
        network_profile: Optional["_models.AgentPoolNetworkProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of agents (VMs) to host docker containers. Allowed values must be in the
         range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
         system pools. The default value is 1.
        :paramtype count: int
        :keyword vm_size: VM size availability varies by region. If a node contains insufficient
         compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on
         restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions.
        :paramtype vm_size: str
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in the master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword os_disk_type: The default is 'Ephemeral' if the VM supports it and has a cache disk
         larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed
         after creation. For more information see `Ephemeral OS
         <https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os>`_. Known values are:
         "Managed" and "Ephemeral".
        :paramtype os_disk_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSDiskType
        :keyword kubelet_disk_type: Determines the placement of emptyDir volumes, container runtime
         data root, and Kubelet ephemeral storage. Known values are: "OS" and "Temporary".
        :paramtype kubelet_disk_type: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.KubeletDiskType
        :keyword workload_runtime: Determines the type of workload a node can run. Known values are:
         "OCIContainer" and "WasmWasi".
        :paramtype workload_runtime: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.WorkloadRuntime
        :keyword vnet_subnet_id: If this is not specified, a VNET and subnet will be generated and
         used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to
         just nodes. This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
        :paramtype vnet_subnet_id: str
        :keyword pod_subnet_id: If omitted, pod IPs are statically assigned on the node subnet (see
         vnetSubnetID for more details). This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
        :paramtype pod_subnet_id: str
        :keyword max_pods: The maximum number of pods that can run on a node.
        :paramtype max_pods: int
        :keyword os_type: The operating system type. The default is Linux. Known values are: "Linux"
         and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
        :keyword os_sku: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType
         is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >=
         1.25 if OSType is Windows. Known values are: "Ubuntu", "AzureLinux", "CBLMariner",
         "Windows2019", and "Windows2022".
        :paramtype os_sku: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSSKU
        :keyword max_count: The maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: The minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler.
        :paramtype enable_auto_scaling: bool
        :keyword scale_down_mode: This also effects the cluster autoscaler behavior. If not specified,
         it defaults to Delete. Known values are: "Delete" and "Deallocate".
        :paramtype scale_down_mode: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.ScaleDownMode
        :keyword type_properties_type: The type of Agent Pool. Known values are:
         "VirtualMachineScaleSets" and "AvailabilitySet".
        :paramtype type_properties_type: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolType
        :keyword mode: A cluster must have at least one 'System' Agent Pool at all times. For
         additional information on agent pool restrictions and best practices, see:
         https://docs.microsoft.com/azure/aks/use-system-pools. Known values are: "System" and "User".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolMode
        :keyword orchestrator_version: Both patch version <major.minor.patch> (e.g. 1.20.13) and
         <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported
         GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once
         it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch
         version is available. As a best practice, you should upgrade all node pools in an AKS cluster
         to the same Kubernetes version. The node pool version must have the same major version as the
         control plane. The node pool minor version must be within two minor versions of the control
         plane version. The node pool version cannot be greater than the control plane version. For more
         information see `upgrading a node pool
         <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool>`_.
        :paramtype orchestrator_version: str
        :keyword upgrade_settings: Settings for upgrading the agentpool.
        :paramtype upgrade_settings:
         ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolUpgradeSettings
        :keyword power_state: When an Agent Pool is first created it is initially Running. The Agent
         Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs
         and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and
         provisioning state is Succeeded.
        :paramtype power_state: ~azure.mgmt.containerservice.v2024_01_01.models.PowerState
        :keyword availability_zones: The list of Availability zones to use for nodes. This can only be
         specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
        :paramtype availability_zones: list[str]
        :keyword enable_node_public_ip: Some scenarios may require nodes in a node pool to receive
         their own dedicated public IP addresses. A common scenario is for gaming workloads, where a
         console needs to make a direct connection to a cloud virtual machine to minimize hops. For more
         information see `assigning a public IP per node
         <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools>`_.  # pylint: disable=line-too-long
         The default is false.
        :paramtype enable_node_public_ip: bool
        :keyword node_public_ip_prefix_id: This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.  # pylint: disable=line-too-long
        :paramtype node_public_ip_prefix_id: str
        :keyword scale_set_priority: The Virtual Machine Scale Set priority. If not specified, the
         default is 'Regular'. Known values are: "Spot" and "Regular".
        :paramtype scale_set_priority: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetPriority
        :keyword scale_set_eviction_policy: This cannot be specified unless the scaleSetPriority is
         'Spot'. If not specified, the default is 'Delete'. Known values are: "Delete" and "Deallocate".
        :paramtype scale_set_eviction_policy: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetEvictionPolicy
        :keyword spot_max_price: Possible values are any decimal value greater than zero or -1 which
         indicates the willingness to pay any on-demand price. For more details on spot pricing, see
         `spot VMs pricing <https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing>`_.
        :paramtype spot_max_price: float
        :keyword tags: The tags to be persisted on the agent pool virtual machine scale set.
        :paramtype tags: dict[str, str]
        :keyword node_labels: The node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: The taints added to new nodes during node pool create and scale. For
         example, key=value:NoSchedule.
        :paramtype node_taints: list[str]
        :keyword proximity_placement_group_id: The ID for Proximity Placement Group.
        :paramtype proximity_placement_group_id: str
        :keyword kubelet_config: The Kubelet configuration on the agent pool nodes.
        :paramtype kubelet_config: ~azure.mgmt.containerservice.v2024_01_01.models.KubeletConfig
        :keyword linux_os_config: The OS configuration of Linux agent nodes.
        :paramtype linux_os_config: ~azure.mgmt.containerservice.v2024_01_01.models.LinuxOSConfig
        :keyword enable_encryption_at_host: This is only supported on certain VM sizes and in certain
         Azure regions. For more information, see:
         https://docs.microsoft.com/azure/aks/enable-host-encryption.
        :paramtype enable_encryption_at_host: bool
        :keyword enable_ultra_ssd: Whether to enable UltraSSD.
        :paramtype enable_ultra_ssd: bool
        :keyword enable_fips: See `Add a FIPS-enabled node pool
         <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview>`_
         for more details.
        :paramtype enable_fips: bool
        :keyword gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance
         profile for supported GPU VM SKU. Known values are: "MIG1g", "MIG2g", "MIG3g", "MIG4g", and
         "MIG7g".
        :paramtype gpu_instance_profile: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.GPUInstanceProfile
        :keyword creation_data: CreationData to be used to specify the source Snapshot ID if the node
         pool will be created/upgraded using a snapshot.
        :paramtype creation_data: ~azure.mgmt.containerservice.v2024_01_01.models.CreationData
        :keyword capacity_reservation_group_id: AKS will associate the specified agent pool with the
         Capacity Reservation Group.
        :paramtype capacity_reservation_group_id: str
        :keyword host_group_id: This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.  # pylint: disable=line-too-long
         For more information see `Azure dedicated hosts
         <https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts>`_.
        :paramtype host_group_id: str
        :keyword network_profile: Network-related settings of an agent pool.
        :paramtype network_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolNetworkProfile
        """
        super().__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.os_disk_type = os_disk_type
        self.kubelet_disk_type = kubelet_disk_type
        self.workload_runtime = workload_runtime
        self.vnet_subnet_id = vnet_subnet_id
        self.pod_subnet_id = pod_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.os_sku = os_sku
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.scale_down_mode = scale_down_mode
        self.type_properties_type = type_properties_type
        self.mode = mode
        self.orchestrator_version = orchestrator_version
        self.current_orchestrator_version = None
        self.node_image_version = None
        self.upgrade_settings = upgrade_settings
        self.provisioning_state = None
        self.power_state = power_state
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.node_public_ip_prefix_id = node_public_ip_prefix_id
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.spot_max_price = spot_max_price
        self.tags = tags
        self.node_labels = node_labels
        self.node_taints = node_taints
        self.proximity_placement_group_id = proximity_placement_group_id
        self.kubelet_config = kubelet_config
        self.linux_os_config = linux_os_config
        self.enable_encryption_at_host = enable_encryption_at_host
        self.enable_ultra_ssd = enable_ultra_ssd
        self.enable_fips = enable_fips
        self.gpu_instance_profile = gpu_instance_profile
        self.creation_data = creation_data
        self.capacity_reservation_group_id = capacity_reservation_group_id
        self.host_group_id = host_group_id
        self.network_profile = network_profile


class AgentPoolAvailableVersions(_serialization.Model):
    """The list of available versions for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the agent pool version list.
    :vartype id: str
    :ivar name: The name of the agent pool version list.
    :vartype name: str
    :ivar type: Type of the agent pool version list.
    :vartype type: str
    :ivar agent_pool_versions: List of versions available for agent pool.
    :vartype agent_pool_versions:
     list[~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "agent_pool_versions": {
            "key": "properties.agentPoolVersions",
            "type": "[AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]",
        },
    }

    def __init__(
        self,
        *,
        agent_pool_versions: Optional[List["_models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword agent_pool_versions: List of versions available for agent pool.
        :paramtype agent_pool_versions:
         list[~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.agent_pool_versions = agent_pool_versions


class AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem(_serialization.Model):  # pylint: disable=name-too-long
    """AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.

    :ivar default: Whether this version is the default agent pool version.
    :vartype default: bool
    :ivar kubernetes_version: The Kubernetes version (major.minor.patch).
    :vartype kubernetes_version: str
    :ivar is_preview: Whether Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        "default": {"key": "default", "type": "bool"},
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(
        self,
        *,
        default: Optional[bool] = None,
        kubernetes_version: Optional[str] = None,
        is_preview: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default: Whether this version is the default agent pool version.
        :paramtype default: bool
        :keyword kubernetes_version: The Kubernetes version (major.minor.patch).
        :paramtype kubernetes_version: str
        :keyword is_preview: Whether Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.default = default
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolListResult(_serialization.Model):
    """The response from the List Agent Pools operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of agent pools.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.AgentPool]
    :ivar next_link: The URL to get the next set of agent pool results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AgentPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AgentPool"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of agent pools.
        :paramtype value: list[~azure.mgmt.containerservice.v2024_01_01.models.AgentPool]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AgentPoolNetworkProfile(_serialization.Model):
    """Network settings of an agent pool.

    :ivar node_public_ip_tags: IPTags of instance-level public IPs.
    :vartype node_public_ip_tags: list[~azure.mgmt.containerservice.v2024_01_01.models.IPTag]
    :ivar allowed_host_ports: The port ranges that are allowed to access. The specified ranges are
     allowed to overlap.
    :vartype allowed_host_ports: list[~azure.mgmt.containerservice.v2024_01_01.models.PortRange]
    :ivar application_security_groups: The IDs of the application security groups which agent pool
     will associate when created.
    :vartype application_security_groups: list[str]
    """

    _attribute_map = {
        "node_public_ip_tags": {"key": "nodePublicIPTags", "type": "[IPTag]"},
        "allowed_host_ports": {"key": "allowedHostPorts", "type": "[PortRange]"},
        "application_security_groups": {"key": "applicationSecurityGroups", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        node_public_ip_tags: Optional[List["_models.IPTag"]] = None,
        allowed_host_ports: Optional[List["_models.PortRange"]] = None,
        application_security_groups: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword node_public_ip_tags: IPTags of instance-level public IPs.
        :paramtype node_public_ip_tags: list[~azure.mgmt.containerservice.v2024_01_01.models.IPTag]
        :keyword allowed_host_ports: The port ranges that are allowed to access. The specified ranges
         are allowed to overlap.
        :paramtype allowed_host_ports: list[~azure.mgmt.containerservice.v2024_01_01.models.PortRange]
        :keyword application_security_groups: The IDs of the application security groups which agent
         pool will associate when created.
        :paramtype application_security_groups: list[str]
        """
        super().__init__(**kwargs)
        self.node_public_ip_tags = node_public_ip_tags
        self.allowed_host_ports = allowed_host_ports
        self.application_security_groups = application_security_groups


class AgentPoolUpgradeProfile(_serialization.Model):
    """The list of available upgrades for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the agent pool upgrade profile.
    :vartype id: str
    :ivar name: The name of the agent pool upgrade profile.
    :vartype name: str
    :ivar type: The type of the agent pool upgrade profile.
    :vartype type: str
    :ivar kubernetes_version: The Kubernetes version (major.minor.patch). Required.
    :vartype kubernetes_version: str
    :ivar os_type: The operating system type. The default is Linux. Known values are: "Linux" and
     "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
    :ivar upgrades: List of orchestrator types and versions available for upgrade.
    :vartype upgrades:
     list[~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
    :ivar latest_node_image_version: The latest AKS supported node image version.
    :vartype latest_node_image_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kubernetes_version": {"required": True},
        "os_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "upgrades": {"key": "properties.upgrades", "type": "[AgentPoolUpgradeProfilePropertiesUpgradesItem]"},
        "latest_node_image_version": {"key": "properties.latestNodeImageVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        kubernetes_version: str,
        os_type: Union[str, "_models.OSType"] = "Linux",
        upgrades: Optional[List["_models.AgentPoolUpgradeProfilePropertiesUpgradesItem"]] = None,
        latest_node_image_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: The Kubernetes version (major.minor.patch). Required.
        :paramtype kubernetes_version: str
        :keyword os_type: The operating system type. The default is Linux. Known values are: "Linux"
         and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
        :keyword upgrades: List of orchestrator types and versions available for upgrade.
        :paramtype upgrades:
         list[~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
        :keyword latest_node_image_version: The latest AKS supported node image version.
        :paramtype latest_node_image_version: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kubernetes_version = kubernetes_version
        self.os_type = os_type
        self.upgrades = upgrades
        self.latest_node_image_version = latest_node_image_version


class AgentPoolUpgradeProfilePropertiesUpgradesItem(_serialization.Model):  # pylint: disable=name-too-long
    """AgentPoolUpgradeProfilePropertiesUpgradesItem.

    :ivar kubernetes_version: The Kubernetes version (major.minor.patch).
    :vartype kubernetes_version: str
    :ivar is_preview: Whether the Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(
        self, *, kubernetes_version: Optional[str] = None, is_preview: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: The Kubernetes version (major.minor.patch).
        :paramtype kubernetes_version: str
        :keyword is_preview: Whether the Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolUpgradeSettings(_serialization.Model):
    """Settings for upgrading an agentpool.

    :ivar max_surge: This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%').
     If a percentage is specified, it is the percentage of the total agent pool size at the time of
     the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is
     1. For more information, including best practices, see:
     https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade.
    :vartype max_surge: str
    :ivar drain_timeout_in_minutes: The amount of time (in minutes) to wait on eviction of pods and
     graceful termination per node. This eviction wait time honors waiting on pod disruption
     budgets. If this time is exceeded, the upgrade fails. If not specified, the default is 30
     minutes.
    :vartype drain_timeout_in_minutes: int
    :ivar node_soak_duration_in_minutes: The amount of time (in minutes) to wait after draining a
     node and before reimaging it and moving on to next node. If not specified, the default is 0
     minutes.
    :vartype node_soak_duration_in_minutes: int
    """

    _validation = {
        "drain_timeout_in_minutes": {"maximum": 1440, "minimum": 1},
        "node_soak_duration_in_minutes": {"maximum": 30, "minimum": 0},
    }

    _attribute_map = {
        "max_surge": {"key": "maxSurge", "type": "str"},
        "drain_timeout_in_minutes": {"key": "drainTimeoutInMinutes", "type": "int"},
        "node_soak_duration_in_minutes": {"key": "nodeSoakDurationInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        max_surge: Optional[str] = None,
        drain_timeout_in_minutes: Optional[int] = None,
        node_soak_duration_in_minutes: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_surge: This can either be set to an integer (e.g. '5') or a percentage (e.g.
         '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the
         time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the
         default is 1. For more information, including best practices, see:
         https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade.
        :paramtype max_surge: str
        :keyword drain_timeout_in_minutes: The amount of time (in minutes) to wait on eviction of pods
         and graceful termination per node. This eviction wait time honors waiting on pod disruption
         budgets. If this time is exceeded, the upgrade fails. If not specified, the default is 30
         minutes.
        :paramtype drain_timeout_in_minutes: int
        :keyword node_soak_duration_in_minutes: The amount of time (in minutes) to wait after draining
         a node and before reimaging it and moving on to next node. If not specified, the default is 0
         minutes.
        :paramtype node_soak_duration_in_minutes: int
        """
        super().__init__(**kwargs)
        self.max_surge = max_surge
        self.drain_timeout_in_minutes = drain_timeout_in_minutes
        self.node_soak_duration_in_minutes = node_soak_duration_in_minutes


class AzureKeyVaultKms(_serialization.Model):
    """Azure Key Vault key management service settings for the security profile.

    :ivar enabled: Whether to enable Azure Key Vault key management service. The default is false.
    :vartype enabled: bool
    :ivar key_id: Identifier of Azure Key Vault key. See `key identifier format
     <https://docs.microsoft.com/en-us/azure/key-vault/general/about-keys-secrets-certificates#vault-name-and-object-name>`_  # pylint: disable=line-too-long
     for more details. When Azure Key Vault key management service is enabled, this field is
     required and must be a valid key identifier. When Azure Key Vault key management service is
     disabled, leave the field empty.
    :vartype key_id: str
    :ivar key_vault_network_access: Network access of key vault. The possible values are ``Public``
     and ``Private``. ``Public`` means the key vault allows public access from all networks.
     ``Private`` means the key vault disables public access and enables private link. The default
     value is ``Public``. Known values are: "Public" and "Private".
    :vartype key_vault_network_access: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.KeyVaultNetworkAccessTypes
    :ivar key_vault_resource_id: Resource ID of key vault. When keyVaultNetworkAccess is
     ``Private``\ , this field is required and must be a valid resource ID. When
     keyVaultNetworkAccess is ``Public``\ , leave the field empty.
    :vartype key_vault_resource_id: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "key_id": {"key": "keyId", "type": "str"},
        "key_vault_network_access": {"key": "keyVaultNetworkAccess", "type": "str"},
        "key_vault_resource_id": {"key": "keyVaultResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        key_id: Optional[str] = None,
        key_vault_network_access: Union[str, "_models.KeyVaultNetworkAccessTypes"] = "Public",
        key_vault_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Whether to enable Azure Key Vault key management service. The default is
         false.
        :paramtype enabled: bool
        :keyword key_id: Identifier of Azure Key Vault key. See `key identifier format
         <https://docs.microsoft.com/en-us/azure/key-vault/general/about-keys-secrets-certificates#vault-name-and-object-name>`_  # pylint: disable=line-too-long
         for more details. When Azure Key Vault key management service is enabled, this field is
         required and must be a valid key identifier. When Azure Key Vault key management service is
         disabled, leave the field empty.
        :paramtype key_id: str
        :keyword key_vault_network_access: Network access of key vault. The possible values are
         ``Public`` and ``Private``. ``Public`` means the key vault allows public access from all
         networks. ``Private`` means the key vault disables public access and enables private link. The
         default value is ``Public``. Known values are: "Public" and "Private".
        :paramtype key_vault_network_access: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.KeyVaultNetworkAccessTypes
        :keyword key_vault_resource_id: Resource ID of key vault. When keyVaultNetworkAccess is
         ``Private``\ , this field is required and must be a valid resource ID. When
         keyVaultNetworkAccess is ``Public``\ , leave the field empty.
        :paramtype key_vault_resource_id: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.key_id = key_id
        self.key_vault_network_access = key_vault_network_access
        self.key_vault_resource_id = key_vault_resource_id


class CloudErrorBody(_serialization.Model):
    """An error response from the Container service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.containerservice.v2024_01_01.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.containerservice.v2024_01_01.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ClusterUpgradeSettings(_serialization.Model):
    """Settings for upgrading a cluster.

    :ivar override_settings: Settings for overrides.
    :vartype override_settings:
     ~azure.mgmt.containerservice.v2024_01_01.models.UpgradeOverrideSettings
    """

    _attribute_map = {
        "override_settings": {"key": "overrideSettings", "type": "UpgradeOverrideSettings"},
    }

    def __init__(self, *, override_settings: Optional["_models.UpgradeOverrideSettings"] = None, **kwargs: Any) -> None:
        """
        :keyword override_settings: Settings for overrides.
        :paramtype override_settings:
         ~azure.mgmt.containerservice.v2024_01_01.models.UpgradeOverrideSettings
        """
        super().__init__(**kwargs)
        self.override_settings = override_settings


class CompatibleVersions(_serialization.Model):
    """Version information about a product/service that is compatible with a service mesh revision.

    :ivar name: The product/service name.
    :vartype name: str
    :ivar versions: Product/service versions compatible with a service mesh add-on revision.
    :vartype versions: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "versions": {"key": "versions", "type": "[str]"},
    }

    def __init__(self, *, name: Optional[str] = None, versions: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword name: The product/service name.
        :paramtype name: str
        :keyword versions: Product/service versions compatible with a service mesh add-on revision.
        :paramtype versions: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.versions = versions


class ContainerServiceLinuxProfile(_serialization.Model):
    """Profile for Linux VMs in the container service cluster.

    All required parameters must be populated in order to send to server.

    :ivar admin_username: The administrator username to use for Linux VMs. Required.
    :vartype admin_username: str
    :ivar ssh: The SSH configuration for Linux-based VMs running on Azure. Required.
    :vartype ssh: ~azure.mgmt.containerservice.v2024_01_01.models.ContainerServiceSshConfiguration
    """

    _validation = {
        "admin_username": {"required": True, "pattern": r"^[A-Za-z][-A-Za-z0-9_]*$"},
        "ssh": {"required": True},
    }

    _attribute_map = {
        "admin_username": {"key": "adminUsername", "type": "str"},
        "ssh": {"key": "ssh", "type": "ContainerServiceSshConfiguration"},
    }

    def __init__(self, *, admin_username: str, ssh: "_models.ContainerServiceSshConfiguration", **kwargs: Any) -> None:
        """
        :keyword admin_username: The administrator username to use for Linux VMs. Required.
        :paramtype admin_username: str
        :keyword ssh: The SSH configuration for Linux-based VMs running on Azure. Required.
        :paramtype ssh:
         ~azure.mgmt.containerservice.v2024_01_01.models.ContainerServiceSshConfiguration
        """
        super().__init__(**kwargs)
        self.admin_username = admin_username
        self.ssh = ssh


class ContainerServiceNetworkProfile(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Profile of network configuration.

    :ivar network_plugin: Network plugin used for building the Kubernetes network. Known values
     are: "azure", "kubenet", and "none".
    :vartype network_plugin: str or ~azure.mgmt.containerservice.v2024_01_01.models.NetworkPlugin
    :ivar network_plugin_mode: The mode the network plugin should use. "overlay"
    :vartype network_plugin_mode: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.NetworkPluginMode
    :ivar network_policy: Network policy used for building the Kubernetes network. Known values
     are: "calico", "azure", and "cilium".
    :vartype network_policy: str or ~azure.mgmt.containerservice.v2024_01_01.models.NetworkPolicy
    :ivar network_mode: This cannot be specified if networkPlugin is anything other than 'azure'.
     Known values are: "transparent" and "bridge".
    :vartype network_mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.NetworkMode
    :ivar network_dataplane: Network dataplane used in the Kubernetes cluster. Known values are:
     "azure" and "cilium".
    :vartype network_dataplane: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.NetworkDataplane
    :ivar pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
    :vartype pod_cidr: str
    :ivar service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :vartype service_cidr: str
    :ivar dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :vartype dns_service_ip: str
    :ivar outbound_type: This can only be set at cluster creation time and cannot be changed later.
     For more information see `egress outbound type
     <https://docs.microsoft.com/azure/aks/egress-outboundtype>`_. Known values are: "loadBalancer",
     "userDefinedRouting", "managedNATGateway", and "userAssignedNATGateway".
    :vartype outbound_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OutboundType
    :ivar load_balancer_sku: The default is 'standard'. See `Azure Load Balancer SKUs
     <https://docs.microsoft.com/azure/load-balancer/skus>`_ for more information about the
     differences between load balancer SKUs. Known values are: "standard" and "basic".
    :vartype load_balancer_sku: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.LoadBalancerSku
    :ivar load_balancer_profile: Profile of the cluster load balancer.
    :vartype load_balancer_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterLoadBalancerProfile
    :ivar nat_gateway_profile: Profile of the cluster NAT gateway.
    :vartype nat_gateway_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterNATGatewayProfile
    :ivar pod_cidrs: One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each
     IP family (IPv4/IPv6), is expected for dual-stack networking.
    :vartype pod_cidrs: list[str]
    :ivar service_cidrs: One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for
     each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with
     any Subnet IP ranges.
    :vartype service_cidrs: list[str]
    :ivar ip_families: IP families are used to determine single-stack or dual-stack clusters. For
     single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and
     IPv6.
    :vartype ip_families: list[str or ~azure.mgmt.containerservice.v2024_01_01.models.IpFamily]
    """

    _validation = {
        "pod_cidr": {"pattern": r"^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$"},
        "service_cidr": {"pattern": r"^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$"},
        "dns_service_ip": {
            "pattern": r"^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$"
        },
    }

    _attribute_map = {
        "network_plugin": {"key": "networkPlugin", "type": "str"},
        "network_plugin_mode": {"key": "networkPluginMode", "type": "str"},
        "network_policy": {"key": "networkPolicy", "type": "str"},
        "network_mode": {"key": "networkMode", "type": "str"},
        "network_dataplane": {"key": "networkDataplane", "type": "str"},
        "pod_cidr": {"key": "podCidr", "type": "str"},
        "service_cidr": {"key": "serviceCidr", "type": "str"},
        "dns_service_ip": {"key": "dnsServiceIP", "type": "str"},
        "outbound_type": {"key": "outboundType", "type": "str"},
        "load_balancer_sku": {"key": "loadBalancerSku", "type": "str"},
        "load_balancer_profile": {"key": "loadBalancerProfile", "type": "ManagedClusterLoadBalancerProfile"},
        "nat_gateway_profile": {"key": "natGatewayProfile", "type": "ManagedClusterNATGatewayProfile"},
        "pod_cidrs": {"key": "podCidrs", "type": "[str]"},
        "service_cidrs": {"key": "serviceCidrs", "type": "[str]"},
        "ip_families": {"key": "ipFamilies", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        network_plugin: Union[str, "_models.NetworkPlugin"] = "kubenet",
        network_plugin_mode: Optional[Union[str, "_models.NetworkPluginMode"]] = None,
        network_policy: Optional[Union[str, "_models.NetworkPolicy"]] = None,
        network_mode: Optional[Union[str, "_models.NetworkMode"]] = None,
        network_dataplane: Optional[Union[str, "_models.NetworkDataplane"]] = None,
        pod_cidr: str = "10.244.0.0/16",
        service_cidr: str = "10.0.0.0/16",
        dns_service_ip: str = "10.0.0.10",
        outbound_type: Union[str, "_models.OutboundType"] = "loadBalancer",
        load_balancer_sku: Optional[Union[str, "_models.LoadBalancerSku"]] = None,
        load_balancer_profile: Optional["_models.ManagedClusterLoadBalancerProfile"] = None,
        nat_gateway_profile: Optional["_models.ManagedClusterNATGatewayProfile"] = None,
        pod_cidrs: Optional[List[str]] = None,
        service_cidrs: Optional[List[str]] = None,
        ip_families: Optional[List[Union[str, "_models.IpFamily"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_plugin: Network plugin used for building the Kubernetes network. Known values
         are: "azure", "kubenet", and "none".
        :paramtype network_plugin: str or ~azure.mgmt.containerservice.v2024_01_01.models.NetworkPlugin
        :keyword network_plugin_mode: The mode the network plugin should use. "overlay"
        :paramtype network_plugin_mode: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.NetworkPluginMode
        :keyword network_policy: Network policy used for building the Kubernetes network. Known values
         are: "calico", "azure", and "cilium".
        :paramtype network_policy: str or ~azure.mgmt.containerservice.v2024_01_01.models.NetworkPolicy
        :keyword network_mode: This cannot be specified if networkPlugin is anything other than
         'azure'. Known values are: "transparent" and "bridge".
        :paramtype network_mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.NetworkMode
        :keyword network_dataplane: Network dataplane used in the Kubernetes cluster. Known values are:
         "azure" and "cilium".
        :paramtype network_dataplane: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.NetworkDataplane
        :keyword pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
        :paramtype pod_cidr: str
        :keyword service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It
         must not overlap with any Subnet IP ranges.
        :paramtype service_cidr: str
        :keyword dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be
         within the Kubernetes service address range specified in serviceCidr.
        :paramtype dns_service_ip: str
        :keyword outbound_type: This can only be set at cluster creation time and cannot be changed
         later. For more information see `egress outbound type
         <https://docs.microsoft.com/azure/aks/egress-outboundtype>`_. Known values are: "loadBalancer",
         "userDefinedRouting", "managedNATGateway", and "userAssignedNATGateway".
        :paramtype outbound_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OutboundType
        :keyword load_balancer_sku: The default is 'standard'. See `Azure Load Balancer SKUs
         <https://docs.microsoft.com/azure/load-balancer/skus>`_ for more information about the
         differences between load balancer SKUs. Known values are: "standard" and "basic".
        :paramtype load_balancer_sku: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.LoadBalancerSku
        :keyword load_balancer_profile: Profile of the cluster load balancer.
        :paramtype load_balancer_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterLoadBalancerProfile
        :keyword nat_gateway_profile: Profile of the cluster NAT gateway.
        :paramtype nat_gateway_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterNATGatewayProfile
        :keyword pod_cidrs: One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for
         each IP family (IPv4/IPv6), is expected for dual-stack networking.
        :paramtype pod_cidrs: list[str]
        :keyword service_cidrs: One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one
         for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap
         with any Subnet IP ranges.
        :paramtype service_cidrs: list[str]
        :keyword ip_families: IP families are used to determine single-stack or dual-stack clusters.
         For single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and
         IPv6.
        :paramtype ip_families: list[str or ~azure.mgmt.containerservice.v2024_01_01.models.IpFamily]
        """
        super().__init__(**kwargs)
        self.network_plugin = network_plugin
        self.network_plugin_mode = network_plugin_mode
        self.network_policy = network_policy
        self.network_mode = network_mode
        self.network_dataplane = network_dataplane
        self.pod_cidr = pod_cidr
        self.service_cidr = service_cidr
        self.dns_service_ip = dns_service_ip
        self.outbound_type = outbound_type
        self.load_balancer_sku = load_balancer_sku
        self.load_balancer_profile = load_balancer_profile
        self.nat_gateway_profile = nat_gateway_profile
        self.pod_cidrs = pod_cidrs
        self.service_cidrs = service_cidrs
        self.ip_families = ip_families


class ContainerServiceSshConfiguration(_serialization.Model):
    """SSH configuration for Linux-based VMs running on Azure.

    All required parameters must be populated in order to send to server.

    :ivar public_keys: The list of SSH public keys used to authenticate with Linux-based VMs. A
     maximum of 1 key may be specified. Required.
    :vartype public_keys:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ContainerServiceSshPublicKey]
    """

    _validation = {
        "public_keys": {"required": True},
    }

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[ContainerServiceSshPublicKey]"},
    }

    def __init__(self, *, public_keys: List["_models.ContainerServiceSshPublicKey"], **kwargs: Any) -> None:
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with Linux-based VMs. A
         maximum of 1 key may be specified. Required.
        :paramtype public_keys:
         list[~azure.mgmt.containerservice.v2024_01_01.models.ContainerServiceSshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class ContainerServiceSshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key data.

    All required parameters must be populated in order to send to server.

    :ivar key_data: Certificate public key used to authenticate with VMs through SSH. The
     certificate must be in PEM format with or without headers. Required.
    :vartype key_data: str
    """

    _validation = {
        "key_data": {"required": True},
    }

    _attribute_map = {
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, key_data: str, **kwargs: Any) -> None:
        """
        :keyword key_data: Certificate public key used to authenticate with VMs through SSH. The
         certificate must be in PEM format with or without headers. Required.
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.key_data = key_data


class CreationData(_serialization.Model):
    """Data used when creating a target resource from a source resource.

    :ivar source_resource_id: This is the ARM ID of the source object to be used to create the
     target object.
    :vartype source_resource_id: str
    """

    _attribute_map = {
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
    }

    def __init__(self, *, source_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword source_resource_id: This is the ARM ID of the source object to be used to create the
         target object.
        :paramtype source_resource_id: str
        """
        super().__init__(**kwargs)
        self.source_resource_id = source_resource_id


class CredentialResult(_serialization.Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytes
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "bytearray"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class CredentialResults(_serialization.Model):
    """The list credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs: list[~azure.mgmt.containerservice.v2024_01_01.models.CredentialResult]
    """

    _validation = {
        "kubeconfigs": {"readonly": True},
    }

    _attribute_map = {
        "kubeconfigs": {"key": "kubeconfigs", "type": "[CredentialResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kubeconfigs = None


class DailySchedule(_serialization.Model):
    """For schedules like: 'recur every day' or 'recur every 3 days'.

    All required parameters must be populated in order to send to server.

    :ivar interval_days: Specifies the number of days between each set of occurrences. Required.
    :vartype interval_days: int
    """

    _validation = {
        "interval_days": {"required": True, "maximum": 7, "minimum": 1},
    }

    _attribute_map = {
        "interval_days": {"key": "intervalDays", "type": "int"},
    }

    def __init__(self, *, interval_days: int, **kwargs: Any) -> None:
        """
        :keyword interval_days: Specifies the number of days between each set of occurrences. Required.
        :paramtype interval_days: int
        """
        super().__init__(**kwargs)
        self.interval_days = interval_days


class DateSpan(_serialization.Model):
    """For example, between '2022-12-23' and '2023-01-05'.

    All required parameters must be populated in order to send to server.

    :ivar start: The start date of the date span. Required.
    :vartype start: ~datetime.date
    :ivar end: The end date of the date span. Required.
    :vartype end: ~datetime.date
    """

    _validation = {
        "start": {"required": True},
        "end": {"required": True},
    }

    _attribute_map = {
        "start": {"key": "start", "type": "date"},
        "end": {"key": "end", "type": "date"},
    }

    def __init__(self, *, start: datetime.date, end: datetime.date, **kwargs: Any) -> None:
        """
        :keyword start: The start date of the date span. Required.
        :paramtype start: ~datetime.date
        :keyword end: The end date of the date span. Required.
        :paramtype end: ~datetime.date
        """
        super().__init__(**kwargs)
        self.start = start
        self.end = end


class DelegatedResource(_serialization.Model):
    """Delegated resource properties - internal use only.

    :ivar resource_id: The ARM resource id of the delegated resource - internal use only.
    :vartype resource_id: str
    :ivar tenant_id: The tenant id of the delegated resource - internal use only.
    :vartype tenant_id: str
    :ivar referral_resource: The delegation id of the referral delegation (optional) - internal use
     only.
    :vartype referral_resource: str
    :ivar location: The source resource location - internal use only.
    :vartype location: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "referral_resource": {"key": "referralResource", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        referral_resource: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The ARM resource id of the delegated resource - internal use only.
        :paramtype resource_id: str
        :keyword tenant_id: The tenant id of the delegated resource - internal use only.
        :paramtype tenant_id: str
        :keyword referral_resource: The delegation id of the referral delegation (optional) - internal
         use only.
        :paramtype referral_resource: str
        :keyword location: The source resource location - internal use only.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.tenant_id = tenant_id
        self.referral_resource = referral_resource
        self.location = location


class EndpointDependency(_serialization.Model):
    """A domain name that AKS agent nodes are reaching at.

    :ivar domain_name: The domain name of the dependency.
    :vartype domain_name: str
    :ivar endpoint_details: The Ports and Protocols used when connecting to domainName.
    :vartype endpoint_details: list[~azure.mgmt.containerservice.v2024_01_01.models.EndpointDetail]
    """

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "endpoint_details": {"key": "endpointDetails", "type": "[EndpointDetail]"},
    }

    def __init__(
        self,
        *,
        domain_name: Optional[str] = None,
        endpoint_details: Optional[List["_models.EndpointDetail"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword domain_name: The domain name of the dependency.
        :paramtype domain_name: str
        :keyword endpoint_details: The Ports and Protocols used when connecting to domainName.
        :paramtype endpoint_details:
         list[~azure.mgmt.containerservice.v2024_01_01.models.EndpointDetail]
        """
        super().__init__(**kwargs)
        self.domain_name = domain_name
        self.endpoint_details = endpoint_details


class EndpointDetail(_serialization.Model):
    """connect information from the AKS agent nodes to a single endpoint.

    :ivar ip_address: An IP Address that Domain Name currently resolves to.
    :vartype ip_address: str
    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    :ivar protocol: The protocol used for connection.
    :vartype protocol: str
    :ivar description: Description of the detail.
    :vartype description: str
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "protocol": {"key": "protocol", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ip_address: An IP Address that Domain Name currently resolves to.
        :paramtype ip_address: str
        :keyword port: The port an endpoint is connected to.
        :paramtype port: int
        :keyword protocol: The protocol used for connection.
        :paramtype protocol: str
        :keyword description: Description of the detail.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port
        self.protocol = protocol
        self.description = description


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.containerservice.v2024_01_01.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.containerservice.v2024_01_01.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.containerservice.v2024_01_01.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExtendedLocation(_serialization.Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "EdgeZone"
    :vartype type: str or ~azure.mgmt.containerservice.v2024_01_01.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "EdgeZone"
        :paramtype type: str or ~azure.mgmt.containerservice.v2024_01_01.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class IPTag(_serialization.Model):
    """Contains the IPTag associated with the object.

    :ivar ip_tag_type: The IP tag type. Example: RoutingPreference.
    :vartype ip_tag_type: str
    :ivar tag: The value of the IP tag associated with the public IP. Example: Internet.
    :vartype tag: str
    """

    _attribute_map = {
        "ip_tag_type": {"key": "ipTagType", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
    }

    def __init__(self, *, ip_tag_type: Optional[str] = None, tag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_tag_type: The IP tag type. Example: RoutingPreference.
        :paramtype ip_tag_type: str
        :keyword tag: The value of the IP tag associated with the public IP. Example: Internet.
        :paramtype tag: str
        """
        super().__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class IstioCertificateAuthority(_serialization.Model):
    """Istio Service Mesh Certificate Authority (CA) configuration. For now, we only support plugin
    certificates as described here https://aka.ms/asm-plugin-ca.

    :ivar plugin: Plugin certificates information for Service Mesh.
    :vartype plugin:
     ~azure.mgmt.containerservice.v2024_01_01.models.IstioPluginCertificateAuthority
    """

    _attribute_map = {
        "plugin": {"key": "plugin", "type": "IstioPluginCertificateAuthority"},
    }

    def __init__(self, *, plugin: Optional["_models.IstioPluginCertificateAuthority"] = None, **kwargs: Any) -> None:
        """
        :keyword plugin: Plugin certificates information for Service Mesh.
        :paramtype plugin:
         ~azure.mgmt.containerservice.v2024_01_01.models.IstioPluginCertificateAuthority
        """
        super().__init__(**kwargs)
        self.plugin = plugin


class IstioComponents(_serialization.Model):
    """Istio components configuration.

    :ivar ingress_gateways: Istio ingress gateways.
    :vartype ingress_gateways:
     list[~azure.mgmt.containerservice.v2024_01_01.models.IstioIngressGateway]
    :ivar egress_gateways: Istio egress gateways.
    :vartype egress_gateways:
     list[~azure.mgmt.containerservice.v2024_01_01.models.IstioEgressGateway]
    """

    _attribute_map = {
        "ingress_gateways": {"key": "ingressGateways", "type": "[IstioIngressGateway]"},
        "egress_gateways": {"key": "egressGateways", "type": "[IstioEgressGateway]"},
    }

    def __init__(
        self,
        *,
        ingress_gateways: Optional[List["_models.IstioIngressGateway"]] = None,
        egress_gateways: Optional[List["_models.IstioEgressGateway"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ingress_gateways: Istio ingress gateways.
        :paramtype ingress_gateways:
         list[~azure.mgmt.containerservice.v2024_01_01.models.IstioIngressGateway]
        :keyword egress_gateways: Istio egress gateways.
        :paramtype egress_gateways:
         list[~azure.mgmt.containerservice.v2024_01_01.models.IstioEgressGateway]
        """
        super().__init__(**kwargs)
        self.ingress_gateways = ingress_gateways
        self.egress_gateways = egress_gateways


class IstioEgressGateway(_serialization.Model):
    """Istio egress gateway configuration.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether to enable the egress gateway. Required.
    :vartype enabled: bool
    :ivar node_selector: NodeSelector for scheduling the egress gateway.
    :vartype node_selector: dict[str, str]
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "node_selector": {"key": "nodeSelector", "type": "{str}"},
    }

    def __init__(self, *, enabled: bool, node_selector: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable the egress gateway. Required.
        :paramtype enabled: bool
        :keyword node_selector: NodeSelector for scheduling the egress gateway.
        :paramtype node_selector: dict[str, str]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.node_selector = node_selector


class IstioIngressGateway(_serialization.Model):
    """Istio ingress gateway configuration. For now, we support up to one external ingress gateway
    named ``aks-istio-ingressgateway-external`` and one internal ingress gateway named
    ``aks-istio-ingressgateway-internal``.

    All required parameters must be populated in order to send to server.

    :ivar mode: Mode of an ingress gateway. Required. Known values are: "External" and "Internal".
    :vartype mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.IstioIngressGatewayMode
    :ivar enabled: Whether to enable the ingress gateway. Required.
    :vartype enabled: bool
    """

    _validation = {
        "mode": {"required": True},
        "enabled": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, mode: Union[str, "_models.IstioIngressGatewayMode"], enabled: bool, **kwargs: Any) -> None:
        """
        :keyword mode: Mode of an ingress gateway. Required. Known values are: "External" and
         "Internal".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.IstioIngressGatewayMode
        :keyword enabled: Whether to enable the ingress gateway. Required.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.enabled = enabled


class IstioPluginCertificateAuthority(_serialization.Model):
    """Plugin certificates information for Service Mesh.

    :ivar key_vault_id: The resource ID of the Key Vault.
    :vartype key_vault_id: str
    :ivar cert_object_name: Intermediate certificate object name in Azure Key Vault.
    :vartype cert_object_name: str
    :ivar key_object_name: Intermediate certificate private key object name in Azure Key Vault.
    :vartype key_object_name: str
    :ivar root_cert_object_name: Root certificate object name in Azure Key Vault.
    :vartype root_cert_object_name: str
    :ivar cert_chain_object_name: Certificate chain object name in Azure Key Vault.
    :vartype cert_chain_object_name: str
    """

    _attribute_map = {
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "cert_object_name": {"key": "certObjectName", "type": "str"},
        "key_object_name": {"key": "keyObjectName", "type": "str"},
        "root_cert_object_name": {"key": "rootCertObjectName", "type": "str"},
        "cert_chain_object_name": {"key": "certChainObjectName", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_vault_id: Optional[str] = None,
        cert_object_name: Optional[str] = None,
        key_object_name: Optional[str] = None,
        root_cert_object_name: Optional[str] = None,
        cert_chain_object_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_id: The resource ID of the Key Vault.
        :paramtype key_vault_id: str
        :keyword cert_object_name: Intermediate certificate object name in Azure Key Vault.
        :paramtype cert_object_name: str
        :keyword key_object_name: Intermediate certificate private key object name in Azure Key Vault.
        :paramtype key_object_name: str
        :keyword root_cert_object_name: Root certificate object name in Azure Key Vault.
        :paramtype root_cert_object_name: str
        :keyword cert_chain_object_name: Certificate chain object name in Azure Key Vault.
        :paramtype cert_chain_object_name: str
        """
        super().__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.cert_object_name = cert_object_name
        self.key_object_name = key_object_name
        self.root_cert_object_name = root_cert_object_name
        self.cert_chain_object_name = cert_chain_object_name


class IstioServiceMesh(_serialization.Model):
    """Istio service mesh configuration.

    :ivar components: Istio components configuration.
    :vartype components: ~azure.mgmt.containerservice.v2024_01_01.models.IstioComponents
    :ivar certificate_authority: Istio Service Mesh Certificate Authority (CA) configuration. For
     now, we only support plugin certificates as described here https://aka.ms/asm-plugin-ca.
    :vartype certificate_authority:
     ~azure.mgmt.containerservice.v2024_01_01.models.IstioCertificateAuthority
    :ivar revisions: The list of revisions of the Istio control plane. When an upgrade is not in
     progress, this holds one value. When canary upgrade is in progress, this can only hold two
     consecutive values. For more information, see:
     https://learn.microsoft.com/en-us/azure/aks/istio-upgrade.
    :vartype revisions: list[str]
    """

    _validation = {
        "revisions": {"max_items": 2, "min_items": 0, "unique": True},
    }

    _attribute_map = {
        "components": {"key": "components", "type": "IstioComponents"},
        "certificate_authority": {"key": "certificateAuthority", "type": "IstioCertificateAuthority"},
        "revisions": {"key": "revisions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        components: Optional["_models.IstioComponents"] = None,
        certificate_authority: Optional["_models.IstioCertificateAuthority"] = None,
        revisions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword components: Istio components configuration.
        :paramtype components: ~azure.mgmt.containerservice.v2024_01_01.models.IstioComponents
        :keyword certificate_authority: Istio Service Mesh Certificate Authority (CA) configuration.
         For now, we only support plugin certificates as described here https://aka.ms/asm-plugin-ca.
        :paramtype certificate_authority:
         ~azure.mgmt.containerservice.v2024_01_01.models.IstioCertificateAuthority
        :keyword revisions: The list of revisions of the Istio control plane. When an upgrade is not in
         progress, this holds one value. When canary upgrade is in progress, this can only hold two
         consecutive values. For more information, see:
         https://learn.microsoft.com/en-us/azure/aks/istio-upgrade.
        :paramtype revisions: list[str]
        """
        super().__init__(**kwargs)
        self.components = components
        self.certificate_authority = certificate_authority
        self.revisions = revisions


class KubeletConfig(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """See `AKS custom node configuration
    <https://docs.microsoft.com/azure/aks/custom-node-configuration>`_ for more details.

    :ivar cpu_manager_policy: The default is 'none'. See `Kubernetes CPU management policies
     <https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies>`_
     for more information. Allowed values are 'none' and 'static'.
    :vartype cpu_manager_policy: str
    :ivar cpu_cfs_quota: The default is true.
    :vartype cpu_cfs_quota: bool
    :ivar cpu_cfs_quota_period: The default is '100ms.' Valid values are a sequence of decimal
     numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported
     units are 'ns', 'us', 'ms', 's', 'm', and 'h'.
    :vartype cpu_cfs_quota_period: str
    :ivar image_gc_high_threshold: To disable image garbage collection, set to 100. The default is
     85%.
    :vartype image_gc_high_threshold: int
    :ivar image_gc_low_threshold: This cannot be set higher than imageGcHighThreshold. The default
     is 80%.
    :vartype image_gc_low_threshold: int
    :ivar topology_manager_policy: For more information see `Kubernetes Topology Manager
     <https://kubernetes.io/docs/tasks/administer-cluster/topology-manager>`_. The default is
     'none'. Allowed values are 'none', 'best-effort', 'restricted', and 'single-numa-node'.
    :vartype topology_manager_policy: str
    :ivar allowed_unsafe_sysctls: Allowed list of unsafe sysctls or unsafe sysctl patterns (ending
     in ``*``\ ).
    :vartype allowed_unsafe_sysctls: list[str]
    :ivar fail_swap_on: If set to true it will make the Kubelet fail to start if swap is enabled on
     the node.
    :vartype fail_swap_on: bool
    :ivar container_log_max_size_mb: The maximum size (e.g. 10Mi) of container log file before it
     is rotated.
    :vartype container_log_max_size_mb: int
    :ivar container_log_max_files: The maximum number of container log files that can be present
     for a container. The number must be ≥ 2.
    :vartype container_log_max_files: int
    :ivar pod_max_pids: The maximum number of processes per pod.
    :vartype pod_max_pids: int
    """

    _validation = {
        "container_log_max_files": {"minimum": 2},
    }

    _attribute_map = {
        "cpu_manager_policy": {"key": "cpuManagerPolicy", "type": "str"},
        "cpu_cfs_quota": {"key": "cpuCfsQuota", "type": "bool"},
        "cpu_cfs_quota_period": {"key": "cpuCfsQuotaPeriod", "type": "str"},
        "image_gc_high_threshold": {"key": "imageGcHighThreshold", "type": "int"},
        "image_gc_low_threshold": {"key": "imageGcLowThreshold", "type": "int"},
        "topology_manager_policy": {"key": "topologyManagerPolicy", "type": "str"},
        "allowed_unsafe_sysctls": {"key": "allowedUnsafeSysctls", "type": "[str]"},
        "fail_swap_on": {"key": "failSwapOn", "type": "bool"},
        "container_log_max_size_mb": {"key": "containerLogMaxSizeMB", "type": "int"},
        "container_log_max_files": {"key": "containerLogMaxFiles", "type": "int"},
        "pod_max_pids": {"key": "podMaxPids", "type": "int"},
    }

    def __init__(
        self,
        *,
        cpu_manager_policy: Optional[str] = None,
        cpu_cfs_quota: Optional[bool] = None,
        cpu_cfs_quota_period: Optional[str] = None,
        image_gc_high_threshold: Optional[int] = None,
        image_gc_low_threshold: Optional[int] = None,
        topology_manager_policy: Optional[str] = None,
        allowed_unsafe_sysctls: Optional[List[str]] = None,
        fail_swap_on: Optional[bool] = None,
        container_log_max_size_mb: Optional[int] = None,
        container_log_max_files: Optional[int] = None,
        pod_max_pids: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cpu_manager_policy: The default is 'none'. See `Kubernetes CPU management policies
         <https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies>`_
         for more information. Allowed values are 'none' and 'static'.
        :paramtype cpu_manager_policy: str
        :keyword cpu_cfs_quota: The default is true.
        :paramtype cpu_cfs_quota: bool
        :keyword cpu_cfs_quota_period: The default is '100ms.' Valid values are a sequence of decimal
         numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported
         units are 'ns', 'us', 'ms', 's', 'm', and 'h'.
        :paramtype cpu_cfs_quota_period: str
        :keyword image_gc_high_threshold: To disable image garbage collection, set to 100. The default
         is 85%.
        :paramtype image_gc_high_threshold: int
        :keyword image_gc_low_threshold: This cannot be set higher than imageGcHighThreshold. The
         default is 80%.
        :paramtype image_gc_low_threshold: int
        :keyword topology_manager_policy: For more information see `Kubernetes Topology Manager
         <https://kubernetes.io/docs/tasks/administer-cluster/topology-manager>`_. The default is
         'none'. Allowed values are 'none', 'best-effort', 'restricted', and 'single-numa-node'.
        :paramtype topology_manager_policy: str
        :keyword allowed_unsafe_sysctls: Allowed list of unsafe sysctls or unsafe sysctl patterns
         (ending in ``*``\ ).
        :paramtype allowed_unsafe_sysctls: list[str]
        :keyword fail_swap_on: If set to true it will make the Kubelet fail to start if swap is enabled
         on the node.
        :paramtype fail_swap_on: bool
        :keyword container_log_max_size_mb: The maximum size (e.g. 10Mi) of container log file before
         it is rotated.
        :paramtype container_log_max_size_mb: int
        :keyword container_log_max_files: The maximum number of container log files that can be present
         for a container. The number must be ≥ 2.
        :paramtype container_log_max_files: int
        :keyword pod_max_pids: The maximum number of processes per pod.
        :paramtype pod_max_pids: int
        """
        super().__init__(**kwargs)
        self.cpu_manager_policy = cpu_manager_policy
        self.cpu_cfs_quota = cpu_cfs_quota
        self.cpu_cfs_quota_period = cpu_cfs_quota_period
        self.image_gc_high_threshold = image_gc_high_threshold
        self.image_gc_low_threshold = image_gc_low_threshold
        self.topology_manager_policy = topology_manager_policy
        self.allowed_unsafe_sysctls = allowed_unsafe_sysctls
        self.fail_swap_on = fail_swap_on
        self.container_log_max_size_mb = container_log_max_size_mb
        self.container_log_max_files = container_log_max_files
        self.pod_max_pids = pod_max_pids


class KubernetesPatchVersion(_serialization.Model):
    """Kubernetes patch version profile.

    :ivar upgrades: Possible upgrade path for given patch version.
    :vartype upgrades: list[str]
    """

    _attribute_map = {
        "upgrades": {"key": "upgrades", "type": "[str]"},
    }

    def __init__(self, *, upgrades: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword upgrades: Possible upgrade path for given patch version.
        :paramtype upgrades: list[str]
        """
        super().__init__(**kwargs)
        self.upgrades = upgrades


class KubernetesVersion(_serialization.Model):
    """Kubernetes version profile for given major.minor release.

    :ivar version: major.minor version of Kubernetes release.
    :vartype version: str
    :ivar capabilities: Capabilities on this Kubernetes version.
    :vartype capabilities:
     ~azure.mgmt.containerservice.v2024_01_01.models.KubernetesVersionCapabilities
    :ivar is_preview: Whether this version is in preview mode.
    :vartype is_preview: bool
    :ivar patch_versions: Patch versions of Kubernetes release.
    :vartype patch_versions: dict[str,
     ~azure.mgmt.containerservice.v2024_01_01.models.KubernetesPatchVersion]
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "capabilities": {"key": "capabilities", "type": "KubernetesVersionCapabilities"},
        "is_preview": {"key": "isPreview", "type": "bool"},
        "patch_versions": {"key": "patchVersions", "type": "{KubernetesPatchVersion}"},
    }

    def __init__(
        self,
        *,
        version: Optional[str] = None,
        capabilities: Optional["_models.KubernetesVersionCapabilities"] = None,
        is_preview: Optional[bool] = None,
        patch_versions: Optional[Dict[str, "_models.KubernetesPatchVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword version: major.minor version of Kubernetes release.
        :paramtype version: str
        :keyword capabilities: Capabilities on this Kubernetes version.
        :paramtype capabilities:
         ~azure.mgmt.containerservice.v2024_01_01.models.KubernetesVersionCapabilities
        :keyword is_preview: Whether this version is in preview mode.
        :paramtype is_preview: bool
        :keyword patch_versions: Patch versions of Kubernetes release.
        :paramtype patch_versions: dict[str,
         ~azure.mgmt.containerservice.v2024_01_01.models.KubernetesPatchVersion]
        """
        super().__init__(**kwargs)
        self.version = version
        self.capabilities = capabilities
        self.is_preview = is_preview
        self.patch_versions = patch_versions


class KubernetesVersionCapabilities(_serialization.Model):
    """Capabilities on this Kubernetes version.

    :ivar support_plan:
    :vartype support_plan: list[str or
     ~azure.mgmt.containerservice.v2024_01_01.models.KubernetesSupportPlan]
    """

    _attribute_map = {
        "support_plan": {"key": "supportPlan", "type": "[str]"},
    }

    def __init__(
        self, *, support_plan: Optional[List[Union[str, "_models.KubernetesSupportPlan"]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword support_plan:
        :paramtype support_plan: list[str or
         ~azure.mgmt.containerservice.v2024_01_01.models.KubernetesSupportPlan]
        """
        super().__init__(**kwargs)
        self.support_plan = support_plan


class KubernetesVersionListResult(_serialization.Model):
    """Hold values properties, which is array of KubernetesVersion.

    :ivar values: Array of AKS supported Kubernetes versions.
    :vartype values: list[~azure.mgmt.containerservice.v2024_01_01.models.KubernetesVersion]
    """

    _attribute_map = {
        "values": {"key": "values", "type": "[KubernetesVersion]"},
    }

    def __init__(self, *, values: Optional[List["_models.KubernetesVersion"]] = None, **kwargs: Any) -> None:
        """
        :keyword values: Array of AKS supported Kubernetes versions.
        :paramtype values: list[~azure.mgmt.containerservice.v2024_01_01.models.KubernetesVersion]
        """
        super().__init__(**kwargs)
        self.values = values


class LinuxOSConfig(_serialization.Model):
    """See `AKS custom node configuration
    <https://docs.microsoft.com/azure/aks/custom-node-configuration>`_ for more details.

    :ivar sysctls: Sysctl settings for Linux agent nodes.
    :vartype sysctls: ~azure.mgmt.containerservice.v2024_01_01.models.SysctlConfig
    :ivar transparent_huge_page_enabled: Valid values are 'always', 'madvise', and 'never'. The
     default is 'always'. For more information see `Transparent Hugepages
     <https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge>`_.
    :vartype transparent_huge_page_enabled: str
    :ivar transparent_huge_page_defrag: Valid values are 'always', 'defer', 'defer+madvise',
     'madvise' and 'never'. The default is 'madvise'. For more information see `Transparent
     Hugepages
     <https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge>`_.
    :vartype transparent_huge_page_defrag: str
    :ivar swap_file_size_mb: The size in MB of a swap file that will be created on each node.
    :vartype swap_file_size_mb: int
    """

    _attribute_map = {
        "sysctls": {"key": "sysctls", "type": "SysctlConfig"},
        "transparent_huge_page_enabled": {"key": "transparentHugePageEnabled", "type": "str"},
        "transparent_huge_page_defrag": {"key": "transparentHugePageDefrag", "type": "str"},
        "swap_file_size_mb": {"key": "swapFileSizeMB", "type": "int"},
    }

    def __init__(
        self,
        *,
        sysctls: Optional["_models.SysctlConfig"] = None,
        transparent_huge_page_enabled: Optional[str] = None,
        transparent_huge_page_defrag: Optional[str] = None,
        swap_file_size_mb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sysctls: Sysctl settings for Linux agent nodes.
        :paramtype sysctls: ~azure.mgmt.containerservice.v2024_01_01.models.SysctlConfig
        :keyword transparent_huge_page_enabled: Valid values are 'always', 'madvise', and 'never'. The
         default is 'always'. For more information see `Transparent Hugepages
         <https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge>`_.
        :paramtype transparent_huge_page_enabled: str
        :keyword transparent_huge_page_defrag: Valid values are 'always', 'defer', 'defer+madvise',
         'madvise' and 'never'. The default is 'madvise'. For more information see `Transparent
         Hugepages
         <https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge>`_.
        :paramtype transparent_huge_page_defrag: str
        :keyword swap_file_size_mb: The size in MB of a swap file that will be created on each node.
        :paramtype swap_file_size_mb: int
        """
        super().__init__(**kwargs)
        self.sysctls = sysctls
        self.transparent_huge_page_enabled = transparent_huge_page_enabled
        self.transparent_huge_page_defrag = transparent_huge_page_defrag
        self.swap_file_size_mb = swap_file_size_mb


class MaintenanceConfiguration(SubResource):
    """See `planned maintenance <https://docs.microsoft.com/azure/aks/planned-maintenance>`_ for more
    information about planned maintenance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.containerservice.v2024_01_01.models.SystemData
    :ivar time_in_week: If two array entries specify the same day of the week, the applied
     configuration is the union of times in both entries.
    :vartype time_in_week: list[~azure.mgmt.containerservice.v2024_01_01.models.TimeInWeek]
    :ivar not_allowed_time: Time slots on which upgrade is not allowed.
    :vartype not_allowed_time: list[~azure.mgmt.containerservice.v2024_01_01.models.TimeSpan]
    :ivar maintenance_window: Maintenance window for the maintenance configuration.
    :vartype maintenance_window: ~azure.mgmt.containerservice.v2024_01_01.models.MaintenanceWindow
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "time_in_week": {"key": "properties.timeInWeek", "type": "[TimeInWeek]"},
        "not_allowed_time": {"key": "properties.notAllowedTime", "type": "[TimeSpan]"},
        "maintenance_window": {"key": "properties.maintenanceWindow", "type": "MaintenanceWindow"},
    }

    def __init__(
        self,
        *,
        time_in_week: Optional[List["_models.TimeInWeek"]] = None,
        not_allowed_time: Optional[List["_models.TimeSpan"]] = None,
        maintenance_window: Optional["_models.MaintenanceWindow"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_in_week: If two array entries specify the same day of the week, the applied
         configuration is the union of times in both entries.
        :paramtype time_in_week: list[~azure.mgmt.containerservice.v2024_01_01.models.TimeInWeek]
        :keyword not_allowed_time: Time slots on which upgrade is not allowed.
        :paramtype not_allowed_time: list[~azure.mgmt.containerservice.v2024_01_01.models.TimeSpan]
        :keyword maintenance_window: Maintenance window for the maintenance configuration.
        :paramtype maintenance_window:
         ~azure.mgmt.containerservice.v2024_01_01.models.MaintenanceWindow
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.time_in_week = time_in_week
        self.not_allowed_time = not_allowed_time
        self.maintenance_window = maintenance_window


class MaintenanceConfigurationListResult(_serialization.Model):
    """The response from the List maintenance configurations operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of maintenance configurations.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.MaintenanceConfiguration]
    :ivar next_link: The URL to get the next set of maintenance configuration results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MaintenanceConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.MaintenanceConfiguration"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of maintenance configurations.
        :paramtype value:
         list[~azure.mgmt.containerservice.v2024_01_01.models.MaintenanceConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class MaintenanceWindow(_serialization.Model):
    """Maintenance window used to configure scheduled auto-upgrade for a Managed Cluster.

    All required parameters must be populated in order to send to server.

    :ivar schedule: Recurrence schedule for the maintenance window. Required.
    :vartype schedule: ~azure.mgmt.containerservice.v2024_01_01.models.Schedule
    :ivar duration_hours: Length of maintenance window range from 4 to 24 hours.
    :vartype duration_hours: int
    :ivar utc_offset: The UTC offset in format +/-HH:mm. For example, '+05:30' for IST and '-07:00'
     for PST. If not specified, the default is '+00:00'.
    :vartype utc_offset: str
    :ivar start_date: The date the maintenance window activates. If the current date is before this
     date, the maintenance window is inactive and will not be used for upgrades. If not specified,
     the maintenance window will be active right away.
    :vartype start_date: ~datetime.date
    :ivar start_time: The start time of the maintenance window. Accepted values are from '00:00' to
     '23:59'. 'utcOffset' applies to this field. For example: '02:00' with 'utcOffset: +02:00' means
     UTC time '00:00'. Required.
    :vartype start_time: str
    :ivar not_allowed_dates: Date ranges on which upgrade is not allowed. 'utcOffset' applies to
     this field. For example, with 'utcOffset: +02:00' and 'dateSpan' being '2022-12-23' to
     '2023-01-03', maintenance will be blocked from '2022-12-22 22:00' to '2023-01-03 22:00' in UTC
     time.
    :vartype not_allowed_dates: list[~azure.mgmt.containerservice.v2024_01_01.models.DateSpan]
    """

    _validation = {
        "schedule": {"required": True},
        "duration_hours": {"required": True, "maximum": 24, "minimum": 4},
        "utc_offset": {"pattern": r"^(-|\+)[0-9]{2}:[0-9]{2}$"},
        "start_time": {"required": True, "pattern": r"^\d{2}:\d{2}$"},
    }

    _attribute_map = {
        "schedule": {"key": "schedule", "type": "Schedule"},
        "duration_hours": {"key": "durationHours", "type": "int"},
        "utc_offset": {"key": "utcOffset", "type": "str"},
        "start_date": {"key": "startDate", "type": "date"},
        "start_time": {"key": "startTime", "type": "str"},
        "not_allowed_dates": {"key": "notAllowedDates", "type": "[DateSpan]"},
    }

    def __init__(
        self,
        *,
        schedule: "_models.Schedule",
        duration_hours: int = 24,
        start_time: str,
        utc_offset: Optional[str] = None,
        start_date: Optional[datetime.date] = None,
        not_allowed_dates: Optional[List["_models.DateSpan"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schedule: Recurrence schedule for the maintenance window. Required.
        :paramtype schedule: ~azure.mgmt.containerservice.v2024_01_01.models.Schedule
        :keyword duration_hours: Length of maintenance window range from 4 to 24 hours.
        :paramtype duration_hours: int
        :keyword utc_offset: The UTC offset in format +/-HH:mm. For example, '+05:30' for IST and
         '-07:00' for PST. If not specified, the default is '+00:00'.
        :paramtype utc_offset: str
        :keyword start_date: The date the maintenance window activates. If the current date is before
         this date, the maintenance window is inactive and will not be used for upgrades. If not
         specified, the maintenance window will be active right away.
        :paramtype start_date: ~datetime.date
        :keyword start_time: The start time of the maintenance window. Accepted values are from '00:00'
         to '23:59'. 'utcOffset' applies to this field. For example: '02:00' with 'utcOffset: +02:00'
         means UTC time '00:00'. Required.
        :paramtype start_time: str
        :keyword not_allowed_dates: Date ranges on which upgrade is not allowed. 'utcOffset' applies to
         this field. For example, with 'utcOffset: +02:00' and 'dateSpan' being '2022-12-23' to
         '2023-01-03', maintenance will be blocked from '2022-12-22 22:00' to '2023-01-03 22:00' in UTC
         time.
        :paramtype not_allowed_dates: list[~azure.mgmt.containerservice.v2024_01_01.models.DateSpan]
        """
        super().__init__(**kwargs)
        self.schedule = schedule
        self.duration_hours = duration_hours
        self.utc_offset = utc_offset
        self.start_date = start_date
        self.start_time = start_time
        self.not_allowed_dates = not_allowed_dates


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservice.v2024_01_01.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservice.v2024_01_01.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class ManagedCluster(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservice.v2024_01_01.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: The managed cluster SKU.
    :vartype sku: ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSKU
    :ivar extended_location: The extended location of the Virtual Machine.
    :vartype extended_location: ~azure.mgmt.containerservice.v2024_01_01.models.ExtendedLocation
    :ivar identity: The identity of the managed cluster, if configured.
    :vartype identity: ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterIdentity
    :ivar provisioning_state: The current provisioning state.
    :vartype provisioning_state: str
    :ivar power_state: The Power State of the cluster.
    :vartype power_state: ~azure.mgmt.containerservice.v2024_01_01.models.PowerState
    :ivar max_agent_pools: The max number of agent pools for the managed cluster.
    :vartype max_agent_pools: int
    :ivar kubernetes_version: Both patch version <major.minor.patch> (e.g. 1.20.13) and
     <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported
     GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once
     it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch
     version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions
     cannot be skipped. All upgrades must be performed sequentially by major version number. For
     example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x ->
     1.16.x is not allowed. See `upgrading an AKS cluster
     <https://docs.microsoft.com/azure/aks/upgrade-cluster>`_ for more details.
    :vartype kubernetes_version: str
    :ivar current_kubernetes_version: If kubernetesVersion was a fully specified version
     <major.minor.patch>, this field will be exactly equal to it. If kubernetesVersion was
     <major.minor>, this field will contain the full <major.minor.patch> version being used.
    :vartype current_kubernetes_version: str
    :ivar dns_prefix: This cannot be updated once the Managed Cluster has been created.
    :vartype dns_prefix: str
    :ivar fqdn_subdomain: This cannot be updated once the Managed Cluster has been created.
    :vartype fqdn_subdomain: str
    :ivar fqdn: The FQDN of the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: The FQDN of private cluster.
    :vartype private_fqdn: str
    :ivar azure_portal_fqdn: The Azure Portal requires certain Cross-Origin Resource Sharing (CORS)
     headers to be sent in some responses, which Kubernetes APIServer doesn't handle by default.
     This special FQDN supports CORS, allowing the Azure Portal to function properly.
    :vartype azure_portal_fqdn: str
    :ivar agent_pool_profiles: The agent pool properties.
    :vartype agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAgentPoolProfile]
    :ivar linux_profile: The profile for Linux VMs in the Managed Cluster.
    :vartype linux_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ContainerServiceLinuxProfile
    :ivar windows_profile: The profile for Windows VMs in the Managed Cluster.
    :vartype windows_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterWindowsProfile
    :ivar service_principal_profile: Information about a service principal identity for the cluster
     to use for manipulating Azure APIs.
    :vartype service_principal_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterServicePrincipalProfile
    :ivar addon_profiles: The profile of managed cluster add-on.
    :vartype addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAddonProfile]
    :ivar pod_identity_profile: See `use AAD pod identity
     <https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity>`_ for more details on AAD pod
     identity integration.
    :vartype pod_identity_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityProfile
    :ivar oidc_issuer_profile: The OIDC issuer profile of the Managed Cluster.
    :vartype oidc_issuer_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterOIDCIssuerProfile
    :ivar node_resource_group: The name of the resource group containing agent pool nodes.
    :vartype node_resource_group: str
    :ivar enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
    :vartype enable_rbac: bool
    :ivar support_plan: The support plan for the Managed Cluster. If unspecified, the default is
     'KubernetesOfficial'. Known values are: "KubernetesOfficial" and "AKSLongTermSupport".
    :vartype support_plan: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.KubernetesSupportPlan
    :ivar enable_pod_security_policy: (DEPRECATED) Whether to enable Kubernetes pod security policy
     (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in
     v1.25. Learn more at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
    :vartype enable_pod_security_policy: bool
    :ivar network_profile: The network configuration profile.
    :vartype network_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ContainerServiceNetworkProfile
    :ivar aad_profile: The Azure Active Directory configuration.
    :vartype aad_profile: ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAADProfile
    :ivar auto_upgrade_profile: The auto upgrade configuration.
    :vartype auto_upgrade_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAutoUpgradeProfile
    :ivar upgrade_settings: Settings for upgrading a cluster.
    :vartype upgrade_settings:
     ~azure.mgmt.containerservice.v2024_01_01.models.ClusterUpgradeSettings
    :ivar auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
    :vartype auto_scaler_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPropertiesAutoScalerProfile
    :ivar api_server_access_profile: The access profile for managed cluster API server.
    :vartype api_server_access_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAPIServerAccessProfile
    :ivar disk_encryption_set_id: This is of the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'.  # pylint: disable=line-too-long
    :vartype disk_encryption_set_id: str
    :ivar identity_profile: Identities associated with the cluster.
    :vartype identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2024_01_01.models.UserAssignedIdentity]
    :ivar private_link_resources: Private link resources associated with the cluster.
    :vartype private_link_resources:
     list[~azure.mgmt.containerservice.v2024_01_01.models.PrivateLinkResource]
    :ivar disable_local_accounts: If set to true, getting static credentials will be disabled for
     this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details
     see `disable local accounts
     <https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview>`_.
    :vartype disable_local_accounts: bool
    :ivar http_proxy_config: Configurations for provisioning the cluster with HTTP proxy servers.
    :vartype http_proxy_config:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterHTTPProxyConfig
    :ivar security_profile: Security profile for the managed cluster.
    :vartype security_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSecurityProfile
    :ivar storage_profile: Storage profile for the managed cluster.
    :vartype storage_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterStorageProfile
    :ivar ingress_profile: Ingress profile for the managed cluster.
    :vartype ingress_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterIngressProfile
    :ivar public_network_access: Allow or deny public network access for AKS. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.PublicNetworkAccess
    :ivar workload_auto_scaler_profile: Workload Auto-scaler profile for the managed cluster.
    :vartype workload_auto_scaler_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterWorkloadAutoScalerProfile
    :ivar azure_monitor_profile: Azure Monitor addon profiles for monitoring the managed cluster.
    :vartype azure_monitor_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAzureMonitorProfile
    :ivar service_mesh_profile: Service mesh profile for a managed cluster.
    :vartype service_mesh_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ServiceMeshProfile
    :ivar resource_uid: The resourceUID uniquely identifies ManagedClusters that reuse ARM
     ResourceIds (i.e: create, delete, create sequence).
    :vartype resource_uid: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "power_state": {"readonly": True},
        "max_agent_pools": {"readonly": True},
        "current_kubernetes_version": {"readonly": True},
        "fqdn": {"readonly": True},
        "private_fqdn": {"readonly": True},
        "azure_portal_fqdn": {"readonly": True},
        "resource_uid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "ManagedClusterSKU"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "identity": {"key": "identity", "type": "ManagedClusterIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "power_state": {"key": "properties.powerState", "type": "PowerState"},
        "max_agent_pools": {"key": "properties.maxAgentPools", "type": "int"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "current_kubernetes_version": {"key": "properties.currentKubernetesVersion", "type": "str"},
        "dns_prefix": {"key": "properties.dnsPrefix", "type": "str"},
        "fqdn_subdomain": {"key": "properties.fqdnSubdomain", "type": "str"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "private_fqdn": {"key": "properties.privateFQDN", "type": "str"},
        "azure_portal_fqdn": {"key": "properties.azurePortalFQDN", "type": "str"},
        "agent_pool_profiles": {"key": "properties.agentPoolProfiles", "type": "[ManagedClusterAgentPoolProfile]"},
        "linux_profile": {"key": "properties.linuxProfile", "type": "ContainerServiceLinuxProfile"},
        "windows_profile": {"key": "properties.windowsProfile", "type": "ManagedClusterWindowsProfile"},
        "service_principal_profile": {
            "key": "properties.servicePrincipalProfile",
            "type": "ManagedClusterServicePrincipalProfile",
        },
        "addon_profiles": {"key": "properties.addonProfiles", "type": "{ManagedClusterAddonProfile}"},
        "pod_identity_profile": {"key": "properties.podIdentityProfile", "type": "ManagedClusterPodIdentityProfile"},
        "oidc_issuer_profile": {"key": "properties.oidcIssuerProfile", "type": "ManagedClusterOIDCIssuerProfile"},
        "node_resource_group": {"key": "properties.nodeResourceGroup", "type": "str"},
        "enable_rbac": {"key": "properties.enableRBAC", "type": "bool"},
        "support_plan": {"key": "properties.supportPlan", "type": "str"},
        "enable_pod_security_policy": {"key": "properties.enablePodSecurityPolicy", "type": "bool"},
        "network_profile": {"key": "properties.networkProfile", "type": "ContainerServiceNetworkProfile"},
        "aad_profile": {"key": "properties.aadProfile", "type": "ManagedClusterAADProfile"},
        "auto_upgrade_profile": {"key": "properties.autoUpgradeProfile", "type": "ManagedClusterAutoUpgradeProfile"},
        "upgrade_settings": {"key": "properties.upgradeSettings", "type": "ClusterUpgradeSettings"},
        "auto_scaler_profile": {
            "key": "properties.autoScalerProfile",
            "type": "ManagedClusterPropertiesAutoScalerProfile",
        },
        "api_server_access_profile": {
            "key": "properties.apiServerAccessProfile",
            "type": "ManagedClusterAPIServerAccessProfile",
        },
        "disk_encryption_set_id": {"key": "properties.diskEncryptionSetID", "type": "str"},
        "identity_profile": {"key": "properties.identityProfile", "type": "{UserAssignedIdentity}"},
        "private_link_resources": {"key": "properties.privateLinkResources", "type": "[PrivateLinkResource]"},
        "disable_local_accounts": {"key": "properties.disableLocalAccounts", "type": "bool"},
        "http_proxy_config": {"key": "properties.httpProxyConfig", "type": "ManagedClusterHTTPProxyConfig"},
        "security_profile": {"key": "properties.securityProfile", "type": "ManagedClusterSecurityProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "ManagedClusterStorageProfile"},
        "ingress_profile": {"key": "properties.ingressProfile", "type": "ManagedClusterIngressProfile"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "workload_auto_scaler_profile": {
            "key": "properties.workloadAutoScalerProfile",
            "type": "ManagedClusterWorkloadAutoScalerProfile",
        },
        "azure_monitor_profile": {"key": "properties.azureMonitorProfile", "type": "ManagedClusterAzureMonitorProfile"},
        "service_mesh_profile": {"key": "properties.serviceMeshProfile", "type": "ServiceMeshProfile"},
        "resource_uid": {"key": "properties.resourceUID", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ManagedClusterSKU"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        identity: Optional["_models.ManagedClusterIdentity"] = None,
        kubernetes_version: Optional[str] = None,
        dns_prefix: Optional[str] = None,
        fqdn_subdomain: Optional[str] = None,
        agent_pool_profiles: Optional[List["_models.ManagedClusterAgentPoolProfile"]] = None,
        linux_profile: Optional["_models.ContainerServiceLinuxProfile"] = None,
        windows_profile: Optional["_models.ManagedClusterWindowsProfile"] = None,
        service_principal_profile: Optional["_models.ManagedClusterServicePrincipalProfile"] = None,
        addon_profiles: Optional[Dict[str, "_models.ManagedClusterAddonProfile"]] = None,
        pod_identity_profile: Optional["_models.ManagedClusterPodIdentityProfile"] = None,
        oidc_issuer_profile: Optional["_models.ManagedClusterOIDCIssuerProfile"] = None,
        node_resource_group: Optional[str] = None,
        enable_rbac: Optional[bool] = None,
        support_plan: Optional[Union[str, "_models.KubernetesSupportPlan"]] = None,
        enable_pod_security_policy: Optional[bool] = None,
        network_profile: Optional["_models.ContainerServiceNetworkProfile"] = None,
        aad_profile: Optional["_models.ManagedClusterAADProfile"] = None,
        auto_upgrade_profile: Optional["_models.ManagedClusterAutoUpgradeProfile"] = None,
        upgrade_settings: Optional["_models.ClusterUpgradeSettings"] = None,
        auto_scaler_profile: Optional["_models.ManagedClusterPropertiesAutoScalerProfile"] = None,
        api_server_access_profile: Optional["_models.ManagedClusterAPIServerAccessProfile"] = None,
        disk_encryption_set_id: Optional[str] = None,
        identity_profile: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        private_link_resources: Optional[List["_models.PrivateLinkResource"]] = None,
        disable_local_accounts: Optional[bool] = None,
        http_proxy_config: Optional["_models.ManagedClusterHTTPProxyConfig"] = None,
        security_profile: Optional["_models.ManagedClusterSecurityProfile"] = None,
        storage_profile: Optional["_models.ManagedClusterStorageProfile"] = None,
        ingress_profile: Optional["_models.ManagedClusterIngressProfile"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        workload_auto_scaler_profile: Optional["_models.ManagedClusterWorkloadAutoScalerProfile"] = None,
        azure_monitor_profile: Optional["_models.ManagedClusterAzureMonitorProfile"] = None,
        service_mesh_profile: Optional["_models.ServiceMeshProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: The managed cluster SKU.
        :paramtype sku: ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSKU
        :keyword extended_location: The extended location of the Virtual Machine.
        :paramtype extended_location: ~azure.mgmt.containerservice.v2024_01_01.models.ExtendedLocation
        :keyword identity: The identity of the managed cluster, if configured.
        :paramtype identity: ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterIdentity
        :keyword kubernetes_version: Both patch version <major.minor.patch> (e.g. 1.20.13) and
         <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported
         GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once
         it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch
         version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions
         cannot be skipped. All upgrades must be performed sequentially by major version number. For
         example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x ->
         1.16.x is not allowed. See `upgrading an AKS cluster
         <https://docs.microsoft.com/azure/aks/upgrade-cluster>`_ for more details.
        :paramtype kubernetes_version: str
        :keyword dns_prefix: This cannot be updated once the Managed Cluster has been created.
        :paramtype dns_prefix: str
        :keyword fqdn_subdomain: This cannot be updated once the Managed Cluster has been created.
        :paramtype fqdn_subdomain: str
        :keyword agent_pool_profiles: The agent pool properties.
        :paramtype agent_pool_profiles:
         list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAgentPoolProfile]
        :keyword linux_profile: The profile for Linux VMs in the Managed Cluster.
        :paramtype linux_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ContainerServiceLinuxProfile
        :keyword windows_profile: The profile for Windows VMs in the Managed Cluster.
        :paramtype windows_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterWindowsProfile
        :keyword service_principal_profile: Information about a service principal identity for the
         cluster to use for manipulating Azure APIs.
        :paramtype service_principal_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterServicePrincipalProfile
        :keyword addon_profiles: The profile of managed cluster add-on.
        :paramtype addon_profiles: dict[str,
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAddonProfile]
        :keyword pod_identity_profile: See `use AAD pod identity
         <https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity>`_ for more details on AAD pod
         identity integration.
        :paramtype pod_identity_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityProfile
        :keyword oidc_issuer_profile: The OIDC issuer profile of the Managed Cluster.
        :paramtype oidc_issuer_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterOIDCIssuerProfile
        :keyword node_resource_group: The name of the resource group containing agent pool nodes.
        :paramtype node_resource_group: str
        :keyword enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
        :paramtype enable_rbac: bool
        :keyword support_plan: The support plan for the Managed Cluster. If unspecified, the default is
         'KubernetesOfficial'. Known values are: "KubernetesOfficial" and "AKSLongTermSupport".
        :paramtype support_plan: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.KubernetesSupportPlan
        :keyword enable_pod_security_policy: (DEPRECATED) Whether to enable Kubernetes pod security
         policy (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from
         Kubernetes in v1.25. Learn more at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
        :paramtype enable_pod_security_policy: bool
        :keyword network_profile: The network configuration profile.
        :paramtype network_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ContainerServiceNetworkProfile
        :keyword aad_profile: The Azure Active Directory configuration.
        :paramtype aad_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAADProfile
        :keyword auto_upgrade_profile: The auto upgrade configuration.
        :paramtype auto_upgrade_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAutoUpgradeProfile
        :keyword upgrade_settings: Settings for upgrading a cluster.
        :paramtype upgrade_settings:
         ~azure.mgmt.containerservice.v2024_01_01.models.ClusterUpgradeSettings
        :keyword auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
        :paramtype auto_scaler_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPropertiesAutoScalerProfile
        :keyword api_server_access_profile: The access profile for managed cluster API server.
        :paramtype api_server_access_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAPIServerAccessProfile
        :keyword disk_encryption_set_id: This is of the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'.  # pylint: disable=line-too-long
        :paramtype disk_encryption_set_id: str
        :keyword identity_profile: Identities associated with the cluster.
        :paramtype identity_profile: dict[str,
         ~azure.mgmt.containerservice.v2024_01_01.models.UserAssignedIdentity]
        :keyword private_link_resources: Private link resources associated with the cluster.
        :paramtype private_link_resources:
         list[~azure.mgmt.containerservice.v2024_01_01.models.PrivateLinkResource]
        :keyword disable_local_accounts: If set to true, getting static credentials will be disabled
         for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more
         details see `disable local accounts
         <https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview>`_.
        :paramtype disable_local_accounts: bool
        :keyword http_proxy_config: Configurations for provisioning the cluster with HTTP proxy
         servers.
        :paramtype http_proxy_config:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterHTTPProxyConfig
        :keyword security_profile: Security profile for the managed cluster.
        :paramtype security_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSecurityProfile
        :keyword storage_profile: Storage profile for the managed cluster.
        :paramtype storage_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterStorageProfile
        :keyword ingress_profile: Ingress profile for the managed cluster.
        :paramtype ingress_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterIngressProfile
        :keyword public_network_access: Allow or deny public network access for AKS. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.PublicNetworkAccess
        :keyword workload_auto_scaler_profile: Workload Auto-scaler profile for the managed cluster.
        :paramtype workload_auto_scaler_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterWorkloadAutoScalerProfile
        :keyword azure_monitor_profile: Azure Monitor addon profiles for monitoring the managed
         cluster.
        :paramtype azure_monitor_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAzureMonitorProfile
        :keyword service_mesh_profile: Service mesh profile for a managed cluster.
        :paramtype service_mesh_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ServiceMeshProfile
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.extended_location = extended_location
        self.identity = identity
        self.provisioning_state = None
        self.power_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kubernetes_version
        self.current_kubernetes_version = None
        self.dns_prefix = dns_prefix
        self.fqdn_subdomain = fqdn_subdomain
        self.fqdn = None
        self.private_fqdn = None
        self.azure_portal_fqdn = None
        self.agent_pool_profiles = agent_pool_profiles
        self.linux_profile = linux_profile
        self.windows_profile = windows_profile
        self.service_principal_profile = service_principal_profile
        self.addon_profiles = addon_profiles
        self.pod_identity_profile = pod_identity_profile
        self.oidc_issuer_profile = oidc_issuer_profile
        self.node_resource_group = node_resource_group
        self.enable_rbac = enable_rbac
        self.support_plan = support_plan
        self.enable_pod_security_policy = enable_pod_security_policy
        self.network_profile = network_profile
        self.aad_profile = aad_profile
        self.auto_upgrade_profile = auto_upgrade_profile
        self.upgrade_settings = upgrade_settings
        self.auto_scaler_profile = auto_scaler_profile
        self.api_server_access_profile = api_server_access_profile
        self.disk_encryption_set_id = disk_encryption_set_id
        self.identity_profile = identity_profile
        self.private_link_resources = private_link_resources
        self.disable_local_accounts = disable_local_accounts
        self.http_proxy_config = http_proxy_config
        self.security_profile = security_profile
        self.storage_profile = storage_profile
        self.ingress_profile = ingress_profile
        self.public_network_access = public_network_access
        self.workload_auto_scaler_profile = workload_auto_scaler_profile
        self.azure_monitor_profile = azure_monitor_profile
        self.service_mesh_profile = service_mesh_profile
        self.resource_uid = None


class ManagedClusterAADProfile(_serialization.Model):
    """For more details see `managed AAD on AKS <https://docs.microsoft.com/azure/aks/managed-aad>`_.

    :ivar managed: Whether to enable managed AAD.
    :vartype managed: bool
    :ivar enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
    :vartype enable_azure_rbac: bool
    :ivar admin_group_object_i_ds: The list of AAD group object IDs that will have admin role of
     the cluster.
    :vartype admin_group_object_i_ds: list[str]
    :ivar client_app_id: (DEPRECATED) The client AAD application ID. Learn more at
     https://aka.ms/aks/aad-legacy.
    :vartype client_app_id: str
    :ivar server_app_id: (DEPRECATED) The server AAD application ID. Learn more at
     https://aka.ms/aks/aad-legacy.
    :vartype server_app_id: str
    :ivar server_app_secret: (DEPRECATED) The server AAD application secret. Learn more at
     https://aka.ms/aks/aad-legacy.
    :vartype server_app_secret: str
    :ivar tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
     tenant of the deployment subscription.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "managed": {"key": "managed", "type": "bool"},
        "enable_azure_rbac": {"key": "enableAzureRBAC", "type": "bool"},
        "admin_group_object_i_ds": {"key": "adminGroupObjectIDs", "type": "[str]"},
        "client_app_id": {"key": "clientAppID", "type": "str"},
        "server_app_id": {"key": "serverAppID", "type": "str"},
        "server_app_secret": {"key": "serverAppSecret", "type": "str"},
        "tenant_id": {"key": "tenantID", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed: Optional[bool] = None,
        enable_azure_rbac: Optional[bool] = None,
        admin_group_object_i_ds: Optional[List[str]] = None,
        client_app_id: Optional[str] = None,
        server_app_id: Optional[str] = None,
        server_app_secret: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed: Whether to enable managed AAD.
        :paramtype managed: bool
        :keyword enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
        :paramtype enable_azure_rbac: bool
        :keyword admin_group_object_i_ds: The list of AAD group object IDs that will have admin role of
         the cluster.
        :paramtype admin_group_object_i_ds: list[str]
        :keyword client_app_id: (DEPRECATED) The client AAD application ID. Learn more at
         https://aka.ms/aks/aad-legacy.
        :paramtype client_app_id: str
        :keyword server_app_id: (DEPRECATED) The server AAD application ID. Learn more at
         https://aka.ms/aks/aad-legacy.
        :paramtype server_app_id: str
        :keyword server_app_secret: (DEPRECATED) The server AAD application secret. Learn more at
         https://aka.ms/aks/aad-legacy.
        :paramtype server_app_secret: str
        :keyword tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
         tenant of the deployment subscription.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.managed = managed
        self.enable_azure_rbac = enable_azure_rbac
        self.admin_group_object_i_ds = admin_group_object_i_ds
        self.client_app_id = client_app_id
        self.server_app_id = server_app_id
        self.server_app_secret = server_app_secret
        self.tenant_id = tenant_id


class ManagedClusterAccessProfile(TrackedResource):
    """Managed cluster Access Profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservice.v2024_01_01.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar kube_config: Base64-encoded Kubernetes configuration file.
    :vartype kube_config: bytes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "kube_config": {"key": "properties.kubeConfig", "type": "bytearray"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kube_config: Optional[bytes] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword kube_config: Base64-encoded Kubernetes configuration file.
        :paramtype kube_config: bytes
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.kube_config = kube_config


class ManagedClusterAddonProfile(_serialization.Model):
    """A Kubernetes add-on profile for a managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether the add-on is enabled or not. Required.
    :vartype enabled: bool
    :ivar config: Key-value pairs for configuring an add-on.
    :vartype config: dict[str, str]
    :ivar identity: Information of user assigned identity used by this add-on.
    :vartype identity:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAddonProfileIdentity
    """

    _validation = {
        "enabled": {"required": True},
        "identity": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "config": {"key": "config", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedClusterAddonProfileIdentity"},
    }

    def __init__(self, *, enabled: bool, config: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether the add-on is enabled or not. Required.
        :paramtype enabled: bool
        :keyword config: Key-value pairs for configuring an add-on.
        :paramtype config: dict[str, str]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.config = config
        self.identity = None


class UserAssignedIdentity(_serialization.Model):
    """Details about a user assigned identity.

    :ivar resource_id: The resource ID of the user assigned identity.
    :vartype resource_id: str
    :ivar client_id: The client ID of the user assigned identity.
    :vartype client_id: str
    :ivar object_id: The object ID of the user assigned identity.
    :vartype object_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        client_id: Optional[str] = None,
        object_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource ID of the user assigned identity.
        :paramtype resource_id: str
        :keyword client_id: The client ID of the user assigned identity.
        :paramtype client_id: str
        :keyword object_id: The object ID of the user assigned identity.
        :paramtype object_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.client_id = client_id
        self.object_id = object_id


class ManagedClusterAddonProfileIdentity(UserAssignedIdentity):
    """Information of user assigned identity used by this add-on.

    :ivar resource_id: The resource ID of the user assigned identity.
    :vartype resource_id: str
    :ivar client_id: The client ID of the user assigned identity.
    :vartype client_id: str
    :ivar object_id: The object ID of the user assigned identity.
    :vartype object_id: str
    """


class ManagedClusterAgentPoolProfileProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties for the container service agent pool profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
     system pools. The default value is 1.
    :vartype count: int
    :ivar vm_size: VM size availability varies by region. If a node contains insufficient compute
     resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted
     VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions.
    :vartype vm_size: str
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in the master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar os_disk_type: The default is 'Ephemeral' if the VM supports it and has a cache disk
     larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed
     after creation. For more information see `Ephemeral OS
     <https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os>`_. Known values are:
     "Managed" and "Ephemeral".
    :vartype os_disk_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSDiskType
    :ivar kubelet_disk_type: Determines the placement of emptyDir volumes, container runtime data
     root, and Kubelet ephemeral storage. Known values are: "OS" and "Temporary".
    :vartype kubelet_disk_type: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.KubeletDiskType
    :ivar workload_runtime: Determines the type of workload a node can run. Known values are:
     "OCIContainer" and "WasmWasi".
    :vartype workload_runtime: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.WorkloadRuntime
    :ivar vnet_subnet_id: If this is not specified, a VNET and subnet will be generated and used.
     If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just
     nodes. This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
    :vartype vnet_subnet_id: str
    :ivar pod_subnet_id: If omitted, pod IPs are statically assigned on the node subnet (see
     vnetSubnetID for more details). This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
    :vartype pod_subnet_id: str
    :ivar max_pods: The maximum number of pods that can run on a node.
    :vartype max_pods: int
    :ivar os_type: The operating system type. The default is Linux. Known values are: "Linux" and
     "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
    :ivar os_sku: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is
     Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >=
     1.25 if OSType is Windows. Known values are: "Ubuntu", "AzureLinux", "CBLMariner",
     "Windows2019", and "Windows2022".
    :vartype os_sku: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSSKU
    :ivar max_count: The maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: The minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler.
    :vartype enable_auto_scaling: bool
    :ivar scale_down_mode: This also effects the cluster autoscaler behavior. If not specified, it
     defaults to Delete. Known values are: "Delete" and "Deallocate".
    :vartype scale_down_mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.ScaleDownMode
    :ivar type: The type of Agent Pool. Known values are: "VirtualMachineScaleSets" and
     "AvailabilitySet".
    :vartype type: str or ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolType
    :ivar mode: A cluster must have at least one 'System' Agent Pool at all times. For additional
     information on agent pool restrictions and best practices, see:
     https://docs.microsoft.com/azure/aks/use-system-pools. Known values are: "System" and "User".
    :vartype mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolMode
    :ivar orchestrator_version: Both patch version <major.minor.patch> (e.g. 1.20.13) and
     <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported
     GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once
     it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch
     version is available. As a best practice, you should upgrade all node pools in an AKS cluster
     to the same Kubernetes version. The node pool version must have the same major version as the
     control plane. The node pool minor version must be within two minor versions of the control
     plane version. The node pool version cannot be greater than the control plane version. For more
     information see `upgrading a node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool>`_.
    :vartype orchestrator_version: str
    :ivar current_orchestrator_version: If orchestratorVersion is a fully specified version
     <major.minor.patch>, this field will be exactly equal to it. If orchestratorVersion is
     <major.minor>, this field will contain the full <major.minor.patch> version being used.
    :vartype current_orchestrator_version: str
    :ivar node_image_version: The version of node image.
    :vartype node_image_version: str
    :ivar upgrade_settings: Settings for upgrading the agentpool.
    :vartype upgrade_settings:
     ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state.
    :vartype provisioning_state: str
    :ivar power_state: When an Agent Pool is first created it is initially Running. The Agent Pool
     can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and
     does not accrue billing charges. An Agent Pool can only be stopped if it is Running and
     provisioning state is Succeeded.
    :vartype power_state: ~azure.mgmt.containerservice.v2024_01_01.models.PowerState
    :ivar availability_zones: The list of Availability zones to use for nodes. This can only be
     specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
    :vartype availability_zones: list[str]
    :ivar enable_node_public_ip: Some scenarios may require nodes in a node pool to receive their
     own dedicated public IP addresses. A common scenario is for gaming workloads, where a console
     needs to make a direct connection to a cloud virtual machine to minimize hops. For more
     information see `assigning a public IP per node
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools>`_.
     The default is false.
    :vartype enable_node_public_ip: bool
    :ivar node_public_ip_prefix_id: This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.  # pylint: disable=line-too-long
    :vartype node_public_ip_prefix_id: str
    :ivar scale_set_priority: The Virtual Machine Scale Set priority. If not specified, the default
     is 'Regular'. Known values are: "Spot" and "Regular".
    :vartype scale_set_priority: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetPriority
    :ivar scale_set_eviction_policy: This cannot be specified unless the scaleSetPriority is
     'Spot'. If not specified, the default is 'Delete'. Known values are: "Delete" and "Deallocate".
    :vartype scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetEvictionPolicy
    :ivar spot_max_price: Possible values are any decimal value greater than zero or -1 which
     indicates the willingness to pay any on-demand price. For more details on spot pricing, see
     `spot VMs pricing <https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing>`_.
    :vartype spot_max_price: float
    :ivar tags: The tags to be persisted on the agent pool virtual machine scale set.
    :vartype tags: dict[str, str]
    :ivar node_labels: The node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: The taints added to new nodes during node pool create and scale. For
     example, key=value:NoSchedule.
    :vartype node_taints: list[str]
    :ivar proximity_placement_group_id: The ID for Proximity Placement Group.
    :vartype proximity_placement_group_id: str
    :ivar kubelet_config: The Kubelet configuration on the agent pool nodes.
    :vartype kubelet_config: ~azure.mgmt.containerservice.v2024_01_01.models.KubeletConfig
    :ivar linux_os_config: The OS configuration of Linux agent nodes.
    :vartype linux_os_config: ~azure.mgmt.containerservice.v2024_01_01.models.LinuxOSConfig
    :ivar enable_encryption_at_host: This is only supported on certain VM sizes and in certain
     Azure regions. For more information, see:
     https://docs.microsoft.com/azure/aks/enable-host-encryption.
    :vartype enable_encryption_at_host: bool
    :ivar enable_ultra_ssd: Whether to enable UltraSSD.
    :vartype enable_ultra_ssd: bool
    :ivar enable_fips: See `Add a FIPS-enabled node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview>`_
     for more details.
    :vartype enable_fips: bool
    :ivar gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance profile
     for supported GPU VM SKU. Known values are: "MIG1g", "MIG2g", "MIG3g", "MIG4g", and "MIG7g".
    :vartype gpu_instance_profile: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.GPUInstanceProfile
    :ivar creation_data: CreationData to be used to specify the source Snapshot ID if the node pool
     will be created/upgraded using a snapshot.
    :vartype creation_data: ~azure.mgmt.containerservice.v2024_01_01.models.CreationData
    :ivar capacity_reservation_group_id: AKS will associate the specified agent pool with the
     Capacity Reservation Group.
    :vartype capacity_reservation_group_id: str
    :ivar host_group_id: This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.  # pylint: disable=line-too-long
     For more information see `Azure dedicated hosts
     <https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts>`_.
    :vartype host_group_id: str
    :ivar network_profile: Network-related settings of an agent pool.
    :vartype network_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolNetworkProfile
    """

    _validation = {
        "os_disk_size_gb": {"maximum": 2048, "minimum": 0},
        "current_orchestrator_version": {"readonly": True},
        "node_image_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "osDiskSizeGB", "type": "int"},
        "os_disk_type": {"key": "osDiskType", "type": "str"},
        "kubelet_disk_type": {"key": "kubeletDiskType", "type": "str"},
        "workload_runtime": {"key": "workloadRuntime", "type": "str"},
        "vnet_subnet_id": {"key": "vnetSubnetID", "type": "str"},
        "pod_subnet_id": {"key": "podSubnetID", "type": "str"},
        "max_pods": {"key": "maxPods", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "os_sku": {"key": "osSKU", "type": "str"},
        "max_count": {"key": "maxCount", "type": "int"},
        "min_count": {"key": "minCount", "type": "int"},
        "enable_auto_scaling": {"key": "enableAutoScaling", "type": "bool"},
        "scale_down_mode": {"key": "scaleDownMode", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "orchestrator_version": {"key": "orchestratorVersion", "type": "str"},
        "current_orchestrator_version": {"key": "currentOrchestratorVersion", "type": "str"},
        "node_image_version": {"key": "nodeImageVersion", "type": "str"},
        "upgrade_settings": {"key": "upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "power_state": {"key": "powerState", "type": "PowerState"},
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "enable_node_public_ip": {"key": "enableNodePublicIP", "type": "bool"},
        "node_public_ip_prefix_id": {"key": "nodePublicIPPrefixID", "type": "str"},
        "scale_set_priority": {"key": "scaleSetPriority", "type": "str"},
        "scale_set_eviction_policy": {"key": "scaleSetEvictionPolicy", "type": "str"},
        "spot_max_price": {"key": "spotMaxPrice", "type": "float"},
        "tags": {"key": "tags", "type": "{str}"},
        "node_labels": {"key": "nodeLabels", "type": "{str}"},
        "node_taints": {"key": "nodeTaints", "type": "[str]"},
        "proximity_placement_group_id": {"key": "proximityPlacementGroupID", "type": "str"},
        "kubelet_config": {"key": "kubeletConfig", "type": "KubeletConfig"},
        "linux_os_config": {"key": "linuxOSConfig", "type": "LinuxOSConfig"},
        "enable_encryption_at_host": {"key": "enableEncryptionAtHost", "type": "bool"},
        "enable_ultra_ssd": {"key": "enableUltraSSD", "type": "bool"},
        "enable_fips": {"key": "enableFIPS", "type": "bool"},
        "gpu_instance_profile": {"key": "gpuInstanceProfile", "type": "str"},
        "creation_data": {"key": "creationData", "type": "CreationData"},
        "capacity_reservation_group_id": {"key": "capacityReservationGroupID", "type": "str"},
        "host_group_id": {"key": "hostGroupID", "type": "str"},
        "network_profile": {"key": "networkProfile", "type": "AgentPoolNetworkProfile"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        count: Optional[int] = None,
        vm_size: Optional[str] = None,
        os_disk_size_gb: Optional[int] = None,
        os_disk_type: Optional[Union[str, "_models.OSDiskType"]] = None,
        kubelet_disk_type: Optional[Union[str, "_models.KubeletDiskType"]] = None,
        workload_runtime: Optional[Union[str, "_models.WorkloadRuntime"]] = None,
        vnet_subnet_id: Optional[str] = None,
        pod_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Union[str, "_models.OSType"] = "Linux",
        os_sku: Optional[Union[str, "_models.OSSKU"]] = None,
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        scale_down_mode: Optional[Union[str, "_models.ScaleDownMode"]] = None,
        type: Optional[Union[str, "_models.AgentPoolType"]] = None,
        mode: Optional[Union[str, "_models.AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        power_state: Optional["_models.PowerState"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        node_public_ip_prefix_id: Optional[str] = None,
        scale_set_priority: Union[str, "_models.ScaleSetPriority"] = "Regular",
        scale_set_eviction_policy: Union[str, "_models.ScaleSetEvictionPolicy"] = "Delete",
        spot_max_price: float = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        proximity_placement_group_id: Optional[str] = None,
        kubelet_config: Optional["_models.KubeletConfig"] = None,
        linux_os_config: Optional["_models.LinuxOSConfig"] = None,
        enable_encryption_at_host: Optional[bool] = None,
        enable_ultra_ssd: Optional[bool] = None,
        enable_fips: Optional[bool] = None,
        gpu_instance_profile: Optional[Union[str, "_models.GPUInstanceProfile"]] = None,
        creation_data: Optional["_models.CreationData"] = None,
        capacity_reservation_group_id: Optional[str] = None,
        host_group_id: Optional[str] = None,
        network_profile: Optional["_models.AgentPoolNetworkProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of agents (VMs) to host docker containers. Allowed values must be in the
         range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
         system pools. The default value is 1.
        :paramtype count: int
        :keyword vm_size: VM size availability varies by region. If a node contains insufficient
         compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on
         restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions.
        :paramtype vm_size: str
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in the master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword os_disk_type: The default is 'Ephemeral' if the VM supports it and has a cache disk
         larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed
         after creation. For more information see `Ephemeral OS
         <https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os>`_. Known values are:
         "Managed" and "Ephemeral".
        :paramtype os_disk_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSDiskType
        :keyword kubelet_disk_type: Determines the placement of emptyDir volumes, container runtime
         data root, and Kubelet ephemeral storage. Known values are: "OS" and "Temporary".
        :paramtype kubelet_disk_type: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.KubeletDiskType
        :keyword workload_runtime: Determines the type of workload a node can run. Known values are:
         "OCIContainer" and "WasmWasi".
        :paramtype workload_runtime: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.WorkloadRuntime
        :keyword vnet_subnet_id: If this is not specified, a VNET and subnet will be generated and
         used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to
         just nodes. This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
        :paramtype vnet_subnet_id: str
        :keyword pod_subnet_id: If omitted, pod IPs are statically assigned on the node subnet (see
         vnetSubnetID for more details). This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
        :paramtype pod_subnet_id: str
        :keyword max_pods: The maximum number of pods that can run on a node.
        :paramtype max_pods: int
        :keyword os_type: The operating system type. The default is Linux. Known values are: "Linux"
         and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
        :keyword os_sku: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType
         is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >=
         1.25 if OSType is Windows. Known values are: "Ubuntu", "AzureLinux", "CBLMariner",
         "Windows2019", and "Windows2022".
        :paramtype os_sku: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSSKU
        :keyword max_count: The maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: The minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler.
        :paramtype enable_auto_scaling: bool
        :keyword scale_down_mode: This also effects the cluster autoscaler behavior. If not specified,
         it defaults to Delete. Known values are: "Delete" and "Deallocate".
        :paramtype scale_down_mode: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.ScaleDownMode
        :keyword type: The type of Agent Pool. Known values are: "VirtualMachineScaleSets" and
         "AvailabilitySet".
        :paramtype type: str or ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolType
        :keyword mode: A cluster must have at least one 'System' Agent Pool at all times. For
         additional information on agent pool restrictions and best practices, see:
         https://docs.microsoft.com/azure/aks/use-system-pools. Known values are: "System" and "User".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolMode
        :keyword orchestrator_version: Both patch version <major.minor.patch> (e.g. 1.20.13) and
         <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported
         GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once
         it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch
         version is available. As a best practice, you should upgrade all node pools in an AKS cluster
         to the same Kubernetes version. The node pool version must have the same major version as the
         control plane. The node pool minor version must be within two minor versions of the control
         plane version. The node pool version cannot be greater than the control plane version. For more
         information see `upgrading a node pool
         <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool>`_.
        :paramtype orchestrator_version: str
        :keyword upgrade_settings: Settings for upgrading the agentpool.
        :paramtype upgrade_settings:
         ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolUpgradeSettings
        :keyword power_state: When an Agent Pool is first created it is initially Running. The Agent
         Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs
         and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and
         provisioning state is Succeeded.
        :paramtype power_state: ~azure.mgmt.containerservice.v2024_01_01.models.PowerState
        :keyword availability_zones: The list of Availability zones to use for nodes. This can only be
         specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
        :paramtype availability_zones: list[str]
        :keyword enable_node_public_ip: Some scenarios may require nodes in a node pool to receive
         their own dedicated public IP addresses. A common scenario is for gaming workloads, where a
         console needs to make a direct connection to a cloud virtual machine to minimize hops. For more
         information see `assigning a public IP per node
         <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools>`_.  # pylint: disable=line-too-long
         The default is false.
        :paramtype enable_node_public_ip: bool
        :keyword node_public_ip_prefix_id: This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.  # pylint: disable=line-too-long
        :paramtype node_public_ip_prefix_id: str
        :keyword scale_set_priority: The Virtual Machine Scale Set priority. If not specified, the
         default is 'Regular'. Known values are: "Spot" and "Regular".
        :paramtype scale_set_priority: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetPriority
        :keyword scale_set_eviction_policy: This cannot be specified unless the scaleSetPriority is
         'Spot'. If not specified, the default is 'Delete'. Known values are: "Delete" and "Deallocate".
        :paramtype scale_set_eviction_policy: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetEvictionPolicy
        :keyword spot_max_price: Possible values are any decimal value greater than zero or -1 which
         indicates the willingness to pay any on-demand price. For more details on spot pricing, see
         `spot VMs pricing <https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing>`_.
        :paramtype spot_max_price: float
        :keyword tags: The tags to be persisted on the agent pool virtual machine scale set.
        :paramtype tags: dict[str, str]
        :keyword node_labels: The node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: The taints added to new nodes during node pool create and scale. For
         example, key=value:NoSchedule.
        :paramtype node_taints: list[str]
        :keyword proximity_placement_group_id: The ID for Proximity Placement Group.
        :paramtype proximity_placement_group_id: str
        :keyword kubelet_config: The Kubelet configuration on the agent pool nodes.
        :paramtype kubelet_config: ~azure.mgmt.containerservice.v2024_01_01.models.KubeletConfig
        :keyword linux_os_config: The OS configuration of Linux agent nodes.
        :paramtype linux_os_config: ~azure.mgmt.containerservice.v2024_01_01.models.LinuxOSConfig
        :keyword enable_encryption_at_host: This is only supported on certain VM sizes and in certain
         Azure regions. For more information, see:
         https://docs.microsoft.com/azure/aks/enable-host-encryption.
        :paramtype enable_encryption_at_host: bool
        :keyword enable_ultra_ssd: Whether to enable UltraSSD.
        :paramtype enable_ultra_ssd: bool
        :keyword enable_fips: See `Add a FIPS-enabled node pool
         <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview>`_
         for more details.
        :paramtype enable_fips: bool
        :keyword gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance
         profile for supported GPU VM SKU. Known values are: "MIG1g", "MIG2g", "MIG3g", "MIG4g", and
         "MIG7g".
        :paramtype gpu_instance_profile: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.GPUInstanceProfile
        :keyword creation_data: CreationData to be used to specify the source Snapshot ID if the node
         pool will be created/upgraded using a snapshot.
        :paramtype creation_data: ~azure.mgmt.containerservice.v2024_01_01.models.CreationData
        :keyword capacity_reservation_group_id: AKS will associate the specified agent pool with the
         Capacity Reservation Group.
        :paramtype capacity_reservation_group_id: str
        :keyword host_group_id: This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.  # pylint: disable=line-too-long
         For more information see `Azure dedicated hosts
         <https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts>`_.
        :paramtype host_group_id: str
        :keyword network_profile: Network-related settings of an agent pool.
        :paramtype network_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolNetworkProfile
        """
        super().__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.os_disk_type = os_disk_type
        self.kubelet_disk_type = kubelet_disk_type
        self.workload_runtime = workload_runtime
        self.vnet_subnet_id = vnet_subnet_id
        self.pod_subnet_id = pod_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.os_sku = os_sku
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.scale_down_mode = scale_down_mode
        self.type = type
        self.mode = mode
        self.orchestrator_version = orchestrator_version
        self.current_orchestrator_version = None
        self.node_image_version = None
        self.upgrade_settings = upgrade_settings
        self.provisioning_state = None
        self.power_state = power_state
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.node_public_ip_prefix_id = node_public_ip_prefix_id
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.spot_max_price = spot_max_price
        self.tags = tags
        self.node_labels = node_labels
        self.node_taints = node_taints
        self.proximity_placement_group_id = proximity_placement_group_id
        self.kubelet_config = kubelet_config
        self.linux_os_config = linux_os_config
        self.enable_encryption_at_host = enable_encryption_at_host
        self.enable_ultra_ssd = enable_ultra_ssd
        self.enable_fips = enable_fips
        self.gpu_instance_profile = gpu_instance_profile
        self.creation_data = creation_data
        self.capacity_reservation_group_id = capacity_reservation_group_id
        self.host_group_id = host_group_id
        self.network_profile = network_profile


class ManagedClusterAgentPoolProfile(
    ManagedClusterAgentPoolProfileProperties
):  # pylint: disable=too-many-instance-attributes
    """Profile for the container service agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
     system pools. The default value is 1.
    :vartype count: int
    :ivar vm_size: VM size availability varies by region. If a node contains insufficient compute
     resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted
     VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions.
    :vartype vm_size: str
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in the master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar os_disk_type: The default is 'Ephemeral' if the VM supports it and has a cache disk
     larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed
     after creation. For more information see `Ephemeral OS
     <https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os>`_. Known values are:
     "Managed" and "Ephemeral".
    :vartype os_disk_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSDiskType
    :ivar kubelet_disk_type: Determines the placement of emptyDir volumes, container runtime data
     root, and Kubelet ephemeral storage. Known values are: "OS" and "Temporary".
    :vartype kubelet_disk_type: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.KubeletDiskType
    :ivar workload_runtime: Determines the type of workload a node can run. Known values are:
     "OCIContainer" and "WasmWasi".
    :vartype workload_runtime: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.WorkloadRuntime
    :ivar vnet_subnet_id: If this is not specified, a VNET and subnet will be generated and used.
     If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just
     nodes. This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
    :vartype vnet_subnet_id: str
    :ivar pod_subnet_id: If omitted, pod IPs are statically assigned on the node subnet (see
     vnetSubnetID for more details). This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
    :vartype pod_subnet_id: str
    :ivar max_pods: The maximum number of pods that can run on a node.
    :vartype max_pods: int
    :ivar os_type: The operating system type. The default is Linux. Known values are: "Linux" and
     "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
    :ivar os_sku: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is
     Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >=
     1.25 if OSType is Windows. Known values are: "Ubuntu", "AzureLinux", "CBLMariner",
     "Windows2019", and "Windows2022".
    :vartype os_sku: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSSKU
    :ivar max_count: The maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: The minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler.
    :vartype enable_auto_scaling: bool
    :ivar scale_down_mode: This also effects the cluster autoscaler behavior. If not specified, it
     defaults to Delete. Known values are: "Delete" and "Deallocate".
    :vartype scale_down_mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.ScaleDownMode
    :ivar type: The type of Agent Pool. Known values are: "VirtualMachineScaleSets" and
     "AvailabilitySet".
    :vartype type: str or ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolType
    :ivar mode: A cluster must have at least one 'System' Agent Pool at all times. For additional
     information on agent pool restrictions and best practices, see:
     https://docs.microsoft.com/azure/aks/use-system-pools. Known values are: "System" and "User".
    :vartype mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolMode
    :ivar orchestrator_version: Both patch version <major.minor.patch> (e.g. 1.20.13) and
     <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported
     GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once
     it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch
     version is available. As a best practice, you should upgrade all node pools in an AKS cluster
     to the same Kubernetes version. The node pool version must have the same major version as the
     control plane. The node pool minor version must be within two minor versions of the control
     plane version. The node pool version cannot be greater than the control plane version. For more
     information see `upgrading a node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool>`_.
    :vartype orchestrator_version: str
    :ivar current_orchestrator_version: If orchestratorVersion is a fully specified version
     <major.minor.patch>, this field will be exactly equal to it. If orchestratorVersion is
     <major.minor>, this field will contain the full <major.minor.patch> version being used.
    :vartype current_orchestrator_version: str
    :ivar node_image_version: The version of node image.
    :vartype node_image_version: str
    :ivar upgrade_settings: Settings for upgrading the agentpool.
    :vartype upgrade_settings:
     ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state.
    :vartype provisioning_state: str
    :ivar power_state: When an Agent Pool is first created it is initially Running. The Agent Pool
     can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and
     does not accrue billing charges. An Agent Pool can only be stopped if it is Running and
     provisioning state is Succeeded.
    :vartype power_state: ~azure.mgmt.containerservice.v2024_01_01.models.PowerState
    :ivar availability_zones: The list of Availability zones to use for nodes. This can only be
     specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
    :vartype availability_zones: list[str]
    :ivar enable_node_public_ip: Some scenarios may require nodes in a node pool to receive their
     own dedicated public IP addresses. A common scenario is for gaming workloads, where a console
     needs to make a direct connection to a cloud virtual machine to minimize hops. For more
     information see `assigning a public IP per node
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools>`_.
     The default is false.
    :vartype enable_node_public_ip: bool
    :ivar node_public_ip_prefix_id: This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.  # pylint: disable=line-too-long
    :vartype node_public_ip_prefix_id: str
    :ivar scale_set_priority: The Virtual Machine Scale Set priority. If not specified, the default
     is 'Regular'. Known values are: "Spot" and "Regular".
    :vartype scale_set_priority: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetPriority
    :ivar scale_set_eviction_policy: This cannot be specified unless the scaleSetPriority is
     'Spot'. If not specified, the default is 'Delete'. Known values are: "Delete" and "Deallocate".
    :vartype scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetEvictionPolicy
    :ivar spot_max_price: Possible values are any decimal value greater than zero or -1 which
     indicates the willingness to pay any on-demand price. For more details on spot pricing, see
     `spot VMs pricing <https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing>`_.
    :vartype spot_max_price: float
    :ivar tags: The tags to be persisted on the agent pool virtual machine scale set.
    :vartype tags: dict[str, str]
    :ivar node_labels: The node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: The taints added to new nodes during node pool create and scale. For
     example, key=value:NoSchedule.
    :vartype node_taints: list[str]
    :ivar proximity_placement_group_id: The ID for Proximity Placement Group.
    :vartype proximity_placement_group_id: str
    :ivar kubelet_config: The Kubelet configuration on the agent pool nodes.
    :vartype kubelet_config: ~azure.mgmt.containerservice.v2024_01_01.models.KubeletConfig
    :ivar linux_os_config: The OS configuration of Linux agent nodes.
    :vartype linux_os_config: ~azure.mgmt.containerservice.v2024_01_01.models.LinuxOSConfig
    :ivar enable_encryption_at_host: This is only supported on certain VM sizes and in certain
     Azure regions. For more information, see:
     https://docs.microsoft.com/azure/aks/enable-host-encryption.
    :vartype enable_encryption_at_host: bool
    :ivar enable_ultra_ssd: Whether to enable UltraSSD.
    :vartype enable_ultra_ssd: bool
    :ivar enable_fips: See `Add a FIPS-enabled node pool
     <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview>`_
     for more details.
    :vartype enable_fips: bool
    :ivar gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance profile
     for supported GPU VM SKU. Known values are: "MIG1g", "MIG2g", "MIG3g", "MIG4g", and "MIG7g".
    :vartype gpu_instance_profile: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.GPUInstanceProfile
    :ivar creation_data: CreationData to be used to specify the source Snapshot ID if the node pool
     will be created/upgraded using a snapshot.
    :vartype creation_data: ~azure.mgmt.containerservice.v2024_01_01.models.CreationData
    :ivar capacity_reservation_group_id: AKS will associate the specified agent pool with the
     Capacity Reservation Group.
    :vartype capacity_reservation_group_id: str
    :ivar host_group_id: This is of the form:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.  # pylint: disable=line-too-long
     For more information see `Azure dedicated hosts
     <https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts>`_.
    :vartype host_group_id: str
    :ivar network_profile: Network-related settings of an agent pool.
    :vartype network_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolNetworkProfile
    :ivar name: Windows agent pool names must be 6 characters or less. Required.
    :vartype name: str
    """

    _validation = {
        "os_disk_size_gb": {"maximum": 2048, "minimum": 0},
        "current_orchestrator_version": {"readonly": True},
        "node_image_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "name": {"required": True, "pattern": r"^[a-z][a-z0-9]{0,11}$"},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "osDiskSizeGB", "type": "int"},
        "os_disk_type": {"key": "osDiskType", "type": "str"},
        "kubelet_disk_type": {"key": "kubeletDiskType", "type": "str"},
        "workload_runtime": {"key": "workloadRuntime", "type": "str"},
        "vnet_subnet_id": {"key": "vnetSubnetID", "type": "str"},
        "pod_subnet_id": {"key": "podSubnetID", "type": "str"},
        "max_pods": {"key": "maxPods", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "os_sku": {"key": "osSKU", "type": "str"},
        "max_count": {"key": "maxCount", "type": "int"},
        "min_count": {"key": "minCount", "type": "int"},
        "enable_auto_scaling": {"key": "enableAutoScaling", "type": "bool"},
        "scale_down_mode": {"key": "scaleDownMode", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "orchestrator_version": {"key": "orchestratorVersion", "type": "str"},
        "current_orchestrator_version": {"key": "currentOrchestratorVersion", "type": "str"},
        "node_image_version": {"key": "nodeImageVersion", "type": "str"},
        "upgrade_settings": {"key": "upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "power_state": {"key": "powerState", "type": "PowerState"},
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "enable_node_public_ip": {"key": "enableNodePublicIP", "type": "bool"},
        "node_public_ip_prefix_id": {"key": "nodePublicIPPrefixID", "type": "str"},
        "scale_set_priority": {"key": "scaleSetPriority", "type": "str"},
        "scale_set_eviction_policy": {"key": "scaleSetEvictionPolicy", "type": "str"},
        "spot_max_price": {"key": "spotMaxPrice", "type": "float"},
        "tags": {"key": "tags", "type": "{str}"},
        "node_labels": {"key": "nodeLabels", "type": "{str}"},
        "node_taints": {"key": "nodeTaints", "type": "[str]"},
        "proximity_placement_group_id": {"key": "proximityPlacementGroupID", "type": "str"},
        "kubelet_config": {"key": "kubeletConfig", "type": "KubeletConfig"},
        "linux_os_config": {"key": "linuxOSConfig", "type": "LinuxOSConfig"},
        "enable_encryption_at_host": {"key": "enableEncryptionAtHost", "type": "bool"},
        "enable_ultra_ssd": {"key": "enableUltraSSD", "type": "bool"},
        "enable_fips": {"key": "enableFIPS", "type": "bool"},
        "gpu_instance_profile": {"key": "gpuInstanceProfile", "type": "str"},
        "creation_data": {"key": "creationData", "type": "CreationData"},
        "capacity_reservation_group_id": {"key": "capacityReservationGroupID", "type": "str"},
        "host_group_id": {"key": "hostGroupID", "type": "str"},
        "network_profile": {"key": "networkProfile", "type": "AgentPoolNetworkProfile"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        name: str,
        count: Optional[int] = None,
        vm_size: Optional[str] = None,
        os_disk_size_gb: Optional[int] = None,
        os_disk_type: Optional[Union[str, "_models.OSDiskType"]] = None,
        kubelet_disk_type: Optional[Union[str, "_models.KubeletDiskType"]] = None,
        workload_runtime: Optional[Union[str, "_models.WorkloadRuntime"]] = None,
        vnet_subnet_id: Optional[str] = None,
        pod_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Union[str, "_models.OSType"] = "Linux",
        os_sku: Optional[Union[str, "_models.OSSKU"]] = None,
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        scale_down_mode: Optional[Union[str, "_models.ScaleDownMode"]] = None,
        type: Optional[Union[str, "_models.AgentPoolType"]] = None,
        mode: Optional[Union[str, "_models.AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        power_state: Optional["_models.PowerState"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        node_public_ip_prefix_id: Optional[str] = None,
        scale_set_priority: Union[str, "_models.ScaleSetPriority"] = "Regular",
        scale_set_eviction_policy: Union[str, "_models.ScaleSetEvictionPolicy"] = "Delete",
        spot_max_price: float = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        proximity_placement_group_id: Optional[str] = None,
        kubelet_config: Optional["_models.KubeletConfig"] = None,
        linux_os_config: Optional["_models.LinuxOSConfig"] = None,
        enable_encryption_at_host: Optional[bool] = None,
        enable_ultra_ssd: Optional[bool] = None,
        enable_fips: Optional[bool] = None,
        gpu_instance_profile: Optional[Union[str, "_models.GPUInstanceProfile"]] = None,
        creation_data: Optional["_models.CreationData"] = None,
        capacity_reservation_group_id: Optional[str] = None,
        host_group_id: Optional[str] = None,
        network_profile: Optional["_models.AgentPoolNetworkProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of agents (VMs) to host docker containers. Allowed values must be in the
         range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for
         system pools. The default value is 1.
        :paramtype count: int
        :keyword vm_size: VM size availability varies by region. If a node contains insufficient
         compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on
         restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions.
        :paramtype vm_size: str
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in the master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword os_disk_type: The default is 'Ephemeral' if the VM supports it and has a cache disk
         larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed
         after creation. For more information see `Ephemeral OS
         <https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os>`_. Known values are:
         "Managed" and "Ephemeral".
        :paramtype os_disk_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSDiskType
        :keyword kubelet_disk_type: Determines the placement of emptyDir volumes, container runtime
         data root, and Kubelet ephemeral storage. Known values are: "OS" and "Temporary".
        :paramtype kubelet_disk_type: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.KubeletDiskType
        :keyword workload_runtime: Determines the type of workload a node can run. Known values are:
         "OCIContainer" and "WasmWasi".
        :paramtype workload_runtime: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.WorkloadRuntime
        :keyword vnet_subnet_id: If this is not specified, a VNET and subnet will be generated and
         used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to
         just nodes. This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
        :paramtype vnet_subnet_id: str
        :keyword pod_subnet_id: If omitted, pod IPs are statically assigned on the node subnet (see
         vnetSubnetID for more details). This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.  # pylint: disable=line-too-long
        :paramtype pod_subnet_id: str
        :keyword max_pods: The maximum number of pods that can run on a node.
        :paramtype max_pods: int
        :keyword os_type: The operating system type. The default is Linux. Known values are: "Linux"
         and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
        :keyword os_sku: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType
         is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >=
         1.25 if OSType is Windows. Known values are: "Ubuntu", "AzureLinux", "CBLMariner",
         "Windows2019", and "Windows2022".
        :paramtype os_sku: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSSKU
        :keyword max_count: The maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: The minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler.
        :paramtype enable_auto_scaling: bool
        :keyword scale_down_mode: This also effects the cluster autoscaler behavior. If not specified,
         it defaults to Delete. Known values are: "Delete" and "Deallocate".
        :paramtype scale_down_mode: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.ScaleDownMode
        :keyword type: The type of Agent Pool. Known values are: "VirtualMachineScaleSets" and
         "AvailabilitySet".
        :paramtype type: str or ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolType
        :keyword mode: A cluster must have at least one 'System' Agent Pool at all times. For
         additional information on agent pool restrictions and best practices, see:
         https://docs.microsoft.com/azure/aks/use-system-pools. Known values are: "System" and "User".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolMode
        :keyword orchestrator_version: Both patch version <major.minor.patch> (e.g. 1.20.13) and
         <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported
         GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once
         it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch
         version is available. As a best practice, you should upgrade all node pools in an AKS cluster
         to the same Kubernetes version. The node pool version must have the same major version as the
         control plane. The node pool minor version must be within two minor versions of the control
         plane version. The node pool version cannot be greater than the control plane version. For more
         information see `upgrading a node pool
         <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool>`_.
        :paramtype orchestrator_version: str
        :keyword upgrade_settings: Settings for upgrading the agentpool.
        :paramtype upgrade_settings:
         ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolUpgradeSettings
        :keyword power_state: When an Agent Pool is first created it is initially Running. The Agent
         Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs
         and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and
         provisioning state is Succeeded.
        :paramtype power_state: ~azure.mgmt.containerservice.v2024_01_01.models.PowerState
        :keyword availability_zones: The list of Availability zones to use for nodes. This can only be
         specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
        :paramtype availability_zones: list[str]
        :keyword enable_node_public_ip: Some scenarios may require nodes in a node pool to receive
         their own dedicated public IP addresses. A common scenario is for gaming workloads, where a
         console needs to make a direct connection to a cloud virtual machine to minimize hops. For more
         information see `assigning a public IP per node
         <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools>`_.  # pylint: disable=line-too-long
         The default is false.
        :paramtype enable_node_public_ip: bool
        :keyword node_public_ip_prefix_id: This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.  # pylint: disable=line-too-long
        :paramtype node_public_ip_prefix_id: str
        :keyword scale_set_priority: The Virtual Machine Scale Set priority. If not specified, the
         default is 'Regular'. Known values are: "Spot" and "Regular".
        :paramtype scale_set_priority: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetPriority
        :keyword scale_set_eviction_policy: This cannot be specified unless the scaleSetPriority is
         'Spot'. If not specified, the default is 'Delete'. Known values are: "Delete" and "Deallocate".
        :paramtype scale_set_eviction_policy: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.ScaleSetEvictionPolicy
        :keyword spot_max_price: Possible values are any decimal value greater than zero or -1 which
         indicates the willingness to pay any on-demand price. For more details on spot pricing, see
         `spot VMs pricing <https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing>`_.
        :paramtype spot_max_price: float
        :keyword tags: The tags to be persisted on the agent pool virtual machine scale set.
        :paramtype tags: dict[str, str]
        :keyword node_labels: The node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: The taints added to new nodes during node pool create and scale. For
         example, key=value:NoSchedule.
        :paramtype node_taints: list[str]
        :keyword proximity_placement_group_id: The ID for Proximity Placement Group.
        :paramtype proximity_placement_group_id: str
        :keyword kubelet_config: The Kubelet configuration on the agent pool nodes.
        :paramtype kubelet_config: ~azure.mgmt.containerservice.v2024_01_01.models.KubeletConfig
        :keyword linux_os_config: The OS configuration of Linux agent nodes.
        :paramtype linux_os_config: ~azure.mgmt.containerservice.v2024_01_01.models.LinuxOSConfig
        :keyword enable_encryption_at_host: This is only supported on certain VM sizes and in certain
         Azure regions. For more information, see:
         https://docs.microsoft.com/azure/aks/enable-host-encryption.
        :paramtype enable_encryption_at_host: bool
        :keyword enable_ultra_ssd: Whether to enable UltraSSD.
        :paramtype enable_ultra_ssd: bool
        :keyword enable_fips: See `Add a FIPS-enabled node pool
         <https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview>`_
         for more details.
        :paramtype enable_fips: bool
        :keyword gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance
         profile for supported GPU VM SKU. Known values are: "MIG1g", "MIG2g", "MIG3g", "MIG4g", and
         "MIG7g".
        :paramtype gpu_instance_profile: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.GPUInstanceProfile
        :keyword creation_data: CreationData to be used to specify the source Snapshot ID if the node
         pool will be created/upgraded using a snapshot.
        :paramtype creation_data: ~azure.mgmt.containerservice.v2024_01_01.models.CreationData
        :keyword capacity_reservation_group_id: AKS will associate the specified agent pool with the
         Capacity Reservation Group.
        :paramtype capacity_reservation_group_id: str
        :keyword host_group_id: This is of the form:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.  # pylint: disable=line-too-long
         For more information see `Azure dedicated hosts
         <https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts>`_.
        :paramtype host_group_id: str
        :keyword network_profile: Network-related settings of an agent pool.
        :paramtype network_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.AgentPoolNetworkProfile
        :keyword name: Windows agent pool names must be 6 characters or less. Required.
        :paramtype name: str
        """
        super().__init__(
            count=count,
            vm_size=vm_size,
            os_disk_size_gb=os_disk_size_gb,
            os_disk_type=os_disk_type,
            kubelet_disk_type=kubelet_disk_type,
            workload_runtime=workload_runtime,
            vnet_subnet_id=vnet_subnet_id,
            pod_subnet_id=pod_subnet_id,
            max_pods=max_pods,
            os_type=os_type,
            os_sku=os_sku,
            max_count=max_count,
            min_count=min_count,
            enable_auto_scaling=enable_auto_scaling,
            scale_down_mode=scale_down_mode,
            type=type,
            mode=mode,
            orchestrator_version=orchestrator_version,
            upgrade_settings=upgrade_settings,
            power_state=power_state,
            availability_zones=availability_zones,
            enable_node_public_ip=enable_node_public_ip,
            node_public_ip_prefix_id=node_public_ip_prefix_id,
            scale_set_priority=scale_set_priority,
            scale_set_eviction_policy=scale_set_eviction_policy,
            spot_max_price=spot_max_price,
            tags=tags,
            node_labels=node_labels,
            node_taints=node_taints,
            proximity_placement_group_id=proximity_placement_group_id,
            kubelet_config=kubelet_config,
            linux_os_config=linux_os_config,
            enable_encryption_at_host=enable_encryption_at_host,
            enable_ultra_ssd=enable_ultra_ssd,
            enable_fips=enable_fips,
            gpu_instance_profile=gpu_instance_profile,
            creation_data=creation_data,
            capacity_reservation_group_id=capacity_reservation_group_id,
            host_group_id=host_group_id,
            network_profile=network_profile,
            **kwargs
        )
        self.name = name


class ManagedClusterAPIServerAccessProfile(_serialization.Model):
    """Access profile for managed cluster API server.

    :ivar authorized_ip_ranges: IP ranges are specified in CIDR format, e.g. 137.117.106.88/29.
     This feature is not compatible with clusters that use Public IP Per Node, or clusters that are
     using a Basic Load Balancer. For more information see `API server authorized IP ranges
     <https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges>`_.
    :vartype authorized_ip_ranges: list[str]
    :ivar enable_private_cluster: For more details, see `Creating a private AKS cluster
     <https://docs.microsoft.com/azure/aks/private-clusters>`_.
    :vartype enable_private_cluster: bool
    :ivar private_dns_zone: The default is System. For more details see `configure private DNS zone
     <https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone>`_. Allowed
     values are 'system' and 'none'.
    :vartype private_dns_zone: str
    :ivar enable_private_cluster_public_fqdn: Whether to create additional public FQDN for private
     cluster or not.
    :vartype enable_private_cluster_public_fqdn: bool
    :ivar disable_run_command: Whether to disable run command for the cluster or not.
    :vartype disable_run_command: bool
    """

    _attribute_map = {
        "authorized_ip_ranges": {"key": "authorizedIPRanges", "type": "[str]"},
        "enable_private_cluster": {"key": "enablePrivateCluster", "type": "bool"},
        "private_dns_zone": {"key": "privateDNSZone", "type": "str"},
        "enable_private_cluster_public_fqdn": {"key": "enablePrivateClusterPublicFQDN", "type": "bool"},
        "disable_run_command": {"key": "disableRunCommand", "type": "bool"},
    }

    def __init__(
        self,
        *,
        authorized_ip_ranges: Optional[List[str]] = None,
        enable_private_cluster: Optional[bool] = None,
        private_dns_zone: Optional[str] = None,
        enable_private_cluster_public_fqdn: Optional[bool] = None,
        disable_run_command: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authorized_ip_ranges: IP ranges are specified in CIDR format, e.g. 137.117.106.88/29.
         This feature is not compatible with clusters that use Public IP Per Node, or clusters that are
         using a Basic Load Balancer. For more information see `API server authorized IP ranges
         <https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges>`_.
        :paramtype authorized_ip_ranges: list[str]
        :keyword enable_private_cluster: For more details, see `Creating a private AKS cluster
         <https://docs.microsoft.com/azure/aks/private-clusters>`_.
        :paramtype enable_private_cluster: bool
        :keyword private_dns_zone: The default is System. For more details see `configure private DNS
         zone <https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone>`_.
         Allowed values are 'system' and 'none'.
        :paramtype private_dns_zone: str
        :keyword enable_private_cluster_public_fqdn: Whether to create additional public FQDN for
         private cluster or not.
        :paramtype enable_private_cluster_public_fqdn: bool
        :keyword disable_run_command: Whether to disable run command for the cluster or not.
        :paramtype disable_run_command: bool
        """
        super().__init__(**kwargs)
        self.authorized_ip_ranges = authorized_ip_ranges
        self.enable_private_cluster = enable_private_cluster
        self.private_dns_zone = private_dns_zone
        self.enable_private_cluster_public_fqdn = enable_private_cluster_public_fqdn
        self.disable_run_command = disable_run_command


class ManagedClusterAutoUpgradeProfile(_serialization.Model):
    """Auto upgrade profile for a managed cluster.

    :ivar upgrade_channel: For more information see `setting the AKS cluster auto-upgrade channel
     <https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel>`_. Known values
     are: "rapid", "stable", "patch", "node-image", and "none".
    :vartype upgrade_channel: str or ~azure.mgmt.containerservice.v2024_01_01.models.UpgradeChannel
    :ivar node_os_upgrade_channel: Manner in which the OS on your nodes is updated. The default is
     NodeImage. Known values are: "None", "Unmanaged", and "NodeImage".
    :vartype node_os_upgrade_channel: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.NodeOSUpgradeChannel
    """

    _attribute_map = {
        "upgrade_channel": {"key": "upgradeChannel", "type": "str"},
        "node_os_upgrade_channel": {"key": "nodeOSUpgradeChannel", "type": "str"},
    }

    def __init__(
        self,
        *,
        upgrade_channel: Optional[Union[str, "_models.UpgradeChannel"]] = None,
        node_os_upgrade_channel: Optional[Union[str, "_models.NodeOSUpgradeChannel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword upgrade_channel: For more information see `setting the AKS cluster auto-upgrade
         channel <https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel>`_.
         Known values are: "rapid", "stable", "patch", "node-image", and "none".
        :paramtype upgrade_channel: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.UpgradeChannel
        :keyword node_os_upgrade_channel: Manner in which the OS on your nodes is updated. The default
         is NodeImage. Known values are: "None", "Unmanaged", and "NodeImage".
        :paramtype node_os_upgrade_channel: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.NodeOSUpgradeChannel
        """
        super().__init__(**kwargs)
        self.upgrade_channel = upgrade_channel
        self.node_os_upgrade_channel = node_os_upgrade_channel


class ManagedClusterAzureMonitorProfile(_serialization.Model):
    """Azure Monitor addon profiles for monitoring the managed cluster.

    :ivar metrics: Metrics profile for the Azure Monitor managed service for Prometheus addon.
     Collect out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace
     and configure additional scraping for custom targets. See aka.ms/AzureManagedPrometheus for an
     overview.
    :vartype metrics:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAzureMonitorProfileMetrics
    """

    _attribute_map = {
        "metrics": {"key": "metrics", "type": "ManagedClusterAzureMonitorProfileMetrics"},
    }

    def __init__(
        self, *, metrics: Optional["_models.ManagedClusterAzureMonitorProfileMetrics"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword metrics: Metrics profile for the Azure Monitor managed service for Prometheus addon.
         Collect out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace
         and configure additional scraping for custom targets. See aka.ms/AzureManagedPrometheus for an
         overview.
        :paramtype metrics:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAzureMonitorProfileMetrics
        """
        super().__init__(**kwargs)
        self.metrics = metrics


class ManagedClusterAzureMonitorProfileKubeStateMetrics(_serialization.Model):  # pylint: disable=name-too-long
    """Kube State Metrics profile for the Azure Managed Prometheus addon. These optional settings are
    for the kube-state-metrics pod that is deployed with the addon. See
    aka.ms/AzureManagedPrometheus-optional-parameters for details.

    :ivar metric_labels_allowlist: Comma-separated list of additional Kubernetes label keys that
     will be used in the resource's labels metric (Example:
     'namespaces=[k8s-label-1,k8s-label-n,...],pods=[app],...'). By default the metric contains only
     resource name and namespace labels.
    :vartype metric_labels_allowlist: str
    :ivar metric_annotations_allow_list: Comma-separated list of Kubernetes annotation keys that
     will be used in the resource's labels metric (Example:
     'namespaces=[kubernetes.io/team,...],pods=[kubernetes.io/team],...'). By default the metric
     contains only resource name and namespace labels.
    :vartype metric_annotations_allow_list: str
    """

    _attribute_map = {
        "metric_labels_allowlist": {"key": "metricLabelsAllowlist", "type": "str"},
        "metric_annotations_allow_list": {"key": "metricAnnotationsAllowList", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric_labels_allowlist: Optional[str] = None,
        metric_annotations_allow_list: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric_labels_allowlist: Comma-separated list of additional Kubernetes label keys that
         will be used in the resource's labels metric (Example:
         'namespaces=[k8s-label-1,k8s-label-n,...],pods=[app],...'). By default the metric contains only
         resource name and namespace labels.
        :paramtype metric_labels_allowlist: str
        :keyword metric_annotations_allow_list: Comma-separated list of Kubernetes annotation keys that
         will be used in the resource's labels metric (Example:
         'namespaces=[kubernetes.io/team,...],pods=[kubernetes.io/team],...'). By default the metric
         contains only resource name and namespace labels.
        :paramtype metric_annotations_allow_list: str
        """
        super().__init__(**kwargs)
        self.metric_labels_allowlist = metric_labels_allowlist
        self.metric_annotations_allow_list = metric_annotations_allow_list


class ManagedClusterAzureMonitorProfileMetrics(_serialization.Model):
    """Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect
    out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace and
    configure additional scraping for custom targets. See aka.ms/AzureManagedPrometheus for an
    overview.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether to enable or disable the Azure Managed Prometheus addon for Prometheus
     monitoring. See aka.ms/AzureManagedPrometheus-aks-enable for details on enabling and disabling.
     Required.
    :vartype enabled: bool
    :ivar kube_state_metrics: Kube State Metrics profile for the Azure Managed Prometheus addon.
     These optional settings are for the kube-state-metrics pod that is deployed with the addon. See
     aka.ms/AzureManagedPrometheus-optional-parameters for details.
    :vartype kube_state_metrics:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAzureMonitorProfileKubeStateMetrics
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "kube_state_metrics": {"key": "kubeStateMetrics", "type": "ManagedClusterAzureMonitorProfileKubeStateMetrics"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        kube_state_metrics: Optional["_models.ManagedClusterAzureMonitorProfileKubeStateMetrics"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Whether to enable or disable the Azure Managed Prometheus addon for
         Prometheus monitoring. See aka.ms/AzureManagedPrometheus-aks-enable for details on enabling and
         disabling. Required.
        :paramtype enabled: bool
        :keyword kube_state_metrics: Kube State Metrics profile for the Azure Managed Prometheus addon.
         These optional settings are for the kube-state-metrics pod that is deployed with the addon. See
         aka.ms/AzureManagedPrometheus-optional-parameters for details.
        :paramtype kube_state_metrics:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterAzureMonitorProfileKubeStateMetrics
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.kube_state_metrics = kube_state_metrics


class ManagedClusterHTTPProxyConfig(_serialization.Model):
    """Cluster HTTP proxy configuration.

    :ivar http_proxy: The HTTP proxy server endpoint to use.
    :vartype http_proxy: str
    :ivar https_proxy: The HTTPS proxy server endpoint to use.
    :vartype https_proxy: str
    :ivar no_proxy: The endpoints that should not go through proxy.
    :vartype no_proxy: list[str]
    :ivar trusted_ca: Alternative CA cert to use for connecting to proxy servers.
    :vartype trusted_ca: str
    """

    _attribute_map = {
        "http_proxy": {"key": "httpProxy", "type": "str"},
        "https_proxy": {"key": "httpsProxy", "type": "str"},
        "no_proxy": {"key": "noProxy", "type": "[str]"},
        "trusted_ca": {"key": "trustedCa", "type": "str"},
    }

    def __init__(
        self,
        *,
        http_proxy: Optional[str] = None,
        https_proxy: Optional[str] = None,
        no_proxy: Optional[List[str]] = None,
        trusted_ca: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword http_proxy: The HTTP proxy server endpoint to use.
        :paramtype http_proxy: str
        :keyword https_proxy: The HTTPS proxy server endpoint to use.
        :paramtype https_proxy: str
        :keyword no_proxy: The endpoints that should not go through proxy.
        :paramtype no_proxy: list[str]
        :keyword trusted_ca: Alternative CA cert to use for connecting to proxy servers.
        :paramtype trusted_ca: str
        """
        super().__init__(**kwargs)
        self.http_proxy = http_proxy
        self.https_proxy = https_proxy
        self.no_proxy = no_proxy
        self.trusted_ca = trusted_ca


class ManagedClusterIdentity(_serialization.Model):
    """Identity for the managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity which is used by master
     components.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity which is used by master
     components.
    :vartype tenant_id: str
    :ivar type: For more information see `use managed identities in AKS
     <https://docs.microsoft.com/azure/aks/use-managed-identity>`_. Known values are:
     "SystemAssigned", "UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.containerservice.v2024_01_01.models.ResourceIdentityType
    :ivar delegated_resources: The delegated identity resources assigned to this managed cluster.
     This can only be set by another Azure Resource Provider, and managed cluster only accept one
     delegated identity resource. Internal use only.
    :vartype delegated_resources: dict[str,
     ~azure.mgmt.containerservice.v2024_01_01.models.DelegatedResource]
    :ivar user_assigned_identities: The keys must be ARM resource IDs in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedServiceIdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "delegated_resources": {"key": "delegatedResources", "type": "{DelegatedResource}"},
        "user_assigned_identities": {
            "key": "userAssignedIdentities",
            "type": "{ManagedServiceIdentityUserAssignedIdentitiesValue}",
        },
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        delegated_resources: Optional[Dict[str, "_models.DelegatedResource"]] = None,
        user_assigned_identities: Optional[
            Dict[str, "_models.ManagedServiceIdentityUserAssignedIdentitiesValue"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: For more information see `use managed identities in AKS
         <https://docs.microsoft.com/azure/aks/use-managed-identity>`_. Known values are:
         "SystemAssigned", "UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.containerservice.v2024_01_01.models.ResourceIdentityType
        :keyword delegated_resources: The delegated identity resources assigned to this managed
         cluster. This can only be set by another Azure Resource Provider, and managed cluster only
         accept one delegated identity resource. Internal use only.
        :paramtype delegated_resources: dict[str,
         ~azure.mgmt.containerservice.v2024_01_01.models.DelegatedResource]
        :keyword user_assigned_identities: The keys must be ARM resource IDs in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedServiceIdentityUserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.delegated_resources = delegated_resources
        self.user_assigned_identities = user_assigned_identities


class ManagedClusterIngressProfile(_serialization.Model):
    """Ingress profile for the container service cluster.

    :ivar web_app_routing: App Routing settings for the ingress profile. You can find an overview
     and onboarding guide for this feature at
     https://learn.microsoft.com/en-us/azure/aks/app-routing?tabs=default%2Cdeploy-app-default.
    :vartype web_app_routing:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterIngressProfileWebAppRouting
    """

    _attribute_map = {
        "web_app_routing": {"key": "webAppRouting", "type": "ManagedClusterIngressProfileWebAppRouting"},
    }

    def __init__(
        self, *, web_app_routing: Optional["_models.ManagedClusterIngressProfileWebAppRouting"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword web_app_routing: App Routing settings for the ingress profile. You can find an
         overview and onboarding guide for this feature at
         https://learn.microsoft.com/en-us/azure/aks/app-routing?tabs=default%2Cdeploy-app-default.
        :paramtype web_app_routing:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterIngressProfileWebAppRouting
        """
        super().__init__(**kwargs)
        self.web_app_routing = web_app_routing


class ManagedClusterIngressProfileWebAppRouting(_serialization.Model):  # pylint: disable=name-too-long
    """Application Routing add-on settings for the ingress profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Whether to enable the Application Routing add-on.
    :vartype enabled: bool
    :ivar dns_zone_resource_ids: Resource IDs of the DNS zones to be associated with the
     Application Routing add-on. Used only when Application Routing add-on is enabled. Public and
     private DNS zones can be in different resource groups, but all public DNS zones must be in the
     same resource group and all private DNS zones must be in the same resource group.
    :vartype dns_zone_resource_ids: list[str]
    :ivar identity: Managed identity of the Application Routing add-on. This is the identity that
     should be granted permissions, for example, to manage the associated Azure DNS resource and get
     certificates from Azure Key Vault. See `this overview of the add-on
     <https://learn.microsoft.com/en-us/azure/aks/web-app-routing?tabs=with-osm>`_ for more
     instructions.
    :vartype identity: ~azure.mgmt.containerservice.v2024_01_01.models.UserAssignedIdentity
    """

    _validation = {
        "dns_zone_resource_ids": {"max_items": 5, "min_items": 0},
        "identity": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "dns_zone_resource_ids": {"key": "dnsZoneResourceIds", "type": "[str]"},
        "identity": {"key": "identity", "type": "UserAssignedIdentity"},
    }

    def __init__(
        self, *, enabled: Optional[bool] = None, dns_zone_resource_ids: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Whether to enable the Application Routing add-on.
        :paramtype enabled: bool
        :keyword dns_zone_resource_ids: Resource IDs of the DNS zones to be associated with the
         Application Routing add-on. Used only when Application Routing add-on is enabled. Public and
         private DNS zones can be in different resource groups, but all public DNS zones must be in the
         same resource group and all private DNS zones must be in the same resource group.
        :paramtype dns_zone_resource_ids: list[str]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.dns_zone_resource_ids = dns_zone_resource_ids
        self.identity = None


class ManagedClusterListResult(_serialization.Model):
    """The response from the List Managed Clusters operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of managed clusters.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedCluster]
    :ivar next_link: The URL to get the next set of managed cluster results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedCluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ManagedCluster"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of managed clusters.
        :paramtype value: list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedCluster]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ManagedClusterLoadBalancerProfile(_serialization.Model):
    """Profile of the managed cluster load balancer.

    :ivar managed_outbound_i_ps: Desired managed outbound IPs for the cluster load balancer.
    :vartype managed_outbound_i_ps:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
    :ivar outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load balancer.
    :vartype outbound_ip_prefixes:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
    :ivar outbound_i_ps: Desired outbound IP resources for the cluster load balancer.
    :vartype outbound_i_ps:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
    :ivar effective_outbound_i_ps: The effective outbound IP resources of the cluster load
     balancer.
    :vartype effective_outbound_i_ps:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ResourceReference]
    :ivar allocated_outbound_ports: The desired number of allocated SNAT ports per VM. Allowed
     values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in
     Azure dynamically allocating ports.
    :vartype allocated_outbound_ports: int
    :ivar idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
     are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_multiple_standard_load_balancers: Enable multiple standard load balancers per AKS
     cluster or not.
    :vartype enable_multiple_standard_load_balancers: bool
    :ivar backend_pool_type: The type of the managed inbound Load Balancer BackendPool. Known
     values are: "NodeIPConfiguration" and "NodeIP".
    :vartype backend_pool_type: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.BackendPoolType
    """

    _validation = {
        "allocated_outbound_ports": {"maximum": 64000, "minimum": 0},
        "idle_timeout_in_minutes": {"maximum": 120, "minimum": 4},
    }

    _attribute_map = {
        "managed_outbound_i_ps": {
            "key": "managedOutboundIPs",
            "type": "ManagedClusterLoadBalancerProfileManagedOutboundIPs",
        },
        "outbound_ip_prefixes": {
            "key": "outboundIPPrefixes",
            "type": "ManagedClusterLoadBalancerProfileOutboundIPPrefixes",
        },
        "outbound_i_ps": {"key": "outboundIPs", "type": "ManagedClusterLoadBalancerProfileOutboundIPs"},
        "effective_outbound_i_ps": {"key": "effectiveOutboundIPs", "type": "[ResourceReference]"},
        "allocated_outbound_ports": {"key": "allocatedOutboundPorts", "type": "int"},
        "idle_timeout_in_minutes": {"key": "idleTimeoutInMinutes", "type": "int"},
        "enable_multiple_standard_load_balancers": {"key": "enableMultipleStandardLoadBalancers", "type": "bool"},
        "backend_pool_type": {"key": "backendPoolType", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed_outbound_i_ps: Optional["_models.ManagedClusterLoadBalancerProfileManagedOutboundIPs"] = None,
        outbound_ip_prefixes: Optional["_models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes"] = None,
        outbound_i_ps: Optional["_models.ManagedClusterLoadBalancerProfileOutboundIPs"] = None,
        effective_outbound_i_ps: Optional[List["_models.ResourceReference"]] = None,
        allocated_outbound_ports: int = 0,
        idle_timeout_in_minutes: int = 30,
        enable_multiple_standard_load_balancers: Optional[bool] = None,
        backend_pool_type: Union[str, "_models.BackendPoolType"] = "NodeIPConfiguration",
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_outbound_i_ps: Desired managed outbound IPs for the cluster load balancer.
        :paramtype managed_outbound_i_ps:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
        :keyword outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load
         balancer.
        :paramtype outbound_ip_prefixes:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
        :keyword outbound_i_ps: Desired outbound IP resources for the cluster load balancer.
        :paramtype outbound_i_ps:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
        :keyword effective_outbound_i_ps: The effective outbound IP resources of the cluster load
         balancer.
        :paramtype effective_outbound_i_ps:
         list[~azure.mgmt.containerservice.v2024_01_01.models.ResourceReference]
        :keyword allocated_outbound_ports: The desired number of allocated SNAT ports per VM. Allowed
         values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in
         Azure dynamically allocating ports.
        :paramtype allocated_outbound_ports: int
        :keyword idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
         are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_multiple_standard_load_balancers: Enable multiple standard load balancers per
         AKS cluster or not.
        :paramtype enable_multiple_standard_load_balancers: bool
        :keyword backend_pool_type: The type of the managed inbound Load Balancer BackendPool. Known
         values are: "NodeIPConfiguration" and "NodeIP".
        :paramtype backend_pool_type: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.BackendPoolType
        """
        super().__init__(**kwargs)
        self.managed_outbound_i_ps = managed_outbound_i_ps
        self.outbound_ip_prefixes = outbound_ip_prefixes
        self.outbound_i_ps = outbound_i_ps
        self.effective_outbound_i_ps = effective_outbound_i_ps
        self.allocated_outbound_ports = allocated_outbound_ports
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_multiple_standard_load_balancers = enable_multiple_standard_load_balancers
        self.backend_pool_type = backend_pool_type


class ManagedClusterLoadBalancerProfileManagedOutboundIPs(_serialization.Model):  # pylint: disable=name-too-long
    """Desired managed outbound IPs for the cluster load balancer.

    :ivar count: The desired number of IPv4 outbound IPs created/managed by Azure for the cluster
     load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value
     is 1.
    :vartype count: int
    :ivar count_ipv6: The desired number of IPv6 outbound IPs created/managed by Azure for the
     cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default
     value is 0 for single-stack and 1 for dual-stack.
    :vartype count_ipv6: int
    """

    _validation = {
        "count": {"maximum": 100, "minimum": 1},
        "count_ipv6": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "count_ipv6": {"key": "countIPv6", "type": "int"},
    }

    def __init__(self, *, count: int = 1, count_ipv6: int = 0, **kwargs: Any) -> None:
        """
        :keyword count: The desired number of IPv4 outbound IPs created/managed by Azure for the
         cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default
         value is 1.
        :paramtype count: int
        :keyword count_ipv6: The desired number of IPv6 outbound IPs created/managed by Azure for the
         cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default
         value is 0 for single-stack and 1 for dual-stack.
        :paramtype count_ipv6: int
        """
        super().__init__(**kwargs)
        self.count = count
        self.count_ipv6 = count_ipv6


class ManagedClusterLoadBalancerProfileOutboundIPPrefixes(_serialization.Model):  # pylint: disable=name-too-long
    """Desired outbound IP Prefix resources for the cluster load balancer.

    :ivar public_ip_prefixes: A list of public IP prefix resources.
    :vartype public_ip_prefixes:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ResourceReference]
    """

    _attribute_map = {
        "public_ip_prefixes": {"key": "publicIPPrefixes", "type": "[ResourceReference]"},
    }

    def __init__(
        self, *, public_ip_prefixes: Optional[List["_models.ResourceReference"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword public_ip_prefixes: A list of public IP prefix resources.
        :paramtype public_ip_prefixes:
         list[~azure.mgmt.containerservice.v2024_01_01.models.ResourceReference]
        """
        super().__init__(**kwargs)
        self.public_ip_prefixes = public_ip_prefixes


class ManagedClusterLoadBalancerProfileOutboundIPs(_serialization.Model):  # pylint: disable=name-too-long
    """Desired outbound IP resources for the cluster load balancer.

    :ivar public_i_ps: A list of public IP resources.
    :vartype public_i_ps: list[~azure.mgmt.containerservice.v2024_01_01.models.ResourceReference]
    """

    _attribute_map = {
        "public_i_ps": {"key": "publicIPs", "type": "[ResourceReference]"},
    }

    def __init__(self, *, public_i_ps: Optional[List["_models.ResourceReference"]] = None, **kwargs: Any) -> None:
        """
        :keyword public_i_ps: A list of public IP resources.
        :paramtype public_i_ps: list[~azure.mgmt.containerservice.v2024_01_01.models.ResourceReference]
        """
        super().__init__(**kwargs)
        self.public_i_ps = public_i_ps


class ManagedClusterManagedOutboundIPProfile(_serialization.Model):
    """Profile of the managed outbound IP resources of the managed cluster.

    :ivar count: The desired number of outbound IPs created/managed by Azure. Allowed values must
     be in the range of 1 to 16 (inclusive). The default value is 1.
    :vartype count: int
    """

    _validation = {
        "count": {"maximum": 16, "minimum": 1},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, count: int = 1, **kwargs: Any) -> None:
        """
        :keyword count: The desired number of outbound IPs created/managed by Azure. Allowed values
         must be in the range of 1 to 16 (inclusive). The default value is 1.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.count = count


class ManagedClusterNATGatewayProfile(_serialization.Model):
    """Profile of the managed cluster NAT gateway.

    :ivar managed_outbound_ip_profile: Profile of the managed outbound IP resources of the cluster
     NAT gateway.
    :vartype managed_outbound_ip_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterManagedOutboundIPProfile
    :ivar effective_outbound_i_ps: The effective outbound IP resources of the cluster NAT gateway.
    :vartype effective_outbound_i_ps:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ResourceReference]
    :ivar idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
     are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
    :vartype idle_timeout_in_minutes: int
    """

    _validation = {
        "idle_timeout_in_minutes": {"maximum": 120, "minimum": 4},
    }

    _attribute_map = {
        "managed_outbound_ip_profile": {
            "key": "managedOutboundIPProfile",
            "type": "ManagedClusterManagedOutboundIPProfile",
        },
        "effective_outbound_i_ps": {"key": "effectiveOutboundIPs", "type": "[ResourceReference]"},
        "idle_timeout_in_minutes": {"key": "idleTimeoutInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        managed_outbound_ip_profile: Optional["_models.ManagedClusterManagedOutboundIPProfile"] = None,
        effective_outbound_i_ps: Optional[List["_models.ResourceReference"]] = None,
        idle_timeout_in_minutes: int = 4,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_outbound_ip_profile: Profile of the managed outbound IP resources of the
         cluster NAT gateway.
        :paramtype managed_outbound_ip_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterManagedOutboundIPProfile
        :keyword effective_outbound_i_ps: The effective outbound IP resources of the cluster NAT
         gateway.
        :paramtype effective_outbound_i_ps:
         list[~azure.mgmt.containerservice.v2024_01_01.models.ResourceReference]
        :keyword idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
         are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
        :paramtype idle_timeout_in_minutes: int
        """
        super().__init__(**kwargs)
        self.managed_outbound_ip_profile = managed_outbound_ip_profile
        self.effective_outbound_i_ps = effective_outbound_i_ps
        self.idle_timeout_in_minutes = idle_timeout_in_minutes


class ManagedClusterOIDCIssuerProfile(_serialization.Model):
    """The OIDC issuer profile of the Managed Cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar issuer_url: The OIDC issuer url of the Managed Cluster.
    :vartype issuer_url: str
    :ivar enabled: Whether the OIDC issuer is enabled.
    :vartype enabled: bool
    """

    _validation = {
        "issuer_url": {"readonly": True},
    }

    _attribute_map = {
        "issuer_url": {"key": "issuerURL", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether the OIDC issuer is enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.issuer_url = None
        self.enabled = enabled


class ManagedClusterPodIdentity(_serialization.Model):
    """Details about the pod identity assigned to the Managed Cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the pod identity. Required.
    :vartype name: str
    :ivar namespace: The namespace of the pod identity. Required.
    :vartype namespace: str
    :ivar binding_selector: The binding selector to use for the AzureIdentityBinding resource.
    :vartype binding_selector: str
    :ivar identity: The user assigned identity details. Required.
    :vartype identity: ~azure.mgmt.containerservice.v2024_01_01.models.UserAssignedIdentity
    :ivar provisioning_state: The current provisioning state of the pod identity. Known values are:
     "Assigned", "Canceled", "Deleting", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityProvisioningState
    :ivar provisioning_info:
    :vartype provisioning_info:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityProvisioningInfo
    """

    _validation = {
        "name": {"required": True},
        "namespace": {"required": True},
        "identity": {"required": True},
        "provisioning_state": {"readonly": True},
        "provisioning_info": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "binding_selector": {"key": "bindingSelector", "type": "str"},
        "identity": {"key": "identity", "type": "UserAssignedIdentity"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "provisioning_info": {"key": "provisioningInfo", "type": "ManagedClusterPodIdentityProvisioningInfo"},
    }

    def __init__(
        self,
        *,
        name: str,
        namespace: str,
        identity: "_models.UserAssignedIdentity",
        binding_selector: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the pod identity. Required.
        :paramtype name: str
        :keyword namespace: The namespace of the pod identity. Required.
        :paramtype namespace: str
        :keyword binding_selector: The binding selector to use for the AzureIdentityBinding resource.
        :paramtype binding_selector: str
        :keyword identity: The user assigned identity details. Required.
        :paramtype identity: ~azure.mgmt.containerservice.v2024_01_01.models.UserAssignedIdentity
        """
        super().__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.binding_selector = binding_selector
        self.identity = identity
        self.provisioning_state = None
        self.provisioning_info = None


class ManagedClusterPodIdentityException(_serialization.Model):
    """See `disable AAD Pod Identity for a specific Pod/Application
    <https://azure.github.io/aad-pod-identity/docs/configure/application_exception/>`_ for more
    details.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the pod identity exception. Required.
    :vartype name: str
    :ivar namespace: The namespace of the pod identity exception. Required.
    :vartype namespace: str
    :ivar pod_labels: The pod labels to match. Required.
    :vartype pod_labels: dict[str, str]
    """

    _validation = {
        "name": {"required": True},
        "namespace": {"required": True},
        "pod_labels": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "pod_labels": {"key": "podLabels", "type": "{str}"},
    }

    def __init__(self, *, name: str, namespace: str, pod_labels: Dict[str, str], **kwargs: Any) -> None:
        """
        :keyword name: The name of the pod identity exception. Required.
        :paramtype name: str
        :keyword namespace: The namespace of the pod identity exception. Required.
        :paramtype namespace: str
        :keyword pod_labels: The pod labels to match. Required.
        :paramtype pod_labels: dict[str, str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.pod_labels = pod_labels


class ManagedClusterPodIdentityProfile(_serialization.Model):
    """See `use AAD pod identity <https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity>`_
    for more details on pod identity integration.

    :ivar enabled: Whether the pod identity addon is enabled.
    :vartype enabled: bool
    :ivar allow_network_plugin_kubenet: Running in Kubenet is disabled by default due to the
     security related nature of AAD Pod Identity and the risks of IP spoofing. See `using Kubenet
     network plugin with AAD Pod Identity
     <https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities>`_  # pylint: disable=line-too-long
     for more information.
    :vartype allow_network_plugin_kubenet: bool
    :ivar user_assigned_identities: The pod identities to use in the cluster.
    :vartype user_assigned_identities:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentity]
    :ivar user_assigned_identity_exceptions: The pod identity exceptions to allow.
    :vartype user_assigned_identity_exceptions:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityException]
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "allow_network_plugin_kubenet": {"key": "allowNetworkPluginKubenet", "type": "bool"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "[ManagedClusterPodIdentity]"},
        "user_assigned_identity_exceptions": {
            "key": "userAssignedIdentityExceptions",
            "type": "[ManagedClusterPodIdentityException]",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        allow_network_plugin_kubenet: Optional[bool] = None,
        user_assigned_identities: Optional[List["_models.ManagedClusterPodIdentity"]] = None,
        user_assigned_identity_exceptions: Optional[List["_models.ManagedClusterPodIdentityException"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Whether the pod identity addon is enabled.
        :paramtype enabled: bool
        :keyword allow_network_plugin_kubenet: Running in Kubenet is disabled by default due to the
         security related nature of AAD Pod Identity and the risks of IP spoofing. See `using Kubenet
         network plugin with AAD Pod Identity
         <https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities>`_  # pylint: disable=line-too-long
         for more information.
        :paramtype allow_network_plugin_kubenet: bool
        :keyword user_assigned_identities: The pod identities to use in the cluster.
        :paramtype user_assigned_identities:
         list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentity]
        :keyword user_assigned_identity_exceptions: The pod identity exceptions to allow.
        :paramtype user_assigned_identity_exceptions:
         list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityException]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.allow_network_plugin_kubenet = allow_network_plugin_kubenet
        self.user_assigned_identities = user_assigned_identities
        self.user_assigned_identity_exceptions = user_assigned_identity_exceptions


class ManagedClusterPodIdentityProvisioningError(_serialization.Model):  # pylint: disable=name-too-long
    """An error response from the pod identity provisioning.

    :ivar error: Details about the error.
    :vartype error:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityProvisioningErrorBody
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ManagedClusterPodIdentityProvisioningErrorBody"},
    }

    def __init__(
        self, *, error: Optional["_models.ManagedClusterPodIdentityProvisioningErrorBody"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword error: Details about the error.
        :paramtype error:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityProvisioningErrorBody
        """
        super().__init__(**kwargs)
        self.error = error


class ManagedClusterPodIdentityProvisioningErrorBody(_serialization.Model):  # pylint: disable=name-too-long
    """An error response from the pod identity provisioning.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityProvisioningErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ManagedClusterPodIdentityProvisioningErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ManagedClusterPodIdentityProvisioningErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details:
         list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityProvisioningErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ManagedClusterPodIdentityProvisioningInfo(_serialization.Model):  # pylint: disable=name-too-long
    """ManagedClusterPodIdentityProvisioningInfo.

    :ivar error: Pod identity assignment error (if any).
    :vartype error:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityProvisioningError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ManagedClusterPodIdentityProvisioningError"},
    }

    def __init__(
        self, *, error: Optional["_models.ManagedClusterPodIdentityProvisioningError"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword error: Pod identity assignment error (if any).
        :paramtype error:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPodIdentityProvisioningError
        """
        super().__init__(**kwargs)
        self.error = error


class ManagedClusterPoolUpgradeProfile(_serialization.Model):
    """The list of available upgrade versions.

    All required parameters must be populated in order to send to server.

    :ivar kubernetes_version: The Kubernetes version (major.minor.patch). Required.
    :vartype kubernetes_version: str
    :ivar name: The Agent Pool name.
    :vartype name: str
    :ivar os_type: The operating system type. The default is Linux. Known values are: "Linux" and
     "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
    :ivar upgrades: List of orchestrator types and versions available for upgrade.
    :vartype upgrades:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
    """

    _validation = {
        "kubernetes_version": {"required": True},
        "os_type": {"required": True},
    }

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "upgrades": {"key": "upgrades", "type": "[ManagedClusterPoolUpgradeProfileUpgradesItem]"},
    }

    def __init__(
        self,
        *,
        kubernetes_version: str,
        os_type: Union[str, "_models.OSType"] = "Linux",
        name: Optional[str] = None,
        upgrades: Optional[List["_models.ManagedClusterPoolUpgradeProfileUpgradesItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: The Kubernetes version (major.minor.patch). Required.
        :paramtype kubernetes_version: str
        :keyword name: The Agent Pool name.
        :paramtype name: str
        :keyword os_type: The operating system type. The default is Linux. Known values are: "Linux"
         and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
        :keyword upgrades: List of orchestrator types and versions available for upgrade.
        :paramtype upgrades:
         list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
        """
        super().__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.name = name
        self.os_type = os_type
        self.upgrades = upgrades


class ManagedClusterPoolUpgradeProfileUpgradesItem(_serialization.Model):  # pylint: disable=name-too-long
    """ManagedClusterPoolUpgradeProfileUpgradesItem.

    :ivar kubernetes_version: The Kubernetes version (major.minor.patch).
    :vartype kubernetes_version: str
    :ivar is_preview: Whether the Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(
        self, *, kubernetes_version: Optional[str] = None, is_preview: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: The Kubernetes version (major.minor.patch).
        :paramtype kubernetes_version: str
        :keyword is_preview: Whether the Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class ManagedClusterPropertiesAutoScalerProfile(
    _serialization.Model
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Parameters to be applied to the cluster-autoscaler when enabled.

    :ivar balance_similar_node_groups: Valid values are 'true' and 'false'.
    :vartype balance_similar_node_groups: str
    :ivar expander: If not specified, the default is 'random'. See `expanders
     <https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders>`_
     for more information. Known values are: "least-waste", "most-pods", "priority", and "random".
    :vartype expander: str or ~azure.mgmt.containerservice.v2024_01_01.models.Expander
    :ivar max_empty_bulk_delete: The default is 10.
    :vartype max_empty_bulk_delete: str
    :ivar max_graceful_termination_sec: The default is 600.
    :vartype max_graceful_termination_sec: str
    :ivar max_node_provision_time: The default is '15m'. Values must be an integer followed by an
     'm'. No unit of time other than minutes (m) is supported.
    :vartype max_node_provision_time: str
    :ivar max_total_unready_percentage: The default is 45. The maximum is 100 and the minimum is 0.
    :vartype max_total_unready_percentage: str
    :ivar new_pod_scale_up_delay: For scenarios like burst/batch scale where you don't want CA to
     act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore
     unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer
     followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
    :vartype new_pod_scale_up_delay: str
    :ivar ok_total_unready_count: This must be an integer. The default is 3.
    :vartype ok_total_unready_count: str
    :ivar scan_interval: The default is '10'. Values must be an integer number of seconds.
    :vartype scan_interval: str
    :ivar scale_down_delay_after_add: The default is '10m'. Values must be an integer followed by
     an 'm'. No unit of time other than minutes (m) is supported.
    :vartype scale_down_delay_after_add: str
    :ivar scale_down_delay_after_delete: The default is the scan-interval. Values must be an
     integer followed by an 'm'. No unit of time other than minutes (m) is supported.
    :vartype scale_down_delay_after_delete: str
    :ivar scale_down_delay_after_failure: The default is '3m'. Values must be an integer followed
     by an 'm'. No unit of time other than minutes (m) is supported.
    :vartype scale_down_delay_after_failure: str
    :ivar scale_down_unneeded_time: The default is '10m'. Values must be an integer followed by an
     'm'. No unit of time other than minutes (m) is supported.
    :vartype scale_down_unneeded_time: str
    :ivar scale_down_unready_time: The default is '20m'. Values must be an integer followed by an
     'm'. No unit of time other than minutes (m) is supported.
    :vartype scale_down_unready_time: str
    :ivar scale_down_utilization_threshold: The default is '0.5'.
    :vartype scale_down_utilization_threshold: str
    :ivar skip_nodes_with_local_storage: The default is true.
    :vartype skip_nodes_with_local_storage: str
    :ivar skip_nodes_with_system_pods: The default is true.
    :vartype skip_nodes_with_system_pods: str
    """

    _attribute_map = {
        "balance_similar_node_groups": {"key": "balance-similar-node-groups", "type": "str"},
        "expander": {"key": "expander", "type": "str"},
        "max_empty_bulk_delete": {"key": "max-empty-bulk-delete", "type": "str"},
        "max_graceful_termination_sec": {"key": "max-graceful-termination-sec", "type": "str"},
        "max_node_provision_time": {"key": "max-node-provision-time", "type": "str"},
        "max_total_unready_percentage": {"key": "max-total-unready-percentage", "type": "str"},
        "new_pod_scale_up_delay": {"key": "new-pod-scale-up-delay", "type": "str"},
        "ok_total_unready_count": {"key": "ok-total-unready-count", "type": "str"},
        "scan_interval": {"key": "scan-interval", "type": "str"},
        "scale_down_delay_after_add": {"key": "scale-down-delay-after-add", "type": "str"},
        "scale_down_delay_after_delete": {"key": "scale-down-delay-after-delete", "type": "str"},
        "scale_down_delay_after_failure": {"key": "scale-down-delay-after-failure", "type": "str"},
        "scale_down_unneeded_time": {"key": "scale-down-unneeded-time", "type": "str"},
        "scale_down_unready_time": {"key": "scale-down-unready-time", "type": "str"},
        "scale_down_utilization_threshold": {"key": "scale-down-utilization-threshold", "type": "str"},
        "skip_nodes_with_local_storage": {"key": "skip-nodes-with-local-storage", "type": "str"},
        "skip_nodes_with_system_pods": {"key": "skip-nodes-with-system-pods", "type": "str"},
    }

    def __init__(
        self,
        *,
        balance_similar_node_groups: Optional[str] = None,
        expander: Optional[Union[str, "_models.Expander"]] = None,
        max_empty_bulk_delete: Optional[str] = None,
        max_graceful_termination_sec: Optional[str] = None,
        max_node_provision_time: Optional[str] = None,
        max_total_unready_percentage: Optional[str] = None,
        new_pod_scale_up_delay: Optional[str] = None,
        ok_total_unready_count: Optional[str] = None,
        scan_interval: Optional[str] = None,
        scale_down_delay_after_add: Optional[str] = None,
        scale_down_delay_after_delete: Optional[str] = None,
        scale_down_delay_after_failure: Optional[str] = None,
        scale_down_unneeded_time: Optional[str] = None,
        scale_down_unready_time: Optional[str] = None,
        scale_down_utilization_threshold: Optional[str] = None,
        skip_nodes_with_local_storage: Optional[str] = None,
        skip_nodes_with_system_pods: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword balance_similar_node_groups: Valid values are 'true' and 'false'.
        :paramtype balance_similar_node_groups: str
        :keyword expander: If not specified, the default is 'random'. See `expanders
         <https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders>`_
         for more information. Known values are: "least-waste", "most-pods", "priority", and "random".
        :paramtype expander: str or ~azure.mgmt.containerservice.v2024_01_01.models.Expander
        :keyword max_empty_bulk_delete: The default is 10.
        :paramtype max_empty_bulk_delete: str
        :keyword max_graceful_termination_sec: The default is 600.
        :paramtype max_graceful_termination_sec: str
        :keyword max_node_provision_time: The default is '15m'. Values must be an integer followed by
         an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype max_node_provision_time: str
        :keyword max_total_unready_percentage: The default is 45. The maximum is 100 and the minimum is
         0.
        :paramtype max_total_unready_percentage: str
        :keyword new_pod_scale_up_delay: For scenarios like burst/batch scale where you don't want CA
         to act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore
         unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer
         followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
        :paramtype new_pod_scale_up_delay: str
        :keyword ok_total_unready_count: This must be an integer. The default is 3.
        :paramtype ok_total_unready_count: str
        :keyword scan_interval: The default is '10'. Values must be an integer number of seconds.
        :paramtype scan_interval: str
        :keyword scale_down_delay_after_add: The default is '10m'. Values must be an integer followed
         by an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype scale_down_delay_after_add: str
        :keyword scale_down_delay_after_delete: The default is the scan-interval. Values must be an
         integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype scale_down_delay_after_delete: str
        :keyword scale_down_delay_after_failure: The default is '3m'. Values must be an integer
         followed by an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype scale_down_delay_after_failure: str
        :keyword scale_down_unneeded_time: The default is '10m'. Values must be an integer followed by
         an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype scale_down_unneeded_time: str
        :keyword scale_down_unready_time: The default is '20m'. Values must be an integer followed by
         an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype scale_down_unready_time: str
        :keyword scale_down_utilization_threshold: The default is '0.5'.
        :paramtype scale_down_utilization_threshold: str
        :keyword skip_nodes_with_local_storage: The default is true.
        :paramtype skip_nodes_with_local_storage: str
        :keyword skip_nodes_with_system_pods: The default is true.
        :paramtype skip_nodes_with_system_pods: str
        """
        super().__init__(**kwargs)
        self.balance_similar_node_groups = balance_similar_node_groups
        self.expander = expander
        self.max_empty_bulk_delete = max_empty_bulk_delete
        self.max_graceful_termination_sec = max_graceful_termination_sec
        self.max_node_provision_time = max_node_provision_time
        self.max_total_unready_percentage = max_total_unready_percentage
        self.new_pod_scale_up_delay = new_pod_scale_up_delay
        self.ok_total_unready_count = ok_total_unready_count
        self.scan_interval = scan_interval
        self.scale_down_delay_after_add = scale_down_delay_after_add
        self.scale_down_delay_after_delete = scale_down_delay_after_delete
        self.scale_down_delay_after_failure = scale_down_delay_after_failure
        self.scale_down_unneeded_time = scale_down_unneeded_time
        self.scale_down_unready_time = scale_down_unready_time
        self.scale_down_utilization_threshold = scale_down_utilization_threshold
        self.skip_nodes_with_local_storage = skip_nodes_with_local_storage
        self.skip_nodes_with_system_pods = skip_nodes_with_system_pods


class ManagedClusterSecurityProfile(_serialization.Model):
    """Security profile for the container service cluster.

    :ivar defender: Microsoft Defender settings for the security profile.
    :vartype defender:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSecurityProfileDefender
    :ivar azure_key_vault_kms: Azure Key Vault `key management service
     <https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/>`_ settings for the security
     profile.
    :vartype azure_key_vault_kms: ~azure.mgmt.containerservice.v2024_01_01.models.AzureKeyVaultKms
    :ivar workload_identity: Workload identity settings for the security profile. Workload identity
     enables Kubernetes applications to access Azure cloud resources securely with Azure AD. See
     https://aka.ms/aks/wi for more details.
    :vartype workload_identity:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSecurityProfileWorkloadIdentity
    :ivar image_cleaner: Image Cleaner settings for the security profile.
    :vartype image_cleaner:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSecurityProfileImageCleaner
    """

    _attribute_map = {
        "defender": {"key": "defender", "type": "ManagedClusterSecurityProfileDefender"},
        "azure_key_vault_kms": {"key": "azureKeyVaultKms", "type": "AzureKeyVaultKms"},
        "workload_identity": {"key": "workloadIdentity", "type": "ManagedClusterSecurityProfileWorkloadIdentity"},
        "image_cleaner": {"key": "imageCleaner", "type": "ManagedClusterSecurityProfileImageCleaner"},
    }

    def __init__(
        self,
        *,
        defender: Optional["_models.ManagedClusterSecurityProfileDefender"] = None,
        azure_key_vault_kms: Optional["_models.AzureKeyVaultKms"] = None,
        workload_identity: Optional["_models.ManagedClusterSecurityProfileWorkloadIdentity"] = None,
        image_cleaner: Optional["_models.ManagedClusterSecurityProfileImageCleaner"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword defender: Microsoft Defender settings for the security profile.
        :paramtype defender:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSecurityProfileDefender
        :keyword azure_key_vault_kms: Azure Key Vault `key management service
         <https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/>`_ settings for the security
         profile.
        :paramtype azure_key_vault_kms:
         ~azure.mgmt.containerservice.v2024_01_01.models.AzureKeyVaultKms
        :keyword workload_identity: Workload identity settings for the security profile. Workload
         identity enables Kubernetes applications to access Azure cloud resources securely with Azure
         AD. See https://aka.ms/aks/wi for more details.
        :paramtype workload_identity:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSecurityProfileWorkloadIdentity
        :keyword image_cleaner: Image Cleaner settings for the security profile.
        :paramtype image_cleaner:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSecurityProfileImageCleaner
        """
        super().__init__(**kwargs)
        self.defender = defender
        self.azure_key_vault_kms = azure_key_vault_kms
        self.workload_identity = workload_identity
        self.image_cleaner = image_cleaner


class ManagedClusterSecurityProfileDefender(_serialization.Model):
    """Microsoft Defender settings for the security profile.

    :ivar log_analytics_workspace_resource_id: Resource ID of the Log Analytics workspace to be
     associated with Microsoft Defender. When Microsoft Defender is enabled, this field is required
     and must be a valid workspace resource ID. When Microsoft Defender is disabled, leave the field
     empty.
    :vartype log_analytics_workspace_resource_id: str
    :ivar security_monitoring: Microsoft Defender threat detection for Cloud settings for the
     security profile.
    :vartype security_monitoring:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSecurityProfileDefenderSecurityMonitoring
    """

    _attribute_map = {
        "log_analytics_workspace_resource_id": {"key": "logAnalyticsWorkspaceResourceId", "type": "str"},
        "security_monitoring": {
            "key": "securityMonitoring",
            "type": "ManagedClusterSecurityProfileDefenderSecurityMonitoring",
        },
    }

    def __init__(
        self,
        *,
        log_analytics_workspace_resource_id: Optional[str] = None,
        security_monitoring: Optional["_models.ManagedClusterSecurityProfileDefenderSecurityMonitoring"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_analytics_workspace_resource_id: Resource ID of the Log Analytics workspace to be
         associated with Microsoft Defender. When Microsoft Defender is enabled, this field is required
         and must be a valid workspace resource ID. When Microsoft Defender is disabled, leave the field
         empty.
        :paramtype log_analytics_workspace_resource_id: str
        :keyword security_monitoring: Microsoft Defender threat detection for Cloud settings for the
         security profile.
        :paramtype security_monitoring:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSecurityProfileDefenderSecurityMonitoring
        """
        super().__init__(**kwargs)
        self.log_analytics_workspace_resource_id = log_analytics_workspace_resource_id
        self.security_monitoring = security_monitoring


class ManagedClusterSecurityProfileDefenderSecurityMonitoring(_serialization.Model):  # pylint: disable=name-too-long
    """Microsoft Defender settings for the security profile threat detection.

    :ivar enabled: Whether to enable Defender threat detection.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable Defender threat detection.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ManagedClusterSecurityProfileImageCleaner(_serialization.Model):  # pylint: disable=name-too-long
    """Image Cleaner removes unused images from nodes, freeing up disk space and helping to reduce
    attack surface area. Here are settings for the security profile.

    :ivar enabled: Whether to enable Image Cleaner on AKS cluster.
    :vartype enabled: bool
    :ivar interval_hours: Image Cleaner scanning interval in hours.
    :vartype interval_hours: int
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "interval_hours": {"key": "intervalHours", "type": "int"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, interval_hours: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable Image Cleaner on AKS cluster.
        :paramtype enabled: bool
        :keyword interval_hours: Image Cleaner scanning interval in hours.
        :paramtype interval_hours: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.interval_hours = interval_hours


class ManagedClusterSecurityProfileWorkloadIdentity(_serialization.Model):  # pylint: disable=name-too-long
    """Workload identity settings for the security profile.

    :ivar enabled: Whether to enable workload identity.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable workload identity.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ManagedClusterServicePrincipalProfile(_serialization.Model):
    """Information about a service principal identity for the cluster to use for manipulating Azure
    APIs.

    All required parameters must be populated in order to send to server.

    :ivar client_id: The ID for the service principal. Required.
    :vartype client_id: str
    :ivar secret: The secret password associated with the service principal in plain text.
    :vartype secret: str
    """

    _validation = {
        "client_id": {"required": True},
    }

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(self, *, client_id: str, secret: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: The ID for the service principal. Required.
        :paramtype client_id: str
        :keyword secret: The secret password associated with the service principal in plain text.
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.secret = secret


class ManagedClusterSKU(_serialization.Model):
    """The SKU of a Managed Cluster.

    :ivar name: The name of a managed cluster SKU. "Base"
    :vartype name: str or ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSKUName
    :ivar tier: If not specified, the default is 'Free'. See `AKS Pricing Tier
     <https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers>`_ for more details. Known
     values are: "Premium", "Standard", and "Free".
    :vartype tier: str or ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSKUTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.ManagedClusterSKUName"]] = None,
        tier: Optional[Union[str, "_models.ManagedClusterSKUTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of a managed cluster SKU. "Base"
        :paramtype name: str or ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSKUName
        :keyword tier: If not specified, the default is 'Free'. See `AKS Pricing Tier
         <https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers>`_ for more details. Known
         values are: "Premium", "Standard", and "Free".
        :paramtype tier: str or ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterSKUTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class ManagedClusterStorageProfile(_serialization.Model):
    """Storage profile for the container service cluster.

    :ivar disk_csi_driver: AzureDisk CSI Driver settings for the storage profile.
    :vartype disk_csi_driver:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterStorageProfileDiskCSIDriver
    :ivar file_csi_driver: AzureFile CSI Driver settings for the storage profile.
    :vartype file_csi_driver:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterStorageProfileFileCSIDriver
    :ivar snapshot_controller: Snapshot Controller settings for the storage profile.
    :vartype snapshot_controller:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterStorageProfileSnapshotController
    :ivar blob_csi_driver: AzureBlob CSI Driver settings for the storage profile.
    :vartype blob_csi_driver:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterStorageProfileBlobCSIDriver
    """

    _attribute_map = {
        "disk_csi_driver": {"key": "diskCSIDriver", "type": "ManagedClusterStorageProfileDiskCSIDriver"},
        "file_csi_driver": {"key": "fileCSIDriver", "type": "ManagedClusterStorageProfileFileCSIDriver"},
        "snapshot_controller": {"key": "snapshotController", "type": "ManagedClusterStorageProfileSnapshotController"},
        "blob_csi_driver": {"key": "blobCSIDriver", "type": "ManagedClusterStorageProfileBlobCSIDriver"},
    }

    def __init__(
        self,
        *,
        disk_csi_driver: Optional["_models.ManagedClusterStorageProfileDiskCSIDriver"] = None,
        file_csi_driver: Optional["_models.ManagedClusterStorageProfileFileCSIDriver"] = None,
        snapshot_controller: Optional["_models.ManagedClusterStorageProfileSnapshotController"] = None,
        blob_csi_driver: Optional["_models.ManagedClusterStorageProfileBlobCSIDriver"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_csi_driver: AzureDisk CSI Driver settings for the storage profile.
        :paramtype disk_csi_driver:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterStorageProfileDiskCSIDriver
        :keyword file_csi_driver: AzureFile CSI Driver settings for the storage profile.
        :paramtype file_csi_driver:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterStorageProfileFileCSIDriver
        :keyword snapshot_controller: Snapshot Controller settings for the storage profile.
        :paramtype snapshot_controller:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterStorageProfileSnapshotController
        :keyword blob_csi_driver: AzureBlob CSI Driver settings for the storage profile.
        :paramtype blob_csi_driver:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterStorageProfileBlobCSIDriver
        """
        super().__init__(**kwargs)
        self.disk_csi_driver = disk_csi_driver
        self.file_csi_driver = file_csi_driver
        self.snapshot_controller = snapshot_controller
        self.blob_csi_driver = blob_csi_driver


class ManagedClusterStorageProfileBlobCSIDriver(_serialization.Model):  # pylint: disable=name-too-long
    """AzureBlob CSI Driver settings for the storage profile.

    :ivar enabled: Whether to enable AzureBlob CSI Driver. The default value is false.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable AzureBlob CSI Driver. The default value is false.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ManagedClusterStorageProfileDiskCSIDriver(_serialization.Model):  # pylint: disable=name-too-long
    """AzureDisk CSI Driver settings for the storage profile.

    :ivar enabled: Whether to enable AzureDisk CSI Driver. The default value is true.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable AzureDisk CSI Driver. The default value is true.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ManagedClusterStorageProfileFileCSIDriver(_serialization.Model):  # pylint: disable=name-too-long
    """AzureFile CSI Driver settings for the storage profile.

    :ivar enabled: Whether to enable AzureFile CSI Driver. The default value is true.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable AzureFile CSI Driver. The default value is true.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ManagedClusterStorageProfileSnapshotController(_serialization.Model):  # pylint: disable=name-too-long
    """Snapshot Controller settings for the storage profile.

    :ivar enabled: Whether to enable Snapshot Controller. The default value is true.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable Snapshot Controller. The default value is true.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ManagedClusterUpgradeProfile(_serialization.Model):
    """The list of available upgrades for compute pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the upgrade profile.
    :vartype id: str
    :ivar name: The name of the upgrade profile.
    :vartype name: str
    :ivar type: The type of the upgrade profile.
    :vartype type: str
    :ivar control_plane_profile: The list of available upgrade versions for the control plane.
     Required.
    :vartype control_plane_profile:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPoolUpgradeProfile
    :ivar agent_pool_profiles: The list of available upgrade versions for agent pools. Required.
    :vartype agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPoolUpgradeProfile]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "control_plane_profile": {"required": True},
        "agent_pool_profiles": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "control_plane_profile": {"key": "properties.controlPlaneProfile", "type": "ManagedClusterPoolUpgradeProfile"},
        "agent_pool_profiles": {"key": "properties.agentPoolProfiles", "type": "[ManagedClusterPoolUpgradeProfile]"},
    }

    def __init__(
        self,
        *,
        control_plane_profile: "_models.ManagedClusterPoolUpgradeProfile",
        agent_pool_profiles: List["_models.ManagedClusterPoolUpgradeProfile"],
        **kwargs: Any
    ) -> None:
        """
        :keyword control_plane_profile: The list of available upgrade versions for the control plane.
         Required.
        :paramtype control_plane_profile:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPoolUpgradeProfile
        :keyword agent_pool_profiles: The list of available upgrade versions for agent pools. Required.
        :paramtype agent_pool_profiles:
         list[~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterPoolUpgradeProfile]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.control_plane_profile = control_plane_profile
        self.agent_pool_profiles = agent_pool_profiles


class ManagedClusterWindowsProfile(_serialization.Model):
    """Profile for Windows VMs in the managed cluster.

    All required parameters must be populated in order to send to server.

    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **Restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length:** 1 character
     :code:`<br>`:code:`<br>` **Max-length:** 20 characters. Required.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length:** 8 characters :code:`<br>`:code:`<br>`
     **Max-length:** 123 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
     conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
     characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\W_])
     :code:`<br>`:code:`<br>` **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
     "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
    :vartype admin_password: str
    :ivar license_type: The license type to use for Windows VMs. See `Azure Hybrid User Benefits
     <https://azure.microsoft.com/pricing/hybrid-benefit/faq/>`_ for more details. Known values are:
     "None" and "Windows_Server".
    :vartype license_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.LicenseType
    :ivar enable_csi_proxy: For more details on CSI proxy, see the `CSI proxy GitHub repo
     <https://github.com/kubernetes-csi/csi-proxy>`_.
    :vartype enable_csi_proxy: bool
    :ivar gmsa_profile: The Windows gMSA Profile in the Managed Cluster.
    :vartype gmsa_profile: ~azure.mgmt.containerservice.v2024_01_01.models.WindowsGmsaProfile
    """

    _validation = {
        "admin_username": {"required": True},
    }

    _attribute_map = {
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
        "enable_csi_proxy": {"key": "enableCSIProxy", "type": "bool"},
        "gmsa_profile": {"key": "gmsaProfile", "type": "WindowsGmsaProfile"},
    }

    def __init__(
        self,
        *,
        admin_username: str,
        admin_password: Optional[str] = None,
        license_type: Optional[Union[str, "_models.LicenseType"]] = None,
        enable_csi_proxy: Optional[bool] = None,
        gmsa_profile: Optional["_models.WindowsGmsaProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` **Restriction:** Cannot end in "." :code:`<br>`:code:`<br>`
         **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1",
         "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console",
         "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0",
         "sys", "test2", "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length:** 1
         character :code:`<br>`:code:`<br>` **Max-length:** 20 characters. Required.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length:** 8 characters :code:`<br>`:code:`<br>`
         **Max-length:** 123 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
         conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
         characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\W_])
         :code:`<br>`:code:`<br>` **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
         "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
        :paramtype admin_password: str
        :keyword license_type: The license type to use for Windows VMs. See `Azure Hybrid User Benefits
         <https://azure.microsoft.com/pricing/hybrid-benefit/faq/>`_ for more details. Known values are:
         "None" and "Windows_Server".
        :paramtype license_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.LicenseType
        :keyword enable_csi_proxy: For more details on CSI proxy, see the `CSI proxy GitHub repo
         <https://github.com/kubernetes-csi/csi-proxy>`_.
        :paramtype enable_csi_proxy: bool
        :keyword gmsa_profile: The Windows gMSA Profile in the Managed Cluster.
        :paramtype gmsa_profile: ~azure.mgmt.containerservice.v2024_01_01.models.WindowsGmsaProfile
        """
        super().__init__(**kwargs)
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.license_type = license_type
        self.enable_csi_proxy = enable_csi_proxy
        self.gmsa_profile = gmsa_profile


class ManagedClusterWorkloadAutoScalerProfile(_serialization.Model):
    """Workload Auto-scaler profile for the managed cluster.

    :ivar keda: KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler
     profile.
    :vartype keda:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterWorkloadAutoScalerProfileKeda
    :ivar vertical_pod_autoscaler: VPA (Vertical Pod Autoscaler) settings for the workload
     auto-scaler profile.
    :vartype vertical_pod_autoscaler:
     ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler
    """

    _attribute_map = {
        "keda": {"key": "keda", "type": "ManagedClusterWorkloadAutoScalerProfileKeda"},
        "vertical_pod_autoscaler": {
            "key": "verticalPodAutoscaler",
            "type": "ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler",
        },
    }

    def __init__(
        self,
        *,
        keda: Optional["_models.ManagedClusterWorkloadAutoScalerProfileKeda"] = None,
        vertical_pod_autoscaler: Optional[
            "_models.ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword keda: KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler
         profile.
        :paramtype keda:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterWorkloadAutoScalerProfileKeda
        :keyword vertical_pod_autoscaler: VPA (Vertical Pod Autoscaler) settings for the workload
         auto-scaler profile.
        :paramtype vertical_pod_autoscaler:
         ~azure.mgmt.containerservice.v2024_01_01.models.ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler
        """
        super().__init__(**kwargs)
        self.keda = keda
        self.vertical_pod_autoscaler = vertical_pod_autoscaler


class ManagedClusterWorkloadAutoScalerProfileKeda(_serialization.Model):  # pylint: disable=name-too-long
    """KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether to enable KEDA. Required.
    :vartype enabled: bool
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: bool, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable KEDA. Required.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler(
    _serialization.Model
):  # pylint: disable=name-too-long
    """VPA (Vertical Pod Autoscaler) settings for the workload auto-scaler profile.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether to enable VPA. Default value is false. Required.
    :vartype enabled: bool
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: bool = False, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether to enable VPA. Default value is false. Required.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ManagedServiceIdentityUserAssignedIdentitiesValue(_serialization.Model):  # pylint: disable=name-too-long
    """ManagedServiceIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class MeshRevision(_serialization.Model):
    """Holds information on upgrades and compatibility for given major.minor mesh release.

    :ivar revision: The revision of the mesh release.
    :vartype revision: str
    :ivar upgrades: List of revisions available for upgrade of a specific mesh revision.
    :vartype upgrades: list[str]
    :ivar compatible_with: List of items this revision of service mesh is compatible with, and
     their associated versions.
    :vartype compatible_with:
     list[~azure.mgmt.containerservice.v2024_01_01.models.CompatibleVersions]
    """

    _attribute_map = {
        "revision": {"key": "revision", "type": "str"},
        "upgrades": {"key": "upgrades", "type": "[str]"},
        "compatible_with": {"key": "compatibleWith", "type": "[CompatibleVersions]"},
    }

    def __init__(
        self,
        *,
        revision: Optional[str] = None,
        upgrades: Optional[List[str]] = None,
        compatible_with: Optional[List["_models.CompatibleVersions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword revision: The revision of the mesh release.
        :paramtype revision: str
        :keyword upgrades: List of revisions available for upgrade of a specific mesh revision.
        :paramtype upgrades: list[str]
        :keyword compatible_with: List of items this revision of service mesh is compatible with, and
         their associated versions.
        :paramtype compatible_with:
         list[~azure.mgmt.containerservice.v2024_01_01.models.CompatibleVersions]
        """
        super().__init__(**kwargs)
        self.revision = revision
        self.upgrades = upgrades
        self.compatible_with = compatible_with


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservice.v2024_01_01.models.SystemData
    """


class MeshRevisionProfile(ProxyResource):
    """Mesh revision profile for a mesh.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservice.v2024_01_01.models.SystemData
    :ivar properties: Mesh revision profile properties for a mesh.
    :vartype properties:
     ~azure.mgmt.containerservice.v2024_01_01.models.MeshRevisionProfileProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "MeshRevisionProfileProperties"},
    }

    def __init__(self, *, properties: Optional["_models.MeshRevisionProfileProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Mesh revision profile properties for a mesh.
        :paramtype properties:
         ~azure.mgmt.containerservice.v2024_01_01.models.MeshRevisionProfileProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class MeshRevisionProfileList(_serialization.Model):
    """Holds an array of MeshRevisionsProfiles.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of service mesh add-on revision profiles for all supported mesh modes.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.MeshRevisionProfile]
    :ivar next_link: The URL to get the next set of mesh revision profile.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MeshRevisionProfile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.MeshRevisionProfile"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of service mesh add-on revision profiles for all supported mesh modes.
        :paramtype value: list[~azure.mgmt.containerservice.v2024_01_01.models.MeshRevisionProfile]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class MeshRevisionProfileProperties(_serialization.Model):
    """Mesh revision profile properties for a mesh.

    :ivar mesh_revisions:
    :vartype mesh_revisions: list[~azure.mgmt.containerservice.v2024_01_01.models.MeshRevision]
    """

    _attribute_map = {
        "mesh_revisions": {"key": "meshRevisions", "type": "[MeshRevision]"},
    }

    def __init__(self, *, mesh_revisions: Optional[List["_models.MeshRevision"]] = None, **kwargs: Any) -> None:
        """
        :keyword mesh_revisions:
        :paramtype mesh_revisions: list[~azure.mgmt.containerservice.v2024_01_01.models.MeshRevision]
        """
        super().__init__(**kwargs)
        self.mesh_revisions = mesh_revisions


class MeshUpgradeProfile(ProxyResource):
    """Upgrade profile for given mesh.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservice.v2024_01_01.models.SystemData
    :ivar properties: Mesh upgrade profile properties for a major.minor release.
    :vartype properties:
     ~azure.mgmt.containerservice.v2024_01_01.models.MeshUpgradeProfileProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "MeshUpgradeProfileProperties"},
    }

    def __init__(self, *, properties: Optional["_models.MeshUpgradeProfileProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Mesh upgrade profile properties for a major.minor release.
        :paramtype properties:
         ~azure.mgmt.containerservice.v2024_01_01.models.MeshUpgradeProfileProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class MeshUpgradeProfileList(_serialization.Model):
    """Holds an array of MeshUpgradeProfiles.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of supported service mesh add-on upgrade profiles.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.MeshUpgradeProfile]
    :ivar next_link: The URL to get the next set of mesh upgrade profile.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MeshUpgradeProfile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.MeshUpgradeProfile"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of supported service mesh add-on upgrade profiles.
        :paramtype value: list[~azure.mgmt.containerservice.v2024_01_01.models.MeshUpgradeProfile]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class MeshUpgradeProfileProperties(MeshRevision):
    """Mesh upgrade profile properties for a major.minor release.

    :ivar revision: The revision of the mesh release.
    :vartype revision: str
    :ivar upgrades: List of revisions available for upgrade of a specific mesh revision.
    :vartype upgrades: list[str]
    :ivar compatible_with: List of items this revision of service mesh is compatible with, and
     their associated versions.
    :vartype compatible_with:
     list[~azure.mgmt.containerservice.v2024_01_01.models.CompatibleVersions]
    """


class OperationListResult(_serialization.Model):
    """The List Operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of operations.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.OperationValue]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationValue]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class OperationValue(_serialization.Model):
    """Describes the properties of a Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the operation.
    :vartype origin: str
    :ivar name: The name of the operation.
    :vartype name: str
    :ivar operation: The display name of the operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        "origin": {"readonly": True},
        "name": {"readonly": True},
        "operation": {"readonly": True},
        "resource": {"readonly": True},
        "description": {"readonly": True},
        "provider": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "operation": {"key": "display.operation", "type": "str"},
        "resource": {"key": "display.resource", "type": "str"},
        "description": {"key": "display.description", "type": "str"},
        "provider": {"key": "display.provider", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class OSOptionProfile(_serialization.Model):
    """The OS option profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the OS option resource.
    :vartype id: str
    :ivar name: The name of the OS option resource.
    :vartype name: str
    :ivar type: The type of the OS option resource.
    :vartype type: str
    :ivar os_option_property_list: The list of OS options. Required.
    :vartype os_option_property_list:
     list[~azure.mgmt.containerservice.v2024_01_01.models.OSOptionProperty]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "os_option_property_list": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "os_option_property_list": {"key": "properties.osOptionPropertyList", "type": "[OSOptionProperty]"},
    }

    def __init__(self, *, os_option_property_list: List["_models.OSOptionProperty"], **kwargs: Any) -> None:
        """
        :keyword os_option_property_list: The list of OS options. Required.
        :paramtype os_option_property_list:
         list[~azure.mgmt.containerservice.v2024_01_01.models.OSOptionProperty]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.os_option_property_list = os_option_property_list


class OSOptionProperty(_serialization.Model):
    """OS option property.

    All required parameters must be populated in order to send to server.

    :ivar os_type: The OS type. Required.
    :vartype os_type: str
    :ivar enable_fips_image: Whether the image is FIPS-enabled. Required.
    :vartype enable_fips_image: bool
    """

    _validation = {
        "os_type": {"required": True},
        "enable_fips_image": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "os-type", "type": "str"},
        "enable_fips_image": {"key": "enable-fips-image", "type": "bool"},
    }

    def __init__(self, *, os_type: str, enable_fips_image: bool, **kwargs: Any) -> None:
        """
        :keyword os_type: The OS type. Required.
        :paramtype os_type: str
        :keyword enable_fips_image: Whether the image is FIPS-enabled. Required.
        :paramtype enable_fips_image: bool
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.enable_fips_image = enable_fips_image


class OutboundEnvironmentEndpoint(_serialization.Model):
    """Egress endpoints which AKS agent nodes connect to for common purpose.

    :ivar category: The category of endpoints accessed by the AKS agent node, e.g.
     azure-resource-management, apiserver, etc.
    :vartype category: str
    :ivar endpoints: The endpoints that AKS agent nodes connect to.
    :vartype endpoints: list[~azure.mgmt.containerservice.v2024_01_01.models.EndpointDependency]
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[EndpointDependency]"},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        endpoints: Optional[List["_models.EndpointDependency"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: The category of endpoints accessed by the AKS agent node, e.g.
         azure-resource-management, apiserver, etc.
        :paramtype category: str
        :keyword endpoints: The endpoints that AKS agent nodes connect to.
        :paramtype endpoints: list[~azure.mgmt.containerservice.v2024_01_01.models.EndpointDependency]
        """
        super().__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints


class OutboundEnvironmentEndpointCollection(_serialization.Model):
    """Collection of OutboundEnvironmentEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value:
     list[~azure.mgmt.containerservice.v2024_01_01.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundEnvironmentEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.OutboundEnvironmentEndpoint"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value:
         list[~azure.mgmt.containerservice.v2024_01_01.models.OutboundEnvironmentEndpoint]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PortRange(_serialization.Model):
    """The port range.

    :ivar port_start: The minimum port that is included in the range. It should be ranged from 1 to
     65535, and be less than or equal to portEnd.
    :vartype port_start: int
    :ivar port_end: The maximum port that is included in the range. It should be ranged from 1 to
     65535, and be greater than or equal to portStart.
    :vartype port_end: int
    :ivar protocol: The network protocol of the port. Known values are: "TCP" and "UDP".
    :vartype protocol: str or ~azure.mgmt.containerservice.v2024_01_01.models.Protocol
    """

    _validation = {
        "port_start": {"maximum": 65535, "minimum": 1},
        "port_end": {"maximum": 65535, "minimum": 1},
    }

    _attribute_map = {
        "port_start": {"key": "portStart", "type": "int"},
        "port_end": {"key": "portEnd", "type": "int"},
        "protocol": {"key": "protocol", "type": "str"},
    }

    def __init__(
        self,
        *,
        port_start: Optional[int] = None,
        port_end: Optional[int] = None,
        protocol: Optional[Union[str, "_models.Protocol"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword port_start: The minimum port that is included in the range. It should be ranged from 1
         to 65535, and be less than or equal to portEnd.
        :paramtype port_start: int
        :keyword port_end: The maximum port that is included in the range. It should be ranged from 1
         to 65535, and be greater than or equal to portStart.
        :paramtype port_end: int
        :keyword protocol: The network protocol of the port. Known values are: "TCP" and "UDP".
        :paramtype protocol: str or ~azure.mgmt.containerservice.v2024_01_01.models.Protocol
        """
        super().__init__(**kwargs)
        self.port_start = port_start
        self.port_end = port_end
        self.protocol = protocol


class PowerState(_serialization.Model):
    """Describes the Power State of the cluster.

    :ivar code: Tells whether the cluster is Running or Stopped. Known values are: "Running" and
     "Stopped".
    :vartype code: str or ~azure.mgmt.containerservice.v2024_01_01.models.Code
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
    }

    def __init__(self, *, code: Optional[Union[str, "_models.Code"]] = None, **kwargs: Any) -> None:
        """
        :keyword code: Tells whether the cluster is Running or Stopped. Known values are: "Running" and
         "Stopped".
        :paramtype code: str or ~azure.mgmt.containerservice.v2024_01_01.models.Code
        """
        super().__init__(**kwargs)
        self.code = code


class PrivateEndpoint(_serialization.Model):
    """Private endpoint which a connection belongs to.

    :ivar id: The resource ID of the private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The resource ID of the private endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(_serialization.Model):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the private endpoint connection.
    :vartype id: str
    :ivar name: The name of the private endpoint connection.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar provisioning_state: The current provisioning state. Known values are: "Canceled",
     "Creating", "Deleting", "Failed", and "Succeeded".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.PrivateEndpointConnectionProvisioningState
    :ivar private_endpoint: The resource of private endpoint.
    :vartype private_endpoint: ~azure.mgmt.containerservice.v2024_01_01.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.containerservice.v2024_01_01.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private endpoint.
        :paramtype private_endpoint: ~azure.mgmt.containerservice.v2024_01_01.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.containerservice.v2024_01_01.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateEndpointConnectionListResult(_serialization.Model):
    """A list of private endpoint connections.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The collection value.
        :paramtype value:
         list[~azure.mgmt.containerservice.v2024_01_01.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResource(_serialization.Model):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the private link resource.
    :vartype id: str
    :ivar name: The name of the private link resource.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar group_id: The group ID of the resource.
    :vartype group_id: str
    :ivar required_members: The RequiredMembers of the resource.
    :vartype required_members: list[str]
    :ivar private_link_service_id: The private link service ID of the resource, this field is
     exposed only to NRP internally.
    :vartype private_link_service_id: str
    """

    _validation = {
        "private_link_service_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "private_link_service_id": {"key": "privateLinkServiceID", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the private link resource.
        :paramtype id: str
        :keyword name: The name of the private link resource.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        :keyword group_id: The group ID of the resource.
        :paramtype group_id: str
        :keyword required_members: The RequiredMembers of the resource.
        :paramtype required_members: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.group_id = group_id
        self.required_members = required_members
        self.private_link_service_id = None


class PrivateLinkResourcesListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerservice.v2024_01_01.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """The state of a private link service connection.

    :ivar status: The private link service connection status. Known values are: "Pending",
     "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.containerservice.v2024_01_01.models.ConnectionStatus
    :ivar description: The private link service connection description.
    :vartype description: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.ConnectionStatus"]] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The private link service connection status. Known values are: "Pending",
         "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or ~azure.mgmt.containerservice.v2024_01_01.models.ConnectionStatus
        :keyword description: The private link service connection description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description


class RelativeMonthlySchedule(_serialization.Model):
    """For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last
    Friday'.

    All required parameters must be populated in order to send to server.

    :ivar interval_months: Specifies the number of months between each set of occurrences.
     Required.
    :vartype interval_months: int
    :ivar week_index: Specifies on which week of the month the dayOfWeek applies. Required. Known
     values are: "First", "Second", "Third", "Fourth", and "Last".
    :vartype week_index: str or ~azure.mgmt.containerservice.v2024_01_01.models.Type
    :ivar day_of_week: Specifies on which day of the week the maintenance occurs. Required. Known
     values are: "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", and "Saturday".
    :vartype day_of_week: str or ~azure.mgmt.containerservice.v2024_01_01.models.WeekDay
    """

    _validation = {
        "interval_months": {"required": True, "maximum": 6, "minimum": 1},
        "week_index": {"required": True},
        "day_of_week": {"required": True},
    }

    _attribute_map = {
        "interval_months": {"key": "intervalMonths", "type": "int"},
        "week_index": {"key": "weekIndex", "type": "str"},
        "day_of_week": {"key": "dayOfWeek", "type": "str"},
    }

    def __init__(
        self,
        *,
        interval_months: int,
        week_index: Union[str, "_models.Type"],
        day_of_week: Union[str, "_models.WeekDay"],
        **kwargs: Any
    ) -> None:
        """
        :keyword interval_months: Specifies the number of months between each set of occurrences.
         Required.
        :paramtype interval_months: int
        :keyword week_index: Specifies on which week of the month the dayOfWeek applies. Required.
         Known values are: "First", "Second", "Third", "Fourth", and "Last".
        :paramtype week_index: str or ~azure.mgmt.containerservice.v2024_01_01.models.Type
        :keyword day_of_week: Specifies on which day of the week the maintenance occurs. Required.
         Known values are: "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", and
         "Saturday".
        :paramtype day_of_week: str or ~azure.mgmt.containerservice.v2024_01_01.models.WeekDay
        """
        super().__init__(**kwargs)
        self.interval_months = interval_months
        self.week_index = week_index
        self.day_of_week = day_of_week


class ResourceReference(_serialization.Model):
    """A reference to an Azure resource.

    :ivar id: The fully qualified Azure resource id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The fully qualified Azure resource id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class RunCommandRequest(_serialization.Model):
    """A run command request.

    All required parameters must be populated in order to send to server.

    :ivar command: The command to run. Required.
    :vartype command: str
    :ivar context: A base64 encoded zip file containing the files required by the command.
    :vartype context: str
    :ivar cluster_token: AuthToken issued for AKS AAD Server App.
    :vartype cluster_token: str
    """

    _validation = {
        "command": {"required": True},
    }

    _attribute_map = {
        "command": {"key": "command", "type": "str"},
        "context": {"key": "context", "type": "str"},
        "cluster_token": {"key": "clusterToken", "type": "str"},
    }

    def __init__(
        self, *, command: str, context: Optional[str] = None, cluster_token: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword command: The command to run. Required.
        :paramtype command: str
        :keyword context: A base64 encoded zip file containing the files required by the command.
        :paramtype context: str
        :keyword cluster_token: AuthToken issued for AKS AAD Server App.
        :paramtype cluster_token: str
        """
        super().__init__(**kwargs)
        self.command = command
        self.context = context
        self.cluster_token = cluster_token


class RunCommandResult(_serialization.Model):
    """run command result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The command id.
    :vartype id: str
    :ivar provisioning_state: provisioning State.
    :vartype provisioning_state: str
    :ivar exit_code: The exit code of the command.
    :vartype exit_code: int
    :ivar started_at: The time when the command started.
    :vartype started_at: ~datetime.datetime
    :ivar finished_at: The time when the command finished.
    :vartype finished_at: ~datetime.datetime
    :ivar logs: The command output.
    :vartype logs: str
    :ivar reason: An explanation of why provisioningState is set to failed (if so).
    :vartype reason: str
    """

    _validation = {
        "id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "exit_code": {"readonly": True},
        "started_at": {"readonly": True},
        "finished_at": {"readonly": True},
        "logs": {"readonly": True},
        "reason": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "exit_code": {"key": "properties.exitCode", "type": "int"},
        "started_at": {"key": "properties.startedAt", "type": "iso-8601"},
        "finished_at": {"key": "properties.finishedAt", "type": "iso-8601"},
        "logs": {"key": "properties.logs", "type": "str"},
        "reason": {"key": "properties.reason", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.provisioning_state = None
        self.exit_code = None
        self.started_at = None
        self.finished_at = None
        self.logs = None
        self.reason = None


class Schedule(_serialization.Model):
    """One and only one of the schedule types should be specified. Choose either 'daily', 'weekly',
    'absoluteMonthly' or 'relativeMonthly' for your maintenance schedule.

    :ivar daily: For schedules like: 'recur every day' or 'recur every 3 days'.
    :vartype daily: ~azure.mgmt.containerservice.v2024_01_01.models.DailySchedule
    :ivar weekly: For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'.
    :vartype weekly: ~azure.mgmt.containerservice.v2024_01_01.models.WeeklySchedule
    :ivar absolute_monthly: For schedules like: 'recur every month on the 15th' or 'recur every 3
     months on the 20th'.
    :vartype absolute_monthly:
     ~azure.mgmt.containerservice.v2024_01_01.models.AbsoluteMonthlySchedule
    :ivar relative_monthly: For schedules like: 'recur every month on the first Monday' or 'recur
     every 3 months on last Friday'.
    :vartype relative_monthly:
     ~azure.mgmt.containerservice.v2024_01_01.models.RelativeMonthlySchedule
    """

    _attribute_map = {
        "daily": {"key": "daily", "type": "DailySchedule"},
        "weekly": {"key": "weekly", "type": "WeeklySchedule"},
        "absolute_monthly": {"key": "absoluteMonthly", "type": "AbsoluteMonthlySchedule"},
        "relative_monthly": {"key": "relativeMonthly", "type": "RelativeMonthlySchedule"},
    }

    def __init__(
        self,
        *,
        daily: Optional["_models.DailySchedule"] = None,
        weekly: Optional["_models.WeeklySchedule"] = None,
        absolute_monthly: Optional["_models.AbsoluteMonthlySchedule"] = None,
        relative_monthly: Optional["_models.RelativeMonthlySchedule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword daily: For schedules like: 'recur every day' or 'recur every 3 days'.
        :paramtype daily: ~azure.mgmt.containerservice.v2024_01_01.models.DailySchedule
        :keyword weekly: For schedules like: 'recur every Monday' or 'recur every 3 weeks on
         Wednesday'.
        :paramtype weekly: ~azure.mgmt.containerservice.v2024_01_01.models.WeeklySchedule
        :keyword absolute_monthly: For schedules like: 'recur every month on the 15th' or 'recur every
         3 months on the 20th'.
        :paramtype absolute_monthly:
         ~azure.mgmt.containerservice.v2024_01_01.models.AbsoluteMonthlySchedule
        :keyword relative_monthly: For schedules like: 'recur every month on the first Monday' or
         'recur every 3 months on last Friday'.
        :paramtype relative_monthly:
         ~azure.mgmt.containerservice.v2024_01_01.models.RelativeMonthlySchedule
        """
        super().__init__(**kwargs)
        self.daily = daily
        self.weekly = weekly
        self.absolute_monthly = absolute_monthly
        self.relative_monthly = relative_monthly


class ServiceMeshProfile(_serialization.Model):
    """Service mesh profile for a managed cluster.

    All required parameters must be populated in order to send to server.

    :ivar mode: Mode of the service mesh. Required. Known values are: "Istio" and "Disabled".
    :vartype mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.ServiceMeshMode
    :ivar istio: Istio service mesh configuration.
    :vartype istio: ~azure.mgmt.containerservice.v2024_01_01.models.IstioServiceMesh
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "istio": {"key": "istio", "type": "IstioServiceMesh"},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "_models.ServiceMeshMode"],
        istio: Optional["_models.IstioServiceMesh"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Mode of the service mesh. Required. Known values are: "Istio" and "Disabled".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2024_01_01.models.ServiceMeshMode
        :keyword istio: Istio service mesh configuration.
        :paramtype istio: ~azure.mgmt.containerservice.v2024_01_01.models.IstioServiceMesh
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.istio = istio


class Snapshot(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A node pool snapshot resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservice.v2024_01_01.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar creation_data: CreationData to be used to specify the source agent pool resource ID to
     create this snapshot.
    :vartype creation_data: ~azure.mgmt.containerservice.v2024_01_01.models.CreationData
    :ivar snapshot_type: The type of a snapshot. The default is NodePool. "NodePool"
    :vartype snapshot_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.SnapshotType
    :ivar kubernetes_version: The version of Kubernetes.
    :vartype kubernetes_version: str
    :ivar node_image_version: The version of node image.
    :vartype node_image_version: str
    :ivar os_type: The operating system type. The default is Linux. Known values are: "Linux" and
     "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSType
    :ivar os_sku: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is
     Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >=
     1.25 if OSType is Windows. Known values are: "Ubuntu", "AzureLinux", "CBLMariner",
     "Windows2019", and "Windows2022".
    :vartype os_sku: str or ~azure.mgmt.containerservice.v2024_01_01.models.OSSKU
    :ivar vm_size: The size of the VM.
    :vartype vm_size: str
    :ivar enable_fips: Whether to use a FIPS-enabled OS.
    :vartype enable_fips: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "kubernetes_version": {"readonly": True},
        "node_image_version": {"readonly": True},
        "os_type": {"readonly": True},
        "os_sku": {"readonly": True},
        "vm_size": {"readonly": True},
        "enable_fips": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "creation_data": {"key": "properties.creationData", "type": "CreationData"},
        "snapshot_type": {"key": "properties.snapshotType", "type": "str"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "node_image_version": {"key": "properties.nodeImageVersion", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_sku": {"key": "properties.osSku", "type": "str"},
        "vm_size": {"key": "properties.vmSize", "type": "str"},
        "enable_fips": {"key": "properties.enableFIPS", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        creation_data: Optional["_models.CreationData"] = None,
        snapshot_type: Union[str, "_models.SnapshotType"] = "NodePool",
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword creation_data: CreationData to be used to specify the source agent pool resource ID to
         create this snapshot.
        :paramtype creation_data: ~azure.mgmt.containerservice.v2024_01_01.models.CreationData
        :keyword snapshot_type: The type of a snapshot. The default is NodePool. "NodePool"
        :paramtype snapshot_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.SnapshotType
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.creation_data = creation_data
        self.snapshot_type = snapshot_type
        self.kubernetes_version = None
        self.node_image_version = None
        self.os_type = None
        self.os_sku = None
        self.vm_size = None
        self.enable_fips = None


class SnapshotListResult(_serialization.Model):
    """The response from the List Snapshots operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of snapshots.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.Snapshot]
    :ivar next_link: The URL to get the next set of snapshot results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Snapshot]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Snapshot"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of snapshots.
        :paramtype value: list[~azure.mgmt.containerservice.v2024_01_01.models.Snapshot]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SysctlConfig(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Sysctl settings for Linux agent nodes.

    :ivar net_core_somaxconn: Sysctl setting net.core.somaxconn.
    :vartype net_core_somaxconn: int
    :ivar net_core_netdev_max_backlog: Sysctl setting net.core.netdev_max_backlog.
    :vartype net_core_netdev_max_backlog: int
    :ivar net_core_rmem_default: Sysctl setting net.core.rmem_default.
    :vartype net_core_rmem_default: int
    :ivar net_core_rmem_max: Sysctl setting net.core.rmem_max.
    :vartype net_core_rmem_max: int
    :ivar net_core_wmem_default: Sysctl setting net.core.wmem_default.
    :vartype net_core_wmem_default: int
    :ivar net_core_wmem_max: Sysctl setting net.core.wmem_max.
    :vartype net_core_wmem_max: int
    :ivar net_core_optmem_max: Sysctl setting net.core.optmem_max.
    :vartype net_core_optmem_max: int
    :ivar net_ipv4_tcp_max_syn_backlog: Sysctl setting net.ipv4.tcp_max_syn_backlog.
    :vartype net_ipv4_tcp_max_syn_backlog: int
    :ivar net_ipv4_tcp_max_tw_buckets: Sysctl setting net.ipv4.tcp_max_tw_buckets.
    :vartype net_ipv4_tcp_max_tw_buckets: int
    :ivar net_ipv4_tcp_fin_timeout: Sysctl setting net.ipv4.tcp_fin_timeout.
    :vartype net_ipv4_tcp_fin_timeout: int
    :ivar net_ipv4_tcp_keepalive_time: Sysctl setting net.ipv4.tcp_keepalive_time.
    :vartype net_ipv4_tcp_keepalive_time: int
    :ivar net_ipv4_tcp_keepalive_probes: Sysctl setting net.ipv4.tcp_keepalive_probes.
    :vartype net_ipv4_tcp_keepalive_probes: int
    :ivar net_ipv4_tcpkeepalive_intvl: Sysctl setting net.ipv4.tcp_keepalive_intvl.
    :vartype net_ipv4_tcpkeepalive_intvl: int
    :ivar net_ipv4_tcp_tw_reuse: Sysctl setting net.ipv4.tcp_tw_reuse.
    :vartype net_ipv4_tcp_tw_reuse: bool
    :ivar net_ipv4_ip_local_port_range: Sysctl setting net.ipv4.ip_local_port_range.
    :vartype net_ipv4_ip_local_port_range: str
    :ivar net_ipv4_neigh_default_gc_thresh1: Sysctl setting net.ipv4.neigh.default.gc_thresh1.
    :vartype net_ipv4_neigh_default_gc_thresh1: int
    :ivar net_ipv4_neigh_default_gc_thresh2: Sysctl setting net.ipv4.neigh.default.gc_thresh2.
    :vartype net_ipv4_neigh_default_gc_thresh2: int
    :ivar net_ipv4_neigh_default_gc_thresh3: Sysctl setting net.ipv4.neigh.default.gc_thresh3.
    :vartype net_ipv4_neigh_default_gc_thresh3: int
    :ivar net_netfilter_nf_conntrack_max: Sysctl setting net.netfilter.nf_conntrack_max.
    :vartype net_netfilter_nf_conntrack_max: int
    :ivar net_netfilter_nf_conntrack_buckets: Sysctl setting net.netfilter.nf_conntrack_buckets.
    :vartype net_netfilter_nf_conntrack_buckets: int
    :ivar fs_inotify_max_user_watches: Sysctl setting fs.inotify.max_user_watches.
    :vartype fs_inotify_max_user_watches: int
    :ivar fs_file_max: Sysctl setting fs.file-max.
    :vartype fs_file_max: int
    :ivar fs_aio_max_nr: Sysctl setting fs.aio-max-nr.
    :vartype fs_aio_max_nr: int
    :ivar fs_nr_open: Sysctl setting fs.nr_open.
    :vartype fs_nr_open: int
    :ivar kernel_threads_max: Sysctl setting kernel.threads-max.
    :vartype kernel_threads_max: int
    :ivar vm_max_map_count: Sysctl setting vm.max_map_count.
    :vartype vm_max_map_count: int
    :ivar vm_swappiness: Sysctl setting vm.swappiness.
    :vartype vm_swappiness: int
    :ivar vm_vfs_cache_pressure: Sysctl setting vm.vfs_cache_pressure.
    :vartype vm_vfs_cache_pressure: int
    """

    _validation = {
        "net_ipv4_tcpkeepalive_intvl": {"maximum": 90, "minimum": 10},
        "net_netfilter_nf_conntrack_max": {"maximum": 2097152, "minimum": 131072},
        "net_netfilter_nf_conntrack_buckets": {"maximum": 524288, "minimum": 65536},
    }

    _attribute_map = {
        "net_core_somaxconn": {"key": "netCoreSomaxconn", "type": "int"},
        "net_core_netdev_max_backlog": {"key": "netCoreNetdevMaxBacklog", "type": "int"},
        "net_core_rmem_default": {"key": "netCoreRmemDefault", "type": "int"},
        "net_core_rmem_max": {"key": "netCoreRmemMax", "type": "int"},
        "net_core_wmem_default": {"key": "netCoreWmemDefault", "type": "int"},
        "net_core_wmem_max": {"key": "netCoreWmemMax", "type": "int"},
        "net_core_optmem_max": {"key": "netCoreOptmemMax", "type": "int"},
        "net_ipv4_tcp_max_syn_backlog": {"key": "netIpv4TcpMaxSynBacklog", "type": "int"},
        "net_ipv4_tcp_max_tw_buckets": {"key": "netIpv4TcpMaxTwBuckets", "type": "int"},
        "net_ipv4_tcp_fin_timeout": {"key": "netIpv4TcpFinTimeout", "type": "int"},
        "net_ipv4_tcp_keepalive_time": {"key": "netIpv4TcpKeepaliveTime", "type": "int"},
        "net_ipv4_tcp_keepalive_probes": {"key": "netIpv4TcpKeepaliveProbes", "type": "int"},
        "net_ipv4_tcpkeepalive_intvl": {"key": "netIpv4TcpkeepaliveIntvl", "type": "int"},
        "net_ipv4_tcp_tw_reuse": {"key": "netIpv4TcpTwReuse", "type": "bool"},
        "net_ipv4_ip_local_port_range": {"key": "netIpv4IpLocalPortRange", "type": "str"},
        "net_ipv4_neigh_default_gc_thresh1": {"key": "netIpv4NeighDefaultGcThresh1", "type": "int"},
        "net_ipv4_neigh_default_gc_thresh2": {"key": "netIpv4NeighDefaultGcThresh2", "type": "int"},
        "net_ipv4_neigh_default_gc_thresh3": {"key": "netIpv4NeighDefaultGcThresh3", "type": "int"},
        "net_netfilter_nf_conntrack_max": {"key": "netNetfilterNfConntrackMax", "type": "int"},
        "net_netfilter_nf_conntrack_buckets": {"key": "netNetfilterNfConntrackBuckets", "type": "int"},
        "fs_inotify_max_user_watches": {"key": "fsInotifyMaxUserWatches", "type": "int"},
        "fs_file_max": {"key": "fsFileMax", "type": "int"},
        "fs_aio_max_nr": {"key": "fsAioMaxNr", "type": "int"},
        "fs_nr_open": {"key": "fsNrOpen", "type": "int"},
        "kernel_threads_max": {"key": "kernelThreadsMax", "type": "int"},
        "vm_max_map_count": {"key": "vmMaxMapCount", "type": "int"},
        "vm_swappiness": {"key": "vmSwappiness", "type": "int"},
        "vm_vfs_cache_pressure": {"key": "vmVfsCachePressure", "type": "int"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        net_core_somaxconn: Optional[int] = None,
        net_core_netdev_max_backlog: Optional[int] = None,
        net_core_rmem_default: Optional[int] = None,
        net_core_rmem_max: Optional[int] = None,
        net_core_wmem_default: Optional[int] = None,
        net_core_wmem_max: Optional[int] = None,
        net_core_optmem_max: Optional[int] = None,
        net_ipv4_tcp_max_syn_backlog: Optional[int] = None,
        net_ipv4_tcp_max_tw_buckets: Optional[int] = None,
        net_ipv4_tcp_fin_timeout: Optional[int] = None,
        net_ipv4_tcp_keepalive_time: Optional[int] = None,
        net_ipv4_tcp_keepalive_probes: Optional[int] = None,
        net_ipv4_tcpkeepalive_intvl: Optional[int] = None,
        net_ipv4_tcp_tw_reuse: Optional[bool] = None,
        net_ipv4_ip_local_port_range: Optional[str] = None,
        net_ipv4_neigh_default_gc_thresh1: Optional[int] = None,
        net_ipv4_neigh_default_gc_thresh2: Optional[int] = None,
        net_ipv4_neigh_default_gc_thresh3: Optional[int] = None,
        net_netfilter_nf_conntrack_max: Optional[int] = None,
        net_netfilter_nf_conntrack_buckets: Optional[int] = None,
        fs_inotify_max_user_watches: Optional[int] = None,
        fs_file_max: Optional[int] = None,
        fs_aio_max_nr: Optional[int] = None,
        fs_nr_open: Optional[int] = None,
        kernel_threads_max: Optional[int] = None,
        vm_max_map_count: Optional[int] = None,
        vm_swappiness: Optional[int] = None,
        vm_vfs_cache_pressure: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword net_core_somaxconn: Sysctl setting net.core.somaxconn.
        :paramtype net_core_somaxconn: int
        :keyword net_core_netdev_max_backlog: Sysctl setting net.core.netdev_max_backlog.
        :paramtype net_core_netdev_max_backlog: int
        :keyword net_core_rmem_default: Sysctl setting net.core.rmem_default.
        :paramtype net_core_rmem_default: int
        :keyword net_core_rmem_max: Sysctl setting net.core.rmem_max.
        :paramtype net_core_rmem_max: int
        :keyword net_core_wmem_default: Sysctl setting net.core.wmem_default.
        :paramtype net_core_wmem_default: int
        :keyword net_core_wmem_max: Sysctl setting net.core.wmem_max.
        :paramtype net_core_wmem_max: int
        :keyword net_core_optmem_max: Sysctl setting net.core.optmem_max.
        :paramtype net_core_optmem_max: int
        :keyword net_ipv4_tcp_max_syn_backlog: Sysctl setting net.ipv4.tcp_max_syn_backlog.
        :paramtype net_ipv4_tcp_max_syn_backlog: int
        :keyword net_ipv4_tcp_max_tw_buckets: Sysctl setting net.ipv4.tcp_max_tw_buckets.
        :paramtype net_ipv4_tcp_max_tw_buckets: int
        :keyword net_ipv4_tcp_fin_timeout: Sysctl setting net.ipv4.tcp_fin_timeout.
        :paramtype net_ipv4_tcp_fin_timeout: int
        :keyword net_ipv4_tcp_keepalive_time: Sysctl setting net.ipv4.tcp_keepalive_time.
        :paramtype net_ipv4_tcp_keepalive_time: int
        :keyword net_ipv4_tcp_keepalive_probes: Sysctl setting net.ipv4.tcp_keepalive_probes.
        :paramtype net_ipv4_tcp_keepalive_probes: int
        :keyword net_ipv4_tcpkeepalive_intvl: Sysctl setting net.ipv4.tcp_keepalive_intvl.
        :paramtype net_ipv4_tcpkeepalive_intvl: int
        :keyword net_ipv4_tcp_tw_reuse: Sysctl setting net.ipv4.tcp_tw_reuse.
        :paramtype net_ipv4_tcp_tw_reuse: bool
        :keyword net_ipv4_ip_local_port_range: Sysctl setting net.ipv4.ip_local_port_range.
        :paramtype net_ipv4_ip_local_port_range: str
        :keyword net_ipv4_neigh_default_gc_thresh1: Sysctl setting net.ipv4.neigh.default.gc_thresh1.
        :paramtype net_ipv4_neigh_default_gc_thresh1: int
        :keyword net_ipv4_neigh_default_gc_thresh2: Sysctl setting net.ipv4.neigh.default.gc_thresh2.
        :paramtype net_ipv4_neigh_default_gc_thresh2: int
        :keyword net_ipv4_neigh_default_gc_thresh3: Sysctl setting net.ipv4.neigh.default.gc_thresh3.
        :paramtype net_ipv4_neigh_default_gc_thresh3: int
        :keyword net_netfilter_nf_conntrack_max: Sysctl setting net.netfilter.nf_conntrack_max.
        :paramtype net_netfilter_nf_conntrack_max: int
        :keyword net_netfilter_nf_conntrack_buckets: Sysctl setting net.netfilter.nf_conntrack_buckets.
        :paramtype net_netfilter_nf_conntrack_buckets: int
        :keyword fs_inotify_max_user_watches: Sysctl setting fs.inotify.max_user_watches.
        :paramtype fs_inotify_max_user_watches: int
        :keyword fs_file_max: Sysctl setting fs.file-max.
        :paramtype fs_file_max: int
        :keyword fs_aio_max_nr: Sysctl setting fs.aio-max-nr.
        :paramtype fs_aio_max_nr: int
        :keyword fs_nr_open: Sysctl setting fs.nr_open.
        :paramtype fs_nr_open: int
        :keyword kernel_threads_max: Sysctl setting kernel.threads-max.
        :paramtype kernel_threads_max: int
        :keyword vm_max_map_count: Sysctl setting vm.max_map_count.
        :paramtype vm_max_map_count: int
        :keyword vm_swappiness: Sysctl setting vm.swappiness.
        :paramtype vm_swappiness: int
        :keyword vm_vfs_cache_pressure: Sysctl setting vm.vfs_cache_pressure.
        :paramtype vm_vfs_cache_pressure: int
        """
        super().__init__(**kwargs)
        self.net_core_somaxconn = net_core_somaxconn
        self.net_core_netdev_max_backlog = net_core_netdev_max_backlog
        self.net_core_rmem_default = net_core_rmem_default
        self.net_core_rmem_max = net_core_rmem_max
        self.net_core_wmem_default = net_core_wmem_default
        self.net_core_wmem_max = net_core_wmem_max
        self.net_core_optmem_max = net_core_optmem_max
        self.net_ipv4_tcp_max_syn_backlog = net_ipv4_tcp_max_syn_backlog
        self.net_ipv4_tcp_max_tw_buckets = net_ipv4_tcp_max_tw_buckets
        self.net_ipv4_tcp_fin_timeout = net_ipv4_tcp_fin_timeout
        self.net_ipv4_tcp_keepalive_time = net_ipv4_tcp_keepalive_time
        self.net_ipv4_tcp_keepalive_probes = net_ipv4_tcp_keepalive_probes
        self.net_ipv4_tcpkeepalive_intvl = net_ipv4_tcpkeepalive_intvl
        self.net_ipv4_tcp_tw_reuse = net_ipv4_tcp_tw_reuse
        self.net_ipv4_ip_local_port_range = net_ipv4_ip_local_port_range
        self.net_ipv4_neigh_default_gc_thresh1 = net_ipv4_neigh_default_gc_thresh1
        self.net_ipv4_neigh_default_gc_thresh2 = net_ipv4_neigh_default_gc_thresh2
        self.net_ipv4_neigh_default_gc_thresh3 = net_ipv4_neigh_default_gc_thresh3
        self.net_netfilter_nf_conntrack_max = net_netfilter_nf_conntrack_max
        self.net_netfilter_nf_conntrack_buckets = net_netfilter_nf_conntrack_buckets
        self.fs_inotify_max_user_watches = fs_inotify_max_user_watches
        self.fs_file_max = fs_file_max
        self.fs_aio_max_nr = fs_aio_max_nr
        self.fs_nr_open = fs_nr_open
        self.kernel_threads_max = kernel_threads_max
        self.vm_max_map_count = vm_max_map_count
        self.vm_swappiness = vm_swappiness
        self.vm_vfs_cache_pressure = vm_vfs_cache_pressure


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.containerservice.v2024_01_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.containerservice.v2024_01_01.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class TimeInWeek(_serialization.Model):
    """Time in a week.

    :ivar day: The day of the week. Known values are: "Sunday", "Monday", "Tuesday", "Wednesday",
     "Thursday", "Friday", and "Saturday".
    :vartype day: str or ~azure.mgmt.containerservice.v2024_01_01.models.WeekDay
    :ivar hour_slots: Each integer hour represents a time range beginning at 0m after the hour
     ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00
     UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
    :vartype hour_slots: list[int]
    """

    _attribute_map = {
        "day": {"key": "day", "type": "str"},
        "hour_slots": {"key": "hourSlots", "type": "[int]"},
    }

    def __init__(
        self,
        *,
        day: Optional[Union[str, "_models.WeekDay"]] = None,
        hour_slots: Optional[List[int]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword day: The day of the week. Known values are: "Sunday", "Monday", "Tuesday",
         "Wednesday", "Thursday", "Friday", and "Saturday".
        :paramtype day: str or ~azure.mgmt.containerservice.v2024_01_01.models.WeekDay
        :keyword hour_slots: Each integer hour represents a time range beginning at 0m after the hour
         ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00
         UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
        :paramtype hour_slots: list[int]
        """
        super().__init__(**kwargs)
        self.day = day
        self.hour_slots = hour_slots


class TimeSpan(_serialization.Model):
    """For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.

    :ivar start: The start of a time span.
    :vartype start: ~datetime.datetime
    :ivar end: The end of a time span.
    :vartype end: ~datetime.datetime
    """

    _attribute_map = {
        "start": {"key": "start", "type": "iso-8601"},
        "end": {"key": "end", "type": "iso-8601"},
    }

    def __init__(
        self, *, start: Optional[datetime.datetime] = None, end: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """
        :keyword start: The start of a time span.
        :paramtype start: ~datetime.datetime
        :keyword end: The end of a time span.
        :paramtype end: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.start = start
        self.end = end


class TrustedAccessRole(_serialization.Model):
    """Trusted access role definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source_resource_type: Resource type of Azure resource.
    :vartype source_resource_type: str
    :ivar name: Name of role, name is unique under a source resource type.
    :vartype name: str
    :ivar rules: List of rules for the role. This maps to 'rules' property of `Kubernetes Cluster
     Role
     <https://kubernetes.io/docs/reference/kubernetes-api/authorization-resources/cluster-role-v1/#ClusterRole>`_.
    :vartype rules: list[~azure.mgmt.containerservice.v2024_01_01.models.TrustedAccessRoleRule]
    """

    _validation = {
        "source_resource_type": {"readonly": True},
        "name": {"readonly": True},
        "rules": {"readonly": True},
    }

    _attribute_map = {
        "source_resource_type": {"key": "sourceResourceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "rules": {"key": "rules", "type": "[TrustedAccessRoleRule]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source_resource_type = None
        self.name = None
        self.rules = None


class TrustedAccessRoleBinding(Resource):
    """Defines binding between a resource and role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservice.v2024_01_01.models.SystemData
    :ivar provisioning_state: The current provisioning state of trusted access role binding. Known
     values are: "Canceled", "Deleting", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservice.v2024_01_01.models.TrustedAccessRoleBindingProvisioningState
    :ivar source_resource_id: The ARM resource ID of source resource that trusted access is
     configured for. Required.
    :vartype source_resource_id: str
    :ivar roles: A list of roles to bind, each item is a resource type qualified role name. For
     example: 'Microsoft.MachineLearningServices/workspaces/reader'. Required.
    :vartype roles: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "source_resource_id": {"required": True},
        "roles": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "source_resource_id": {"key": "properties.sourceResourceId", "type": "str"},
        "roles": {"key": "properties.roles", "type": "[str]"},
    }

    def __init__(self, *, source_resource_id: str, roles: List[str], **kwargs: Any) -> None:
        """
        :keyword source_resource_id: The ARM resource ID of source resource that trusted access is
         configured for. Required.
        :paramtype source_resource_id: str
        :keyword roles: A list of roles to bind, each item is a resource type qualified role name. For
         example: 'Microsoft.MachineLearningServices/workspaces/reader'. Required.
        :paramtype roles: list[str]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.source_resource_id = source_resource_id
        self.roles = roles


class TrustedAccessRoleBindingListResult(_serialization.Model):
    """List of trusted access role bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Role binding list.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.TrustedAccessRoleBinding]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TrustedAccessRoleBinding]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.TrustedAccessRoleBinding"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Role binding list.
        :paramtype value:
         list[~azure.mgmt.containerservice.v2024_01_01.models.TrustedAccessRoleBinding]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class TrustedAccessRoleListResult(_serialization.Model):
    """List of trusted access roles.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Role list.
    :vartype value: list[~azure.mgmt.containerservice.v2024_01_01.models.TrustedAccessRole]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TrustedAccessRole]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class TrustedAccessRoleRule(_serialization.Model):
    """Rule for trusted access role.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar verbs: List of allowed verbs.
    :vartype verbs: list[str]
    :ivar api_groups: List of allowed apiGroups.
    :vartype api_groups: list[str]
    :ivar resources: List of allowed resources.
    :vartype resources: list[str]
    :ivar resource_names: List of allowed names.
    :vartype resource_names: list[str]
    :ivar non_resource_ur_ls: List of allowed nonResourceURLs.
    :vartype non_resource_ur_ls: list[str]
    """

    _validation = {
        "verbs": {"readonly": True},
        "api_groups": {"readonly": True},
        "resources": {"readonly": True},
        "resource_names": {"readonly": True},
        "non_resource_ur_ls": {"readonly": True},
    }

    _attribute_map = {
        "verbs": {"key": "verbs", "type": "[str]"},
        "api_groups": {"key": "apiGroups", "type": "[str]"},
        "resources": {"key": "resources", "type": "[str]"},
        "resource_names": {"key": "resourceNames", "type": "[str]"},
        "non_resource_ur_ls": {"key": "nonResourceURLs", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.verbs = None
        self.api_groups = None
        self.resources = None
        self.resource_names = None
        self.non_resource_ur_ls = None


class UpgradeOverrideSettings(_serialization.Model):
    """Settings for overrides when upgrading a cluster.

    :ivar force_upgrade: Whether to force upgrade the cluster. Note that this option instructs
     upgrade operation to bypass upgrade protections such as checking for deprecated API usage.
     Enable this option only with caution.
    :vartype force_upgrade: bool
    :ivar until: Until when the overrides are effective. Note that this only matches the start time
     of an upgrade, and the effectiveness won't change once an upgrade starts even if the ``until``
     expires as upgrade proceeds. This field is not set by default. It must be set for the overrides
     to take effect.
    :vartype until: ~datetime.datetime
    """

    _attribute_map = {
        "force_upgrade": {"key": "forceUpgrade", "type": "bool"},
        "until": {"key": "until", "type": "iso-8601"},
    }

    def __init__(
        self, *, force_upgrade: Optional[bool] = None, until: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """
        :keyword force_upgrade: Whether to force upgrade the cluster. Note that this option instructs
         upgrade operation to bypass upgrade protections such as checking for deprecated API usage.
         Enable this option only with caution.
        :paramtype force_upgrade: bool
        :keyword until: Until when the overrides are effective. Note that this only matches the start
         time of an upgrade, and the effectiveness won't change once an upgrade starts even if the
         ``until`` expires as upgrade proceeds. This field is not set by default. It must be set for the
         overrides to take effect.
        :paramtype until: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.force_upgrade = force_upgrade
        self.until = until


class WeeklySchedule(_serialization.Model):
    """For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'.

    All required parameters must be populated in order to send to server.

    :ivar interval_weeks: Specifies the number of weeks between each set of occurrences. Required.
    :vartype interval_weeks: int
    :ivar day_of_week: Specifies on which day of the week the maintenance occurs. Required. Known
     values are: "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", and "Saturday".
    :vartype day_of_week: str or ~azure.mgmt.containerservice.v2024_01_01.models.WeekDay
    """

    _validation = {
        "interval_weeks": {"required": True, "maximum": 4, "minimum": 1},
        "day_of_week": {"required": True},
    }

    _attribute_map = {
        "interval_weeks": {"key": "intervalWeeks", "type": "int"},
        "day_of_week": {"key": "dayOfWeek", "type": "str"},
    }

    def __init__(self, *, interval_weeks: int, day_of_week: Union[str, "_models.WeekDay"], **kwargs: Any) -> None:
        """
        :keyword interval_weeks: Specifies the number of weeks between each set of occurrences.
         Required.
        :paramtype interval_weeks: int
        :keyword day_of_week: Specifies on which day of the week the maintenance occurs. Required.
         Known values are: "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", and
         "Saturday".
        :paramtype day_of_week: str or ~azure.mgmt.containerservice.v2024_01_01.models.WeekDay
        """
        super().__init__(**kwargs)
        self.interval_weeks = interval_weeks
        self.day_of_week = day_of_week


class WindowsGmsaProfile(_serialization.Model):
    """Windows gMSA Profile in the managed cluster.

    :ivar enabled: Specifies whether to enable Windows gMSA in the managed cluster.
    :vartype enabled: bool
    :ivar dns_server: Specifies the DNS server for Windows gMSA. :code:`<br>`:code:`<br>` Set it to
     empty if you have configured the DNS server in the vnet which is used to create the managed
     cluster.
    :vartype dns_server: str
    :ivar root_domain_name: Specifies the root domain name for Windows gMSA.
     :code:`<br>`:code:`<br>` Set it to empty if you have configured the DNS server in the vnet
     which is used to create the managed cluster.
    :vartype root_domain_name: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "dns_server": {"key": "dnsServer", "type": "str"},
        "root_domain_name": {"key": "rootDomainName", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        dns_server: Optional[str] = None,
        root_domain_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Specifies whether to enable Windows gMSA in the managed cluster.
        :paramtype enabled: bool
        :keyword dns_server: Specifies the DNS server for Windows gMSA. :code:`<br>`:code:`<br>` Set it
         to empty if you have configured the DNS server in the vnet which is used to create the managed
         cluster.
        :paramtype dns_server: str
        :keyword root_domain_name: Specifies the root domain name for Windows gMSA.
         :code:`<br>`:code:`<br>` Set it to empty if you have configured the DNS server in the vnet
         which is used to create the managed cluster.
        :paramtype root_domain_name: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.dns_server = dns_server
        self.root_domain_name = root_domain_name
